# คำถามท้ายบท

<CourseFloatingBanner
    chapter={6}
    classNames="absolute z-10 right-0 top-0"
/>

มาทดสอบความรู้ที่คุณได้เรียนในบทนี้กันเถอะ!

### 1. สถานการณ์ไหนที่คุณควรจะเทรน tokenizer ขึ้นมาใหม่?

<Question
	choices={[
		{
			text: "เมื่อชุดข้อมูลเป้าหมาย คล้ายกับชุดข้อมูลที่โมเดลที่มีอยู่แล้วใช้ในการเทรน และคุณต้องการจะเทรนโมเดลขึ้นมาใหม่",
			explain: "ในกรณีนี้ คุณควรจะใช้ tokenizer ตัวเดิมเป็น pretrained model แล้ว fine-tune มันจะดีกว่า เพื่อจะได้ประหยัดเวลาและทรัพยากร"
		},
		{
			text: "เมื่อชุดข้อมูลเป้าหมาย คล้ายกับชุดข้อมูลที่ pretrained model ใช้ในการเทรน และคุณต้องการจะ fine-tune โมเดลตัวนี้",
			explain: "ถ้าคุณต้องการ fine-tune โมเดลจาก pretrained model คุณควรจะใช้ tokenizer ตัวเดียวกันเสมอ"
		},
		{
			text: "เมื่อชุดข้อมูลเป้าหมาย แตกต่างจากชุดข้อมูลที่ pretrained model ใช้ และคุณต้องการจะเทรนโมเดลใหม่ขึ้นมา",
			explain: "ถูกต้อง! ในกรณีนี้ ไม่มีประโยชน์ที่จะใช้ tokenizer ตัวเดิม",
            correct: true
		},
        {
			text: "เมื่อชุดข้อมูลเป้าหมายแตกต่างจากชุดข้อมูลที่ใช้โดย pretrained model แต่คุณต้องการ fine-tune โมเดลตัวนี้เพื่อให้ได้โมเดลใหม่",
			explain: "ในการ fine-tune จาก pretrained model คุณควรใช้ tokenizer ตัวเดียวกันเสมอ"
		}
	]}
/>

### 2. เวลาใช้ `train_new_from_iterator()` อะไรคือข้อดีของการใช้ generator of lists of texts เทียบกับการใช้ list of lists of texts?

<Question
	choices={[
		{
			text: "มันเป็นข้อมูลประเภทเดียวที่ <code>train_new_from_iterator()</code> สามารถใช้ได้",
			explain: "list of lists of texts เป็น generator ประเภทหนึ่ง ดังนั้น method นี้สามารถใช้มันได้เช่นกัน ลองดูใหม่นะ!"
		},
		{
			text: "เพื่อป้องกันไม่ให้คุณต้องโหลดชุดข้อมูลทั้งหมด ลงไปใน memory ภายในครั้งเดียว",
			explain: "ถูกต้อง! แต่ละ batch ของข้อความ จะถูกปล่อยออกจาก memory เวลาที่คุณ iterate มัน คุณจะเห็นประโยชน์ของการทำแบบนี้ได้ชัดเจนยิ่งขึ้น เวลาที่คุณใช้ 🤗 Datasets เพื่อเก็บข้อความ",
			correct: true
		},
		{
			text: "ทำให้ 🤗 Tokenizers library สามารถใช้ multiprocessing ได้",
			explain: "ไม่ถูก เพราะมันจะใช้ multiprocessing ในทั้งสองกรณี"
		},
        {
			text: "tokenizer จะสามารถผลิตข้อความได้ดีขึ้น",
			explain: "tokenizer ไม่สามารถผลิตข้อความได้ -- คุณอาจจะกำลังสับสนมันกับ language model หรือเปล่า"
		}
	]}
/>

### 3. อะไรคือข้อดีของ "fast" tokenizer?

<Question
	choices={[
		{
			text: "มันสามารถประมวลผลข้อความ input ได้เร็วกว่า slow tokenizer เวลาที่คุณใช้ input batch ขนาดใหญ่",
			explain: "ถูกต้อง! มันทำแบบนั้นได้ก็เพราะ การทำงานแบบ parallelism จาก Rust จะทำให้มันประมวลผล input ในรูปแบบ batch ได้เร็วขึ้น นอกจากนี้แล้ว คุณรู้ไหมว่ามันยังมีประโยชน์อะไรอีก",
			correct: true
		},
		{
			text: "Fast tokenizer สามารถประมวลได้เร็วกว่า slow tokenizer เสมอ",
			explain: "ไม่ถูก เพราะว่า fast tokenizer จะช้ากว่าถ้าหาก input น้อยมาก เพราะมันจะไม่สามารถใช้ parallelism ได้"
		},
		{
			text: "มันสามารถทำ padding และ truncation (ตัดบางส่วนของข้อความออก ถ้ายาวไป) ได้",
			explain: "slow tokenizers สามารถทำได้เช่นกัน"
		},
        {
			text: "มันมี feature พิเศษที่ช่วยให้คุณสามารถ map แต่ละ token ไปหา span ของข้อความหลักได้",
			explain: " ถูกต้อง Feature นี้เรียกว่า offset mappings แต่ยังมีอีกข้อที่ถูกเช่นกัน",
			correct: true
		}
	]}
/>

### 4. `token-classification` pipeline มีวิธีจัดการกับ entity ที่ประกอบไปด้วยหลายๆ token ได้อย่างไร?

<Question
	choices={[
		{
			text: "Entity ที่มี label เดียวกันจะถูกรวมเป็น entity เดียว",
			explain: "คำอธิบายนี้ง่ายเกินไป ลองใหม่นะ!"
		},
		{
			text: "มันจะใช้ label ประเภทหนึ่งสำหรับ token ที่อยู่จุดเริ่มต้นของ entity และ label อีกประเภทสำหรับ token ส่วนที่เหลือ",
			explain: "ถูกต้อง!",
			correct: true
		},
		{
			text: "ในคำๆหนึ่ง ถ้า token แรกมี label ของ entity คำทั้งคำจะถูก label ให้เป็น entity นั้นด้วย",
			explain: "ถูกต้อง นี่เป็นวิธีหนึ่งในการจัดการกับ entity ลองดูว่ามีคำตอบอื่นที่ถูกต้องอีกมั้ย",
			correct: true
		},
        {
			text: "ถ้า token หนึ่งถูก label ว่าเป็น entity token อื่นๆที่ตามมาที่มี label เดียวกัน จะถูกจัดว่าเป็น entity เดียวกัน ยกเว้นว่า มันจะเป็น label ที่บอกว่าเริ่ม entity ใหม่",
			explain: "ถูกต้อง นี่เป็นวิธีมาตรฐานที่เอาไว้ใช้รวม token ของ entity เข้าด้วยกัน -- ยังมีอีกคำตอบที่ถูกต้องเช่นกัน ลองหาดู",
			correct: true
		}
	]}
/>

### 5. `question-answering` pipeline มีวิธีจัดการกับข้อความส่วนบริบท(context)ที่มีขนาดยาวอย่างไร?

<Question
	choices={[
		{
			text: "มันไม่ได้จัดการอะไร มันแค่ตัด context ให้มีความยาวเท่ากับความยาวสูงสุดที่เป็นไปได้เท่านั้น",
			explain: "เราได้เรียนทริกที่เอาไว้ใช้แก้ปัญหา context ยาวกันแล้ว จำได้มั้ย"
		},
		{
			text: "มันจะแบ่ง context ออกเป็นหลายๆส่วน แล้วคำนวณค่าเฉลี่ยของผลลัพธ์จากแต่ละส่วนเป็นคำตอบ",
			explain: "ไม่ถูก มันไม่สมเหตุสมผลที่จะใช้ค่าเฉลี่ย เพราะว่าบางส่วนของ context อาจจะไม่มีคำตอบอยู่เลยก็ได้"
		},
		{
			text: "มันจะแยก context ออกเป็นหลายๆส่วน โดยให้แต่ละส่วนทับซ้อนกันด้วย (overlap) แล้วมันจะคำนวณ score ให้แต่ละส่วน แล้วเลือกส่วนที่มี score สูงที่สุดเป็นคำตอบ",
			explain: "ถูกต้อง!",
			correct: true
		},
        {
			text: "มันจะแบ่ง context ออกเป็นหลายๆส่วน โดยไม่มีส่วนทับซ้อน เพื่อรักษาประสิทธิภาพ แล้วเลือกส่วนที่มี score สูงที่สุดเป็นคำตอบ",
			explain: "ไม่ถูก เราควรแบ่ง context ให้มีส่วนที่ทับซ้อนด้วย เพื่อป้องกันไม่ให้เกิดกรณีที่ span ของคำตอบ ถูกตัดออกไปอยู่หลายๆส่วน"
		}
	]}
/>

### 6. อะไรคือ normalization?

<Question
	choices={[
		{
			text: "ขั้นตอนที่เกี่ยวข้องกับการทำความสะอาดข้อมูล ที่ tokenizer ทำในขั้นเริ่มต้น",
			explain: "ถูกต้อง ตัวอย่างเช่น ลบ accents หรือ whitespace หรือแปลงข้อความเป็นตัวอักษรเล็ก",
			correct: true
		},
		{
			text: "เทคนิคในการสร้างข้อมูลใหม่จากข้อมูลที่มีอยู่เพื่อขยายชุดข้อมูล (data augmentation) เกี่ยวข้องกับการทำข้อความให้เป็นปกติมากขึ้น โดยลบคำที่พบได้ยากออก",
			explain: "ไม่ถูก! ลองดูใหม่นะ"
		},
		{
			text: "ลำดับสุดท้ายหลังการประมวลผลหลัก ซึ่ง tokenizer จะเพิ่ม token พิเศษเข้าไปใน vocabulary",
			explain: "ไม่ถูก ขั้นตอนนี้คือ post-processing"
		},
        {
			text: "ขั้นตอนการสร้าง embeddings ให้มีค่า mean เท่ากับ 0 และค่า standard deviation เท่ากับ 1 ซึ่งคำนวณได้โดยการลบค่า mean ออกจากค่าหลัก และ หารโดย standard deviation",
			explain: "นี่เป็นขั้นตอน normalization สำหรับงานด้าน computer vision ที่เอาไว้ใช้ปรับค่าของ pixel ให้เป็นมาตรฐาน แต่วิธีนี้ใช้ไม่ได้ใน NLP"
		}
	]}
/>

### 7. อะไรคือขั้นตอนการ pre-tokenization ของ subword tokenizer?

<Question
	choices={[
		{
			text: "ขั้นตอนก่อนการ tokenize ที่มีการทำ data augmentation เช่น random masking",
			explain: "ไม่ถูก ขั้นตอนนี้เป็นส่วนหนึ่งในการประมวลผลหลัก"
		},
		{
			text: "ขั้นตอนก่อนการ tokenize ที่ข้อความจะถูกทำความสะอาด (cleanup)",
			explain: "ไม่ถูก ขั้นตอนนี้เรียกว่า normalization"
		},
		{
			text: "ขั้นตอนก่อนการ tokenize ที่ข้อความจะถูกแยกออกเป็นคำๆ",
			explain: "ถูกต้อง!",
			correct: true
		},
        {
			text: "ขั้นตอนก่อนการ tokenize ที่ข้อความจะถูกแยกออกเป็น token",
			explain: "ไม่ถูก นี่คือขั้นตอนหลักของ tokenizer"
		}
	]}
/>

### 8. เลือกข้อความที่ถูกต้อง เกี่ยวกับ BPE model?

<Question
	choices={[
		{
			text: "BPE คืออัลกอริทึมแบบ subword ที่เริ่มการเทรนด้วย vocabulary ขนาดเล็ก และมันจะเรียนกฎเพื่อรวม token (merge rules)",
			explain: "ถูกต้อง!",
			correct: true
		},
		{
			text: "BPE คืออัลกอริทึมแบบ subword ที่เริ่มการเทรนด้วย vocabulary ขนาดใหญ่ และมันจะพยายามจะลบ token ออกจาก vocabulary เรื่อยๆ",
			explain: "ไม่ถูก นี่คือคำอธิบายของอัลกอริทึมอีกประเภทต่างหาก"
		},
		{
			text: "BPE มีเป้าหมายคือการเรียนกฎเพื่อรวม token เข้าด้วยกัน (merge rules) โดยมันจะรวมคู่ของ token ที่พบบ่อยที่สุดเข้าด้วยกัน",
			explain: "ถูกต้อง!",
			correct: true
		},
		{
			text: "BPE มีเป้าหมายคือการเรียนกฎเพื่อรวม token เข้าด้วยกัน (merge rules) มันจะรวมคู่ของ token ที่มี score สูงที่สุดเข้าด้วยกัน ถ้าหากคู่ token นี้มีจำนวนมากและแต่ละ token ในคู่มีจำนวนน้อย คู่นี้จะมี score สูง",
			explain: "ไม่ถูก นี่คือคำอธิบายของอัลกอริทึมอีกประเภทต่างหาก"
		},
		{
			text: "BPE ตัดคำออกเป็นคำย่อย (subwords) โดยแบ่งแต่ละคำออกเป็นตัวอักษร แล้วใช้ merge rules เพื่อรวมคำย่อยพวกนี้เข้าด้วยกัน",
			explain: "ถูกต้อง!",
			correct: true
		},
		{
			text: "BPE ตัดคำออกเป็นคำย่อย (subwords) โดยจะแบ่งคำเมื่อเจอคำย่อยที่ยาวที่สุดที่อยู่ใน vocabulary เริ่มจากต้นคำ จากนั้น มันจะทำแบบเดียวกันนี้กับส่วนที่เหลือของข้อความไปเรื่อยๆ",
			explain: "ไม่ถูก นี่คือคำอธิบายของอัลกอริทึมอีกประเภทต่างหาก"
		},
	]}
/>

### 9. เลือกข้อความที่ถูกต้อง เกี่ยวกับ WordPiece model?

<Question
	choices={[
		{
			text: "WordPiece คืออัลกอริทึมแบบ subword ที่เริ่มการเทรนด้วย vocabulary ขนาดเล็ก และเรียนกฎสำหรับการรวม token (merge rules)",
			explain: "ถูกต้อง!",
			correct: true
		},
		{
			text: "WordPiece คืออัลกอริทึมแบบ subword ที่เริ่มการเทรนด้วย vocabulary ขนาดใหญ่ และมันจะพยายามจะลบ token ออกจาก vocabulary เรื่อยๆ",
			explain: "ไม่ถูก นี่คือคำอธิบายของอัลกอริทึมอีกประเภทต่างหาก"
		},
		{
			text: "WordPiece มีเป้าหมายคือการเรียนกฎเพื่อรวม token เข้าด้วยกัน (merge rules) โดยมันจะรวมคู่ของ token ที่พบบ่อยที่สุดเข้าด้วยกัน",
			explain: "ไม่ถูก นี่คือคำอธิบายของอัลกอริทึมอีกประเภทต่างหาก"
		},
		{
			text: "WordPiece มีเป้าหมายคือการเรียนกฎเพื่อรวม token เข้าด้วยกัน (merge rules) มันจะรวมคู่ของ token ที่มี score สูงที่สุดเข้าด้วยกัน ถ้าหากคู่ token นี้มีจำนวนมากและแต่ละ token ในคู่มีจำนวนน้อย คู่นี้จะมี score สูง",
			explain: "ถูกต้อง!",
			correct: true
		},
		{
			text: "WordPiece ตัดคำให้เป็นคำย่อย (subwords) โดยเลือก segmentation ที่มีความเป็นไปได้มากที่สุดเป็นคำตอบ",
			explain: "ไม่ถูก นี่คือคำอธิบายของอัลกอริทึมอีกประเภทต่างหาก"
		},
		{
			text: "WordPiece ตัดคำออกเป็นคำย่อย (subwords) โดยจะแบ่งคำเมื่อเจอคำย่อยที่ยาวที่สุดที่อยู่ใน vocabulary เริ่มจากต้นคำ จากนั้น มันจะทำแบบเดียวกันนี้กับส่วนที่เหลือของข้อความไปเรื่อยๆ",
			explain: "ถูกต้อง นี่คือวิธีที่ WordPiece ทำการ encoding",
			correct: true
		},
	]}
/>

### 10. เลือกข้อความที่ถูกต้อง เกี่ยวกับ Unigram model?

<Question
	choices={[
		{
			text: "Unigram คืออัลกอริทึมแบบ subword ที่เริ่มการเทรนด้วย vocabulary ขนาดเล็ก และเรียนกฎสำหรับการรวม token (merge rules)",
			explain: "ไม่ถูก นี่คือคำอธิบายของอัลกอริทึมอีกประเภทต่างหาก"
		},
		{
			text: "Unigram คืออัลกอริทึมแบบ subword ที่เริ่มการเทรนด้วย vocabulary ขนาดใหญ่ และมันจะพยายามจะลบ token ออกจาก vocabulary เรื่อยๆ",
			explain: "ถูกต้อง!",
			correct: true
		},
		{
			text: "Unigram จะปรับ vocabulary โดยพยายามลดให้ค่า loss ของ corpus",
			explain: "ถูกต้อง!",
			correct: true
		},
		{
			text: "Unigram จะปรับ vocabulary โดยเลือกเก็บ token ที่มีความถี่สูงไว้",
			explain: "ไม่ถูก"
		},
		{
			text: "Unigram WordPiece ตัดคำให้เป็นคำย่อย (subwords) โดยเลือก segmentation ที่มีความเป็นไปได้มากที่สุดเป็นคำตอบ",
			explain: "ถูกต้อง!",
			correct: true
		},
		{
			text: "Unigram ตัดคำออกเป็นคำย่อย (subwords) โดยแบ่งแต่ละคำออกเป็นตัวอักษร แล้วใช้ merge rules เพื่อรวมคำย่อยพวกนี้เข้าด้วยกัน",
			explain: "ไม่ถูก นี่คือคำอธิบายของอัลกอริทึมอีกประเภทต่างหาก"
		},
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/th/chapter6/10.mdx" />