# Giriş

Hugging Face kursuna hoş geldiniz! Bu bölümde kursta kullanacağımız çalışma ortamını kuracağız. Eğer kursa yeni başlıyorsanız, öncelikle [1. bölüme](/course/chapter1) bakmanızı, sonra da geri gelip ortamınızı kurmanızı öneririz. Böylelikle kodları kendi başınıza deneyimleyebilirsiniz.

Bu kursta kullanacağımız bütün kütüphaneler Python package'ı olarak indirilebilir, bu yüzden burada Python ortamının kurulumunu ve lazım olacak kütüphaneleri indirmeyi göstereceğiz.

İki farklı yol göstereceğiz Colab defterleri ve Python sanal ortamı. Size en uygun olanı seçebilirsiniz. Yeni başlayanların Colab defteri kullanmasını tavsiye ederiz.

Kursta Windows sistemi kullanmıyoruz bu yüzden eğer Windows kullanıyorsanız Colab kullanmanız daha iyi olacaktır. Eğer herhangi bir Linux dağıtımı ya da macOS kullanıyorsanız iki yöntemi de tercih edebilirsiniz. 

Kurs genel olarak Hugging Face üzerinden gidiyor. Eğer hesabınız yoksa [buradan hesap açabilirsiniz](https://huggingface.co/join). 

## Google Colab defteri kullanmak

Colab defteri kullanmak açık ara en kolay kurulum. Tarayıcınızda bir defter açın ve hemen kodlamaya başlayın! 

Eğer Colab kullanmayı bilmiyorsanız bu [İngilizce tutorialı](https://colab.research.google.com/notebooks/intro.ipynb) takip edebilirsiniz. Colab TPU ya da GPU gibi bazı hızlandırıcı donanımları kullanmanıza izin verir. Üstelik küçük işlemler için bunlar ücretsiz!

Colab kullanımında kendinizi rahat hissettikten sonra yeni bir defter oluşturun ve kuruluma başlayın:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png" alt="An empty colab notebook" width="80%"/>
</div>

Sonraki adım kurs boyunca kullanacağımız kütüphaneleri indirmek. Kurulum için `pip` kullanacağız, kendisi Pythonın package yöneticisi. Defterlerde satırın başına `!` koyarak sistem komutlarını çalıştırabilirsiniz. yani 🤗 Transformers kütüphanesini şöyle indiriyoruz:

```
!pip install transformers
```

İmport ederek package'ın doğru kurulduğundan emin olabilirsiniz:

```
import transformers
```

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif" alt="A gif showing the result of the two commands above: installation and import" width="80%"/>
</div>

Bu 🤗 Transformers'ın oldukça hafif bir versiyonunu yüklüyor. Yani hiç bir machine learning kütüphanesini barındırmıyor. (PyTorch ya da TensorFlow gibi) Kütüphanenin farklı farklı özelliklerini kullanacağımız için "development version"ı indirmenizi tavsiye ederiz çünkü akla gelebilecek bütün kullanımlar için gerekli bağımlılıkları (dependencies) barındırıyor:

```
!pip install transformers[sentencepiece]
```

Bu biraz zaman alabilir ama sonrasında kursun tamamı için hazır olacaksınız! Başarılar!

## Python Sanal Ortamı Kullanmak

Eğer Python sanal ortamı kullanmayı seçerseniz ilk adım olarak bilgisayarınıza Python kurmalısınız. [Bu rehberi](https://realpython.com/installing-python/) kullanmanızı öneririz.

Python'ı kurduktan sonra terminal üzerinden Python komutlarını çalıştırabiliyor olmanız gerekiyor. `python --version` komutunu çalıştırarak kurulumun doğru tamamlandığından emin olabilirsiniz. Bu komut sisteminizde kurulu olan Python sürümünü ekrana yazdıracak.

`python --version` gibi bir python komutunu terminalde çalıştırdığınızda bu komutu çalıştıran program bilgisayarınızdaki "ana" (main) python sürümüdür. Bu sürüme hiç bir python package'ı yüklemenizi önermiyoruz. Bunu her projeniz için ayrı bir ortam açmak için kullanabilirsiniz bu şekilde başka uygulamalar ile olabilecek uyumluluk hataları hakkında endielenmenize gerek kalmaz.

Python'da bu  [*virtual environments (sanal ortamlar)*](https://docs.python.org/3/tutorial/venv.html) kullanılarak yapılıyor, bunları ayrı ayrı kurulmuş Python sürümleri olarak düşünebilirsiniz. Bunun için yapılmış farklı toollar var fakat biz resmi package'ı kullanacağız, ismi de [`venv`](https://docs.python.org/3/library/venv.html#module-venv).

İlk olarak, uygulamanızın bulunmasını istediğiniz klasörü açın — mesela *transformers-course* diye bir klasör açmak isteyebilirsiniz:

```
mkdir ~/transformers-course
cd ~/transformers-course
```

Bu klasörün içinde Python `venv` modülünü kullanarak bir sanal ortam açalım:

```
python -m venv .env
```

Normalde boş olan klasörünüzün içinde *.env* adında yeni bir klasör açılmış olması lazım:

```
ls -a
```

```out
.      ..    .env
```

`activate` ve `deactivate` scriptlerini kullanarak sanal ortama gir çık yapabilirsiniz:

```
# Activate the virtual environment
source .env/bin/activate

# Deactivate the virtual environment
deactivate
```

`which python` komutunu kullanarak hangi Python kurulumunda olduğunuzu öğrenebilirsiniz: Eğer sanal ortamı gösteriyorsa sizi tebrik ederim başarıyla sanal ortam kurmuşsunuz demektir!

```
which python
```

```out
/home/<user>/transformers-course/.env/bin/python
```

### Bağımlılıkları indirmek

Google Colab bölümünde olduğu gibi şimdi gerekli packageları indirmeniz gerekiyor. Yine aynı şekilde `pip` kullanarak 🤗 Transformers'ın development versiyonunu indirebilirsiniz:

```
pip install "transformers[sentencepiece]"
```

Her şey hazır başlayabilirsiniz! Başarılar!


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/tr/chapter0/1.mdx" />