# Đố vui cuối chương

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

Chương này bao gồm rất nhiều mặt! Đừng lo lắng nếu bạn không nắm được tất cả các chi tiết; các chương tiếp theo sẽ giúp bạn hiểu mọi thứ hoạt động như thế nào.

Tuy nhiên, trước tiên, hãy kiểm tra những gì bạn đã học được trong chương này!

### 1. Khám phá Hub và tìm `roberta-large-mnli`. Nó phục vụ cho tác vụ gì?

<Question
  choices={[
    {
      text: "Tóm tắt",
      explain:
        'Xem lại tại <a href="https://huggingface.co/roberta-large-mnli">roberta-large-mnli page</a>.',
    },
    {
      text: "Phân loại văn bản",
      explain:
        "Chính xác hơn, nó phân loại nếu hai câu được liên kết một cách hợp lý qua ba nhãn (mâu thuẫn, trung lập, vướng mắc) — hay tác vụ còn được gọi là <em>luận suy ngôn ngữ tự nhiên</em>.",
      correct: true,
    },
    {
      text: "Tạo văn bản",
      explain:
        'Xem lại tại <a href="https://huggingface.co/roberta-large-mnli">roberta-large-mnli page</a>.',
    },
  ]}
/>

### 2. Đoạn mã sau sẽ trả về cái gì?

```py
from transformers import pipeline

ner = pipeline("ner", grouped_entities=True)
ner("My name is Sylvain and I work at Hugging Face in Brooklyn.")
```

<Question
  choices={[
    {
      text: 'Nó sẽ trả về điểm phân loại cho câu này, với các nhãn "positive" hoặc "negative".',
      explain:
        "Không chính xác - đây là mô tả của pipeline <code>sentiment-analysis</code>.",
    },
    {
      text: "Nó sẽ trả về một văn bản được tạo để hoàn thành câu này.",
      explain:
        "Không chính xác - đây là mô tả của pipeline<code>text-generation</code>.",
    },
    {
      text: "Nó sẽ trả về các từ đại diện cho người, tổ chức hoặc địa điểm.",
      explain:
        'Hơn nữa, với <code>grouped_entities=True</code>, nó sẽ nhóm các từ thuộc cùng một thực thể lại với nhau, ví dụ như "Hugging Face".',
      correct: true,
    },
  ]}
/>

### 3. Từ nào có thể thay thế ... trong đoạn mã dưới đây?

```py
from transformers import pipeline

filler = pipeline("fill-mask", model="bert-base-cased")
result = filler("...")
```

<Question
  choices={[
    {
      text: "This &#60;mask> has been waiting for you.",
      explain:
        "Không chính xác. Kiểm tra thẻ mô hình <code>bert-base-cased</code> và cố gắng phát hiện lỗi của bạn.",
    },
    {
      text: "This [MASK] has been waiting for you.",
      explain: "Chính xác! Đáp án là [MASK].",
      correct: true,
    },
    {
      text: "This man has been waiting for you.",
      explain:
        "Không chính xác. Pipeline này sẽ điền vào các từ bị che đi, vì vậy nó cần một [MASK] token ở đâu đó.",
    },
  ]}
/>

### 4. Tại sao đoạn mã này sẽ lỗi?

```py
from transformers import pipeline

classifier = pipeline("zero-shot-classification")
result = classifier("This is a course about the Transformers library")
```

<Question
  choices={[
    {
      text: "Pipeline này này yêu cầu cấp nhãn để phân loại văn bản này.",
      explain:
        "Đúng — đoạn mã chính xác cần bao gồm <code>candidate_labels=[...]</code>.",
      correct: true,
    },
    {
      text: "Pipeline này yêu cầu nhiều câu thay vì một câu.",
      explain:
        "Không chính xác, mặc dù khi được sử dụng đúng cách, pipeline này có thể lấy một danh sách các câu để xử lý (giống như tất cả các pipeline khác).",
    },
    {
      text: "Thư viện 🤗 Transformers bị hỏng, như thường lệ.",
      explain:
        "Chúng tôi sẽ không đánh giá cao câu trả lời này với bất kỳ bình luận nào!",
    },
    {
      text: "Pipeline yêu cầu đầu vào dài hơn; pipeline này quá ngắn.",
      explain:
        "Không chính xác. Lưu ý rằng một văn bản rất dài sẽ bị cắt bớt khi xử lý bằng pipeline này.",
    },
  ]}
/>

### 5. "Học chuyển giao" nghĩa là gì?

<Question
	choices={[
		{
			text: "Chuyển giao tri thức của một mô hình được huấn luyện trước sang một mô hình mới bằng cách huấn luyện nó trên cùng một bộ dữ liệu.",
			explain: "Không, đó sẽ là hai phiên bản của cùng một mô hình."
		},
		{
			text: "Chuyển giao tri thức của một mô hình được huấn luyện trước sang một mô hình mới bằng cách khởi tạo mô hình thứ hai với trọng số của mô hình đầu tiên.",
			explain: "Chính xác: khi mô hình thứ hai được huấn luyện về một tác vụ mới, nó sẽ *chuyển giao* tri thức thức của mô hình đầu tiên.",
			correct: true
		},
		{
			text: "Chuyển giao tri thức của một mô hình được huấn luyện trước sang một mô hình mới bằng cách xây dựng mô hình thứ hai có cùng kiến trúc với mô hình đầu tiên.",
			explain: "Kiến trúc chỉ là cách mô hình được xây dựng; không có kiến thức được chia sẻ hoặc chuyển giao trong trường hợp này."
		}
	]}
/>

### 6. Đúng hay sai? Một mô hình ngôn ngữ thường không cần nhãn cho quá trình huấn luyện trước của nó.

<Question
  choices={[
    {
      text: "Đúng",
      explain:
        "Quá trình huấn luyện trước thường là <em>tự giám sát</em>, có nghĩa là các nhãn được tạo ra tự động từ các đầu vào (như dự đoán từ tiếp theo hoặc điền vào một số từ bị che).",
      correct: true,
    },
    {
      text: "Sai",
      explain: "Đây không phải đáp án chính xác.",
    },
  ]}
/>

### 7. Chọn câu mô tả đúng nhất các thuật ngữ "mô hình", "kiến trúc" và "trọng số".

<Question
  choices={[
    {
      text: "Nếu một mô hình là một tòa nhà, thì kiến trúc của nó là bản thiết kế và trọng số là những người sống bên trong.",
      explain:
        "Theo phép ẩn dụ này, trọng lượng sẽ là những viên gạch và các vật liệu khác được sử dụng để xây dựng tòa nhà.",
    },
    {
      text: "Một kiến trúc là một bản đồ để xây dựng một mô hình và trọng số của nó là các thành phố được thể hiện trên bản đồ.",
      explain:
        "Vấn đề với phép ẩn dụ này là bản đồ thường đại diện cho một thực tế đang tồn tại (chỉ có một thành phố ở Pháp tên là Paris). Đối với một kiến trúc nhất định, có thể có nhiều trọng số.",
    },
    {
      text: "Một kiến trúc là sự liên tiếp của các hàm toán học để xây dựng một mô hình và trọng số của nó là các tham số hàm đó.",
      explain:
        "Cùng một tập hợp các hàm toán học (kiến trúc) có thể được sử dụng để xây dựng các mô hình khác nhau bằng cách sử dụng các tham số (trọng số) khác nhau.",
      correct: true,
    },
  ]}
/>

### 8. Bạn sẽ sử dụng loại mô hình nào trong số những loại mô hình này để hoàn thành lời nhắc với văn bản được tạo ra?

<Question
  choices={[
    {
      text: "Một mô hình mã hoá",
      explain:
        "Một mô hình mã hóa tạo ra một biểu diễn của toàn bộ câu, phù hợp hơn cho các tác vụ như phân loại.",
    },
    {
      text: "Một mô hình giải hoá",
      explain:
        "Các mô hình giải mã hoàn toàn phù hợp để tạo văn bản từ lời nhắc.",
      correct: true,
    },
    {
      text: "Một mô hình chuỗi-sang-chuỗi",
      explain:
        "Mô hình chuỗi-sang-chuỗi phù hợp cho các tác vụ mà bạn muốn tạo các câu liên quan đến các câu đầu vào, chứ không phải một lời nhắc nhất định.",
    },
  ]}
/>

### 9. Bạn sẽ sử dụng kiểu mô hình nào để tóm tắt văn bản?

<Question
  choices={[
    {
      text: "Một mô hình mã hoá",
      explain:
        "Một mô hình mã hóa tạo ra một biểu diễn của toàn bộ câu, phù hợp hơn cho các tác vụ như phân loại.",
    },
    {
      text: "Một mô hình giải hoá",
      explain:
        "Các mô hình giải mã rất tốt để tạo văn bản đầu ra (như tóm tắt), nhưng chúng không có khả năng khai thác ngữ cảnh như toàn bộ văn bản để tóm tắt.",
    },
    {
      text: "Một mô hình chuỗi-sang-chuỗi",
      explain:
        "Mô hình chuỗi-sang-chuỗi hoàn toàn phù hợp với tác vụ tóm tắt văn bản.",
      correct: true,
    },
  ]}
/>

### 10. Bạn sẽ sử dụng kiểu mô hình nào trong số những kiểu mô hình này để phân loại đầu vào văn bản theo các nhãn nhất định?

<Question
  choices={[
    {
      text: "Một mô hình mã hoá",
      explain:
        "Một mô hình mã hóa tạo ra biểu diễn của toàn bộ câu, phù hợp hơn cho các tác vụ như phân loại.",
      correct: true,
    },
    {
      text: "Một mô hình giải hoá",
      explain:
        "Các mô hình giải mã phù hợp để tạo văn bản đầu ra, không phải trích xuất nhãn ra khỏi một câu.",
    },
    {
      text: "Một mô hình chuỗi-sang-chuỗi",
      explain:
        "Mô hình chuỗi-sang-chuỗi phù hợp hơn cho các tác vụ mà bạn muốn tạo văn bản dựa trên một câu đầu vào, không phải nhãn.",
    },
  ]}
/>

### 11. Sự sai lệch quan sát thấy trong một mô hình có thể bắt nguồn nào?

<Question
  choices={[
    {
      text: "Mô hình là phiên bản tinh chỉnh của một mô hình được huấn luyện trước và nó đã chọn ra sai lệch từ đó.",
      explain:
        "Khi áp dụng Học chuyển giao, sự sai lệch trong mô hình huấn luyện tới mô hình tinh chỉnh.",
      correct: true,
    },
    {
      text: "Dữ liệu mà mô hình sử dụng huấn luyện bị sai lệch.",
      explain:
        "Đây là một trường hợp tiêu biểu của sai lệch, nhưng không phải là nguyên do duy nhất.",
      correct: true,
    },
    {
      text: "Các thông số mô hình tối ưu bị sai lệch.",
      explain:
        "Một nguồn sai lệch ít rõ ràng hơn là cách mô hình được huấn luyện. Mô hình của bạn sẽ tối ưu hóa một cách mù quáng cho bất kỳ chỉ số nào bạn đã chọn, mà không cần suy nghĩ gì thêm.",
      correct: true,
    },
  ]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/vi/chapter1/10.mdx" />