# Giới thiệu

<CourseFloatingBanner
    chapter={2}
    classNames="absolute z-10 right-0 top-0"
/>

Như bạn đã thấy trong [Chương 1](/course/chapter1), các mô hình Transformer thường rất lớn. Với hàng triệu đến hàng chục *tỷ* thông số, việc huấn luyện và triển khai các mô hình này là một công việc phức tạp. Hơn nữa, với việc các mô hình mới được phát hành gần như hàng ngày và mỗi mô hình có cách triển khai riêng, việc thử tất cả chúng không phải là nhiệm vụ dễ dàng.

Thư viện 🤗 Transformers được tạo ra để giải quyết vấn đề này. Mục tiêu của nó là cung cấp một API duy nhất mà qua đó bất kỳ mô hình Transformer nào cũng có thể được tải, huấn luyện, và lưu. Các tính năng chính của thư viện gồm:

- **Tính dễ sử dụng**: Việc tải xuống, tải và sử dụng mô hình NLP tối tân để luận suy có thể được thực hiện chỉ trong hai dòng mã.
- **Tính linh hoạt**: Về cốt lõi, tất cả các mô hình đều là các lớp PyTorch `nn.Module` hoặc TensorFlow` tf.keras.Model` đơn giản và có thể được xử lý giống như bất kỳ mô hình nào khác trong khuôn khổ học máy (ML) tương ứng của chúng.
- **Tính đơn giản**: Hầu như không có bất kỳ sự trừu tượng nào được thực hiện trên toàn bộ thư viện. "All in one file" ("Tất cả trong một tệp") là khái niệm cốt lõi: bước lan truyền thẳng của một mô hình được xác định hoàn toàn trong một tệp duy nhất giúp bản thân đoạn mã dễ hiểu và có thể hack được.

Tính năng cuối cùng này làm cho 🤗 Transformers khá khác biệt so với các thư viện ML khác. Các mô hình không được xây dựng trên các mô-đun được chia sẻ trên các tệp; thay vào đó, mỗi mô hình có các lớp riêng của nó. Ngoài việc làm cho các mô hình dễ tiếp cận và dễ hiểu hơn, điều này cho phép bạn dễ dàng thử nghiệm trên một mô hình mà không ảnh hưởng đến các mô hình khác.

Chương này sẽ bắt đầu với một ví dụ từ đầu đến cuối, trong đó chúng ta sử dụng một mô hình và một tokenizer cùng nhau để sao chép hàm `pipeline()` được giới thiệu trong [Chapter 1](/course/chapter1). Tiếp theo, chúng ta sẽ thảo luận về API mô hình: chúng ta sẽ đi sâu vào các lớp cấu hình và mô hình, đồng thời chỉ cho bạn cách tải một mô hình và cách nó xử lý các đầu vào dạng số để đưa ra các dự đoán đầu ra.

Sau đó, chúng ta sẽ xem xét API tokenizer, một thành phần chính khác của hàm `pipeline()`. Tokenizers thực hiện các bước xử lý đầu tiên và cuối cùng, xử lý việc chuyển đổi từ văn bản đầu vào thành dạng số cho mạng nơ-ron và chuyển đổi trở lại văn bản khi cần. Cuối cùng, chúng tôi sẽ chỉ cho bạn cách xử lý việc gửi nhiều câu vào một mô hình trong một batch (lô) đã chuẩn bị, sau đó tóm tắt tất cả bằng cách xem xét kỹ hơn hàm `tokenizer()` ở bậc cao.

<Tip>
⚠️ Để có thể tận dụng tất cả các tính năng có sẵn với Model Hub và 🤗 Transformers, chúng tôi khuyến khích bạn <a href="https://huggingface.co/join">tạo tài khoản </a>.
</Tip>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/vi/chapter2/1.mdx" />