# Đố vui cuối chương

<CourseFloatingBanner
    chapter={5}
    classNames="absolute z-10 right-0 top-0"
/>

Chương này bao gồm rất nhiều nội dung! Đừng lo lắng nếu bạn không nắm được tất cả các chi tiết; các chương tiếp theo sẽ giúp bạn hiểu mọi thứ hoạt động như thế nào.

Tuy nhiên, trước khi tiếp tục, hãy kiểm tra những gì bạn đã học được trong chương này.

### 1. Hàm `load_dataset()` trong 🤗 Datasets cho phép bạn tải tập dữ liệu từ vị trí nào sau đây?

<Question
  choices={[
    {
      text: "Cục bộ, ví dụ: trên máy tính xách tay của bạn",
      explain:
        "Chính xác! Bạn có thể truyền đường dẫn của các tệp cục bộ tới tham số <code>data_files</code> của <code>load_dataset()</code> để tải các tập dữ liệu cục bộ.",
      correct: true,
    },
    {
      text: "The Hugging Face Hub",
      explain:
        "Đúng! Bạn có thể tải tập dữ liệu trên Hub bằng cách cung cấp ID tập dữ liệu, ví dụ: <code>load_dataset('emotion')</code>.",
      correct: true,
    },
    {
      text: "Máy chủ từ xa",
      explain:
        "Đúng! Bạn có thể truyền URL đến tham số <code>data_files</code> của <code>load_dataset()</code> để tải các tệp từ xa.",
      correct: true,
    },
  ]}
/>

### 2. Giả sử bạn đã tải một trong số các tác vụ GLUE như sau:

```py
from datasets import load_dataset

dataset = load_dataset("glue", "mrpc", split="train")
```

Đâu là một trong số những câu lệnh sẽ tạo ra một tập mẫu ngẫu nhiên 50 phần tử từ `dataset`?

<Question
  choices={[
    {
      text: "<code>dataset.sample(50)</code>",
      explain:
        "Điều này không chính xác - không có phương thức <code>Dataset.sample()</code>.",
    },
    {
      text: "<code>dataset.shuffle().select(range(50))</code>",
      explain:
        "Chính xác! Như bạn đã thấy trong chương này, trước tiên bạn xáo trộn tập dữ liệu và sau đó chọn các mẫu từ nó.",
      correct: true,
    },
    {
      text: "<code>dataset.select(range(50)).shuffle()</code>",
      explain:
        "Điều này không chính xác - mặc dù đoạn mã sẽ chạy, nó sẽ chỉ xáo trộn 50 phần tử đầu tiên trong tập dữ liệu.",
    },
  ]}
/>

### 3. Giả sử bạn có một tập dữ liệu về vật nuôi trong nhà được gọi là `pets_dataset`, có cột `name` biểu thị tên của từng vật nuôi. Phương pháp tiếp cận nào sau đây sẽ cho phép bạn lọc tập dữ liệu cho tất cả vật nuôi có tên bắt đầu bằng chữ cái "L"?

<Question
  choices={[
    {
      text: "<code>pets_dataset.filter(lambda x : x['name'].startswith('L'))</code>",
      explain:
        "Đúng! Sử dụng hàm lambda của Python cho các bộ lọc nhanh này là một ý tưởng tuyệt vời. Bạn có thể nghĩ ra giải pháp khác không?",
      correct: true,
    },
    {
      text: "<code>pets_dataset.filter(lambda x['name'].startswith('L'))</code>",
      explain:
        "Điều này không chính xác - một hàm lambda có dạng chung <code>lambda *arguments* : *expression*</code>, vì vậy bạn cần cung cấp các tham số trong trường hợp này.",
    },
    {
      text: "Tạo ra một hàm <code>def filter_names(x): return x['name'].startswith('L')</code> và chạy <code>pets_dataset.filter(filter_names)</code>.",
      explain:
        "Chính xác! Cũng giống như với <code>Dataset.map()</code>, bạn có thể truyền các hàm tường minh<code>Dataset.filter()</code>. Điều này rất hữu ích khi bạn có một số logic phức tạp không phù hợp với một hàm lambda ngắn. Giải pháp nào khác sẽ hiệu quả?",
      correct: true,
    },
  ]}
/>

### 4. Ánh xạ bộ nhớ là gì?

<Question
  choices={[
    {
      text: "Ánh xạ giữa RAM CPU và GPU",
      explain: "Không phải vậy - hãy thử lại!",
    },
    {
      text: "Ánh xạ giữa RAM và bộ nhớ hệ thống tệp",
      explain:
        "Đúng! 🤗 Datasets coi mỗi tập dữ liệu như một tệp ánh xạ bộ nhớ. Điều này cho phép thư viện truy cập và hoạt động trên các phần tử của tập dữ liệu mà không cần tải đầy đủ vào bộ nhớ.",
      correct: true,
    },
    {
      text: "Ánh xạ giữa hai tệp trong cache 🤗 Datasets",
      explain: "Không phải vậy - hãy thử lại!",
    },
  ]}
/>

### 5. Lợi ích chính của ánh xạ bộ nhớ là gì?

<Question
  choices={[
    {
      text: "Truy cập tệp ánh xạ bộ nhớ nhanh hơn đọc hoặc ghi vào đĩa.",
      explain:
        "Đúng! Điều này cho phép 🤗 Datasets xử lý nhanh như chớp. Tuy nhiên, đó không phải là lợi ích duy nhất.",
      correct: true,
    },
    {
      text: "Các ứng dụng có thể truy cập các phân đoạn dữ liệu trong một tệp cực lớn mà không cần phải đọc toàn bộ tệp vào RAM trước.",
      explain:
        "Đúng! Điều này cho phép 🤗 Datasets tải tập dữ liệu nhiều gigabyte trên máy tính xách tay của bạn mà không làm nổ CPU của bạn. Ánh xạ bộ nhớ còn mang lại lợi thế nào khác không?",
      correct: true,
    },
    {
      text: "Nó tiêu thụ ít năng lượng hơn, vì vậy pin của bạn dùng được lâu hơn.",
      explain: "Điều này không chính xác - hãy thử lại!",
    },
  ]}
/>

### 6. Tại sao đoạn mã sau không thành công?

```py
from datasets import load_dataset

dataset = load_dataset("allocine", streaming=True, split="train")
dataset[0]
```

<Question
  choices={[
    {
      text: "Nó cố gắng phát trực tuyến tập dữ liệu quá lớn để vừa với RAM.",
      explain:
        "Điều này không chính xác - tập dữ liệu phát trực tuyến được giải nén nhanh chóng và bạn có thể xử lý tập dữ liệu có kích thước terabyte với rất ít RAM!",
    },
    {
      text: "Nó cố gắng truy cập một <code>IterableDataset</code>.",
      explain:
        "Đúng! Một <code>IterableDataset</code> là một trình tạo, không phải là một vùng chứa, nên bạn có thể truy cập các phần tử của nó sử dụng <code>next(iter(dataset))</code>.",
      correct: true,
    },
    {
      text: "Tập dữ liệu <code>allocine</code> không có phần tách huấn luyện (<code>train</code> split).",
      explain:
        "Không chính xác -- tham khảo [thẻ dữ liệu <code>allocine</code>](https://huggingface.co/datasets/allocine) trên Hub để xem có những phần tách dữ liệu nào.",
    },
  ]}
/>

### 7. Lợi ích chính của việc tạo thẻ tập dữ liệu là gì?

<Question
  choices={[
    {
      text: "Nó cung cấp thông tin về mục đích sử dụng và các tác vụ được hỗ trợ của tập dữ liệu để những người khác trong cộng đồng có thể đưa ra quyết định sáng suốt về việc sử dụng nó.",
      explain:
        "Đúng! Tập dữ liệu không có tài liệu có thể được sử dụng để huấn luyện các mô hình có thể không phản ánh ý định của người tạo tập dữ liệu hoặc có thể tạo ra các mô hình có tình trạng pháp lý không rõ ràng nếu chúng được huấn luyện về dữ liệu vi phạm quyền riêng tư hoặc hạn chế cấp phép. Tuy nhiên, đó không phải là lợi ích duy nhất!",
      correct: true,
    },
    {
      text: "Nó giúp thu hút sự chú ý đến những sai lệch ​​có trong ngữ liệu.",
      explain:
        "Đúng! Hầu hết tất cả các tập dữ liệu đều có một số dạng sai lệch, có thể tạo ra hậu quả tiêu cực. Nhận thức được chúng sẽ giúp người xây dựng mô hình hiểu cách giải quyết các thành kiến ​​cố hữu. Thẻ tập dữ liệu còn giúp được gì nữa không?",
      correct: true,
    },
    {
      text: "Nó cải thiện cơ hội mà những người khác trong cộng đồng sẽ sử dụng tập dữ liệu của mình.",
      explain:
        "Đúng! Một thẻ dữ liệu được viết tốt sẽ có xu hướng dẫn đến việc sử dụng tập dữ liệu quý giá của bạn cao hơn. Nó cung cấp những lợi ích nào khác không?",
      correct: true,
    },
  ]}
/>

### 8. Tìm kiếm ngữ nghĩa là gì?

<Question
  choices={[
    {
      text: "Một cách để tìm kiếm các kết quả khớp hoàn toàn giữa các từ trong truy vấn và các tài liệu trong kho ngữ liệu",
      explain:
        "Điều này không chính xác - loại tìm kiếm này được gọi là *tìm kiếm từ vựng* và đó là những gì bạn thường thấy với các công cụ tìm kiếm truyền thống.",
    },
    {
      text: "Một cách để tìm kiếm các tài liệu phù hợp bằng cách hiểu ý nghĩa ngữ cảnh của một truy vấn",
      explain:
        "Đúng! Tìm kiếm theo ngữ nghĩa sử dụng vectơ nhúng để đại diện cho các truy vấn và tài liệu, đồng thời sử dụng số liệu tương tự để đo mức độ trùng lặp giữa chúng. Bạn có thể mô tả nó như thế nào khác không?",
      correct: true,
    },
    {
      text: "Một cách để cải thiện độ chính xác của tìm kiếm",
      explain:
        "Đúng! Các công cụ tìm kiếm ngữ nghĩa có thể nắm bắt mục đích của một truy vấn tốt hơn nhiều so với đối sánh từ khóa và thường truy xuất tài liệu với độ chính xác cao hơn. Nhưng đây không phải là câu trả lời đúng duy nhất - tìm kiếm ngữ nghĩa còn cung cấp gì nữa?",
      correct: true,
    },
  ]}
/>

### 9. Đối với tìm kiếm ngữ nghĩa phi đối xứng, bạn thường có:

<Question
  choices={[
    {
      text: "Một truy vấn ngắn và một đoạn dài hơn trả lời cho truy vấn",
      explain: "Chính xác!",
      correct: true,
    },
    {
      text: "Truy vấn và đoạn văn có cùng độ dài",
      explain:
        "Đây thực sự là một ví dụ về tìm kiếm ngữ nghĩa đối xứng - hãy thử lại!",
    },
    {
      text: "Một truy vấn dài và một đoạn ngắn hơn trả lời cho truy vấn",
      explain: "Điều này không chính xác - hãy thử lại!",
    },
  ]}
/>

### 10. Tôi có thể sử dụng 🤗 Datasets để tải dữ liệu sử dụng cho các mảng khác như xử lý âm thanh được không?

<Question
  choices={[
    {
      text: "Không",
      explain:
        "Không chính xác -- 🤗 Datasets hiện có hỗ trợ dữ liệu dạng bảng, âm thanh, và hình ảnh. Xem thêm <a  href='https://huggingface.co/datasets/mnist'>dữ liệu MNIST</a> trên Hub cho ví dụ về xử lý hình ảnh.",
    },
    {
      text: "Có",
      explain:
        "Chính xác! Hãy xem những diễn biến thú vị với giọng nói và hình ảnh trong thư viện 🤗 Transformers để xem cách 🤗 Datasets được sử dụng như thế nào trong các lĩnh vực này.",
      correct: true,
    },
  ]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/vi/chapter5/8.mdx" />