# Yêu cầu trợ giúp trên diễn đàn

<DocNotebookDropdown
  classNames="absolute z-10 right-0 top-0"
  options={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/vi/chapter8/section3.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/vi/chapter8/section3.ipynb"},
]} />

<Youtube id="S2EEG3JIt2A"/>

[Diễn đàn Hugging Face](https://discuss.huggingface.co) là nơi tuyệt vời để nhận được sự giúp đỡ từ các nhóm nguồn mở và cộng đồng Hugging Face. Trang chủ luôn trông như sau:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forums.png" alt="The Hugging Face forums." width="100%"/>
</div>

Ở bên tay trái, bạn có thể thấy tất cả các danh mục mà các chủ đề khác nhau được nhóm lại, trong khi bên tay phải hiển thị các chủ đề gần đây nhất. Chủ đề là một bài đăng có chứa tiêu đề, danh mục và mô tả; nó khá giống với định dạng vấn đề GitHub mà chúng ta đã thấy khi tạo tập dữ liệu của riêng mình trong [Chương 5](/course/chapter5). Như tên cho thấy, danh mục [Beginners](https://discuss.huggingface.co/c/beginners/5) chủ yếu dành cho những người mới bắt đầu với hệ sinh thái và thư viện Hugging Face. Mọi câu hỏi trên bất kỳ thư viện nào đều được hoan nghênh ở đó, có thể là để gỡ lỗi một số mã hoặc để yêu cầu trợ giúp về cách thực hiện điều gì đó. (Điều đó nói rằng, nếu câu hỏi của bạn liên quan đến một thư viện cụ thể, bạn có thể nên chuyển đến danh mục thư viện tương ứng trên diễn đàn.)

Tương tự, danh mục [Intermediate](https://discuss.huggingface.co/c/intermediate/6)và [Research](https://discuss.huggingface.co/c/research/7) dành cho các câu hỏi nâng cao hơn , ví dụ về thư viện hoặc một số nghiên cứu NLP mới thú vị mà bạn muốn thảo luận.

Và đương nhiên, chúng ta cũng nên đề cập đến danh mục [Course](https://discuss.huggingface.co/c/course/20), nơi bạn có thể đặt bất kỳ câu hỏi nào liên quan đến khóa học Hugging Face!

Khi bạn đã chọn một danh mục, bạn sẽ sẵn sàng viết chủ đề đầu tiên của mình. Bạn có thể tìm thấy một số [hướng dẫn](https://discuss.huggingface.co/t/how-to-request-support/3128) trong diễn đàn về cách thực hiện việc này và trong phần này chúng ta sẽ xem xét một số tính năng tạo nên một chủ đề hay.

## Viết một bài đăng tốt trên diễn đàn

Như một ví dụ, giả sử rằng chúng ta đang cố gắng tạo các biểu diễn từ các bài viết trên Wikipedia để tạo một công cụ tìm kiếm tùy chỉnh. Như thường lệ, chúng ta tải tokenizer và mô hình như sau:

```python
from transformers import AutoTokenizer, AutoModel

model_checkpoint = "distilbert-base-uncased"
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)
model = AutoModel.from_pretrained(model_checkpoint)
```

Giờ giả sử ta đang cố nhúng toàn bộ phần này của [Wikipedia](https://en.wikipedia.org/wiki/Transformers) lên Transformers:

```python
text = """
Generation One is a retroactive term for the Transformers characters that
appeared between 1984 and 1993. The Transformers began with the 1980s Japanese
toy lines Micro Change and Diaclone. They presented robots able to transform
into everyday vehicles, electronic items or weapons. Hasbro bought the Micro
Change and Diaclone toys, and partnered with Takara. Marvel Comics was hired by
Hasbro to create the backstory; editor-in-chief Jim Shooter wrote an overall
story, and gave the task of creating the characthers to writer Dennis O'Neil.
Unhappy with O'Neil's work (although O'Neil created the name "Optimus Prime"),
Shooter chose Bob Budiansky to create the characters.

The Transformers mecha were largely designed by Shōji Kawamori, the creator of
the Japanese mecha anime franchise Macross (which was adapted into the Robotech
franchise in North America). Kawamori came up with the idea of transforming
mechs while working on the Diaclone and Macross franchises in the early 1980s
(such as the VF-1 Valkyrie in Macross and Robotech), with his Diaclone mechs
later providing the basis for Transformers.

The primary concept of Generation One is that the heroic Optimus Prime, the
villainous Megatron, and their finest soldiers crash land on pre-historic Earth
in the Ark and the Nemesis before awakening in 1985, Cybertron hurtling through
the Neutral zone as an effect of the war. The Marvel comic was originally part
of the main Marvel Universe, with appearances from Spider-Man and Nick Fury,
plus some cameos, as well as a visit to the Savage Land.

The Transformers TV series began around the same time. Produced by Sunbow
Productions and Marvel Productions, later Hasbro Productions, from the start it
contradicted Budiansky's backstories. The TV series shows the Autobots looking
for new energy sources, and crash landing as the Decepticons attack. Marvel
interpreted the Autobots as destroying a rogue asteroid approaching Cybertron.
Shockwave is loyal to Megatron in the TV series, keeping Cybertron in a
stalemate during his absence, but in the comic book he attempts to take command
of the Decepticons. The TV series would also differ wildly from the origins
Budiansky had created for the Dinobots, the Decepticon turned Autobot Jetfire
(known as Skyfire on TV), the Constructicons (who combine to form
Devastator),[19][20] and Omega Supreme. The Marvel comic establishes early on
that Prime wields the Creation Matrix, which gives life to machines. In the
second season, the two-part episode The Key to Vector Sigma introduced the
ancient Vector Sigma computer, which served the same original purpose as the
Creation Matrix (giving life to Transformers), and its guardian Alpha Trion.
"""

inputs = tokenizer(text, return_tensors="pt")
logits = model(**inputs).logits
```

```python output
IndexError: index out of range in self
```

Rất tiếc, chúng ta đã gặp sự cố - và thông báo lỗi khó hiểu hơn nhiều so với những thông báo chúng ta thấy trong [phần 2](/course/chapter8/section2)! Chúng ta không thể thực hiện được toàn bộ quá trình truy vết, vì vậy chúng ta quyết định chuyển sang diễn đàn Hugging Face để được trợ giúp. Làm thế nào chúng ta có thể tạo ra chủ đề?

Để bắt đầu, chúng ta cần nhấp vào nút "New Topic" hay "Chủ đề mới" ở góc trên bên phải (lưu ý rằng để tạo chủ đề, chúng ta cần đăng nhập):

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forums-new-topic.png" alt="Creating a new forum topic." width="100%"/>
</div>

Thao tác này sẽ hiển thị một giao diện viết, nơi chúng ta có thể nhập tiêu đề của chủ đề của mình, chọn một danh mục và soạn thảo nội dung:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic01.png" alt="The interface for creating a forum topic." width="100%"/>
</div>

Vì lỗi dường như chỉ xảy ra với 🤗 Transformers, nên chúng ta sẽ chọn lỗi này cho danh mục. Nỗ lực đầu tiên của chúng ta trong việc giải thích vấn đề có thể trông giống như sau:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic02.png" alt="Drafting the content for a new forum topic." width="100%"/>
</div>

Mặc dù chủ đề này chứa thông báo lỗi mà chúng tôi cần trợ giúp, nhưng có một số vấn đề với cách viết:

1. Tiêu đề không mang tính mô tả cao, vì vậy bất kỳ ai duyệt diễn đàn sẽ không thể biết chủ đề là gì nếu không đọc phần nội dung.
2. Phần thân không cung cấp đủ thông tin về _nơi_ bắt nguồn lỗi và _cách_ để tạo lại lỗi đó.
3. Chủ đề gắn thẻ trực tiếp một vài người với giọng điệu hơi khắt khe.

Các chủ đề như thế này không có khả năng nhận được câu trả lời nhanh (nếu họ nhận được một câu trả lời nào đó), vì vậy hãy xem cách chúng ta có thể cải thiện nó. Chúng ta sẽ bắt đầu với vấn đề đầu tiên là chọn một tiêu đề hay.

### Choosing a descriptive title

Nếu bạn đang cố gắng nhận trợ giúp về một lỗi trong mã của mình, một nguyên tắc chung là đưa đủ thông tin vào tiêu đề để người khác có thể nhanh chóng xác định xem họ có nghĩ rằng họ có thể trả lời câu hỏi của bạn hay không. Trong ví dụ đang chạy của mình, chúng ta biết tên của ngoại lệ đang được nêu ra và có một số gợi ý rằng nó được kích hoạt trong phần truyền thẳng của mô hình, nơi chúng tôi gọi là `model(**inputs)`. Để thông báo điều này, một tiêu đề có thể có là:

> Source of IndexError in the AutoModel forward pass?

hay 

> Nguồn của IndexError trong thẻ chuyển tiếp AutoModel?

Tiêu đề này cho người đọc biết bạn nghĩ rằng lỗi đến từ _đâu_ và nếu họ đã gặp phải `IndexError` trước đó, thì rất có thể họ sẽ biết cách gỡ lỗi nó. Tất nhiên, tiêu đề có thể là bất kỳ thứ gì bạn muốn và các biến thể khác như:

> Why does my model produce an IndexError?

hay 

> Tại sao mô hình của tôi tạo ra một IndexError?

cũng có thể ổn. Bây giờ chúng ta đã có một tiêu đề mô tả, hãy xem cách cải thiện nội dụng phần thân bài.

### Định dạng các đoạn mã của bạn

Đọc mã nguồn đã đủ khó trong IDE, nhưng còn khó hơn khi mã được sao chép và dán dưới dạng văn bản thuần túy! May mắn thay, các diễn đàn về Hugging Face hỗ trợ việc sử dụng Markdown, vì vậy bạn nên luôn đặt các khối mã của mình bằng ba dấu gạch ngược (```) để dễ đọc hơn. Hãy làm điều này để sửa chữa thông báo lỗi - và trong khi chúng ta xử lý nó, hãy làm cho phần nội dung lịch sự hơn một chút so với phiên bản gốc của mình:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic03.png" alt="Our revised forum topic, with proper code formatting." width="100%"/>
</div>

Như bạn có thể thấy trong ảnh chụp màn hình, việc bao bọc các khối mã trong dấu gạch ngược sẽ chuyển văn bản thô thành mã được định dạng, hoàn chỉnh với kiểu màu! Cũng lưu ý rằng các dấu gạch ngược đơn lẻ có thể được sử dụng để định dạng các biến nội tuyến, giống như chúng tôi đã làm cho `distilbert-base-unsased`. Chủ đề này có vẻ tốt hơn nhiều và với một chút may mắn, chúng ta có thể tìm thấy ai đó trong cộng đồng có thể đoán được lỗi là gì. Tuy nhiên, thay vì dựa vào may mắn, chúng ta hãy làm cho cuộc sống dễ dàng hơn bằng cách đưa vào chi tiết đầy đủ các truy vết của nó!

### Bao gồm toàn bộ truy vết

Vì dòng cuối cùng của bản truy vết thường đủ để gỡ lỗi đoạn mã của riêng bạn, nên bạn có thể chỉ cung cấp dòng đó trong chủ đề của mình để "tiết kiệm dung lượng". Mặc dù có chủ ý tốt, điều này thực sự khiến người khác có thể _khó_ gỡ lỗi vấn đề _hơn_ vì thông tin cao hơn trong bản truy xuất có thể thực sự hữu ích. Vì vậy, một phương pháp hay là sao chép và dán _toàn bộ_ dấu vết, đồng thời đảm bảo rằng nó được định dạng độc đáo. Vì những lần truy xuất này có thể mất nhiều thời gian, một số người thích hiển thị chúng sau khi họ đã giải thích mã nguồn. Làm thôi nào. Bây giờ, chủ đề diễn đàn của chúng ta trông giống như sau:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic04.png" alt="Our example forum topic, with the complete traceback." width="100%"/>
</div>

Điều này có nhiều thông tin hơn và một người đọc cẩn thận có thể chỉ ra rằng vấn đề dường như là do chuyển một đầu vào dài vì dòng này trong bản truy xuất:

> Token indices sequence length is longer than the specified maximum sequence length for this model (583 > 512).

Tuy nhiên, chúng ta có thể khiến mọi thứ trở nên dễ dàng hơn với họ bằng cách cung cấp mã thực đã gây ra lỗi. Hãy làm điều đó ngay bây giờ.

### Cung cấp một ví dụ có thể tái tạo

Nếu bạn đã từng cố gắng gỡ lỗi đoạn mã của người khác, trước tiên có thể bạn đã cố gắng tạo lại sự cố mà họ đã báo cáo để bạn có thể bắt đầu làm việc theo cách của mình thông qua truy xuất để xác định lỗi. Nó không khác gì khi nói đến (hoặc cung cấp) hỗ trợ trên các diễn đàn, vì vậy sẽ thực sự hữu ích nếu bạn có thể cung cấp một ví dụ nhỏ mô tả lại lỗi. Một nửa thời gian, chỉ cần đi qua bài tập này sẽ giúp bạn nhận ra điều gì đang xảy ra. Trong mọi trường hợp, phần còn thiếu trong ví dụ của chúng ta là hiển thị _các đầu vào_ mà ta đã cung cấp cho mô hình. Làm điều đó cho chúng ta một cái gì đó giống như ví dụ đã hoàn thành sau:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic05.png" alt="The final version of our forum topic." width="100%"/>
</div>

Chủ đề này hiện chứa khá nhiều thông tin và nó được viết theo cách có nhiều khả năng thu hút sự chú ý của cộng đồng và nhận được câu trả lời hữu ích. Với những hướng dẫn cơ bản này, giờ đây bạn có thể tạo các chủ đề tuyệt vời để tìm câu trả lời cho các câu hỏi về 🤗 Transformers của mình!


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/vi/chapter8/3.mdx" />