# Đố vui cuối chương

Cũng kiểm tra xem bạn đã học được gì từ chương này!

### 1. Bạn nên đọc truy vết của Python theo thứ tự nào?

<Question
  choices={[
    {
      text: "Từ trên xuống dưới",
      explain:
        "Hãy thử lại - mặc dù hầu hết các ngôn ngữ lập trình khác in ngoại lệ ở trên cùng, Python đặc biệt về mặt này.",
    },
    {
      text: "Từ dưới lên trên",
      explain:
        "Đúng! Một lợi thế của các truy vết của Python hiển thị ngoại lệ ở phía dưới là việc gỡ lỗi dễ dàng hơn khi bạn đang làm việc trong thiết bị đầu cuối như terminal và đây là dòng cuối cùng bạn nhìn thấy.",
      correct: true,
    },
  ]}
/>

### 2. Ví dụ có thể tái tạo tối thiểu là gì?

<Question
  choices={[
    {
      text: "Cách triển khai đơn giản của kiến ​​trúc Transformer từ một bài báo nghiên cứu",
      explain:
        "Mặc dù việc triển khai các mô hình Transformer của riêng bạn từ đầu rất mang tính giáo dục, nhưng đây không phải là điều chúng ta đang nói ở đây.",
    },
    {
      text: "Một khối mã nhỏ gọn và khép kín có thể chạy mà không có bất kỳ sự phụ thuộc bên ngoài nào vào các tệp hoặc dữ liệu riêng tư",
      explain:
        "Đúng! Các ví dụ có thể tái tạo tối thiểu giúp người bảo trì của thư viện tái tạo vấn đề bạn đang gặp phải, vì vậy họ có thể tìm ra giải pháp nhanh hơn.",
      correct: true,
    },
    {
      text: "Ảnh chụp màn hình của truy vết Python",
      explain:
        "Hãy thử lại - mặc dù rất hấp dẫn để bao gồm ảnh chụp màn hình về lỗi bạn đang gặp phải khi gửi vấn đề, điều này khiến những người khác rất khó tái tạo lỗi.",
    },
    {
      text: "Một notebook chứa toàn bộ phân tích của bạn, bao gồm các phần không liên quan đến lỗi",
      explain:
        "Không hẳn - mặc dù có thể hữu ích khi chia sẻ notebook Google Colab hiển thị lỗi, hãy đảm bảo rằng notebook đó ngắn và chỉ chứa mã có liên quan.",
    },
  ]}
/>

### 3. Giả sử bạn cố gắng chạy đoạn mã sau, mà mã này xảy ra lỗi như dưới đây:

```py
from transformers import GPT3ForSequenceClassification

# ImportError: cannot import name 'GPT3ForSequenceClassification' from 'transformers' (/Users/lewtun/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/__init__.py)
# ---------------------------------------------------------------------------
# ImportError                               Traceback (most recent call last)
# /var/folders/28/k4cy5q7s2hs92xq7_h89_vgm0000gn/T/ipykernel_30848/333858878.py in <module>
# ----> 1 from transformers import GPT3ForSequenceClassification

# ImportError: cannot import name 'GPT3ForSequenceClassification' from 'transformers' (/Users/lewtun/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/__init__.py)
```

Điều nào dưới đây có thể là một lựa chọn tốt cho tiêu đề của một chủ đề diễn đàn để yêu cầu trợ giúp?

<Question
  choices={[
    {
      text: "<code>ImportError: cannot import name 'GPT3ForSequenceClassification' from 'transformers' (/Users/lewtun/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/__init__.py)</code>",
      explain:
        "Việc bao gồm dòng cuối cùng của truy vết có thể mang tính mô tả, nhưng điều này tốt hơn nên dành cho phần chính của chủ đề. Hãy thử lại!",
    },
    {
      text: "Vấn đề với <code>from transformers import GPT3ForSequenceClassification</code>",
      explain:
        "Hãy thử lại - mặc dù điều này cung cấp thông tin hữu ích, nhưng nó có lẽ tốt nhất nên được dành cho phần chính của văn bả.",
    },
    {
      text: "Tại sao tôi không thể nhập <code>GPT3ForSequenceClassification</code>?",
      explain:
        "Lựa chọn tốt! Tiêu đề này ngắn gọn và cung cấp cho người đọc manh mối về những gì có thể sai (tức là GPT-3 không được hỗ trợ trong 🤗 Transformers).",
      correct: true,
    },
    {
      text: "Liệu GPT-3 có được hỗ trợ trong 🤗 Transformers?",
      explain:
        "Một câu hỏi hay! Sử dụng câu hỏi làm tiêu đề chủ đề là một cách tuyệt vời để truyền đạt vấn đề với cộng đồng.",
      correct: true,
    },
  ]}
/>

### 4.Giả sử bạn đang cố gắng chạy `trainer.train()` và gặp phải lỗi khó hiểu không cho bạn biết chính xác lỗi đến từ đâu. Đâu sẽ là nơi đầu tiên bạn tìm lỗi trong pipeline huấn luyện của mình?

<Question
  choices={[
    {
      text: "Bước tối ưu hóa nơi chúng ta tính toán độ dốc và thực hiện lan truyền ngược",
      explain:
        "Mặc dù có thể có lỗi trong trình tối ưu hóa của bạn, nhưng đây thường là một vài bước trong quá trình huấn luyện, vì vậy, có những thứ khác cần kiểm tra trước. Hãy thử lại!",
    },
    {
      text: "Bước đánh giá nơi chúng tôi tính toán các chỉ số",
      explain:
        "Đánh giá thường là những gì bạn làm sau khi huấn luyện cho một epoch đầy đủ, vì vậy trước tiên bạn nên kiểm tra một chỗ nào đó trước trong quá trình huấn luyện.",
    },
    {
      text: "Bộ dữ liệu",
      explain:
        "Đúng! Xem xét dữ liệu của bạn hầu như luôn là điều đầu tiên bạn nên làm, để đảm bảo văn bản được tokenize phù hợp, có các đặc trưng mong đợi, v.v.",
      correct: true,
    },
    {
      text: "The dataloaders",
      explain:
        "Hãy thử lại - điều này rất gần với điều đầu tiên bạn nên kiểm tra. Bạn có nhớ đối tượng mà chúng ta truyền cho bộ dữ liệu là gì không?",
    },
  ]}
/>

### 5. Đâu là cách tốt nhất để gỡ lỗi CUDA?

<Question
  choices={[
    {
      text: "Đăng thông báo lỗi trên diễn đàn hoặc GitHub.",
      explain:
        "Điều đó sẽ không giúp ích cho bất kỳ ai vì các thông báo lỗi CUDA thường rất khó hiểu.",
    },
    {
      text: "Thực thi cùng một mã trên CPU.",
      explain: "Chính xác, điều đó sẽ cung cấp cho bạn thông báo lỗi tốt hơn!",
      correct: true,
    },
    {
      text: "Đọc phần theo dõi để tìm hiểu nguyên nhân gây ra lỗi.",
      explain:
        "Đó là những gì bạn sẽ làm đối với bất kỳ lỗi nào khác, nhưng lỗi CUDA thường không được nêu ra ở nơi chúng xảy ra vì hầu hết các hoạt động CUDA là không đồng bộ.",
    },
    {
      text: "Giảm kích thước lô.",
      explain:
        "Giảm kích thước lô thường là một chiến lược tốt để xử lý lỗi CUDA hết bộ nhớ, nhưng không phải cho vấn đề cụ thể này. Hãy thử lại!",
    },
    {
      text: "Khởi động lại Jupyter kernel.",
      explain:
        "Hãy thử lại - khởi động lại kernel sẽ không làm cho lỗi biến mất một cách kỳ diệu!",
    },
  ]}
/>

### 6. Đâu là cách tốt nhất để khắc phục lỗi trên Github?

<Question
  choices={[
    {
      text: "ăng một ví dụ có thể tái tạo đầy đủ về lỗi.",
      explain:
        "Vâng, đó là cách tốt nhất để giúp những người bảo trì tìm ra lỗi của bạn. Bạn nên làm gì khác?",
      correct: true,
    },
    {
      text: "Yêu cầu cập nhật mỗi ngày.",
      explain:
        "Điều đó không thể giúp bạn bất kỳ sự giúp đỡ nào; mọi người có thể sẽ bỏ qua bạn nhiều hơn.",
    },
    {
      text: "Kiểm tra mã nguồn xung quanh lỗi và cố gắng tìm lý do tại sao nó xảy ra. Đăng kết quả về vấn đề.",
      explain:
        "Điều đó chắc chắn sẽ giúp ích cho những người bảo trì! Và nếu bạn tìm ra nguồn gốc của lỗi và cách khắc phục, bạn thậm chí có thể mở một pull request. Bạn nên làm gì khác?",
      correct: true,
    },
  ]}
/>

### 7. Tại sao học quá kĩ (overfit) vào một lô thường là cách gỡ lỗi tốt nhất?

<Question
  choices={[
    {
      text: "Không đâu; nó luôn là điều xấu ta nên tránh.",
      explain:
        "Khi huấn luyện trên toàn bộ tập dữ liệu, việc học kĩ quá mức thực sự có thể là một dấu hiệu cho thấy mô hình của bạn sẽ không khái quát tốt cho các ví dụ mới. Tuy nhiên, để gỡ lỗi, chúng tôi thường không huấn luyện trên toàn bộ tập dữ liệu. Hãy thử lại!",
    },
    {
      text: "Nó cho phép chúng ta xác minh rằng mô hình có thể giảm mất mát xuống bằng không.",
      explain:
        "Đúng! Với một lô nhỏ có ít nhất hai ví dụ, chúng ta có thể nhanh chóng xác minh xem mô hình có khả năng học hỏi hay không.",
      correct: true,
    },
    {
      text: "Nó cho phép chúng tôi xác minh rằng hình dạng tensor của đầu vào và nhãn của chúng tôi là chính xác.",
      explain:
        "Hãy thử lại - nếu hình dạng tensor của bạn bị lệch, thì bạn chắc chắn sẽ không thể huấn luyện, ngay cả trên một lô duy nhất.",
    },
  ]}
/>

### 8. Tại sao bao gồm chi tiết về môi trường tính toán với `transformers-cli env` khi tạo ra một issue (vấn đề) trên kho 🤗 Transformers là một ý hay?

<Question
  choices={[
    {
      text: "Nó cho phép người bảo trì hiểu phiên bản thư viện bạn đang sử dụng.",
      explain:
        "Đúng! Vì mỗi phiên bản chính của thư viện có thể có những thay đổi trong API, nên việc biết bạn đang sử dụng phiên bản cụ thể nào có thể giúp thu hẹp vấn đề. Các lợi ích khác là gì?",
      correct: true,
    },
    {
      text: "Nó cho phép người bảo trì biết liệu bạn đang chạy mã trên Windows, macOS hay Linux.",
      explain:
        "Đúng! Các lỗi đôi khi có thể do hệ điều hành cụ thể mà bạn đang sử dụng gây ra và việc biết điều này sẽ giúp người bảo trì tái tạo chúng cục bộ. Tuy nhiên, đó không phải là lý do duy nhất.",
      correct: true,
    },
    {
      text: "Nó cho phép người bảo trì biết liệu bạn đang chạy mã trên GPU hay CPU.",
      explain:
        "Đúng! Như chúng ta đã thấy trong chương này, mã chạy trên GPU hoặc CPU có thể tạo ra các kết quả hoặc lỗi khác nhau và việc biết bạn đang sử dụng phần cứng nào có thể giúp tập trung sự chú ý của người bảo trì. Nhưng đây không phải là điều duy nhất lợi ích...",
      correct: true,
    },
  ]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/vi/chapter8/7.mdx" />