import{s as fs,o as Cs,n as hs}from"../chunks/scheduler.cc52f4b9.js";import{S as Zs,i as Gs,e as o,s as a,c as p,h as Is,a as y,d as s,b as n,f as ws,g as M,j as d,k as Us,l as $s,m as t,n as c,t as i,o as r,p as m}from"../chunks/index.9480bb2b.js";import{T as us}from"../chunks/Tip.f7b80743.js";import{C as ks,H as Xl,E as Bs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.009dc98d.js";import{Y as Ts}from"../chunks/Youtube.7b12d9e8.js";import{C as b}from"../chunks/CodeBlock.184aadb6.js";import{C as Xs}from"../chunks/CourseFloatingBanner.6488bde3.js";function Ws(kl){let j,w="✏️ <strong>试试看！</strong> 修改之前的训练循环以在 SST-2 数据集上微调你的模型。";return{c(){j=o("p"),j.innerHTML=w},l(J){j=y(J,"P",{"data-svelte-h":!0}),d(j)!=="svelte-n66aug"&&(j.innerHTML=w)},m(J,U){t(J,j,U)},p:hs,d(J){J&&s(j)}}}function Rs(kl){let j,w="⚠️ 为了使云端 TPU 提供的加速中发挥最大的效益，我们建议使用 tokenizer 的 <code>padding=max_length</code> 和 <code>max_length</code> 参数将你的样本填充到固定长度。";return{c(){j=o("p"),j.innerHTML=w},l(J){j=y(J,"P",{"data-svelte-h":!0}),d(j)!=="svelte-1thjlh4"&&(j.innerHTML=w)},m(J,U){t(J,j,U)},p:hs,d(J){J&&s(j)}}}function gs(kl){let j,w,J,U,h,Wl,f,Rl,C,gl,Z,vl,G,Ee="现在，我们将了解如何在不使用 <code>Trainer</code> 类的情况下实现与上一节相同的结果。同样，我们假设你已经完成了第 2 节中的数据处理。下面对第 2 节内容的一个简短总结，涵盖了你需要在本节之前运行的所有内容：",_l,I,Vl,$,Yl,k,Fe="在正式开始编写我们的训练循环之前，我们需要定义一些对象。首先是我们将用于迭代 batch 的数据加载器。但在定义这些数据加载器之前，我们需要对我们的 <code>tokenized_datasets</code> 进行一些后处理，以自己实现一些 Trainer 自动为我们处理的内容。具体来说，我们需要：",Al,B,Qe="<li>删除与模型不需要的列（如 <code>sentence1</code> 和 <code>sentence2</code> 列）。</li> <li>将列名 <code>label</code> 重命名为 <code>labels</code> （因为模型默认的输入是 <code>labels</code> ）。</li> <li>设置数据集的格式，使其返回 PyTorch 张量而不是列表。</li>",zl,X,He="针对上面的每个步骤，我们的 <code>tokenized_datasets</code> 都有一个方法：",Nl,W,El,R,xe="然后，我们可以检查结果中是否只有模型能够接受的列：",Fl,g,Ql,v,Se="至此，我们可以轻松定义数据加载器：",Hl,_,xl,V,Le="为了快速检验数据处理中没有错误，我们可以这样检验其中的一个 batch：",Sl,Y,Ll,A,ql,z,qe="请注意，这里的形状可能与你略有不同，因为我们为训练数据加载器设置了 <code>shuffle=True</code> ，并且模型会将句子填充到 <code>batch</code> 中的最大长度。",Kl,N,Ke="现在我们已经完全完成了数据预处理（对于任何 ML 从业者来说都是一个令人满意但难以实现的目标），让我们将注意力转向模型。我们会像在上一节中所做的那样实例化它：",Pl,E,Dl,F,Pe="为了确保训练过程中一切顺利，我们将 <code>batch</code> 传递给这个模型：",Ol,Q,le,H,ee,x,De="当我们输入 <code>labels</code> 时，🤗 Transformers 模型都将返回这个 <code>batch</code> 的 <code>loss</code> ，我们还得到了 <code>logits</code> （ <code>batch</code> 中的每个输入有两个输出，所以张量大小为 8 x 2）。",se,S,Oe='我们几乎准备好编写我们的训练循环了！我们只是缺少两件事：优化器和学习率调度器。由于我们试图手动实现 <code>Trainer</code> 的功能，我们将使用相同的优化器和学习率调度器。 <code>Trainer</code> 使用的优化器是 <code>AdamW</code> ，它与 <code>Adam</code> 相同，但加入了权重衰减正则化的一点变化（参见 Ilya Loshchilov 和 Frank Hutter 的 <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">“Decoupled Weight Decay Regularization”</a> ）：',te,L,ae,q,ls="最后，默认使用的学习率调度器只是从最大值 （5e-5） 到 0 的线性衰减。为了定义它，我们需要知道我们训练的次数，即所有数据训练的次数（epochs）乘以的 batch 的数量（即我们训练数据加载器的长度）。 <code>Trainer</code> 默认情况下使用三个 <code>epochs</code> ，因此我们定义训练过程如下：",ne,K,pe,P,Me,D,ce,O,es="最后一件事：如果我们可以访问 GPU，我们将希望使用 GPU（在 CPU 上，训练可能需要几个小时而不是几分钟）。为此，我们定义了一个 <code>device</code> ，它在 GPU 可用的情况下指向 GPU，最后我们将把我们的模型和 <code>batch</code> 放在 <code>device</code> 上：",ie,ll,re,el,me,sl,ss="我们现在准备好训练了！为了知道训练何时结束，我们使用 <code>tqdm</code> 库，在训练步骤数上添加了一个进度条：",oe,tl,ye,al,ts="你可以看到训练循环的核心与介绍中的非常相似。我们没有要求在训练的过程中进行检验，所以这个训练循环不会告诉我们任何关于模型目前的状态。我们需要为此添加一个评估循环。",de,nl,je,pl,as="正如我们之前所做的那样，我们将使用 🤗 Evaluate 库提供的指标。我们已经了解了 <code>metric.compute()</code> 方法，当我们使用 <code>add_batch()</code> 方法进行预测循环时，实际上该指标可以为我们累积所有 <code>batch</code> 的结果。一旦我们累积了所有 <code>batch</code> ，我们就可以使用 <code>metric.compute()</code> 评估得到的结果。以下是如何在评估循环中实现所有这些的方法：",be,Ml,Je,cl,we,il,ns="同样，由于模型头部初始化和数据打乱的随机性，你的结果会略有不同，但应该相差不多。",Ue,u,ue,rl,Te,ml,he,ol,ps='我们之前定义的训练循环在单个 CPU 或 GPU 上运行良好。通过使用 <a href="https://github.com/huggingface/accelerate" rel="nofollow">🤗 Accelerate</a> 库，只需进行一些调整，我们就可以在多个 GPU 或 TPU 上启用分布式训练。从创建训练和验证数据加载器开始，我们的手动训练循环如下所示：',fe,yl,Ce,dl,Ms="以下是更改的部分：",Ze,jl,Ge,bl,cs="要添加的第一行是导入 <code>Accelerator</code> 。第二行实例化一个 <code>Accelerator</code> 对象 它将查看环境并初始化适当的分布式设置。🤗 Accelerate 为你处理数据在设备间的数据传递，因此你可以删除将模型放在设备上的那行代码（或者，如果你愿意，可使用 <code>accelerator.device</code> 代替 <code>device</code> ）。",Ie,Jl,is="然后大部分工作会在将数据加载器、模型和优化器发送到的 <code>accelerator.prepare()</code> 中完成。这将会把这些对象包装在适当的容器中，以确保你的分布式训练按预期工作。要进行的其余更改是删除将 <code>batch</code> 放在 <code>device</code> 的那行代码（同样，如果你想保留它，你可以将其更改为使用 <code>accelerator.device</code> ） 并将 <code>loss.backward()</code> 替换为 <code>accelerator.backward(loss)</code> 。",$e,T,ke,wl,rs="如果你想复制并粘贴来直接运行，以下是 🤗 Accelerate 的完整训练循环：",Be,Ul,Xe,ul,ms="把这个放在 <code>train.py</code> 文件中，可以让它在任何类型的分布式设置上运行。要在分布式设置中试用它，请运行以下命令：",We,Tl,Re,hl,os="这将询问你几个配置的问题并将你的回答保存到此命令使用的配置文件中：",ge,fl,ve,Cl,ys="这将启动分布式训练",_e,Zl,ds="这将启动分布式训练。如果你想在 Notebook 中尝试此操作（例如，在 Colab 上使用 TPU 进行测试），只需将代码粘贴到一个 <code>training_function()</code> 函数中，并在最后一个单元格中运行：",Ve,Gl,Ye,Il,js='你可以在 <a href="https://github.com/huggingface/accelerate/tree/main/examples" rel="nofollow">🤗 Accelerate repo</a> 找到更多的示例。',Ae,$l,ze,Bl,Ne;return h=new ks({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new Xl({props:{title:"一个完整的训练",local:"一个完整的训练",headingTag:"h1"}}),C=new Xs({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter3/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter3/section4.ipynb"}]}}),Z=new Ts({props:{id:"Dh9CL8fyG80"}}),I=new b({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),$=new Xl({props:{title:"训练前的准备",local:"训练前的准备",headingTag:"h2"}}),W=new b({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiUyQyUyMCUyMmlkeCUyMiU1RCklMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXM=",highlighted:`tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;idx&quot;</span>])
tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)
tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].column_names`,wrap:!1}}),g=new b({props:{code:"JTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RA==",highlighted:'[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>]',wrap:!1}}),_=new b({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0Q4JTJDJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMEEpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUwQSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

train_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>], shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)
eval_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)`,wrap:!1}}),Y=new b({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBicmVhayUwQSU3QmslM0ElMjB2LnNoYXBlJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
    <span class="hljs-keyword">break</span>
{k: v.shape <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}`,wrap:!1}}),A=new b({props:{code:"JTdCJ2F0dGVudGlvbl9tYXNrJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSUyQyUwQSUyMCdpbnB1dF9pZHMnJTNBJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwNjUlNUQpJTJDJTBBJTIwJ2xhYmVscyclM0ElMjB0b3JjaC5TaXplKCU1QjglNUQpJTJDJTBBJTIwJ3Rva2VuX3R5cGVfaWRzJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSU3RA==",highlighted:`{<span class="hljs-string">&#x27;attention_mask&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: torch.Size([<span class="hljs-number">8</span>]),
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>])}`,wrap:!1}}),E=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),Q=new b({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBcHJpbnQob3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5sb2dpdHMuc2hhcGUp",highlighted:`outputs = model(**batch)
<span class="hljs-built_in">print</span>(outputs.loss, outputs.logits.shape)`,wrap:!1}}),H=new b({props:{code:"dGVuc29yKDAuNTQ0MSUyQyUyMGdyYWRfZm4lM0QlM0NObGxMb3NzQmFja3dhcmQlM0UpJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwMiU1RCk=",highlighted:'tensor(<span class="hljs-number">0.5441</span>, grad_fn=&lt;NllLossBackward&gt;) torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">2</span>])',wrap:!1}}),L=new b({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),K=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRG51bV90cmFpbmluZ19zdGVwcyUyQyUwQSklMEFwcmludChudW1fdHJhaW5pbmdfc3RlcHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)
<span class="hljs-built_in">print</span>(num_training_steps)`,wrap:!1}}),P=new b({props:{code:"MTM3Nw==",highlighted:'<span class="hljs-number">1377</span>',wrap:!1}}),D=new Xl({props:{title:"训练循环",local:"训练循环",headingTag:"h2"}}),ll=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBZGV2aWNl",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)
device`,wrap:!1}}),el=new b({props:{code:"ZGV2aWNlKHR5cGUlM0QnY3VkYScp",highlighted:'device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;cuda&#x27;</span>)',wrap:!1}}),tl=new b({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),nl=new Xl({props:{title:"评估循环",local:"评估循环",headingTag:"h2"}}),Ml=new b({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1vZGVsLmV2YWwoKSUwQWZvciUyMGJhdGNoJTIwaW4lMjBldmFsX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2gocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCklMEElMEFtZXRyaWMuY29tcHV0ZSgp",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(**batch)

    logits = outputs.logits
    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

metric.compute()`,wrap:!1}}),cl=new b({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODQzMTM3MjU0OTAxOTYwOCUyQyUyMCdmMSclM0ElMjAwLjg5MDc4NDk4MjkzNTE1MzUlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8431372549019608</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8907849829351535</span>}',wrap:!1}}),u=new us({props:{$$slots:{default:[Ws]},$$scope:{ctx:kl}}}),rl=new Xl({props:{title:"使用🤗 Accelerate 加速你的训练循环",local:"使用🤗 Accelerate加速你的训练循环",headingTag:"h2"}}),ml=new Ts({props:{id:"s7dy8QRgjJ0"}}),yl=new b({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMGdldF9zY2hlZHVsZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDNlLTUpJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIpJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMHRvcmNoLmRldmljZSglMjJjcHUlMjIpJTBBbW9kZWwudG8oZGV2aWNlKSUwQSUwQW51bV9lcG9jaHMlMjAlM0QlMjAzJTBBbnVtX3RyYWluaW5nX3N0ZXBzJTIwJTNEJTIwbnVtX2Vwb2NocyUyMColMjBsZW4odHJhaW5fZGF0YWxvYWRlciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),jl=new b({props:{code:"JTJCJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUyMCUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTIwZ2V0X3NjaGVkdWxlciUwQSUwQSUyQiUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQSUyMCUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCUyQyUyMG51bV9sYWJlbHMlM0QyKSUwQSUyMCUyMG9wdGltaXplciUyMCUzRCUyMEFkYW1XKG1vZGVsLnBhcmFtZXRlcnMoKSUyQyUyMGxyJTNEM2UtNSklMEElMEEtJTIwZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIpJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMHRvcmNoLmRldmljZSglMjJjcHUlMjIpJTBBLSUyMG1vZGVsLnRvKGRldmljZSklMEElMEElMkIlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKCUwQSUyQiUyMCUyMCUyMCUyMCUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBldmFsX2RhdGFsb2FkZXIlMkMlMjBtb2RlbCUyQyUyMG9wdGltaXplciUwQSUyQiUyMCklMEElMEElMjAlMjBudW1fZXBvY2hzJTIwJTNEJTIwMyUwQSUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBJTIwJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRG51bV90cmFpbmluZ19zdGVwcyUwQSUyMCUyMCklMEElMEElMjAlMjBwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBJTIwJTIwbW9kZWwudHJhaW4oKSUwQSUyMCUyMGZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBLSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBiYXRjaC5pdGVtcygpJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQS0lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMkIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBscl9zY2hlZHVsZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvZ3Jlc3NfYmFyLnVwZGF0ZSgxKQ==",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from transformers import AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`,wrap:!1}}),T=new us({props:{$$slots:{default:[Rs]},$$scope:{ctx:kl}}}),Ul=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC5vcHRpbSUyMGltcG9ydCUyMEFkYW1XJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),Tl=new b({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),fl=new b({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:'accelerate <span class="hljs-built_in">launch</span> train.py',wrap:!1}}),Gl=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

notebook_launcher(training_function)`,wrap:!1}}),$l=new Bs({props:{source:"https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter3/4.mdx"}}),{c(){j=o("meta"),w=a(),J=o("p"),U=a(),p(h.$$.fragment),Wl=a(),p(f.$$.fragment),Rl=a(),p(C.$$.fragment),gl=a(),p(Z.$$.fragment),vl=a(),G=o("p"),G.innerHTML=Ee,_l=a(),p(I.$$.fragment),Vl=a(),p($.$$.fragment),Yl=a(),k=o("p"),k.innerHTML=Fe,Al=a(),B=o("ul"),B.innerHTML=Qe,zl=a(),X=o("p"),X.innerHTML=He,Nl=a(),p(W.$$.fragment),El=a(),R=o("p"),R.textContent=xe,Fl=a(),p(g.$$.fragment),Ql=a(),v=o("p"),v.textContent=Se,Hl=a(),p(_.$$.fragment),xl=a(),V=o("p"),V.textContent=Le,Sl=a(),p(Y.$$.fragment),Ll=a(),p(A.$$.fragment),ql=a(),z=o("p"),z.innerHTML=qe,Kl=a(),N=o("p"),N.textContent=Ke,Pl=a(),p(E.$$.fragment),Dl=a(),F=o("p"),F.innerHTML=Pe,Ol=a(),p(Q.$$.fragment),le=a(),p(H.$$.fragment),ee=a(),x=o("p"),x.innerHTML=De,se=a(),S=o("p"),S.innerHTML=Oe,te=a(),p(L.$$.fragment),ae=a(),q=o("p"),q.innerHTML=ls,ne=a(),p(K.$$.fragment),pe=a(),p(P.$$.fragment),Me=a(),p(D.$$.fragment),ce=a(),O=o("p"),O.innerHTML=es,ie=a(),p(ll.$$.fragment),re=a(),p(el.$$.fragment),me=a(),sl=o("p"),sl.innerHTML=ss,oe=a(),p(tl.$$.fragment),ye=a(),al=o("p"),al.textContent=ts,de=a(),p(nl.$$.fragment),je=a(),pl=o("p"),pl.innerHTML=as,be=a(),p(Ml.$$.fragment),Je=a(),p(cl.$$.fragment),we=a(),il=o("p"),il.textContent=ns,Ue=a(),p(u.$$.fragment),ue=a(),p(rl.$$.fragment),Te=a(),p(ml.$$.fragment),he=a(),ol=o("p"),ol.innerHTML=ps,fe=a(),p(yl.$$.fragment),Ce=a(),dl=o("p"),dl.textContent=Ms,Ze=a(),p(jl.$$.fragment),Ge=a(),bl=o("p"),bl.innerHTML=cs,Ie=a(),Jl=o("p"),Jl.innerHTML=is,$e=a(),p(T.$$.fragment),ke=a(),wl=o("p"),wl.textContent=rs,Be=a(),p(Ul.$$.fragment),Xe=a(),ul=o("p"),ul.innerHTML=ms,We=a(),p(Tl.$$.fragment),Re=a(),hl=o("p"),hl.textContent=os,ge=a(),p(fl.$$.fragment),ve=a(),Cl=o("p"),Cl.textContent=ys,_e=a(),Zl=o("p"),Zl.innerHTML=ds,Ve=a(),p(Gl.$$.fragment),Ye=a(),Il=o("p"),Il.innerHTML=js,Ae=a(),p($l.$$.fragment),ze=a(),Bl=o("p"),this.h()},l(l){const e=Is("svelte-u9bgzb",document.head);j=y(e,"META",{name:!0,content:!0}),e.forEach(s),w=n(l),J=y(l,"P",{}),ws(J).forEach(s),U=n(l),M(h.$$.fragment,l),Wl=n(l),M(f.$$.fragment,l),Rl=n(l),M(C.$$.fragment,l),gl=n(l),M(Z.$$.fragment,l),vl=n(l),G=y(l,"P",{"data-svelte-h":!0}),d(G)!=="svelte-13enyaf"&&(G.innerHTML=Ee),_l=n(l),M(I.$$.fragment,l),Vl=n(l),M($.$$.fragment,l),Yl=n(l),k=y(l,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1yecb2p"&&(k.innerHTML=Fe),Al=n(l),B=y(l,"UL",{"data-svelte-h":!0}),d(B)!=="svelte-lvny5e"&&(B.innerHTML=Qe),zl=n(l),X=y(l,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1v2kn1o"&&(X.innerHTML=He),Nl=n(l),M(W.$$.fragment,l),El=n(l),R=y(l,"P",{"data-svelte-h":!0}),d(R)!=="svelte-1nix2jt"&&(R.textContent=xe),Fl=n(l),M(g.$$.fragment,l),Ql=n(l),v=y(l,"P",{"data-svelte-h":!0}),d(v)!=="svelte-1agqx3n"&&(v.textContent=Se),Hl=n(l),M(_.$$.fragment,l),xl=n(l),V=y(l,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1056o5f"&&(V.textContent=Le),Sl=n(l),M(Y.$$.fragment,l),Ll=n(l),M(A.$$.fragment,l),ql=n(l),z=y(l,"P",{"data-svelte-h":!0}),d(z)!=="svelte-15la3hm"&&(z.innerHTML=qe),Kl=n(l),N=y(l,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1fp0mz9"&&(N.textContent=Ke),Pl=n(l),M(E.$$.fragment,l),Dl=n(l),F=y(l,"P",{"data-svelte-h":!0}),d(F)!=="svelte-1bhzb96"&&(F.innerHTML=Pe),Ol=n(l),M(Q.$$.fragment,l),le=n(l),M(H.$$.fragment,l),ee=n(l),x=y(l,"P",{"data-svelte-h":!0}),d(x)!=="svelte-2dyt89"&&(x.innerHTML=De),se=n(l),S=y(l,"P",{"data-svelte-h":!0}),d(S)!=="svelte-pzmurp"&&(S.innerHTML=Oe),te=n(l),M(L.$$.fragment,l),ae=n(l),q=y(l,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1wax5dr"&&(q.innerHTML=ls),ne=n(l),M(K.$$.fragment,l),pe=n(l),M(P.$$.fragment,l),Me=n(l),M(D.$$.fragment,l),ce=n(l),O=y(l,"P",{"data-svelte-h":!0}),d(O)!=="svelte-az2ahg"&&(O.innerHTML=es),ie=n(l),M(ll.$$.fragment,l),re=n(l),M(el.$$.fragment,l),me=n(l),sl=y(l,"P",{"data-svelte-h":!0}),d(sl)!=="svelte-spzdap"&&(sl.innerHTML=ss),oe=n(l),M(tl.$$.fragment,l),ye=n(l),al=y(l,"P",{"data-svelte-h":!0}),d(al)!=="svelte-1ff2fnh"&&(al.textContent=ts),de=n(l),M(nl.$$.fragment,l),je=n(l),pl=y(l,"P",{"data-svelte-h":!0}),d(pl)!=="svelte-1ddz8vi"&&(pl.innerHTML=as),be=n(l),M(Ml.$$.fragment,l),Je=n(l),M(cl.$$.fragment,l),we=n(l),il=y(l,"P",{"data-svelte-h":!0}),d(il)!=="svelte-55obbg"&&(il.textContent=ns),Ue=n(l),M(u.$$.fragment,l),ue=n(l),M(rl.$$.fragment,l),Te=n(l),M(ml.$$.fragment,l),he=n(l),ol=y(l,"P",{"data-svelte-h":!0}),d(ol)!=="svelte-wubmmt"&&(ol.innerHTML=ps),fe=n(l),M(yl.$$.fragment,l),Ce=n(l),dl=y(l,"P",{"data-svelte-h":!0}),d(dl)!=="svelte-8f4nle"&&(dl.textContent=Ms),Ze=n(l),M(jl.$$.fragment,l),Ge=n(l),bl=y(l,"P",{"data-svelte-h":!0}),d(bl)!=="svelte-1jqk627"&&(bl.innerHTML=cs),Ie=n(l),Jl=y(l,"P",{"data-svelte-h":!0}),d(Jl)!=="svelte-yw9l7a"&&(Jl.innerHTML=is),$e=n(l),M(T.$$.fragment,l),ke=n(l),wl=y(l,"P",{"data-svelte-h":!0}),d(wl)!=="svelte-cz9ffq"&&(wl.textContent=rs),Be=n(l),M(Ul.$$.fragment,l),Xe=n(l),ul=y(l,"P",{"data-svelte-h":!0}),d(ul)!=="svelte-9sxezb"&&(ul.innerHTML=ms),We=n(l),M(Tl.$$.fragment,l),Re=n(l),hl=y(l,"P",{"data-svelte-h":!0}),d(hl)!=="svelte-14ydy5s"&&(hl.textContent=os),ge=n(l),M(fl.$$.fragment,l),ve=n(l),Cl=y(l,"P",{"data-svelte-h":!0}),d(Cl)!=="svelte-wi892w"&&(Cl.textContent=ys),_e=n(l),Zl=y(l,"P",{"data-svelte-h":!0}),d(Zl)!=="svelte-1mbq56y"&&(Zl.innerHTML=ds),Ve=n(l),M(Gl.$$.fragment,l),Ye=n(l),Il=y(l,"P",{"data-svelte-h":!0}),d(Il)!=="svelte-127l9y5"&&(Il.innerHTML=js),Ae=n(l),M($l.$$.fragment,l),ze=n(l),Bl=y(l,"P",{}),ws(Bl).forEach(s),this.h()},h(){Us(j,"name","hf:doc:metadata"),Us(j,"content",vs)},m(l,e){$s(document.head,j),t(l,w,e),t(l,J,e),t(l,U,e),c(h,l,e),t(l,Wl,e),c(f,l,e),t(l,Rl,e),c(C,l,e),t(l,gl,e),c(Z,l,e),t(l,vl,e),t(l,G,e),t(l,_l,e),c(I,l,e),t(l,Vl,e),c($,l,e),t(l,Yl,e),t(l,k,e),t(l,Al,e),t(l,B,e),t(l,zl,e),t(l,X,e),t(l,Nl,e),c(W,l,e),t(l,El,e),t(l,R,e),t(l,Fl,e),c(g,l,e),t(l,Ql,e),t(l,v,e),t(l,Hl,e),c(_,l,e),t(l,xl,e),t(l,V,e),t(l,Sl,e),c(Y,l,e),t(l,Ll,e),c(A,l,e),t(l,ql,e),t(l,z,e),t(l,Kl,e),t(l,N,e),t(l,Pl,e),c(E,l,e),t(l,Dl,e),t(l,F,e),t(l,Ol,e),c(Q,l,e),t(l,le,e),c(H,l,e),t(l,ee,e),t(l,x,e),t(l,se,e),t(l,S,e),t(l,te,e),c(L,l,e),t(l,ae,e),t(l,q,e),t(l,ne,e),c(K,l,e),t(l,pe,e),c(P,l,e),t(l,Me,e),c(D,l,e),t(l,ce,e),t(l,O,e),t(l,ie,e),c(ll,l,e),t(l,re,e),c(el,l,e),t(l,me,e),t(l,sl,e),t(l,oe,e),c(tl,l,e),t(l,ye,e),t(l,al,e),t(l,de,e),c(nl,l,e),t(l,je,e),t(l,pl,e),t(l,be,e),c(Ml,l,e),t(l,Je,e),c(cl,l,e),t(l,we,e),t(l,il,e),t(l,Ue,e),c(u,l,e),t(l,ue,e),c(rl,l,e),t(l,Te,e),c(ml,l,e),t(l,he,e),t(l,ol,e),t(l,fe,e),c(yl,l,e),t(l,Ce,e),t(l,dl,e),t(l,Ze,e),c(jl,l,e),t(l,Ge,e),t(l,bl,e),t(l,Ie,e),t(l,Jl,e),t(l,$e,e),c(T,l,e),t(l,ke,e),t(l,wl,e),t(l,Be,e),c(Ul,l,e),t(l,Xe,e),t(l,ul,e),t(l,We,e),c(Tl,l,e),t(l,Re,e),t(l,hl,e),t(l,ge,e),c(fl,l,e),t(l,ve,e),t(l,Cl,e),t(l,_e,e),t(l,Zl,e),t(l,Ve,e),c(Gl,l,e),t(l,Ye,e),t(l,Il,e),t(l,Ae,e),c($l,l,e),t(l,ze,e),t(l,Bl,e),Ne=!0},p(l,[e]){const bs={};e&2&&(bs.$$scope={dirty:e,ctx:l}),u.$set(bs);const Js={};e&2&&(Js.$$scope={dirty:e,ctx:l}),T.$set(Js)},i(l){Ne||(i(h.$$.fragment,l),i(f.$$.fragment,l),i(C.$$.fragment,l),i(Z.$$.fragment,l),i(I.$$.fragment,l),i($.$$.fragment,l),i(W.$$.fragment,l),i(g.$$.fragment,l),i(_.$$.fragment,l),i(Y.$$.fragment,l),i(A.$$.fragment,l),i(E.$$.fragment,l),i(Q.$$.fragment,l),i(H.$$.fragment,l),i(L.$$.fragment,l),i(K.$$.fragment,l),i(P.$$.fragment,l),i(D.$$.fragment,l),i(ll.$$.fragment,l),i(el.$$.fragment,l),i(tl.$$.fragment,l),i(nl.$$.fragment,l),i(Ml.$$.fragment,l),i(cl.$$.fragment,l),i(u.$$.fragment,l),i(rl.$$.fragment,l),i(ml.$$.fragment,l),i(yl.$$.fragment,l),i(jl.$$.fragment,l),i(T.$$.fragment,l),i(Ul.$$.fragment,l),i(Tl.$$.fragment,l),i(fl.$$.fragment,l),i(Gl.$$.fragment,l),i($l.$$.fragment,l),Ne=!0)},o(l){r(h.$$.fragment,l),r(f.$$.fragment,l),r(C.$$.fragment,l),r(Z.$$.fragment,l),r(I.$$.fragment,l),r($.$$.fragment,l),r(W.$$.fragment,l),r(g.$$.fragment,l),r(_.$$.fragment,l),r(Y.$$.fragment,l),r(A.$$.fragment,l),r(E.$$.fragment,l),r(Q.$$.fragment,l),r(H.$$.fragment,l),r(L.$$.fragment,l),r(K.$$.fragment,l),r(P.$$.fragment,l),r(D.$$.fragment,l),r(ll.$$.fragment,l),r(el.$$.fragment,l),r(tl.$$.fragment,l),r(nl.$$.fragment,l),r(Ml.$$.fragment,l),r(cl.$$.fragment,l),r(u.$$.fragment,l),r(rl.$$.fragment,l),r(ml.$$.fragment,l),r(yl.$$.fragment,l),r(jl.$$.fragment,l),r(T.$$.fragment,l),r(Ul.$$.fragment,l),r(Tl.$$.fragment,l),r(fl.$$.fragment,l),r(Gl.$$.fragment,l),r($l.$$.fragment,l),Ne=!1},d(l){l&&(s(w),s(J),s(U),s(Wl),s(Rl),s(gl),s(vl),s(G),s(_l),s(Vl),s(Yl),s(k),s(Al),s(B),s(zl),s(X),s(Nl),s(El),s(R),s(Fl),s(Ql),s(v),s(Hl),s(xl),s(V),s(Sl),s(Ll),s(ql),s(z),s(Kl),s(N),s(Pl),s(Dl),s(F),s(Ol),s(le),s(ee),s(x),s(se),s(S),s(te),s(ae),s(q),s(ne),s(pe),s(Me),s(ce),s(O),s(ie),s(re),s(me),s(sl),s(oe),s(ye),s(al),s(de),s(je),s(pl),s(be),s(Je),s(we),s(il),s(Ue),s(ue),s(Te),s(he),s(ol),s(fe),s(Ce),s(dl),s(Ze),s(Ge),s(bl),s(Ie),s(Jl),s($e),s(ke),s(wl),s(Be),s(Xe),s(ul),s(We),s(Re),s(hl),s(ge),s(ve),s(Cl),s(_e),s(Zl),s(Ve),s(Ye),s(Il),s(Ae),s(ze),s(Bl)),s(j),m(h,l),m(f,l),m(C,l),m(Z,l),m(I,l),m($,l),m(W,l),m(g,l),m(_,l),m(Y,l),m(A,l),m(E,l),m(Q,l),m(H,l),m(L,l),m(K,l),m(P,l),m(D,l),m(ll,l),m(el,l),m(tl,l),m(nl,l),m(Ml,l),m(cl,l),m(u,l),m(rl,l),m(ml,l),m(yl,l),m(jl,l),m(T,l),m(Ul,l),m(Tl,l),m(fl,l),m(Gl,l),m($l,l)}}}const vs='{"title":"一个完整的训练","local":"一个完整的训练","sections":[{"title":"训练前的准备","local":"训练前的准备","sections":[],"depth":2},{"title":"训练循环","local":"训练循环","sections":[],"depth":2},{"title":"评估循环","local":"评估循环","sections":[],"depth":2},{"title":"使用🤗 Accelerate 加速你的训练循环","local":"使用🤗 Accelerate加速你的训练循环","sections":[],"depth":2}],"depth":1}';function _s(kl){return Cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qs extends Zs{constructor(j){super(),Gs(this,j,_s,gs,fs,{})}}export{Qs as component};
