# Transformers 能做什么？[[Transformers 能做什么？]]

<CourseFloatingBanner chapter={1}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter1/section3.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter1/section3.ipynb"},
]} />


在本节中，我们将看看 Transformer 模型可以做什么，并使用 🤗 Transformers 库中的第一个工具： `pipeline()` 函数。

<Tip>

👀 看到那个右上角的在 Colab 中打开（Open in Colab）的按钮了吗？单击它就可以打开一个包含本节所有代码示例的 Google Colab Notebook 每一个有实例代码的小节都会有它。

如果你想在本地运行示例，我们建议你查看<a href="/course/chapter0">第 0 章</a>。

</Tip>

## Transformers 无处不在！[[Transformer 被应用于各个方面！]]

Transformer 模型用于解决各种 NLP 任务，就像上一节中提到的那样。以下是一些使用 Hugging Face 和 Transformer 模型的公司和组织，他们也通过分享他们的模型回馈社区：

<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/companies.PNG" alt="使用 Hugging Face 的公司" width="100%">

[🤗 Transformers 库](https://github.com/huggingface/transformers) 提供了创建和使用这些共享模型的功能。 [Hugging Face 模型中心（以下简称“Hub”）](https://huggingface.co/models) 包含数千个任何人都可以下载和使用的预训练模型。你还可以将自己的模型上传到 Hub！

<Tip>

⚠️ Hugging Face Hub 不限于 Transformer 模型。任何人都可以分享他们想要的任何类型的模型或数据集！创建一个 [Huggingface.co 帐户](https://huggingface.co/join) 即可使用所有可用功能！

</Tip>

在深入研究 Transformer 模型的底层工作原理之前，让我们先看几个示例，看看它们如何用于解决一些有趣的 NLP 问题。

## 使用 pipelines [[使用 pipelines]]

<Youtube id="tiZFewofSLM" />

🤗 Transformers 库中最基本的对象是 `pipeline()` 函数。它将模型与所需的预处理和后续处理步骤连接起来，使我们能够通过直接输入任何文本并获得最终的结果：

```python
from transformers import pipeline

classifier = pipeline("sentiment-analysis")
classifier("I've been waiting for a HuggingFace course my whole life.")
```
```python out
[{'label': 'POSITIVE', 'score': 0.9598047137260437}]

```

我们也可以多传几句！
```python
classifier(
    ["I've been waiting for a HuggingFace course my whole life.", "I hate this so much!"]
)
```
```python out
[{'label': 'POSITIVE', 'score': 0.9598047137260437},
 {'label': 'NEGATIVE', 'score': 0.9994558095932007}]
```
默认情况下，此 pipeline 加载选定的预训练模型，该模型已针对英语情感分析进行了微调。创建 `classifier` 对象时，模型将被下载和缓存。如果你重新运行该命令，则将使用缓存的模型，而无需再次下载模型。

将一些文本传递到 pipeline 时涉及三个主要步骤：

1. 文本被预处理为模型可以理解的格式。
2. 将预处理后的输入传递给模型。
3. 对模型的预测进行后续处理并输出最终人类可以理解的结果。

目前 [可用的一些pipeline](https://huggingface.co/transformers/main_classes/pipelines) 有：

* `eature-extraction` （获取文本的向量表示）
* `fill-mask` （完形填空）
* `ner` （命名实体识别）
* `question-answering` （问答）
* `sentiment-analysis` （情感分析）
* `summarization` （提取摘要）
* `text-generation` （文本生成）
* `translation` （翻译）
* `zero-shot-classification` （零样本分类）

让我们来看看其中的一些例子吧！

## 零样本分类 [[零样本分类]]

我们将从一个具挑战性的任务开始，我们需要对没有标签的文本进行分类。这是实际项目中的常见场景，因为给文本打标签通常很耗时并且需要领域专业知识。对于这项任务 `zero-shot-classification`。pipeline 非常强大：它允许你直接指定用于分类的标签，因此你不必依赖预训练模型的标签。下面的模型展示了如何使用这三个标签将句子分类为 `education（教育）` 、 `politics（政治）` 、或者 `business（商业）` —— 也可以使用你喜欢的任何其他标签集对文本进行分类。

```python
from transformers import pipeline

classifier = pipeline("zero-shot-classification")
classifier(
    "This is a course about the Transformers library",
    candidate_labels=["education", "politics", "business"],
)
```
```python out
{'sequence': 'This is a course about the Transformers library',
 'labels': ['education', 'business', 'politics'],
 'scores': [0.8445963859558105, 0.111976258456707, 0.043427448719739914]}
```

这个 pipeline 称为 `zero-shot` （零样本学习），因为你不需要对数据上的模型进行微调即可使用它。它可以直接返回你想要的任何标签列表的概率分数！

<Tip>

✏️**快来试试吧！**使用你自己的序列和标签，看看模型的表现如何。

</Tip>

## 文本生成 [[文本生成]]

让我们尝试一下另一个 pipeline，这次是用于生成文本的 `text-generation` 。这里的主要使用方法是你提供一些文本，模型将通过生成剩余的文本来自动补全整段话。这类似于许多手机上的预测文本功能。文本生成涉及随机性，因此如果你没有得到相同的如下所示的结果也是正常的。

```python
from transformers import pipeline

generator = pipeline("text-generation")
generator("In this course, we will teach you how to")
```
```python out
[{'generated_text': 'In this course, we will teach you how to understand and use '
                    'data flow and data interchange when handling user data. We '
                    'will be working with one or more of the most commonly used '
                    'data flows — data flows of various types, as seen by the '
                    'HTTP'}]
```
你可以使用参数 `num_return_sequences` 控制生成多少个不同的候选的句子，并使用参数 `max_length` 控制输出文本的总长度。

<Tip>

✏️**快来试试吧！**使用 `num_return_sequences` 和 `max_length` 参数生成两个句子，每个句子 15 个单词。

</Tip>

## 在 pipeline 中使用 Hub 中的其他模型 [[在 pipeline 中使用 Hub 中的其他模型]]

前面的示例使用了默认模型，但你也可以从 Hub 中选择一个特定模型，将其用于特定任务，例如文本生成。转到 [模型中心（hub）](https://huggingface.co/models) 并单击左侧的相应标签将会只显示该任务支持的模型。你应该看到一个 [模型筛选](https://huggingface.co/models?pipeline_tag=text-generation) 的页面。

让我们试试 [`distilgpt2`](https://huggingface.co/distilgpt2) 模型吧！以下面是在之前的 pipeline 中加载它的方法：

```python
from transformers import pipeline

generator = pipeline("text-generation", model="distilgpt2")
generator(
    "In this course, we will teach you how to",
    max_length=30,
    num_return_sequences=2,
)
```
```python out
[{'generated_text': 'In this course, we will teach you how to manipulate the world and '
                    'move your mental and physical capabilities to your advantage.'},
 {'generated_text': 'In this course, we will teach you how to become an expert and '
                    'practice realtime, and with a hands on experience on both real '
                    'time and real'}]
```

你可以通过单击语言标签来筛选搜索结果，然后选择另一种文本生成模型的模型。模型中心（hub）也包含了支持多种语言的多语言模型。

通过单击选择模型后，你会看到有一个小组件，可让你直接在线试用。通过这种方式，你可以在下载之前快速测试模型的功能。

<Tip>

✏️**快来试试吧！**使用标签筛选查找另一种语言的文本生成模型。使用小组件测试并在 pipeline 中使用它！

</Tip>

## 推理 API [[推理 API]]

所有模型都可以使用 Inference API 直接通过浏览器进行测试，该 API 可在 [Hugging Face 网站](https://huggingface.co/) 上找到。通过输入自定义文本并观察模型的输出，你可以直接在此页面上使用模型。

小组件形式的推理 API 也可作为付费产品使用，如果你的工作流程需要它，它会派上用场。有关更多详细信息，请参阅 [定价页面](https://huggingface.co/pricing) 。

## 完形填空 [[Mask filling]]

你将尝试的下一个 pipeline 是 `fill-mask` 。此任务的想法是填补给定文本中的空白：

```python
from transformers import pipeline

unmasker = pipeline("fill-mask")
unmasker("This course will teach you all about <mask> models.", top_k=2)
```
```python out
[{'sequence': 'This course will teach you all about mathematical models.',
  'score': 0.19619831442832947,
  'token': 30412,
  'token_str': ' mathematical'},
 {'sequence': 'This course will teach you all about computational models.',
  'score': 0.04052725434303284,
  'token': 38163,
  'token_str': ' computational'}]
```

 `top_k` 参数控制要显示的结果有多少种。请注意，这里模型填补了特殊的 `<mask>` 词，它通常被称为 `mask token` 。不同的 `mask-filling` 模型可能有不同的 `mask token` ，因此在探索其他模型时要验证正确的 `mask token` 是什么。检查它的一种方法是查看小组件中使用的 `mask token` 。

<Tip>

✏️**快来试试吧！**在 Hub 上搜索 `bert-base-cased` 模型并在推理 API 小组件中找到它的 mask token。对于上面 pipeline 示例中的句子，这个模型预测了什么？

</Tip>

## 命名实体识别 [[命名实体识别]]

命名实体识别 （NER） 是一项任务，其中模型必须找到输入文本的哪些部分对应于诸如人员、位置或组织之类的实体。让我们看一个例子：

```python
from transformers import pipeline

ner = pipeline("ner", grouped_entities=True)
ner("My name is Sylvain and I work at Hugging Face in Brooklyn.")
```
```python out
[{'entity_group': 'PER', 'score': 0.99816, 'word': 'Sylvain', 'start': 11, 'end': 18}, 
 {'entity_group': 'ORG', 'score': 0.97960, 'word': 'Hugging Face', 'start': 33, 'end': 45}, 
 {'entity_group': 'LOC', 'score': 0.99321, 'word': 'Brooklyn', 'start': 49, 'end': 57}
]
```

在这里，模型正确地识别出 Sylvain 是一个人 （PER），Hugging Face 是一个组织 （ORG），而布鲁克林是一个位置 （LOC）。

我们在创建 pipeline 的函数中传递的 `grouped_entities=True` 参数告诉 pipeline 将与同一实体对应的句子部分重新分组：这里模型正确地将“Hugging”和“Face”分组为一个组织，即使名称由多个词组成。事实上，正如我们即将在下一章看到的，预处理甚至会将一些单词分成更小的部分。例如， `Sylvain` 分割为了四部分： `S、##yl、##va` 和 `##in` 。在后处理步骤中，pipeline 成功地重新组合了这些部分。

<Tip>

✏️**快来试试吧！**在模型中心（hub）搜索能够用英语进行词性标注（通常缩写为 POS）的模型。对于上面示例中的句子，这个词性标注的模型预测了什么？

</Tip>

## 问答 [[问答]]

 `question-answering` pipeline 使用给定上下文中的信息回答问题：

```python
from transformers import pipeline

question_answerer = pipeline("question-answering")
question_answerer(
    question="Where do I work?",
    context="My name is Sylvain and I work at Hugging Face in Brooklyn",
)
```
```python out
{'score': 0.6385916471481323, 'start': 33, 'end': 45, 'answer': 'Hugging Face'}
```
请注意，这个 pipeline 通过从提供的上下文中提取信息来工作；它不会凭空生成答案。

## 提取摘要 [[文本摘要]]

提取摘要是将文本缩减为较短文本的任务，同时保留文本中所有（或大部分）主要（重要）的信息。下面是一个例子：

```python
from transformers import pipeline

summarizer = pipeline("summarization")
summarizer(
    """
    America has changed dramatically during recent years. Not only has the number of 
    graduates in traditional engineering disciplines such as mechanical, civil, 
    electrical, chemical, and aeronautical engineering declined, but in most of 
    the premier American universities engineering curricula now concentrate on 
    and encourage largely the study of engineering science. As a result, there 
    are declining offerings in engineering subjects dealing with infrastructure, 
    the environment, and related issues, and greater concentration on high 
    technology subjects, largely supporting increasingly complex scientific 
    developments. While the latter is important, it should not be at the expense 
    of more traditional engineering.

    Rapidly developing economies such as China and India, as well as other 
    industrial countries in Europe and Asia, continue to encourage and advance 
    the teaching of engineering. Both China and India, respectively, graduate 
    six and eight times as many traditional engineers as does the United States. 
    Other industrial countries at minimum maintain their output, while America 
    suffers an increasingly serious decline in the number of engineering graduates 
    and a lack of well-educated engineers.
"""
)
```
```python out
[{'summary_text': ' America has changed dramatically during recent years . The '
                  'number of engineering graduates in the U.S. has declined in '
                  'traditional engineering disciplines such as mechanical, civil '
                  ', electrical, chemical, and aeronautical engineering . Rapidly '
                  'developing economies such as China and India, as well as other '
                  'industrial countries in Europe and Asia, continue to encourage '
                  'and advance engineering .'}]
```

与文本生成一样，你指定结果的 `max_length` 或 `min_length` 。

## 翻译 [[翻译]]

对于翻译，如果你在任务名称中包含语言对（例如“ `translation_en_to_fr` ”），则可以使用默认模型，但最简单的方法是在 [模型中心（hub）](https://huggingface.co/models) 选择要使用的模型。在这里，我们将尝试从法语翻译成英语：

```python
from transformers import pipeline

translator = pipeline("translation", model="Helsinki-NLP/opus-mt-fr-en")
translator("Ce cours est produit par Hugging Face.")
```
```python out
[{'translation_text': 'This course is produced by Hugging Face.'}]

```

与文本生成和摘要一样，你可以指定结果的 `max_length` 或 `min_length` 。

<Tip>

✏️**快来试试吧！**搜索其他语言的翻译模型，尝试将前面的句子翻译成几种不同的语言。

</Tip>

到目前为止显示的 pipeline 主要用于演示目的。它们是为特定任务而定制的，不能对他们进行自定义的修改。在下一章中，你将了解 `pipeline()` 函数内部的过程以及如何进行自定义的修改。

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter1/3.mdx" />