# 自然語言處理

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

在進入 Transformer 模型之前，讓我們快速概述一下自然語言處理是什麼以及我們為什麼這麼重視它。

## 什麼是自然語言處理？

NLP 是語言學和機器學習交叉領域，專注於理解與人類語言相關的一切。 NLP 任務的目標不僅是單獨理解單個單詞，而且是能夠理解這些單詞的上下文。

以下是常見 NLP 任務的列表，每個任務都有一些示例：

- **對整個句子進行分類**: 獲取評論的情緒，檢測電子郵件是否為垃圾郵件，確定句子在語法上是否正確或兩個句子在邏輯上是否相關
- **對句子中的每個詞進行分類**: 識別句子的語法成分（名詞、動詞、形容詞）或命名實體（人、地點、組織）
- **生成文本內容**: 用自動生成的文本完成提示，用屏蔽詞填充文本中的空白
- **從文本中提取答案**: 給定問題和上下文，根據上下文中提供的信息提取問題的答案
- **從輸入文本生成新句子**: 將文本翻譯成另一種語言，總結文本

NLP 不僅限於書面文本。它還解決了語音識別和計算機視覺中的複雜挑戰，例如生成音頻樣本的轉錄或圖像描述。
## 為什麼具有挑戰性？

計算機處理信息的方式與人類不同。例如，當我們讀到「我餓了」這句話時，我們很容易理解它的意思。同樣，給定兩個句子，例如「我很餓」和「我很傷心」，我們可以輕鬆確定它們的相似程度。對於機器學習 (ML) 模型，此類任務更加困難。文本需要以一種使模型能夠從中學習的方式進行處理。而且由於語言很複雜，我們需要仔細考慮必須如何進行這種處理。關於如何表示文本已經做了很多研究，我們將在下一章中介紹一些方法。

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter1/2.mdx" />