# 章末小測試

<CourseFloatingBanner
    chapter={5}
    classNames="absolute z-10 right-0 top-0"
/>

本章涵蓋了很多方面! 如果你沒有掌握所有細節, 不用擔心; 在下一章將幫助你瞭解內部的事情是如何工作的。

不過, 在繼續下一章之前, 讓我們測試一下你在本章學到的內容。

### 1.🤗 Datasets中的 `load_dataset ()` 函數允許你從下列哪個位置加載數據集？
<Question
	choices={[
		{
			text: "在本地，例如在你的筆記本電腦上",
			explain: "正確！ 你可以將本地文件的路徑傳遞給 <code>load_dataset()</code> 函數的 <code>data_files</code> 參數來加載本地數據集。",
			correct: true
		},
		{
			text: "Hugging Face Hub",
			explain: "正確! 你可以通過提供數據集 ID 在 Hub 上加載數據集, 例如 < code > load _ dataset ('em otion') </code > 。",
			correct: true
		},
		{
			text: "遠程服務器",
			explain: "正確！ 你可以將URL傳遞給 <code>load_dataset()</code> 函數的 <code>data_files</code> 參數來加載遠程文件。",
			correct: true
		},
	]}
/>

### 2.假設您加載了 GLUE 任務，如下所示:
```py
from datasets import load_dataset

dataset = load_dataset("glue", "mrpc", split="train")
```

以下哪個命令將從 `dataset` 中生成50個元素的隨機樣本?

<Question
	choices={[
		{
			text: "< 代碼 > dataset.sample (50) </code >",
			explain: "這是不正確的——沒有 < code > Dataset.sample () </code > 方法。"
		},
		{
			text: "<code>dataset.shuffle().select(range(50))</code>",
			explain: "正確！ 正如你在本章中看待的, 你首先打亂了數據集, 然後從中選擇樣本。",
			correct: true
		},
		{
			text: "<code>dataset.select(range(50)).shuffle()</code>",
			explain: "這是不正確的——儘管代碼會運行, 但它只會隨機處理數據集中的前50個元素。"
		}
	]}
/>

### 3.假設你有一個叫做寵物數據集的家庭寵物數據集，它有一個名字列表示每個寵物的名字。下列哪種方法可以讓你過濾所有名字以字母"L"開頭的寵物的數據？
<Question
	choices={[
		{
			text: "< code > pets _ dataset. filter (lambda x: x ['name'] . startswith ('L')) </code >",
			explain: "正確! 為這些快速過濾使用 Python lambda 函數是一個好主意。你還能想到其他解決方案嗎？",
			correct: true
		},
		{
			text: "< code > pets _ dataset. filter (lambda x ['name'] . startswith ('L') </code >",
			explain: "這是不正確的—— lambda 函數採用通用格式 < code > lambda * arguments * : * expression * </code >, 因此在這種情況下需要提供參數。"
		},
		{
			text: "創建一個類似於 < code > def filter _ names (x) : return x ['name'] . startswith ('L') </code > 的函數並運行 < code > pets _ dataset. filter (filter _ names) </code > 。",
			explain: "正確！就像使用 < code > Dataset.map () </code > 一樣，你可以將顯式函數傳遞給 < code > Dataset.filter () </code > 。當你有一些不適合於簡短 lambda 函數的複雜邏輯時，這是非常有用的。其他解決方案中還有哪一個可行？",
			correct: true
		}
	]}
/>

### 4.什麼是內存映射？
<Question
	choices={[
		{
			text: "CPU 與 GPU RAM 之間的映射",
			explain: "不是這樣的---- 再試一次！",
		},
		{
			text: "RAM 和文件系統存儲之間的映射",
			explain: "正確！🤗 Datasets 將每個數據集視為一個內存映射文件。這允許庫訪問和操作數據集的元素，而無需將其完全加載到內存中。",
			correct: true
		},
		{
			text: "🤗 Datasets緩存中兩個文件之間的映射",
			explain: "這是不正確的-再試一次！"
		}
	]}
/>

### 5.下列哪一項是內存映射的主要好處？
<Question
	choices={[
		{
			text: "訪問內存映射文件比從磁盤讀取或寫入磁盤更快。",
			explain: "正確! 這使得🤗 Datasets 可以快速傳輸，但這並不是唯一的好處。",
			correct: true
		},
		{
			text: "應用程序可以訪問一個非常大的文件中的數據段，而不必首先將整個文件讀入 RAM。",
			explain: "正確! ——這允許🤗Datasets在你的筆記本電腦上加載多個GB的數據集, 而不消耗你的CPU。內存映射還提供了什麼其他優勢?",
			correct: true
		},
		{
			text: "它消耗更少的能量，所以你的電池持續時間更長。",
			explain: "這是不正確的——再試一次！"
		}
	]}
/>

### 6.為什麼下面的代碼是錯誤的？
```py
from datasets import load_dataset

dataset = load_dataset("allocine", streaming=True, split="train")
dataset[0]
```

<Question
	choices={[
		{
			text: "它試圖對一個太大而無法放入 RAM 的數據集進行流式處理。",
			explain: "這是不正確的---- 流數據集是動態解壓的, 你可以用非常小的RAM處理TB大小的數據集!",
		},
		{
			text: "它嘗試訪問 < code > IterableDataset </code > 。",
			explain: "正確! < code > IterableDataset </code > 是一個生成器, 而不是一個容器, 因此你應該使用 < code > next (iter (dataset)) </code > 來訪問它的元素。",
			correct: true
		},
		{
			text: "數據集 < code > allocine </code > 沒有分割< code >訓練集</code >。",
			explain: "這是不正確的---- 查看 Hub 上的[ < code > allocine </code > dataset card ]( https://huggingface.co/datasets/allocine ), 看看它包含哪些拆分。"
		}
	]}
/>

### 7.創建數據集卡的主要好處是什麼？
<Question
	choices={[
		{
			text: "它提供了關於數據集的預期用途和支持的任務的信息，以便社區中的其他人可以對使用它做出明智的決定。",
			explain: "正確！ 未記錄的數據集可用於訓練可能無法反映數據集創建者意圖的模型, 或者如果對違反隱私或許可限制的數據進行訓練, 則可能會產生法律狀態模糊的模型。不過, 這並不是唯一的好處!",
			correct : true
		},
		{
			text: "它有助於引起人們對語料庫中存在的偏見的注意。",
			explain: "正確！ 幾乎所有數據集都存在某種形式的偏差, 這可能會產生負面的後果。瞭解它們有助於模型構建著瞭解如何解決固有的偏見。數據集卡還有什麼幫助？",
			correct : true
		},
		{
			text: "它提高了社區中其他人使用我的數據集的機會。",
			explain: "正確！一個編寫良好的數據集卡片會帶來更高的寶貴的數據集使用率。它還提供什麼其他好處？",
			correct: true
		},
	]}
/>


### 8.什麼是語義搜索？
<Question
	choices={[
		{
			text: "一種在查詢中的單詞和語料庫中的文檔之間搜索精確匹配的方法",
			explain: "這是不正確的---這種類型的搜索被稱為“詞彙搜索”，這是你通常在傳統搜索引擎中可以看到的。"
		},
		{
			text: "一種通過理解查詢的上下文含義來搜索匹配文檔的方法",
			explain: "正確！ 語義搜索使用嵌入向量來表示查詢和文檔，並使用相似度度量來衡量它們之間的重疊量。你還能怎麼形容它？",
			correct: true
		},
		{
			text: "一種提高搜索準確性的方法",
			explain: "正確！語義搜索引擎能夠比關鍵字匹配更好地捕獲查詢意圖，並且通常能夠以更高的精度檢索文檔。但這不是唯一正確的答案——語義搜索還能提供什麼？",
			correct: true
		}
	]}
/>

### 9.對於非對稱語義搜索，通常有:
<Question
	choices={[
		{
			text: "一個簡短的查詢和一個較長的段落回答查詢",
			explain: "正確！",
			correct : true
		},
		{
			text: "相同長度的查詢和段落",
			explain: "這實際上是一個對稱語義搜索的例子——再試一次！"
		},
		{
			text: "一個較長的查詢和一個較短的段落來回答查詢",
			explain: "這是錯誤的---- 再試一次！"
		}
	]}
/>

### 10.我可以使用數據集加載數據用於其他領域，如語音處理？
<Question
	choices={[
		{
			text: "沒有",
			explain: "正確！🤗 Datasets目前支持表格數據、音頻和計算機視覺。查看[MNIST]( https://huggingface.co/datasets/allocine )數據集以獲取計算機視覺示例。"
		},
		{
			text: "是的",
			explain: "正確！查看令人興奮的發展與語音和視覺在🤗 Transformers庫，看看🤗 Datasets是如何使用這些領域。",
			correct : true
		},
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter5/8.mdx" />