# 章末測評

讓我們測試一下你在本章學到的東西!

### 1.應該按照什麼順序讀取 Python 回溯？
<Question
	choices={[
		{
			text: "從上到下",
			explain: "再試一次——儘管大多數其他編程語言在頂部打印異常，但 Python 在這方面是特殊的。"
		},
		{
			text: "自下而上",
			explain: "正確！在底部顯示異常的 Python 回溯的一個優點是，在終端中工作時更容易調試，這是你看到的最後一行。",
			correct: true
		}
	]}
/>

### 2.什麼是最小可再生示例？
<Question
	choices={[
		{
			text: "來自一篇研究文章一個簡單的 Transformer 體系結構的實現",
			explain: "雖然從頭開始實現你自己的 Transformer 模型是非常有教育意義的，但這不是我們在這裡討論的內容。"
		},
		{
			text: "一種緊湊且自包含的代碼塊，可以在不依賴於私有文件或數據的情況下運行",
			explain: "正確！查看你的數據幾乎總是你應該做的第一件事，以確保文本被適當地編碼，具有預期的特性，等等。",
			correct: true
		},
		{
			text: "Python 回溯的屏幕截圖",
			explain: "再試一次 -- 儘管在提交問題時, 很容易包含您所面臨錯誤的屏幕截圖, 但這使得其他人很難重現錯誤。"
		},
		{
			text: "一個記錄整個分析的筆記本，包括與錯誤無關的部分",
			explain: "不完全 -- 儘管共享一個顯示錯誤的GoogleColab筆記本會很有幫助, 但要確保它簡短, 並且只包含相關代碼。 "
		}
	]}
/>

### 3.假設你嘗試運行以下代碼，它拋出一個錯誤:
```py
from transformers import GPT3ForSequenceClassification

# ImportError: cannot import name 'GPT3ForSequenceClassification' from 'transformers' (/Users/lewtun/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/__init__.py)
# ---------------------------------------------------------------------------
# ImportError                               Traceback (most recent call last)
# /var/folders/28/k4cy5q7s2hs92xq7_h89_vgm0000gn/T/ipykernel_30848/333858878.py in <module>
# ----> 1 from transformers import GPT3ForSequenceClassification

# ImportError: cannot import name 'GPT3ForSequenceClassification' from 'transformers' (/Users/lewtun/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/__init__.py)
```

以下哪項可能是論壇主題標題尋求幫助的好選擇?

<Question
	choices={[
		{
			text: "導入錯誤:無法從'transformers'導入名稱'GPT3GPT3ForSequenceClassification'(/Users/lewtun/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/_ init _. py) ",
			explain: "包含回溯的最後一行可以是描述性的，但這最好保留給主題的主體部分。再試一次！"
		},
		{
			text: "從transformers導入 gpt3forsequeclassification 時出現問題",
			explain: "再試一次——儘管這提供了有用的信息，但最好還是保留在文本的主體部分。",
		},
		{
			text: "為什麼我不能導入 < code > GPT3ForSequenceClassification </code > ?",
			explain: "不錯的選擇！這個標題是簡潔的，並給讀者一個線索，什麼可能是錯誤的(即,gpt-3不支持在🤗 Transformers)。",
			correct: true
		},
		{
			text: "Gpt-3在🤗 Transformers中支持嗎?",
			explain: "好主意! 用問題作為主題標題是向社區傳達問題的好方法。",
			correct: true
		}
	]}
/>

### 4.假設您試圖運行 'trainer.train ()'，但是遇到了一個神秘的錯誤，這個錯誤不能準確地告訴您錯誤來自哪裡。下列哪一項是您應該首先在您的培訓管道中尋找錯誤的地方？
<Question
	choices={[
		{
			text: "計算梯度並執行反向傳播的優化步驟",
			explain: "儘管優化器中可能存在缺陷, 但這通常是訓練管道中的幾個步驟, 因此首先要檢查其他事項。再試一次!"
		},
		{
			text: "計算度量的評估步驟",
			explain: "評估通常是在整個訓練期結束後進行的, 因此你應該首先在訓練管道的早期檢查某個地方。",
		},
		{
			text: "數據集",
			explain: "正確的!查看數據幾乎總是您應該做的第一件事, 以確保文本進行了適當的編碼, 具有預期的特性, 等等。",
			correct: true
		},
		{
			text: "數據記錄器",
			explain: "再試一次---- 這非常接近你應該檢查的第一件事。你還記得我們交給數據收集者的是什麼東西嗎？"
		}
	]}
/>

### 5.調試 CUDA 錯誤的最好方法是什麼？
<Question
	choices={[
		{
			text: "在論壇或 GitHub 上發佈錯誤消息。",
			explain: "這不會幫助任何人, 因為 CUDA 的錯誤信息通常是非常沒有信息。"
		},
		{
			text: "在 CPU 上執行相同的代碼。",
			explain: "沒錯, 這應該會給你一個更好的錯誤消息!",
			correct: true
		},
		{
			text: "請閱讀回溯以找出錯誤的原因。",
			explain: "對於任何其他錯誤, 你都會這樣做, 但CUDA錯誤通常不會在發生的地方引發, 因為大多數CUDA操作都是異步的。"
		},
		{
			text: "減少批量。",
			explain: "減少批處理大小通常是處理CUDA內存不足錯誤的一個好策略, 但不是為這個特定的問題。再試一次！"
		},
		{
			text: "重新啟動 Jupyter 內核。",
			explain: "再試一次——重新啟動內核不會讓錯誤神奇地消失！",
		}
	]}
/>

### 6.修復 GitHub 上的問題最好的方法是什麼？
<Question
	choices={[
		{
			text: "發佈這個 bug 的完整可重複的例子。",
			explain: "是的，這是幫助維護人員找到 bug 的最好方法。你還應該做什麼？？",
			correct: true
		},
		{
			text: "每天要求更新。",
			explain: "這不太可能給你任何幫助；人們可能會更忽視你。",
		},
		{
			text: "檢查錯誤周圍的源代碼，並試圖找出錯誤發生的原因。在這期雜誌上發佈結果。",
			explain: "這肯定會對維護人員有幫助！如果您確實找到了 bug 的來源和修復程序, 甚至可以打開一個 pull 請求。你還應該做些什麼？",
			correct: true
		}
	]}
/>

### 7.為什麼對一個批處理進行過度調試通常是一種好的調試技術？
<Question
	choices={[
		{
			text: "不是這樣的, 過分合身總是不好的, 應該避免。",
			explain: "當對整個數據集進行訓練時, 過度擬合確實可能是一個信號, 表明你的模型不能很好地推廣到新的示例。但是, 對於調試, 我們通常不會對整個數據集進行訓練。再試一次！"
		},
		{
			text: "這使我們能夠驗證該模型能夠將損耗降低到零。",
			explain: "正確! 只需要兩個樣本的小批量, 我們就可以快速驗證模型是否具有學習能力。",
			correct: true
		},
		{
			text: "它允許我們驗證我們輸入和標籤的張量形狀是正確的。",
			explain: "再試一次 -- 如果你的張量形狀不對齊, 那麼你肯定不能訓練, 即使是一批。",
		}
	]}
/>

### 8.為什麼在 🤗 Transformers 存儲庫中創建新問題時，使用 transformers-cli env 包含有關計算環境的詳細信息是個好主意？
<Question
	choices={[
		{
			text: "它允許維護人員理解你正在使用的庫的哪個版本。",
			explain: "正確! 由於庫的每個主要版本在API中都可能有更改, 因此瞭解您正在使用的特定版本有助於縮小問題範圍。其他好處是什麼?",
			correct: true
		},
		{
			text: "它讓維護人員知道你是在 Windows、 macOS 還是 Linux 上運行代碼。",
			explain: "正確！錯誤有時可能是由你正在使用的特定操作系統引起的, 瞭解這一點有助於維護人員在本地複製這些錯誤。但這並不是唯一的原因。",
			correct: true
		},
		{
			text: "它允許維護人員知道你是在 GPU 還是 CPU 上運行代碼。",
			explain: "正確! 正如我們在本章中看到的, gpu 和 cpu 上的錯誤在風格上可能有很大的不同, 瞭解您正在使用的硬件可以幫助集中維護人員的注意力。但這不是唯一的好處...",
		}
	]}
/>

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter8/7.mdx" />