import{s as Ke,o as Oe}from"../chunks/scheduler.6062bdaf.js";import{S as et,i as tt,g as i,s as n,r as m,A as lt,h as s,f as l,c as o,j as Se,u as p,x as d,k as De,y as at,a,v as u,d as f,t as h,w as c,m as nt,n as ot}from"../chunks/index.4bca734e.js";import{T as it}from"../chunks/Tip.b9ac1f03.js";import{C as D}from"../chunks/CodeBlock.fa01571c.js";import{H as M}from"../chunks/Heading.723dceba.js";function st(K){let r;return{c(){r=nt("GPTQ quantization only works for text model for now. Futhermore, the quantization process can take a lot of time depending on one's hardware (175B model = 4 gpu hours using NVIDIA A100). Please check on the Hugging Face Hub if there is not already a GPTQ quantized version of the model you would like to quantize.")},l(b){r=ot(b,"GPTQ quantization only works for text model for now. Futhermore, the quantization process can take a lot of time depending on one's hardware (175B model = 4 gpu hours using NVIDIA A100). Please check on the Hugging Face Hub if there is not already a GPTQ quantized version of the model you would like to quantize.")},m(b,w){a(b,r,w)},d(b){b&&l(r)}}}function dt(K){let r,b,w,O,_,ee,g,te,$,Re='🤗 Optimum collaborated with <a href="https://github.com/PanQiWei/AutoGPTQ" rel="nofollow">AutoGPTQ library</a> to provide a simple API that apply GPTQ quantization on language models. With GPTQ quantization, you can quantize your favorite language model to 8, 4, 3 or even 2 bits. This comes without a big drop of performance and with faster inference speed. This is supported by most GPU hardwares.',le,T,Xe='If you want to quantize 🤗 Transformers models with GPTQ, follow this <a href="https://huggingface.co/docs/transformers/main_classes/quantization" rel="nofollow">documentation</a>.',ae,v,Ce="To learn more about the quantization technique used in GPTQ, please refer to:",ne,k,We='<li>the <a href="https://arxiv.org/pdf/2210.17323.pdf" rel="nofollow">GPTQ</a> paper</li> <li>the <a href="https://github.com/PanQiWei/AutoGPTQ" rel="nofollow">AutoGPTQ</a> library used as the backend</li>',oe,Z,Ue="Note that the AutoGPTQ library provides more advanced usage (triton backend, fused attention, fused MLP) that are not integrated with Optimum. For now, we leverage only the CUDA kernel for GPTQ.",ie,q,se,z,Je="You need to have the following requirements installed to run the code below:",de,j,Qe=`<li><p>AutoGPTQ library:
<code>pip install auto-gptq</code></p></li> <li><p>Optimum library:
<code>pip install --upgrade optimum</code></p></li> <li><p>Install latest <code>transformers</code> library from source:
<code>pip install --upgrade git+https://github.com/huggingface/transformers.git</code></p></li> <li><p>Install latest <code>accelerate</code> library:
<code>pip install --upgrade accelerate</code></p></li>`,re,F,me,G,He="The <code>GPTQQuantizer</code> class is used to quantize your model. In order to quantize your model, you need to provide a few arguemnts:",pe,R,xe="<li>the number of bits: <code>bits</code></li> <li>the dataset used to calibrate the quantization: <code>dataset</code></li> <li>the model sequence length used to process the dataset: <code>model_seqlen</code></li> <li>the block name to quantize: <code>block_name_to_quantize</code></li>",ue,X,Ve="With 🤗 Transformers integration, you don’t need to pass the <code>block_name_to_quantize</code> and <code>model_seqlen</code> as we can retrieve them. However, for custom model, you need to specify them. Also, make sure that your model is converted to <code>torch.float16</code> before quantization.",fe,C,he,y,ce,W,be,U,Ee="To save your model, use the save method from <code>GPTQQuantizer</code> class. It will create a folder with your model state dict along with the quantization config.",ye,J,Me,Q,we,H,Be=`You can load your quantized weights by using the <code>load_quantized_model()</code> function.
Through the Accelerate library, it is possible to load a model faster with a lower memory usage. The model needs to be initialized using empty weights, with weights loaded as a next step.`,_e,x,ge,V,$e,E,Pe="With the release of exllamav2 kernels, you can get faster inference speed compared to exllama kernels for 4-bit model. It is activated by default: <code>disable_exllamav2=False</code> in <code>load_quantized_model()</code>. In order to use these kernels, you need to have the entire model on gpus.",Te,B,ve,P,Ie="If you wish to use exllama kernels, you will have to change the version by setting <code>exllama_config</code>:",ke,I,Ze,L,Le="Note that only 4-bit models are supported with exllama/exllamav2 kernels for now. Furthermore, it is recommended to disable exllama/exllamav2 kernels when you are finetuning your model with peft.",qe,A,Ae='You can find the benchmark of these kernels <a href="https://github.com/huggingface/optimum/tree/main/tests/benchmark#gptq-benchmark" rel="nofollow">here</a>',ze,Y,je,N,Ye=`With the official support of adapters in the Hugging Face ecosystem, you can fine-tune models that have been quantized with GPTQ.
Please have a look at <a href="https://github.com/huggingface/peft" rel="nofollow"><code>peft</code></a> library for more details.`,Fe,S,Ge;return _=new M({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),g=new M({props:{title:"AutoGPTQ Integration",local:"autogptq-integration",headingTag:"h2"}}),q=new M({props:{title:"Requirements",local:"requirements",headingTag:"h3"}}),F=new M({props:{title:"Load and quantize a model",local:"load-and-quantize-a-model",headingTag:"h3"}}),C=new D({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBvcHRpbXVtLmdwdHElMjBpbXBvcnQlMjBHUFRRUXVhbnRpemVyJTJDJTIwbG9hZF9xdWFudGl6ZWRfbW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0xMjVtJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQXF1YW50aXplciUyMCUzRCUyMEdQVFFRdWFudGl6ZXIoYml0cyUzRDQlMkMlMjBkYXRhc2V0JTNEJTIyYzQlMjIlMkMlMjBibG9ja19uYW1lX3RvX3F1YW50aXplJTIwJTNEJTIwJTIybW9kZWwuZGVjb2Rlci5sYXllcnMlMjIlMkMlMjBtb2RlbF9zZXFsZW4lMjAlM0QlMjAyMDQ4KSUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMHF1YW50aXplci5xdWFudGl6ZV9tb2RlbChtb2RlbCUyQyUyMHRva2VuaXplcik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> optimum.gptq <span class="hljs-keyword">import</span> GPTQQuantizer, load_quantized_model
<span class="hljs-keyword">import</span> torch
model_name = <span class="hljs-string">&quot;facebook/opt-125m&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_name)
model = AutoModelForCausalLM.from_pretrained(model_name, torch_dtype=torch.float16)

quantizer = GPTQQuantizer(bits=<span class="hljs-number">4</span>, dataset=<span class="hljs-string">&quot;c4&quot;</span>, block_name_to_quantize = <span class="hljs-string">&quot;model.decoder.layers&quot;</span>, model_seqlen = <span class="hljs-number">2048</span>)
quantized_model = quantizer.quantize_model(model, tokenizer)`,wrap:!1}}),y=new it({props:{warning:!0,$$slots:{default:[st]},$$scope:{ctx:K}}}),W=new M({props:{title:"Save the model",local:"save-the-model",headingTag:"h3"}}),J=new D({props:{code:"c2F2ZV9mb2xkZXIlMjAlM0QlMjAlMjIlMkZwYXRoJTJGdG8lMkZzYXZlX2ZvbGRlciUyRiUyMiUwQXF1YW50aXplci5zYXZlKG1vZGVsJTJDc2F2ZV9mb2xkZXIp",highlighted:`save_folder = <span class="hljs-string">&quot;/path/to/save_folder/&quot;</span>
quantizer.save(model,save_folder)`,wrap:!1}}),Q=new M({props:{title:"Load quantized weights",local:"load-quantized-weights",headingTag:"h3"}}),x=new D({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEF3aXRoJTIwaW5pdF9lbXB0eV93ZWlnaHRzKCklM0ElMEElMjAlMjAlMjAlMjBlbXB0eV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQWVtcHR5X21vZGVsLnRpZV93ZWlnaHRzKCklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBsb2FkX3F1YW50aXplZF9tb2RlbChlbXB0eV9tb2RlbCUyQyUyMHNhdmVfZm9sZGVyJTNEc2F2ZV9mb2xkZXIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">with</span> init_empty_weights():
    empty_model = AutoModelForCausalLM.from_pretrained(model_name, torch_dtype=torch.float16)
empty_model.tie_weights()
quantized_model = load_quantized_model(empty_model, save_folder=save_folder, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),V=new M({props:{title:"Exllama kernels for faster inference",local:"exllama-kernels-for-faster-inference",headingTag:"h3"}}),B=new D({props:{code:"ZnJvbSUyMG9wdGltdW0uZ3B0cSUyMGltcG9ydCUyMEdQVFFRdWFudGl6ZXIlMkMlMjBsb2FkX3F1YW50aXplZF9tb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEF3aXRoJTIwaW5pdF9lbXB0eV93ZWlnaHRzKCklM0ElMEElMjAlMjAlMjAlMjBlbXB0eV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQWVtcHR5X21vZGVsLnRpZV93ZWlnaHRzKCklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBsb2FkX3F1YW50aXplZF9tb2RlbChlbXB0eV9tb2RlbCUyQyUyMHNhdmVfZm9sZGVyJTNEc2F2ZV9mb2xkZXIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> optimum.gptq <span class="hljs-keyword">import</span> GPTQQuantizer, load_quantized_model
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">with</span> init_empty_weights():
    empty_model = AutoModelForCausalLM.from_pretrained(model_name, torch_dtype=torch.float16)
empty_model.tie_weights()
quantized_model = load_quantized_model(empty_model, save_folder=save_folder, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),I=new D({props:{code:"ZnJvbSUyMG9wdGltdW0uZ3B0cSUyMGltcG9ydCUyMEdQVFFRdWFudGl6ZXIlMkMlMjBsb2FkX3F1YW50aXplZF9tb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEF3aXRoJTIwaW5pdF9lbXB0eV93ZWlnaHRzKCklM0ElMEElMjAlMjAlMjAlMjBlbXB0eV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQWVtcHR5X21vZGVsLnRpZV93ZWlnaHRzKCklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBsb2FkX3F1YW50aXplZF9tb2RlbChlbXB0eV9tb2RlbCUyQyUyMHNhdmVfZm9sZGVyJTNEc2F2ZV9mb2xkZXIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMGV4bGxhbWFfY29uZmlnJTIwJTNEJTIwJTdCJTIydmVyc2lvbiUyMiUzQTElN0Qp",highlighted:`<span class="hljs-keyword">from</span> optimum.gptq <span class="hljs-keyword">import</span> GPTQQuantizer, load_quantized_model
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">with</span> init_empty_weights():
    empty_model = AutoModelForCausalLM.from_pretrained(model_name, torch_dtype=torch.float16)
empty_model.tie_weights()
quantized_model = load_quantized_model(empty_model, save_folder=save_folder, device_map=<span class="hljs-string">&quot;auto&quot;</span>, exllama_config = {<span class="hljs-string">&quot;version&quot;</span>:<span class="hljs-number">1</span>})`,wrap:!1}}),Y=new M({props:{title:"Fine-tune a quantized model",local:"fine-tune-a-quantized-model",headingTag:"h4"}}),{c(){r=i("meta"),b=n(),w=i("p"),O=n(),m(_.$$.fragment),ee=n(),m(g.$$.fragment),te=n(),$=i("p"),$.innerHTML=Re,le=n(),T=i("p"),T.innerHTML=Xe,ae=n(),v=i("p"),v.textContent=Ce,ne=n(),k=i("ul"),k.innerHTML=We,oe=n(),Z=i("p"),Z.textContent=Ue,ie=n(),m(q.$$.fragment),se=n(),z=i("p"),z.textContent=Je,de=n(),j=i("ul"),j.innerHTML=Qe,re=n(),m(F.$$.fragment),me=n(),G=i("p"),G.innerHTML=He,pe=n(),R=i("ul"),R.innerHTML=xe,ue=n(),X=i("p"),X.innerHTML=Ve,fe=n(),m(C.$$.fragment),he=n(),m(y.$$.fragment),ce=n(),m(W.$$.fragment),be=n(),U=i("p"),U.innerHTML=Ee,ye=n(),m(J.$$.fragment),Me=n(),m(Q.$$.fragment),we=n(),H=i("p"),H.innerHTML=Be,_e=n(),m(x.$$.fragment),ge=n(),m(V.$$.fragment),$e=n(),E=i("p"),E.innerHTML=Pe,Te=n(),m(B.$$.fragment),ve=n(),P=i("p"),P.innerHTML=Ie,ke=n(),m(I.$$.fragment),Ze=n(),L=i("p"),L.textContent=Le,qe=n(),A=i("p"),A.innerHTML=Ae,ze=n(),m(Y.$$.fragment),je=n(),N=i("p"),N.innerHTML=Ye,Fe=n(),S=i("p"),this.h()},l(e){const t=lt("svelte-u9bgzb",document.head);r=s(t,"META",{name:!0,content:!0}),t.forEach(l),b=o(e),w=s(e,"P",{}),Se(w).forEach(l),O=o(e),p(_.$$.fragment,e),ee=o(e),p(g.$$.fragment,e),te=o(e),$=s(e,"P",{"data-svelte-h":!0}),d($)!=="svelte-ugzxpc"&&($.innerHTML=Re),le=o(e),T=s(e,"P",{"data-svelte-h":!0}),d(T)!=="svelte-1uwtkai"&&(T.innerHTML=Xe),ae=o(e),v=s(e,"P",{"data-svelte-h":!0}),d(v)!=="svelte-1ruo6q2"&&(v.textContent=Ce),ne=o(e),k=s(e,"UL",{"data-svelte-h":!0}),d(k)!=="svelte-kq5zxq"&&(k.innerHTML=We),oe=o(e),Z=s(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1p4dqk2"&&(Z.textContent=Ue),ie=o(e),p(q.$$.fragment,e),se=o(e),z=s(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-3chw6d"&&(z.textContent=Je),de=o(e),j=s(e,"UL",{"data-svelte-h":!0}),d(j)!=="svelte-bd9wx0"&&(j.innerHTML=Qe),re=o(e),p(F.$$.fragment,e),me=o(e),G=s(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1mwd8qr"&&(G.innerHTML=He),pe=o(e),R=s(e,"UL",{"data-svelte-h":!0}),d(R)!=="svelte-1gnh4h2"&&(R.innerHTML=xe),ue=o(e),X=s(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1palewv"&&(X.innerHTML=Ve),fe=o(e),p(C.$$.fragment,e),he=o(e),p(y.$$.fragment,e),ce=o(e),p(W.$$.fragment,e),be=o(e),U=s(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-o4ss2s"&&(U.innerHTML=Ee),ye=o(e),p(J.$$.fragment,e),Me=o(e),p(Q.$$.fragment,e),we=o(e),H=s(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-1x9uzwt"&&(H.innerHTML=Be),_e=o(e),p(x.$$.fragment,e),ge=o(e),p(V.$$.fragment,e),$e=o(e),E=s(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-12tew79"&&(E.innerHTML=Pe),Te=o(e),p(B.$$.fragment,e),ve=o(e),P=s(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-m8dfkf"&&(P.innerHTML=Ie),ke=o(e),p(I.$$.fragment,e),Ze=o(e),L=s(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1wjtw1l"&&(L.textContent=Le),qe=o(e),A=s(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-fpw9ll"&&(A.innerHTML=Ae),ze=o(e),p(Y.$$.fragment,e),je=o(e),N=s(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1rghhrt"&&(N.innerHTML=Ye),Fe=o(e),S=s(e,"P",{}),Se(S).forEach(l),this.h()},h(){De(r,"name","hf:doc:metadata"),De(r,"content",rt)},m(e,t){at(document.head,r),a(e,b,t),a(e,w,t),a(e,O,t),u(_,e,t),a(e,ee,t),u(g,e,t),a(e,te,t),a(e,$,t),a(e,le,t),a(e,T,t),a(e,ae,t),a(e,v,t),a(e,ne,t),a(e,k,t),a(e,oe,t),a(e,Z,t),a(e,ie,t),u(q,e,t),a(e,se,t),a(e,z,t),a(e,de,t),a(e,j,t),a(e,re,t),u(F,e,t),a(e,me,t),a(e,G,t),a(e,pe,t),a(e,R,t),a(e,ue,t),a(e,X,t),a(e,fe,t),u(C,e,t),a(e,he,t),u(y,e,t),a(e,ce,t),u(W,e,t),a(e,be,t),a(e,U,t),a(e,ye,t),u(J,e,t),a(e,Me,t),u(Q,e,t),a(e,we,t),a(e,H,t),a(e,_e,t),u(x,e,t),a(e,ge,t),u(V,e,t),a(e,$e,t),a(e,E,t),a(e,Te,t),u(B,e,t),a(e,ve,t),a(e,P,t),a(e,ke,t),u(I,e,t),a(e,Ze,t),a(e,L,t),a(e,qe,t),a(e,A,t),a(e,ze,t),u(Y,e,t),a(e,je,t),a(e,N,t),a(e,Fe,t),a(e,S,t),Ge=!0},p(e,[t]){const Ne={};t&2&&(Ne.$$scope={dirty:t,ctx:e}),y.$set(Ne)},i(e){Ge||(f(_.$$.fragment,e),f(g.$$.fragment,e),f(q.$$.fragment,e),f(F.$$.fragment,e),f(C.$$.fragment,e),f(y.$$.fragment,e),f(W.$$.fragment,e),f(J.$$.fragment,e),f(Q.$$.fragment,e),f(x.$$.fragment,e),f(V.$$.fragment,e),f(B.$$.fragment,e),f(I.$$.fragment,e),f(Y.$$.fragment,e),Ge=!0)},o(e){h(_.$$.fragment,e),h(g.$$.fragment,e),h(q.$$.fragment,e),h(F.$$.fragment,e),h(C.$$.fragment,e),h(y.$$.fragment,e),h(W.$$.fragment,e),h(J.$$.fragment,e),h(Q.$$.fragment,e),h(x.$$.fragment,e),h(V.$$.fragment,e),h(B.$$.fragment,e),h(I.$$.fragment,e),h(Y.$$.fragment,e),Ge=!1},d(e){e&&(l(b),l(w),l(O),l(ee),l(te),l($),l(le),l(T),l(ae),l(v),l(ne),l(k),l(oe),l(Z),l(ie),l(se),l(z),l(de),l(j),l(re),l(me),l(G),l(pe),l(R),l(ue),l(X),l(fe),l(he),l(ce),l(be),l(U),l(ye),l(Me),l(we),l(H),l(_e),l(ge),l($e),l(E),l(Te),l(ve),l(P),l(ke),l(Ze),l(L),l(qe),l(A),l(ze),l(je),l(N),l(Fe),l(S)),l(r),c(_,e),c(g,e),c(q,e),c(F,e),c(C,e),c(y,e),c(W,e),c(J,e),c(Q,e),c(x,e),c(V,e),c(B,e),c(I,e),c(Y,e)}}}const rt='{"title":"Quantization","local":"quantization","sections":[{"title":"AutoGPTQ Integration","local":"autogptq-integration","sections":[{"title":"Requirements","local":"requirements","sections":[],"depth":3},{"title":"Load and quantize a model","local":"load-and-quantize-a-model","sections":[],"depth":3},{"title":"Save the model","local":"save-the-model","sections":[],"depth":3},{"title":"Load quantized weights","local":"load-quantized-weights","sections":[],"depth":3},{"title":"Exllama kernels for faster inference","local":"exllama-kernels-for-faster-inference","sections":[{"title":"Fine-tune a quantized model","local":"fine-tune-a-quantized-model","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function mt(K){return Oe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bt extends et{constructor(r){super(),tt(this,r,mt,dt,Ke,{})}}export{bt as component};
