import{s as Ll,o as Pl,n as we}from"../chunks/scheduler.182ea377.js";import{S as ql,i as Dl,g as o,s as a,r as f,A as Kl,h as m,f as t,c as i,j as zl,u as d,x as r,k as Fl,y as Ol,a as s,v as y,d as h,t as w,w as J}from"../chunks/index.abf12888.js";import{T as he}from"../chunks/Tip.230e2334.js";import{C as I}from"../chunks/CodeBlock.57fe6e13.js";import{H as v}from"../chunks/Heading.16916d63.js";function et(U){let n,u='In many cases, optimizing for memory or speed leads to improved performance in the other, so you should try to optimize for both whenever you can. This guide focuses on minimizing memory usage, but you can also learn more about how to <a href="fp16">Speed up inference</a>.';return{c(){n=o("p"),n.innerHTML=u},l(p){n=m(p,"P",{"data-svelte-h":!0}),r(n)!=="svelte-15lbm2y"&&(n.innerHTML=u)},m(p,c){s(p,n,c)},p:we,d(p){p&&t(n)}}}function lt(U){let n,u='Consider using <a href="#model-offloading">model offloading</a> if you want to optimize for speed because it is much faster. The tradeoff is your memory savings won’t be as large.';return{c(){n=o("p"),n.innerHTML=u},l(p){n=m(p,"P",{"data-svelte-h":!0}),r(n)!=="svelte-1yyrc0t"&&(n.innerHTML=u)},m(p,c){s(p,n,c)},p:we,d(p){p&&t(n)}}}function tt(U){let n,u='When using <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, don’t move the pipeline to CUDA beforehand or else the gain in memory consumption will only be minimal (see this <a href="https://github.com/huggingface/diffusers/issues/1934" rel="nofollow">issue</a> for more information).',p,c,j='<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a> is a stateful operation that installs hooks on the models.';return{c(){n=o("p"),n.innerHTML=u,p=a(),c=o("p"),c.innerHTML=j},l(M){n=m(M,"P",{"data-svelte-h":!0}),r(n)!=="svelte-pysjic"&&(n.innerHTML=u),p=i(M),c=m(M,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1zrt6x"&&(c.innerHTML=j)},m(M,T){s(M,n,T),s(M,p,T),s(M,c,T)},p:we,d(M){M&&(t(n),t(p),t(c))}}}function st(U){let n,u="Model offloading requires 🤗 Accelerate version 0.17.0 or higher.";return{c(){n=o("p"),n.textContent=u},l(p){n=m(p,"P",{"data-svelte-h":!0}),r(n)!=="svelte-1guxtqy"&&(n.textContent=u)},m(p,c){s(p,n,c)},p:we,d(p){p&&t(n)}}}function nt(U){let n,u='In order to properly offload models after they’re called, it is required to run the entire pipeline and models are called in the pipeline’s expected order. Exercise caution if models are reused outside the context of the pipeline after hooks have been installed. See <a href="https://huggingface.co/docs/accelerate/en/package_reference/big_modeling#accelerate.hooks.remove_hook_from_module" rel="nofollow">Removing Hooks</a> for more information.',p,c,j='<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> is a stateful operation that installs hooks on the models and state on the pipeline.';return{c(){n=o("p"),n.innerHTML=u,p=a(),c=o("p"),c.innerHTML=j},l(M){n=m(M,"P",{"data-svelte-h":!0}),r(n)!=="svelte-bljvwk"&&(n.innerHTML=u),p=i(M),c=m(M,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1rrcfel"&&(c.innerHTML=j)},m(M,T){s(M,n,T),s(M,p,T),s(M,c,T)},p:we,d(M){M&&(t(n),t(p),t(c))}}}function at(U){let n,u="If you have PyTorch &gt;= 2.0 installed, you should not expect a speed-up for inference when enabling <code>xformers</code>.";return{c(){n=o("p"),n.innerHTML=u},l(p){n=m(p,"P",{"data-svelte-h":!0}),r(n)!=="svelte-17vr965"&&(n.innerHTML=u)},m(p,c){s(p,n,c)},p:we,d(p){p&&t(n)}}}function it(U){let n,u,p,c,j,M,T,fl="A barrier to using diffusion models is the large amount of memory required. To overcome this challenge, there are several memory-reducing techniques you can use to run even some of the largest models on free-tier or consumer GPUs. Some of these techniques can even be combined to further reduce memory usage.",Te,b,Ue,W,dl="The results below are obtained from generating a single 512x512 image from the prompt a photo of an astronaut riding a horse on mars with 50 DDIM steps on a Nvidia Titan RTX, demonstrating the speed-up you can expect as a result of reduced memory consumption.",je,$,yl="<thead><tr><th></th> <th>latency</th> <th>speed-up</th></tr></thead> <tbody><tr><td>original</td> <td>9.50s</td> <td>x1</td></tr> <tr><td>fp16</td> <td>3.61s</td> <td>x2.63</td></tr> <tr><td>channels last</td> <td>3.30s</td> <td>x2.88</td></tr> <tr><td>traced UNet</td> <td>3.21s</td> <td>x2.96</td></tr> <tr><td>memory-efficient attention</td> <td>2.63s</td> <td>x3.61</td></tr></tbody>",be,G,Ze,V,hl='Sliced VAE enables decoding large batches of images with limited VRAM or batches with 32 images or more by decoding the batches of latents one image at a time. You’ll likely want to couple this with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to reduce memory use further if you have xFormers installed.',Ce,X,wl='To use sliced VAE, call <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline.enable_vae_slicing">enable_vae_slicing()</a> on your pipeline before inference:',_e,R,ge,k,Jl="You may see a small performance boost in VAE decoding on multi-image batches, and there should be no performance impact on single-image batches.",Be,E,Ie,x,Tl='Tiled VAE processing also enables working with large images on limited VRAM (for example, generating 4k images on 8GB of VRAM) by splitting the image into overlapping tiles, decoding the tiles, and then blending the outputs together to compose the final image. You should also used tiled VAE with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to reduce memory use further if you have xFormers installed.',ve,S,Ul='To use tiled VAE processing, call <a href="/docs/diffusers/main/en/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelPipeline.enable_vae_tiling">enable_vae_tiling()</a> on your pipeline before inference:',We,A,$e,Q,jl="The output image has some tile-to-tile tone variation because the tiles are decoded separately, but you shouldn’t see any sharp and obvious seams between the tiles. Tiling is turned off for images that are 512x512 or smaller.",Ge,N,Ve,H,bl="Offloading the weights to the CPU and only loading them on the GPU when performing the forward pass can also save memory. Often, this technique can reduce memory consumption to less than 3GB.",Xe,Y,Zl='To perform CPU offloading, call <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>:',Re,z,ke,F,Cl="CPU offloading works on submodules rather than whole models. This is the best way to minimize memory consumption, but inference is much slower due to the iterative nature of the diffusion process. The UNet component of the pipeline runs several times (as many as <code>num_inference_steps</code>); each time, the different UNet submodules are sequentially onloaded and offloaded as needed, resulting in a large number of memory transfers.",Ee,Z,xe,C,Se,L,Ae,_,Qe,P,_l='<a href="#cpu-offloading">Sequential CPU offloading</a> preserves a lot of memory but it makes inference slower because submodules are moved to GPU as needed, and they’re immediately returned to the CPU when a new module runs.',Ne,q,gl="Full-model offloading is an alternative that moves whole models to the GPU, instead of handling each model’s constituent <em>submodules</em>. There is a negligible impact on inference time (compared with moving the pipeline to <code>cuda</code>), and it still provides some memory savings.",He,D,Bl=`During model offloading, only one of the main components of the pipeline (typically the text encoder, UNet and VAE)
is placed on the GPU while the others wait on the CPU. Components like the UNet that run for multiple iterations stay on the GPU until they’re no longer needed.`,Ye,K,Il='Enable model offloading by calling <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> on the pipeline:',ze,O,Fe,g,Le,ee,Pe,le,vl="The channels-last memory format is an alternative way of ordering NCHW tensors in memory to preserve dimension ordering. Channels-last tensors are ordered in such a way that the channels become the densest dimension (storing images pixel-per-pixel). Since not all operators currently support the channels-last format, it may result in worst performance but you should still try and see if it works for your model.",qe,te,Wl="For example, to set the pipeline’s UNet to use the channels-last format:",De,se,Ke,ne,Oe,ae,$l="Tracing runs an example input tensor through the model and captures the operations that are performed on it as that input makes its way through the model’s layers. The executable or <code>ScriptFunction</code> that is returned is optimized with just-in-time compilation.",el,ie,Gl="To trace a UNet:",ll,pe,tl,oe,Vl="Replace the <code>unet</code> attribute of the pipeline with the traced model:",sl,me,nl,re,al,ce,Xl='Recent work on optimizing bandwidth in the attention block has generated huge speed-ups and reductions in GPU memory usage. The most recent type of memory-efficient attention is <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">Flash Attention</a> (you can check out the original code at <a href="https://github.com/HazyResearch/flash-attention" rel="nofollow">HazyResearch/flash-attention</a>).',il,B,pl,Me,Rl="To use Flash Attention, install the following:",ol,ue,kl='<li>PyTorch &gt; 1.12</li> <li>CUDA available</li> <li><a href="xformers">xFormers</a></li>',ml,fe,El='Then call <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> on the pipeline:',rl,de,cl,ye,xl='The iteration speed when using <code>xformers</code> should match the iteration speed of PyTorch 2.0 as described <a href="torch2.0">here</a>.',Ml,Je,ul;return j=new v({props:{title:"Reduce memory usage",local:"reduce-memory-usage",headingTag:"h1"}}),b=new he({props:{$$slots:{default:[et]},$$scope:{ctx:U}}}),G=new v({props:{title:"Sliced VAE",local:"sliced-vae",headingTag:"h2"}}),R=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBJTIzcGlwZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoJTVCcHJvbXB0JTVEJTIwKiUyMDMyKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_vae_slicing()
<span class="hljs-comment">#pipe.enable_xformers_memory_efficient_attention()</span>
images = pipe([prompt] * <span class="hljs-number">32</span>).images`,wrap:!1}}),E=new v({props:{title:"Tiled VAE",local:"tiled-vae",headingTag:"h2"}}),A=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJlYXV0aWZ1bCUyMGxhbmRzY2FwZSUyMHBob3RvZ3JhcGglMjIlMEFwaXBlLmVuYWJsZV92YWVfdGlsaW5nKCklMEElMjNwaXBlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCU1QnByb21wdCU1RCUyQyUyMHdpZHRoJTNEMzg0MCUyQyUyMGhlaWdodCUzRDIyMjQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, UniPCMultistepScheduler

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;a beautiful landscape photograph&quot;</span>
pipe.enable_vae_tiling()
<span class="hljs-comment">#pipe.enable_xformers_memory_efficient_attention()</span>

image = pipe([prompt], width=<span class="hljs-number">3840</span>, height=<span class="hljs-number">2224</span>, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),N=new v({props:{title:"CPU offloading",local:"cpu-offloading",headingTag:"h2"}}),z=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfc2VxdWVudGlhbF9jcHVfb2ZmbG9hZCgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_sequential_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Z=new he({props:{$$slots:{default:[lt]},$$scope:{ctx:U}}}),C=new he({props:{warning:!0,$$slots:{default:[tt]},$$scope:{ctx:U}}}),L=new v({props:{title:"Model offloading",local:"model-offloading",headingTag:"h2"}}),_=new he({props:{$$slots:{default:[st]},$$scope:{ctx:U}}}),O=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_model_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),g=new he({props:{warning:!0,$$slots:{default:[nt]},$$scope:{ctx:U}}}),ee=new v({props:{title:"Channels-last memory format",local:"channels-last-memory-format",headingTag:"h2"}}),se=new I({props:{code:"cHJpbnQocGlwZS51bmV0LmNvbnZfb3V0LnN0YXRlX2RpY3QoKSU1QiUyMndlaWdodCUyMiU1RC5zdHJpZGUoKSklMjAlMjAlMjMlMjAoMjg4MCUyQyUyMDklMkMlMjAzJTJDJTIwMSklMEFwaXBlLnVuZXQudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTIwJTIwJTIzJTIwaW4tcGxhY2UlMjBvcGVyYXRpb24lMEFwcmludCglMEElMjAlMjAlMjAlMjBwaXBlLnVuZXQuY29udl9vdXQuc3RhdGVfZGljdCgpJTVCJTIyd2VpZ2h0JTIyJTVELnN0cmlkZSgpJTBBKSUyMCUyMCUyMyUyMCgyODgwJTJDJTIwMSUyQyUyMDk2MCUyQyUyMDMyMCklMjBoYXZpbmclMjBhJTIwc3RyaWRlJTIwb2YlMjAxJTIwZm9yJTIwdGhlJTIwMm5kJTIwZGltZW5zaW9uJTIwcHJvdmVzJTIwdGhhdCUyMGl0JTIwd29ya3M=",highlighted:`<span class="hljs-built_in">print</span>(pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride())  <span class="hljs-comment"># (2880, 9, 3, 1)</span>
pipe.unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># in-place operation</span>
<span class="hljs-built_in">print</span>(
    pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride()
)  <span class="hljs-comment"># (2880, 1, 960, 320) having a stride of 1 for the 2nd dimension proves that it works</span>`,wrap:!1}}),ne=new v({props:{title:"Tracing",local:"tracing",headingTag:"h2"}}),pe=new I({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> functools

<span class="hljs-comment"># torch disable grad</span>
torch.set_grad_enabled(<span class="hljs-literal">False</span>)

<span class="hljs-comment"># set variables</span>
n_experiments = <span class="hljs-number">2</span>
unet_runs_per_experiment = <span class="hljs-number">50</span>


<span class="hljs-comment"># load inputs</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_inputs</span>():
    sample = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    timestep = torch.rand(<span class="hljs-number">1</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16) * <span class="hljs-number">999</span>
    encoder_hidden_states = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">77</span>, <span class="hljs-number">768</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    <span class="hljs-keyword">return</span> sample, timestep, encoder_hidden_states


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
unet = pipe.unet
unet.<span class="hljs-built_in">eval</span>()
unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># use channels_last memory format</span>
unet.forward = functools.partial(unet.forward, return_dict=<span class="hljs-literal">False</span>)  <span class="hljs-comment"># set return_dict=False as default</span>

<span class="hljs-comment"># warmup</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet(*inputs)

<span class="hljs-comment"># trace</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;tracing..&quot;</span>)
unet_traced = torch.jit.trace(unet, inputs)
unet_traced.<span class="hljs-built_in">eval</span>()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;done tracing&quot;</span>)


<span class="hljs-comment"># warmup and optimize graph</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet_traced(*inputs)


<span class="hljs-comment"># benchmarking</span>
<span class="hljs-keyword">with</span> torch.inference_mode():
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet_traced(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet traced inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)

<span class="hljs-comment"># save the model</span>
unet_traced.save(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)`,wrap:!1}}),me=new I({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YWNsYXNzZXMlMjBpbXBvcnQlMjBkYXRhY2xhc3MlMEElMEElMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMFVOZXQyRENvbmRpdGlvbk91dHB1dCUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUzQSUyMHRvcmNoLkZsb2F0VGVuc29yJTBBJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwdXNlJTIwaml0dGVkJTIwdW5ldCUwQXVuZXRfdHJhY2VkJTIwJTNEJTIwdG9yY2guaml0LmxvYWQoJTIydW5ldF90cmFjZWQucHQlMjIpJTBBJTBBJTBBJTIzJTIwZGVsJTIwcGlwZS51bmV0JTBBY2xhc3MlMjBUcmFjZWRVTmV0KHRvcmNoLm5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaW5fY2hhbm5lbHMlMjAlM0QlMjBwaXBlLnVuZXQuY29uZmlnLmluX2NoYW5uZWxzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5kZXZpY2UlMjAlM0QlMjBwaXBlLnVuZXQuZGV2aWNlJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwbGF0ZW50X21vZGVsX2lucHV0JTJDJTIwdCUyQyUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGUlMjAlM0QlMjB1bmV0X3RyYWNlZChsYXRlbnRfbW9kZWxfaW5wdXQlMkMlMjB0JTJDJTIwZW5jb2Rlcl9oaWRkZW5fc3RhdGVzKSU1QjAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBVTmV0MkRDb25kaXRpb25PdXRwdXQoc2FtcGxlJTNEc2FtcGxlKSUwQSUwQSUwQXBpcGUudW5ldCUyMCUzRCUyMFRyYWNlZFVOZXQoKSUwQSUwQXdpdGglMjB0b3JjaC5pbmZlcmVuY2VfbW9kZSgpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBwaXBlKCU1QnByb21wdCU1RCUyMColMjAxJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">UNet2DConditionOutput</span>:
    sample: torch.FloatTensor


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># use jitted unet</span>
unet_traced = torch.jit.load(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)


<span class="hljs-comment"># del pipe.unet</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TracedUNet</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.in_channels = pipe.unet.config.in_channels
        self.device = pipe.unet.device

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, latent_model_input, t, encoder_hidden_states</span>):
        sample = unet_traced(latent_model_input, t, encoder_hidden_states)[<span class="hljs-number">0</span>]
        <span class="hljs-keyword">return</span> UNet2DConditionOutput(sample=sample)


pipe.unet = TracedUNet()

<span class="hljs-keyword">with</span> torch.inference_mode():
    image = pipe([prompt] * <span class="hljs-number">1</span>, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),re=new v({props:{title:"Memory-efficient attention",local:"memory-efficient-attention",headingTag:"h2"}}),B=new he({props:{$$slots:{default:[at]},$$scope:{ctx:U}}}),de=new I({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBzYW1wbGUlMjAlM0QlMjBwaXBlKCUyMmElMjBzbWFsbCUyMGNhdCUyMiklMEElMEElMjMlMjBvcHRpb25hbCUzQSUyMFlvdSUyMGNhbiUyMGRpc2FibGUlMjBpdCUyMHZpYSUwQSUyMyUyMHBpcGUuZGlzYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.enable_xformers_memory_efficient_attention()

<span class="hljs-keyword">with</span> torch.inference_mode():
    sample = pipe(<span class="hljs-string">&quot;a small cat&quot;</span>)

<span class="hljs-comment"># optional: You can disable it via</span>
<span class="hljs-comment"># pipe.disable_xformers_memory_efficient_attention()</span>`,wrap:!1}}),{c(){n=o("meta"),u=a(),p=o("p"),c=a(),f(j.$$.fragment),M=a(),T=o("p"),T.textContent=fl,Te=a(),f(b.$$.fragment),Ue=a(),W=o("p"),W.textContent=dl,je=a(),$=o("table"),$.innerHTML=yl,be=a(),f(G.$$.fragment),Ze=a(),V=o("p"),V.innerHTML=hl,Ce=a(),X=o("p"),X.innerHTML=wl,_e=a(),f(R.$$.fragment),ge=a(),k=o("p"),k.textContent=Jl,Be=a(),f(E.$$.fragment),Ie=a(),x=o("p"),x.innerHTML=Tl,ve=a(),S=o("p"),S.innerHTML=Ul,We=a(),f(A.$$.fragment),$e=a(),Q=o("p"),Q.textContent=jl,Ge=a(),f(N.$$.fragment),Ve=a(),H=o("p"),H.textContent=bl,Xe=a(),Y=o("p"),Y.innerHTML=Zl,Re=a(),f(z.$$.fragment),ke=a(),F=o("p"),F.innerHTML=Cl,Ee=a(),f(Z.$$.fragment),xe=a(),f(C.$$.fragment),Se=a(),f(L.$$.fragment),Ae=a(),f(_.$$.fragment),Qe=a(),P=o("p"),P.innerHTML=_l,Ne=a(),q=o("p"),q.innerHTML=gl,He=a(),D=o("p"),D.textContent=Bl,Ye=a(),K=o("p"),K.innerHTML=Il,ze=a(),f(O.$$.fragment),Fe=a(),f(g.$$.fragment),Le=a(),f(ee.$$.fragment),Pe=a(),le=o("p"),le.textContent=vl,qe=a(),te=o("p"),te.textContent=Wl,De=a(),f(se.$$.fragment),Ke=a(),f(ne.$$.fragment),Oe=a(),ae=o("p"),ae.innerHTML=$l,el=a(),ie=o("p"),ie.textContent=Gl,ll=a(),f(pe.$$.fragment),tl=a(),oe=o("p"),oe.innerHTML=Vl,sl=a(),f(me.$$.fragment),nl=a(),f(re.$$.fragment),al=a(),ce=o("p"),ce.innerHTML=Xl,il=a(),f(B.$$.fragment),pl=a(),Me=o("p"),Me.textContent=Rl,ol=a(),ue=o("ul"),ue.innerHTML=kl,ml=a(),fe=o("p"),fe.innerHTML=El,rl=a(),f(de.$$.fragment),cl=a(),ye=o("p"),ye.innerHTML=xl,Ml=a(),Je=o("p"),this.h()},l(e){const l=Kl("svelte-u9bgzb",document.head);n=m(l,"META",{name:!0,content:!0}),l.forEach(t),u=i(e),p=m(e,"P",{}),zl(p).forEach(t),c=i(e),d(j.$$.fragment,e),M=i(e),T=m(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-18ag1qn"&&(T.textContent=fl),Te=i(e),d(b.$$.fragment,e),Ue=i(e),W=m(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1nfsyhf"&&(W.textContent=dl),je=i(e),$=m(e,"TABLE",{"data-svelte-h":!0}),r($)!=="svelte-qiiy0g"&&($.innerHTML=yl),be=i(e),d(G.$$.fragment,e),Ze=i(e),V=m(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-g37v30"&&(V.innerHTML=hl),Ce=i(e),X=m(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1t1foqu"&&(X.innerHTML=wl),_e=i(e),d(R.$$.fragment,e),ge=i(e),k=m(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-fte8mn"&&(k.textContent=Jl),Be=i(e),d(E.$$.fragment,e),Ie=i(e),x=m(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1g0rx31"&&(x.innerHTML=Tl),ve=i(e),S=m(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1yciusa"&&(S.innerHTML=Ul),We=i(e),d(A.$$.fragment,e),$e=i(e),Q=m(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-nyzaca"&&(Q.textContent=jl),Ge=i(e),d(N.$$.fragment,e),Ve=i(e),H=m(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-435lli"&&(H.textContent=bl),Xe=i(e),Y=m(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-z49dor"&&(Y.innerHTML=Zl),Re=i(e),d(z.$$.fragment,e),ke=i(e),F=m(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-153k8wf"&&(F.innerHTML=Cl),Ee=i(e),d(Z.$$.fragment,e),xe=i(e),d(C.$$.fragment,e),Se=i(e),d(L.$$.fragment,e),Ae=i(e),d(_.$$.fragment,e),Qe=i(e),P=m(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1w0xgx8"&&(P.innerHTML=_l),Ne=i(e),q=m(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-nislc4"&&(q.innerHTML=gl),He=i(e),D=m(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-11gjm3"&&(D.textContent=Bl),Ye=i(e),K=m(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-op610o"&&(K.innerHTML=Il),ze=i(e),d(O.$$.fragment,e),Fe=i(e),d(g.$$.fragment,e),Le=i(e),d(ee.$$.fragment,e),Pe=i(e),le=m(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-sky5la"&&(le.textContent=vl),qe=i(e),te=m(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-mhdc10"&&(te.textContent=Wl),De=i(e),d(se.$$.fragment,e),Ke=i(e),d(ne.$$.fragment,e),Oe=i(e),ae=m(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1hj6sqj"&&(ae.innerHTML=$l),el=i(e),ie=m(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1ca1ko1"&&(ie.textContent=Gl),ll=i(e),d(pe.$$.fragment,e),tl=i(e),oe=m(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-mpebhd"&&(oe.innerHTML=Vl),sl=i(e),d(me.$$.fragment,e),nl=i(e),d(re.$$.fragment,e),al=i(e),ce=m(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1tu2ji2"&&(ce.innerHTML=Xl),il=i(e),d(B.$$.fragment,e),pl=i(e),Me=m(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-rpfoyf"&&(Me.textContent=Rl),ol=i(e),ue=m(e,"UL",{"data-svelte-h":!0}),r(ue)!=="svelte-1q6gndt"&&(ue.innerHTML=kl),ml=i(e),fe=m(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-141yc6t"&&(fe.innerHTML=El),rl=i(e),d(de.$$.fragment,e),cl=i(e),ye=m(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1nf2kxh"&&(ye.innerHTML=xl),Ml=i(e),Je=m(e,"P",{}),zl(Je).forEach(t),this.h()},h(){Fl(n,"name","hf:doc:metadata"),Fl(n,"content",pt)},m(e,l){Ol(document.head,n),s(e,u,l),s(e,p,l),s(e,c,l),y(j,e,l),s(e,M,l),s(e,T,l),s(e,Te,l),y(b,e,l),s(e,Ue,l),s(e,W,l),s(e,je,l),s(e,$,l),s(e,be,l),y(G,e,l),s(e,Ze,l),s(e,V,l),s(e,Ce,l),s(e,X,l),s(e,_e,l),y(R,e,l),s(e,ge,l),s(e,k,l),s(e,Be,l),y(E,e,l),s(e,Ie,l),s(e,x,l),s(e,ve,l),s(e,S,l),s(e,We,l),y(A,e,l),s(e,$e,l),s(e,Q,l),s(e,Ge,l),y(N,e,l),s(e,Ve,l),s(e,H,l),s(e,Xe,l),s(e,Y,l),s(e,Re,l),y(z,e,l),s(e,ke,l),s(e,F,l),s(e,Ee,l),y(Z,e,l),s(e,xe,l),y(C,e,l),s(e,Se,l),y(L,e,l),s(e,Ae,l),y(_,e,l),s(e,Qe,l),s(e,P,l),s(e,Ne,l),s(e,q,l),s(e,He,l),s(e,D,l),s(e,Ye,l),s(e,K,l),s(e,ze,l),y(O,e,l),s(e,Fe,l),y(g,e,l),s(e,Le,l),y(ee,e,l),s(e,Pe,l),s(e,le,l),s(e,qe,l),s(e,te,l),s(e,De,l),y(se,e,l),s(e,Ke,l),y(ne,e,l),s(e,Oe,l),s(e,ae,l),s(e,el,l),s(e,ie,l),s(e,ll,l),y(pe,e,l),s(e,tl,l),s(e,oe,l),s(e,sl,l),y(me,e,l),s(e,nl,l),y(re,e,l),s(e,al,l),s(e,ce,l),s(e,il,l),y(B,e,l),s(e,pl,l),s(e,Me,l),s(e,ol,l),s(e,ue,l),s(e,ml,l),s(e,fe,l),s(e,rl,l),y(de,e,l),s(e,cl,l),s(e,ye,l),s(e,Ml,l),s(e,Je,l),ul=!0},p(e,[l]){const Sl={};l&2&&(Sl.$$scope={dirty:l,ctx:e}),b.$set(Sl);const Al={};l&2&&(Al.$$scope={dirty:l,ctx:e}),Z.$set(Al);const Ql={};l&2&&(Ql.$$scope={dirty:l,ctx:e}),C.$set(Ql);const Nl={};l&2&&(Nl.$$scope={dirty:l,ctx:e}),_.$set(Nl);const Hl={};l&2&&(Hl.$$scope={dirty:l,ctx:e}),g.$set(Hl);const Yl={};l&2&&(Yl.$$scope={dirty:l,ctx:e}),B.$set(Yl)},i(e){ul||(h(j.$$.fragment,e),h(b.$$.fragment,e),h(G.$$.fragment,e),h(R.$$.fragment,e),h(E.$$.fragment,e),h(A.$$.fragment,e),h(N.$$.fragment,e),h(z.$$.fragment,e),h(Z.$$.fragment,e),h(C.$$.fragment,e),h(L.$$.fragment,e),h(_.$$.fragment,e),h(O.$$.fragment,e),h(g.$$.fragment,e),h(ee.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(re.$$.fragment,e),h(B.$$.fragment,e),h(de.$$.fragment,e),ul=!0)},o(e){w(j.$$.fragment,e),w(b.$$.fragment,e),w(G.$$.fragment,e),w(R.$$.fragment,e),w(E.$$.fragment,e),w(A.$$.fragment,e),w(N.$$.fragment,e),w(z.$$.fragment,e),w(Z.$$.fragment,e),w(C.$$.fragment,e),w(L.$$.fragment,e),w(_.$$.fragment,e),w(O.$$.fragment,e),w(g.$$.fragment,e),w(ee.$$.fragment,e),w(se.$$.fragment,e),w(ne.$$.fragment,e),w(pe.$$.fragment,e),w(me.$$.fragment,e),w(re.$$.fragment,e),w(B.$$.fragment,e),w(de.$$.fragment,e),ul=!1},d(e){e&&(t(u),t(p),t(c),t(M),t(T),t(Te),t(Ue),t(W),t(je),t($),t(be),t(Ze),t(V),t(Ce),t(X),t(_e),t(ge),t(k),t(Be),t(Ie),t(x),t(ve),t(S),t(We),t($e),t(Q),t(Ge),t(Ve),t(H),t(Xe),t(Y),t(Re),t(ke),t(F),t(Ee),t(xe),t(Se),t(Ae),t(Qe),t(P),t(Ne),t(q),t(He),t(D),t(Ye),t(K),t(ze),t(Fe),t(Le),t(Pe),t(le),t(qe),t(te),t(De),t(Ke),t(Oe),t(ae),t(el),t(ie),t(ll),t(tl),t(oe),t(sl),t(nl),t(al),t(ce),t(il),t(pl),t(Me),t(ol),t(ue),t(ml),t(fe),t(rl),t(cl),t(ye),t(Ml),t(Je)),t(n),J(j,e),J(b,e),J(G,e),J(R,e),J(E,e),J(A,e),J(N,e),J(z,e),J(Z,e),J(C,e),J(L,e),J(_,e),J(O,e),J(g,e),J(ee,e),J(se,e),J(ne,e),J(pe,e),J(me,e),J(re,e),J(B,e),J(de,e)}}}const pt='{"title":"Reduce memory usage","local":"reduce-memory-usage","sections":[{"title":"Sliced VAE","local":"sliced-vae","sections":[],"depth":2},{"title":"Tiled VAE","local":"tiled-vae","sections":[],"depth":2},{"title":"CPU offloading","local":"cpu-offloading","sections":[],"depth":2},{"title":"Model offloading","local":"model-offloading","sections":[],"depth":2},{"title":"Channels-last memory format","local":"channels-last-memory-format","sections":[],"depth":2},{"title":"Tracing","local":"tracing","sections":[],"depth":2},{"title":"Memory-efficient attention","local":"memory-efficient-attention","sections":[],"depth":2}],"depth":1}';function ot(U){return Pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ft extends ql{constructor(n){super(),Dl(this,n,ot,it,Ll,{})}}export{ft as component};
