import{s as zn,o as En,n as Ko}from"../chunks/scheduler.182ea377.js";import{S as Nn,i as Rn,g as a,s as n,r as p,A as Fn,h as r,f as o,c as s,j as M,u as c,x as d,k as V,y as t,a as l,v as m,d as f,t as u,w as g}from"../chunks/index.abf12888.js";import{T as Hn}from"../chunks/Tip.230e2334.js";import{D as Z}from"../chunks/Docstring.93f6f462.js";import{C as Fe}from"../chunks/CodeBlock.57fe6e13.js";import{E as Ln}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Re}from"../chunks/Heading.16916d63.js";function Yn(G){let _,D="🧪 This pipeline is for research purposes only.";return{c(){_=a("p"),_.textContent=D},l(w){_=r(w,"P",{"data-svelte-h":!0}),d(_)!=="svelte-1r9f87h"&&(_.textContent=D)},m(w,y){l(w,_,y)},p:Ko,d(w){w&&o(_)}}}function An(G){let _,D="Examples:",w,y,J;return y=new Fe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9TRFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b192aWRlbyUwQSUwQXBpcGUlMjAlM0QlMjBUZXh0VG9WaWRlb1NEUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRhbW8tdmlsYWIlMkZ0ZXh0LXRvLXZpZGVvLW1zLTEuN2IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyU3BpZGVybWFuJTIwaXMlMjBzdXJmaW5nJTIyJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQpLmZyYW1lcyUwQXZpZGVvX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fdmlkZW8odmlkZW9fZnJhbWVzKSUwQXZpZGVvX3BhdGg=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> TextToVideoSDPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = TextToVideoSDPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Spiderman is surfing&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_frames = pipe(prompt).frames
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_video(video_frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path`,wrap:!1}}),{c(){_=a("p"),_.textContent=D,w=n(),p(y.$$.fragment)},l(h){_=r(h,"P",{"data-svelte-h":!0}),d(_)!=="svelte-kvfsh7"&&(_.textContent=D),w=s(h),c(y.$$.fragment,h)},m(h,$){l(h,_,$),l(h,w,$),m(y,h,$),J=!0},p:Ko,i(h){J||(f(y.$$.fragment,h),J=!0)},o(h){u(y.$$.fragment,h),J=!1},d(h){h&&(o(_),o(w)),g(y,h)}}}function Qn(G){let _,D="Examples:",w,y,J;return y=new Fe({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_576w&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;spiderman running in the desert&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_frames = pipe(prompt, num_inference_steps=<span class="hljs-number">40</span>, height=<span class="hljs-number">320</span>, width=<span class="hljs-number">576</span>, num_frames=<span class="hljs-number">24</span>).frames
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># safe low-res video</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_video(video_frames, output_video_path=<span class="hljs-string">&quot;./video_576_spiderman.mp4&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s offload the text-to-image model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cpu&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and load the image-to-image model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;cerspense/zeroscope_v2_XL&quot;</span>, torch_dtype=torch.float16, revision=<span class="hljs-string">&quot;refs/pr/15&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The VAE consumes A LOT of memory, let&#x27;s make sure we run it in sliced mode</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_slicing()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now let&#x27;s upscale it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video = [Image.fromarray(frame).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>)) <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> video_frames]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and denoise it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_frames = pipe(prompt, video=video, strength=<span class="hljs-number">0.6</span>).frames
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_video(video_frames, output_video_path=<span class="hljs-string">&quot;./video_1024_spiderman.mp4&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path`,wrap:!1}}),{c(){_=a("p"),_.textContent=D,w=n(),p(y.$$.fragment)},l(h){_=r(h,"P",{"data-svelte-h":!0}),d(_)!=="svelte-kvfsh7"&&(_.textContent=D),w=s(h),c(y.$$.fragment,h)},m(h,$){l(h,_,$),l(h,w,$),m(y,h,$),J=!0},p:Ko,i(h){J||(f(y.$$.fragment,h),J=!0)},o(h){u(y.$$.fragment,h),J=!1},d(h){h&&(o(_),o(w)),g(y,h)}}}function qn(G){let _,D,w,y,J,h,$,Tt,K,en='<a href="https://huggingface.co/papers/2303.08320" rel="nofollow">VideoFusion: Decomposed Diffusion Models for High-Quality Video Generation</a> is by Zhengxiong Luo, Dayou Chen, Yingya Zhang, Yan Huang, Liang Wang, Yujun Shen, Deli Zhao, Jingren Zhou, Tieniu Tan.',yt,ee,tn="The abstract from the paper is:",xt,te,on="<em>A diffusion probabilistic model (DPM), which constructs a forward diffusion process by gradually adding noise to data points and learns the reverse denoising process to generate new samples, has been shown to handle complex data distribution. Despite its recent success in image synthesis, applying DPMs to video generation is still challenging due to high-dimensional data spaces. Previous methods usually adopt a standard diffusion process, where frames in the same video clip are destroyed with independent noises, ignoring the content redundancy and temporal correlation. This work presents a decomposed diffusion process via resolving the per-frame noise into a base noise that is shared among all frames and a residual noise that varies along the time axis. The denoising pipeline employs two jointly-learned networks to match the noise decomposition accordingly. Experiments on various datasets confirm that our approach, termed as VideoFusion, surpasses both GAN-based and diffusion-based alternatives in high-quality video generation. We further show that our decomposed formulation can benefit from pre-trained image diffusion models and well-support text-conditioned video creation.</em>",wt,oe,nn='You can find additional information about Text-to-Video on the <a href="https://modelscope.cn/models/damo/text-to-video-synthesis/summary" rel="nofollow">project page</a>, <a href="https://github.com/modelscope/modelscope/" rel="nofollow">original codebase</a>, and try it out in a <a href="https://huggingface.co/spaces/damo-vilab/modelscope-text-to-video-synthesis" rel="nofollow">demo</a>. Official checkpoints can be found at <a href="https://huggingface.co/damo-vilab" rel="nofollow">damo-vilab</a> and <a href="https://huggingface.co/cerspense" rel="nofollow">cerspense</a>.',Mt,ne,Vt,se,Zt,ie,sn="Let’s start by generating a short video with the default length of 16 frames (2s at 8 fps):",Jt,ae,$t,re,an=`Diffusers supports different optimization techniques to improve the latency
and memory footprint of a pipeline. Since videos are often more memory-heavy than images,
we can enable CPU offloading and VAE slicing to keep the memory footprint at bay.`,Dt,le,rn="Let’s generate a video of 8 seconds (64 frames) on the same GPU using CPU offloading and VAE slicing:",kt,de,jt,pe,ln="It just takes <strong>7 GBs of GPU memory</strong> to generate the 64 video frames using PyTorch 2.0, “fp16” precision and the techniques mentioned above.",Ct,ce,dn="We can also use a different scheduler easily, using the same method we’d use for Stable Diffusion:",St,me,Pt,fe,pn="Here are some sample outputs:",Ut,ue,cn=`<tbody><tr><td><center>An astronaut riding a horse.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/astr.gif" alt="An astronaut riding a horse." style="width: 300px;"/></center></td> <td><center>Darth vader surfing in waves.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/vader.gif" alt="Darth vader surfing in waves." style="width: 300px;"/></center></td></tr></tbody>`,Gt,ge,It,he,mn=`Zeroscope are watermark-free model and have been trained on specific sizes such as <code>576x320</code> and <code>1024x576</code>.
One should first generate a video using the lower resolution checkpoint <a href="https://huggingface.co/cerspense/zeroscope_v2_576w" rel="nofollow"><code>cerspense/zeroscope_v2_576w</code></a> with <a href="/docs/diffusers/v0.22.0/en/api/pipelines/text_to_video#diffusers.TextToVideoSDPipeline">TextToVideoSDPipeline</a>,
which can then be upscaled using <a href="/docs/diffusers/v0.22.0/en/api/pipelines/text_to_video#diffusers.VideoToVideoSDPipeline">VideoToVideoSDPipeline</a> and <a href="https://huggingface.co/cerspense/zeroscope_v2_XL" rel="nofollow"><code>cerspense/zeroscope_v2_XL</code></a>.`,Wt,_e,Bt,ve,fn="Now the video can be upscaled:",Xt,be,Lt,Te,un="Here are some sample outputs:",zt,ye,gn=`<tbody><tr><td><center>Darth vader surfing in waves.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/darthvader_cerpense.gif" alt="Darth vader surfing in waves." style="width: 576px;"/></center></td></tr></tbody>`,Et,xe,Nt,v,we,po,He,hn="Pipeline for text-to-video generation.",co,Ye,_n=`This model inherits from <a href="/docs/diffusers/v0.22.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,mo,C,Me,fo,Ae,vn="The call function to the pipeline for generation.",uo,I,go,W,Ve,ho,Qe,bn="Disables the FreeU mechanism if enabled.",_o,B,Ze,vo,qe,Tn=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,bo,X,Je,To,Oe,yn=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,yo,k,$e,xo,Ke,xn='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',wo,et,wn="The suffixes after the scaling factors represent the stages where they are being applied.",Mo,tt,Mn=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Vo,L,De,Zo,ot,Vn=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Jo,z,ke,$o,nt,Zn=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Do,E,je,ko,st,Jn="Encodes the prompt into text encoder hidden states.",Rt,Ce,Ft,b,Se,jo,it,$n="Pipeline for text-guided video-to-video generation.",Co,at,Dn=`This model inherits from <a href="/docs/diffusers/v0.22.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,So,S,Pe,Po,rt,kn="The call function to the pipeline for generation.",Uo,N,Go,R,Ue,Io,lt,jn="Disables the FreeU mechanism if enabled.",Wo,F,Ge,Bo,dt,Cn=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Xo,H,Ie,Lo,pt,Sn=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,zo,j,We,Eo,ct,Pn='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',No,mt,Un="The suffixes after the scaling factors represent the stages where they are being applied.",Ro,ft,Gn=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Fo,Y,Be,Ho,ut,In=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Yo,A,Xe,Ao,gt,Wn=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Qo,Q,Le,qo,ht,Bn="Encodes the prompt into text encoder hidden states.",Ht,ze,Yt,P,Ee,Oo,_t,Xn="Output class for text-to-video pipelines.",At,bt,Qt;return J=new Hn({props:{warning:!0,$$slots:{default:[Yn]},$$scope:{ctx:G}}}),$=new Re({props:{title:"Text-to-video",local:"text-to-video",headingTag:"h1"}}),ne=new Re({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),se=new Re({props:{title:"text-to-video-ms-1.7b",local:"text-to-video-ms-17b",headingTag:"h3"}}),ae=new Fe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJkYW1vLXZpbGFiJTJGdGV4dC10by12aWRlby1tcy0xLjdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJTcGlkZXJtYW4lMjBpcyUyMHN1cmZpbmclMjIlMEF2aWRlb19mcmFtZXMlMjAlM0QlMjBwaXBlKHByb21wdCkuZnJhbWVzJTBBdmlkZW9fcGF0aCUyMCUzRCUyMGV4cG9ydF90b192aWRlbyh2aWRlb19mcmFtZXMpJTBBdmlkZW9fcGF0aA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Spiderman is surfing&quot;</span>
video_frames = pipe(prompt).frames
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),de=new Fe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJkYW1vLXZpbGFiJTJGdGV4dC10by12aWRlby1tcy0xLjdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMG1lbW9yeSUyMG9wdGltaXphdGlvbiUwQXBpcGUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJEYXJ0aCUyMFZhZGVyJTIwc3VyZmluZyUyMGElMjB3YXZlJTIyJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1fZnJhbWVzJTNENjQpLmZyYW1lcyUwQXZpZGVvX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fdmlkZW8odmlkZW9fZnJhbWVzKSUwQXZpZGVvX3BhdGg=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># memory optimization</span>
pipe.enable_vae_slicing()

prompt = <span class="hljs-string">&quot;Darth Vader surfing a wave&quot;</span>
video_frames = pipe(prompt, num_frames=<span class="hljs-number">64</span>).frames
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),me=new Fe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJkYW1vLXZpbGFiJTJGdGV4dC10by12aWRlby1tcy0xLjdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJTcGlkZXJtYW4lMjBpcyUyMHN1cmZpbmclMjIlMEF2aWRlb19mcmFtZXMlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuZnJhbWVzJTBBdmlkZW9fcGF0aCUyMCUzRCUyMGV4cG9ydF90b192aWRlbyh2aWRlb19mcmFtZXMpJTBBdmlkZW9fcGF0aA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;Spiderman is surfing&quot;</span>
video_frames = pipe(prompt, num_inference_steps=<span class="hljs-number">25</span>).frames
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),ge=new Re({props:{title:"cerspense/zeroscope_v2_576w & cerspense/zeroscope_v2_XL",local:"cerspensezeroscopev2576w--cerspensezeroscopev2xl",headingTag:"h3"}}),_e=new Fe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJjZXJzcGVuc2UlMkZ6ZXJvc2NvcGVfdjJfNTc2dyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBJTIzJTIwbWVtb3J5JTIwb3B0aW1pemF0aW9uJTBBcGlwZS51bmV0LmVuYWJsZV9mb3J3YXJkX2NodW5raW5nKGNodW5rX3NpemUlM0QxJTJDJTIwZGltJTNEMSklMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyRGFydGglMjBWYWRlciUyMHN1cmZpbmclMjBhJTIwd2F2ZSUyMiUwQXZpZGVvX2ZyYW1lcyUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2ZyYW1lcyUzRDI0KS5mcmFtZXMlMEF2aWRlb19wYXRoJTIwJTNEJTIwZXhwb3J0X3RvX3ZpZGVvKHZpZGVvX2ZyYW1lcyklMEF2aWRlb19wYXRo",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_576w&quot;</span>, torch_dtype=torch.float16)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># memory optimization</span>
pipe.unet.enable_forward_chunking(chunk_size=<span class="hljs-number">1</span>, dim=<span class="hljs-number">1</span>)
pipe.enable_vae_slicing()

prompt = <span class="hljs-string">&quot;Darth Vader surfing a wave&quot;</span>
video_frames = pipe(prompt, num_frames=<span class="hljs-number">24</span>).frames
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),be=new Fe({props:{code:"cGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJjZXJzcGVuc2UlMkZ6ZXJvc2NvcGVfdjJfWEwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEElMjMlMjBtZW1vcnklMjBvcHRpbWl6YXRpb24lMEFwaXBlLnVuZXQuZW5hYmxlX2ZvcndhcmRfY2h1bmtpbmcoY2h1bmtfc2l6ZSUzRDElMkMlMjBkaW0lM0QxKSUwQXBpcGUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEElMEF2aWRlbyUyMCUzRCUyMCU1QkltYWdlLmZyb21hcnJheShmcmFtZSkucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMjBmb3IlMjBmcmFtZSUyMGluJTIwdmlkZW9fZnJhbWVzJTVEJTBBJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjB2aWRlbyUzRHZpZGVvJTJDJTIwc3RyZW5ndGglM0QwLjYpLmZyYW1lcyUwQXZpZGVvX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fdmlkZW8odmlkZW9fZnJhbWVzKSUwQXZpZGVvX3BhdGg=",highlighted:`pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_XL&quot;</span>, torch_dtype=torch.float16)
pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># memory optimization</span>
pipe.unet.enable_forward_chunking(chunk_size=<span class="hljs-number">1</span>, dim=<span class="hljs-number">1</span>)
pipe.enable_vae_slicing()

video = [Image.fromarray(frame).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>)) <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> video_frames]

video_frames = pipe(prompt, video=video, strength=<span class="hljs-number">0.6</span>).frames
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),xe=new Re({props:{title:"TextToVideoSDPipeline",local:"diffusers.TextToVideoSDPipeline",headingTag:"h2"}}),we=new Z({props:{name:"class diffusers.TextToVideoSDPipeline",anchor:"diffusers.TextToVideoSDPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet3DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.22.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.TextToVideoSDPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.TextToVideoSDPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.TextToVideoSDPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.22.0/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/v0.22.0/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.TextToVideoSDPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.22.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.22.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.22.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.22.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L79"}}),Me=new Z({props:{name:"__call__",anchor:"diffusers.TextToVideoSDPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_frames",val:": int = 16"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 9.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.22.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.22.0/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L515",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.22.0/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.22.0/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> or <code>tuple</code></p>
`}}),I=new Ln({props:{anchor:"diffusers.TextToVideoSDPipeline.__call__.example",$$slots:{default:[An]},$$scope:{ctx:G}}}),Ve=new Z({props:{name:"disable_freeu",anchor:"diffusers.TextToVideoSDPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L511"}}),Ze=new Z({props:{name:"disable_vae_slicing",anchor:"diffusers.TextToVideoSDPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L129"}}),Je=new Z({props:{name:"disable_vae_tiling",anchor:"diffusers.TextToVideoSDPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L146"}}),$e=new Z({props:{name:"enable_freeu",anchor:"diffusers.TextToVideoSDPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.TextToVideoSDPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.TextToVideoSDPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.TextToVideoSDPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L488"}}),De=new Z({props:{name:"enable_vae_slicing",anchor:"diffusers.TextToVideoSDPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L121"}}),ke=new Z({props:{name:"enable_vae_tiling",anchor:"diffusers.TextToVideoSDPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L137"}}),je=new Z({props:{name:"encode_prompt",anchor:"diffusers.TextToVideoSDPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L187"}}),Ce=new Re({props:{title:"VideoToVideoSDPipeline",local:"diffusers.VideoToVideoSDPipeline",headingTag:"h2"}}),Se=new Z({props:{name:"class diffusers.VideoToVideoSDPipeline",anchor:"diffusers.VideoToVideoSDPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet3DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.22.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.VideoToVideoSDPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.VideoToVideoSDPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.VideoToVideoSDPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.22.0/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/v0.22.0/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.VideoToVideoSDPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.22.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.22.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.22.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.22.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L141"}}),Pe=new Z({props:{name:"__call__",anchor:"diffusers.VideoToVideoSDPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"video",val:": typing.Union[typing.List[numpy.ndarray], torch.FloatTensor] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 15.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.video",description:`<strong>video</strong> (<code>List[np.ndarray]</code> or <code>torch.FloatTensor</code>) &#x2014;
<code>video</code> frames or tensor representing a video batch to be used as the starting point for the process.
Can also accept video latents as <code>image</code>, if passing latents directly, it will not be encoded again.`,name:"video"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>video</code>. Must be between 0 and 1. <code>video</code> is used as a
starting point, adding more noise to it the larger the <code>strength</code>. The number of denoising steps
depends on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the
denoising process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of
1 essentially ignores <code>video</code>.`,name:"strength"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in video generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.22.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.22.0/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L606",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.22.0/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.22.0/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> or <code>tuple</code></p>
`}}),N=new Ln({props:{anchor:"diffusers.VideoToVideoSDPipeline.__call__.example",$$slots:{default:[Qn]},$$scope:{ctx:G}}}),Ue=new Z({props:{name:"disable_freeu",anchor:"diffusers.VideoToVideoSDPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L602"}}),Ge=new Z({props:{name:"disable_vae_slicing",anchor:"diffusers.VideoToVideoSDPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L191"}}),Ie=new Z({props:{name:"disable_vae_tiling",anchor:"diffusers.VideoToVideoSDPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L208"}}),We=new Z({props:{name:"enable_freeu",anchor:"diffusers.VideoToVideoSDPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.VideoToVideoSDPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.VideoToVideoSDPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.VideoToVideoSDPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L579"}}),Be=new Z({props:{name:"enable_vae_slicing",anchor:"diffusers.VideoToVideoSDPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L183"}}),Xe=new Z({props:{name:"enable_vae_tiling",anchor:"diffusers.VideoToVideoSDPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L199"}}),Le=new Z({props:{name:"encode_prompt",anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L249"}}),ze=new Re({props:{title:"TextToVideoSDPipelineOutput",local:"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput",headingTag:"h2"}}),Ee=new Z({props:{name:"class diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput",anchor:"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput",parameters:[{name:"frames",val:": typing.Union[typing.List[numpy.ndarray], torch.FloatTensor]"}],parametersDescription:[{anchor:"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput.frames",description:`<strong>frames</strong> (<code>List[np.ndarray]</code> or <code>torch.FloatTensor</code>) &#x2014;
List of denoised frames (essentially images) as NumPy arrays of shape <code>(height, width, num_channels)</code> or as
a <code>torch</code> tensor. The length of the list denotes the video length (the number of frames).`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_output.py#L13"}}),{c(){_=a("meta"),D=n(),w=a("p"),y=n(),p(J.$$.fragment),h=n(),p($.$$.fragment),Tt=n(),K=a("p"),K.innerHTML=en,yt=n(),ee=a("p"),ee.textContent=tn,xt=n(),te=a("p"),te.innerHTML=on,wt=n(),oe=a("p"),oe.innerHTML=nn,Mt=n(),p(ne.$$.fragment),Vt=n(),p(se.$$.fragment),Zt=n(),ie=a("p"),ie.textContent=sn,Jt=n(),p(ae.$$.fragment),$t=n(),re=a("p"),re.textContent=an,Dt=n(),le=a("p"),le.textContent=rn,kt=n(),p(de.$$.fragment),jt=n(),pe=a("p"),pe.innerHTML=ln,Ct=n(),ce=a("p"),ce.textContent=dn,St=n(),p(me.$$.fragment),Pt=n(),fe=a("p"),fe.textContent=pn,Ut=n(),ue=a("table"),ue.innerHTML=cn,Gt=n(),p(ge.$$.fragment),It=n(),he=a("p"),he.innerHTML=mn,Wt=n(),p(_e.$$.fragment),Bt=n(),ve=a("p"),ve.textContent=fn,Xt=n(),p(be.$$.fragment),Lt=n(),Te=a("p"),Te.textContent=un,zt=n(),ye=a("table"),ye.innerHTML=gn,Et=n(),p(xe.$$.fragment),Nt=n(),v=a("div"),p(we.$$.fragment),po=n(),He=a("p"),He.textContent=hn,co=n(),Ye=a("p"),Ye.innerHTML=_n,mo=n(),C=a("div"),p(Me.$$.fragment),fo=n(),Ae=a("p"),Ae.textContent=vn,uo=n(),p(I.$$.fragment),go=n(),W=a("div"),p(Ve.$$.fragment),ho=n(),Qe=a("p"),Qe.textContent=bn,_o=n(),B=a("div"),p(Ze.$$.fragment),vo=n(),qe=a("p"),qe.innerHTML=Tn,bo=n(),X=a("div"),p(Je.$$.fragment),To=n(),Oe=a("p"),Oe.innerHTML=yn,yo=n(),k=a("div"),p($e.$$.fragment),xo=n(),Ke=a("p"),Ke.innerHTML=xn,wo=n(),et=a("p"),et.textContent=wn,Mo=n(),tt=a("p"),tt.innerHTML=Mn,Vo=n(),L=a("div"),p(De.$$.fragment),Zo=n(),ot=a("p"),ot.textContent=Vn,Jo=n(),z=a("div"),p(ke.$$.fragment),$o=n(),nt=a("p"),nt.textContent=Zn,Do=n(),E=a("div"),p(je.$$.fragment),ko=n(),st=a("p"),st.textContent=Jn,Rt=n(),p(Ce.$$.fragment),Ft=n(),b=a("div"),p(Se.$$.fragment),jo=n(),it=a("p"),it.textContent=$n,Co=n(),at=a("p"),at.innerHTML=Dn,So=n(),S=a("div"),p(Pe.$$.fragment),Po=n(),rt=a("p"),rt.textContent=kn,Uo=n(),p(N.$$.fragment),Go=n(),R=a("div"),p(Ue.$$.fragment),Io=n(),lt=a("p"),lt.textContent=jn,Wo=n(),F=a("div"),p(Ge.$$.fragment),Bo=n(),dt=a("p"),dt.innerHTML=Cn,Xo=n(),H=a("div"),p(Ie.$$.fragment),Lo=n(),pt=a("p"),pt.innerHTML=Sn,zo=n(),j=a("div"),p(We.$$.fragment),Eo=n(),ct=a("p"),ct.innerHTML=Pn,No=n(),mt=a("p"),mt.textContent=Un,Ro=n(),ft=a("p"),ft.innerHTML=Gn,Fo=n(),Y=a("div"),p(Be.$$.fragment),Ho=n(),ut=a("p"),ut.textContent=In,Yo=n(),A=a("div"),p(Xe.$$.fragment),Ao=n(),gt=a("p"),gt.textContent=Wn,Qo=n(),Q=a("div"),p(Le.$$.fragment),qo=n(),ht=a("p"),ht.textContent=Bn,Ht=n(),p(ze.$$.fragment),Yt=n(),P=a("div"),p(Ee.$$.fragment),Oo=n(),_t=a("p"),_t.textContent=Xn,At=n(),bt=a("p"),this.h()},l(e){const i=Fn("svelte-u9bgzb",document.head);_=r(i,"META",{name:!0,content:!0}),i.forEach(o),D=s(e),w=r(e,"P",{}),M(w).forEach(o),y=s(e),c(J.$$.fragment,e),h=s(e),c($.$$.fragment,e),Tt=s(e),K=r(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1gxmldy"&&(K.innerHTML=en),yt=s(e),ee=r(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1cwsb16"&&(ee.textContent=tn),xt=s(e),te=r(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1t7ua5b"&&(te.innerHTML=on),wt=s(e),oe=r(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-9292p9"&&(oe.innerHTML=nn),Mt=s(e),c(ne.$$.fragment,e),Vt=s(e),c(se.$$.fragment,e),Zt=s(e),ie=r(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-a4ktac"&&(ie.textContent=sn),Jt=s(e),c(ae.$$.fragment,e),$t=s(e),re=r(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1gwbshq"&&(re.textContent=an),Dt=s(e),le=r(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-yoc5w4"&&(le.textContent=rn),kt=s(e),c(de.$$.fragment,e),jt=s(e),pe=r(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-m9rmsr"&&(pe.innerHTML=ln),Ct=s(e),ce=r(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1yxs7ur"&&(ce.textContent=dn),St=s(e),c(me.$$.fragment,e),Pt=s(e),fe=r(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1g617uu"&&(fe.textContent=pn),Ut=s(e),ue=r(e,"TABLE",{"data-svelte-h":!0}),d(ue)!=="svelte-5s26g4"&&(ue.innerHTML=cn),Gt=s(e),c(ge.$$.fragment,e),It=s(e),he=r(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-zokgby"&&(he.innerHTML=mn),Wt=s(e),c(_e.$$.fragment,e),Bt=s(e),ve=r(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-4ywac8"&&(ve.textContent=fn),Xt=s(e),c(be.$$.fragment,e),Lt=s(e),Te=r(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1g617uu"&&(Te.textContent=un),zt=s(e),ye=r(e,"TABLE",{"data-svelte-h":!0}),d(ye)!=="svelte-9iw63g"&&(ye.innerHTML=gn),Et=s(e),c(xe.$$.fragment,e),Nt=s(e),v=r(e,"DIV",{class:!0});var T=M(v);c(we.$$.fragment,T),po=s(T),He=r(T,"P",{"data-svelte-h":!0}),d(He)!=="svelte-19ipoo4"&&(He.textContent=hn),co=s(T),Ye=r(T,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-cgt1gx"&&(Ye.innerHTML=_n),mo=s(T),C=r(T,"DIV",{class:!0});var U=M(C);c(Me.$$.fragment,U),fo=s(U),Ae=r(U,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-50j04k"&&(Ae.textContent=vn),uo=s(U),c(I.$$.fragment,U),U.forEach(o),go=s(T),W=r(T,"DIV",{class:!0});var Ne=M(W);c(Ve.$$.fragment,Ne),ho=s(Ne),Qe=r(Ne,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-psupw6"&&(Qe.textContent=bn),Ne.forEach(o),_o=s(T),B=r(T,"DIV",{class:!0});var qt=M(B);c(Ze.$$.fragment,qt),vo=s(qt),qe=r(qt,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1s3c06i"&&(qe.innerHTML=Tn),qt.forEach(o),bo=s(T),X=r(T,"DIV",{class:!0});var Ot=M(X);c(Je.$$.fragment,Ot),To=s(Ot),Oe=r(Ot,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-pkn4ui"&&(Oe.innerHTML=yn),Ot.forEach(o),yo=s(T),k=r(T,"DIV",{class:!0});var q=M(k);c($e.$$.fragment,q),xo=s(q),Ke=r(q,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-1f3tmq1"&&(Ke.innerHTML=xn),wo=s(q),et=r(q,"P",{"data-svelte-h":!0}),d(et)!=="svelte-xjijlp"&&(et.textContent=wn),Mo=s(q),tt=r(q,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-hy0nzs"&&(tt.innerHTML=Mn),q.forEach(o),Vo=s(T),L=r(T,"DIV",{class:!0});var Kt=M(L);c(De.$$.fragment,Kt),Zo=s(Kt),ot=r(Kt,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-14bnrb6"&&(ot.textContent=Vn),Kt.forEach(o),Jo=s(T),z=r(T,"DIV",{class:!0});var eo=M(z);c(ke.$$.fragment,eo),$o=s(eo),nt=r(eo,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-1xwrf7t"&&(nt.textContent=Zn),eo.forEach(o),Do=s(T),E=r(T,"DIV",{class:!0});var to=M(E);c(je.$$.fragment,to),ko=s(to),st=r(to,"P",{"data-svelte-h":!0}),d(st)!=="svelte-16q0ax1"&&(st.textContent=Jn),to.forEach(o),T.forEach(o),Rt=s(e),c(Ce.$$.fragment,e),Ft=s(e),b=r(e,"DIV",{class:!0});var x=M(b);c(Se.$$.fragment,x),jo=s(x),it=r(x,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1oyadpc"&&(it.textContent=$n),Co=s(x),at=r(x,"P",{"data-svelte-h":!0}),d(at)!=="svelte-cgt1gx"&&(at.innerHTML=Dn),So=s(x),S=r(x,"DIV",{class:!0});var vt=M(S);c(Pe.$$.fragment,vt),Po=s(vt),rt=r(vt,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-50j04k"&&(rt.textContent=kn),Uo=s(vt),c(N.$$.fragment,vt),vt.forEach(o),Go=s(x),R=r(x,"DIV",{class:!0});var oo=M(R);c(Ue.$$.fragment,oo),Io=s(oo),lt=r(oo,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-psupw6"&&(lt.textContent=jn),oo.forEach(o),Wo=s(x),F=r(x,"DIV",{class:!0});var no=M(F);c(Ge.$$.fragment,no),Bo=s(no),dt=r(no,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-1s3c06i"&&(dt.innerHTML=Cn),no.forEach(o),Xo=s(x),H=r(x,"DIV",{class:!0});var so=M(H);c(Ie.$$.fragment,so),Lo=s(so),pt=r(so,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-pkn4ui"&&(pt.innerHTML=Sn),so.forEach(o),zo=s(x),j=r(x,"DIV",{class:!0});var O=M(j);c(We.$$.fragment,O),Eo=s(O),ct=r(O,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-1f3tmq1"&&(ct.innerHTML=Pn),No=s(O),mt=r(O,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-xjijlp"&&(mt.textContent=Un),Ro=s(O),ft=r(O,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-hy0nzs"&&(ft.innerHTML=Gn),O.forEach(o),Fo=s(x),Y=r(x,"DIV",{class:!0});var io=M(Y);c(Be.$$.fragment,io),Ho=s(io),ut=r(io,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-14bnrb6"&&(ut.textContent=In),io.forEach(o),Yo=s(x),A=r(x,"DIV",{class:!0});var ao=M(A);c(Xe.$$.fragment,ao),Ao=s(ao),gt=r(ao,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-1xwrf7t"&&(gt.textContent=Wn),ao.forEach(o),Qo=s(x),Q=r(x,"DIV",{class:!0});var ro=M(Q);c(Le.$$.fragment,ro),qo=s(ro),ht=r(ro,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-16q0ax1"&&(ht.textContent=Bn),ro.forEach(o),x.forEach(o),Ht=s(e),c(ze.$$.fragment,e),Yt=s(e),P=r(e,"DIV",{class:!0});var lo=M(P);c(Ee.$$.fragment,lo),Oo=s(lo),_t=r(lo,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-1uuckb2"&&(_t.textContent=Xn),lo.forEach(o),At=s(e),bt=r(e,"P",{}),M(bt).forEach(o),this.h()},h(){V(_,"name","hf:doc:metadata"),V(_,"content",On),V(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,_),l(e,D,i),l(e,w,i),l(e,y,i),m(J,e,i),l(e,h,i),m($,e,i),l(e,Tt,i),l(e,K,i),l(e,yt,i),l(e,ee,i),l(e,xt,i),l(e,te,i),l(e,wt,i),l(e,oe,i),l(e,Mt,i),m(ne,e,i),l(e,Vt,i),m(se,e,i),l(e,Zt,i),l(e,ie,i),l(e,Jt,i),m(ae,e,i),l(e,$t,i),l(e,re,i),l(e,Dt,i),l(e,le,i),l(e,kt,i),m(de,e,i),l(e,jt,i),l(e,pe,i),l(e,Ct,i),l(e,ce,i),l(e,St,i),m(me,e,i),l(e,Pt,i),l(e,fe,i),l(e,Ut,i),l(e,ue,i),l(e,Gt,i),m(ge,e,i),l(e,It,i),l(e,he,i),l(e,Wt,i),m(_e,e,i),l(e,Bt,i),l(e,ve,i),l(e,Xt,i),m(be,e,i),l(e,Lt,i),l(e,Te,i),l(e,zt,i),l(e,ye,i),l(e,Et,i),m(xe,e,i),l(e,Nt,i),l(e,v,i),m(we,v,null),t(v,po),t(v,He),t(v,co),t(v,Ye),t(v,mo),t(v,C),m(Me,C,null),t(C,fo),t(C,Ae),t(C,uo),m(I,C,null),t(v,go),t(v,W),m(Ve,W,null),t(W,ho),t(W,Qe),t(v,_o),t(v,B),m(Ze,B,null),t(B,vo),t(B,qe),t(v,bo),t(v,X),m(Je,X,null),t(X,To),t(X,Oe),t(v,yo),t(v,k),m($e,k,null),t(k,xo),t(k,Ke),t(k,wo),t(k,et),t(k,Mo),t(k,tt),t(v,Vo),t(v,L),m(De,L,null),t(L,Zo),t(L,ot),t(v,Jo),t(v,z),m(ke,z,null),t(z,$o),t(z,nt),t(v,Do),t(v,E),m(je,E,null),t(E,ko),t(E,st),l(e,Rt,i),m(Ce,e,i),l(e,Ft,i),l(e,b,i),m(Se,b,null),t(b,jo),t(b,it),t(b,Co),t(b,at),t(b,So),t(b,S),m(Pe,S,null),t(S,Po),t(S,rt),t(S,Uo),m(N,S,null),t(b,Go),t(b,R),m(Ue,R,null),t(R,Io),t(R,lt),t(b,Wo),t(b,F),m(Ge,F,null),t(F,Bo),t(F,dt),t(b,Xo),t(b,H),m(Ie,H,null),t(H,Lo),t(H,pt),t(b,zo),t(b,j),m(We,j,null),t(j,Eo),t(j,ct),t(j,No),t(j,mt),t(j,Ro),t(j,ft),t(b,Fo),t(b,Y),m(Be,Y,null),t(Y,Ho),t(Y,ut),t(b,Yo),t(b,A),m(Xe,A,null),t(A,Ao),t(A,gt),t(b,Qo),t(b,Q),m(Le,Q,null),t(Q,qo),t(Q,ht),l(e,Ht,i),m(ze,e,i),l(e,Yt,i),l(e,P,i),m(Ee,P,null),t(P,Oo),t(P,_t),l(e,At,i),l(e,bt,i),Qt=!0},p(e,[i]){const T={};i&2&&(T.$$scope={dirty:i,ctx:e}),J.$set(T);const U={};i&2&&(U.$$scope={dirty:i,ctx:e}),I.$set(U);const Ne={};i&2&&(Ne.$$scope={dirty:i,ctx:e}),N.$set(Ne)},i(e){Qt||(f(J.$$.fragment,e),f($.$$.fragment,e),f(ne.$$.fragment,e),f(se.$$.fragment,e),f(ae.$$.fragment,e),f(de.$$.fragment,e),f(me.$$.fragment,e),f(ge.$$.fragment,e),f(_e.$$.fragment,e),f(be.$$.fragment,e),f(xe.$$.fragment,e),f(we.$$.fragment,e),f(Me.$$.fragment,e),f(I.$$.fragment,e),f(Ve.$$.fragment,e),f(Ze.$$.fragment,e),f(Je.$$.fragment,e),f($e.$$.fragment,e),f(De.$$.fragment,e),f(ke.$$.fragment,e),f(je.$$.fragment,e),f(Ce.$$.fragment,e),f(Se.$$.fragment,e),f(Pe.$$.fragment,e),f(N.$$.fragment,e),f(Ue.$$.fragment,e),f(Ge.$$.fragment,e),f(Ie.$$.fragment,e),f(We.$$.fragment,e),f(Be.$$.fragment,e),f(Xe.$$.fragment,e),f(Le.$$.fragment,e),f(ze.$$.fragment,e),f(Ee.$$.fragment,e),Qt=!0)},o(e){u(J.$$.fragment,e),u($.$$.fragment,e),u(ne.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(ge.$$.fragment,e),u(_e.$$.fragment,e),u(be.$$.fragment,e),u(xe.$$.fragment,e),u(we.$$.fragment,e),u(Me.$$.fragment,e),u(I.$$.fragment,e),u(Ve.$$.fragment,e),u(Ze.$$.fragment,e),u(Je.$$.fragment,e),u($e.$$.fragment,e),u(De.$$.fragment,e),u(ke.$$.fragment,e),u(je.$$.fragment,e),u(Ce.$$.fragment,e),u(Se.$$.fragment,e),u(Pe.$$.fragment,e),u(N.$$.fragment,e),u(Ue.$$.fragment,e),u(Ge.$$.fragment,e),u(Ie.$$.fragment,e),u(We.$$.fragment,e),u(Be.$$.fragment,e),u(Xe.$$.fragment,e),u(Le.$$.fragment,e),u(ze.$$.fragment,e),u(Ee.$$.fragment,e),Qt=!1},d(e){e&&(o(D),o(w),o(y),o(h),o(Tt),o(K),o(yt),o(ee),o(xt),o(te),o(wt),o(oe),o(Mt),o(Vt),o(Zt),o(ie),o(Jt),o($t),o(re),o(Dt),o(le),o(kt),o(jt),o(pe),o(Ct),o(ce),o(St),o(Pt),o(fe),o(Ut),o(ue),o(Gt),o(It),o(he),o(Wt),o(Bt),o(ve),o(Xt),o(Lt),o(Te),o(zt),o(ye),o(Et),o(Nt),o(v),o(Rt),o(Ft),o(b),o(Ht),o(Yt),o(P),o(At),o(bt)),o(_),g(J,e),g($,e),g(ne,e),g(se,e),g(ae,e),g(de,e),g(me,e),g(ge,e),g(_e,e),g(be,e),g(xe,e),g(we),g(Me),g(I),g(Ve),g(Ze),g(Je),g($e),g(De),g(ke),g(je),g(Ce,e),g(Se),g(Pe),g(N),g(Ue),g(Ge),g(Ie),g(We),g(Be),g(Xe),g(Le),g(ze,e),g(Ee)}}}const On='{"title":"Text-to-video","local":"text-to-video","sections":[{"title":"Usage example","local":"usage-example","sections":[{"title":"text-to-video-ms-1.7b","local":"text-to-video-ms-17b","sections":[],"depth":3},{"title":"cerspense/zeroscope_v2_576w & cerspense/zeroscope_v2_XL","local":"cerspensezeroscopev2576w--cerspensezeroscopev2xl","sections":[],"depth":3}],"depth":2},{"title":"TextToVideoSDPipeline","local":"diffusers.TextToVideoSDPipeline","sections":[],"depth":2},{"title":"VideoToVideoSDPipeline","local":"diffusers.VideoToVideoSDPipeline","sections":[],"depth":2},{"title":"TextToVideoSDPipelineOutput","local":"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput","sections":[],"depth":2}],"depth":1}';function Kn(G){return En(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rs extends Nn{constructor(_){super(),Rn(this,_,Kn,qn,zn,{})}}export{rs as component};
