import{s as k0,o as T0,n as H}from"../chunks/scheduler.6062bdaf.js";import{S as q0,i as M0,g as c,s,r as u,A as j0,h as l,f as p,c as r,j as q,u as h,x as d,k as M,y as n,a as $,v as f,d as m,t as _,w as b,m as H0,n as C0}from"../chunks/index.4bca734e.js";import{T as I}from"../chunks/Tip.b9ac1f03.js";import{D as j}from"../chunks/Docstring.81ba5e3c.js";import{C}from"../chunks/CodeBlock.fa01571c.js";import{E as U}from"../chunks/ExampleCodeBlock.30e7542f.js";import{H as R,E as U0}from"../chunks/EditOnGithub.74ab2baa.js";function I0(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGFkZF9jb2xsZWN0aW9uX2l0ZW0lMEFjb2xsZWN0aW9uJTIwJTNEJTIwYWRkX2NvbGxlY3Rpb25faXRlbSglMEElMjAlMjAlMjAlMjBjb2xsZWN0aW9uX3NsdWclM0QlMjJkYXZhbnN0cmllbiUyRmNsaW1hdGUtNjRmOTlkYzJhNTA2N2Y2YjY1NTMxYmFiJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXRlbV9pZCUzRCUyMnBpZXJyZS1sb2ljJTJGY2xpbWF0ZS1uZXdzLWFydGljbGVzJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXRlbV90eXBlJTNEJTIyZGF0YXNldCUyMiUwQSklMEFjb2xsZWN0aW9uLml0ZW1zJTVCLTElNUQuaXRlbV9pZCUwQSUwQWFkZF9jb2xsZWN0aW9uX2l0ZW0oJTBBJTIwJTIwJTIwJTIwY29sbGVjdGlvbl9zbHVnJTNEJTIyZGF2YW5zdHJpZW4lMkZjbGltYXRlLTY0Zjk5ZGMyYTUwNjdmNmI2NTUzMWJhYiUyMiUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1faWQlM0QlMjJkYXRhc2V0cyUyRmNsaW1hdGVfZmV2ZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBpdGVtX3R5cGUlM0QlMjJkYXRhc2V0JTIyJTBBJTIwJTIwJTIwJTIwbm90ZSUzRCUyMlRoaXMlMjBkYXRhc2V0JTIwYWRvcHRzJTIwdGhlJTIwRkVWRVIlMjBtZXRob2RvbG9neSUyMHRoYXQlMjBjb25zaXN0cyUyMG9mJTIwMSUyQzUzNSUyMHJlYWwtd29ybGQlMjBjbGFpbXMlMjByZWdhcmRpbmclMjBjbGltYXRlLWNoYW5nZSUyMGNvbGxlY3RlZCUyMG9uJTIwdGhlJTIwaW50ZXJuZXQuJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> add_collection_item
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = add_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;davanstrien/climate-64f99dc2a5067f6b65531bab&quot;</span>,
<span class="hljs-meta">... </span>    item_id=<span class="hljs-string">&quot;pierre-loic/climate-news-articles&quot;</span>,
<span class="hljs-meta">... </span>    item_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.items[-<span class="hljs-number">1</span>].item_id
<span class="hljs-string">&quot;pierre-loic/climate-news-articles&quot;</span>
<span class="hljs-comment"># ^item got added to the collection on last position</span>

<span class="hljs-comment"># Add item with a note</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>add_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;davanstrien/climate-64f99dc2a5067f6b65531bab&quot;</span>,
<span class="hljs-meta">... </span>    item_id=<span class="hljs-string">&quot;datasets/climate_fever&quot;</span>,
<span class="hljs-meta">... </span>    item_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>    note=<span class="hljs-string">&quot;This dataset adopts the FEVER methodology that consists of 1,535 real-world claims regarding climate-change collected on the internet.&quot;</span>
<span class="hljs-meta">... </span>)
(...)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function A0(T){let o,v="Check if the user has access to a repository:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGF1dGhfY2hlY2slMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViLnV0aWxzJTIwaW1wb3J0JTIwR2F0ZWRSZXBvRXJyb3IlMkMlMjBSZXBvc2l0b3J5Tm90Rm91bmRFcnJvciUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> auth_check
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.utils <span class="hljs-keyword">import</span> GatedRepoError, RepositoryNotFoundError

<span class="hljs-keyword">try</span>:
    auth_check(<span class="hljs-string">&quot;user/my-cool-model&quot;</span>)
<span class="hljs-keyword">except</span> GatedRepoError:
    <span class="hljs-comment"># Handle gated repository error</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;You do not have permission to access this gated repository.&quot;</span>)
<span class="hljs-keyword">except</span> RepositoryNotFoundError:
    <span class="hljs-comment"># Handle repository not found error</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The repository was not found or you do not have access.&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-12u7bhh"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function N0(T){let o,v="Examples:",i,a,g;return a=new C({props:{code:"bmV3X3RpdGxlJTIwJTNEJTIwJTIyTmV3JTIwdGl0bGUlMkMlMjBmaXhpbmclMjBhJTIwdHlwbyUyMiUwQUhmQXBpKCkucmVuYW1lX2Rpc2N1c3Npb24oJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGcmVwb19uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGlzY3Vzc2lvbl9udW0lM0QzNCUwQSUyMCUyMCUyMCUyMG5ld190aXRsZSUzRG5ld190aXRsZSUwQSklMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>new_title = <span class="hljs-string">&quot;New title, fixing a typo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi().rename_discussion(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo_name&quot;</span>,
<span class="hljs-meta">... </span>    discussion_num=<span class="hljs-number">34</span>
<span class="hljs-meta">... </span>    new_title=new_title
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># DiscussionStatusChange(id=&#x27;deadbeef0000000&#x27;, type=&#x27;status-change&#x27;, ...)</span>
`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function J0(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function E0(T){let o,v="Examples:",i,a,g;return a=new C({props:{code:"JTBBY29tbWVudCUyMCUzRCUyMCUyMiUyMiUyMiUwQUhlbGxvJTIwJTQwb3RoZXJ1c2VyISUwQSUyMyUyMFRoaXMlMjBpcyUyMGElMjB0aXRsZSUwQSoqVGhpcyUyMGlzJTIwYm9sZCoqJTJDJTIwKnRoaXMlMjBpcyUyMGl0YWxpYyolMjBhbmQlMjB+dGhpcyUyMGlzJTIwc3RyaWtldGhyb3VnaH4lMEFBbmQlMjAlNUJ0aGlzJTVEKGh0dHAlM0ElMkYlMkZ1cmwpJTIwaXMlMjBhJTIwbGluayUwQSUyMiUyMiUyMiUwQSUwQUhmQXBpKCkuY29tbWVudF9kaXNjdXNzaW9uKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRnJlcG9fbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGRpc2N1c3Npb25fbnVtJTNEMzQlMEElMjAlMjAlMjAlMjBjb21tZW50JTNEY29tbWVudCUwQSklMEE=",highlighted:`
<span class="hljs-meta">&gt;&gt;&gt; </span>comment = <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>Hello @otheruser!
...
<span class="hljs-meta">... </span># This is a title
...
<span class="hljs-meta">... </span>**This is bold**, *this is italic* and ~this is strikethrough~
<span class="hljs-meta">... </span>And [this](http://url) is a link
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi().comment_discussion(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo_name&quot;</span>,
<span class="hljs-meta">... </span>    discussion_num=<span class="hljs-number">34</span>
<span class="hljs-meta">... </span>    comment=comment
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># DiscussionComment(id=&#x27;deadbeef0000000&#x27;, type=&#x27;comment&#x27;, ...)</span>
`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function D0(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function R0(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGNyZWF0ZV9jb2xsZWN0aW9uKCUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIySUNDViUyMDIwMjMlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlBvcnRmb2xpbyUyMG9mJTIwbW9kZWxzJTJDJTIwcGFwZXJzJTIwYW5kJTIwZGVtb3MlMjBJJTIwcHJlc2VudGVkJTIwYXQlMjBJQ0NWJTIwMjAyMyUyMiUyQyUwQSklMEFjb2xsZWN0aW9uLnNsdWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = create_collection(
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;ICCV 2023&quot;</span>,
<span class="hljs-meta">... </span>    description=<span class="hljs-string">&quot;Portfolio of models, papers and demos I presented at ICCV 2023&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.slug
<span class="hljs-string">&quot;username/iccv-2023-64f9a55bb3115b4f513ec026&quot;</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function F0(T){let o,v=`The input list of <code>CommitOperation</code> will be mutated during the commit process. Do not reuse the same objects
for multiple commits.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1i3qk8u"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function S0(T){let o,v=`<code>create_commit</code> assumes that the repo already exists on the Hub. If you get a
Client error 404, please make sure you are authenticated and that <code>repo_id</code> and
<code>repo_type</code> are set correctly. If repo does not exist, create it first using
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-f4qclq"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function G0(T){let o,v="<code>create_commit</code> is limited to 25k LFS files and a 1GB payload for regular files.";return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-yun5lq"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function L0(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function Z0(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIybXktZW5kcG9pbnQtbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9zaXRvcnklM0QlMjJncHQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDIlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIyaW50ZWwtaWNsJTIyJTJDJTBBKSUwQWVuZHBvaW50JTBBJTBBZW5kcG9pbnQuY2xpZW50LnRleHRfZ2VuZXJhdGlvbiguLi4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;my-endpoint-name&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;gpt2&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;cpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x2&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, status=<span class="hljs-string">&quot;pending&quot;</span>,...)

<span class="hljs-comment"># Run inference on the endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_generation(...)
<span class="hljs-string">&quot;...&quot;</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function V0(T){let o,v;return o=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIyYXdzLXplcGh5ci03Yi1iZXRhLTA0ODYlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvc2l0b3J5JTNEJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmdwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDElMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIybnZpZGlhLWExMGclMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21faW1hZ2UlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoZWFsdGhfcm91dGUlMjIlM0ElMjAlMjIlMkZoZWFsdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnYlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfQkFUQ0hfUFJFRklMTF9UT0tFTlMlMjIlM0ElMjAlMjIyMDQ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX0xFTkdUSCUyMiUzQSUyMCUyMjEwMjQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMTUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyJTJGcmVwb3NpdG9yeSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmdoY3IuaW8lMkZodWdnaW5nZmFjZSUyRnRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UlM0ExLjEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMHNlY3JldHMlM0QlN0IlMjJNWV9TRUNSRVRfS0VZJTIyJTNBJTIwJTIyc2VjcmV0X3ZhbHVlJTIyJTdEJTJDJTBBKSUwQQ==",highlighted:`<span class="hljs-comment"># Start an Inference Endpoint running Zephyr-7b-beta on TGI</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;aws-zephyr-7b-beta-0486&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x1&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;nvidia-a10g&quot;</span>,
<span class="hljs-meta">... </span>    custom_image={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;env&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;2048&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_INPUT_LENGTH&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1512&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:1.1.0&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>   secrets={<span class="hljs-string">&quot;MY_SECRET_KEY&quot;</span>: <span class="hljs-string">&quot;secret_value&quot;</span>},
<span class="hljs-meta">... </span>)
`,wrap:!1}}),{c(){u(o.$$.fragment)},l(i){h(o.$$.fragment,i)},m(i,a){f(o,i,a),v=!0},p:H,i(i){v||(m(o.$$.fragment,i),v=!0)},o(i){_(o.$$.fragment,i),v=!1},d(i){b(o,i)}}}function P0(T){let o,v=`<code>create_inference_endpoint_from_catalog</code> is experimental. Its API is subject to change in the future. Please provide feedback
if you have any suggestions or requests.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1bm6hf4"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function W0(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function B0(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV93ZWJob29rJTBBcGF5bG9hZCUyMCUzRCUyMGNyZWF0ZV93ZWJob29rKCUwQSUyMCUyMCUyMCUyMHdhdGNoZWQlM0QlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMm5hbWUlMjIlM0ElMjAlMjJqdWxpZW4tYyUyMiU3RCUyQyUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJvcmclMjIlMkMlMjAlMjJuYW1lJTIyJTNBJTIwJTIySHVnZ2luZ0ZhY2VINCUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMHVybCUzRCUyMmh0dHBzJTNBJTJGJTJGd2ViaG9vay5zaXRlJTJGYTIxNzZlODItNTcyMC00M2VlLTllMDYtZjkxY2I0YzkxNTQ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwZG9tYWlucyUzRCU1QiUyMnJlcG8lMjIlMkMlMjAlMjJkaXNjdXNzaW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2VjcmV0JTNEJTIybXktc2VjcmV0JTIyJTJDJTBBKSUwQXByaW50KHBheWxvYWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>payload = create_webhook(
<span class="hljs-meta">... </span>    watched=[{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;julien-c&quot;</span>}, {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;org&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;HuggingFaceH4&quot;</span>}],
<span class="hljs-meta">... </span>    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
<span class="hljs-meta">... </span>    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
<span class="hljs-meta">... </span>    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(payload)
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function Y0(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-117o2wk"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function X0(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRlbGV0ZV9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGRlbGV0ZV9jb2xsZWN0aW9uKCUyMnVzZXJuYW1lJTJGdXNlbGVzcy1jb2xsZWN0aW9uLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUyMG1pc3Npbmdfb2slM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> delete_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = delete_collection(<span class="hljs-string">&quot;username/useless-collection-64f9a55bb3115b4f513ec026&quot;</span>, missing_ok=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function z0(T){let o,v="This is a non-revertible action. A deleted collection cannot be restored.";return{c(){o=c("p"),o.textContent=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1k7dttx"&&(o.textContent=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function O0(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTJDJTIwZGVsZXRlX2NvbGxlY3Rpb25faXRlbSUwQSUwQWNvbGxlY3Rpb24lMjAlM0QlMjBnZXRfY29sbGVjdGlvbiglMjJUaGVCbG9rZSUyRnJlY2VudC1tb2RlbHMtNjRmOWE1NWJiMzExNWI0ZjUxM2VjMDI2JTIyKSUwQSUwQWRlbGV0ZV9jb2xsZWN0aW9uX2l0ZW0oJTBBJTIwJTIwJTIwJTIwY29sbGVjdGlvbl9zbHVnJTNEJTIyVGhlQmxva2UlMkZyZWNlbnQtbW9kZWxzLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1fb2JqZWN0X2lkJTNEY29sbGVjdGlvbi5pdGVtcyU1Qi0xJTVELml0ZW1fb2JqZWN0X2lkJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection, delete_collection_item

<span class="hljs-comment"># Get collection first</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>)

<span class="hljs-comment"># Delete item based on its ID</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>delete_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>,
<span class="hljs-meta">... </span>    item_object_id=collection.items[-<span class="hljs-number">1</span>].item_object_id,
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function Q0(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError">EntryNotFoundError</a>
If the file to download cannot be found.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1hfnpzg"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function K0(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRlbGV0ZV93ZWJob29rJTBBZGVsZXRlX3dlYmhvb2soJTIyNjU0YmJiYzE2ZjJlYzE0ZDc3ZjEwOWNjJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> delete_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>delete_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function eq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRpc2FibGVfd2ViaG9vayUwQWRpc2FibGVkX3dlYmhvb2slMjAlM0QlMjBkaXNhYmxlX3dlYmhvb2soJTIyNjU0YmJiYzE2ZjJlYzE0ZDc3ZjEwOWNjJTIyKSUwQWRpc2FibGVkX3dlYmhvb2s=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> disable_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>disabled_webhook = disable_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>disabled_webhook
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function tq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGR1cGxpY2F0ZV9zcGFjZSUwQSUwQWR1cGxpY2F0ZV9zcGFjZSglMjJtdWx0aW1vZGFsYXJ0JTJGZHJlYW1ib290aC10cmFpbmluZyUyMiklMEElMEFkdXBsaWNhdGVfc3BhY2UoJTIybXVsdGltb2RhbGFydCUyRmRyZWFtYm9vdGgtdHJhaW5pbmclMjIlMkMlMjB0b19pZCUzRCUyMm15LWRyZWFtYm9vdGglMjIlMkMlMjBwcml2YXRlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> duplicate_space

<span class="hljs-comment"># Duplicate a Space to your account</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/spaces/nateraw/dreambooth-training&#x27;</span>,...)

<span class="hljs-comment"># Can set custom destination id and visibility flag.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>, to_id=<span class="hljs-string">&quot;my-dreambooth&quot;</span>, private=<span class="hljs-literal">True</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/spaces/nateraw/my-dreambooth&#x27;</span>,...)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function nq(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function oq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGVuYWJsZV93ZWJob29rJTBBZW5hYmxlZF93ZWJob29rJTIwJTNEJTIwZW5hYmxlX3dlYmhvb2soJTIyNjU0YmJiYzE2ZjJlYzE0ZDc3ZjEwOWNjJTIyKSUwQWVuYWJsZWRfd2ViaG9vaw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> enable_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>enabled_webhook = enable_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>enabled_webhook
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function aq(T){let o,v="Examples:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGZpbGVfZXhpc3RzJTBBZmlsZV9leGlzdHMoJTIyYmlnY29kZSUyRnN0YXJjb2RlciUyMiUyQyUyMCUyMmNvbmZpZy5qc29uJTIyKSUwQWZpbGVfZXhpc3RzKCUyMmJpZ2NvZGUlMkZzdGFyY29kZXIlMjIlMkMlMjAlMjJub3QtYS1maWxlJTIyKSUwQWZpbGVfZXhpc3RzKCUyMmJpZ2NvZGUlMkZub3QtYS1yZXBvJTIyJTJDJTIwJTIyY29uZmlnLmpzb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> file_exists
<span class="hljs-meta">&gt;&gt;&gt; </span>file_exists(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>, <span class="hljs-string">&quot;config.json&quot;</span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_exists(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>, <span class="hljs-string">&quot;not-a-file&quot;</span>)
<span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_exists(<span class="hljs-string">&quot;bigcode/not-a-repo&quot;</span>, <span class="hljs-string">&quot;config.json&quot;</span>)
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function sq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGdldF9jb2xsZWN0aW9uKCUyMlRoZUJsb2tlJTJGcmVjZW50LW1vZGVscy02NGY5YTU1YmIzMTE1YjRmNTEzZWMwMjYlMjIpJTBBY29sbGVjdGlvbi50aXRsZSUwQWxlbihjb2xsZWN0aW9uLml0ZW1zKSUwQWNvbGxlY3Rpb24uaXRlbXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.title
<span class="hljs-string">&#x27;Recent models&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(collection.items)
<span class="hljs-number">37</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.items[<span class="hljs-number">0</span>]
CollectionItem(
    item_object_id=<span class="hljs-string">&#x27;651446103cd773a050bf64c2&#x27;</span>,
    item_id=<span class="hljs-string">&#x27;TheBloke/U-Amethyst-20B-AWQ&#x27;</span>,
    item_type=<span class="hljs-string">&#x27;model&#x27;</span>,
    position=<span class="hljs-number">88</span>,
    note=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function rq(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function iq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmdldF9pbmZlcmVuY2VfZW5kcG9pbnQoJTIybXktdGV4dC10by1pbWFnZSUyMiklMEFlbmRwb2ludCUwQSUwQWVuZHBvaW50LnN0YXR1cyUwQWVuZHBvaW50LnVybCUwQSUwQWVuZHBvaW50LmNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.get_inference_endpoint(<span class="hljs-string">&quot;my-text-to-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-text-to-image&#x27;</span>, ...)

<span class="hljs-comment"># Get status</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.status
<span class="hljs-string">&#x27;running&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.url
<span class="hljs-string">&#x27;https://my-text-to-image.region.vendor.endpoints.huggingface.cloud&#x27;</span>

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_to_image(...)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function cq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9wYXRoc19pbmZvJTBBcGF0aHNfaW5mbyUyMCUzRCUyMGdldF9wYXRoc19pbmZvKCUyMmFsbGVuYWklMkZjNCUyMiUyQyUyMCU1QiUyMlJFQURNRS5tZCUyMiUyQyUyMCUyMmVuJTIyJTVEJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiklMEFwYXRoc19pbmZv",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_paths_info
<span class="hljs-meta">&gt;&gt;&gt; </span>paths_info = get_paths_info(<span class="hljs-string">&quot;allenai/c4&quot;</span>, [<span class="hljs-string">&quot;README.md&quot;</span>, <span class="hljs-string">&quot;en&quot;</span>], repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>paths_info
[
    RepoFile(path=<span class="hljs-string">&#x27;README.md&#x27;</span>, size=<span class="hljs-number">2379</span>, blob_id=<span class="hljs-string">&#x27;f84cb4c97182890fc1dbdeaf1a6a468fd27b4fff&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFolder(path=<span class="hljs-string">&#x27;en&#x27;</span>, tree_id=<span class="hljs-string">&#x27;dc943c4c40f53d02b31ced1defa7e5f438d5862e&#x27;</span>, last_commit=<span class="hljs-literal">None</span>)
]`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function lq(T){let o,v="Collecting all discussions of a repo in a list:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9yZXBvX2Rpc2N1c3Npb25zJTBBZGlzY3Vzc2lvbnNfbGlzdCUyMCUzRCUyMGxpc3QoZ2V0X3JlcG9fZGlzY3Vzc2lvbnMocmVwb19pZCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_repo_discussions
<span class="hljs-meta">&gt;&gt;&gt; </span>discussions_list = <span class="hljs-built_in">list</span>(get_repo_discussions(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>))`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1p6axsk"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function pq(T){let o,v="Iterating over discussions of a repo:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9yZXBvX2Rpc2N1c3Npb25zJTBBZm9yJTIwZGlzY3Vzc2lvbiUyMGluJTIwZ2V0X3JlcG9fZGlzY3Vzc2lvbnMocmVwb19pZCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGRpc2N1c3Npb24ubnVtJTJDJTIwZGlzY3Vzc2lvbi50aXRsZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_repo_discussions
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> discussion <span class="hljs-keyword">in</span> get_repo_discussions(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(discussion.num, discussion.title)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-121l6g4"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function dq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"bWV0YWRhdGElMjAlM0QlMjBnZXRfc2FmZXRlbnNvcnNfbWV0YWRhdGEoJTIyYmlnc2NpZW5jZSUyRmJsb29tei01NjBtJTIyKSUwQW1ldGFkYXRhJTBBbWV0YWRhdGEuZmlsZXNfbWV0YWRhdGElNUIlMjJtb2RlbC5zYWZldGVuc29ycyUyMiU1RC5tZXRhZGF0YSUwQSUwQW1ldGFkYXRhJTIwJTNEJTIwZ2V0X3NhZmV0ZW5zb3JzX21ldGFkYXRhKCUyMmJpZ3NjaWVuY2UlMkZibG9vbSUyMiklMEFtZXRhZGF0YSUwQWxlbihtZXRhZGF0YS5maWxlc19tZXRhZGF0YSklMEElMEFnZXRfc2FmZXRlbnNvcnNfbWV0YWRhdGEoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIp",highlighted:`<span class="hljs-comment"># Parse repo with single weights file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata = get_safetensors_metadata(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata
SafetensorsRepoMetadata(
    metadata=<span class="hljs-literal">None</span>,
    sharded=<span class="hljs-literal">False</span>,
    weight_map={<span class="hljs-string">&#x27;h.0.input_layernorm.bias&#x27;</span>: <span class="hljs-string">&#x27;model.safetensors&#x27;</span>, ...},
    files_metadata={<span class="hljs-string">&#x27;model.safetensors&#x27;</span>: SafetensorsFileMetadata(...)}
)
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata.files_metadata[<span class="hljs-string">&quot;model.safetensors&quot;</span>].metadata
{<span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;pt&#x27;</span>}

<span class="hljs-comment"># Parse repo with sharded model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata = get_safetensors_metadata(<span class="hljs-string">&quot;bigscience/bloom&quot;</span>)
Parse safetensors files: <span class="hljs-number">100</span>%|██████████████████████████████████████████| <span class="hljs-number">72</span>/<span class="hljs-number">72</span> [<span class="hljs-number">00</span>:<span class="hljs-number">12</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">5.78</span>it/s]
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata
SafetensorsRepoMetadata(metadata={<span class="hljs-string">&#x27;total_size&#x27;</span>: <span class="hljs-number">352494542848</span>}, sharded=<span class="hljs-literal">True</span>, weight_map={...}, files_metadata={...})
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(metadata.files_metadata)
<span class="hljs-number">72</span>  <span class="hljs-comment"># All safetensors files have been fetched</span>

<span class="hljs-comment"># Parse repo with sharded model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>get_safetensors_metadata(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
NotASafetensorsRepoError: <span class="hljs-string">&#x27;runwayml/stable-diffusion-v1-5&#x27;</span> <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> a safetensors repo. Couldn<span class="hljs-string">&#x27;t find &#x27;</span>model.safetensors.index.json<span class="hljs-string">&#x27; or &#x27;</span>model.safetensors<span class="hljs-string">&#x27; files.</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function gq(T){let o,v=`This method is deprecated and will be removed in version 1.0. Permissions are more complex than when
<code>get_token_permission</code> was first introduced. OAuth and fine-grain tokens allows for more detailed permissions.
If you need to know the permissions associated with a token, please use <code>whoami</code> and check the <code>&#39;auth&#39;</code> key.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1uyfywd"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function uq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF93ZWJob29rJTBBd2ViaG9vayUyMCUzRCUyMGdldF93ZWJob29rKCUyMjY1NGJiYmMxNmYyZWMxNGQ3N2YxMDljYyUyMiklMEFwcmludCh3ZWJob29rKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>webhook = get_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(webhook)
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function hq(T){let o,v;return o=new C({props:{code:"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",highlighted:`<span class="hljs-selector-attr">[  96]</span>  .
└── <span class="hljs-selector-attr">[ 160]</span>  models<span class="hljs-attr">--julien-c--EsperBERTo-small</span>
    ├── <span class="hljs-selector-attr">[ 160]</span>  blobs
    │   ├── <span class="hljs-selector-attr">[321M]</span>  <span class="hljs-number">403450</span>e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
    │   ├── <span class="hljs-selector-attr">[ 398]</span>  <span class="hljs-number">7</span>cb18dc9bafbfcf74629a4b760af1b160957a83e
    │   └── <span class="hljs-selector-attr">[1.4K]</span>  d7edf6bd2a681fb0175f7735299831ee1b22b812
    ├── <span class="hljs-selector-attr">[  96]</span>  refs
    │   └── <span class="hljs-selector-attr">[  40]</span>  <span class="hljs-selector-tag">main</span>
    └── <span class="hljs-selector-attr">[ 128]</span>  snapshots
        ├── <span class="hljs-selector-attr">[ 128]</span>  <span class="hljs-number">2439</span>f60ef33a0d46d85da5001d52aeda5b00ce9f
        │   ├── <span class="hljs-selector-attr">[  52]</span>  README<span class="hljs-selector-class">.md</span> -&gt; ../../blobs/d7edf6bd2a681fb0175f7735299831ee1b22b812
        │   └── <span class="hljs-selector-attr">[  76]</span>  pytorch_model<span class="hljs-selector-class">.bin</span> -&gt; ../../blobs/<span class="hljs-number">403450</span>e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
        └── <span class="hljs-selector-attr">[ 128]</span>  bbc77c8132af1cc5cf678da3f1ddf2de43606d48
            ├── <span class="hljs-selector-attr">[  52]</span>  README<span class="hljs-selector-class">.md</span> -&gt; ../../blobs/<span class="hljs-number">7</span>cb18dc9bafbfcf74629a4b760af1b160957a83e
            └── <span class="hljs-selector-attr">[  76]</span>  pytorch_model<span class="hljs-selector-class">.bin</span> -&gt; ../../blobs/<span class="hljs-number">403450</span>e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd`,wrap:!1}}),{c(){u(o.$$.fragment)},l(i){h(o.$$.fragment,i)},m(i,a){f(o,i,a),v=!0},p:H,i(i){v||(m(o.$$.fragment,i),v=!0)},o(i){_(o.$$.fragment,i),v=!1},d(i){b(o,i)}}}function fq(T){let o;return{c(){o=H0("Hidden comments' content cannot be retrieved anymore. Hiding a comment is irreversible.")},l(v){o=C0(v,"Hidden comments' content cannot be retrieved anymore. Hiding a comment is irreversible.")},m(v,i){$(v,o,i)},d(v){v&&p(o)}}}function mq(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function _q(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfYWNjZXB0ZWRfYWNjZXNzX3JlcXVlc3RzJTBBJTBBcmVxdWVzdHMlMjAlM0QlMjBsaXN0X2FjY2VwdGVkX2FjY2Vzc19yZXF1ZXN0cyglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03YiUyMiklMEFsZW4ocmVxdWVzdHMpJTBBcmVxdWVzdHMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_accepted_access_requests

<span class="hljs-meta">&gt;&gt;&gt; </span>requests = list_accepted_access_requests(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(requests)
<span class="hljs-number">411</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests[<span class="hljs-number">0</span>]
[
    AccessRequest(
        username=<span class="hljs-string">&#x27;clem&#x27;</span>,
        fullname=<span class="hljs-string">&#x27;Clem 🤗&#x27;</span>,
        email=<span class="hljs-string">&#x27;***&#x27;</span>,
        timestamp=datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">11</span>, <span class="hljs-number">23</span>, <span class="hljs-number">18</span>, <span class="hljs-number">4</span>, <span class="hljs-number">53</span>, <span class="hljs-number">828000</span>, tzinfo=datetime.timezone.utc),
        status=<span class="hljs-string">&#x27;accepted&#x27;</span>,
        fields=<span class="hljs-literal">None</span>,
    ),
    ...
]`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function bq(T){let o,v=`When listing collections, the item list per collection is truncated to 4 items maximum. To retrieve all items
from a collection, you must use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_collection">get_collection()</a>.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-m77nml"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function vq(T){let o,v="Example usage with the <code>filter</code> argument:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X2RhdGFzZXRzKCklMEElMEElMEFhcGkubGlzdF9kYXRhc2V0cyhmaWx0ZXIlM0QlMjJ0YXNrX2NhdGVnb3JpZXMlM0F0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyKSUwQSUwQSUwQWFwaS5saXN0X2RhdGFzZXRzKCUwQSUyMCUyMCUyMCUyMGZpbHRlciUzRCglMjJsYW5ndWFnZSUzQXJ1JTIyJTJDJTIwJTIydGFza19pZHMlM0FsYW5ndWFnZS1tb2RlbGluZyUyMiklMEEpJTBBJTBBYXBpLmxpc3RfZGF0YXNldHModGFncyUzRCUyMmZpZnR5b25lJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all datasets</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets()


<span class="hljs-comment"># List only the text classification datasets</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(<span class="hljs-built_in">filter</span>=<span class="hljs-string">&quot;task_categories:text-classification&quot;</span>)


<span class="hljs-comment"># List only the datasets in russian for language modeling</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(
<span class="hljs-meta">... </span>    <span class="hljs-built_in">filter</span>=(<span class="hljs-string">&quot;language:ru&quot;</span>, <span class="hljs-string">&quot;task_ids:language-modeling&quot;</span>)
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># List FiftyOne datasets (identified by the tag &quot;fiftyone&quot; in dataset card)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(tags=<span class="hljs-string">&quot;fiftyone&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.innerHTML=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1lrmw6w"&&(o.innerHTML=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function yq(T){let o,v="Example usage with the <code>search</code> argument:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X2RhdGFzZXRzKHNlYXJjaCUzRCUyMnRleHQlMjIpJTBBJTBBYXBpLmxpc3RfZGF0YXNldHMoc2VhcmNoJTNEJTIydGV4dCUyMiUyQyUyMGF1dGhvciUzRCUyMmdvb2dsZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all datasets with &quot;text&quot; in their name</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(search=<span class="hljs-string">&quot;text&quot;</span>)

<span class="hljs-comment"># List all datasets with &quot;text&quot; in their name made by google</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(search=<span class="hljs-string">&quot;text&quot;</span>, author=<span class="hljs-string">&quot;google&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.innerHTML=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1oyacuq"&&(o.innerHTML=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function xq(T){let o,v=`<code>list_inference_catalog</code> is experimental. Its API is subject to change in the future. Please provide feedback
if you have any suggestions or requests.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-jn3ftn"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function $q(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5saXN0X2luZmVyZW5jZV9lbmRwb2ludHMoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_inference_endpoints()
[InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint&#x27;</span>, ...), ...]`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function wq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfbGlrZWRfcmVwb3MlMEElMEFsaWtlcyUyMCUzRCUyMGxpc3RfbGlrZWRfcmVwb3MoJTIyanVsaWVuLWMlMjIpJTBBJTBBbGlrZXMudXNlciUwQSUwQWxpa2VzLm1vZGVscw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_liked_repos

<span class="hljs-meta">&gt;&gt;&gt; </span>likes = list_liked_repos(<span class="hljs-string">&quot;julien-c&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>likes.user
<span class="hljs-string">&quot;julien-c&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>likes.models
[<span class="hljs-string">&quot;osanseviero/streamlit_1.15&quot;</span>, <span class="hljs-string">&quot;Xhaheen/ChatGPT_HF&quot;</span>, ...]`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function kq(T){let o,v="Example usage with the <code>filter</code> argument:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X21vZGVscygpJTBBJTBBYXBpLmxpc3RfbW9kZWxzKGZpbHRlciUzRCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBYXBpLmxpc3RfbW9kZWxzKGZpbHRlciUzRCUyMmFsbGVubmxwJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all models</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models()

<span class="hljs-comment"># List only the text classification models</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(<span class="hljs-built_in">filter</span>=<span class="hljs-string">&quot;text-classification&quot;</span>)

<span class="hljs-comment"># List only models from the AllenNLP library</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(<span class="hljs-built_in">filter</span>=<span class="hljs-string">&quot;allennlp&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.innerHTML=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1lrmw6w"&&(o.innerHTML=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function Tq(T){let o,v="Example usage with the <code>search</code> argument:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X21vZGVscyhzZWFyY2glM0QlMjJiZXJ0JTIyKSUwQSUwQWFwaS5saXN0X21vZGVscyhzZWFyY2glM0QlMjJiZXJ0JTIyJTJDJTIwYXV0aG9yJTNEJTIyZ29vZ2xlJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all models with &quot;bert&quot; in their name</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(search=<span class="hljs-string">&quot;bert&quot;</span>)

<span class="hljs-comment"># List all models with &quot;bert&quot; in their name made by google</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(search=<span class="hljs-string">&quot;bert&quot;</span>, author=<span class="hljs-string">&quot;google&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.innerHTML=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1oyacuq"&&(o.innerHTML=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function qq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X3BhcGVycyhxdWVyeSUzRCUyMmF0dGVudGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all papers with &quot;attention&quot; in their title</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_papers(query=<span class="hljs-string">&quot;attention&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function Mq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcGVuZGluZ19hY2Nlc3NfcmVxdWVzdHMlMkMlMjBhY2NlcHRfYWNjZXNzX3JlcXVlc3QlMEElMEFyZXF1ZXN0cyUyMCUzRCUyMGxpc3RfcGVuZGluZ19hY2Nlc3NfcmVxdWVzdHMoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2IlMjIpJTBBbGVuKHJlcXVlc3RzKSUwQXJlcXVlc3RzJTVCMCU1RCUwQSUwQWFjY2VwdF9hY2Nlc3NfcmVxdWVzdCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03YiUyMiUyQyUyMCUyMmNsZW0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_pending_access_requests, accept_access_request

<span class="hljs-comment"># List pending requests</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests = list_pending_access_requests(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(requests)
<span class="hljs-number">411</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests[<span class="hljs-number">0</span>]
[
    AccessRequest(
        username=<span class="hljs-string">&#x27;clem&#x27;</span>,
        fullname=<span class="hljs-string">&#x27;Clem 🤗&#x27;</span>,
        email=<span class="hljs-string">&#x27;***&#x27;</span>,
        timestamp=datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">11</span>, <span class="hljs-number">23</span>, <span class="hljs-number">18</span>, <span class="hljs-number">4</span>, <span class="hljs-number">53</span>, <span class="hljs-number">828000</span>, tzinfo=datetime.timezone.utc),
        status=<span class="hljs-string">&#x27;pending&#x27;</span>,
        fields=<span class="hljs-literal">None</span>,
    ),
    ...
]

<span class="hljs-comment"># Accept Clem&#x27;s request</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>accept_access_request(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>, <span class="hljs-string">&quot;clem&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function jq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVqZWN0ZWRfYWNjZXNzX3JlcXVlc3RzJTBBJTBBcmVxdWVzdHMlMjAlM0QlMjBsaXN0X3JlamVjdGVkX2FjY2Vzc19yZXF1ZXN0cyglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03YiUyMiklMEFsZW4ocmVxdWVzdHMpJTBBcmVxdWVzdHMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_rejected_access_requests

<span class="hljs-meta">&gt;&gt;&gt; </span>requests = list_rejected_access_requests(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(requests)
<span class="hljs-number">411</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests[<span class="hljs-number">0</span>]
[
    AccessRequest(
        username=<span class="hljs-string">&#x27;clem&#x27;</span>,
        fullname=<span class="hljs-string">&#x27;Clem 🤗&#x27;</span>,
        email=<span class="hljs-string">&#x27;***&#x27;</span>,
        timestamp=datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">11</span>, <span class="hljs-number">23</span>, <span class="hljs-number">18</span>, <span class="hljs-number">4</span>, <span class="hljs-number">53</span>, <span class="hljs-number">828000</span>, tzinfo=datetime.timezone.utc),
        status=<span class="hljs-string">&#x27;rejected&#x27;</span>,
        fields=<span class="hljs-literal">None</span>,
    ),
    ...
]`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function Hq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWluaXRpYWxfY29tbWl0JTIwJTNEJTIwYXBpLmxpc3RfcmVwb19jb21taXRzKCUyMmdwdDIlMjIpJTVCLTElNUQlMEElMEFpbml0aWFsX2NvbW1pdCUwQSUwQWFwaS5jcmVhdGVfYnJhbmNoKCUyMmdwdDIlMjIlMkMlMjAlMjJuZXdfZW1wdHlfYnJhbmNoJTIyJTJDJTIwcmV2aXNpb24lM0Rpbml0aWFsX2NvbW1pdC5jb21taXRfaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># Commits are sorted by date (last commit first)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>initial_commit = api.list_repo_commits(<span class="hljs-string">&quot;gpt2&quot;</span>)[-<span class="hljs-number">1</span>]

<span class="hljs-comment"># Initial commit is always a system commit containing the \`.gitattributes\` file.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>initial_commit
GitCommitInfo(
    commit_id=<span class="hljs-string">&#x27;9b865efde13a30c13e0a33e536cf3e4a5a9d71d8&#x27;</span>,
    authors=[<span class="hljs-string">&#x27;system&#x27;</span>],
    created_at=datetime.datetime(<span class="hljs-number">2019</span>, <span class="hljs-number">2</span>, <span class="hljs-number">18</span>, <span class="hljs-number">10</span>, <span class="hljs-number">36</span>, <span class="hljs-number">15</span>, tzinfo=datetime.timezone.utc),
    title=<span class="hljs-string">&#x27;initial commit&#x27;</span>,
    message=<span class="hljs-string">&#x27;&#x27;</span>,
    formatted_title=<span class="hljs-literal">None</span>,
    formatted_message=<span class="hljs-literal">None</span>
)

<span class="hljs-comment"># Create an empty branch by deriving from initial commit</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_branch(<span class="hljs-string">&quot;gpt2&quot;</span>, <span class="hljs-string">&quot;new_empty_branch&quot;</span>, revision=initial_commit.commit_id)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function Cq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5saXN0X3JlcG9fcmVmcyglMjJncHQyJTIyKSUwQSUwQWFwaS5saXN0X3JlcG9fcmVmcyglMjJiaWdjb2RlJTJGdGhlLXN0YWNrJTIyJTJDJTIwcmVwb190eXBlJTNEJ2RhdGFzZXQnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_repo_refs(<span class="hljs-string">&quot;gpt2&quot;</span>)
GitRefs(branches=[GitRefInfo(name=<span class="hljs-string">&#x27;main&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/main&#x27;</span>, target_commit=<span class="hljs-string">&#x27;e7da7f221d5bf496a48136c0cd264e630fe9fcc8&#x27;</span>)], converts=[], tags=[])

<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_repo_refs(<span class="hljs-string">&quot;bigcode/the-stack&quot;</span>, repo_type=<span class="hljs-string">&#x27;dataset&#x27;</span>)
GitRefs(
    branches=[
        GitRefInfo(name=<span class="hljs-string">&#x27;main&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/main&#x27;</span>, target_commit=<span class="hljs-string">&#x27;18edc1591d9ce72aa82f56c4431b3c969b210ae3&#x27;</span>),
        GitRefInfo(name=<span class="hljs-string">&#x27;v1.1.a1&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/v1.1.a1&#x27;</span>, target_commit=<span class="hljs-string">&#x27;f9826b862d1567f3822d3d25649b0d6d22ace714&#x27;</span>)
    ],
    converts=[],
    tags=[
        GitRefInfo(name=<span class="hljs-string">&#x27;v1.0&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/tags/v1.0&#x27;</span>, target_commit=<span class="hljs-string">&#x27;c37a8cd1e382064d8aced5e05543c5f7753834da&#x27;</span>)
    ]
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function Uq(T){let o,v;return o=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVwb190cmVlJTBBcmVwb190cmVlJTIwJTNEJTIwbGlzdF9yZXBvX3RyZWUoJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIpJTBBcmVwb190cmVlJTBBbGlzdChyZXBvX3RyZWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_repo_tree
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_tree = list_repo_tree(<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_tree
&lt;generator <span class="hljs-built_in">object</span> HfApi.list_repo_tree at <span class="hljs-number">0x7fa4088e1ac0</span>&gt;
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(repo_tree)
[
    RepoFile(path=<span class="hljs-string">&#x27;.gitattributes&#x27;</span>, size=<span class="hljs-number">391</span>, blob_id=<span class="hljs-string">&#x27;ae8c63daedbd4206d7d40126955d4e6ab1c80f8f&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(path=<span class="hljs-string">&#x27;README.md&#x27;</span>, size=<span class="hljs-number">391</span>, blob_id=<span class="hljs-string">&#x27;43bd404b159de6fba7c2f4d3264347668d43af25&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(path=<span class="hljs-string">&#x27;config.json&#x27;</span>, size=<span class="hljs-number">554</span>, blob_id=<span class="hljs-string">&#x27;2f9618c3a19b9a61add74f70bfb121335aeef666&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(
        path=<span class="hljs-string">&#x27;flax_model.msgpack&#x27;</span>, size=<span class="hljs-number">497764107</span>, blob_id=<span class="hljs-string">&#x27;8095a62ccb4d806da7666fcda07467e2d150218e&#x27;</span>,
        lfs={<span class="hljs-string">&#x27;size&#x27;</span>: <span class="hljs-number">497764107</span>, <span class="hljs-string">&#x27;sha256&#x27;</span>: <span class="hljs-string">&#x27;d88b0d6a6ff9c3f8151f9d3228f57092aaea997f09af009eefd7373a77b5abb9&#x27;</span>, <span class="hljs-string">&#x27;pointer_size&#x27;</span>: <span class="hljs-number">134</span>}, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>
    ),
    RepoFile(path=<span class="hljs-string">&#x27;merges.txt&#x27;</span>, size=<span class="hljs-number">456318</span>, blob_id=<span class="hljs-string">&#x27;226b0752cac7789c48f0cb3ec53eda48b7be36cc&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(
        path=<span class="hljs-string">&#x27;pytorch_model.bin&#x27;</span>, size=<span class="hljs-number">548123560</span>, blob_id=<span class="hljs-string">&#x27;64eaa9c526867e404b68f2c5d66fd78e27026523&#x27;</span>,
        lfs={<span class="hljs-string">&#x27;size&#x27;</span>: <span class="hljs-number">548123560</span>, <span class="hljs-string">&#x27;sha256&#x27;</span>: <span class="hljs-string">&#x27;9be78edb5b928eba33aa88f431551348f7466ba9f5ef3daf1d552398722a5436&#x27;</span>, <span class="hljs-string">&#x27;pointer_size&#x27;</span>: <span class="hljs-number">134</span>}, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>
    ),
    RepoFile(path=<span class="hljs-string">&#x27;vocab.json&#x27;</span>, size=<span class="hljs-number">898669</span>, blob_id=<span class="hljs-string">&#x27;b00361fece0387ca34b4b8b8539ed830d644dbeb&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>)]
]`,wrap:!1}}),{c(){u(o.$$.fragment)},l(i){h(o.$$.fragment,i)},m(i,a){f(o,i,a),v=!0},p:H,i(i){v||(m(o.$$.fragment,i),v=!0)},o(i){_(o.$$.fragment,i),v=!1},d(i){b(o,i)}}}function Iq(T){let o,v;return o=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVwb190cmVlJTBBcmVwb190cmVlJTIwJTNEJTIwbGlzdF9yZXBvX3RyZWUoJTIycHJvbXB0aGVybyUyRm9wZW5qb3VybmV5LXY0JTIyJTJDJTIwZXhwYW5kJTNEVHJ1ZSklMEFsaXN0KHJlcG9fdHJlZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_repo_tree
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_tree = list_repo_tree(<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>, expand=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(repo_tree)
[
    RepoFolder(
        path=<span class="hljs-string">&#x27;feature_extractor&#x27;</span>,
        tree_id=<span class="hljs-string">&#x27;aa536c4ea18073388b5b0bc791057a7296a00398&#x27;</span>,
        last_commit={
            <span class="hljs-string">&#x27;oid&#x27;</span>: <span class="hljs-string">&#x27;47b62b20b20e06b9de610e840282b7e6c3d51190&#x27;</span>,
            <span class="hljs-string">&#x27;title&#x27;</span>: <span class="hljs-string">&#x27;Upload diffusers weights (#48)&#x27;</span>,
            <span class="hljs-string">&#x27;date&#x27;</span>: datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">3</span>, <span class="hljs-number">21</span>, <span class="hljs-number">9</span>, <span class="hljs-number">5</span>, <span class="hljs-number">27</span>, tzinfo=datetime.timezone.utc)
        }
    ),
    RepoFolder(
        path=<span class="hljs-string">&#x27;safety_checker&#x27;</span>,
        tree_id=<span class="hljs-string">&#x27;65aef9d787e5557373fdf714d6c34d4fcdd70440&#x27;</span>,
        last_commit={
            <span class="hljs-string">&#x27;oid&#x27;</span>: <span class="hljs-string">&#x27;47b62b20b20e06b9de610e840282b7e6c3d51190&#x27;</span>,
            <span class="hljs-string">&#x27;title&#x27;</span>: <span class="hljs-string">&#x27;Upload diffusers weights (#48)&#x27;</span>,
            <span class="hljs-string">&#x27;date&#x27;</span>: datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">3</span>, <span class="hljs-number">21</span>, <span class="hljs-number">9</span>, <span class="hljs-number">5</span>, <span class="hljs-number">27</span>, tzinfo=datetime.timezone.utc)
        }
    ),
    RepoFile(
        path=<span class="hljs-string">&#x27;model_index.json&#x27;</span>,
        size=<span class="hljs-number">582</span>,
        blob_id=<span class="hljs-string">&#x27;d3d7c1e8c3e78eeb1640b8e2041ee256e24c9ee1&#x27;</span>,
        lfs=<span class="hljs-literal">None</span>,
        last_commit={
            <span class="hljs-string">&#x27;oid&#x27;</span>: <span class="hljs-string">&#x27;b195ed2d503f3eb29637050a886d77bd81d35f0e&#x27;</span>,
            <span class="hljs-string">&#x27;title&#x27;</span>: <span class="hljs-string">&#x27;Fix deprecation warning by changing \`CLIPFeatureExtractor\` to \`CLIPImageProcessor\`. (#54)&#x27;</span>,
            <span class="hljs-string">&#x27;date&#x27;</span>: datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">5</span>, <span class="hljs-number">15</span>, <span class="hljs-number">21</span>, <span class="hljs-number">41</span>, <span class="hljs-number">59</span>, tzinfo=datetime.timezone.utc)
        },
        security={
            <span class="hljs-string">&#x27;safe&#x27;</span>: <span class="hljs-literal">True</span>,
            <span class="hljs-string">&#x27;av_scan&#x27;</span>: {<span class="hljs-string">&#x27;virusFound&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;virusNames&#x27;</span>: <span class="hljs-literal">None</span>},
            <span class="hljs-string">&#x27;pickle_import_scan&#x27;</span>: <span class="hljs-literal">None</span>
        }
    )
    ...
]`,wrap:!1}}),{c(){u(o.$$.fragment)},l(i){h(o.$$.fragment,i)},m(i,a){f(o,i,a),v=!0},p:H,i(i){v||(m(o.$$.fragment,i),v=!0)},o(i){_(o.$$.fragment,i),v=!1},d(i){b(o,i)}}}function Aq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3Rfd2ViaG9va3MlMEF3ZWJob29rcyUyMCUzRCUyMGxpc3Rfd2ViaG9va3MoKSUwQWxlbih3ZWJob29rcyklMEF3ZWJob29rcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_webhooks
<span class="hljs-meta">&gt;&gt;&gt; </span>webhooks = list_webhooks()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(webhooks)
<span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>webhooks[<span class="hljs-number">0</span>]
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function Nq(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function Jq(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-117o2wk"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function Eq(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-hjndn0"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function Dq(T){let o,v=`This is a power-user method. You shouldn’t need to call it directly to make a normal commit.
Use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> directly instead.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1vdjdxz"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function Rq(T){let o,v=`Commit operations will be mutated during the process. In particular, the attached <code>path_or_fileobj</code> will be
removed after the upload to save memory (and replaced by an empty <code>bytes</code> object). Do not reuse the same
objects except to pass them to <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>. If you don’t want to remove the attached content from the
commit operation object, pass <code>free_memory=False</code>.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-xfsqok"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function Fq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdE9wZXJhdGlvbkFkZCUyQyUyMHByZXVwbG9hZF9sZnNfZmlsZXMlMkMlMjBjcmVhdGVfY29tbWl0JTJDJTIwY3JlYXRlX3JlcG8lMEElMEFyZXBvX2lkJTIwJTNEJTIwY3JlYXRlX3JlcG8oJTIydGVzdF9wcmV1cGxvYWQlMjIpLnJlcG9faWQlMEElMEFvcGVyYXRpb25zJTIwJTNEJTIwJTVCJTVEJTIwJTIzJTIwTGlzdCUyMG9mJTIwYWxsJTIwJTYwQ29tbWl0T3BlcmF0aW9uQWRkJTYwJTIwb2JqZWN0cyUyMHRoYXQlMjB3aWxsJTIwYmUlMjBnZW5lcmF0ZWQlMEFmb3IlMjBpJTIwaW4lMjByYW5nZSg1KSUzQSUwQSUyMCUyMCUyMCUyMGNvbnRlbnQlMjAlM0QlMjAuLi4lMjAlMjMlMjBnZW5lcmF0ZSUyMGJpbmFyeSUyMGNvbnRlbnQlMEElMjAlMjAlMjAlMjBhZGRpdGlvbiUyMCUzRCUyMENvbW1pdE9wZXJhdGlvbkFkZChwYXRoX2luX3JlcG8lM0RmJTIyc2hhcmRfJTdCaSU3RF9vZl81LmJpbiUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGNvbnRlbnQpJTBBJTIwJTIwJTIwJTIwcHJldXBsb2FkX2xmc19maWxlcyhyZXBvX2lkJTJDJTIwYWRkaXRpb25zJTNEJTVCYWRkaXRpb24lNUQpJTIwJTIzJTIwdXBsb2FkJTIwJTJCJTIwZnJlZSUyMG1lbW9yeSUwQSUyMCUyMCUyMCUyMG9wZXJhdGlvbnMuYXBwZW5kKGFkZGl0aW9uKSUwQSUwQWNyZWF0ZV9jb21taXQocmVwb19pZCUyQyUyMG9wZXJhdGlvbnMlM0RvcGVyYXRpb25zJTJDJTIwY29tbWl0X21lc3NhZ2UlM0QlMjJDb21taXQlMjBhbGwlMjBzaGFyZHMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitOperationAdd, preupload_lfs_files, create_commit, create_repo

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = create_repo(<span class="hljs-string">&quot;test_preupload&quot;</span>).repo_id

<span class="hljs-comment"># Generate and preupload LFS files one by one</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>operations = [] <span class="hljs-comment"># List of all \`CommitOperationAdd\` objects that will be generated</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
<span class="hljs-meta">... </span>    content = ... <span class="hljs-comment"># generate binary content</span>
<span class="hljs-meta">... </span>    addition = CommitOperationAdd(path_in_repo=<span class="hljs-string">f&quot;shard_<span class="hljs-subst">{i}</span>_of_5.bin&quot;</span>, path_or_fileobj=content)
<span class="hljs-meta">... </span>    preupload_lfs_files(repo_id, additions=[addition]) <span class="hljs-comment"># upload + free memory</span>
<span class="hljs-meta">... </span>    operations.append(addition)

<span class="hljs-comment"># Create commit</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_commit(repo_id, operations=operations, commit_message=<span class="hljs-string">&quot;Commit all shards&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function Sq(T){let o,v="Examples:",i,a,g;return a=new C({props:{code:"bmV3X3RpdGxlJTIwJTNEJTIwJTIyTmV3JTIwdGl0bGUlMkMlMjBmaXhpbmclMjBhJTIwdHlwbyUyMiUwQUhmQXBpKCkucmVuYW1lX2Rpc2N1c3Npb24oJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGcmVwb19uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGlzY3Vzc2lvbl9udW0lM0QzNCUwQSUyMCUyMCUyMCUyMG5ld190aXRsZSUzRG5ld190aXRsZSUwQSklMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>new_title = <span class="hljs-string">&quot;New title, fixing a typo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi().rename_discussion(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo_name&quot;</span>,
<span class="hljs-meta">... </span>    discussion_num=<span class="hljs-number">34</span>
<span class="hljs-meta">... </span>    new_title=new_title
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># DiscussionTitleChange(id=&#x27;deadbeef0000000&#x27;, type=&#x27;title-change&#x27;, ...)</span>
`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function Gq(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function Lq(T){let o,v="Examples:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJlcG9fZXhpc3RzJTBBcmVwb19leGlzdHMoJTIyZ29vZ2xlJTJGZ2VtbWEtN2IlMjIpJTBBcmVwb19leGlzdHMoJTIyZ29vZ2xlJTJGbm90LWEtcmVwbyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> repo_exists
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_exists(<span class="hljs-string">&quot;google/gemma-7b&quot;</span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_exists(<span class="hljs-string">&quot;google/not-a-repo&quot;</span>)
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function Zq(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-117o2wk"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function Vq(T){let o,v='It is also possible to request hardware directly when creating the Space repo! See <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a> for details.';return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-752acu"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function Pq(T){let o,v=`It is not possible to decrease persistent storage after its granted. To do so, you must delete it
via <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.delete_space_storage">delete_space_storage()</a>.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-w6dccp"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function Wq(T){let o,v="Examples:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJldmlzaW9uX2V4aXN0cyUwQXJldmlzaW9uX2V4aXN0cyglMjJnb29nbGUlMkZnZW1tYS03YiUyMiUyQyUyMCUyMmZsb2F0MTYlMjIpJTBBcmV2aXNpb25fZXhpc3RzKCUyMmdvb2dsZSUyRmdlbW1hLTdiJTIyJTJDJTIwJTIybm90LWEtcmV2aXNpb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> revision_exists
<span class="hljs-meta">&gt;&gt;&gt; </span>revision_exists(<span class="hljs-string">&quot;google/gemma-7b&quot;</span>, <span class="hljs-string">&quot;float16&quot;</span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>revision_exists(<span class="hljs-string">&quot;google/gemma-7b&quot;</span>, <span class="hljs-string">&quot;not-a-revision&quot;</span>)
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function Bq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWZ1dHVyZSUyMCUzRCUyMGFwaS5ydW5fYXNfZnV0dXJlKGFwaS53aG9hbWkpJTIwJTIzJTIwaW5zdGFudCUwQWZ1dHVyZS5kb25lKCklMEFmdXR1cmUucmVzdWx0KCklMjAlMjMlMjB3YWl0JTIwdW50aWwlMjBjb21wbGV0ZSUyMGFuZCUyMHJldHVybiUyMHJlc3VsdCUwQWZ1dHVyZS5kb25lKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>future = api.run_as_future(api.whoami) <span class="hljs-comment"># instant</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>future.done()
<span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>future.result() <span class="hljs-comment"># wait until complete and return result</span>
(...)
<span class="hljs-meta">&gt;&gt;&gt; </span>future.done()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function Yq(T){let o,v='It is also possible to set a custom sleep time when requesting hardware with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.request_space_hardware">request_space_hardware()</a>.';return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1k7k0vb"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function Xq(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-117o2wk"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function zq(T){let o,v="Once squashed, the commit history cannot be retrieved. This is a non-revertible operation.";return{c(){o=c("p"),o.textContent=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-16nd2e3"&&(o.textContent=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function Oq(T){let o,v=`Once the history of a branch has been squashed, it is not possible to merge it back into another branch since
their history will have diverged.`;return{c(){o=c("p"),o.textContent=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-qbmppr"&&(o.textContent=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function Qq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQXJlcG9faWQlMjAlM0QlMjBhcGkuY3JlYXRlX3JlcG8oJTIydGVzdC1zcXVhc2glMjIpLnJlcG9faWQlMEElMEFhcGkudXBsb2FkX2ZpbGUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBwYXRoX2luX3JlcG8lM0QlMjJmaWxlLnR4dCUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGIlMjJjb250ZW50JTIyKSUwQWFwaS51cGxvYWRfZmlsZShyZXBvX2lkJTNEcmVwb19pZCUyQyUyMHBhdGhfaW5fcmVwbyUzRCUyMmxmcy5iaW4lMjIlMkMlMjBwYXRoX29yX2ZpbGVvYmolM0RiJTIyY29udGVudCUyMiklMEFhcGkudXBsb2FkX2ZpbGUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBwYXRoX2luX3JlcG8lM0QlMjJmaWxlLnR4dCUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGIlMjJhbm90aGVyX2NvbnRlbnQlMjIpJTBBJTBBYXBpLnN1cGVyX3NxdWFzaF9oaXN0b3J5KHJlcG9faWQlM0RyZXBvX2lkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># Create repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = api.create_repo(<span class="hljs-string">&quot;test-squash&quot;</span>).repo_id

<span class="hljs-comment"># Make a lot of commits.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(repo_id=repo_id, path_in_repo=<span class="hljs-string">&quot;file.txt&quot;</span>, path_or_fileobj=<span class="hljs-string">b&quot;content&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(repo_id=repo_id, path_in_repo=<span class="hljs-string">&quot;lfs.bin&quot;</span>, path_or_fileobj=<span class="hljs-string">b&quot;content&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(repo_id=repo_id, path_in_repo=<span class="hljs-string">&quot;file.txt&quot;</span>, path_or_fileobj=<span class="hljs-string">b&quot;another_content&quot;</span>)

<span class="hljs-comment"># Squash history</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.super_squash_history(repo_id=repo_id)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function Kq(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfbGlrZWRfcmVwb3MlMkMlMjB1bmxpa2UlMEElMjJncHQyJTIyJTIwaW4lMjBsaXN0X2xpa2VkX3JlcG9zKCkubW9kZWxzJTIwJTIzJTIwd2UlMjBhc3N1bWUlMjB5b3UlMjBoYXZlJTIwYWxyZWFkeSUyMGxpa2VkJTIwZ3B0MiUwQXVubGlrZSglMjJncHQyJTIyKSUwQSUyMmdwdDIlMjIlMjBpbiUyMGxpc3RfbGlrZWRfcmVwb3MoKS5tb2RlbHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_liked_repos, unlike
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;gpt2&quot;</span> <span class="hljs-keyword">in</span> list_liked_repos().models <span class="hljs-comment"># we assume you have already liked gpt2</span>
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>unlike(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;gpt2&quot;</span> <span class="hljs-keyword">in</span> list_liked_repos().models
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function eM(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTJDJTIwdXBkYXRlX2NvbGxlY3Rpb25faXRlbSUwQSUwQWNvbGxlY3Rpb24lMjAlM0QlMjBnZXRfY29sbGVjdGlvbiglMjJUaGVCbG9rZSUyRnJlY2VudC1tb2RlbHMtNjRmOWE1NWJiMzExNWI0ZjUxM2VjMDI2JTIyKSUwQSUwQXVwZGF0ZV9jb2xsZWN0aW9uX2l0ZW0oJTBBJTIwJTIwJTIwJTIwY29sbGVjdGlvbl9zbHVnJTNEJTIyVGhlQmxva2UlMkZyZWNlbnQtbW9kZWxzLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1fb2JqZWN0X2lkJTNEY29sbGVjdGlvbi5pdGVtcyU1Qi0xJTVELml0ZW1fb2JqZWN0X2lkJTJDJTBBJTIwJTIwJTIwJTIwbm90ZSUzRCUyMk5ld2x5JTIwdXBkYXRlZCUyMG1vZGVsISUyMiUwQSUyMCUyMCUyMCUyMHBvc2l0aW9uJTNEMCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection, update_collection_item

<span class="hljs-comment"># Get collection first</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>)

<span class="hljs-comment"># Update item based on its ID (add note + update position)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>update_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>,
<span class="hljs-meta">... </span>    item_object_id=collection.items[-<span class="hljs-number">1</span>].item_object_id,
<span class="hljs-meta">... </span>    note=<span class="hljs-string">&quot;Newly updated model!&quot;</span>
<span class="hljs-meta">... </span>    position=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function tM(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwZGF0ZV9jb2xsZWN0aW9uX21ldGFkYXRhJTBBY29sbGVjdGlvbiUyMCUzRCUyMHVwZGF0ZV9jb2xsZWN0aW9uX21ldGFkYXRhKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMnVzZXJuYW1lJTJGaWNjdi0yMDIzLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIySUNDViUyME9jdC4lMjAyMDIzJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJQb3J0Zm9saW8lMjBvZiUyMG1vZGVscyUyQyUyMGRhdGFzZXRzJTJDJTIwcGFwZXJzJTIwYW5kJTIwZGVtb3MlMjBJJTIwcHJlc2VudGVkJTIwYXQlMjBJQ0NWJTIwT2N0LiUyMDIwMjMlMjIlMkMlMEElMjAlMjAlMjAlMjBwcml2YXRlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjB0aGVtZSUzRCUyMnBpbmslMjIlMkMlMEEpJTBBY29sbGVjdGlvbi5zbHVn",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> update_collection_metadata
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = update_collection_metadata(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;username/iccv-2023-64f9a55bb3115b4f513ec026&quot;</span>,
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;ICCV Oct. 2023&quot;</span>
<span class="hljs-meta">... </span>    description=<span class="hljs-string">&quot;Portfolio of models, datasets, papers and demos I presented at ICCV Oct. 2023&quot;</span>,
<span class="hljs-meta">... </span>    private=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    theme=<span class="hljs-string">&quot;pink&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.slug
<span class="hljs-string">&quot;username/iccv-oct-2023-64f9a55bb3115b4f513ec026&quot;</span>
<span class="hljs-comment"># ^collection slug got updated but not the trailing ID</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function nM(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-hjndn0"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function oM(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwZGF0ZV93ZWJob29rJTBBdXBkYXRlZF9wYXlsb2FkJTIwJTNEJTIwdXBkYXRlX3dlYmhvb2soJTBBJTIwJTIwJTIwJTIwd2ViaG9va19pZCUzRCUyMjY1NGJiYmMxNmYyZWMxNGQ3N2YxMDljYyUyMiUyQyUwQSUyMCUyMCUyMCUyMHVybCUzRCUyMmh0dHBzJTNBJTJGJTJGbmV3LndlYmhvb2suc2l0ZSUyRmEyMTc2ZTgyLTU3MjAtNDNlZS05ZTA2LWY5MWNiNGM5MTU0OCUyMiUyQyUwQSUyMCUyMCUyMCUyMHdhdGNoZWQlM0QlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMm5hbWUlMjIlM0ElMjAlMjJqdWxpZW4tYyUyMiU3RCUyQyUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJvcmclMjIlMkMlMjAlMjJuYW1lJTIyJTNBJTIwJTIySHVnZ2luZ0ZhY2VINCUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMGRvbWFpbnMlM0QlNUIlMjJyZXBvJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2VjcmV0JTNEJTIybXktc2VjcmV0JTIyJTJDJTBBKSUwQXByaW50KHVwZGF0ZWRfcGF5bG9hZCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> update_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_payload = update_webhook(
<span class="hljs-meta">... </span>    webhook_id=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
<span class="hljs-meta">... </span>    url=<span class="hljs-string">&quot;https://new.webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
<span class="hljs-meta">... </span>    watched=[{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;julien-c&quot;</span>}, {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;org&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;HuggingFaceH4&quot;</span>}],
<span class="hljs-meta">... </span>    domains=[<span class="hljs-string">&quot;repo&quot;</span>],
<span class="hljs-meta">... </span>    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(updated_payload)
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://new.webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">False</span>,`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function aM(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-qqcg2t"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function sM(T){let o,v=`<code>upload_file</code> assumes that the repo already exists on the Hub. If you get a
Client error 404, please make sure you are authenticated and that <code>repo_id</code> and
<code>repo_type</code> are set correctly. If repo does not exist, create it first using
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-gqeru2"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function rM(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwbG9hZF9maWxlJTBBJTBBd2l0aCUyMG9wZW4oJTIyLiUyRmxvY2FsJTJGZmlsZXBhdGglMjIlMkMlMjAlMjJyYiUyMiklMjBhcyUyMGZvYmolM0ElMEElMjAlMjAlMjAlMjB1cGxvYWRfZmlsZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0RmaWxlb2JqJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGF0aF9pbl9yZXBvJTNEJTIycmVtb3RlJTJGZmlsZSUyRnBhdGguaDUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRva2VuJTNEJTIybXlfdG9rZW4lMjIlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBdXBsb2FkX2ZpbGUoJTBBJTIwJTIwJTIwJTIwcGF0aF9vcl9maWxlb2JqJTNEJTIyLiU1QyU1Q2xvY2FsJTVDJTVDZmlsZSU1QyU1Q3BhdGglMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZmaWxlJTJGcGF0aC5oNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRm15LW1vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW4lM0QlMjJteV90b2tlbiUyMiUyQyUwQSklMEElMEF1cGxvYWRfZmlsZSglMEElMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0QlMjIuJTVDJTVDbG9jYWwlNUMlNUNmaWxlJTVDJTVDcGF0aCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMnJlbW90ZSUyRmZpbGUlMkZwYXRoLmg1JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGbXktbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3JlYXRlX3ByJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> upload_file

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;./local/filepath&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> fobj:
<span class="hljs-meta">... </span>    upload_file(
<span class="hljs-meta">... </span>        path_or_fileobj=fileobj,
<span class="hljs-meta">... </span>        path_in_repo=<span class="hljs-string">&quot;remote/file/path.h5&quot;</span>,
<span class="hljs-meta">... </span>        repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>        repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>        token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    )
<span class="hljs-string">&quot;https://huggingface.co/datasets/username/my-dataset/blob/main/remote/file/path.h5&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>upload_file(
<span class="hljs-meta">... </span>    path_or_fileobj=<span class="hljs-string">&quot;.\\\\local\\\\file\\\\path&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/file/path.h5&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-model&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/username/my-model/blob/main/remote/file/path.h5&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>upload_file(
<span class="hljs-meta">... </span>    path_or_fileobj=<span class="hljs-string">&quot;.\\\\local\\\\file\\\\path&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/file/path.h5&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-model&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    create_pr=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/username/my-model/blob/refs%2Fpr%2F1/remote/file/path.h5&quot;</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function iM(T){let o,v="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li>`;return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1l6tbi1"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function cM(T){let o,v=`<code>upload_folder</code> assumes that the repo already exists on the Hub. If you get a Client error 404, please make
sure you are authenticated and that <code>repo_id</code> and <code>repo_type</code> are set correctly. If repo does not exist, create
it first using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1ofwh3e"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function lM(T){let o,v='When dealing with a large folder (thousands of files or hundreds of GB), we recommend using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_large_folder">upload_large_folder()</a> instead.';return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1n31r9o"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function pM(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"dXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmxvY2FsJTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZleHBlcmltZW50JTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwaWdub3JlX3BhdHRlcm5zJTNEJTIyKiolMkZsb2dzJTJGKi50eHQlMjIlMkMlMEEpJTBBJTBBdXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmxvY2FsJTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZleHBlcmltZW50JTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVsZXRlX3BhdHRlcm5zJTNEJTIyKiolMkZsb2dzJTJGKi50eHQlMjIlMkMlMEEpJTBBJTBBdXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmxvY2FsJTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZleHBlcmltZW50JTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3JlYXRlX3ByJTNEVHJ1ZSUyQyUwQSklMEE=",highlighted:`<span class="hljs-comment"># Upload checkpoints folder except the log files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;local/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/experiment/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;datasets&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    ignore_patterns=<span class="hljs-string">&quot;**/logs/*.txt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># &quot;https://huggingface.co/datasets/username/my-dataset/tree/main/remote/experiment/checkpoints&quot;</span>

<span class="hljs-comment"># Upload checkpoints folder including logs while deleting existing logs from the repo</span>
<span class="hljs-comment"># Useful if you don&#x27;t know exactly which log files have already being pushed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;local/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/experiment/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;datasets&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    delete_patterns=<span class="hljs-string">&quot;**/logs/*.txt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/datasets/username/my-dataset/tree/main/remote/experiment/checkpoints&quot;</span>

<span class="hljs-comment"># Upload checkpoints folder while creating a PR</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;local/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/experiment/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;datasets&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    create_pr=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/datasets/username/my-dataset/tree/refs%2Fpr%2F1/remote/experiment/checkpoints&quot;</span>
`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function dM(T){let o,v="A few things to keep in mind:",i,a,g='<li>Repository limits still apply: <a href="https://huggingface.co/docs/hub/repositories-recommendations" rel="nofollow">https://huggingface.co/docs/hub/repositories-recommendations</a></li> <li>Do not start several processes in parallel.</li> <li>You can interrupt and resume the process at any time.</li> <li>Do not upload the same folder to several repositories. If you need to do so, you must delete the local <code>.cache/.huggingface/</code> folder first.</li>';return{c(){o=c("p"),o.textContent=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-vnn6d1"&&(o.textContent=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1iweq7b"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function gM(T){let o,v='While being much more robust to upload large folders, <code>upload_large_folder</code> is more limited than <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> feature-wise. In practice:',i,a,g='<li>you cannot set a custom <code>path_in_repo</code>. If you want to upload to a subfolder, you need to set the proper structure locally.</li> <li>you cannot set a custom <code>commit_message</code> and <code>commit_description</code> since multiple commits are created.</li> <li>you cannot delete from the repo while uploading. Please make a separate commit first.</li> <li>you cannot create a PR directly. Please create a PR first (from the UI or using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_pull_request">create_pull_request()</a>) and then commit to it by passing <code>revision</code>.</li>';return{c(){o=c("p"),o.innerHTML=v,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1n7ws7"&&(o.innerHTML=v),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-gxpink"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function uM(T){let o,v=`Most attributes of this class are optional. This is because the data returned by the Hub depends on the query made.
In general, the more specific the query, the more information is returned. On the contrary, when listing datasets
using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_datasets">list_datasets()</a> only a subset of the attributes are returned.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-fx9t9d"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function hM(T){let o,v=`Most attributes of this class are optional. This is because the data returned by the Hub depends on the query made.
In general, the more specific the query, the more information is returned. On the contrary, when listing models
using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_models">list_models()</a> only a subset of the attributes are returned.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1bvqy32"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function fM(T){let o,v=`All attributes of this class are optional except <code>rfilename</code>. This is because only the file names are returned when
listing repositories on the Hub (with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_models">list_models()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_datasets">list_datasets()</a> or <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_spaces">list_spaces()</a>). If you need more
information like file size, blob id or lfs details, you must request them specifically from one repo at a time
(using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.model_info">model_info()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.dataset_info">dataset_info()</a> or <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.space_info">space_info()</a>) as it adds more constraints on the backend server to
retrieve these.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1y8shbz"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function mM(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"UmVwb1VybCgnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmdwdDInKSUwQSUwQVJlcG9VcmwoJ2h0dHBzJTNBJTJGJTJGaHViLWNpLmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkdW1teV91c2VyJTJGZHVtbXlfZGF0YXNldCclMkMlMjBlbmRwb2ludCUzRCdodHRwcyUzQSUyRiUyRmh1Yi1jaS5odWdnaW5nZmFjZS5jbycpJTBBJTBBUmVwb1VybCgnaGYlM0ElMkYlMkZkYXRhc2V0cyUyRm15LXVzZXIlMkZteS1kYXRhc2V0JyklMEElMEFIZkFwaS5jcmVhdGVfcmVwbyglMjJkdW1teV9tb2RlbCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/gpt2&#x27;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/gpt2&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;model&#x27;</span>, repo_id=<span class="hljs-string">&#x27;gpt2&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>RepoUrl(<span class="hljs-string">&#x27;https://hub-ci.huggingface.co/datasets/dummy_user/dummy_dataset&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://hub-ci.huggingface.co&#x27;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://hub-ci.huggingface.co/datasets/dummy_user/dummy_dataset&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://hub-ci.huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;dataset&#x27;</span>, repo_id=<span class="hljs-string">&#x27;dummy_user/dummy_dataset&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>RepoUrl(<span class="hljs-string">&#x27;hf://datasets/my-user/my-dataset&#x27;</span>)
RepoUrl(<span class="hljs-string">&#x27;hf://datasets/my-user/my-dataset&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;dataset&#x27;</span>, repo_id=<span class="hljs-string">&#x27;user/dataset&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi.create_repo(<span class="hljs-string">&quot;dummy_model&quot;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/Wauplin/dummy_model&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;model&#x27;</span>, repo_id=<span class="hljs-string">&#x27;Wauplin/dummy_model&#x27;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function _M(T){let o,v=`Most attributes of this class are optional. This is because the data returned by the Hub depends on the query made.
In general, the more specific the query, the more information is returned. On the contrary, when listing spaces
using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_spaces">list_spaces()</a> only a subset of the attributes are returned.`;return{c(){o=c("p"),o.innerHTML=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-vi95sv"&&(o.innerHTML=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function bM(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"b3BlcmF0aW9uJTIwJTNEJTIwQ29tbWl0T3BlcmF0aW9uQWRkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMnJlbW90ZSUyRmRpciUyRndlaWdodHMuaDUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0QlMjIuJTJGbG9jYWwlMkZ3ZWlnaHRzLmg1JTIyJTJDJTBBKSUwQSUwQXdpdGglMjBvcGVyYXRpb24uYXNfZmlsZSgpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwY29udGVudCUyMCUzRCUyMGZpbGUucmVhZCgpJTBBJTBBd2l0aCUyMG9wZXJhdGlvbi5hc19maWxlKHdpdGhfdHFkbSUzRFRydWUpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwd2hpbGUlMjBUcnVlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YSUyMCUzRCUyMGZpbGUucmVhZCgxMDI0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbm90JTIwZGF0YSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBd2l0aCUyMG9wZXJhdGlvbi5hc19maWxlKHdpdGhfdHFkbSUzRFRydWUpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwcmVxdWVzdHMucHV0KC4uLiUyQyUyMGRhdGElM0RmaWxlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>operation = CommitOperationAdd(
<span class="hljs-meta">... </span>       path_in_repo=<span class="hljs-string">&quot;remote/dir/weights.h5&quot;</span>,
<span class="hljs-meta">... </span>       path_or_fileobj=<span class="hljs-string">&quot;./local/weights.h5&quot;</span>,
<span class="hljs-meta">... </span>)
CommitOperationAdd(path_in_repo=<span class="hljs-string">&#x27;remote/dir/weights.h5&#x27;</span>, path_or_fileobj=<span class="hljs-string">&#x27;./local/weights.h5&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> operation.as_file() <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    content = file.read()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> operation.as_file(with_tqdm=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
<span class="hljs-meta">... </span>        data = file.read(<span class="hljs-number">1024</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> data:
<span class="hljs-meta">... </span>             <span class="hljs-keyword">break</span>
config.json: <span class="hljs-number">100</span>%|█████████████████████████| <span class="hljs-number">8.19</span>k/<span class="hljs-number">8.19</span>k [<span class="hljs-number">00</span>:02&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">3.72</span>kB/s]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> operation.as_file(with_tqdm=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    requests.put(..., data=file)
config.json: <span class="hljs-number">100</span>%|█████████████████████████| <span class="hljs-number">8.19</span>k/<span class="hljs-number">8.19</span>k [<span class="hljs-number">00</span>:02&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">3.72</span>kB/s]`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function vM(T){let o,v="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdFNjaGVkdWxlciUwQSUwQWNzdl9wYXRoJTIwJTNEJTIwUGF0aCglMjJ3YXRjaGVkX2ZvbGRlciUyRmRhdGEuY3N2JTIyKSUwQUNvbW1pdFNjaGVkdWxlcihyZXBvX2lkJTNEJTIydGVzdF9zY2hlZHVsZXIlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyJTJDJTIwZm9sZGVyX3BhdGglM0Rjc3ZfcGF0aC5wYXJlbnQlMkMlMjBldmVyeSUzRDEwKSUwQSUwQXdpdGglMjBjc3ZfcGF0aC5vcGVuKCUyMmElMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwZi53cml0ZSglMjJmaXJzdCUyMGxpbmUlMjIpJTBBJTBBd2l0aCUyMGNzdl9wYXRoLm9wZW4oJTIyYSUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmLndyaXRlKCUyMnNlY29uZCUyMGxpbmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitScheduler

<span class="hljs-comment"># Scheduler uploads every 10 minutes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>csv_path = Path(<span class="hljs-string">&quot;watched_folder/data.csv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>CommitScheduler(repo_id=<span class="hljs-string">&quot;test_scheduler&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, folder_path=csv_path.parent, every=<span class="hljs-number">10</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;first line&quot;</span>)

<span class="hljs-comment"># Some time later (...)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;second line&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function yM(T){let o,v="Example using a context manager:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdFNjaGVkdWxlciUwQSUwQXdpdGglMjBDb21taXRTY2hlZHVsZXIocmVwb19pZCUzRCUyMnRlc3Rfc2NoZWR1bGVyJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUyMGZvbGRlcl9wYXRoJTNEJTIyd2F0Y2hlZF9mb2xkZXIlMjIlMkMlMjBldmVyeSUzRDEwKSUyMGFzJTIwc2NoZWR1bGVyJTNBJTBBJTIwJTIwJTIwJTIwY3N2X3BhdGglMjAlM0QlMjBQYXRoKCUyMndhdGNoZWRfZm9sZGVyJTJGZGF0YS5jc3YlMjIpJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGNzdl9wYXRoLm9wZW4oJTIyYSUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmLndyaXRlKCUyMmZpcnN0JTIwbGluZSUyMiklMEElMjAlMjAlMjAlMjAoLi4uKSUwQSUyMCUyMCUyMCUyMHdpdGglMjBjc3ZfcGF0aC5vcGVuKCUyMmElMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZSglMjJzZWNvbmQlMjBsaW5lJTIyKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> CommitScheduler(repo_id=<span class="hljs-string">&quot;test_scheduler&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, folder_path=<span class="hljs-string">&quot;watched_folder&quot;</span>, every=<span class="hljs-number">10</span>) <span class="hljs-keyword">as</span> scheduler:
<span class="hljs-meta">... </span>    csv_path = Path(<span class="hljs-string">&quot;watched_folder/data.csv&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(<span class="hljs-string">&quot;first line&quot;</span>)
<span class="hljs-meta">... </span>    (...)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(<span class="hljs-string">&quot;second line&quot;</span>)

<span class="hljs-comment"># Scheduler is now stopped and last commit have been triggered</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=v,i=s(),u(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-k44prv"&&(o.textContent=v),i=r(e),h(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),f(a,e,x),g=!0},p:H,i(e){g||(m(a.$$.fragment,e),g=!0)},o(e){_(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),b(a,e)}}}function xM(T){let o,v=`This method is not meant to be called directly. It is run in the background by the scheduler, respecting a
queue mechanism to avoid concurrent commits. Making a direct call to the method might lead to concurrency
issues.`;return{c(){o=c("p"),o.textContent=v},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1oh5a50"&&(o.textContent=v)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function $M(T){let o,v,i,a,g,e,x,E2="아래는 허깅 페이스 Hub의 API를 위한 파이썬 래퍼인 <code>HfApi</code> 클래스에 대한 문서입니다.",Ku,Ds,D2="<code>HfApi</code>의 모든 메서드는 패키지의 루트에서 직접 접근할 수 있습니다. 두 접근 방식은 아래에서 자세히 설명합니다.",eh,Rs,R2=`루트 메서드를 사용하는 것이 더 간단하지만 <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> 클래스를 사용하면 더 유연하게 사용할 수 있습니다.
특히 모든 HTTP 호출에서 재사용할 토큰을 전달할 수 있습니다.
이 방식은 토큰이 머신에 유지되지 않기 때문에 <code>huggingface-cli login</code> 또는 <a href="/docs/huggingface_hub/main/ko/package_reference/login#huggingface_hub.login">login()</a>를 사용하는 방식과는 다르며,
다른 엔드포인트를 제공하거나 사용자정의 에이전트를 구성할 수도 있습니다.`,th,Fs,nh,Ss,oh,w,Gs,tf,el,F2="Client to interact with the Hugging Face Hub via HTTP.",nf,tl,S2=`The client is initialized with some high-level settings used in all requests
made to the Hub (HF endpoint, authentication, user agents…). Using the <code>HfApi</code>
client is preferred but not mandatory as all of its public methods are exposed
directly at the root of <code>huggingface_hub</code>.`,of,Me,Ls,af,nl,G2="Accept an access request from a user for a given gated repo.",sf,ol,L2=`Once the request is accepted, the user will be able to download any file of the repo and access the community
tab. If the approval mode is automatic, you don’t have to accept requests manually. An accepted request can be
cancelled or rejected at any time using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>.`,rf,al,Z2='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',cf,je,Zs,lf,sl,V2="Add an item to a collection on the Hub.",pf,rl,P2='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.Collection">Collection</a>',df,$o,gf,Wt,Vs,uf,il,W2="Adds or updates a secret in a Space.",hf,cl,B2=`Secrets allow to set secret keys or tokens to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,ff,Bt,Ps,mf,ll,Y2="Adds or updates a variable in a Space.",_f,pl,X2=`Variables allow to set environment variables to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>`,bf,F,Ws,vf,dl,z2="Check if the provided user token has access to a specific repository on the Hugging Face Hub.",yf,gl,O2=`This method verifies whether the user, authenticated via the provided token, has access to the specified
repository. If the repository is not found or if the user lacks the required permissions to access it,
the method raises an appropriate exception.`,xf,ul,Q2="Example:",$f,wo,wf,hl,K2="In this example:",kf,fl,e1=`<li>If the user has access, the method completes successfully.</li> <li>If the repository is gated or does not exist, appropriate exceptions are raised, allowing the user
to handle them accordingly.</li>`,Tf,He,Bs,qf,ml,t1="Cancel an access request from a user for a given gated repo.",Mf,_l,n1="A cancelled request will go back to the pending list and the user will lose access to the repo.",jf,bl,o1='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',Hf,Ce,Ys,Cf,vl,a1="Closes or re-opens a Discussion or Pull Request.",Uf,ko,If,To,Af,Ue,Xs,Nf,yl,s1="Creates a new comment on the given Discussion.",Jf,qo,Ef,Mo,Df,jo,zs,Rf,xl,r1=`Create a new branch for a repo on the Hub, starting from the specified revision (defaults to <code>main</code>).
To find a revision suiting your needs, you can use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_repo_refs">list_repo_refs()</a> or <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_repo_commits">list_repo_commits()</a>.`,Ff,Ie,Os,Sf,$l,i1="Create a new Collection on the Hub.",Gf,wl,c1='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.Collection">Collection</a>',Lf,Ho,Zf,ae,Qs,Vf,kl,l1="Creates a commit in the given repo, deleting & uploading files as needed.",Pf,Co,Wf,Uo,Bf,Io,Yf,Z,Ks,Xf,Tl,p1="Creates a Discussion or Pull Request.",zf,ql,d1="Pull Requests created programmatically will be in <code>&quot;draft&quot;</code> status.",Of,Ml,g1='Creating a Pull Request with changes can also be done at once with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">HfApi.create_commit()</a>.',Qf,jl,u1='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionWithDetails">DiscussionWithDetails</a>',Kf,Ao,em,Ae,er,tm,Hl,h1="Create a new Inference Endpoint.",nm,No,om,Jo,am,Ne,tr,sm,Cl,f1="Create a new Inference Endpoint from a model in the Hugging Face Inference Catalog.",rm,Ul,m1=`The goal of the Inference Catalog is to provide a curated list of models that are optimized for inference
and for which default configurations have been tested. See <a href="https://endpoints.huggingface.co/catalog" rel="nofollow">https://endpoints.huggingface.co/catalog</a> for a list
of available models in the catalog.`,im,Eo,cm,V,nr,lm,Il,_1="Creates a Pull Request . Pull Requests created programmatically will be in <code>&quot;draft&quot;</code> status.",pm,Al,b1='Creating a Pull Request with changes can also be done at once with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">HfApi.create_commit()</a>;',dm,Nl,v1='This is a wrapper around <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_discussion">HfApi.create_discussion()</a>.',gm,Jl,y1='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionWithDetails">DiscussionWithDetails</a>',um,Do,hm,Ro,or,fm,El,x1="Create an empty repo on the HuggingFace Hub.",mm,Fo,ar,_m,Dl,$1="Tag a given commit of a repo on the Hub.",bm,Yt,sr,vm,Rl,w1="Create a new webhook.",ym,So,xm,Je,rr,$m,Fl,k1="Get info on one specific dataset on huggingface.co.",wm,Sl,T1="Dataset can be private if you pass an acceptable token.",km,Go,Tm,Lo,ir,qm,Gl,q1="Delete a branch from a repo on the Hub.",Mm,Ee,cr,jm,Ll,M1="Delete a collection on the Hub.",Hm,Zo,Cm,Vo,Um,Xt,lr,Im,Zl,j1="Delete an item from a collection.",Am,Po,Nm,zt,pr,Jm,Vl,H1="Deletes a file in the given repo.",Em,Wo,Dm,Ot,dr,Rm,Pl,C1="Delete files from a repository on the Hub.",Fm,Wl,U1=`If a folder path is provided, the entire folder is deleted as well as
all files it contained.`,Sm,Qt,gr,Gm,Bl,I1="Deletes a folder in the given repo.",Lm,Yl,A1='Simple wrapper around <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> method.',Zm,De,ur,Vm,Xl,N1="Delete an Inference Endpoint.",Pm,zl,J1=`This operation is not reversible. If you don’t want to be charged for an Inference Endpoint, it is preferable
to pause it with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a> or scale it to zero with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a>.`,Wm,Ol,E1='For convenience, you can also delete an Inference Endpoint using <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.delete">InferenceEndpoint.delete()</a>.',Bm,Bo,hr,Ym,Ql,D1="Delete a repo from the HuggingFace Hub. CAUTION: this is irreversible.",Xm,Kt,fr,zm,Kl,R1="Deletes a secret from a Space.",Om,ep,F1=`Secrets allow to set secret keys or tokens to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,Qm,Yo,mr,Km,tp,S1="Delete persistent storage for a Space.",e_,en,_r,t_,np,G1="Deletes a variable from a Space.",n_,op,L1=`Variables allow to set environment variables to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>`,o_,Xo,br,a_,ap,Z1="Delete a tag from a repo on the Hub.",s_,tn,vr,r_,sp,V1="Delete a webhook.",i_,zo,c_,nn,yr,l_,rp,P1="Disable a webhook (makes it “disabled”).",p_,Oo,d_,Re,xr,g_,ip,W1="Duplicate a Space.",u_,cp,B1=`Programmatically duplicate a Space. The new Space will be created in your account and will be in the same state
as the original Space (running or paused). You can duplicate a Space no matter the current state of a Space.`,h_,Qo,f_,on,$r,m_,lp,Y1="Edits a comment on a Discussion / Pull Request.",__,Ko,b_,an,wr,v_,pp,X1="Enable a webhook (makes it “active”).",y_,ea,x_,sn,kr,$_,dp,z1="Checks if a file exists in a repository on the Hugging Face Hub.",w_,ta,k_,Fe,Tr,T_,gp,O1="Gets information about a Collection on the Hub.",q_,up,Q1='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.Collection">Collection</a>',M_,na,j_,oa,qr,H_,hp,K1="List all valid dataset tags as a nested namespace object.",C_,Se,Mr,U_,fp,ew="Fetches a Discussion’s / Pull Request ‘s details from the Hub.",I_,mp,tw='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionWithDetails">DiscussionWithDetails</a>',A_,aa,N_,sa,jr,J_,_p,nw=`Returns the repository name for a given model ID and optional
organization.`,E_,ra,Hr,D_,bp,ow="Fetch metadata of a file versioned on the Hub for a given url.",R_,rn,Cr,F_,vp,aw="Get information about an Inference Endpoint.",S_,ia,G_,ca,Ur,L_,yp,sw="List all valid model tags as a nested namespace object",Z_,cn,Ir,V_,xp,rw="Get information about a repo’s paths.",P_,la,W_,se,Ar,B_,$p,iw="Fetches Discussions and Pull Requests for the given repo.",Y_,wp,cw="Example:",X_,pa,z_,da,O_,P,Nr,Q_,kp,lw="Parse metadata for a safetensors repo on the Hub.",K_,Tp,pw=`We first check if the repo has a single safetensors file or a sharded safetensors repo. If it’s a single
safetensors file, we parse the metadata from this file. If it’s a sharded safetensors repo, we parse the
metadata from the index file and then parse the metadata from each shard.`,eb,qp,dw='To parse metadata from a single safetensors file, use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.parse_safetensors_file_metadata">parse_safetensors_file_metadata()</a>.',tb,Mp,gw='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',nb,ga,ob,ua,Jr,ab,jp,uw="Gets runtime information about a Space.",sb,ln,Er,rb,Hp,hw="Gets all variables from a Space.",ib,Cp,fw=`Variables allow to set environment variables to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>`,cb,Ge,Dr,lb,Up,mw="Check if a given <code>token</code> is valid and return its permissions.",pb,ha,db,Ip,_w='For more details about tokens, please refer to <a href="https://huggingface.co/docs/hub/security-tokens#what-are-user-access-tokens" rel="nofollow">https://huggingface.co/docs/hub/security-tokens#what-are-user-access-tokens</a>.',gb,fa,Rr,ub,Ap,bw="Get an overview of a user on the Hub.",hb,pn,Fr,fb,Np,vw="Get a webhook by its id.",mb,ma,_b,Le,Sr,bb,Jp,yw="Grant access to a user for a given gated repo.",vb,Ep,xw=`Granting access don’t require for the user to send an access request by themselves. The user is automatically
added to the accepted list meaning they can download the files You can revoke the granted access at any time
using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a> or <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>.`,yb,Dp,$w='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',xb,W,Gr,$b,Rp,ww="Download a given file if it’s not already present in the local cache.",wb,Fp,kw="The new cache file layout looks like this:",kb,Sp,Tw=`<li>The cache directory contains one subfolder per repo_id (namespaced by repo type)</li> <li>inside each repo folder:<ul><li>refs is a list of the latest known revision =&gt; commit_hash pairs</li> <li>blobs contains the actual file blobs (identified by their git-sha or sha256, depending on
whether they’re LFS files or not)</li> <li>snapshots contains one subfolder per commit, each “commit” contains the subset of the files
that have been resolved at that particular commit. Each filename is a symlink to the blob
at that particular commit.</li></ul></li>`,Tb,_a,qb,Gp,qw=`If <code>local_dir</code> is provided, the file structure from the repo will be replicated in this location. When using this
option, the <code>cache_dir</code> will not be used and a <code>.cache/huggingface/</code> folder will be created at the root of <code>local_dir</code>
to store some metadata related to the downloaded files. While this mechanism is not as robust as the main
cache-system, it’s optimized for regularly pulling the latest version of a repository.`,Mb,Ze,Lr,jb,Lp,Mw="Hides a comment on a Discussion / Pull Request.",Hb,ba,Cb,va,Ub,re,Zr,Ib,Zp,jw="Get accepted access requests for a given gated repo.",Ab,Vp,Hw=`An accepted request means the user has requested access to the repo and the request has been accepted. The user
can download any file of the repo. If the approval mode is automatic, this list should contains by default all
requests. Accepted requests can be cancelled or rejected at any time using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a> and
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>. A cancelled request will go back to the pending list while a rejected request will
go to the rejected list. In both cases, the user will lose access to the repo.`,Nb,Pp,Cw='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',Jb,ya,Eb,dn,Vr,Db,Wp,Uw="List collections on the Huggingface Hub, given some filters.",Rb,xa,Fb,Ve,Pr,Sb,Bp,Iw="List datasets hosted on the Huggingface Hub, given some filters.",Gb,$a,Lb,wa,Zb,ie,Wr,Vb,Yp,Aw="List models available in the Hugging Face Inference Catalog.",Pb,Xp,Nw=`The goal of the Inference Catalog is to provide a curated list of models that are optimized for inference
and for which default configurations have been tested. See <a href="https://endpoints.huggingface.co/catalog" rel="nofollow">https://endpoints.huggingface.co/catalog</a> for a list
of available models in the catalog.`,Wb,zp,Jw='Use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint_from_catalog">create_inference_endpoint_from_catalog()</a> to deploy a model from the catalog.',Bb,ka,Yb,gn,Br,Xb,Op,Ew="Lists all inference endpoints for the given namespace.",zb,Ta,Ob,ce,Yr,Qb,Qp,Dw="List all public repos liked by a user on huggingface.co.",Kb,Kp,Rw=`This list is public so token is optional. If <code>user</code> is not passed, it defaults to
the logged in user.`,ev,ed,Fw='See also <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.unlike">unlike()</a>.',tv,qa,nv,Pe,Xr,ov,td,Sw="List models hosted on the Huggingface Hub, given some filters.",av,Ma,sv,ja,rv,Ha,zr,iv,nd,Gw="List of members of an organization on the Hub.",cv,un,Or,lv,od,Lw="List daily papers on the Hugging Face Hub given a search query.",pv,Ca,dv,le,Qr,gv,ad,Zw="Get pending access requests for a given gated repo.",uv,sd,Vw=`A pending request means the user has requested access to the repo but the request has not been processed yet.
If the approval mode is automatic, this list should be empty. Pending requests can be accepted or rejected
using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.accept_access_request">accept_access_request()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>.`,hv,rd,Pw='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',fv,Ua,mv,pe,Kr,_v,id,Ww="Get rejected access requests for a given gated repo.",bv,cd,Bw=`A rejected request means the user has requested access to the repo and the request has been explicitly rejected
by a repo owner (either you or another user from your organization). The user cannot download any file of the
repo. Rejected requests can be accepted or cancelled at any time using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.accept_access_request">accept_access_request()</a> and
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a>. A cancelled request will go back to the pending list while an accepted request will
go to the accepted list.`,vv,ld,Yw='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',yv,Ia,xv,We,ei,$v,pd,Xw="Get the list of commits of a given revision for a repo on the Hub.",wv,dd,zw="Commits are sorted by date (last commit first).",kv,Aa,Tv,Na,ti,qv,gd,Ow="Get the list of files in a given repo.",Mv,hn,ni,jv,ud,Qw="List all users who liked a given repo on the hugging Face Hub.",Hv,hd,Kw='See also <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_liked_repos">list_liked_repos()</a>.',Cv,fn,oi,Uv,fd,ek="Get the list of refs of a given repo (both tags and branches).",Iv,Ja,Av,S,ai,Nv,md,tk="List a repo tree’s files and folders and get information about them.",Jv,_d,nk="Examples:",Ev,bd,ok="Get information about a repo’s tree.",Dv,Ea,Rv,vd,ak="Get even more information about a repo’s tree (last commit and files’ security scan results)",Fv,Da,Sv,Ra,si,Gv,yd,sk="List spaces hosted on the Huggingface Hub, given some filters.",Lv,Fa,ri,Zv,xd,rk="Get the list of followers of a user on the Hub.",Vv,Sa,ii,Pv,$d,ik="Get the list of users followed by a user on the Hub.",Wv,mn,ci,Bv,wd,ck="List all configured webhooks.",Yv,Ga,Xv,_n,li,zv,kd,lk="Merges a Pull Request.",Ov,La,Qv,Be,pi,Kv,Td,pk="Get info on one specific model on huggingface.co",ey,qd,dk="Model can be private if you pass an acceptable token or are logged in.",ty,Za,ny,Ye,di,oy,Md,gk="Moving a repository from namespace1/repo_name1 to namespace2/repo_name2",ay,jd,uk=`Note there are certain limitations. For more information about moving
repositories, please see
<a href="https://hf.co/docs/hub/repositories-settings#renaming-or-transferring-a-repo" rel="nofollow">https://hf.co/docs/hub/repositories-settings#renaming-or-transferring-a-repo</a>.`,sy,Va,ry,Pa,gi,iy,Hd,hk="Get information for a paper on the Hub.",cy,Xe,ui,ly,Cd,fk="Parse metadata from a safetensors file on the Hub.",py,Ud,mk='To parse metadata from all safetensors files in a repo at once, use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_safetensors_metadata">get_safetensors_metadata()</a>.',dy,Id,_k='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',gy,ze,hi,uy,Ad,bk="Pause an Inference Endpoint.",hy,Nd,vk=`A paused Inference Endpoint will not be charged. It can be resumed at any time using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a>.
This is different than scaling the Inference Endpoint to zero with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a>, which
would be automatically restarted when a request is made to it.`,fy,Jd,yk='For convenience, you can also pause an Inference Endpoint using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a>.',my,Oe,fi,_y,Ed,xk="Pause your Space.",by,Dd,$k=`A paused Space stops executing until manually restarted by its owner. This is different from the sleeping
state in which free Spaces go after 48h of inactivity. Paused time is not billed to your account, no matter the
hardware you’ve selected. To restart your Space, use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.restart_space">restart_space()</a> and go to your Space settings page.`,vy,Rd,wk='For more details, please visit <a href="https://huggingface.co/docs/hub/spaces-gpus#pause" rel="nofollow">the docs</a>.',yy,B,mi,xy,Fd,kk="Pre-upload LFS files to S3 in preparation on a future commit.",$y,Sd,Tk=`This method is useful if you are generating the files to upload on-the-fly and you don’t want to store them
in memory before uploading them all at once.`,wy,Wa,ky,Ba,Ty,Ya,qy,Qe,_i,My,Gd,qk="Reject an access request from a user for a given gated repo.",jy,Ld,Mk=`A rejected request will go to the rejected list. The user cannot download any file of the repo. Rejected
requests can be accepted or cancelled at any time using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.accept_access_request">accept_access_request()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a>.
A cancelled request will go back to the pending list while an accepted request will go to the accepted list.`,Hy,Zd,jk='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',Cy,Ke,bi,Uy,Vd,Hk="Renames a Discussion.",Iy,Xa,Ay,za,Ny,bn,vi,Jy,Pd,Ck="Checks if a repository exists on the Hugging Face Hub.",Ey,Oa,Dy,vn,yi,Ry,Wd,Uk="Get the info object for a given repo of a given type.",Fy,Qa,Sy,yn,xi,Gy,Bd,Ik="Request new hardware for a Space.",Ly,Ka,Zy,xn,$i,Vy,Yd,Ak="Request persistent storage for a Space.",Py,es,Wy,et,wi,By,Xd,Nk="Restart your Space.",Yy,zd,Jk=`This is the only way to programmatically restart a Space if you’ve put it on Pause (see <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.pause_space">pause_space()</a>). You
must be the owner of the Space to restart it. If you are using an upgraded hardware, your account will be
billed as soon as the Space is restarted. You can trigger a restart no matter the current state of a Space.`,Xy,Od,Ek='For more details, please visit <a href="https://huggingface.co/docs/hub/spaces-gpus#pause" rel="nofollow">the docs</a>.',zy,$n,ki,Oy,Qd,Dk="Resume an Inference Endpoint.",Qy,Kd,Rk='For convenience, you can also resume an Inference Endpoint using <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">InferenceEndpoint.resume()</a>.',Ky,wn,Ti,ex,eg,Fk="Checks if a specific revision exists on a repo on the Hugging Face Hub.",tx,ts,nx,de,qi,ox,tg,Sk="Run a method in the background and return a Future instance.",ax,ng,Gk=`The main goal is to run methods without blocking the main thread (e.g. to push data during a training).
Background jobs are queued to preserve order but are not ran in parallel. If you need to speed-up your scripts
by parallelizing lots of call to the API, you must setup and use your own <a href="https://docs.python.org/3/library/concurrent.futures.html#threadpoolexecutor" rel="nofollow">ThreadPoolExecutor</a>.`,sx,og,Lk=`Note: Most-used methods like <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> have a <code>run_as_future: bool</code>
argument to directly call them in the background. This is equivalent to calling <code>api.run_as_future(...)</code> on them
but less verbose.`,rx,ns,ix,tt,Mi,cx,ag,Zk="Scale Inference Endpoint to zero.",lx,sg,Vk=`An Inference Endpoint scaled to zero will not be charged. It will be resume on the next request to it, with a
cold start delay. This is different than pausing the Inference Endpoint with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a>, which
would require a manual resume with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a>.`,px,rg,Pk='For convenience, you can also scale an Inference Endpoint to zero using <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">InferenceEndpoint.scale_to_zero()</a>.',dx,nt,ji,gx,ig,Wk="Set a custom sleep time for a Space running on upgraded hardware..",ux,cg,Bk=`Your Space will go to sleep after X seconds of inactivity. You are not billed when your Space is in “sleep”
mode. If a new visitor lands on your Space, it will “wake it up”. Only upgraded hardware can have a
configurable sleep time. To know more about the sleep stage, please refer to
<a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a>.`,hx,os,fx,ge,Hi,mx,lg,Yk="Download repo files.",_x,pg,Xk=`Download a whole snapshot of a repo’s files at the specified revision. This is useful when you want all files from
a repo, because you don’t know which ones you will need a priori. All files are nested inside a folder in order
to keep their actual filename relative to that folder. You can also filter which files to download using
<code>allow_patterns</code> and <code>ignore_patterns</code>.`,bx,dg,zk=`If <code>local_dir</code> is provided, the file structure from the repo will be replicated in this location. When using this
option, the <code>cache_dir</code> will not be used and a <code>.cache/huggingface/</code> folder will be created at the root of <code>local_dir</code>
to store some metadata related to the downloaded files.While this mechanism is not as robust as the main
cache-system, it’s optimized for regularly pulling the latest version of a repository.`,vx,gg,Ok=`An alternative would be to clone the repo but this requires git and git-lfs to be installed and properly
configured. It is also not possible to filter which files to download when cloning a repository using git.`,yx,ot,Ci,xx,ug,Qk="Get info on one specific Space on huggingface.co.",$x,hg,Kk="Space can be private if you pass an acceptable token.",wx,as,kx,Y,Ui,Tx,fg,eT="Squash commit history on a branch for a repo on the Hub.",qx,mg,tT=`Squashing the repo history is useful when you know you’ll make hundreds of commits and you don’t want to
clutter the history. Squashing commits can only be performed from the head of a branch.`,Mx,ss,jx,rs,Hx,is,Cx,ue,Ii,Ux,_g,nT="Unlike a given repo on the Hub (e.g. remove from favorite list).",Ix,bg,oT="To prevent spam usage, it is not possible to <code>like</code> a repository from a script.",Ax,vg,aT='See also <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_liked_repos">list_liked_repos()</a>.',Nx,cs,Jx,kn,Ai,Ex,yg,sT="Update an item in a collection.",Dx,ls,Rx,he,Ni,Fx,xg,rT="Update metadata of a collection on the Hub.",Sx,$g,iT="All arguments are optional. Only provided metadata will be updated.",Gx,wg,cT='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.Collection">Collection</a>',Lx,ps,Zx,at,Ji,Vx,kg,lT="Update an Inference Endpoint.",Px,Tg,pT=`This method allows the update of either the compute configuration, the deployed model, or both. All arguments are
optional but at least one must be provided.`,Wx,qg,dT='For convenience, you can also update an Inference Endpoint using <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">InferenceEndpoint.update()</a>.',Bx,Tn,Ei,Yx,Mg,gT="Update the settings of a repository, including gated access and visibility.",Xx,jg,uT=`To give more control over how repos are used, the Hub allows repo authors to enable
access requests for their repos, and also to set the visibility of the repo to private.`,zx,st,Di,Ox,Hg,hT="Update the visibility setting of a repository.",Qx,Cg,fT="Deprecated. Use <code>update_repo_settings</code> instead.",Kx,ds,e$,qn,Ri,t$,Ug,mT="Update an existing webhook.",n$,gs,o$,fe,Fi,a$,Ig,_T=`Upload a local file (up to 50 GB) to the given repo. The upload is done
through a HTTP post request, and doesn’t require git or git-lfs to be
installed.`,s$,us,r$,hs,i$,fs,c$,N,Si,l$,Ag,bT=`Upload a local folder to the given repo. The upload is done through a HTTP requests, and doesn’t require git or
git-lfs to be installed.`,p$,Ng,vT=`The structure of the folder will be preserved. Files with the same name already present in the repository will
be overwritten. Others will be left untouched.`,d$,Jg,yT=`Use the <code>allow_patterns</code> and <code>ignore_patterns</code> arguments to specify which files to upload. These parameters
accept either a single pattern or a list of patterns. Patterns are Standard Wildcards (globbing patterns) as
documented <a href="https://tldp.org/LDP/GNU-Linux-Tools-Summary/html/x11655.htm" rel="nofollow">here</a>. If both <code>allow_patterns</code> and
<code>ignore_patterns</code> are provided, both constraints apply. By default, all files from the folder are uploaded.`,g$,Eg,xT=`Use the <code>delete_patterns</code> argument to specify remote files you want to delete. Input type is the same as for
<code>allow_patterns</code> (see above). If <code>path_in_repo</code> is also provided, the patterns are matched against paths
relative to this folder. For example, <code>upload_folder(..., path_in_repo=&quot;experiment&quot;, delete_patterns=&quot;logs/*&quot;)</code>
will delete any remote file under <code>./experiment/logs/</code>. Note that the <code>.gitattributes</code> file will not be deleted
even if it matches the patterns.`,u$,Dg,$T=`Any <code>.git/</code> folder present in any subdirectory will be ignored. However, please be aware that the <code>.gitignore</code>
file is not taken into account.`,h$,Rg,wT="Uses <code>HfApi.create_commit</code> under the hood.",f$,ms,m$,_s,_$,bs,b$,vs,v$,A,Gi,y$,Fg,kT="Upload a large folder to the Hub in the most resilient way possible.",x$,Sg,TT=`Several workers are started to upload files in an optimized way. Before being committed to a repo, files must be
hashed and be pre-uploaded if they are LFS files. Workers will perform these tasks for each file in the folder.
At each step, some metadata information about the upload process is saved in the folder under <code>.cache/.huggingface/</code>
to be able to resume the process if interrupted. The whole process might result in several commits.`,$$,ys,w$,xs,k$,Gg,qT="<strong>Technical details:</strong>",T$,Lg,MT="<code>upload_large_folder</code> process is as follow:",q$,Zg,jT=`<li>(Check parameters and setup.)</li> <li>Create repo if missing.</li> <li>List local files to upload.</li> <li>Start workers. Workers can perform the following tasks:<ul><li>Hash a file.</li> <li>Get upload mode (regular or LFS) for a list of files.</li> <li>Pre-upload an LFS file.</li> <li>Commit a bunch of files.
Once a worker finishes a task, it will move on to the next task based on the priority list (see below) until
all files are uploaded and committed.</li></ul></li> <li>While workers are up, regularly print a report to sys.stdout.</li>`,M$,Vg,HT="Order of priority:",j$,Pg,CT="<li>Commit if more than 5 minutes since last commit attempt (and at least 1 file).</li> <li>Commit if at least 150 files are ready to commit.</li> <li>Get upload mode if at least 10 files have been hashed.</li> <li>Pre-upload LFS file if at least 1 file and no worker is pre-uploading.</li> <li>Hash file if at least 1 file and no worker is hashing.</li> <li>Get upload mode if at least 1 file and no worker is getting upload mode.</li> <li>Pre-upload LFS file if at least 1 file (exception: if hf_transfer is enabled, only 1 worker can preupload LFS at a time).</li> <li>Hash file if at least 1 file to hash.</li> <li>Get upload mode if at least 1 file to get upload mode.</li> <li>Commit if at least 1 file to commit and at least 1 min since last commit attempt.</li> <li>Commit if at least 1 file to commit and all other queues are empty.</li>",H$,Wg,UT="Special rules:",C$,Bg,IT="<li>If <code>hf_transfer</code> is enabled, only 1 LFS uploader at a time. Otherwise the CPU would be bloated by <code>hf_transfer</code>.</li> <li>Only one worker can commit at a time.</li> <li>If no tasks are available, the worker waits for 10 seconds before checking again.</li>",U$,$s,Li,I$,Yg,AT="Call HF API to know “whoami”.",ah,Zi,sh,Vi,rh,Dn,Pi,A$,Xg,NT="Data structure containing information about a user access request.",ih,Wi,ch,ct,Bi,N$,zg,JT="Data structure containing information about a newly created commit.",J$,Og,ET=`Returned by any method that creates a commit on the Hub: <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>,
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.delete_file">delete_file()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.delete_folder">delete_folder()</a>. It inherits from <code>str</code> for backward compatibility but using methods specific
to <code>str</code> is deprecated.`,lh,Yi,ph,lt,Xi,E$,Qg,DT="Contains information about a dataset on the Hub.",D$,ws,dh,zi,gh,Rn,Oi,R$,Kg,RT="Contains information about a git reference for a repo on the Hub.",uh,Qi,hh,Fn,Ki,F$,eu,FT='Contains information about a git commit for a repo on the Hub. Check out <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_repo_commits">list_repo_commits()</a> for more details.',fh,ec,mh,pt,tc,S$,tu,ST="Contains information about all git references for a repo on the Hub.",G$,nu,GT='Object is returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_repo_refs">list_repo_refs()</a>.',_h,nc,bh,dt,oc,L$,ou,LT="Contains information about a model on the Hub.",Z$,ks,vh,ac,yh,gt,sc,V$,au,ZT="Contains basic information about a repo file inside a repo on the Hub.",P$,Ts,xh,rc,$h,Sn,ic,W$,su,VT="Contains information about a file on the Hub.",wh,cc,kh,z,lc,B$,ru,PT="Subclass of <code>str</code> describing a repo URL on the Hub.",Y$,iu,WT=`<code>RepoUrl</code> is returned by <code>HfApi.create_repo</code>. It inherits from <code>str</code> for backward
compatibility. At initialization, the URL is parsed to populate properties:`,X$,cu,BT="<li>endpoint (<code>str</code>)</li> <li>namespace (<code>Optional[str]</code>)</li> <li>repo_name (<code>str</code>)</li> <li>repo_id (<code>str</code>)</li> <li>repo_type (<code>Literal[&quot;model&quot;, &quot;dataset&quot;, &quot;space&quot;]</code>)</li> <li>url (<code>str</code>)</li>",z$,qs,Th,pc,qh,O,dc,O$,lu,YT="Metadata for a Safetensors repo.",Q$,pu,XT=`A repo is considered to be a Safetensors repo if it contains either a ‘model.safetensors’ weight file (non-shared
model) or a ‘model.safetensors.index.json’ index file (sharded model) at its root.`,K$,du,zT='This class is returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_safetensors_metadata">get_safetensors_metadata()</a>.',e2,gu,OT='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',Mh,gc,jh,me,uc,t2,uu,QT="Metadata for a Safetensors file hosted on the Hub.",n2,hu,KT='This class is returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.parse_safetensors_file_metadata">parse_safetensors_file_metadata()</a>.',o2,fu,e0='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',Hh,hc,Ch,ut,fc,a2,mu,t0="Contains information about a Space on the Hub.",s2,Ms,Uh,mc,Ih,ht,_c,r2,_u,n0="Information about a tensor.",i2,bu,o0='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',Ah,bc,Nh,Gn,vc,c2,vu,a0="Contains information about a user on the Hub.",Jh,yc,Eh,Ln,xc,l2,yu,s0="Contains information about a user likes on the Hub.",Dh,$c,Rh,wc,r0="<code>CommitOperation()</code>에 지원되는 값은 다음과 같습니다:",Fh,_e,kc,p2,xu,i0="Data structure holding necessary info to upload a file to a repository on the Hub.",d2,Mn,Tc,g2,$u,c0=`A context manager that yields a file-like object allowing to read the underlying
data behind <code>path_or_fileobj</code>.`,u2,js,h2,jn,qc,f2,wu,l0="The base64-encoded content of <code>path_or_fileobj</code>",m2,ku,p0="Returns: <code>bytes</code>",Sh,Zn,Mc,_2,Tu,d0=`Data structure holding necessary info to delete a file or a folder from a repository
on the Hub.`,Gh,Q,jc,b2,qu,g0="Data structure holding necessary info to copy a file in a repository on the Hub.",v2,Mu,u0="Limitations:",y2,ju,h0="<li>Only LFS files can be copied. To copy a regular file, you need to download it locally and re-upload it</li> <li>Cross-repository copies are not supported.</li>",x2,Hu,f0='Note: you can combine a <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitOperationCopy">CommitOperationCopy</a> and a <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitOperationDelete">CommitOperationDelete</a> to rename an LFS file on the Hub.',Lh,Hc,Zh,D,Cc,$2,Cu,m0="Scheduler to upload a local folder to the Hub at regular intervals (e.g. push to hub every 5 minutes).",w2,Uu,_0=`The recommended way to use the scheduler is to use it as a context manager. This ensures that the scheduler is
properly stopped and the last commit is triggered when the script ends. The scheduler can also be stopped manually
with the <code>stop</code> method. Checkout the <a href="https://huggingface.co/docs/huggingface_hub/guides/upload#scheduled-uploads" rel="nofollow">upload guide</a>
to learn more about how to use it.`,k2,Hs,T2,Cs,q2,rt,Uc,M2,Iu,b0="Push folder to the Hub and return the commit info.",j2,Us,H2,Au,v0=`The default behavior of <code>push_to_hub</code> is to assume an append-only folder. It lists all files in the folder and
uploads only changed files. If no changes are found, the method returns without committing anything. If you want
to change this behavior, you can inherit from <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a> and override this method. This can be useful
for example to compress data together in a single file before committing. For more details and examples, check
out our <a href="https://huggingface.co/docs/huggingface_hub/main/en/guides/upload#scheduled-uploads" rel="nofollow">integration guide</a>.`,C2,Hn,Ic,U2,Nu,y0="Stop the scheduler.",I2,Ju,x0="A stopped scheduler cannot be restarted. Mostly for tests purposes.",A2,Cn,Ac,N2,Eu,$0="Trigger a <code>push_to_hub</code> and return a future.",J2,Du,w0=`This method is automatically called every <code>every</code> minutes. You can also call it manually to trigger a commit
immediately, without waiting for the next scheduled commit.`,Vh,Nc,Ph,Qu,Wh;return g=new R({props:{title:"HfApi Client",local:"hfapi-client",headingTag:"h1"}}),Fs=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwbGlzdF9tb2RlbHMlMEElMEElMjMlMjAlRUIlQTMlQTglRUQlOEElQjglMjAlRUIlQTklOTQlRUMlODQlOUMlRUIlOTMlOUMlRUIlQTUlQkMlMjAlRUMlODIlQUMlRUMlOUElQTklRUQlOTUlOTglRUMlODQlQjglRUMlOUElOTQuJTBBbW9kZWxzJTIwJTNEJTIwbGlzdF9tb2RlbHMoKSUwQSUwQSUyMyUyMCVFQiU5OCU5MCVFQiU4QSU5NCUyMEhmQXBpJTIwY2xpZW50JUVCJUE1JUJDJTIwJUVBJUI1JUFDJUVDJTg0JUIxJUVEJTk1JTk4JUVDJTg0JUI4JUVDJTlBJTk0LiUwQWhmX2FwaSUyMCUzRCUyMEhmQXBpKCUwQSUyMCUyMCUyMCUyMGVuZHBvaW50JTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyMiUyQyUyMCUyMyUyMCVFQiVCOSU4NCVFQSVCMyVCNSVFQSVCMCU5QyUyMEh1YiUyMCVFQyU5NyU5NCVFQiU5MyU5QyVFRCU4RiVBQyVFQyU5RCVCOCVFRCU4QSVCOCVFQiVBNSVCQyUyMCVFQyVBNyU4MCVFQyVBMCU5NSVFRCU5NSVBMCUyMCVFQyU4OCU5OCUyMCVFQyU5RSU4OCVFQyU4QSVCNSVFQiU4QiU4OCVFQiU4QiVBNC4lMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMmhmX3h4eCUyMiUyQyUyMCUyMyUyMCVFRCU4NiVBMCVFRCU4MSVCMCVFQyU5RCU4MCUyMCVFQiVBOCVCOCVFQyU4QiVBMCVFQyU5NyU5MCUyMCVFQyU5QyVBMCVFQyVBNyU4MCVFQiU5MCU5OCVFQyVBNyU4MCUyMCVFQyU5NSU4QSVFQyU4QSVCNSVFQiU4QiU4OCVFQiU4QiVBNC4lMEEpJTBBbW9kZWxzJTIwJTNEJTIwaGZfYXBpLmxpc3RfbW9kZWxzKCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, list_models

<span class="hljs-comment"># 루트 메서드를 사용하세요.</span>
models = list_models()

<span class="hljs-comment"># 또는 HfApi client를 구성하세요.</span>
hf_api = HfApi(
    endpoint=<span class="hljs-string">&quot;https://huggingface.co&quot;</span>, <span class="hljs-comment"># 비공개 Hub 엔드포인트를 지정할 수 있습니다.</span>
    token=<span class="hljs-string">&quot;hf_xxx&quot;</span>, <span class="hljs-comment"># 토큰은 머신에 유지되지 않습니다.</span>
)
models = hf_api.list_models()`,wrap:!1}}),Ss=new R({props:{title:"HfApi",local:"huggingface_hub.HfApi ][ huggingface_hub.HfApi",headingTag:"h2"}}),Gs=new j({props:{name:"class huggingface_hub.HfApi",anchor:"huggingface_hub.HfApi",parameters:[{name:"endpoint",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"library_name",val:": Optional[str] = None"},{name:"library_version",val:": Optional[str] = None"},{name:"user_agent",val:": Union[Dict, str, None] = None"},{name:"headers",val:": Optional[Dict[str, str]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.endpoint",description:`<strong>endpoint</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Endpoint of the Hub. Defaults to <a href="https://huggingface.co" rel="nofollow">https://huggingface.co</a>.`,name:"endpoint"},{anchor:"huggingface_hub.HfApi.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.library_name",description:`<strong>library_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the library that is making the HTTP request. Will be added to
the user-agent header. Example: <code>&quot;transformers&quot;</code>.`,name:"library_name"},{anchor:"huggingface_hub.HfApi.library_version",description:`<strong>library_version</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The version of the library that is making the HTTP request. Will be added
to the user-agent header. Example: <code>&quot;4.24.0&quot;</code>.`,name:"library_version"},{anchor:"huggingface_hub.HfApi.user_agent",description:`<strong>user_agent</strong> (<code>str</code>, <code>dict</code>, <em>optional</em>) &#x2014;
The user agent info in the form of a dictionary or a single string. It will
be completed with information about the installed packages.`,name:"user_agent"},{anchor:"huggingface_hub.HfApi.headers",description:`<strong>headers</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional headers to be sent with each request. Example: <code>{&quot;X-My-Header&quot;: &quot;value&quot;}</code>.
Headers passed here are taking precedence over the default headers.`,name:"headers"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1565"}}),Ls=new j({props:{name:"accept_access_request",anchor:"huggingface_hub.HfApi.accept_access_request",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.accept_access_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to accept access request for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.accept_access_request.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user which access request should be accepted.`,name:"user"},{anchor:"huggingface_hub.HfApi.accept_access_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to accept access request for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.accept_access_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8620",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request cannot be found.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request is already in the accepted list.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Zs=new j({props:{name:"add_collection_item",anchor:"huggingface_hub.HfApi.add_collection_item",parameters:[{name:"collection_slug",val:": str"},{name:"item_id",val:": str"},{name:"item_type",val:": CollectionItemType_T"},{name:"note",val:": Optional[str] = None"},{name:"exists_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.add_collection_item.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.add_collection_item.item_id",description:`<strong>item_id</strong> (<code>str</code>) &#x2014;
ID of the item to add to the collection. It can be the ID of a repo on the Hub (e.g. <code>&quot;facebook/bart-large-mnli&quot;</code>)
or a paper id (e.g. <code>&quot;2307.09288&quot;</code>).`,name:"item_id"},{anchor:"huggingface_hub.HfApi.add_collection_item.item_type",description:`<strong>item_type</strong> (<code>str</code>) &#x2014;
Type of the item to add. Can be one of <code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code>, <code>&quot;space&quot;</code> or <code>&quot;paper&quot;</code>.`,name:"item_type"},{anchor:"huggingface_hub.HfApi.add_collection_item.note",description:`<strong>note</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A note to attach to the item in the collection. The maximum size for a note is 500 characters.`,name:"note"},{anchor:"huggingface_hub.HfApi.add_collection_item.exists_ok",description:`<strong>exists_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if item already exists.`,name:"exists_ok"},{anchor:"huggingface_hub.HfApi.add_collection_item.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8172",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the item you try to add to the collection does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 409 if the item you try to add to the collection is already in the collection (and exists_ok=False)</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),$o=new U({props:{anchor:"huggingface_hub.HfApi.add_collection_item.example",$$slots:{default:[I0]},$$scope:{ctx:T}}}),Vs=new j({props:{name:"add_space_secret",anchor:"huggingface_hub.HfApi.add_space_secret",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"value",val:": str"},{name:"description",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.add_space_secret.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.add_space_secret.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Secret key. Example: <code>&quot;GITHUB_API_KEY&quot;</code>`,name:"key"},{anchor:"huggingface_hub.HfApi.add_space_secret.value",description:`<strong>value</strong> (<code>str</code>) &#x2014;
Secret value. Example: <code>&quot;your_github_api_key&quot;</code>.`,name:"value"},{anchor:"huggingface_hub.HfApi.add_space_secret.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Secret description. Example: <code>&quot;Github API key to access the Github API&quot;</code>.`,name:"description"},{anchor:"huggingface_hub.HfApi.add_space_secret.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6713"}}),Ps=new j({props:{name:"add_space_variable",anchor:"huggingface_hub.HfApi.add_space_variable",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"value",val:": str"},{name:"description",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.add_space_variable.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.add_space_variable.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Variable key. Example: <code>&quot;MODEL_REPO_ID&quot;</code>`,name:"key"},{anchor:"huggingface_hub.HfApi.add_space_variable.value",description:`<strong>value</strong> (<code>str</code>) &#x2014;
Variable value. Example: <code>&quot;the_model_repo_id&quot;</code>.`,name:"value"},{anchor:"huggingface_hub.HfApi.add_space_variable.description",description:`<strong>description</strong> (<code>str</code>) &#x2014;
Description of the variable. Example: <code>&quot;Model Repo ID of the implemented model&quot;</code>.`,name:"description"},{anchor:"huggingface_hub.HfApi.add_space_variable.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6801"}}),Ws=new j({props:{name:"auth_check",anchor:"huggingface_hub.HfApi.auth_check",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.auth_check.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to check for access. Format should be <code>&quot;user/repo_name&quot;</code>.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.auth_check.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository. Should be one of <code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code>, or <code>&quot;space&quot;</code>.
If not specified, the default is <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.auth_check.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9528",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>
<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
Raised if the repository does not exist, is private, or the user does not have access. This can
occur if the <code>repo_id</code> or <code>repo_type</code> is incorrect or if the repository is private but the user
is not authenticated.</p>
</li>
<li>
<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.GatedRepoError"
>GatedRepoError</a> —
Raised if the repository exists but is gated and the user is not authorized to access it.</p>
</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.GatedRepoError"
>GatedRepoError</a></p>
`}}),wo=new U({props:{anchor:"huggingface_hub.HfApi.auth_check.example",$$slots:{default:[A0]},$$scope:{ctx:T}}}),Bs=new j({props:{name:"cancel_access_request",anchor:"huggingface_hub.HfApi.cancel_access_request",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.cancel_access_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to cancel access request for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.cancel_access_request.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user which access request should be cancelled.`,name:"user"},{anchor:"huggingface_hub.HfApi.cancel_access_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to cancel access request for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.cancel_access_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8580",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request cannot be found.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request is already in the pending list.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Ys=new j({props:{name:"change_discussion_status",anchor:"huggingface_hub.HfApi.change_discussion_status",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"new_status",val:": Literal['open', 'closed']"},{name:"token",val:": Union[bool, str, None] = None"},{name:"comment",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.change_discussion_status.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.change_discussion_status.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.change_discussion_status.new_status",description:`<strong>new_status</strong> (<code>str</code>) &#x2014;
The new status for the discussion, either <code>&quot;open&quot;</code> or <code>&quot;closed&quot;</code>.`,name:"new_status"},{anchor:"huggingface_hub.HfApi.change_discussion_status.comment",description:`<strong>comment</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional comment to post with the status change.`,name:"comment"},{anchor:"huggingface_hub.HfApi.change_discussion_status.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.change_discussion_status.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6455",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the status change event</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionStatusChange"
>DiscussionStatusChange</a></p>
`}}),ko=new U({props:{anchor:"huggingface_hub.HfApi.change_discussion_status.example",$$slots:{default:[N0]},$$scope:{ctx:T}}}),To=new I({props:{$$slots:{default:[J0]},$$scope:{ctx:T}}}),Xs=new j({props:{name:"comment_discussion",anchor:"huggingface_hub.HfApi.comment_discussion",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"comment",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.comment_discussion.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.comment_discussion.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.comment_discussion.comment",description:`<strong>comment</strong> (<code>str</code>) &#x2014;
The content of the comment to create. Comments support markdown formatting.`,name:"comment"},{anchor:"huggingface_hub.HfApi.comment_discussion.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.comment_discussion.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6306",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the newly created comment</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionComment"
>DiscussionComment</a></p>
`}}),qo=new U({props:{anchor:"huggingface_hub.HfApi.comment_discussion.example",$$slots:{default:[E0]},$$scope:{ctx:T}}}),Mo=new I({props:{$$slots:{default:[D0]},$$scope:{ctx:T}}}),zs=new j({props:{name:"create_branch",anchor:"huggingface_hub.HfApi.create_branch",parameters:[{name:"repo_id",val:": str"},{name:"branch",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"exist_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_branch.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which the branch will be created.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_branch.branch",description:`<strong>branch</strong> (<code>str</code>) &#x2014;
The name of the branch to create.`,name:"branch"},{anchor:"huggingface_hub.HfApi.create_branch.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to create the branch from. It can be a branch name or
the OID/SHA of a commit, as a hexadecimal string. Defaults to the head
of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_branch.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_branch.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if creating a branch on a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if tagging a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_branch.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if branch already exists.`,name:"exist_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5647",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If invalid reference for a branch. Ex: <code>refs/pr/5</code> or ‘refs/foo/bar’.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If the branch already exists on the repo (error 409) and <code>exist_ok</code> is
set to <code>False</code>.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a></p>
`}}),Os=new j({props:{name:"create_collection",anchor:"huggingface_hub.HfApi.create_collection",parameters:[{name:"title",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"description",val:": Optional[str] = None"},{name:"private",val:": bool = False"},{name:"exists_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_collection.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
Title of the collection to create. Example: <code>&quot;Recent models&quot;</code>.`,name:"title"},{anchor:"huggingface_hub.HfApi.create_collection.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Namespace of the collection to create (username or org). Will default to the owner name.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.create_collection.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Description of the collection to create.`,name:"description"},{anchor:"huggingface_hub.HfApi.create_collection.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the collection should be private or not. Defaults to <code>False</code> (i.e. public collection).`,name:"private"},{anchor:"huggingface_hub.HfApi.create_collection.exists_ok",description:`<strong>exists_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if collection already exists.`,name:"exists_ok"},{anchor:"huggingface_hub.HfApi.create_collection.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7995"}}),Ho=new U({props:{anchor:"huggingface_hub.HfApi.create_collection.example",$$slots:{default:[R0]},$$scope:{ctx:T}}}),Qs=new j({props:{name:"create_commit",anchor:"huggingface_hub.HfApi.create_commit",parameters:[{name:"repo_id",val:": str"},{name:"operations",val:": Iterable[CommitOperation]"},{name:"commit_message",val:": str"},{name:"commit_description",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"num_threads",val:": int = 5"},{name:"parent_commit",val:": Optional[str] = None"},{name:"run_as_future",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_commit.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which the commit will be created, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_commit.operations",description:`<strong>operations</strong> (<code>Iterable</code> of <code>CommitOperation()</code>) &#x2014;
An iterable of operations to include in the commit, either:</p>
<ul>
<li><a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitOperationAdd">CommitOperationAdd</a> to upload a file</li>
<li><a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitOperationDelete">CommitOperationDelete</a> to delete a file</li>
<li><a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitOperationCopy">CommitOperationCopy</a> to copy a file</li>
</ul>
<p>Operation objects will be mutated to include information relative to the upload. Do not reuse the
same objects for multiple commits.`,name:"operations"},{anchor:"huggingface_hub.HfApi.create_commit.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
The summary (first line) of the commit that will be created.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.create_commit.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.create_commit.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_commit.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_commit.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_commit.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.create_commit.num_threads",description:`<strong>num_threads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of concurrent threads for uploading files. Defaults to 5.
Setting it to 2 means at most 2 files will be uploaded concurrently.`,name:"num_threads"},{anchor:"huggingface_hub.HfApi.create_commit.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string.
Shorthands (7 first characters) are also supported. If specified and <code>create_pr</code> is <code>False</code>,
the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>. If specified and <code>create_pr</code>
is <code>True</code>, the pull request will be created from <code>parent_commit</code>. Specifying <code>parent_commit</code>
ensures the repo has not changed before committing the changes, and can be especially useful
if the repo is updated / committed to concurrently.`,name:"parent_commit"},{anchor:"huggingface_hub.HfApi.create_commit.run_as_future",description:`<strong>run_as_future</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to run this method in the background. Background jobs are run sequentially without
blocking the main thread. Passing <code>run_as_future=True</code> will return a <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow">Future</a>
object. Defaults to <code>False</code>.`,name:"run_as_future"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3820",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Instance of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> containing information about the newly created commit (commit hash, commit
url, pr url, commit message,…). If <code>run_as_future=True</code> is passed, returns a Future object which will
contain the result when executed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> or <code>Future</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If commit message is empty.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If parent commit is not a valid commit OID.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If a README.md file with an invalid metadata section is committed. In this case, the commit will fail
early, before trying to upload any file.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>create_pr</code> is <code>True</code> and revision is neither <code>None</code> nor <code>"main"</code>.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),Co=new I({props:{warning:!0,$$slots:{default:[F0]},$$scope:{ctx:T}}}),Uo=new I({props:{warning:!0,$$slots:{default:[S0]},$$scope:{ctx:T}}}),Io=new I({props:{warning:!0,$$slots:{default:[G0]},$$scope:{ctx:T}}}),Ks=new j({props:{name:"create_discussion",anchor:"huggingface_hub.HfApi.create_discussion",parameters:[{name:"repo_id",val:": str"},{name:"title",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"description",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"pull_request",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_discussion.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_discussion.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
The title of the discussion. It can be up to 200 characters long,
and must be at least 3 characters long. Leading and trailing whitespaces
will be stripped.`,name:"title"},{anchor:"huggingface_hub.HfApi.create_discussion.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_discussion.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional description for the Pull Request.
Defaults to <code>&quot;Discussion opened with the huggingface_hub Python library&quot;</code>`,name:"description"},{anchor:"huggingface_hub.HfApi.create_discussion.pull_request",description:`<strong>pull_request</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to create a Pull Request or discussion. If <code>True</code>, creates a Pull Request.
If <code>False</code>, creates a discussion. Defaults to <code>False</code>.`,name:"pull_request"},{anchor:"huggingface_hub.HfApi.create_discussion.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6127"}}),Ao=new I({props:{$$slots:{default:[L0]},$$scope:{ctx:T}}}),er=new j({props:{name:"create_inference_endpoint",anchor:"huggingface_hub.HfApi.create_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"repository",val:": str"},{name:"framework",val:": str"},{name:"accelerator",val:": str"},{name:"instance_size",val:": str"},{name:"instance_type",val:": str"},{name:"region",val:": str"},{name:"vendor",val:": str"},{name:"account_id",val:": Optional[str] = None"},{name:"min_replica",val:": int = 0"},{name:"max_replica",val:": int = 1"},{name:"scale_to_zero_timeout",val:": int = 15"},{name:"revision",val:": Optional[str] = None"},{name:"task",val:": Optional[str] = None"},{name:"custom_image",val:": Optional[Dict] = None"},{name:"secrets",val:": Optional[Dict[str, str]] = None"},{name:"type",val:": InferenceEndpointType = <InferenceEndpointType.PROTECTED: 'protected'>"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The unique name for the new Inference Endpoint.`,name:"name"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.repository",description:`<strong>repository</strong> (<code>str</code>) &#x2014;
The name of the model repository associated with the Inference Endpoint (e.g. <code>&quot;gpt2&quot;</code>).`,name:"repository"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.framework",description:`<strong>framework</strong> (<code>str</code>) &#x2014;
The machine learning framework used for the model (e.g. <code>&quot;custom&quot;</code>).`,name:"framework"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.accelerator",description:`<strong>accelerator</strong> (<code>str</code>) &#x2014;
The hardware accelerator to be used for inference (e.g. <code>&quot;cpu&quot;</code>).`,name:"accelerator"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.instance_size",description:`<strong>instance_size</strong> (<code>str</code>) &#x2014;
The size or type of the instance to be used for hosting the model (e.g. <code>&quot;x4&quot;</code>).`,name:"instance_size"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.instance_type",description:`<strong>instance_type</strong> (<code>str</code>) &#x2014;
The cloud instance type where the Inference Endpoint will be deployed (e.g. <code>&quot;intel-icl&quot;</code>).`,name:"instance_type"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.region",description:`<strong>region</strong> (<code>str</code>) &#x2014;
The cloud region in which the Inference Endpoint will be created (e.g. <code>&quot;us-east-1&quot;</code>).`,name:"region"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.vendor",description:`<strong>vendor</strong> (<code>str</code>) &#x2014;
The cloud provider or vendor where the Inference Endpoint will be hosted (e.g. <code>&quot;aws&quot;</code>).`,name:"vendor"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.account_id",description:`<strong>account_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The account ID used to link a VPC to a private Inference Endpoint (if applicable).`,name:"account_id"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.min_replica",description:`<strong>min_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of replicas (instances) to keep running for the Inference Endpoint. Defaults to 0.`,name:"min_replica"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.max_replica",description:`<strong>max_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of replicas (instances) to scale to for the Inference Endpoint. Defaults to 1.`,name:"max_replica"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.scale_to_zero_timeout",description:`<strong>scale_to_zero_timeout</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The duration in minutes before an inactive endpoint is scaled to zero. Defaults to 15.`,name:"scale_to_zero_timeout"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model revision to deploy on the Inference Endpoint (e.g. <code>&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</code>).`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task on which to deploy the model (e.g. <code>&quot;text-classification&quot;</code>).`,name:"task"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.custom_image",description:`<strong>custom_image</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A custom Docker image to use for the Inference Endpoint. This is useful if you want to deploy an
Inference Endpoint running on the <code>text-generation-inference</code> (TGI) framework (see examples).`,name:"custom_image"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.secrets",description:`<strong>secrets</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Secret values to inject in the container environment.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.type",description:"<strong>type</strong> ([`InferenceEndpointType]<code>, *optional*) -- The type of the Inference Endpoint, which can be </code>&#x201C;protected&#x201D;<code>(default),</code>&#x201C;public&#x201D;<code>or</code>&#x201C;private&#x201D;`.",name:"type"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Inference Endpoint will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7330",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the updated Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),No=new U({props:{anchor:"huggingface_hub.HfApi.create_inference_endpoint.example",$$slots:{default:[Z0]},$$scope:{ctx:T}}}),Jo=new U({props:{anchor:"huggingface_hub.HfApi.create_inference_endpoint.example-2",$$slots:{default:[V0]},$$scope:{ctx:T}}}),tr=new j({props:{name:"create_inference_endpoint_from_catalog",anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog",parameters:[{name:"repo_id",val:": str"},{name:"name",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"namespace",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The ID of the model in the catalog to deploy as an Inference Endpoint.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.name",description:`<strong>name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The unique name for the new Inference Endpoint. If not provided, a random name will be generated.`,name:"name"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).`,name:"token"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Inference Endpoint will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7496",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the new Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Eo=new I({props:{warning:!0,$$slots:{default:[P0]},$$scope:{ctx:T}}}),nr=new j({props:{name:"create_pull_request",anchor:"huggingface_hub.HfApi.create_pull_request",parameters:[{name:"repo_id",val:": str"},{name:"title",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"description",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_pull_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_pull_request.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
The title of the discussion. It can be up to 200 characters long,
and must be at least 3 characters long. Leading and trailing whitespaces
will be stripped.`,name:"title"},{anchor:"huggingface_hub.HfApi.create_pull_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_pull_request.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional description for the Pull Request.
Defaults to <code>&quot;Discussion opened with the huggingface_hub Python library&quot;</code>`,name:"description"},{anchor:"huggingface_hub.HfApi.create_pull_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6219"}}),Do=new I({props:{$$slots:{default:[W0]},$$scope:{ctx:T}}}),or=new j({props:{name:"create_repo",anchor:"huggingface_hub.HfApi.create_repo",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"private",val:": Optional[bool] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"exist_ok",val:": bool = False"},{name:"resource_group_id",val:": Optional[str] = None"},{name:"space_sdk",val:": Optional[str] = None"},{name:"space_hardware",val:": Optional[SpaceHardware] = None"},{name:"space_storage",val:": Optional[SpaceStorage] = None"},{name:"space_sleep_time",val:": Optional[int] = None"},{name:"space_secrets",val:": Optional[List[Dict[str, str]]] = None"},{name:"space_variables",val:": Optional[List[Dict[str, str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_repo.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_repo.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_repo.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to make the repo private. If <code>None</code> (default), the repo will be public unless the organization&#x2019;s default is private. This value is ignored if the repo already exists.`,name:"private"},{anchor:"huggingface_hub.HfApi.create_repo.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_repo.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if repo already exists.`,name:"exist_ok"},{anchor:"huggingface_hub.HfApi.create_repo.resource_group_id",description:`<strong>resource_group_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Resource group in which to create the repo. Resource groups is only available for organizations and
allow to define which members of the organization can access the resource. The ID of a resource group
can be found in the URL of the resource&#x2019;s page on the Hub (e.g. <code>&quot;66670e5163145ca562cb1988&quot;</code>).
To learn more about resource groups, see <a href="https://huggingface.co/docs/hub/en/security-resource-groups" rel="nofollow">https://huggingface.co/docs/hub/en/security-resource-groups</a>.`,name:"resource_group_id"},{anchor:"huggingface_hub.HfApi.create_repo.space_sdk",description:`<strong>space_sdk</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Choice of SDK to use if repo_type is &#x201C;space&#x201D;. Can be &#x201C;streamlit&#x201D;, &#x201C;gradio&#x201D;, &#x201C;docker&#x201D;, or &#x201C;static&#x201D;.`,name:"space_sdk"},{anchor:"huggingface_hub.HfApi.create_repo.space_hardware",description:`<strong>space_hardware</strong> (<code>SpaceHardware</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of Hardware if repo_type is &#x201C;space&#x201D;. See <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for a complete list.`,name:"space_hardware"},{anchor:"huggingface_hub.HfApi.create_repo.space_storage",description:`<strong>space_storage</strong> (<code>SpaceStorage</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of persistent storage tier. Example: <code>&quot;small&quot;</code>. See <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceStorage">SpaceStorage</a> for a complete list.`,name:"space_storage"},{anchor:"huggingface_hub.HfApi.create_repo.space_sleep_time",description:`<strong>space_sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to sleep (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"space_sleep_time"},{anchor:"huggingface_hub.HfApi.create_repo.space_secrets",description:`<strong>space_secrets</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of secret keys to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,name:"space_secrets"},{anchor:"huggingface_hub.HfApi.create_repo.space_variables",description:`<strong>space_variables</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of public environment variables to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>.`,name:"space_variables"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3390",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>URL to the newly created repo. Value is a subclass of <code>str</code> containing
attributes like <code>endpoint</code>, <code>repo_type</code> and <code>repo_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.RepoUrl"
>RepoUrl</a></p>
`}}),ar=new j({props:{name:"create_tag",anchor:"huggingface_hub.HfApi.create_tag",parameters:[{name:"repo_id",val:": str"},{name:"tag",val:": str"},{name:"tag_message",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"exist_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_tag.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which a commit will be tagged.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_tag.tag",description:`<strong>tag</strong> (<code>str</code>) &#x2014;
The name of the tag to create.`,name:"tag"},{anchor:"huggingface_hub.HfApi.create_tag.tag_message",description:`<strong>tag_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the tag to create.`,name:"tag_message"},{anchor:"huggingface_hub.HfApi.create_tag.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to tag. It can be a branch name or the OID/SHA of a
commit, as a hexadecimal string. Shorthands (7 first characters) are
also supported. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_tag.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_tag.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if tagging a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if tagging a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_tag.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if tag already exists.`,name:"exist_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5779",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If the branch already exists on the repo (error 409) and <code>exist_ok</code> is
set to <code>False</code>.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a></p>
`}}),sr=new j({props:{name:"create_webhook",anchor:"huggingface_hub.HfApi.create_webhook",parameters:[{name:"url",val:": str"},{name:"watched",val:": List[Union[Dict, WebhookWatchedItem]]"},{name:"domains",val:": Optional[List[constants.WEBHOOK_DOMAIN_T]] = None"},{name:"secret",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_webhook.url",description:`<strong>url</strong> (<code>str</code>) &#x2014;
URL to send the payload to.`,name:"url"},{anchor:"huggingface_hub.HfApi.create_webhook.watched",description:`<strong>watched</strong> (<code>List[WebhookWatchedItem]</code>) &#x2014;
List of <code>WebhookWatchedItem</code> to be watched by the webhook. It can be users, orgs, models, datasets or spaces.
Watched items can also be provided as plain dictionaries.`,name:"watched"},{anchor:"huggingface_hub.HfApi.create_webhook.domains",description:`<strong>domains</strong> (<code>List[Literal[&quot;repo&quot;, &quot;discussion&quot;]]</code>, optional) &#x2014;
List of domains to watch. It can be &#x201C;repo&#x201D;, &#x201C;discussion&#x201D; or both.`,name:"domains"},{anchor:"huggingface_hub.HfApi.create_webhook.secret",description:`<strong>secret</strong> (<code>str</code>, optional) &#x2014;
A secret to sign the payload with.`,name:"secret"},{anchor:"huggingface_hub.HfApi.create_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8899",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the newly created webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WebhookInfo</code></p>
`}}),So=new U({props:{anchor:"huggingface_hub.HfApi.create_webhook.example",$$slots:{default:[B0]},$$scope:{ctx:T}}}),rr=new j({props:{name:"dataset_info",anchor:"huggingface_hub.HfApi.dataset_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[List[ExpandDatasetProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.dataset_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.dataset_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the dataset repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.dataset_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.dataset_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.dataset_info.expand",description:`<strong>expand</strong> (<code>List[ExpandDatasetProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>files_metadata</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;citation&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;description&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;paperswithcode_id&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>,<code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.dataset_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2531",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dataset repository information.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.DatasetInfo"
>hf_api.DatasetInfo</a></p>
`}}),Go=new I({props:{$$slots:{default:[Y0]},$$scope:{ctx:T}}}),ir=new j({props:{name:"delete_branch",anchor:"huggingface_hub.HfApi.delete_branch",parameters:[{name:"repo_id",val:": str"},{name:"branch",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_branch.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which a branch will be deleted.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_branch.branch",description:`<strong>branch</strong> (<code>str</code>) &#x2014;
The name of the branch to delete.`,name:"branch"},{anchor:"huggingface_hub.HfApi.delete_branch.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_branch.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if creating a branch on a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if tagging a model. Default is <code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5727",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If trying to delete a protected branch. Ex: <code>main</code> cannot be deleted.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If trying to delete a branch that does not exist.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a></p>
`}}),cr=new j({props:{name:"delete_collection",anchor:"huggingface_hub.HfApi.delete_collection",parameters:[{name:"collection_slug",val:": str"},{name:"missing_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_collection.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to delete. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.delete_collection.missing_ok",description:`<strong>missing_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if collection doesn&#x2019;t exists.`,name:"missing_ok"},{anchor:"huggingface_hub.HfApi.delete_collection.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8131"}}),Zo=new U({props:{anchor:"huggingface_hub.HfApi.delete_collection.example",$$slots:{default:[X0]},$$scope:{ctx:T}}}),Vo=new I({props:{warning:!0,$$slots:{default:[z0]},$$scope:{ctx:T}}}),lr=new j({props:{name:"delete_collection_item",anchor:"huggingface_hub.HfApi.delete_collection_item",parameters:[{name:"collection_slug",val:": str"},{name:"item_object_id",val:": str"},{name:"missing_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_collection_item.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.delete_collection_item.item_object_id",description:`<strong>item_object_id</strong> (<code>str</code>) &#x2014;
ID of the item in the collection. This is not the id of the item on the Hub (repo_id or paper id).
It must be retrieved from a <a href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.CollectionItem">CollectionItem</a> object. Example: <code>collection.items[0].item_object_id</code>.`,name:"item_object_id"},{anchor:"huggingface_hub.HfApi.delete_collection_item.missing_ok",description:`<strong>missing_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if item doesn&#x2019;t exists.`,name:"missing_ok"},{anchor:"huggingface_hub.HfApi.delete_collection_item.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8307"}}),Po=new U({props:{anchor:"huggingface_hub.HfApi.delete_collection_item.example",$$slots:{default:[O0]},$$scope:{ctx:T}}}),pr=new j({props:{name:"delete_file",anchor:"huggingface_hub.HfApi.delete_file",parameters:[{name:"path_in_repo",val:": str"},{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_file.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example:
<code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.delete_file.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository from which the file will be deleted, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_file.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_file.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the file is in a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if in a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.delete_file.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit. Defaults to
<code>f&quot;Delete {path_in_repo} with huggingface_hub&quot;</code>.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.delete_file.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.delete_file.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.delete_file.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4745"}}),Wo=new I({props:{$$slots:{default:[Q0]},$$scope:{ctx:T}}}),dr=new j({props:{name:"delete_files",anchor:"huggingface_hub.HfApi.delete_files",parameters:[{name:"repo_id",val:": str"},{name:"delete_patterns",val:": List[str]"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository from which the folder will be deleted, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_files.delete_patterns",description:`<strong>delete_patterns</strong> (<code>List[str]</code>) &#x2014;
List of files or folders to delete. Each string can either be
a file path, a folder path or a Unix shell-style wildcard.
E.g. <code>[&quot;file.txt&quot;, &quot;folder/&quot;, &quot;data/*.parquet&quot;]</code>`,name:"delete_patterns"},{anchor:"huggingface_hub.HfApi.delete_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.
to the stored token.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Type of the repo to delete files from. Can be <code>&quot;model&quot;</code>,
<code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>. Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_files.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.delete_files.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary (first line) of the generated commit. Defaults to
<code>f&quot;Delete files using huggingface_hub&quot;</code>.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.delete_files.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit.`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.delete_files.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.delete_files.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4835"}}),gr=new j({props:{name:"delete_folder",anchor:"huggingface_hub.HfApi.delete_folder",parameters:[{name:"path_in_repo",val:": str"},{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_folder.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative folder path in the repo, for example: <code>&quot;checkpoints/1fec34a&quot;</code>.`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.delete_folder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository from which the folder will be deleted, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_folder.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.
to the stored token.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_folder.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the folder is in a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if in a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_folder.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.delete_folder.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit. Defaults to
<code>f&quot;Delete folder {path_in_repo} with huggingface_hub&quot;</code>.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.delete_folder.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit.`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.delete_folder.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.delete_folder.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4911"}}),ur=new j({props:{name:"delete_inference_endpoint",anchor:"huggingface_hub.HfApi.delete_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to delete.`,name:"name"},{anchor:"huggingface_hub.HfApi.delete_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.delete_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7739"}}),hr=new j({props:{name:"delete_repo",anchor:"huggingface_hub.HfApi.delete_repo",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"missing_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_repo.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_repo.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_repo.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_repo.missing_ok",description:`<strong>missing_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if repo does not exist.`,name:"missing_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3539",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to delete from cannot be found and <code>missing_ok</code> is set to False (default).</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),fr=new j({props:{name:"delete_space_secret",anchor:"huggingface_hub.HfApi.delete_space_secret",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_space_secret.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_space_secret.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Secret key. Example: <code>&quot;GITHUB_API_KEY&quot;</code>.`,name:"key"},{anchor:"huggingface_hub.HfApi.delete_space_secret.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6753"}}),mr=new j({props:{name:"delete_space_storage",anchor:"huggingface_hub.HfApi.delete_space_storage",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_space_storage.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to update. Example: <code>&quot;open-llm-leaderboard/open_llm_leaderboard&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_space_storage.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7237",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>BadRequestError</code> —
If space has no persistent storage.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>BadRequestError</code></p>
`}}),_r=new j({props:{name:"delete_space_variable",anchor:"huggingface_hub.HfApi.delete_space_variable",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_space_variable.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_space_variable.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Variable key. Example: <code>&quot;MODEL_REPO_ID&quot;</code>`,name:"key"},{anchor:"huggingface_hub.HfApi.delete_space_variable.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6842"}}),br=new j({props:{name:"delete_tag",anchor:"huggingface_hub.HfApi.delete_tag",parameters:[{name:"repo_id",val:": str"},{name:"tag",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_tag.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which a tag will be deleted.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_tag.tag",description:`<strong>tag</strong> (<code>str</code>) &#x2014;
The name of the tag to delete.`,name:"tag"},{anchor:"huggingface_hub.HfApi.delete_tag.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_tag.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if tagging a dataset or space, <code>None</code> or
<code>&quot;model&quot;</code> if tagging a model. Default is <code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5853",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If tag is not found.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a></p>
`}}),vr=new j({props:{name:"delete_webhook",anchor:"huggingface_hub.HfApi.delete_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to delete.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.delete_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9153",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>None</code></p>
`}}),zo=new U({props:{anchor:"huggingface_hub.HfApi.delete_webhook.example",$$slots:{default:[K0]},$$scope:{ctx:T}}}),yr=new j({props:{name:"disable_webhook",anchor:"huggingface_hub.HfApi.disable_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.disable_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to disable.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.disable_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9102",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the disabled webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WebhookInfo</code></p>
`}}),Oo=new U({props:{anchor:"huggingface_hub.HfApi.disable_webhook.example",$$slots:{default:[eq]},$$scope:{ctx:T}}}),xr=new j({props:{name:"duplicate_space",anchor:"huggingface_hub.HfApi.duplicate_space",parameters:[{name:"from_id",val:": str"},{name:"to_id",val:": Optional[str] = None"},{name:"private",val:": Optional[bool] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"exist_ok",val:": bool = False"},{name:"hardware",val:": Optional[SpaceHardware] = None"},{name:"storage",val:": Optional[SpaceStorage] = None"},{name:"sleep_time",val:": Optional[int] = None"},{name:"secrets",val:": Optional[List[Dict[str, str]]] = None"},{name:"variables",val:": Optional[List[Dict[str, str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.duplicate_space.from_id",description:`<strong>from_id</strong> (<code>str</code>) &#x2014;
ID of the Space to duplicate. Example: <code>&quot;pharma/CLIP-Interrogator&quot;</code>.`,name:"from_id"},{anchor:"huggingface_hub.HfApi.duplicate_space.to_id",description:`<strong>to_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
ID of the new Space. Example: <code>&quot;dog/CLIP-Interrogator&quot;</code>. If not provided, the new Space will have the same
name as the original Space, but in your account.`,name:"to_id"},{anchor:"huggingface_hub.HfApi.duplicate_space.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the new Space should be private or not. Defaults to the same privacy as the original Space.`,name:"private"},{anchor:"huggingface_hub.HfApi.duplicate_space.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.duplicate_space.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if repo already exists.`,name:"exist_ok"},{anchor:"huggingface_hub.HfApi.duplicate_space.hardware",description:`<strong>hardware</strong> (<code>SpaceHardware</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of Hardware. Example: <code>&quot;t4-medium&quot;</code>. See <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for a complete list.`,name:"hardware"},{anchor:"huggingface_hub.HfApi.duplicate_space.storage",description:`<strong>storage</strong> (<code>SpaceStorage</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of persistent storage tier. Example: <code>&quot;small&quot;</code>. See <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceStorage">SpaceStorage</a> for a complete list.`,name:"storage"},{anchor:"huggingface_hub.HfApi.duplicate_space.sleep_time",description:`<strong>sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to sleep (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"sleep_time"},{anchor:"huggingface_hub.HfApi.duplicate_space.secrets",description:`<strong>secrets</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of secret keys to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.duplicate_space.variables",description:`<strong>variables</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of public environment variables to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>.`,name:"variables"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7080",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>URL to the newly created repo. Value is a subclass of <code>str</code> containing
attributes like <code>endpoint</code>, <code>repo_type</code> and <code>repo_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.RepoUrl"
>RepoUrl</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If one of <code>from_id</code> or <code>to_id</code> cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
If the HuggingFace API returned an error</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <code>HTTPError</code></p>
`}}),Qo=new U({props:{anchor:"huggingface_hub.HfApi.duplicate_space.example",$$slots:{default:[tq]},$$scope:{ctx:T}}}),$r=new j({props:{name:"edit_discussion_comment",anchor:"huggingface_hub.HfApi.edit_discussion_comment",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"comment_id",val:": str"},{name:"new_content",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.edit_discussion_comment.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.comment_id",description:`<strong>comment_id</strong> (<code>str</code>) &#x2014;
The ID of the comment to edit.`,name:"comment_id"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.new_content",description:`<strong>new_content</strong> (<code>str</code>) &#x2014;
The new content of the comment. Comments support markdown formatting.`,name:"new_content"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6589",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the edited comment</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionComment"
>DiscussionComment</a></p>
`}}),Ko=new I({props:{$$slots:{default:[nq]},$$scope:{ctx:T}}}),wr=new j({props:{name:"enable_webhook",anchor:"huggingface_hub.HfApi.enable_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.enable_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to enable.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.enable_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9051",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the enabled webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WebhookInfo</code></p>
`}}),ea=new U({props:{anchor:"huggingface_hub.HfApi.enable_webhook.example",$$slots:{default:[oq]},$$scope:{ctx:T}}}),kr=new j({props:{name:"file_exists",anchor:"huggingface_hub.HfApi.file_exists",parameters:[{name:"repo_id",val:": str"},{name:"filename",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.file_exists.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.file_exists.filename",description:`<strong>filename</strong> (<code>str</code>) &#x2014;
The name of the file to check, for example:
<code>&quot;config.json&quot;</code>`,name:"filename"},{anchor:"huggingface_hub.HfApi.file_exists.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.file_exists.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the information. Defaults to <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.file_exists.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2842",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if the file exists, False otherwise.</p>
`}}),ta=new U({props:{anchor:"huggingface_hub.HfApi.file_exists.example",$$slots:{default:[aq]},$$scope:{ctx:T}}}),Tr=new j({props:{name:"get_collection",anchor:"huggingface_hub.HfApi.get_collection",parameters:[{name:"collection_slug",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_collection.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection of the Hub. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.get_collection.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7956"}}),na=new U({props:{anchor:"huggingface_hub.HfApi.get_collection.example",$$slots:{default:[sq]},$$scope:{ctx:T}}}),qr=new j({props:{name:"get_dataset_tags",anchor:"huggingface_hub.HfApi.get_dataset_tags",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1737"}}),Mr=new j({props:{name:"get_discussion_details",anchor:"huggingface_hub.HfApi.get_discussion_details",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_discussion_details.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_discussion_details.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.get_discussion_details.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_discussion_details.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6048"}}),aa=new I({props:{$$slots:{default:[rq]},$$scope:{ctx:T}}}),jr=new j({props:{name:"get_full_repo_name",anchor:"huggingface_hub.HfApi.get_full_repo_name",parameters:[{name:"model_id",val:": str"},{name:"organization",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_full_repo_name.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
The name of the model.`,name:"model_id"},{anchor:"huggingface_hub.HfApi.get_full_repo_name.organization",description:`<strong>organization</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If passed, the repository name will be in the organization
namespace instead of the user namespace.`,name:"organization"},{anchor:"huggingface_hub.HfApi.get_full_repo_name.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5902",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The repository name in the user’s namespace
({username}/{model_id}) if no organization is passed, and under the
organization namespace ({organization}/{model_id}) otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Hr=new j({props:{name:"get_hf_file_metadata",anchor:"huggingface_hub.HfApi.get_hf_file_metadata",parameters:[{name:"url",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"proxies",val:": Optional[Dict] = None"},{name:"timeout",val:": Optional[float] = 10"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.url",description:`<strong>url</strong> (<code>str</code>) &#x2014;
File url, for example returned by <code>hf_hub_url()</code>.`,name:"url"},{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.proxies",description:`<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary mapping protocol to the URL of the proxy passed to <code>requests.request</code>.`,name:"proxies"},{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>, defaults to 10) &#x2014;
How many seconds to wait for the server to send metadata before giving up.`,name:"timeout"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5098",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>HfFileMetadata</code> object containing metadata such as location, etag, size and commit_hash.</p>
`}}),Cr=new j({props:{name:"get_inference_endpoint",anchor:"huggingface_hub.HfApi.get_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to retrieve information about.`,name:"name"},{anchor:"huggingface_hub.HfApi.get_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.get_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7584",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the requested Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),ia=new U({props:{anchor:"huggingface_hub.HfApi.get_inference_endpoint.example",$$slots:{default:[iq]},$$scope:{ctx:T}}}),Ur=new j({props:{name:"get_model_tags",anchor:"huggingface_hub.HfApi.get_model_tags",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1728"}}),Ir=new j({props:{name:"get_paths_info",anchor:"huggingface_hub.HfApi.get_paths_info",parameters:[{name:"repo_id",val:": str"},{name:"paths",val:": Union[List[str], str]"},{name:"expand",val:": bool = False"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_paths_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_paths_info.paths",description:`<strong>paths</strong> (<code>Union[List[str], str]</code>, <em>optional</em>) &#x2014;
The paths to get information about. If a path do not exist, it is ignored without raising
an exception.`,name:"paths"},{anchor:"huggingface_hub.HfApi.get_paths_info.expand",description:`<strong>expand</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to fetch more information about the paths (e.g. last commit and files&#x2019; security scan results). This
operation is more expensive for the server so only 50 results are returned per page (instead of 1000).
As pagination is implemented in <code>huggingface_hub</code>, this is transparent for you except for the time it
takes to get the results.`,name:"expand"},{anchor:"huggingface_hub.HfApi.get_paths_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the information. Defaults to <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.get_paths_info.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository from which to get the information (<code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>.
Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_paths_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3227",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The information about the paths, as a list of <code>RepoFile</code> and <code>RepoFolder</code> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Union[RepoFile, RepoFolder]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a></p>
`}}),la=new U({props:{anchor:"huggingface_hub.HfApi.get_paths_info.example",$$slots:{default:[cq]},$$scope:{ctx:T}}}),Ar=new j({props:{name:"get_repo_discussions",anchor:"huggingface_hub.HfApi.get_repo_discussions",parameters:[{name:"repo_id",val:": str"},{name:"author",val:": Optional[str] = None"},{name:"discussion_type",val:": Optional[constants.DiscussionTypeFilter] = None"},{name:"discussion_status",val:": Optional[constants.DiscussionStatusFilter] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_repo_discussions.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass a value to filter by discussion author. <code>None</code> means no filter.
Default is <code>None</code>.`,name:"author"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.discussion_type",description:`<strong>discussion_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;pull_request&quot;</code> to fetch only pull requests, <code>&quot;discussion&quot;</code>
to fetch only discussions. Set to <code>&quot;all&quot;</code> or <code>None</code> to fetch both.
Default is <code>None</code>.`,name:"discussion_type"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.discussion_status",description:`<strong>discussion_status</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;open&quot;</code> (respectively <code>&quot;closed&quot;</code>) to fetch only open
(respectively closed) discussions. Set to <code>&quot;all&quot;</code> or <code>None</code>
to fetch both.
Default is <code>None</code>.`,name:"discussion_status"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if fetching from a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if fetching from a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5940",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An iterator of <a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.Discussion"
>Discussion</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterator[Discussion]</code></p>
`}}),pa=new U({props:{anchor:"huggingface_hub.HfApi.get_repo_discussions.example",$$slots:{default:[lq]},$$scope:{ctx:T}}}),da=new U({props:{anchor:"huggingface_hub.HfApi.get_repo_discussions.example-2",$$slots:{default:[pq]},$$scope:{ctx:T}}}),Nr=new j({props:{name:"get_safetensors_metadata",anchor:"huggingface_hub.HfApi.get_safetensors_metadata",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the file is in a dataset or space, <code>None</code> or <code>&quot;model&quot;</code> if in a
model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to fetch the file from. Can be a branch name, a tag, or a commit hash. Defaults to the
head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5404",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information related to safetensors repo.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>SafetensorsRepoMetadata</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>NotASafetensorsRepoError</code> —
If the repo is not a safetensors repo i.e. doesn’t have either a
<code>model.safetensors</code> or a <code>model.safetensors.index.json</code> file.</li>
<li><code>SafetensorsParsingError</code> —
If a safetensors file header couldn’t be parsed correctly.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>NotASafetensorsRepoError</code> or <code>SafetensorsParsingError</code></p>
`}}),ga=new U({props:{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.example",$$slots:{default:[dq]},$$scope:{ctx:T}}}),Jr=new j({props:{name:"get_space_runtime",anchor:"huggingface_hub.HfApi.get_space_runtime",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_space_runtime.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_space_runtime.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6870",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),Er=new j({props:{name:"get_space_variables",anchor:"huggingface_hub.HfApi.get_space_variables",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_space_variables.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to query. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_space_variables.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6778"}}),Dr=new j({props:{name:"get_token_permission",anchor:"huggingface_hub.HfApi.get_token_permission",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_token_permission.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1688",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Permission granted by the token (“read” or “write”). Returns <code>None</code> if no
token passed, if token is invalid or if role is not returned by the server. This typically happens when the token is an OAuth token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Literal["read", "write", "fineGrained", None]</code></p>
`}}),ha=new I({props:{warning:!0,$$slots:{default:[gq]},$$scope:{ctx:T}}}),Rr=new j({props:{name:"get_user_overview",anchor:"huggingface_hub.HfApi.get_user_overview",parameters:[{name:"username",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_user_overview.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user to get an overview of.`,name:"username"},{anchor:"huggingface_hub.HfApi.get_user_overview.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9352",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.User"
>User</a> object with the user’s overview.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>User</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Fr=new j({props:{name:"get_webhook",anchor:"huggingface_hub.HfApi.get_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to get.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.get_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8798",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WebhookInfo</code></p>
`}}),ma=new U({props:{anchor:"huggingface_hub.HfApi.get_webhook.example",$$slots:{default:[uq]},$$scope:{ctx:T}}}),Sr=new j({props:{name:"grant_access",anchor:"huggingface_hub.HfApi.grant_access",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.grant_access.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to grant access to.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.grant_access.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user to grant access.`,name:"user"},{anchor:"huggingface_hub.HfApi.grant_access.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to grant access to. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.grant_access.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8743",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the user already has access to the repo.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Gr=new j({props:{name:"hf_hub_download",anchor:"huggingface_hub.HfApi.hf_hub_download",parameters:[{name:"repo_id",val:": str"},{name:"filename",val:": str"},{name:"subfolder",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"cache_dir",val:": Union[str, Path, None] = None"},{name:"local_dir",val:": Union[str, Path, None] = None"},{name:"force_download",val:": bool = False"},{name:"proxies",val:": Optional[Dict] = None"},{name:"etag_timeout",val:": float = 10"},{name:"token",val:": Union[bool, str, None] = None"},{name:"local_files_only",val:": bool = False"},{name:"resume_download",val:": Optional[bool] = None"},{name:"force_filename",val:": Optional[str] = None"},{name:"local_dir_use_symlinks",val:": Union[bool, Literal['auto']] = 'auto'"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.hf_hub_download.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.hf_hub_download.filename",description:`<strong>filename</strong> (<code>str</code>) &#x2014;
The name of the file in the repo.`,name:"filename"},{anchor:"huggingface_hub.HfApi.hf_hub_download.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional value corresponding to a folder inside the repository.`,name:"subfolder"},{anchor:"huggingface_hub.HfApi.hf_hub_download.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if downloading from a dataset or space,
<code>None</code> or <code>&quot;model&quot;</code> if downloading from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.hf_hub_download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional Git revision id which can be a branch name, a tag, or a
commit hash.`,name:"revision"},{anchor:"huggingface_hub.HfApi.hf_hub_download.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <code>Path</code>, <em>optional</em>) &#x2014;
Path to the folder where cached files are stored.`,name:"cache_dir"},{anchor:"huggingface_hub.HfApi.hf_hub_download.local_dir",description:`<strong>local_dir</strong> (<code>str</code> or <code>Path</code>, <em>optional</em>) &#x2014;
If provided, the downloaded file will be placed under this directory.`,name:"local_dir"},{anchor:"huggingface_hub.HfApi.hf_hub_download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the file should be downloaded even if it already exists in
the local cache.`,name:"force_download"},{anchor:"huggingface_hub.HfApi.hf_hub_download.proxies",description:`<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary mapping protocol to the URL of the proxy passed to
<code>requests.request</code>.`,name:"proxies"},{anchor:"huggingface_hub.HfApi.hf_hub_download.etag_timeout",description:`<strong>etag_timeout</strong> (<code>float</code>, <em>optional</em>, defaults to <code>10</code>) &#x2014;
When fetching ETag, how many seconds to wait for the server to send
data before giving up which is passed to <code>requests.request</code>.`,name:"etag_timeout"},{anchor:"huggingface_hub.HfApi.hf_hub_download.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.hf_hub_download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, avoid downloading the file and return the path to the
local cached file if it exists.`,name:"local_files_only"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5139",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Local path of file or if networking is off, last version of file cached on disk.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If the revision to download from cannot be found.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a> —
If the file to download cannot be found.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.LocalEntryNotFoundError"
>LocalEntryNotFoundError</a> —
If network is disabled or unavailable and file is not found in cache.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a> —
If <code>token=True</code> but the token cannot be found.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#OSError"
  rel="nofollow"
><code>OSError</code></a> —
If ETag cannot be determined.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If some parameter value is invalid.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.LocalEntryNotFoundError"
>LocalEntryNotFoundError</a> or <code>EnvironmentError</code> or <code>OSError</code> or <code>ValueError</code></p>
`}}),_a=new U({props:{anchor:"huggingface_hub.HfApi.hf_hub_download.example",$$slots:{default:[hq]},$$scope:{ctx:T}}}),Lr=new j({props:{name:"hide_discussion_comment",anchor:"huggingface_hub.HfApi.hide_discussion_comment",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"comment_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.hide_discussion_comment.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.comment_id",description:`<strong>comment_id</strong> (<code>str</code>) &#x2014;
The ID of the comment to edit.`,name:"comment_id"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6649",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the hidden comment</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionComment"
>DiscussionComment</a></p>
`}}),ba=new I({props:{warning:!0,$$slots:{default:[fq]},$$scope:{ctx:T}}}),va=new I({props:{$$slots:{default:[mq]},$$scope:{ctx:T}}}),Zr=new j({props:{name:"list_accepted_access_requests",anchor:"huggingface_hub.HfApi.list_accepted_access_requests",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to get access requests for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to get access requests for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8427",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <code>AccessRequest</code> objects. Each time contains a <code>username</code>, <code>email</code>,
<code>status</code> and <code>timestamp</code> attribute. If the gated repo has a custom form, the <code>fields</code> attribute will
be populated with user’s answers.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AccessRequest]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),ya=new U({props:{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.example",$$slots:{default:[_q]},$$scope:{ctx:T}}}),Vr=new j({props:{name:"list_collections",anchor:"huggingface_hub.HfApi.list_collections",parameters:[{name:"owner",val:": Union[List[str], str, None] = None"},{name:"item",val:": Union[List[str], str, None] = None"},{name:"sort",val:": Optional[Literal['lastModified', 'trending', 'upvotes']] = None"},{name:"limit",val:": Optional[int] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_collections.owner",description:`<strong>owner</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
Filter by owner&#x2019;s username.`,name:"owner"},{anchor:"huggingface_hub.HfApi.list_collections.item",description:`<strong>item</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
Filter collections containing a particular items. Example: <code>&quot;models/teknium/OpenHermes-2.5-Mistral-7B&quot;</code>, <code>&quot;datasets/squad&quot;</code> or <code>&quot;papers/2311.12983&quot;</code>.`,name:"item"},{anchor:"huggingface_hub.HfApi.list_collections.sort",description:`<strong>sort</strong> (<code>Literal[&quot;lastModified&quot;, &quot;trending&quot;, &quot;upvotes&quot;]</code>, <em>optional</em>) &#x2014;
Sort collections by last modified, trending or upvotes.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_collections.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of collections to be returned.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_collections.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7897",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.Collection"
>Collection</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[Collection]</code></p>
`}}),xa=new I({props:{warning:!0,$$slots:{default:[bq]},$$scope:{ctx:T}}}),Pr=new j({props:{name:"list_datasets",anchor:"huggingface_hub.HfApi.list_datasets",parameters:[{name:"filter",val:": Union[str, Iterable[str], None] = None"},{name:"author",val:": Optional[str] = None"},{name:"benchmark",val:": Optional[Union[str, List[str]]] = None"},{name:"dataset_name",val:": Optional[str] = None"},{name:"gated",val:": Optional[bool] = None"},{name:"language_creators",val:": Optional[Union[str, List[str]]] = None"},{name:"language",val:": Optional[Union[str, List[str]]] = None"},{name:"multilinguality",val:": Optional[Union[str, List[str]]] = None"},{name:"size_categories",val:": Optional[Union[str, List[str]]] = None"},{name:"tags",val:": Optional[Union[str, List[str]]] = None"},{name:"task_categories",val:": Optional[Union[str, List[str]]] = None"},{name:"task_ids",val:": Optional[Union[str, List[str]]] = None"},{name:"search",val:": Optional[str] = None"},{name:"sort",val:": Optional[Union[Literal['last_modified'], str]] = None"},{name:"direction",val:": Optional[Literal[-1]] = None"},{name:"limit",val:": Optional[int] = None"},{name:"expand",val:": Optional[List[ExpandDatasetProperty_T]] = None"},{name:"full",val:": Optional[bool] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_datasets.filter",description:`<strong>filter</strong> (<code>str</code> or <code>Iterable[str]</code>, <em>optional</em>) &#x2014;
A string or list of string to filter datasets on the hub.`,name:"filter"},{anchor:"huggingface_hub.HfApi.list_datasets.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string which identify the author of the returned datasets.`,name:"author"},{anchor:"huggingface_hub.HfApi.list_datasets.benchmark",description:`<strong>benchmark</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by their official benchmark.`,name:"benchmark"},{anchor:"huggingface_hub.HfApi.list_datasets.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by its name, such as <code>SQAC</code> or <code>wikineural</code>`,name:"dataset_name"},{anchor:"huggingface_hub.HfApi.list_datasets.gated",description:`<strong>gated</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
A boolean to filter datasets on the Hub that are gated or not. By default, all datasets are returned.
If <code>gated=True</code> is passed, only gated datasets are returned.
If <code>gated=False</code> is passed, only non-gated datasets are returned.`,name:"gated"},{anchor:"huggingface_hub.HfApi.list_datasets.language_creators",description:`<strong>language_creators</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub with how the data was curated, such as <code>crowdsourced</code> or
<code>machine_generated</code>.`,name:"language_creators"},{anchor:"huggingface_hub.HfApi.list_datasets.language",description:`<strong>language</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings representing a two-character language to
filter datasets by on the Hub.`,name:"language"},{anchor:"huggingface_hub.HfApi.list_datasets.multilinguality",description:`<strong>multilinguality</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings representing a filter for datasets that
contain multiple languages.`,name:"multilinguality"},{anchor:"huggingface_hub.HfApi.list_datasets.size_categories",description:`<strong>size_categories</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by the size of the dataset such as <code>100K&lt;n&lt;1M</code> or
<code>1M&lt;n&lt;10M</code>.`,name:"size_categories"},{anchor:"huggingface_hub.HfApi.list_datasets.tags",description:`<strong>tags</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string tag or a list of tags to filter datasets on the Hub.`,name:"tags"},{anchor:"huggingface_hub.HfApi.list_datasets.task_categories",description:`<strong>task_categories</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by the designed task, such as <code>audio_classification</code> or
<code>named_entity_recognition</code>.`,name:"task_categories"},{anchor:"huggingface_hub.HfApi.list_datasets.task_ids",description:`<strong>task_ids</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by the specific task such as <code>speech_emotion_recognition</code> or
<code>paraphrase</code>.`,name:"task_ids"},{anchor:"huggingface_hub.HfApi.list_datasets.search",description:`<strong>search</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that will be contained in the returned datasets.`,name:"search"},{anchor:"huggingface_hub.HfApi.list_datasets.sort",description:`<strong>sort</strong> (<code>Literal[&quot;last_modified&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The key with which to sort the resulting models. Possible values are &#x201C;last_modified&#x201D;, &#x201C;trending_score&#x201D;,
&#x201C;created_at&#x201D;, &#x201C;downloads&#x201D; and &#x201C;likes&#x201D;.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_datasets.direction",description:`<strong>direction</strong> (<code>Literal[-1]</code> or <code>int</code>, <em>optional</em>) &#x2014;
Direction in which to sort. The value <code>-1</code> sorts by descending
order while all other values sort by ascending order.`,name:"direction"},{anchor:"huggingface_hub.HfApi.list_datasets.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The limit on the number of datasets fetched. Leaving this option
to <code>None</code> fetches all datasets.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_datasets.expand",description:`<strong>expand</strong> (<code>List[ExpandDatasetProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;citation&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;description&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;paperswithcode_id&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_datasets.full",description:`<strong>full</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch all dataset data, including the <code>last_modified</code>,
the <code>card_data</code> and  the files. Can contain useful information such as the
PapersWithCode ID.`,name:"full"},{anchor:"huggingface_hub.HfApi.list_datasets.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1966",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.DatasetInfo"
>huggingface_hub.hf_api.DatasetInfo</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[DatasetInfo]</code></p>
`}}),$a=new U({props:{anchor:"huggingface_hub.HfApi.list_datasets.example",$$slots:{default:[vq]},$$scope:{ctx:T}}}),wa=new U({props:{anchor:"huggingface_hub.HfApi.list_datasets.example-2",$$slots:{default:[yq]},$$scope:{ctx:T}}}),Wr=new j({props:{name:"list_inference_catalog",anchor:"huggingface_hub.HfApi.list_inference_catalog",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_inference_catalog.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7551",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of model IDs available in the catalog.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List<code>str</code></p>
`}}),ka=new I({props:{warning:!0,$$slots:{default:[xq]},$$scope:{ctx:T}}}),Br=new j({props:{name:"list_inference_endpoints",anchor:"huggingface_hub.HfApi.list_inference_endpoints",parameters:[{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_inference_endpoints.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace to list endpoints for. Defaults to the current user. Set to <code>&quot;*&quot;</code> to list all endpoints
from all namespaces (i.e. personal namespace and all orgs the user belongs to).`,name:"namespace"},{anchor:"huggingface_hub.HfApi.list_inference_endpoints.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7272",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of all inference endpoints for the given namespace.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List<a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Ta=new U({props:{anchor:"huggingface_hub.HfApi.list_inference_endpoints.example",$$slots:{default:[$q]},$$scope:{ctx:T}}}),Yr=new j({props:{name:"list_liked_repos",anchor:"huggingface_hub.HfApi.list_liked_repos",parameters:[{name:"user",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_liked_repos.user",description:`<strong>user</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the user for which you want to fetch the likes.`,name:"user"},{anchor:"huggingface_hub.HfApi.list_liked_repos.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2338",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>object containing the user name and 3 lists of repo ids (1 for
models, 1 for datasets and 1 for Spaces).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.UserLikes"
>UserLikes</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>user</code> is not passed and no token found (either from argument or from machine).</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),qa=new U({props:{anchor:"huggingface_hub.HfApi.list_liked_repos.example",$$slots:{default:[wq]},$$scope:{ctx:T}}}),Xr=new j({props:{name:"list_models",anchor:"huggingface_hub.HfApi.list_models",parameters:[{name:"filter",val:": Union[str, Iterable[str], None] = None"},{name:"author",val:": Optional[str] = None"},{name:"gated",val:": Optional[bool] = None"},{name:"inference",val:": Optional[Literal['cold', 'frozen', 'warm']] = None"},{name:"library",val:": Optional[Union[str, List[str]]] = None"},{name:"language",val:": Optional[Union[str, List[str]]] = None"},{name:"model_name",val:": Optional[str] = None"},{name:"task",val:": Optional[Union[str, List[str]]] = None"},{name:"trained_dataset",val:": Optional[Union[str, List[str]]] = None"},{name:"tags",val:": Optional[Union[str, List[str]]] = None"},{name:"search",val:": Optional[str] = None"},{name:"pipeline_tag",val:": Optional[str] = None"},{name:"emissions_thresholds",val:": Optional[Tuple[float, float]] = None"},{name:"sort",val:": Union[Literal['last_modified'], str, None] = None"},{name:"direction",val:": Optional[Literal[-1]] = None"},{name:"limit",val:": Optional[int] = None"},{name:"expand",val:": Optional[List[ExpandModelProperty_T]] = None"},{name:"full",val:": Optional[bool] = None"},{name:"cardData",val:": bool = False"},{name:"fetch_config",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_models.filter",description:`<strong>filter</strong> (<code>str</code> or <code>Iterable[str]</code>, <em>optional</em>) &#x2014;
A string or list of string to filter models on the Hub.`,name:"filter"},{anchor:"huggingface_hub.HfApi.list_models.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string which identify the author (user or organization) of the
returned models.`,name:"author"},{anchor:"huggingface_hub.HfApi.list_models.gated",description:`<strong>gated</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
A boolean to filter models on the Hub that are gated or not. By default, all models are returned.
If <code>gated=True</code> is passed, only gated models are returned.
If <code>gated=False</code> is passed, only non-gated models are returned.`,name:"gated"},{anchor:"huggingface_hub.HfApi.list_models.inference",description:`<strong>inference</strong> (<code>Literal[&quot;cold&quot;, &quot;frozen&quot;, &quot;warm&quot;]</code>, <em>optional</em>) &#x2014;
A string to filter models on the Hub by their state on the Inference API.
Warm models are available for immediate use. Cold models will be loaded on first inference call.
Frozen models are not available in Inference API.`,name:"inference"},{anchor:"huggingface_hub.HfApi.list_models.library",description:`<strong>library</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings of foundational libraries models were
originally trained from, such as pytorch, tensorflow, or allennlp.`,name:"library"},{anchor:"huggingface_hub.HfApi.list_models.language",description:`<strong>language</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings of languages, both by name and country
code, such as &#x201C;en&#x201D; or &#x201C;English&#x201D;`,name:"language"},{anchor:"huggingface_hub.HfApi.list_models.model_name",description:`<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that contain complete or partial names for models on the
Hub, such as &#x201C;bert&#x201D; or &#x201C;bert-base-cased&#x201D;`,name:"model_name"},{anchor:"huggingface_hub.HfApi.list_models.task",description:`<strong>task</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings of tasks models were designed for, such
as: &#x201C;fill-mask&#x201D; or &#x201C;automatic-speech-recognition&#x201D;`,name:"task"},{anchor:"huggingface_hub.HfApi.list_models.trained_dataset",description:`<strong>trained_dataset</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string tag or a list of string tags of the trained dataset for a
model on the Hub.`,name:"trained_dataset"},{anchor:"huggingface_hub.HfApi.list_models.tags",description:`<strong>tags</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string tag or a list of tags to filter models on the Hub by, such
as <code>text-generation</code> or <code>spacy</code>.`,name:"tags"},{anchor:"huggingface_hub.HfApi.list_models.search",description:`<strong>search</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that will be contained in the returned model ids.`,name:"search"},{anchor:"huggingface_hub.HfApi.list_models.pipeline_tag",description:`<strong>pipeline_tag</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string pipeline tag to filter models on the Hub by, such as <code>summarization</code>.`,name:"pipeline_tag"},{anchor:"huggingface_hub.HfApi.list_models.emissions_thresholds",description:`<strong>emissions_thresholds</strong> (<code>Tuple</code>, <em>optional</em>) &#x2014;
A tuple of two ints or floats representing a minimum and maximum
carbon footprint to filter the resulting models with in grams.`,name:"emissions_thresholds"},{anchor:"huggingface_hub.HfApi.list_models.sort",description:`<strong>sort</strong> (<code>Literal[&quot;last_modified&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The key with which to sort the resulting models. Possible values are &#x201C;last_modified&#x201D;, &#x201C;trending_score&#x201D;,
&#x201C;created_at&#x201D;, &#x201C;downloads&#x201D; and &#x201C;likes&#x201D;.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_models.direction",description:`<strong>direction</strong> (<code>Literal[-1]</code> or <code>int</code>, <em>optional</em>) &#x2014;
Direction in which to sort. The value <code>-1</code> sorts by descending
order while all other values sort by ascending order.`,name:"direction"},{anchor:"huggingface_hub.HfApi.list_models.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The limit on the number of models fetched. Leaving this option
to <code>None</code> fetches all models.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_models.expand",description:`<strong>expand</strong> (<code>List[ExpandModelProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code>, <code>cardData</code> or <code>fetch_config</code> are passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;baseModels&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;childrenModelCount&quot;</code>, <code>&quot;config&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;gguf&quot;</code>, <code>&quot;inference&quot;</code>, <code>&quot;inferenceProviderMapping&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;library_name&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;mask_token&quot;</code>, <code>&quot;model-index&quot;</code>, <code>&quot;pipeline_tag&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;safetensors&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;spaces&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;transformersInfo&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;widgetData&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_models.full",description:`<strong>full</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch all model data, including the <code>last_modified</code>,
the <code>sha</code>, the files and the <code>tags</code>. This is set to <code>True</code> by
default when using a filter.`,name:"full"},{anchor:"huggingface_hub.HfApi.list_models.cardData",description:`<strong>cardData</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to grab the metadata for the model as well. Can contain
useful information such as carbon emissions, metrics, and
datasets trained on.`,name:"cardData"},{anchor:"huggingface_hub.HfApi.list_models.fetch_config",description:`<strong>fetch_config</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch the model configs as well. This is not included
in <code>full</code> due to its size.`,name:"fetch_config"},{anchor:"huggingface_hub.HfApi.list_models.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1746",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.ModelInfo"
>huggingface_hub.hf_api.ModelInfo</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[ModelInfo]</code></p>
`}}),Ma=new U({props:{anchor:"huggingface_hub.HfApi.list_models.example",$$slots:{default:[kq]},$$scope:{ctx:T}}}),ja=new U({props:{anchor:"huggingface_hub.HfApi.list_models.example-2",$$slots:{default:[Tq]},$$scope:{ctx:T}}}),zr=new j({props:{name:"list_organization_members",anchor:"huggingface_hub.HfApi.list_organization_members",parameters:[{name:"organization",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_organization_members.organization",description:`<strong>organization</strong> (<code>str</code>) &#x2014;
Name of the organization to get the members of.`,name:"organization"},{anchor:"huggingface_hub.HfApi.list_organization_members.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9378",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.User"
>User</a> objects with the members of the organization.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the organization does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Or=new j({props:{name:"list_papers",anchor:"huggingface_hub.HfApi.list_papers",parameters:[{name:"query",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_papers.query",description:`<strong>query</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A search query string to find papers.
If provided, returns papers that match the query.`,name:"query"},{anchor:"huggingface_hub.HfApi.list_papers.token",description:`<strong>token</strong> (Union[bool, str, None], <em>optional</em>) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9462",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <code>huggingface_hub.hf_api.PaperInfo</code> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[PaperInfo]</code></p>
`}}),Ca=new U({props:{anchor:"huggingface_hub.HfApi.list_papers.example",$$slots:{default:[qq]},$$scope:{ctx:T}}}),Qr=new j({props:{name:"list_pending_access_requests",anchor:"huggingface_hub.HfApi.list_pending_access_requests",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_pending_access_requests.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to get access requests for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_pending_access_requests.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to get access requests for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_pending_access_requests.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8363",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <code>AccessRequest</code> objects. Each time contains a <code>username</code>, <code>email</code>,
<code>status</code> and <code>timestamp</code> attribute. If the gated repo has a custom form, the <code>fields</code> attribute will
be populated with user’s answers.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AccessRequest]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Ua=new U({props:{anchor:"huggingface_hub.HfApi.list_pending_access_requests.example",$$slots:{default:[Mq]},$$scope:{ctx:T}}}),Kr=new j({props:{name:"list_rejected_access_requests",anchor:"huggingface_hub.HfApi.list_rejected_access_requests",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to get access requests for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to get access requests for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8489",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <code>AccessRequest</code> objects. Each time contains a <code>username</code>, <code>email</code>,
<code>status</code> and <code>timestamp</code> attribute. If the gated repo has a custom form, the <code>fields</code> attribute will
be populated with user’s answers.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AccessRequest]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Ia=new U({props:{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.example",$$slots:{default:[jq]},$$scope:{ctx:T}}}),ei=new j({props:{name:"list_repo_commits",anchor:"huggingface_hub.HfApi.list_repo_commits",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"revision",val:": Optional[str] = None"},{name:"formatted",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_commits.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_commits.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing commits from a dataset or a Space, <code>None</code> or <code>&quot;model&quot;</code> if
listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_commits.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.list_repo_commits.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.list_repo_commits.formatted",description:`<strong>formatted</strong> (<code>bool</code>) &#x2014;
Whether to return the HTML-formatted title and description of the commits. Defaults to False.`,name:"formatted"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3141",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of objects containing information about the commits for a repo on the Hub.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List[<a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.GitCommitInfo"
>GitCommitInfo</a>]</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a></p>
`}}),Aa=new U({props:{anchor:"huggingface_hub.HfApi.list_repo_commits.example",$$slots:{default:[Hq]},$$scope:{ctx:T}}}),ti=new j({props:{name:"list_repo_files",anchor:"huggingface_hub.HfApi.list_repo_files",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_files.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.list_repo_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to
a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2900",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the list of files in a given repository.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),ni=new j({props:{name:"list_repo_likers",anchor:"huggingface_hub.HfApi.list_repo_likers",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_likers.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to retrieve . Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_likers.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.list_repo_likers.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2414",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.User"
>huggingface_hub.hf_api.User</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`}}),oi=new j({props:{name:"list_repo_refs",anchor:"huggingface_hub.HfApi.list_repo_refs",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"include_pull_requests",val:": bool = False"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_refs.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_refs.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing refs from a dataset or a Space,
<code>None</code> or <code>&quot;model&quot;</code> if listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_refs.include_pull_requests",description:`<strong>include_pull_requests</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to include refs from pull requests in the list. Defaults to <code>False</code>.`,name:"include_pull_requests"},{anchor:"huggingface_hub.HfApi.list_repo_refs.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3069",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>object containing all information about branches and tags for a
repo on the Hub.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.GitRefs"
>GitRefs</a></p>
`}}),Ja=new U({props:{anchor:"huggingface_hub.HfApi.list_repo_refs.example",$$slots:{default:[Cq]},$$scope:{ctx:T}}}),ai=new j({props:{name:"list_repo_tree",anchor:"huggingface_hub.HfApi.list_repo_tree",parameters:[{name:"repo_id",val:": str"},{name:"path_in_repo",val:": Optional[str] = None"},{name:"recursive",val:": bool = False"},{name:"expand",val:": bool = False"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_tree.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_tree.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Relative path of the tree (folder) in the repo, for example:
<code>&quot;checkpoints/1fec34a/results&quot;</code>. Will default to the root tree (folder) of the repository.`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.list_repo_tree.recursive",description:`<strong>recursive</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to list tree&#x2019;s files and folders recursively.`,name:"recursive"},{anchor:"huggingface_hub.HfApi.list_repo_tree.expand",description:`<strong>expand</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to fetch more information about the tree&#x2019;s files and folders (e.g. last commit and files&#x2019; security scan results). This
operation is more expensive for the server so only 50 results are returned per page (instead of 1000).
As pagination is implemented in <code>huggingface_hub</code>, this is transparent for you except for the time it
takes to get the results.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_repo_tree.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the tree. Defaults to <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.list_repo_tree.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository from which to get the tree (<code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>.
Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_tree.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2937",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The information about the tree’s files and folders, as an iterable of <code>RepoFile</code> and <code>RepoFolder</code> objects. The order of the files and folders is
not guaranteed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[Union[RepoFile, RepoFolder]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a> —
If the tree (folder) does not exist (error 404) on the repo.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a></p>
`}}),Ea=new U({props:{anchor:"huggingface_hub.HfApi.list_repo_tree.example",$$slots:{default:[Uq]},$$scope:{ctx:T}}}),Da=new U({props:{anchor:"huggingface_hub.HfApi.list_repo_tree.example-2",$$slots:{default:[Iq]},$$scope:{ctx:T}}}),si=new j({props:{name:"list_spaces",anchor:"huggingface_hub.HfApi.list_spaces",parameters:[{name:"filter",val:": Union[str, Iterable[str], None] = None"},{name:"author",val:": Optional[str] = None"},{name:"search",val:": Optional[str] = None"},{name:"datasets",val:": Union[str, Iterable[str], None] = None"},{name:"models",val:": Union[str, Iterable[str], None] = None"},{name:"linked",val:": bool = False"},{name:"sort",val:": Union[Literal['last_modified'], str, None] = None"},{name:"direction",val:": Optional[Literal[-1]] = None"},{name:"limit",val:": Optional[int] = None"},{name:"expand",val:": Optional[List[ExpandSpaceProperty_T]] = None"},{name:"full",val:": Optional[bool] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_spaces.filter",description:`<strong>filter</strong> (<code>str</code> or <code>Iterable</code>, <em>optional</em>) &#x2014;
A string tag or list of tags that can be used to identify Spaces on the Hub.`,name:"filter"},{anchor:"huggingface_hub.HfApi.list_spaces.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string which identify the author of the returned Spaces.`,name:"author"},{anchor:"huggingface_hub.HfApi.list_spaces.search",description:`<strong>search</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that will be contained in the returned Spaces.`,name:"search"},{anchor:"huggingface_hub.HfApi.list_spaces.datasets",description:`<strong>datasets</strong> (<code>str</code> or <code>Iterable</code>, <em>optional</em>) &#x2014;
Whether to return Spaces that make use of a dataset.
The name of a specific dataset can be passed as a string.`,name:"datasets"},{anchor:"huggingface_hub.HfApi.list_spaces.models",description:`<strong>models</strong> (<code>str</code> or <code>Iterable</code>, <em>optional</em>) &#x2014;
Whether to return Spaces that make use of a model.
The name of a specific model can be passed as a string.`,name:"models"},{anchor:"huggingface_hub.HfApi.list_spaces.linked",description:`<strong>linked</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return Spaces that make use of either a model or a dataset.`,name:"linked"},{anchor:"huggingface_hub.HfApi.list_spaces.sort",description:`<strong>sort</strong> (<code>Literal[&quot;last_modified&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The key with which to sort the resulting models. Possible values are &#x201C;last_modified&#x201D;, &#x201C;trending_score&#x201D;,
&#x201C;created_at&#x201D; and &#x201C;likes&#x201D;.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_spaces.direction",description:`<strong>direction</strong> (<code>Literal[-1]</code> or <code>int</code>, <em>optional</em>) &#x2014;
Direction in which to sort. The value <code>-1</code> sorts by descending
order while all other values sort by ascending order.`,name:"direction"},{anchor:"huggingface_hub.HfApi.list_spaces.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The limit on the number of Spaces fetched. Leaving this option
to <code>None</code> fetches all Spaces.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_spaces.expand",description:`<strong>expand</strong> (<code>List[ExpandSpaceProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;datasets&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;models&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;runtime&quot;</code>, <code>&quot;sdk&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;subdomain&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_spaces.full",description:`<strong>full</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch all Spaces data, including the <code>last_modified</code>, <code>siblings</code>
and <code>card_data</code> fields.`,name:"full"},{anchor:"huggingface_hub.HfApi.list_spaces.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2177",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.SpaceInfo"
>huggingface_hub.hf_api.SpaceInfo</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[SpaceInfo]</code></p>
`}}),ri=new j({props:{name:"list_user_followers",anchor:"huggingface_hub.HfApi.list_user_followers",parameters:[{name:"username",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_user_followers.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user to get the followers of.`,name:"username"},{anchor:"huggingface_hub.HfApi.list_user_followers.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9406",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.User"
>User</a> objects with the followers of the user.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),ii=new j({props:{name:"list_user_following",anchor:"huggingface_hub.HfApi.list_user_following",parameters:[{name:"username",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_user_following.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user to get the users followed by.`,name:"username"},{anchor:"huggingface_hub.HfApi.list_user_following.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9434",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.User"
>User</a> objects with the users followed by the user.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),ci=new j({props:{name:"list_webhooks",anchor:"huggingface_hub.HfApi.list_webhooks",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_webhooks.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8849",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of webhook info objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[WebhookInfo]</code></p>
`}}),Ga=new U({props:{anchor:"huggingface_hub.HfApi.list_webhooks.example",$$slots:{default:[Aq]},$$scope:{ctx:T}}}),li=new j({props:{name:"merge_pull_request",anchor:"huggingface_hub.HfApi.merge_pull_request",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"token",val:": Union[bool, str, None] = None"},{name:"comment",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.merge_pull_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.merge_pull_request.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.merge_pull_request.comment",description:`<strong>comment</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional comment to post with the status change.`,name:"comment"},{anchor:"huggingface_hub.HfApi.merge_pull_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.merge_pull_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6533",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the status change event</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionStatusChange"
>DiscussionStatusChange</a></p>
`}}),La=new I({props:{$$slots:{default:[Nq]},$$scope:{ctx:T}}}),pi=new j({props:{name:"model_info",anchor:"huggingface_hub.HfApi.model_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"securityStatus",val:": Optional[bool] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[List[ExpandModelProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.model_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.model_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the model repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.model_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.model_info.securityStatus",description:`<strong>securityStatus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to retrieve the security status from the model
repository as well. The security status will be returned in the <code>security_repo_status</code> field.`,name:"securityStatus"},{anchor:"huggingface_hub.HfApi.model_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.model_info.expand",description:`<strong>expand</strong> (<code>List[ExpandModelProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>securityStatus</code> or <code>files_metadata</code> are passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;baseModels&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;childrenModelCount&quot;</code>, <code>&quot;config&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;gguf&quot;</code>, <code>&quot;inference&quot;</code>, <code>&quot;inferenceProviderMapping&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;library_name&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;mask_token&quot;</code>, <code>&quot;model-index&quot;</code>, <code>&quot;pipeline_tag&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;safetensors&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;spaces&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;transformersInfo&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;widgetData&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.model_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2453",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The model repository information.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.ModelInfo"
>huggingface_hub.hf_api.ModelInfo</a></p>
`}}),Za=new I({props:{$$slots:{default:[Jq]},$$scope:{ctx:T}}}),di=new j({props:{name:"move_repo",anchor:"huggingface_hub.HfApi.move_repo",parameters:[{name:"from_id",val:": str"},{name:"to_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.move_repo.from_id",description:`<strong>from_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>. Original repository identifier.`,name:"from_id"},{anchor:"huggingface_hub.HfApi.move_repo.to_id",description:`<strong>to_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>. Final repository identifier.`,name:"to_id"},{anchor:"huggingface_hub.HfApi.move_repo.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.move_repo.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3721"}}),Va=new I({props:{$$slots:{default:[Eq]},$$scope:{ctx:T}}}),gi=new j({props:{name:"paper_info",anchor:"huggingface_hub.HfApi.paper_info",parameters:[{name:"id",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.paper_info.id",description:`<strong>id</strong> (<code>str</code>, <strong>optional</strong>) &#x2014;
ArXiv id of the paper.`,name:"id"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9508",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>PaperInfo</code> object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PaperInfo</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the paper does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),ui=new j({props:{name:"parse_safetensors_file_metadata",anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata",parameters:[{name:"repo_id",val:": str"},{name:"filename",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.filename",description:`<strong>filename</strong> (<code>str</code>) &#x2014;
The name of the file in the repo.`,name:"filename"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the file is in a dataset or space, <code>None</code> or <code>&quot;model&quot;</code> if in a
model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to fetch the file from. Can be a branch name, a tag, or a commit hash. Defaults to the
head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5544",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information related to a safetensors file.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>SafetensorsFileMetadata</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>NotASafetensorsRepoError</code> —
If the repo is not a safetensors repo i.e. doesn’t have either a
<code>model.safetensors</code> or a <code>model.safetensors.index.json</code> file.</li>
<li><code>SafetensorsParsingError</code> —
If a safetensors file header couldn’t be parsed correctly.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>NotASafetensorsRepoError</code> or <code>SafetensorsParsingError</code></p>
`}}),hi=new j({props:{name:"pause_inference_endpoint",anchor:"huggingface_hub.HfApi.pause_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.pause_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to pause.`,name:"name"},{anchor:"huggingface_hub.HfApi.pause_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.pause_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7767",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the paused Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),fi=new j({props:{name:"pause_space",anchor:"huggingface_hub.HfApi.pause_space",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.pause_space.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to pause. Example: <code>&quot;Salesforce/BLIP2&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.pause_space.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6995",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about your Space including <code>stage=PAUSED</code> and requested hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If your Space is not found (error 404). Most probably wrong repo_id or your space is private but you
are not authenticated.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
403 Forbidden: only the owner of a Space can pause it. If you want to manage a Space that you don’t
own, either ask the owner by opening a Discussion or duplicate the Space.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If your Space is a static Space. Static Spaces are always running and never billed. If you want to hide
a static Space, you can set it to private.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a></p>
`}}),mi=new j({props:{name:"preupload_lfs_files",anchor:"huggingface_hub.HfApi.preupload_lfs_files",parameters:[{name:"repo_id",val:": str"},{name:"additions",val:": Iterable[CommitOperationAdd]"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"num_threads",val:": int = 5"},{name:"free_memory",val:": bool = True"},{name:"gitignore_content",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.preupload_lfs_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which you will commit the files, for example: <code>&quot;username/custom_transformers&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.operations",description:`<strong>operations</strong> (<code>Iterable</code> of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitOperationAdd">CommitOperationAdd</a>) &#x2014;
The list of files to upload. Warning: the objects in this list will be mutated to include information
relative to the upload. Do not reuse the same objects for multiple commits.`,name:"operations"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of repository to upload to (e.g. <code>&quot;model&quot;</code> -default-, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>).`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not you plan to create a Pull Request with that commit. Defaults to <code>False</code>.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.num_threads",description:`<strong>num_threads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of concurrent threads for uploading files. Defaults to 5.
Setting it to 2 means at most 2 files will be uploaded concurrently.`,name:"num_threads"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.gitignore_content",description:`<strong>gitignore_content</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The content of the <code>.gitignore</code> file to know which files should be ignored. The order of priority
is to first check if <code>gitignore_content</code> is passed, then check if the <code>.gitignore</code> file is present
in the list of files to commit and finally default to the <code>.gitignore</code> file already hosted on the Hub
(if any).`,name:"gitignore_content"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4116"}}),Wa=new I({props:{warning:!0,$$slots:{default:[Dq]},$$scope:{ctx:T}}}),Ba=new I({props:{warning:!0,$$slots:{default:[Rq]},$$scope:{ctx:T}}}),Ya=new U({props:{anchor:"huggingface_hub.HfApi.preupload_lfs_files.example",$$slots:{default:[Fq]},$$scope:{ctx:T}}}),_i=new j({props:{name:"reject_access_request",anchor:"huggingface_hub.HfApi.reject_access_request",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"rejection_reason",val:": Optional[str]"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.reject_access_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to reject access request for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.reject_access_request.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user which access request should be rejected.`,name:"user"},{anchor:"huggingface_hub.HfApi.reject_access_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to reject access request for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.reject_access_request.rejection_reason",description:`<strong>rejection_reason</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Optional rejection reason that will be visible to the user (max 200 characters).`,name:"rejection_reason"},{anchor:"huggingface_hub.HfApi.reject_access_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8662",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request cannot be found.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request is already in the rejected list.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),bi=new j({props:{name:"rename_discussion",anchor:"huggingface_hub.HfApi.rename_discussion",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"new_title",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.rename_discussion.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.rename_discussion.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.rename_discussion.new_title",description:`<strong>new_title</strong> (<code>str</code>) &#x2014;
The new title for the discussion`,name:"new_title"},{anchor:"huggingface_hub.HfApi.rename_discussion.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.rename_discussion.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6385",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the title change event</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionTitleChange"
>DiscussionTitleChange</a></p>
`}}),Xa=new U({props:{anchor:"huggingface_hub.HfApi.rename_discussion.example",$$slots:{default:[Sq]},$$scope:{ctx:T}}}),za=new I({props:{$$slots:{default:[Gq]},$$scope:{ctx:T}}}),vi=new j({props:{name:"repo_exists",anchor:"huggingface_hub.HfApi.repo_exists",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.repo_exists.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.repo_exists.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.repo_exists.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2751",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if the repository exists, False otherwise.</p>
`}}),Oa=new U({props:{anchor:"huggingface_hub.HfApi.repo_exists.example",$$slots:{default:[Lq]},$$scope:{ctx:T}}}),yi=new j({props:{name:"repo_info",anchor:"huggingface_hub.HfApi.repo_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[Union[ExpandModelProperty_T, ExpandDatasetProperty_T, ExpandSpaceProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.repo_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.repo_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.repo_info.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.repo_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.repo_info.expand",description:`<strong>expand</strong> (<code>ExpandModelProperty_T</code> or <code>ExpandDatasetProperty_T</code> or <code>ExpandSpaceProperty_T</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>files_metadata</code> is passed.
For an exhaustive list of available properties, check out <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.model_info">model_info()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.dataset_info">dataset_info()</a> or <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.space_info">space_info()</a>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.repo_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.repo_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2677",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The repository information, as a
<a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.DatasetInfo"
>huggingface_hub.hf_api.DatasetInfo</a>, <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.ModelInfo"
>huggingface_hub.hf_api.ModelInfo</a>
or <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.SpaceInfo"
>huggingface_hub.hf_api.SpaceInfo</a> object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[SpaceInfo, DatasetInfo, ModelInfo]</code></p>
`}}),Qa=new I({props:{$$slots:{default:[Zq]},$$scope:{ctx:T}}}),xi=new j({props:{name:"request_space_hardware",anchor:"huggingface_hub.HfApi.request_space_hardware",parameters:[{name:"repo_id",val:": str"},{name:"hardware",val:": SpaceHardware"},{name:"token",val:": Union[bool, str, None] = None"},{name:"sleep_time",val:": Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.request_space_hardware.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.request_space_hardware.hardware",description:`<strong>hardware</strong> (<code>str</code> or <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a>) &#x2014;
Hardware on which to run the Space. Example: <code>&quot;t4-medium&quot;</code>.`,name:"hardware"},{anchor:"huggingface_hub.HfApi.request_space_hardware.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.request_space_hardware.sleep_time",description:`<strong>sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to sleep (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"sleep_time"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6891",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),Ka=new I({props:{$$slots:{default:[Vq]},$$scope:{ctx:T}}}),$i=new j({props:{name:"request_space_storage",anchor:"huggingface_hub.HfApi.request_space_storage",parameters:[{name:"repo_id",val:": str"},{name:"storage",val:": SpaceStorage"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.request_space_storage.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to update. Example: <code>&quot;open-llm-leaderboard/open_llm_leaderboard&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.request_space_storage.storage",description:`<strong>storage</strong> (<code>str</code> or <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceStorage">SpaceStorage</a>) &#x2014;
Storage tier. Either &#x2018;small&#x2019;, &#x2018;medium&#x2019;, or &#x2018;large&#x2019;.`,name:"storage"},{anchor:"huggingface_hub.HfApi.request_space_storage.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7198",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),es=new I({props:{$$slots:{default:[Pq]},$$scope:{ctx:T}}}),wi=new j({props:{name:"restart_space",anchor:"huggingface_hub.HfApi.restart_space",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"factory_reboot",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.restart_space.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to restart. Example: <code>&quot;Salesforce/BLIP2&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.restart_space.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.restart_space.factory_reboot",description:`<strong>factory_reboot</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, the Space will be rebuilt from scratch without caching any requirements.`,name:"factory_reboot"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7034",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about your Space.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If your Space is not found (error 404). Most probably wrong repo_id or your space is private but you
are not authenticated.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
403 Forbidden: only the owner of a Space can restart it. If you want to restart a Space that you don’t
own, either ask the owner by opening a Discussion or duplicate the Space.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If your Space is a static Space. Static Spaces are always running and never billed. If you want to hide
a static Space, you can set it to private.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a></p>
`}}),ki=new j({props:{name:"resume_inference_endpoint",anchor:"huggingface_hub.HfApi.resume_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"running_ok",val:": bool = True"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to resume.`,name:"name"},{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.running_ok",description:`<strong>running_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, the method will not raise an error if the Inference Endpoint is already running. Defaults to
<code>True</code>.`,name:"running_ok"},{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7802",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the resumed Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Ti=new j({props:{name:"revision_exists",anchor:"huggingface_hub.HfApi.revision_exists",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.revision_exists.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.revision_exists.revision",description:`<strong>revision</strong> (<code>str</code>) &#x2014;
The revision of the repository to check.`,name:"revision"},{anchor:"huggingface_hub.HfApi.revision_exists.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.revision_exists.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2795",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if the repository and the revision exists, False otherwise.</p>
`}}),ts=new U({props:{anchor:"huggingface_hub.HfApi.revision_exists.example",$$slots:{default:[Wq]},$$scope:{ctx:T}}}),qi=new j({props:{name:"run_as_future",anchor:"huggingface_hub.HfApi.run_as_future",parameters:[{name:"fn",val:": Callable[..., R]"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.HfApi.run_as_future.fn",description:`<strong>fn</strong> (<code>Callable</code>) &#x2014;
The method to run in the background.`,name:"fn"},{anchor:"huggingface_hub.HfApi.run_as_future.*args,",description:`<strong>*args,</strong> **kwargs &#x2014;
Arguments with which the method will be called.`,name:"*args,"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1613",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a <a
  href="https://docs.python.org/3/library/concurrent.futures.html#future-objects"
  rel="nofollow"
>Future</a> instance to
get the result of the task.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Future</code></p>
`}}),ns=new U({props:{anchor:"huggingface_hub.HfApi.run_as_future.example",$$slots:{default:[Bq]},$$scope:{ctx:T}}}),Mi=new j({props:{name:"scale_to_zero_inference_endpoint",anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to scale to zero.`,name:"name"},{anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7848",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the scaled-to-zero Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),ji=new j({props:{name:"set_space_sleep_time",anchor:"huggingface_hub.HfApi.set_space_sleep_time",parameters:[{name:"repo_id",val:": str"},{name:"sleep_time",val:": int"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.set_space_sleep_time.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.set_space_sleep_time.sleep_time",description:`<strong>sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to pause (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"sleep_time"},{anchor:"huggingface_hub.HfApi.set_space_sleep_time.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6944",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),os=new I({props:{$$slots:{default:[Yq]},$$scope:{ctx:T}}}),Hi=new j({props:{name:"snapshot_download",anchor:"huggingface_hub.HfApi.snapshot_download",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"cache_dir",val:": Union[str, Path, None] = None"},{name:"local_dir",val:": Union[str, Path, None] = None"},{name:"proxies",val:": Optional[Dict] = None"},{name:"etag_timeout",val:": float = 10"},{name:"force_download",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"},{name:"local_files_only",val:": bool = False"},{name:"allow_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"ignore_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"max_workers",val:": int = 8"},{name:"tqdm_class",val:": Optional[base_tqdm] = None"},{name:"local_dir_use_symlinks",val:": Union[bool, Literal['auto']] = 'auto'"},{name:"resume_download",val:": Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.snapshot_download.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.snapshot_download.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if downloading from a dataset or space,
<code>None</code> or <code>&quot;model&quot;</code> if downloading from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.snapshot_download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional Git revision id which can be a branch name, a tag, or a
commit hash.`,name:"revision"},{anchor:"huggingface_hub.HfApi.snapshot_download.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <code>Path</code>, <em>optional</em>) &#x2014;
Path to the folder where cached files are stored.`,name:"cache_dir"},{anchor:"huggingface_hub.HfApi.snapshot_download.local_dir",description:`<strong>local_dir</strong> (<code>str</code> or <code>Path</code>, <em>optional</em>) &#x2014;
If provided, the downloaded files will be placed under this directory.`,name:"local_dir"},{anchor:"huggingface_hub.HfApi.snapshot_download.proxies",description:`<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary mapping protocol to the URL of the proxy passed to
<code>requests.request</code>.`,name:"proxies"},{anchor:"huggingface_hub.HfApi.snapshot_download.etag_timeout",description:`<strong>etag_timeout</strong> (<code>float</code>, <em>optional</em>, defaults to <code>10</code>) &#x2014;
When fetching ETag, how many seconds to wait for the server to send
data before giving up which is passed to <code>requests.request</code>.`,name:"etag_timeout"},{anchor:"huggingface_hub.HfApi.snapshot_download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the file should be downloaded even if it already exists in the local cache.`,name:"force_download"},{anchor:"huggingface_hub.HfApi.snapshot_download.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.snapshot_download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, avoid downloading the file and return the path to the
local cached file if it exists.`,name:"local_files_only"},{anchor:"huggingface_hub.HfApi.snapshot_download.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are downloaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.HfApi.snapshot_download.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not downloaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.HfApi.snapshot_download.max_workers",description:`<strong>max_workers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of concurrent threads to download files (1 thread = 1 file download).
Defaults to 8.`,name:"max_workers"},{anchor:"huggingface_hub.HfApi.snapshot_download.tqdm_class",description:`<strong>tqdm_class</strong> (<code>tqdm</code>, <em>optional</em>) &#x2014;
If provided, overwrites the default behavior for the progress bar. Passed
argument must inherit from <code>tqdm.auto.tqdm</code> or at least mimic its behavior.
Note that the <code>tqdm_class</code> is not passed to each individual download.
Defaults to the custom HF progress bar that can be disabled by setting
<code>HF_HUB_DISABLE_PROGRESS_BARS</code> environment variable.`,name:"tqdm_class"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5279",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>folder path of the repo snapshot.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If the revision to download from cannot be found.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a> —
If <code>token=True</code> and the token cannot be found.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#OSError"
  rel="nofollow"
><code>OSError</code></a> — if
ETag cannot be determined.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
if some parameter value is invalid.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <code>EnvironmentError</code> or <code>OSError</code> or <code>ValueError</code></p>
`}}),Ci=new j({props:{name:"space_info",anchor:"huggingface_hub.HfApi.space_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[List[ExpandSpaceProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.space_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.space_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the space repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.space_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.space_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.space_info.expand",description:`<strong>expand</strong> (<code>List[ExpandSpaceProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;datasets&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;models&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;runtime&quot;</code>, <code>&quot;sdk&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;subdomain&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.space_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2604",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The space repository information.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.SpaceInfo"
>SpaceInfo</a></p>
`}}),as=new I({props:{$$slots:{default:[Xq]},$$scope:{ctx:T}}}),Ui=new j({props:{name:"super_squash_history",anchor:"huggingface_hub.HfApi.super_squash_history",parameters:[{name:"repo_id",val:": str"},{name:"branch",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.super_squash_history.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.super_squash_history.branch",description:`<strong>branch</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The branch to squash. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"branch"},{anchor:"huggingface_hub.HfApi.super_squash_history.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The commit message to use for the squashed commit.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.super_squash_history.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing commits from a dataset or a Space, <code>None</code> or <code>&quot;model&quot;</code> if
listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.super_squash_history.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3304",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If the branch to squash cannot be found.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If invalid reference for a branch. You cannot squash history on tags.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a></p>
`}}),ss=new I({props:{warning:!0,$$slots:{default:[zq]},$$scope:{ctx:T}}}),rs=new I({props:{warning:!0,$$slots:{default:[Oq]},$$scope:{ctx:T}}}),is=new U({props:{anchor:"huggingface_hub.HfApi.super_squash_history.example",$$slots:{default:[Qq]},$$scope:{ctx:T}}}),Ii=new j({props:{name:"unlike",anchor:"huggingface_hub.HfApi.unlike",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.unlike.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to unlike. Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.unlike.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.unlike.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if unliking a dataset or space, <code>None</code> or
<code>&quot;model&quot;</code> if unliking a model. Default is <code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2287",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),cs=new U({props:{anchor:"huggingface_hub.HfApi.unlike.example",$$slots:{default:[Kq]},$$scope:{ctx:T}}}),Ai=new j({props:{name:"update_collection_item",anchor:"huggingface_hub.HfApi.update_collection_item",parameters:[{name:"collection_slug",val:": str"},{name:"item_object_id",val:": str"},{name:"note",val:": Optional[str] = None"},{name:"position",val:": Optional[int] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_collection_item.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.update_collection_item.item_object_id",description:`<strong>item_object_id</strong> (<code>str</code>) &#x2014;
ID of the item in the collection. This is not the id of the item on the Hub (repo_id or paper id).
It must be retrieved from a <a href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.CollectionItem">CollectionItem</a> object. Example: <code>collection.items[0].item_object_id</code>.`,name:"item_object_id"},{anchor:"huggingface_hub.HfApi.update_collection_item.note",description:`<strong>note</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A note to attach to the item in the collection. The maximum size for a note is 500 characters.`,name:"note"},{anchor:"huggingface_hub.HfApi.update_collection_item.position",description:`<strong>position</strong> (<code>int</code>, <em>optional</em>) &#x2014;
New position of the item in the collection.`,name:"position"},{anchor:"huggingface_hub.HfApi.update_collection_item.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8254"}}),ls=new U({props:{anchor:"huggingface_hub.HfApi.update_collection_item.example",$$slots:{default:[eM]},$$scope:{ctx:T}}}),Ni=new j({props:{name:"update_collection_metadata",anchor:"huggingface_hub.HfApi.update_collection_metadata",parameters:[{name:"collection_slug",val:": str"},{name:"title",val:": Optional[str] = None"},{name:"description",val:": Optional[str] = None"},{name:"position",val:": Optional[int] = None"},{name:"private",val:": Optional[bool] = None"},{name:"theme",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_collection_metadata.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
Title of the collection to update.`,name:"title"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Description of the collection to update.`,name:"description"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.position",description:`<strong>position</strong> (<code>int</code>, <em>optional</em>) &#x2014;
New position of the collection in the list of collections of the user.`,name:"position"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the collection should be private or not.`,name:"private"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.theme",description:`<strong>theme</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Theme of the collection on the Hub.`,name:"theme"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8063"}}),ps=new U({props:{anchor:"huggingface_hub.HfApi.update_collection_metadata.example",$$slots:{default:[tM]},$$scope:{ctx:T}}}),Ji=new j({props:{name:"update_inference_endpoint",anchor:"huggingface_hub.HfApi.update_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"accelerator",val:": Optional[str] = None"},{name:"instance_size",val:": Optional[str] = None"},{name:"instance_type",val:": Optional[str] = None"},{name:"min_replica",val:": Optional[int] = None"},{name:"max_replica",val:": Optional[int] = None"},{name:"scale_to_zero_timeout",val:": Optional[int] = None"},{name:"repository",val:": Optional[str] = None"},{name:"framework",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"task",val:": Optional[str] = None"},{name:"custom_image",val:": Optional[Dict] = None"},{name:"secrets",val:": Optional[Dict[str, str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to update.`,name:"name"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.accelerator",description:`<strong>accelerator</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The hardware accelerator to be used for inference (e.g. <code>&quot;cpu&quot;</code>).`,name:"accelerator"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.instance_size",description:`<strong>instance_size</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The size or type of the instance to be used for hosting the model (e.g. <code>&quot;x4&quot;</code>).`,name:"instance_size"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.instance_type",description:`<strong>instance_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The cloud instance type where the Inference Endpoint will be deployed (e.g. <code>&quot;intel-icl&quot;</code>).`,name:"instance_type"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.min_replica",description:`<strong>min_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of replicas (instances) to keep running for the Inference Endpoint.`,name:"min_replica"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.max_replica",description:`<strong>max_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of replicas (instances) to scale to for the Inference Endpoint.`,name:"max_replica"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.scale_to_zero_timeout",description:`<strong>scale_to_zero_timeout</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The duration in minutes before an inactive endpoint is scaled to zero.`,name:"scale_to_zero_timeout"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.repository",description:`<strong>repository</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the model repository associated with the Inference Endpoint (e.g. <code>&quot;gpt2&quot;</code>).`,name:"repository"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The machine learning framework used for the model (e.g. <code>&quot;custom&quot;</code>).`,name:"framework"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model revision to deploy on the Inference Endpoint (e.g. <code>&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</code>).`,name:"revision"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task on which to deploy the model (e.g. <code>&quot;text-classification&quot;</code>).`,name:"task"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.custom_image",description:`<strong>custom_image</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A custom Docker image to use for the Inference Endpoint. This is useful if you want to deploy an
Inference Endpoint running on the <code>text-generation-inference</code> (TGI) framework (see examples).`,name:"custom_image"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.secrets",description:`<strong>secrets</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Secret values to inject in the container environment.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Inference Endpoint will be updated. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7631",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the updated Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Ei=new j({props:{name:"update_repo_settings",anchor:"huggingface_hub.HfApi.update_repo_settings",parameters:[{name:"repo_id",val:": str"},{name:"gated",val:": Optional[Literal['auto', 'manual', False]] = None"},{name:"private",val:": Optional[bool] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_repo_settings.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a /.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.update_repo_settings.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
The gated status for the repository. If set to <code>None</code> (default), the <code>gated</code> setting of the repository won&#x2019;t be updated.<ul>
<li>&#x201C;auto&#x201D;: The repository is gated, and access requests are automatically approved or denied based on predefined criteria.</li>
<li>&#x201C;manual&#x201D;: The repository is gated, and access requests require manual approval.</li>
<li>False : The repository is not gated, and anyone can access it.</li>
</ul>`,name:"gated"},{anchor:"huggingface_hub.HfApi.update_repo_settings.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the repository should be private.`,name:"private"},{anchor:"huggingface_hub.HfApi.update_repo_settings.token",description:`<strong>token</strong> (<code>Union[str, bool, None]</code>, <em>optional</em>) &#x2014;
A valid user access token (string). Defaults to the locally saved token,
which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass False.`,name:"token"},{anchor:"huggingface_hub.HfApi.update_repo_settings.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository to update settings from (<code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>).
Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3644",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If gated is not one of “auto”, “manual”, or False.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If repo_type is not one of the values in constants.REPO_TYPES.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If the request to the Hugging Face Hub API fails.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),Di=new j({props:{name:"update_repo_visibility",anchor:"huggingface_hub.HfApi.update_repo_visibility",parameters:[{name:"repo_id",val:": str"},{name:"private",val:": bool = False"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_repo_visibility.repo_id",description:`<strong>repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.update_repo_visibility.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the repository should be private.`,name:"private"},{anchor:"huggingface_hub.HfApi.update_repo_visibility.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.update_repo_visibility.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3589",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The HTTP response in json.</p>
`}}),ds=new I({props:{$$slots:{default:[nM]},$$scope:{ctx:T}}}),Ri=new j({props:{name:"update_webhook",anchor:"huggingface_hub.HfApi.update_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"url",val:": Optional[str] = None"},{name:"watched",val:": Optional[List[Union[Dict, WebhookWatchedItem]]] = None"},{name:"domains",val:": Optional[List[constants.WEBHOOK_DOMAIN_T]] = None"},{name:"secret",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to be updated.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.update_webhook.url",description:`<strong>url</strong> (<code>str</code>, optional) &#x2014;
The URL to which the payload will be sent.`,name:"url"},{anchor:"huggingface_hub.HfApi.update_webhook.watched",description:`<strong>watched</strong> (<code>List[WebhookWatchedItem]</code>, optional) &#x2014;
List of items to watch. It can be users, orgs, models, datasets, or spaces.
Refer to <code>WebhookWatchedItem</code> for more details. Watched items can also be provided as plain dictionaries.`,name:"watched"},{anchor:"huggingface_hub.HfApi.update_webhook.domains",description:`<strong>domains</strong> (<code>List[Literal[&quot;repo&quot;, &quot;discussion&quot;]]</code>, optional) &#x2014;
The domains to watch. This can include &#x201C;repo&#x201D;, &#x201C;discussion&#x201D;, or both.`,name:"domains"},{anchor:"huggingface_hub.HfApi.update_webhook.secret",description:`<strong>secret</strong> (<code>str</code>, optional) &#x2014;
A secret to sign the payload with, providing an additional layer of security.`,name:"secret"},{anchor:"huggingface_hub.HfApi.update_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8972",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the updated webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WebhookInfo</code></p>
`}}),gs=new U({props:{anchor:"huggingface_hub.HfApi.update_webhook.example",$$slots:{default:[oM]},$$scope:{ctx:T}}}),Fi=new j({props:{name:"upload_file",anchor:"huggingface_hub.HfApi.upload_file",parameters:[{name:"path_or_fileobj",val:": Union[str, Path, bytes, BinaryIO]"},{name:"path_in_repo",val:": str"},{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"},{name:"run_as_future",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.upload_file.path_or_fileobj",description:`<strong>path_or_fileobj</strong> (<code>str</code>, <code>Path</code>, <code>bytes</code>, or <code>IO</code>) &#x2014;
Path to a file on the local machine or binary data stream /
fileobj / buffer.`,name:"path_or_fileobj"},{anchor:"huggingface_hub.HfApi.upload_file.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example:
<code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.upload_file.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to which the file will be uploaded, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.upload_file.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.upload_file.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.upload_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.upload_file.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.upload_file.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.upload_file.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.upload_file.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"},{anchor:"huggingface_hub.HfApi.upload_file.run_as_future",description:`<strong>run_as_future</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to run this method in the background. Background jobs are run sequentially without
blocking the main thread. Passing <code>run_as_future=True</code> will return a <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow">Future</a>
object. Defaults to <code>False</code>.`,name:"run_as_future"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4304",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Instance of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> containing information about the newly created commit (commit hash, commit
url, pr url, commit message,…). If <code>run_as_future=True</code> is passed, returns a Future object which will
contain the result when executed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> or <code>Future</code></p>
`}}),us=new I({props:{$$slots:{default:[aM]},$$scope:{ctx:T}}}),hs=new I({props:{warning:!0,$$slots:{default:[sM]},$$scope:{ctx:T}}}),fs=new U({props:{anchor:"huggingface_hub.HfApi.upload_file.example",$$slots:{default:[rM]},$$scope:{ctx:T}}}),Si=new j({props:{name:"upload_folder",anchor:"huggingface_hub.HfApi.upload_folder",parameters:[{name:"repo_id",val:": str"},{name:"folder_path",val:": Union[str, Path]"},{name:"path_in_repo",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"},{name:"allow_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"ignore_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"delete_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"run_as_future",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.upload_folder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to which the file will be uploaded, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.upload_folder.folder_path",description:`<strong>folder_path</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to the folder to upload on the local file system`,name:"folder_path"},{anchor:"huggingface_hub.HfApi.upload_folder.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Relative path of the directory in the repo, for example:
<code>&quot;checkpoints/1fec34a/results&quot;</code>. Will default to the root folder of the repository.`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.upload_folder.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.upload_folder.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.upload_folder.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.upload_folder.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit. Defaults to:
<code>f&quot;Upload {path_in_repo} with huggingface_hub&quot;</code>`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.upload_folder.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.upload_folder.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>. If <code>revision</code> is not
set, PR is opened against the <code>&quot;main&quot;</code> branch. If <code>revision</code> is set and is a branch, PR is opened
against this branch. If <code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.upload_folder.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"},{anchor:"huggingface_hub.HfApi.upload_folder.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are uploaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.HfApi.upload_folder.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not uploaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.HfApi.upload_folder.delete_patterns",description:`<strong>delete_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, remote files matching any of the patterns will be deleted from the repo while committing
new files. This is useful if you don&#x2019;t know which files have already been uploaded.
Note: to avoid discrepancies the <code>.gitattributes</code> file is not deleted even if it matches the pattern.`,name:"delete_patterns"},{anchor:"huggingface_hub.HfApi.upload_folder.run_as_future",description:`<strong>run_as_future</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to run this method in the background. Background jobs are run sequentially without
blocking the main thread. Passing <code>run_as_future=True</code> will return a <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow">Future</a>
object. Defaults to <code>False</code>.`,name:"run_as_future"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4512",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Instance of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> containing information about the newly created commit (commit hash, commit
url, pr url, commit message,…). If <code>run_as_future=True</code> is passed, returns a Future object which will
contain the result when executed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> or <code>Future</code></p>
`}}),ms=new I({props:{$$slots:{default:[iM]},$$scope:{ctx:T}}}),_s=new I({props:{warning:!0,$$slots:{default:[cM]},$$scope:{ctx:T}}}),bs=new I({props:{$$slots:{default:[lM]},$$scope:{ctx:T}}}),vs=new U({props:{anchor:"huggingface_hub.HfApi.upload_folder.example",$$slots:{default:[pM]},$$scope:{ctx:T}}}),Gi=new j({props:{name:"upload_large_folder",anchor:"huggingface_hub.HfApi.upload_large_folder",parameters:[{name:"repo_id",val:": str"},{name:"folder_path",val:": Union[str, Path]"},{name:"repo_type",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"private",val:": Optional[bool] = None"},{name:"allow_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"ignore_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"num_workers",val:": Optional[int] = None"},{name:"print_report",val:": bool = True"},{name:"print_report_every",val:": int = 60"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.upload_large_folder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to which the file will be uploaded.
E.g. <code>&quot;HuggingFaceTB/smollm-corpus&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.upload_large_folder.folder_path",description:`<strong>folder_path</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to the folder to upload on the local file system.`,name:"folder_path"},{anchor:"huggingface_hub.HfApi.upload_large_folder.repo_type",description:`<strong>repo_type</strong> (<code>str</code>) &#x2014;
Type of the repository. Must be one of <code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>.
Unlike in all other <code>HfApi</code> methods, <code>repo_type</code> is explicitly required here. This is to avoid
any mistake when uploading a large folder to the Hub, and therefore prevent from having to re-upload
everything.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.upload_large_folder.revision",description:`<strong>revision</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The branch to commit to. If not provided, the <code>main</code> branch will be used.`,name:"revision"},{anchor:"huggingface_hub.HfApi.upload_large_folder.private",description:`<strong>private</strong> (<code>bool</code>, <code>optional</code>) &#x2014;
Whether the repository should be private.
If <code>None</code> (default), the repo will be public unless the organization&#x2019;s default is private.`,name:"private"},{anchor:"huggingface_hub.HfApi.upload_large_folder.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are uploaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.HfApi.upload_large_folder.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not uploaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.HfApi.upload_large_folder.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of workers to start. Defaults to <code>os.cpu_count() - 2</code> (minimum 2).
A higher number of workers may speed up the process if your machine allows it. However, on machines with a
slower connection, it is recommended to keep the number of workers low to ensure better resumability.
Indeed, partially uploaded files will have to be completely re-uploaded if the process is interrupted.`,name:"num_workers"},{anchor:"huggingface_hub.HfApi.upload_large_folder.print_report",description:`<strong>print_report</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to print a report of the upload progress. Defaults to True.
Report is printed to <code>sys.stdout</code> every X seconds (60 by defaults) and overwrites the previous report.`,name:"print_report"},{anchor:"huggingface_hub.HfApi.upload_large_folder.print_report_every",description:`<strong>print_report_every</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Frequency at which the report is printed. Defaults to 60 seconds.`,name:"print_report_every"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4979"}}),ys=new I({props:{$$slots:{default:[dM]},$$scope:{ctx:T}}}),xs=new I({props:{warning:!0,$$slots:{default:[gM]},$$scope:{ctx:T}}}),Li=new j({props:{name:"whoami",anchor:"huggingface_hub.HfApi.whoami",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.whoami.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1653"}}),Zi=new R({props:{title:"API Dataclasses",local:"api-dataclasses",headingTag:"h2"}}),Vi=new R({props:{title:"AccessRequest",local:"huggingface_hub.hf_api.AccessRequest ][ huggingface_hub.hf_api.AccessRequest",headingTag:"h3"}}),Pi=new j({props:{name:"class huggingface_hub.hf_api.AccessRequest",anchor:"huggingface_hub.hf_api.AccessRequest",parameters:[{name:"username",val:": str"},{name:"fullname",val:": str"},{name:"email",val:": Optional[str]"},{name:"timestamp",val:": datetime"},{name:"status",val:": Literal['pending', 'accepted', 'rejected']"},{name:"fields",val:": Optional[Dict[str, Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.hf_api.AccessRequest.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user who requested access.`,name:"username"},{anchor:"huggingface_hub.hf_api.AccessRequest.fullname",description:`<strong>fullname</strong> (<code>str</code>) &#x2014;
Fullname of the user who requested access.`,name:"fullname"},{anchor:"huggingface_hub.hf_api.AccessRequest.email",description:`<strong>email</strong> (<code>Optional[str]</code>) &#x2014;
Email of the user who requested access.
Can only be <code>None</code> in the /accepted list if the user was granted access manually.`,name:"email"},{anchor:"huggingface_hub.hf_api.AccessRequest.timestamp",description:`<strong>timestamp</strong> (<code>datetime</code>) &#x2014;
Timestamp of the request.`,name:"timestamp"},{anchor:"huggingface_hub.hf_api.AccessRequest.status",description:`<strong>status</strong> (<code>Literal[&quot;pending&quot;, &quot;accepted&quot;, &quot;rejected&quot;]</code>) &#x2014;
Status of the request. Can be one of <code>[&quot;pending&quot;, &quot;accepted&quot;, &quot;rejected&quot;]</code>.`,name:"status"},{anchor:"huggingface_hub.hf_api.AccessRequest.fields",description:`<strong>fields</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional fields filled by the user in the gate form.`,name:"fields"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L448"}}),Wi=new R({props:{title:"CommitInfo",local:"huggingface_hub.CommitInfo ][ huggingface_hub.CommitInfo",headingTag:"h3"}}),Bi=new j({props:{name:"class huggingface_hub.CommitInfo",anchor:"huggingface_hub.CommitInfo",parameters:[{name:"*args",val:""},{name:"commit_url",val:": str"},{name:"_url",val:": Optional[str] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.CommitInfo.commit_url",description:`<strong>commit_url</strong> (<code>str</code>) &#x2014;
Url where to find the commit.`,name:"commit_url"},{anchor:"huggingface_hub.CommitInfo.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
The summary (first line) of the commit that has been created.`,name:"commit_message"},{anchor:"huggingface_hub.CommitInfo.commit_description",description:`<strong>commit_description</strong> (<code>str</code>) &#x2014;
Description of the commit that has been created. Can be empty.`,name:"commit_description"},{anchor:"huggingface_hub.CommitInfo.oid",description:`<strong>oid</strong> (<code>str</code>) &#x2014;
Commit hash id. Example: <code>&quot;91c54ad1727ee830252e457677f467be0bfd8a57&quot;</code>.`,name:"oid"},{anchor:"huggingface_hub.CommitInfo.pr_url",description:`<strong>pr_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Url to the PR that has been created, if any. Populated when <code>create_pr=True</code>
is passed.`,name:"pr_url"},{anchor:"huggingface_hub.CommitInfo.pr_revision",description:`<strong>pr_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision of the PR that has been created, if any. Populated when
<code>create_pr=True</code> is passed. Example: <code>&quot;refs/pr/1&quot;</code>.`,name:"pr_revision"},{anchor:"huggingface_hub.CommitInfo.pr_num",description:`<strong>pr_num</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of the PR discussion that has been created, if any. Populated when
<code>create_pr=True</code> is passed. Can be passed as <code>discussion_num</code> in
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_discussion_details">get_discussion_details()</a>. Example: <code>1</code>.`,name:"pr_num"},{anchor:"huggingface_hub.CommitInfo.repo_url",description:`<strong>repo_url</strong> (<code>RepoUrl</code>) &#x2014;
Repo URL of the commit containing info like repo_id, repo_type, etc.`,name:"repo_url"},{anchor:"huggingface_hub.CommitInfo._url",description:`<strong>_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Legacy url for <code>str</code> compatibility. Can be the url to the uploaded file on the Hub (if returned by
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>), to the uploaded folder on the Hub (if returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>) or to the commit on
the Hub (if returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>). Defaults to <code>commit_url</code>. It is deprecated to use this
attribute. Please use <code>commit_url</code> instead.`,name:"_url"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L368"}}),Yi=new R({props:{title:"DatasetInfo",local:"huggingface_hub.hf_api.DatasetInfo ][ huggingface_hub.DatasetInfo",headingTag:"h3"}}),Xi=new j({props:{name:"class huggingface_hub.DatasetInfo",anchor:"huggingface_hub.DatasetInfo",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.DatasetInfo.id",description:`<strong>id</strong> (<code>str</code>) &#x2014;
ID of dataset.`,name:"id"},{anchor:"huggingface_hub.DatasetInfo.author",description:`<strong>author</strong> (<code>str</code>) &#x2014;
Author of the dataset.`,name:"author"},{anchor:"huggingface_hub.DatasetInfo.sha",description:`<strong>sha</strong> (<code>str</code>) &#x2014;
Repo SHA at this particular revision.`,name:"sha"},{anchor:"huggingface_hub.DatasetInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of creation of the repo on the Hub. Note that the lowest value is <code>2022-03-02T23:29:04.000Z</code>,
corresponding to the date when we began to store creation dates.`,name:"created_at"},{anchor:"huggingface_hub.DatasetInfo.last_modified",description:`<strong>last_modified</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of last commit to the repo.`,name:"last_modified"},{anchor:"huggingface_hub.DatasetInfo.private",description:`<strong>private</strong> (<code>bool</code>) &#x2014;
Is the repo private.`,name:"private"},{anchor:"huggingface_hub.DatasetInfo.disabled",description:`<strong>disabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Is the repo disabled.`,name:"disabled"},{anchor:"huggingface_hub.DatasetInfo.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
Is the repo gated.
If so, whether there is manual or automatic approval.`,name:"gated"},{anchor:"huggingface_hub.DatasetInfo.downloads",description:`<strong>downloads</strong> (<code>int</code>) &#x2014;
Number of downloads of the dataset over the last 30 days.`,name:"downloads"},{anchor:"huggingface_hub.DatasetInfo.downloads_all_time",description:`<strong>downloads_all_time</strong> (<code>int</code>) &#x2014;
Cumulated number of downloads of the model since its creation.`,name:"downloads_all_time"},{anchor:"huggingface_hub.DatasetInfo.likes",description:`<strong>likes</strong> (<code>int</code>) &#x2014;
Number of likes of the dataset.`,name:"likes"},{anchor:"huggingface_hub.DatasetInfo.tags",description:`<strong>tags</strong> (<code>List[str]</code>) &#x2014;
List of tags of the dataset.`,name:"tags"},{anchor:"huggingface_hub.DatasetInfo.card_data",description:`<strong>card_data</strong> (<code>DatasetCardData</code>, <em>optional</em>) &#x2014;
Model Card Metadata  as a <a href="/docs/huggingface_hub/main/ko/package_reference/cards#huggingface_hub.DatasetCardData">huggingface_hub.repocard_data.DatasetCardData</a> object.`,name:"card_data"},{anchor:"huggingface_hub.DatasetInfo.siblings",description:`<strong>siblings</strong> (<code>List[RepoSibling]</code>) &#x2014;
List of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.hf_api.RepoSibling">huggingface_hub.hf_api.RepoSibling</a> objects that constitute the dataset.`,name:"siblings"},{anchor:"huggingface_hub.DatasetInfo.paperswithcode_id",description:`<strong>paperswithcode_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Papers with code ID of the dataset.`,name:"paperswithcode_id"},{anchor:"huggingface_hub.DatasetInfo.trending_score",description:`<strong>trending_score</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Trending score of the dataset.`,name:"trending_score"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L906"}}),ws=new I({props:{$$slots:{default:[uM]},$$scope:{ctx:T}}}),zi=new R({props:{title:"GitRefInfo",local:"huggingface_hub.GitRefInfo ][ huggingface_hub.GitRefInfo",headingTag:"h3"}}),Oi=new j({props:{name:"class huggingface_hub.GitRefInfo",anchor:"huggingface_hub.GitRefInfo",parameters:[{name:"name",val:": str"},{name:"ref",val:": str"},{name:"target_commit",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.GitRefInfo.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
Name of the reference (e.g. tag name or branch name).`,name:"name"},{anchor:"huggingface_hub.GitRefInfo.ref",description:`<strong>ref</strong> (<code>str</code>) &#x2014;
Full git ref on the Hub (e.g. <code>&quot;refs/heads/main&quot;</code> or <code>&quot;refs/tags/v1.0&quot;</code>).`,name:"ref"},{anchor:"huggingface_hub.GitRefInfo.target_commit",description:`<strong>target_commit</strong> (<code>str</code>) &#x2014;
OID of the target commit for the ref (e.g. <code>&quot;e7da7f221d5bf496a48136c0cd264e630fe9fcc8&quot;</code>)`,name:"target_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1254"}}),Qi=new R({props:{title:"GitCommitInfo",local:"huggingface_hub.GitCommitInfo ][ huggingface_hub.GitCommitInfo",headingTag:"h3"}}),Ki=new j({props:{name:"class huggingface_hub.GitCommitInfo",anchor:"huggingface_hub.GitCommitInfo",parameters:[{name:"commit_id",val:": str"},{name:"authors",val:": List[str]"},{name:"created_at",val:": datetime"},{name:"title",val:": str"},{name:"message",val:": str"},{name:"formatted_title",val:": Optional[str]"},{name:"formatted_message",val:": Optional[str]"}],parametersDescription:[{anchor:"huggingface_hub.GitCommitInfo.commit_id",description:`<strong>commit_id</strong> (<code>str</code>) &#x2014;
OID of the commit (e.g. <code>&quot;e7da7f221d5bf496a48136c0cd264e630fe9fcc8&quot;</code>)`,name:"commit_id"},{anchor:"huggingface_hub.GitCommitInfo.authors",description:`<strong>authors</strong> (<code>List[str]</code>) &#x2014;
List of authors of the commit.`,name:"authors"},{anchor:"huggingface_hub.GitCommitInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>) &#x2014;
Datetime when the commit was created.`,name:"created_at"},{anchor:"huggingface_hub.GitCommitInfo.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
Title of the commit. This is a free-text value entered by the authors.`,name:"title"},{anchor:"huggingface_hub.GitCommitInfo.message",description:`<strong>message</strong> (<code>str</code>) &#x2014;
Description of the commit. This is a free-text value entered by the authors.`,name:"message"},{anchor:"huggingface_hub.GitCommitInfo.formatted_title",description:`<strong>formatted_title</strong> (<code>str</code>) &#x2014;
Title of the commit formatted as HTML. Only returned if <code>formatted=True</code> is set.`,name:"formatted_title"},{anchor:"huggingface_hub.GitCommitInfo.formatted_message",description:`<strong>formatted_message</strong> (<code>str</code>) &#x2014;
Description of the commit formatted as HTML. Only returned if <code>formatted=True</code> is set.`,name:"formatted_message"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1299"}}),ec=new R({props:{title:"GitRefs",local:"huggingface_hub.GitRefs ][ huggingface_hub.GitRefs",headingTag:"h3"}}),tc=new j({props:{name:"class huggingface_hub.GitRefs",anchor:"huggingface_hub.GitRefs",parameters:[{name:"branches",val:": List[GitRefInfo]"},{name:"converts",val:": List[GitRefInfo]"},{name:"tags",val:": List[GitRefInfo]"},{name:"pull_requests",val:": Optional[List[GitRefInfo]] = None"}],parametersDescription:[{anchor:"huggingface_hub.GitRefs.branches",description:`<strong>branches</strong> (<code>List[GitRefInfo]</code>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about branches on the repo.`,name:"branches"},{anchor:"huggingface_hub.GitRefs.converts",description:`<strong>converts</strong> (<code>List[GitRefInfo]</code>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about &#x201C;convert&#x201D; refs on the repo.
Converts are refs used (internally) to push preprocessed data in Dataset repos.`,name:"converts"},{anchor:"huggingface_hub.GitRefs.tags",description:`<strong>tags</strong> (<code>List[GitRefInfo]</code>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about tags on the repo.`,name:"tags"},{anchor:"huggingface_hub.GitRefs.pull_requests",description:`<strong>pull_requests</strong> (<code>List[GitRefInfo]</code>, <em>optional</em>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about pull requests on the repo.
Only returned if <code>include_prs=True</code> is set.`,name:"pull_requests"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1273"}}),nc=new R({props:{title:"ModelInfo",local:"huggingface_hub.hf_api.ModelInfo ][ huggingface_hub.ModelInfo",headingTag:"h3"}}),oc=new j({props:{name:"class huggingface_hub.ModelInfo",anchor:"huggingface_hub.ModelInfo",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelInfo.id",description:`<strong>id</strong> (<code>str</code>) &#x2014;
ID of model.`,name:"id"},{anchor:"huggingface_hub.ModelInfo.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Author of the model.`,name:"author"},{anchor:"huggingface_hub.ModelInfo.sha",description:`<strong>sha</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Repo SHA at this particular revision.`,name:"sha"},{anchor:"huggingface_hub.ModelInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of creation of the repo on the Hub. Note that the lowest value is <code>2022-03-02T23:29:04.000Z</code>,
corresponding to the date when we began to store creation dates.`,name:"created_at"},{anchor:"huggingface_hub.ModelInfo.last_modified",description:`<strong>last_modified</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of last commit to the repo.`,name:"last_modified"},{anchor:"huggingface_hub.ModelInfo.private",description:`<strong>private</strong> (<code>bool</code>) &#x2014;
Is the repo private.`,name:"private"},{anchor:"huggingface_hub.ModelInfo.disabled",description:`<strong>disabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Is the repo disabled.`,name:"disabled"},{anchor:"huggingface_hub.ModelInfo.downloads",description:`<strong>downloads</strong> (<code>int</code>) &#x2014;
Number of downloads of the model over the last 30 days.`,name:"downloads"},{anchor:"huggingface_hub.ModelInfo.downloads_all_time",description:`<strong>downloads_all_time</strong> (<code>int</code>) &#x2014;
Cumulated number of downloads of the model since its creation.`,name:"downloads_all_time"},{anchor:"huggingface_hub.ModelInfo.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
Is the repo gated.
If so, whether there is manual or automatic approval.`,name:"gated"},{anchor:"huggingface_hub.ModelInfo.gguf",description:`<strong>gguf</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
GGUF information of the model.`,name:"gguf"},{anchor:"huggingface_hub.ModelInfo.inference",description:`<strong>inference</strong> (<code>Literal[&quot;cold&quot;, &quot;frozen&quot;, &quot;warm&quot;]</code>, <em>optional</em>) &#x2014;
Status of the model on the inference API.
Warm models are available for immediate use. Cold models will be loaded on first inference call.
Frozen models are not available in Inference API.`,name:"inference"},{anchor:"huggingface_hub.ModelInfo.inference_provider_mapping",description:`<strong>inference_provider_mapping</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Model&#x2019;s inference provider mapping.`,name:"inference_provider_mapping"},{anchor:"huggingface_hub.ModelInfo.likes",description:`<strong>likes</strong> (<code>int</code>) &#x2014;
Number of likes of the model.`,name:"likes"},{anchor:"huggingface_hub.ModelInfo.library_name",description:`<strong>library_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Library associated with the model.`,name:"library_name"},{anchor:"huggingface_hub.ModelInfo.tags",description:`<strong>tags</strong> (<code>List[str]</code>) &#x2014;
List of tags of the model. Compared to <code>card_data.tags</code>, contains extra tags computed by the Hub
(e.g. supported libraries, model&#x2019;s arXiv).`,name:"tags"},{anchor:"huggingface_hub.ModelInfo.pipeline_tag",description:`<strong>pipeline_tag</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pipeline tag associated with the model.`,name:"pipeline_tag"},{anchor:"huggingface_hub.ModelInfo.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mask token used by the model.`,name:"mask_token"},{anchor:"huggingface_hub.ModelInfo.widget_data",description:`<strong>widget_data</strong> (<code>Any</code>, <em>optional</em>) &#x2014;
Widget data associated with the model.`,name:"widget_data"},{anchor:"huggingface_hub.ModelInfo.model_index",description:`<strong>model_index</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Model index for evaluation.`,name:"model_index"},{anchor:"huggingface_hub.ModelInfo.config",description:`<strong>config</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Model configuration.`,name:"config"},{anchor:"huggingface_hub.ModelInfo.transformers_info",description:`<strong>transformers_info</strong> (<code>TransformersInfo</code>, <em>optional</em>) &#x2014;
Transformers-specific info (auto class, processor, etc.) associated with the model.`,name:"transformers_info"},{anchor:"huggingface_hub.ModelInfo.trending_score",description:`<strong>trending_score</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Trending score of the model.`,name:"trending_score"},{anchor:"huggingface_hub.ModelInfo.card_data",description:`<strong>card_data</strong> (<code>ModelCardData</code>, <em>optional</em>) &#x2014;
Model Card Metadata  as a <a href="/docs/huggingface_hub/main/ko/package_reference/cards#huggingface_hub.ModelCardData">huggingface_hub.repocard_data.ModelCardData</a> object.`,name:"card_data"},{anchor:"huggingface_hub.ModelInfo.siblings",description:`<strong>siblings</strong> (<code>List[RepoSibling]</code>) &#x2014;
List of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.hf_api.RepoSibling">huggingface_hub.hf_api.RepoSibling</a> objects that constitute the model.`,name:"siblings"},{anchor:"huggingface_hub.ModelInfo.spaces",description:`<strong>spaces</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of spaces using the model.`,name:"spaces"},{anchor:"huggingface_hub.ModelInfo.safetensors",description:`<strong>safetensors</strong> (<code>SafeTensorsInfo</code>, <em>optional</em>) &#x2014;
Model&#x2019;s safetensors information.`,name:"safetensors"},{anchor:"huggingface_hub.ModelInfo.security_repo_status",description:`<strong>security_repo_status</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Model&#x2019;s security scan status.`,name:"security_repo_status"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L718"}}),ks=new I({props:{$$slots:{default:[hM]},$$scope:{ctx:T}}}),ac=new R({props:{title:"RepoSibling",local:"huggingface_hub.hf_api.RepoSibling ][ huggingface_hub.hf_api.RepoSibling",headingTag:"h3"}}),sc=new j({props:{name:"class huggingface_hub.hf_api.RepoSibling",anchor:"huggingface_hub.hf_api.RepoSibling",parameters:[{name:"rfilename",val:": str"},{name:"size",val:": Optional[int] = None"},{name:"blob_id",val:": Optional[str] = None"},{name:"lfs",val:": Optional[BlobLfsInfo] = None"}],parametersDescription:[{anchor:"huggingface_hub.hf_api.RepoSibling.rfilename",description:`<strong>rfilename</strong> (str) &#x2014;
file name, relative to the repo root.`,name:"rfilename"},{anchor:"huggingface_hub.hf_api.RepoSibling.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The file&#x2019;s size, in bytes. This attribute is defined when <code>files_metadata</code> argument of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.repo_info">repo_info()</a> is set
to <code>True</code>. It&#x2019;s <code>None</code> otherwise.`,name:"size"},{anchor:"huggingface_hub.hf_api.RepoSibling.blob_id",description:`<strong>blob_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The file&#x2019;s git OID. This attribute is defined when <code>files_metadata</code> argument of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.repo_info">repo_info()</a> is set to
<code>True</code>. It&#x2019;s <code>None</code> otherwise.`,name:"blob_id"},{anchor:"huggingface_hub.hf_api.RepoSibling.lfs",description:`<strong>lfs</strong> (<code>BlobLfsInfo</code>, <em>optional</em>) &#x2014;
The file&#x2019;s LFS metadata. This attribute is defined when<code>files_metadata</code> argument of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.repo_info">repo_info()</a> is set to
<code>True</code> and the file is stored with Git LFS. It&#x2019;s <code>None</code> otherwise.`,name:"lfs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L581"}}),Ts=new I({props:{$$slots:{default:[fM]},$$scope:{ctx:T}}}),rc=new R({props:{title:"RepoFile",local:"huggingface_hub.hf_api.RepoFile ][ huggingface_hub.hf_api.RepoFile",headingTag:"h3"}}),ic=new j({props:{name:"class huggingface_hub.hf_api.RepoFile",anchor:"huggingface_hub.hf_api.RepoFile",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.hf_api.RepoFile.path",description:`<strong>path</strong> (str) &#x2014;
file path relative to the repo root.`,name:"path"},{anchor:"huggingface_hub.hf_api.RepoFile.size",description:`<strong>size</strong> (<code>int</code>) &#x2014;
The file&#x2019;s size, in bytes.`,name:"size"},{anchor:"huggingface_hub.hf_api.RepoFile.blob_id",description:`<strong>blob_id</strong> (<code>str</code>) &#x2014;
The file&#x2019;s git OID.`,name:"blob_id"},{anchor:"huggingface_hub.hf_api.RepoFile.lfs",description:`<strong>lfs</strong> (<code>BlobLfsInfo</code>) &#x2014;
The file&#x2019;s LFS metadata.`,name:"lfs"},{anchor:"huggingface_hub.hf_api.RepoFile.last_commit",description:`<strong>last_commit</strong> (<code>LastCommitInfo</code>, <em>optional</em>) &#x2014;
The file&#x2019;s last commit metadata. Only defined if <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_repo_tree">list_repo_tree()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_paths_info">get_paths_info()</a>
are called with <code>expand=True</code>.`,name:"last_commit"},{anchor:"huggingface_hub.hf_api.RepoFile.security",description:`<strong>security</strong> (<code>BlobSecurityInfo</code>, <em>optional</em>) &#x2014;
The file&#x2019;s security scan metadata. Only defined if <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_repo_tree">list_repo_tree()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_paths_info">get_paths_info()</a>
are called with <code>expand=True</code>.`,name:"security"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L616"}}),cc=new R({props:{title:"RepoUrl",local:"huggingface_hub.RepoUrl ][ huggingface_hub.RepoUrl",headingTag:"h3"}}),lc=new j({props:{name:"class huggingface_hub.RepoUrl",anchor:"huggingface_hub.RepoUrl",parameters:[{name:"url",val:": Any"},{name:"endpoint",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.RepoUrl.url",description:`<strong>url</strong> (<code>Any</code>) &#x2014;
String value of the repo url.`,name:"url"},{anchor:"huggingface_hub.RepoUrl.endpoint",description:`<strong>endpoint</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Endpoint of the Hub. Defaults to <a href="https://huggingface.co" rel="nofollow">https://huggingface.co</a>.`,name:"endpoint"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L520",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If URL cannot be parsed.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>repo_type</code> is unknown.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),qs=new U({props:{anchor:"huggingface_hub.RepoUrl.example",$$slots:{default:[mM]},$$scope:{ctx:T}}}),pc=new R({props:{title:"SafetensorsRepoMetadata",local:"huggingface_hub.utils.SafetensorsRepoMetadata ][ huggingface_hub.utils.SafetensorsRepoMetadata",headingTag:"h3"}}),dc=new j({props:{name:"class huggingface_hub.utils.SafetensorsRepoMetadata",anchor:"huggingface_hub.utils.SafetensorsRepoMetadata",parameters:[{name:"metadata",val:": typing.Optional[typing.Dict]"},{name:"sharded",val:": bool"},{name:"weight_map",val:": typing.Dict[str, str]"},{name:"files_metadata",val:": typing.Dict[str, huggingface_hub.utils._safetensors.SafetensorsFileMetadata]"}],parametersDescription:[{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.metadata",description:`<strong>metadata</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
The metadata contained in the &#x2018;model.safetensors.index.json&#x2019; file, if it exists. Only populated for sharded
models.`,name:"metadata"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.sharded",description:`<strong>sharded</strong> (<code>bool</code>) &#x2014;
Whether the repo contains a sharded model or not.`,name:"sharded"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.weight_map",description:`<strong>weight_map</strong> (<code>Dict[str, str]</code>) &#x2014;
A map of all weights. Keys are tensor names and values are filenames of the files containing the tensors.`,name:"weight_map"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.files_metadata",description:`<strong>files_metadata</strong> (<code>Dict[str, SafetensorsFileMetadata]</code>) &#x2014;
A map of all files metadata. Keys are filenames and values are the metadata of the corresponding file, as
a <code>SafetensorsFileMetadata</code> object.`,name:"files_metadata"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.parameter_count",description:`<strong>parameter_count</strong> (<code>Dict[str, int]</code>) &#x2014;
A map of the number of parameters per data type. Keys are data types and values are the number of parameters
of that data type.`,name:"parameter_count"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_safetensors.py#L73"}}),gc=new R({props:{title:"SafetensorsFileMetadata",local:"huggingface_hub.utils.SafetensorsFileMetadata ][ huggingface_hub.utils.SafetensorsFileMetadata",headingTag:"h3"}}),uc=new j({props:{name:"class huggingface_hub.utils.SafetensorsFileMetadata",anchor:"huggingface_hub.utils.SafetensorsFileMetadata",parameters:[{name:"metadata",val:": typing.Dict[str, str]"},{name:"tensors",val:": typing.Dict[str, huggingface_hub.utils._safetensors.TensorInfo]"}],parametersDescription:[{anchor:"huggingface_hub.utils.SafetensorsFileMetadata.metadata",description:`<strong>metadata</strong> (<code>Dict</code>) &#x2014;
The metadata contained in the file.`,name:"metadata"},{anchor:"huggingface_hub.utils.SafetensorsFileMetadata.tensors",description:`<strong>tensors</strong> (<code>Dict[str, TensorInfo]</code>) &#x2014;
A map of all tensors. Keys are tensor names and values are information about the corresponding tensor, as a
<code>TensorInfo</code> object.`,name:"tensors"},{anchor:"huggingface_hub.utils.SafetensorsFileMetadata.parameter_count",description:`<strong>parameter_count</strong> (<code>Dict[str, int]</code>) &#x2014;
A map of the number of parameters per data type. Keys are data types and values are the number of parameters
of that data type.`,name:"parameter_count"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_safetensors.py#L43"}}),hc=new R({props:{title:"SpaceInfo",local:"huggingface_hub.hf_api.SpaceInfo ][ huggingface_hub.SpaceInfo",headingTag:"h3"}}),fc=new j({props:{name:"class huggingface_hub.SpaceInfo",anchor:"huggingface_hub.SpaceInfo",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.SpaceInfo.id",description:`<strong>id</strong> (<code>str</code>) &#x2014;
ID of the Space.`,name:"id"},{anchor:"huggingface_hub.SpaceInfo.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Author of the Space.`,name:"author"},{anchor:"huggingface_hub.SpaceInfo.sha",description:`<strong>sha</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Repo SHA at this particular revision.`,name:"sha"},{anchor:"huggingface_hub.SpaceInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of creation of the repo on the Hub. Note that the lowest value is <code>2022-03-02T23:29:04.000Z</code>,
corresponding to the date when we began to store creation dates.`,name:"created_at"},{anchor:"huggingface_hub.SpaceInfo.last_modified",description:`<strong>last_modified</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of last commit to the repo.`,name:"last_modified"},{anchor:"huggingface_hub.SpaceInfo.private",description:`<strong>private</strong> (<code>bool</code>) &#x2014;
Is the repo private.`,name:"private"},{anchor:"huggingface_hub.SpaceInfo.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
Is the repo gated.
If so, whether there is manual or automatic approval.`,name:"gated"},{anchor:"huggingface_hub.SpaceInfo.disabled",description:`<strong>disabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Is the Space disabled.`,name:"disabled"},{anchor:"huggingface_hub.SpaceInfo.host",description:`<strong>host</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Host URL of the Space.`,name:"host"},{anchor:"huggingface_hub.SpaceInfo.subdomain",description:`<strong>subdomain</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Subdomain of the Space.`,name:"subdomain"},{anchor:"huggingface_hub.SpaceInfo.likes",description:`<strong>likes</strong> (<code>int</code>) &#x2014;
Number of likes of the Space.`,name:"likes"},{anchor:"huggingface_hub.SpaceInfo.tags",description:`<strong>tags</strong> (<code>List[str]</code>) &#x2014;
List of tags of the Space.`,name:"tags"},{anchor:"huggingface_hub.SpaceInfo.siblings",description:`<strong>siblings</strong> (<code>List[RepoSibling]</code>) &#x2014;
List of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.hf_api.RepoSibling">huggingface_hub.hf_api.RepoSibling</a> objects that constitute the Space.`,name:"siblings"},{anchor:"huggingface_hub.SpaceInfo.card_data",description:`<strong>card_data</strong> (<code>SpaceCardData</code>, <em>optional</em>) &#x2014;
Space Card Metadata  as a <a href="/docs/huggingface_hub/main/ko/package_reference/cards#huggingface_hub.SpaceCardData">huggingface_hub.repocard_data.SpaceCardData</a> object.`,name:"card_data"},{anchor:"huggingface_hub.SpaceInfo.runtime",description:`<strong>runtime</strong> (<code>SpaceRuntime</code>, <em>optional</em>) &#x2014;
Space runtime information as a <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime">huggingface_hub.hf_api.SpaceRuntime</a> object.`,name:"runtime"},{anchor:"huggingface_hub.SpaceInfo.sdk",description:`<strong>sdk</strong> (<code>str</code>, <em>optional</em>) &#x2014;
SDK used by the Space.`,name:"sdk"},{anchor:"huggingface_hub.SpaceInfo.models",description:`<strong>models</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of models used by the Space.`,name:"models"},{anchor:"huggingface_hub.SpaceInfo.datasets",description:`<strong>datasets</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of datasets used by the Space.`,name:"datasets"},{anchor:"huggingface_hub.SpaceInfo.trending_score",description:`<strong>trending_score</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Trending score of the Space.`,name:"trending_score"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1025"}}),Ms=new I({props:{$$slots:{default:[_M]},$$scope:{ctx:T}}}),mc=new R({props:{title:"TensorInfo",local:"huggingface_hub.utils.TensorInfo ][ huggingface_hub.utils.TensorInfo",headingTag:"h3"}}),_c=new j({props:{name:"class huggingface_hub.utils.TensorInfo",anchor:"huggingface_hub.utils.TensorInfo",parameters:[{name:"dtype",val:": typing.Literal['F64', 'F32', 'F16', 'BF16', 'I64', 'I32', 'I16', 'I8', 'U8', 'BOOL']"},{name:"shape",val:": typing.List[int]"},{name:"data_offsets",val:": typing.Tuple[int, int]"}],parametersDescription:[{anchor:"huggingface_hub.utils.TensorInfo.dtype",description:`<strong>dtype</strong> (<code>str</code>) &#x2014;
The data type of the tensor (&#x201C;F64&#x201D;, &#x201C;F32&#x201D;, &#x201C;F16&#x201D;, &#x201C;BF16&#x201D;, &#x201C;I64&#x201D;, &#x201C;I32&#x201D;, &#x201C;I16&#x201D;, &#x201C;I8&#x201D;, &#x201C;U8&#x201D;, &#x201C;BOOL&#x201D;).`,name:"dtype"},{anchor:"huggingface_hub.utils.TensorInfo.shape",description:`<strong>shape</strong> (<code>List[int]</code>) &#x2014;
The shape of the tensor.`,name:"shape"},{anchor:"huggingface_hub.utils.TensorInfo.data_offsets",description:`<strong>data_offsets</strong> (<code>Tuple[int, int]</code>) &#x2014;
The offsets of the data in the file as a tuple <code>[BEGIN, END]</code>.`,name:"data_offsets"},{anchor:"huggingface_hub.utils.TensorInfo.parameter_count",description:`<strong>parameter_count</strong> (<code>int</code>) &#x2014;
The number of parameters in the tensor.`,name:"parameter_count"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_safetensors.py#L13"}}),bc=new R({props:{title:"User",local:"huggingface_hub.User ][ huggingface_hub.User",headingTag:"h3"}}),vc=new j({props:{name:"class huggingface_hub.User",anchor:"huggingface_hub.User",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.User.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Name of the user on the Hub (unique).`,name:"username"},{anchor:"huggingface_hub.User.fullname",description:`<strong>fullname</strong> (<code>str</code>) &#x2014;
User&#x2019;s full name.`,name:"fullname"},{anchor:"huggingface_hub.User.avatar_url",description:`<strong>avatar_url</strong> (<code>str</code>) &#x2014;
URL of the user&#x2019;s avatar.`,name:"avatar_url"},{anchor:"huggingface_hub.User.details",description:`<strong>details</strong> (<code>str</code>, <em>optional</em>) &#x2014;
User&#x2019;s details.`,name:"details"},{anchor:"huggingface_hub.User.is_following",description:`<strong>is_following</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the authenticated user is following this user.`,name:"is_following"},{anchor:"huggingface_hub.User.is_pro",description:`<strong>is_pro</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the user is a pro user.`,name:"is_pro"},{anchor:"huggingface_hub.User.num_models",description:`<strong>num_models</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of models created by the user.`,name:"num_models"},{anchor:"huggingface_hub.User.num_datasets",description:`<strong>num_datasets</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of datasets created by the user.`,name:"num_datasets"},{anchor:"huggingface_hub.User.num_spaces",description:`<strong>num_spaces</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of spaces created by the user.`,name:"num_spaces"},{anchor:"huggingface_hub.User.num_discussions",description:`<strong>num_discussions</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of discussions initiated by the user.`,name:"num_discussions"},{anchor:"huggingface_hub.User.num_papers",description:`<strong>num_papers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of papers authored by the user.`,name:"num_papers"},{anchor:"huggingface_hub.User.num_upvotes",description:`<strong>num_upvotes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of upvotes received by the user.`,name:"num_upvotes"},{anchor:"huggingface_hub.User.num_likes",description:`<strong>num_likes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of likes given by the user.`,name:"num_likes"},{anchor:"huggingface_hub.User.num_following",description:`<strong>num_following</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of users this user is following.`,name:"num_following"},{anchor:"huggingface_hub.User.num_followers",description:`<strong>num_followers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of users following this user.`,name:"num_followers"},{anchor:"huggingface_hub.User.orgs",description:`<strong>orgs</strong> (list of <code>Organization</code>) &#x2014;
List of organizations the user is part of.`,name:"orgs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1387"}}),yc=new R({props:{title:"UserLikes",local:"huggingface_hub.UserLikes ][ huggingface_hub.UserLikes",headingTag:"h3"}}),xc=new j({props:{name:"class huggingface_hub.UserLikes",anchor:"huggingface_hub.UserLikes",parameters:[{name:"user",val:": str"},{name:"total",val:": int"},{name:"datasets",val:": List[str]"},{name:"models",val:": List[str]"},{name:"spaces",val:": List[str]"}],parametersDescription:[{anchor:"huggingface_hub.UserLikes.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
Name of the user for which we fetched the likes.`,name:"user"},{anchor:"huggingface_hub.UserLikes.total",description:`<strong>total</strong> (<code>int</code>) &#x2014;
Total number of likes.`,name:"total"},{anchor:"huggingface_hub.UserLikes.datasets",description:`<strong>datasets</strong> (<code>List[str]</code>) &#x2014;
List of datasets liked by the user (as repo_ids).`,name:"datasets"},{anchor:"huggingface_hub.UserLikes.models",description:`<strong>models</strong> (<code>List[str]</code>) &#x2014;
List of models liked by the user (as repo_ids).`,name:"models"},{anchor:"huggingface_hub.UserLikes.spaces",description:`<strong>spaces</strong> (<code>List[str]</code>) &#x2014;
List of spaces liked by the user (as repo_ids).`,name:"spaces"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1332"}}),$c=new R({props:{title:"CommitOperation",local:"huggingface_hub.CommitOperationAdd ][ huggingface_hub.CommitOperationAdd",headingTag:"h2"}}),kc=new j({props:{name:"class huggingface_hub.CommitOperationAdd",anchor:"huggingface_hub.CommitOperationAdd",parameters:[{name:"path_in_repo",val:": str"},{name:"path_or_fileobj",val:": typing.Union[str, pathlib.Path, bytes, typing.BinaryIO]"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationAdd.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example: <code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitOperationAdd.path_or_fileobj",description:`<strong>path_or_fileobj</strong> (<code>str</code>, <code>Path</code>, <code>bytes</code>, or <code>BinaryIO</code>) &#x2014;
Either:<ul>
<li>a path to a local file (as <code>str</code> or <code>pathlib.Path</code>) to upload</li>
<li>a buffer of bytes (<code>bytes</code>) holding the content of the file to upload</li>
<li>a &#x201C;file object&#x201D; (subclass of <code>io.BufferedIOBase</code>), typically obtained
with <code>open(path, &quot;rb&quot;)</code>. It must support <code>seek()</code> and <code>tell()</code> methods.</li>
</ul>`,name:"path_or_fileobj"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L118",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>path_or_fileobj</code> is not one of <code>str</code>, <code>Path</code>, <code>bytes</code> or <code>io.BufferedIOBase</code>.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>path_or_fileobj</code> is a <code>str</code> or <code>Path</code> but not a path to an existing file.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>path_or_fileobj</code> is a <code>io.BufferedIOBase</code> but it doesn’t support both
<code>seek()</code> and <code>tell()</code>.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Tc=new j({props:{name:"as_file",anchor:"huggingface_hub.CommitOperationAdd.as_file",parameters:[{name:"with_tqdm",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationAdd.as_file.with_tqdm",description:`<strong>with_tqdm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True, iterating over the file object will display a progress bar. Only
works if the file-like object is a path to a file. Pure bytes and buffers
are not supported.`,name:"with_tqdm"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L201"}}),js=new U({props:{anchor:"huggingface_hub.CommitOperationAdd.as_file.example",$$slots:{default:[bM]},$$scope:{ctx:T}}}),qc=new j({props:{name:"b64content",anchor:"huggingface_hub.CommitOperationAdd.b64content",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L251"}}),Mc=new j({props:{name:"class huggingface_hub.CommitOperationDelete",anchor:"huggingface_hub.CommitOperationDelete",parameters:[{name:"path_in_repo",val:": str"},{name:"is_folder",val:": typing.Union[bool, typing.Literal['auto']] = 'auto'"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationDelete.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example: <code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>
for a file or <code>&quot;checkpoints/1fec34a/&quot;</code> for a folder.`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitOperationDelete.is_folder",description:`<strong>is_folder</strong> (<code>bool</code> or <code>Literal[&quot;auto&quot;]</code>, <em>optional</em>) &#x2014;
Whether the Delete Operation applies to a folder or not. If &#x201C;auto&#x201D;, the path
type (file or folder) is guessed automatically by looking if path ends with
a &#x201D;/&#x201D; (folder) or not (file). To explicitly set the path type, you can set
<code>is_folder=True</code> or <code>is_folder=False</code>.`,name:"is_folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L51"}}),jc=new j({props:{name:"class huggingface_hub.CommitOperationCopy",anchor:"huggingface_hub.CommitOperationCopy",parameters:[{name:"src_path_in_repo",val:": str"},{name:"path_in_repo",val:": str"},{name:"src_revision",val:": typing.Optional[str] = None"},{name:"_src_oid",val:": typing.Optional[str] = None"},{name:"_dest_oid",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationCopy.src_path_in_repo",description:`<strong>src_path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo of the file to be copied, e.g. <code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>.`,name:"src_path_in_repo"},{anchor:"huggingface_hub.CommitOperationCopy.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo where to copy the file, e.g. <code>&quot;checkpoints/1fec34a/weights_copy.bin&quot;</code>.`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitOperationCopy.src_revision",description:`<strong>src_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision of the file to be copied. Can be any valid git revision.
Default to the target commit revision.`,name:"src_revision"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L82"}}),Hc=new R({props:{title:"CommitScheduler",local:"huggingface_hub.CommitScheduler ][ huggingface_hub.CommitScheduler",headingTag:"h2"}}),Cc=new j({props:{name:"class huggingface_hub.CommitScheduler",anchor:"huggingface_hub.CommitScheduler",parameters:[{name:"repo_id",val:": str"},{name:"folder_path",val:": typing.Union[str, pathlib.Path]"},{name:"every",val:": typing.Union[int, float] = 5"},{name:"path_in_repo",val:": typing.Optional[str] = None"},{name:"repo_type",val:": typing.Optional[str] = None"},{name:"revision",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"allow_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"ignore_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"squash_history",val:": bool = False"},{name:"hf_api",val:": typing.Optional[ForwardRef('HfApi')] = None"}],parametersDescription:[{anchor:"huggingface_hub.CommitScheduler.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to commit to.`,name:"repo_id"},{anchor:"huggingface_hub.CommitScheduler.folder_path",description:`<strong>folder_path</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to the local folder to upload regularly.`,name:"folder_path"},{anchor:"huggingface_hub.CommitScheduler.every",description:`<strong>every</strong> (<code>int</code> or <code>float</code>, <em>optional</em>) &#x2014;
The number of minutes between each commit. Defaults to 5 minutes.`,name:"every"},{anchor:"huggingface_hub.CommitScheduler.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Relative path of the directory in the repo, for example: <code>&quot;checkpoints/&quot;</code>. Defaults to the root folder
of the repository.`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitScheduler.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to commit to. Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.CommitScheduler.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repo to commit to. Defaults to <code>main</code>.`,name:"revision"},{anchor:"huggingface_hub.CommitScheduler.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to make the repo private. If <code>None</code> (default), the repo will be public unless the organization&#x2019;s default is private. This value is ignored if the repo already exists.`,name:"private"},{anchor:"huggingface_hub.CommitScheduler.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use to commit to the repo. Defaults to the token saved on the machine.`,name:"token"},{anchor:"huggingface_hub.CommitScheduler.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are uploaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.CommitScheduler.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not uploaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.CommitScheduler.squash_history",description:`<strong>squash_history</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to squash the history of the repo after each commit. Defaults to <code>False</code>. Squashing commits is
useful to avoid degraded performances on the repo when it grows too large.`,name:"squash_history"},{anchor:"huggingface_hub.CommitScheduler.hf_api",description:`<strong>hf_api</strong> (<code>HfApi</code>, <em>optional</em>) &#x2014;
The <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> client to use to commit to the Hub. Can be set with custom settings (user agent, token,&#x2026;).`,name:"hf_api"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L29"}}),Hs=new U({props:{anchor:"huggingface_hub.CommitScheduler.example",$$slots:{default:[vM]},$$scope:{ctx:T}}}),Cs=new U({props:{anchor:"huggingface_hub.CommitScheduler.example-2",$$slots:{default:[yM]},$$scope:{ctx:T}}}),Uc=new j({props:{name:"push_to_hub",anchor:"huggingface_hub.CommitScheduler.push_to_hub",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L204"}}),Us=new I({props:{warning:!0,$$slots:{default:[xM]},$$scope:{ctx:T}}}),Ic=new j({props:{name:"stop",anchor:"huggingface_hub.CommitScheduler.stop",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L157"}}),Ac=new j({props:{name:"trigger",anchor:"huggingface_hub.CommitScheduler.trigger",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L181"}}),Nc=new U0({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/ko/package_reference/hf_api.md"}}),{c(){o=c("meta"),v=s(),i=c("p"),a=s(),u(g.$$.fragment),e=s(),x=c("p"),x.innerHTML=E2,Ku=s(),Ds=c("p"),Ds.innerHTML=D2,eh=s(),Rs=c("p"),Rs.innerHTML=R2,th=s(),u(Fs.$$.fragment),nh=s(),u(Ss.$$.fragment),oh=s(),w=c("div"),u(Gs.$$.fragment),tf=s(),el=c("p"),el.textContent=F2,nf=s(),tl=c("p"),tl.innerHTML=S2,of=s(),Me=c("div"),u(Ls.$$.fragment),af=s(),nl=c("p"),nl.textContent=G2,sf=s(),ol=c("p"),ol.innerHTML=L2,rf=s(),al=c("p"),al.innerHTML=Z2,cf=s(),je=c("div"),u(Zs.$$.fragment),lf=s(),sl=c("p"),sl.textContent=V2,pf=s(),rl=c("p"),rl.innerHTML=P2,df=s(),u($o.$$.fragment),gf=s(),Wt=c("div"),u(Vs.$$.fragment),uf=s(),il=c("p"),il.textContent=W2,hf=s(),cl=c("p"),cl.innerHTML=B2,ff=s(),Bt=c("div"),u(Ps.$$.fragment),mf=s(),ll=c("p"),ll.textContent=Y2,_f=s(),pl=c("p"),pl.innerHTML=X2,bf=s(),F=c("div"),u(Ws.$$.fragment),vf=s(),dl=c("p"),dl.textContent=z2,yf=s(),gl=c("p"),gl.textContent=O2,xf=s(),ul=c("p"),ul.textContent=Q2,$f=s(),u(wo.$$.fragment),wf=s(),hl=c("p"),hl.textContent=K2,kf=s(),fl=c("ul"),fl.innerHTML=e1,Tf=s(),He=c("div"),u(Bs.$$.fragment),qf=s(),ml=c("p"),ml.textContent=t1,Mf=s(),_l=c("p"),_l.textContent=n1,jf=s(),bl=c("p"),bl.innerHTML=o1,Hf=s(),Ce=c("div"),u(Ys.$$.fragment),Cf=s(),vl=c("p"),vl.textContent=a1,Uf=s(),u(ko.$$.fragment),If=s(),u(To.$$.fragment),Af=s(),Ue=c("div"),u(Xs.$$.fragment),Nf=s(),yl=c("p"),yl.textContent=s1,Jf=s(),u(qo.$$.fragment),Ef=s(),u(Mo.$$.fragment),Df=s(),jo=c("div"),u(zs.$$.fragment),Rf=s(),xl=c("p"),xl.innerHTML=r1,Ff=s(),Ie=c("div"),u(Os.$$.fragment),Sf=s(),$l=c("p"),$l.textContent=i1,Gf=s(),wl=c("p"),wl.innerHTML=c1,Lf=s(),u(Ho.$$.fragment),Zf=s(),ae=c("div"),u(Qs.$$.fragment),Vf=s(),kl=c("p"),kl.textContent=l1,Pf=s(),u(Co.$$.fragment),Wf=s(),u(Uo.$$.fragment),Bf=s(),u(Io.$$.fragment),Yf=s(),Z=c("div"),u(Ks.$$.fragment),Xf=s(),Tl=c("p"),Tl.textContent=p1,zf=s(),ql=c("p"),ql.innerHTML=d1,Of=s(),Ml=c("p"),Ml.innerHTML=g1,Qf=s(),jl=c("p"),jl.innerHTML=u1,Kf=s(),u(Ao.$$.fragment),em=s(),Ae=c("div"),u(er.$$.fragment),tm=s(),Hl=c("p"),Hl.textContent=h1,nm=s(),u(No.$$.fragment),om=s(),u(Jo.$$.fragment),am=s(),Ne=c("div"),u(tr.$$.fragment),sm=s(),Cl=c("p"),Cl.textContent=f1,rm=s(),Ul=c("p"),Ul.innerHTML=m1,im=s(),u(Eo.$$.fragment),cm=s(),V=c("div"),u(nr.$$.fragment),lm=s(),Il=c("p"),Il.innerHTML=_1,pm=s(),Al=c("p"),Al.innerHTML=b1,dm=s(),Nl=c("p"),Nl.innerHTML=v1,gm=s(),Jl=c("p"),Jl.innerHTML=y1,um=s(),u(Do.$$.fragment),hm=s(),Ro=c("div"),u(or.$$.fragment),fm=s(),El=c("p"),El.textContent=x1,mm=s(),Fo=c("div"),u(ar.$$.fragment),_m=s(),Dl=c("p"),Dl.textContent=$1,bm=s(),Yt=c("div"),u(sr.$$.fragment),vm=s(),Rl=c("p"),Rl.textContent=w1,ym=s(),u(So.$$.fragment),xm=s(),Je=c("div"),u(rr.$$.fragment),$m=s(),Fl=c("p"),Fl.textContent=k1,wm=s(),Sl=c("p"),Sl.textContent=T1,km=s(),u(Go.$$.fragment),Tm=s(),Lo=c("div"),u(ir.$$.fragment),qm=s(),Gl=c("p"),Gl.textContent=q1,Mm=s(),Ee=c("div"),u(cr.$$.fragment),jm=s(),Ll=c("p"),Ll.textContent=M1,Hm=s(),u(Zo.$$.fragment),Cm=s(),u(Vo.$$.fragment),Um=s(),Xt=c("div"),u(lr.$$.fragment),Im=s(),Zl=c("p"),Zl.textContent=j1,Am=s(),u(Po.$$.fragment),Nm=s(),zt=c("div"),u(pr.$$.fragment),Jm=s(),Vl=c("p"),Vl.textContent=H1,Em=s(),u(Wo.$$.fragment),Dm=s(),Ot=c("div"),u(dr.$$.fragment),Rm=s(),Pl=c("p"),Pl.textContent=C1,Fm=s(),Wl=c("p"),Wl.textContent=U1,Sm=s(),Qt=c("div"),u(gr.$$.fragment),Gm=s(),Bl=c("p"),Bl.textContent=I1,Lm=s(),Yl=c("p"),Yl.innerHTML=A1,Zm=s(),De=c("div"),u(ur.$$.fragment),Vm=s(),Xl=c("p"),Xl.textContent=N1,Pm=s(),zl=c("p"),zl.innerHTML=J1,Wm=s(),Ol=c("p"),Ol.innerHTML=E1,Bm=s(),Bo=c("div"),u(hr.$$.fragment),Ym=s(),Ql=c("p"),Ql.textContent=D1,Xm=s(),Kt=c("div"),u(fr.$$.fragment),zm=s(),Kl=c("p"),Kl.textContent=R1,Om=s(),ep=c("p"),ep.innerHTML=F1,Qm=s(),Yo=c("div"),u(mr.$$.fragment),Km=s(),tp=c("p"),tp.textContent=S1,e_=s(),en=c("div"),u(_r.$$.fragment),t_=s(),np=c("p"),np.textContent=G1,n_=s(),op=c("p"),op.innerHTML=L1,o_=s(),Xo=c("div"),u(br.$$.fragment),a_=s(),ap=c("p"),ap.textContent=Z1,s_=s(),tn=c("div"),u(vr.$$.fragment),r_=s(),sp=c("p"),sp.textContent=V1,i_=s(),u(zo.$$.fragment),c_=s(),nn=c("div"),u(yr.$$.fragment),l_=s(),rp=c("p"),rp.textContent=P1,p_=s(),u(Oo.$$.fragment),d_=s(),Re=c("div"),u(xr.$$.fragment),g_=s(),ip=c("p"),ip.textContent=W1,u_=s(),cp=c("p"),cp.textContent=B1,h_=s(),u(Qo.$$.fragment),f_=s(),on=c("div"),u($r.$$.fragment),m_=s(),lp=c("p"),lp.textContent=Y1,__=s(),u(Ko.$$.fragment),b_=s(),an=c("div"),u(wr.$$.fragment),v_=s(),pp=c("p"),pp.textContent=X1,y_=s(),u(ea.$$.fragment),x_=s(),sn=c("div"),u(kr.$$.fragment),$_=s(),dp=c("p"),dp.textContent=z1,w_=s(),u(ta.$$.fragment),k_=s(),Fe=c("div"),u(Tr.$$.fragment),T_=s(),gp=c("p"),gp.textContent=O1,q_=s(),up=c("p"),up.innerHTML=Q1,M_=s(),u(na.$$.fragment),j_=s(),oa=c("div"),u(qr.$$.fragment),H_=s(),hp=c("p"),hp.textContent=K1,C_=s(),Se=c("div"),u(Mr.$$.fragment),U_=s(),fp=c("p"),fp.textContent=ew,I_=s(),mp=c("p"),mp.innerHTML=tw,A_=s(),u(aa.$$.fragment),N_=s(),sa=c("div"),u(jr.$$.fragment),J_=s(),_p=c("p"),_p.textContent=nw,E_=s(),ra=c("div"),u(Hr.$$.fragment),D_=s(),bp=c("p"),bp.textContent=ow,R_=s(),rn=c("div"),u(Cr.$$.fragment),F_=s(),vp=c("p"),vp.textContent=aw,S_=s(),u(ia.$$.fragment),G_=s(),ca=c("div"),u(Ur.$$.fragment),L_=s(),yp=c("p"),yp.textContent=sw,Z_=s(),cn=c("div"),u(Ir.$$.fragment),V_=s(),xp=c("p"),xp.textContent=rw,P_=s(),u(la.$$.fragment),W_=s(),se=c("div"),u(Ar.$$.fragment),B_=s(),$p=c("p"),$p.textContent=iw,Y_=s(),wp=c("p"),wp.textContent=cw,X_=s(),u(pa.$$.fragment),z_=s(),u(da.$$.fragment),O_=s(),P=c("div"),u(Nr.$$.fragment),Q_=s(),kp=c("p"),kp.textContent=lw,K_=s(),Tp=c("p"),Tp.textContent=pw,eb=s(),qp=c("p"),qp.innerHTML=dw,tb=s(),Mp=c("p"),Mp.innerHTML=gw,nb=s(),u(ga.$$.fragment),ob=s(),ua=c("div"),u(Jr.$$.fragment),ab=s(),jp=c("p"),jp.textContent=uw,sb=s(),ln=c("div"),u(Er.$$.fragment),rb=s(),Hp=c("p"),Hp.textContent=hw,ib=s(),Cp=c("p"),Cp.innerHTML=fw,cb=s(),Ge=c("div"),u(Dr.$$.fragment),lb=s(),Up=c("p"),Up.innerHTML=mw,pb=s(),u(ha.$$.fragment),db=s(),Ip=c("p"),Ip.innerHTML=_w,gb=s(),fa=c("div"),u(Rr.$$.fragment),ub=s(),Ap=c("p"),Ap.textContent=bw,hb=s(),pn=c("div"),u(Fr.$$.fragment),fb=s(),Np=c("p"),Np.textContent=vw,mb=s(),u(ma.$$.fragment),_b=s(),Le=c("div"),u(Sr.$$.fragment),bb=s(),Jp=c("p"),Jp.textContent=yw,vb=s(),Ep=c("p"),Ep.innerHTML=xw,yb=s(),Dp=c("p"),Dp.innerHTML=$w,xb=s(),W=c("div"),u(Gr.$$.fragment),$b=s(),Rp=c("p"),Rp.textContent=ww,wb=s(),Fp=c("p"),Fp.textContent=kw,kb=s(),Sp=c("ul"),Sp.innerHTML=Tw,Tb=s(),u(_a.$$.fragment),qb=s(),Gp=c("p"),Gp.innerHTML=qw,Mb=s(),Ze=c("div"),u(Lr.$$.fragment),jb=s(),Lp=c("p"),Lp.textContent=Mw,Hb=s(),u(ba.$$.fragment),Cb=s(),u(va.$$.fragment),Ub=s(),re=c("div"),u(Zr.$$.fragment),Ib=s(),Zp=c("p"),Zp.textContent=jw,Ab=s(),Vp=c("p"),Vp.innerHTML=Hw,Nb=s(),Pp=c("p"),Pp.innerHTML=Cw,Jb=s(),u(ya.$$.fragment),Eb=s(),dn=c("div"),u(Vr.$$.fragment),Db=s(),Wp=c("p"),Wp.textContent=Uw,Rb=s(),u(xa.$$.fragment),Fb=s(),Ve=c("div"),u(Pr.$$.fragment),Sb=s(),Bp=c("p"),Bp.textContent=Iw,Gb=s(),u($a.$$.fragment),Lb=s(),u(wa.$$.fragment),Zb=s(),ie=c("div"),u(Wr.$$.fragment),Vb=s(),Yp=c("p"),Yp.textContent=Aw,Pb=s(),Xp=c("p"),Xp.innerHTML=Nw,Wb=s(),zp=c("p"),zp.innerHTML=Jw,Bb=s(),u(ka.$$.fragment),Yb=s(),gn=c("div"),u(Br.$$.fragment),Xb=s(),Op=c("p"),Op.textContent=Ew,zb=s(),u(Ta.$$.fragment),Ob=s(),ce=c("div"),u(Yr.$$.fragment),Qb=s(),Qp=c("p"),Qp.textContent=Dw,Kb=s(),Kp=c("p"),Kp.innerHTML=Rw,ev=s(),ed=c("p"),ed.innerHTML=Fw,tv=s(),u(qa.$$.fragment),nv=s(),Pe=c("div"),u(Xr.$$.fragment),ov=s(),td=c("p"),td.textContent=Sw,av=s(),u(Ma.$$.fragment),sv=s(),u(ja.$$.fragment),rv=s(),Ha=c("div"),u(zr.$$.fragment),iv=s(),nd=c("p"),nd.textContent=Gw,cv=s(),un=c("div"),u(Or.$$.fragment),lv=s(),od=c("p"),od.textContent=Lw,pv=s(),u(Ca.$$.fragment),dv=s(),le=c("div"),u(Qr.$$.fragment),gv=s(),ad=c("p"),ad.textContent=Zw,uv=s(),sd=c("p"),sd.innerHTML=Vw,hv=s(),rd=c("p"),rd.innerHTML=Pw,fv=s(),u(Ua.$$.fragment),mv=s(),pe=c("div"),u(Kr.$$.fragment),_v=s(),id=c("p"),id.textContent=Ww,bv=s(),cd=c("p"),cd.innerHTML=Bw,vv=s(),ld=c("p"),ld.innerHTML=Yw,yv=s(),u(Ia.$$.fragment),xv=s(),We=c("div"),u(ei.$$.fragment),$v=s(),pd=c("p"),pd.textContent=Xw,wv=s(),dd=c("p"),dd.textContent=zw,kv=s(),u(Aa.$$.fragment),Tv=s(),Na=c("div"),u(ti.$$.fragment),qv=s(),gd=c("p"),gd.textContent=Ow,Mv=s(),hn=c("div"),u(ni.$$.fragment),jv=s(),ud=c("p"),ud.textContent=Qw,Hv=s(),hd=c("p"),hd.innerHTML=Kw,Cv=s(),fn=c("div"),u(oi.$$.fragment),Uv=s(),fd=c("p"),fd.textContent=ek,Iv=s(),u(Ja.$$.fragment),Av=s(),S=c("div"),u(ai.$$.fragment),Nv=s(),md=c("p"),md.textContent=tk,Jv=s(),_d=c("p"),_d.textContent=nk,Ev=s(),bd=c("p"),bd.textContent=ok,Dv=s(),u(Ea.$$.fragment),Rv=s(),vd=c("p"),vd.textContent=ak,Fv=s(),u(Da.$$.fragment),Sv=s(),Ra=c("div"),u(si.$$.fragment),Gv=s(),yd=c("p"),yd.textContent=sk,Lv=s(),Fa=c("div"),u(ri.$$.fragment),Zv=s(),xd=c("p"),xd.textContent=rk,Vv=s(),Sa=c("div"),u(ii.$$.fragment),Pv=s(),$d=c("p"),$d.textContent=ik,Wv=s(),mn=c("div"),u(ci.$$.fragment),Bv=s(),wd=c("p"),wd.textContent=ck,Yv=s(),u(Ga.$$.fragment),Xv=s(),_n=c("div"),u(li.$$.fragment),zv=s(),kd=c("p"),kd.textContent=lk,Ov=s(),u(La.$$.fragment),Qv=s(),Be=c("div"),u(pi.$$.fragment),Kv=s(),Td=c("p"),Td.textContent=pk,ey=s(),qd=c("p"),qd.textContent=dk,ty=s(),u(Za.$$.fragment),ny=s(),Ye=c("div"),u(di.$$.fragment),oy=s(),Md=c("p"),Md.textContent=gk,ay=s(),jd=c("p"),jd.innerHTML=uk,sy=s(),u(Va.$$.fragment),ry=s(),Pa=c("div"),u(gi.$$.fragment),iy=s(),Hd=c("p"),Hd.textContent=hk,cy=s(),Xe=c("div"),u(ui.$$.fragment),ly=s(),Cd=c("p"),Cd.textContent=fk,py=s(),Ud=c("p"),Ud.innerHTML=mk,dy=s(),Id=c("p"),Id.innerHTML=_k,gy=s(),ze=c("div"),u(hi.$$.fragment),uy=s(),Ad=c("p"),Ad.textContent=bk,hy=s(),Nd=c("p"),Nd.innerHTML=vk,fy=s(),Jd=c("p"),Jd.innerHTML=yk,my=s(),Oe=c("div"),u(fi.$$.fragment),_y=s(),Ed=c("p"),Ed.textContent=xk,by=s(),Dd=c("p"),Dd.innerHTML=$k,vy=s(),Rd=c("p"),Rd.innerHTML=wk,yy=s(),B=c("div"),u(mi.$$.fragment),xy=s(),Fd=c("p"),Fd.textContent=kk,$y=s(),Sd=c("p"),Sd.textContent=Tk,wy=s(),u(Wa.$$.fragment),ky=s(),u(Ba.$$.fragment),Ty=s(),u(Ya.$$.fragment),qy=s(),Qe=c("div"),u(_i.$$.fragment),My=s(),Gd=c("p"),Gd.textContent=qk,jy=s(),Ld=c("p"),Ld.innerHTML=Mk,Hy=s(),Zd=c("p"),Zd.innerHTML=jk,Cy=s(),Ke=c("div"),u(bi.$$.fragment),Uy=s(),Vd=c("p"),Vd.textContent=Hk,Iy=s(),u(Xa.$$.fragment),Ay=s(),u(za.$$.fragment),Ny=s(),bn=c("div"),u(vi.$$.fragment),Jy=s(),Pd=c("p"),Pd.textContent=Ck,Ey=s(),u(Oa.$$.fragment),Dy=s(),vn=c("div"),u(yi.$$.fragment),Ry=s(),Wd=c("p"),Wd.textContent=Uk,Fy=s(),u(Qa.$$.fragment),Sy=s(),yn=c("div"),u(xi.$$.fragment),Gy=s(),Bd=c("p"),Bd.textContent=Ik,Ly=s(),u(Ka.$$.fragment),Zy=s(),xn=c("div"),u($i.$$.fragment),Vy=s(),Yd=c("p"),Yd.textContent=Ak,Py=s(),u(es.$$.fragment),Wy=s(),et=c("div"),u(wi.$$.fragment),By=s(),Xd=c("p"),Xd.textContent=Nk,Yy=s(),zd=c("p"),zd.innerHTML=Jk,Xy=s(),Od=c("p"),Od.innerHTML=Ek,zy=s(),$n=c("div"),u(ki.$$.fragment),Oy=s(),Qd=c("p"),Qd.textContent=Dk,Qy=s(),Kd=c("p"),Kd.innerHTML=Rk,Ky=s(),wn=c("div"),u(Ti.$$.fragment),ex=s(),eg=c("p"),eg.textContent=Fk,tx=s(),u(ts.$$.fragment),nx=s(),de=c("div"),u(qi.$$.fragment),ox=s(),tg=c("p"),tg.textContent=Sk,ax=s(),ng=c("p"),ng.innerHTML=Gk,sx=s(),og=c("p"),og.innerHTML=Lk,rx=s(),u(ns.$$.fragment),ix=s(),tt=c("div"),u(Mi.$$.fragment),cx=s(),ag=c("p"),ag.textContent=Zk,lx=s(),sg=c("p"),sg.innerHTML=Vk,px=s(),rg=c("p"),rg.innerHTML=Pk,dx=s(),nt=c("div"),u(ji.$$.fragment),gx=s(),ig=c("p"),ig.textContent=Wk,ux=s(),cg=c("p"),cg.innerHTML=Bk,hx=s(),u(os.$$.fragment),fx=s(),ge=c("div"),u(Hi.$$.fragment),mx=s(),lg=c("p"),lg.textContent=Yk,_x=s(),pg=c("p"),pg.innerHTML=Xk,bx=s(),dg=c("p"),dg.innerHTML=zk,vx=s(),gg=c("p"),gg.textContent=Ok,yx=s(),ot=c("div"),u(Ci.$$.fragment),xx=s(),ug=c("p"),ug.textContent=Qk,$x=s(),hg=c("p"),hg.textContent=Kk,wx=s(),u(as.$$.fragment),kx=s(),Y=c("div"),u(Ui.$$.fragment),Tx=s(),fg=c("p"),fg.textContent=eT,qx=s(),mg=c("p"),mg.textContent=tT,Mx=s(),u(ss.$$.fragment),jx=s(),u(rs.$$.fragment),Hx=s(),u(is.$$.fragment),Cx=s(),ue=c("div"),u(Ii.$$.fragment),Ux=s(),_g=c("p"),_g.textContent=nT,Ix=s(),bg=c("p"),bg.innerHTML=oT,Ax=s(),vg=c("p"),vg.innerHTML=aT,Nx=s(),u(cs.$$.fragment),Jx=s(),kn=c("div"),u(Ai.$$.fragment),Ex=s(),yg=c("p"),yg.textContent=sT,Dx=s(),u(ls.$$.fragment),Rx=s(),he=c("div"),u(Ni.$$.fragment),Fx=s(),xg=c("p"),xg.textContent=rT,Sx=s(),$g=c("p"),$g.textContent=iT,Gx=s(),wg=c("p"),wg.innerHTML=cT,Lx=s(),u(ps.$$.fragment),Zx=s(),at=c("div"),u(Ji.$$.fragment),Vx=s(),kg=c("p"),kg.textContent=lT,Px=s(),Tg=c("p"),Tg.textContent=pT,Wx=s(),qg=c("p"),qg.innerHTML=dT,Bx=s(),Tn=c("div"),u(Ei.$$.fragment),Yx=s(),Mg=c("p"),Mg.textContent=gT,Xx=s(),jg=c("p"),jg.textContent=uT,zx=s(),st=c("div"),u(Di.$$.fragment),Ox=s(),Hg=c("p"),Hg.textContent=hT,Qx=s(),Cg=c("p"),Cg.innerHTML=fT,Kx=s(),u(ds.$$.fragment),e$=s(),qn=c("div"),u(Ri.$$.fragment),t$=s(),Ug=c("p"),Ug.textContent=mT,n$=s(),u(gs.$$.fragment),o$=s(),fe=c("div"),u(Fi.$$.fragment),a$=s(),Ig=c("p"),Ig.textContent=_T,s$=s(),u(us.$$.fragment),r$=s(),u(hs.$$.fragment),i$=s(),u(fs.$$.fragment),c$=s(),N=c("div"),u(Si.$$.fragment),l$=s(),Ag=c("p"),Ag.textContent=bT,p$=s(),Ng=c("p"),Ng.textContent=vT,d$=s(),Jg=c("p"),Jg.innerHTML=yT,g$=s(),Eg=c("p"),Eg.innerHTML=xT,u$=s(),Dg=c("p"),Dg.innerHTML=$T,h$=s(),Rg=c("p"),Rg.innerHTML=wT,f$=s(),u(ms.$$.fragment),m$=s(),u(_s.$$.fragment),_$=s(),u(bs.$$.fragment),b$=s(),u(vs.$$.fragment),v$=s(),A=c("div"),u(Gi.$$.fragment),y$=s(),Fg=c("p"),Fg.textContent=kT,x$=s(),Sg=c("p"),Sg.innerHTML=TT,$$=s(),u(ys.$$.fragment),w$=s(),u(xs.$$.fragment),k$=s(),Gg=c("p"),Gg.innerHTML=qT,T$=s(),Lg=c("p"),Lg.innerHTML=MT,q$=s(),Zg=c("ol"),Zg.innerHTML=jT,M$=s(),Vg=c("p"),Vg.textContent=HT,j$=s(),Pg=c("ol"),Pg.innerHTML=CT,H$=s(),Wg=c("p"),Wg.textContent=UT,C$=s(),Bg=c("ul"),Bg.innerHTML=IT,U$=s(),$s=c("div"),u(Li.$$.fragment),I$=s(),Yg=c("p"),Yg.textContent=AT,ah=s(),u(Zi.$$.fragment),sh=s(),u(Vi.$$.fragment),rh=s(),Dn=c("div"),u(Pi.$$.fragment),A$=s(),Xg=c("p"),Xg.textContent=NT,ih=s(),u(Wi.$$.fragment),ch=s(),ct=c("div"),u(Bi.$$.fragment),N$=s(),zg=c("p"),zg.textContent=JT,J$=s(),Og=c("p"),Og.innerHTML=ET,lh=s(),u(Yi.$$.fragment),ph=s(),lt=c("div"),u(Xi.$$.fragment),E$=s(),Qg=c("p"),Qg.textContent=DT,D$=s(),u(ws.$$.fragment),dh=s(),u(zi.$$.fragment),gh=s(),Rn=c("div"),u(Oi.$$.fragment),R$=s(),Kg=c("p"),Kg.textContent=RT,uh=s(),u(Qi.$$.fragment),hh=s(),Fn=c("div"),u(Ki.$$.fragment),F$=s(),eu=c("p"),eu.innerHTML=FT,fh=s(),u(ec.$$.fragment),mh=s(),pt=c("div"),u(tc.$$.fragment),S$=s(),tu=c("p"),tu.textContent=ST,G$=s(),nu=c("p"),nu.innerHTML=GT,_h=s(),u(nc.$$.fragment),bh=s(),dt=c("div"),u(oc.$$.fragment),L$=s(),ou=c("p"),ou.textContent=LT,Z$=s(),u(ks.$$.fragment),vh=s(),u(ac.$$.fragment),yh=s(),gt=c("div"),u(sc.$$.fragment),V$=s(),au=c("p"),au.textContent=ZT,P$=s(),u(Ts.$$.fragment),xh=s(),u(rc.$$.fragment),$h=s(),Sn=c("div"),u(ic.$$.fragment),W$=s(),su=c("p"),su.textContent=VT,wh=s(),u(cc.$$.fragment),kh=s(),z=c("div"),u(lc.$$.fragment),B$=s(),ru=c("p"),ru.innerHTML=PT,Y$=s(),iu=c("p"),iu.innerHTML=WT,X$=s(),cu=c("ul"),cu.innerHTML=BT,z$=s(),u(qs.$$.fragment),Th=s(),u(pc.$$.fragment),qh=s(),O=c("div"),u(dc.$$.fragment),O$=s(),lu=c("p"),lu.textContent=YT,Q$=s(),pu=c("p"),pu.textContent=XT,K$=s(),du=c("p"),du.innerHTML=zT,e2=s(),gu=c("p"),gu.innerHTML=OT,Mh=s(),u(gc.$$.fragment),jh=s(),me=c("div"),u(uc.$$.fragment),t2=s(),uu=c("p"),uu.textContent=QT,n2=s(),hu=c("p"),hu.innerHTML=KT,o2=s(),fu=c("p"),fu.innerHTML=e0,Hh=s(),u(hc.$$.fragment),Ch=s(),ut=c("div"),u(fc.$$.fragment),a2=s(),mu=c("p"),mu.textContent=t0,s2=s(),u(Ms.$$.fragment),Uh=s(),u(mc.$$.fragment),Ih=s(),ht=c("div"),u(_c.$$.fragment),r2=s(),_u=c("p"),_u.textContent=n0,i2=s(),bu=c("p"),bu.innerHTML=o0,Ah=s(),u(bc.$$.fragment),Nh=s(),Gn=c("div"),u(vc.$$.fragment),c2=s(),vu=c("p"),vu.textContent=a0,Jh=s(),u(yc.$$.fragment),Eh=s(),Ln=c("div"),u(xc.$$.fragment),l2=s(),yu=c("p"),yu.textContent=s0,Dh=s(),u($c.$$.fragment),Rh=s(),wc=c("p"),wc.innerHTML=r0,Fh=s(),_e=c("div"),u(kc.$$.fragment),p2=s(),xu=c("p"),xu.textContent=i0,d2=s(),Mn=c("div"),u(Tc.$$.fragment),g2=s(),$u=c("p"),$u.innerHTML=c0,u2=s(),u(js.$$.fragment),h2=s(),jn=c("div"),u(qc.$$.fragment),f2=s(),wu=c("p"),wu.innerHTML=l0,m2=s(),ku=c("p"),ku.innerHTML=p0,Sh=s(),Zn=c("div"),u(Mc.$$.fragment),_2=s(),Tu=c("p"),Tu.textContent=d0,Gh=s(),Q=c("div"),u(jc.$$.fragment),b2=s(),qu=c("p"),qu.textContent=g0,v2=s(),Mu=c("p"),Mu.textContent=u0,y2=s(),ju=c("ul"),ju.innerHTML=h0,x2=s(),Hu=c("p"),Hu.innerHTML=f0,Lh=s(),u(Hc.$$.fragment),Zh=s(),D=c("div"),u(Cc.$$.fragment),$2=s(),Cu=c("p"),Cu.textContent=m0,w2=s(),Uu=c("p"),Uu.innerHTML=_0,k2=s(),u(Hs.$$.fragment),T2=s(),u(Cs.$$.fragment),q2=s(),rt=c("div"),u(Uc.$$.fragment),M2=s(),Iu=c("p"),Iu.textContent=b0,j2=s(),u(Us.$$.fragment),H2=s(),Au=c("p"),Au.innerHTML=v0,C2=s(),Hn=c("div"),u(Ic.$$.fragment),U2=s(),Nu=c("p"),Nu.textContent=y0,I2=s(),Ju=c("p"),Ju.textContent=x0,A2=s(),Cn=c("div"),u(Ac.$$.fragment),N2=s(),Eu=c("p"),Eu.innerHTML=$0,J2=s(),Du=c("p"),Du.innerHTML=w0,Vh=s(),u(Nc.$$.fragment),Ph=s(),Qu=c("p"),this.h()},l(t){const y=j0("svelte-u9bgzb",document.head);o=l(y,"META",{name:!0,content:!0}),y.forEach(p),v=r(t),i=l(t,"P",{}),q(i).forEach(p),a=r(t),h(g.$$.fragment,t),e=r(t),x=l(t,"P",{"data-svelte-h":!0}),d(x)!=="svelte-6ncsww"&&(x.innerHTML=E2),Ku=r(t),Ds=l(t,"P",{"data-svelte-h":!0}),d(Ds)!=="svelte-fytuye"&&(Ds.innerHTML=D2),eh=r(t),Rs=l(t,"P",{"data-svelte-h":!0}),d(Rs)!=="svelte-2nagd6"&&(Rs.innerHTML=R2),th=r(t),h(Fs.$$.fragment,t),nh=r(t),h(Ss.$$.fragment,t),oh=r(t),w=l(t,"DIV",{class:!0});var k=q(w);h(Gs.$$.fragment,k),tf=r(k),el=l(k,"P",{"data-svelte-h":!0}),d(el)!=="svelte-868tea"&&(el.textContent=F2),nf=r(k),tl=l(k,"P",{"data-svelte-h":!0}),d(tl)!=="svelte-mq1mm2"&&(tl.innerHTML=S2),of=r(k),Me=l(k,"DIV",{class:!0});var ft=q(Me);h(Ls.$$.fragment,ft),af=r(ft),nl=l(ft,"P",{"data-svelte-h":!0}),d(nl)!=="svelte-nwim5u"&&(nl.textContent=G2),sf=r(ft),ol=l(ft,"P",{"data-svelte-h":!0}),d(ol)!=="svelte-jkya6j"&&(ol.innerHTML=L2),rf=r(ft),al=l(ft,"P",{"data-svelte-h":!0}),d(al)!=="svelte-xxbgtf"&&(al.innerHTML=Z2),ft.forEach(p),cf=r(k),je=l(k,"DIV",{class:!0});var mt=q(je);h(Zs.$$.fragment,mt),lf=r(mt),sl=l(mt,"P",{"data-svelte-h":!0}),d(sl)!=="svelte-pl69v6"&&(sl.textContent=V2),pf=r(mt),rl=l(mt,"P",{"data-svelte-h":!0}),d(rl)!=="svelte-17aw16u"&&(rl.innerHTML=P2),df=r(mt),h($o.$$.fragment,mt),mt.forEach(p),gf=r(k),Wt=l(k,"DIV",{class:!0});var Vn=q(Wt);h(Vs.$$.fragment,Vn),uf=r(Vn),il=l(Vn,"P",{"data-svelte-h":!0}),d(il)!=="svelte-p5bez4"&&(il.textContent=W2),hf=r(Vn),cl=l(Vn,"P",{"data-svelte-h":!0}),d(cl)!=="svelte-eb77qn"&&(cl.innerHTML=B2),Vn.forEach(p),ff=r(k),Bt=l(k,"DIV",{class:!0});var Pn=q(Bt);h(Ps.$$.fragment,Pn),mf=r(Pn),ll=l(Pn,"P",{"data-svelte-h":!0}),d(ll)!=="svelte-1ck64b0"&&(ll.textContent=Y2),_f=r(Pn),pl=l(Pn,"P",{"data-svelte-h":!0}),d(pl)!=="svelte-xt39ay"&&(pl.innerHTML=X2),Pn.forEach(p),bf=r(k),F=l(k,"DIV",{class:!0});var G=q(F);h(Ws.$$.fragment,G),vf=r(G),dl=l(G,"P",{"data-svelte-h":!0}),d(dl)!=="svelte-1ryj8c0"&&(dl.textContent=z2),yf=r(G),gl=l(G,"P",{"data-svelte-h":!0}),d(gl)!=="svelte-vnh51y"&&(gl.textContent=O2),xf=r(G),ul=l(G,"P",{"data-svelte-h":!0}),d(ul)!=="svelte-11lpom8"&&(ul.textContent=Q2),$f=r(G),h(wo.$$.fragment,G),wf=r(G),hl=l(G,"P",{"data-svelte-h":!0}),d(hl)!=="svelte-15bi1il"&&(hl.textContent=K2),kf=r(G),fl=l(G,"UL",{"data-svelte-h":!0}),d(fl)!=="svelte-1cixf91"&&(fl.innerHTML=e1),G.forEach(p),Tf=r(k),He=l(k,"DIV",{class:!0});var _t=q(He);h(Bs.$$.fragment,_t),qf=r(_t),ml=l(_t,"P",{"data-svelte-h":!0}),d(ml)!=="svelte-1v3ljxo"&&(ml.textContent=t1),Mf=r(_t),_l=l(_t,"P",{"data-svelte-h":!0}),d(_l)!=="svelte-zq4mwt"&&(_l.textContent=n1),jf=r(_t),bl=l(_t,"P",{"data-svelte-h":!0}),d(bl)!=="svelte-xxbgtf"&&(bl.innerHTML=o1),_t.forEach(p),Hf=r(k),Ce=l(k,"DIV",{class:!0});var bt=q(Ce);h(Ys.$$.fragment,bt),Cf=r(bt),vl=l(bt,"P",{"data-svelte-h":!0}),d(vl)!=="svelte-16mfbn3"&&(vl.textContent=a1),Uf=r(bt),h(ko.$$.fragment,bt),If=r(bt),h(To.$$.fragment,bt),bt.forEach(p),Af=r(k),Ue=l(k,"DIV",{class:!0});var vt=q(Ue);h(Xs.$$.fragment,vt),Nf=r(vt),yl=l(vt,"P",{"data-svelte-h":!0}),d(yl)!=="svelte-1xtlk3i"&&(yl.textContent=s1),Jf=r(vt),h(qo.$$.fragment,vt),Ef=r(vt),h(Mo.$$.fragment,vt),vt.forEach(p),Df=r(k),jo=l(k,"DIV",{class:!0});var Jc=q(jo);h(zs.$$.fragment,Jc),Rf=r(Jc),xl=l(Jc,"P",{"data-svelte-h":!0}),d(xl)!=="svelte-1eopmb2"&&(xl.innerHTML=r1),Jc.forEach(p),Ff=r(k),Ie=l(k,"DIV",{class:!0});var yt=q(Ie);h(Os.$$.fragment,yt),Sf=r(yt),$l=l(yt,"P",{"data-svelte-h":!0}),d($l)!=="svelte-8lce12"&&($l.textContent=i1),Gf=r(yt),wl=l(yt,"P",{"data-svelte-h":!0}),d(wl)!=="svelte-17aw16u"&&(wl.innerHTML=c1),Lf=r(yt),h(Ho.$$.fragment,yt),yt.forEach(p),Zf=r(k),ae=l(k,"DIV",{class:!0});var be=q(ae);h(Qs.$$.fragment,be),Vf=r(be),kl=l(be,"P",{"data-svelte-h":!0}),d(kl)!=="svelte-pth6mb"&&(kl.textContent=l1),Pf=r(be),h(Co.$$.fragment,be),Wf=r(be),h(Uo.$$.fragment,be),Bf=r(be),h(Io.$$.fragment,be),be.forEach(p),Yf=r(k),Z=l(k,"DIV",{class:!0});var K=q(Z);h(Ks.$$.fragment,K),Xf=r(K),Tl=l(K,"P",{"data-svelte-h":!0}),d(Tl)!=="svelte-1g87pq3"&&(Tl.textContent=p1),zf=r(K),ql=l(K,"P",{"data-svelte-h":!0}),d(ql)!=="svelte-1gunwzz"&&(ql.innerHTML=d1),Of=r(K),Ml=l(K,"P",{"data-svelte-h":!0}),d(Ml)!=="svelte-1bbedq1"&&(Ml.innerHTML=g1),Qf=r(K),jl=l(K,"P",{"data-svelte-h":!0}),d(jl)!=="svelte-zi6kpu"&&(jl.innerHTML=u1),Kf=r(K),h(Ao.$$.fragment,K),K.forEach(p),em=r(k),Ae=l(k,"DIV",{class:!0});var xt=q(Ae);h(er.$$.fragment,xt),tm=r(xt),Hl=l(xt,"P",{"data-svelte-h":!0}),d(Hl)!=="svelte-aoy5wl"&&(Hl.textContent=h1),nm=r(xt),h(No.$$.fragment,xt),om=r(xt),h(Jo.$$.fragment,xt),xt.forEach(p),am=r(k),Ne=l(k,"DIV",{class:!0});var $t=q(Ne);h(tr.$$.fragment,$t),sm=r($t),Cl=l($t,"P",{"data-svelte-h":!0}),d(Cl)!=="svelte-1mk48gz"&&(Cl.textContent=f1),rm=r($t),Ul=l($t,"P",{"data-svelte-h":!0}),d(Ul)!=="svelte-s9x0iz"&&(Ul.innerHTML=m1),im=r($t),h(Eo.$$.fragment,$t),$t.forEach(p),cm=r(k),V=l(k,"DIV",{class:!0});var ee=q(V);h(nr.$$.fragment,ee),lm=r(ee),Il=l(ee,"P",{"data-svelte-h":!0}),d(Il)!=="svelte-1hp36yr"&&(Il.innerHTML=_1),pm=r(ee),Al=l(ee,"P",{"data-svelte-h":!0}),d(Al)!=="svelte-194f5ee"&&(Al.innerHTML=b1),dm=r(ee),Nl=l(ee,"P",{"data-svelte-h":!0}),d(Nl)!=="svelte-14j81b7"&&(Nl.innerHTML=v1),gm=r(ee),Jl=l(ee,"P",{"data-svelte-h":!0}),d(Jl)!=="svelte-zi6kpu"&&(Jl.innerHTML=y1),um=r(ee),h(Do.$$.fragment,ee),ee.forEach(p),hm=r(k),Ro=l(k,"DIV",{class:!0});var Ec=q(Ro);h(or.$$.fragment,Ec),fm=r(Ec),El=l(Ec,"P",{"data-svelte-h":!0}),d(El)!=="svelte-12go647"&&(El.textContent=x1),Ec.forEach(p),mm=r(k),Fo=l(k,"DIV",{class:!0});var Dc=q(Fo);h(ar.$$.fragment,Dc),_m=r(Dc),Dl=l(Dc,"P",{"data-svelte-h":!0}),d(Dl)!=="svelte-14fvvbg"&&(Dl.textContent=$1),Dc.forEach(p),bm=r(k),Yt=l(k,"DIV",{class:!0});var Wn=q(Yt);h(sr.$$.fragment,Wn),vm=r(Wn),Rl=l(Wn,"P",{"data-svelte-h":!0}),d(Rl)!=="svelte-1g6e2ay"&&(Rl.textContent=w1),ym=r(Wn),h(So.$$.fragment,Wn),Wn.forEach(p),xm=r(k),Je=l(k,"DIV",{class:!0});var wt=q(Je);h(rr.$$.fragment,wt),$m=r(wt),Fl=l(wt,"P",{"data-svelte-h":!0}),d(Fl)!=="svelte-15pbnj8"&&(Fl.textContent=k1),wm=r(wt),Sl=l(wt,"P",{"data-svelte-h":!0}),d(Sl)!=="svelte-1fg5f6l"&&(Sl.textContent=T1),km=r(wt),h(Go.$$.fragment,wt),wt.forEach(p),Tm=r(k),Lo=l(k,"DIV",{class:!0});var Rc=q(Lo);h(ir.$$.fragment,Rc),qm=r(Rc),Gl=l(Rc,"P",{"data-svelte-h":!0}),d(Gl)!=="svelte-1n7quvg"&&(Gl.textContent=q1),Rc.forEach(p),Mm=r(k),Ee=l(k,"DIV",{class:!0});var kt=q(Ee);h(cr.$$.fragment,kt),jm=r(kt),Ll=l(kt,"P",{"data-svelte-h":!0}),d(Ll)!=="svelte-1s6a009"&&(Ll.textContent=M1),Hm=r(kt),h(Zo.$$.fragment,kt),Cm=r(kt),h(Vo.$$.fragment,kt),kt.forEach(p),Um=r(k),Xt=l(k,"DIV",{class:!0});var Bn=q(Xt);h(lr.$$.fragment,Bn),Im=r(Bn),Zl=l(Bn,"P",{"data-svelte-h":!0}),d(Zl)!=="svelte-gmiayq"&&(Zl.textContent=j1),Am=r(Bn),h(Po.$$.fragment,Bn),Bn.forEach(p),Nm=r(k),zt=l(k,"DIV",{class:!0});var Yn=q(zt);h(pr.$$.fragment,Yn),Jm=r(Yn),Vl=l(Yn,"P",{"data-svelte-h":!0}),d(Vl)!=="svelte-l8j8qy"&&(Vl.textContent=H1),Em=r(Yn),h(Wo.$$.fragment,Yn),Yn.forEach(p),Dm=r(k),Ot=l(k,"DIV",{class:!0});var Xn=q(Ot);h(dr.$$.fragment,Xn),Rm=r(Xn),Pl=l(Xn,"P",{"data-svelte-h":!0}),d(Pl)!=="svelte-eigln8"&&(Pl.textContent=C1),Fm=r(Xn),Wl=l(Xn,"P",{"data-svelte-h":!0}),d(Wl)!=="svelte-11xoqkr"&&(Wl.textContent=U1),Xn.forEach(p),Sm=r(k),Qt=l(k,"DIV",{class:!0});var zn=q(Qt);h(gr.$$.fragment,zn),Gm=r(zn),Bl=l(zn,"P",{"data-svelte-h":!0}),d(Bl)!=="svelte-1gp9ysc"&&(Bl.textContent=I1),Lm=r(zn),Yl=l(zn,"P",{"data-svelte-h":!0}),d(Yl)!=="svelte-1xdeyn5"&&(Yl.innerHTML=A1),zn.forEach(p),Zm=r(k),De=l(k,"DIV",{class:!0});var Tt=q(De);h(ur.$$.fragment,Tt),Vm=r(Tt),Xl=l(Tt,"P",{"data-svelte-h":!0}),d(Xl)!=="svelte-xvin3w"&&(Xl.textContent=N1),Pm=r(Tt),zl=l(Tt,"P",{"data-svelte-h":!0}),d(zl)!=="svelte-w611kl"&&(zl.innerHTML=J1),Wm=r(Tt),Ol=l(Tt,"P",{"data-svelte-h":!0}),d(Ol)!=="svelte-txc80x"&&(Ol.innerHTML=E1),Tt.forEach(p),Bm=r(k),Bo=l(k,"DIV",{class:!0});var Fc=q(Bo);h(hr.$$.fragment,Fc),Ym=r(Fc),Ql=l(Fc,"P",{"data-svelte-h":!0}),d(Ql)!=="svelte-17rezgl"&&(Ql.textContent=D1),Fc.forEach(p),Xm=r(k),Kt=l(k,"DIV",{class:!0});var On=q(Kt);h(fr.$$.fragment,On),zm=r(On),Kl=l(On,"P",{"data-svelte-h":!0}),d(Kl)!=="svelte-1lh7ib8"&&(Kl.textContent=R1),Om=r(On),ep=l(On,"P",{"data-svelte-h":!0}),d(ep)!=="svelte-eb77qn"&&(ep.innerHTML=F1),On.forEach(p),Qm=r(k),Yo=l(k,"DIV",{class:!0});var Sc=q(Yo);h(mr.$$.fragment,Sc),Km=r(Sc),tp=l(Sc,"P",{"data-svelte-h":!0}),d(tp)!=="svelte-2wnalp"&&(tp.textContent=S1),Sc.forEach(p),e_=r(k),en=l(k,"DIV",{class:!0});var Qn=q(en);h(_r.$$.fragment,Qn),t_=r(Qn),np=l(Qn,"P",{"data-svelte-h":!0}),d(np)!=="svelte-idifvk"&&(np.textContent=G1),n_=r(Qn),op=l(Qn,"P",{"data-svelte-h":!0}),d(op)!=="svelte-xt39ay"&&(op.innerHTML=L1),Qn.forEach(p),o_=r(k),Xo=l(k,"DIV",{class:!0});var Gc=q(Xo);h(br.$$.fragment,Gc),a_=r(Gc),ap=l(Gc,"P",{"data-svelte-h":!0}),d(ap)!=="svelte-1k595hs"&&(ap.textContent=Z1),Gc.forEach(p),s_=r(k),tn=l(k,"DIV",{class:!0});var Kn=q(tn);h(vr.$$.fragment,Kn),r_=r(Kn),sp=l(Kn,"P",{"data-svelte-h":!0}),d(sp)!=="svelte-odm3i5"&&(sp.textContent=V1),i_=r(Kn),h(zo.$$.fragment,Kn),Kn.forEach(p),c_=r(k),nn=l(k,"DIV",{class:!0});var eo=q(nn);h(yr.$$.fragment,eo),l_=r(eo),rp=l(eo,"P",{"data-svelte-h":!0}),d(rp)!=="svelte-u3qpxi"&&(rp.textContent=P1),p_=r(eo),h(Oo.$$.fragment,eo),eo.forEach(p),d_=r(k),Re=l(k,"DIV",{class:!0});var qt=q(Re);h(xr.$$.fragment,qt),g_=r(qt),ip=l(qt,"P",{"data-svelte-h":!0}),d(ip)!=="svelte-106oizm"&&(ip.textContent=W1),u_=r(qt),cp=l(qt,"P",{"data-svelte-h":!0}),d(cp)!=="svelte-1tfv4hv"&&(cp.textContent=B1),h_=r(qt),h(Qo.$$.fragment,qt),qt.forEach(p),f_=r(k),on=l(k,"DIV",{class:!0});var to=q(on);h($r.$$.fragment,to),m_=r(to),lp=l(to,"P",{"data-svelte-h":!0}),d(lp)!=="svelte-13117mw"&&(lp.textContent=Y1),__=r(to),h(Ko.$$.fragment,to),to.forEach(p),b_=r(k),an=l(k,"DIV",{class:!0});var no=q(an);h(wr.$$.fragment,no),v_=r(no),pp=l(no,"P",{"data-svelte-h":!0}),d(pp)!=="svelte-isyqd"&&(pp.textContent=X1),y_=r(no),h(ea.$$.fragment,no),no.forEach(p),x_=r(k),sn=l(k,"DIV",{class:!0});var oo=q(sn);h(kr.$$.fragment,oo),$_=r(oo),dp=l(oo,"P",{"data-svelte-h":!0}),d(dp)!=="svelte-sivey2"&&(dp.textContent=z1),w_=r(oo),h(ta.$$.fragment,oo),oo.forEach(p),k_=r(k),Fe=l(k,"DIV",{class:!0});var Mt=q(Fe);h(Tr.$$.fragment,Mt),T_=r(Mt),gp=l(Mt,"P",{"data-svelte-h":!0}),d(gp)!=="svelte-1niezvm"&&(gp.textContent=O1),q_=r(Mt),up=l(Mt,"P",{"data-svelte-h":!0}),d(up)!=="svelte-17aw16u"&&(up.innerHTML=Q1),M_=r(Mt),h(na.$$.fragment,Mt),Mt.forEach(p),j_=r(k),oa=l(k,"DIV",{class:!0});var Lc=q(oa);h(qr.$$.fragment,Lc),H_=r(Lc),hp=l(Lc,"P",{"data-svelte-h":!0}),d(hp)!=="svelte-1o179eo"&&(hp.textContent=K1),Lc.forEach(p),C_=r(k),Se=l(k,"DIV",{class:!0});var jt=q(Se);h(Mr.$$.fragment,jt),U_=r(jt),fp=l(jt,"P",{"data-svelte-h":!0}),d(fp)!=="svelte-1av5ht1"&&(fp.textContent=ew),I_=r(jt),mp=l(jt,"P",{"data-svelte-h":!0}),d(mp)!=="svelte-zi6kpu"&&(mp.innerHTML=tw),A_=r(jt),h(aa.$$.fragment,jt),jt.forEach(p),N_=r(k),sa=l(k,"DIV",{class:!0});var Zc=q(sa);h(jr.$$.fragment,Zc),J_=r(Zc),_p=l(Zc,"P",{"data-svelte-h":!0}),d(_p)!=="svelte-1a5sg0y"&&(_p.textContent=nw),Zc.forEach(p),E_=r(k),ra=l(k,"DIV",{class:!0});var Vc=q(ra);h(Hr.$$.fragment,Vc),D_=r(Vc),bp=l(Vc,"P",{"data-svelte-h":!0}),d(bp)!=="svelte-13tt6xv"&&(bp.textContent=ow),Vc.forEach(p),R_=r(k),rn=l(k,"DIV",{class:!0});var ao=q(rn);h(Cr.$$.fragment,ao),F_=r(ao),vp=l(ao,"P",{"data-svelte-h":!0}),d(vp)!=="svelte-oj23bg"&&(vp.textContent=aw),S_=r(ao),h(ia.$$.fragment,ao),ao.forEach(p),G_=r(k),ca=l(k,"DIV",{class:!0});var Pc=q(ca);h(Ur.$$.fragment,Pc),L_=r(Pc),yp=l(Pc,"P",{"data-svelte-h":!0}),d(yp)!=="svelte-d99h9l"&&(yp.textContent=sw),Pc.forEach(p),Z_=r(k),cn=l(k,"DIV",{class:!0});var so=q(cn);h(Ir.$$.fragment,so),V_=r(so),xp=l(so,"P",{"data-svelte-h":!0}),d(xp)!=="svelte-fasffe"&&(xp.textContent=rw),P_=r(so),h(la.$$.fragment,so),so.forEach(p),W_=r(k),se=l(k,"DIV",{class:!0});var ve=q(se);h(Ar.$$.fragment,ve),B_=r(ve),$p=l(ve,"P",{"data-svelte-h":!0}),d($p)!=="svelte-1ipows8"&&($p.textContent=iw),Y_=r(ve),wp=l(ve,"P",{"data-svelte-h":!0}),d(wp)!=="svelte-11lpom8"&&(wp.textContent=cw),X_=r(ve),h(pa.$$.fragment,ve),z_=r(ve),h(da.$$.fragment,ve),ve.forEach(p),O_=r(k),P=l(k,"DIV",{class:!0});var te=q(P);h(Nr.$$.fragment,te),Q_=r(te),kp=l(te,"P",{"data-svelte-h":!0}),d(kp)!=="svelte-1d865z6"&&(kp.textContent=lw),K_=r(te),Tp=l(te,"P",{"data-svelte-h":!0}),d(Tp)!=="svelte-vb94yg"&&(Tp.textContent=pw),eb=r(te),qp=l(te,"P",{"data-svelte-h":!0}),d(qp)!=="svelte-1vhvhde"&&(qp.innerHTML=dw),tb=r(te),Mp=l(te,"P",{"data-svelte-h":!0}),d(Mp)!=="svelte-ndzof3"&&(Mp.innerHTML=gw),nb=r(te),h(ga.$$.fragment,te),te.forEach(p),ob=r(k),ua=l(k,"DIV",{class:!0});var Wc=q(ua);h(Jr.$$.fragment,Wc),ab=r(Wc),jp=l(Wc,"P",{"data-svelte-h":!0}),d(jp)!=="svelte-130dnbj"&&(jp.textContent=uw),Wc.forEach(p),sb=r(k),ln=l(k,"DIV",{class:!0});var ro=q(ln);h(Er.$$.fragment,ro),rb=r(ro),Hp=l(ro,"P",{"data-svelte-h":!0}),d(Hp)!=="svelte-20b1wq"&&(Hp.textContent=hw),ib=r(ro),Cp=l(ro,"P",{"data-svelte-h":!0}),d(Cp)!=="svelte-xt39ay"&&(Cp.innerHTML=fw),ro.forEach(p),cb=r(k),Ge=l(k,"DIV",{class:!0});var Ht=q(Ge);h(Dr.$$.fragment,Ht),lb=r(Ht),Up=l(Ht,"P",{"data-svelte-h":!0}),d(Up)!=="svelte-1vu5uho"&&(Up.innerHTML=mw),pb=r(Ht),h(ha.$$.fragment,Ht),db=r(Ht),Ip=l(Ht,"P",{"data-svelte-h":!0}),d(Ip)!=="svelte-65kopl"&&(Ip.innerHTML=_w),Ht.forEach(p),gb=r(k),fa=l(k,"DIV",{class:!0});var Bc=q(fa);h(Rr.$$.fragment,Bc),ub=r(Bc),Ap=l(Bc,"P",{"data-svelte-h":!0}),d(Ap)!=="svelte-i5g6s6"&&(Ap.textContent=bw),Bc.forEach(p),hb=r(k),pn=l(k,"DIV",{class:!0});var io=q(pn);h(Fr.$$.fragment,io),fb=r(io),Np=l(io,"P",{"data-svelte-h":!0}),d(Np)!=="svelte-1qqa7u0"&&(Np.textContent=vw),mb=r(io),h(ma.$$.fragment,io),io.forEach(p),_b=r(k),Le=l(k,"DIV",{class:!0});var Ct=q(Le);h(Sr.$$.fragment,Ct),bb=r(Ct),Jp=l(Ct,"P",{"data-svelte-h":!0}),d(Jp)!=="svelte-19fc6id"&&(Jp.textContent=yw),vb=r(Ct),Ep=l(Ct,"P",{"data-svelte-h":!0}),d(Ep)!=="svelte-fnfmvb"&&(Ep.innerHTML=xw),yb=r(Ct),Dp=l(Ct,"P",{"data-svelte-h":!0}),d(Dp)!=="svelte-xxbgtf"&&(Dp.innerHTML=$w),Ct.forEach(p),xb=r(k),W=l(k,"DIV",{class:!0});var ne=q(W);h(Gr.$$.fragment,ne),$b=r(ne),Rp=l(ne,"P",{"data-svelte-h":!0}),d(Rp)!=="svelte-gsbehr"&&(Rp.textContent=ww),wb=r(ne),Fp=l(ne,"P",{"data-svelte-h":!0}),d(Fp)!=="svelte-1rkm1l0"&&(Fp.textContent=kw),kb=r(ne),Sp=l(ne,"UL",{"data-svelte-h":!0}),d(Sp)!=="svelte-1t8qnom"&&(Sp.innerHTML=Tw),Tb=r(ne),h(_a.$$.fragment,ne),qb=r(ne),Gp=l(ne,"P",{"data-svelte-h":!0}),d(Gp)!=="svelte-mwwpv9"&&(Gp.innerHTML=qw),ne.forEach(p),Mb=r(k),Ze=l(k,"DIV",{class:!0});var Ut=q(Ze);h(Lr.$$.fragment,Ut),jb=r(Ut),Lp=l(Ut,"P",{"data-svelte-h":!0}),d(Lp)!=="svelte-1ia1m9g"&&(Lp.textContent=Mw),Hb=r(Ut),h(ba.$$.fragment,Ut),Cb=r(Ut),h(va.$$.fragment,Ut),Ut.forEach(p),Ub=r(k),re=l(k,"DIV",{class:!0});var ye=q(re);h(Zr.$$.fragment,ye),Ib=r(ye),Zp=l(ye,"P",{"data-svelte-h":!0}),d(Zp)!=="svelte-1a7k7d"&&(Zp.textContent=jw),Ab=r(ye),Vp=l(ye,"P",{"data-svelte-h":!0}),d(Vp)!=="svelte-ajfhh0"&&(Vp.innerHTML=Hw),Nb=r(ye),Pp=l(ye,"P",{"data-svelte-h":!0}),d(Pp)!=="svelte-xxbgtf"&&(Pp.innerHTML=Cw),Jb=r(ye),h(ya.$$.fragment,ye),ye.forEach(p),Eb=r(k),dn=l(k,"DIV",{class:!0});var co=q(dn);h(Vr.$$.fragment,co),Db=r(co),Wp=l(co,"P",{"data-svelte-h":!0}),d(Wp)!=="svelte-1rbvjim"&&(Wp.textContent=Uw),Rb=r(co),h(xa.$$.fragment,co),co.forEach(p),Fb=r(k),Ve=l(k,"DIV",{class:!0});var It=q(Ve);h(Pr.$$.fragment,It),Sb=r(It),Bp=l(It,"P",{"data-svelte-h":!0}),d(Bp)!=="svelte-f61qi5"&&(Bp.textContent=Iw),Gb=r(It),h($a.$$.fragment,It),Lb=r(It),h(wa.$$.fragment,It),It.forEach(p),Zb=r(k),ie=l(k,"DIV",{class:!0});var xe=q(ie);h(Wr.$$.fragment,xe),Vb=r(xe),Yp=l(xe,"P",{"data-svelte-h":!0}),d(Yp)!=="svelte-5021cf"&&(Yp.textContent=Aw),Pb=r(xe),Xp=l(xe,"P",{"data-svelte-h":!0}),d(Xp)!=="svelte-s9x0iz"&&(Xp.innerHTML=Nw),Wb=r(xe),zp=l(xe,"P",{"data-svelte-h":!0}),d(zp)!=="svelte-1vlqxmj"&&(zp.innerHTML=Jw),Bb=r(xe),h(ka.$$.fragment,xe),xe.forEach(p),Yb=r(k),gn=l(k,"DIV",{class:!0});var lo=q(gn);h(Br.$$.fragment,lo),Xb=r(lo),Op=l(lo,"P",{"data-svelte-h":!0}),d(Op)!=="svelte-omx1g3"&&(Op.textContent=Ew),zb=r(lo),h(Ta.$$.fragment,lo),lo.forEach(p),Ob=r(k),ce=l(k,"DIV",{class:!0});var $e=q(ce);h(Yr.$$.fragment,$e),Qb=r($e),Qp=l($e,"P",{"data-svelte-h":!0}),d(Qp)!=="svelte-lufmym"&&(Qp.textContent=Dw),Kb=r($e),Kp=l($e,"P",{"data-svelte-h":!0}),d(Kp)!=="svelte-517n25"&&(Kp.innerHTML=Rw),ev=r($e),ed=l($e,"P",{"data-svelte-h":!0}),d(ed)!=="svelte-4np1w2"&&(ed.innerHTML=Fw),tv=r($e),h(qa.$$.fragment,$e),$e.forEach(p),nv=r(k),Pe=l(k,"DIV",{class:!0});var At=q(Pe);h(Xr.$$.fragment,At),ov=r(At),td=l(At,"P",{"data-svelte-h":!0}),d(td)!=="svelte-7xr8du"&&(td.textContent=Sw),av=r(At),h(Ma.$$.fragment,At),sv=r(At),h(ja.$$.fragment,At),At.forEach(p),rv=r(k),Ha=l(k,"DIV",{class:!0});var Yc=q(Ha);h(zr.$$.fragment,Yc),iv=r(Yc),nd=l(Yc,"P",{"data-svelte-h":!0}),d(nd)!=="svelte-1lk5pt4"&&(nd.textContent=Gw),Yc.forEach(p),cv=r(k),un=l(k,"DIV",{class:!0});var po=q(un);h(Or.$$.fragment,po),lv=r(po),od=l(po,"P",{"data-svelte-h":!0}),d(od)!=="svelte-1qh0k4h"&&(od.textContent=Lw),pv=r(po),h(Ca.$$.fragment,po),po.forEach(p),dv=r(k),le=l(k,"DIV",{class:!0});var we=q(le);h(Qr.$$.fragment,we),gv=r(we),ad=l(we,"P",{"data-svelte-h":!0}),d(ad)!=="svelte-1tc2fi9"&&(ad.textContent=Zw),uv=r(we),sd=l(we,"P",{"data-svelte-h":!0}),d(sd)!=="svelte-1vz216g"&&(sd.innerHTML=Vw),hv=r(we),rd=l(we,"P",{"data-svelte-h":!0}),d(rd)!=="svelte-xxbgtf"&&(rd.innerHTML=Pw),fv=r(we),h(Ua.$$.fragment,we),we.forEach(p),mv=r(k),pe=l(k,"DIV",{class:!0});var ke=q(pe);h(Kr.$$.fragment,ke),_v=r(ke),id=l(ke,"P",{"data-svelte-h":!0}),d(id)!=="svelte-eo3dek"&&(id.textContent=Ww),bv=r(ke),cd=l(ke,"P",{"data-svelte-h":!0}),d(cd)!=="svelte-rh9cjt"&&(cd.innerHTML=Bw),vv=r(ke),ld=l(ke,"P",{"data-svelte-h":!0}),d(ld)!=="svelte-xxbgtf"&&(ld.innerHTML=Yw),yv=r(ke),h(Ia.$$.fragment,ke),ke.forEach(p),xv=r(k),We=l(k,"DIV",{class:!0});var Nt=q(We);h(ei.$$.fragment,Nt),$v=r(Nt),pd=l(Nt,"P",{"data-svelte-h":!0}),d(pd)!=="svelte-1vpgi7z"&&(pd.textContent=Xw),wv=r(Nt),dd=l(Nt,"P",{"data-svelte-h":!0}),d(dd)!=="svelte-11ohrqa"&&(dd.textContent=zw),kv=r(Nt),h(Aa.$$.fragment,Nt),Nt.forEach(p),Tv=r(k),Na=l(k,"DIV",{class:!0});var Xc=q(Na);h(ti.$$.fragment,Xc),qv=r(Xc),gd=l(Xc,"P",{"data-svelte-h":!0}),d(gd)!=="svelte-wnw53w"&&(gd.textContent=Ow),Xc.forEach(p),Mv=r(k),hn=l(k,"DIV",{class:!0});var go=q(hn);h(ni.$$.fragment,go),jv=r(go),ud=l(go,"P",{"data-svelte-h":!0}),d(ud)!=="svelte-b4yhj"&&(ud.textContent=Qw),Hv=r(go),hd=l(go,"P",{"data-svelte-h":!0}),d(hd)!=="svelte-cotkoa"&&(hd.innerHTML=Kw),go.forEach(p),Cv=r(k),fn=l(k,"DIV",{class:!0});var uo=q(fn);h(oi.$$.fragment,uo),Uv=r(uo),fd=l(uo,"P",{"data-svelte-h":!0}),d(fd)!=="svelte-12l2ojn"&&(fd.textContent=ek),Iv=r(uo),h(Ja.$$.fragment,uo),uo.forEach(p),Av=r(k),S=l(k,"DIV",{class:!0});var L=q(S);h(ai.$$.fragment,L),Nv=r(L),md=l(L,"P",{"data-svelte-h":!0}),d(md)!=="svelte-ihiuvu"&&(md.textContent=tk),Jv=r(L),_d=l(L,"P",{"data-svelte-h":!0}),d(_d)!=="svelte-kvfsh7"&&(_d.textContent=nk),Ev=r(L),bd=l(L,"P",{"data-svelte-h":!0}),d(bd)!=="svelte-cs4ah2"&&(bd.textContent=ok),Dv=r(L),h(Ea.$$.fragment,L),Rv=r(L),vd=l(L,"P",{"data-svelte-h":!0}),d(vd)!=="svelte-1pnedrv"&&(vd.textContent=ak),Fv=r(L),h(Da.$$.fragment,L),L.forEach(p),Sv=r(k),Ra=l(k,"DIV",{class:!0});var zc=q(Ra);h(si.$$.fragment,zc),Gv=r(zc),yd=l(zc,"P",{"data-svelte-h":!0}),d(yd)!=="svelte-uowooj"&&(yd.textContent=sk),zc.forEach(p),Lv=r(k),Fa=l(k,"DIV",{class:!0});var Oc=q(Fa);h(ri.$$.fragment,Oc),Zv=r(Oc),xd=l(Oc,"P",{"data-svelte-h":!0}),d(xd)!=="svelte-apiozp"&&(xd.textContent=rk),Oc.forEach(p),Vv=r(k),Sa=l(k,"DIV",{class:!0});var Qc=q(Sa);h(ii.$$.fragment,Qc),Pv=r(Qc),$d=l(Qc,"P",{"data-svelte-h":!0}),d($d)!=="svelte-1qehg6u"&&($d.textContent=ik),Qc.forEach(p),Wv=r(k),mn=l(k,"DIV",{class:!0});var ho=q(mn);h(ci.$$.fragment,ho),Bv=r(ho),wd=l(ho,"P",{"data-svelte-h":!0}),d(wd)!=="svelte-zuangp"&&(wd.textContent=ck),Yv=r(ho),h(Ga.$$.fragment,ho),ho.forEach(p),Xv=r(k),_n=l(k,"DIV",{class:!0});var fo=q(_n);h(li.$$.fragment,fo),zv=r(fo),kd=l(fo,"P",{"data-svelte-h":!0}),d(kd)!=="svelte-tnvivq"&&(kd.textContent=lk),Ov=r(fo),h(La.$$.fragment,fo),fo.forEach(p),Qv=r(k),Be=l(k,"DIV",{class:!0});var Jt=q(Be);h(pi.$$.fragment,Jt),Kv=r(Jt),Td=l(Jt,"P",{"data-svelte-h":!0}),d(Td)!=="svelte-1qa90id"&&(Td.textContent=pk),ey=r(Jt),qd=l(Jt,"P",{"data-svelte-h":!0}),d(qd)!=="svelte-1knrefm"&&(qd.textContent=dk),ty=r(Jt),h(Za.$$.fragment,Jt),Jt.forEach(p),ny=r(k),Ye=l(k,"DIV",{class:!0});var Et=q(Ye);h(di.$$.fragment,Et),oy=r(Et),Md=l(Et,"P",{"data-svelte-h":!0}),d(Md)!=="svelte-3q13qo"&&(Md.textContent=gk),ay=r(Et),jd=l(Et,"P",{"data-svelte-h":!0}),d(jd)!=="svelte-1p5ibr4"&&(jd.innerHTML=uk),sy=r(Et),h(Va.$$.fragment,Et),Et.forEach(p),ry=r(k),Pa=l(k,"DIV",{class:!0});var Kc=q(Pa);h(gi.$$.fragment,Kc),iy=r(Kc),Hd=l(Kc,"P",{"data-svelte-h":!0}),d(Hd)!=="svelte-15c9e8d"&&(Hd.textContent=hk),Kc.forEach(p),cy=r(k),Xe=l(k,"DIV",{class:!0});var Dt=q(Xe);h(ui.$$.fragment,Dt),ly=r(Dt),Cd=l(Dt,"P",{"data-svelte-h":!0}),d(Cd)!=="svelte-cs1v9f"&&(Cd.textContent=fk),py=r(Dt),Ud=l(Dt,"P",{"data-svelte-h":!0}),d(Ud)!=="svelte-hmt9ht"&&(Ud.innerHTML=mk),dy=r(Dt),Id=l(Dt,"P",{"data-svelte-h":!0}),d(Id)!=="svelte-ndzof3"&&(Id.innerHTML=_k),Dt.forEach(p),gy=r(k),ze=l(k,"DIV",{class:!0});var Rt=q(ze);h(hi.$$.fragment,Rt),uy=r(Rt),Ad=l(Rt,"P",{"data-svelte-h":!0}),d(Ad)!=="svelte-16tls2x"&&(Ad.textContent=bk),hy=r(Rt),Nd=l(Rt,"P",{"data-svelte-h":!0}),d(Nd)!=="svelte-80m3eg"&&(Nd.innerHTML=vk),fy=r(Rt),Jd=l(Rt,"P",{"data-svelte-h":!0}),d(Jd)!=="svelte-5ptavr"&&(Jd.innerHTML=yk),Rt.forEach(p),my=r(k),Oe=l(k,"DIV",{class:!0});var Ft=q(Oe);h(fi.$$.fragment,Ft),_y=r(Ft),Ed=l(Ft,"P",{"data-svelte-h":!0}),d(Ed)!=="svelte-keb9bv"&&(Ed.textContent=xk),by=r(Ft),Dd=l(Ft,"P",{"data-svelte-h":!0}),d(Dd)!=="svelte-15wjl3y"&&(Dd.innerHTML=$k),vy=r(Ft),Rd=l(Ft,"P",{"data-svelte-h":!0}),d(Rd)!=="svelte-12do56u"&&(Rd.innerHTML=wk),Ft.forEach(p),yy=r(k),B=l(k,"DIV",{class:!0});var oe=q(B);h(mi.$$.fragment,oe),xy=r(oe),Fd=l(oe,"P",{"data-svelte-h":!0}),d(Fd)!=="svelte-13c8xg2"&&(Fd.textContent=kk),$y=r(oe),Sd=l(oe,"P",{"data-svelte-h":!0}),d(Sd)!=="svelte-5htwml"&&(Sd.textContent=Tk),wy=r(oe),h(Wa.$$.fragment,oe),ky=r(oe),h(Ba.$$.fragment,oe),Ty=r(oe),h(Ya.$$.fragment,oe),oe.forEach(p),qy=r(k),Qe=l(k,"DIV",{class:!0});var St=q(Qe);h(_i.$$.fragment,St),My=r(St),Gd=l(St,"P",{"data-svelte-h":!0}),d(Gd)!=="svelte-1o1ui5j"&&(Gd.textContent=qk),jy=r(St),Ld=l(St,"P",{"data-svelte-h":!0}),d(Ld)!=="svelte-ptggg8"&&(Ld.innerHTML=Mk),Hy=r(St),Zd=l(St,"P",{"data-svelte-h":!0}),d(Zd)!=="svelte-xxbgtf"&&(Zd.innerHTML=jk),St.forEach(p),Cy=r(k),Ke=l(k,"DIV",{class:!0});var Gt=q(Ke);h(bi.$$.fragment,Gt),Uy=r(Gt),Vd=l(Gt,"P",{"data-svelte-h":!0}),d(Vd)!=="svelte-vjmct2"&&(Vd.textContent=Hk),Iy=r(Gt),h(Xa.$$.fragment,Gt),Ay=r(Gt),h(za.$$.fragment,Gt),Gt.forEach(p),Ny=r(k),bn=l(k,"DIV",{class:!0});var mo=q(bn);h(vi.$$.fragment,mo),Jy=r(mo),Pd=l(mo,"P",{"data-svelte-h":!0}),d(Pd)!=="svelte-1h0ufuc"&&(Pd.textContent=Ck),Ey=r(mo),h(Oa.$$.fragment,mo),mo.forEach(p),Dy=r(k),vn=l(k,"DIV",{class:!0});var _o=q(vn);h(yi.$$.fragment,_o),Ry=r(_o),Wd=l(_o,"P",{"data-svelte-h":!0}),d(Wd)!=="svelte-1my46uo"&&(Wd.textContent=Uk),Fy=r(_o),h(Qa.$$.fragment,_o),_o.forEach(p),Sy=r(k),yn=l(k,"DIV",{class:!0});var bo=q(yn);h(xi.$$.fragment,bo),Gy=r(bo),Bd=l(bo,"P",{"data-svelte-h":!0}),d(Bd)!=="svelte-5pcxuz"&&(Bd.textContent=Ik),Ly=r(bo),h(Ka.$$.fragment,bo),bo.forEach(p),Zy=r(k),xn=l(k,"DIV",{class:!0});var vo=q(xn);h($i.$$.fragment,vo),Vy=r(vo),Yd=l(vo,"P",{"data-svelte-h":!0}),d(Yd)!=="svelte-10aqzwl"&&(Yd.textContent=Ak),Py=r(vo),h(es.$$.fragment,vo),vo.forEach(p),Wy=r(k),et=l(k,"DIV",{class:!0});var Lt=q(et);h(wi.$$.fragment,Lt),By=r(Lt),Xd=l(Lt,"P",{"data-svelte-h":!0}),d(Xd)!=="svelte-38gi4y"&&(Xd.textContent=Nk),Yy=r(Lt),zd=l(Lt,"P",{"data-svelte-h":!0}),d(zd)!=="svelte-zwgc7q"&&(zd.innerHTML=Jk),Xy=r(Lt),Od=l(Lt,"P",{"data-svelte-h":!0}),d(Od)!=="svelte-12do56u"&&(Od.innerHTML=Ek),Lt.forEach(p),zy=r(k),$n=l(k,"DIV",{class:!0});var yo=q($n);h(ki.$$.fragment,yo),Oy=r(yo),Qd=l(yo,"P",{"data-svelte-h":!0}),d(Qd)!=="svelte-o2dz8s"&&(Qd.textContent=Dk),Qy=r(yo),Kd=l(yo,"P",{"data-svelte-h":!0}),d(Kd)!=="svelte-1drucw9"&&(Kd.innerHTML=Rk),yo.forEach(p),Ky=r(k),wn=l(k,"DIV",{class:!0});var xo=q(wn);h(Ti.$$.fragment,xo),ex=r(xo),eg=l(xo,"P",{"data-svelte-h":!0}),d(eg)!=="svelte-kx7a2l"&&(eg.textContent=Fk),tx=r(xo),h(ts.$$.fragment,xo),xo.forEach(p),nx=r(k),de=l(k,"DIV",{class:!0});var Te=q(de);h(qi.$$.fragment,Te),ox=r(Te),tg=l(Te,"P",{"data-svelte-h":!0}),d(tg)!=="svelte-i4rj9b"&&(tg.textContent=Sk),ax=r(Te),ng=l(Te,"P",{"data-svelte-h":!0}),d(ng)!=="svelte-15iw2gd"&&(ng.innerHTML=Gk),sx=r(Te),og=l(Te,"P",{"data-svelte-h":!0}),d(og)!=="svelte-1f3ta7h"&&(og.innerHTML=Lk),rx=r(Te),h(ns.$$.fragment,Te),Te.forEach(p),ix=r(k),tt=l(k,"DIV",{class:!0});var Zt=q(tt);h(Mi.$$.fragment,Zt),cx=r(Zt),ag=l(Zt,"P",{"data-svelte-h":!0}),d(ag)!=="svelte-6vx93v"&&(ag.textContent=Zk),lx=r(Zt),sg=l(Zt,"P",{"data-svelte-h":!0}),d(sg)!=="svelte-153amg4"&&(sg.innerHTML=Vk),px=r(Zt),rg=l(Zt,"P",{"data-svelte-h":!0}),d(rg)!=="svelte-dx5ct"&&(rg.innerHTML=Pk),Zt.forEach(p),dx=r(k),nt=l(k,"DIV",{class:!0});var Vt=q(nt);h(ji.$$.fragment,Vt),gx=r(Vt),ig=l(Vt,"P",{"data-svelte-h":!0}),d(ig)!=="svelte-h8ye5s"&&(ig.textContent=Wk),ux=r(Vt),cg=l(Vt,"P",{"data-svelte-h":!0}),d(cg)!=="svelte-1u14fwi"&&(cg.innerHTML=Bk),hx=r(Vt),h(os.$$.fragment,Vt),Vt.forEach(p),fx=r(k),ge=l(k,"DIV",{class:!0});var qe=q(ge);h(Hi.$$.fragment,qe),mx=r(qe),lg=l(qe,"P",{"data-svelte-h":!0}),d(lg)!=="svelte-t9d1pp"&&(lg.textContent=Yk),_x=r(qe),pg=l(qe,"P",{"data-svelte-h":!0}),d(pg)!=="svelte-xxyl9g"&&(pg.innerHTML=Xk),bx=r(qe),dg=l(qe,"P",{"data-svelte-h":!0}),d(dg)!=="svelte-1v8h65f"&&(dg.innerHTML=zk),vx=r(qe),gg=l(qe,"P",{"data-svelte-h":!0}),d(gg)!=="svelte-k7g81c"&&(gg.textContent=Ok),qe.forEach(p),yx=r(k),ot=l(k,"DIV",{class:!0});var Pt=q(ot);h(Ci.$$.fragment,Pt),xx=r(Pt),ug=l(Pt,"P",{"data-svelte-h":!0}),d(ug)!=="svelte-1lgtcoe"&&(ug.textContent=Qk),$x=r(Pt),hg=l(Pt,"P",{"data-svelte-h":!0}),d(hg)!=="svelte-zugpyn"&&(hg.textContent=Kk),wx=r(Pt),h(as.$$.fragment,Pt),Pt.forEach(p),kx=r(k),Y=l(k,"DIV",{class:!0});var it=q(Y);h(Ui.$$.fragment,it),Tx=r(it),fg=l(it,"P",{"data-svelte-h":!0}),d(fg)!=="svelte-1j5taqn"&&(fg.textContent=eT),qx=r(it),mg=l(it,"P",{"data-svelte-h":!0}),d(mg)!=="svelte-1oloczu"&&(mg.textContent=tT),Mx=r(it),h(ss.$$.fragment,it),jx=r(it),h(rs.$$.fragment,it),Hx=r(it),h(is.$$.fragment,it),it.forEach(p),Cx=r(k),ue=l(k,"DIV",{class:!0});var Un=q(ue);h(Ii.$$.fragment,Un),Ux=r(Un),_g=l(Un,"P",{"data-svelte-h":!0}),d(_g)!=="svelte-z82c1y"&&(_g.textContent=nT),Ix=r(Un),bg=l(Un,"P",{"data-svelte-h":!0}),d(bg)!=="svelte-w9m9bs"&&(bg.innerHTML=oT),Ax=r(Un),vg=l(Un,"P",{"data-svelte-h":!0}),d(vg)!=="svelte-cotkoa"&&(vg.innerHTML=aT),Nx=r(Un),h(cs.$$.fragment,Un),Un.forEach(p),Jx=r(k),kn=l(k,"DIV",{class:!0});var Ru=q(kn);h(Ai.$$.fragment,Ru),Ex=r(Ru),yg=l(Ru,"P",{"data-svelte-h":!0}),d(yg)!=="svelte-klf1wz"&&(yg.textContent=sT),Dx=r(Ru),h(ls.$$.fragment,Ru),Ru.forEach(p),Rx=r(k),he=l(k,"DIV",{class:!0});var In=q(he);h(Ni.$$.fragment,In),Fx=r(In),xg=l(In,"P",{"data-svelte-h":!0}),d(xg)!=="svelte-6tdefx"&&(xg.textContent=rT),Sx=r(In),$g=l(In,"P",{"data-svelte-h":!0}),d($g)!=="svelte-sjutdt"&&($g.textContent=iT),Gx=r(In),wg=l(In,"P",{"data-svelte-h":!0}),d(wg)!=="svelte-17aw16u"&&(wg.innerHTML=cT),Lx=r(In),h(ps.$$.fragment,In),In.forEach(p),Zx=r(k),at=l(k,"DIV",{class:!0});var Is=q(at);h(Ji.$$.fragment,Is),Vx=r(Is),kg=l(Is,"P",{"data-svelte-h":!0}),d(kg)!=="svelte-tgkk8q"&&(kg.textContent=lT),Px=r(Is),Tg=l(Is,"P",{"data-svelte-h":!0}),d(Tg)!=="svelte-llxqqu"&&(Tg.textContent=pT),Wx=r(Is),qg=l(Is,"P",{"data-svelte-h":!0}),d(qg)!=="svelte-1xddutv"&&(qg.innerHTML=dT),Is.forEach(p),Bx=r(k),Tn=l(k,"DIV",{class:!0});var Fu=q(Tn);h(Ei.$$.fragment,Fu),Yx=r(Fu),Mg=l(Fu,"P",{"data-svelte-h":!0}),d(Mg)!=="svelte-1xslq7e"&&(Mg.textContent=gT),Xx=r(Fu),jg=l(Fu,"P",{"data-svelte-h":!0}),d(jg)!=="svelte-zgmljc"&&(jg.textContent=uT),Fu.forEach(p),zx=r(k),st=l(k,"DIV",{class:!0});var As=q(st);h(Di.$$.fragment,As),Ox=r(As),Hg=l(As,"P",{"data-svelte-h":!0}),d(Hg)!=="svelte-1icdi1y"&&(Hg.textContent=hT),Qx=r(As),Cg=l(As,"P",{"data-svelte-h":!0}),d(Cg)!=="svelte-1b93kvt"&&(Cg.innerHTML=fT),Kx=r(As),h(ds.$$.fragment,As),As.forEach(p),e$=r(k),qn=l(k,"DIV",{class:!0});var Su=q(qn);h(Ri.$$.fragment,Su),t$=r(Su),Ug=l(Su,"P",{"data-svelte-h":!0}),d(Ug)!=="svelte-1a9paom"&&(Ug.textContent=mT),n$=r(Su),h(gs.$$.fragment,Su),Su.forEach(p),o$=r(k),fe=l(k,"DIV",{class:!0});var An=q(fe);h(Fi.$$.fragment,An),a$=r(An),Ig=l(An,"P",{"data-svelte-h":!0}),d(Ig)!=="svelte-kukbcr"&&(Ig.textContent=_T),s$=r(An),h(us.$$.fragment,An),r$=r(An),h(hs.$$.fragment,An),i$=r(An),h(fs.$$.fragment,An),An.forEach(p),c$=r(k),N=l(k,"DIV",{class:!0});var E=q(N);h(Si.$$.fragment,E),l$=r(E),Ag=l(E,"P",{"data-svelte-h":!0}),d(Ag)!=="svelte-1nvey1d"&&(Ag.textContent=bT),p$=r(E),Ng=l(E,"P",{"data-svelte-h":!0}),d(Ng)!=="svelte-1vu0l4l"&&(Ng.textContent=vT),d$=r(E),Jg=l(E,"P",{"data-svelte-h":!0}),d(Jg)!=="svelte-adrskp"&&(Jg.innerHTML=yT),g$=r(E),Eg=l(E,"P",{"data-svelte-h":!0}),d(Eg)!=="svelte-1m6fudm"&&(Eg.innerHTML=xT),u$=r(E),Dg=l(E,"P",{"data-svelte-h":!0}),d(Dg)!=="svelte-nojwu3"&&(Dg.innerHTML=$T),h$=r(E),Rg=l(E,"P",{"data-svelte-h":!0}),d(Rg)!=="svelte-90ewc6"&&(Rg.innerHTML=wT),f$=r(E),h(ms.$$.fragment,E),m$=r(E),h(_s.$$.fragment,E),_$=r(E),h(bs.$$.fragment,E),b$=r(E),h(vs.$$.fragment,E),E.forEach(p),v$=r(k),A=l(k,"DIV",{class:!0});var J=q(A);h(Gi.$$.fragment,J),y$=r(J),Fg=l(J,"P",{"data-svelte-h":!0}),d(Fg)!=="svelte-1a1ittk"&&(Fg.textContent=kT),x$=r(J),Sg=l(J,"P",{"data-svelte-h":!0}),d(Sg)!=="svelte-3l9535"&&(Sg.innerHTML=TT),$$=r(J),h(ys.$$.fragment,J),w$=r(J),h(xs.$$.fragment,J),k$=r(J),Gg=l(J,"P",{"data-svelte-h":!0}),d(Gg)!=="svelte-8c4beu"&&(Gg.innerHTML=qT),T$=r(J),Lg=l(J,"P",{"data-svelte-h":!0}),d(Lg)!=="svelte-25734v"&&(Lg.innerHTML=MT),q$=r(J),Zg=l(J,"OL",{"data-svelte-h":!0}),d(Zg)!=="svelte-1ewi7og"&&(Zg.innerHTML=jT),M$=r(J),Vg=l(J,"P",{"data-svelte-h":!0}),d(Vg)!=="svelte-59ei85"&&(Vg.textContent=HT),j$=r(J),Pg=l(J,"OL",{"data-svelte-h":!0}),d(Pg)!=="svelte-1igkyl7"&&(Pg.innerHTML=CT),H$=r(J),Wg=l(J,"P",{"data-svelte-h":!0}),d(Wg)!=="svelte-w718ua"&&(Wg.textContent=UT),C$=r(J),Bg=l(J,"UL",{"data-svelte-h":!0}),d(Bg)!=="svelte-c57nbb"&&(Bg.innerHTML=IT),J.forEach(p),U$=r(k),$s=l(k,"DIV",{class:!0});var Bh=q($s);h(Li.$$.fragment,Bh),I$=r(Bh),Yg=l(Bh,"P",{"data-svelte-h":!0}),d(Yg)!=="svelte-l7gr50"&&(Yg.textContent=AT),Bh.forEach(p),k.forEach(p),ah=r(t),h(Zi.$$.fragment,t),sh=r(t),h(Vi.$$.fragment,t),rh=r(t),Dn=l(t,"DIV",{class:!0});var Yh=q(Dn);h(Pi.$$.fragment,Yh),A$=r(Yh),Xg=l(Yh,"P",{"data-svelte-h":!0}),d(Xg)!=="svelte-frgpd7"&&(Xg.textContent=NT),Yh.forEach(p),ih=r(t),h(Wi.$$.fragment,t),ch=r(t),ct=l(t,"DIV",{class:!0});var Gu=q(ct);h(Bi.$$.fragment,Gu),N$=r(Gu),zg=l(Gu,"P",{"data-svelte-h":!0}),d(zg)!=="svelte-n4j72f"&&(zg.textContent=JT),J$=r(Gu),Og=l(Gu,"P",{"data-svelte-h":!0}),d(Og)!=="svelte-92iwcm"&&(Og.innerHTML=ET),Gu.forEach(p),lh=r(t),h(Yi.$$.fragment,t),ph=r(t),lt=l(t,"DIV",{class:!0});var Lu=q(lt);h(Xi.$$.fragment,Lu),E$=r(Lu),Qg=l(Lu,"P",{"data-svelte-h":!0}),d(Qg)!=="svelte-si50g0"&&(Qg.textContent=DT),D$=r(Lu),h(ws.$$.fragment,Lu),Lu.forEach(p),dh=r(t),h(zi.$$.fragment,t),gh=r(t),Rn=l(t,"DIV",{class:!0});var Xh=q(Rn);h(Oi.$$.fragment,Xh),R$=r(Xh),Kg=l(Xh,"P",{"data-svelte-h":!0}),d(Kg)!=="svelte-1dp8z99"&&(Kg.textContent=RT),Xh.forEach(p),uh=r(t),h(Qi.$$.fragment,t),hh=r(t),Fn=l(t,"DIV",{class:!0});var zh=q(Fn);h(Ki.$$.fragment,zh),F$=r(zh),eu=l(zh,"P",{"data-svelte-h":!0}),d(eu)!=="svelte-17whmxr"&&(eu.innerHTML=FT),zh.forEach(p),fh=r(t),h(ec.$$.fragment,t),mh=r(t),pt=l(t,"DIV",{class:!0});var Zu=q(pt);h(tc.$$.fragment,Zu),S$=r(Zu),tu=l(Zu,"P",{"data-svelte-h":!0}),d(tu)!=="svelte-8pkqdq"&&(tu.textContent=ST),G$=r(Zu),nu=l(Zu,"P",{"data-svelte-h":!0}),d(nu)!=="svelte-1c8qold"&&(nu.innerHTML=GT),Zu.forEach(p),_h=r(t),h(nc.$$.fragment,t),bh=r(t),dt=l(t,"DIV",{class:!0});var Vu=q(dt);h(oc.$$.fragment,Vu),L$=r(Vu),ou=l(Vu,"P",{"data-svelte-h":!0}),d(ou)!=="svelte-fx2iaz"&&(ou.textContent=LT),Z$=r(Vu),h(ks.$$.fragment,Vu),Vu.forEach(p),vh=r(t),h(ac.$$.fragment,t),yh=r(t),gt=l(t,"DIV",{class:!0});var Pu=q(gt);h(sc.$$.fragment,Pu),V$=r(Pu),au=l(Pu,"P",{"data-svelte-h":!0}),d(au)!=="svelte-pzc88f"&&(au.textContent=ZT),P$=r(Pu),h(Ts.$$.fragment,Pu),Pu.forEach(p),xh=r(t),h(rc.$$.fragment,t),$h=r(t),Sn=l(t,"DIV",{class:!0});var Oh=q(Sn);h(ic.$$.fragment,Oh),W$=r(Oh),su=l(Oh,"P",{"data-svelte-h":!0}),d(su)!=="svelte-1eicjbk"&&(su.textContent=VT),Oh.forEach(p),wh=r(t),h(cc.$$.fragment,t),kh=r(t),z=l(t,"DIV",{class:!0});var Nn=q(z);h(lc.$$.fragment,Nn),B$=r(Nn),ru=l(Nn,"P",{"data-svelte-h":!0}),d(ru)!=="svelte-1v78htg"&&(ru.innerHTML=PT),Y$=r(Nn),iu=l(Nn,"P",{"data-svelte-h":!0}),d(iu)!=="svelte-murgw9"&&(iu.innerHTML=WT),X$=r(Nn),cu=l(Nn,"UL",{"data-svelte-h":!0}),d(cu)!=="svelte-1mrng5l"&&(cu.innerHTML=BT),z$=r(Nn),h(qs.$$.fragment,Nn),Nn.forEach(p),Th=r(t),h(pc.$$.fragment,t),qh=r(t),O=l(t,"DIV",{class:!0});var Jn=q(O);h(dc.$$.fragment,Jn),O$=r(Jn),lu=l(Jn,"P",{"data-svelte-h":!0}),d(lu)!=="svelte-ovnxfi"&&(lu.textContent=YT),Q$=r(Jn),pu=l(Jn,"P",{"data-svelte-h":!0}),d(pu)!=="svelte-afv8fv"&&(pu.textContent=XT),K$=r(Jn),du=l(Jn,"P",{"data-svelte-h":!0}),d(du)!=="svelte-1pzb93s"&&(du.innerHTML=zT),e2=r(Jn),gu=l(Jn,"P",{"data-svelte-h":!0}),d(gu)!=="svelte-ndzof3"&&(gu.innerHTML=OT),Jn.forEach(p),Mh=r(t),h(gc.$$.fragment,t),jh=r(t),me=l(t,"DIV",{class:!0});var Ns=q(me);h(uc.$$.fragment,Ns),t2=r(Ns),uu=l(Ns,"P",{"data-svelte-h":!0}),d(uu)!=="svelte-2ejdv8"&&(uu.textContent=QT),n2=r(Ns),hu=l(Ns,"P",{"data-svelte-h":!0}),d(hu)!=="svelte-1t8oovk"&&(hu.innerHTML=KT),o2=r(Ns),fu=l(Ns,"P",{"data-svelte-h":!0}),d(fu)!=="svelte-ndzof3"&&(fu.innerHTML=e0),Ns.forEach(p),Hh=r(t),h(hc.$$.fragment,t),Ch=r(t),ut=l(t,"DIV",{class:!0});var Wu=q(ut);h(fc.$$.fragment,Wu),a2=r(Wu),mu=l(Wu,"P",{"data-svelte-h":!0}),d(mu)!=="svelte-1v8t816"&&(mu.textContent=t0),s2=r(Wu),h(Ms.$$.fragment,Wu),Wu.forEach(p),Uh=r(t),h(mc.$$.fragment,t),Ih=r(t),ht=l(t,"DIV",{class:!0});var Bu=q(ht);h(_c.$$.fragment,Bu),r2=r(Bu),_u=l(Bu,"P",{"data-svelte-h":!0}),d(_u)!=="svelte-by9v9h"&&(_u.textContent=n0),i2=r(Bu),bu=l(Bu,"P",{"data-svelte-h":!0}),d(bu)!=="svelte-ndzof3"&&(bu.innerHTML=o0),Bu.forEach(p),Ah=r(t),h(bc.$$.fragment,t),Nh=r(t),Gn=l(t,"DIV",{class:!0});var Qh=q(Gn);h(vc.$$.fragment,Qh),c2=r(Qh),vu=l(Qh,"P",{"data-svelte-h":!0}),d(vu)!=="svelte-f10xp"&&(vu.textContent=a0),Qh.forEach(p),Jh=r(t),h(yc.$$.fragment,t),Eh=r(t),Ln=l(t,"DIV",{class:!0});var Kh=q(Ln);h(xc.$$.fragment,Kh),l2=r(Kh),yu=l(Kh,"P",{"data-svelte-h":!0}),d(yu)!=="svelte-s36het"&&(yu.textContent=s0),Kh.forEach(p),Dh=r(t),h($c.$$.fragment,t),Rh=r(t),wc=l(t,"P",{"data-svelte-h":!0}),d(wc)!=="svelte-141kvtu"&&(wc.innerHTML=r0),Fh=r(t),_e=l(t,"DIV",{class:!0});var Js=q(_e);h(kc.$$.fragment,Js),p2=r(Js),xu=l(Js,"P",{"data-svelte-h":!0}),d(xu)!=="svelte-1nyzeix"&&(xu.textContent=i0),d2=r(Js),Mn=l(Js,"DIV",{class:!0});var Yu=q(Mn);h(Tc.$$.fragment,Yu),g2=r(Yu),$u=l(Yu,"P",{"data-svelte-h":!0}),d($u)!=="svelte-1d7s5nc"&&($u.innerHTML=c0),u2=r(Yu),h(js.$$.fragment,Yu),Yu.forEach(p),h2=r(Js),jn=l(Js,"DIV",{class:!0});var Xu=q(jn);h(qc.$$.fragment,Xu),f2=r(Xu),wu=l(Xu,"P",{"data-svelte-h":!0}),d(wu)!=="svelte-1o44akx"&&(wu.innerHTML=l0),m2=r(Xu),ku=l(Xu,"P",{"data-svelte-h":!0}),d(ku)!=="svelte-huzhzj"&&(ku.innerHTML=p0),Xu.forEach(p),Js.forEach(p),Sh=r(t),Zn=l(t,"DIV",{class:!0});var ef=q(Zn);h(Mc.$$.fragment,ef),_2=r(ef),Tu=l(ef,"P",{"data-svelte-h":!0}),d(Tu)!=="svelte-1cij9yu"&&(Tu.textContent=d0),ef.forEach(p),Gh=r(t),Q=l(t,"DIV",{class:!0});var En=q(Q);h(jc.$$.fragment,En),b2=r(En),qu=l(En,"P",{"data-svelte-h":!0}),d(qu)!=="svelte-bx32lj"&&(qu.textContent=g0),v2=r(En),Mu=l(En,"P",{"data-svelte-h":!0}),d(Mu)!=="svelte-1a6nwfz"&&(Mu.textContent=u0),y2=r(En),ju=l(En,"UL",{"data-svelte-h":!0}),d(ju)!=="svelte-1wreq5n"&&(ju.innerHTML=h0),x2=r(En),Hu=l(En,"P",{"data-svelte-h":!0}),d(Hu)!=="svelte-fipu1x"&&(Hu.innerHTML=f0),En.forEach(p),Lh=r(t),h(Hc.$$.fragment,t),Zh=r(t),D=l(t,"DIV",{class:!0});var X=q(D);h(Cc.$$.fragment,X),$2=r(X),Cu=l(X,"P",{"data-svelte-h":!0}),d(Cu)!=="svelte-1wfz9hx"&&(Cu.textContent=m0),w2=r(X),Uu=l(X,"P",{"data-svelte-h":!0}),d(Uu)!=="svelte-10g22je"&&(Uu.innerHTML=_0),k2=r(X),h(Hs.$$.fragment,X),T2=r(X),h(Cs.$$.fragment,X),q2=r(X),rt=l(X,"DIV",{class:!0});var Es=q(rt);h(Uc.$$.fragment,Es),M2=r(Es),Iu=l(Es,"P",{"data-svelte-h":!0}),d(Iu)!=="svelte-e95u7k"&&(Iu.textContent=b0),j2=r(Es),h(Us.$$.fragment,Es),H2=r(Es),Au=l(Es,"P",{"data-svelte-h":!0}),d(Au)!=="svelte-ulgg79"&&(Au.innerHTML=v0),Es.forEach(p),C2=r(X),Hn=l(X,"DIV",{class:!0});var zu=q(Hn);h(Ic.$$.fragment,zu),U2=r(zu),Nu=l(zu,"P",{"data-svelte-h":!0}),d(Nu)!=="svelte-t1x1k0"&&(Nu.textContent=y0),I2=r(zu),Ju=l(zu,"P",{"data-svelte-h":!0}),d(Ju)!=="svelte-1jdo3t2"&&(Ju.textContent=x0),zu.forEach(p),A2=r(X),Cn=l(X,"DIV",{class:!0});var Ou=q(Cn);h(Ac.$$.fragment,Ou),N2=r(Ou),Eu=l(Ou,"P",{"data-svelte-h":!0}),d(Eu)!=="svelte-m2dnyn"&&(Eu.innerHTML=$0),J2=r(Ou),Du=l(Ou,"P",{"data-svelte-h":!0}),d(Du)!=="svelte-aasb0o"&&(Du.innerHTML=w0),Ou.forEach(p),X.forEach(p),Vh=r(t),h(Nc.$$.fragment,t),Ph=r(t),Qu=l(t,"P",{}),q(Qu).forEach(p),this.h()},h(){M(o,"name","hf:doc:metadata"),M(o,"content",wM),M(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ro,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Lo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Yo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(en,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(sa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ra,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ca,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ua,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ha,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Na,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ra,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Sa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,y){n(document.head,o),$(t,v,y),$(t,i,y),$(t,a,y),f(g,t,y),$(t,e,y),$(t,x,y),$(t,Ku,y),$(t,Ds,y),$(t,eh,y),$(t,Rs,y),$(t,th,y),f(Fs,t,y),$(t,nh,y),f(Ss,t,y),$(t,oh,y),$(t,w,y),f(Gs,w,null),n(w,tf),n(w,el),n(w,nf),n(w,tl),n(w,of),n(w,Me),f(Ls,Me,null),n(Me,af),n(Me,nl),n(Me,sf),n(Me,ol),n(Me,rf),n(Me,al),n(w,cf),n(w,je),f(Zs,je,null),n(je,lf),n(je,sl),n(je,pf),n(je,rl),n(je,df),f($o,je,null),n(w,gf),n(w,Wt),f(Vs,Wt,null),n(Wt,uf),n(Wt,il),n(Wt,hf),n(Wt,cl),n(w,ff),n(w,Bt),f(Ps,Bt,null),n(Bt,mf),n(Bt,ll),n(Bt,_f),n(Bt,pl),n(w,bf),n(w,F),f(Ws,F,null),n(F,vf),n(F,dl),n(F,yf),n(F,gl),n(F,xf),n(F,ul),n(F,$f),f(wo,F,null),n(F,wf),n(F,hl),n(F,kf),n(F,fl),n(w,Tf),n(w,He),f(Bs,He,null),n(He,qf),n(He,ml),n(He,Mf),n(He,_l),n(He,jf),n(He,bl),n(w,Hf),n(w,Ce),f(Ys,Ce,null),n(Ce,Cf),n(Ce,vl),n(Ce,Uf),f(ko,Ce,null),n(Ce,If),f(To,Ce,null),n(w,Af),n(w,Ue),f(Xs,Ue,null),n(Ue,Nf),n(Ue,yl),n(Ue,Jf),f(qo,Ue,null),n(Ue,Ef),f(Mo,Ue,null),n(w,Df),n(w,jo),f(zs,jo,null),n(jo,Rf),n(jo,xl),n(w,Ff),n(w,Ie),f(Os,Ie,null),n(Ie,Sf),n(Ie,$l),n(Ie,Gf),n(Ie,wl),n(Ie,Lf),f(Ho,Ie,null),n(w,Zf),n(w,ae),f(Qs,ae,null),n(ae,Vf),n(ae,kl),n(ae,Pf),f(Co,ae,null),n(ae,Wf),f(Uo,ae,null),n(ae,Bf),f(Io,ae,null),n(w,Yf),n(w,Z),f(Ks,Z,null),n(Z,Xf),n(Z,Tl),n(Z,zf),n(Z,ql),n(Z,Of),n(Z,Ml),n(Z,Qf),n(Z,jl),n(Z,Kf),f(Ao,Z,null),n(w,em),n(w,Ae),f(er,Ae,null),n(Ae,tm),n(Ae,Hl),n(Ae,nm),f(No,Ae,null),n(Ae,om),f(Jo,Ae,null),n(w,am),n(w,Ne),f(tr,Ne,null),n(Ne,sm),n(Ne,Cl),n(Ne,rm),n(Ne,Ul),n(Ne,im),f(Eo,Ne,null),n(w,cm),n(w,V),f(nr,V,null),n(V,lm),n(V,Il),n(V,pm),n(V,Al),n(V,dm),n(V,Nl),n(V,gm),n(V,Jl),n(V,um),f(Do,V,null),n(w,hm),n(w,Ro),f(or,Ro,null),n(Ro,fm),n(Ro,El),n(w,mm),n(w,Fo),f(ar,Fo,null),n(Fo,_m),n(Fo,Dl),n(w,bm),n(w,Yt),f(sr,Yt,null),n(Yt,vm),n(Yt,Rl),n(Yt,ym),f(So,Yt,null),n(w,xm),n(w,Je),f(rr,Je,null),n(Je,$m),n(Je,Fl),n(Je,wm),n(Je,Sl),n(Je,km),f(Go,Je,null),n(w,Tm),n(w,Lo),f(ir,Lo,null),n(Lo,qm),n(Lo,Gl),n(w,Mm),n(w,Ee),f(cr,Ee,null),n(Ee,jm),n(Ee,Ll),n(Ee,Hm),f(Zo,Ee,null),n(Ee,Cm),f(Vo,Ee,null),n(w,Um),n(w,Xt),f(lr,Xt,null),n(Xt,Im),n(Xt,Zl),n(Xt,Am),f(Po,Xt,null),n(w,Nm),n(w,zt),f(pr,zt,null),n(zt,Jm),n(zt,Vl),n(zt,Em),f(Wo,zt,null),n(w,Dm),n(w,Ot),f(dr,Ot,null),n(Ot,Rm),n(Ot,Pl),n(Ot,Fm),n(Ot,Wl),n(w,Sm),n(w,Qt),f(gr,Qt,null),n(Qt,Gm),n(Qt,Bl),n(Qt,Lm),n(Qt,Yl),n(w,Zm),n(w,De),f(ur,De,null),n(De,Vm),n(De,Xl),n(De,Pm),n(De,zl),n(De,Wm),n(De,Ol),n(w,Bm),n(w,Bo),f(hr,Bo,null),n(Bo,Ym),n(Bo,Ql),n(w,Xm),n(w,Kt),f(fr,Kt,null),n(Kt,zm),n(Kt,Kl),n(Kt,Om),n(Kt,ep),n(w,Qm),n(w,Yo),f(mr,Yo,null),n(Yo,Km),n(Yo,tp),n(w,e_),n(w,en),f(_r,en,null),n(en,t_),n(en,np),n(en,n_),n(en,op),n(w,o_),n(w,Xo),f(br,Xo,null),n(Xo,a_),n(Xo,ap),n(w,s_),n(w,tn),f(vr,tn,null),n(tn,r_),n(tn,sp),n(tn,i_),f(zo,tn,null),n(w,c_),n(w,nn),f(yr,nn,null),n(nn,l_),n(nn,rp),n(nn,p_),f(Oo,nn,null),n(w,d_),n(w,Re),f(xr,Re,null),n(Re,g_),n(Re,ip),n(Re,u_),n(Re,cp),n(Re,h_),f(Qo,Re,null),n(w,f_),n(w,on),f($r,on,null),n(on,m_),n(on,lp),n(on,__),f(Ko,on,null),n(w,b_),n(w,an),f(wr,an,null),n(an,v_),n(an,pp),n(an,y_),f(ea,an,null),n(w,x_),n(w,sn),f(kr,sn,null),n(sn,$_),n(sn,dp),n(sn,w_),f(ta,sn,null),n(w,k_),n(w,Fe),f(Tr,Fe,null),n(Fe,T_),n(Fe,gp),n(Fe,q_),n(Fe,up),n(Fe,M_),f(na,Fe,null),n(w,j_),n(w,oa),f(qr,oa,null),n(oa,H_),n(oa,hp),n(w,C_),n(w,Se),f(Mr,Se,null),n(Se,U_),n(Se,fp),n(Se,I_),n(Se,mp),n(Se,A_),f(aa,Se,null),n(w,N_),n(w,sa),f(jr,sa,null),n(sa,J_),n(sa,_p),n(w,E_),n(w,ra),f(Hr,ra,null),n(ra,D_),n(ra,bp),n(w,R_),n(w,rn),f(Cr,rn,null),n(rn,F_),n(rn,vp),n(rn,S_),f(ia,rn,null),n(w,G_),n(w,ca),f(Ur,ca,null),n(ca,L_),n(ca,yp),n(w,Z_),n(w,cn),f(Ir,cn,null),n(cn,V_),n(cn,xp),n(cn,P_),f(la,cn,null),n(w,W_),n(w,se),f(Ar,se,null),n(se,B_),n(se,$p),n(se,Y_),n(se,wp),n(se,X_),f(pa,se,null),n(se,z_),f(da,se,null),n(w,O_),n(w,P),f(Nr,P,null),n(P,Q_),n(P,kp),n(P,K_),n(P,Tp),n(P,eb),n(P,qp),n(P,tb),n(P,Mp),n(P,nb),f(ga,P,null),n(w,ob),n(w,ua),f(Jr,ua,null),n(ua,ab),n(ua,jp),n(w,sb),n(w,ln),f(Er,ln,null),n(ln,rb),n(ln,Hp),n(ln,ib),n(ln,Cp),n(w,cb),n(w,Ge),f(Dr,Ge,null),n(Ge,lb),n(Ge,Up),n(Ge,pb),f(ha,Ge,null),n(Ge,db),n(Ge,Ip),n(w,gb),n(w,fa),f(Rr,fa,null),n(fa,ub),n(fa,Ap),n(w,hb),n(w,pn),f(Fr,pn,null),n(pn,fb),n(pn,Np),n(pn,mb),f(ma,pn,null),n(w,_b),n(w,Le),f(Sr,Le,null),n(Le,bb),n(Le,Jp),n(Le,vb),n(Le,Ep),n(Le,yb),n(Le,Dp),n(w,xb),n(w,W),f(Gr,W,null),n(W,$b),n(W,Rp),n(W,wb),n(W,Fp),n(W,kb),n(W,Sp),n(W,Tb),f(_a,W,null),n(W,qb),n(W,Gp),n(w,Mb),n(w,Ze),f(Lr,Ze,null),n(Ze,jb),n(Ze,Lp),n(Ze,Hb),f(ba,Ze,null),n(Ze,Cb),f(va,Ze,null),n(w,Ub),n(w,re),f(Zr,re,null),n(re,Ib),n(re,Zp),n(re,Ab),n(re,Vp),n(re,Nb),n(re,Pp),n(re,Jb),f(ya,re,null),n(w,Eb),n(w,dn),f(Vr,dn,null),n(dn,Db),n(dn,Wp),n(dn,Rb),f(xa,dn,null),n(w,Fb),n(w,Ve),f(Pr,Ve,null),n(Ve,Sb),n(Ve,Bp),n(Ve,Gb),f($a,Ve,null),n(Ve,Lb),f(wa,Ve,null),n(w,Zb),n(w,ie),f(Wr,ie,null),n(ie,Vb),n(ie,Yp),n(ie,Pb),n(ie,Xp),n(ie,Wb),n(ie,zp),n(ie,Bb),f(ka,ie,null),n(w,Yb),n(w,gn),f(Br,gn,null),n(gn,Xb),n(gn,Op),n(gn,zb),f(Ta,gn,null),n(w,Ob),n(w,ce),f(Yr,ce,null),n(ce,Qb),n(ce,Qp),n(ce,Kb),n(ce,Kp),n(ce,ev),n(ce,ed),n(ce,tv),f(qa,ce,null),n(w,nv),n(w,Pe),f(Xr,Pe,null),n(Pe,ov),n(Pe,td),n(Pe,av),f(Ma,Pe,null),n(Pe,sv),f(ja,Pe,null),n(w,rv),n(w,Ha),f(zr,Ha,null),n(Ha,iv),n(Ha,nd),n(w,cv),n(w,un),f(Or,un,null),n(un,lv),n(un,od),n(un,pv),f(Ca,un,null),n(w,dv),n(w,le),f(Qr,le,null),n(le,gv),n(le,ad),n(le,uv),n(le,sd),n(le,hv),n(le,rd),n(le,fv),f(Ua,le,null),n(w,mv),n(w,pe),f(Kr,pe,null),n(pe,_v),n(pe,id),n(pe,bv),n(pe,cd),n(pe,vv),n(pe,ld),n(pe,yv),f(Ia,pe,null),n(w,xv),n(w,We),f(ei,We,null),n(We,$v),n(We,pd),n(We,wv),n(We,dd),n(We,kv),f(Aa,We,null),n(w,Tv),n(w,Na),f(ti,Na,null),n(Na,qv),n(Na,gd),n(w,Mv),n(w,hn),f(ni,hn,null),n(hn,jv),n(hn,ud),n(hn,Hv),n(hn,hd),n(w,Cv),n(w,fn),f(oi,fn,null),n(fn,Uv),n(fn,fd),n(fn,Iv),f(Ja,fn,null),n(w,Av),n(w,S),f(ai,S,null),n(S,Nv),n(S,md),n(S,Jv),n(S,_d),n(S,Ev),n(S,bd),n(S,Dv),f(Ea,S,null),n(S,Rv),n(S,vd),n(S,Fv),f(Da,S,null),n(w,Sv),n(w,Ra),f(si,Ra,null),n(Ra,Gv),n(Ra,yd),n(w,Lv),n(w,Fa),f(ri,Fa,null),n(Fa,Zv),n(Fa,xd),n(w,Vv),n(w,Sa),f(ii,Sa,null),n(Sa,Pv),n(Sa,$d),n(w,Wv),n(w,mn),f(ci,mn,null),n(mn,Bv),n(mn,wd),n(mn,Yv),f(Ga,mn,null),n(w,Xv),n(w,_n),f(li,_n,null),n(_n,zv),n(_n,kd),n(_n,Ov),f(La,_n,null),n(w,Qv),n(w,Be),f(pi,Be,null),n(Be,Kv),n(Be,Td),n(Be,ey),n(Be,qd),n(Be,ty),f(Za,Be,null),n(w,ny),n(w,Ye),f(di,Ye,null),n(Ye,oy),n(Ye,Md),n(Ye,ay),n(Ye,jd),n(Ye,sy),f(Va,Ye,null),n(w,ry),n(w,Pa),f(gi,Pa,null),n(Pa,iy),n(Pa,Hd),n(w,cy),n(w,Xe),f(ui,Xe,null),n(Xe,ly),n(Xe,Cd),n(Xe,py),n(Xe,Ud),n(Xe,dy),n(Xe,Id),n(w,gy),n(w,ze),f(hi,ze,null),n(ze,uy),n(ze,Ad),n(ze,hy),n(ze,Nd),n(ze,fy),n(ze,Jd),n(w,my),n(w,Oe),f(fi,Oe,null),n(Oe,_y),n(Oe,Ed),n(Oe,by),n(Oe,Dd),n(Oe,vy),n(Oe,Rd),n(w,yy),n(w,B),f(mi,B,null),n(B,xy),n(B,Fd),n(B,$y),n(B,Sd),n(B,wy),f(Wa,B,null),n(B,ky),f(Ba,B,null),n(B,Ty),f(Ya,B,null),n(w,qy),n(w,Qe),f(_i,Qe,null),n(Qe,My),n(Qe,Gd),n(Qe,jy),n(Qe,Ld),n(Qe,Hy),n(Qe,Zd),n(w,Cy),n(w,Ke),f(bi,Ke,null),n(Ke,Uy),n(Ke,Vd),n(Ke,Iy),f(Xa,Ke,null),n(Ke,Ay),f(za,Ke,null),n(w,Ny),n(w,bn),f(vi,bn,null),n(bn,Jy),n(bn,Pd),n(bn,Ey),f(Oa,bn,null),n(w,Dy),n(w,vn),f(yi,vn,null),n(vn,Ry),n(vn,Wd),n(vn,Fy),f(Qa,vn,null),n(w,Sy),n(w,yn),f(xi,yn,null),n(yn,Gy),n(yn,Bd),n(yn,Ly),f(Ka,yn,null),n(w,Zy),n(w,xn),f($i,xn,null),n(xn,Vy),n(xn,Yd),n(xn,Py),f(es,xn,null),n(w,Wy),n(w,et),f(wi,et,null),n(et,By),n(et,Xd),n(et,Yy),n(et,zd),n(et,Xy),n(et,Od),n(w,zy),n(w,$n),f(ki,$n,null),n($n,Oy),n($n,Qd),n($n,Qy),n($n,Kd),n(w,Ky),n(w,wn),f(Ti,wn,null),n(wn,ex),n(wn,eg),n(wn,tx),f(ts,wn,null),n(w,nx),n(w,de),f(qi,de,null),n(de,ox),n(de,tg),n(de,ax),n(de,ng),n(de,sx),n(de,og),n(de,rx),f(ns,de,null),n(w,ix),n(w,tt),f(Mi,tt,null),n(tt,cx),n(tt,ag),n(tt,lx),n(tt,sg),n(tt,px),n(tt,rg),n(w,dx),n(w,nt),f(ji,nt,null),n(nt,gx),n(nt,ig),n(nt,ux),n(nt,cg),n(nt,hx),f(os,nt,null),n(w,fx),n(w,ge),f(Hi,ge,null),n(ge,mx),n(ge,lg),n(ge,_x),n(ge,pg),n(ge,bx),n(ge,dg),n(ge,vx),n(ge,gg),n(w,yx),n(w,ot),f(Ci,ot,null),n(ot,xx),n(ot,ug),n(ot,$x),n(ot,hg),n(ot,wx),f(as,ot,null),n(w,kx),n(w,Y),f(Ui,Y,null),n(Y,Tx),n(Y,fg),n(Y,qx),n(Y,mg),n(Y,Mx),f(ss,Y,null),n(Y,jx),f(rs,Y,null),n(Y,Hx),f(is,Y,null),n(w,Cx),n(w,ue),f(Ii,ue,null),n(ue,Ux),n(ue,_g),n(ue,Ix),n(ue,bg),n(ue,Ax),n(ue,vg),n(ue,Nx),f(cs,ue,null),n(w,Jx),n(w,kn),f(Ai,kn,null),n(kn,Ex),n(kn,yg),n(kn,Dx),f(ls,kn,null),n(w,Rx),n(w,he),f(Ni,he,null),n(he,Fx),n(he,xg),n(he,Sx),n(he,$g),n(he,Gx),n(he,wg),n(he,Lx),f(ps,he,null),n(w,Zx),n(w,at),f(Ji,at,null),n(at,Vx),n(at,kg),n(at,Px),n(at,Tg),n(at,Wx),n(at,qg),n(w,Bx),n(w,Tn),f(Ei,Tn,null),n(Tn,Yx),n(Tn,Mg),n(Tn,Xx),n(Tn,jg),n(w,zx),n(w,st),f(Di,st,null),n(st,Ox),n(st,Hg),n(st,Qx),n(st,Cg),n(st,Kx),f(ds,st,null),n(w,e$),n(w,qn),f(Ri,qn,null),n(qn,t$),n(qn,Ug),n(qn,n$),f(gs,qn,null),n(w,o$),n(w,fe),f(Fi,fe,null),n(fe,a$),n(fe,Ig),n(fe,s$),f(us,fe,null),n(fe,r$),f(hs,fe,null),n(fe,i$),f(fs,fe,null),n(w,c$),n(w,N),f(Si,N,null),n(N,l$),n(N,Ag),n(N,p$),n(N,Ng),n(N,d$),n(N,Jg),n(N,g$),n(N,Eg),n(N,u$),n(N,Dg),n(N,h$),n(N,Rg),n(N,f$),f(ms,N,null),n(N,m$),f(_s,N,null),n(N,_$),f(bs,N,null),n(N,b$),f(vs,N,null),n(w,v$),n(w,A),f(Gi,A,null),n(A,y$),n(A,Fg),n(A,x$),n(A,Sg),n(A,$$),f(ys,A,null),n(A,w$),f(xs,A,null),n(A,k$),n(A,Gg),n(A,T$),n(A,Lg),n(A,q$),n(A,Zg),n(A,M$),n(A,Vg),n(A,j$),n(A,Pg),n(A,H$),n(A,Wg),n(A,C$),n(A,Bg),n(w,U$),n(w,$s),f(Li,$s,null),n($s,I$),n($s,Yg),$(t,ah,y),f(Zi,t,y),$(t,sh,y),f(Vi,t,y),$(t,rh,y),$(t,Dn,y),f(Pi,Dn,null),n(Dn,A$),n(Dn,Xg),$(t,ih,y),f(Wi,t,y),$(t,ch,y),$(t,ct,y),f(Bi,ct,null),n(ct,N$),n(ct,zg),n(ct,J$),n(ct,Og),$(t,lh,y),f(Yi,t,y),$(t,ph,y),$(t,lt,y),f(Xi,lt,null),n(lt,E$),n(lt,Qg),n(lt,D$),f(ws,lt,null),$(t,dh,y),f(zi,t,y),$(t,gh,y),$(t,Rn,y),f(Oi,Rn,null),n(Rn,R$),n(Rn,Kg),$(t,uh,y),f(Qi,t,y),$(t,hh,y),$(t,Fn,y),f(Ki,Fn,null),n(Fn,F$),n(Fn,eu),$(t,fh,y),f(ec,t,y),$(t,mh,y),$(t,pt,y),f(tc,pt,null),n(pt,S$),n(pt,tu),n(pt,G$),n(pt,nu),$(t,_h,y),f(nc,t,y),$(t,bh,y),$(t,dt,y),f(oc,dt,null),n(dt,L$),n(dt,ou),n(dt,Z$),f(ks,dt,null),$(t,vh,y),f(ac,t,y),$(t,yh,y),$(t,gt,y),f(sc,gt,null),n(gt,V$),n(gt,au),n(gt,P$),f(Ts,gt,null),$(t,xh,y),f(rc,t,y),$(t,$h,y),$(t,Sn,y),f(ic,Sn,null),n(Sn,W$),n(Sn,su),$(t,wh,y),f(cc,t,y),$(t,kh,y),$(t,z,y),f(lc,z,null),n(z,B$),n(z,ru),n(z,Y$),n(z,iu),n(z,X$),n(z,cu),n(z,z$),f(qs,z,null),$(t,Th,y),f(pc,t,y),$(t,qh,y),$(t,O,y),f(dc,O,null),n(O,O$),n(O,lu),n(O,Q$),n(O,pu),n(O,K$),n(O,du),n(O,e2),n(O,gu),$(t,Mh,y),f(gc,t,y),$(t,jh,y),$(t,me,y),f(uc,me,null),n(me,t2),n(me,uu),n(me,n2),n(me,hu),n(me,o2),n(me,fu),$(t,Hh,y),f(hc,t,y),$(t,Ch,y),$(t,ut,y),f(fc,ut,null),n(ut,a2),n(ut,mu),n(ut,s2),f(Ms,ut,null),$(t,Uh,y),f(mc,t,y),$(t,Ih,y),$(t,ht,y),f(_c,ht,null),n(ht,r2),n(ht,_u),n(ht,i2),n(ht,bu),$(t,Ah,y),f(bc,t,y),$(t,Nh,y),$(t,Gn,y),f(vc,Gn,null),n(Gn,c2),n(Gn,vu),$(t,Jh,y),f(yc,t,y),$(t,Eh,y),$(t,Ln,y),f(xc,Ln,null),n(Ln,l2),n(Ln,yu),$(t,Dh,y),f($c,t,y),$(t,Rh,y),$(t,wc,y),$(t,Fh,y),$(t,_e,y),f(kc,_e,null),n(_e,p2),n(_e,xu),n(_e,d2),n(_e,Mn),f(Tc,Mn,null),n(Mn,g2),n(Mn,$u),n(Mn,u2),f(js,Mn,null),n(_e,h2),n(_e,jn),f(qc,jn,null),n(jn,f2),n(jn,wu),n(jn,m2),n(jn,ku),$(t,Sh,y),$(t,Zn,y),f(Mc,Zn,null),n(Zn,_2),n(Zn,Tu),$(t,Gh,y),$(t,Q,y),f(jc,Q,null),n(Q,b2),n(Q,qu),n(Q,v2),n(Q,Mu),n(Q,y2),n(Q,ju),n(Q,x2),n(Q,Hu),$(t,Lh,y),f(Hc,t,y),$(t,Zh,y),$(t,D,y),f(Cc,D,null),n(D,$2),n(D,Cu),n(D,w2),n(D,Uu),n(D,k2),f(Hs,D,null),n(D,T2),f(Cs,D,null),n(D,q2),n(D,rt),f(Uc,rt,null),n(rt,M2),n(rt,Iu),n(rt,j2),f(Us,rt,null),n(rt,H2),n(rt,Au),n(D,C2),n(D,Hn),f(Ic,Hn,null),n(Hn,U2),n(Hn,Nu),n(Hn,I2),n(Hn,Ju),n(D,A2),n(D,Cn),f(Ac,Cn,null),n(Cn,N2),n(Cn,Eu),n(Cn,J2),n(Cn,Du),$(t,Vh,y),f(Nc,t,y),$(t,Ph,y),$(t,Qu,y),Wh=!0},p(t,[y]){const k={};y&2&&(k.$$scope={dirty:y,ctx:t}),$o.$set(k);const ft={};y&2&&(ft.$$scope={dirty:y,ctx:t}),wo.$set(ft);const mt={};y&2&&(mt.$$scope={dirty:y,ctx:t}),ko.$set(mt);const Vn={};y&2&&(Vn.$$scope={dirty:y,ctx:t}),To.$set(Vn);const Pn={};y&2&&(Pn.$$scope={dirty:y,ctx:t}),qo.$set(Pn);const G={};y&2&&(G.$$scope={dirty:y,ctx:t}),Mo.$set(G);const _t={};y&2&&(_t.$$scope={dirty:y,ctx:t}),Ho.$set(_t);const bt={};y&2&&(bt.$$scope={dirty:y,ctx:t}),Co.$set(bt);const vt={};y&2&&(vt.$$scope={dirty:y,ctx:t}),Uo.$set(vt);const Jc={};y&2&&(Jc.$$scope={dirty:y,ctx:t}),Io.$set(Jc);const yt={};y&2&&(yt.$$scope={dirty:y,ctx:t}),Ao.$set(yt);const be={};y&2&&(be.$$scope={dirty:y,ctx:t}),No.$set(be);const K={};y&2&&(K.$$scope={dirty:y,ctx:t}),Jo.$set(K);const xt={};y&2&&(xt.$$scope={dirty:y,ctx:t}),Eo.$set(xt);const $t={};y&2&&($t.$$scope={dirty:y,ctx:t}),Do.$set($t);const ee={};y&2&&(ee.$$scope={dirty:y,ctx:t}),So.$set(ee);const Ec={};y&2&&(Ec.$$scope={dirty:y,ctx:t}),Go.$set(Ec);const Dc={};y&2&&(Dc.$$scope={dirty:y,ctx:t}),Zo.$set(Dc);const Wn={};y&2&&(Wn.$$scope={dirty:y,ctx:t}),Vo.$set(Wn);const wt={};y&2&&(wt.$$scope={dirty:y,ctx:t}),Po.$set(wt);const Rc={};y&2&&(Rc.$$scope={dirty:y,ctx:t}),Wo.$set(Rc);const kt={};y&2&&(kt.$$scope={dirty:y,ctx:t}),zo.$set(kt);const Bn={};y&2&&(Bn.$$scope={dirty:y,ctx:t}),Oo.$set(Bn);const Yn={};y&2&&(Yn.$$scope={dirty:y,ctx:t}),Qo.$set(Yn);const Xn={};y&2&&(Xn.$$scope={dirty:y,ctx:t}),Ko.$set(Xn);const zn={};y&2&&(zn.$$scope={dirty:y,ctx:t}),ea.$set(zn);const Tt={};y&2&&(Tt.$$scope={dirty:y,ctx:t}),ta.$set(Tt);const Fc={};y&2&&(Fc.$$scope={dirty:y,ctx:t}),na.$set(Fc);const On={};y&2&&(On.$$scope={dirty:y,ctx:t}),aa.$set(On);const Sc={};y&2&&(Sc.$$scope={dirty:y,ctx:t}),ia.$set(Sc);const Qn={};y&2&&(Qn.$$scope={dirty:y,ctx:t}),la.$set(Qn);const Gc={};y&2&&(Gc.$$scope={dirty:y,ctx:t}),pa.$set(Gc);const Kn={};y&2&&(Kn.$$scope={dirty:y,ctx:t}),da.$set(Kn);const eo={};y&2&&(eo.$$scope={dirty:y,ctx:t}),ga.$set(eo);const qt={};y&2&&(qt.$$scope={dirty:y,ctx:t}),ha.$set(qt);const to={};y&2&&(to.$$scope={dirty:y,ctx:t}),ma.$set(to);const no={};y&2&&(no.$$scope={dirty:y,ctx:t}),_a.$set(no);const oo={};y&2&&(oo.$$scope={dirty:y,ctx:t}),ba.$set(oo);const Mt={};y&2&&(Mt.$$scope={dirty:y,ctx:t}),va.$set(Mt);const Lc={};y&2&&(Lc.$$scope={dirty:y,ctx:t}),ya.$set(Lc);const jt={};y&2&&(jt.$$scope={dirty:y,ctx:t}),xa.$set(jt);const Zc={};y&2&&(Zc.$$scope={dirty:y,ctx:t}),$a.$set(Zc);const Vc={};y&2&&(Vc.$$scope={dirty:y,ctx:t}),wa.$set(Vc);const ao={};y&2&&(ao.$$scope={dirty:y,ctx:t}),ka.$set(ao);const Pc={};y&2&&(Pc.$$scope={dirty:y,ctx:t}),Ta.$set(Pc);const so={};y&2&&(so.$$scope={dirty:y,ctx:t}),qa.$set(so);const ve={};y&2&&(ve.$$scope={dirty:y,ctx:t}),Ma.$set(ve);const te={};y&2&&(te.$$scope={dirty:y,ctx:t}),ja.$set(te);const Wc={};y&2&&(Wc.$$scope={dirty:y,ctx:t}),Ca.$set(Wc);const ro={};y&2&&(ro.$$scope={dirty:y,ctx:t}),Ua.$set(ro);const Ht={};y&2&&(Ht.$$scope={dirty:y,ctx:t}),Ia.$set(Ht);const Bc={};y&2&&(Bc.$$scope={dirty:y,ctx:t}),Aa.$set(Bc);const io={};y&2&&(io.$$scope={dirty:y,ctx:t}),Ja.$set(io);const Ct={};y&2&&(Ct.$$scope={dirty:y,ctx:t}),Ea.$set(Ct);const ne={};y&2&&(ne.$$scope={dirty:y,ctx:t}),Da.$set(ne);const Ut={};y&2&&(Ut.$$scope={dirty:y,ctx:t}),Ga.$set(Ut);const ye={};y&2&&(ye.$$scope={dirty:y,ctx:t}),La.$set(ye);const co={};y&2&&(co.$$scope={dirty:y,ctx:t}),Za.$set(co);const It={};y&2&&(It.$$scope={dirty:y,ctx:t}),Va.$set(It);const xe={};y&2&&(xe.$$scope={dirty:y,ctx:t}),Wa.$set(xe);const lo={};y&2&&(lo.$$scope={dirty:y,ctx:t}),Ba.$set(lo);const $e={};y&2&&($e.$$scope={dirty:y,ctx:t}),Ya.$set($e);const At={};y&2&&(At.$$scope={dirty:y,ctx:t}),Xa.$set(At);const Yc={};y&2&&(Yc.$$scope={dirty:y,ctx:t}),za.$set(Yc);const po={};y&2&&(po.$$scope={dirty:y,ctx:t}),Oa.$set(po);const we={};y&2&&(we.$$scope={dirty:y,ctx:t}),Qa.$set(we);const ke={};y&2&&(ke.$$scope={dirty:y,ctx:t}),Ka.$set(ke);const Nt={};y&2&&(Nt.$$scope={dirty:y,ctx:t}),es.$set(Nt);const Xc={};y&2&&(Xc.$$scope={dirty:y,ctx:t}),ts.$set(Xc);const go={};y&2&&(go.$$scope={dirty:y,ctx:t}),ns.$set(go);const uo={};y&2&&(uo.$$scope={dirty:y,ctx:t}),os.$set(uo);const L={};y&2&&(L.$$scope={dirty:y,ctx:t}),as.$set(L);const zc={};y&2&&(zc.$$scope={dirty:y,ctx:t}),ss.$set(zc);const Oc={};y&2&&(Oc.$$scope={dirty:y,ctx:t}),rs.$set(Oc);const Qc={};y&2&&(Qc.$$scope={dirty:y,ctx:t}),is.$set(Qc);const ho={};y&2&&(ho.$$scope={dirty:y,ctx:t}),cs.$set(ho);const fo={};y&2&&(fo.$$scope={dirty:y,ctx:t}),ls.$set(fo);const Jt={};y&2&&(Jt.$$scope={dirty:y,ctx:t}),ps.$set(Jt);const Et={};y&2&&(Et.$$scope={dirty:y,ctx:t}),ds.$set(Et);const Kc={};y&2&&(Kc.$$scope={dirty:y,ctx:t}),gs.$set(Kc);const Dt={};y&2&&(Dt.$$scope={dirty:y,ctx:t}),us.$set(Dt);const Rt={};y&2&&(Rt.$$scope={dirty:y,ctx:t}),hs.$set(Rt);const Ft={};y&2&&(Ft.$$scope={dirty:y,ctx:t}),fs.$set(Ft);const oe={};y&2&&(oe.$$scope={dirty:y,ctx:t}),ms.$set(oe);const St={};y&2&&(St.$$scope={dirty:y,ctx:t}),_s.$set(St);const Gt={};y&2&&(Gt.$$scope={dirty:y,ctx:t}),bs.$set(Gt);const mo={};y&2&&(mo.$$scope={dirty:y,ctx:t}),vs.$set(mo);const _o={};y&2&&(_o.$$scope={dirty:y,ctx:t}),ys.$set(_o);const bo={};y&2&&(bo.$$scope={dirty:y,ctx:t}),xs.$set(bo);const vo={};y&2&&(vo.$$scope={dirty:y,ctx:t}),ws.$set(vo);const Lt={};y&2&&(Lt.$$scope={dirty:y,ctx:t}),ks.$set(Lt);const yo={};y&2&&(yo.$$scope={dirty:y,ctx:t}),Ts.$set(yo);const xo={};y&2&&(xo.$$scope={dirty:y,ctx:t}),qs.$set(xo);const Te={};y&2&&(Te.$$scope={dirty:y,ctx:t}),Ms.$set(Te);const Zt={};y&2&&(Zt.$$scope={dirty:y,ctx:t}),js.$set(Zt);const Vt={};y&2&&(Vt.$$scope={dirty:y,ctx:t}),Hs.$set(Vt);const qe={};y&2&&(qe.$$scope={dirty:y,ctx:t}),Cs.$set(qe);const Pt={};y&2&&(Pt.$$scope={dirty:y,ctx:t}),Us.$set(Pt)},i(t){Wh||(m(g.$$.fragment,t),m(Fs.$$.fragment,t),m(Ss.$$.fragment,t),m(Gs.$$.fragment,t),m(Ls.$$.fragment,t),m(Zs.$$.fragment,t),m($o.$$.fragment,t),m(Vs.$$.fragment,t),m(Ps.$$.fragment,t),m(Ws.$$.fragment,t),m(wo.$$.fragment,t),m(Bs.$$.fragment,t),m(Ys.$$.fragment,t),m(ko.$$.fragment,t),m(To.$$.fragment,t),m(Xs.$$.fragment,t),m(qo.$$.fragment,t),m(Mo.$$.fragment,t),m(zs.$$.fragment,t),m(Os.$$.fragment,t),m(Ho.$$.fragment,t),m(Qs.$$.fragment,t),m(Co.$$.fragment,t),m(Uo.$$.fragment,t),m(Io.$$.fragment,t),m(Ks.$$.fragment,t),m(Ao.$$.fragment,t),m(er.$$.fragment,t),m(No.$$.fragment,t),m(Jo.$$.fragment,t),m(tr.$$.fragment,t),m(Eo.$$.fragment,t),m(nr.$$.fragment,t),m(Do.$$.fragment,t),m(or.$$.fragment,t),m(ar.$$.fragment,t),m(sr.$$.fragment,t),m(So.$$.fragment,t),m(rr.$$.fragment,t),m(Go.$$.fragment,t),m(ir.$$.fragment,t),m(cr.$$.fragment,t),m(Zo.$$.fragment,t),m(Vo.$$.fragment,t),m(lr.$$.fragment,t),m(Po.$$.fragment,t),m(pr.$$.fragment,t),m(Wo.$$.fragment,t),m(dr.$$.fragment,t),m(gr.$$.fragment,t),m(ur.$$.fragment,t),m(hr.$$.fragment,t),m(fr.$$.fragment,t),m(mr.$$.fragment,t),m(_r.$$.fragment,t),m(br.$$.fragment,t),m(vr.$$.fragment,t),m(zo.$$.fragment,t),m(yr.$$.fragment,t),m(Oo.$$.fragment,t),m(xr.$$.fragment,t),m(Qo.$$.fragment,t),m($r.$$.fragment,t),m(Ko.$$.fragment,t),m(wr.$$.fragment,t),m(ea.$$.fragment,t),m(kr.$$.fragment,t),m(ta.$$.fragment,t),m(Tr.$$.fragment,t),m(na.$$.fragment,t),m(qr.$$.fragment,t),m(Mr.$$.fragment,t),m(aa.$$.fragment,t),m(jr.$$.fragment,t),m(Hr.$$.fragment,t),m(Cr.$$.fragment,t),m(ia.$$.fragment,t),m(Ur.$$.fragment,t),m(Ir.$$.fragment,t),m(la.$$.fragment,t),m(Ar.$$.fragment,t),m(pa.$$.fragment,t),m(da.$$.fragment,t),m(Nr.$$.fragment,t),m(ga.$$.fragment,t),m(Jr.$$.fragment,t),m(Er.$$.fragment,t),m(Dr.$$.fragment,t),m(ha.$$.fragment,t),m(Rr.$$.fragment,t),m(Fr.$$.fragment,t),m(ma.$$.fragment,t),m(Sr.$$.fragment,t),m(Gr.$$.fragment,t),m(_a.$$.fragment,t),m(Lr.$$.fragment,t),m(ba.$$.fragment,t),m(va.$$.fragment,t),m(Zr.$$.fragment,t),m(ya.$$.fragment,t),m(Vr.$$.fragment,t),m(xa.$$.fragment,t),m(Pr.$$.fragment,t),m($a.$$.fragment,t),m(wa.$$.fragment,t),m(Wr.$$.fragment,t),m(ka.$$.fragment,t),m(Br.$$.fragment,t),m(Ta.$$.fragment,t),m(Yr.$$.fragment,t),m(qa.$$.fragment,t),m(Xr.$$.fragment,t),m(Ma.$$.fragment,t),m(ja.$$.fragment,t),m(zr.$$.fragment,t),m(Or.$$.fragment,t),m(Ca.$$.fragment,t),m(Qr.$$.fragment,t),m(Ua.$$.fragment,t),m(Kr.$$.fragment,t),m(Ia.$$.fragment,t),m(ei.$$.fragment,t),m(Aa.$$.fragment,t),m(ti.$$.fragment,t),m(ni.$$.fragment,t),m(oi.$$.fragment,t),m(Ja.$$.fragment,t),m(ai.$$.fragment,t),m(Ea.$$.fragment,t),m(Da.$$.fragment,t),m(si.$$.fragment,t),m(ri.$$.fragment,t),m(ii.$$.fragment,t),m(ci.$$.fragment,t),m(Ga.$$.fragment,t),m(li.$$.fragment,t),m(La.$$.fragment,t),m(pi.$$.fragment,t),m(Za.$$.fragment,t),m(di.$$.fragment,t),m(Va.$$.fragment,t),m(gi.$$.fragment,t),m(ui.$$.fragment,t),m(hi.$$.fragment,t),m(fi.$$.fragment,t),m(mi.$$.fragment,t),m(Wa.$$.fragment,t),m(Ba.$$.fragment,t),m(Ya.$$.fragment,t),m(_i.$$.fragment,t),m(bi.$$.fragment,t),m(Xa.$$.fragment,t),m(za.$$.fragment,t),m(vi.$$.fragment,t),m(Oa.$$.fragment,t),m(yi.$$.fragment,t),m(Qa.$$.fragment,t),m(xi.$$.fragment,t),m(Ka.$$.fragment,t),m($i.$$.fragment,t),m(es.$$.fragment,t),m(wi.$$.fragment,t),m(ki.$$.fragment,t),m(Ti.$$.fragment,t),m(ts.$$.fragment,t),m(qi.$$.fragment,t),m(ns.$$.fragment,t),m(Mi.$$.fragment,t),m(ji.$$.fragment,t),m(os.$$.fragment,t),m(Hi.$$.fragment,t),m(Ci.$$.fragment,t),m(as.$$.fragment,t),m(Ui.$$.fragment,t),m(ss.$$.fragment,t),m(rs.$$.fragment,t),m(is.$$.fragment,t),m(Ii.$$.fragment,t),m(cs.$$.fragment,t),m(Ai.$$.fragment,t),m(ls.$$.fragment,t),m(Ni.$$.fragment,t),m(ps.$$.fragment,t),m(Ji.$$.fragment,t),m(Ei.$$.fragment,t),m(Di.$$.fragment,t),m(ds.$$.fragment,t),m(Ri.$$.fragment,t),m(gs.$$.fragment,t),m(Fi.$$.fragment,t),m(us.$$.fragment,t),m(hs.$$.fragment,t),m(fs.$$.fragment,t),m(Si.$$.fragment,t),m(ms.$$.fragment,t),m(_s.$$.fragment,t),m(bs.$$.fragment,t),m(vs.$$.fragment,t),m(Gi.$$.fragment,t),m(ys.$$.fragment,t),m(xs.$$.fragment,t),m(Li.$$.fragment,t),m(Zi.$$.fragment,t),m(Vi.$$.fragment,t),m(Pi.$$.fragment,t),m(Wi.$$.fragment,t),m(Bi.$$.fragment,t),m(Yi.$$.fragment,t),m(Xi.$$.fragment,t),m(ws.$$.fragment,t),m(zi.$$.fragment,t),m(Oi.$$.fragment,t),m(Qi.$$.fragment,t),m(Ki.$$.fragment,t),m(ec.$$.fragment,t),m(tc.$$.fragment,t),m(nc.$$.fragment,t),m(oc.$$.fragment,t),m(ks.$$.fragment,t),m(ac.$$.fragment,t),m(sc.$$.fragment,t),m(Ts.$$.fragment,t),m(rc.$$.fragment,t),m(ic.$$.fragment,t),m(cc.$$.fragment,t),m(lc.$$.fragment,t),m(qs.$$.fragment,t),m(pc.$$.fragment,t),m(dc.$$.fragment,t),m(gc.$$.fragment,t),m(uc.$$.fragment,t),m(hc.$$.fragment,t),m(fc.$$.fragment,t),m(Ms.$$.fragment,t),m(mc.$$.fragment,t),m(_c.$$.fragment,t),m(bc.$$.fragment,t),m(vc.$$.fragment,t),m(yc.$$.fragment,t),m(xc.$$.fragment,t),m($c.$$.fragment,t),m(kc.$$.fragment,t),m(Tc.$$.fragment,t),m(js.$$.fragment,t),m(qc.$$.fragment,t),m(Mc.$$.fragment,t),m(jc.$$.fragment,t),m(Hc.$$.fragment,t),m(Cc.$$.fragment,t),m(Hs.$$.fragment,t),m(Cs.$$.fragment,t),m(Uc.$$.fragment,t),m(Us.$$.fragment,t),m(Ic.$$.fragment,t),m(Ac.$$.fragment,t),m(Nc.$$.fragment,t),Wh=!0)},o(t){_(g.$$.fragment,t),_(Fs.$$.fragment,t),_(Ss.$$.fragment,t),_(Gs.$$.fragment,t),_(Ls.$$.fragment,t),_(Zs.$$.fragment,t),_($o.$$.fragment,t),_(Vs.$$.fragment,t),_(Ps.$$.fragment,t),_(Ws.$$.fragment,t),_(wo.$$.fragment,t),_(Bs.$$.fragment,t),_(Ys.$$.fragment,t),_(ko.$$.fragment,t),_(To.$$.fragment,t),_(Xs.$$.fragment,t),_(qo.$$.fragment,t),_(Mo.$$.fragment,t),_(zs.$$.fragment,t),_(Os.$$.fragment,t),_(Ho.$$.fragment,t),_(Qs.$$.fragment,t),_(Co.$$.fragment,t),_(Uo.$$.fragment,t),_(Io.$$.fragment,t),_(Ks.$$.fragment,t),_(Ao.$$.fragment,t),_(er.$$.fragment,t),_(No.$$.fragment,t),_(Jo.$$.fragment,t),_(tr.$$.fragment,t),_(Eo.$$.fragment,t),_(nr.$$.fragment,t),_(Do.$$.fragment,t),_(or.$$.fragment,t),_(ar.$$.fragment,t),_(sr.$$.fragment,t),_(So.$$.fragment,t),_(rr.$$.fragment,t),_(Go.$$.fragment,t),_(ir.$$.fragment,t),_(cr.$$.fragment,t),_(Zo.$$.fragment,t),_(Vo.$$.fragment,t),_(lr.$$.fragment,t),_(Po.$$.fragment,t),_(pr.$$.fragment,t),_(Wo.$$.fragment,t),_(dr.$$.fragment,t),_(gr.$$.fragment,t),_(ur.$$.fragment,t),_(hr.$$.fragment,t),_(fr.$$.fragment,t),_(mr.$$.fragment,t),_(_r.$$.fragment,t),_(br.$$.fragment,t),_(vr.$$.fragment,t),_(zo.$$.fragment,t),_(yr.$$.fragment,t),_(Oo.$$.fragment,t),_(xr.$$.fragment,t),_(Qo.$$.fragment,t),_($r.$$.fragment,t),_(Ko.$$.fragment,t),_(wr.$$.fragment,t),_(ea.$$.fragment,t),_(kr.$$.fragment,t),_(ta.$$.fragment,t),_(Tr.$$.fragment,t),_(na.$$.fragment,t),_(qr.$$.fragment,t),_(Mr.$$.fragment,t),_(aa.$$.fragment,t),_(jr.$$.fragment,t),_(Hr.$$.fragment,t),_(Cr.$$.fragment,t),_(ia.$$.fragment,t),_(Ur.$$.fragment,t),_(Ir.$$.fragment,t),_(la.$$.fragment,t),_(Ar.$$.fragment,t),_(pa.$$.fragment,t),_(da.$$.fragment,t),_(Nr.$$.fragment,t),_(ga.$$.fragment,t),_(Jr.$$.fragment,t),_(Er.$$.fragment,t),_(Dr.$$.fragment,t),_(ha.$$.fragment,t),_(Rr.$$.fragment,t),_(Fr.$$.fragment,t),_(ma.$$.fragment,t),_(Sr.$$.fragment,t),_(Gr.$$.fragment,t),_(_a.$$.fragment,t),_(Lr.$$.fragment,t),_(ba.$$.fragment,t),_(va.$$.fragment,t),_(Zr.$$.fragment,t),_(ya.$$.fragment,t),_(Vr.$$.fragment,t),_(xa.$$.fragment,t),_(Pr.$$.fragment,t),_($a.$$.fragment,t),_(wa.$$.fragment,t),_(Wr.$$.fragment,t),_(ka.$$.fragment,t),_(Br.$$.fragment,t),_(Ta.$$.fragment,t),_(Yr.$$.fragment,t),_(qa.$$.fragment,t),_(Xr.$$.fragment,t),_(Ma.$$.fragment,t),_(ja.$$.fragment,t),_(zr.$$.fragment,t),_(Or.$$.fragment,t),_(Ca.$$.fragment,t),_(Qr.$$.fragment,t),_(Ua.$$.fragment,t),_(Kr.$$.fragment,t),_(Ia.$$.fragment,t),_(ei.$$.fragment,t),_(Aa.$$.fragment,t),_(ti.$$.fragment,t),_(ni.$$.fragment,t),_(oi.$$.fragment,t),_(Ja.$$.fragment,t),_(ai.$$.fragment,t),_(Ea.$$.fragment,t),_(Da.$$.fragment,t),_(si.$$.fragment,t),_(ri.$$.fragment,t),_(ii.$$.fragment,t),_(ci.$$.fragment,t),_(Ga.$$.fragment,t),_(li.$$.fragment,t),_(La.$$.fragment,t),_(pi.$$.fragment,t),_(Za.$$.fragment,t),_(di.$$.fragment,t),_(Va.$$.fragment,t),_(gi.$$.fragment,t),_(ui.$$.fragment,t),_(hi.$$.fragment,t),_(fi.$$.fragment,t),_(mi.$$.fragment,t),_(Wa.$$.fragment,t),_(Ba.$$.fragment,t),_(Ya.$$.fragment,t),_(_i.$$.fragment,t),_(bi.$$.fragment,t),_(Xa.$$.fragment,t),_(za.$$.fragment,t),_(vi.$$.fragment,t),_(Oa.$$.fragment,t),_(yi.$$.fragment,t),_(Qa.$$.fragment,t),_(xi.$$.fragment,t),_(Ka.$$.fragment,t),_($i.$$.fragment,t),_(es.$$.fragment,t),_(wi.$$.fragment,t),_(ki.$$.fragment,t),_(Ti.$$.fragment,t),_(ts.$$.fragment,t),_(qi.$$.fragment,t),_(ns.$$.fragment,t),_(Mi.$$.fragment,t),_(ji.$$.fragment,t),_(os.$$.fragment,t),_(Hi.$$.fragment,t),_(Ci.$$.fragment,t),_(as.$$.fragment,t),_(Ui.$$.fragment,t),_(ss.$$.fragment,t),_(rs.$$.fragment,t),_(is.$$.fragment,t),_(Ii.$$.fragment,t),_(cs.$$.fragment,t),_(Ai.$$.fragment,t),_(ls.$$.fragment,t),_(Ni.$$.fragment,t),_(ps.$$.fragment,t),_(Ji.$$.fragment,t),_(Ei.$$.fragment,t),_(Di.$$.fragment,t),_(ds.$$.fragment,t),_(Ri.$$.fragment,t),_(gs.$$.fragment,t),_(Fi.$$.fragment,t),_(us.$$.fragment,t),_(hs.$$.fragment,t),_(fs.$$.fragment,t),_(Si.$$.fragment,t),_(ms.$$.fragment,t),_(_s.$$.fragment,t),_(bs.$$.fragment,t),_(vs.$$.fragment,t),_(Gi.$$.fragment,t),_(ys.$$.fragment,t),_(xs.$$.fragment,t),_(Li.$$.fragment,t),_(Zi.$$.fragment,t),_(Vi.$$.fragment,t),_(Pi.$$.fragment,t),_(Wi.$$.fragment,t),_(Bi.$$.fragment,t),_(Yi.$$.fragment,t),_(Xi.$$.fragment,t),_(ws.$$.fragment,t),_(zi.$$.fragment,t),_(Oi.$$.fragment,t),_(Qi.$$.fragment,t),_(Ki.$$.fragment,t),_(ec.$$.fragment,t),_(tc.$$.fragment,t),_(nc.$$.fragment,t),_(oc.$$.fragment,t),_(ks.$$.fragment,t),_(ac.$$.fragment,t),_(sc.$$.fragment,t),_(Ts.$$.fragment,t),_(rc.$$.fragment,t),_(ic.$$.fragment,t),_(cc.$$.fragment,t),_(lc.$$.fragment,t),_(qs.$$.fragment,t),_(pc.$$.fragment,t),_(dc.$$.fragment,t),_(gc.$$.fragment,t),_(uc.$$.fragment,t),_(hc.$$.fragment,t),_(fc.$$.fragment,t),_(Ms.$$.fragment,t),_(mc.$$.fragment,t),_(_c.$$.fragment,t),_(bc.$$.fragment,t),_(vc.$$.fragment,t),_(yc.$$.fragment,t),_(xc.$$.fragment,t),_($c.$$.fragment,t),_(kc.$$.fragment,t),_(Tc.$$.fragment,t),_(js.$$.fragment,t),_(qc.$$.fragment,t),_(Mc.$$.fragment,t),_(jc.$$.fragment,t),_(Hc.$$.fragment,t),_(Cc.$$.fragment,t),_(Hs.$$.fragment,t),_(Cs.$$.fragment,t),_(Uc.$$.fragment,t),_(Us.$$.fragment,t),_(Ic.$$.fragment,t),_(Ac.$$.fragment,t),_(Nc.$$.fragment,t),Wh=!1},d(t){t&&(p(v),p(i),p(a),p(e),p(x),p(Ku),p(Ds),p(eh),p(Rs),p(th),p(nh),p(oh),p(w),p(ah),p(sh),p(rh),p(Dn),p(ih),p(ch),p(ct),p(lh),p(ph),p(lt),p(dh),p(gh),p(Rn),p(uh),p(hh),p(Fn),p(fh),p(mh),p(pt),p(_h),p(bh),p(dt),p(vh),p(yh),p(gt),p(xh),p($h),p(Sn),p(wh),p(kh),p(z),p(Th),p(qh),p(O),p(Mh),p(jh),p(me),p(Hh),p(Ch),p(ut),p(Uh),p(Ih),p(ht),p(Ah),p(Nh),p(Gn),p(Jh),p(Eh),p(Ln),p(Dh),p(Rh),p(wc),p(Fh),p(_e),p(Sh),p(Zn),p(Gh),p(Q),p(Lh),p(Zh),p(D),p(Vh),p(Ph),p(Qu)),p(o),b(g,t),b(Fs,t),b(Ss,t),b(Gs),b(Ls),b(Zs),b($o),b(Vs),b(Ps),b(Ws),b(wo),b(Bs),b(Ys),b(ko),b(To),b(Xs),b(qo),b(Mo),b(zs),b(Os),b(Ho),b(Qs),b(Co),b(Uo),b(Io),b(Ks),b(Ao),b(er),b(No),b(Jo),b(tr),b(Eo),b(nr),b(Do),b(or),b(ar),b(sr),b(So),b(rr),b(Go),b(ir),b(cr),b(Zo),b(Vo),b(lr),b(Po),b(pr),b(Wo),b(dr),b(gr),b(ur),b(hr),b(fr),b(mr),b(_r),b(br),b(vr),b(zo),b(yr),b(Oo),b(xr),b(Qo),b($r),b(Ko),b(wr),b(ea),b(kr),b(ta),b(Tr),b(na),b(qr),b(Mr),b(aa),b(jr),b(Hr),b(Cr),b(ia),b(Ur),b(Ir),b(la),b(Ar),b(pa),b(da),b(Nr),b(ga),b(Jr),b(Er),b(Dr),b(ha),b(Rr),b(Fr),b(ma),b(Sr),b(Gr),b(_a),b(Lr),b(ba),b(va),b(Zr),b(ya),b(Vr),b(xa),b(Pr),b($a),b(wa),b(Wr),b(ka),b(Br),b(Ta),b(Yr),b(qa),b(Xr),b(Ma),b(ja),b(zr),b(Or),b(Ca),b(Qr),b(Ua),b(Kr),b(Ia),b(ei),b(Aa),b(ti),b(ni),b(oi),b(Ja),b(ai),b(Ea),b(Da),b(si),b(ri),b(ii),b(ci),b(Ga),b(li),b(La),b(pi),b(Za),b(di),b(Va),b(gi),b(ui),b(hi),b(fi),b(mi),b(Wa),b(Ba),b(Ya),b(_i),b(bi),b(Xa),b(za),b(vi),b(Oa),b(yi),b(Qa),b(xi),b(Ka),b($i),b(es),b(wi),b(ki),b(Ti),b(ts),b(qi),b(ns),b(Mi),b(ji),b(os),b(Hi),b(Ci),b(as),b(Ui),b(ss),b(rs),b(is),b(Ii),b(cs),b(Ai),b(ls),b(Ni),b(ps),b(Ji),b(Ei),b(Di),b(ds),b(Ri),b(gs),b(Fi),b(us),b(hs),b(fs),b(Si),b(ms),b(_s),b(bs),b(vs),b(Gi),b(ys),b(xs),b(Li),b(Zi,t),b(Vi,t),b(Pi),b(Wi,t),b(Bi),b(Yi,t),b(Xi),b(ws),b(zi,t),b(Oi),b(Qi,t),b(Ki),b(ec,t),b(tc),b(nc,t),b(oc),b(ks),b(ac,t),b(sc),b(Ts),b(rc,t),b(ic),b(cc,t),b(lc),b(qs),b(pc,t),b(dc),b(gc,t),b(uc),b(hc,t),b(fc),b(Ms),b(mc,t),b(_c),b(bc,t),b(vc),b(yc,t),b(xc),b($c,t),b(kc),b(Tc),b(js),b(qc),b(Mc),b(jc),b(Hc,t),b(Cc),b(Hs),b(Cs),b(Uc),b(Us),b(Ic),b(Ac),b(Nc,t)}}}const wM='{"title":"HfApi Client","local":"hfapi-client","sections":[{"title":"HfApi","local":"huggingface_hub.HfApi ][ huggingface_hub.HfApi","sections":[],"depth":2},{"title":"API Dataclasses","local":"api-dataclasses","sections":[{"title":"AccessRequest","local":"huggingface_hub.hf_api.AccessRequest ][ huggingface_hub.hf_api.AccessRequest","sections":[],"depth":3},{"title":"CommitInfo","local":"huggingface_hub.CommitInfo ][ huggingface_hub.CommitInfo","sections":[],"depth":3},{"title":"DatasetInfo","local":"huggingface_hub.hf_api.DatasetInfo ][ huggingface_hub.DatasetInfo","sections":[],"depth":3},{"title":"GitRefInfo","local":"huggingface_hub.GitRefInfo ][ huggingface_hub.GitRefInfo","sections":[],"depth":3},{"title":"GitCommitInfo","local":"huggingface_hub.GitCommitInfo ][ huggingface_hub.GitCommitInfo","sections":[],"depth":3},{"title":"GitRefs","local":"huggingface_hub.GitRefs ][ huggingface_hub.GitRefs","sections":[],"depth":3},{"title":"ModelInfo","local":"huggingface_hub.hf_api.ModelInfo ][ huggingface_hub.ModelInfo","sections":[],"depth":3},{"title":"RepoSibling","local":"huggingface_hub.hf_api.RepoSibling ][ huggingface_hub.hf_api.RepoSibling","sections":[],"depth":3},{"title":"RepoFile","local":"huggingface_hub.hf_api.RepoFile ][ huggingface_hub.hf_api.RepoFile","sections":[],"depth":3},{"title":"RepoUrl","local":"huggingface_hub.RepoUrl ][ huggingface_hub.RepoUrl","sections":[],"depth":3},{"title":"SafetensorsRepoMetadata","local":"huggingface_hub.utils.SafetensorsRepoMetadata ][ huggingface_hub.utils.SafetensorsRepoMetadata","sections":[],"depth":3},{"title":"SafetensorsFileMetadata","local":"huggingface_hub.utils.SafetensorsFileMetadata ][ huggingface_hub.utils.SafetensorsFileMetadata","sections":[],"depth":3},{"title":"SpaceInfo","local":"huggingface_hub.hf_api.SpaceInfo ][ huggingface_hub.SpaceInfo","sections":[],"depth":3},{"title":"TensorInfo","local":"huggingface_hub.utils.TensorInfo ][ huggingface_hub.utils.TensorInfo","sections":[],"depth":3},{"title":"User","local":"huggingface_hub.User ][ huggingface_hub.User","sections":[],"depth":3},{"title":"UserLikes","local":"huggingface_hub.UserLikes ][ huggingface_hub.UserLikes","sections":[],"depth":3}],"depth":2},{"title":"CommitOperation","local":"huggingface_hub.CommitOperationAdd ][ huggingface_hub.CommitOperationAdd","sections":[],"depth":2},{"title":"CommitScheduler","local":"huggingface_hub.CommitScheduler ][ huggingface_hub.CommitScheduler","sections":[],"depth":2}],"depth":1}';function kM(T){return T0(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class IM extends q0{constructor(o){super(),M0(this,o,kM,$M,k0,{})}}export{IM as component};
