import{s as ta,o as aa,n as ve}from"../chunks/scheduler.22bf70d2.js";import{S as la,i as ia,g as c,s as i,r as p,A as na,h as o,f as a,c as n,j as ea,u as f,x as d,k as Me,y as ra,a as l,v as m,d as h,t as u,w as y}from"../chunks/index.59178e06.js";import{T as be}from"../chunks/Tip.75d940ba.js";import{C as T}from"../chunks/CodeBlock.f7047b13.js";import{H as I,E as sa}from"../chunks/EditOnGithub.86314611.js";function ca($){let r,w="Add <code>--config_file</code> to the <code>accelerate test</code> or <code>accelerate launch</code> command to specify the location of the configuration file if it is saved in a non-default location like the cache.";return{c(){r=c("p"),r.innerHTML=w},l(s){r=o(s,"P",{"data-svelte-h":!0}),d(r)!=="svelte-owtvtx"&&(r.innerHTML=w)},m(s,g){l(s,r,g)},p:ve,d(s){s&&a(r)}}}function oa($){let r,w='This step is <em>optional</em> but it is considered best practice to allow Accelerate to handle device placement. You could also deactivate automatic device placement by passing <code>device_placement=False</code> when initializing the <a href="/docs/accelerate/v0.30.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>. If you want to explicitly place objects on a device with <code>.to(device)</code>, make sure you use <code>accelerator.device</code> instead. For example, if you create an optimizer before placing a model on <code>accelerator.device</code>, training fails on a TPU.';return{c(){r=c("p"),r.innerHTML=w},l(s){r=o(s,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1realvz"&&(r.innerHTML=w)},m(s,g){l(s,r,g)},p:ve,d(s){s&&a(r)}}}function da($){let r,w='Accelerate does not use non-blocking transfers by default for its automatic device placement, which can result in potentially unwanted CUDA synchronizations.  You can enable non-blocking transfers by passing a <a href="/docs/accelerate/v0.30.0/en/package_reference/utilities#accelerate.DataLoaderConfiguration">DataLoaderConfiguration</a> with <code>non_blocking=True</code> set as the <code>dataloader_config</code> when initializing the <a href="/docs/accelerate/v0.30.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>.  As usual, non-blocking transfers will only work if the dataloader also has <code>pin_memory=True</code> set.  Be wary that using non-blocking transfers from GPU to CPU may cause incorrect results if it results in CPU operations being performed on non-ready tensors.';return{c(){r=c("p"),r.innerHTML=w},l(s){r=o(s,"P",{"data-svelte-h":!0}),d(r)!=="svelte-mrftp9"&&(r.innerHTML=w)},m(s,g){l(s,r,g)},p:ve,d(s){s&&a(r)}}}function pa($){let r,w='Data at the end of a dataset may be duplicated so the batch can be equally divided among all workers. The <a href="/docs/accelerate/v0.30.0/en/package_reference/accelerator#accelerate.Accelerator.gather_for_metrics">gather_for_metrics()</a> method automatically removes the duplicated data to calculate a more accurate metric.';return{c(){r=c("p"),r.innerHTML=w},l(s){r=o(s,"P",{"data-svelte-h":!0}),d(r)!=="svelte-myyfg1"&&(r.innerHTML=w)},m(s,g){l(s,r,g)},p:ve,d(s){s&&a(r)}}}function fa($){let r,w='Take a look at the <a href="concept_guides/big_model_inference">Handling big models for inference</a> guide for a better understanding of how Big Model Inference works under the hood.';return{c(){r=c("p"),r.innerHTML=w},l(s){r=o(s,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1s8g9lk"&&(r.innerHTML=w)},m(s,g){l(s,r,g)},p:ve,d(s){s&&a(r)}}}function ma($){let r,w,s,g,C,_e,G,vt='There are many ways to launch and run your code depending on your training environment (<a href="https://pytorch.org/docs/stable/elastic/run.html" rel="nofollow">torchrun</a>, <a href="https://www.deepspeed.ai/" rel="nofollow">DeepSpeed</a>, etc.) and available hardware. Accelerate offers a unified interface for launching and training on different distributed setups, allowing you to focus on your PyTorch training code instead of the intricacies of adapting your code to these different setups. This allows you to easily scale your PyTorch code for training and inference on distributed setups with hardware like GPUs and TPUs. Accelerate also provides Big Model Inference to make loading and running inference with really large models that usually don’t fit in memory more accessible.',Je,B,_t="This quicktour introduces the three main features of Accelerate:",ke,Z,Jt="<li>a unified command line launching interface for distributed training scripts</li> <li>a training library for adapting PyTorch training code to run on different distributed setups</li> <li>Big Model Inference</li>",Ue,x,je,H,kt='Accelerate automatically selects the appropriate configuration values for any given distributed training framework (DeepSpeed, FSDP, etc.) through a unified configuration file generated from the <a href="package_reference/cli#accelerate-config"><code>accelerate config</code></a> command. You could also pass the configuration values explicitly to the command line which is helpful in certain situations like if you’re using SLURM.',Ie,L,Ut='But in most cases, you should always run <a href="package_reference/cli#accelerate-config"><code>accelerate config</code></a> first to help Accelerate learn about your training setup.',Ce,W,Ge,X,jt='The <a href="package_reference/cli#accelerate-config"><code>accelerate config</code></a> command creates and saves a default_config.yaml file in Accelerates cache folder. This file stores the configuration for your training environment, which helps Accelerate correctly launch your training script based on your machine.',Be,R,It='After you’ve configured your environment, you can test your setup with <a href="package_reference/cli#accelerate-test"><code>accelerate test</code></a>, which launches a short script to test the distributed environment.',Ze,A,xe,M,He,Y,Ct='Once your environment is setup, launch your training script with <a href="package_reference/cli#accelerate-launch"><code>accelerate launch</code></a>!',Le,N,We,z,Gt='To learn more, check out the <a href="basic_tutorials/launch">Launch distributed code</a> tutorial for more information about launching your scripts.',Xe,P,Re,F,Bt='The next main feature of Accelerate is the <a href="/docs/accelerate/v0.30.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class which adapts your PyTorch code to run on different distributed setups.',Ae,V,Zt="You only need to add a few lines of code to your training script to enable it to run on multiple GPUs or TPUs.",Ye,Q,Ne,S,xt='<li>Import and instantiate the <a href="/docs/accelerate/v0.30.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class at the beginning of your training script. The <a href="/docs/accelerate/v0.30.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class initializes everything necessary for distributed training, and it automatically detects your training environment (a single machine with a GPU, a machine with several GPUs, several machines with multiple GPUs or a TPU, etc.) based on how the code was launched.</li>',ze,E,Pe,b,Ht='<li>Remove calls like <code>.cuda()</code> on your model and input data. The <a href="/docs/accelerate/v0.30.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class automatically places these objects on the appropriate device for you.</li>',Fe,v,Ve,_,Qe,D,Se,J,Lt='<li>Pass all relevant PyTorch objects for training (optimizer, model, dataloader(s), learning rate scheduler) to the <a href="/docs/accelerate/v0.30.0/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method as soon as they’re created. This method wraps the model in a container optimized for your distributed setup, uses Accelerates version of the optimizer and scheduler, and creates a sharded version of your dataloader for distribution across GPUs or TPUs.</li>',Ee,q,De,k,Wt='<li>Replace <code>loss.backward()</code> with <a href="/docs/accelerate/v0.30.0/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a> to use the correct <code>backward()</code> method for your training setup.</li>',qe,K,Ke,O,Xt='Read <a href="concept_guides/internal_mechanism">Accelerate’s internal mechanisms</a> guide to learn more details about how Accelerate adapts your code.',Oe,ee,et,te,Rt='To perform distributed evaluation, pass your validation dataloader to the <a href="/docs/accelerate/v0.30.0/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method:',tt,ae,at,le,At='Each device in your distributed setup only receives a part of the evaluation data, which means you should group your predictions together with the <a href="/docs/accelerate/v0.30.0/en/package_reference/accelerator#accelerate.Accelerator.gather_for_metrics">gather_for_metrics()</a> method. This method requires all tensors to be the same size on each process, so if your tensors have different sizes on each process (for instance when dynamically padding to the maximum length in a batch), you should use the <a href="/docs/accelerate/v0.30.0/en/package_reference/accelerator#accelerate.Accelerator.pad_across_processes">pad_across_processes()</a> method to pad you tensor to the largest size across processes. Note that the tensors needs to be 1D and that we concatenate the tensors along the first dimension.',lt,ie,it,ne,Yt="For more complex cases (e.g. 2D tensors, don’t want to concatenate tensors, dict of 3D tensors), you can pass <code>use_gather_object=True</code> in <code>gather_for_metrics</code>. This will return the list of objects after gathering. Note that using it with GPU tensors is not well supported and inefficient.",nt,U,rt,re,st,se,Nt='Accelerate’s Big Model Inference has two main features, <a href="/docs/accelerate/v0.30.0/en/package_reference/big_modeling#accelerate.init_empty_weights">init_empty_weights()</a> and <a href="/docs/accelerate/v0.30.0/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a>, to load large models for inference that typically don’t fit into memory.',ct,j,ot,ce,dt,oe,zt='The <a href="/docs/accelerate/v0.30.0/en/package_reference/big_modeling#accelerate.init_empty_weights">init_empty_weights()</a> context manager initializes models of any size by creating a <em>model skeleton</em> and moving and placing parameters each time they’re created to PyTorch’s <a href="https://pytorch.org/docs/main/meta.html" rel="nofollow"><strong>meta</strong></a> device. This way, not all weights are immediately loaded and only a small part of the model is loaded into memory at a time.',pt,de,Pt='For example, loading an empty <a href="https://huggingface.co/mistralai/Mixtral-8x7B-Instruct-v0.1" rel="nofollow">Mixtral-8x7B</a> model takes significantly less memory than fully loading the models and weights on the CPU.',ft,pe,mt,fe,ht,me,Ft='The <a href="/docs/accelerate/v0.30.0/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a> function loads full or sharded checkpoints into the empty model, and automatically distribute weights across all available devices.',ut,he,Vt="The <code>device_map</code> parameter determines where to place each model layer, and specifiying <code>&quot;auto&quot;</code> places them on the GPU first, then the CPU, and finally the hard drive as memory-mapped tensors if there’s still not enough memory. Use the <code>no_split_module_classes</code> parameter to indicate which modules shouldn’t be split across devices (typically those with a residual connection).",yt,ue,wt,ye,gt,we,Qt="Now that you’ve been introduced to the main Accelerate features, your next steps could include:",$t,ge,St='<li>Check out the <a href="basic_tutorials/overview">tutorials</a> for a gentle walkthrough of Accelerate. This is especially useful if you’re new to distributed training and the library.</li> <li>Dive into the <a href="usage_guides/explore">guides</a> to see how to use Accelerate for specific use-cases.</li> <li>Deepen your conceptual understanding of how Accelerate works internally by reading the <a href="concept_guides/internal_mechanism">concept guides</a>.</li> <li>Look up classes and commands in the <a href="package_reference/accelerator">API reference</a> to see what parameters and options are available.</li>',Tt,$e,Mt,Te,bt;return C=new I({props:{title:"Quicktour",local:"quicktour",headingTag:"h1"}}),x=new I({props:{title:"Unified launch interface",local:"unified-launch-interface",headingTag:"h2"}}),W=new T({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),A=new T({props:{code:"YWNjZWxlcmF0ZSUyMHRlc3Q=",highlighted:'accelerate <span class="hljs-built_in">test</span>',wrap:!1}}),M=new be({props:{warning:!1,$$slots:{default:[ca]},$$scope:{ctx:$}}}),N=new T({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHBhdGhfdG9fc2NyaXB0LnB5JTIwLS1hcmdzX2Zvcl90aGVfc2NyaXB0",highlighted:"accelerate launch path_to_script.py --args_for_the_script",wrap:!1}}),P=new I({props:{title:"Adapt training code",local:"adapt-training-code",headingTag:"h2"}}),Q=new T({props:{code:"JTJCJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUyQiUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQSUyQiUyMGRldmljZSUyMCUzRCUyMGFjY2VsZXJhdG9yLmRldmljZSUwQSUyQiUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTJCJTIwJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTBBJTJCJTIwKSUwQSUwQSUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbmluZ19kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBLSUyMCUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBLSUyMCUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjB0YXJnZXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmN0aW9uKG91dHB1dHMlMkMlMjB0YXJnZXRzKSUwQSUyQiUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMHNjaGVkdWxlci5zdGVwKCk=",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
<span class="hljs-addition">+ accelerator = Accelerator()</span>

<span class="hljs-addition">+ device = accelerator.device</span>
<span class="hljs-addition">+ model, optimizer, training_dataloader, scheduler = accelerator.prepare(</span>
<span class="hljs-addition">+     model, optimizer, training_dataloader, scheduler</span>
<span class="hljs-addition">+ )</span>

  for batch in training_dataloader:
      optimizer.zero_grad()
      inputs, targets = batch
<span class="hljs-deletion">-     inputs = inputs.to(device)</span>
<span class="hljs-deletion">-     targets = targets.to(device)</span>
      outputs = model(inputs)
      loss = loss_function(outputs, targets)
<span class="hljs-addition">+     accelerator.backward(loss)</span>
      optimizer.step()
      scheduler.step()`,wrap:!1}}),E=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()`,wrap:!1}}),v=new be({props:{warning:!0,$$slots:{default:[oa]},$$scope:{ctx:$}}}),_=new be({props:{warning:!0,$$slots:{default:[da]},$$scope:{ctx:$}}}),D=new T({props:{code:"ZGV2aWNlJTIwJTNEJTIwYWNjZWxlcmF0b3IuZGV2aWNl",highlighted:"device = accelerator.device",wrap:!1}}),q=new T({props:{code:"bW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBscl9zY2hlZHVsZXIlMEEp",highlighted:`model, optimizer, train_dataloader, lr_scheduler = accelerator.prepare(
    model, optimizer, train_dataloader, lr_scheduler
)`,wrap:!1}}),K=new T({props:{code:"YWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyk=",highlighted:"accelerator.backward(loss)",wrap:!1}}),ee=new I({props:{title:"Distributed evaluation",local:"distributed-evaluation",headingTag:"h3"}}),ae=new T({props:{code:"dmFsaWRhdGlvbl9kYXRhbG9hZGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSh2YWxpZGF0aW9uX2RhdGFsb2FkZXIp",highlighted:"validation_dataloader = accelerator.prepare(validation_dataloader)",wrap:!1}}),ie=new T({props:{code:"Zm9yJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMGluJTIwdmFsaWRhdGlvbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIzJTIwR2F0aGVyJTIwYWxsJTIwcHJlZGljdGlvbnMlMjBhbmQlMjB0YXJnZXRzJTBBJTIwJTIwJTIwJTIwYWxsX3ByZWRpY3Rpb25zJTJDJTIwYWxsX3RhcmdldHMlMjAlM0QlMjBhY2NlbGVyYXRvci5nYXRoZXJfZm9yX21ldHJpY3MoKHByZWRpY3Rpb25zJTJDJTIwdGFyZ2V0cykpJTBBJTIwJTIwJTIwJTIwJTIzJTIwRXhhbXBsZSUyMG9mJTIwdXNlJTIwd2l0aCUyMGElMjAqRGF0YXNldHMuTWV0cmljKiUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2goYWxsX3ByZWRpY3Rpb25zJTJDJTIwYWxsX3RhcmdldHMp",highlighted:`<span class="hljs-keyword">for</span> inputs, targets <span class="hljs-keyword">in</span> validation_dataloader:
    predictions = model(inputs)
    <span class="hljs-comment"># Gather all predictions and targets</span>
    all_predictions, all_targets = accelerator.gather_for_metrics((predictions, targets))
    <span class="hljs-comment"># Example of use with a *Datasets.Metric*</span>
    metric.add_batch(all_predictions, all_targets)`,wrap:!1}}),U=new be({props:{warning:!1,$$slots:{default:[pa]},$$scope:{ctx:$}}}),re=new I({props:{title:"Big Model Inference",local:"big-model-inference",headingTag:"h2"}}),j=new be({props:{warning:!1,$$slots:{default:[fa]},$$scope:{ctx:$}}}),ce=new I({props:{title:"Empty weights initialization",local:"empty-weights-initialization",headingTag:"h3"}}),pe=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0NvbmZpZyUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWl4dHJhbC04eDdCLUluc3RydWN0LXYwLjElMjIpJTBBd2l0aCUyMGluaXRfZW1wdHlfd2VpZ2h0cygpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCausalLM

config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>)
<span class="hljs-keyword">with</span> init_empty_weights():
    model = AutoModelForCausalLM.from_config(config)`,wrap:!1}}),fe=new I({props:{title:"Load and dispatch weights",local:"load-and-dispatch-weights",headingTag:"h3"}}),ue=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBsb2FkX2NoZWNrcG9pbnRfYW5kX2Rpc3BhdGNoJTBBJTBBbW9kZWwlMjAlM0QlMjBsb2FkX2NoZWNrcG9pbnRfYW5kX2Rpc3BhdGNoKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTIwY2hlY2twb2ludCUzRCUyMm1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBub19zcGxpdF9tb2R1bGVfY2xhc3NlcyUzRCU1QidCbG9jayclNUQlMEEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> load_checkpoint_and_dispatch

model = load_checkpoint_and_dispatch(
    model, checkpoint=<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, no_split_module_classes=[<span class="hljs-string">&#x27;Block&#x27;</span>]
)`,wrap:!1}}),ye=new I({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),$e=new sa({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/quicktour.md"}}),{c(){r=c("meta"),w=i(),s=c("p"),g=i(),p(C.$$.fragment),_e=i(),G=c("p"),G.innerHTML=vt,Je=i(),B=c("p"),B.textContent=_t,ke=i(),Z=c("ul"),Z.innerHTML=Jt,Ue=i(),p(x.$$.fragment),je=i(),H=c("p"),H.innerHTML=kt,Ie=i(),L=c("p"),L.innerHTML=Ut,Ce=i(),p(W.$$.fragment),Ge=i(),X=c("p"),X.innerHTML=jt,Be=i(),R=c("p"),R.innerHTML=It,Ze=i(),p(A.$$.fragment),xe=i(),p(M.$$.fragment),He=i(),Y=c("p"),Y.innerHTML=Ct,Le=i(),p(N.$$.fragment),We=i(),z=c("p"),z.innerHTML=Gt,Xe=i(),p(P.$$.fragment),Re=i(),F=c("p"),F.innerHTML=Bt,Ae=i(),V=c("p"),V.textContent=Zt,Ye=i(),p(Q.$$.fragment),Ne=i(),S=c("ol"),S.innerHTML=xt,ze=i(),p(E.$$.fragment),Pe=i(),b=c("ol"),b.innerHTML=Ht,Fe=i(),p(v.$$.fragment),Ve=i(),p(_.$$.fragment),Qe=i(),p(D.$$.fragment),Se=i(),J=c("ol"),J.innerHTML=Lt,Ee=i(),p(q.$$.fragment),De=i(),k=c("ol"),k.innerHTML=Wt,qe=i(),p(K.$$.fragment),Ke=i(),O=c("p"),O.innerHTML=Xt,Oe=i(),p(ee.$$.fragment),et=i(),te=c("p"),te.innerHTML=Rt,tt=i(),p(ae.$$.fragment),at=i(),le=c("p"),le.innerHTML=At,lt=i(),p(ie.$$.fragment),it=i(),ne=c("p"),ne.innerHTML=Yt,nt=i(),p(U.$$.fragment),rt=i(),p(re.$$.fragment),st=i(),se=c("p"),se.innerHTML=Nt,ct=i(),p(j.$$.fragment),ot=i(),p(ce.$$.fragment),dt=i(),oe=c("p"),oe.innerHTML=zt,pt=i(),de=c("p"),de.innerHTML=Pt,ft=i(),p(pe.$$.fragment),mt=i(),p(fe.$$.fragment),ht=i(),me=c("p"),me.innerHTML=Ft,ut=i(),he=c("p"),he.innerHTML=Vt,yt=i(),p(ue.$$.fragment),wt=i(),p(ye.$$.fragment),gt=i(),we=c("p"),we.textContent=Qt,$t=i(),ge=c("ul"),ge.innerHTML=St,Tt=i(),p($e.$$.fragment),Mt=i(),Te=c("p"),this.h()},l(e){const t=na("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(a),w=n(e),s=o(e,"P",{}),ea(s).forEach(a),g=n(e),f(C.$$.fragment,e),_e=n(e),G=o(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-zyosvv"&&(G.innerHTML=vt),Je=n(e),B=o(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1o5ahli"&&(B.textContent=_t),ke=n(e),Z=o(e,"UL",{"data-svelte-h":!0}),d(Z)!=="svelte-d1sk9"&&(Z.innerHTML=Jt),Ue=n(e),f(x.$$.fragment,e),je=n(e),H=o(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-aki53"&&(H.innerHTML=kt),Ie=n(e),L=o(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-2e4yon"&&(L.innerHTML=Ut),Ce=n(e),f(W.$$.fragment,e),Ge=n(e),X=o(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-47dzsm"&&(X.innerHTML=jt),Be=n(e),R=o(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-vfcxnx"&&(R.innerHTML=It),Ze=n(e),f(A.$$.fragment,e),xe=n(e),f(M.$$.fragment,e),He=n(e),Y=o(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-jk8hrr"&&(Y.innerHTML=Ct),Le=n(e),f(N.$$.fragment,e),We=n(e),z=o(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-ehdvry"&&(z.innerHTML=Gt),Xe=n(e),f(P.$$.fragment,e),Re=n(e),F=o(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-v62nbo"&&(F.innerHTML=Bt),Ae=n(e),V=o(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1x7bxhi"&&(V.textContent=Zt),Ye=n(e),f(Q.$$.fragment,e),Ne=n(e),S=o(e,"OL",{"data-svelte-h":!0}),d(S)!=="svelte-cjeg7r"&&(S.innerHTML=xt),ze=n(e),f(E.$$.fragment,e),Pe=n(e),b=o(e,"OL",{start:!0,"data-svelte-h":!0}),d(b)!=="svelte-4fg3zr"&&(b.innerHTML=Ht),Fe=n(e),f(v.$$.fragment,e),Ve=n(e),f(_.$$.fragment,e),Qe=n(e),f(D.$$.fragment,e),Se=n(e),J=o(e,"OL",{start:!0,"data-svelte-h":!0}),d(J)!=="svelte-w24f7t"&&(J.innerHTML=Lt),Ee=n(e),f(q.$$.fragment,e),De=n(e),k=o(e,"OL",{start:!0,"data-svelte-h":!0}),d(k)!=="svelte-142zw5g"&&(k.innerHTML=Wt),qe=n(e),f(K.$$.fragment,e),Ke=n(e),O=o(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-l0bxbi"&&(O.innerHTML=Xt),Oe=n(e),f(ee.$$.fragment,e),et=n(e),te=o(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-vpq7uw"&&(te.innerHTML=Rt),tt=n(e),f(ae.$$.fragment,e),at=n(e),le=o(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-5drp3q"&&(le.innerHTML=At),lt=n(e),f(ie.$$.fragment,e),it=n(e),ne=o(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-uu4pqd"&&(ne.innerHTML=Yt),nt=n(e),f(U.$$.fragment,e),rt=n(e),f(re.$$.fragment,e),st=n(e),se=o(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-1sob7se"&&(se.innerHTML=Nt),ct=n(e),f(j.$$.fragment,e),ot=n(e),f(ce.$$.fragment,e),dt=n(e),oe=o(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1r5t8et"&&(oe.innerHTML=zt),pt=n(e),de=o(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-1oh4egp"&&(de.innerHTML=Pt),ft=n(e),f(pe.$$.fragment,e),mt=n(e),f(fe.$$.fragment,e),ht=n(e),me=o(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1qvgujx"&&(me.innerHTML=Ft),ut=n(e),he=o(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-h9i8yj"&&(he.innerHTML=Vt),yt=n(e),f(ue.$$.fragment,e),wt=n(e),f(ye.$$.fragment,e),gt=n(e),we=o(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-51r5yq"&&(we.textContent=Qt),$t=n(e),ge=o(e,"UL",{"data-svelte-h":!0}),d(ge)!=="svelte-1xs3v0c"&&(ge.innerHTML=St),Tt=n(e),f($e.$$.fragment,e),Mt=n(e),Te=o(e,"P",{}),ea(Te).forEach(a),this.h()},h(){Me(r,"name","hf:doc:metadata"),Me(r,"content",ha),Me(b,"start","2"),Me(J,"start","3"),Me(k,"start","4")},m(e,t){ra(document.head,r),l(e,w,t),l(e,s,t),l(e,g,t),m(C,e,t),l(e,_e,t),l(e,G,t),l(e,Je,t),l(e,B,t),l(e,ke,t),l(e,Z,t),l(e,Ue,t),m(x,e,t),l(e,je,t),l(e,H,t),l(e,Ie,t),l(e,L,t),l(e,Ce,t),m(W,e,t),l(e,Ge,t),l(e,X,t),l(e,Be,t),l(e,R,t),l(e,Ze,t),m(A,e,t),l(e,xe,t),m(M,e,t),l(e,He,t),l(e,Y,t),l(e,Le,t),m(N,e,t),l(e,We,t),l(e,z,t),l(e,Xe,t),m(P,e,t),l(e,Re,t),l(e,F,t),l(e,Ae,t),l(e,V,t),l(e,Ye,t),m(Q,e,t),l(e,Ne,t),l(e,S,t),l(e,ze,t),m(E,e,t),l(e,Pe,t),l(e,b,t),l(e,Fe,t),m(v,e,t),l(e,Ve,t),m(_,e,t),l(e,Qe,t),m(D,e,t),l(e,Se,t),l(e,J,t),l(e,Ee,t),m(q,e,t),l(e,De,t),l(e,k,t),l(e,qe,t),m(K,e,t),l(e,Ke,t),l(e,O,t),l(e,Oe,t),m(ee,e,t),l(e,et,t),l(e,te,t),l(e,tt,t),m(ae,e,t),l(e,at,t),l(e,le,t),l(e,lt,t),m(ie,e,t),l(e,it,t),l(e,ne,t),l(e,nt,t),m(U,e,t),l(e,rt,t),m(re,e,t),l(e,st,t),l(e,se,t),l(e,ct,t),m(j,e,t),l(e,ot,t),m(ce,e,t),l(e,dt,t),l(e,oe,t),l(e,pt,t),l(e,de,t),l(e,ft,t),m(pe,e,t),l(e,mt,t),m(fe,e,t),l(e,ht,t),l(e,me,t),l(e,ut,t),l(e,he,t),l(e,yt,t),m(ue,e,t),l(e,wt,t),m(ye,e,t),l(e,gt,t),l(e,we,t),l(e,$t,t),l(e,ge,t),l(e,Tt,t),m($e,e,t),l(e,Mt,t),l(e,Te,t),bt=!0},p(e,[t]){const Et={};t&2&&(Et.$$scope={dirty:t,ctx:e}),M.$set(Et);const Dt={};t&2&&(Dt.$$scope={dirty:t,ctx:e}),v.$set(Dt);const qt={};t&2&&(qt.$$scope={dirty:t,ctx:e}),_.$set(qt);const Kt={};t&2&&(Kt.$$scope={dirty:t,ctx:e}),U.$set(Kt);const Ot={};t&2&&(Ot.$$scope={dirty:t,ctx:e}),j.$set(Ot)},i(e){bt||(h(C.$$.fragment,e),h(x.$$.fragment,e),h(W.$$.fragment,e),h(A.$$.fragment,e),h(M.$$.fragment,e),h(N.$$.fragment,e),h(P.$$.fragment,e),h(Q.$$.fragment,e),h(E.$$.fragment,e),h(v.$$.fragment,e),h(_.$$.fragment,e),h(D.$$.fragment,e),h(q.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(U.$$.fragment,e),h(re.$$.fragment,e),h(j.$$.fragment,e),h(ce.$$.fragment,e),h(pe.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(ye.$$.fragment,e),h($e.$$.fragment,e),bt=!0)},o(e){u(C.$$.fragment,e),u(x.$$.fragment,e),u(W.$$.fragment,e),u(A.$$.fragment,e),u(M.$$.fragment,e),u(N.$$.fragment,e),u(P.$$.fragment,e),u(Q.$$.fragment,e),u(E.$$.fragment,e),u(v.$$.fragment,e),u(_.$$.fragment,e),u(D.$$.fragment,e),u(q.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(U.$$.fragment,e),u(re.$$.fragment,e),u(j.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(ye.$$.fragment,e),u($e.$$.fragment,e),bt=!1},d(e){e&&(a(w),a(s),a(g),a(_e),a(G),a(Je),a(B),a(ke),a(Z),a(Ue),a(je),a(H),a(Ie),a(L),a(Ce),a(Ge),a(X),a(Be),a(R),a(Ze),a(xe),a(He),a(Y),a(Le),a(We),a(z),a(Xe),a(Re),a(F),a(Ae),a(V),a(Ye),a(Ne),a(S),a(ze),a(Pe),a(b),a(Fe),a(Ve),a(Qe),a(Se),a(J),a(Ee),a(De),a(k),a(qe),a(Ke),a(O),a(Oe),a(et),a(te),a(tt),a(at),a(le),a(lt),a(it),a(ne),a(nt),a(rt),a(st),a(se),a(ct),a(ot),a(dt),a(oe),a(pt),a(de),a(ft),a(mt),a(ht),a(me),a(ut),a(he),a(yt),a(wt),a(gt),a(we),a($t),a(ge),a(Tt),a(Mt),a(Te)),a(r),y(C,e),y(x,e),y(W,e),y(A,e),y(M,e),y(N,e),y(P,e),y(Q,e),y(E,e),y(v,e),y(_,e),y(D,e),y(q,e),y(K,e),y(ee,e),y(ae,e),y(ie,e),y(U,e),y(re,e),y(j,e),y(ce,e),y(pe,e),y(fe,e),y(ue,e),y(ye,e),y($e,e)}}}const ha='{"title":"Quicktour","local":"quicktour","sections":[{"title":"Unified launch interface","local":"unified-launch-interface","sections":[],"depth":2},{"title":"Adapt training code","local":"adapt-training-code","sections":[{"title":"Distributed evaluation","local":"distributed-evaluation","sections":[],"depth":3}],"depth":2},{"title":"Big Model Inference","local":"big-model-inference","sections":[{"title":"Empty weights initialization","local":"empty-weights-initialization","sections":[],"depth":3},{"title":"Load and dispatch weights","local":"load-and-dispatch-weights","sections":[],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function ua($){return aa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ma extends la{constructor(r){super(),ia(this,r,ua,ma,ta,{})}}export{Ma as component};
