import{s as yt,n as Rt,o as Qt}from"../chunks/scheduler.6062bdaf.js";import{S as wt,i as Ct,g as r,s as a,r as u,A as Pt,h as s,f as o,c as i,j as l,u as p,x as L,k as g,y as e,a as q,v as _,d as h,t as f,w as x}from"../chunks/index.4bca734e.js";import{D as M}from"../chunks/Docstring.ed07512f.js";import{H as qt}from"../chunks/Heading.723dceba.js";function Dt(ft){let c,X,A,j,y,S,R,B,n,Q,at,U,xt="Handles the ONNX Runtime quantization process for models shared on huggingface.co/models.",it,b,w,rt,E,bt="Computes the quantization ranges.",st,z,C,mt,H,zt="Performs the calibration step and computes the quantization ranges.",dt,v,P,ct,I,vt="Instantiates a <code>ORTQuantizer</code> from an ONNX model file or an <code>ORTModel</code>.",ut,T,D,lt,W,Tt="Creates the calibration <code>datasets.Dataset</code> to use for the post-training static quantization calibration step.",pt,O,N,gt,k,Ot="Performs the calibration step and collects the quantization ranges without computing them.",_t,$,F,ht,V,$t="Quantizes a model given the optimization specifications defined in <code>quantization_config</code>.",J,G,K;return y=new qt({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),R=new qt({props:{title:"ORTQuantizer",local:"optimum.onnxruntime.ORTQuantizer",headingTag:"h2"}}),Q=new M({props:{name:"class optimum.onnxruntime.ORTQuantizer",anchor:"optimum.onnxruntime.ORTQuantizer",parameters:[{name:"onnx_model_path",val:": Path"},{name:"config",val:": typing.Optional[ForwardRef('PretrainedConfig')] = None"}],source:"https://github.com/huggingface/optimum/blob/v1.18.1/optimum/onnxruntime/quantization.py#L83"}}),w=new M({props:{name:"compute_ranges",anchor:"optimum.onnxruntime.ORTQuantizer.compute_ranges",parameters:[],source:"https://github.com/huggingface/optimum/blob/v1.18.1/optimum/onnxruntime/quantization.py#L261",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary mapping the nodes name to their quantization ranges.</p>
`}}),C=new M({props:{name:"fit",anchor:"optimum.onnxruntime.ORTQuantizer.fit",parameters:[{name:"dataset",val:": Dataset"},{name:"calibration_config",val:": CalibrationConfig"},{name:"onnx_augmented_model_name",val:": typing.Union[str, pathlib.Path] = 'augmented_model.onnx'"},{name:"operators_to_quantize",val:": typing.Optional[typing.List[str]] = None"},{name:"batch_size",val:": int = 1"},{name:"use_external_data_format",val:": bool = False"},{name:"use_gpu",val:": bool = False"},{name:"force_symmetric_range",val:": bool = False"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTQuantizer.fit.dataset",description:`<strong>dataset</strong> (<code>Dataset</code>) &#x2014;
The dataset to use when performing the calibration step.`,name:"dataset"},{anchor:"optimum.onnxruntime.ORTQuantizer.fit.calibration_config",description:`<strong>calibration_config</strong> (<code>~CalibrationConfig</code>) &#x2014;
The configuration containing the parameters related to the calibration step.`,name:"calibration_config"},{anchor:"optimum.onnxruntime.ORTQuantizer.fit.onnx_augmented_model_name",description:`<strong>onnx_augmented_model_name</strong> (<code>Union[str, Path]</code>, defaults to <code>&quot;augmented_model.onnx&quot;</code>) &#x2014;
The path used to save the augmented model used to collect the quantization ranges.`,name:"onnx_augmented_model_name"},{anchor:"optimum.onnxruntime.ORTQuantizer.fit.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
List of the operators types to quantize.`,name:"operators_to_quantize"},{anchor:"optimum.onnxruntime.ORTQuantizer.fit.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The batch size to use when collecting the quantization ranges values.`,name:"batch_size"},{anchor:"optimum.onnxruntime.ORTQuantizer.fit.use_external_data_format",description:`<strong>use_external_data_format</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use external data format to store model which size is &gt;= 2Gb.`,name:"use_external_data_format"},{anchor:"optimum.onnxruntime.ORTQuantizer.fit.use_gpu",description:`<strong>use_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use the GPU when collecting the quantization ranges values.`,name:"use_gpu"},{anchor:"optimum.onnxruntime.ORTQuantizer.fit.force_symmetric_range",description:`<strong>force_symmetric_range</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to make the quantization ranges symmetric.`,name:"force_symmetric_range"}],source:"https://github.com/huggingface/optimum/blob/v1.18.1/optimum/onnxruntime/quantization.py#L157",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary mapping the nodes name to their quantization ranges.</p>
`}}),P=new M({props:{name:"from_pretrained",anchor:"optimum.onnxruntime.ORTQuantizer.from_pretrained",parameters:[{name:"model_or_path",val:": typing.Union[ForwardRef('ORTModel'), str, pathlib.Path]"},{name:"file_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTQuantizer.from_pretrained.model_or_path",description:`<strong>model_or_path</strong> (<code>Union[ORTModel, str, Path]</code>) &#x2014;
Can be either:<ul>
<li>A path to a saved exported ONNX Intermediate Representation (IR) model, e.g., \`./my_model_directory/.</li>
<li>Or an <code>ORTModelForXX</code> class, e.g., <code>ORTModelForQuestionAnswering</code>.</li>
</ul>`,name:"model_or_path"},{anchor:"optimum.onnxruntime.ORTQuantizer.from_pretrained.file_name(Optional[str],",description:`<strong>file_name(<code>Optional[str]</code>,</strong> defaults to <code>None</code>) &#x2014;
Overwrites the default model file name from <code>&quot;model.onnx&quot;</code> to <code>file_name</code>.
This allows you to load different model files from the same repository or directory.`,name:"file_name(Optional[str],"}],source:"https://github.com/huggingface/optimum/blob/v1.18.1/optimum/onnxruntime/quantization.py#L110",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of <code>ORTQuantizer</code>.</p>
`}}),D=new M({props:{name:"get_calibration_dataset",anchor:"optimum.onnxruntime.ORTQuantizer.get_calibration_dataset",parameters:[{name:"dataset_name",val:": str"},{name:"num_samples",val:": int = 100"},{name:"dataset_config_name",val:": typing.Optional[str] = None"},{name:"dataset_split",val:": typing.Optional[str] = None"},{name:"preprocess_function",val:": typing.Optional[typing.Callable] = None"},{name:"preprocess_batch",val:": bool = True"},{name:"seed",val:": int = 2016"},{name:"use_auth_token",val:": bool = False"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTQuantizer.get_calibration_dataset.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>) &#x2014;
The dataset repository name on the Hugging Face Hub or path to a local directory containing data files
to load to use for the calibration step.`,name:"dataset_name"},{anchor:"optimum.onnxruntime.ORTQuantizer.get_calibration_dataset.num_samples",description:`<strong>num_samples</strong> (<code>int</code>, defaults to 100) &#x2014;
The maximum number of samples composing the calibration dataset.`,name:"num_samples"},{anchor:"optimum.onnxruntime.ORTQuantizer.get_calibration_dataset.dataset_config_name",description:`<strong>dataset_config_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The name of the dataset configuration.`,name:"dataset_config_name"},{anchor:"optimum.onnxruntime.ORTQuantizer.get_calibration_dataset.dataset_split",description:`<strong>dataset_split</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
Which split of the dataset to use to perform the calibration step.`,name:"dataset_split"},{anchor:"optimum.onnxruntime.ORTQuantizer.get_calibration_dataset.preprocess_function",description:`<strong>preprocess_function</strong> (<code>Optional[Callable]</code>, defaults to <code>None</code>) &#x2014;
Processing function to apply to each example after loading dataset.`,name:"preprocess_function"},{anchor:"optimum.onnxruntime.ORTQuantizer.get_calibration_dataset.preprocess_batch",description:`<strong>preprocess_batch</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether the <code>preprocess_function</code> should be batched.`,name:"preprocess_batch"},{anchor:"optimum.onnxruntime.ORTQuantizer.get_calibration_dataset.seed",description:`<strong>seed</strong> (<code>int</code>, defaults to 2016) &#x2014;
The random seed to use when shuffling the calibration dataset.`,name:"seed"},{anchor:"optimum.onnxruntime.ORTQuantizer.get_calibration_dataset.use_auth_token",description:`<strong>use_auth_token</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use the token generated when running <code>transformers-cli login</code> (necessary for some datasets
like ImageNet).`,name:"use_auth_token"}],source:"https://github.com/huggingface/optimum/blob/v1.18.1/optimum/onnxruntime/quantization.py#L435",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The calibration <code>datasets.Dataset</code> to use for the post-training static quantization calibration
step.</p>
`}}),N=new M({props:{name:"partial_fit",anchor:"optimum.onnxruntime.ORTQuantizer.partial_fit",parameters:[{name:"dataset",val:": Dataset"},{name:"calibration_config",val:": CalibrationConfig"},{name:"onnx_augmented_model_name",val:": typing.Union[str, pathlib.Path] = 'augmented_model.onnx'"},{name:"operators_to_quantize",val:": typing.Optional[typing.List[str]] = None"},{name:"batch_size",val:": int = 1"},{name:"use_external_data_format",val:": bool = False"},{name:"use_gpu",val:": bool = False"},{name:"force_symmetric_range",val:": bool = False"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTQuantizer.partial_fit.dataset",description:`<strong>dataset</strong> (<code>Dataset</code>) &#x2014;
The dataset to use when performing the calibration step.`,name:"dataset"},{anchor:"optimum.onnxruntime.ORTQuantizer.partial_fit.calibration_config",description:`<strong>calibration_config</strong> (<code>CalibrationConfig</code>) &#x2014;
The configuration containing the parameters related to the calibration step.`,name:"calibration_config"},{anchor:"optimum.onnxruntime.ORTQuantizer.partial_fit.onnx_augmented_model_name",description:`<strong>onnx_augmented_model_name</strong> (<code>Union[str, Path]</code>, defaults to <code>&quot;augmented_model.onnx&quot;</code>) &#x2014;
The path used to save the augmented model used to collect the quantization ranges.`,name:"onnx_augmented_model_name"},{anchor:"optimum.onnxruntime.ORTQuantizer.partial_fit.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
List of the operators types to quantize.`,name:"operators_to_quantize"},{anchor:"optimum.onnxruntime.ORTQuantizer.partial_fit.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The batch size to use when collecting the quantization ranges values.`,name:"batch_size"},{anchor:"optimum.onnxruntime.ORTQuantizer.partial_fit.use_external_data_format",description:`<strong>use_external_data_format</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether uto se external data format to store model which size is &gt;= 2Gb.`,name:"use_external_data_format"},{anchor:"optimum.onnxruntime.ORTQuantizer.partial_fit.use_gpu",description:`<strong>use_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use the GPU when collecting the quantization ranges values.`,name:"use_gpu"},{anchor:"optimum.onnxruntime.ORTQuantizer.partial_fit.force_symmetric_range",description:`<strong>force_symmetric_range</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to make the quantization ranges symmetric.`,name:"force_symmetric_range"}],source:"https://github.com/huggingface/optimum/blob/v1.18.1/optimum/onnxruntime/quantization.py#L211"}}),F=new M({props:{name:"quantize",anchor:"optimum.onnxruntime.ORTQuantizer.quantize",parameters:[{name:"quantization_config",val:": QuantizationConfig"},{name:"save_dir",val:": typing.Union[str, pathlib.Path]"},{name:"file_suffix",val:": typing.Optional[str] = 'quantized'"},{name:"calibration_tensors_range",val:": typing.Union[typing.Dict[str, typing.Tuple[float, float]], NoneType] = None"},{name:"use_external_data_format",val:": bool = False"},{name:"preprocessor",val:": typing.Optional[optimum.onnxruntime.preprocessors.quantization.QuantizationPreprocessor] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTQuantizer.quantize.quantization_config",description:`<strong>quantization_config</strong> (<code>QuantizationConfig</code>) &#x2014;
The configuration containing the parameters related to quantization.`,name:"quantization_config"},{anchor:"optimum.onnxruntime.ORTQuantizer.quantize.save_dir",description:`<strong>save_dir</strong> (<code>Union[str, Path]</code>) &#x2014;
The directory where the quantized model should be saved.`,name:"save_dir"},{anchor:"optimum.onnxruntime.ORTQuantizer.quantize.file_suffix",description:`<strong>file_suffix</strong> (<code>Optional[str]</code>, defaults to <code>&quot;quantized&quot;</code>) &#x2014;
The file_suffix used to save the quantized model.`,name:"file_suffix"},{anchor:"optimum.onnxruntime.ORTQuantizer.quantize.calibration_tensors_range",description:`<strong>calibration_tensors_range</strong> (<code>Optional[Dict[str, Tuple[float, float]]]</code>, defaults to <code>None</code>) &#x2014;
The dictionary mapping the nodes name to their quantization ranges, used and required only when applying static quantization.`,name:"calibration_tensors_range"},{anchor:"optimum.onnxruntime.ORTQuantizer.quantize.use_external_data_format",description:`<strong>use_external_data_format</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use external data format to store model which size is &gt;= 2Gb.`,name:"use_external_data_format"},{anchor:"optimum.onnxruntime.ORTQuantizer.quantize.preprocessor",description:`<strong>preprocessor</strong> (<code>Optional[QuantizationPreprocessor]</code>, defaults to <code>None</code>) &#x2014;
The preprocessor to use to collect the nodes to include or exclude from quantization.`,name:"preprocessor"}],source:"https://github.com/huggingface/optimum/blob/v1.18.1/optimum/onnxruntime/quantization.py#L280",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The path of the resulting quantized model.</p>
`}}),{c(){c=r("meta"),X=a(),A=r("p"),j=a(),u(y.$$.fragment),S=a(),u(R.$$.fragment),B=a(),n=r("div"),u(Q.$$.fragment),at=a(),U=r("p"),U.textContent=xt,it=a(),b=r("div"),u(w.$$.fragment),rt=a(),E=r("p"),E.textContent=bt,st=a(),z=r("div"),u(C.$$.fragment),mt=a(),H=r("p"),H.textContent=zt,dt=a(),v=r("div"),u(P.$$.fragment),ct=a(),I=r("p"),I.innerHTML=vt,ut=a(),T=r("div"),u(D.$$.fragment),lt=a(),W=r("p"),W.innerHTML=Tt,pt=a(),O=r("div"),u(N.$$.fragment),gt=a(),k=r("p"),k.textContent=Ot,_t=a(),$=r("div"),u(F.$$.fragment),ht=a(),V=r("p"),V.innerHTML=$t,J=a(),G=r("p"),this.h()},l(t){const d=Pt("svelte-u9bgzb",document.head);c=s(d,"META",{name:!0,content:!0}),d.forEach(o),X=i(t),A=s(t,"P",{}),l(A).forEach(o),j=i(t),p(y.$$.fragment,t),S=i(t),p(R.$$.fragment,t),B=i(t),n=s(t,"DIV",{class:!0});var m=l(n);p(Q.$$.fragment,m),at=i(m),U=s(m,"P",{"data-svelte-h":!0}),L(U)!=="svelte-1tiz3jr"&&(U.textContent=xt),it=i(m),b=s(m,"DIV",{class:!0});var Y=l(b);p(w.$$.fragment,Y),rt=i(Y),E=s(Y,"P",{"data-svelte-h":!0}),L(E)!=="svelte-1183xvy"&&(E.textContent=bt),Y.forEach(o),st=i(m),z=s(m,"DIV",{class:!0});var Z=l(z);p(C.$$.fragment,Z),mt=i(Z),H=s(Z,"P",{"data-svelte-h":!0}),L(H)!=="svelte-1tzjvze"&&(H.textContent=zt),Z.forEach(o),dt=i(m),v=s(m,"DIV",{class:!0});var tt=l(v);p(P.$$.fragment,tt),ct=i(tt),I=s(tt,"P",{"data-svelte-h":!0}),L(I)!=="svelte-p4e5on"&&(I.innerHTML=vt),tt.forEach(o),ut=i(m),T=s(m,"DIV",{class:!0});var et=l(T);p(D.$$.fragment,et),lt=i(et),W=s(et,"P",{"data-svelte-h":!0}),L(W)!=="svelte-1xfi4es"&&(W.innerHTML=Tt),et.forEach(o),pt=i(m),O=s(m,"DIV",{class:!0});var nt=l(O);p(N.$$.fragment,nt),gt=i(nt),k=s(nt,"P",{"data-svelte-h":!0}),L(k)!=="svelte-g6p4yh"&&(k.textContent=Ot),nt.forEach(o),_t=i(m),$=s(m,"DIV",{class:!0});var ot=l($);p(F.$$.fragment,ot),ht=i(ot),V=s(ot,"P",{"data-svelte-h":!0}),L(V)!=="svelte-4dslow"&&(V.innerHTML=$t),ot.forEach(o),m.forEach(o),J=i(t),G=s(t,"P",{}),l(G).forEach(o),this.h()},h(){g(c,"name","hf:doc:metadata"),g(c,"content",Nt),g(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,d){e(document.head,c),q(t,X,d),q(t,A,d),q(t,j,d),_(y,t,d),q(t,S,d),_(R,t,d),q(t,B,d),q(t,n,d),_(Q,n,null),e(n,at),e(n,U),e(n,it),e(n,b),_(w,b,null),e(b,rt),e(b,E),e(n,st),e(n,z),_(C,z,null),e(z,mt),e(z,H),e(n,dt),e(n,v),_(P,v,null),e(v,ct),e(v,I),e(n,ut),e(n,T),_(D,T,null),e(T,lt),e(T,W),e(n,pt),e(n,O),_(N,O,null),e(O,gt),e(O,k),e(n,_t),e(n,$),_(F,$,null),e($,ht),e($,V),q(t,J,d),q(t,G,d),K=!0},p:Rt,i(t){K||(h(y.$$.fragment,t),h(R.$$.fragment,t),h(Q.$$.fragment,t),h(w.$$.fragment,t),h(C.$$.fragment,t),h(P.$$.fragment,t),h(D.$$.fragment,t),h(N.$$.fragment,t),h(F.$$.fragment,t),K=!0)},o(t){f(y.$$.fragment,t),f(R.$$.fragment,t),f(Q.$$.fragment,t),f(w.$$.fragment,t),f(C.$$.fragment,t),f(P.$$.fragment,t),f(D.$$.fragment,t),f(N.$$.fragment,t),f(F.$$.fragment,t),K=!1},d(t){t&&(o(X),o(A),o(j),o(S),o(B),o(n),o(J),o(G)),o(c),x(y,t),x(R,t),x(Q),x(w),x(C),x(P),x(D),x(N),x(F)}}}const Nt='{"title":"Quantization","local":"quantization","sections":[{"title":"ORTQuantizer","local":"optimum.onnxruntime.ORTQuantizer","sections":[],"depth":2}],"depth":1}';function Ft(ft){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends wt{constructor(c){super(),Ct(this,c,Ft,Dt,yt,{})}}export{Ht as component};
