import{s as Vl,o as Xl,n as vl}from"../chunks/scheduler.8c3d61f6.js";import{S as Wl,i as $l,g as p,s as a,r as w,A as zl,h as c,f as s,c as n,j as Zl,u as j,x as M,k as gl,y as Hl,a as t,v as T,d,t as b,w as U}from"../chunks/index.da70eac4.js";import{T as Rl}from"../chunks/Tip.1d9b8c37.js";import{C as S}from"../chunks/CodeBlock.a9c4becf.js";import{H as Ql,E as Nl}from"../chunks/getInferenceSnippets.725ed3d4.js";function Sl(N){let i,m="🧪 <strong>Experimental Feature</strong>: Modular Diffusers is an experimental feature we are actively developing. The API may be subject to breaking changes.";return{c(){i=p("p"),i.innerHTML=m},l(o){i=c(o,"P",{"data-svelte-h":!0}),M(i)!=="svelte-11qh5l3"&&(i.innerHTML=m)},m(o,r){t(o,i,r)},p:vl,d(o){o&&s(i)}}}function xl(N){let i,m='Other types of multi-blocks include <a href="auto_pipeline_blocks.md">AutoPipelineBlocks</a> (for conditional block selection) and <a href="loop_sequential_pipeline_blocks.md">LoopSequentialPipelineBlocks</a> (for iterative workflows). For information on creating individual blocks, see the <a href="pipeline_block.md">PipelineBlock guide</a>.',o,r,u='Additionally, like all <code>ModularPipelineBlocks</code>, <code>SequentialPipelineBlocks</code> are definitions/specifications, not runnable pipelines. You need to convert them into a <code>ModularPipeline</code> to actually execute them. For information on creating and running pipelines, see the <a href="modular_pipeline.md">Modular Pipeline guide</a>.';return{c(){i=p("p"),i.innerHTML=m,o=a(),r=p("p"),r.innerHTML=u},l(J){i=c(J,"P",{"data-svelte-h":!0}),M(i)!=="svelte-a7cb5j"&&(i.innerHTML=m),o=n(J),r=c(J,"P",{"data-svelte-h":!0}),M(r)!=="svelte-anzuje"&&(r.innerHTML=u)},m(J,y){t(J,i,y),t(J,o,y),t(J,r,y)},p:vl,d(J){J&&(s(i),s(o),s(r))}}}function Fl(N){let i,m,o,r,u,J,y,F,I,jl="<code>SequentialPipelineBlocks</code> is a subclass of <code>ModularPipelineBlocks</code>. Unlike <code>PipelineBlock</code>, it is a multi-block that composes other blocks together in sequence, creating modular workflows where data flows from one block to the next. It’s one of the most common ways to build complex pipelines by combining simpler building blocks.",q,h,P,f,Tl="In this tutorial, we will focus on how to create <code>SequentialPipelineBlocks</code> and how blocks connect and work together.",L,k,dl='The key insight is that blocks connect through their intermediate inputs and outputs - the “studs and anti-studs” we discussed in the <a href="pipeline_block.md">PipelineBlock guide</a>. When one block produces an intermediate output, it becomes available as an intermediate input for subsequent blocks.',D,C,bl="Let’s explore this through an example. We will use the same helper function from the PipelineBlock guide to create blocks.",K,_,O,B,Ul="Let’s create a block that produces <code>batch_size</code>, which we’ll call “input_block”:",ll,A,el,G,hl="Now let’s create a second block that uses the <code>batch_size</code> from the first block:",sl,Y,tl,E,Il="Now let’s connect these blocks to create a <code>SequentialPipelineBlocks</code>:",al,Z,nl,g,fl="Now you have a <code>SequentialPipelineBlocks</code> with 2 blocks:",il,R,pl,v,kl="When you inspect <code>blocks.doc</code>, you can see that <code>batch_size</code> is not listed as an input. The pipeline automatically detects that the <code>input_block</code> can produce <code>batch_size</code> for the <code>image_encoder_block</code>, so it doesn’t ask the user to provide it.",cl,V,Ml,X,Cl="At runtime, you have data flow like this:",ol,W,_l='<img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/modular_quicktour/Editor%20_%20Mermaid%20Chart-2025-06-30-092631.png" alt="Data Flow Diagram"/>',rl,$,Bl="<strong>How SequentialPipelineBlocks Works:</strong>",Jl,z,Al="<li>Blocks are executed in the order they’re registered in the <code>blocks_dict</code></li> <li>Outputs from one block become available as intermediate inputs to all subsequent blocks</li> <li>The pipeline automatically figures out which values need to be provided by the user and which will be generated by previous blocks</li> <li>Each block maintains its own behavior and operates through its defined interface, while collectively these interfaces determine what the entire pipeline accepts and produces</li>",yl,H,Gl="What happens within each block follows the same pattern we described earlier: each block gets its own <code>block_state</code> with the relevant inputs and intermediate inputs, performs its computation, and updates the pipeline state with its intermediate outputs.",ml,Q,ul,x,wl;return u=new Ql({props:{title:"SequentialPipelineBlocks",local:"sequentialpipelineblocks",headingTag:"h1"}}),y=new Rl({props:{warning:!0,$$slots:{default:[Sl]},$$scope:{ctx:N}}}),h=new Rl({props:{$$slots:{default:[xl]},$$scope:{ctx:N}}}),_=new S({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> PipelineBlock, InputParam, OutputParam
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_block</span>(<span class="hljs-params">inputs=[], intermediate_inputs=[], intermediate_outputs=[], block_fn=<span class="hljs-literal">None</span>, description=<span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">class</span> <span class="hljs-title class_">TestBlock</span>(<span class="hljs-title class_ inherited__">PipelineBlock</span>):
        model_name = <span class="hljs-string">&quot;test&quot;</span>
        
<span class="hljs-meta">        @property</span>
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">inputs</span>(<span class="hljs-params">self</span>):
            <span class="hljs-keyword">return</span> inputs
            
<span class="hljs-meta">        @property</span>
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">intermediate_inputs</span>(<span class="hljs-params">self</span>):
            <span class="hljs-keyword">return</span> intermediate_inputs
            
<span class="hljs-meta">        @property</span>
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">intermediate_outputs</span>(<span class="hljs-params">self</span>):
            <span class="hljs-keyword">return</span> intermediate_outputs
            
<span class="hljs-meta">        @property</span>
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">description</span>(<span class="hljs-params">self</span>):
            <span class="hljs-keyword">return</span> description <span class="hljs-keyword">if</span> description <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;&quot;</span>
            
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, state</span>):
            block_state = self.get_block_state(state)
            <span class="hljs-keyword">if</span> block_fn <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
                block_state = block_fn(block_state, state)
            self.set_block_state(state, block_state)
            <span class="hljs-keyword">return</span> components, state
    
    <span class="hljs-keyword">return</span> TestBlock`,wrap:!1}}),A=new S({props:{code:"ZGVmJTIwaW5wdXRfYmxvY2tfZm4oYmxvY2tfc3RhdGUlMkMlMjBwaXBlbGluZV9zdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTIwJTNEJTIwbGVuKGJsb2NrX3N0YXRlLnByb21wdCklMEElMjAlMjAlMjAlMjBibG9ja19zdGF0ZS5iYXRjaF9zaXplJTIwJTNEJTIwYmF0Y2hfc2l6ZSUyMColMjBibG9ja19zdGF0ZS5udW1faW1hZ2VzX3Blcl9wcm9tcHQlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBibG9ja19zdGF0ZSUwQSUwQWlucHV0X2Jsb2NrX2NscyUyMCUzRCUyMG1ha2VfYmxvY2soJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwSW5wdXRQYXJhbShuYW1lJTNEJTIycHJvbXB0JTIyJTJDJTIwdHlwZV9oaW50JTNEbGlzdCUyQyUyMGRlc2NyaXB0aW9uJTNEJTIybGlzdCUyMG9mJTIwdGV4dCUyMHByb21wdHMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwSW5wdXRQYXJhbShuYW1lJTNEJTIybnVtX2ltYWdlc19wZXJfcHJvbXB0JTIyJTJDJTIwdHlwZV9oaW50JTNEaW50JTJDJTIwZGVzY3JpcHRpb24lM0QlMjJudW1iZXIlMjBvZiUyMGltYWdlcyUyMHBlciUyMHByb21wdCUyMiklMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBpbnRlcm1lZGlhdGVfb3V0cHV0cyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME91dHB1dFBhcmFtKG5hbWUlM0QlMjJiYXRjaF9zaXplJTIyJTJDJTIwZGVzY3JpcHRpb24lM0QlMjJjYWxjdWxhdGVkJTIwYmF0Y2glMjBzaXplJTIyKSUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMGJsb2NrX2ZuJTNEaW5wdXRfYmxvY2tfZm4lMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMkElMjBibG9jayUyMHRoYXQlMjBkZXRlcm1pbmVzJTIwYmF0Y2hfc2l6ZSUyMGJhc2VkJTIwb24lMjB0aGUlMjBudW1iZXIlMjBvZiUyMHByb21wdHMlMjBhbmQlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlMjBhcmd1bWVudC4lMjIlMEEpJTBBaW5wdXRfYmxvY2slMjAlM0QlMjBpbnB1dF9ibG9ja19jbHMoKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">input_block_fn</span>(<span class="hljs-params">block_state, pipeline_state</span>):
    
    batch_size = <span class="hljs-built_in">len</span>(block_state.prompt)
    block_state.batch_size = batch_size * block_state.num_images_per_prompt
    
    <span class="hljs-keyword">return</span> block_state

input_block_cls = make_block(
    inputs=[
        InputParam(name=<span class="hljs-string">&quot;prompt&quot;</span>, type_hint=<span class="hljs-built_in">list</span>, description=<span class="hljs-string">&quot;list of text prompts&quot;</span>),
        InputParam(name=<span class="hljs-string">&quot;num_images_per_prompt&quot;</span>, type_hint=<span class="hljs-built_in">int</span>, description=<span class="hljs-string">&quot;number of images per prompt&quot;</span>)
    ],
    intermediate_outputs=[
        OutputParam(name=<span class="hljs-string">&quot;batch_size&quot;</span>, description=<span class="hljs-string">&quot;calculated batch size&quot;</span>)
    ],
    block_fn=input_block_fn,
    description=<span class="hljs-string">&quot;A block that determines batch_size based on the number of prompts and num_images_per_prompt argument.&quot;</span>
)
input_block = input_block_cls()`,wrap:!1}}),Y=new S({props:{code:"ZGVmJTIwaW1hZ2VfZW5jb2Rlcl9ibG9ja19mbihibG9ja19zdGF0ZSUyQyUyMHBpcGVsaW5lX3N0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFNpbXVsYXRlJTIwcHJvY2Vzc2luZyUyMHRoZSUyMGltYWdlJTBBJTIwJTIwJTIwJTIwYmxvY2tfc3RhdGUuaW1hZ2UlMjAlM0QlMjB0b3JjaC5yYW5kbigxJTJDJTIwMyUyQyUyMDUxMiUyQyUyMDUxMiklMEElMjAlMjAlMjAlMjBibG9ja19zdGF0ZS5iYXRjaF9zaXplJTIwJTNEJTIwYmxvY2tfc3RhdGUuYmF0Y2hfc2l6ZSUyMColMjAyJTBBJTIwJTIwJTIwJTIwYmxvY2tfc3RhdGUuaW1hZ2VfbGF0ZW50cyUyMCUzRCUyMHRvcmNoLnJhbmRuKDElMkMlMjA0JTJDJTIwNjQlMkMlMjA2NCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBibG9ja19zdGF0ZSUwQSUwQWltYWdlX2VuY29kZXJfYmxvY2tfY2xzJTIwJTNEJTIwbWFrZV9ibG9jayglMEElMjAlMjAlMjAlMjBpbnB1dHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBJbnB1dFBhcmFtKG5hbWUlM0QlMjJpbWFnZSUyMiUyQyUyMHR5cGVfaGludCUzRCUyMlBJTC5JbWFnZSUyMiUyQyUyMGRlc2NyaXB0aW9uJTNEJTIycmF3JTIwaW5wdXQlMjBpbWFnZSUyMHRvJTIwcHJvY2VzcyUyMiklMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBpbnRlcm1lZGlhdGVfaW5wdXRzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwSW5wdXRQYXJhbShuYW1lJTNEJTIyYmF0Y2hfc2l6ZSUyMiUyQyUyMHR5cGVfaGludCUzRGludCklMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBpbnRlcm1lZGlhdGVfb3V0cHV0cyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME91dHB1dFBhcmFtKG5hbWUlM0QlMjJpbWFnZV9sYXRlbnRzJTIyJTJDJTIwZGVzY3JpcHRpb24lM0QlMjJsYXRlbnRzJTIwcmVwcmVzZW50aW5nJTIwdGhlJTIwaW1hZ2UlMjIpJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwYmxvY2tfZm4lM0RpbWFnZV9lbmNvZGVyX2Jsb2NrX2ZuJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJFbmNvZGUlMjByYXclMjBpbWFnZSUyMGludG8lMjBpdHMlMjBsYXRlbnQlMjBwcmVzZW50YXRpb24lMjIlMEEpJTBBaW1hZ2VfZW5jb2Rlcl9ibG9jayUyMCUzRCUyMGltYWdlX2VuY29kZXJfYmxvY2tfY2xzKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">image_encoder_block_fn</span>(<span class="hljs-params">block_state, pipeline_state</span>):
    <span class="hljs-comment"># Simulate processing the image</span>
    block_state.image = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>)
    block_state.batch_size = block_state.batch_size * <span class="hljs-number">2</span>
    block_state.image_latents = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>)
    <span class="hljs-keyword">return</span> block_state

image_encoder_block_cls = make_block(
    inputs=[
        InputParam(name=<span class="hljs-string">&quot;image&quot;</span>, type_hint=<span class="hljs-string">&quot;PIL.Image&quot;</span>, description=<span class="hljs-string">&quot;raw input image to process&quot;</span>)
    ],
    intermediate_inputs=[
        InputParam(name=<span class="hljs-string">&quot;batch_size&quot;</span>, type_hint=<span class="hljs-built_in">int</span>)
    ],
    intermediate_outputs=[
        OutputParam(name=<span class="hljs-string">&quot;image_latents&quot;</span>, description=<span class="hljs-string">&quot;latents representing the image&quot;</span>)
    ],
    block_fn=image_encoder_block_fn,
    description=<span class="hljs-string">&quot;Encode raw image into its latent presentation&quot;</span>
)
image_encoder_block = image_encoder_block_cls()`,wrap:!1}}),Z=new S({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcyUyMGltcG9ydCUyMFNlcXVlbnRpYWxQaXBlbGluZUJsb2NrcyUyQyUyMEluc2VydGFibGVEaWN0JTBBJTBBJTIzJTIwRGVmaW5lJTIwYSUyMGRpY3QlMjBtYXBwaW5nJTIwYmxvY2slMjBuYW1lcyUyMHRvJTIwYmxvY2slMjBpbnN0YW5jZXMlMEFibG9ja3NfZGljdCUyMCUzRCUyMEluc2VydGFibGVEaWN0KCklMEFibG9ja3NfZGljdCU1QiUyMmlucHV0JTIyJTVEJTIwJTNEJTIwaW5wdXRfYmxvY2slMEFibG9ja3NfZGljdCU1QiUyMmltYWdlX2VuY29kZXIlMjIlNUQlMjAlM0QlMjBpbWFnZV9lbmNvZGVyX2Jsb2NrJTBBJTBBJTIzJTIwQ3JlYXRlJTIwdGhlJTIwU2VxdWVudGlhbFBpcGVsaW5lQmxvY2tzJTBBYmxvY2tzJTIwJTNEJTIwU2VxdWVudGlhbFBpcGVsaW5lQmxvY2tzLmZyb21fYmxvY2tzX2RpY3QoYmxvY2tzX2RpY3Qp",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> SequentialPipelineBlocks, InsertableDict

<span class="hljs-comment"># Define a dict mapping block names to block instances</span>
blocks_dict = InsertableDict()
blocks_dict[<span class="hljs-string">&quot;input&quot;</span>] = input_block
blocks_dict[<span class="hljs-string">&quot;image_encoder&quot;</span>] = image_encoder_block

<span class="hljs-comment"># Create the SequentialPipelineBlocks</span>
blocks = SequentialPipelineBlocks.from_blocks_dict(blocks_dict)`,wrap:!1}}),R=new S({props:{code:"YmxvY2tzJTBBJTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>blocks
SequentialPipelineBlocks(
  Class: ModularPipelineBlocks

  Description: 


  Sub-Blocks:
    [<span class="hljs-number">0</span>] <span class="hljs-built_in">input</span> (TestBlock)
       Description: A block that determines batch_size based on the number of prompts <span class="hljs-keyword">and</span> num_images_per_prompt argument.

    [<span class="hljs-number">1</span>] image_encoder (TestBlock)
       Description: Encode raw image into its latent presentation

)`,wrap:!1}}),V=new S({props:{code:"cHJpbnQoYmxvY2tzLmRvYyklMEElMEElMEElMEElMEElMEElMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(blocks.doc)
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SequentialPipelineBlocks</span>

  Inputs:

      prompt (\`<span class="hljs-literal">None</span>\`, *optional*):

      num_images_per_prompt (\`<span class="hljs-literal">None</span>\`, *optional*):

      image (\`PIL.Image\`, *optional*):
          raw <span class="hljs-built_in">input</span> image to process

  Outputs:

      batch_size (\`<span class="hljs-literal">None</span>\`):

      image_latents (\`<span class="hljs-literal">None</span>\`):
          latents representing the image`,wrap:!1}}),Q=new Nl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/modular_diffusers/sequential_pipeline_blocks.md"}}),{c(){i=p("meta"),m=a(),o=p("p"),r=a(),w(u.$$.fragment),J=a(),w(y.$$.fragment),F=a(),I=p("p"),I.innerHTML=jl,q=a(),w(h.$$.fragment),P=a(),f=p("p"),f.innerHTML=Tl,L=a(),k=p("p"),k.innerHTML=dl,D=a(),C=p("p"),C.textContent=bl,K=a(),w(_.$$.fragment),O=a(),B=p("p"),B.innerHTML=Ul,ll=a(),w(A.$$.fragment),el=a(),G=p("p"),G.innerHTML=hl,sl=a(),w(Y.$$.fragment),tl=a(),E=p("p"),E.innerHTML=Il,al=a(),w(Z.$$.fragment),nl=a(),g=p("p"),g.innerHTML=fl,il=a(),w(R.$$.fragment),pl=a(),v=p("p"),v.innerHTML=kl,cl=a(),w(V.$$.fragment),Ml=a(),X=p("p"),X.textContent=Cl,ol=a(),W=p("p"),W.innerHTML=_l,rl=a(),$=p("p"),$.innerHTML=Bl,Jl=a(),z=p("ol"),z.innerHTML=Al,yl=a(),H=p("p"),H.innerHTML=Gl,ml=a(),w(Q.$$.fragment),ul=a(),x=p("p"),this.h()},l(l){const e=zl("svelte-u9bgzb",document.head);i=c(e,"META",{name:!0,content:!0}),e.forEach(s),m=n(l),o=c(l,"P",{}),Zl(o).forEach(s),r=n(l),j(u.$$.fragment,l),J=n(l),j(y.$$.fragment,l),F=n(l),I=c(l,"P",{"data-svelte-h":!0}),M(I)!=="svelte-lkeq7d"&&(I.innerHTML=jl),q=n(l),j(h.$$.fragment,l),P=n(l),f=c(l,"P",{"data-svelte-h":!0}),M(f)!=="svelte-wd2mvc"&&(f.innerHTML=Tl),L=n(l),k=c(l,"P",{"data-svelte-h":!0}),M(k)!=="svelte-zj48j9"&&(k.innerHTML=dl),D=n(l),C=c(l,"P",{"data-svelte-h":!0}),M(C)!=="svelte-zxlpt5"&&(C.textContent=bl),K=n(l),j(_.$$.fragment,l),O=n(l),B=c(l,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1654za5"&&(B.innerHTML=Ul),ll=n(l),j(A.$$.fragment,l),el=n(l),G=c(l,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1m93z3e"&&(G.innerHTML=hl),sl=n(l),j(Y.$$.fragment,l),tl=n(l),E=c(l,"P",{"data-svelte-h":!0}),M(E)!=="svelte-nhjvm4"&&(E.innerHTML=Il),al=n(l),j(Z.$$.fragment,l),nl=n(l),g=c(l,"P",{"data-svelte-h":!0}),M(g)!=="svelte-13ut5ty"&&(g.innerHTML=fl),il=n(l),j(R.$$.fragment,l),pl=n(l),v=c(l,"P",{"data-svelte-h":!0}),M(v)!=="svelte-17k1idd"&&(v.innerHTML=kl),cl=n(l),j(V.$$.fragment,l),Ml=n(l),X=c(l,"P",{"data-svelte-h":!0}),M(X)!=="svelte-spy343"&&(X.textContent=Cl),ol=n(l),W=c(l,"P",{"data-svelte-h":!0}),M(W)!=="svelte-szckjx"&&(W.innerHTML=_l),rl=n(l),$=c(l,"P",{"data-svelte-h":!0}),M($)!=="svelte-1h5pvg6"&&($.innerHTML=Bl),Jl=n(l),z=c(l,"OL",{"data-svelte-h":!0}),M(z)!=="svelte-1wy15br"&&(z.innerHTML=Al),yl=n(l),H=c(l,"P",{"data-svelte-h":!0}),M(H)!=="svelte-xwhbre"&&(H.innerHTML=Gl),ml=n(l),j(Q.$$.fragment,l),ul=n(l),x=c(l,"P",{}),Zl(x).forEach(s),this.h()},h(){gl(i,"name","hf:doc:metadata"),gl(i,"content",ql)},m(l,e){Hl(document.head,i),t(l,m,e),t(l,o,e),t(l,r,e),T(u,l,e),t(l,J,e),T(y,l,e),t(l,F,e),t(l,I,e),t(l,q,e),T(h,l,e),t(l,P,e),t(l,f,e),t(l,L,e),t(l,k,e),t(l,D,e),t(l,C,e),t(l,K,e),T(_,l,e),t(l,O,e),t(l,B,e),t(l,ll,e),T(A,l,e),t(l,el,e),t(l,G,e),t(l,sl,e),T(Y,l,e),t(l,tl,e),t(l,E,e),t(l,al,e),T(Z,l,e),t(l,nl,e),t(l,g,e),t(l,il,e),T(R,l,e),t(l,pl,e),t(l,v,e),t(l,cl,e),T(V,l,e),t(l,Ml,e),t(l,X,e),t(l,ol,e),t(l,W,e),t(l,rl,e),t(l,$,e),t(l,Jl,e),t(l,z,e),t(l,yl,e),t(l,H,e),t(l,ml,e),T(Q,l,e),t(l,ul,e),t(l,x,e),wl=!0},p(l,[e]){const Yl={};e&2&&(Yl.$$scope={dirty:e,ctx:l}),y.$set(Yl);const El={};e&2&&(El.$$scope={dirty:e,ctx:l}),h.$set(El)},i(l){wl||(d(u.$$.fragment,l),d(y.$$.fragment,l),d(h.$$.fragment,l),d(_.$$.fragment,l),d(A.$$.fragment,l),d(Y.$$.fragment,l),d(Z.$$.fragment,l),d(R.$$.fragment,l),d(V.$$.fragment,l),d(Q.$$.fragment,l),wl=!0)},o(l){b(u.$$.fragment,l),b(y.$$.fragment,l),b(h.$$.fragment,l),b(_.$$.fragment,l),b(A.$$.fragment,l),b(Y.$$.fragment,l),b(Z.$$.fragment,l),b(R.$$.fragment,l),b(V.$$.fragment,l),b(Q.$$.fragment,l),wl=!1},d(l){l&&(s(m),s(o),s(r),s(J),s(F),s(I),s(q),s(P),s(f),s(L),s(k),s(D),s(C),s(K),s(O),s(B),s(ll),s(el),s(G),s(sl),s(tl),s(E),s(al),s(nl),s(g),s(il),s(pl),s(v),s(cl),s(Ml),s(X),s(ol),s(W),s(rl),s($),s(Jl),s(z),s(yl),s(H),s(ml),s(ul),s(x)),s(i),U(u,l),U(y,l),U(h,l),U(_,l),U(A,l),U(Y,l),U(Z,l),U(R,l),U(V,l),U(Q,l)}}}const ql='{"title":"SequentialPipelineBlocks","local":"sequentialpipelineblocks","sections":[],"depth":1}';function Pl(N){return Xl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ee extends Wl{constructor(i){super(),$l(this,i,Pl,Fl,Vl,{})}}export{ee as component};
