import{s as dt,o as yt,n as Fe}from"../chunks/scheduler.8c3d61f6.js";import{S as ht,i as bt,g as c,s as n,r as M,A as wt,h as o,f as s,c as i,j as ft,u,x as r,k as le,y as jt,a as l,v as m,d as f,t as d,w as y}from"../chunks/index.da70eac4.js";import{T as Ve}from"../chunks/Tip.1d9b8c37.js";import{C as se}from"../chunks/CodeBlock.00a903b3.js";import{H as ne,E as Jt}from"../chunks/EditOnGithub.1e64e623.js";function gt(w){let a,h='🤗 Diffusers currently only supports <code>callback_on_step_end</code>, but feel free to open a <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">feature request</a> if you have a cool use-case and require a callback function with a different execution point!';return{c(){a=c("p"),a.innerHTML=h},l(p){a=o(p,"P",{"data-svelte-h":!0}),r(a)!=="svelte-1g9pkv"&&(a.innerHTML=h)},m(p,b){l(p,a,b)},p:Fe,d(p){p&&s(a)}}}function Tt(w){let a,h='If you want to add a new official callback, feel free to open a <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">feature request</a> or <a href="https://huggingface.co/docs/diffusers/main/en/conceptual/contribution#how-to-open-a-pr" rel="nofollow">submit a PR</a>.';return{c(){a=c("p"),a.innerHTML=h},l(p){a=o(p,"P",{"data-svelte-h":!0}),r(a)!=="svelte-1q7jmra"&&(a.innerHTML=h)},m(p,b){l(p,a,b)},p:Fe,d(p){p&&s(a)}}}function Ut(w){let a,h='The interruption callback is supported for text-to-image, image-to-image, and inpainting for the <a href="../api/pipelines/stable_diffusion/overview">StableDiffusionPipeline</a> and <a href="../api/pipelines/stable_diffusion/stable_diffusion_xl">StableDiffusionXLPipeline</a>.';return{c(){a=c("p"),a.innerHTML=h},l(p){a=o(p,"P",{"data-svelte-h":!0}),r(a)!=="svelte-q9hytq"&&(a.innerHTML=h)},m(p,b){l(p,a,b)},p:Fe,d(p){p&&s(a)}}}function Ct(w){let a,h='This tip was contributed by <a href="https://github.com/asomoza" rel="nofollow">asomoza</a>.';return{c(){a=c("p"),a.innerHTML=h},l(p){a=o(p,"P",{"data-svelte-h":!0}),r(a)!=="svelte-13sfhtz"&&(a.innerHTML=h)},m(p,b){l(p,a,b)},p:Fe,d(p){p&&s(a)}}}function _t(w){let a,h,p,b,k,ie,I,He="The denoising loop of a pipeline can be modified with custom defined functions using the <code>callback_on_step_end</code> parameter. The callback function is executed at the end of each step, and modifies the pipeline attributes and variables for the next step. This is really useful for <em>dynamically</em> adjusting certain pipeline attributes or modifying tensor variables. This versatility allows for interesting use cases such as changing the prompt embeddings at each timestep, assigning different weights to the prompt embeddings, and editing the guidance scale. With callbacks, you can implement new features without modifying the underlying code!",pe,j,ce,G,Qe="This guide will demonstrate how callbacks work by a few features you can implement with them.",oe,W,re,B,ze="We provide a list of callbacks you can plug into an existing pipeline and modify the denoising loop. This is the current list of official callbacks:",Me,$,Le="<li><code>SDCFGCutoffCallback</code>: Disables the CFG after a certain number of steps for all SD 1.5 pipelines, including text-to-image, image-to-image, inpaint, and controlnet.</li> <li><code>SDXLCFGCutoffCallback</code>: Disables the CFG after a certain number of steps for all SDXL pipelines, including text-to-image, image-to-image, inpaint, and controlnet.</li> <li><code>IPAdapterScaleCutoffCallback</code>: Disables the IP Adapter after a certain number of steps for all pipelines supporting IP-Adapter.</li>",ue,J,me,v,qe="To set up a callback, you need to specify the number of denoising steps after which the callback comes into effect. You can do so by using either one of these two arguments",fe,A,De="<li><code>cutoff_step_ratio</code>: Float number with the ratio of the steps.</li> <li><code>cutoff_step_index</code>: Integer number with the exact number of the step.</li>",de,x,ye,g,Pe='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/without_cfg_callback.png" alt="generated image of a sports car at the road"/> <figcaption class="mt-2 text-center text-sm text-gray-500">without SDXLCFGCutoffCallback</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/with_cfg_callback.png" alt="generated image of a sports car at the road with cfg callback"/> <figcaption class="mt-2 text-center text-sm text-gray-500">with SDXLCFGCutoffCallback</figcaption></div>',he,Y,be,X,Ke="Dynamic classifier-free guidance (CFG) is a feature that allows you to disable CFG after a certain number of inference steps which can help you save compute with minimal cost to performance. The callback function for this should have the following arguments:",we,N,Oe="<li><code>pipeline</code> (or the pipeline instance) provides access to important properties such as <code>num_timesteps</code> and <code>guidance_scale</code>. You can modify these properties by updating the underlying attributes. For this example, you’ll disable CFG by setting <code>pipeline._guidance_scale=0.0</code>.</li> <li><code>step_index</code> and <code>timestep</code> tell you where you are in the denoising loop. Use <code>step_index</code> to turn off CFG after reaching 40% of <code>num_timesteps</code>.</li> <li><code>callback_kwargs</code> is a dict that contains tensor variables you can modify during the denoising loop. It only includes variables specified in the <code>callback_on_step_end_tensor_inputs</code> argument, which is passed to the pipeline’s <code>__call__</code> method. Different pipelines may use different sets of variables, so please check a pipeline’s <code>_callback_tensor_inputs</code> attribute for the list of variables you can modify. Some common variables include <code>latents</code> and <code>prompt_embeds</code>. For this function, change the batch size of <code>prompt_embeds</code> after setting <code>guidance_scale=0.0</code> in order for it to work properly.</li>",je,E,et="Your callback function should look something like this:",Je,R,ge,S,tt="Now, you can pass the callback function to the <code>callback_on_step_end</code> parameter and the <code>prompt_embeds</code> to <code>callback_on_step_end_tensor_inputs</code>.",Te,V,Ue,F,Ce,T,_e,H,st="Stopping the diffusion process early is useful when building UIs that work with Diffusers because it allows users to stop the generation process if they’re unhappy with the intermediate results. You can incorporate this into your pipeline with a callback.",Ze,Q,lt="This callback function should take the following arguments: <code>pipeline</code>, <code>i</code>, <code>t</code>, and <code>callback_kwargs</code> (this must be returned). Set the pipeline’s <code>_interrupt</code> attribute to <code>True</code> to stop the diffusion process after a certain number of steps. You are also free to implement your own custom stopping logic inside the callback.",ke,z,at="In this example, the diffusion process is stopped after 10 steps even though <code>num_inference_steps</code> is set to 50.",Ie,L,Ge,q,We,U,Be,D,nt="Display an image after each generation step by accessing and converting the latents after each step into an image. The latent space is compressed to 128x128, so the images are also 128x128 which is useful for a quick preview.",$e,P,it='<li>Use the function below to convert the SDXL latents (4 channels) to RGB tensors (3 channels) as explained in the <a href="https://huggingface.co/blog/TimothyAlexisVass/explaining-the-sdxl-latent-space" rel="nofollow">Explaining the SDXL latent space</a> blog post.</li>',ve,K,Ae,C,pt="<li>Create a function to decode and save the latents into an image.</li>",xe,O,Ye,_,ct="<li>Pass the <code>decode_tensors</code> function to the <code>callback_on_step_end</code> parameter to decode the tensors after each step. You also need to specify what you want to modify in the <code>callback_on_step_end_tensor_inputs</code> parameter, which in this case are the latents.</li>",Xe,ee,Ne,Z,ot='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/tips_step_0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">step 0</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/tips_step_19.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">step 19</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/tips_step_29.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">step 29</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/tips_step_39.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">step 39</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/tips_step_49.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">step 49</figcaption></div>',Ee,te,Re,ae,Se;return k=new ne({props:{title:"Pipeline callbacks",local:"pipeline-callbacks",headingTag:"h1"}}),j=new Ve({props:{warning:!1,$$slots:{default:[gt]},$$scope:{ctx:w}}}),W=new ne({props:{title:"Official callbacks",local:"official-callbacks",headingTag:"h2"}}),J=new Ve({props:{warning:!1,$$slots:{default:[Tt]},$$scope:{ctx:w}}}),x=new se({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMuY2FsbGJhY2tzJTIwaW1wb3J0JTIwU0RYTENGR0N1dG9mZkNhbGxiYWNrJTBBJTBBJTBBY2FsbGJhY2slMjAlM0QlMjBTRFhMQ0ZHQ3V0b2ZmQ2FsbGJhY2soY3V0b2ZmX3N0ZXBfcmF0aW8lM0QwLjQpJTBBJTIzJTIwY2FuJTIwYWxzbyUyMGJlJTIwdXNlZCUyMHdpdGglMjBjdXRvZmZfc3RlcF9pbmRleCUwQSUyMyUyMGNhbGxiYWNrJTIwJTNEJTIwU0RYTENGR0N1dG9mZkNhbGxiYWNrKGN1dG9mZl9zdGVwX3JhdGlvJTNETm9uZSUyQyUyMGN1dG9mZl9zdGVwX2luZGV4JTNEMTApJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyUyQyUyMHVzZV9rYXJyYXNfc2lnbWFzJTNEVHJ1ZSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwc3BvcnRzJTIwY2FyJTIwYXQlMjB0aGUlMjByb2FkJTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyQyUyMGhpZ2glMjBkZXRhaWwlMkMlMjA4ayUyMHJlc29sdXRpb24lMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgyNjI4NjcwNjQxKSUwQSUwQW91dCUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNENi41JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwY2FsbGJhY2tfb25fc3RlcF9lbmQlM0RjYWxsYmFjayUyQyUwQSklMEElMEFvdXQuaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMm9mZmljaWFsX2NhbGxiYWNrLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler, StableDiffusionXLPipeline
<span class="hljs-keyword">from</span> diffusers.callbacks <span class="hljs-keyword">import</span> SDXLCFGCutoffCallback


callback = SDXLCFGCutoffCallback(cutoff_step_ratio=<span class="hljs-number">0.4</span>)
<span class="hljs-comment"># can also be used with cutoff_step_index</span>
<span class="hljs-comment"># callback = SDXLCFGCutoffCallback(cutoff_step_ratio=None, cutoff_step_index=10)</span>

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.scheduler = DPMSolverMultistepScheduler.from_config(pipeline.scheduler.config, use_karras_sigmas=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;a sports car at the road, best quality, high quality, high detail, 8k resolution&quot;</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">2628670641</span>)

out = pipeline(
    prompt=prompt,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    guidance_scale=<span class="hljs-number">6.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=generator,
    callback_on_step_end=callback,
)

out.images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;official_callback.png&quot;</span>)`,wrap:!1}}),Y=new ne({props:{title:"Dynamic classifier-free guidance",local:"dynamic-classifier-free-guidance",headingTag:"h2"}}),R=new se({props:{code:"ZGVmJTIwY2FsbGJhY2tfZHluYW1pY19jZmcocGlwZSUyQyUyMHN0ZXBfaW5kZXglMkMlMjB0aW1lc3RlcCUyQyUyMGNhbGxiYWNrX2t3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBhZGp1c3QlMjB0aGUlMjBiYXRjaF9zaXplJTIwb2YlMjBwcm9tcHRfZW1iZWRzJTIwYWNjb3JkaW5nJTIwdG8lMjBndWlkYW5jZV9zY2FsZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc3RlcF9pbmRleCUyMCUzRCUzRCUyMGludChwaXBlbGluZS5udW1fdGltZXN0ZXBzJTIwKiUyMDAuNCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTIwJTNEJTIwY2FsbGJhY2tfa3dhcmdzJTVCJTIycHJvbXB0X2VtYmVkcyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb21wdF9lbWJlZHMlMjAlM0QlMjBwcm9tcHRfZW1iZWRzLmNodW5rKDIpJTVCLTElNUQlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjB1cGRhdGUlMjBndWlkYW5jZV9zY2FsZSUyMGFuZCUyMHByb21wdF9lbWJlZHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlbGluZS5fZ3VpZGFuY2Vfc2NhbGUlMjAlM0QlMjAwLjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYWxsYmFja19rd2FyZ3MlNUIlMjJwcm9tcHRfZW1iZWRzJTIyJTVEJTIwJTNEJTIwcHJvbXB0X2VtYmVkcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGNhbGxiYWNrX2t3YXJncw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">callback_dynamic_cfg</span>(<span class="hljs-params">pipe, step_index, timestep, callback_kwargs</span>):
        <span class="hljs-comment"># adjust the batch_size of prompt_embeds according to guidance_scale</span>
        <span class="hljs-keyword">if</span> step_index == <span class="hljs-built_in">int</span>(pipeline.num_timesteps * <span class="hljs-number">0.4</span>):
                prompt_embeds = callback_kwargs[<span class="hljs-string">&quot;prompt_embeds&quot;</span>]
                prompt_embeds = prompt_embeds.chunk(<span class="hljs-number">2</span>)[-<span class="hljs-number">1</span>]

                <span class="hljs-comment"># update guidance_scale and prompt_embeds</span>
                pipeline._guidance_scale = <span class="hljs-number">0.0</span>
                callback_kwargs[<span class="hljs-string">&quot;prompt_embeds&quot;</span>] = prompt_embeds
        <span class="hljs-keyword">return</span> callback_kwargs`,wrap:!1}}),V=new se({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZSUyMCUzRCUyMHBpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgxKSUwQW91dCUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGNhbGxiYWNrX29uX3N0ZXBfZW5kJTNEY2FsbGJhY2tfZHluYW1pY19jZmclMkMlMEElMjAlMjAlMjAlMjBjYWxsYmFja19vbl9zdGVwX2VuZF90ZW5zb3JfaW5wdXRzJTNEJTVCJ3Byb21wdF9lbWJlZHMnJTVEJTBBKSUwQSUwQW91dC5pbWFnZXMlNUIwJTVELnNhdmUoJTIyb3V0X2N1c3RvbV9jZmcucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">1</span>)
out = pipeline(
    prompt,
    generator=generator,
    callback_on_step_end=callback_dynamic_cfg,
    callback_on_step_end_tensor_inputs=[<span class="hljs-string">&#x27;prompt_embeds&#x27;</span>]
)

out.images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;out_custom_cfg.png&quot;</span>)`,wrap:!1}}),F=new ne({props:{title:"Interrupt the diffusion process",local:"interrupt-the-diffusion-process",headingTag:"h2"}}),T=new Ve({props:{warning:!1,$$slots:{default:[Ut]},$$scope:{ctx:w}}}),L=new se({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFudW1faW5mZXJlbmNlX3N0ZXBzJTIwJTNEJTIwNTAlMEElMEFkZWYlMjBpbnRlcnJ1cHRfY2FsbGJhY2socGlwZWxpbmUlMkMlMjBpJTJDJTIwdCUyQyUyMGNhbGxiYWNrX2t3YXJncyklM0ElMEElMjAlMjAlMjAlMjBzdG9wX2lkeCUyMCUzRCUyMDEwJTBBJTIwJTIwJTIwJTIwaWYlMjBpJTIwJTNEJTNEJTIwc3RvcF9pZHglM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlbGluZS5faW50ZXJydXB0JTIwJTNEJTIwVHJ1ZSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGNhbGxiYWNrX2t3YXJncyUwQSUwQXBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMkElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0RudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwY2FsbGJhY2tfb25fc3RlcF9lbmQlM0RpbnRlcnJ1cHRfY2FsbGJhY2slMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
pipeline.enable_model_cpu_offload()
num_inference_steps = <span class="hljs-number">50</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">interrupt_callback</span>(<span class="hljs-params">pipeline, i, t, callback_kwargs</span>):
    stop_idx = <span class="hljs-number">10</span>
    <span class="hljs-keyword">if</span> i == stop_idx:
        pipeline._interrupt = <span class="hljs-literal">True</span>

    <span class="hljs-keyword">return</span> callback_kwargs

pipeline(
    <span class="hljs-string">&quot;A photo of a cat&quot;</span>,
    num_inference_steps=num_inference_steps,
    callback_on_step_end=interrupt_callback,
)`,wrap:!1}}),q=new ne({props:{title:"Display image after each generation step",local:"display-image-after-each-generation-step",headingTag:"h2"}}),U=new Ve({props:{warning:!1,$$slots:{default:[Ct]},$$scope:{ctx:w}}}),K=new se({props:{code:"ZGVmJTIwbGF0ZW50c190b19yZ2IobGF0ZW50cyklM0ElMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCg2MCUyQyUyMC02MCUyQyUyMDI1JTJDJTIwLTcwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCg2MCUyQyUyMCUyMC01JTJDJTIwMTUlMkMlMjAtNTApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKDYwJTJDJTIwJTIwMTAlMkMlMjAtNSUyQyUyMC0zNSklMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwd2VpZ2h0c190ZW5zb3IlMjAlM0QlMjB0b3JjaC50KHRvcmNoLnRlbnNvcih3ZWlnaHRzJTJDJTIwZHR5cGUlM0RsYXRlbnRzLmR0eXBlKS50byhsYXRlbnRzLmRldmljZSkpJTBBJTIwJTIwJTIwJTIwYmlhc2VzX3RlbnNvciUyMCUzRCUyMHRvcmNoLnRlbnNvcigoMTUwJTJDJTIwMTQwJTJDJTIwMTMwKSUyQyUyMGR0eXBlJTNEbGF0ZW50cy5kdHlwZSkudG8obGF0ZW50cy5kZXZpY2UpJTBBJTIwJTIwJTIwJTIwcmdiX3RlbnNvciUyMCUzRCUyMHRvcmNoLmVpbnN1bSglMjIuLi5seHklMkNsciUyMC0lM0UlMjAuLi5yeHklMjIlMkMlMjBsYXRlbnRzJTJDJTIwd2VpZ2h0c190ZW5zb3IpJTIwJTJCJTIwYmlhc2VzX3RlbnNvci51bnNxdWVlemUoLTEpLnVuc3F1ZWV6ZSgtMSklMEElMjAlMjAlMjAlMjBpbWFnZV9hcnJheSUyMCUzRCUyMHJnYl90ZW5zb3IuY2xhbXAoMCUyQyUyMDI1NSklNUIwJTVELmJ5dGUoKS5jcHUoKS5udW1weSgpJTBBJTIwJTIwJTIwJTIwaW1hZ2VfYXJyYXklMjAlM0QlMjBpbWFnZV9hcnJheS50cmFuc3Bvc2UoMSUyQyUyMDIlMkMlMjAwKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMEltYWdlLmZyb21hcnJheShpbWFnZV9hcnJheSk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">latents_to_rgb</span>(<span class="hljs-params">latents</span>):
    weights = (
        (<span class="hljs-number">60</span>, -<span class="hljs-number">60</span>, <span class="hljs-number">25</span>, -<span class="hljs-number">70</span>),
        (<span class="hljs-number">60</span>,  -<span class="hljs-number">5</span>, <span class="hljs-number">15</span>, -<span class="hljs-number">50</span>),
        (<span class="hljs-number">60</span>,  <span class="hljs-number">10</span>, -<span class="hljs-number">5</span>, -<span class="hljs-number">35</span>)
    )

    weights_tensor = torch.t(torch.tensor(weights, dtype=latents.dtype).to(latents.device))
    biases_tensor = torch.tensor((<span class="hljs-number">150</span>, <span class="hljs-number">140</span>, <span class="hljs-number">130</span>), dtype=latents.dtype).to(latents.device)
    rgb_tensor = torch.einsum(<span class="hljs-string">&quot;...lxy,lr -&gt; ...rxy&quot;</span>, latents, weights_tensor) + biases_tensor.unsqueeze(-<span class="hljs-number">1</span>).unsqueeze(-<span class="hljs-number">1</span>)
    image_array = rgb_tensor.clamp(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>)[<span class="hljs-number">0</span>].byte().cpu().numpy()
    image_array = image_array.transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>)

    <span class="hljs-keyword">return</span> Image.fromarray(image_array)`,wrap:!1}}),O=new se({props:{code:"ZGVmJTIwZGVjb2RlX3RlbnNvcnMocGlwZSUyQyUyMHN0ZXAlMkMlMjB0aW1lc3RlcCUyQyUyMGNhbGxiYWNrX2t3YXJncyklM0ElMEElMjAlMjAlMjAlMjBsYXRlbnRzJTIwJTNEJTIwY2FsbGJhY2tfa3dhcmdzJTVCJTIybGF0ZW50cyUyMiU1RCUwQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwbGF0ZW50c190b19yZ2IobGF0ZW50cyklMEElMjAlMjAlMjAlMjBpbWFnZS5zYXZlKGYlMjIlN0JzdGVwJTdELnBuZyUyMiklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBjYWxsYmFja19rd2FyZ3M=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">decode_tensors</span>(<span class="hljs-params">pipe, step, timestep, callback_kwargs</span>):
    latents = callback_kwargs[<span class="hljs-string">&quot;latents&quot;</span>]

    image = latents_to_rgb(latents)
    image.save(<span class="hljs-string">f&quot;<span class="hljs-subst">{step}</span>.png&quot;</span>)

    <span class="hljs-keyword">return</span> callback_kwargs`,wrap:!1}}),ee=new se({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyQSUyMGNyb2lzc2FudCUyMHNoYXBlZCUyMGxpa2UlMjBhJTIwY3V0ZSUyMGJlYXIuJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyRGVmb3JtZWQlMkMlMjB1Z2x5JTJDJTIwYmFkJTIwYW5hdG9teSUyMiUyQyUwQSUyMCUyMCUyMCUyMGNhbGxiYWNrX29uX3N0ZXBfZW5kJTNEZGVjb2RlX3RlbnNvcnMlMkMlMEElMjAlMjAlMjAlMjBjYWxsYmFja19vbl9zdGVwX2VuZF90ZW5zb3JfaW5wdXRzJTNEJTVCJTIybGF0ZW50cyUyMiU1RCUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipeline(
    prompt=<span class="hljs-string">&quot;A croissant shaped like a cute bear.&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;Deformed, ugly, bad anatomy&quot;</span>,
    callback_on_step_end=decode_tensors,
    callback_on_step_end_tensor_inputs=[<span class="hljs-string">&quot;latents&quot;</span>],
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),te=new Jt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/callback.md"}}),{c(){a=c("meta"),h=n(),p=c("p"),b=n(),M(k.$$.fragment),ie=n(),I=c("p"),I.innerHTML=He,pe=n(),M(j.$$.fragment),ce=n(),G=c("p"),G.textContent=Qe,oe=n(),M(W.$$.fragment),re=n(),B=c("p"),B.textContent=ze,Me=n(),$=c("ul"),$.innerHTML=Le,ue=n(),M(J.$$.fragment),me=n(),v=c("p"),v.textContent=qe,fe=n(),A=c("ul"),A.innerHTML=De,de=n(),M(x.$$.fragment),ye=n(),g=c("div"),g.innerHTML=Pe,he=n(),M(Y.$$.fragment),be=n(),X=c("p"),X.textContent=Ke,we=n(),N=c("ul"),N.innerHTML=Oe,je=n(),E=c("p"),E.textContent=et,Je=n(),M(R.$$.fragment),ge=n(),S=c("p"),S.innerHTML=tt,Te=n(),M(V.$$.fragment),Ue=n(),M(F.$$.fragment),Ce=n(),M(T.$$.fragment),_e=n(),H=c("p"),H.textContent=st,Ze=n(),Q=c("p"),Q.innerHTML=lt,ke=n(),z=c("p"),z.innerHTML=at,Ie=n(),M(L.$$.fragment),Ge=n(),M(q.$$.fragment),We=n(),M(U.$$.fragment),Be=n(),D=c("p"),D.textContent=nt,$e=n(),P=c("ol"),P.innerHTML=it,ve=n(),M(K.$$.fragment),Ae=n(),C=c("ol"),C.innerHTML=pt,xe=n(),M(O.$$.fragment),Ye=n(),_=c("ol"),_.innerHTML=ct,Xe=n(),M(ee.$$.fragment),Ne=n(),Z=c("div"),Z.innerHTML=ot,Ee=n(),M(te.$$.fragment),Re=n(),ae=c("p"),this.h()},l(e){const t=wt("svelte-u9bgzb",document.head);a=o(t,"META",{name:!0,content:!0}),t.forEach(s),h=i(e),p=o(e,"P",{}),ft(p).forEach(s),b=i(e),u(k.$$.fragment,e),ie=i(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1ex9ief"&&(I.innerHTML=He),pe=i(e),u(j.$$.fragment,e),ce=i(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1ct42i6"&&(G.textContent=Qe),oe=i(e),u(W.$$.fragment,e),re=i(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1b451ym"&&(B.textContent=ze),Me=i(e),$=o(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-vd4zqd"&&($.innerHTML=Le),ue=i(e),u(J.$$.fragment,e),me=i(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1y502l4"&&(v.textContent=qe),fe=i(e),A=o(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-3im7a1"&&(A.innerHTML=De),de=i(e),u(x.$$.fragment,e),ye=i(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-17tud58"&&(g.innerHTML=Pe),he=i(e),u(Y.$$.fragment,e),be=i(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1f6wgfp"&&(X.textContent=Ke),we=i(e),N=o(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-dtd0ri"&&(N.innerHTML=Oe),je=i(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1s2b9st"&&(E.textContent=et),Je=i(e),u(R.$$.fragment,e),ge=i(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-y3yxaw"&&(S.innerHTML=tt),Te=i(e),u(V.$$.fragment,e),Ue=i(e),u(F.$$.fragment,e),Ce=i(e),u(T.$$.fragment,e),_e=i(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1nej5ag"&&(H.textContent=st),Ze=i(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-zdg2uc"&&(Q.innerHTML=lt),ke=i(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-s21qgj"&&(z.innerHTML=at),Ie=i(e),u(L.$$.fragment,e),Ge=i(e),u(q.$$.fragment,e),We=i(e),u(U.$$.fragment,e),Be=i(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1ofpl9u"&&(D.textContent=nt),$e=i(e),P=o(e,"OL",{"data-svelte-h":!0}),r(P)!=="svelte-19fyqau"&&(P.innerHTML=it),ve=i(e),u(K.$$.fragment,e),Ae=i(e),C=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(C)!=="svelte-ebwxn0"&&(C.innerHTML=pt),xe=i(e),u(O.$$.fragment,e),Ye=i(e),_=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(_)!=="svelte-1r24q0u"&&(_.innerHTML=ct),Xe=i(e),u(ee.$$.fragment,e),Ne=i(e),Z=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(Z)!=="svelte-o2x0os"&&(Z.innerHTML=ot),Ee=i(e),u(te.$$.fragment,e),Re=i(e),ae=o(e,"P",{}),ft(ae).forEach(s),this.h()},h(){le(a,"name","hf:doc:metadata"),le(a,"content",Zt),le(g,"class","flex gap-4"),le(C,"start","2"),le(_,"start","3"),le(Z,"class","flex gap-4 justify-center")},m(e,t){jt(document.head,a),l(e,h,t),l(e,p,t),l(e,b,t),m(k,e,t),l(e,ie,t),l(e,I,t),l(e,pe,t),m(j,e,t),l(e,ce,t),l(e,G,t),l(e,oe,t),m(W,e,t),l(e,re,t),l(e,B,t),l(e,Me,t),l(e,$,t),l(e,ue,t),m(J,e,t),l(e,me,t),l(e,v,t),l(e,fe,t),l(e,A,t),l(e,de,t),m(x,e,t),l(e,ye,t),l(e,g,t),l(e,he,t),m(Y,e,t),l(e,be,t),l(e,X,t),l(e,we,t),l(e,N,t),l(e,je,t),l(e,E,t),l(e,Je,t),m(R,e,t),l(e,ge,t),l(e,S,t),l(e,Te,t),m(V,e,t),l(e,Ue,t),m(F,e,t),l(e,Ce,t),m(T,e,t),l(e,_e,t),l(e,H,t),l(e,Ze,t),l(e,Q,t),l(e,ke,t),l(e,z,t),l(e,Ie,t),m(L,e,t),l(e,Ge,t),m(q,e,t),l(e,We,t),m(U,e,t),l(e,Be,t),l(e,D,t),l(e,$e,t),l(e,P,t),l(e,ve,t),m(K,e,t),l(e,Ae,t),l(e,C,t),l(e,xe,t),m(O,e,t),l(e,Ye,t),l(e,_,t),l(e,Xe,t),m(ee,e,t),l(e,Ne,t),l(e,Z,t),l(e,Ee,t),m(te,e,t),l(e,Re,t),l(e,ae,t),Se=!0},p(e,[t]){const rt={};t&2&&(rt.$$scope={dirty:t,ctx:e}),j.$set(rt);const Mt={};t&2&&(Mt.$$scope={dirty:t,ctx:e}),J.$set(Mt);const ut={};t&2&&(ut.$$scope={dirty:t,ctx:e}),T.$set(ut);const mt={};t&2&&(mt.$$scope={dirty:t,ctx:e}),U.$set(mt)},i(e){Se||(f(k.$$.fragment,e),f(j.$$.fragment,e),f(W.$$.fragment,e),f(J.$$.fragment,e),f(x.$$.fragment,e),f(Y.$$.fragment,e),f(R.$$.fragment,e),f(V.$$.fragment,e),f(F.$$.fragment,e),f(T.$$.fragment,e),f(L.$$.fragment,e),f(q.$$.fragment,e),f(U.$$.fragment,e),f(K.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),Se=!0)},o(e){d(k.$$.fragment,e),d(j.$$.fragment,e),d(W.$$.fragment,e),d(J.$$.fragment,e),d(x.$$.fragment,e),d(Y.$$.fragment,e),d(R.$$.fragment,e),d(V.$$.fragment,e),d(F.$$.fragment,e),d(T.$$.fragment,e),d(L.$$.fragment,e),d(q.$$.fragment,e),d(U.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),Se=!1},d(e){e&&(s(h),s(p),s(b),s(ie),s(I),s(pe),s(ce),s(G),s(oe),s(re),s(B),s(Me),s($),s(ue),s(me),s(v),s(fe),s(A),s(de),s(ye),s(g),s(he),s(be),s(X),s(we),s(N),s(je),s(E),s(Je),s(ge),s(S),s(Te),s(Ue),s(Ce),s(_e),s(H),s(Ze),s(Q),s(ke),s(z),s(Ie),s(Ge),s(We),s(Be),s(D),s($e),s(P),s(ve),s(Ae),s(C),s(xe),s(Ye),s(_),s(Xe),s(Ne),s(Z),s(Ee),s(Re),s(ae)),s(a),y(k,e),y(j,e),y(W,e),y(J,e),y(x,e),y(Y,e),y(R,e),y(V,e),y(F,e),y(T,e),y(L,e),y(q,e),y(U,e),y(K,e),y(O,e),y(ee,e),y(te,e)}}}const Zt='{"title":"Pipeline callbacks","local":"pipeline-callbacks","sections":[{"title":"Official callbacks","local":"official-callbacks","sections":[],"depth":2},{"title":"Dynamic classifier-free guidance","local":"dynamic-classifier-free-guidance","sections":[],"depth":2},{"title":"Interrupt the diffusion process","local":"interrupt-the-diffusion-process","sections":[],"depth":2},{"title":"Display image after each generation step","local":"display-image-after-each-generation-step","sections":[],"depth":2}],"depth":1}';function kt(w){return yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vt extends ht{constructor(a){super(),bt(this,a,kt,_t,dt,{})}}export{vt as component};
