import{s as Sl,o as Pl,n as Nl}from"../chunks/scheduler.c57aa7ef.js";import{S as Dl,i as Kl,g as i,s,r as p,A as Ol,h as o,f as a,c as n,j as El,u as d,x as r,k as Na,y as es,a as l,v as m,d as f,t as h,w as u}from"../chunks/index.c50cb18e.js";import{T as Yl}from"../chunks/Tip.9268b0ca.js";import{C as M}from"../chunks/CodeBlock.34f0a53d.js";import{H as w,E as ts}from"../chunks/EditOnGithub.958a8a49.js";function as(it){let c,b='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){c=i("p"),c.innerHTML=b},l(y){c=o(y,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1nbpolx"&&(c.innerHTML=b)},m(y,g){l(y,c,g)},p:Nl,d(y){y&&a(c)}}}function ls(it){let c,b='There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.';return{c(){c=i("p"),c.innerHTML=b},l(y){c=o(y,"P",{"data-svelte-h":!0}),r(c)!=="svelte-19y7vpj"&&(c.innerHTML=b)},m(y,g){l(y,c,g)},p:Nl,d(y){y&&a(c)}}}function ss(it){let c,b,y,g,_,rt,Z,Sa='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',pt,j,Pa="This guide explores in more detail other options and features for using LoRA.",dt,v,mt,k,Da='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',ft,U,Ka='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',ht,R,ut,C,Oa="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",ct,L,Mt,B,wt,W,el='<a href="https://arxiv.org/abs/2404.02948" rel="nofollow">PiSSA</a> initializes the LoRA adapter using the principal singular values and singular vectors. This straightforward modification allows PiSSA to converge more rapidly than LoRA and ultimately attain superior performance. Moreover, PiSSA reduces the quantization error compared to QLoRA, leading to further enhancements.',yt,I,tl="Configure the initialization method to “pissa”, which may take several minutes to execute SVD on the pre-trained model:",bt,G,gt,A,al="Alternatively, execute fast SVD, which takes only a few seconds. The number of iterations determines the trade-off between the error and computation time:",Tt,Q,Jt,V,ll='For detailed instruction on using PiSSA, please follow <a href="https://github.com/fxmeng/peft/tree/main/examples/pissa_finetuning" rel="nofollow">these instructions</a>.',$t,X,_t,x,sl='<a href="https://arxiv.org/abs/2406.01775" rel="nofollow">OLoRA</a> utilizes QR decomposition to initialize the LoRA adapters. OLoRA translates the base weights of the model by a factor of their QR decompositions, i.e., it mutates the weights before performing any training on them. This approach significantly improves stability, accelerates convergence speed, and ultimately achieves superior performance.',Zt,H,nl="You just need to pass a single additional option to use OLoRA:",jt,z,vt,q,il='For more advanced usage, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/olora_finetuning" rel="nofollow">documentation</a>.',kt,F,Ut,E,Rt,Y,ol='When quantizing the base model for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. To use LoftQ, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',Ct,N,rl="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",Lt,S,Bt,P,pl="An easier but more limited way to apply LoftQ initialization is to use the convenience function <code>replace_lora_weights_loftq</code>. This takes the quantized PEFT model as input and replaces the LoRA weights in-place with their LoftQ-initialized counterparts.",Wt,D,It,K,dl='<code>replace_lora_weights_loftq</code> also allows you to pass a <code>callback</code> argument to give you more control over which layers should be modified or not, which empirically can improve the results quite a lot. To see a more elaborate example of this, check out <a href="https://github.com/huggingface/peft/blob/main/examples/loftq_finetuning/LoftQ_weight_replacement.ipynb" rel="nofollow">this notebook</a>.',Gt,O,ml="<code>replace_lora_weights_loftq</code> implements only one iteration step of LoftQ. This means that only the LoRA weights are updated, instead of iteratevily updating LoRA weights and quantized base model weights. This may lead to lower performance but has the advantage that we can use the original quantized weights derived from the base model, instead of having to keep an extra copy of modified quantized weights. Whether this tradeoff is worthwhile depends on the use case.",At,ee,fl="At the moment, <code>replace_lora_weights_loftq</code> has these additional limitations:",Qt,te,hl="<li>Model files must be stored as a <code>safetensors</code> file.</li> <li>Only bitsandbytes 4bit quantization is supported.</li>",Vt,T,Xt,ae,xt,le,ul='Another way to initialize <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',Ht,se,zt,ne,qt,ie,cl='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. For more information on DoRA, see  <a href="https://arxiv.org/abs/2402.09353" rel="nofollow">https://arxiv.org/abs/2402.09353</a>.',Ft,oe,Et,re,Ml="If parts of the model or the DoRA adapter are offloaded to CPU you can get a significant speedup at the cost of some temporary (ephemeral) VRAM overhead by using <code>ephemeral_gpu_offload=True</code> in <code>config.runtime_config</code>.",Yt,pe,Nt,de,wl="A <code>PeftModel</code> with a DoRA adapter can also be loaded with <code>ephemeral_gpu_offload=True</code> flag using the <code>from_pretrained</code> method as well as the <code>load_adapter</code> method.",St,me,Pt,fe,Dt,he,yl='<li>DoRA only supports linear and Conv2d layers at the moment.</li> <li>DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">LoraModel.merge_and_unload()</a>.</li> <li>DoRA should work with weights quantized with bitsandbytes (“QDoRA”). However, issues have been reported when using QDoRA with DeepSpeed Zero2.</li>',Kt,ue,Ot,ce,bl='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',ea,Me,ta,we,aa,ye,gl='An approach used to improve the performance of models is to expand a model by duplicating layers in the model to build a larger model from a pretrained model of a given size. For example increasing a 7B model to a 10B model as described in the <a href="https://arxiv.org/abs/2312.15166" rel="nofollow">SOLAR</a> paper. PEFT LoRA supports this kind of expansion in a memory efficient manner that supports further fine-tuning using LoRA adapters attached to the layers post replication of the layers. The replicated layers do not take additional memory as they share the underlying weights so the only additional memory required is the memory for the adapter weights. To use this feature you would create a config with the <code>layer_replication</code> argument.',la,be,sa,ge,Tl='Assuming the original model had 5 layers <code>[0, 1, 2 ,3, 4]</code>, this would create a model with 7 layers arranged as <code>[0, 1, 2, 3, 2, 3, 4]</code>. This follows the <a href="https://github.com/arcee-ai/mergekit" rel="nofollow">mergekit</a> pass through merge convention where sequences of layers specified as start inclusive and end exclusive tuples are stacked to build the final model. Each layer in the final model gets its own distinct set of LoRA adapters.',na,Te,Jl=`<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B" rel="nofollow">Fewshot-Metamath-OrcaVicuna-Mistral-10B</a> is an example of a model trained using this method on Mistral-7B expanded to 10B. The
<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B/blob/main/adapter_config.json" rel="nofollow">adapter_config.json</a> shows a sample LoRA adapter config applying this method for fine-tuning.`,ia,Je,oa,$e,$l="LoRA training can optionally include special purpose optimizers. Currently the only such optimizer is LoRA+.",ra,_e,pa,Ze,_l='LoRA training can be optimized using <a href="https://arxiv.org/abs/2402.12354" rel="nofollow">LoRA+</a>, which uses different learning rates for the adapter matrices A and B, shown to increase finetuning speed by up to 2x and performance by 1-2%.',da,je,ma,ve,fa,ke,Zl='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',ha,Ue,jl="Below is a diagram that explains the intuition of LoRA adapter merging:",ua,J,vl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_diagram.png"/>',ca,Re,kl="We show in the snippets below how to run that using PEFT.",Ma,Ce,wa,Le,Ul='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',ya,Be,ba,We,Rl='The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',ga,Ie,Cl="First load the base model:",Ta,Ge,Ja,Ae,Ll="Then we load the first adapter:",$a,Qe,_a,Ve,Bl="Then load a different adapter and merge it with the first one:",Za,Xe,ja,$,va,xe,Wl="Now, perform inference:",ka,He,Ua,ze,Ra,qe,Il='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',Ca,Fe,La,Ee,Gl='To return the base model, you could use <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',Ba,Ye,Wa,Ne,Ia,Se,Al="Normally, each inference batch has to use the same adapter(s) in PEFT. This can sometimes be annoying, because we may have batches that contain samples intended to be used with different LoRA adapters. For example, we could have a base model that works well in English and two more LoRA adapters, one for French and one for German. Usually, we would have to split our batches such that each batch only contains samples of one of the languages, we cannot combine different languages in the same batch.",Ga,Pe,Ql="Thankfully, it is possible to mix different LoRA adapters in the same batch using the <code>adapter_name</code> argument. Below, we show an example of how this works in practice. First, let’s load the base model, English, and the two adapters, French and German, like this:",Aa,De,Qa,Ke,Vl="Now, we want to generate text on a sample that contains all three languages: The first three samples are in English, the next three are in French, and the last three are in German. We can use the <code>adapter_names</code> argument to specify which adapter to use for each sample. Since our base model is used for English, we use the special string <code>&quot;__base__&quot;</code> for these samples. For the next three samples, we indicate the adapter name of the French LoRA fine-tune, in this case <code>&quot;adapter_fr&quot;</code>. For the last three samples, we indicate the adapter name of the German LoRA fine-tune, in this case <code>&quot;adapter_de&quot;</code>. This way, we can use the base model and the two adapters in a single batch.",Va,Oe,Xa,et,Xl="Note that the order does not matter here, i.e. the samples in the batch don’t need to be grouped by adapter as in the example above. We just need to ensure that the <code>adapter_names</code> argument is aligned correctly with the samples.",xa,tt,xl="Additionally, the same approach also works with the <code>modules_to_save</code> feature, which allows for saving and reusing specific neural network layers, such as custom heads for classification tasks, across different LoRA adapters.",Ha,at,za,lt,Hl="Using this features has some drawbacks, namely:",qa,st,zl='<li>It only works for inference, not for training.</li> <li>Disabling adapters using the <code>with model.disable_adapter()</code> context takes precedence over <code>adapter_names</code>.</li> <li>You cannot pass <code>adapter_names</code> when some adapter weights where merged with base weight using the <code>merge_adapter</code> method. Please unmerge all adapters first by calling <code>model.unmerge_adapter()</code>.</li> <li>For obvious reasons, this cannot be used after calling <code>merge_and_unload()</code>, since all the LoRA adapters will be merged into the base weights in this case.</li> <li>This feature does not currently work with DoRA, so set <code>use_dora=False</code> in your <code>LoraConfig</code> if you want to use it.</li> <li>The <code>modules_to_save</code> feature is currently only supported for the layers of types <code>Linear</code>, <code>Embedding</code>, <code>Conv2d</code> and <code>Conv1d</code>.</li> <li>There is an expected overhead for inference with <code>adapter_names</code>, especially if the amount of different adapters in the batch is high. This is because the batch size is effectively reduced to the number of samples per adapter. If runtime performance is your top priority, try the following:<ul><li>Increase the batch size.</li> <li>Try to avoid having a large number of different adapters in the same batch, prefer homogeneous batches. This can be achieved by buffering samples with the same adapter and only perform inference with a small handfull of different adapters.</li> <li>Take a look at alternative implementations such as <a href="https://github.com/predibase/lorax" rel="nofollow">LoRAX</a>, <a href="https://github.com/punica-ai/punica" rel="nofollow">punica</a>, or <a href="https://github.com/S-LoRA/S-LoRA" rel="nofollow">S-LoRA</a>, which are specialized to work with a large number of different adapters.</li></ul></li>',Fa,nt,Ea,ot,Ya;return _=new w({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),v=new w({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),R=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),L=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),B=new w({props:{title:"PiSSA",local:"pissa",headingTag:"h3"}}),G=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMnBpc3NhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa&quot;</span>, ...)`,wrap:!1}}),Q=new M({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKGluaXRfbG9yYV93ZWlnaHRzJTNEJTIycGlzc2Ffbml0ZXJfJTVCbnVtYmVyJTIwb2YlMjBpdGVycyU1RCUyMiUyQyUyMC4uLiklMjA=",highlighted:'lora_config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa_niter_[number of iters]&quot;</span>, ...) ',wrap:!1}}),X=new w({props:{title:"OLoRA",local:"olora",headingTag:"h3"}}),z=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMm9sb3JhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;olora&quot;</span>, ...)`,wrap:!1}}),F=new w({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),E=new w({props:{title:"Standard approach",local:"standard-approach",headingTag:"h4"}}),S=new w({props:{title:"A more convenient way",local:"a-more-convenient-way",headingTag:"h4"}}),D=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjByZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjAuLi4pJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCguLi4lMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEElMjMlMjBub3RlJTNBJTIwZG9uJ3QlMjBwYXNzJTIwaW5pdF9sb3JhX3dlaWdodHMlM0QlMjJsb2Z0cSUyMiUyMG9yJTIwbG9mdHFfY29uZmlnISUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIpJTBBcGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBsb3JhX2NvbmZpZyklMEFyZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cShwZWZ0X21vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> replace_lora_weights_loftq
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, ...)
base_model = AutoModelForCausalLM.from_pretrained(..., quantization_config=bnb_config)
<span class="hljs-comment"># note: don&#x27;t pass init_lora_weights=&quot;loftq&quot; or loftq_config!</span>
lora_config = LoraConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>)
peft_model = get_peft_model(base_model, lora_config)
replace_lora_weights_loftq(peft_model)`,wrap:!1}}),T=new Yl({props:{$$slots:{default:[as]},$$scope:{ctx:it}}}),ae=new w({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),se=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),ne=new w({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),oe=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),pe=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwTG9yYVJ1bnRpbWVDb25maWclMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKHVzZV9kb3JhJTNEVHJ1ZSUyQyUyMHJ1bnRpbWVfY29uZmlnJTNETG9yYVJ1bnRpbWVDb25maWcoZXBoZW1lcmFsX2dwdV9vZmZsb2FkJTNEVHJ1ZSklMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, LoraRuntimeConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, runtime_config=LoraRuntimeConfig(ephemeral_gpu_offload=<span class="hljs-literal">True</span>), ...)`,wrap:!1}}),me=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoYmFzZV9tb2RlbCUyQyUyMHBlZnRfbW9kZWxfaWQlMkMlMjBlcGhlbWVyYWxfZ3B1X29mZmxvYWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model = PeftModel.from_pretrained(base_model, peft_model_id, ephemeral_gpu_offload=<span class="hljs-literal">True</span>)`,wrap:!1}}),fe=new w({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),ue=new w({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),Me=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),we=new w({props:{title:"Memory efficient Layer Replication with LoRA",local:"memory-efficient-layer-replication-with-lora",headingTag:"h3"}}),be=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhsYXllcl9yZXBsaWNhdGlvbiUzRCU1QiU1QjAlMkM0JTVEJTJDJTIwJTVCMiUyQzUlNUQlNUQlMkMlMjAuLi4p",highlighted:'config = LoraConfig(layer_replication=[[<span class="hljs-number">0</span>,<span class="hljs-number">4</span>], [<span class="hljs-number">2</span>,<span class="hljs-number">5</span>]], ...)',wrap:!1}}),Je=new w({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),_e=new w({props:{title:"LoRA+ optimized LoRA",local:"lora-optimized-lora",headingTag:"h3"}}),je=new M({props:{code:"JTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> peft.optimizers <span class="hljs-keyword">import</span> create_loraplus_optimizer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer
<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

base_model = ...
config = LoraConfig(...)
model = get_peft_model(base_model, config)

optimizer = create_loraplus_optimizer(
    model=model,
    optimizer_cls=bnb.optim.Adam8bit,
    lr=<span class="hljs-number">5e-5</span>,
    loraplus_lr_ratio=<span class="hljs-number">16</span>,
)
scheduler = <span class="hljs-literal">None</span>

...
trainer = Trainer(
    ...,
    optimizers=(optimizer, scheduler),
)`,wrap:!1}}),ve=new w({props:{title:"Merge LoRA weights into the base model",local:"merge-lora-weights-into-the-base-model",headingTag:"h2"}}),Ce=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),Be=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),Ge=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),Qe=new M({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),Xe=new M({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),$=new Yl({props:{$$slots:{default:[ls]},$$scope:{ctx:it}}}),He=new M({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oJTIyY3VkYSUyMiklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),ze=new w({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),Fe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),Ye=new M({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),Ne=new w({props:{title:"Inference with different LoRA adapters in the same batch",local:"inference-with-different-lora-adapters-in-the-same-batch",headingTag:"h2"}}),De=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBGcmVuY2glMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMCUzQ3BhdGglM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyX2ZyJTIyKSUwQSUyMyUyMG5leHQlMkMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBHZXJtYW4lMEFwZWZ0X21vZGVsLmxvYWRfYWRhcHRlciglM0NwYXRoJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl9kZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-comment"># load the LoRA adapter for French</span>
peft_model = PeftModel.from_pretrained(model, &lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_fr&quot;</span>)
<span class="hljs-comment"># next, load the LoRA adapter for German</span>
peft_model.load_adapter(&lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_de&quot;</span>)`,wrap:!1}}),Oe=new M({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBhd2Vzb21lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMkMlMjBteSUyMGZpc2glMjBpcyUyMGdyZWF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBjaGllbiUyMGVzdCUyMG1pZ25vbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlNhbHV0JTJDJTIwbW9uJTIwY2hhdCUyMGVzdCUyMGclQzMlQTluaWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBwb2lzc29uJTIwZXN0JTIwc3VwZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBIdW5kJTIwaXN0JTIwcyVDMyVCQyVDMyU5RiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhhbGxvJTJDJTIwbWVpbmUlMjBLYXR6ZSUyMGlzdCUyMHRvbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBGaXNjaCUyMGlzdCUyMGdybyVDMyU5RmFydGlnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQWFkYXB0ZXJfbmFtZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJfX2Jhc2VfXyUyMiUyQyUyMCUyMl9fYmFzZV9fJTIyJTJDJTIwJTIyX19iYXNlX18lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2ZyJTIyJTJDJTIwJTIyYWRhcHRlcl9mciUyMiUyQyUyMCUyMmFkYXB0ZXJfZnIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2RlJTIyJTJDJTIwJTIyYWRhcHRlcl9kZSUyMiUyQyUyMCUyMmFkYXB0ZXJfZGUlMjIlMkMlMEElNUQlMEFvdXRwdXQlMjAlM0QlMjBwZWZ0X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYWRhcHRlcl9uYW1lcyUzRGFkYXB0ZXJfbmFtZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`inputs = tokenizer(
    [
        <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>,
        <span class="hljs-string">&quot;Hello, my cat is awesome&quot;</span>,
        <span class="hljs-string">&quot;Hello, my fish is great&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chien est mignon&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chat est génial&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon poisson est super&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Hund ist süß&quot;</span>,
        <span class="hljs-string">&quot;Hallo, meine Katze ist toll&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Fisch ist großartig&quot;</span>,
    ],
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

adapter_names = [
    <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>,
    <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>,
    <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>,
]
output = peft_model.generate(**inputs, adapter_names=adapter_names, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),at=new w({props:{title:"Caveats",local:"caveats",headingTag:"h3"}}),nt=new ts({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/lora.md"}}),{c(){c=i("meta"),b=s(),y=i("p"),g=s(),p(_.$$.fragment),rt=s(),Z=i("p"),Z.innerHTML=Sa,pt=s(),j=i("p"),j.textContent=Pa,dt=s(),p(v.$$.fragment),mt=s(),k=i("p"),k.innerHTML=Da,ft=s(),U=i("p"),U.innerHTML=Ka,ht=s(),p(R.$$.fragment),ut=s(),C=i("p"),C.innerHTML=Oa,ct=s(),p(L.$$.fragment),Mt=s(),p(B.$$.fragment),wt=s(),W=i("p"),W.innerHTML=el,yt=s(),I=i("p"),I.textContent=tl,bt=s(),p(G.$$.fragment),gt=s(),A=i("p"),A.textContent=al,Tt=s(),p(Q.$$.fragment),Jt=s(),V=i("p"),V.innerHTML=ll,$t=s(),p(X.$$.fragment),_t=s(),x=i("p"),x.innerHTML=sl,Zt=s(),H=i("p"),H.textContent=nl,jt=s(),p(z.$$.fragment),vt=s(),q=i("p"),q.innerHTML=il,kt=s(),p(F.$$.fragment),Ut=s(),p(E.$$.fragment),Rt=s(),Y=i("p"),Y.innerHTML=ol,Ct=s(),N=i("p"),N.innerHTML=rl,Lt=s(),p(S.$$.fragment),Bt=s(),P=i("p"),P.innerHTML=pl,Wt=s(),p(D.$$.fragment),It=s(),K=i("p"),K.innerHTML=dl,Gt=s(),O=i("p"),O.innerHTML=ml,At=s(),ee=i("p"),ee.innerHTML=fl,Qt=s(),te=i("ul"),te.innerHTML=hl,Vt=s(),p(T.$$.fragment),Xt=s(),p(ae.$$.fragment),xt=s(),le=i("p"),le.innerHTML=ul,Ht=s(),p(se.$$.fragment),zt=s(),p(ne.$$.fragment),qt=s(),ie=i("p"),ie.innerHTML=cl,Ft=s(),p(oe.$$.fragment),Et=s(),re=i("p"),re.innerHTML=Ml,Yt=s(),p(pe.$$.fragment),Nt=s(),de=i("p"),de.innerHTML=wl,St=s(),p(me.$$.fragment),Pt=s(),p(fe.$$.fragment),Dt=s(),he=i("ul"),he.innerHTML=yl,Kt=s(),p(ue.$$.fragment),Ot=s(),ce=i("p"),ce.innerHTML=bl,ea=s(),p(Me.$$.fragment),ta=s(),p(we.$$.fragment),aa=s(),ye=i("p"),ye.innerHTML=gl,la=s(),p(be.$$.fragment),sa=s(),ge=i("p"),ge.innerHTML=Tl,na=s(),Te=i("p"),Te.innerHTML=Jl,ia=s(),p(Je.$$.fragment),oa=s(),$e=i("p"),$e.textContent=$l,ra=s(),p(_e.$$.fragment),pa=s(),Ze=i("p"),Ze.innerHTML=_l,da=s(),p(je.$$.fragment),ma=s(),p(ve.$$.fragment),fa=s(),ke=i("p"),ke.innerHTML=Zl,ha=s(),Ue=i("p"),Ue.textContent=jl,ua=s(),J=i("div"),J.innerHTML=vl,ca=s(),Re=i("p"),Re.textContent=kl,Ma=s(),p(Ce.$$.fragment),wa=s(),Le=i("p"),Le.innerHTML=Ul,ya=s(),p(Be.$$.fragment),ba=s(),We=i("p"),We.innerHTML=Rl,ga=s(),Ie=i("p"),Ie.textContent=Cl,Ta=s(),p(Ge.$$.fragment),Ja=s(),Ae=i("p"),Ae.textContent=Ll,$a=s(),p(Qe.$$.fragment),_a=s(),Ve=i("p"),Ve.textContent=Bl,Za=s(),p(Xe.$$.fragment),ja=s(),p($.$$.fragment),va=s(),xe=i("p"),xe.textContent=Wl,ka=s(),p(He.$$.fragment),Ua=s(),p(ze.$$.fragment),Ra=s(),qe=i("p"),qe.innerHTML=Il,Ca=s(),p(Fe.$$.fragment),La=s(),Ee=i("p"),Ee.innerHTML=Gl,Ba=s(),p(Ye.$$.fragment),Wa=s(),p(Ne.$$.fragment),Ia=s(),Se=i("p"),Se.textContent=Al,Ga=s(),Pe=i("p"),Pe.innerHTML=Ql,Aa=s(),p(De.$$.fragment),Qa=s(),Ke=i("p"),Ke.innerHTML=Vl,Va=s(),p(Oe.$$.fragment),Xa=s(),et=i("p"),et.innerHTML=Xl,xa=s(),tt=i("p"),tt.innerHTML=xl,Ha=s(),p(at.$$.fragment),za=s(),lt=i("p"),lt.textContent=Hl,qa=s(),st=i("ul"),st.innerHTML=zl,Fa=s(),p(nt.$$.fragment),Ea=s(),ot=i("p"),this.h()},l(e){const t=Ol("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(a),b=n(e),y=o(e,"P",{}),El(y).forEach(a),g=n(e),d(_.$$.fragment,e),rt=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-38uxl6"&&(Z.innerHTML=Sa),pt=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-ovsn32"&&(j.textContent=Pa),dt=n(e),d(v.$$.fragment,e),mt=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-j883mf"&&(k.innerHTML=Da),ft=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1fujb7a"&&(U.innerHTML=Ka),ht=n(e),d(R.$$.fragment,e),ut=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-mwvui1"&&(C.innerHTML=Oa),ct=n(e),d(L.$$.fragment,e),Mt=n(e),d(B.$$.fragment,e),wt=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1skluc"&&(W.innerHTML=el),yt=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1hy0lgx"&&(I.textContent=tl),bt=n(e),d(G.$$.fragment,e),gt=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-auzrbb"&&(A.textContent=al),Tt=n(e),d(Q.$$.fragment,e),Jt=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-u5znzv"&&(V.innerHTML=ll),$t=n(e),d(X.$$.fragment,e),_t=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-17kc0j8"&&(x.innerHTML=sl),Zt=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1j9g8qn"&&(H.textContent=nl),jt=n(e),d(z.$$.fragment,e),vt=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-sulxp4"&&(q.innerHTML=il),kt=n(e),d(F.$$.fragment,e),Ut=n(e),d(E.$$.fragment,e),Rt=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1ts8vpq"&&(Y.innerHTML=ol),Ct=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-7f0aai"&&(N.innerHTML=rl),Lt=n(e),d(S.$$.fragment,e),Bt=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-14vtcq9"&&(P.innerHTML=pl),Wt=n(e),d(D.$$.fragment,e),It=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1nywyxh"&&(K.innerHTML=dl),Gt=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1d2jix1"&&(O.innerHTML=ml),At=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-yl8kok"&&(ee.innerHTML=fl),Qt=n(e),te=o(e,"UL",{"data-svelte-h":!0}),r(te)!=="svelte-12tl4fy"&&(te.innerHTML=hl),Vt=n(e),d(T.$$.fragment,e),Xt=n(e),d(ae.$$.fragment,e),xt=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-omuw13"&&(le.innerHTML=ul),Ht=n(e),d(se.$$.fragment,e),zt=n(e),d(ne.$$.fragment,e),qt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1ukfkwt"&&(ie.innerHTML=cl),Ft=n(e),d(oe.$$.fragment,e),Et=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-8wzhde"&&(re.innerHTML=Ml),Yt=n(e),d(pe.$$.fragment,e),Nt=n(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-16lyt50"&&(de.innerHTML=wl),St=n(e),d(me.$$.fragment,e),Pt=n(e),d(fe.$$.fragment,e),Dt=n(e),he=o(e,"UL",{"data-svelte-h":!0}),r(he)!=="svelte-azzgzc"&&(he.innerHTML=yl),Kt=n(e),d(ue.$$.fragment,e),Ot=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-15vxux2"&&(ce.innerHTML=bl),ea=n(e),d(Me.$$.fragment,e),ta=n(e),d(we.$$.fragment,e),aa=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1mosto0"&&(ye.innerHTML=gl),la=n(e),d(be.$$.fragment,e),sa=n(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1ttqqw0"&&(ge.innerHTML=Tl),na=n(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-foj0wd"&&(Te.innerHTML=Jl),ia=n(e),d(Je.$$.fragment,e),oa=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-rkzqzi"&&($e.textContent=$l),ra=n(e),d(_e.$$.fragment,e),pa=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-9dmo2s"&&(Ze.innerHTML=_l),da=n(e),d(je.$$.fragment,e),ma=n(e),d(ve.$$.fragment,e),fa=n(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1c3h9aa"&&(ke.innerHTML=Zl),ha=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1wwmf5r"&&(Ue.textContent=jl),ua=n(e),J=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1f6iuw5"&&(J.innerHTML=vl),ca=n(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-hlzwis"&&(Re.textContent=kl),Ma=n(e),d(Ce.$$.fragment,e),wa=n(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-m3cr6r"&&(Le.innerHTML=Ul),ya=n(e),d(Be.$$.fragment,e),ba=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-kbqhpl"&&(We.innerHTML=Rl),ga=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1mwdwt1"&&(Ie.textContent=Cl),Ta=n(e),d(Ge.$$.fragment,e),Ja=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-nuhu05"&&(Ae.textContent=Ll),$a=n(e),d(Qe.$$.fragment,e),_a=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1n53hd9"&&(Ve.textContent=Bl),Za=n(e),d(Xe.$$.fragment,e),ja=n(e),d($.$$.fragment,e),va=n(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-qwbdkg"&&(xe.textContent=Wl),ka=n(e),d(He.$$.fragment,e),Ua=n(e),d(ze.$$.fragment,e),Ra=n(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-ke62q2"&&(qe.innerHTML=Il),Ca=n(e),d(Fe.$$.fragment,e),La=n(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-cvmoj6"&&(Ee.innerHTML=Gl),Ba=n(e),d(Ye.$$.fragment,e),Wa=n(e),d(Ne.$$.fragment,e),Ia=n(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1fq5tpu"&&(Se.textContent=Al),Ga=n(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-lcywla"&&(Pe.innerHTML=Ql),Aa=n(e),d(De.$$.fragment,e),Qa=n(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-6wkyom"&&(Ke.innerHTML=Vl),Va=n(e),d(Oe.$$.fragment,e),Xa=n(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1o40ch6"&&(et.innerHTML=Xl),xa=n(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-13py9hk"&&(tt.innerHTML=xl),Ha=n(e),d(at.$$.fragment,e),za=n(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-fpz5mj"&&(lt.textContent=Hl),qa=n(e),st=o(e,"UL",{"data-svelte-h":!0}),r(st)!=="svelte-150o10n"&&(st.innerHTML=zl),Fa=n(e),d(nt.$$.fragment,e),Ea=n(e),ot=o(e,"P",{}),El(ot).forEach(a),this.h()},h(){Na(c,"name","hf:doc:metadata"),Na(c,"content",ns),Na(J,"class","flex justify-center")},m(e,t){es(document.head,c),l(e,b,t),l(e,y,t),l(e,g,t),m(_,e,t),l(e,rt,t),l(e,Z,t),l(e,pt,t),l(e,j,t),l(e,dt,t),m(v,e,t),l(e,mt,t),l(e,k,t),l(e,ft,t),l(e,U,t),l(e,ht,t),m(R,e,t),l(e,ut,t),l(e,C,t),l(e,ct,t),m(L,e,t),l(e,Mt,t),m(B,e,t),l(e,wt,t),l(e,W,t),l(e,yt,t),l(e,I,t),l(e,bt,t),m(G,e,t),l(e,gt,t),l(e,A,t),l(e,Tt,t),m(Q,e,t),l(e,Jt,t),l(e,V,t),l(e,$t,t),m(X,e,t),l(e,_t,t),l(e,x,t),l(e,Zt,t),l(e,H,t),l(e,jt,t),m(z,e,t),l(e,vt,t),l(e,q,t),l(e,kt,t),m(F,e,t),l(e,Ut,t),m(E,e,t),l(e,Rt,t),l(e,Y,t),l(e,Ct,t),l(e,N,t),l(e,Lt,t),m(S,e,t),l(e,Bt,t),l(e,P,t),l(e,Wt,t),m(D,e,t),l(e,It,t),l(e,K,t),l(e,Gt,t),l(e,O,t),l(e,At,t),l(e,ee,t),l(e,Qt,t),l(e,te,t),l(e,Vt,t),m(T,e,t),l(e,Xt,t),m(ae,e,t),l(e,xt,t),l(e,le,t),l(e,Ht,t),m(se,e,t),l(e,zt,t),m(ne,e,t),l(e,qt,t),l(e,ie,t),l(e,Ft,t),m(oe,e,t),l(e,Et,t),l(e,re,t),l(e,Yt,t),m(pe,e,t),l(e,Nt,t),l(e,de,t),l(e,St,t),m(me,e,t),l(e,Pt,t),m(fe,e,t),l(e,Dt,t),l(e,he,t),l(e,Kt,t),m(ue,e,t),l(e,Ot,t),l(e,ce,t),l(e,ea,t),m(Me,e,t),l(e,ta,t),m(we,e,t),l(e,aa,t),l(e,ye,t),l(e,la,t),m(be,e,t),l(e,sa,t),l(e,ge,t),l(e,na,t),l(e,Te,t),l(e,ia,t),m(Je,e,t),l(e,oa,t),l(e,$e,t),l(e,ra,t),m(_e,e,t),l(e,pa,t),l(e,Ze,t),l(e,da,t),m(je,e,t),l(e,ma,t),m(ve,e,t),l(e,fa,t),l(e,ke,t),l(e,ha,t),l(e,Ue,t),l(e,ua,t),l(e,J,t),l(e,ca,t),l(e,Re,t),l(e,Ma,t),m(Ce,e,t),l(e,wa,t),l(e,Le,t),l(e,ya,t),m(Be,e,t),l(e,ba,t),l(e,We,t),l(e,ga,t),l(e,Ie,t),l(e,Ta,t),m(Ge,e,t),l(e,Ja,t),l(e,Ae,t),l(e,$a,t),m(Qe,e,t),l(e,_a,t),l(e,Ve,t),l(e,Za,t),m(Xe,e,t),l(e,ja,t),m($,e,t),l(e,va,t),l(e,xe,t),l(e,ka,t),m(He,e,t),l(e,Ua,t),m(ze,e,t),l(e,Ra,t),l(e,qe,t),l(e,Ca,t),m(Fe,e,t),l(e,La,t),l(e,Ee,t),l(e,Ba,t),m(Ye,e,t),l(e,Wa,t),m(Ne,e,t),l(e,Ia,t),l(e,Se,t),l(e,Ga,t),l(e,Pe,t),l(e,Aa,t),m(De,e,t),l(e,Qa,t),l(e,Ke,t),l(e,Va,t),m(Oe,e,t),l(e,Xa,t),l(e,et,t),l(e,xa,t),l(e,tt,t),l(e,Ha,t),m(at,e,t),l(e,za,t),l(e,lt,t),l(e,qa,t),l(e,st,t),l(e,Fa,t),m(nt,e,t),l(e,Ea,t),l(e,ot,t),Ya=!0},p(e,[t]){const ql={};t&2&&(ql.$$scope={dirty:t,ctx:e}),T.$set(ql);const Fl={};t&2&&(Fl.$$scope={dirty:t,ctx:e}),$.$set(Fl)},i(e){Ya||(f(_.$$.fragment,e),f(v.$$.fragment,e),f(R.$$.fragment,e),f(L.$$.fragment,e),f(B.$$.fragment,e),f(G.$$.fragment,e),f(Q.$$.fragment,e),f(X.$$.fragment,e),f(z.$$.fragment,e),f(F.$$.fragment,e),f(E.$$.fragment,e),f(S.$$.fragment,e),f(D.$$.fragment,e),f(T.$$.fragment,e),f(ae.$$.fragment,e),f(se.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(fe.$$.fragment,e),f(ue.$$.fragment,e),f(Me.$$.fragment,e),f(we.$$.fragment,e),f(be.$$.fragment,e),f(Je.$$.fragment,e),f(_e.$$.fragment,e),f(je.$$.fragment,e),f(ve.$$.fragment,e),f(Ce.$$.fragment,e),f(Be.$$.fragment,e),f(Ge.$$.fragment,e),f(Qe.$$.fragment,e),f(Xe.$$.fragment,e),f($.$$.fragment,e),f(He.$$.fragment,e),f(ze.$$.fragment,e),f(Fe.$$.fragment,e),f(Ye.$$.fragment,e),f(Ne.$$.fragment,e),f(De.$$.fragment,e),f(Oe.$$.fragment,e),f(at.$$.fragment,e),f(nt.$$.fragment,e),Ya=!0)},o(e){h(_.$$.fragment,e),h(v.$$.fragment,e),h(R.$$.fragment,e),h(L.$$.fragment,e),h(B.$$.fragment,e),h(G.$$.fragment,e),h(Q.$$.fragment,e),h(X.$$.fragment,e),h(z.$$.fragment,e),h(F.$$.fragment,e),h(E.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(T.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(Me.$$.fragment,e),h(we.$$.fragment,e),h(be.$$.fragment,e),h(Je.$$.fragment,e),h(_e.$$.fragment,e),h(je.$$.fragment,e),h(ve.$$.fragment,e),h(Ce.$$.fragment,e),h(Be.$$.fragment,e),h(Ge.$$.fragment,e),h(Qe.$$.fragment,e),h(Xe.$$.fragment,e),h($.$$.fragment,e),h(He.$$.fragment,e),h(ze.$$.fragment,e),h(Fe.$$.fragment,e),h(Ye.$$.fragment,e),h(Ne.$$.fragment,e),h(De.$$.fragment,e),h(Oe.$$.fragment,e),h(at.$$.fragment,e),h(nt.$$.fragment,e),Ya=!1},d(e){e&&(a(b),a(y),a(g),a(rt),a(Z),a(pt),a(j),a(dt),a(mt),a(k),a(ft),a(U),a(ht),a(ut),a(C),a(ct),a(Mt),a(wt),a(W),a(yt),a(I),a(bt),a(gt),a(A),a(Tt),a(Jt),a(V),a($t),a(_t),a(x),a(Zt),a(H),a(jt),a(vt),a(q),a(kt),a(Ut),a(Rt),a(Y),a(Ct),a(N),a(Lt),a(Bt),a(P),a(Wt),a(It),a(K),a(Gt),a(O),a(At),a(ee),a(Qt),a(te),a(Vt),a(Xt),a(xt),a(le),a(Ht),a(zt),a(qt),a(ie),a(Ft),a(Et),a(re),a(Yt),a(Nt),a(de),a(St),a(Pt),a(Dt),a(he),a(Kt),a(Ot),a(ce),a(ea),a(ta),a(aa),a(ye),a(la),a(sa),a(ge),a(na),a(Te),a(ia),a(oa),a($e),a(ra),a(pa),a(Ze),a(da),a(ma),a(fa),a(ke),a(ha),a(Ue),a(ua),a(J),a(ca),a(Re),a(Ma),a(wa),a(Le),a(ya),a(ba),a(We),a(ga),a(Ie),a(Ta),a(Ja),a(Ae),a($a),a(_a),a(Ve),a(Za),a(ja),a(va),a(xe),a(ka),a(Ua),a(Ra),a(qe),a(Ca),a(La),a(Ee),a(Ba),a(Wa),a(Ia),a(Se),a(Ga),a(Pe),a(Aa),a(Qa),a(Ke),a(Va),a(Xa),a(et),a(xa),a(tt),a(Ha),a(za),a(lt),a(qa),a(st),a(Fa),a(Ea),a(ot)),a(c),u(_,e),u(v,e),u(R,e),u(L,e),u(B,e),u(G,e),u(Q,e),u(X,e),u(z,e),u(F,e),u(E,e),u(S,e),u(D,e),u(T,e),u(ae,e),u(se,e),u(ne,e),u(oe,e),u(pe,e),u(me,e),u(fe,e),u(ue,e),u(Me,e),u(we,e),u(be,e),u(Je,e),u(_e,e),u(je,e),u(ve,e),u(Ce,e),u(Be,e),u(Ge,e),u(Qe,e),u(Xe,e),u($,e),u(He,e),u(ze,e),u(Fe,e),u(Ye,e),u(Ne,e),u(De,e),u(Oe,e),u(at,e),u(nt,e)}}}const ns='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"PiSSA","local":"pissa","sections":[],"depth":3},{"title":"OLoRA","local":"olora","sections":[],"depth":3},{"title":"LoftQ","local":"loftq","sections":[{"title":"Standard approach","local":"standard-approach","sections":[],"depth":4},{"title":"A more convenient way","local":"a-more-convenient-way","sections":[],"depth":4}],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3},{"title":"Memory efficient Layer Replication with LoRA","local":"memory-efficient-layer-replication-with-lora","sections":[],"depth":3}],"depth":2},{"title":"Optimizers","local":"optimizers","sections":[{"title":"LoRA+ optimized LoRA","local":"lora-optimized-lora","sections":[],"depth":3}],"depth":2},{"title":"Merge LoRA weights into the base model","local":"merge-lora-weights-into-the-base-model","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2},{"title":"Inference with different LoRA adapters in the same batch","local":"inference-with-different-lora-adapters-in-the-same-batch","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":3}],"depth":2}],"depth":1}';function is(it){return Pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fs extends Dl{constructor(c){super(),Kl(this,c,is,ss,Sl,{})}}export{fs as component};
