import{s as kl,n as vl,o as Sl}from"../chunks/scheduler.f7e1785c.js";import{S as Bl,i as Cl,g as i,s as l,r as p,m as J,H as na,A as xl,h as o,f as s,c as n,j as ca,u as h,x as r,n as b,E as ia,k as pt,y as T,a,v as c,d,t as m,w as M}from"../chunks/index.9f8f0838.js";import{C as u}from"../chunks/CodeBlock.b3510e34.js";import{H as ht}from"../chunks/Heading.6643a2f7.js";function El(da){let U,ct,ot,dt,j,mt,I,ma=`In this section, we’ll cover how to use the <code>pipeline()</code> to leverage pre-trained models for speech recognition. In <a href="../chapter2/asr_pipeline">Unit 2</a>,
we introduced the <code>pipeline()</code> as an easy way of running speech recognition tasks, with all pre- and post-processing handled under-the-hood
and the flexibility to quickly experiment with any pre-trained checkpoint on the Hugging Face Hub. In this Unit, we’ll go a
level deeper and explore the different attributes of speech recognition models and how we can use them to tackle a range
of different tasks.`,Mt,k,Ma="As detailed in Unit 3, speech recognition model broadly fall into one of two categories:",ut,v,ua="<li>Connectionist Temporal Classification (CTC): <em>encoder-only</em> models with a linear classification (CTC) head on top</li> <li>Sequence-to-sequence (Seq2Seq): <em>encoder-decoder</em> models, with a cross-attention mechanism between the encoder and decoder</li>",yt,S,ya=`Prior to 2022, CTC was the more popular of the two architectures, with encoder-only models such as Wav2Vec2, HuBERT and XLSR achieving
breakthoughs in the pre-training / fine-tuning paradigm for speech. Big corporations, such as Meta and Microsoft, pre-trained
the encoder on vast amounts of unlabelled audio data for many days or weeks. Users could then take a pre-trained checkpoint, and
fine-tune it with a CTC head on as little as <strong>10 minutes</strong> of labelled speech data to achieve strong performance on a downstream
speech recognition task.`,wt,B,wa=`However, CTC models have their shortcomings. Appending a simple linear layer to an encoder gives a small, fast overall model, but can
be prone to phonetic spelling errors. We’ll demonstrate this for the Wav2Vec2 model below.`,Tt,C,Ut,x,Ta=`Let’s load a small excerpt of the <a href="hf-internal-testing/librispeech_asr_dummy">LibriSpeech ASR</a> dataset to demonstrate
Wav2Vec2’s speech transcription capabilities:`,ft,E,gt,G,Ua="<strong>Output:</strong>",Jt,R,bt,V,fa="We can pick one of the 73 audio samples and inspect the audio sample as well as the transcription:",jt,$,It,H,ga="<strong>Output:</strong>",kt,W,vt,F,Ja=`Alright! Christmas and roast beef, sounds great! 🎄 Having chosen a data sample, we now load a fine-tuned checkpoint into
the <code>pipeline()</code>. For this, we’ll use the official <a href="facebook/wav2vec2-base-100h">Wav2Vec2 base</a> checkpoint fine-tuned on
100 hours of LibriSpeech data:`,St,Z,Bt,N,ba=`Next, we’ll take an example from the dataset and pass its raw data to the pipeline. Since the <code>pipeline</code> <em>consumes</em> any
dictionary that we pass it (meaning it cannot be re-used), we’ll pass a copy of the data. This way, we can safely re-use
the same audio sample in the following examples:`,Ct,_,xt,Y,ja="<strong>Output:</strong>",Et,L,Gt,Q,Ia=`We can see that the Wav2Vec2 model does a pretty good job at transcribing this sample - at a first glance it looks generally correct.
Let’s put the target and prediction side-by-side and highlight the differences:`,Rt,A,Vt,q,ka="Comparing the target text to the predicted transcription, we can see that all words <em>sound</em> correct, but some are not spelled accurately. For example:",$t,X,va="<li><em>CHRISTMAUS</em> vs. <em>CHRISTMAS</em></li> <li><em>ROSE</em> vs. <em>ROAST</em></li> <li><em>SIMALYIS</em> vs. <em>SIMILES</em></li>",Ht,z,Sa=`This highlights the shortcoming of a CTC model. A CTC model is essentially an ‘acoustic-only’ model: it consists of an encoder
which forms hidden-state representations from the audio inputs, and a linear layer which maps the hidden-states to characters:`,Wt,P,Ba=`This means that the system almost entirely bases its prediction on the acoustic input it was given (the phonetic sounds of the audio),
and so has a tendency to transcribe the audio in a phonetic way (e.g. <em>CHRISTMAUS</em>). It gives less importance to the
language modelling context of previous and successive letters, and so is prone to phonetic spelling errors. A more intelligent model
would identify that <em>CHRISTMAUS</em> is not a valid word in the English vocabulary, and correct it to <em>CHRISTMAS</em> when making
its predictions. We’re also missing two big features in our prediction - casing and punctuation - which limits the usefulness of
the model’s transcriptions to real-world applications.`,Ft,O,Zt,D,Ca=`Cue Seq2Seq models! As outlined in Unit 3, Seq2Seq models are formed of an encoder and decoder linked via a cross-attention
mechanism. The encoder plays the same role as before, computing hidden-state representations of the audio inputs, while the decoder
plays the role of a <strong>language model</strong>. The decoder processes the entire sequence of hidden-state representations
from the encoder and generates the corresponding text transcriptions. With global context of the audio input, the decoder
is able to use language modelling context as it makes its predictions, correcting for spelling mistakes on-the-fly and thus
circumventing the issue of phonetic predictions.`,Nt,K,xa="There are two downsides to Seq2Seq models:",_t,ee,Ea="<li>They are inherently slower at decoding, since the decoding process happens one step at a time, rather than all at once</li> <li>They are more data hungry, requiring significantly more training data to reach convergence</li>",Yt,te,Ga=`In particular, the need for large amounts of training data has been a bottleneck in the advancement of Seq2Seq architectures for
speech. Labelled speech data is difficult to come by, with the largest annotated datasets at the time clocking in at just
10,000 hours. This all changed in 2022 upon the release of <strong>Whisper</strong>. Whisper is a pre-trained model for speech recognition
published in <a href="https://openai.com/blog/whisper/" rel="nofollow">September 2022</a> by the authors Alec Radford et al. from OpenAI. Unlike
its CTC predecessors, which were pre-trained entirely on <strong>un-labelled</strong> audio data, Whisper is pre-trained on a vast quantity of
<strong>labelled</strong> audio-transcription data, 680,000 hours to be precise.`,Lt,se,Ra=`This is an order of magnitude more data than the un-labelled audio data used to train Wav2Vec 2.0 (60,000 hours). What is
more, 117,000 hours of this pre-training data is multilingual (or “non-English”) data. This results in checkpoints that can be applied to
over 96 languages, many of which are considered <em>low-resource</em>, meaning the language lacks a large corpus of data suitable for training.`,Qt,ae,Va=`When scaled to 680,000 hours of labelled pre-training data, Whisper models demonstrate a strong ability to generalise to
many datasets and domains. The pre-trained checkpoints achieve competitive results to state-of-the-art pipe systems, with
near 3% word error rate (WER) on the test-clean subset of LibriSpeech pipe and a new state-of-the-art on TED-LIUM with
4.7% WER (<em>c.f.</em> Table 8 of the <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper paper</a>).`,At,le,$a=`Of particular importance is Whisper’s ability to handle long-form audio samples, its robustness to input noise and ability
to predict cased and punctuated transcriptions. This makes it a viable candidate for real-world speech recognition systems.`,qt,ne,Ha=`The remainder of this section will show you how to use the pre-trained Whisper models for speech recognition using 🤗
Transformers. In many situations, the pre-trained Whisper checkpoints are extremely performant and give great results,
thus we encourage you to try using the pre-trained checkpoints as a first step to solving any speech recognition problem.
Through fine-tuning, the pre-trained checkpoints can be adapted for specific datasets and languages to further improve
upon these results. We’ll demonstrate how to do this in the upcoming subsection on <a href="fine-tuning">fine-tuning</a>.`,Xt,ie,Wa=`The Whisper checkpoints come in five configurations of varying model sizes. The smallest four are trained on either
English-only or multilingual data. The largest checkpoint is multilingual only. All nine of the pre-trained checkpoints
are available on the <a href="https://huggingface.co/models?search=openai/whisper" rel="nofollow">Hugging Face Hub</a>. The checkpoints are
summarised in the following table with links to the models on the Hub. “VRAM” denotes the required GPU memory to run the
model with the minimum batch size of 1. “Rel Speed” is the relative speed of a checkpoint compared to the largest model.
Based on this information, you can select a checkpoint that is best suited to your hardware.`,zt,oe,Fa='<thead><tr><th>Size</th> <th>Parameters</th> <th>VRAM / GB</th> <th>Rel Speed</th> <th>English-only</th> <th>Multilingual</th></tr></thead> <tbody><tr><td>tiny</td> <td>39 M</td> <td>1.4</td> <td>32</td> <td><a href="https://huggingface.co/openai/whisper-tiny.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-tiny" rel="nofollow">✓</a></td></tr> <tr><td>base</td> <td>74 M</td> <td>1.5</td> <td>16</td> <td><a href="https://huggingface.co/openai/whisper-base.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-base" rel="nofollow">✓</a></td></tr> <tr><td>small</td> <td>244 M</td> <td>2.3</td> <td>6</td> <td><a href="https://huggingface.co/openai/whisper-small.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-small" rel="nofollow">✓</a></td></tr> <tr><td>medium</td> <td>769 M</td> <td>4.2</td> <td>2</td> <td><a href="https://huggingface.co/openai/whisper-medium.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-medium" rel="nofollow">✓</a></td></tr> <tr><td>large</td> <td>1550 M</td> <td>7.5</td> <td>1</td> <td>x</td> <td><a href="https://huggingface.co/openai/whisper-large-v2" rel="nofollow">✓</a></td></tr></tbody>',Pt,re,Za=`Let’s load the <a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a> checkpoint, which is of comparable size to the
Wav2Vec2 checkpoint we used previously. Preempting our move to multilingual speech recognition, we’ll load the multilingual
variant of the base checkpoint. We’ll also load the model on the GPU if available, or CPU otherwise. The <code>pipeline()</code> will
subsequently take care of moving all inputs / outputs from the CPU to the GPU as required:`,Ot,pe,Dt,he,Na=`Great! Now let’s transcribe the audio as before. The only change we make is passing an extra argument, <code>max_new_tokens</code>,
which tells the model the maximum number of tokens to generate when making its prediction:`,Kt,ce,es,de,_a="<strong>Output:</strong>",ts,me,ss,Me,Ya=`Easy enough! The first thing you’ll notice is the presence of both casing and punctuation. Immediately this makes the
transcription easier to read compared to the un-cased and un-punctuated transcription from Wav2Vec2. Let’s put the transcription
side-by-side with the target:`,as,ue,ls,ye,La=`Whisper has done a great job at correcting the phonetic errors we saw from Wav2Vec2 - both <em>Christmas</em> and <em>roast</em> are
spelled correctly. We see that the model still struggles with <em>SIMILES</em>, being incorrectly transcribed as <em>similarly</em>, but
this time the prediction is a valid word from the English vocabulary. Using a larger Whisper checkpoint can help further
reduce transcription errors, at the expense of requiring more compute and a longer transcription time.`,ns,we,Qa=`We’ve been promised a model that can handle 96 languages, so lets leave English speech recognition for now and go global 🌎!
The <a href="https://huggingface.co/datasets/facebook/multilingual_librispeech" rel="nofollow">Multilingual LibriSpeech</a> (MLS) dataset is
the multilingual equivalent of the LibriSpeech dataset, with labelled audio data in six languages. We’ll load one sample
from the Spanish split of the MLS dataset, making use of <em>streaming</em> mode so that we don’t have to download the entire dataset:`,is,Te,os,Ue,Aa="Again, we’ll inspect the text transcription and take a listen to the audio segment:",rs,fe,ps,ge,qa="<strong>Output:</strong>",hs,Je,cs,be,Xa=`This is the target text that we’re aiming for with our Whisper transcription. Although we now know that we can
probably do better this, since our model is also going to predict punctuation and casing, neither of which are present in the
reference. Let’s forward the audio sample to the pipeline to get our text prediction. One thing to note is that the
pipeline <em>consumes</em> the dictionary of audio inputs that we input, meaning the dictionary can’t be re-used. To circumvent
this, we’ll pass a <em>copy</em> of the audio sample, so that we can re-use the same audio sample in the proceeding code examples:`,ds,je,ms,Ie,za="<strong>Output:</strong>",Ms,ke,us,ve,Pa=`Great - this looks very similar to our reference text (arguably better since it has punctuation and casing!). You’ll notice
that we forwarded the <code>&quot;task&quot;</code> as a <em>generate key-word argument</em> (generate kwarg). Setting the <code>&quot;task&quot;</code> to <code>&quot;transcribe&quot;</code>
forces Whisper to perform the task of <em>speech recognition</em>, where the audio is transcribed in the same language that the
speech was spoken in. Whisper is also capable of performing the closely related task of <em>speech translation</em>, where the
audio in Spanish can be translated to text in English. To achieve this, we set the <code>&quot;task&quot;</code> to <code>&quot;translate&quot;</code>:`,ys,Se,ws,Be,Oa="<strong>Output:</strong>",Ts,Ce,Us,xe,Da=`Now that we know we can toggle between speech recognition and speech translation, we can pick our task depending on our
needs. Either we recognise from audio in language X to text in the same language X (e.g. Spanish audio to Spanish text),
or we translate from audio in any language X to text in English (e.g. Spanish audio to English text).`,fs,Ee,Ka=`To read more about how the <code>&quot;task&quot;</code> argument is used to control the properties of the generated text, refer to the
<a href="https://huggingface.co/openai/whisper-base#usage" rel="nofollow">model card</a> for the Whisper base model.`,gs,Ge,Js,Re,el=`So far, we’ve focussed on transcribing short audio samples of less than 30 seconds. We mentioned that one of the appeals
of Whisper was its ability to work on long audio samples. We’ll tackle this task here!`,bs,Ve,tl=`Let’s create a long audio file by concatenating sequential samples from the MLS dataset. Since the MLS dataset is
curated by splitting long audiobook recordings into shorter segments, concatenating samples is one way of reconstructing
longer audiobook passages. Consequently, the resulting audio should be coherent across the entire sample.`,js,$e,sl="We’ll set our target audio length to 5 minutes, and stop concatenating samples once we hit this value:",Is,He,ks,We,al="<strong>Output:</strong>",vs,Fe,Ss,Ze,ll=`Alright! 5 minutes and 17 seconds of audio to transcribe. There are two problems with forwarding this long audio sample
directly to the model:`,Bs,Ne,nl="<li>Whisper is inherently designed to work with 30 second samples: anything shorter than 30s is padded to 30s with silence, anything longer than 30s is truncated to 30s by cutting of the extra audio, so if we pass our audio directly we’ll only get the transcription for the first 30s</li> <li>Memory in a transformer network scales with the sequence length squared: doubling the input length quadruples the memory requirement, so passing super long audio files is bound to lead to an out-of-memory (OOM) error</li>",Cs,_e,il=`The way long-form transcription works in 🤗 Transformers is by <em>chunking</em> the input audio into smaller, more manageable segments.
Each segment has a small amount of overlap with the previous one. This allows us to accurately stitch the segments back together
at the boundaries, since we can find the overlap between segments and merge the transcriptions accordingly:`,xs,f,ol='<img src="https://huggingface.co/blog/assets/49_asr_chunking/Striding.png" alt="🤗 Transformers chunking algorithm. Source: https://huggingface.co/blog/asr-chunking."/>',Es,y,oa,Gs,Jl='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',Rs,Vs,bl='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',$s,nt,rl="stateless",ra,Hs,jl='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Ws,Fs,Il='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',Zs,it,pl="batch",pa,g,hl="blog post",ha,Ns,Ye,cl=`To activate long-form transcriptions, we have to add one additional argument when we call the pipeline. This argument,
<code>chunk_length_s</code>, controls the length of the chunked segments in seconds. For Whisper, 30 second chunks are optimal,
since this matches the input length Whisper expects.`,_s,Le,dl=`To activate batching, we need to pass the argument <code>batch_size</code> to the pipeline. Putting it all together, we can transcribe the
long audio sample with chunking and batching as follows:`,Ys,Qe,Ls,Ae,ml="<strong>Output:</strong>",Qs,qe,As,Xe,Ml=`We won’t print the entire output here since it’s pretty long (312 words total)! On a 16GB V100 GPU, you can expect the above
line to take approximately 3.45 seconds to run, which is pretty good for a 317 second audio sample. On a CPU, expect
closer to 30 seconds.`,qs,ze,ul=`Whisper is also able to predict segment-level <em>timestamps</em> for the audio data. These timestamps indicate the start and end
time for a short passage of audio, and are particularly useful for aligning a transcription with the input audio. Suppose
we want to provide closed captions for a video - we need these timestamps to know which part of the transcription corresponds
to a certain segment of video, in order to display the correct transcription for that time.`,Xs,Pe,yl=`Activating timestamp prediction is straightforward, we just need to set the argument <code>return_timestamps=True</code>. Timestamps
are compatible with both the chunking and batching methods we used previously, so we can simply append the timestamp
argument to our previous call:`,zs,Oe,Ps,De,wl="<strong>Output:</strong>",Os,Ke,Ds,et,Tl="And voila! We have our predicted text as well as corresponding timestamps.",Ks,tt,ea,st,Ul=`Whisper is a strong pre-trained model for speech recognition and translation. Compared to Wav2Vec2, it has higher
transcription accuracy, with outputs that contain punctuation and casing. It can be used to transcribe speech in English
as well as 96 other languages, both on short audio segments and longer ones through <em>chunking</em>. These attributes make it
a viable model for many speech recognition and translation tasks without the need for fine-tuning. The <code>pipeline()</code> method
provides an easy way of running inference in one-line API calls with control over the generated predictions.`,ta,at,fl=`While the Whisper model performs extremely well on many high-resource languages, it has lower transcription and translation
accuracy on low-resource languages, i.e. those with less readily available training data. There is also varying performance
across different accents and dialects of certain languages, including lower accuracy for speakers of different genders,
races, ages or other demographic criteria (<em>c.f.</em> <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper paper</a>).`,sa,lt,gl=`To boost the performance on low-resource languages, accents or dialects, we can take the pre-trained Whisper model and
train it on a small corpus of appropriately selected data, in a process called <em>fine-tuning</em>. We’ll show that with
as little as ten hours of additional data, we can improve the performance of the Whisper model by over 100% on a low-resource
language. In the next section, we’ll cover the process behind selecting a dataset for fine-tuning.`,aa,rt,la;return j=new ht({props:{title:"Pre-trained models for automatic speech recognition",local:"pre-trained-models-for-automatic-speech-recognition",headingTag:"h1"}}),C=new ht({props:{title:"Probing CTC Models",local:"probing-ctc-models",headingTag:"h2"}}),E=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMEEpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(
    <span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>
)
dataset`,wrap:!1}}),R=new u({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidmaWxlJyUyQyUyMCdhdWRpbyclMkMlMjAndGV4dCclMkMlMjAnc3BlYWtlcl9pZCclMkMlMjAnY2hhcHRlcl9pZCclMkMlMjAnaWQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA3MyUwQSU3RCk=",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;file&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;speaker_id&#x27;</span>, <span class="hljs-string">&#x27;chapter_id&#x27;</span>, <span class="hljs-string">&#x27;id&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">73</span>
})`,wrap:!1}}),$=new u({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjIlNUQlMEElMEFwcmludChzYW1wbGUlNUIlMjJ0ZXh0JTIyJTVEKSUwQUF1ZGlvKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjByYXRlJTNEc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sample = dataset[<span class="hljs-number">2</span>]

<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),W=new u({props:{code:"SEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5E",highlighted:'HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND',wrap:!1}}),Z=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS0xMDBoJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;facebook/wav2vec2-base-100h&quot;</span>)`,wrap:!1}}),_=new u({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCkp",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())',wrap:!1}}),L=new u({props:{code:"JTdCJTIydGV4dCUyMiUzQSUyMCUyMkhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMENIUklTVE1BVVMlMjBBTkQlMjBST1NFJTIwQkVFRiUyMExPT01JTkclMjBCRUZPUkUlMjBVUyUyMFNJTUFMWUlTJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQlMjIlN0Q=",highlighted:'<span class="hljs-comment">{&quot;text&quot;: &quot;HE TELLS US THAT AT THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAUS AND ROSE BEEF LOOMING BEFORE US SIMALYIS DRAWN FROM EATING AND ITS RESULTS OCCUR MOST READILY TO THE MIND&quot;}</span>',wrap:!1}}),A=new u({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMCUyMEhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMCoqQ0hSSVNUTUFVUyoqJTIwQU5EJTIwKipST1NFKiolMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwKipTSU1BTFlJUyoqJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQ=",highlighted:`<span class="hljs-symbol">Target:</span>      HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span>  HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH **CHRISTMAUS** <span class="hljs-keyword">AND </span>**ROSE** <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US **SIMALYIS** DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND`,wrap:!1}}),O=new ht({props:{title:"Graduation to Seq2Seq",local:"graduation-to-seq2seq",headingTag:"h2"}}),pe=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>, device=device
)`,wrap:!1}}),ce=new u({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>)',wrap:!1}}),me=new u({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMENocmlzdG1hcyUyMGFuZCUyMHJvYXN0JTIwYmVlZiUyMGxvb21pbmclMjBiZWZvcmUlMjB1cyUyQyUyMHNpbWlsYXJseSUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQuJyU3RA==",highlighted:'{&#x27;<span class="hljs-built_in">text</span>&#x27;: &#x27; He tells us <span class="hljs-keyword">that</span> <span class="hljs-keyword">at</span> this festive season <span class="hljs-keyword">of</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span>, <span class="hljs-keyword">with</span> Christmas <span class="hljs-keyword">and</span> roast beef looming <span class="hljs-keyword">before</span> us, similarly <span class="hljs-keyword">is</span> drawn <span class="hljs-keyword">from</span> eating <span class="hljs-keyword">and</span> <span class="hljs-keyword">its</span> results occur most readily <span class="hljs-keyword">to</span> <span class="hljs-keyword">the</span> mind.&#x27;}',wrap:!1}}),ue=new u({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMCoqQ2hyaXN0bWFzKiolMjBhbmQlMjAqKnJvYXN0KiolMjBiZWVmJTIwbG9vbWluZyUyMGJlZm9yZSUyMHVzJTJDJTIwKipzaW1pbGFybHkqKiUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQu",highlighted:`<span class="hljs-symbol">Target:</span>     HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span> He tells us that <span class="hljs-built_in">at</span> this festive season of the year, with **Christmas** <span class="hljs-keyword">and </span>**roast** <span class="hljs-keyword">beef </span>looming <span class="hljs-keyword">before </span>us, **similarly** is drawn from eating <span class="hljs-keyword">and </span>its results occur most readily to the mind.`,wrap:!1}}),Te=new u({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm11bHRpbGluZ3VhbF9saWJyaXNwZWVjaCUyMiUyQyUyMCUyMnNwYW5pc2glMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTBBKSUwQXNhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSk=",highlighted:`dataset = load_dataset(
    <span class="hljs-string">&quot;facebook/multilingual_librispeech&quot;</span>, <span class="hljs-string">&quot;spanish&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))`,wrap:!1}}),fe=new u({props:{code:"cHJpbnQoc2FtcGxlJTVCJTIydGV4dCUyMiU1RCklMEFBdWRpbyhzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmF0ZSUzRHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),Je=new u({props:{code:"ZW50b25jZXMlMjB0ZSUyMGRlbGVsaXRhciVDMyVBMXMlMjBlbiUyMGplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjAlQzMlQTElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwamFjb2IlMjB0dSUyMHBhZHJlJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBqZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRv",highlighted:'entonces <span class="hljs-keyword">te</span> delelitarás <span class="hljs-keyword">en</span> jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré á comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> jehová lo ha hablado',wrap:!1}}),je=new u({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCklMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1NiUyQyUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMnRhc2slMjIlM0ElMjAlMjJ0cmFuc2NyaWJlJTIyJTdEKQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy(), max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>})',wrap:!1}}),ke=new u({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUyMGhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4nJTdE",highlighted:'{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> Jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado.&#x27;}',wrap:!1}}),Se=new u({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2JTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zbGF0ZSUyMiU3RCk=",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;translate&quot;</span>})',wrap:!1}}),Ce=new u({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMFNvJTIweW91JTIwd2lsbCUyMGNob29zZSUyMGluJTIwSmVob3ZhaCUyMGFuZCUyMEklMjB3aWxsJTIwcmFpc2UlMjB5b3UlMjBvbiUyMHRoZSUyMGhlaWdodHMlMjBvZiUyMHRoZSUyMGVhcnRoJTIwYW5kJTIwSSUyMHdpbGwlMjBnaXZlJTIweW91JTIwdGhlJTIwaG9ub3IlMjBvZiUyMEphY29iJTIwdG8lMjB5b3VyJTIwZmF0aGVyJTIwYmVjYXVzZSUyMHRoZSUyMHZvaWNlJTIwb2YlMjBKZWhvdmFoJTIwaGFzJTIwc3Bva2VuJTIwdG8lMjB5b3UuJyU3RA==",highlighted:'<span class="hljs-comment">{&#x27;text&#x27;: &#x27; So you will choose in Jehovah and I will raise you on the heights of the earth and I will give you the honor of Jacob to your father because the voice of Jehovah has spoken to you.&#x27;}</span>',wrap:!1}}),Ge=new ht({props:{title:"Long-Form Transcription and Timestamps",local:"long-form-transcription-and-timestamps",headingTag:"h2"}}),He=new u({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBdGFyZ2V0X2xlbmd0aF9pbl9tJTIwJTNEJTIwNSUwQSUwQSUyMyUyMGNvbnZlcnQlMjBmcm9tJTIwbWludXRlcyUyMHRvJTIwc2Vjb25kcyUyMCgqJTIwNjApJTIwdG8lMjBudW0lMjBzYW1wbGVzJTIwKColMjBzYW1wbGluZyUyMHJhdGUpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMHBpcGUuZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUwQXRhcmdldF9sZW5ndGhfaW5fc2FtcGxlcyUyMCUzRCUyMHRhcmdldF9sZW5ndGhfaW5fbSUyMColMjA2MCUyMColMjBzYW1wbGluZ19yYXRlJTBBJTBBJTIzJTIwaXRlcmF0ZSUyMG92ZXIlMjBvdXIlMjBzdHJlYW1pbmclMjBkYXRhc2V0JTJDJTIwY29uY2F0ZW5hdGluZyUyMHNhbXBsZXMlMjB1bnRpbCUyMHdlJTIwaGl0JTIwb3VyJTIwdGFyZ2V0JTBBbG9uZ19hdWRpbyUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMHNhbXBsZSUyMGluJTIwZGF0YXNldCUzQSUwQSUyMCUyMCUyMCUyMGxvbmdfYXVkaW8uZXh0ZW5kKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBsZW4obG9uZ19hdWRpbyklMjAlM0UlMjB0YXJnZXRfbGVuZ3RoX2luX3NhbXBsZXMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhayUwQSUwQWxvbmdfYXVkaW8lMjAlM0QlMjBucC5hc2FycmF5KGxvbmdfYXVkaW8pJTBBJTBBJTIzJTIwaG93JTIwZGlkJTIwd2UlMjBkbyUzRiUwQXNlY29uZHMlMjAlM0QlMjBsZW4obG9uZ19hdWRpbyklMjAlMkYlMjAxNjAwMCUwQW1pbnV0ZXMlMkMlMjBzZWNvbmRzJTIwJTNEJTIwZGl2bW9kKHNlY29uZHMlMkMlMjA2MCklMEFwcmludChmJTIyTGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwJTdCbWludXRlcyU3RCUyMG1pbnV0ZXMlMjAlN0JzZWNvbmRzJTNBLjJmJTdEJTIwc2Vjb25kcyUyMik=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

target_length_in_m = <span class="hljs-number">5</span>

<span class="hljs-comment"># convert from minutes to seconds (* 60) to num samples (* sampling rate)</span>
sampling_rate = pipe.feature_extractor.sampling_rate
target_length_in_samples = target_length_in_m * <span class="hljs-number">60</span> * sampling_rate

<span class="hljs-comment"># iterate over our streaming dataset, concatenating samples until we hit our target</span>
long_audio = []
<span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> dataset:
    long_audio.extend(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(long_audio) &gt; target_length_in_samples:
        <span class="hljs-keyword">break</span>

long_audio = np.asarray(long_audio)

<span class="hljs-comment"># how did we do?</span>
seconds = <span class="hljs-built_in">len</span>(long_audio) / <span class="hljs-number">16000</span>
minutes, seconds = <span class="hljs-built_in">divmod</span>(seconds, <span class="hljs-number">60</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Length of audio sample is <span class="hljs-subst">{minutes}</span> minutes <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)`,wrap:!1}}),Fe=new u({props:{code:"TGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwNS4wJTIwbWludXRlcyUyMDE3LjIyJTIwc2Vjb25kcw==",highlighted:'<span class="hljs-attribute">Length</span> of audio sample is <span class="hljs-number">5</span>.<span class="hljs-number">0</span> minutes <span class="hljs-number">17</span>.<span class="hljs-number">22</span> seconds',wrap:!1}}),Qe=new u({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
)`,wrap:!1}}),qe=new u({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTJDJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMkMlMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUwQWhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyQyUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4lMjBub3NvdHJvcyUyMGN1cmFkb3MuJTIwVG9kb3MlMjBub3NvdHJvcyUyMG5vcyUyMGRlc2NhcnJpYW1vcyUwQWNvbW8lMjBiZWphcyUyQyUyMGNhZGElMjBjdWFsJTIwc2UlMjBhcGFydCVDMyVCMyUyMHBvciUyMHN1JTIwY2FtaW5vJTJDJTIwbWFzJTIwSmVob3YlQzMlQTElMjBjYXJnJUMzJUIzJTIwZW4lMjAlQzMlQTlsJTIwZWwlMjBwZWNhZG8lMjBkZSUyMHRvZG9zJTIwbm9zb3Ryb3MuLi4=",highlighted:`{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová, y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra, y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span>
heredad <span class="hljs-keyword">de</span> Jacob tu padre, porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos
como bejas, cada cual <span class="hljs-keyword">se</span> apartó por <span class="hljs-keyword">su</span> camino, mas Jehová cargó <span class="hljs-keyword">en</span> é<span class="hljs-keyword">l</span> el pecado <span class="hljs-keyword">de</span> todos nosotros...`,wrap:!1}}),Oe=new u({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSUyQyUwQSklNUIlMjJjaHVua3MlMjIlNUQ=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
    return_timestamps=<span class="hljs-literal">True</span>,
)[<span class="hljs-string">&quot;chunks&quot;</span>]`,wrap:!1}}),Ke=new u({props:{code:"JTVCJTdCJ3RpbWVzdGFtcCclM0ElMjAoMC4wJTJDJTIwMjYuNCklMkMlMEElMjAlMjAndGV4dCclM0ElMjAnJTIwRW50b25jZXMlMjB0ZSUyMGRlbGVpdGFyJUMzJUExcyUyMGVuJTIwSmVob3YlQzMlQTElMkMlMjB5JTIweW8lMjB0ZSUyMGhhciVDMyVBOSUyMHN1YmlyJTIwc29icmUlMjBsYXMlMjBhbHR1cmFzJTIwZGUlMjBsYSUyMHRpZXJyYSUyQyUyMHklMjB0ZSUyMGRhciVDMyVBOSUyMGElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwSmFjb2IlMjB0dSUyMHBhZHJlJTJDJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBKZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRvLiUyMG5vc290cm9zJTIwY3VyYWRvcy4lMjBUb2RvcyUyMG5vc290cm9zJTIwbm9zJTIwZGVzY2FycmlhbW9zJTIwY29tbyUyMGJlamFzJTJDJTIwY2FkYSUyMGN1YWwlMjBzZSUyMGFwYXJ0JUMzJUIzJTIwcG9yJTIwc3UlMjBjYW1pbm8lMkMnJTdEJTJDJTBBJTIwJTdCJ3RpbWVzdGFtcCclM0ElMjAoMjYuNCUyQyUyMDMyLjQ4KSUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCclMjBtYXMlMjBKZWhvdiVDMyVBMSUyMGNhcmclQzMlQjMlMjBlbiUyMCVDMyVBOWwlMjBlbCUyMHBlY2FkbyUyMGRlJTIwdG9kb3MlMjBub3NvdHJvcy4lMjBObyUyMGVzJTIwcXVlJTIwcGFydGFzJTIwdHUlMjBwYW4lMjBjb24lMjBlbCclN0QlMkMlMEElMjAlN0IndGltZXN0YW1wJyUzQSUyMCgzMi40OCUyQyUyMDM4LjQpJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyUyMGhhbWJyaWVudG8lMjB5JTIwYSUyMGxvcyUyMGhvbWJyZXMlMjBoZXJyYW50ZXMlMjBtZXRhcyUyMGVuJTIwY2FzYSUyQyUyMHF1ZSUyMGN1YW5kbyUyMHZpZXJlcyUyMGFsJTIwZGVzbnVkbyUyMGxvJTIwY3VicmFzJTIweSUyMG5vJyU3RCUyQyUwQSUyMC4uLg==",highlighted:`[{<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">0.0</span>, <span class="hljs-number">26.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; Entonces te deleitarás en Jehová, y yo te haré subir sobre las alturas de la tierra, y te daré a comer la heredad de Jacob tu padre, porque la boca de Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos como bejas, cada cual se apartó por su camino,&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">26.4</span>, <span class="hljs-number">32.48</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; mas Jehová cargó en él el pecado de todos nosotros. No es que partas tu pan con el&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">32.48</span>, <span class="hljs-number">38.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; hambriento y a los hombres herrantes metas en casa, que cuando vieres al desnudo lo cubras y no&#x27;},
 ...`,wrap:!1}}),tt=new ht({props:{title:"Summary",local:"summary",headingTag:"h2"}}),{c(){U=i("meta"),ct=l(),ot=i("p"),dt=l(),p(j.$$.fragment),mt=l(),I=i("p"),I.innerHTML=ma,Mt=l(),k=i("p"),k.textContent=Ma,ut=l(),v=i("ol"),v.innerHTML=ua,yt=l(),S=i("p"),S.innerHTML=ya,wt=l(),B=i("p"),B.textContent=wa,Tt=l(),p(C.$$.fragment),Ut=l(),x=i("p"),x.innerHTML=Ta,ft=l(),p(E.$$.fragment),gt=l(),G=i("p"),G.innerHTML=Ua,Jt=l(),p(R.$$.fragment),bt=l(),V=i("p"),V.textContent=fa,jt=l(),p($.$$.fragment),It=l(),H=i("p"),H.innerHTML=ga,kt=l(),p(W.$$.fragment),vt=l(),F=i("p"),F.innerHTML=Ja,St=l(),p(Z.$$.fragment),Bt=l(),N=i("p"),N.innerHTML=ba,Ct=l(),p(_.$$.fragment),xt=l(),Y=i("p"),Y.innerHTML=ja,Et=l(),p(L.$$.fragment),Gt=l(),Q=i("p"),Q.textContent=Ia,Rt=l(),p(A.$$.fragment),Vt=l(),q=i("p"),q.innerHTML=ka,$t=l(),X=i("ul"),X.innerHTML=va,Ht=l(),z=i("p"),z.textContent=Sa,Wt=l(),P=i("p"),P.innerHTML=Ba,Ft=l(),p(O.$$.fragment),Zt=l(),D=i("p"),D.innerHTML=Ca,Nt=l(),K=i("p"),K.textContent=xa,_t=l(),ee=i("ol"),ee.innerHTML=Ea,Yt=l(),te=i("p"),te.innerHTML=Ga,Lt=l(),se=i("p"),se.innerHTML=Ra,Qt=l(),ae=i("p"),ae.innerHTML=Va,At=l(),le=i("p"),le.textContent=$a,qt=l(),ne=i("p"),ne.innerHTML=Ha,Xt=l(),ie=i("p"),ie.innerHTML=Wa,zt=l(),oe=i("table"),oe.innerHTML=Fa,Pt=l(),re=i("p"),re.innerHTML=Za,Ot=l(),p(pe.$$.fragment),Dt=l(),he=i("p"),he.innerHTML=Na,Kt=l(),p(ce.$$.fragment),es=l(),de=i("p"),de.innerHTML=_a,ts=l(),p(me.$$.fragment),ss=l(),Me=i("p"),Me.textContent=Ya,as=l(),p(ue.$$.fragment),ls=l(),ye=i("p"),ye.innerHTML=La,ns=l(),we=i("p"),we.innerHTML=Qa,is=l(),p(Te.$$.fragment),os=l(),Ue=i("p"),Ue.textContent=Aa,rs=l(),p(fe.$$.fragment),ps=l(),ge=i("p"),ge.innerHTML=qa,hs=l(),p(Je.$$.fragment),cs=l(),be=i("p"),be.innerHTML=Xa,ds=l(),p(je.$$.fragment),ms=l(),Ie=i("p"),Ie.innerHTML=za,Ms=l(),p(ke.$$.fragment),us=l(),ve=i("p"),ve.innerHTML=Pa,ys=l(),p(Se.$$.fragment),ws=l(),Be=i("p"),Be.innerHTML=Oa,Ts=l(),p(Ce.$$.fragment),Us=l(),xe=i("p"),xe.textContent=Da,fs=l(),Ee=i("p"),Ee.innerHTML=Ka,gs=l(),p(Ge.$$.fragment),Js=l(),Re=i("p"),Re.textContent=el,bs=l(),Ve=i("p"),Ve.textContent=tl,js=l(),$e=i("p"),$e.textContent=sl,Is=l(),p(He.$$.fragment),ks=l(),We=i("p"),We.innerHTML=al,vs=l(),p(Fe.$$.fragment),Ss=l(),Ze=i("p"),Ze.textContent=ll,Bs=l(),Ne=i("ol"),Ne.innerHTML=nl,Cs=l(),_e=i("p"),_e.innerHTML=il,xs=l(),f=i("div"),f.innerHTML=ol,Es=l(),y=i("p"),oa=J("The advantage of chunking the samples is that we don’t need the result of chunk "),Gs=new na(!1),Rs=J(` to transcribe the subsequent
chunk `),Vs=new na(!1),$s=J(`. The stitching is done after we have transcribed all the chunks at the chunk boundaries, so it doesn’t
matter which order we transcribe chunks in. The algorithm is entirely `),nt=i("strong"),nt.textContent=rl,ra=J(", so we can even do chunk "),Hs=new na(!1),Ws=J(`
at the same time as chunk `),Fs=new na(!1),Zs=J("! This allows us to "),it=i("em"),it.textContent=pl,pa=J(` the chunks and run them through the model in parallel,
providing a large computational speed-up compared to transcribing them sequentially. To read more about chunking in 🤗 Transformers,
you can refer to this `),g=i("a"),g.textContent=hl,ha=J("."),Ns=l(),Ye=i("p"),Ye.innerHTML=cl,_s=l(),Le=i("p"),Le.innerHTML=dl,Ys=l(),p(Qe.$$.fragment),Ls=l(),Ae=i("p"),Ae.innerHTML=ml,Qs=l(),p(qe.$$.fragment),As=l(),Xe=i("p"),Xe.textContent=Ml,qs=l(),ze=i("p"),ze.innerHTML=ul,Xs=l(),Pe=i("p"),Pe.innerHTML=yl,zs=l(),p(Oe.$$.fragment),Ps=l(),De=i("p"),De.innerHTML=wl,Os=l(),p(Ke.$$.fragment),Ds=l(),et=i("p"),et.textContent=Tl,Ks=l(),p(tt.$$.fragment),ea=l(),st=i("p"),st.innerHTML=Ul,ta=l(),at=i("p"),at.innerHTML=fl,sa=l(),lt=i("p"),lt.innerHTML=gl,aa=l(),rt=i("p"),this.h()},l(e){const t=xl("svelte-u9bgzb",document.head);U=o(t,"META",{name:!0,content:!0}),t.forEach(s),ct=n(e),ot=o(e,"P",{}),ca(ot).forEach(s),dt=n(e),h(j.$$.fragment,e),mt=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-qu6ugv"&&(I.innerHTML=ma),Mt=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1lo7cg7"&&(k.textContent=Ma),ut=n(e),v=o(e,"OL",{"data-svelte-h":!0}),r(v)!=="svelte-4r9go5"&&(v.innerHTML=ua),yt=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-7bh989"&&(S.innerHTML=ya),wt=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1y7wlps"&&(B.textContent=wa),Tt=n(e),h(C.$$.fragment,e),Ut=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-6p3rx4"&&(x.innerHTML=Ta),ft=n(e),h(E.$$.fragment,e),gt=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1mvdyro"&&(G.innerHTML=Ua),Jt=n(e),h(R.$$.fragment,e),bt=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1f14qa5"&&(V.textContent=fa),jt=n(e),h($.$$.fragment,e),It=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1mvdyro"&&(H.innerHTML=ga),kt=n(e),h(W.$$.fragment,e),vt=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-zwb92k"&&(F.innerHTML=Ja),St=n(e),h(Z.$$.fragment,e),Bt=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-160y70r"&&(N.innerHTML=ba),Ct=n(e),h(_.$$.fragment,e),xt=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1mvdyro"&&(Y.innerHTML=ja),Et=n(e),h(L.$$.fragment,e),Gt=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1n1tyml"&&(Q.textContent=Ia),Rt=n(e),h(A.$$.fragment,e),Vt=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-fjdtrw"&&(q.innerHTML=ka),$t=n(e),X=o(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-11mc7qy"&&(X.innerHTML=va),Ht=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-18hr596"&&(z.textContent=Sa),Wt=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-mwf7be"&&(P.innerHTML=Ba),Ft=n(e),h(O.$$.fragment,e),Zt=n(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-55oy83"&&(D.innerHTML=Ca),Nt=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-969zyv"&&(K.textContent=xa),_t=n(e),ee=o(e,"OL",{"data-svelte-h":!0}),r(ee)!=="svelte-osi73t"&&(ee.innerHTML=Ea),Yt=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1bn96on"&&(te.innerHTML=Ga),Lt=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-zyrdbw"&&(se.innerHTML=Ra),Qt=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-em8jox"&&(ae.innerHTML=Va),At=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1g5392c"&&(le.textContent=$a),qt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-5h4os6"&&(ne.innerHTML=Ha),Xt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-uy2cuy"&&(ie.innerHTML=Wa),zt=n(e),oe=o(e,"TABLE",{"data-svelte-h":!0}),r(oe)!=="svelte-leifmh"&&(oe.innerHTML=Fa),Pt=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-efpzbz"&&(re.innerHTML=Za),Ot=n(e),h(pe.$$.fragment,e),Dt=n(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1feq0tt"&&(he.innerHTML=Na),Kt=n(e),h(ce.$$.fragment,e),es=n(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1mvdyro"&&(de.innerHTML=_a),ts=n(e),h(me.$$.fragment,e),ss=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-18db65j"&&(Me.textContent=Ya),as=n(e),h(ue.$$.fragment,e),ls=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-mm1pes"&&(ye.innerHTML=La),ns=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1ol57p5"&&(we.innerHTML=Qa),is=n(e),h(Te.$$.fragment,e),os=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1f9nh4o"&&(Ue.textContent=Aa),rs=n(e),h(fe.$$.fragment,e),ps=n(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1mvdyro"&&(ge.innerHTML=qa),hs=n(e),h(Je.$$.fragment,e),cs=n(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-75q7fw"&&(be.innerHTML=Xa),ds=n(e),h(je.$$.fragment,e),ms=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1mvdyro"&&(Ie.innerHTML=za),Ms=n(e),h(ke.$$.fragment,e),us=n(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-uzlabu"&&(ve.innerHTML=Pa),ys=n(e),h(Se.$$.fragment,e),ws=n(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1mvdyro"&&(Be.innerHTML=Oa),Ts=n(e),h(Ce.$$.fragment,e),Us=n(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-joibr"&&(xe.textContent=Da),fs=n(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1aecqb1"&&(Ee.innerHTML=Ka),gs=n(e),h(Ge.$$.fragment,e),Js=n(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-ad6ien"&&(Re.textContent=el),bs=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1atykwj"&&(Ve.textContent=tl),js=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-8fkb86"&&($e.textContent=sl),Is=n(e),h(He.$$.fragment,e),ks=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1mvdyro"&&(We.innerHTML=al),vs=n(e),h(Fe.$$.fragment,e),Ss=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-rlobar"&&(Ze.textContent=ll),Bs=n(e),Ne=o(e,"OL",{"data-svelte-h":!0}),r(Ne)!=="svelte-xow7at"&&(Ne.innerHTML=nl),Cs=n(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1kl6cah"&&(_e.innerHTML=il),xs=n(e),f=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(f)!=="svelte-dbmn5s"&&(f.innerHTML=ol),Es=n(e),y=o(e,"P",{});var w=ca(y);oa=b(w,"The advantage of chunking the samples is that we don’t need the result of chunk "),Gs=ia(w,!1),Rs=b(w,` to transcribe the subsequent
chunk `),Vs=ia(w,!1),$s=b(w,`. The stitching is done after we have transcribed all the chunks at the chunk boundaries, so it doesn’t
matter which order we transcribe chunks in. The algorithm is entirely `),nt=o(w,"STRONG",{"data-svelte-h":!0}),r(nt)!=="svelte-1caf2ri"&&(nt.textContent=rl),ra=b(w,", so we can even do chunk "),Hs=ia(w,!1),Ws=b(w,`
at the same time as chunk `),Fs=ia(w,!1),Zs=b(w,"! This allows us to "),it=o(w,"EM",{"data-svelte-h":!0}),r(it)!=="svelte-1swb9sm"&&(it.textContent=pl),pa=b(w,` the chunks and run them through the model in parallel,
providing a large computational speed-up compared to transcribing them sequentially. To read more about chunking in 🤗 Transformers,
you can refer to this `),g=o(w,"A",{href:!0,rel:!0,"data-svelte-h":!0}),r(g)!=="svelte-1d46t8h"&&(g.textContent=hl),ha=b(w,"."),w.forEach(s),Ns=n(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1bfrg8c"&&(Ye.innerHTML=cl),_s=n(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1ldveni"&&(Le.innerHTML=dl),Ys=n(e),h(Qe.$$.fragment,e),Ls=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1mvdyro"&&(Ae.innerHTML=ml),Qs=n(e),h(qe.$$.fragment,e),As=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-wy7qyj"&&(Xe.textContent=Ml),qs=n(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1pdqzp1"&&(ze.innerHTML=ul),Xs=n(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1kodbk1"&&(Pe.innerHTML=yl),zs=n(e),h(Oe.$$.fragment,e),Ps=n(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-1mvdyro"&&(De.innerHTML=wl),Os=n(e),h(Ke.$$.fragment,e),Ds=n(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-7n3xc4"&&(et.textContent=Tl),Ks=n(e),h(tt.$$.fragment,e),ea=n(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1t35nks"&&(st.innerHTML=Ul),ta=n(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1eiih7q"&&(at.innerHTML=fl),sa=n(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-a24nm6"&&(lt.innerHTML=gl),aa=n(e),rt=o(e,"P",{}),ca(rt).forEach(s),this.h()},h(){pt(U,"name","hf:doc:metadata"),pt(U,"content",Gl),pt(f,"class","flex justify-center"),Gs.a=Rs,Vs.a=$s,Hs.a=Ws,Fs.a=Zs,pt(g,"href","https://huggingface.co/blog/asr-chunking"),pt(g,"rel","nofollow")},m(e,t){T(document.head,U),a(e,ct,t),a(e,ot,t),a(e,dt,t),c(j,e,t),a(e,mt,t),a(e,I,t),a(e,Mt,t),a(e,k,t),a(e,ut,t),a(e,v,t),a(e,yt,t),a(e,S,t),a(e,wt,t),a(e,B,t),a(e,Tt,t),c(C,e,t),a(e,Ut,t),a(e,x,t),a(e,ft,t),c(E,e,t),a(e,gt,t),a(e,G,t),a(e,Jt,t),c(R,e,t),a(e,bt,t),a(e,V,t),a(e,jt,t),c($,e,t),a(e,It,t),a(e,H,t),a(e,kt,t),c(W,e,t),a(e,vt,t),a(e,F,t),a(e,St,t),c(Z,e,t),a(e,Bt,t),a(e,N,t),a(e,Ct,t),c(_,e,t),a(e,xt,t),a(e,Y,t),a(e,Et,t),c(L,e,t),a(e,Gt,t),a(e,Q,t),a(e,Rt,t),c(A,e,t),a(e,Vt,t),a(e,q,t),a(e,$t,t),a(e,X,t),a(e,Ht,t),a(e,z,t),a(e,Wt,t),a(e,P,t),a(e,Ft,t),c(O,e,t),a(e,Zt,t),a(e,D,t),a(e,Nt,t),a(e,K,t),a(e,_t,t),a(e,ee,t),a(e,Yt,t),a(e,te,t),a(e,Lt,t),a(e,se,t),a(e,Qt,t),a(e,ae,t),a(e,At,t),a(e,le,t),a(e,qt,t),a(e,ne,t),a(e,Xt,t),a(e,ie,t),a(e,zt,t),a(e,oe,t),a(e,Pt,t),a(e,re,t),a(e,Ot,t),c(pe,e,t),a(e,Dt,t),a(e,he,t),a(e,Kt,t),c(ce,e,t),a(e,es,t),a(e,de,t),a(e,ts,t),c(me,e,t),a(e,ss,t),a(e,Me,t),a(e,as,t),c(ue,e,t),a(e,ls,t),a(e,ye,t),a(e,ns,t),a(e,we,t),a(e,is,t),c(Te,e,t),a(e,os,t),a(e,Ue,t),a(e,rs,t),c(fe,e,t),a(e,ps,t),a(e,ge,t),a(e,hs,t),c(Je,e,t),a(e,cs,t),a(e,be,t),a(e,ds,t),c(je,e,t),a(e,ms,t),a(e,Ie,t),a(e,Ms,t),c(ke,e,t),a(e,us,t),a(e,ve,t),a(e,ys,t),c(Se,e,t),a(e,ws,t),a(e,Be,t),a(e,Ts,t),c(Ce,e,t),a(e,Us,t),a(e,xe,t),a(e,fs,t),a(e,Ee,t),a(e,gs,t),c(Ge,e,t),a(e,Js,t),a(e,Re,t),a(e,bs,t),a(e,Ve,t),a(e,js,t),a(e,$e,t),a(e,Is,t),c(He,e,t),a(e,ks,t),a(e,We,t),a(e,vs,t),c(Fe,e,t),a(e,Ss,t),a(e,Ze,t),a(e,Bs,t),a(e,Ne,t),a(e,Cs,t),a(e,_e,t),a(e,xs,t),a(e,f,t),a(e,Es,t),a(e,y,t),T(y,oa),Gs.m(Jl,y),T(y,Rs),Vs.m(bl,y),T(y,$s),T(y,nt),T(y,ra),Hs.m(jl,y),T(y,Ws),Fs.m(Il,y),T(y,Zs),T(y,it),T(y,pa),T(y,g),T(y,ha),a(e,Ns,t),a(e,Ye,t),a(e,_s,t),a(e,Le,t),a(e,Ys,t),c(Qe,e,t),a(e,Ls,t),a(e,Ae,t),a(e,Qs,t),c(qe,e,t),a(e,As,t),a(e,Xe,t),a(e,qs,t),a(e,ze,t),a(e,Xs,t),a(e,Pe,t),a(e,zs,t),c(Oe,e,t),a(e,Ps,t),a(e,De,t),a(e,Os,t),c(Ke,e,t),a(e,Ds,t),a(e,et,t),a(e,Ks,t),c(tt,e,t),a(e,ea,t),a(e,st,t),a(e,ta,t),a(e,at,t),a(e,sa,t),a(e,lt,t),a(e,aa,t),a(e,rt,t),la=!0},p:vl,i(e){la||(d(j.$$.fragment,e),d(C.$$.fragment,e),d(E.$$.fragment,e),d(R.$$.fragment,e),d($.$$.fragment,e),d(W.$$.fragment,e),d(Z.$$.fragment,e),d(_.$$.fragment,e),d(L.$$.fragment,e),d(A.$$.fragment,e),d(O.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(me.$$.fragment,e),d(ue.$$.fragment,e),d(Te.$$.fragment,e),d(fe.$$.fragment,e),d(Je.$$.fragment,e),d(je.$$.fragment,e),d(ke.$$.fragment,e),d(Se.$$.fragment,e),d(Ce.$$.fragment,e),d(Ge.$$.fragment,e),d(He.$$.fragment,e),d(Fe.$$.fragment,e),d(Qe.$$.fragment,e),d(qe.$$.fragment,e),d(Oe.$$.fragment,e),d(Ke.$$.fragment,e),d(tt.$$.fragment,e),la=!0)},o(e){m(j.$$.fragment,e),m(C.$$.fragment,e),m(E.$$.fragment,e),m(R.$$.fragment,e),m($.$$.fragment,e),m(W.$$.fragment,e),m(Z.$$.fragment,e),m(_.$$.fragment,e),m(L.$$.fragment,e),m(A.$$.fragment,e),m(O.$$.fragment,e),m(pe.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(ue.$$.fragment,e),m(Te.$$.fragment,e),m(fe.$$.fragment,e),m(Je.$$.fragment,e),m(je.$$.fragment,e),m(ke.$$.fragment,e),m(Se.$$.fragment,e),m(Ce.$$.fragment,e),m(Ge.$$.fragment,e),m(He.$$.fragment,e),m(Fe.$$.fragment,e),m(Qe.$$.fragment,e),m(qe.$$.fragment,e),m(Oe.$$.fragment,e),m(Ke.$$.fragment,e),m(tt.$$.fragment,e),la=!1},d(e){e&&(s(ct),s(ot),s(dt),s(mt),s(I),s(Mt),s(k),s(ut),s(v),s(yt),s(S),s(wt),s(B),s(Tt),s(Ut),s(x),s(ft),s(gt),s(G),s(Jt),s(bt),s(V),s(jt),s(It),s(H),s(kt),s(vt),s(F),s(St),s(Bt),s(N),s(Ct),s(xt),s(Y),s(Et),s(Gt),s(Q),s(Rt),s(Vt),s(q),s($t),s(X),s(Ht),s(z),s(Wt),s(P),s(Ft),s(Zt),s(D),s(Nt),s(K),s(_t),s(ee),s(Yt),s(te),s(Lt),s(se),s(Qt),s(ae),s(At),s(le),s(qt),s(ne),s(Xt),s(ie),s(zt),s(oe),s(Pt),s(re),s(Ot),s(Dt),s(he),s(Kt),s(es),s(de),s(ts),s(ss),s(Me),s(as),s(ls),s(ye),s(ns),s(we),s(is),s(os),s(Ue),s(rs),s(ps),s(ge),s(hs),s(cs),s(be),s(ds),s(ms),s(Ie),s(Ms),s(us),s(ve),s(ys),s(ws),s(Be),s(Ts),s(Us),s(xe),s(fs),s(Ee),s(gs),s(Js),s(Re),s(bs),s(Ve),s(js),s($e),s(Is),s(ks),s(We),s(vs),s(Ss),s(Ze),s(Bs),s(Ne),s(Cs),s(_e),s(xs),s(f),s(Es),s(y),s(Ns),s(Ye),s(_s),s(Le),s(Ys),s(Ls),s(Ae),s(Qs),s(As),s(Xe),s(qs),s(ze),s(Xs),s(Pe),s(zs),s(Ps),s(De),s(Os),s(Ds),s(et),s(Ks),s(ea),s(st),s(ta),s(at),s(sa),s(lt),s(aa),s(rt)),s(U),M(j,e),M(C,e),M(E,e),M(R,e),M($,e),M(W,e),M(Z,e),M(_,e),M(L,e),M(A,e),M(O,e),M(pe,e),M(ce,e),M(me,e),M(ue,e),M(Te,e),M(fe,e),M(Je,e),M(je,e),M(ke,e),M(Se,e),M(Ce,e),M(Ge,e),M(He,e),M(Fe,e),M(Qe,e),M(qe,e),M(Oe,e),M(Ke,e),M(tt,e)}}}const Gl='{"title":"Pre-trained models for automatic speech recognition","local":"pre-trained-models-for-automatic-speech-recognition","sections":[{"title":"Probing CTC Models","local":"probing-ctc-models","sections":[],"depth":2},{"title":"Graduation to Seq2Seq","local":"graduation-to-seq2seq","sections":[],"depth":2},{"title":"Long-Form Transcription and Timestamps","local":"long-form-transcription-and-timestamps","sections":[],"depth":2},{"title":"Summary","local":"summary","sections":[],"depth":2}],"depth":1}';function Rl(da){return Sl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fl extends Bl{constructor(U){super(),Cl(this,U,Rl,El,kl,{})}}export{Fl as component};
