import{s as Qs,n as Ys,o as Xs}from"../chunks/scheduler.7bc62968.js";import{S as Zs,i as se,g as n,s as i,r as R,m as ws,H as Os,A as ee,h as l,f as t,c as r,j as S,u as U,x as o,n as xs,B as Fs,k as Bs,y as m,a,v as O,d as F,t as B,w as J}from"../chunks/index.2f8492b0.js";import{H as K}from"../chunks/Heading.14fb2476.js";function te(Ls){let c,Q,q,Y,u,X,f,Z,v,zs='Generative Adversarial Networks (GANs) are a class of deep learning models introduced by <a href="https://scholar.google.ca/citations?user=iYN86KEAAAAJ&amp;hl=en" rel="nofollow">Ian Goodfellow</a> and his colleagues in 2014. The core idea behind GANs is to train a generator network to produce data that is indistinguishable from real data, while simultaneously training a discriminator network to differentiate between real and generated data.',ss,p,C,Cs="<strong>Architecture overview:</strong> GANs consist of two main components: <code>the generator</code> and <code>the discriminator</code>",As,g,E,Es="Generator:",ks,es,Js='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>z</mi></mrow><annotation encoding="application/x-tex">z</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4306em;"></span><span class="mord mathnormal" style="margin-right:0.04398em;">z</span></span></span></span>',ts,_s,M,Ms="<strong>Discriminator:</strong> The discriminator, akin to a detective, evaluates whether a given sample is real (from the actual dataset) or fake (generated by the generator). Its objective is to become increasingly accurate in distinguishing between real and generated samples.",as,y,Ns="A common analogy that can be found online is that of an art forger/painter (the generator) which tries to forge paintings and an art investigator/critic (the discriminator) which tries to detect limitations.",ns,b,Hs='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/generative_models/GAN.png" alt="Lilian Weng GAN Figure"/>',is,w,ls,x,Is="GANs and VAEs are both popular generative models in machine learning, but they have different strengths and weaknesses. Whether one is “better” depends on the specific task and requirements. Here’s a breakdown of their strengths and weaknesses.",rs,A,Ds=`<li><strong>Image Generation:</strong><ul><li><strong>GANs:</strong><ul><li><strong>Strengths:</strong> Generate higher quality images, especially for complex data with sharp details and realistic textures.</li> <li><strong>Weaknesses:</strong> Can be more difficult to train and prone to instability.</li> <li><strong>Example:</strong> A GAN-generated image of a bedroom is likely to be indistinguishable from a real one, while a VAE-generated bedroom might appear blurry or have unrealistic lighting.
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/generative_models/bedroom.png" alt="Example of GAN-Generated bedrooms taken from Unsupervised Representation Learning with Deep Convolutional Generative Adversarial Networks, 2015"/></li></ul></li> <li><strong>VAEs:</strong><ul><li><strong>Strengths:</strong> Easier to train and more stable than GANs</li> <li><strong>Weaknesses:</strong> May generate blurry, less detailed images with unrealistic features.</li></ul></li></ul></li> <li><strong>Other Tasks:</strong><ul><li><strong>GANs:</strong><ul><li><strong>Strengths:</strong> Can be used for tasks like super-resolution and image-to-image translation.</li> <li><strong>Weaknesses:</strong> May not be the best choice for tasks that require a smooth transition between data points</li></ul></li> <li><strong>VAEs:</strong><ul><li><strong>Strengths:</strong> Widely used for tasks like image denoising and anomaly detection.</li> <li><strong>Weaknesses:</strong> May not be as effective as GANs for tasks that require high-quality image generation.</li></ul></li></ul></li>`,ms,k,Ps="Here’s a table summarizing the key differences:",os,_,Ss="<thead><tr><th>Feature</th> <th>GANs</th> <th>VAEs</th></tr></thead> <tbody><tr><td>Image Quality</td> <td>Higher</td> <td>Lower</td></tr> <tr><td>Ease of Training</td> <td>More difficult</td> <td>Easier</td></tr> <tr><td>Stability</td> <td>Less Stable</td> <td>More Stable</td></tr> <tr><td>Applications</td> <td>Image Generation, Super-resolution, image-to-image translation</td> <td>Image Denoising, Anamoly Detection, Signal Analysis</td></tr></tbody>",ps,T,qs="Ultimately, the best choice depends on one’s specific needs and priorities. If one needs high-quality images for tasks like generating realistic faces or landscapes, then a GAN might be the better choice. However, if one needs a model that is easier to train and more stable, then a VAE might be a better option.",hs,G,cs,$,Vs="Training GANs involves a unique adversarial process where the generator and discriminator play a cat-and-mouse game.",gs,h,N,Ws="<strong>Adversarial Training Process:</strong> The generator and discriminator are trained simultaneously. The generator aims to produce data that is indistinguishable from real data, while the discriminator strives to improve its ability to differentiate between real and fake samples.",Ts,d,H,js="Objective Function:",Gs,ds,Ks='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><munder><mrow><mi>min</mi><mo>⁡</mo></mrow><mi>G</mi></munder><munder><mrow><mi>max</mi><mo>⁡</mo></mrow><mi>D</mi></munder><mi>L</mi><mo stretchy="false">(</mo><mi>D</mi><mo separator="true">,</mo><mi>G</mi><mo stretchy="false">)</mo><mo>=</mo><msub><mi mathvariant="double-struck">E</mi><mrow><mi>x</mi><mo>∼</mo><msub><mi>p</mi><mi>r</mi></msub><mo stretchy="false">(</mo><mi>x</mi><mo stretchy="false">)</mo></mrow></msub><mo stretchy="false">[</mo><mi>log</mi><mo>⁡</mo><mi>D</mi><mo stretchy="false">(</mo><mi>x</mi><mo stretchy="false">)</mo><mo stretchy="false">]</mo><mo>+</mo><msub><mi mathvariant="double-struck">E</mi><mrow><mi>x</mi><mo>∼</mo><msub><mi>p</mi><mi>g</mi></msub><mo stretchy="false">(</mo><mi>x</mi><mo stretchy="false">)</mo></mrow></msub><mo stretchy="false">[</mo><mi>log</mi><mo>⁡</mo><mo stretchy="false">(</mo><mn>1</mn><mo>−</mo><mi>D</mi><mo stretchy="false">(</mo><mi>x</mi><mo stretchy="false">)</mo><mo stretchy="false">)</mo><mo stretchy="false">]</mo></mrow><annotation encoding="application/x-tex">\\min_G \\max_D L(D, G)=\\mathbb{E}_{x \\sim p_{r}(x)} [\\log D(x)] + \\mathbb{E}_{x \\sim p_g(x)} [\\log(1 - D(x))]</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.4943em;vertical-align:-0.7443em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6679em;"><span style="top:-2.3557em;margin-left:0em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">G</span></span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span><span class="mop">min</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.7443em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.4306em;"><span style="top:-2.3557em;margin-left:0em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">D</span></span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span><span class="mop">max</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.7443em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">L</span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.02778em;">D</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">G</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.1052em;vertical-align:-0.3552em;"></span><span class="mord"><span class="mord mathbb">E</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3448em;"><span style="top:-2.5198em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">x</span><span class="mrel mtight">∼</span><span class="mord mtight"><span class="mord mathnormal mtight">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1645em;"><span style="top:-2.357em;margin-left:0em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">r</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.143em;"><span></span></span></span></span></span></span><span class="mopen mtight">(</span><span class="mord mathnormal mtight">x</span><span class="mclose mtight">)</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3552em;"><span></span></span></span></span></span></span><span class="mopen">[</span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">D</span><span class="mopen">(</span><span class="mord mathnormal">x</span><span class="mclose">)]</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1275em;vertical-align:-0.3775em;"></span><span class="mord"><span class="mord mathbb">E</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3448em;"><span style="top:-2.5198em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">x</span><span class="mrel mtight">∼</span><span class="mord mtight"><span class="mord mathnormal mtight">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1645em;"><span style="top:-2.357em;margin-left:0em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">g</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2819em;"><span></span></span></span></span></span></span><span class="mopen mtight">(</span><span class="mord mathnormal mtight">x</span><span class="mclose mtight">)</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3775em;"><span></span></span></span></span></span></span><span class="mopen">[</span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mopen">(</span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">D</span><span class="mopen">(</span><span class="mord mathnormal">x</span><span class="mclose">))]</span></span></span></span></span>',us,$s,I,Rs="<strong>Iterative Improvement:</strong> As training progresses, the generator becomes adept at producing realistic samples, and the discriminator becomes more discerning. This adversarial loop continues until the generator generates data that is virtually indistinguishable from real data.",fs,L,vs,z,Us='<li><a href="https://lilianweng.github.io/posts/2017-08-20-gan/" rel="nofollow">Lilian Weng’s Awesome Blog on GANs</a></li> <li><a href="https://jonathan-hui.medium.com/gan-whats-generative-adversarial-networks-and-its-application-f39ed278ef09" rel="nofollow">GAN — What is Generative Adversarial Networks</a></li> <li><a href="https://ai.stackexchange.com/questions/25601/what-are-the-fundamental-differences-between-vae-and-gan-for-image-generation" rel="nofollow">What are the fundamental differences between VAE and GAN for image generation?</a></li> <li><a href="https://stats.stackexchange.com/questions/541775/issues-with-gan-and-vae-models" rel="nofollow">Issues with GAN and VAE models</a></li> <li><a href="https://www.baeldung.com/cs/vae-vs-gan-image-generation" rel="nofollow">VAE Vs. GAN For Image Generation</a></li> <li><a href="https://towardsai.net/p/machine-learning/diffusion-models-vs-gans-vs-vaes-comparison-of-deep-generative-models" rel="nofollow">Diffusion Models vs. GANs vs. VAEs: Comparison of Deep Generative Models</a></li>',ys,V,bs;return u=new K({props:{title:"Generative Adversarial Networks",local:"generative-adversarial-networks",headingTag:"h1"}}),f=new K({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),w=new K({props:{title:"GANs vs VAEs",local:"gans-vs-vaes",headingTag:"h2"}}),G=new K({props:{title:"Training GANs",local:"training-gans",headingTag:"h2"}}),L=new K({props:{title:"References:",local:"references",headingTag:"h2"}}),{c(){c=n("meta"),Q=i(),q=n("p"),Y=i(),R(u.$$.fragment),X=i(),R(f.$$.fragment),Z=i(),v=n("p"),v.innerHTML=zs,ss=i(),p=n("ul"),C=n("li"),C.innerHTML=Cs,As=i(),g=n("li"),E=n("strong"),E.textContent=Es,ks=ws(" The generator takes random noise"),es=new Os(!1),ts=ws(" as input and generates synthetic data samples. Its goal is to create data that is realistic enough to deceive the discriminator."),_s=i(),M=n("li"),M.innerHTML=Ms,as=i(),y=n("p"),y.textContent=Ns,ns=i(),b=n("p"),b.innerHTML=Hs,is=i(),R(w.$$.fragment),ls=i(),x=n("p"),x.textContent=Is,rs=i(),A=n("ul"),A.innerHTML=Ds,ms=i(),k=n("p"),k.textContent=Ps,os=i(),_=n("table"),_.innerHTML=Ss,ps=i(),T=n("p"),T.textContent=qs,hs=i(),R(G.$$.fragment),cs=i(),$=n("p"),$.textContent=Vs,gs=i(),h=n("ul"),N=n("li"),N.innerHTML=Ws,Ts=i(),d=n("li"),H=n("strong"),H.textContent=js,Gs=ws(" The training process is guided by a min-max game type objective function which is used to optimize both the generator and the discriminator. The generator aims to minimize the probability of the discriminator correctly classifying generated samples as fake, while the discriminator seeks to maximize this probability. This objective function is represented as:"),ds=new Os(!1),us=ws(`
Here, the discriminator tries to maximize this loss function whereas the generator tries to minimize it, hence the adversarial nature.`),$s=i(),I=n("li"),I.innerHTML=Rs,fs=i(),R(L.$$.fragment),vs=i(),z=n("ol"),z.innerHTML=Us,ys=i(),V=n("p"),this.h()},l(s){const e=ee("svelte-u9bgzb",document.head);c=l(e,"META",{name:!0,content:!0}),e.forEach(t),Q=r(s),q=l(s,"P",{}),S(q).forEach(t),Y=r(s),U(u.$$.fragment,s),X=r(s),U(f.$$.fragment,s),Z=r(s),v=l(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1vteoh7"&&(v.innerHTML=zs),ss=r(s),p=l(s,"UL",{});var D=S(p);C=l(D,"LI",{"data-svelte-h":!0}),o(C)!=="svelte-x2mu2f"&&(C.innerHTML=Cs),As=r(D),g=l(D,"LI",{});var W=S(g);E=l(W,"STRONG",{"data-svelte-h":!0}),o(E)!=="svelte-1gdtcpl"&&(E.textContent=Es),ks=xs(W," The generator takes random noise"),es=Fs(W,!1),ts=xs(W," as input and generates synthetic data samples. Its goal is to create data that is realistic enough to deceive the discriminator."),W.forEach(t),_s=r(D),M=l(D,"LI",{"data-svelte-h":!0}),o(M)!=="svelte-e07c60"&&(M.innerHTML=Ms),D.forEach(t),as=r(s),y=l(s,"P",{"data-svelte-h":!0}),o(y)!=="svelte-1hb8plt"&&(y.textContent=Ns),ns=r(s),b=l(s,"P",{"data-svelte-h":!0}),o(b)!=="svelte-14zw7rg"&&(b.innerHTML=Hs),is=r(s),U(w.$$.fragment,s),ls=r(s),x=l(s,"P",{"data-svelte-h":!0}),o(x)!=="svelte-ryo7sn"&&(x.textContent=Is),rs=r(s),A=l(s,"UL",{"data-svelte-h":!0}),o(A)!=="svelte-6a5dty"&&(A.innerHTML=Ds),ms=r(s),k=l(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1anp2nv"&&(k.textContent=Ps),os=r(s),_=l(s,"TABLE",{"data-svelte-h":!0}),o(_)!=="svelte-qvoxqx"&&(_.innerHTML=Ss),ps=r(s),T=l(s,"P",{"data-svelte-h":!0}),o(T)!=="svelte-9mfent"&&(T.textContent=qs),hs=r(s),U(G.$$.fragment,s),cs=r(s),$=l(s,"P",{"data-svelte-h":!0}),o($)!=="svelte-hlrzgj"&&($.textContent=Vs),gs=r(s),h=l(s,"UL",{});var P=S(h);N=l(P,"LI",{"data-svelte-h":!0}),o(N)!=="svelte-113ifpr"&&(N.innerHTML=Ws),Ts=r(P),d=l(P,"LI",{});var j=S(d);H=l(j,"STRONG",{"data-svelte-h":!0}),o(H)!=="svelte-1vgqxfx"&&(H.textContent=js),Gs=xs(j," The training process is guided by a min-max game type objective function which is used to optimize both the generator and the discriminator. The generator aims to minimize the probability of the discriminator correctly classifying generated samples as fake, while the discriminator seeks to maximize this probability. This objective function is represented as:"),ds=Fs(j,!1),us=xs(j,`
Here, the discriminator tries to maximize this loss function whereas the generator tries to minimize it, hence the adversarial nature.`),j.forEach(t),$s=r(P),I=l(P,"LI",{"data-svelte-h":!0}),o(I)!=="svelte-w0fr8a"&&(I.innerHTML=Rs),P.forEach(t),fs=r(s),U(L.$$.fragment,s),vs=r(s),z=l(s,"OL",{"data-svelte-h":!0}),o(z)!=="svelte-1mdhw80"&&(z.innerHTML=Us),ys=r(s),V=l(s,"P",{}),S(V).forEach(t),this.h()},h(){Bs(c,"name","hf:doc:metadata"),Bs(c,"content",ae),es.a=ts,ds.a=us},m(s,e){m(document.head,c),a(s,Q,e),a(s,q,e),a(s,Y,e),O(u,s,e),a(s,X,e),O(f,s,e),a(s,Z,e),a(s,v,e),a(s,ss,e),a(s,p,e),m(p,C),m(p,As),m(p,g),m(g,E),m(g,ks),es.m(Js,g),m(g,ts),m(p,_s),m(p,M),a(s,as,e),a(s,y,e),a(s,ns,e),a(s,b,e),a(s,is,e),O(w,s,e),a(s,ls,e),a(s,x,e),a(s,rs,e),a(s,A,e),a(s,ms,e),a(s,k,e),a(s,os,e),a(s,_,e),a(s,ps,e),a(s,T,e),a(s,hs,e),O(G,s,e),a(s,cs,e),a(s,$,e),a(s,gs,e),a(s,h,e),m(h,N),m(h,Ts),m(h,d),m(d,H),m(d,Gs),ds.m(Ks,d),m(d,us),m(h,$s),m(h,I),a(s,fs,e),O(L,s,e),a(s,vs,e),a(s,z,e),a(s,ys,e),a(s,V,e),bs=!0},p:Ys,i(s){bs||(F(u.$$.fragment,s),F(f.$$.fragment,s),F(w.$$.fragment,s),F(G.$$.fragment,s),F(L.$$.fragment,s),bs=!0)},o(s){B(u.$$.fragment,s),B(f.$$.fragment,s),B(w.$$.fragment,s),B(G.$$.fragment,s),B(L.$$.fragment,s),bs=!1},d(s){s&&(t(Q),t(q),t(Y),t(X),t(Z),t(v),t(ss),t(p),t(as),t(y),t(ns),t(b),t(is),t(ls),t(x),t(rs),t(A),t(ms),t(k),t(os),t(_),t(ps),t(T),t(hs),t(cs),t($),t(gs),t(h),t(fs),t(vs),t(z),t(ys),t(V)),t(c),J(u,s),J(f,s),J(w,s),J(G,s),J(L,s)}}}const ae='{"title":"Generative Adversarial Networks","local":"generative-adversarial-networks","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"GANs vs VAEs","local":"gans-vs-vaes","sections":[],"depth":2},{"title":"Training GANs","local":"training-gans","sections":[],"depth":2},{"title":"References:","local":"references","sections":[],"depth":2}],"depth":1}';function ne(Ls){return Xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class me extends Zs{constructor(c){super(),se(this,c,ne,te,Qs,{})}}export{me as component};
