import{s as Zs,n as ks,o as Bs}from"../chunks/scheduler.85c25b89.js";import{S as $s,i as Gs,g as p,s as a,r as m,A as Ns,h as i,f as t,c as n,j as Is,u as o,x as M,k as Cs,y as Ws,a as e,v as c,d as r,t as h,w as J}from"../chunks/index.c9837788.js";import{C as Q}from"../chunks/CodeBlock.52fa569e.js";import{H as X}from"../chunks/Heading.3097d2ed.js";function xs(hs){let y,Y,V,_,j,S,w,Js='<strong>Inception v3</strong> is a convolutional neural network architecture from the Inception family that makes several improvements including using <a href="https://paperswithcode.com/method/label-smoothing" rel="nofollow">Label Smoothing</a>, Factorized 7 x 7 convolutions, and the use of an <a href="https://paperswithcode.com/method/auxiliary-classifier" rel="nofollow">auxiliary classifer</a> to propagate label information lower down the network (along with the use of batch normalization for layers in the sidehead). The key building block is an <a href="https://paperswithcode.com/method/inception-v3-module" rel="nofollow">Inception Module</a>.',z,T,ys='The weights from this model were ported from <a href="https://cv.gluon.ai/model_zoo/classification.html" rel="nofollow">Gluon</a>.',H,g,F,d,js="To load a pretrained model:",L,u,D,U,ws="To load and preprocess the image:",q,b,P,f,Ts="To get the model predictions:",K,I,O,C,gs="To get the top-5 predictions class names:",ss,Z,ls,k,ds="Replace the model name with the variant you want to use, e.g. <code>gluon_inception_v3</code>. You can find the IDs in the model summaries at the top of this page.",ts,B,us='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',es,$,as,G,Us="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ns,N,ps,W,bs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,is,x,ms,v,fs='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',os,A,Ms,E,cs,R,rs;return j=new X({props:{title:"(Gluon) Inception v3",local:"gluon-inception-v3",headingTag:"h1"}}),g=new X({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2dsdW9uX2luY2VwdGlvbl92MyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_inception_v3&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),$=new X({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZ2x1b25faW5jZXB0aW9uX3YzJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_inception_v3&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new X({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),A=new X({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new Q({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZTemVnZWR5VklTVzE1JTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCQ2hyaXN0aWFuJTIwU3plZ2VkeSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFZpbmNlbnQlMjBWYW5ob3Vja2UlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTZXJnZXklMjBJb2ZmZSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEpvbmF0aG9uJTIwU2hsZW5zJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwWmJpZ25pZXclMjBXb2puYSU3RCUyQyUwQSUyMCUyMHRpdGxlJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCUmV0aGlua2luZyUyMHRoZSUyMEluY2VwdGlvbiUyMEFyY2hpdGVjdHVyZSUyMGZvciUyMENvbXB1dGVyJTIwVmlzaW9uJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUyMCUyMCUzRCUyMCU3QkNvUlIlN0QlMkMlMEElMjAlMjB2b2x1bWUlMjAlMjAlMjAlMjAlM0QlMjAlN0JhYnMlMkYxNTEyLjAwNTY3JTdEJTJDJTBBJTIwJTIweWVhciUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QjIwMTUlN0QlMkMlMEElMjAlMjB1cmwlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwJTNBJTJGJTJGYXJ4aXYub3JnJTJGYWJzJTJGMTUxMi4wMDU2NyU3RCUyQyUwQSUyMCUyMGFyY2hpdmVQcmVmaXglMjAlM0QlMjAlN0JhclhpdiU3RCUyQyUwQSUyMCUyMGVwcmludCUyMCUyMCUyMCUyMCUzRCUyMCU3QjE1MTIuMDA1NjclN0QlMkMlMEElMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjAlN0JNb24lMkMlMjAxMyUyMEF1ZyUyMDIwMTglMjAxNiUzQTQ5JTNBMDclMjAlMkIwMjAwJTdEJTJDJTBBJTIwJTIwYmlidXJsJTIwJTIwJTIwJTIwJTNEJTIwJTdCaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyUyRnJlYyUyRmpvdXJuYWxzJTJGY29yciUyRlN6ZWdlZHlWSVNXMTUuYmliJTdEJTJDJTBBJTIwJTIwYmlic291cmNlJTIwJTNEJTIwJTdCZGJscCUyMGNvbXB1dGVyJTIwc2NpZW5jZSUyMGJpYmxpb2dyYXBoeSUyQyUyMGh0dHBzJTNBJTJGJTJGZGJscC5vcmclN0QlMEElN0Q=",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>SzegedyVISW15,
  author    = {Christian Szegedy and
               Vincent Vanhoucke and
               Sergey Ioffe and
               Jonathon Shlens and
               Zbigniew Wojna},
  title     = {Rethinking the Inception Architecture <span class="hljs-keyword">for</span> Computer Vision},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1512.00567</span>},
  year      = {<span class="hljs-number">2015</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1512.00567</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1512.00567</span>},
  timestamp = {Mon, <span class="hljs-number">13</span> Aug <span class="hljs-number">2018</span> <span class="hljs-number">16</span>:<span class="hljs-number">49</span>:<span class="hljs-number">07</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>SzegedyVISW15.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),{c(){y=p("meta"),Y=a(),V=p("p"),_=a(),m(j.$$.fragment),S=a(),w=p("p"),w.innerHTML=Js,z=a(),T=p("p"),T.innerHTML=ys,H=a(),m(g.$$.fragment),F=a(),d=p("p"),d.textContent=js,L=a(),m(u.$$.fragment),D=a(),U=p("p"),U.textContent=ws,q=a(),m(b.$$.fragment),P=a(),f=p("p"),f.textContent=Ts,K=a(),m(I.$$.fragment),O=a(),C=p("p"),C.textContent=gs,ss=a(),m(Z.$$.fragment),ls=a(),k=p("p"),k.innerHTML=ds,ts=a(),B=p("p"),B.innerHTML=us,es=a(),m($.$$.fragment),as=a(),G=p("p"),G.textContent=Us,ns=a(),m(N.$$.fragment),ps=a(),W=p("p"),W.innerHTML=bs,is=a(),m(x.$$.fragment),ms=a(),v=p("p"),v.innerHTML=fs,os=a(),m(A.$$.fragment),Ms=a(),m(E.$$.fragment),cs=a(),R=p("p"),this.h()},l(s){const l=Ns("svelte-u9bgzb",document.head);y=i(l,"META",{name:!0,content:!0}),l.forEach(t),Y=n(s),V=i(s,"P",{}),Is(V).forEach(t),_=n(s),o(j.$$.fragment,s),S=n(s),w=i(s,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1q7bbkg"&&(w.innerHTML=Js),z=n(s),T=i(s,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1vag5uc"&&(T.innerHTML=ys),H=n(s),o(g.$$.fragment,s),F=n(s),d=i(s,"P",{"data-svelte-h":!0}),M(d)!=="svelte-18ywhxh"&&(d.textContent=js),L=n(s),o(u.$$.fragment,s),D=n(s),U=i(s,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1c2ipa8"&&(U.textContent=ws),q=n(s),o(b.$$.fragment,s),P=n(s),f=i(s,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1n9qsq1"&&(f.textContent=Ts),K=n(s),o(I.$$.fragment,s),O=n(s),C=i(s,"P",{"data-svelte-h":!0}),M(C)!=="svelte-19cnvx1"&&(C.textContent=gs),ss=n(s),o(Z.$$.fragment,s),ls=n(s),k=i(s,"P",{"data-svelte-h":!0}),M(k)!=="svelte-t399n1"&&(k.innerHTML=ds),ts=n(s),B=i(s,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1wmi3ea"&&(B.innerHTML=us),es=n(s),o($.$$.fragment,s),as=n(s),G=i(s,"P",{"data-svelte-h":!0}),M(G)!=="svelte-9sr7nh"&&(G.textContent=Us),ns=n(s),o(N.$$.fragment,s),ps=n(s),W=i(s,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1kguc51"&&(W.innerHTML=bs),is=n(s),o(x.$$.fragment,s),ms=n(s),v=i(s,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1n0coha"&&(v.innerHTML=fs),os=n(s),o(A.$$.fragment,s),Ms=n(s),o(E.$$.fragment,s),cs=n(s),R=i(s,"P",{}),Is(R).forEach(t),this.h()},h(){Cs(y,"name","hf:doc:metadata"),Cs(y,"content",vs)},m(s,l){Ws(document.head,y),e(s,Y,l),e(s,V,l),e(s,_,l),c(j,s,l),e(s,S,l),e(s,w,l),e(s,z,l),e(s,T,l),e(s,H,l),c(g,s,l),e(s,F,l),e(s,d,l),e(s,L,l),c(u,s,l),e(s,D,l),e(s,U,l),e(s,q,l),c(b,s,l),e(s,P,l),e(s,f,l),e(s,K,l),c(I,s,l),e(s,O,l),e(s,C,l),e(s,ss,l),c(Z,s,l),e(s,ls,l),e(s,k,l),e(s,ts,l),e(s,B,l),e(s,es,l),c($,s,l),e(s,as,l),e(s,G,l),e(s,ns,l),c(N,s,l),e(s,ps,l),e(s,W,l),e(s,is,l),c(x,s,l),e(s,ms,l),e(s,v,l),e(s,os,l),c(A,s,l),e(s,Ms,l),c(E,s,l),e(s,cs,l),e(s,R,l),rs=!0},p:ks,i(s){rs||(r(j.$$.fragment,s),r(g.$$.fragment,s),r(u.$$.fragment,s),r(b.$$.fragment,s),r(I.$$.fragment,s),r(Z.$$.fragment,s),r($.$$.fragment,s),r(N.$$.fragment,s),r(x.$$.fragment,s),r(A.$$.fragment,s),r(E.$$.fragment,s),rs=!0)},o(s){h(j.$$.fragment,s),h(g.$$.fragment,s),h(u.$$.fragment,s),h(b.$$.fragment,s),h(I.$$.fragment,s),h(Z.$$.fragment,s),h($.$$.fragment,s),h(N.$$.fragment,s),h(x.$$.fragment,s),h(A.$$.fragment,s),h(E.$$.fragment,s),rs=!1},d(s){s&&(t(Y),t(V),t(_),t(S),t(w),t(z),t(T),t(H),t(F),t(d),t(L),t(D),t(U),t(q),t(P),t(f),t(K),t(O),t(C),t(ss),t(ls),t(k),t(ts),t(B),t(es),t(as),t(G),t(ns),t(ps),t(W),t(is),t(ms),t(v),t(os),t(Ms),t(cs),t(R)),t(y),J(j,s),J(g,s),J(u,s),J(b,s),J(I,s),J(Z,s),J($,s),J(N,s),J(x,s),J(A,s),J(E,s)}}}const vs='{"title":"(Gluon) Inception v3","local":"gluon-inception-v3","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function As(hs){return Bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xs extends $s{constructor(y){super(),Gs(this,y,As,xs,Zs,{})}}export{Xs as component};
