import{s as vs,n as Us,o as xs}from"../chunks/scheduler.85c25b89.js";import{S as $s,i as Cs,g as l,s as i,u as c,H as Is,A as _s,h as n,f as s,c as p,j as r,v as g,y as h,E as ks,k as m,o,a as e,w as d,d as w,t as y,x as u}from"../chunks/index.9633332f.js";import{I as ht}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function Ns(Lt){let M,ct,lt,gt,j,v,nt,I,Yt,q,Dt="RegNetX",dt,_,qt="<strong>RegNetX</strong> is a convolutional network design space with simple, regular models with parameters: depth $d$, initial width $w_{0} &gt; 0$, and slope $w_{a} &gt; 0$, and generates a different block width $u_{j}$ for each block $j &lt; d$. The key restriction for the RegNet types of model is that there is a linear parameterisation of block widths (the design space only contains models with this linear structure):",wt,K,yt,bs='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>j</mi><mo>=</mo><mi>w</mi><mi mathvariant="normal">_</mi><mn>0</mn><mo>+</mo><mi>w</mi><mi mathvariant="normal">_</mi><mi>a</mi><mo>⋅</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> u\\_{j} = w\\_{0} + w\\_{a}\\cdot{j} </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9695em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.9544em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02691em;">w</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord"><span class="mord">0</span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.7545em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02691em;">w</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord"><span class="mord mathnormal">a</span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">⋅</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span></span></span>',ut,k,Kt="For <strong>RegNetX</strong> we have additional restrictions: we set $b = 1$ (the bottleneck ratio), $12 \\leq d \\leq 28$, and $w_{m} \\geq 2$ (the width multiplier).",Mt,J,U,it,N,Xt,O,Ot="How do I use this model on an image?",jt,W,ts="To load a pretrained model:",Jt,Z,ft,E,ss="To load and preprocess the image:",Tt,B,bt,G,as="To get the model predictions:",vt,Q,Ut,R,es="To get the top-5 predictions class names:",xt,A,$t,S,ls="Replace the model name with the variant you want to use, e.g. <code>regnetx_002</code>. You can find the IDs in the model summaries at the top of this page.",Ct,V,ns='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',It,f,x,pt,H,zt,tt,is="How do I finetune this model?",_t,Y,ps="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",kt,X,Nt,z,ms=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Wt,T,$,mt,F,Ft,st,os="How do I train this model?",Zt,P,rs='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Et,b,C,ot,L,Pt,at,hs="Citation",Bt,D,Gt,rt,Qt;return I=new ht({}),N=new ht({}),Z=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3JlZ25ldHhfMDAyJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;regnetx_002&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),B=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),Q=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),A=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),H=new ht({}),X=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVnbmV0eF8wMDInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;regnetx_002&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),F=new ht({}),L=new ht({}),D=new et({props:{code:"JTQwbWlzYyU3QnJhZG9zYXZvdmljMjAyMGRlc2lnbmluZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCRGVzaWduaW5nJTIwTmV0d29yayUyMERlc2lnbiUyMFNwYWNlcyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QklsaWphJTIwUmFkb3Nhdm92aWMlMjBhbmQlMjBSYWolMjBQcmF0ZWVrJTIwS29zYXJhanUlMjBhbmQlMjBSb3NzJTIwR2lyc2hpY2slMjBhbmQlMjBLYWltaW5nJTIwSGUlMjBhbmQlMjBQaW90ciUyMERvbGwlQzMlQTFyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IyMDAzLjEzNjc4JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{radosavovic2020designing,
      title={Designing Network Design Spaces}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Ilija Radosavovic and Raj Prateek Kosaraju and Ross Girshick and Kaiming He and Piotr Dollár}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{2003.13678}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`}}),{c(){M=l("meta"),ct=i(),lt=l("p"),gt=i(),j=l("h1"),v=l("a"),nt=l("span"),c(I.$$.fragment),Yt=i(),q=l("span"),q.textContent=Dt,dt=i(),_=l("p"),_.innerHTML=qt,wt=i(),K=l("p"),yt=new Is(!1),ut=i(),k=l("p"),k.innerHTML=Kt,Mt=i(),J=l("h2"),U=l("a"),it=l("span"),c(N.$$.fragment),Xt=i(),O=l("span"),O.textContent=Ot,jt=i(),W=l("p"),W.textContent=ts,Jt=i(),c(Z.$$.fragment),ft=i(),E=l("p"),E.textContent=ss,Tt=i(),c(B.$$.fragment),bt=i(),G=l("p"),G.textContent=as,vt=i(),c(Q.$$.fragment),Ut=i(),R=l("p"),R.textContent=es,xt=i(),c(A.$$.fragment),$t=i(),S=l("p"),S.innerHTML=ls,Ct=i(),V=l("p"),V.innerHTML=ns,It=i(),f=l("h2"),x=l("a"),pt=l("span"),c(H.$$.fragment),zt=i(),tt=l("span"),tt.textContent=is,_t=i(),Y=l("p"),Y.textContent=ps,kt=i(),c(X.$$.fragment),Nt=i(),z=l("p"),z.innerHTML=ms,Wt=i(),T=l("h2"),$=l("a"),mt=l("span"),c(F.$$.fragment),Ft=i(),st=l("span"),st.textContent=os,Zt=i(),P=l("p"),P.innerHTML=rs,Et=i(),b=l("h2"),C=l("a"),ot=l("span"),c(L.$$.fragment),Pt=i(),at=l("span"),at.textContent=hs,Bt=i(),c(D.$$.fragment),Gt=i(),rt=l("p"),this.h()},l(t){const a=_s("svelte-1phssyn",document.head);M=n(a,"META",{name:!0,content:!0}),a.forEach(s),ct=p(t),lt=n(t,"P",{}),r(lt).forEach(s),gt=p(t),j=n(t,"H1",{class:!0});var Rt=r(j);v=n(Rt,"A",{id:!0,class:!0,href:!0});var cs=r(v);nt=n(cs,"SPAN",{});var gs=r(nt);g(I.$$.fragment,gs),gs.forEach(s),cs.forEach(s),Yt=p(Rt),q=n(Rt,"SPAN",{"data-svelte-h":!0}),h(q)!=="svelte-1dsjyhw"&&(q.textContent=Dt),Rt.forEach(s),dt=p(t),_=n(t,"P",{"data-svelte-h":!0}),h(_)!=="svelte-11cu0pz"&&(_.innerHTML=qt),wt=p(t),K=n(t,"P",{});var ds=r(K);yt=ks(ds,!1),ds.forEach(s),ut=p(t),k=n(t,"P",{"data-svelte-h":!0}),h(k)!=="svelte-mi3jox"&&(k.innerHTML=Kt),Mt=p(t),J=n(t,"H2",{class:!0});var At=r(J);U=n(At,"A",{id:!0,class:!0,href:!0});var ws=r(U);it=n(ws,"SPAN",{});var ys=r(it);g(N.$$.fragment,ys),ys.forEach(s),ws.forEach(s),Xt=p(At),O=n(At,"SPAN",{"data-svelte-h":!0}),h(O)!=="svelte-1c1hspn"&&(O.textContent=Ot),At.forEach(s),jt=p(t),W=n(t,"P",{"data-svelte-h":!0}),h(W)!=="svelte-18ywhxh"&&(W.textContent=ts),Jt=p(t),g(Z.$$.fragment,t),ft=p(t),E=n(t,"P",{"data-svelte-h":!0}),h(E)!=="svelte-1c2ipa8"&&(E.textContent=ss),Tt=p(t),g(B.$$.fragment,t),bt=p(t),G=n(t,"P",{"data-svelte-h":!0}),h(G)!=="svelte-1n9qsq1"&&(G.textContent=as),vt=p(t),g(Q.$$.fragment,t),Ut=p(t),R=n(t,"P",{"data-svelte-h":!0}),h(R)!=="svelte-19cnvx1"&&(R.textContent=es),xt=p(t),g(A.$$.fragment,t),$t=p(t),S=n(t,"P",{"data-svelte-h":!0}),h(S)!=="svelte-o836lw"&&(S.innerHTML=ls),Ct=p(t),V=n(t,"P",{"data-svelte-h":!0}),h(V)!=="svelte-1wmi3ea"&&(V.innerHTML=ns),It=p(t),f=n(t,"H2",{class:!0});var St=r(f);x=n(St,"A",{id:!0,class:!0,href:!0});var us=r(x);pt=n(us,"SPAN",{});var Ms=r(pt);g(H.$$.fragment,Ms),Ms.forEach(s),us.forEach(s),zt=p(St),tt=n(St,"SPAN",{"data-svelte-h":!0}),h(tt)!=="svelte-1viv4qv"&&(tt.textContent=is),St.forEach(s),_t=p(t),Y=n(t,"P",{"data-svelte-h":!0}),h(Y)!=="svelte-9sr7nh"&&(Y.textContent=ps),kt=p(t),g(X.$$.fragment,t),Nt=p(t),z=n(t,"P",{"data-svelte-h":!0}),h(z)!=="svelte-1kguc51"&&(z.innerHTML=ms),Wt=p(t),T=n(t,"H2",{class:!0});var Vt=r(T);$=n(Vt,"A",{id:!0,class:!0,href:!0});var js=r($);mt=n(js,"SPAN",{});var Js=r(mt);g(F.$$.fragment,Js),Js.forEach(s),js.forEach(s),Ft=p(Vt),st=n(Vt,"SPAN",{"data-svelte-h":!0}),h(st)!=="svelte-1ce591d"&&(st.textContent=os),Vt.forEach(s),Zt=p(t),P=n(t,"P",{"data-svelte-h":!0}),h(P)!=="svelte-1n0coha"&&(P.innerHTML=rs),Et=p(t),b=n(t,"H2",{class:!0});var Ht=r(b);C=n(Ht,"A",{id:!0,class:!0,href:!0});var fs=r(C);ot=n(fs,"SPAN",{});var Ts=r(ot);g(L.$$.fragment,Ts),Ts.forEach(s),fs.forEach(s),Pt=p(Ht),at=n(Ht,"SPAN",{"data-svelte-h":!0}),h(at)!=="svelte-15mb3gy"&&(at.textContent=hs),Ht.forEach(s),Bt=p(t),g(D.$$.fragment,t),Gt=p(t),rt=n(t,"P",{}),r(rt).forEach(s),this.h()},h(){m(M,"name","hf:doc:metadata"),m(M,"content",JSON.stringify(Ws)),m(v,"id","regnetx"),m(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(v,"href","#regnetx"),m(j,"class","relative group"),yt.a=null,m(U,"id","how-do-i-use-this-model-on-an-image"),m(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(U,"href","#how-do-i-use-this-model-on-an-image"),m(J,"class","relative group"),m(x,"id","how-do-i-finetune-this-model"),m(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(x,"href","#how-do-i-finetune-this-model"),m(f,"class","relative group"),m($,"id","how-do-i-train-this-model"),m($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m($,"href","#how-do-i-train-this-model"),m(T,"class","relative group"),m(C,"id","citation"),m(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(C,"href","#citation"),m(b,"class","relative group")},m(t,a){o(document.head,M),e(t,ct,a),e(t,lt,a),e(t,gt,a),e(t,j,a),o(j,v),o(v,nt),d(I,nt,null),o(j,Yt),o(j,q),e(t,dt,a),e(t,_,a),e(t,wt,a),e(t,K,a),yt.m(bs,K),e(t,ut,a),e(t,k,a),e(t,Mt,a),e(t,J,a),o(J,U),o(U,it),d(N,it,null),o(J,Xt),o(J,O),e(t,jt,a),e(t,W,a),e(t,Jt,a),d(Z,t,a),e(t,ft,a),e(t,E,a),e(t,Tt,a),d(B,t,a),e(t,bt,a),e(t,G,a),e(t,vt,a),d(Q,t,a),e(t,Ut,a),e(t,R,a),e(t,xt,a),d(A,t,a),e(t,$t,a),e(t,S,a),e(t,Ct,a),e(t,V,a),e(t,It,a),e(t,f,a),o(f,x),o(x,pt),d(H,pt,null),o(f,zt),o(f,tt),e(t,_t,a),e(t,Y,a),e(t,kt,a),d(X,t,a),e(t,Nt,a),e(t,z,a),e(t,Wt,a),e(t,T,a),o(T,$),o($,mt),d(F,mt,null),o(T,Ft),o(T,st),e(t,Zt,a),e(t,P,a),e(t,Et,a),e(t,b,a),o(b,C),o(C,ot),d(L,ot,null),o(b,Pt),o(b,at),e(t,Bt,a),d(D,t,a),e(t,Gt,a),e(t,rt,a),Qt=!0},p:Us,i(t){Qt||(w(I.$$.fragment,t),w(N.$$.fragment,t),w(Z.$$.fragment,t),w(B.$$.fragment,t),w(Q.$$.fragment,t),w(A.$$.fragment,t),w(H.$$.fragment,t),w(X.$$.fragment,t),w(F.$$.fragment,t),w(L.$$.fragment,t),w(D.$$.fragment,t),Qt=!0)},o(t){y(I.$$.fragment,t),y(N.$$.fragment,t),y(Z.$$.fragment,t),y(B.$$.fragment,t),y(Q.$$.fragment,t),y(A.$$.fragment,t),y(H.$$.fragment,t),y(X.$$.fragment,t),y(F.$$.fragment,t),y(L.$$.fragment,t),y(D.$$.fragment,t),Qt=!1},d(t){t&&(s(ct),s(lt),s(gt),s(j),s(dt),s(_),s(wt),s(K),s(ut),s(k),s(Mt),s(J),s(jt),s(W),s(Jt),s(ft),s(E),s(Tt),s(bt),s(G),s(vt),s(Ut),s(R),s(xt),s($t),s(S),s(Ct),s(V),s(It),s(f),s(_t),s(Y),s(kt),s(Nt),s(z),s(Wt),s(T),s(Zt),s(P),s(Et),s(b),s(Bt),s(Gt),s(rt)),s(M),u(I),u(N),u(Z,t),u(B,t),u(Q,t),u(A,t),u(H),u(X,t),u(F),u(L),u(D,t)}}}const Ws={local:"regnetx",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"RegNetX"};function Zs(Lt){return xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rs extends $s{constructor(M){super(),Cs(this,M,Zs,Ns,vs,{})}}export{Rs as component};
