import{s as qs,n as As,o as Ls}from"../chunks/scheduler.0219f8bd.js";import{S as Ds,i as Ks,g as r,s as t,r as p,A as Ps,h,f as a,c as e,j as zs,x as m,u as i,k as Qs,y as Os,a as n,v as c,d as M,t as J,w as o}from"../chunks/index.f61edf3b.js";import{C as d}from"../chunks/CodeBlock.38e566ae.js";import{H as j}from"../chunks/Heading.d33122ca.js";function sl(Ns){let y,P,D,O,T,Es='<br/> <picture><source media="(prefers-color-scheme: dark)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-dark.svg"/> <source media="(prefers-color-scheme: light)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg"/> <img alt="huggingface javascript library logo" src="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg" width="376" height="59" style="max-width: 100%;"/></picture> <br/> <br/>',ss,w,ls,g,as,u,Ys="This is a collection of JS libraries to interact with the Hugging Face API, with TS types included.",ns,U,Rs='<li><a href="inference/README">@huggingface/inference</a>: Use Inference Endpoints (serverless) to make calls to 100,000+ Machine Learning models</li> <li><a href="hub/README">@huggingface/hub</a>: Interact with huggingface.co to create or delete repos and commit / download files</li> <li><a href="agents/README">@huggingface/agents</a>: Interact with HF models through a natural language interface</li>',ts,f,Vs="We use modern features to avoid polyfills and dependencies, so the libraries will only work on modern browsers / Node.js >= 18 / Bun / Deno.",es,b,Ss="The libraries are still very young, please help us by opening issues!",ps,I,is,G,cs,Z,vs="To install via NPM, you can download the libraries as needed:",Ms,B,Js,k,xs="Then import the libraries in your code:",os,W,rs,C,hs,$,Fs='You can run our packages with vanilla JS, without any bundler, by using a CDN or static hosting. Using <a href="https://hacks.mozilla.org/2018/03/es-modules-a-cartoon-deep-dive/" rel="nofollow">ES modules</a>, i.e. <code>&lt;script type=&quot;module&quot;&gt;</code>, you can import the libraries in your code:',ms,Q,js,N,ds,E,ys,Y,Ts,R,Xs='Get your HF access token in your <a href="https://huggingface.co/settings/tokens" rel="nofollow">account settings</a>.',ws,V,gs,S,us,v,Us,x,fs,F,bs,X,Is,H,Hs="There are more features of course, check each library’s README!",Gs,_,Zs,z,Bs,q,ks,A,Ws,L,_s="This will generate ESM and CJS javascript files in <code>packages/*/dist</code>, eg <code>packages/inference/dist/index.mjs</code>.",Cs,K,$s;return w=new d({props:{code:"YXdhaXQlMjBpbmZlcmVuY2UudHJhbnNsYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAndDUtYmFzZSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnTXklMjBuYW1lJTIwaXMlMjBXb2xmZ2FuZyUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBCZXJsaW4nJTBBJTdEKSUwQSUwQWF3YWl0JTIwaGYudHJhbnNsYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTIyaG93JTIwaXMlMjB0aGUlMjB3ZWF0aGVyJTIwbGlrZSUyMGluJTIwR2Fib3JvbmUlMjIlMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTIwJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwc3JjX2xhbmclM0ElMjAlMjJlbmdfTGF0biUyMiUyQyUwQSUyMCUyMCUyMCUyMHRndF9sYW5nJTNBJTIwJTIyc290X0xhdG4lMjIlMEElMjAlMjAlN0QlMEElN0QpJTBBJTBBYXdhaXQlMjBpbmZlcmVuY2UudGV4dFRvSW1hZ2UoJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTInJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ2F3YXJkJTIwd2lubmluZyUyMGhpZ2glMjByZXNvbHV0aW9uJTIwcGhvdG8lMjBvZiUyMGElMjBnaWFudCUyMHRvcnRvaXNlJTJGKChsYWR5YmlyZCkpJTIwaHlicmlkJTJDJTIwJTVCdHJlbmRpbmclMjBvbiUyMGFydHN0YXRpb24lNUQnJTJDJTBBJTIwJTIwcGFyYW1ldGVycyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzQSUyMCdibHVycnknJTJDJTBBJTIwJTIwJTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;t5-base&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Wolfgang and I live in Berlin&#x27;</span>
})

<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;how is the weather like in Gaborone&quot;</span>,
  parameters : {
    <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&quot;eng_Latn&quot;</span>,
    <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&quot;sot_Latn&quot;</span>
  }
})

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;stabilityai/stable-diffusion-2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;award winning high resolution photo of a giant tortoise/((ladybird)) hybrid, [trending on artstation]&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">negative_prompt</span>: <span class="hljs-string">&#x27;blurry&#x27;</span>,
  }
})`,wrap:!1}}),g=new j({props:{title:"Hugging Face JS libraries",local:"hugging-face-js-libraries",headingTag:"h1"}}),I=new j({props:{title:"Installation",local:"installation",headingTag:"h2"}}),G=new j({props:{title:"From NPM",local:"from-npm",headingTag:"h3"}}),B=new d({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBbnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBbnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRz",highlighted:`npm install @huggingface/inference
npm install @huggingface/hub
npm install @huggingface/agents`,wrap:!1}}),W=new d({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEFpbXBvcnQlMjAlN0IlMjBIZkFnZW50JTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRzJTIyJTNCJTBBaW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMGNvbW1pdCUyQyUyMGRlbGV0ZVJlcG8lMkMlMjBsaXN0RmlsZXMlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEFpbXBvcnQlMjB0eXBlJTIwJTdCJTIwUmVwb0lkJTJDJTIwQ3JlZGVudGlhbHMlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0I=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents&quot;</span>;
<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoId</span>, <span class="hljs-title class_">Credentials</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;`,wrap:!1}}),C=new j({props:{title:"From CDN or Static hosting",local:"from-cdn-or-static-hosting",headingTag:"h3"}}),Q=new d({props:{code:"JTNDc2NyaXB0JTIwdHlwZSUzRCUyMm1vZHVsZSUyMiUzRSUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMCU3QiUyMEhmSW5mZXJlbmNlJTIwJTdEJTIwZnJvbSUyMCdodHRwcyUzQSUyRiUyRmNkbi5qc2RlbGl2ci5uZXQlMkZucG0lMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSU0MDIuNi40JTJGJTJCZXNtJyUzQiUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGY2RuLmpzZGVsaXZyLm5ldCUyRm5wbSUyRiU0MGh1Z2dpbmdmYWNlJTJGaHViJTQwMC4xMy4wJTJGJTJCZXNtJTIyJTNCJTBBJTNDJTJGc2NyaXB0JTNF",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">script</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;module&quot;</span>&gt;</span><span class="language-javascript">
    <span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;https://cdn.jsdelivr.net/npm/@huggingface/inference@2.6.4/+esm&#x27;</span>;
    <span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://cdn.jsdelivr.net/npm/@huggingface/hub@0.13.0/+esm&quot;</span>;
</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>`,wrap:!1}}),N=new j({props:{title:"Deno",local:"deno",headingTag:"h3"}}),E=new d({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMiUwQWltcG9ydCUyMCU3QiUyMEhmQWdlbnQlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQSUwQWltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMEhmSW5mZXJlbmNlJTIwJTdEJTIwZnJvbSUyMCUyMm5wbSUzQSU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTIyJTBBaW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQSUwQWltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMm5wbSUzQSU0MGh1Z2dpbmdmYWNlJTJGaHViJTIy",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/agents&quot;</span>;

<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/inference&quot;</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/agents&quot;</span>;

<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),Y=new j({props:{title:"Usage examples",local:"usage-examples",headingTag:"h2"}}),V=new j({props:{title:"@huggingface/inference examples",local:"huggingfaceinference-examples",headingTag:"h3"}}),S=new d({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEElMEFjb25zdCUyMEhGX1RPS0VOJTIwJTNEJTIwJTIyaGZfLi4uJTIyJTNCJTBBJTBBY29uc3QlMjBpbmZlcmVuY2UlMjAlM0QlMjBuZXclMjBIZkluZmVyZW5jZShIRl9UT0tFTiklM0IlMEElMEElMkYlMkYlMjBZb3UlMjBjYW4lMjBhbHNvJTIwb21pdCUyMCUyMm1vZGVsJTIyJTIwdG8lMjB1c2UlMjB0aGUlMjByZWNvbW1lbmRlZCUyMG1vZGVsJTIwZm9yJTIwdGhlJTIwdGFzayUwQWF3YWl0JTIwaW5mZXJlbmNlLnRyYW5zbGF0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ3Q1LWJhc2UnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ015JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQW1zdGVyZGFtJyUwQSU3RCklMEElMEFhd2FpdCUyMGluZmVyZW5jZS50ZXh0VG9JbWFnZSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnYXdhcmQlMjB3aW5uaW5nJTIwaGlnaCUyMHJlc29sdXRpb24lMjBwaG90byUyMG9mJTIwYSUyMGdpYW50JTIwdG9ydG9pc2UlMkYoKGxhZHliaXJkKSklMjBoeWJyaWQlMkMlMjAlNUJ0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiU1RCclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNBJTIwJ2JsdXJyeSclMkMlMEElMjAlMjAlN0QlMEElN0QpJTBBJTBBYXdhaXQlMjBpbmZlcmVuY2UuaW1hZ2VUb1RleHQoJTdCJTBBJTIwJTIwZGF0YSUzQSUyMGF3YWl0JTIwKGF3YWl0JTIwZmV0Y2goJ2h0dHBzJTNBJTJGJTJGcGljc3VtLnBob3RvcyUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMkMlMEElMjAlMjBtb2RlbCUzQSUyMCdubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyclMkMlMjAlMjAlMEElN0QpJTBBJTBBJTJGJTJGJTIwVXNpbmclMjB5b3VyJTIwb3duJTIwZGVkaWNhdGVkJTIwaW5mZXJlbmNlJTIwZW5kcG9pbnQlM0ElMjBodHRwcyUzQSUyRiUyRmhmLmNvJTJGZG9jcyUyRmluZmVyZW5jZS1lbmRwb2ludHMlMkYlMEFjb25zdCUyMGdwdDIlMjAlM0QlMjBpbmZlcmVuY2UuZW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGeHl6LmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZ3B0MicpJTNCJTBBY29uc3QlMjAlN0IlMjBnZW5lcmF0ZWRfdGV4dCUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ3B0Mi50ZXh0R2VuZXJhdGlvbiglN0JpbnB1dHMlM0ElMjAnVGhlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjB1bml2ZXJzZSUyMGlzJyU3RCklM0I=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">const</span> inference = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-variable constant_">HF_TOKEN</span>);

<span class="hljs-comment">// You can also omit &quot;model&quot; to use the recommended model for the task</span>
<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;t5-base&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Wolfgang and I live in Amsterdam&#x27;</span>
})

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;stabilityai/stable-diffusion-2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;award winning high resolution photo of a giant tortoise/((ladybird)) hybrid, [trending on artstation]&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">negative_prompt</span>: <span class="hljs-string">&#x27;blurry&#x27;</span>,
  }
})

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">imageToText</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://picsum.photos/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>(),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;nlpconnect/vit-gpt2-image-captioning&#x27;</span>,  
})

<span class="hljs-comment">// Using your own dedicated inference endpoint: https://hf.co/docs/inference-endpoints/</span>
<span class="hljs-keyword">const</span> gpt2 = inference.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>({<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>});`,wrap:!1}}),v=new j({props:{title:"@huggingface/agents example",local:"huggingfaceagents-example",headingTag:"h3"}}),x=new d({props:{code:"aW1wb3J0JTIwJTdCSGZBZ2VudCUyQyUyMExMTUZyb21IdWIlMkMlMjBkZWZhdWx0VG9vbHMlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRzJyUzQiUwQSUwQWNvbnN0JTIwSEZfVE9LRU4lMjAlM0QlMjAlMjJoZl8uLi4lMjIlM0IlMEElMEFjb25zdCUyMGFnZW50JTIwJTNEJTIwbmV3JTIwSGZBZ2VudCglMEElMjAlMjBIRl9UT0tFTiUyQyUwQSUyMCUyMExMTUZyb21IdWIoSEZfVE9LRU4pJTJDJTBBJTIwJTIwJTVCLi4uZGVmYXVsdFRvb2xzJTVEJTBBKSUzQiUwQSUwQSUwQSUyRiUyRiUyMHlvdSUyMGNhbiUyMGdlbmVyYXRlJTIwdGhlJTIwY29kZSUyQyUyMGluc3BlY3QlMjBpdCUyMGFuZCUyMHRoZW4lMjBydW4lMjBpdCUwQWNvbnN0JTIwY29kZSUyMCUzRCUyMGF3YWl0JTIwYWdlbnQuZ2VuZXJhdGVDb2RlKCUyMkRyYXclMjBhJTIwcGljdHVyZSUyMG9mJTIwYSUyMGNhdCUyMHdlYXJpbmclMjBhJTIwdG9wJTIwaGF0LiUyMFRoZW4lMjBjYXB0aW9uJTIwdGhlJTIwcGljdHVyZSUyMGFuZCUyMHJlYWQlMjBpdCUyMG91dCUyMGxvdWQuJTIyKSUzQiUwQWNvbnNvbGUubG9nKGNvZGUpJTNCJTBBY29uc3QlMjBtZXNzYWdlcyUyMCUzRCUyMGF3YWl0JTIwYWdlbnQuZXZhbHVhdGVDb2RlKGNvZGUpJTBBY29uc29sZS5sb2cobWVzc2FnZXMpJTNCJTIwJTJGJTJGJTIwY29udGFpbnMlMjB0aGUlMjBkYXRhJTBBJTBBJTJGJTJGJTIwb3IlMjB5b3UlMjBjYW4lMjBydW4lMjB0aGUlMjBjb2RlJTIwZGlyZWN0bHklMkMlMjBob3dldmVyJTIweW91JTIwY2FuJ3QlMjBjaGVjayUyMHRoYXQlMjB0aGUlMjBjb2RlJTIwaXMlMjBzYWZlJTIwdG8lMjBleGVjdXRlJTIwdGhpcyUyMHdheSUyQyUyMHVzZSUyMGF0JTIweW91ciUyMG93biUyMHJpc2suJTBBY29uc3QlMjBtZXNzYWdlcyUyMCUzRCUyMGF3YWl0JTIwYWdlbnQucnVuKCUyMkRyYXclMjBhJTIwcGljdHVyZSUyMG9mJTIwYSUyMGNhdCUyMHdlYXJpbmclMjBhJTIwdG9wJTIwaGF0LiUyMFRoZW4lMjBjYXB0aW9uJTIwdGhlJTIwcGljdHVyZSUyMGFuZCUyMHJlYWQlMjBpdCUyMG91dCUyMGxvdWQuJTIyKSUwQWNvbnNvbGUubG9nKG1lc3NhZ2VzKSUzQiUyMA==",highlighted:`<span class="hljs-keyword">import</span> {<span class="hljs-title class_">HfAgent</span>, <span class="hljs-title class_">LLMFromHub</span>, defaultTools} <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/agents&#x27;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfAgent</span>(
  <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-title class_">LLMFromHub</span>(<span class="hljs-variable constant_">HF_TOKEN</span>),
  [...defaultTools]
);


<span class="hljs-comment">// you can generate the code, inspect it and then run it</span>
<span class="hljs-keyword">const</span> code = <span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">generateCode</span>(<span class="hljs-string">&quot;Draw a picture of a cat wearing a top hat. Then caption the picture and read it out loud.&quot;</span>);
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(code);
<span class="hljs-keyword">const</span> messages = <span class="hljs-keyword">await</span> agent.evaluateCode(code)
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(messages); <span class="hljs-comment">// contains the data</span>

<span class="hljs-comment">// or you can run the code directly, however you can&#x27;t check that the code is safe to execute this way, use at your own risk.</span>
<span class="hljs-keyword">const</span> messages = <span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">run</span>(<span class="hljs-string">&quot;Draw a picture of a cat wearing a top hat. Then caption the picture and read it out loud.&quot;</span>)
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(messages); `,wrap:!1}}),F=new j({props:{title:"@huggingface/hub examples",local:"huggingfacehub-examples",headingTag:"h3"}}),X=new d({props:{code:"aW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMHVwbG9hZEZpbGUlMkMlMjBkZWxldGVGaWxlcyUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwSEZfVE9LRU4lMjAlM0QlMjAlMjJoZl8uLi4lMjIlM0IlMEElMEFhd2FpdCUyMGNyZWF0ZVJlcG8oJTdCJTBBJTIwJTIwcmVwbyUzQSUyMCUyMm15LXVzZXIlMkZubHAtbW9kZWwlMjIlMkMlMjAlMkYlMkYlMjBvciUyMCU3QnR5cGUlM0ElMjAlMjJtb2RlbCUyMiUyQyUyMG5hbWUlM0ElMjAlMjJteS11c2VyJTJGbmxwLXRlc3QlMjIlN0QlMkMlMEElMjAlMjBjcmVkZW50aWFscyUzQSUyMCU3QmFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lN0QlMEElN0QpJTNCJTBBJTBBYXdhaXQlMjB1cGxvYWRGaWxlKCU3QiUwQSUyMCUyMHJlcG8lM0ElMjAlMjJteS11c2VyJTJGbmxwLW1vZGVsJTIyJTJDJTBBJTIwJTIwY3JlZGVudGlhbHMlM0ElMjAlN0JhY2Nlc3NUb2tlbiUzQSUyMEhGX1RPS0VOJTdEJTJDJTBBJTIwJTIwJTJGJTJGJTIwQ2FuJTIwd29yayUyMHdpdGglMjBuYXRpdmUlMjBGaWxlJTIwaW4lMjBicm93c2VycyUwQSUyMCUyMGZpbGUlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwYXRoJTNBJTIwJTIycHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMEElMjAlMjAlMjAlMjBjb250ZW50JTNBJTIwbmV3JTIwQmxvYiguLi4pJTIwJTBBJTIwJTIwJTdEJTBBJTdEKSUzQiUwQSUwQWF3YWl0JTIwZGVsZXRlRmlsZXMoJTdCJTBBJTIwJTIwcmVwbyUzQSUyMCU3QnR5cGUlM0ElMjAlMjJzcGFjZSUyMiUyQyUyMG5hbWUlM0ElMjAlMjJteS11c2VyJTJGbXktc3BhY2UlMjIlN0QlMkMlMjAlMkYlMkYlMjBvciUyMCUyMnNwYWNlcyUyRm15LXVzZXIlMkZteS1zcGFjZSUyMiUwQSUyMCUyMGNyZWRlbnRpYWxzJTNBJTIwJTdCYWNjZXNzVG9rZW4lM0ElMjBIRl9UT0tFTiU3RCUyQyUwQSUyMCUyMHBhdGhzJTNBJTIwJTVCJTIyUkVBRE1FLm1kJTIyJTJDJTIwJTIyLmdpdGF0dHJpYnV0ZXMlMjIlNUQlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">import</span> { createRepo, uploadFile, deleteFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>, <span class="hljs-comment">// or {type: &quot;model&quot;, name: &quot;my-user/nlp-test&quot;},</span>
  <span class="hljs-attr">credentials</span>: {<span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>}
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>,
  <span class="hljs-attr">credentials</span>: {<span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>},
  <span class="hljs-comment">// Can work with native File in browsers</span>
  <span class="hljs-attr">file</span>: {
    <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
    <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>(...) 
  }
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteFiles</span>({
  <span class="hljs-attr">repo</span>: {<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;space&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;my-user/my-space&quot;</span>}, <span class="hljs-comment">// or &quot;spaces/my-user/my-space&quot;</span>
  <span class="hljs-attr">credentials</span>: {<span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>},
  <span class="hljs-attr">paths</span>: [<span class="hljs-string">&quot;README.md&quot;</span>, <span class="hljs-string">&quot;.gitattributes&quot;</span>]
});`,wrap:!1}}),_=new j({props:{title:"Formatting & testing",local:"formatting--testing",headingTag:"h2"}}),z=new d({props:{code:"c3VkbyUyMGNvcmVwYWNrJTIwZW5hYmxlJTBBcG5wbSUyMGluc3RhbGwlMEElMEFwbnBtJTIwLXIlMjBmb3JtYXQlM0FjaGVjayUwQXBucG0lMjAtciUyMGxpbnQlM0FjaGVjayUwQXBucG0lMjAtciUyMHRlc3Q=",highlighted:`sudo corepack enable
pnpm install

pnpm -r format:check
pnpm -r lint:check
pnpm -r test`,wrap:!1}}),q=new j({props:{title:"Building",local:"building",headingTag:"h2"}}),A=new d({props:{code:"cG5wbSUyMC1yJTIwYnVpbGQ=",highlighted:'<span class="hljs-attribute">pnpm -r build</span>',wrap:!1}}),{c(){y=r("meta"),P=t(),D=r("p"),O=t(),T=r("p"),T.innerHTML=Es,ss=t(),p(w.$$.fragment),ls=t(),p(g.$$.fragment),as=t(),u=r("p"),u.textContent=Ys,ns=t(),U=r("ul"),U.innerHTML=Rs,ts=t(),f=r("p"),f.textContent=Vs,es=t(),b=r("p"),b.textContent=Ss,ps=t(),p(I.$$.fragment),is=t(),p(G.$$.fragment),cs=t(),Z=r("p"),Z.textContent=vs,Ms=t(),p(B.$$.fragment),Js=t(),k=r("p"),k.textContent=xs,os=t(),p(W.$$.fragment),rs=t(),p(C.$$.fragment),hs=t(),$=r("p"),$.innerHTML=Fs,ms=t(),p(Q.$$.fragment),js=t(),p(N.$$.fragment),ds=t(),p(E.$$.fragment),ys=t(),p(Y.$$.fragment),Ts=t(),R=r("p"),R.innerHTML=Xs,ws=t(),p(V.$$.fragment),gs=t(),p(S.$$.fragment),us=t(),p(v.$$.fragment),Us=t(),p(x.$$.fragment),fs=t(),p(F.$$.fragment),bs=t(),p(X.$$.fragment),Is=t(),H=r("p"),H.textContent=Hs,Gs=t(),p(_.$$.fragment),Zs=t(),p(z.$$.fragment),Bs=t(),p(q.$$.fragment),ks=t(),p(A.$$.fragment),Ws=t(),L=r("p"),L.innerHTML=_s,Cs=t(),K=r("p"),this.h()},l(s){const l=Ps("svelte-u9bgzb",document.head);y=h(l,"META",{name:!0,content:!0}),l.forEach(a),P=e(s),D=h(s,"P",{}),zs(D).forEach(a),O=e(s),T=h(s,"P",{align:!0,"data-svelte-h":!0}),m(T)!=="svelte-8nbzva"&&(T.innerHTML=Es),ss=e(s),i(w.$$.fragment,s),ls=e(s),i(g.$$.fragment,s),as=e(s),u=h(s,"P",{"data-svelte-h":!0}),m(u)!=="svelte-1eufct4"&&(u.textContent=Ys),ns=e(s),U=h(s,"UL",{"data-svelte-h":!0}),m(U)!=="svelte-68sj3b"&&(U.innerHTML=Rs),ts=e(s),f=h(s,"P",{"data-svelte-h":!0}),m(f)!=="svelte-9ezgtg"&&(f.textContent=Vs),es=e(s),b=h(s,"P",{"data-svelte-h":!0}),m(b)!=="svelte-1vx14v7"&&(b.textContent=Ss),ps=e(s),i(I.$$.fragment,s),is=e(s),i(G.$$.fragment,s),cs=e(s),Z=h(s,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-18mxf19"&&(Z.textContent=vs),Ms=e(s),i(B.$$.fragment,s),Js=e(s),k=h(s,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1fdwpsr"&&(k.textContent=xs),os=e(s),i(W.$$.fragment,s),rs=e(s),i(C.$$.fragment,s),hs=e(s),$=h(s,"P",{"data-svelte-h":!0}),m($)!=="svelte-1td2f08"&&($.innerHTML=Fs),ms=e(s),i(Q.$$.fragment,s),js=e(s),i(N.$$.fragment,s),ds=e(s),i(E.$$.fragment,s),ys=e(s),i(Y.$$.fragment,s),Ts=e(s),R=h(s,"P",{"data-svelte-h":!0}),m(R)!=="svelte-mx6w21"&&(R.innerHTML=Xs),ws=e(s),i(V.$$.fragment,s),gs=e(s),i(S.$$.fragment,s),us=e(s),i(v.$$.fragment,s),Us=e(s),i(x.$$.fragment,s),fs=e(s),i(F.$$.fragment,s),bs=e(s),i(X.$$.fragment,s),Is=e(s),H=h(s,"P",{"data-svelte-h":!0}),m(H)!=="svelte-16qnxzd"&&(H.textContent=Hs),Gs=e(s),i(_.$$.fragment,s),Zs=e(s),i(z.$$.fragment,s),Bs=e(s),i(q.$$.fragment,s),ks=e(s),i(A.$$.fragment,s),Ws=e(s),L=h(s,"P",{"data-svelte-h":!0}),m(L)!=="svelte-ymfi8c"&&(L.innerHTML=_s),Cs=e(s),K=h(s,"P",{}),zs(K).forEach(a),this.h()},h(){Qs(y,"name","hf:doc:metadata"),Qs(y,"content",ll),Qs(T,"align","center")},m(s,l){Os(document.head,y),n(s,P,l),n(s,D,l),n(s,O,l),n(s,T,l),n(s,ss,l),c(w,s,l),n(s,ls,l),c(g,s,l),n(s,as,l),n(s,u,l),n(s,ns,l),n(s,U,l),n(s,ts,l),n(s,f,l),n(s,es,l),n(s,b,l),n(s,ps,l),c(I,s,l),n(s,is,l),c(G,s,l),n(s,cs,l),n(s,Z,l),n(s,Ms,l),c(B,s,l),n(s,Js,l),n(s,k,l),n(s,os,l),c(W,s,l),n(s,rs,l),c(C,s,l),n(s,hs,l),n(s,$,l),n(s,ms,l),c(Q,s,l),n(s,js,l),c(N,s,l),n(s,ds,l),c(E,s,l),n(s,ys,l),c(Y,s,l),n(s,Ts,l),n(s,R,l),n(s,ws,l),c(V,s,l),n(s,gs,l),c(S,s,l),n(s,us,l),c(v,s,l),n(s,Us,l),c(x,s,l),n(s,fs,l),c(F,s,l),n(s,bs,l),c(X,s,l),n(s,Is,l),n(s,H,l),n(s,Gs,l),c(_,s,l),n(s,Zs,l),c(z,s,l),n(s,Bs,l),c(q,s,l),n(s,ks,l),c(A,s,l),n(s,Ws,l),n(s,L,l),n(s,Cs,l),n(s,K,l),$s=!0},p:As,i(s){$s||(M(w.$$.fragment,s),M(g.$$.fragment,s),M(I.$$.fragment,s),M(G.$$.fragment,s),M(B.$$.fragment,s),M(W.$$.fragment,s),M(C.$$.fragment,s),M(Q.$$.fragment,s),M(N.$$.fragment,s),M(E.$$.fragment,s),M(Y.$$.fragment,s),M(V.$$.fragment,s),M(S.$$.fragment,s),M(v.$$.fragment,s),M(x.$$.fragment,s),M(F.$$.fragment,s),M(X.$$.fragment,s),M(_.$$.fragment,s),M(z.$$.fragment,s),M(q.$$.fragment,s),M(A.$$.fragment,s),$s=!0)},o(s){J(w.$$.fragment,s),J(g.$$.fragment,s),J(I.$$.fragment,s),J(G.$$.fragment,s),J(B.$$.fragment,s),J(W.$$.fragment,s),J(C.$$.fragment,s),J(Q.$$.fragment,s),J(N.$$.fragment,s),J(E.$$.fragment,s),J(Y.$$.fragment,s),J(V.$$.fragment,s),J(S.$$.fragment,s),J(v.$$.fragment,s),J(x.$$.fragment,s),J(F.$$.fragment,s),J(X.$$.fragment,s),J(_.$$.fragment,s),J(z.$$.fragment,s),J(q.$$.fragment,s),J(A.$$.fragment,s),$s=!1},d(s){s&&(a(P),a(D),a(O),a(T),a(ss),a(ls),a(as),a(u),a(ns),a(U),a(ts),a(f),a(es),a(b),a(ps),a(is),a(cs),a(Z),a(Ms),a(Js),a(k),a(os),a(rs),a(hs),a($),a(ms),a(js),a(ds),a(ys),a(Ts),a(R),a(ws),a(gs),a(us),a(Us),a(fs),a(bs),a(Is),a(H),a(Gs),a(Zs),a(Bs),a(ks),a(Ws),a(L),a(Cs),a(K)),a(y),o(w,s),o(g,s),o(I,s),o(G,s),o(B,s),o(W,s),o(C,s),o(Q,s),o(N,s),o(E,s),o(Y,s),o(V,s),o(S,s),o(v,s),o(x,s),o(F,s),o(X,s),o(_,s),o(z,s),o(q,s),o(A,s)}}}const ll='{"title":"Hugging Face JS libraries","local":"hugging-face-js-libraries","sections":[{"title":"Installation","local":"installation","sections":[{"title":"From NPM","local":"from-npm","sections":[],"depth":3},{"title":"From CDN or Static hosting","local":"from-cdn-or-static-hosting","sections":[],"depth":3},{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage examples","local":"usage-examples","sections":[{"title":"@huggingface/inference examples","local":"huggingfaceinference-examples","sections":[],"depth":3},{"title":"@huggingface/agents example","local":"huggingfaceagents-example","sections":[],"depth":3},{"title":"@huggingface/hub examples","local":"huggingfacehub-examples","sections":[],"depth":3}],"depth":2},{"title":"Formatting & testing","local":"formatting--testing","sections":[],"depth":2},{"title":"Building","local":"building","sections":[],"depth":2}],"depth":1}';function al(Ns){return Ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class il extends Ds{constructor(y){super(),Ks(this,y,al,sl,qs,{})}}export{il as component};
