import{s as ue,n as Je,o as ye}from"../chunks/scheduler.85c25b89.js";import{S as je,i as we,g as l,s as p,u as c,A as be,h as n,f as e,c as i,j as h,v as M,y as m,k as o,o as r,a,w as g,d,t as u,x as J}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function Te(Xt){let y,ht,st,mt,j,v,at,k,Rt,D,Ht="Res2NeXt",ct,C,Ft='<strong>Res2NeXt</strong> is an image model that employs a variation on <a href="https://paperswithcode.com/method/resnext" rel="nofollow">ResNeXt</a> bottleneck residual blocks. The motivation is to be able to represent features at multiple scales. This is achieved through a novel building block for CNNs that constructs hierarchical residual-like connections within one single residual block. This represents multi-scale features at a granular level and increases the range of receptive fields for each network layer.',Mt,w,U,lt,E,St,q,zt="How do I use this model on an image?",gt,Z,Lt="To load a pretrained model:",dt,B,ut,W,Pt="To load and preprocess the image:",Jt,$,yt,G,Dt="To get the model predictions:",jt,Q,wt,_,qt="To get the top-5 predictions class names:",bt,R,Tt,S,Kt="Replace the model name with the variant you want to use, e.g. <code>res2next50</code>. You can find the IDs in the model summaries at the top of this page.",ft,A,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',vt,b,x,nt,V,At,K,te="How do I finetune this model?",Ut,Y,ee="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",xt,X,It,H,se=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Nt,T,I,pt,F,Vt,O,ae="How do I train this model?",kt,z,le='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Ct,f,N,it,L,Yt,tt,ne="Citation",Et,P,Zt,ot,Bt;return k=new rt({}),E=new rt({}),B=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3JlczJuZXh0NTAnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;res2next50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),$=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),Q=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),R=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),V=new rt({}),X=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzMm5leHQ1MCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;res2next50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),F=new rt({}),L=new rt({}),P=new et({props:{code:"JTQwYXJ0aWNsZSU3Qkdhb18yMDIxJTJDJTBBJTIwJTIwJTIwdGl0bGUlM0QlN0JSZXMyTmV0JTNBJTIwQSUyME5ldyUyME11bHRpLVNjYWxlJTIwQmFja2JvbmUlMjBBcmNoaXRlY3R1cmUlN0QlMkMlMEElMjAlMjAlMjB2b2x1bWUlM0QlN0I0MyU3RCUyQyUwQSUyMCUyMCUyMElTU04lM0QlN0IxOTM5LTM1MzklN0QlMkMlMEElMjAlMjAlMjB1cmwlM0QlN0JodHRwJTNBJTJGJTJGZHguZG9pLm9yZyUyRjEwLjExMDklMkZUUEFNSS4yMDE5LjI5Mzg3NTglN0QlMkMlMEElMjAlMjAlMjBET0klM0QlN0IxMC4xMTA5JTJGdHBhbWkuMjAxOS4yOTM4NzU4JTdEJTJDJTBBJTIwJTIwJTIwbnVtYmVyJTNEJTdCMiU3RCUyQyUwQSUyMCUyMCUyMGpvdXJuYWwlM0QlN0JJRUVFJTIwVHJhbnNhY3Rpb25zJTIwb24lMjBQYXR0ZXJuJTIwQW5hbHlzaXMlMjBhbmQlMjBNYWNoaW5lJTIwSW50ZWxsaWdlbmNlJTdEJTJDJTBBJTIwJTIwJTIwcHVibGlzaGVyJTNEJTdCSW5zdGl0dXRlJTIwb2YlMjBFbGVjdHJpY2FsJTIwYW5kJTIwRWxlY3Ryb25pY3MlMjBFbmdpbmVlcnMlMjAoSUVFRSklN0QlMkMlMEElMjAlMjAlMjBhdXRob3IlM0QlN0JHYW8lMkMlMjBTaGFuZy1IdWElMjBhbmQlMjBDaGVuZyUyQyUyME1pbmctTWluZyUyMGFuZCUyMFpoYW8lMkMlMjBLYWklMjBhbmQlMjBaaGFuZyUyQyUyMFhpbi1ZdSUyMGFuZCUyMFlhbmclMkMlMjBNaW5nLUhzdWFuJTIwYW5kJTIwVG9yciUyQyUyMFBoaWxpcCU3RCUyQyUwQSUyMCUyMCUyMHllYXIlM0QlN0IyMDIxJTdEJTJDJTBBJTIwJTIwJTIwbW9udGglM0QlN0JGZWIlN0QlMkMlMEElMjAlMjAlMjBwYWdlcyUzRCU3QjY1MiVFMiU4MCU5MzY2MiU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@article</span><span class="hljs-template-variable">{Gao_2021,
   title={Res2Net: A New Multi-Scale Backbone Architecture}</span><span class="language-xml">,
   volume=</span><span class="hljs-template-variable">{43}</span><span class="language-xml">,
   ISSN=</span><span class="hljs-template-variable">{1939-3539}</span><span class="language-xml">,
   url=</span><span class="hljs-template-variable">{http://dx.doi.org/10.1109/TPAMI.2019.2938758}</span><span class="language-xml">,
   DOI=</span><span class="hljs-template-variable">{10.1109/tpami.2019.2938758}</span><span class="language-xml">,
   number=</span><span class="hljs-template-variable">{2}</span><span class="language-xml">,
   journal=</span><span class="hljs-template-variable">{IEEE Transactions on Pattern Analysis and Machine Intelligence}</span><span class="language-xml">,
   publisher=</span><span class="hljs-template-variable">{Institute of Electrical and Electronics Engineers (IEEE)}</span><span class="language-xml">,
   author=</span><span class="hljs-template-variable">{Gao, Shang-Hua and Cheng, Ming-Ming and Zhao, Kai and Zhang, Xin-Yu and Yang, Ming-Hsuan and Torr, Philip}</span><span class="language-xml">,
   year=</span><span class="hljs-template-variable">{2021}</span><span class="language-xml">,
   month=</span><span class="hljs-template-variable">{Feb}</span><span class="language-xml">,
   pages=</span><span class="hljs-template-variable">{652–662}</span><span class="language-xml">
}</span>`}}),{c(){y=l("meta"),ht=p(),st=l("p"),mt=p(),j=l("h1"),v=l("a"),at=l("span"),c(k.$$.fragment),Rt=p(),D=l("span"),D.textContent=Ht,ct=p(),C=l("p"),C.innerHTML=Ft,Mt=p(),w=l("h2"),U=l("a"),lt=l("span"),c(E.$$.fragment),St=p(),q=l("span"),q.textContent=zt,gt=p(),Z=l("p"),Z.textContent=Lt,dt=p(),c(B.$$.fragment),ut=p(),W=l("p"),W.textContent=Pt,Jt=p(),c($.$$.fragment),yt=p(),G=l("p"),G.textContent=Dt,jt=p(),c(Q.$$.fragment),wt=p(),_=l("p"),_.textContent=qt,bt=p(),c(R.$$.fragment),Tt=p(),S=l("p"),S.innerHTML=Kt,ft=p(),A=l("p"),A.innerHTML=Ot,vt=p(),b=l("h2"),x=l("a"),nt=l("span"),c(V.$$.fragment),At=p(),K=l("span"),K.textContent=te,Ut=p(),Y=l("p"),Y.textContent=ee,xt=p(),c(X.$$.fragment),It=p(),H=l("p"),H.innerHTML=se,Nt=p(),T=l("h2"),I=l("a"),pt=l("span"),c(F.$$.fragment),Vt=p(),O=l("span"),O.textContent=ae,kt=p(),z=l("p"),z.innerHTML=le,Ct=p(),f=l("h2"),N=l("a"),it=l("span"),c(L.$$.fragment),Yt=p(),tt=l("span"),tt.textContent=ne,Et=p(),c(P.$$.fragment),Zt=p(),ot=l("p"),this.h()},l(t){const s=be("svelte-1phssyn",document.head);y=n(s,"META",{name:!0,content:!0}),s.forEach(e),ht=i(t),st=n(t,"P",{}),h(st).forEach(e),mt=i(t),j=n(t,"H1",{class:!0});var Wt=h(j);v=n(Wt,"A",{id:!0,class:!0,href:!0});var pe=h(v);at=n(pe,"SPAN",{});var ie=h(at);M(k.$$.fragment,ie),ie.forEach(e),pe.forEach(e),Rt=i(Wt),D=n(Wt,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-14bnbqa"&&(D.textContent=Ht),Wt.forEach(e),ct=i(t),C=n(t,"P",{"data-svelte-h":!0}),m(C)!=="svelte-ayu0xr"&&(C.innerHTML=Ft),Mt=i(t),w=n(t,"H2",{class:!0});var $t=h(w);U=n($t,"A",{id:!0,class:!0,href:!0});var oe=h(U);lt=n(oe,"SPAN",{});var re=h(lt);M(E.$$.fragment,re),re.forEach(e),oe.forEach(e),St=i($t),q=n($t,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-1c1hspn"&&(q.textContent=zt),$t.forEach(e),gt=i(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-18ywhxh"&&(Z.textContent=Lt),dt=i(t),M(B.$$.fragment,t),ut=i(t),W=n(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1c2ipa8"&&(W.textContent=Pt),Jt=i(t),M($.$$.fragment,t),yt=i(t),G=n(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1n9qsq1"&&(G.textContent=Dt),jt=i(t),M(Q.$$.fragment,t),wt=i(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-19cnvx1"&&(_.textContent=qt),bt=i(t),M(R.$$.fragment,t),Tt=i(t),S=n(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-199rhg"&&(S.innerHTML=Kt),ft=i(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1wmi3ea"&&(A.innerHTML=Ot),vt=i(t),b=n(t,"H2",{class:!0});var Gt=h(b);x=n(Gt,"A",{id:!0,class:!0,href:!0});var he=h(x);nt=n(he,"SPAN",{});var me=h(nt);M(V.$$.fragment,me),me.forEach(e),he.forEach(e),At=i(Gt),K=n(Gt,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=te),Gt.forEach(e),Ut=i(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-9sr7nh"&&(Y.textContent=ee),xt=i(t),M(X.$$.fragment,t),It=i(t),H=n(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1kguc51"&&(H.innerHTML=se),Nt=i(t),T=n(t,"H2",{class:!0});var Qt=h(T);I=n(Qt,"A",{id:!0,class:!0,href:!0});var ce=h(I);pt=n(ce,"SPAN",{});var Me=h(pt);M(F.$$.fragment,Me),Me.forEach(e),ce.forEach(e),Vt=i(Qt),O=n(Qt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=ae),Qt.forEach(e),kt=i(t),z=n(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1n0coha"&&(z.innerHTML=le),Ct=i(t),f=n(t,"H2",{class:!0});var _t=h(f);N=n(_t,"A",{id:!0,class:!0,href:!0});var ge=h(N);it=n(ge,"SPAN",{});var de=h(it);M(L.$$.fragment,de),de.forEach(e),ge.forEach(e),Yt=i(_t),tt=n(_t,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ne),_t.forEach(e),Et=i(t),M(P.$$.fragment,t),Zt=i(t),ot=n(t,"P",{}),h(ot).forEach(e),this.h()},h(){o(y,"name","hf:doc:metadata"),o(y,"content",JSON.stringify(fe)),o(v,"id","res2next"),o(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(v,"href","#res2next"),o(j,"class","relative group"),o(U,"id","how-do-i-use-this-model-on-an-image"),o(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(U,"href","#how-do-i-use-this-model-on-an-image"),o(w,"class","relative group"),o(x,"id","how-do-i-finetune-this-model"),o(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(x,"href","#how-do-i-finetune-this-model"),o(b,"class","relative group"),o(I,"id","how-do-i-train-this-model"),o(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(I,"href","#how-do-i-train-this-model"),o(T,"class","relative group"),o(N,"id","citation"),o(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(N,"href","#citation"),o(f,"class","relative group")},m(t,s){r(document.head,y),a(t,ht,s),a(t,st,s),a(t,mt,s),a(t,j,s),r(j,v),r(v,at),g(k,at,null),r(j,Rt),r(j,D),a(t,ct,s),a(t,C,s),a(t,Mt,s),a(t,w,s),r(w,U),r(U,lt),g(E,lt,null),r(w,St),r(w,q),a(t,gt,s),a(t,Z,s),a(t,dt,s),g(B,t,s),a(t,ut,s),a(t,W,s),a(t,Jt,s),g($,t,s),a(t,yt,s),a(t,G,s),a(t,jt,s),g(Q,t,s),a(t,wt,s),a(t,_,s),a(t,bt,s),g(R,t,s),a(t,Tt,s),a(t,S,s),a(t,ft,s),a(t,A,s),a(t,vt,s),a(t,b,s),r(b,x),r(x,nt),g(V,nt,null),r(b,At),r(b,K),a(t,Ut,s),a(t,Y,s),a(t,xt,s),g(X,t,s),a(t,It,s),a(t,H,s),a(t,Nt,s),a(t,T,s),r(T,I),r(I,pt),g(F,pt,null),r(T,Vt),r(T,O),a(t,kt,s),a(t,z,s),a(t,Ct,s),a(t,f,s),r(f,N),r(N,it),g(L,it,null),r(f,Yt),r(f,tt),a(t,Et,s),g(P,t,s),a(t,Zt,s),a(t,ot,s),Bt=!0},p:Je,i(t){Bt||(d(k.$$.fragment,t),d(E.$$.fragment,t),d(B.$$.fragment,t),d($.$$.fragment,t),d(Q.$$.fragment,t),d(R.$$.fragment,t),d(V.$$.fragment,t),d(X.$$.fragment,t),d(F.$$.fragment,t),d(L.$$.fragment,t),d(P.$$.fragment,t),Bt=!0)},o(t){u(k.$$.fragment,t),u(E.$$.fragment,t),u(B.$$.fragment,t),u($.$$.fragment,t),u(Q.$$.fragment,t),u(R.$$.fragment,t),u(V.$$.fragment,t),u(X.$$.fragment,t),u(F.$$.fragment,t),u(L.$$.fragment,t),u(P.$$.fragment,t),Bt=!1},d(t){t&&(e(ht),e(st),e(mt),e(j),e(ct),e(C),e(Mt),e(w),e(gt),e(Z),e(dt),e(ut),e(W),e(Jt),e(yt),e(G),e(jt),e(wt),e(_),e(bt),e(Tt),e(S),e(ft),e(A),e(vt),e(b),e(Ut),e(Y),e(xt),e(It),e(H),e(Nt),e(T),e(kt),e(z),e(Ct),e(f),e(Et),e(Zt),e(ot)),e(y),J(k),J(E),J(B,t),J($,t),J(Q,t),J(R,t),J(V),J(X,t),J(F),J(L),J(P,t)}}}const fe={local:"res2next",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"Res2NeXt"};function ve(Xt){return ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ke extends je{constructor(y){super(),we(this,y,ve,Te,ue,{})}}export{ke as component};
