import{s as Sl,n as Zl,o as Nl}from"../chunks/scheduler.7bc62968.js";import{S as Hl,i as zl,g as i,s,r as p,A as Rl,h as o,f as t,c as a,j as El,u as r,x as M,k as _l,y as Ql,a as n,v as w,d as T,t as m,w as u}from"../chunks/index.66556066.js";import{C as Yl}from"../chunks/CodeBlock.a759539a.js";import{H as y}from"../chunks/Heading.3f0870db.js";function Dl(sl){let c,re,Me,we,h,Te,J,al="MobileNet is a type of neural network architecture designed for mobile devices. It was developed by Google’s research team and first introduced in 2017. The primary goal of MobileNet is to provide high-performance, low-latency image classification and object detection on smartphones, tablets, and other resource-constrained devices.",me,C,il="MobileNet achieves this by using depthwise separable convolutions, which are a more efficient alternative to standard convolutions. Depthwise separable convolutions break down the computation into two separate steps: depthwise convolution followed by pointwise convolution. This results in a significant reduction of parameters and computational complexity, allowing MobileNet to run efficiently on mobile devices.",ue,j,ye,U,ol="By replacing regular convolutional layers with these depthwise separable convolutions and pointwise convolutions, MobileNet achieves high accuracy while minimizing computational overhead, making it well-suited for mobile devices and other resource-limited platforms. There are two types of convolutions used in MobileNet:",ce,f,he,d,Ml="In traditional convolutional layers, each filter applies its weight across all input channels simultaneously. Depthwise separable convolutions break this down into two steps: depthwise convolution followed by pointwise convolution.",Je,I,pl="This step performs a convolution separately for each channel (a single color or feature) in the input image using a small filter (usually 3x3). The output of this step is the same size as the input but with fewer channels.",Ce,b,je,v,rl="This type of convolution applies a single filter (usually 1x1) across all channels in both input and output layers. It has fewer parameters than regular convolution and can be seen as an alternative to fully connected layers, making it suitable for mobile devices that have limited computational resources.",Ue,x,wl="After depthwise convolution, this step combines the filtered outputs from previous steps using another 1x1 convolutional layer. This operation effectively aggregates the features learned by the depthwise convolutions into a smaller set of features, reducing the overall complexity while retaining important information.",fe,g,de,A,Tl="To better understand, let’s simplify it and explain:",Ie,B,be,$,ml="Imagine you have a big, thick filter (like a sponge with many layers). This filter is applied over the entire image. It processes all parts of the image and all its features (like colors) at once. This requires a lot of work (computation) and a big filter (memory).",ve,k,xe,E,ul="MobileNet does this process basic. It splits the big filter into two smaller, simpler steps:",ge,_,yl=`<li><strong>Step 1 - Depthwise Convolution:</strong> First, it uses a thin filter (like a single layer of a sponge) for each feature of the image
separately (like processing each color individually). This is less work because each filter is small and simple.</li> <li><strong>Step 2 - Pointwise Convolution:</strong> Then, it uses another small filter (just a tiny dot) to mix these features back together. This step is like taking a summary of what the first filters found.</li>`,Ae,S,Be,Z,cl="MobileNet uses these two smaller steps instead of one big step, it’s like doing a lighter version of the work needed in regular convolutions. It’s more efficient, especially on devices that aren’t very powerful, like smartphones.",$e,N,hl="With smaller filters, MobileNet doesn’t need as much memory. It’s like needing a smaller box to store all your tools, making it easier to fit into smaller devices.",ke,H,Ee,z,_e,R,Jl="<li>Normal convolutions use a larger kernel (like 3x3 or 5x5) to look at a group of pixels in the image at once. It’s like observing a small patch of a picture to understand a part of the scene.</li> <li>These convolutions are good at understanding features like edges, corners, and textures by analyzing how pixels are arranged next to each other.</li>",Se,Q,Ze,Y,Cl="<li>A 1x1 convolution, looks at one pixel at a time. It doesn’t try to understand the arrangement of neighboring pixels.</li> <li>Even though it’s looking at one pixel, it considers all the information from different channels (like the RGB channels in a color image). It combines these channels to create a new version of that pixel.</li> <li>The 1x1 convolution can either increase or decrease the number of channels. This means it can simplify the information (by reducing channels) or create more complex information (by increasing channels).</li>",Ne,D,He,W,jl="<li><strong>Area of Focus:</strong> Normal convolutions analyze a set of pixels together to understand patterns, whereas 1x1 convolutions focus on individual pixels, combining the information from different channels.</li> <li><strong>Purpose:</strong> Normal convolutions are used for detecting patterns and features in an image. In contrast, 1x1 convolutions are mainly used to alter the channel depth, helping in adjusting the complexity of the information for subsequent layers in a neural network for efficiency in weak devices.</li>",ze,X,Ul="MobileNet also employs techniques like channel-wise linear bottleneck layers, which improve model accuracy while reducing the number of parameters. The architecture is designed with optimizations for various hardware platforms, including CPUs, GPUs, and even specialized hardware such as Google’s Tensor Processing Units (TPUs).",Re,V,Qe,G,fl="Channel-wise linear bottleneck layers help to further reduce the number of parameters and computational cost while maintaining high accuracy in image classification tasks.",Ye,L,dl="A channel-wise linear bottleneck layer consists of three main operations applied sequentially:",De,F,Il="<li><strong>Depthwise convolution:</strong> This step performs a convolution separately for each channel (a single color or feature) in the input image using a small filter (usually 3x3). The output of this step is the same size as the input but with fewer channels.</li> <li><strong>Batch normalization:</strong> This operation normalizes the activation values across each channel, helping to stabilize the training process and improve generalization performance.</li> <li><strong>Activation function:</strong> Typically, a ReLU (Rectified Linear Unit) activation function is used after batch normalization to introduce non-linearity in the network.</li>",We,K,Xe,P,bl="Some problems may occur during training. We will explain them first, then we explain what ReLU does to this problems.",Ve,q,Ge,O,vl="In deep neural networks, especially during backpropagation, the vanishing gradient problem can occur. This happens when gradients (which are used to update the network’s weights) become very small as they are passed back through the network’s layers. If these gradients become too small, they “vanish,” making it hard for the network to learn and adjust its weights effectively.",Le,ee,xl="ReLU has a linear, non-saturating form for positive values (where it simply outputs the input if it’s positive), it ensures that the gradients do not become too small, allowing for faster learning and more effective weight adjustments in the network.",Fe,le,Ke,te,gl="Without non-linearity, a neural network, no matter how many layers it has, would function as a linear model, incapable of learning complex patterns.",Pe,ne,Al="Non-linear functions like ReLU enable neural networks to capture and learn complex relationships in the data.",qe,se,Bl="You can find an example implementation of MobileNet for PyTorch below:",Oe,ae,$l="PyTorch:",el,ie,ll,oe,kl='You can also find a pretrained MobileNet model checkpoint on this HuggingFace <a href="https://huggingface.co/google/mobilenet_v2_1.0_224" rel="nofollow">link</a>.',tl,pe,nl;return h=new y({props:{title:"MobileNet",local:"mobilenet",headingTag:"h1"}}),j=new y({props:{title:"Convolution Types on MobileNet",local:"convolution-types-on-mobilenet",headingTag:"h2"}}),f=new y({props:{title:"Depthwise Seperable Convolutions",local:"depthwise-seperable-convolutions",headingTag:"h3"}}),b=new y({props:{title:"Pointwise Seperable Convolutions",local:"pointwise-seperable-convolutions",headingTag:"h3"}}),g=new y({props:{title:"Why Do We Use These Convolutions Instead of Regular Convolutions?",local:"why-do-we-use-these-convolutions-instead-of-regular-convolutions",headingTag:"h3"}}),B=new y({props:{title:"Regular Convolutions - Big, All-in-one Filter:",local:"regular-convolutions---big-all-in-one-filter",headingTag:"h4"}}),k=new y({props:{title:"Depthwise Separable Convolutions - Two-Step, Lighter Process:",local:"depthwise-separable-convolutions---two-step-lighter-process",headingTag:"h4"}}),S=new y({props:{title:"What does this all mean?",local:"what-does-this-all-mean",headingTag:"h4"}}),H=new y({props:{title:"How Do 1x1 Convolutions Work Compared to Normal Convolutions?",local:"how-do-1x1-convolutions-work-compared-to-normal-convolutions",headingTag:"h3"}}),z=new y({props:{title:"Normal Convolutions:",local:"normal-convolutions",headingTag:"h4"}}),Q=new y({props:{title:"1x1 Convolutions:",local:"1x1-convolutions",headingTag:"h4"}}),D=new y({props:{title:"Key Differences:",local:"key-differences",headingTag:"h4"}}),V=new y({props:{title:"Channel-wise Linear Bottleneck Layers",local:"channel-wise-linear-bottleneck-layers",headingTag:"h3"}}),K=new y({props:{title:"What does ReLU do?",local:"what-does-relu-do",headingTag:"h3"}}),q=new y({props:{title:"Vanishing Gradient Problem:",local:"vanishing-gradient-problem",headingTag:"h4"}}),le=new y({props:{title:"Non-Linearity:",local:"non-linearity",headingTag:"h4"}}),ie=new Yl({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F


<span class="hljs-keyword">class</span> <span class="hljs-title class_">DepthwiseSeparableConv</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, in_channels, out_channels, stride</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.depthwise = nn.Conv2d(
            in_channels,
            in_channels,
            kernel_size=<span class="hljs-number">3</span>,
            stride=stride,
            padding=<span class="hljs-number">1</span>,
            groups=in_channels,
        )
        self.pointwise = nn.Conv2d(
            in_channels, out_channels, kernel_size=<span class="hljs-number">1</span>, stride=<span class="hljs-number">1</span>, padding=<span class="hljs-number">0</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.depthwise(x)
        x = self.pointwise(x)
        <span class="hljs-keyword">return</span> x


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MobileNet</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_classes=<span class="hljs-number">1000</span></span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.conv1 = nn.Conv2d(<span class="hljs-number">3</span>, <span class="hljs-number">32</span>, kernel_size=<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>)

        <span class="hljs-comment"># MobileNet body</span>
        self.dw_conv2 = DepthwiseSeparableConv(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">1</span>)
        self.dw_conv3 = DepthwiseSeparableConv(<span class="hljs-number">64</span>, <span class="hljs-number">128</span>, <span class="hljs-number">2</span>)
        self.dw_conv4 = DepthwiseSeparableConv(<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">1</span>)
        self.dw_conv5 = DepthwiseSeparableConv(<span class="hljs-number">128</span>, <span class="hljs-number">256</span>, <span class="hljs-number">2</span>)
        self.dw_conv6 = DepthwiseSeparableConv(<span class="hljs-number">256</span>, <span class="hljs-number">256</span>, <span class="hljs-number">1</span>)
        self.dw_conv7 = DepthwiseSeparableConv(<span class="hljs-number">256</span>, <span class="hljs-number">512</span>, <span class="hljs-number">2</span>)

        <span class="hljs-comment"># 5 depthwise separable convolutions with stride 1</span>
        self.dw_conv8 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)
        self.dw_conv9 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)
        self.dw_conv10 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)
        self.dw_conv11 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)
        self.dw_conv12 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)

        self.dw_conv13 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">1024</span>, <span class="hljs-number">2</span>)
        self.dw_conv14 = DepthwiseSeparableConv(<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>, <span class="hljs-number">1</span>)

        self.avg_pool = nn.AdaptiveAvgPool2d(<span class="hljs-number">1</span>)
        self.fc = nn.Linear(<span class="hljs-number">1024</span>, num_classes)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.conv1(x)
        x = F.relu(x)

        x = self.dw_conv2(x)
        x = F.relu(x)
        x = self.dw_conv3(x)
        x = F.relu(x)
        x = self.dw_conv4(x)
        x = F.relu(x)
        x = self.dw_conv5(x)
        x = F.relu(x)
        x = self.dw_conv6(x)
        x = F.relu(x)
        x = self.dw_conv7(x)
        x = F.relu(x)

        x = self.dw_conv8(x)
        x = F.relu(x)
        x = self.dw_conv9(x)
        x = F.relu(x)
        x = self.dw_conv10(x)
        x = F.relu(x)
        x = self.dw_conv11(x)
        x = F.relu(x)
        x = self.dw_conv12(x)
        x = F.relu(x)

        x = self.dw_conv13(x)
        x = F.relu(x)
        x = self.dw_conv14(x)
        x = F.relu(x)

        x = self.avg_pool(x)
        x = x.view(x.size(<span class="hljs-number">0</span>), -<span class="hljs-number">1</span>)
        x = self.fc(x)

        <span class="hljs-keyword">return</span> x


<span class="hljs-comment"># Create the model</span>
mobilenet = MobileNet(num_classes=<span class="hljs-number">1000</span>)
<span class="hljs-built_in">print</span>(mobilenet)`,wrap:!1}}),{c(){c=i("meta"),re=s(),Me=i("p"),we=s(),p(h.$$.fragment),Te=s(),J=i("p"),J.textContent=al,me=s(),C=i("p"),C.textContent=il,ue=s(),p(j.$$.fragment),ye=s(),U=i("p"),U.textContent=ol,ce=s(),p(f.$$.fragment),he=s(),d=i("p"),d.textContent=Ml,Je=s(),I=i("p"),I.textContent=pl,Ce=s(),p(b.$$.fragment),je=s(),v=i("p"),v.textContent=rl,Ue=s(),x=i("p"),x.textContent=wl,fe=s(),p(g.$$.fragment),de=s(),A=i("p"),A.textContent=Tl,Ie=s(),p(B.$$.fragment),be=s(),$=i("p"),$.textContent=ml,ve=s(),p(k.$$.fragment),xe=s(),E=i("p"),E.textContent=ul,ge=s(),_=i("ul"),_.innerHTML=yl,Ae=s(),p(S.$$.fragment),Be=s(),Z=i("p"),Z.textContent=cl,$e=s(),N=i("p"),N.textContent=hl,ke=s(),p(H.$$.fragment),Ee=s(),p(z.$$.fragment),_e=s(),R=i("ul"),R.innerHTML=Jl,Se=s(),p(Q.$$.fragment),Ze=s(),Y=i("ul"),Y.innerHTML=Cl,Ne=s(),p(D.$$.fragment),He=s(),W=i("ul"),W.innerHTML=jl,ze=s(),X=i("p"),X.textContent=Ul,Re=s(),p(V.$$.fragment),Qe=s(),G=i("p"),G.textContent=fl,Ye=s(),L=i("p"),L.textContent=dl,De=s(),F=i("ol"),F.innerHTML=Il,We=s(),p(K.$$.fragment),Xe=s(),P=i("p"),P.textContent=bl,Ve=s(),p(q.$$.fragment),Ge=s(),O=i("p"),O.textContent=vl,Le=s(),ee=i("p"),ee.textContent=xl,Fe=s(),p(le.$$.fragment),Ke=s(),te=i("p"),te.textContent=gl,Pe=s(),ne=i("p"),ne.textContent=Al,qe=s(),se=i("p"),se.textContent=Bl,Oe=s(),ae=i("p"),ae.textContent=$l,el=s(),p(ie.$$.fragment),ll=s(),oe=i("p"),oe.innerHTML=kl,tl=s(),pe=i("p"),this.h()},l(e){const l=Rl("svelte-u9bgzb",document.head);c=o(l,"META",{name:!0,content:!0}),l.forEach(t),re=a(e),Me=o(e,"P",{}),El(Me).forEach(t),we=a(e),r(h.$$.fragment,e),Te=a(e),J=o(e,"P",{"data-svelte-h":!0}),M(J)!=="svelte-sijmec"&&(J.textContent=al),me=a(e),C=o(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-174b0qn"&&(C.textContent=il),ue=a(e),r(j.$$.fragment,e),ye=a(e),U=o(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1wb1rsu"&&(U.textContent=ol),ce=a(e),r(f.$$.fragment,e),he=a(e),d=o(e,"P",{"data-svelte-h":!0}),M(d)!=="svelte-ponep"&&(d.textContent=Ml),Je=a(e),I=o(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-161c9o7"&&(I.textContent=pl),Ce=a(e),r(b.$$.fragment,e),je=a(e),v=o(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-2y0hnt"&&(v.textContent=rl),Ue=a(e),x=o(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1phmdq0"&&(x.textContent=wl),fe=a(e),r(g.$$.fragment,e),de=a(e),A=o(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-7o9nvi"&&(A.textContent=Tl),Ie=a(e),r(B.$$.fragment,e),be=a(e),$=o(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1aqrp0c"&&($.textContent=ml),ve=a(e),r(k.$$.fragment,e),xe=a(e),E=o(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1n7p8h5"&&(E.textContent=ul),ge=a(e),_=o(e,"UL",{"data-svelte-h":!0}),M(_)!=="svelte-1erfm5m"&&(_.innerHTML=yl),Ae=a(e),r(S.$$.fragment,e),Be=a(e),Z=o(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-ucrnk0"&&(Z.textContent=cl),$e=a(e),N=o(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1q9jr09"&&(N.textContent=hl),ke=a(e),r(H.$$.fragment,e),Ee=a(e),r(z.$$.fragment,e),_e=a(e),R=o(e,"UL",{"data-svelte-h":!0}),M(R)!=="svelte-141ia0e"&&(R.innerHTML=Jl),Se=a(e),r(Q.$$.fragment,e),Ze=a(e),Y=o(e,"UL",{"data-svelte-h":!0}),M(Y)!=="svelte-1fof3jx"&&(Y.innerHTML=Cl),Ne=a(e),r(D.$$.fragment,e),He=a(e),W=o(e,"UL",{"data-svelte-h":!0}),M(W)!=="svelte-20uax5"&&(W.innerHTML=jl),ze=a(e),X=o(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1wb1jef"&&(X.textContent=Ul),Re=a(e),r(V.$$.fragment,e),Qe=a(e),G=o(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-3ec6p4"&&(G.textContent=fl),Ye=a(e),L=o(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-1jsp81n"&&(L.textContent=dl),De=a(e),F=o(e,"OL",{"data-svelte-h":!0}),M(F)!=="svelte-123p5si"&&(F.innerHTML=Il),We=a(e),r(K.$$.fragment,e),Xe=a(e),P=o(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-iz02dd"&&(P.textContent=bl),Ve=a(e),r(q.$$.fragment,e),Ge=a(e),O=o(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1kof70t"&&(O.textContent=vl),Le=a(e),ee=o(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-1t9atje"&&(ee.textContent=xl),Fe=a(e),r(le.$$.fragment,e),Ke=a(e),te=o(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-17n9xro"&&(te.textContent=gl),Pe=a(e),ne=o(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-1cfo99"&&(ne.textContent=Al),qe=a(e),se=o(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-10vxwno"&&(se.textContent=Bl),Oe=a(e),ae=o(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-8s5vj9"&&(ae.textContent=$l),el=a(e),r(ie.$$.fragment,e),ll=a(e),oe=o(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-1fc7bef"&&(oe.innerHTML=kl),tl=a(e),pe=o(e,"P",{}),El(pe).forEach(t),this.h()},h(){_l(c,"name","hf:doc:metadata"),_l(c,"content",Wl)},m(e,l){Ql(document.head,c),n(e,re,l),n(e,Me,l),n(e,we,l),w(h,e,l),n(e,Te,l),n(e,J,l),n(e,me,l),n(e,C,l),n(e,ue,l),w(j,e,l),n(e,ye,l),n(e,U,l),n(e,ce,l),w(f,e,l),n(e,he,l),n(e,d,l),n(e,Je,l),n(e,I,l),n(e,Ce,l),w(b,e,l),n(e,je,l),n(e,v,l),n(e,Ue,l),n(e,x,l),n(e,fe,l),w(g,e,l),n(e,de,l),n(e,A,l),n(e,Ie,l),w(B,e,l),n(e,be,l),n(e,$,l),n(e,ve,l),w(k,e,l),n(e,xe,l),n(e,E,l),n(e,ge,l),n(e,_,l),n(e,Ae,l),w(S,e,l),n(e,Be,l),n(e,Z,l),n(e,$e,l),n(e,N,l),n(e,ke,l),w(H,e,l),n(e,Ee,l),w(z,e,l),n(e,_e,l),n(e,R,l),n(e,Se,l),w(Q,e,l),n(e,Ze,l),n(e,Y,l),n(e,Ne,l),w(D,e,l),n(e,He,l),n(e,W,l),n(e,ze,l),n(e,X,l),n(e,Re,l),w(V,e,l),n(e,Qe,l),n(e,G,l),n(e,Ye,l),n(e,L,l),n(e,De,l),n(e,F,l),n(e,We,l),w(K,e,l),n(e,Xe,l),n(e,P,l),n(e,Ve,l),w(q,e,l),n(e,Ge,l),n(e,O,l),n(e,Le,l),n(e,ee,l),n(e,Fe,l),w(le,e,l),n(e,Ke,l),n(e,te,l),n(e,Pe,l),n(e,ne,l),n(e,qe,l),n(e,se,l),n(e,Oe,l),n(e,ae,l),n(e,el,l),w(ie,e,l),n(e,ll,l),n(e,oe,l),n(e,tl,l),n(e,pe,l),nl=!0},p:Zl,i(e){nl||(T(h.$$.fragment,e),T(j.$$.fragment,e),T(f.$$.fragment,e),T(b.$$.fragment,e),T(g.$$.fragment,e),T(B.$$.fragment,e),T(k.$$.fragment,e),T(S.$$.fragment,e),T(H.$$.fragment,e),T(z.$$.fragment,e),T(Q.$$.fragment,e),T(D.$$.fragment,e),T(V.$$.fragment,e),T(K.$$.fragment,e),T(q.$$.fragment,e),T(le.$$.fragment,e),T(ie.$$.fragment,e),nl=!0)},o(e){m(h.$$.fragment,e),m(j.$$.fragment,e),m(f.$$.fragment,e),m(b.$$.fragment,e),m(g.$$.fragment,e),m(B.$$.fragment,e),m(k.$$.fragment,e),m(S.$$.fragment,e),m(H.$$.fragment,e),m(z.$$.fragment,e),m(Q.$$.fragment,e),m(D.$$.fragment,e),m(V.$$.fragment,e),m(K.$$.fragment,e),m(q.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),nl=!1},d(e){e&&(t(re),t(Me),t(we),t(Te),t(J),t(me),t(C),t(ue),t(ye),t(U),t(ce),t(he),t(d),t(Je),t(I),t(Ce),t(je),t(v),t(Ue),t(x),t(fe),t(de),t(A),t(Ie),t(be),t($),t(ve),t(xe),t(E),t(ge),t(_),t(Ae),t(Be),t(Z),t($e),t(N),t(ke),t(Ee),t(_e),t(R),t(Se),t(Ze),t(Y),t(Ne),t(He),t(W),t(ze),t(X),t(Re),t(Qe),t(G),t(Ye),t(L),t(De),t(F),t(We),t(Xe),t(P),t(Ve),t(Ge),t(O),t(Le),t(ee),t(Fe),t(Ke),t(te),t(Pe),t(ne),t(qe),t(se),t(Oe),t(ae),t(el),t(ll),t(oe),t(tl),t(pe)),t(c),u(h,e),u(j,e),u(f,e),u(b,e),u(g,e),u(B,e),u(k,e),u(S,e),u(H,e),u(z,e),u(Q,e),u(D,e),u(V,e),u(K,e),u(q,e),u(le,e),u(ie,e)}}}const Wl='{"title":"MobileNet","local":"mobilenet","sections":[{"title":"Convolution Types on MobileNet","local":"convolution-types-on-mobilenet","sections":[{"title":"Depthwise Seperable Convolutions","local":"depthwise-seperable-convolutions","sections":[],"depth":3},{"title":"Pointwise Seperable Convolutions","local":"pointwise-seperable-convolutions","sections":[],"depth":3},{"title":"Why Do We Use These Convolutions Instead of Regular Convolutions?","local":"why-do-we-use-these-convolutions-instead-of-regular-convolutions","sections":[{"title":"Regular Convolutions - Big, All-in-one Filter:","local":"regular-convolutions---big-all-in-one-filter","sections":[],"depth":4},{"title":"Depthwise Separable Convolutions - Two-Step, Lighter Process:","local":"depthwise-separable-convolutions---two-step-lighter-process","sections":[],"depth":4},{"title":"What does this all mean?","local":"what-does-this-all-mean","sections":[],"depth":4}],"depth":3},{"title":"How Do 1x1 Convolutions Work Compared to Normal Convolutions?","local":"how-do-1x1-convolutions-work-compared-to-normal-convolutions","sections":[{"title":"Normal Convolutions:","local":"normal-convolutions","sections":[],"depth":4},{"title":"1x1 Convolutions:","local":"1x1-convolutions","sections":[],"depth":4},{"title":"Key Differences:","local":"key-differences","sections":[],"depth":4}],"depth":3},{"title":"Channel-wise Linear Bottleneck Layers","local":"channel-wise-linear-bottleneck-layers","sections":[],"depth":3},{"title":"What does ReLU do?","local":"what-does-relu-do","sections":[{"title":"Vanishing Gradient Problem:","local":"vanishing-gradient-problem","sections":[],"depth":4},{"title":"Non-Linearity:","local":"non-linearity","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function Xl(sl){return Nl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kl extends Hl{constructor(c){super(),zl(this,c,Xl,Dl,Sl,{})}}export{Kl as component};
