import{s as Ls,n as Cs,o as Ms}from"../chunks/scheduler.7bc62968.js";import{S as Hs,i as Ds,g as l,s as n,r as D,m as Ts,H as Is,A as Ps,h as r,f as t,c as i,j as os,u as I,x as m,n as zs,E as Ss,k as Ns,y as h,a,v as P,d as S,t as V,w as q}from"../chunks/index.66556066.js";import{H as j}from"../chunks/Heading.3f0870db.js";function Vs(gs){let p,W,C,U,g,R,d,F,u,ds='Generative Adversarial Networks (GANs) are a class of deep learning models introduced by <a href="https://scholar.google.ca/citations?user=iYN86KEAAAAJ&amp;hl=en" rel="nofollow">Ian Goodfellow</a> and his colleagues in 2014. The core idea behind GANs is to train a generator network to produce data that is indistinguishable from real data, while simultaneously training a discriminator network to differentiate between real and generated data.',O,f,us="<li><strong>Architecture overview:</strong> GANs consist of two main components: <code>the generator</code> and <code>the discriminator</code></li> <li><strong>Generator:</strong> The generator takes random noise $$z$$ as input and generates synthetic data samples. Its goal is to create data that is realistic enough to deceive the discriminator.</li> <li><strong>Discriminator:</strong> The discriminator, akin to a detective, evaluates whether a given sample is real (from the actual dataset) or fake (generated by the generator). Its objective is to become increasingly accurate in distinguishing between real and generated samples.</li>",B,v,fs="A common analogy that can be found online is that of an art forger/painter (the generator) which tries to forge paintings and an art investigator/critic (the discriminator) which tries to detect limitations.",J,y,vs='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/generative_models/GAN.png" alt="Lilian Weng GAN Figure"/>',K,b,Q,w,ys="GANs and VAEs are both popular generative models in machine learning, but they have different strengths and weaknesses. Whether one is “better” depends on the specific task and requirements. Here’s a breakdown of their strengths and weaknesses.",Y,x,bs=`<li><strong>Image Generation:</strong><ul><li><strong>GANs:</strong><ul><li><strong>Strengths:</strong> Generate higher quality images, especially for complex data with sharp details and realistic textures.</li> <li><strong>Weaknesses:</strong> Can be more difficult to train and prone to instability.</li> <li><strong>Example:</strong> A GAN-generated image of a bedroom is likely to be indistinguishable from a real one, while a VAE-generated bedroom might appear blurry or have unrealistic lighting.
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/generative_models/bedroom.png" alt="Example of GAN-Generated bedrooms taken from Unsupervised Representation Learning with Deep Convolutional Generative Adversarial Networks, 2015"/></li></ul></li> <li><strong>VAEs:</strong><ul><li><strong>Strengths:</strong> Easier to train and more stable than GANs</li> <li><strong>Weaknesses:</strong> May generate blurry, less detailed images with unrealistic features.</li></ul></li></ul></li> <li><strong>Other Tasks:</strong><ul><li><strong>GANs:</strong><ul><li><strong>Strengths:</strong> Can be used for tasks like super-resolution and image-to-image translation.</li> <li><strong>Weaknesses:</strong> May not be the best choice for tasks that require a smooth transition between data points</li></ul></li> <li><strong>VAEs:</strong><ul><li><strong>Strengths:</strong> Widely used for tasks like image denoising and anomaly detection.</li> <li><strong>Weaknesses:</strong> May not be as effective as GANs for tasks that require high-quality image generation.</li></ul></li></ul></li>`,X,A,ws=`Here’s a table summarizing the key differences:
|Feature|GANs|VAEs|
|-------|-----|---|
|Image Quality|Higher|Lower|
|Ease of Training|More difficult|Easier|
|Stability|Less Stable|More Stable|
|Applications|Image Generation, Super-resolution, image-to-image translation|Image Denoising, Anamoly Detection, Signal Analysis|`,Z,k,xs="Ultimately, the best choice depends on one’s specific needs and priorities. If one needs high-quality images for tasks like generating realistic faces or landscapes, then a GAN might be the better choice. However, if one needs a model that is easier to train and more stable, then a VAE might be a better option.",ss,$,es,G,As="Training GANs involves a unique adversarial process where the generator and discriminator play a cat-and-mouse game.",ts,o,z,ks="<strong>Adversarial Training Process:</strong> The generator and discriminator are trained simultaneously. The generator aims to produce data that is indistinguishable from real data, while the discriminator strives to improve its ability to differentiate between real and fake samples.",ps,c,N,$s="Objective Function:",hs,as,Es='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><munder><mrow><mi>min</mi><mo>⁡</mo></mrow><mi>G</mi></munder><munder><mrow><mi>max</mi><mo>⁡</mo></mrow><mi>D</mi></munder><mi>L</mi><mo stretchy="false">(</mo><mi>D</mi><mo separator="true">,</mo><mi>G</mi><mo stretchy="false">)</mo><mo>=</mo><msub><mi mathvariant="double-struck">E</mi><mrow><mi>x</mi><mo>∼</mo><msub><mi>p</mi><mi>r</mi></msub><mo stretchy="false">(</mo><mi>x</mi><mo stretchy="false">)</mo></mrow></msub><mo stretchy="false">[</mo><mi>log</mi><mo>⁡</mo><mi>D</mi><mo stretchy="false">(</mo><mi>x</mi><mo stretchy="false">)</mo><mo stretchy="false">]</mo><mo>+</mo><msub><mi mathvariant="double-struck">E</mi><mrow><mi>x</mi><mo>∼</mo><msub><mi>p</mi><mi>g</mi></msub><mo stretchy="false">(</mo><mi>x</mi><mo stretchy="false">)</mo></mrow></msub><mo stretchy="false">[</mo><mi>log</mi><mo>⁡</mo><mo stretchy="false">(</mo><mn>1</mn><mo>−</mo><mi>D</mi><mo stretchy="false">(</mo><mi>x</mi><mo stretchy="false">)</mo><mo stretchy="false">]</mo></mrow><annotation encoding="application/x-tex">\\min_G \\max_D L(D, G)=\\mathbb{E}_{x \\sim p_{r}(x)} [\\log D(x)] + \\mathbb{E}_{x \\sim p_g(x)} [\\log(1 - D(x)]</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.4943em;vertical-align:-0.7443em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6679em;"><span style="top:-2.3557em;margin-left:0em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">G</span></span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span><span class="mop">min</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.7443em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.4306em;"><span style="top:-2.3557em;margin-left:0em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">D</span></span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span><span class="mop">max</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.7443em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">L</span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.02778em;">D</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">G</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.1052em;vertical-align:-0.3552em;"></span><span class="mord"><span class="mord mathbb">E</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3448em;"><span style="top:-2.5198em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">x</span><span class="mrel mtight">∼</span><span class="mord mtight"><span class="mord mathnormal mtight">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1645em;"><span style="top:-2.357em;margin-left:0em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">r</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.143em;"><span></span></span></span></span></span></span><span class="mopen mtight">(</span><span class="mord mathnormal mtight">x</span><span class="mclose mtight">)</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3552em;"><span></span></span></span></span></span></span><span class="mopen">[</span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">D</span><span class="mopen">(</span><span class="mord mathnormal">x</span><span class="mclose">)]</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1275em;vertical-align:-0.3775em;"></span><span class="mord"><span class="mord mathbb">E</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3448em;"><span style="top:-2.5198em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">x</span><span class="mrel mtight">∼</span><span class="mord mtight"><span class="mord mathnormal mtight">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1645em;"><span style="top:-2.357em;margin-left:0em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">g</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2819em;"><span></span></span></span></span></span></span><span class="mopen mtight">(</span><span class="mord mathnormal mtight">x</span><span class="mclose mtight">)</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3775em;"><span></span></span></span></span></span></span><span class="mopen">[</span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mopen">(</span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">D</span><span class="mopen">(</span><span class="mord mathnormal">x</span><span class="mclose">)]</span></span></span></span></span>',ns,cs,E,Gs="<strong>Iterative Improvement:</strong> As training progresses, the generator becomes adept at producing realistic samples, and the discriminator becomes more discerning. This adversarial loop continues until the generator generates data that is virtually indistinguishable from real data.",is,_,ls,T,_s='<li><a href="https://lilianweng.github.io/posts/2017-08-20-gan/" rel="nofollow">Lilian Weng’s Awesome Blog on GANs</a></li> <li><a href="https://jonathan-hui.medium.com/gan-whats-generative-adversarial-networks-and-its-application-f39ed278ef09" rel="nofollow">GAN — What is Generative Adversarial Networks</a></li> <li><a href="https://ai.stackexchange.com/questions/25601/what-are-the-fundamental-differences-between-vae-and-gan-for-image-generation" rel="nofollow">What are the fundamental differences between VAE and GAN for image generation?</a></li> <li><a href="https://stats.stackexchange.com/questions/541775/issues-with-gan-and-vae-models" rel="nofollow">Issues with GAN and VAE models</a></li> <li><a href="https://www.baeldung.com/cs/vae-vs-gan-image-generation" rel="nofollow">VAE Vs. GAN For Image Generation</a></li> <li><a href="https://towardsai.net/p/machine-learning/diffusion-models-vs-gans-vs-vaes-comparison-of-deep-generative-models" rel="nofollow">Diffusion Models vs. GANs vs. VAEs: Comparison of Deep Generative Models</a></li>',rs,M,ms;return g=new j({props:{title:"Generative Adversarial Networks",local:"generative-adversarial-networks",headingTag:"h1"}}),d=new j({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),b=new j({props:{title:"GANs vs VAEs",local:"gans-vs-vaes",headingTag:"h2"}}),$=new j({props:{title:"Training GANs",local:"training-gans",headingTag:"h2"}}),_=new j({props:{title:"References:",local:"references",headingTag:"h2"}}),{c(){p=l("meta"),W=n(),C=l("p"),U=n(),D(g.$$.fragment),R=n(),D(d.$$.fragment),F=n(),u=l("p"),u.innerHTML=ds,O=n(),f=l("ul"),f.innerHTML=us,B=n(),v=l("p"),v.textContent=fs,J=n(),y=l("p"),y.innerHTML=vs,K=n(),D(b.$$.fragment),Q=n(),w=l("p"),w.textContent=ys,Y=n(),x=l("ul"),x.innerHTML=bs,X=n(),A=l("p"),A.textContent=ws,Z=n(),k=l("p"),k.textContent=xs,ss=n(),D($.$$.fragment),es=n(),G=l("p"),G.textContent=As,ts=n(),o=l("ul"),z=l("li"),z.innerHTML=ks,ps=n(),c=l("li"),N=l("strong"),N.textContent=$s,hs=Ts(" The training process is guided by a min-max game type objective function which is used to optimize both the generator and the discriminator. The generator aims to minimize the probability of the discriminator correctly classifying generated samples as fake, while the discriminator seeks to maximize this probability. This objective function is represented as:"),as=new Is(!1),ns=Ts(`
Here, the discriminator tries to maximize this loss function whereas the generator tries to minimize it, hence the adversarial nature.`),cs=n(),E=l("li"),E.innerHTML=Gs,is=n(),D(_.$$.fragment),ls=n(),T=l("ol"),T.innerHTML=_s,rs=n(),M=l("p"),this.h()},l(s){const e=Ps("svelte-u9bgzb",document.head);p=r(e,"META",{name:!0,content:!0}),e.forEach(t),W=i(s),C=r(s,"P",{}),os(C).forEach(t),U=i(s),I(g.$$.fragment,s),R=i(s),I(d.$$.fragment,s),F=i(s),u=r(s,"P",{"data-svelte-h":!0}),m(u)!=="svelte-1vteoh7"&&(u.innerHTML=ds),O=i(s),f=r(s,"UL",{"data-svelte-h":!0}),m(f)!=="svelte-1ommlfq"&&(f.innerHTML=us),B=i(s),v=r(s,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1hb8plt"&&(v.textContent=fs),J=i(s),y=r(s,"P",{"data-svelte-h":!0}),m(y)!=="svelte-14zw7rg"&&(y.innerHTML=vs),K=i(s),I(b.$$.fragment,s),Q=i(s),w=r(s,"P",{"data-svelte-h":!0}),m(w)!=="svelte-ryo7sn"&&(w.textContent=ys),Y=i(s),x=r(s,"UL",{"data-svelte-h":!0}),m(x)!=="svelte-6a5dty"&&(x.innerHTML=bs),X=i(s),A=r(s,"P",{"data-svelte-h":!0}),m(A)!=="svelte-jpicdn"&&(A.textContent=ws),Z=i(s),k=r(s,"P",{"data-svelte-h":!0}),m(k)!=="svelte-9mfent"&&(k.textContent=xs),ss=i(s),I($.$$.fragment,s),es=i(s),G=r(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-hlrzgj"&&(G.textContent=As),ts=i(s),o=r(s,"UL",{});var L=os(o);z=r(L,"LI",{"data-svelte-h":!0}),m(z)!=="svelte-113ifpr"&&(z.innerHTML=ks),ps=i(L),c=r(L,"LI",{});var H=os(c);N=r(H,"STRONG",{"data-svelte-h":!0}),m(N)!=="svelte-1vgqxfx"&&(N.textContent=$s),hs=zs(H," The training process is guided by a min-max game type objective function which is used to optimize both the generator and the discriminator. The generator aims to minimize the probability of the discriminator correctly classifying generated samples as fake, while the discriminator seeks to maximize this probability. This objective function is represented as:"),as=Ss(H,!1),ns=zs(H,`
Here, the discriminator tries to maximize this loss function whereas the generator tries to minimize it, hence the adversarial nature.`),H.forEach(t),cs=i(L),E=r(L,"LI",{"data-svelte-h":!0}),m(E)!=="svelte-w0fr8a"&&(E.innerHTML=Gs),L.forEach(t),is=i(s),I(_.$$.fragment,s),ls=i(s),T=r(s,"OL",{"data-svelte-h":!0}),m(T)!=="svelte-1mdhw80"&&(T.innerHTML=_s),rs=i(s),M=r(s,"P",{}),os(M).forEach(t),this.h()},h(){Ns(p,"name","hf:doc:metadata"),Ns(p,"content",qs),as.a=ns},m(s,e){h(document.head,p),a(s,W,e),a(s,C,e),a(s,U,e),P(g,s,e),a(s,R,e),P(d,s,e),a(s,F,e),a(s,u,e),a(s,O,e),a(s,f,e),a(s,B,e),a(s,v,e),a(s,J,e),a(s,y,e),a(s,K,e),P(b,s,e),a(s,Q,e),a(s,w,e),a(s,Y,e),a(s,x,e),a(s,X,e),a(s,A,e),a(s,Z,e),a(s,k,e),a(s,ss,e),P($,s,e),a(s,es,e),a(s,G,e),a(s,ts,e),a(s,o,e),h(o,z),h(o,ps),h(o,c),h(c,N),h(c,hs),as.m(Es,c),h(c,ns),h(o,cs),h(o,E),a(s,is,e),P(_,s,e),a(s,ls,e),a(s,T,e),a(s,rs,e),a(s,M,e),ms=!0},p:Cs,i(s){ms||(S(g.$$.fragment,s),S(d.$$.fragment,s),S(b.$$.fragment,s),S($.$$.fragment,s),S(_.$$.fragment,s),ms=!0)},o(s){V(g.$$.fragment,s),V(d.$$.fragment,s),V(b.$$.fragment,s),V($.$$.fragment,s),V(_.$$.fragment,s),ms=!1},d(s){s&&(t(W),t(C),t(U),t(R),t(F),t(u),t(O),t(f),t(B),t(v),t(J),t(y),t(K),t(Q),t(w),t(Y),t(x),t(X),t(A),t(Z),t(k),t(ss),t(es),t(G),t(ts),t(o),t(is),t(ls),t(T),t(rs),t(M)),t(p),q(g,s),q(d,s),q(b,s),q($,s),q(_,s)}}}const qs='{"title":"Generative Adversarial Networks","local":"generative-adversarial-networks","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"GANs vs VAEs","local":"gans-vs-vaes","sections":[],"depth":2},{"title":"Training GANs","local":"training-gans","sections":[],"depth":2},{"title":"References:","local":"references","sections":[],"depth":2}],"depth":1}';function js(gs){return Ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fs extends Hs{constructor(p){super(),Ds(this,p,js,Vs,Ls,{})}}export{Fs as component};
