import{s as Ye,n as Ie,o as qe}from"../chunks/scheduler.22bf70d2.js";import{S as Qe,i as Se,g as s,s as i,r as c,A as We,h as r,f as a,c as l,j as Ze,u as p,x as o,k as Xe,y as Ne,a as n,v as m,d,t as h,w as u}from"../chunks/index.59178e06.js";import{C as $e}from"../chunks/CodeBlock.f7047b13.js";import{H as Y}from"../chunks/Heading.f8746c79.js";function Ee(ve){let f,Q,I,S,g,W,w,Je='🤗 Accelerate provides integrations to train on lower precision methods using specified supported hardware through the <code>TransformersEngine</code> and <code>MS-AMP</code> packages. This documentation will help guide you through what hardware is supported, how to configure your <a href="/docs/accelerate/v0.28.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> to leverage the low precision methods, and what you can expect when training.',N,y,E,M,je='To explore more of the nitty-gritty in training in FP8 with PyTorch and 🤗 Accelerate, check out the <a href="../concept_guides/low_precision_training.md">concept_guide</a> on why this can be difficult. But essentially rather than training in BF16, some (or all) aspects of training a model can be performed using 8 bits instead of 16. The challenge is doing so without degrading final performance.',K,T,Ue="This is only enabled on specific NVIDIA hardware, namely:",O,b,Pe="<li>Anything after the 3000 series consumer graphics cards (such as the 4090)</li> <li>Hopper-based GPU architectures (such as the <code>H100</code> and <code>H200</code>)</li>",D,$,Ce="What this will result in is some gain in the memory used (as we’ve cut the needed memory in half for some parts of training) and an increase in throughput <em>should</em> be seen as well for larger models that can replace certain layers with FP8-enabled ones.",ee,v,te,J,_e="Currently two different backends for FP8 are supported (<code>TransformersEngine</code> and <code>MS-AMP</code>), each with different capabilities and configurations.",ae,j,ke='To use either, the same core API is used. Just pass <code>mixed_precision=&quot;fp8&quot;</code> to either the <a href="/docs/accelerate/v0.28.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>, during <code>accelerate config</code> when prompted about mixed precision, or as part of your <code>config.yaml</code> file in the <code>mixed_precision</code> key:',ne,U,ie,P,xe='By default, if <code>MS-AMP</code> is available in your environment, 🤗 Accelerate will automatically utilize it as a backend. To specify it yourself (and customize other parts of the FP8 mixed precision setup), you can utilize the <a href="/docs/accelerate/v0.28.0/en/package_reference/utilities#accelerate.utils.FP8RecipeKwargs">utils.FP8RecipeKwargs</a>:',le,C,se,_,re,k,ze="Of the two, <code>MS-AMP</code> is traditionally the easier one to configure as there is only a single argument: the optimization level.",oe,x,Ae="Currently two levels of optimization are supported in the 🤗 Accelerate integration, <code>&quot;O1&quot;</code> and <code>&quot;O2&quot;</code> (using the letter ‘o’, not zero).",ce,z,Be="<li><code>&quot;O1&quot;</code> will cast the weight gradients and <code>all_reduce</code> communications to happen in 8-bit, while the rest are done in 16 bit. This reduces the general GPU memory usage and speeds up communication bandwidths.</li> <li><code>&quot;O2&quot;</code> will also cast first-order optimizer states into 8 bit, while the second order states are in FP16. (Currently just the <code>Adam</code> optimizer is supported). This tries its best to minimize final accuracy degradation and will save the highest potential memory.</li>",pe,A,Ge="To specify an optimization level, pass it to the <code>FP8KwargsHandler</code> by setting the <code>optimization_level</code> argument:",me,B,de,G,he,F,Fe='TransformersEngine has much more available for customizing how and what FP8 calculations are performed. A full list of supported arguments and what they mean are available in <a href="https://docs.nvidia.com/deeplearning/transformer-engine/user-guide/api/common.html" rel="nofollow">NVIDIA’s documentation</a>, however they are restated as part of <code>FP8KwargsHandler</code>’s docstring for your convenience.',ue,R,Re="🤗 Accelerate tries to set sensible defaults, but exploring and tweaking the various parameters yourself can lead to better performance potentially.",fe,H,He="To use it, specify <code>backend=&quot;te&quot;</code> and modify any of the arguments you want as part of your kwarg handler:",ge,L,we,V,ye,Z,Le="To learn more about training in FP8 please check out the following resources:",Me,X,Ve='<li><a href="../concept_guides/low_precision_training.md">Our concept guide</a> detailing into more about both TransformersEngine and MS-AMP</li> <li><a href="https://docs.nvidia.com/deeplearning/transformer-engine/user-guide/api/common.html" rel="nofollow">The <code>transformers-engine</code> documentation</a></li> <li><a href="https://azure.github.io/MS-AMP/docs/" rel="nofollow">The <code>MS-AMP</code> documentation</a></li>',Te,q,be;return g=new Y({props:{title:"Low Precision Training Methods",local:"low-precision-training-methods",headingTag:"h1"}}),y=new Y({props:{title:"What training on FP8 means",local:"what-training-on-fp8-means",headingTag:"h2"}}),v=new Y({props:{title:"Configuring the Accelerator",local:"configuring-the-accelerator",headingTag:"h2"}}),U=new $e({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnA4JTIyKQ==",highlighted:`from accelerate import Accelerator
<span class="hljs-attribute">accelerator</span> <span class="hljs-operator">=</span> Accelerator(mixed_precision<span class="hljs-operator">=</span><span class="hljs-string">&quot;fp8&quot;</span>)`,wrap:!1}}),C=new $e({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwRlA4UmVjaXBlS3dhcmdzJTBBa3dhcmdzJTIwJTNEJTIwJTVCRlA4UmVjaXBlS3dhcmdzKGJhY2tlbmQlM0QlMjJtc2FtcCUyMiklNUQlMEElMjMlMjBPciUyMHRvJTIwc3BlY2lmeSUyMHRoZSUyMGJhY2tlbmQlMjBhcyUyMCU2MFRyYW5zZm9ybWVyc0VuZ2luZSU2MCUyMGV2ZW4lMjBpZiUyME1TLUFNUCUyMGlzJTIwaW5zdGFsbGVkJTBBJTIzJTIwa3dhcmdzJTIwJTNEJTIwJTVCRlA4UmVjaXBlS3dhcmdzKGJhY2tlbmQlM0QlMjJ0ZSUyMiklNUQlMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKG1peGVkX3ByZWNpc2lvbiUzRCUyMmZwOCUyMiUyQyUyMGt3YXJnX2hhbmRsZXJzJTNEa3dhcmdzKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import FP8RecipeKwargs
kwargs = [FP8RecipeKwargs(<span class="hljs-attribute">backend</span>=<span class="hljs-string">&quot;msamp&quot;</span>)]
<span class="hljs-comment"># Or to specify the backend as \`TransformersEngine\` even if MS-AMP is installed</span>
<span class="hljs-comment"># kwargs = [FP8RecipeKwargs(backend=&quot;te&quot;)]</span>
accelerator = Accelerator(<span class="hljs-attribute">mixed_precision</span>=<span class="hljs-string">&quot;fp8&quot;</span>, <span class="hljs-attribute">kwarg_handlers</span>=kwargs)`,wrap:!1}}),_=new Y({props:{title:"Configuring MS-AMP",local:"configuring-ms-amp",headingTag:"h2"}}),B=new $e({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwRlA4UmVjaXBlS3dhcmdzJTBBa3dhcmdzJTIwJTNEJTIwJTVCRlA4UmVjaXBlS3dhcmdzKGJhY2tlbmQlM0QlMjJtc2FtcCUyMiUyQyUyMG9wdGltaXphdGlvbl9sZXZlbCUzRCUyMk8yJTIyKSU1RCUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnA4JTIyJTJDJTIwa3dhcmdfaGFuZGxlcnMlM0Rrd2FyZ3Mp",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import FP8RecipeKwargs
kwargs = [FP8RecipeKwargs(<span class="hljs-attribute">backend</span>=<span class="hljs-string">&quot;msamp&quot;</span>, <span class="hljs-attribute">optimization_level</span>=<span class="hljs-string">&quot;O2&quot;</span>)]
accelerator = Accelerator(<span class="hljs-attribute">mixed_precision</span>=<span class="hljs-string">&quot;fp8&quot;</span>, <span class="hljs-attribute">kwarg_handlers</span>=kwargs)`,wrap:!1}}),G=new Y({props:{title:"Configuring TransformersEngine",local:"configuring-transformersengine",headingTag:"h2"}}),L=new $e({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwRlA4UmVjaXBlS3dhcmdzJTBBa3dhcmdzJTIwJTNEJTIwJTVCRlA4UmVjaXBlS3dhcmdzKGJhY2tlbmQlM0QlMjJ0ZSUyMiUyQyUyMC4uLiklNUQlMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKG1peGVkX3ByZWNpc2lvbiUzRCUyMmZwOCUyMiUyQyUyMGt3YXJnX2hhbmRsZXJzJTNEa3dhcmdzKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import FP8RecipeKwargs
kwargs = [FP8RecipeKwargs(<span class="hljs-attribute">backend</span>=<span class="hljs-string">&quot;te&quot;</span>, <span class="hljs-built_in">..</span>.)]
accelerator = Accelerator(<span class="hljs-attribute">mixed_precision</span>=<span class="hljs-string">&quot;fp8&quot;</span>, <span class="hljs-attribute">kwarg_handlers</span>=kwargs)`,wrap:!1}}),V=new Y({props:{title:"Further Reading",local:"further-reading",headingTag:"h2"}}),{c(){f=s("meta"),Q=i(),I=s("p"),S=i(),c(g.$$.fragment),W=i(),w=s("p"),w.innerHTML=Je,N=i(),c(y.$$.fragment),E=i(),M=s("p"),M.innerHTML=je,K=i(),T=s("p"),T.textContent=Ue,O=i(),b=s("ul"),b.innerHTML=Pe,D=i(),$=s("p"),$.innerHTML=Ce,ee=i(),c(v.$$.fragment),te=i(),J=s("p"),J.innerHTML=_e,ae=i(),j=s("p"),j.innerHTML=ke,ne=i(),c(U.$$.fragment),ie=i(),P=s("p"),P.innerHTML=xe,le=i(),c(C.$$.fragment),se=i(),c(_.$$.fragment),re=i(),k=s("p"),k.innerHTML=ze,oe=i(),x=s("p"),x.innerHTML=Ae,ce=i(),z=s("ul"),z.innerHTML=Be,pe=i(),A=s("p"),A.innerHTML=Ge,me=i(),c(B.$$.fragment),de=i(),c(G.$$.fragment),he=i(),F=s("p"),F.innerHTML=Fe,ue=i(),R=s("p"),R.textContent=Re,fe=i(),H=s("p"),H.innerHTML=He,ge=i(),c(L.$$.fragment),we=i(),c(V.$$.fragment),ye=i(),Z=s("p"),Z.textContent=Le,Me=i(),X=s("ul"),X.innerHTML=Ve,Te=i(),q=s("p"),this.h()},l(e){const t=We("svelte-u9bgzb",document.head);f=r(t,"META",{name:!0,content:!0}),t.forEach(a),Q=l(e),I=r(e,"P",{}),Ze(I).forEach(a),S=l(e),p(g.$$.fragment,e),W=l(e),w=r(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-lwkaoz"&&(w.innerHTML=Je),N=l(e),p(y.$$.fragment,e),E=l(e),M=r(e,"P",{"data-svelte-h":!0}),o(M)!=="svelte-1hhkoyk"&&(M.innerHTML=je),K=l(e),T=r(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-10cwb11"&&(T.textContent=Ue),O=l(e),b=r(e,"UL",{"data-svelte-h":!0}),o(b)!=="svelte-5d1df8"&&(b.innerHTML=Pe),D=l(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1j45xey"&&($.innerHTML=Ce),ee=l(e),p(v.$$.fragment,e),te=l(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-ewzxpg"&&(J.innerHTML=_e),ae=l(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1i33iy7"&&(j.innerHTML=ke),ne=l(e),p(U.$$.fragment,e),ie=l(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-aw5uvh"&&(P.innerHTML=xe),le=l(e),p(C.$$.fragment,e),se=l(e),p(_.$$.fragment,e),re=l(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-13jlsqr"&&(k.innerHTML=ze),oe=l(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-11lh24s"&&(x.innerHTML=Ae),ce=l(e),z=r(e,"UL",{"data-svelte-h":!0}),o(z)!=="svelte-ha185h"&&(z.innerHTML=Be),pe=l(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-wx6vs8"&&(A.innerHTML=Ge),me=l(e),p(B.$$.fragment,e),de=l(e),p(G.$$.fragment,e),he=l(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-ngle0n"&&(F.innerHTML=Fe),ue=l(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-18df25g"&&(R.textContent=Re),fe=l(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-8khoko"&&(H.innerHTML=He),ge=l(e),p(L.$$.fragment,e),we=l(e),p(V.$$.fragment,e),ye=l(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-t5s4ol"&&(Z.textContent=Le),Me=l(e),X=r(e,"UL",{"data-svelte-h":!0}),o(X)!=="svelte-lri330"&&(X.innerHTML=Ve),Te=l(e),q=r(e,"P",{}),Ze(q).forEach(a),this.h()},h(){Xe(f,"name","hf:doc:metadata"),Xe(f,"content",Ke)},m(e,t){Ne(document.head,f),n(e,Q,t),n(e,I,t),n(e,S,t),m(g,e,t),n(e,W,t),n(e,w,t),n(e,N,t),m(y,e,t),n(e,E,t),n(e,M,t),n(e,K,t),n(e,T,t),n(e,O,t),n(e,b,t),n(e,D,t),n(e,$,t),n(e,ee,t),m(v,e,t),n(e,te,t),n(e,J,t),n(e,ae,t),n(e,j,t),n(e,ne,t),m(U,e,t),n(e,ie,t),n(e,P,t),n(e,le,t),m(C,e,t),n(e,se,t),m(_,e,t),n(e,re,t),n(e,k,t),n(e,oe,t),n(e,x,t),n(e,ce,t),n(e,z,t),n(e,pe,t),n(e,A,t),n(e,me,t),m(B,e,t),n(e,de,t),m(G,e,t),n(e,he,t),n(e,F,t),n(e,ue,t),n(e,R,t),n(e,fe,t),n(e,H,t),n(e,ge,t),m(L,e,t),n(e,we,t),m(V,e,t),n(e,ye,t),n(e,Z,t),n(e,Me,t),n(e,X,t),n(e,Te,t),n(e,q,t),be=!0},p:Ie,i(e){be||(d(g.$$.fragment,e),d(y.$$.fragment,e),d(v.$$.fragment,e),d(U.$$.fragment,e),d(C.$$.fragment,e),d(_.$$.fragment,e),d(B.$$.fragment,e),d(G.$$.fragment,e),d(L.$$.fragment,e),d(V.$$.fragment,e),be=!0)},o(e){h(g.$$.fragment,e),h(y.$$.fragment,e),h(v.$$.fragment,e),h(U.$$.fragment,e),h(C.$$.fragment,e),h(_.$$.fragment,e),h(B.$$.fragment,e),h(G.$$.fragment,e),h(L.$$.fragment,e),h(V.$$.fragment,e),be=!1},d(e){e&&(a(Q),a(I),a(S),a(W),a(w),a(N),a(E),a(M),a(K),a(T),a(O),a(b),a(D),a($),a(ee),a(te),a(J),a(ae),a(j),a(ne),a(ie),a(P),a(le),a(se),a(re),a(k),a(oe),a(x),a(ce),a(z),a(pe),a(A),a(me),a(de),a(he),a(F),a(ue),a(R),a(fe),a(H),a(ge),a(we),a(ye),a(Z),a(Me),a(X),a(Te),a(q)),a(f),u(g,e),u(y,e),u(v,e),u(U,e),u(C,e),u(_,e),u(B,e),u(G,e),u(L,e),u(V,e)}}}const Ke='{"title":"Low Precision Training Methods","local":"low-precision-training-methods","sections":[{"title":"What training on FP8 means","local":"what-training-on-fp8-means","sections":[],"depth":2},{"title":"Configuring the Accelerator","local":"configuring-the-accelerator","sections":[],"depth":2},{"title":"Configuring MS-AMP","local":"configuring-ms-amp","sections":[],"depth":2},{"title":"Configuring TransformersEngine","local":"configuring-transformersengine","sections":[],"depth":2},{"title":"Further Reading","local":"further-reading","sections":[],"depth":2}],"depth":1}';function Oe(ve){return qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nt extends Qe{constructor(f){super(),Se(this,f,Oe,Ee,Ye,{})}}export{nt as component};
