import{s as F,n as K,o as O}from"../chunks/scheduler.22bf70d2.js";import{S as ee,i as te,g as o,s as n,r as z,A as ie,h as r,f as i,c as s,j as D,u as E,x as T,k as I,y as ae,a,v as B,d as J,t as N,w as V}from"../chunks/index.59178e06.js";import{C as ne}from"../chunks/CodeBlock.f7047b13.js";import{H as W}from"../chunks/Heading.f8746c79.js";function se(X){let l,v,$,P,p,b,m,Z='A <a href="https://cloud.google.com/tpu/docs/intro-to-tpu" rel="nofollow">TPU (Tensor Processing Unit)</a> is a type of hardware specifically designed for training models efficiently. Accelerate supports TPU training, but there are a few things you should be aware of, namely graph compilation. This tutorial briefly discusses compilation, and for more details, take a look at the <a href="../concept_guides/training_tpu">Training on TPUs with Accelerate</a> guide.',x,c,U,h,G="A TPU creates a graph of all the operations in the training step such as the forward pass, backward pass and optimizer step. This is why the first training step always takes a while because building and compiling this graph takes time. But once compilation is complete, it is cached and all subsequent steps are much faster.",C,f,Y="The key is to avoid compiling your code again or else training is super slow. This means all your operations must be exactly the same:",M,d,j="<li>all tensors in your batches must have the same length (for example, no dynamic padding for NLP tasks)</li> <li>your code must be static (for example, no layers with for loops that have different lengths depending on the input such as a LSTM)</li>",k,u,L,g,q='A common language model design is to tie the weights of the embedding and softmax layers. However, moving the model to a TPU (either yourself or passing it to the <a href="/docs/accelerate/v0.28.0/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method) breaks the weight tying and you’ll need to retie the weights.',H,y,Q='To add special behavior (like weight tying) in your script for TPUs, set <code>distributed_type</code> to <code>DistributedType.TPU</code> first. Then you can use the <a href="https://huggingface.co/docs/transformers/v4.38.2/en/main_classes/model#transformers.PreTrainedModel.tie_weights" rel="nofollow">tie_weights</a> method to tie the weights.',A,w,R,_,S;return p=new W({props:{title:"TPU training",local:"tpu-training",headingTag:"h1"}}),c=new W({props:{title:"Compilation",local:"compilation",headingTag:"h2"}}),u=new W({props:{title:"Weight tying",local:"weight-tying",headingTag:"h2"}}),w=new ne({props:{code:"aWYlMjBhY2NlbGVyYXRvci5kaXN0cmlidXRlZF90eXBlJTIwJTNEJTNEJTIwRGlzdHJpYnV0ZWRUeXBlLlRQVSUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsLnRpZV93ZWlnaHRzKCk=",highlighted:`<span class="hljs-keyword">if</span> accelerator.distributed_type == DistributedType.TPU:
    model.tie_weights()`,wrap:!1}}),{c(){l=o("meta"),v=n(),$=o("p"),P=n(),z(p.$$.fragment),b=n(),m=o("p"),m.innerHTML=Z,x=n(),z(c.$$.fragment),U=n(),h=o("p"),h.textContent=G,C=n(),f=o("p"),f.textContent=Y,M=n(),d=o("ul"),d.innerHTML=j,k=n(),z(u.$$.fragment),L=n(),g=o("p"),g.innerHTML=q,H=n(),y=o("p"),y.innerHTML=Q,A=n(),z(w.$$.fragment),R=n(),_=o("p"),this.h()},l(e){const t=ie("svelte-u9bgzb",document.head);l=r(t,"META",{name:!0,content:!0}),t.forEach(i),v=s(e),$=r(e,"P",{}),D($).forEach(i),P=s(e),E(p.$$.fragment,e),b=s(e),m=r(e,"P",{"data-svelte-h":!0}),T(m)!=="svelte-1efoa6g"&&(m.innerHTML=Z),x=s(e),E(c.$$.fragment,e),U=s(e),h=r(e,"P",{"data-svelte-h":!0}),T(h)!=="svelte-76he8q"&&(h.textContent=G),C=s(e),f=r(e,"P",{"data-svelte-h":!0}),T(f)!=="svelte-1ga0n4t"&&(f.textContent=Y),M=s(e),d=r(e,"UL",{"data-svelte-h":!0}),T(d)!=="svelte-fxztf"&&(d.innerHTML=j),k=s(e),E(u.$$.fragment,e),L=s(e),g=r(e,"P",{"data-svelte-h":!0}),T(g)!=="svelte-1e3f51a"&&(g.innerHTML=q),H=s(e),y=r(e,"P",{"data-svelte-h":!0}),T(y)!=="svelte-md03gx"&&(y.innerHTML=Q),A=s(e),E(w.$$.fragment,e),R=s(e),_=r(e,"P",{}),D(_).forEach(i),this.h()},h(){I(l,"name","hf:doc:metadata"),I(l,"content",le)},m(e,t){ae(document.head,l),a(e,v,t),a(e,$,t),a(e,P,t),B(p,e,t),a(e,b,t),a(e,m,t),a(e,x,t),B(c,e,t),a(e,U,t),a(e,h,t),a(e,C,t),a(e,f,t),a(e,M,t),a(e,d,t),a(e,k,t),B(u,e,t),a(e,L,t),a(e,g,t),a(e,H,t),a(e,y,t),a(e,A,t),B(w,e,t),a(e,R,t),a(e,_,t),S=!0},p:K,i(e){S||(J(p.$$.fragment,e),J(c.$$.fragment,e),J(u.$$.fragment,e),J(w.$$.fragment,e),S=!0)},o(e){N(p.$$.fragment,e),N(c.$$.fragment,e),N(u.$$.fragment,e),N(w.$$.fragment,e),S=!1},d(e){e&&(i(v),i($),i(P),i(b),i(m),i(x),i(U),i(h),i(C),i(f),i(M),i(d),i(k),i(L),i(g),i(H),i(y),i(A),i(R),i(_)),i(l),V(p,e),V(c,e),V(u,e),V(w,e)}}}const le='{"title":"TPU training","local":"tpu-training","sections":[{"title":"Compilation","local":"compilation","sections":[],"depth":2},{"title":"Weight tying","local":"weight-tying","sections":[],"depth":2}],"depth":1}';function oe(X){return O(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class he extends ee{constructor(l){super(),te(this,l,oe,se,F,{})}}export{he as component};
