import{s as te,o as ee,n as le}from"../chunks/scheduler.d627b047.js";import{S as ne,i as ae,g as s,s as a,r as f,A as ie,h as o,f as l,c as i,j as Kt,u as m,x as r,k as Ot,y as se,a as n,v as u,d,t as c,w as h}from"../chunks/index.d48c4817.js";import{T as oe}from"../chunks/Tip.9bd3babf.js";import{C as g}from"../chunks/CodeBlock.5da89496.js";import{H as O}from"../chunks/Heading.47e562a9.js";function re(et){let p,_='LoftQ initialization does not require quantizing the base model with the <code>load_in_4bits</code> parameter in the <a href="https://huggingface.co/docs/transformers/v4.37.2/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method! Learn more about LoftQ initialization in the <a href="../developer_guides/lora#initialization">Initialization options</a> section.',T,y,w="Note: You can only perform LoftQ initialization on a GPU.";return{c(){p=s("p"),p.innerHTML=_,T=a(),y=s("p"),y.textContent=w},l(M){p=o(M,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1ppz1ve"&&(p.innerHTML=_),T=i(M),y=o(M,"P",{"data-svelte-h":!0}),r(y)!=="svelte-1rnmx2i"&&(y.textContent=w)},m(M,b){n(M,p,b),n(M,T,b),n(M,y,b)},p:le,d(M){M&&(l(p),l(T),l(y))}}}function pe(et){let p,_,T,y,w,M,b,Zt="Quantization represents data with fewer bits, making it a useful technique for reducing memory-usage and accelerating inference especially when it comes to large language models (LLMs). There are several ways to quantize a model including:",lt,$,zt='<li>optimizing which model weights are quantized with the <a href="https://hf.co/papers/2306.00978" rel="nofollow">AWQ</a> algorithm</li> <li>independently quantizing each row of a weight matrix with the <a href="https://hf.co/papers/2210.17323" rel="nofollow">GPTQ</a> algorithm</li> <li>quantizing to 8-bit and 4-bit precision with the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library</li>',nt,j,Qt='However, after a model is quantized it isn’t typically further trained for downstream tasks because training can be unstable due to the lower precision of the weights and activations. But since PEFT methods only add <em>extra</em> trainable parameters, this allows you to train a quantized model with a PEFT adapter on top! Combining quantization with PEFT can be a good strategy for training even the largest models on a single GPU. For example, <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> is a method that quantizes a model to 4-bits and then trains it with LoRA. This method allows you to finetune a 65B parameter model on a single 48GB GPU!',at,v,xt="In this guide, you’ll see how to quantize a model to 4-bits and train it with LoRA.",it,C,st,q,Rt='<a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> is a quantization library with a Transformers integration. With this integration, you can quantize a model to 8 or 4-bits and enable many other options by configuring the <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class. For example, you can:',ot,U,Et="<li>set <code>load_in_4bit=True</code> to quantize the model to 4-bits when you load it</li> <li>set <code>bnb_4bit_quant_type=&quot;nf4&quot;</code> to use a special 4-bit data type for weights initialized from a normal distribution</li> <li>set <code>bnb_4bit_use_double_quant=True</code> to use a nested quantization scheme to quantize the already quantized weights</li> <li>set <code>bnb_4bit_compute_dtype=torch.bfloat16</code> to use bfloat16 for faster computation</li>",rt,B,pt,I,Wt='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/v4.37.2/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',ft,L,mt,k,At='Next, you should call the <a href="/docs/peft/v0.8.0/en/package_reference/peft_model#peft.prepare_model_for_kbit_training">prepare_model_for_kbit_training()</a> function to preprocess the quantized model for traininng.',ut,Z,dt,z,Gt="Now that the quantized model is ready, let’s set up a configuration.",ct,Q,ht,x,Xt='Create a <a href="/docs/peft/v0.8.0/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> with the following parameters (or choose your own):',Mt,R,yt,E,Nt='Then use the <a href="/docs/peft/v0.8.0/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function to create a <a href="/docs/peft/v0.8.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> from the quantized model and configuration.',bt,W,Tt,A,Ft="You’re all set for training with whichever training method you prefer!",wt,G,Jt,X,Vt='<a href="https://hf.co/papers/2310.08659" rel="nofollow">LoftQ</a> initializes LoRA weights such that the quantization error is minimized, and it can improve performance when training quantized models. To get started, create a <code>LoftQConfig</code> and set <code>loftq_bits=4</code> for 4-bit quantization.',gt,J,_t,N,$t,F,Ht='Now pass the <code>loftq_config</code> to the <a href="/docs/peft/v0.8.0/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> to enable LoftQ initialization, and create a <a href="/docs/peft/v0.8.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> for training.',jt,V,vt,H,Ct,Y,Yt="QLoRA adds trainable weights to all the linear layers in the transformer architecture. Since the attribute names for these linear layers can vary across architectures, we provide a convenient flag <code>&#39;all-linear&#39;</code> for this setting:",qt,P,Ut,S,Bt,D,Pt="If you’re interested in learning more about quantization, the following may be helpful:",It,K,St='<li>Learn more about details about QLoRA and check out some benchmarks on its impact in the <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a> blog post.</li> <li>Read more about different quantization schemes in the Transformers <a href="https://hf.co/docs/transformers/main/quantization" rel="nofollow">Quantization</a> guide.</li>',Lt,tt,kt;return w=new O({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),C=new O({props:{title:"Quantize a model",local:"quantize-a-model",headingTag:"h2"}}),B=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)`,wrap:!1}}),L=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),Z=new g({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model = prepare_model_for_kbit_training(model)`,wrap:!1}}),Q=new O({props:{title:"LoraConfig",local:"loraconfig",headingTag:"h2"}}),R=new g({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),W=new g({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model, config)`,wrap:!1}}),G=new O({props:{title:"LoftQ initialization",local:"loftq-initialization",headingTag:"h3"}}),J=new oe({props:{warning:!0,$$slots:{default:[re]},$$scope:{ctx:et}}}),N=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb2Z0UUNvbmZpZyUyQyUyMExvcmFDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKSUwQWxvZnRxX2NvbmZpZyUyMCUzRCUyMExvZnRRQ29uZmlnKGxvZnRxX2JpdHMlM0Q0KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoftQConfig, LoraConfig, get_peft_model

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
loftq_config = LoftQConfig(loftq_bits=<span class="hljs-number">4</span>)`,wrap:!1}}),V=new g({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTNEJTIybG9mdHElMjIlMkMlMEElMjAlMjAlMjAlMjBsb2Z0cV9jb25maWclM0Rsb2Z0cV9jb25maWclMkMlMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBsb3JhX2NvbmZpZyk=",highlighted:`lora_config = LoraConfig(
    init_lora_weights=<span class="hljs-string">&quot;loftq&quot;</span>,
    loftq_config=loftq_config,
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

model = get_peft_model(model, lora_config)`,wrap:!1}}),H=new O({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),P=new g({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4pJTIwJTIzJTIwYWRkcyUyMExvUkElMjB0byUyMGFsbCUyMGxpbmVhciUyMGxheWVycyUyMGxpa2UlMjBpbiUyMFFMb1JB",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...) <span class="hljs-comment"># adds LoRA to all linear layers like in QLoRA</span>',wrap:!1}}),S=new O({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){p=s("meta"),_=a(),T=s("p"),y=a(),f(w.$$.fragment),M=a(),b=s("p"),b.textContent=Zt,lt=a(),$=s("ul"),$.innerHTML=zt,nt=a(),j=s("p"),j.innerHTML=Qt,at=a(),v=s("p"),v.textContent=xt,it=a(),f(C.$$.fragment),st=a(),q=s("p"),q.innerHTML=Rt,ot=a(),U=s("ul"),U.innerHTML=Et,rt=a(),f(B.$$.fragment),pt=a(),I=s("p"),I.innerHTML=Wt,ft=a(),f(L.$$.fragment),mt=a(),k=s("p"),k.innerHTML=At,ut=a(),f(Z.$$.fragment),dt=a(),z=s("p"),z.textContent=Gt,ct=a(),f(Q.$$.fragment),ht=a(),x=s("p"),x.innerHTML=Xt,Mt=a(),f(R.$$.fragment),yt=a(),E=s("p"),E.innerHTML=Nt,bt=a(),f(W.$$.fragment),Tt=a(),A=s("p"),A.textContent=Ft,wt=a(),f(G.$$.fragment),Jt=a(),X=s("p"),X.innerHTML=Vt,gt=a(),f(J.$$.fragment),_t=a(),f(N.$$.fragment),$t=a(),F=s("p"),F.innerHTML=Ht,jt=a(),f(V.$$.fragment),vt=a(),f(H.$$.fragment),Ct=a(),Y=s("p"),Y.innerHTML=Yt,qt=a(),f(P.$$.fragment),Ut=a(),f(S.$$.fragment),Bt=a(),D=s("p"),D.textContent=Pt,It=a(),K=s("ul"),K.innerHTML=St,Lt=a(),tt=s("p"),this.h()},l(t){const e=ie("svelte-u9bgzb",document.head);p=o(e,"META",{name:!0,content:!0}),e.forEach(l),_=i(t),T=o(t,"P",{}),Kt(T).forEach(l),y=i(t),m(w.$$.fragment,t),M=i(t),b=o(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-famg4s"&&(b.textContent=Zt),lt=i(t),$=o(t,"UL",{"data-svelte-h":!0}),r($)!=="svelte-10cnhiv"&&($.innerHTML=zt),nt=i(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-142xot4"&&(j.innerHTML=Qt),at=i(t),v=o(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1demhiu"&&(v.textContent=xt),it=i(t),m(C.$$.fragment,t),st=i(t),q=o(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-p346gx"&&(q.innerHTML=Rt),ot=i(t),U=o(t,"UL",{"data-svelte-h":!0}),r(U)!=="svelte-hfynw8"&&(U.innerHTML=Et),rt=i(t),m(B.$$.fragment,t),pt=i(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1naap7b"&&(I.innerHTML=Wt),ft=i(t),m(L.$$.fragment,t),mt=i(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1tecdsv"&&(k.innerHTML=At),ut=i(t),m(Z.$$.fragment,t),dt=i(t),z=o(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-11mx7fc"&&(z.textContent=Gt),ct=i(t),m(Q.$$.fragment,t),ht=i(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1s3mrov"&&(x.innerHTML=Xt),Mt=i(t),m(R.$$.fragment,t),yt=i(t),E=o(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1ul42go"&&(E.innerHTML=Nt),bt=i(t),m(W.$$.fragment,t),Tt=i(t),A=o(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-xd402n"&&(A.textContent=Ft),wt=i(t),m(G.$$.fragment,t),Jt=i(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-g845ls"&&(X.innerHTML=Vt),gt=i(t),m(J.$$.fragment,t),_t=i(t),m(N.$$.fragment,t),$t=i(t),F=o(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-7qybia"&&(F.innerHTML=Ht),jt=i(t),m(V.$$.fragment,t),vt=i(t),m(H.$$.fragment,t),Ct=i(t),Y=o(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-skv1xp"&&(Y.innerHTML=Yt),qt=i(t),m(P.$$.fragment,t),Ut=i(t),m(S.$$.fragment,t),Bt=i(t),D=o(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-agdyn7"&&(D.textContent=Pt),It=i(t),K=o(t,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-83nivc"&&(K.innerHTML=St),Lt=i(t),tt=o(t,"P",{}),Kt(tt).forEach(l),this.h()},h(){Ot(p,"name","hf:doc:metadata"),Ot(p,"content",fe)},m(t,e){se(document.head,p),n(t,_,e),n(t,T,e),n(t,y,e),u(w,t,e),n(t,M,e),n(t,b,e),n(t,lt,e),n(t,$,e),n(t,nt,e),n(t,j,e),n(t,at,e),n(t,v,e),n(t,it,e),u(C,t,e),n(t,st,e),n(t,q,e),n(t,ot,e),n(t,U,e),n(t,rt,e),u(B,t,e),n(t,pt,e),n(t,I,e),n(t,ft,e),u(L,t,e),n(t,mt,e),n(t,k,e),n(t,ut,e),u(Z,t,e),n(t,dt,e),n(t,z,e),n(t,ct,e),u(Q,t,e),n(t,ht,e),n(t,x,e),n(t,Mt,e),u(R,t,e),n(t,yt,e),n(t,E,e),n(t,bt,e),u(W,t,e),n(t,Tt,e),n(t,A,e),n(t,wt,e),u(G,t,e),n(t,Jt,e),n(t,X,e),n(t,gt,e),u(J,t,e),n(t,_t,e),u(N,t,e),n(t,$t,e),n(t,F,e),n(t,jt,e),u(V,t,e),n(t,vt,e),u(H,t,e),n(t,Ct,e),n(t,Y,e),n(t,qt,e),u(P,t,e),n(t,Ut,e),u(S,t,e),n(t,Bt,e),n(t,D,e),n(t,It,e),n(t,K,e),n(t,Lt,e),n(t,tt,e),kt=!0},p(t,[e]){const Dt={};e&2&&(Dt.$$scope={dirty:e,ctx:t}),J.$set(Dt)},i(t){kt||(d(w.$$.fragment,t),d(C.$$.fragment,t),d(B.$$.fragment,t),d(L.$$.fragment,t),d(Z.$$.fragment,t),d(Q.$$.fragment,t),d(R.$$.fragment,t),d(W.$$.fragment,t),d(G.$$.fragment,t),d(J.$$.fragment,t),d(N.$$.fragment,t),d(V.$$.fragment,t),d(H.$$.fragment,t),d(P.$$.fragment,t),d(S.$$.fragment,t),kt=!0)},o(t){c(w.$$.fragment,t),c(C.$$.fragment,t),c(B.$$.fragment,t),c(L.$$.fragment,t),c(Z.$$.fragment,t),c(Q.$$.fragment,t),c(R.$$.fragment,t),c(W.$$.fragment,t),c(G.$$.fragment,t),c(J.$$.fragment,t),c(N.$$.fragment,t),c(V.$$.fragment,t),c(H.$$.fragment,t),c(P.$$.fragment,t),c(S.$$.fragment,t),kt=!1},d(t){t&&(l(_),l(T),l(y),l(M),l(b),l(lt),l($),l(nt),l(j),l(at),l(v),l(it),l(st),l(q),l(ot),l(U),l(rt),l(pt),l(I),l(ft),l(mt),l(k),l(ut),l(dt),l(z),l(ct),l(ht),l(x),l(Mt),l(yt),l(E),l(bt),l(Tt),l(A),l(wt),l(Jt),l(X),l(gt),l(_t),l($t),l(F),l(jt),l(vt),l(Ct),l(Y),l(qt),l(Ut),l(Bt),l(D),l(It),l(K),l(Lt),l(tt)),l(p),h(w,t),h(C,t),h(B,t),h(L,t),h(Z,t),h(Q,t),h(R,t),h(W,t),h(G,t),h(J,t),h(N,t),h(V,t),h(H,t),h(P,t),h(S,t)}}}const fe='{"title":"Quantization","local":"quantization","sections":[{"title":"Quantize a model","local":"quantize-a-model","sections":[],"depth":2},{"title":"LoraConfig","local":"loraconfig","sections":[{"title":"LoftQ initialization","local":"loftq-initialization","sections":[],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function me(et){return ee(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ye extends ne{constructor(p){super(),ae(this,p,me,pe,te,{})}}export{ye as component};
