import{s as u4,o as _4,n as L}from"../chunks/scheduler.9bc65507.js";import{S as b4,i as M4,g as i,s as t,r as h,A as F4,h as l,f as d,c as a,j as v,u as p,x as f,k as w,y as r,a as F,v as u,d as _,t as b,w as M}from"../chunks/index.707bf1b6.js";import{T as Ix}from"../chunks/Tip.c2ecdbf4.js";import{D as x}from"../chunks/Docstring.17db21ae.js";import{C as k}from"../chunks/CodeBlock.54a9f38d.js";import{E as $}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as B}from"../chunks/Heading.342b1fa6.js";function T4(y){let n,C=`If your <code>NewModelConfig</code> is a subclass of <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, make sure its
<code>model_type</code> attribute is set to the same key you use when registering the config (here <code>&quot;new-model&quot;</code>).`,m,s,c=`Likewise, if your <code>NewModel</code> is a subclass of <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, make sure its
<code>config_class</code> attribute is set to the same class you use when registering the model (here
<code>NewModelConfig</code>).`;return{c(){n=i("p"),n.innerHTML=C,m=t(),s=i("p"),s.innerHTML=c},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-1upn364"&&(n.innerHTML=C),m=a(e),s=l(e,"P",{"data-svelte-h":!0}),f(s)!=="svelte-19m1s9a"&&(s.innerHTML=c)},m(e,T){F(e,n,T),F(e,m,T),F(e,s,T)},p:L,d(e){e&&(d(n),d(m),d(s))}}}function C4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMCh1c2VyLXVwbG9hZGVkKSUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmRibWR6JTJGYmVydC1iYXNlLWdlcm1hbi1jYXNlZCUyMiklMEElMEElMjMlMjBJZiUyMGNvbmZpZ3VyYXRpb24lMjBmaWxlJTIwaXMlMjBpbiUyMGElMjBkaXJlY3RvcnklMjAoZS5nLiUyQyUyMHdhcyUyMHNhdmVkJTIwdXNpbmclMjAqc2F2ZV9wcmV0cmFpbmVkKCcuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJykqKS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRmJlcnRfc2F2ZWRfbW9kZWwlMkYlMjIpJTBBJTBBJTIzJTIwTG9hZCUyMGElMjBzcGVjaWZpYyUyMGNvbmZpZ3VyYXRpb24lMjBmaWxlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGYmVydF9zYXZlZF9tb2RlbCUyRm15X2NvbmZpZ3VyYXRpb24uanNvbiUyMiklMEElMEElMjMlMjBDaGFuZ2UlMjBzb21lJTIwY29uZmlnJTIwYXR0cmlidXRlcyUyMHdoZW4lMjBsb2FkaW5nJTIwYSUyMHByZXRyYWluZWQlMjBjb25maWcuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtdW5jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSUyQyUyMGZvbyUzREZhbHNlKSUwQWNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQWNvbmZpZyUyQyUyMHVudXNlZF9rd2FyZ3MlMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlJTJDJTIwZm9vJTNERmFsc2UlMkMlMjByZXR1cm5fdW51c2VkX2t3YXJncyUzRFRydWUlMEEpJTBBY29uZmlnLm91dHB1dF9hdHRlbnRpb25zJTBBJTBBdW51c2VkX2t3YXJncw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co (user-uploaded) and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;dbmdz/bert-base-german-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If configuration file is in a directory (e.g., was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./test/bert_saved_model/&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load a specific configuration file.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./test/bert_saved_model/my_configuration.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Change some config attributes when loading a pretrained config.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>, foo=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>config, unused_kwargs = AutoConfig.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>, foo=<span class="hljs-literal">False</span>, return_unused_kwargs=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>unused_kwargs
{<span class="hljs-string">&#x27;foo&#x27;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function y4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMjMlMjBEb3dubG9hZCUyMHZvY2FidWxhcnklMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwdm9jYWJ1bGFyeSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMCh1c2VyLXVwbG9hZGVkKSUyMGFuZCUyMGNhY2hlLiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRibWR6JTJGYmVydC1iYXNlLWdlcm1hbi1jYXNlZCUyMiklMEElMEElMjMlMjBJZiUyMHZvY2FidWxhcnklMjBmaWxlcyUyMGFyZSUyMGluJTIwYSUyMGRpcmVjdG9yeSUyMChlLmcuJTIwdG9rZW5pemVyJTIwd2FzJTIwc2F2ZWQlMjB1c2luZyUyMCpzYXZlX3ByZXRyYWluZWQoJy4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYnKSopJTBBJTIzJTIwdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRlc3QlMkZiZXJ0X3NhdmVkX21vZGVsJTJGJTIyKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwdm9jYWJ1bGFyeSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGRlZmluZSUyMG1vZGVsLXNwZWNpZmljJTIwYXJndW1lbnRzJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyRmFjZWJvb2tBSSUyRnJvYmVydGEtYmFzZSUyMiUyQyUyMGFkZF9wcmVmaXhfc3BhY2UlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download vocabulary from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download vocabulary from huggingface.co (user-uploaded) and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;dbmdz/bert-base-german-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If vocabulary files are in a directory (e.g. tokenizer was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># tokenizer = AutoTokenizer.from_pretrained(&quot;./test/bert_saved_model/&quot;)</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download vocabulary from huggingface.co and define model-specific arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;FacebookAI/roberta-base&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function v4(y){let n,C="Passing <code>token=True</code> is required when you want to use a private model.";return{c(){n=i("p"),n.innerHTML=C},l(m){n=l(m,"P",{"data-svelte-h":!0}),f(n)!=="svelte-15auxyb"&&(n.innerHTML=C)},m(m,s){F(m,n,s)},p:L,d(m){m&&d(n)}}}function w4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBmZWF0dXJlJTIwZXh0cmFjdG9yJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1iYXNlLTk2MGglMjIpJTBBJTBBJTIzJTIwSWYlMjBmZWF0dXJlJTIwZXh0cmFjdG9yJTIwZmlsZXMlMjBhcmUlMjBpbiUyMGElMjBkaXJlY3RvcnklMjAoZS5nLiUyMGZlYXR1cmUlMjBleHRyYWN0b3IlMjB3YXMlMjBzYXZlZCUyMHVzaW5nJTIwKnNhdmVfcHJldHJhaW5lZCgnLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRicpKiklMEElMjMlMjBmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download feature extractor from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If feature extractor files are in a directory (e.g. feature extractor was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># feature_extractor = AutoFeatureExtractor.from_pretrained(&quot;./test/saved_model/&quot;)</span>`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function x4(y){let n,C="Passing <code>token=True</code> is required when you want to use a private model.";return{c(){n=i("p"),n.innerHTML=C},l(m){n=l(m,"P",{"data-svelte-h":!0}),f(n)!=="svelte-15auxyb"&&(n.innerHTML=C)},m(m,s){F(m,n,s)},p:L,d(m){m&&d(n)}}}function L4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQSUyMyUyMERvd25sb2FkJTIwaW1hZ2UlMjBwcm9jZXNzb3IlMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrJTIyKSUwQSUwQSUyMyUyMElmJTIwaW1hZ2UlMjBwcm9jZXNzb3IlMjBmaWxlcyUyMGFyZSUyMGluJTIwYSUyMGRpcmVjdG9yeSUyMChlLmcuJTIwaW1hZ2UlMjBwcm9jZXNzb3IlMjB3YXMlMjBzYXZlZCUyMHVzaW5nJTIwKnNhdmVfcHJldHJhaW5lZCgnLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRicpKiklMEElMjMlMjBpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download image processor from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If image processor files are in a directory (e.g. image processor was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># image_processor = AutoImageProcessor.from_pretrained(&quot;./test/saved_model/&quot;)</span>`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function k4(y){let n,C="Passing <code>token=True</code> is required when you want to use a private model.";return{c(){n=i("p"),n.innerHTML=C},l(m){n=l(m,"P",{"data-svelte-h":!0}),f(n)!=="svelte-15auxyb"&&(n.innerHTML=C)},m(m,s){F(m,n,s)},p:L,d(m){m&&d(n)}}}function $4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEElMjMlMjBEb3dubG9hZCUyMHByb2Nlc3NvciUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS05NjBoJTIyKSUwQSUwQSUyMyUyMElmJTIwcHJvY2Vzc29yJTIwZmlsZXMlMjBhcmUlMjBpbiUyMGElMjBkaXJlY3RvcnklMjAoZS5nLiUyMHByb2Nlc3NvciUyMHdhcyUyMHNhdmVkJTIwdXNpbmclMjAqc2F2ZV9wcmV0cmFpbmVkKCcuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJykqKSUwQSUyMyUyMHByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download processor from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If processor files are in a directory (e.g. processor was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># processor = AutoProcessor.from_pretrained(&quot;./test/saved_model/&quot;)</span>`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function B4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function A4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function j4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbCUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWwuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModel.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function Z4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbCUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function R4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModel.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function S4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function G4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JQcmVUcmFpbmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yUHJlVHJhaW5pbmcuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForPreTraining.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function W4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JQcmVUcmFpbmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JQcmVUcmFpbmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForPreTraining.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function P4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclByZVRyYWluaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForPreTraining.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function V4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclByZVRyYWluaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yUHJlVHJhaW5pbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JQcmVUcmFpbmluZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForPreTraining.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function J4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yUHJlVHJhaW5pbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JQcmVUcmFpbmluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForPreTraining.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function E4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yUHJlVHJhaW5pbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForPreTraining.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function I4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function U4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function N4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function q4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function X4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForCausalLM.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function D4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function Q4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNYXNrZWRMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yTWFza2VkTE0uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function H4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNYXNrZWRMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function Y4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck1hc2tlZExNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedLM.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function z4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck1hc2tlZExNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTWFza2VkTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function O4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTWFza2VkTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JNYXNrZWRMTS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMaskedLM.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function K4(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTWFza2VkTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMaskedLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function eX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtdDUlMkZ0NS1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function oX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtdDUlMkZ0NS1iYXNlJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LWJhc2UlMjIlMkMlMjBvdXRwdXRfYXR0ZW50aW9ucyUzRFRydWUpJTBBbW9kZWwuY29uZmlnLm91dHB1dF9hdHRlbnRpb25zJTBBJTBBJTIzJTIwTG9hZGluZyUyMGZyb20lMjBhJTIwVEYlMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBQeVRvcmNoJTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0Zl9tb2RlbCUyRnQ1X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZ0NV90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/t5_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/t5_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function rX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSeq2SeqLM.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function nX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLXQ1JTJGdDUtYmFzZSUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LWJhc2UlMjIlMkMlMjBvdXRwdXRfYXR0ZW50aW9ucyUzRFRydWUpJTBBbW9kZWwuY29uZmlnLm91dHB1dF9hdHRlbnRpb25zJTBBJTBBJTIzJTIwTG9hZGluZyUyMGZyb20lMjBhJTIwUHlUb3JjaCUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFRlbnNvckZsb3clMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnB0X21vZGVsJTJGdDVfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGdDVfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/t5_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSeq2SeqLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/t5_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function tX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU2VxMlNlcUxNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLXQ1JTJGdDUtYmFzZSUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSeq2SeqLM.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function aX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU2VxMlNlcUxNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LWJhc2UlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LWJhc2UlMjIlMkMlMjBvdXRwdXRfYXR0ZW50aW9ucyUzRFRydWUpJTBBbW9kZWwuY29uZmlnLm91dHB1dF9hdHRlbnRpb25zJTBBJTBBJTIzJTIwTG9hZGluZyUyMGZyb20lMjBhJTIwUHlUb3JjaCUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFRlbnNvckZsb3clMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnB0X21vZGVsJTJGdDVfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZ0NV9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/t5_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSeq2SeqLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/t5_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function sX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function iX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function lX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function dX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function mX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSequenceClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function cX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function fX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function gX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function hX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function pX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function uX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMultipleChoice.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function _X(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMultipleChoice.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function bX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForNextSentencePrediction.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function MX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForNextSentencePrediction.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function FX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForNextSentencePrediction.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function TX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForNextSentencePrediction.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function CX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForNextSentencePrediction.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function yX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForNextSentencePrediction.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function vX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function wX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function xX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTokenClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function LX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTokenClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function kX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForTokenClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function $X(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForTokenClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function BX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function AX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function jX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function ZX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function RX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function SX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function GX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JEZXB0aEVzdGltYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function WX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JEZXB0aEVzdGltYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yRGVwdGhFc3RpbWF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yRGVwdGhFc3RpbWF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function PX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function VX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function JX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForImageClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function EX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function IX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForImageClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function UX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function NX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaWRlb0NsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaWRlb0NsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVideoClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVideoClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function qX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaWRlb0NsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclZpZGVvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaWRlb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclZpZGVvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVideoClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVideoClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVideoClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVideoClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function XX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMaskedImageModeling

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedImageModeling.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function DX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck1hc2tlZEltYWdlTW9kZWxpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck1hc2tlZEltYWdlTW9kZWxpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMaskedImageModeling

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedImageModeling.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function QX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck1hc2tlZEltYWdlTW9kZWxpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTWFza2VkSW1hZ2VNb2RlbGluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMaskedImageModeling

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedImageModeling.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function HX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck1hc2tlZEltYWdlTW9kZWxpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMaskedImageModeling

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedImageModeling.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function YX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JPYmplY3REZXRlY3Rpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function zX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JPYmplY3REZXRlY3Rpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function OX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVNlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VTZWdtZW50YXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForImageSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageSegmentation.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function KX(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVNlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVNlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForImageSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function e3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function o3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function r3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function n3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function t3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW5zdGFuY2VTZWdtZW50YXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForInstanceSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForInstanceSegmentation.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function a3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckluc3RhbmNlU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckluc3RhbmNlU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForInstanceSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForInstanceSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForInstanceSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForInstanceSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function s3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JVbml2ZXJzYWxTZWdtZW50YXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclVuaXZlcnNhbFNlZ21lbnRhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForUniversalSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForUniversalSegmentation.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function i3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JVbml2ZXJzYWxTZWdtZW50YXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclVuaXZlcnNhbFNlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForUniversalSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForUniversalSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForUniversalSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForUniversalSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function l3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function d3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function m3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForZeroShotImageClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function c3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yWmVyb1Nob3RJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForZeroShotImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForZeroShotImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForZeroShotImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function f3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RPYmplY3REZXRlY3Rpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function g3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90T2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90T2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function h3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function p3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function u3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForAudioClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function _3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForAudioClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function b3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb0ZyYW1lQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioFrameClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioFrameClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function M3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb0ZyYW1lQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioFrameClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioFrameClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function F3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JDVEMlMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNUQy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCTC

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function T3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JDVEMlMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNUQy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCTC

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function C3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSpeechSeq2Seq.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function y3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSpeechSeq2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function v3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXElMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSpeechSeq2Seq.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function w3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXElMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSpeechSeq2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function x3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSpeechSeq2Seq.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function L3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSpeechSeq2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function k3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb1hWZWN0b3IlMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvWFZlY3Rvci5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioXVector

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioXVector.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function $3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb1hWZWN0b3IlMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9YVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9YVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvWFZlY3Rvci5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioXVector

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioXVector.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioXVector.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioXVector.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function B3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JUYWJsZVF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZS1maW5ldHVuZWQtd3RxJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVGFibGVRdWVzdGlvbkFuc3dlcmluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForTableQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTableQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function A3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JUYWJsZVF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVGFibGVRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZS1maW5ldHVuZWQtd3RxJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZ0YXBhc190Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRnRhcGFzX3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForTableQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTableQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTableQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/tapas_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTableQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/tapas_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function j3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC13dHElMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForTableQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTableQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function Z3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JUYWJsZVF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC13dHElMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yVGFibGVRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZS1maW5ldHVuZWQtd3RxJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRnRhcGFzX3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JUYWJsZVF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZ0YXBhc19weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForTableQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTableQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTableQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/tapas_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTableQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/tapas_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function R3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyaW1waXJhJTJGbGF5b3V0bG0tZG9jdW1lbnQtcWElMjIlMkMlMjByZXZpc2lvbiUzRCUyMjUyZTAxYjMlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function S3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRvY3VtZW50UXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmltcGlyYSUyRmxheW91dGxtLWRvY3VtZW50LXFhJTIyJTJDJTIwcmV2aXNpb24lM0QlMjI1MmUwMWIzJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiUyQyUyMHJldmlzaW9uJTNEJTIyNTJlMDFiMyUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGbGF5b3V0bG1fdGZfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZsYXlvdXRsbV90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/layoutlm_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/layoutlm_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function G3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckRvY3VtZW50UXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiUyQyUyMHJldmlzaW9uJTNEJTIyNTJlMDFiMyUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yRG9jdW1lbnRRdWVzdGlvbkFuc3dlcmluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForDocumentQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function W3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckRvY3VtZW50UXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiUyQyUyMHJldmlzaW9uJTNEJTIyNTJlMDFiMyUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiUyQyUyMHJldmlzaW9uJTNEJTIyNTJlMDFiMyUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZsYXlvdXRsbV9wdF9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yRG9jdW1lbnRRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGbGF5b3V0bG1fcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForDocumentQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForDocumentQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/layoutlm_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForDocumentQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/layoutlm_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function P3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaXN1YWxRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmRhbmRlbGluJTJGdmlsdC1iMzItZmluZXR1bmVkLXZxYSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclZpc3VhbFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVisualQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;dandelin/vilt-b32-finetuned-vqa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVisualQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function V3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaXN1YWxRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaXN1YWxRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZGFuZGVsaW4lMkZ2aWx0LWIzMi1maW5ldHVuZWQtdnFhJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaXN1YWxRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZGFuZGVsaW4lMkZ2aWx0LWIzMi1maW5ldHVuZWQtdnFhJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZ2aWx0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVmlzdWFsUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRnZpbHRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVisualQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVisualQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;dandelin/vilt-b32-finetuned-vqa&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVisualQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;dandelin/vilt-b32-finetuned-vqa&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/vilt_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVisualQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/vilt_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function J3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaXNpb24yU2VxJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVision2Seq.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function E3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaXNpb24yU2VxJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclZpc2lvbjJTZXEuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclZpc2lvbjJTZXEuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVision2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function I3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclZpc2lvbjJTZXElMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForVision2Seq.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function U3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclZpc2lvbjJTZXElMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForVision2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function N3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yVmlzaW9uMlNlcSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclZpc2lvbjJTZXEuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForVision2Seq.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function q3(y){let n,C="Examples:",m,s,c;return s=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yVmlzaW9uMlNlcSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclZpc2lvbjJTZXEuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForVision2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=C,m=t(),h(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=C),m=a(e),p(s.$$.fragment,e)},m(e,T){F(e,n,T),F(e,m,T),u(s,e,T),c=!0},p:L,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(n),d(m)),M(s,e)}}}function X3(y){let n,C,m,s,c,e,T,DV=`In many cases, the architecture you want to use can be guessed from the name or the path of the pretrained model you
are supplying to the <code>from_pretrained()</code> method. AutoClasses are here to do this job for you so that you
automatically retrieve the relevant model given the name/path to the pretrained weights/config/vocabulary.`,Av,yd,QV=`Instantiating one of <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoConfig">AutoConfig</a>, <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel">AutoModel</a>, and
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a> will directly create a class of the relevant architecture. For instance`,jv,vd,Zv,wd,HV='will create a model that is an instance of <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertModel">BertModel</a>.',Rv,xd,YV="There is one class of <code>AutoModel</code> for each task, and for each backend (PyTorch, TensorFlow, or Flax).",Sv,Ld,Gv,kd,zV=`Each of the auto classes has a method to be extended with your custom classes. For instance, if you have defined a
custom class of model <code>NewModel</code>, make sure you have a <code>NewModelConfig</code> then you can add those to the auto
classes like this:`,Wv,$d,Pv,Bd,OV="You will then be able to use the auto classes like you would usually do!",Vv,ys,Jv,Ad,Ev,me,jd,Ux,_p,KV=`This is a generic configuration class that will be instantiated as one of the configuration classes of the library
when created with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoConfig.from_pretrained">from_pretrained()</a> class method.`,Nx,bp,e0="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",qx,Eo,Zd,Xx,Mp,o0="Instantiate one of the configuration classes of the library from a pretrained model configuration.",Dx,Fp,r0=`The configuration class to instantiate is selected based on the <code>model_type</code> property of the config object that
is loaded, or when it’s missing, by falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Qx,Tp,n0='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> (ALBERT model)</li> <li><strong>align</strong> — <a href="/docs/transformers/main/en/model_doc/align#transformers.AlignConfig">AlignConfig</a> (ALIGN model)</li> <li><strong>altclip</strong> — <a href="/docs/transformers/main/en/model_doc/altclip#transformers.AltCLIPConfig">AltCLIPConfig</a> (AltCLIP model)</li> <li><strong>audio-spectrogram-transformer</strong> — <a href="/docs/transformers/main/en/model_doc/audio-spectrogram-transformer#transformers.ASTConfig">ASTConfig</a> (Audio Spectrogram Transformer model)</li> <li><strong>autoformer</strong> — <a href="/docs/transformers/main/en/model_doc/autoformer#transformers.AutoformerConfig">AutoformerConfig</a> (Autoformer model)</li> <li><strong>bark</strong> — <a href="/docs/transformers/main/en/model_doc/bark#transformers.BarkConfig">BarkConfig</a> (Bark model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.BartConfig">BartConfig</a> (BART model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a> (BEiT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertConfig">BertConfig</a> (BERT model)</li> <li><strong>bert-generation</strong> — <a href="/docs/transformers/main/en/model_doc/bert-generation#transformers.BertGenerationConfig">BertGenerationConfig</a> (Bert Generation model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/main/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusConfig">BigBirdPegasusConfig</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig">BioGptConfig</a> (BioGpt model)</li> <li><strong>bit</strong> — <a href="/docs/transformers/main/en/model_doc/bit#transformers.BitConfig">BitConfig</a> (BiT model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/main/en/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/main/en/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> (BlenderbotSmall model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/main/en/model_doc/blip#transformers.BlipConfig">BlipConfig</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/main/en/model_doc/blip-2#transformers.Blip2Config">Blip2Config</a> (BLIP-2 model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/en/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> (BLOOM model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/main/en/model_doc/bridgetower#transformers.BridgeTowerConfig">BridgeTowerConfig</a> (BridgeTower model)</li> <li><strong>bros</strong> — <a href="/docs/transformers/main/en/model_doc/bros#transformers.BrosConfig">BrosConfig</a> (BROS model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineConfig">CanineConfig</a> (CANINE model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/main/en/model_doc/chinese_clip#transformers.ChineseCLIPConfig">ChineseCLIPConfig</a> (Chinese-CLIP model)</li> <li><strong>chinese_clip_vision_model</strong> — <a href="/docs/transformers/main/en/model_doc/chinese_clip#transformers.ChineseCLIPVisionConfig">ChineseCLIPVisionConfig</a> (ChineseCLIPVisionModel model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/main/en/model_doc/clap#transformers.ClapConfig">ClapConfig</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPConfig">CLIPConfig</a> (CLIP model)</li> <li><strong>clip_vision_model</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionConfig">CLIPVisionConfig</a> (CLIPVisionModel model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegConfig">CLIPSegConfig</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/main/en/model_doc/clvp#transformers.ClvpConfig">ClvpConfig</a> (CLVP model)</li> <li><strong>code_llama</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaConfig">LlamaConfig</a> (CodeLlama model)</li> <li><strong>codegen</strong> — <a href="/docs/transformers/main/en/model_doc/codegen#transformers.CodeGenConfig">CodeGenConfig</a> (CodeGen model)</li> <li><strong>cohere</strong> — <a href="/docs/transformers/main/en/model_doc/cohere#transformers.CohereConfig">CohereConfig</a> (Cohere model)</li> <li><strong>conditional_detr</strong> — <a href="/docs/transformers/main/en/model_doc/conditional_detr#transformers.ConditionalDetrConfig">ConditionalDetrConfig</a> (Conditional DETR model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/en/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> (ConvBERT model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/main/en/model_doc/convnext#transformers.ConvNextConfig">ConvNextConfig</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/main/en/model_doc/convnextv2#transformers.ConvNextV2Config">ConvNextV2Config</a> (ConvNeXTV2 model)</li> <li><strong>cpmant</strong> — <a href="/docs/transformers/main/en/model_doc/cpmant#transformers.CpmAntConfig">CpmAntConfig</a> (CPM-Ant model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> (CTRL model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/main/en/model_doc/cvt#transformers.CvtConfig">CvtConfig</a> (CvT model)</li> <li><strong>data2vec-audio</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecAudioConfig">Data2VecAudioConfig</a> (Data2VecAudio model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> (Data2VecText model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecVisionConfig">Data2VecVisionConfig</a> (Data2VecVision model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/en/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> (DeBERTa-v2 model)</li> <li><strong>decision_transformer</strong> — <a href="/docs/transformers/main/en/model_doc/decision_transformer#transformers.DecisionTransformerConfig">DecisionTransformerConfig</a> (Decision Transformer model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/main/en/model_doc/deformable_detr#transformers.DeformableDetrConfig">DeformableDetrConfig</a> (Deformable DETR model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a> (DeiT model)</li> <li><strong>depth_anything</strong> — <a href="/docs/transformers/main/en/model_doc/depth_anything#transformers.DepthAnythingConfig">DepthAnythingConfig</a> (Depth Anything model)</li> <li><strong>deta</strong> — <a href="/docs/transformers/main/en/model_doc/deta#transformers.DetaConfig">DetaConfig</a> (DETA model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a> (DETR model)</li> <li><strong>dinat</strong> — <a href="/docs/transformers/main/en/model_doc/dinat#transformers.DinatConfig">DinatConfig</a> (DiNAT model)</li> <li><strong>dinov2</strong> — <a href="/docs/transformers/main/en/model_doc/dinov2#transformers.Dinov2Config">Dinov2Config</a> (DINOv2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> (DistilBERT model)</li> <li><strong>donut-swin</strong> — <a href="/docs/transformers/main/en/model_doc/donut#transformers.DonutSwinConfig">DonutSwinConfig</a> (DonutSwin model)</li> <li><strong>dpr</strong> — <a href="/docs/transformers/main/en/model_doc/dpr#transformers.DPRConfig">DPRConfig</a> (DPR model)</li> <li><strong>dpt</strong> — <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTConfig">DPTConfig</a> (DPT model)</li> <li><strong>efficientformer</strong> — <a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a> (EfficientFormer model)</li> <li><strong>efficientnet</strong> — <a href="/docs/transformers/main/en/model_doc/efficientnet#transformers.EfficientNetConfig">EfficientNetConfig</a> (EfficientNet model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> (ELECTRA model)</li> <li><strong>encodec</strong> — <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecConfig">EncodecConfig</a> (EnCodec model)</li> <li><strong>encoder-decoder</strong> — <a href="/docs/transformers/main/en/model_doc/encoder-decoder#transformers.EncoderDecoderConfig">EncoderDecoderConfig</a> (Encoder decoder model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/main/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a> (ErnieM model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/main/en/model_doc/esm#transformers.EsmConfig">EsmConfig</a> (ESM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/main/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a> (Falcon model)</li> <li><strong>fastspeech2_conformer</strong> — <a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerConfig">FastSpeech2ConformerConfig</a> (FastSpeech2Conformer model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> (FlauBERT model)</li> <li><strong>flava</strong> — <a href="/docs/transformers/main/en/model_doc/flava#transformers.FlavaConfig">FlavaConfig</a> (FLAVA model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/main/en/model_doc/fnet#transformers.FNetConfig">FNetConfig</a> (FNet model)</li> <li><strong>focalnet</strong> — <a href="/docs/transformers/main/en/model_doc/focalnet#transformers.FocalNetConfig">FocalNetConfig</a> (FocalNet model)</li> <li><strong>fsmt</strong> — <a href="/docs/transformers/main/en/model_doc/fsmt#transformers.FSMTConfig">FSMTConfig</a> (FairSeq Machine-Translation model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> (Funnel Transformer model)</li> <li><strong>fuyu</strong> — <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuConfig">FuyuConfig</a> (Fuyu model)</li> <li><strong>gemma</strong> — <a href="/docs/transformers/main/en/model_doc/gemma#transformers.GemmaConfig">GemmaConfig</a> (Gemma model)</li> <li><strong>git</strong> — <a href="/docs/transformers/main/en/model_doc/git#transformers.GitConfig">GitConfig</a> (GIT model)</li> <li><strong>glpn</strong> — <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNConfig">GLPNConfig</a> (GLPN model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeConfig">GPTBigCodeConfig</a> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neo#transformers.GPTNeoConfig">GPTNeoConfig</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neox#transformers.GPTNeoXConfig">GPTNeoXConfig</a> (GPT NeoX model)</li> <li><strong>gpt_neox_japanese</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseConfig">GPTNeoXJapaneseConfig</a> (GPT NeoX Japanese model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/main/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> (GPT-J model)</li> <li><strong>gptsan-japanese</strong> — <a href="/docs/transformers/main/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseConfig">GPTSanJapaneseConfig</a> (GPTSAN-japanese model)</li> <li><strong>graphormer</strong> — <a href="/docs/transformers/main/en/model_doc/graphormer#transformers.GraphormerConfig">GraphormerConfig</a> (Graphormer model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/main/en/model_doc/groupvit#transformers.GroupViTConfig">GroupViTConfig</a> (GroupViT model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertConfig">HubertConfig</a> (Hubert model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/main/en/model_doc/ibert#transformers.IBertConfig">IBertConfig</a> (I-BERT model)</li> <li><strong>idefics</strong> — <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsConfig">IdeficsConfig</a> (IDEFICS model)</li> <li><strong>imagegpt</strong> — <a href="/docs/transformers/main/en/model_doc/imagegpt#transformers.ImageGPTConfig">ImageGPTConfig</a> (ImageGPT model)</li> <li><strong>informer</strong> — <a href="/docs/transformers/main/en/model_doc/informer#transformers.InformerConfig">InformerConfig</a> (Informer model)</li> <li><strong>instructblip</strong> — <a href="/docs/transformers/main/en/model_doc/instructblip#transformers.InstructBlipConfig">InstructBlipConfig</a> (InstructBLIP model)</li> <li><strong>jukebox</strong> — <a href="/docs/transformers/main/en/model_doc/jukebox#transformers.JukeboxConfig">JukeboxConfig</a> (Jukebox model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/main/en/model_doc/kosmos-2#transformers.Kosmos2Config">Kosmos2Config</a> (KOSMOS-2 model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv2#transformers.LayoutLMv2Config">LayoutLMv2Config</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.LayoutLMv3Config">LayoutLMv3Config</a> (LayoutLMv3 model)</li> <li><strong>led</strong> — <a href="/docs/transformers/main/en/model_doc/led#transformers.LEDConfig">LEDConfig</a> (LED model)</li> <li><strong>levit</strong> — <a href="/docs/transformers/main/en/model_doc/levit#transformers.LevitConfig">LevitConfig</a> (LeViT model)</li> <li><strong>lilt</strong> — <a href="/docs/transformers/main/en/model_doc/lilt#transformers.LiltConfig">LiltConfig</a> (LiLT model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaConfig">LlamaConfig</a> (LLaMA model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaConfig">LlavaConfig</a> (LLaVa model)</li> <li><strong>llava_next</strong> — <a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextConfig">LlavaNextConfig</a> (LLaVA-NeXT model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/main/en/model_doc/longformer#transformers.LongformerConfig">LongformerConfig</a> (Longformer model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/main/en/model_doc/longt5#transformers.LongT5Config">LongT5Config</a> (LongT5 model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/main/en/model_doc/luke#transformers.LukeConfig">LukeConfig</a> (LUKE model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/main/en/model_doc/lxmert#transformers.LxmertConfig">LxmertConfig</a> (LXMERT model)</li> <li><strong>m2m_100</strong> — <a href="/docs/transformers/main/en/model_doc/m2m_100#transformers.M2M100Config">M2M100Config</a> (M2M100 model)</li> <li><strong>mamba</strong> — <a href="/docs/transformers/main/en/model_doc/mamba#transformers.MambaConfig">MambaConfig</a> (Mamba model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/main/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a> (Marian model)</li> <li><strong>markuplm</strong> — <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMConfig">MarkupLMConfig</a> (MarkupLM model)</li> <li><strong>mask2former</strong> — <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a> (Mask2Former model)</li> <li><strong>maskformer</strong> — <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerConfig">MaskFormerConfig</a> (MaskFormer model)</li> <li><strong>maskformer-swin</strong> — <code>MaskFormerSwinConfig</code> (MaskFormerSwin model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> (mBART model)</li> <li><strong>mctct</strong> — <a href="/docs/transformers/main/en/model_doc/mctct#transformers.MCTCTConfig">MCTCTConfig</a> (M-CTC-T model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/main/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/main/en/model_doc/megatron-bert#transformers.MegatronBertConfig">MegatronBertConfig</a> (Megatron-BERT model)</li> <li><strong>mgp-str</strong> — <a href="/docs/transformers/main/en/model_doc/mgp-str#transformers.MgpstrConfig">MgpstrConfig</a> (MGP-STR model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/main/en/model_doc/mistral#transformers.MistralConfig">MistralConfig</a> (Mistral model)</li> <li><strong>mixtral</strong> — <a href="/docs/transformers/main/en/model_doc/mixtral#transformers.MixtralConfig">MixtralConfig</a> (Mixtral model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> (MobileBERT model)</li> <li><strong>mobilenet_v1</strong> — <a href="/docs/transformers/main/en/model_doc/mobilenet_v1#transformers.MobileNetV1Config">MobileNetV1Config</a> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <a href="/docs/transformers/main/en/model_doc/mobilenet_v2#transformers.MobileNetV2Config">MobileNetV2Config</a> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/main/en/model_doc/mobilevit#transformers.MobileViTConfig">MobileViTConfig</a> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <a href="/docs/transformers/main/en/model_doc/mobilevitv2#transformers.MobileViTV2Config">MobileViTV2Config</a> (MobileViTV2 model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig">MptConfig</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/main/en/model_doc/mra#transformers.MraConfig">MraConfig</a> (MRA model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Config">MT5Config</a> (MT5 model)</li> <li><strong>musicgen</strong> — <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a> (MusicGen model)</li> <li><strong>musicgen_melody</strong> — <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig">MusicgenMelodyConfig</a> (MusicGen Melody model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/main/en/model_doc/mvp#transformers.MvpConfig">MvpConfig</a> (MVP model)</li> <li><strong>nat</strong> — <a href="/docs/transformers/main/en/model_doc/nat#transformers.NatConfig">NatConfig</a> (NAT model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/main/en/model_doc/nezha#transformers.NezhaConfig">NezhaConfig</a> (Nezha model)</li> <li><strong>nllb-moe</strong> — <a href="/docs/transformers/main/en/model_doc/nllb-moe#transformers.NllbMoeConfig">NllbMoeConfig</a> (NLLB-MOE model)</li> <li><strong>nougat</strong> — <a href="/docs/transformers/main/en/model_doc/vision-encoder-decoder#transformers.VisionEncoderDecoderConfig">VisionEncoderDecoderConfig</a> (Nougat model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/main/en/model_doc/nystromformer#transformers.NystromformerConfig">NystromformerConfig</a> (Nyströmformer model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerConfig">OneFormerConfig</a> (OneFormer model)</li> <li><strong>open-llama</strong> — <a href="/docs/transformers/main/en/model_doc/open-llama#transformers.OpenLlamaConfig">OpenLlamaConfig</a> (OpenLlama model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> (OPT model)</li> <li><strong>owlv2</strong> — <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Config">Owlv2Config</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/main/en/model_doc/owlvit#transformers.OwlViTConfig">OwlViTConfig</a> (OWL-ViT model)</li> <li><strong>patchtsmixer</strong> — <a href="/docs/transformers/main/en/model_doc/patchtsmixer#transformers.PatchTSMixerConfig">PatchTSMixerConfig</a> (PatchTSMixer model)</li> <li><strong>patchtst</strong> — <a href="/docs/transformers/main/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a> (PatchTST model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/main/en/model_doc/pegasus#transformers.PegasusConfig">PegasusConfig</a> (Pegasus model)</li> <li><strong>pegasus_x</strong> — <a href="/docs/transformers/main/en/model_doc/pegasus_x#transformers.PegasusXConfig">PegasusXConfig</a> (PEGASUS-X model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a> (Perceiver model)</li> <li><strong>persimmon</strong> — <a href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonConfig">PersimmonConfig</a> (Persimmon model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiConfig">PhiConfig</a> (Phi model)</li> <li><strong>pix2struct</strong> — <a href="/docs/transformers/main/en/model_doc/pix2struct#transformers.Pix2StructConfig">Pix2StructConfig</a> (Pix2Struct model)</li> <li><strong>plbart</strong> — <a href="/docs/transformers/main/en/model_doc/plbart#transformers.PLBartConfig">PLBartConfig</a> (PLBart model)</li> <li><strong>poolformer</strong> — <a href="/docs/transformers/main/en/model_doc/poolformer#transformers.PoolFormerConfig">PoolFormerConfig</a> (PoolFormer model)</li> <li><strong>pop2piano</strong> — <a href="/docs/transformers/main/en/model_doc/pop2piano#transformers.Pop2PianoConfig">Pop2PianoConfig</a> (Pop2Piano model)</li> <li><strong>prophetnet</strong> — <a href="/docs/transformers/main/en/model_doc/prophetnet#transformers.ProphetNetConfig">ProphetNetConfig</a> (ProphetNet model)</li> <li><strong>pvt</strong> — <a href="/docs/transformers/main/en/model_doc/pvt#transformers.PvtConfig">PvtConfig</a> (PVT model)</li> <li><strong>pvt_v2</strong> — <a href="/docs/transformers/main/en/model_doc/pvt_v2#transformers.PvtV2Config">PvtV2Config</a> (PVTv2 model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/main/en/model_doc/qdqbert#transformers.QDQBertConfig">QDQBertConfig</a> (QDQBert model)</li> <li><strong>qwen2</strong> — <a href="/docs/transformers/main/en/model_doc/qwen2#transformers.Qwen2Config">Qwen2Config</a> (Qwen2 model)</li> <li><strong>qwen2_moe</strong> — <a href="/docs/transformers/main/en/model_doc/qwen2_moe#transformers.Qwen2MoeConfig">Qwen2MoeConfig</a> (Qwen2MoE model)</li> <li><strong>rag</strong> — <a href="/docs/transformers/main/en/model_doc/rag#transformers.RagConfig">RagConfig</a> (RAG model)</li> <li><strong>realm</strong> — <a href="/docs/transformers/main/en/model_doc/realm#transformers.RealmConfig">RealmConfig</a> (REALM model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a> (Reformer model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a> (RegNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/main/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> (RemBERT model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/main/en/model_doc/resnet#transformers.ResNetConfig">ResNetConfig</a> (ResNet model)</li> <li><strong>retribert</strong> — <a href="/docs/transformers/main/en/model_doc/retribert#transformers.RetriBertConfig">RetriBertConfig</a> (RetriBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/main/en/model_doc/roc_bert#transformers.RoCBertConfig">RoCBertConfig</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> (RoFormer model)</li> <li><strong>rwkv</strong> — <a href="/docs/transformers/main/en/model_doc/rwkv#transformers.RwkvConfig">RwkvConfig</a> (RWKV model)</li> <li><strong>sam</strong> — <a href="/docs/transformers/main/en/model_doc/sam#transformers.SamConfig">SamConfig</a> (SAM model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TConfig">SeamlessM4TConfig</a> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Config">SeamlessM4Tv2Config</a> (SeamlessM4Tv2 model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/main/en/model_doc/segformer#transformers.SegformerConfig">SegformerConfig</a> (SegFormer model)</li> <li><strong>seggpt</strong> — <a href="/docs/transformers/main/en/model_doc/seggpt#transformers.SegGptConfig">SegGptConfig</a> (SegGPT model)</li> <li><strong>sew</strong> — <a href="/docs/transformers/main/en/model_doc/sew#transformers.SEWConfig">SEWConfig</a> (SEW model)</li> <li><strong>sew-d</strong> — <a href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDConfig">SEWDConfig</a> (SEW-D model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipConfig">SiglipConfig</a> (SigLIP model)</li> <li><strong>siglip_vision_model</strong> — <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipVisionConfig">SiglipVisionConfig</a> (SiglipVisionModel model)</li> <li><strong>speech-encoder-decoder</strong> — <a href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderConfig">SpeechEncoderDecoderConfig</a> (Speech Encoder decoder model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/main/en/model_doc/speech_to_text#transformers.Speech2TextConfig">Speech2TextConfig</a> (Speech2Text model)</li> <li><strong>speech_to_text_2</strong> — <a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2Config">Speech2Text2Config</a> (Speech2Text2 model)</li> <li><strong>speecht5</strong> — <a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5Config">SpeechT5Config</a> (SpeechT5 model)</li> <li><strong>splinter</strong> — <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterConfig">SplinterConfig</a> (Splinter model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/main/en/model_doc/squeezebert#transformers.SqueezeBertConfig">SqueezeBertConfig</a> (SqueezeBERT model)</li> <li><strong>stablelm</strong> — <a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmConfig">StableLmConfig</a> (StableLm model)</li> <li><strong>starcoder2</strong> — <a href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2Config">Starcoder2Config</a> (Starcoder2 model)</li> <li><strong>superpoint</strong> — <a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointConfig">SuperPointConfig</a> (SuperPoint model)</li> <li><strong>swiftformer</strong> — <a href="/docs/transformers/main/en/model_doc/swiftformer#transformers.SwiftFormerConfig">SwiftFormerConfig</a> (SwiftFormer model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/main/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a> (Swin Transformer model)</li> <li><strong>swin2sr</strong> — <a href="/docs/transformers/main/en/model_doc/swin2sr#transformers.Swin2SRConfig">Swin2SRConfig</a> (Swin2SR model)</li> <li><strong>swinv2</strong> — <a href="/docs/transformers/main/en/model_doc/swinv2#transformers.Swinv2Config">Swinv2Config</a> (Swin Transformer V2 model)</li> <li><strong>switch_transformers</strong> — <a href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig">SwitchTransformersConfig</a> (SwitchTransformers model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5Config">T5Config</a> (T5 model)</li> <li><strong>table-transformer</strong> — <a href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerConfig">TableTransformerConfig</a> (Table Transformer model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> (TAPAS model)</li> <li><strong>time_series_transformer</strong> — <a href="/docs/transformers/main/en/model_doc/time_series_transformer#transformers.TimeSeriesTransformerConfig">TimeSeriesTransformerConfig</a> (Time Series Transformer model)</li> <li><strong>timesformer</strong> — <a href="/docs/transformers/main/en/model_doc/timesformer#transformers.TimesformerConfig">TimesformerConfig</a> (TimeSformer model)</li> <li><strong>timm_backbone</strong> — <a href="/docs/transformers/main/en/main_classes/backbones#transformers.TimmBackboneConfig">TimmBackboneConfig</a> (TimmBackbone model)</li> <li><strong>trajectory_transformer</strong> — <a href="/docs/transformers/main/en/model_doc/trajectory_transformer#transformers.TrajectoryTransformerConfig">TrajectoryTransformerConfig</a> (Trajectory Transformer model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> (Transformer-XL model)</li> <li><strong>trocr</strong> — <a href="/docs/transformers/main/en/model_doc/trocr#transformers.TrOCRConfig">TrOCRConfig</a> (TrOCR model)</li> <li><strong>tvlt</strong> — <a href="/docs/transformers/main/en/model_doc/tvlt#transformers.TvltConfig">TvltConfig</a> (TVLT model)</li> <li><strong>tvp</strong> — <a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpConfig">TvpConfig</a> (TVP model)</li> <li><strong>udop</strong> — <a href="/docs/transformers/main/en/model_doc/udop#transformers.UdopConfig">UdopConfig</a> (UDOP model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/main/en/model_doc/umt5#transformers.UMT5Config">UMT5Config</a> (UMT5 model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/main/en/model_doc/unispeech#transformers.UniSpeechConfig">UniSpeechConfig</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/main/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig">UniSpeechSatConfig</a> (UniSpeechSat model)</li> <li><strong>univnet</strong> — <a href="/docs/transformers/main/en/model_doc/univnet#transformers.UnivNetConfig">UnivNetConfig</a> (UnivNet model)</li> <li><strong>upernet</strong> — <a href="/docs/transformers/main/en/model_doc/upernet#transformers.UperNetConfig">UperNetConfig</a> (UPerNet model)</li> <li><strong>van</strong> — <a href="/docs/transformers/main/en/model_doc/van#transformers.VanConfig">VanConfig</a> (VAN model)</li> <li><strong>videomae</strong> — <a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEConfig">VideoMAEConfig</a> (VideoMAE model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltConfig">ViltConfig</a> (ViLT model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/main/en/model_doc/vipllava#transformers.VipLlavaConfig">VipLlavaConfig</a> (VipLlava model)</li> <li><strong>vision-encoder-decoder</strong> — <a href="/docs/transformers/main/en/model_doc/vision-encoder-decoder#transformers.VisionEncoderDecoderConfig">VisionEncoderDecoderConfig</a> (Vision Encoder decoder model)</li> <li><strong>vision-text-dual-encoder</strong> — <a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a> (VisionTextDualEncoder model)</li> <li><strong>visual_bert</strong> — <a href="/docs/transformers/main/en/model_doc/visual_bert#transformers.VisualBertConfig">VisualBertConfig</a> (VisualBERT model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a> (ViT model)</li> <li><strong>vit_hybrid</strong> — <a href="/docs/transformers/main/en/model_doc/vit_hybrid#transformers.ViTHybridConfig">ViTHybridConfig</a> (ViT Hybrid model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/main/en/model_doc/vit_mae#transformers.ViTMAEConfig">ViTMAEConfig</a> (ViTMAE model)</li> <li><strong>vit_msn</strong> — <a href="/docs/transformers/main/en/model_doc/vit_msn#transformers.ViTMSNConfig">ViTMSNConfig</a> (ViTMSN model)</li> <li><strong>vitdet</strong> — <a href="/docs/transformers/main/en/model_doc/vitdet#transformers.VitDetConfig">VitDetConfig</a> (VitDet model)</li> <li><strong>vitmatte</strong> — <a href="/docs/transformers/main/en/model_doc/vitmatte#transformers.VitMatteConfig">VitMatteConfig</a> (ViTMatte model)</li> <li><strong>vits</strong> — <a href="/docs/transformers/main/en/model_doc/vits#transformers.VitsConfig">VitsConfig</a> (VITS model)</li> <li><strong>vivit</strong> — <a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitConfig">VivitConfig</a> (ViViT model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertConfig">Wav2Vec2BertConfig</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerConfig">Wav2Vec2ConformerConfig</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/main/en/model_doc/wavlm#transformers.WavLMConfig">WavLMConfig</a> (WavLM model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/main/en/model_doc/whisper#transformers.WhisperConfig">WhisperConfig</a> (Whisper model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/main/en/model_doc/xclip#transformers.XCLIPConfig">XCLIPConfig</a> (X-CLIP model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/main/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> (XGLM model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> (XLM model)</li> <li><strong>xlm-prophetnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetConfig">XLMProphetNetConfig</a> (XLM-ProphetNet model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLConfig">XLMRobertaXLConfig</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/main/en/model_doc/xmod#transformers.XmodConfig">XmodConfig</a> (X-MOD model)</li> <li><strong>yolos</strong> — <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosConfig">YolosConfig</a> (YOLOS model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/main/en/model_doc/yoso#transformers.YosoConfig">YosoConfig</a> (YOSO model)</li>',Hx,vs,Yx,ws,Rd,zx,Cp,t0="Register a new configuration for this class.",Iv,Sd,Uv,ce,Gd,Ox,yp,a0=`This is a generic tokenizer class that will be instantiated as one of the tokenizer classes of the library when
created with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer.from_pretrained">AutoTokenizer.from_pretrained()</a> class method.`,Kx,vp,s0="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",eL,Io,Wd,oL,wp,i0="Instantiate one of the tokenizer classes of the library from a pretrained model vocabulary.",rL,xp,l0=`The tokenizer class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,nL,Lp,d0='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertTokenizer">AlbertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertTokenizerFast">AlbertTokenizerFast</a> (ALBERT model)</li> <li><strong>align</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (ALIGN model)</li> <li><strong>bark</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (Bark model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.BartTokenizer">BartTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/bart#transformers.BartTokenizerFast">BartTokenizerFast</a> (BART model)</li> <li><strong>barthez</strong> — <a href="/docs/transformers/main/en/model_doc/barthez#transformers.BarthezTokenizer">BarthezTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/barthez#transformers.BarthezTokenizerFast">BarthezTokenizerFast</a> (BARThez model)</li> <li><strong>bartpho</strong> — <a href="/docs/transformers/main/en/model_doc/bartpho#transformers.BartphoTokenizer">BartphoTokenizer</a> (BARTpho model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (BERT model)</li> <li><strong>bert-generation</strong> — <a href="/docs/transformers/main/en/model_doc/bert-generation#transformers.BertGenerationTokenizer">BertGenerationTokenizer</a> (Bert Generation model)</li> <li><strong>bert-japanese</strong> — <a href="/docs/transformers/main/en/model_doc/bert-japanese#transformers.BertJapaneseTokenizer">BertJapaneseTokenizer</a> (BertJapanese model)</li> <li><strong>bertweet</strong> — <a href="/docs/transformers/main/en/model_doc/bertweet#transformers.BertweetTokenizer">BertweetTokenizer</a> (BERTweet model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdTokenizer">BigBirdTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdTokenizerFast">BigBirdTokenizerFast</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/main/en/model_doc/pegasus#transformers.PegasusTokenizer">PegasusTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/pegasus#transformers.PegasusTokenizerFast">PegasusTokenizerFast</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptTokenizer">BioGptTokenizer</a> (BioGpt model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/main/en/model_doc/blenderbot#transformers.BlenderbotTokenizer">BlenderbotTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/blenderbot#transformers.BlenderbotTokenizerFast">BlenderbotTokenizerFast</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/main/en/model_doc/blenderbot-small#transformers.BlenderbotSmallTokenizer">BlenderbotSmallTokenizer</a> (BlenderbotSmall model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (BLIP-2 model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/en/model_doc/bloom#transformers.BloomTokenizerFast">BloomTokenizerFast</a> (BLOOM model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (BridgeTower model)</li> <li><strong>bros</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (BROS model)</li> <li><strong>byt5</strong> — <a href="/docs/transformers/main/en/model_doc/byt5#transformers.ByT5Tokenizer">ByT5Tokenizer</a> (ByT5 model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertTokenizer">CamembertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertTokenizerFast">CamembertTokenizerFast</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineTokenizer">CanineTokenizer</a> (CANINE model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (Chinese-CLIP model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (CLIP model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/main/en/model_doc/clvp#transformers.ClvpTokenizer">ClvpTokenizer</a> (CLVP model)</li> <li><strong>code_llama</strong> — <a href="/docs/transformers/main/en/model_doc/code_llama#transformers.CodeLlamaTokenizer">CodeLlamaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/code_llama#transformers.CodeLlamaTokenizerFast">CodeLlamaTokenizerFast</a> (CodeLlama model)</li> <li><strong>codegen</strong> — <a href="/docs/transformers/main/en/model_doc/codegen#transformers.CodeGenTokenizer">CodeGenTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/codegen#transformers.CodeGenTokenizerFast">CodeGenTokenizerFast</a> (CodeGen model)</li> <li><strong>cohere</strong> — <a href="/docs/transformers/main/en/model_doc/cohere#transformers.CohereTokenizerFast">CohereTokenizerFast</a> (Cohere model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/en/model_doc/convbert#transformers.ConvBertTokenizer">ConvBertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/convbert#transformers.ConvBertTokenizerFast">ConvBertTokenizerFast</a> (ConvBERT model)</li> <li><strong>cpm</strong> — <a href="/docs/transformers/main/en/model_doc/cpm#transformers.CpmTokenizer">CpmTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/cpm#transformers.CpmTokenizerFast">CpmTokenizerFast</a> (CPM model)</li> <li><strong>cpmant</strong> — <a href="/docs/transformers/main/en/model_doc/cpmant#transformers.CpmAntTokenizer">CpmAntTokenizer</a> (CPM-Ant model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/en/model_doc/ctrl#transformers.CTRLTokenizer">CTRLTokenizer</a> (CTRL model)</li> <li><strong>data2vec-audio</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a> (Data2VecAudio model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/en/model_doc/deberta#transformers.DebertaTokenizer">DebertaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/deberta#transformers.DebertaTokenizerFast">DebertaTokenizerFast</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.DebertaV2Tokenizer">DebertaV2Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.DebertaV2TokenizerFast">DebertaV2TokenizerFast</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertTokenizer">DistilBertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertTokenizerFast">DistilBertTokenizerFast</a> (DistilBERT model)</li> <li><strong>dpr</strong> — <a href="/docs/transformers/main/en/model_doc/dpr#transformers.DPRQuestionEncoderTokenizer">DPRQuestionEncoderTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/dpr#transformers.DPRQuestionEncoderTokenizerFast">DPRQuestionEncoderTokenizerFast</a> (DPR model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraTokenizer">ElectraTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraTokenizerFast">ElectraTokenizerFast</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a> (ErnieM model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/main/en/model_doc/esm#transformers.EsmTokenizer">EsmTokenizer</a> (ESM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> (Falcon model)</li> <li><strong>fastspeech2_conformer</strong> —  (FastSpeech2Conformer model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.FlaubertTokenizer">FlaubertTokenizer</a> (FlauBERT model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/main/en/model_doc/fnet#transformers.FNetTokenizer">FNetTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/fnet#transformers.FNetTokenizerFast">FNetTokenizerFast</a> (FNet model)</li> <li><strong>fsmt</strong> — <a href="/docs/transformers/main/en/model_doc/fsmt#transformers.FSMTTokenizer">FSMTTokenizer</a> (FairSeq Machine-Translation model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelTokenizer">FunnelTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelTokenizerFast">FunnelTokenizerFast</a> (Funnel Transformer model)</li> <li><strong>gemma</strong> — <a href="/docs/transformers/main/en/model_doc/gemma#transformers.GemmaTokenizer">GemmaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/gemma#transformers.GemmaTokenizerFast">GemmaTokenizerFast</a> (Gemma model)</li> <li><strong>git</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (GIT model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/main/en/model_doc/gpt-sw3#transformers.GPTSw3Tokenizer">GPTSw3Tokenizer</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neox#transformers.GPTNeoXTokenizerFast">GPTNeoXTokenizerFast</a> (GPT NeoX model)</li> <li><strong>gpt_neox_japanese</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseTokenizer">GPTNeoXJapaneseTokenizer</a> (GPT NeoX Japanese model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (GPT-J model)</li> <li><strong>gptsan-japanese</strong> — <a href="/docs/transformers/main/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseTokenizer">GPTSanJapaneseTokenizer</a> (GPTSAN-japanese model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (GroupViT model)</li> <li><strong>herbert</strong> — <a href="/docs/transformers/main/en/model_doc/herbert#transformers.HerbertTokenizer">HerbertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/herbert#transformers.HerbertTokenizerFast">HerbertTokenizerFast</a> (HerBERT model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a> (Hubert model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (I-BERT model)</li> <li><strong>idefics</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (IDEFICS model)</li> <li><strong>instructblip</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (InstructBLIP model)</li> <li><strong>jukebox</strong> — <a href="/docs/transformers/main/en/model_doc/jukebox#transformers.JukeboxTokenizer">JukeboxTokenizer</a> (Jukebox model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizer">XLMRobertaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizerFast">XLMRobertaTokenizerFast</a> (KOSMOS-2 model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.LayoutLMTokenizer">LayoutLMTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.LayoutLMTokenizerFast">LayoutLMTokenizerFast</a> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv2#transformers.LayoutLMv2Tokenizer">LayoutLMv2Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/layoutlmv2#transformers.LayoutLMv2TokenizerFast">LayoutLMv2TokenizerFast</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.LayoutLMv3Tokenizer">LayoutLMv3Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.LayoutLMv3TokenizerFast">LayoutLMv3TokenizerFast</a> (LayoutLMv3 model)</li> <li><strong>layoutxlm</strong> — <a href="/docs/transformers/main/en/model_doc/layoutxlm#transformers.LayoutXLMTokenizer">LayoutXLMTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/layoutxlm#transformers.LayoutXLMTokenizerFast">LayoutXLMTokenizerFast</a> (LayoutXLM model)</li> <li><strong>led</strong> — <a href="/docs/transformers/main/en/model_doc/led#transformers.LEDTokenizer">LEDTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/led#transformers.LEDTokenizerFast">LEDTokenizerFast</a> (LED model)</li> <li><strong>lilt</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.LayoutLMv3Tokenizer">LayoutLMv3Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.LayoutLMv3TokenizerFast">LayoutLMv3TokenizerFast</a> (LiLT model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (LLaMA model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (LLaVa model)</li> <li><strong>llava_next</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (LLaVA-NeXT model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/main/en/model_doc/longformer#transformers.LongformerTokenizer">LongformerTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/longformer#transformers.LongformerTokenizerFast">LongformerTokenizerFast</a> (Longformer model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (LongT5 model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/main/en/model_doc/luke#transformers.LukeTokenizer">LukeTokenizer</a> (LUKE model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/main/en/model_doc/lxmert#transformers.LxmertTokenizer">LxmertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/lxmert#transformers.LxmertTokenizerFast">LxmertTokenizerFast</a> (LXMERT model)</li> <li><strong>m2m_100</strong> — <a href="/docs/transformers/main/en/model_doc/m2m_100#transformers.M2M100Tokenizer">M2M100Tokenizer</a> (M2M100 model)</li> <li><strong>mamba</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neox#transformers.GPTNeoXTokenizerFast">GPTNeoXTokenizerFast</a> (Mamba model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/main/en/model_doc/marian#transformers.MarianTokenizer">MarianTokenizer</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBartTokenizer">MBartTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBartTokenizerFast">MBartTokenizerFast</a> (mBART model)</li> <li><strong>mbart50</strong> — <a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBart50Tokenizer">MBart50Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBart50TokenizerFast">MBart50TokenizerFast</a> (mBART-50 model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (Megatron-BERT model)</li> <li><strong>mgp-str</strong> — <a href="/docs/transformers/main/en/model_doc/mgp-str#transformers.MgpstrTokenizer">MgpstrTokenizer</a> (MGP-STR model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (Mistral model)</li> <li><strong>mixtral</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (Mixtral model)</li> <li><strong>mluke</strong> — <a href="/docs/transformers/main/en/model_doc/mluke#transformers.MLukeTokenizer">MLukeTokenizer</a> (mLUKE model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertTokenizer">MobileBertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertTokenizerFast">MobileBertTokenizerFast</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.MPNetTokenizer">MPNetTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.MPNetTokenizerFast">MPNetTokenizerFast</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neox#transformers.GPTNeoXTokenizerFast">GPTNeoXTokenizerFast</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (MRA model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.T5Tokenizer">MT5Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/mt5#transformers.T5TokenizerFast">MT5TokenizerFast</a> (MT5 model)</li> <li><strong>musicgen</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (MusicGen model)</li> <li><strong>musicgen_melody</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (MusicGen Melody model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/main/en/model_doc/mvp#transformers.MvpTokenizer">MvpTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/mvp#transformers.MvpTokenizerFast">MvpTokenizerFast</a> (MVP model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (Nezha model)</li> <li><strong>nllb</strong> — <a href="/docs/transformers/main/en/model_doc/nllb#transformers.NllbTokenizer">NllbTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/nllb#transformers.NllbTokenizerFast">NllbTokenizerFast</a> (NLLB model)</li> <li><strong>nllb-moe</strong> — <a href="/docs/transformers/main/en/model_doc/nllb#transformers.NllbTokenizer">NllbTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/nllb#transformers.NllbTokenizerFast">NllbTokenizerFast</a> (NLLB-MOE model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertTokenizer">AlbertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertTokenizerFast">AlbertTokenizerFast</a> (Nyströmformer model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (OneFormer model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTTokenizer">OpenAIGPTTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTTokenizerFast">OpenAIGPTTokenizerFast</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (OPT model)</li> <li><strong>owlv2</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (OWL-ViT model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/main/en/model_doc/pegasus#transformers.PegasusTokenizer">PegasusTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/pegasus#transformers.PegasusTokenizerFast">PegasusTokenizerFast</a> (Pegasus model)</li> <li><strong>pegasus_x</strong> — <a href="/docs/transformers/main/en/model_doc/pegasus#transformers.PegasusTokenizer">PegasusTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/pegasus#transformers.PegasusTokenizerFast">PegasusTokenizerFast</a> (PEGASUS-X model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverTokenizer">PerceiverTokenizer</a> (Perceiver model)</li> <li><strong>persimmon</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (Persimmon model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/main/en/model_doc/codegen#transformers.CodeGenTokenizer">CodeGenTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/codegen#transformers.CodeGenTokenizerFast">CodeGenTokenizerFast</a> (Phi model)</li> <li><strong>phobert</strong> — <a href="/docs/transformers/main/en/model_doc/phobert#transformers.PhobertTokenizer">PhobertTokenizer</a> (PhoBERT model)</li> <li><strong>pix2struct</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (Pix2Struct model)</li> <li><strong>plbart</strong> — <a href="/docs/transformers/main/en/model_doc/plbart#transformers.PLBartTokenizer">PLBartTokenizer</a> (PLBart model)</li> <li><strong>prophetnet</strong> — <a href="/docs/transformers/main/en/model_doc/prophetnet#transformers.ProphetNetTokenizer">ProphetNetTokenizer</a> (ProphetNet model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (QDQBert model)</li> <li><strong>qwen2</strong> — <a href="/docs/transformers/main/en/model_doc/qwen2#transformers.Qwen2Tokenizer">Qwen2Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/qwen2#transformers.Qwen2TokenizerFast">Qwen2TokenizerFast</a> (Qwen2 model)</li> <li><strong>qwen2_moe</strong> — <a href="/docs/transformers/main/en/model_doc/qwen2#transformers.Qwen2Tokenizer">Qwen2Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/qwen2#transformers.Qwen2TokenizerFast">Qwen2TokenizerFast</a> (Qwen2MoE model)</li> <li><strong>rag</strong> — <a href="/docs/transformers/main/en/model_doc/rag#transformers.RagTokenizer">RagTokenizer</a> (RAG model)</li> <li><strong>realm</strong> — <a href="/docs/transformers/main/en/model_doc/realm#transformers.RealmTokenizer">RealmTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/realm#transformers.RealmTokenizerFast">RealmTokenizerFast</a> (REALM model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerTokenizer">ReformerTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerTokenizerFast">ReformerTokenizerFast</a> (Reformer model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/main/en/model_doc/rembert#transformers.RemBertTokenizer">RemBertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/rembert#transformers.RemBertTokenizerFast">RemBertTokenizerFast</a> (RemBERT model)</li> <li><strong>retribert</strong> — <a href="/docs/transformers/main/en/model_doc/retribert#transformers.RetriBertTokenizer">RetriBertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/retribert#transformers.RetriBertTokenizerFast">RetriBertTokenizerFast</a> (RetriBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/main/en/model_doc/roc_bert#transformers.RoCBertTokenizer">RoCBertTokenizer</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerTokenizer">RoFormerTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerTokenizerFast">RoFormerTokenizerFast</a> (RoFormer model)</li> <li><strong>rwkv</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neox#transformers.GPTNeoXTokenizerFast">GPTNeoXTokenizerFast</a> (RWKV model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TTokenizer">SeamlessM4TTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TTokenizerFast">SeamlessM4TTokenizerFast</a> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TTokenizer">SeamlessM4TTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TTokenizerFast">SeamlessM4TTokenizerFast</a> (SeamlessM4Tv2 model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipTokenizer">SiglipTokenizer</a> (SigLIP model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/main/en/model_doc/speech_to_text#transformers.Speech2TextTokenizer">Speech2TextTokenizer</a> (Speech2Text model)</li> <li><strong>speech_to_text_2</strong> — <a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer">Speech2Text2Tokenizer</a> (Speech2Text2 model)</li> <li><strong>speecht5</strong> — <a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5Tokenizer">SpeechT5Tokenizer</a> (SpeechT5 model)</li> <li><strong>splinter</strong> — <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterTokenizer">SplinterTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterTokenizerFast">SplinterTokenizerFast</a> (Splinter model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/main/en/model_doc/squeezebert#transformers.SqueezeBertTokenizer">SqueezeBertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/squeezebert#transformers.SqueezeBertTokenizerFast">SqueezeBertTokenizerFast</a> (SqueezeBERT model)</li> <li><strong>stablelm</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neox#transformers.GPTNeoXTokenizerFast">GPTNeoXTokenizerFast</a> (StableLm model)</li> <li><strong>starcoder2</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (Starcoder2 model)</li> <li><strong>switch_transformers</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (SwitchTransformers model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (T5 model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> (TAPAS model)</li> <li><strong>tapex</strong> — <a href="/docs/transformers/main/en/model_doc/tapex#transformers.TapexTokenizer">TapexTokenizer</a> (TAPEX model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TransfoXLTokenizer">TransfoXLTokenizer</a> (Transformer-XL model)</li> <li><strong>tvp</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (TVP model)</li> <li><strong>udop</strong> — <a href="/docs/transformers/main/en/model_doc/udop#transformers.UdopTokenizer">UdopTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/udop#transformers.UdopTokenizerFast">UdopTokenizerFast</a> (UDOP model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/main/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (UMT5 model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (ViLT model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (VipLlava model)</li> <li><strong>visual_bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (VisualBERT model)</li> <li><strong>vits</strong> — <a href="/docs/transformers/main/en/model_doc/vits#transformers.VitsTokenizer">VitsTokenizer</a> (VITS model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a> (Wav2Vec2-Conformer model)</li> <li><strong>wav2vec2_phoneme</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2_phoneme#transformers.Wav2Vec2PhonemeCTCTokenizer">Wav2Vec2PhonemeCTCTokenizer</a> (Wav2Vec2Phoneme model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/main/en/model_doc/whisper#transformers.WhisperTokenizer">WhisperTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/whisper#transformers.WhisperTokenizerFast">WhisperTokenizerFast</a> (Whisper model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (X-CLIP model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/main/en/model_doc/xglm#transformers.XGLMTokenizer">XGLMTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/xglm#transformers.XGLMTokenizerFast">XGLMTokenizerFast</a> (XGLM model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMTokenizer">XLMTokenizer</a> (XLM model)</li> <li><strong>xlm-prophetnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetTokenizer">XLMProphetNetTokenizer</a> (XLM-ProphetNet model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizer">XLMRobertaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizerFast">XLMRobertaTokenizerFast</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizer">XLMRobertaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizerFast">XLMRobertaTokenizerFast</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetTokenizer">XLNetTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetTokenizerFast">XLNetTokenizerFast</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizer">XLMRobertaTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizerFast">XLMRobertaTokenizerFast</a> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertTokenizer">AlbertTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertTokenizerFast">AlbertTokenizerFast</a> (YOSO model)</li>',tL,xs,aL,Ls,Pd,sL,kp,m0="Register a new tokenizer in this mapping.",Nv,Vd,qv,fe,Jd,iL,$p,c0=`This is a generic feature extractor class that will be instantiated as one of the feature extractor classes of the
library when created with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoFeatureExtractor.from_pretrained">AutoFeatureExtractor.from_pretrained()</a> class method.`,lL,Bp,f0="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",dL,A,Ed,mL,Ap,g0="Instantiate one of the feature extractor classes of the library from a pretrained model vocabulary.",cL,jp,h0=`The feature extractor class to instantiate is selected based on the <code>model_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s
missing, by falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,fL,Zp,p0='<li><strong>audio-spectrogram-transformer</strong> — <a href="/docs/transformers/main/en/model_doc/audio-spectrogram-transformer#transformers.ASTFeatureExtractor">ASTFeatureExtractor</a> (Audio Spectrogram Transformer model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitFeatureExtractor">BeitFeatureExtractor</a> (BEiT model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/main/en/model_doc/chinese_clip#transformers.ChineseCLIPFeatureExtractor">ChineseCLIPFeatureExtractor</a> (Chinese-CLIP model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/main/en/model_doc/clap#transformers.ClapFeatureExtractor">ClapFeatureExtractor</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPFeatureExtractor">CLIPFeatureExtractor</a> (CLIP model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/main/en/model_doc/clvp#transformers.ClvpFeatureExtractor">ClvpFeatureExtractor</a> (CLVP model)</li> <li><strong>conditional_detr</strong> — <a href="/docs/transformers/main/en/model_doc/conditional_detr#transformers.ConditionalDetrFeatureExtractor">ConditionalDetrFeatureExtractor</a> (Conditional DETR model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/main/en/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (ConvNeXT model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/main/en/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (CvT model)</li> <li><strong>data2vec-audio</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (Data2VecAudio model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitFeatureExtractor">BeitFeatureExtractor</a> (Data2VecVision model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/main/en/model_doc/deformable_detr#transformers.DeformableDetrFeatureExtractor">DeformableDetrFeatureExtractor</a> (Deformable DETR model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTFeatureExtractor">DeiTFeatureExtractor</a> (DeiT model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrFeatureExtractor">DetrFeatureExtractor</a> (DETR model)</li> <li><strong>dinat</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (DiNAT model)</li> <li><strong>donut-swin</strong> — <a href="/docs/transformers/main/en/model_doc/donut#transformers.DonutFeatureExtractor">DonutFeatureExtractor</a> (DonutSwin model)</li> <li><strong>dpt</strong> — <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTFeatureExtractor">DPTFeatureExtractor</a> (DPT model)</li> <li><strong>encodec</strong> — <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecFeatureExtractor">EncodecFeatureExtractor</a> (EnCodec model)</li> <li><strong>flava</strong> — <a href="/docs/transformers/main/en/model_doc/flava#transformers.FlavaFeatureExtractor">FlavaFeatureExtractor</a> (FLAVA model)</li> <li><strong>glpn</strong> — <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNFeatureExtractor">GLPNFeatureExtractor</a> (GLPN model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPFeatureExtractor">CLIPFeatureExtractor</a> (GroupViT model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (Hubert model)</li> <li><strong>imagegpt</strong> — <a href="/docs/transformers/main/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor">ImageGPTFeatureExtractor</a> (ImageGPT model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv2#transformers.LayoutLMv2FeatureExtractor">LayoutLMv2FeatureExtractor</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.LayoutLMv3FeatureExtractor">LayoutLMv3FeatureExtractor</a> (LayoutLMv3 model)</li> <li><strong>levit</strong> — <a href="/docs/transformers/main/en/model_doc/levit#transformers.LevitFeatureExtractor">LevitFeatureExtractor</a> (LeViT model)</li> <li><strong>maskformer</strong> — <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor">MaskFormerFeatureExtractor</a> (MaskFormer model)</li> <li><strong>mctct</strong> — <a href="/docs/transformers/main/en/model_doc/mctct#transformers.MCTCTFeatureExtractor">MCTCTFeatureExtractor</a> (M-CTC-T model)</li> <li><strong>mobilenet_v1</strong> — <a href="/docs/transformers/main/en/model_doc/mobilenet_v1#transformers.MobileNetV1FeatureExtractor">MobileNetV1FeatureExtractor</a> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <a href="/docs/transformers/main/en/model_doc/mobilenet_v2#transformers.MobileNetV2FeatureExtractor">MobileNetV2FeatureExtractor</a> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/main/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor">MobileViTFeatureExtractor</a> (MobileViT model)</li> <li><strong>nat</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (NAT model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/main/en/model_doc/owlvit#transformers.OwlViTFeatureExtractor">OwlViTFeatureExtractor</a> (OWL-ViT model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverFeatureExtractor">PerceiverFeatureExtractor</a> (Perceiver model)</li> <li><strong>poolformer</strong> — <a href="/docs/transformers/main/en/model_doc/poolformer#transformers.PoolFormerFeatureExtractor">PoolFormerFeatureExtractor</a> (PoolFormer model)</li> <li><strong>pop2piano</strong> — <a href="/docs/transformers/main/en/model_doc/pop2piano#transformers.Pop2PianoFeatureExtractor">Pop2PianoFeatureExtractor</a> (Pop2Piano model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/main/en/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/main/en/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (ResNet model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TFeatureExtractor">SeamlessM4TFeatureExtractor</a> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TFeatureExtractor">SeamlessM4TFeatureExtractor</a> (SeamlessM4Tv2 model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/main/en/model_doc/segformer#transformers.SegformerFeatureExtractor">SegformerFeatureExtractor</a> (SegFormer model)</li> <li><strong>sew</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (SEW model)</li> <li><strong>sew-d</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (SEW-D model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/main/en/model_doc/speech_to_text#transformers.Speech2TextFeatureExtractor">Speech2TextFeatureExtractor</a> (Speech2Text model)</li> <li><strong>speecht5</strong> — <a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5FeatureExtractor">SpeechT5FeatureExtractor</a> (SpeechT5 model)</li> <li><strong>swiftformer</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (SwiftFormer model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (Swin Transformer model)</li> <li><strong>swinv2</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (Swin Transformer V2 model)</li> <li><strong>table-transformer</strong> — <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrFeatureExtractor">DetrFeatureExtractor</a> (Table Transformer model)</li> <li><strong>timesformer</strong> — <a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEFeatureExtractor">VideoMAEFeatureExtractor</a> (TimeSformer model)</li> <li><strong>tvlt</strong> — <a href="/docs/transformers/main/en/model_doc/tvlt#transformers.TvltFeatureExtractor">TvltFeatureExtractor</a> (TVLT model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (UniSpeechSat model)</li> <li><strong>univnet</strong> — <a href="/docs/transformers/main/en/model_doc/univnet#transformers.UnivNetFeatureExtractor">UnivNetFeatureExtractor</a> (UnivNet model)</li> <li><strong>van</strong> — <a href="/docs/transformers/main/en/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (VAN model)</li> <li><strong>videomae</strong> — <a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEFeatureExtractor">VideoMAEFeatureExtractor</a> (VideoMAE model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltFeatureExtractor">ViltFeatureExtractor</a> (ViLT model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (ViT model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (ViTMAE model)</li> <li><strong>vit_msn</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (ViTMSN model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (WavLM model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/main/en/model_doc/whisper#transformers.WhisperFeatureExtractor">WhisperFeatureExtractor</a> (Whisper model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPFeatureExtractor">CLIPFeatureExtractor</a> (X-CLIP model)</li> <li><strong>yolos</strong> — <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosFeatureExtractor">YolosFeatureExtractor</a> (YOLOS model)</li>',gL,ks,hL,$s,pL,Bs,Id,uL,Rp,u0="Register a new feature extractor for this class.",Xv,Ud,Dv,ge,Nd,_L,Sp,_0=`This is a generic image processor class that will be instantiated as one of the image processor classes of the
library when created with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor.from_pretrained">AutoImageProcessor.from_pretrained()</a> class method.`,bL,Gp,b0="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",ML,j,qd,FL,Wp,M0="Instantiate one of the image processor classes of the library from a pretrained model vocabulary.",TL,Pp,F0=`The image processor class to instantiate is selected based on the <code>model_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s
missing, by falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,CL,Vp,T0='<li><strong>align</strong> — <a href="/docs/transformers/main/en/model_doc/efficientnet#transformers.EfficientNetImageProcessor">EfficientNetImageProcessor</a> (ALIGN model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitImageProcessor">BeitImageProcessor</a> (BEiT model)</li> <li><strong>bit</strong> — <a href="/docs/transformers/main/en/model_doc/bit#transformers.BitImageProcessor">BitImageProcessor</a> (BiT model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/main/en/model_doc/blip#transformers.BlipImageProcessor">BlipImageProcessor</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/main/en/model_doc/blip#transformers.BlipImageProcessor">BlipImageProcessor</a> (BLIP-2 model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/main/en/model_doc/bridgetower#transformers.BridgeTowerImageProcessor">BridgeTowerImageProcessor</a> (BridgeTower model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/main/en/model_doc/chinese_clip#transformers.ChineseCLIPImageProcessor">ChineseCLIPImageProcessor</a> (Chinese-CLIP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (CLIP model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (CLIPSeg model)</li> <li><strong>conditional_detr</strong> — <a href="/docs/transformers/main/en/model_doc/conditional_detr#transformers.ConditionalDetrImageProcessor">ConditionalDetrImageProcessor</a> (Conditional DETR model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/main/en/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/main/en/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (ConvNeXTV2 model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/main/en/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (CvT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitImageProcessor">BeitImageProcessor</a> (Data2VecVision model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/main/en/model_doc/deformable_detr#transformers.DeformableDetrImageProcessor">DeformableDetrImageProcessor</a> (Deformable DETR model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTImageProcessor">DeiTImageProcessor</a> (DeiT model)</li> <li><strong>depth_anything</strong> — <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTImageProcessor">DPTImageProcessor</a> (Depth Anything model)</li> <li><strong>deta</strong> — <a href="/docs/transformers/main/en/model_doc/deta#transformers.DetaImageProcessor">DetaImageProcessor</a> (DETA model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a> (DETR model)</li> <li><strong>dinat</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (DiNAT model)</li> <li><strong>dinov2</strong> — <a href="/docs/transformers/main/en/model_doc/bit#transformers.BitImageProcessor">BitImageProcessor</a> (DINOv2 model)</li> <li><strong>donut-swin</strong> — <a href="/docs/transformers/main/en/model_doc/donut#transformers.DonutImageProcessor">DonutImageProcessor</a> (DonutSwin model)</li> <li><strong>dpt</strong> — <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTImageProcessor">DPTImageProcessor</a> (DPT model)</li> <li><strong>efficientformer</strong> — <a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerImageProcessor">EfficientFormerImageProcessor</a> (EfficientFormer model)</li> <li><strong>efficientnet</strong> — <a href="/docs/transformers/main/en/model_doc/efficientnet#transformers.EfficientNetImageProcessor">EfficientNetImageProcessor</a> (EfficientNet model)</li> <li><strong>flava</strong> — <a href="/docs/transformers/main/en/model_doc/flava#transformers.FlavaImageProcessor">FlavaImageProcessor</a> (FLAVA model)</li> <li><strong>focalnet</strong> — <a href="/docs/transformers/main/en/model_doc/bit#transformers.BitImageProcessor">BitImageProcessor</a> (FocalNet model)</li> <li><strong>fuyu</strong> — <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuImageProcessor">FuyuImageProcessor</a> (Fuyu model)</li> <li><strong>git</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (GIT model)</li> <li><strong>glpn</strong> — <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNImageProcessor">GLPNImageProcessor</a> (GLPN model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (GroupViT model)</li> <li><strong>idefics</strong> — <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsImageProcessor">IdeficsImageProcessor</a> (IDEFICS model)</li> <li><strong>imagegpt</strong> — <a href="/docs/transformers/main/en/model_doc/imagegpt#transformers.ImageGPTImageProcessor">ImageGPTImageProcessor</a> (ImageGPT model)</li> <li><strong>instructblip</strong> — <a href="/docs/transformers/main/en/model_doc/blip#transformers.BlipImageProcessor">BlipImageProcessor</a> (InstructBLIP model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (KOSMOS-2 model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv2#transformers.LayoutLMv2ImageProcessor">LayoutLMv2ImageProcessor</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.LayoutLMv3ImageProcessor">LayoutLMv3ImageProcessor</a> (LayoutLMv3 model)</li> <li><strong>levit</strong> — <a href="/docs/transformers/main/en/model_doc/levit#transformers.LevitImageProcessor">LevitImageProcessor</a> (LeViT model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (LLaVa model)</li> <li><strong>llava_next</strong> — <a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a> (LLaVA-NeXT model)</li> <li><strong>mask2former</strong> — <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor">Mask2FormerImageProcessor</a> (Mask2Former model)</li> <li><strong>maskformer</strong> — <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerImageProcessor">MaskFormerImageProcessor</a> (MaskFormer model)</li> <li><strong>mgp-str</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (MGP-STR model)</li> <li><strong>mobilenet_v1</strong> — <a href="/docs/transformers/main/en/model_doc/mobilenet_v1#transformers.MobileNetV1ImageProcessor">MobileNetV1ImageProcessor</a> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <a href="/docs/transformers/main/en/model_doc/mobilenet_v2#transformers.MobileNetV2ImageProcessor">MobileNetV2ImageProcessor</a> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/main/en/model_doc/mobilevit#transformers.MobileViTImageProcessor">MobileViTImageProcessor</a> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <a href="/docs/transformers/main/en/model_doc/mobilevit#transformers.MobileViTImageProcessor">MobileViTImageProcessor</a> (MobileViTV2 model)</li> <li><strong>nat</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (NAT model)</li> <li><strong>nougat</strong> — <a href="/docs/transformers/main/en/model_doc/nougat#transformers.NougatImageProcessor">NougatImageProcessor</a> (Nougat model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor">OneFormerImageProcessor</a> (OneFormer model)</li> <li><strong>owlv2</strong> — <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/main/en/model_doc/owlvit#transformers.OwlViTImageProcessor">OwlViTImageProcessor</a> (OWL-ViT model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverImageProcessor">PerceiverImageProcessor</a> (Perceiver model)</li> <li><strong>pix2struct</strong> — <a href="/docs/transformers/main/en/model_doc/pix2struct#transformers.Pix2StructImageProcessor">Pix2StructImageProcessor</a> (Pix2Struct model)</li> <li><strong>poolformer</strong> — <a href="/docs/transformers/main/en/model_doc/poolformer#transformers.PoolFormerImageProcessor">PoolFormerImageProcessor</a> (PoolFormer model)</li> <li><strong>pvt</strong> — <a href="/docs/transformers/main/en/model_doc/pvt#transformers.PvtImageProcessor">PvtImageProcessor</a> (PVT model)</li> <li><strong>pvt_v2</strong> — <a href="/docs/transformers/main/en/model_doc/pvt#transformers.PvtImageProcessor">PvtImageProcessor</a> (PVTv2 model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/main/en/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/main/en/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (ResNet model)</li> <li><strong>sam</strong> — <a href="/docs/transformers/main/en/model_doc/sam#transformers.SamImageProcessor">SamImageProcessor</a> (SAM model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/main/en/model_doc/segformer#transformers.SegformerImageProcessor">SegformerImageProcessor</a> (SegFormer model)</li> <li><strong>seggpt</strong> — <a href="/docs/transformers/main/en/model_doc/seggpt#transformers.SegGptImageProcessor">SegGptImageProcessor</a> (SegGPT model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipImageProcessor">SiglipImageProcessor</a> (SigLIP model)</li> <li><strong>swiftformer</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (SwiftFormer model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (Swin Transformer model)</li> <li><strong>swin2sr</strong> — <a href="/docs/transformers/main/en/model_doc/swin2sr#transformers.Swin2SRImageProcessor">Swin2SRImageProcessor</a> (Swin2SR model)</li> <li><strong>swinv2</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (Swin Transformer V2 model)</li> <li><strong>table-transformer</strong> — <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a> (Table Transformer model)</li> <li><strong>timesformer</strong> — <a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEImageProcessor">VideoMAEImageProcessor</a> (TimeSformer model)</li> <li><strong>tvlt</strong> — <a href="/docs/transformers/main/en/model_doc/tvlt#transformers.TvltImageProcessor">TvltImageProcessor</a> (TVLT model)</li> <li><strong>tvp</strong> — <a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpImageProcessor">TvpImageProcessor</a> (TVP model)</li> <li><strong>udop</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.LayoutLMv3ImageProcessor">LayoutLMv3ImageProcessor</a> (UDOP model)</li> <li><strong>upernet</strong> — <a href="/docs/transformers/main/en/model_doc/segformer#transformers.SegformerImageProcessor">SegformerImageProcessor</a> (UPerNet model)</li> <li><strong>van</strong> — <a href="/docs/transformers/main/en/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (VAN model)</li> <li><strong>videomae</strong> — <a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEImageProcessor">VideoMAEImageProcessor</a> (VideoMAE model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltImageProcessor">ViltImageProcessor</a> (ViLT model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (VipLlava model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (ViT model)</li> <li><strong>vit_hybrid</strong> — <a href="/docs/transformers/main/en/model_doc/vit_hybrid#transformers.ViTHybridImageProcessor">ViTHybridImageProcessor</a> (ViT Hybrid model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (ViTMAE model)</li> <li><strong>vit_msn</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (ViTMSN model)</li> <li><strong>vitmatte</strong> — <a href="/docs/transformers/main/en/model_doc/vitmatte#transformers.VitMatteImageProcessor">VitMatteImageProcessor</a> (ViTMatte model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (X-CLIP model)</li> <li><strong>yolos</strong> — <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosImageProcessor">YolosImageProcessor</a> (YOLOS model)</li>',yL,As,vL,js,wL,Zs,Xd,xL,Jp,C0="Register a new image processor for this class.",Qv,Dd,Hv,he,Qd,LL,Ep,y0=`This is a generic processor class that will be instantiated as one of the processor classes of the library when
created with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor.from_pretrained">AutoProcessor.from_pretrained()</a> class method.`,kL,Ip,v0="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",$L,Z,Hd,BL,Up,w0="Instantiate one of the processor classes of the library from a pretrained model vocabulary.",AL,Np,x0=`The processor class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible):`,jL,qp,L0='<li><strong>align</strong> — <a href="/docs/transformers/main/en/model_doc/align#transformers.AlignProcessor">AlignProcessor</a> (ALIGN model)</li> <li><strong>altclip</strong> — <a href="/docs/transformers/main/en/model_doc/altclip#transformers.AltCLIPProcessor">AltCLIPProcessor</a> (AltCLIP model)</li> <li><strong>bark</strong> — <a href="/docs/transformers/main/en/model_doc/bark#transformers.BarkProcessor">BarkProcessor</a> (Bark model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/main/en/model_doc/blip#transformers.BlipProcessor">BlipProcessor</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/main/en/model_doc/blip-2#transformers.Blip2Processor">Blip2Processor</a> (BLIP-2 model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/main/en/model_doc/bridgetower#transformers.BridgeTowerProcessor">BridgeTowerProcessor</a> (BridgeTower model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/main/en/model_doc/chinese_clip#transformers.ChineseCLIPProcessor">ChineseCLIPProcessor</a> (Chinese-CLIP model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/main/en/model_doc/clap#transformers.ClapProcessor">ClapProcessor</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPProcessor">CLIPProcessor</a> (CLIP model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegProcessor">CLIPSegProcessor</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/main/en/model_doc/clvp#transformers.ClvpProcessor">ClvpProcessor</a> (CLVP model)</li> <li><strong>flava</strong> — <a href="/docs/transformers/main/en/model_doc/flava#transformers.FlavaProcessor">FlavaProcessor</a> (FLAVA model)</li> <li><strong>fuyu</strong> — <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuProcessor">FuyuProcessor</a> (Fuyu model)</li> <li><strong>git</strong> — <a href="/docs/transformers/main/en/model_doc/git#transformers.GitProcessor">GitProcessor</a> (GIT model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPProcessor">CLIPProcessor</a> (GroupViT model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (Hubert model)</li> <li><strong>idefics</strong> — <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsProcessor">IdeficsProcessor</a> (IDEFICS model)</li> <li><strong>instructblip</strong> — <a href="/docs/transformers/main/en/model_doc/instructblip#transformers.InstructBlipProcessor">InstructBlipProcessor</a> (InstructBLIP model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/main/en/model_doc/kosmos-2#transformers.Kosmos2Processor">Kosmos2Processor</a> (KOSMOS-2 model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv2#transformers.LayoutLMv2Processor">LayoutLMv2Processor</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.LayoutLMv3Processor">LayoutLMv3Processor</a> (LayoutLMv3 model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> (LLaVa model)</li> <li><strong>llava_next</strong> — <a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextProcessor">LlavaNextProcessor</a> (LLaVA-NeXT model)</li> <li><strong>markuplm</strong> — <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMProcessor">MarkupLMProcessor</a> (MarkupLM model)</li> <li><strong>mctct</strong> — <a href="/docs/transformers/main/en/model_doc/mctct#transformers.MCTCTProcessor">MCTCTProcessor</a> (M-CTC-T model)</li> <li><strong>mgp-str</strong> — <a href="/docs/transformers/main/en/model_doc/mgp-str#transformers.MgpstrProcessor">MgpstrProcessor</a> (MGP-STR model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a> (OneFormer model)</li> <li><strong>owlv2</strong> — <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Processor">Owlv2Processor</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/main/en/model_doc/owlvit#transformers.OwlViTProcessor">OwlViTProcessor</a> (OWL-ViT model)</li> <li><strong>pix2struct</strong> — <a href="/docs/transformers/main/en/model_doc/pix2struct#transformers.Pix2StructProcessor">Pix2StructProcessor</a> (Pix2Struct model)</li> <li><strong>pop2piano</strong> — <a href="/docs/transformers/main/en/model_doc/pop2piano#transformers.Pop2PianoProcessor">Pop2PianoProcessor</a> (Pop2Piano model)</li> <li><strong>sam</strong> — <a href="/docs/transformers/main/en/model_doc/sam#transformers.SamProcessor">SamProcessor</a> (SAM model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TProcessor">SeamlessM4TProcessor</a> (SeamlessM4T model)</li> <li><strong>sew</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (SEW model)</li> <li><strong>sew-d</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (SEW-D model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipProcessor">SiglipProcessor</a> (SigLIP model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/main/en/model_doc/speech_to_text#transformers.Speech2TextProcessor">Speech2TextProcessor</a> (Speech2Text model)</li> <li><strong>speech_to_text_2</strong> — <a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2Processor">Speech2Text2Processor</a> (Speech2Text2 model)</li> <li><strong>speecht5</strong> — <a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5Processor">SpeechT5Processor</a> (SpeechT5 model)</li> <li><strong>trocr</strong> — <a href="/docs/transformers/main/en/model_doc/trocr#transformers.TrOCRProcessor">TrOCRProcessor</a> (TrOCR model)</li> <li><strong>tvlt</strong> — <a href="/docs/transformers/main/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a> (TVLT model)</li> <li><strong>tvp</strong> — <a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpProcessor">TvpProcessor</a> (TVP model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (UniSpeechSat model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltProcessor">ViltProcessor</a> (ViLT model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> (VipLlava model)</li> <li><strong>vision-text-dual-encoder</strong> — <a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderProcessor">VisionTextDualEncoderProcessor</a> (VisionTextDualEncoder model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (WavLM model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/main/en/model_doc/whisper#transformers.WhisperProcessor">WhisperProcessor</a> (Whisper model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/main/en/model_doc/xclip#transformers.XCLIPProcessor">XCLIPProcessor</a> (X-CLIP model)</li>',ZL,Rs,RL,Ss,SL,Gs,Yd,GL,Xp,k0="Register a new processor for this class.",Yv,zd,zv,Od,$0="The following auto classes are available for instantiating a base model class without a specific head.",Ov,Kd,Kv,pe,em,WL,Dp,B0=`This is a generic model class that will be instantiated as one of the base model classes of the library when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,PL,Qp,A0="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",VL,Gn,om,JL,Hp,j0="Instantiates one of the base model classes of the library from a configuration.",EL,Yp,Z0=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,IL,Ws,UL,R,rm,NL,zp,R0="Instantiate one of the base model classes of the library from a pretrained model.",qL,Op,S0=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,XL,Kp,G0='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertModel">AlbertModel</a> (ALBERT model)</li> <li><strong>align</strong> — <a href="/docs/transformers/main/en/model_doc/align#transformers.AlignModel">AlignModel</a> (ALIGN model)</li> <li><strong>altclip</strong> — <a href="/docs/transformers/main/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a> (AltCLIP model)</li> <li><strong>audio-spectrogram-transformer</strong> — <a href="/docs/transformers/main/en/model_doc/audio-spectrogram-transformer#transformers.ASTModel">ASTModel</a> (Audio Spectrogram Transformer model)</li> <li><strong>autoformer</strong> — <a href="/docs/transformers/main/en/model_doc/autoformer#transformers.AutoformerModel">AutoformerModel</a> (Autoformer model)</li> <li><strong>bark</strong> — <a href="/docs/transformers/main/en/model_doc/bark#transformers.BarkModel">BarkModel</a> (Bark model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.BartModel">BartModel</a> (BART model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitModel">BeitModel</a> (BEiT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertModel">BertModel</a> (BERT model)</li> <li><strong>bert-generation</strong> — <a href="/docs/transformers/main/en/model_doc/bert-generation#transformers.BertGenerationEncoder">BertGenerationEncoder</a> (Bert Generation model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdModel">BigBirdModel</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/main/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusModel">BigBirdPegasusModel</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptModel">BioGptModel</a> (BioGpt model)</li> <li><strong>bit</strong> — <a href="/docs/transformers/main/en/model_doc/bit#transformers.BitModel">BitModel</a> (BiT model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/main/en/model_doc/blenderbot#transformers.BlenderbotModel">BlenderbotModel</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/main/en/model_doc/blenderbot-small#transformers.BlenderbotSmallModel">BlenderbotSmallModel</a> (BlenderbotSmall model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/main/en/model_doc/blip#transformers.BlipModel">BlipModel</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/main/en/model_doc/blip-2#transformers.Blip2Model">Blip2Model</a> (BLIP-2 model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/en/model_doc/bloom#transformers.BloomModel">BloomModel</a> (BLOOM model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/main/en/model_doc/bridgetower#transformers.BridgeTowerModel">BridgeTowerModel</a> (BridgeTower model)</li> <li><strong>bros</strong> — <a href="/docs/transformers/main/en/model_doc/bros#transformers.BrosModel">BrosModel</a> (BROS model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertModel">CamembertModel</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineModel">CanineModel</a> (CANINE model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/main/en/model_doc/chinese_clip#transformers.ChineseCLIPModel">ChineseCLIPModel</a> (Chinese-CLIP model)</li> <li><strong>chinese_clip_vision_model</strong> — <a href="/docs/transformers/main/en/model_doc/chinese_clip#transformers.ChineseCLIPVisionModel">ChineseCLIPVisionModel</a> (ChineseCLIPVisionModel model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/main/en/model_doc/clap#transformers.ClapModel">ClapModel</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPModel">CLIPModel</a> (CLIP model)</li> <li><strong>clip_vision_model</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionModel">CLIPVisionModel</a> (CLIPVisionModel model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/main/en/model_doc/clvp#transformers.ClvpModelForConditionalGeneration">ClvpModelForConditionalGeneration</a> (CLVP model)</li> <li><strong>code_llama</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaModel">LlamaModel</a> (CodeLlama model)</li> <li><strong>codegen</strong> — <a href="/docs/transformers/main/en/model_doc/codegen#transformers.CodeGenModel">CodeGenModel</a> (CodeGen model)</li> <li><strong>cohere</strong> — <a href="/docs/transformers/main/en/model_doc/cohere#transformers.CohereModel">CohereModel</a> (Cohere model)</li> <li><strong>conditional_detr</strong> — <a href="/docs/transformers/main/en/model_doc/conditional_detr#transformers.ConditionalDetrModel">ConditionalDetrModel</a> (Conditional DETR model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/en/model_doc/convbert#transformers.ConvBertModel">ConvBertModel</a> (ConvBERT model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/main/en/model_doc/convnext#transformers.ConvNextModel">ConvNextModel</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/main/en/model_doc/convnextv2#transformers.ConvNextV2Model">ConvNextV2Model</a> (ConvNeXTV2 model)</li> <li><strong>cpmant</strong> — <a href="/docs/transformers/main/en/model_doc/cpmant#transformers.CpmAntModel">CpmAntModel</a> (CPM-Ant model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/en/model_doc/ctrl#transformers.CTRLModel">CTRLModel</a> (CTRL model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/main/en/model_doc/cvt#transformers.CvtModel">CvtModel</a> (CvT model)</li> <li><strong>data2vec-audio</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecAudioModel">Data2VecAudioModel</a> (Data2VecAudio model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecTextModel">Data2VecTextModel</a> (Data2VecText model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecVisionModel">Data2VecVisionModel</a> (Data2VecVision model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/en/model_doc/deberta#transformers.DebertaModel">DebertaModel</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.DebertaV2Model">DebertaV2Model</a> (DeBERTa-v2 model)</li> <li><strong>decision_transformer</strong> — <a href="/docs/transformers/main/en/model_doc/decision_transformer#transformers.DecisionTransformerModel">DecisionTransformerModel</a> (Decision Transformer model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/main/en/model_doc/deformable_detr#transformers.DeformableDetrModel">DeformableDetrModel</a> (Deformable DETR model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTModel">DeiTModel</a> (DeiT model)</li> <li><strong>deta</strong> — <a href="/docs/transformers/main/en/model_doc/deta#transformers.DetaModel">DetaModel</a> (DETA model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrModel">DetrModel</a> (DETR model)</li> <li><strong>dinat</strong> — <a href="/docs/transformers/main/en/model_doc/dinat#transformers.DinatModel">DinatModel</a> (DiNAT model)</li> <li><strong>dinov2</strong> — <a href="/docs/transformers/main/en/model_doc/dinov2#transformers.Dinov2Model">Dinov2Model</a> (DINOv2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertModel">DistilBertModel</a> (DistilBERT model)</li> <li><strong>donut-swin</strong> — <a href="/docs/transformers/main/en/model_doc/donut#transformers.DonutSwinModel">DonutSwinModel</a> (DonutSwin model)</li> <li><strong>dpr</strong> — <a href="/docs/transformers/main/en/model_doc/dpr#transformers.DPRQuestionEncoder">DPRQuestionEncoder</a> (DPR model)</li> <li><strong>dpt</strong> — <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTModel">DPTModel</a> (DPT model)</li> <li><strong>efficientformer</strong> — <a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerModel">EfficientFormerModel</a> (EfficientFormer model)</li> <li><strong>efficientnet</strong> — <a href="/docs/transformers/main/en/model_doc/efficientnet#transformers.EfficientNetModel">EfficientNetModel</a> (EfficientNet model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraModel">ElectraModel</a> (ELECTRA model)</li> <li><strong>encodec</strong> — <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a> (EnCodec model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/main/en/model_doc/ernie#transformers.ErnieModel">ErnieModel</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMModel">ErnieMModel</a> (ErnieM model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/main/en/model_doc/esm#transformers.EsmModel">EsmModel</a> (ESM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/main/en/model_doc/falcon#transformers.FalconModel">FalconModel</a> (Falcon model)</li> <li><strong>fastspeech2_conformer</strong> — <a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerModel">FastSpeech2ConformerModel</a> (FastSpeech2Conformer model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.FlaubertModel">FlaubertModel</a> (FlauBERT model)</li> <li><strong>flava</strong> — <a href="/docs/transformers/main/en/model_doc/flava#transformers.FlavaModel">FlavaModel</a> (FLAVA model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/main/en/model_doc/fnet#transformers.FNetModel">FNetModel</a> (FNet model)</li> <li><strong>focalnet</strong> — <a href="/docs/transformers/main/en/model_doc/focalnet#transformers.FocalNetModel">FocalNetModel</a> (FocalNet model)</li> <li><strong>fsmt</strong> — <a href="/docs/transformers/main/en/model_doc/fsmt#transformers.FSMTModel">FSMTModel</a> (FairSeq Machine-Translation model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelModel">FunnelModel</a> or <a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelBaseModel">FunnelBaseModel</a> (Funnel Transformer model)</li> <li><strong>gemma</strong> — <a href="/docs/transformers/main/en/model_doc/gemma#transformers.GemmaModel">GemmaModel</a> (Gemma model)</li> <li><strong>git</strong> — <a href="/docs/transformers/main/en/model_doc/git#transformers.GitModel">GitModel</a> (GIT model)</li> <li><strong>glpn</strong> — <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNModel">GLPNModel</a> (GLPN model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Model">GPT2Model</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Model">GPT2Model</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeModel">GPTBigCodeModel</a> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neo#transformers.GPTNeoModel">GPTNeoModel</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neox#transformers.GPTNeoXModel">GPTNeoXModel</a> (GPT NeoX model)</li> <li><strong>gpt_neox_japanese</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseModel">GPTNeoXJapaneseModel</a> (GPT NeoX Japanese model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/main/en/model_doc/gptj#transformers.GPTJModel">GPTJModel</a> (GPT-J model)</li> <li><strong>gptsan-japanese</strong> — <a href="/docs/transformers/main/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseForConditionalGeneration">GPTSanJapaneseForConditionalGeneration</a> (GPTSAN-japanese model)</li> <li><strong>graphormer</strong> — <a href="/docs/transformers/main/en/model_doc/graphormer#transformers.GraphormerModel">GraphormerModel</a> (Graphormer model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/main/en/model_doc/groupvit#transformers.GroupViTModel">GroupViTModel</a> (GroupViT model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertModel">HubertModel</a> (Hubert model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/main/en/model_doc/ibert#transformers.IBertModel">IBertModel</a> (I-BERT model)</li> <li><strong>idefics</strong> — <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsModel">IdeficsModel</a> (IDEFICS model)</li> <li><strong>imagegpt</strong> — <a href="/docs/transformers/main/en/model_doc/imagegpt#transformers.ImageGPTModel">ImageGPTModel</a> (ImageGPT model)</li> <li><strong>informer</strong> — <a href="/docs/transformers/main/en/model_doc/informer#transformers.InformerModel">InformerModel</a> (Informer model)</li> <li><strong>jukebox</strong> — <a href="/docs/transformers/main/en/model_doc/jukebox#transformers.JukeboxModel">JukeboxModel</a> (Jukebox model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/main/en/model_doc/kosmos-2#transformers.Kosmos2Model">Kosmos2Model</a> (KOSMOS-2 model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.LayoutLMModel">LayoutLMModel</a> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv2#transformers.LayoutLMv2Model">LayoutLMv2Model</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.LayoutLMv3Model">LayoutLMv3Model</a> (LayoutLMv3 model)</li> <li><strong>led</strong> — <a href="/docs/transformers/main/en/model_doc/led#transformers.LEDModel">LEDModel</a> (LED model)</li> <li><strong>levit</strong> — <a href="/docs/transformers/main/en/model_doc/levit#transformers.LevitModel">LevitModel</a> (LeViT model)</li> <li><strong>lilt</strong> — <a href="/docs/transformers/main/en/model_doc/lilt#transformers.LiltModel">LiltModel</a> (LiLT model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaModel">LlamaModel</a> (LLaMA model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/main/en/model_doc/longformer#transformers.LongformerModel">LongformerModel</a> (Longformer model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/main/en/model_doc/longt5#transformers.LongT5Model">LongT5Model</a> (LongT5 model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/main/en/model_doc/luke#transformers.LukeModel">LukeModel</a> (LUKE model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/main/en/model_doc/lxmert#transformers.LxmertModel">LxmertModel</a> (LXMERT model)</li> <li><strong>m2m_100</strong> — <a href="/docs/transformers/main/en/model_doc/m2m_100#transformers.M2M100Model">M2M100Model</a> (M2M100 model)</li> <li><strong>mamba</strong> — <a href="/docs/transformers/main/en/model_doc/mamba#transformers.MambaModel">MambaModel</a> (Mamba model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/main/en/model_doc/marian#transformers.MarianModel">MarianModel</a> (Marian model)</li> <li><strong>markuplm</strong> — <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMModel">MarkupLMModel</a> (MarkupLM model)</li> <li><strong>mask2former</strong> — <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a> (Mask2Former model)</li> <li><strong>maskformer</strong> — <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerModel">MaskFormerModel</a> (MaskFormer model)</li> <li><strong>maskformer-swin</strong> — <code>MaskFormerSwinModel</code> (MaskFormerSwin model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBartModel">MBartModel</a> (mBART model)</li> <li><strong>mctct</strong> — <a href="/docs/transformers/main/en/model_doc/mctct#transformers.MCTCTModel">MCTCTModel</a> (M-CTC-T model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/main/en/model_doc/mega#transformers.MegaModel">MegaModel</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/main/en/model_doc/megatron-bert#transformers.MegatronBertModel">MegatronBertModel</a> (Megatron-BERT model)</li> <li><strong>mgp-str</strong> — <a href="/docs/transformers/main/en/model_doc/mgp-str#transformers.MgpstrForSceneTextRecognition">MgpstrForSceneTextRecognition</a> (MGP-STR model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/main/en/model_doc/mistral#transformers.MistralModel">MistralModel</a> (Mistral model)</li> <li><strong>mixtral</strong> — <a href="/docs/transformers/main/en/model_doc/mixtral#transformers.MixtralModel">MixtralModel</a> (Mixtral model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertModel">MobileBertModel</a> (MobileBERT model)</li> <li><strong>mobilenet_v1</strong> — <a href="/docs/transformers/main/en/model_doc/mobilenet_v1#transformers.MobileNetV1Model">MobileNetV1Model</a> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <a href="/docs/transformers/main/en/model_doc/mobilenet_v2#transformers.MobileNetV2Model">MobileNetV2Model</a> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/main/en/model_doc/mobilevit#transformers.MobileViTModel">MobileViTModel</a> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <a href="/docs/transformers/main/en/model_doc/mobilevitv2#transformers.MobileViTV2Model">MobileViTV2Model</a> (MobileViTV2 model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.MPNetModel">MPNetModel</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptModel">MptModel</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/main/en/model_doc/mra#transformers.MraModel">MraModel</a> (MRA model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Model">MT5Model</a> (MT5 model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/main/en/model_doc/mvp#transformers.MvpModel">MvpModel</a> (MVP model)</li> <li><strong>nat</strong> — <a href="/docs/transformers/main/en/model_doc/nat#transformers.NatModel">NatModel</a> (NAT model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/main/en/model_doc/nezha#transformers.NezhaModel">NezhaModel</a> (Nezha model)</li> <li><strong>nllb-moe</strong> — <a href="/docs/transformers/main/en/model_doc/nllb-moe#transformers.NllbMoeModel">NllbMoeModel</a> (NLLB-MOE model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/main/en/model_doc/nystromformer#transformers.NystromformerModel">NystromformerModel</a> (Nyströmformer model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a> (OneFormer model)</li> <li><strong>open-llama</strong> — <a href="/docs/transformers/main/en/model_doc/open-llama#transformers.OpenLlamaModel">OpenLlamaModel</a> (OpenLlama model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTModel">OpenAIGPTModel</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTModel">OPTModel</a> (OPT model)</li> <li><strong>owlv2</strong> — <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/main/en/model_doc/owlvit#transformers.OwlViTModel">OwlViTModel</a> (OWL-ViT model)</li> <li><strong>patchtsmixer</strong> — <a href="/docs/transformers/main/en/model_doc/patchtsmixer#transformers.PatchTSMixerModel">PatchTSMixerModel</a> (PatchTSMixer model)</li> <li><strong>patchtst</strong> — <a href="/docs/transformers/main/en/model_doc/patchtst#transformers.PatchTSTModel">PatchTSTModel</a> (PatchTST model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/main/en/model_doc/pegasus#transformers.PegasusModel">PegasusModel</a> (Pegasus model)</li> <li><strong>pegasus_x</strong> — <a href="/docs/transformers/main/en/model_doc/pegasus_x#transformers.PegasusXModel">PegasusXModel</a> (PEGASUS-X model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> (Perceiver model)</li> <li><strong>persimmon</strong> — <a href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonModel">PersimmonModel</a> (Persimmon model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiModel">PhiModel</a> (Phi model)</li> <li><strong>plbart</strong> — <a href="/docs/transformers/main/en/model_doc/plbart#transformers.PLBartModel">PLBartModel</a> (PLBart model)</li> <li><strong>poolformer</strong> — <a href="/docs/transformers/main/en/model_doc/poolformer#transformers.PoolFormerModel">PoolFormerModel</a> (PoolFormer model)</li> <li><strong>prophetnet</strong> — <a href="/docs/transformers/main/en/model_doc/prophetnet#transformers.ProphetNetModel">ProphetNetModel</a> (ProphetNet model)</li> <li><strong>pvt</strong> — <a href="/docs/transformers/main/en/model_doc/pvt#transformers.PvtModel">PvtModel</a> (PVT model)</li> <li><strong>pvt_v2</strong> — <a href="/docs/transformers/main/en/model_doc/pvt_v2#transformers.PvtV2Model">PvtV2Model</a> (PVTv2 model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/main/en/model_doc/qdqbert#transformers.QDQBertModel">QDQBertModel</a> (QDQBert model)</li> <li><strong>qwen2</strong> — <a href="/docs/transformers/main/en/model_doc/qwen2#transformers.Qwen2Model">Qwen2Model</a> (Qwen2 model)</li> <li><strong>qwen2_moe</strong> — <a href="/docs/transformers/main/en/model_doc/qwen2_moe#transformers.Qwen2MoeModel">Qwen2MoeModel</a> (Qwen2MoE model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerModel">ReformerModel</a> (Reformer model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetModel">RegNetModel</a> (RegNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/main/en/model_doc/rembert#transformers.RemBertModel">RemBertModel</a> (RemBERT model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/main/en/model_doc/resnet#transformers.ResNetModel">ResNetModel</a> (ResNet model)</li> <li><strong>retribert</strong> — <a href="/docs/transformers/main/en/model_doc/retribert#transformers.RetriBertModel">RetriBertModel</a> (RetriBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaModel">RobertaModel</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormModel">RobertaPreLayerNormModel</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/main/en/model_doc/roc_bert#transformers.RoCBertModel">RoCBertModel</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerModel">RoFormerModel</a> (RoFormer model)</li> <li><strong>rwkv</strong> — <a href="/docs/transformers/main/en/model_doc/rwkv#transformers.RwkvModel">RwkvModel</a> (RWKV model)</li> <li><strong>sam</strong> — <a href="/docs/transformers/main/en/model_doc/sam#transformers.SamModel">SamModel</a> (SAM model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TModel">SeamlessM4TModel</a> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Model">SeamlessM4Tv2Model</a> (SeamlessM4Tv2 model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/main/en/model_doc/segformer#transformers.SegformerModel">SegformerModel</a> (SegFormer model)</li> <li><strong>seggpt</strong> — <a href="/docs/transformers/main/en/model_doc/seggpt#transformers.SegGptModel">SegGptModel</a> (SegGPT model)</li> <li><strong>sew</strong> — <a href="/docs/transformers/main/en/model_doc/sew#transformers.SEWModel">SEWModel</a> (SEW model)</li> <li><strong>sew-d</strong> — <a href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDModel">SEWDModel</a> (SEW-D model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipModel">SiglipModel</a> (SigLIP model)</li> <li><strong>siglip_vision_model</strong> — <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipVisionModel">SiglipVisionModel</a> (SiglipVisionModel model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/main/en/model_doc/speech_to_text#transformers.Speech2TextModel">Speech2TextModel</a> (Speech2Text model)</li> <li><strong>speecht5</strong> — <a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5Model">SpeechT5Model</a> (SpeechT5 model)</li> <li><strong>splinter</strong> — <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a> (Splinter model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/main/en/model_doc/squeezebert#transformers.SqueezeBertModel">SqueezeBertModel</a> (SqueezeBERT model)</li> <li><strong>stablelm</strong> — <a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmModel">StableLmModel</a> (StableLm model)</li> <li><strong>starcoder2</strong> — <a href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2Model">Starcoder2Model</a> (Starcoder2 model)</li> <li><strong>swiftformer</strong> — <a href="/docs/transformers/main/en/model_doc/swiftformer#transformers.SwiftFormerModel">SwiftFormerModel</a> (SwiftFormer model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/main/en/model_doc/swin#transformers.SwinModel">SwinModel</a> (Swin Transformer model)</li> <li><strong>swin2sr</strong> — <a href="/docs/transformers/main/en/model_doc/swin2sr#transformers.Swin2SRModel">Swin2SRModel</a> (Swin2SR model)</li> <li><strong>swinv2</strong> — <a href="/docs/transformers/main/en/model_doc/swinv2#transformers.Swinv2Model">Swinv2Model</a> (Swin Transformer V2 model)</li> <li><strong>switch_transformers</strong> — <a href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersModel">SwitchTransformersModel</a> (SwitchTransformers model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5Model">T5Model</a> (T5 model)</li> <li><strong>table-transformer</strong> — <a href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerModel">TableTransformerModel</a> (Table Transformer model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasModel">TapasModel</a> (TAPAS model)</li> <li><strong>time_series_transformer</strong> — <a href="/docs/transformers/main/en/model_doc/time_series_transformer#transformers.TimeSeriesTransformerModel">TimeSeriesTransformerModel</a> (Time Series Transformer model)</li> <li><strong>timesformer</strong> — <a href="/docs/transformers/main/en/model_doc/timesformer#transformers.TimesformerModel">TimesformerModel</a> (TimeSformer model)</li> <li><strong>timm_backbone</strong> — <a href="/docs/transformers/main/en/main_classes/backbones#transformers.TimmBackbone">TimmBackbone</a> (TimmBackbone model)</li> <li><strong>trajectory_transformer</strong> — <a href="/docs/transformers/main/en/model_doc/trajectory_transformer#transformers.TrajectoryTransformerModel">TrajectoryTransformerModel</a> (Trajectory Transformer model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TransfoXLModel">TransfoXLModel</a> (Transformer-XL model)</li> <li><strong>tvlt</strong> — <a href="/docs/transformers/main/en/model_doc/tvlt#transformers.TvltModel">TvltModel</a> (TVLT model)</li> <li><strong>tvp</strong> — <a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpModel">TvpModel</a> (TVP model)</li> <li><strong>udop</strong> — <a href="/docs/transformers/main/en/model_doc/udop#transformers.UdopModel">UdopModel</a> (UDOP model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/main/en/model_doc/umt5#transformers.UMT5Model">UMT5Model</a> (UMT5 model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/main/en/model_doc/unispeech#transformers.UniSpeechModel">UniSpeechModel</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/main/en/model_doc/unispeech-sat#transformers.UniSpeechSatModel">UniSpeechSatModel</a> (UniSpeechSat model)</li> <li><strong>univnet</strong> — <a href="/docs/transformers/main/en/model_doc/univnet#transformers.UnivNetModel">UnivNetModel</a> (UnivNet model)</li> <li><strong>van</strong> — <a href="/docs/transformers/main/en/model_doc/van#transformers.VanModel">VanModel</a> (VAN model)</li> <li><strong>videomae</strong> — <a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEModel">VideoMAEModel</a> (VideoMAE model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltModel">ViltModel</a> (ViLT model)</li> <li><strong>vision-text-dual-encoder</strong> — <a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderModel">VisionTextDualEncoderModel</a> (VisionTextDualEncoder model)</li> <li><strong>visual_bert</strong> — <a href="/docs/transformers/main/en/model_doc/visual_bert#transformers.VisualBertModel">VisualBertModel</a> (VisualBERT model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTModel">ViTModel</a> (ViT model)</li> <li><strong>vit_hybrid</strong> — <a href="/docs/transformers/main/en/model_doc/vit_hybrid#transformers.ViTHybridModel">ViTHybridModel</a> (ViT Hybrid model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/main/en/model_doc/vit_mae#transformers.ViTMAEModel">ViTMAEModel</a> (ViTMAE model)</li> <li><strong>vit_msn</strong> — <a href="/docs/transformers/main/en/model_doc/vit_msn#transformers.ViTMSNModel">ViTMSNModel</a> (ViTMSN model)</li> <li><strong>vitdet</strong> — <a href="/docs/transformers/main/en/model_doc/vitdet#transformers.VitDetModel">VitDetModel</a> (VitDet model)</li> <li><strong>vits</strong> — <a href="/docs/transformers/main/en/model_doc/vits#transformers.VitsModel">VitsModel</a> (VITS model)</li> <li><strong>vivit</strong> — <a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitModel">VivitModel</a> (ViViT model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Model">Wav2Vec2Model</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertModel">Wav2Vec2BertModel</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerModel">Wav2Vec2ConformerModel</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/main/en/model_doc/wavlm#transformers.WavLMModel">WavLMModel</a> (WavLM model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/main/en/model_doc/whisper#transformers.WhisperModel">WhisperModel</a> (Whisper model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/main/en/model_doc/xclip#transformers.XCLIPModel">XCLIPModel</a> (X-CLIP model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/main/en/model_doc/xglm#transformers.XGLMModel">XGLMModel</a> (XGLM model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMModel">XLMModel</a> (XLM model)</li> <li><strong>xlm-prophetnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetModel">XLMProphetNetModel</a> (XLM-ProphetNet model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaModel">XLMRobertaModel</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLModel">XLMRobertaXLModel</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetModel">XLNetModel</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/main/en/model_doc/xmod#transformers.XmodModel">XmodModel</a> (X-MOD model)</li> <li><strong>yolos</strong> — <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosModel">YolosModel</a> (YOLOS model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/main/en/model_doc/yoso#transformers.YosoModel">YosoModel</a> (YOSO model)</li>',DL,eu,W0=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,QL,Ps,e2,nm,o2,ue,tm,HL,ou,P0=`This is a generic model class that will be instantiated as one of the base model classes of the library when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,YL,ru,V0="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",zL,Wn,am,OL,nu,J0="Instantiates one of the base model classes of the library from a configuration.",KL,tu,E0=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,ek,Vs,ok,Uo,sm,rk,au,I0="Instantiate one of the base model classes of the library from a pretrained model.",nk,su,U0=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,tk,iu,N0='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.TFAlbertModel">TFAlbertModel</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.TFBartModel">TFBartModel</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.TFBertModel">TFBertModel</a> (BERT model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/main/en/model_doc/blenderbot#transformers.TFBlenderbotModel">TFBlenderbotModel</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/main/en/model_doc/blenderbot-small#transformers.TFBlenderbotSmallModel">TFBlenderbotSmallModel</a> (BlenderbotSmall model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/main/en/model_doc/blip#transformers.TFBlipModel">TFBlipModel</a> (BLIP model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/en/model_doc/camembert#transformers.TFCamembertModel">TFCamembertModel</a> (CamemBERT model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.TFCLIPModel">TFCLIPModel</a> (CLIP model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/en/model_doc/convbert#transformers.TFConvBertModel">TFConvBertModel</a> (ConvBERT model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/main/en/model_doc/convnext#transformers.TFConvNextModel">TFConvNextModel</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/main/en/model_doc/convnextv2#transformers.TFConvNextV2Model">TFConvNextV2Model</a> (ConvNeXTV2 model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/en/model_doc/ctrl#transformers.TFCTRLModel">TFCTRLModel</a> (CTRL model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/main/en/model_doc/cvt#transformers.TFCvtModel">TFCvtModel</a> (CvT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.TFData2VecVisionModel">TFData2VecVisionModel</a> (Data2VecVision model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/en/model_doc/deberta#transformers.TFDebertaModel">TFDebertaModel</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.TFDebertaV2Model">TFDebertaV2Model</a> (DeBERTa-v2 model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/main/en/model_doc/deit#transformers.TFDeiTModel">TFDeiTModel</a> (DeiT model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.TFDistilBertModel">TFDistilBertModel</a> (DistilBERT model)</li> <li><strong>dpr</strong> — <a href="/docs/transformers/main/en/model_doc/dpr#transformers.TFDPRQuestionEncoder">TFDPRQuestionEncoder</a> (DPR model)</li> <li><strong>efficientformer</strong> — <a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.TFEfficientFormerModel">TFEfficientFormerModel</a> (EfficientFormer model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.TFElectraModel">TFElectraModel</a> (ELECTRA model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/main/en/model_doc/esm#transformers.TFEsmModel">TFEsmModel</a> (ESM model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.TFFlaubertModel">TFFlaubertModel</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/main/en/model_doc/funnel#transformers.TFFunnelModel">TFFunnelModel</a> or <a href="/docs/transformers/main/en/model_doc/funnel#transformers.TFFunnelBaseModel">TFFunnelBaseModel</a> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.TFGPT2Model">TFGPT2Model</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.TFGPT2Model">TFGPT2Model</a> (OpenAI GPT-2 model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/main/en/model_doc/gptj#transformers.TFGPTJModel">TFGPTJModel</a> (GPT-J model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/main/en/model_doc/groupvit#transformers.TFGroupViTModel">TFGroupViTModel</a> (GroupViT model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/main/en/model_doc/hubert#transformers.TFHubertModel">TFHubertModel</a> (Hubert model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.TFLayoutLMModel">TFLayoutLMModel</a> (LayoutLM model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.TFLayoutLMv3Model">TFLayoutLMv3Model</a> (LayoutLMv3 model)</li> <li><strong>led</strong> — <a href="/docs/transformers/main/en/model_doc/led#transformers.TFLEDModel">TFLEDModel</a> (LED model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/main/en/model_doc/longformer#transformers.TFLongformerModel">TFLongformerModel</a> (Longformer model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/main/en/model_doc/lxmert#transformers.TFLxmertModel">TFLxmertModel</a> (LXMERT model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/main/en/model_doc/marian#transformers.TFMarianModel">TFMarianModel</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/main/en/model_doc/mbart#transformers.TFMBartModel">TFMBartModel</a> (mBART model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.TFMobileBertModel">TFMobileBertModel</a> (MobileBERT model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/main/en/model_doc/mobilevit#transformers.TFMobileViTModel">TFMobileViTModel</a> (MobileViT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.TFMPNetModel">TFMPNetModel</a> (MPNet model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.TFMT5Model">TFMT5Model</a> (MT5 model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.TFOpenAIGPTModel">TFOpenAIGPTModel</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/main/en/model_doc/opt#transformers.TFOPTModel">TFOPTModel</a> (OPT model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/main/en/model_doc/pegasus#transformers.TFPegasusModel">TFPegasusModel</a> (Pegasus model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/main/en/model_doc/regnet#transformers.TFRegNetModel">TFRegNetModel</a> (RegNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/main/en/model_doc/rembert#transformers.TFRemBertModel">TFRemBertModel</a> (RemBERT model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/main/en/model_doc/resnet#transformers.TFResNetModel">TFResNetModel</a> (ResNet model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.TFRobertaModel">TFRobertaModel</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormModel">TFRobertaPreLayerNormModel</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.TFRoFormerModel">TFRoFormerModel</a> (RoFormer model)</li> <li><strong>sam</strong> — <a href="/docs/transformers/main/en/model_doc/sam#transformers.TFSamModel">TFSamModel</a> (SAM model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/main/en/model_doc/segformer#transformers.TFSegformerModel">TFSegformerModel</a> (SegFormer model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/main/en/model_doc/speech_to_text#transformers.TFSpeech2TextModel">TFSpeech2TextModel</a> (Speech2Text model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/main/en/model_doc/swin#transformers.TFSwinModel">TFSwinModel</a> (Swin Transformer model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/main/en/model_doc/t5#transformers.TFT5Model">TFT5Model</a> (T5 model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TFTapasModel">TFTapasModel</a> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TFTransfoXLModel">TFTransfoXLModel</a> (Transformer-XL model)</li> <li><strong>vision-text-dual-encoder</strong> — <a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.TFVisionTextDualEncoderModel">TFVisionTextDualEncoderModel</a> (VisionTextDualEncoder model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.TFViTModel">TFViTModel</a> (ViT model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/main/en/model_doc/vit_mae#transformers.TFViTMAEModel">TFViTMAEModel</a> (ViTMAE model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.TFWav2Vec2Model">TFWav2Vec2Model</a> (Wav2Vec2 model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/main/en/model_doc/whisper#transformers.TFWhisperModel">TFWhisperModel</a> (Whisper model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/main/en/model_doc/xglm#transformers.TFXGLMModel">TFXGLMModel</a> (XGLM model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/main/en/model_doc/xlm#transformers.TFXLMModel">TFXLMModel</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.TFXLMRobertaModel">TFXLMRobertaModel</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.TFXLNetModel">TFXLNetModel</a> (XLNet model)</li>',ak,Js,r2,im,n2,_e,lm,sk,lu,q0=`This is a generic model class that will be instantiated as one of the base model classes of the library when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,ik,du,X0="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",lk,Pn,dm,dk,mu,D0="Instantiates one of the base model classes of the library from a configuration.",mk,cu,Q0=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,ck,Es,fk,No,mm,gk,fu,H0="Instantiate one of the base model classes of the library from a pretrained model.",hk,gu,Y0=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,pk,hu,z0='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.FlaxAlbertModel">FlaxAlbertModel</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.FlaxBartModel">FlaxBartModel</a> (BART model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/main/en/model_doc/beit#transformers.FlaxBeitModel">FlaxBeitModel</a> (BEiT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.FlaxBertModel">FlaxBertModel</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.FlaxBigBirdModel">FlaxBigBirdModel</a> (BigBird model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/main/en/model_doc/blenderbot#transformers.FlaxBlenderbotModel">FlaxBlenderbotModel</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/main/en/model_doc/blenderbot-small#transformers.FlaxBlenderbotSmallModel">FlaxBlenderbotSmallModel</a> (BlenderbotSmall model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/en/model_doc/bloom#transformers.FlaxBloomModel">FlaxBloomModel</a> (BLOOM model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.FlaxCLIPModel">FlaxCLIPModel</a> (CLIP model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.FlaxDistilBertModel">FlaxDistilBertModel</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.FlaxElectraModel">FlaxElectraModel</a> (ELECTRA model)</li> <li><strong>gemma</strong> — <a href="/docs/transformers/main/en/model_doc/gemma#transformers.FlaxGemmaModel">FlaxGemmaModel</a> (Gemma model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.FlaxGPT2Model">FlaxGPT2Model</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.FlaxGPT2Model">FlaxGPT2Model</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neo#transformers.FlaxGPTNeoModel">FlaxGPTNeoModel</a> (GPT Neo model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/main/en/model_doc/gptj#transformers.FlaxGPTJModel">FlaxGPTJModel</a> (GPT-J model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.FlaxLlamaModel">FlaxLlamaModel</a> (LLaMA model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/main/en/model_doc/longt5#transformers.FlaxLongT5Model">FlaxLongT5Model</a> (LongT5 model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/main/en/model_doc/marian#transformers.FlaxMarianModel">FlaxMarianModel</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/main/en/model_doc/mbart#transformers.FlaxMBartModel">FlaxMBartModel</a> (mBART model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/main/en/model_doc/mistral#transformers.FlaxMistralModel">FlaxMistralModel</a> (Mistral model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.FlaxMT5Model">FlaxMT5Model</a> (MT5 model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/main/en/model_doc/opt#transformers.FlaxOPTModel">FlaxOPTModel</a> (OPT model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/main/en/model_doc/pegasus#transformers.FlaxPegasusModel">FlaxPegasusModel</a> (Pegasus model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/main/en/model_doc/regnet#transformers.FlaxRegNetModel">FlaxRegNetModel</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/main/en/model_doc/resnet#transformers.FlaxResNetModel">FlaxResNetModel</a> (ResNet model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.FlaxRobertaModel">FlaxRobertaModel</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormModel">FlaxRobertaPreLayerNormModel</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.FlaxRoFormerModel">FlaxRoFormerModel</a> (RoFormer model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/main/en/model_doc/t5#transformers.FlaxT5Model">FlaxT5Model</a> (T5 model)</li> <li><strong>vision-text-dual-encoder</strong> — <a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.FlaxVisionTextDualEncoderModel">FlaxVisionTextDualEncoderModel</a> (VisionTextDualEncoder model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.FlaxViTModel">FlaxViTModel</a> (ViT model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.FlaxWav2Vec2Model">FlaxWav2Vec2Model</a> (Wav2Vec2 model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/main/en/model_doc/whisper#transformers.FlaxWhisperModel">FlaxWhisperModel</a> (Whisper model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/main/en/model_doc/xglm#transformers.FlaxXGLMModel">FlaxXGLMModel</a> (XGLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaModel">FlaxXLMRobertaModel</a> (XLM-RoBERTa model)</li>',uk,Is,t2,cm,a2,fm,O0="The following auto classes are available for instantiating a model with a pretraining head.",s2,gm,i2,be,hm,_k,pu,K0=`This is a generic model class that will be instantiated as one of the model classes of the library (with a pretraining head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,bk,uu,eJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Mk,Vn,pm,Fk,_u,oJ="Instantiates one of the model classes of the library (with a pretraining head) from a configuration.",Tk,bu,rJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Ck,Us,yk,S,um,vk,Mu,nJ="Instantiate one of the model classes of the library (with a pretraining head) from a pretrained model.",wk,Fu,tJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,xk,Tu,aJ='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertForPreTraining">AlbertForPreTraining</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertForPreTraining">BertForPreTraining</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdForPreTraining">BigBirdForPreTraining</a> (BigBird model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/en/model_doc/bloom#transformers.BloomForCausalLM">BloomForCausalLM</a> (BLOOM model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertForMaskedLM">CamembertForMaskedLM</a> (CamemBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/en/model_doc/ctrl#transformers.CTRLLMHeadModel">CTRLLMHeadModel</a> (CTRL model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecTextForMaskedLM">Data2VecTextForMaskedLM</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/en/model_doc/deberta#transformers.DebertaForMaskedLM">DebertaForMaskedLM</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.DebertaV2ForMaskedLM">DebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertForMaskedLM">DistilBertForMaskedLM</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraForPreTraining">ElectraForPreTraining</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/main/en/model_doc/ernie#transformers.ErnieForPreTraining">ErnieForPreTraining</a> (ERNIE model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.FlaubertWithLMHeadModel">FlaubertWithLMHeadModel</a> (FlauBERT model)</li> <li><strong>flava</strong> — <a href="/docs/transformers/main/en/model_doc/flava#transformers.FlavaForPreTraining">FlavaForPreTraining</a> (FLAVA model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/main/en/model_doc/fnet#transformers.FNetForPreTraining">FNetForPreTraining</a> (FNet model)</li> <li><strong>fsmt</strong> — <a href="/docs/transformers/main/en/model_doc/fsmt#transformers.FSMTForConditionalGeneration">FSMTForConditionalGeneration</a> (FairSeq Machine-Translation model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelForPreTraining">FunnelForPreTraining</a> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2LMHeadModel">GPT2LMHeadModel</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2LMHeadModel">GPT2LMHeadModel</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForCausalLM">GPTBigCodeForCausalLM</a> (GPTBigCode model)</li> <li><strong>gptsan-japanese</strong> — <a href="/docs/transformers/main/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseForConditionalGeneration">GPTSanJapaneseForConditionalGeneration</a> (GPTSAN-japanese model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/main/en/model_doc/ibert#transformers.IBertForMaskedLM">IBertForMaskedLM</a> (I-BERT model)</li> <li><strong>idefics</strong> — <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsForVisionText2Text">IdeficsForVisionText2Text</a> (IDEFICS model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.LayoutLMForMaskedLM">LayoutLMForMaskedLM</a> (LayoutLM model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaForConditionalGeneration">LlavaForConditionalGeneration</a> (LLaVa model)</li> <li><strong>llava_next</strong> — <a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextForConditionalGeneration">LlavaNextForConditionalGeneration</a> (LLaVA-NeXT model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/main/en/model_doc/longformer#transformers.LongformerForMaskedLM">LongformerForMaskedLM</a> (Longformer model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/main/en/model_doc/luke#transformers.LukeForMaskedLM">LukeForMaskedLM</a> (LUKE model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/main/en/model_doc/lxmert#transformers.LxmertForPreTraining">LxmertForPreTraining</a> (LXMERT model)</li> <li><strong>mamba</strong> — <a href="/docs/transformers/main/en/model_doc/mamba#transformers.MambaForCausalLM">MambaForCausalLM</a> (Mamba model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/main/en/model_doc/mega#transformers.MegaForMaskedLM">MegaForMaskedLM</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/main/en/model_doc/megatron-bert#transformers.MegatronBertForPreTraining">MegatronBertForPreTraining</a> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertForPreTraining">MobileBertForPreTraining</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.MPNetForMaskedLM">MPNetForMaskedLM</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptForCausalLM">MptForCausalLM</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/main/en/model_doc/mra#transformers.MraForMaskedLM">MraForMaskedLM</a> (MRA model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/main/en/model_doc/mvp#transformers.MvpForConditionalGeneration">MvpForConditionalGeneration</a> (MVP model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/main/en/model_doc/nezha#transformers.NezhaForPreTraining">NezhaForPreTraining</a> (Nezha model)</li> <li><strong>nllb-moe</strong> — <a href="/docs/transformers/main/en/model_doc/nllb-moe#transformers.NllbMoeForConditionalGeneration">NllbMoeForConditionalGeneration</a> (NLLB-MOE model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTLMHeadModel">OpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li> <li><strong>retribert</strong> — <a href="/docs/transformers/main/en/model_doc/retribert#transformers.RetriBertModel">RetriBertModel</a> (RetriBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaForMaskedLM">RobertaForMaskedLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForMaskedLM">RobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/main/en/model_doc/roc_bert#transformers.RoCBertForPreTraining">RoCBertForPreTraining</a> (RoCBert model)</li> <li><strong>rwkv</strong> — <a href="/docs/transformers/main/en/model_doc/rwkv#transformers.RwkvForCausalLM">RwkvForCausalLM</a> (RWKV model)</li> <li><strong>splinter</strong> — <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterForPreTraining">SplinterForPreTraining</a> (Splinter model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/main/en/model_doc/squeezebert#transformers.SqueezeBertForMaskedLM">SqueezeBertForMaskedLM</a> (SqueezeBERT model)</li> <li><strong>switch_transformers</strong> — <a href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersForConditionalGeneration">SwitchTransformersForConditionalGeneration</a> (SwitchTransformers model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5ForConditionalGeneration">T5ForConditionalGeneration</a> (T5 model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasForMaskedLM">TapasForMaskedLM</a> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TransfoXLLMHeadModel">TransfoXLLMHeadModel</a> (Transformer-XL model)</li> <li><strong>tvlt</strong> — <a href="/docs/transformers/main/en/model_doc/tvlt#transformers.TvltForPreTraining">TvltForPreTraining</a> (TVLT model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/main/en/model_doc/unispeech#transformers.UniSpeechForPreTraining">UniSpeechForPreTraining</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/main/en/model_doc/unispeech-sat#transformers.UniSpeechSatForPreTraining">UniSpeechSatForPreTraining</a> (UniSpeechSat model)</li> <li><strong>videomae</strong> — <a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEForPreTraining">VideoMAEForPreTraining</a> (VideoMAE model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/main/en/model_doc/vipllava#transformers.VipLlavaForConditionalGeneration">VipLlavaForConditionalGeneration</a> (VipLlava model)</li> <li><strong>visual_bert</strong> — <a href="/docs/transformers/main/en/model_doc/visual_bert#transformers.VisualBertForPreTraining">VisualBertForPreTraining</a> (VisualBERT model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/main/en/model_doc/vit_mae#transformers.ViTMAEForPreTraining">ViTMAEForPreTraining</a> (ViTMAE model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForPreTraining">Wav2Vec2ForPreTraining</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerForPreTraining">Wav2Vec2ConformerForPreTraining</a> (Wav2Vec2-Conformer model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMWithLMHeadModel">XLMWithLMHeadModel</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaForMaskedLM">XLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForMaskedLM">XLMRobertaXLForMaskedLM</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetLMHeadModel">XLNetLMHeadModel</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/main/en/model_doc/xmod#transformers.XmodForMaskedLM">XmodForMaskedLM</a> (X-MOD model)</li>',Lk,Cu,sJ=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,kk,Ns,l2,_m,d2,Me,bm,$k,yu,iJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a pretraining head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Bk,vu,lJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Ak,Jn,Mm,jk,wu,dJ="Instantiates one of the model classes of the library (with a pretraining head) from a configuration.",Zk,xu,mJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Rk,qs,Sk,qo,Fm,Gk,Lu,cJ="Instantiate one of the model classes of the library (with a pretraining head) from a pretrained model.",Wk,ku,fJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Pk,$u,gJ='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.TFAlbertForPreTraining">TFAlbertForPreTraining</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.TFBartForConditionalGeneration">TFBartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.TFBertForPreTraining">TFBertForPreTraining</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/en/model_doc/camembert#transformers.TFCamembertForMaskedLM">TFCamembertForMaskedLM</a> (CamemBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/en/model_doc/ctrl#transformers.TFCTRLLMHeadModel">TFCTRLLMHeadModel</a> (CTRL model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.TFDistilBertForMaskedLM">TFDistilBertForMaskedLM</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.TFElectraForPreTraining">TFElectraForPreTraining</a> (ELECTRA model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.TFFlaubertWithLMHeadModel">TFFlaubertWithLMHeadModel</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/main/en/model_doc/funnel#transformers.TFFunnelForPreTraining">TFFunnelForPreTraining</a> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.TFGPT2LMHeadModel">TFGPT2LMHeadModel</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.TFGPT2LMHeadModel">TFGPT2LMHeadModel</a> (OpenAI GPT-2 model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.TFLayoutLMForMaskedLM">TFLayoutLMForMaskedLM</a> (LayoutLM model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/main/en/model_doc/lxmert#transformers.TFLxmertForPreTraining">TFLxmertForPreTraining</a> (LXMERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.TFMobileBertForPreTraining">TFMobileBertForPreTraining</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.TFMPNetForMaskedLM">TFMPNetForMaskedLM</a> (MPNet model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.TFOpenAIGPTLMHeadModel">TFOpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.TFRobertaForMaskedLM">TFRobertaForMaskedLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForMaskedLM">TFRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/main/en/model_doc/t5#transformers.TFT5ForConditionalGeneration">TFT5ForConditionalGeneration</a> (T5 model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TFTapasForMaskedLM">TFTapasForMaskedLM</a> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TFTransfoXLLMHeadModel">TFTransfoXLLMHeadModel</a> (Transformer-XL model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/main/en/model_doc/vit_mae#transformers.TFViTMAEForPreTraining">TFViTMAEForPreTraining</a> (ViTMAE model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/main/en/model_doc/xlm#transformers.TFXLMWithLMHeadModel">TFXLMWithLMHeadModel</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForMaskedLM">TFXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.TFXLNetLMHeadModel">TFXLNetLMHeadModel</a> (XLNet model)</li>',Vk,Xs,m2,Tm,c2,Fe,Cm,Jk,Bu,hJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a pretraining head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Ek,Au,pJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Ik,En,ym,Uk,ju,uJ="Instantiates one of the model classes of the library (with a pretraining head) from a configuration.",Nk,Zu,_J=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,qk,Ds,Xk,Xo,vm,Dk,Ru,bJ="Instantiate one of the model classes of the library (with a pretraining head) from a pretrained model.",Qk,Su,MJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Hk,Gu,FJ='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.FlaxAlbertForPreTraining">FlaxAlbertForPreTraining</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.FlaxBartForConditionalGeneration">FlaxBartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.FlaxBertForPreTraining">FlaxBertForPreTraining</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.FlaxBigBirdForPreTraining">FlaxBigBirdForPreTraining</a> (BigBird model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.FlaxElectraForPreTraining">FlaxElectraForPreTraining</a> (ELECTRA model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/main/en/model_doc/longt5#transformers.FlaxLongT5ForConditionalGeneration">FlaxLongT5ForConditionalGeneration</a> (LongT5 model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/main/en/model_doc/mbart#transformers.FlaxMBartForConditionalGeneration">FlaxMBartForConditionalGeneration</a> (mBART model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.FlaxMT5ForConditionalGeneration">FlaxMT5ForConditionalGeneration</a> (MT5 model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.FlaxRobertaForMaskedLM">FlaxRobertaForMaskedLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForMaskedLM">FlaxRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.FlaxRoFormerForMaskedLM">FlaxRoFormerForMaskedLM</a> (RoFormer model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/main/en/model_doc/t5#transformers.FlaxT5ForConditionalGeneration">FlaxT5ForConditionalGeneration</a> (T5 model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.FlaxWav2Vec2ForPreTraining">FlaxWav2Vec2ForPreTraining</a> (Wav2Vec2 model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/main/en/model_doc/whisper#transformers.FlaxWhisperForConditionalGeneration">FlaxWhisperForConditionalGeneration</a> (Whisper model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForMaskedLM">FlaxXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>',Yk,Qs,f2,wm,g2,xm,TJ="The following auto classes are available for the following natural language processing tasks.",h2,Lm,p2,Te,km,zk,Wu,CJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a causal language modeling head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Ok,Pu,yJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Kk,In,$m,e1,Vu,vJ="Instantiates one of the model classes of the library (with a causal language modeling head) from a configuration.",o1,Ju,wJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,r1,Hs,n1,G,Bm,t1,Eu,xJ="Instantiate one of the model classes of the library (with a causal language modeling head) from a pretrained model.",a1,Iu,LJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,s1,Uu,kJ='<li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.BartForCausalLM">BartForCausalLM</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertLMHeadModel">BertLMHeadModel</a> (BERT model)</li> <li><strong>bert-generation</strong> — <a href="/docs/transformers/main/en/model_doc/bert-generation#transformers.BertGenerationDecoder">BertGenerationDecoder</a> (Bert Generation model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdForCausalLM">BigBirdForCausalLM</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/main/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForCausalLM">BigBirdPegasusForCausalLM</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptForCausalLM">BioGptForCausalLM</a> (BioGpt model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/main/en/model_doc/blenderbot#transformers.BlenderbotForCausalLM">BlenderbotForCausalLM</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/main/en/model_doc/blenderbot-small#transformers.BlenderbotSmallForCausalLM">BlenderbotSmallForCausalLM</a> (BlenderbotSmall model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/en/model_doc/bloom#transformers.BloomForCausalLM">BloomForCausalLM</a> (BLOOM model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertForCausalLM">CamembertForCausalLM</a> (CamemBERT model)</li> <li><strong>code_llama</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaForCausalLM">LlamaForCausalLM</a> (CodeLlama model)</li> <li><strong>codegen</strong> — <a href="/docs/transformers/main/en/model_doc/codegen#transformers.CodeGenForCausalLM">CodeGenForCausalLM</a> (CodeGen model)</li> <li><strong>cohere</strong> — <a href="/docs/transformers/main/en/model_doc/cohere#transformers.CohereForCausalLM">CohereForCausalLM</a> (Cohere model)</li> <li><strong>cpmant</strong> — <a href="/docs/transformers/main/en/model_doc/cpmant#transformers.CpmAntForCausalLM">CpmAntForCausalLM</a> (CPM-Ant model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/en/model_doc/ctrl#transformers.CTRLLMHeadModel">CTRLLMHeadModel</a> (CTRL model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecTextForCausalLM">Data2VecTextForCausalLM</a> (Data2VecText model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraForCausalLM">ElectraForCausalLM</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/main/en/model_doc/ernie#transformers.ErnieForCausalLM">ErnieForCausalLM</a> (ERNIE model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/main/en/model_doc/falcon#transformers.FalconForCausalLM">FalconForCausalLM</a> (Falcon model)</li> <li><strong>fuyu</strong> — <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuForCausalLM">FuyuForCausalLM</a> (Fuyu model)</li> <li><strong>gemma</strong> — <a href="/docs/transformers/main/en/model_doc/gemma#transformers.GemmaForCausalLM">GemmaForCausalLM</a> (Gemma model)</li> <li><strong>git</strong> — <a href="/docs/transformers/main/en/model_doc/git#transformers.GitForCausalLM">GitForCausalLM</a> (GIT model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2LMHeadModel">GPT2LMHeadModel</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2LMHeadModel">GPT2LMHeadModel</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForCausalLM">GPTBigCodeForCausalLM</a> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neo#transformers.GPTNeoForCausalLM">GPTNeoForCausalLM</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neox#transformers.GPTNeoXForCausalLM">GPTNeoXForCausalLM</a> (GPT NeoX model)</li> <li><strong>gpt_neox_japanese</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseForCausalLM">GPTNeoXJapaneseForCausalLM</a> (GPT NeoX Japanese model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/main/en/model_doc/gptj#transformers.GPTJForCausalLM">GPTJForCausalLM</a> (GPT-J model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaForCausalLM">LlamaForCausalLM</a> (LLaMA model)</li> <li><strong>mamba</strong> — <a href="/docs/transformers/main/en/model_doc/mamba#transformers.MambaForCausalLM">MambaForCausalLM</a> (Mamba model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/main/en/model_doc/marian#transformers.MarianForCausalLM">MarianForCausalLM</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBartForCausalLM">MBartForCausalLM</a> (mBART model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/main/en/model_doc/mega#transformers.MegaForCausalLM">MegaForCausalLM</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/main/en/model_doc/megatron-bert#transformers.MegatronBertForCausalLM">MegatronBertForCausalLM</a> (Megatron-BERT model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/main/en/model_doc/mistral#transformers.MistralForCausalLM">MistralForCausalLM</a> (Mistral model)</li> <li><strong>mixtral</strong> — <a href="/docs/transformers/main/en/model_doc/mixtral#transformers.MixtralForCausalLM">MixtralForCausalLM</a> (Mixtral model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptForCausalLM">MptForCausalLM</a> (MPT model)</li> <li><strong>musicgen</strong> — <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenForCausalLM">MusicgenForCausalLM</a> (MusicGen model)</li> <li><strong>musicgen_melody</strong> — <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForCausalLM">MusicgenMelodyForCausalLM</a> (MusicGen Melody model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/main/en/model_doc/mvp#transformers.MvpForCausalLM">MvpForCausalLM</a> (MVP model)</li> <li><strong>open-llama</strong> — <a href="/docs/transformers/main/en/model_doc/open-llama#transformers.OpenLlamaForCausalLM">OpenLlamaForCausalLM</a> (OpenLlama model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTLMHeadModel">OpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTForCausalLM">OPTForCausalLM</a> (OPT model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/main/en/model_doc/pegasus#transformers.PegasusForCausalLM">PegasusForCausalLM</a> (Pegasus model)</li> <li><strong>persimmon</strong> — <a href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonForCausalLM">PersimmonForCausalLM</a> (Persimmon model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiForCausalLM">PhiForCausalLM</a> (Phi model)</li> <li><strong>plbart</strong> — <a href="/docs/transformers/main/en/model_doc/plbart#transformers.PLBartForCausalLM">PLBartForCausalLM</a> (PLBart model)</li> <li><strong>prophetnet</strong> — <a href="/docs/transformers/main/en/model_doc/prophetnet#transformers.ProphetNetForCausalLM">ProphetNetForCausalLM</a> (ProphetNet model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/main/en/model_doc/qdqbert#transformers.QDQBertLMHeadModel">QDQBertLMHeadModel</a> (QDQBert model)</li> <li><strong>qwen2</strong> — <a href="/docs/transformers/main/en/model_doc/qwen2#transformers.Qwen2ForCausalLM">Qwen2ForCausalLM</a> (Qwen2 model)</li> <li><strong>qwen2_moe</strong> — <a href="/docs/transformers/main/en/model_doc/qwen2_moe#transformers.Qwen2MoeForCausalLM">Qwen2MoeForCausalLM</a> (Qwen2MoE model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerModelWithLMHead">ReformerModelWithLMHead</a> (Reformer model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/main/en/model_doc/rembert#transformers.RemBertForCausalLM">RemBertForCausalLM</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaForCausalLM">RobertaForCausalLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForCausalLM">RobertaPreLayerNormForCausalLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/main/en/model_doc/roc_bert#transformers.RoCBertForCausalLM">RoCBertForCausalLM</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerForCausalLM">RoFormerForCausalLM</a> (RoFormer model)</li> <li><strong>rwkv</strong> — <a href="/docs/transformers/main/en/model_doc/rwkv#transformers.RwkvForCausalLM">RwkvForCausalLM</a> (RWKV model)</li> <li><strong>speech_to_text_2</strong> — <a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2ForCausalLM">Speech2Text2ForCausalLM</a> (Speech2Text2 model)</li> <li><strong>stablelm</strong> — <a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmForCausalLM">StableLmForCausalLM</a> (StableLm model)</li> <li><strong>starcoder2</strong> — <a href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2ForCausalLM">Starcoder2ForCausalLM</a> (Starcoder2 model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TransfoXLLMHeadModel">TransfoXLLMHeadModel</a> (Transformer-XL model)</li> <li><strong>trocr</strong> — <a href="/docs/transformers/main/en/model_doc/trocr#transformers.TrOCRForCausalLM">TrOCRForCausalLM</a> (TrOCR model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/main/en/model_doc/whisper#transformers.WhisperForCausalLM">WhisperForCausalLM</a> (Whisper model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/main/en/model_doc/xglm#transformers.XGLMForCausalLM">XGLMForCausalLM</a> (XGLM model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMWithLMHeadModel">XLMWithLMHeadModel</a> (XLM model)</li> <li><strong>xlm-prophetnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetForCausalLM">XLMProphetNetForCausalLM</a> (XLM-ProphetNet model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaForCausalLM">XLMRobertaForCausalLM</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForCausalLM">XLMRobertaXLForCausalLM</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetLMHeadModel">XLNetLMHeadModel</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/main/en/model_doc/xmod#transformers.XmodForCausalLM">XmodForCausalLM</a> (X-MOD model)</li>',i1,Nu,$J=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,l1,Ys,u2,Am,_2,Ce,jm,d1,qu,BJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a causal language modeling head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,m1,Xu,AJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",c1,Un,Zm,f1,Du,jJ="Instantiates one of the model classes of the library (with a causal language modeling head) from a configuration.",g1,Qu,ZJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,h1,zs,p1,Do,Rm,u1,Hu,RJ="Instantiate one of the model classes of the library (with a causal language modeling head) from a pretrained model.",_1,Yu,SJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,b1,zu,GJ='<li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.TFBertLMHeadModel">TFBertLMHeadModel</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/en/model_doc/camembert#transformers.TFCamembertForCausalLM">TFCamembertForCausalLM</a> (CamemBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/en/model_doc/ctrl#transformers.TFCTRLLMHeadModel">TFCTRLLMHeadModel</a> (CTRL model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.TFGPT2LMHeadModel">TFGPT2LMHeadModel</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.TFGPT2LMHeadModel">TFGPT2LMHeadModel</a> (OpenAI GPT-2 model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/main/en/model_doc/gptj#transformers.TFGPTJForCausalLM">TFGPTJForCausalLM</a> (GPT-J model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.TFOpenAIGPTLMHeadModel">TFOpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/main/en/model_doc/opt#transformers.TFOPTForCausalLM">TFOPTForCausalLM</a> (OPT model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/main/en/model_doc/rembert#transformers.TFRemBertForCausalLM">TFRemBertForCausalLM</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.TFRobertaForCausalLM">TFRobertaForCausalLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForCausalLM">TFRobertaPreLayerNormForCausalLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.TFRoFormerForCausalLM">TFRoFormerForCausalLM</a> (RoFormer model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TFTransfoXLLMHeadModel">TFTransfoXLLMHeadModel</a> (Transformer-XL model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/main/en/model_doc/xglm#transformers.TFXGLMForCausalLM">TFXGLMForCausalLM</a> (XGLM model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/main/en/model_doc/xlm#transformers.TFXLMWithLMHeadModel">TFXLMWithLMHeadModel</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForCausalLM">TFXLMRobertaForCausalLM</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.TFXLNetLMHeadModel">TFXLNetLMHeadModel</a> (XLNet model)</li>',M1,Os,b2,Sm,M2,ye,Gm,F1,Ou,WJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a causal language modeling head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,T1,Ku,PJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",C1,Nn,Wm,y1,e_,VJ="Instantiates one of the model classes of the library (with a causal language modeling head) from a configuration.",v1,o_,JJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,w1,Ks,x1,Qo,Pm,L1,r_,EJ="Instantiate one of the model classes of the library (with a causal language modeling head) from a pretrained model.",k1,n_,IJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,$1,t_,UJ='<li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.FlaxBartForCausalLM">FlaxBartForCausalLM</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.FlaxBertForCausalLM">FlaxBertForCausalLM</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.FlaxBigBirdForCausalLM">FlaxBigBirdForCausalLM</a> (BigBird model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/en/model_doc/bloom#transformers.FlaxBloomForCausalLM">FlaxBloomForCausalLM</a> (BLOOM model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.FlaxElectraForCausalLM">FlaxElectraForCausalLM</a> (ELECTRA model)</li> <li><strong>gemma</strong> — <a href="/docs/transformers/main/en/model_doc/gemma#transformers.FlaxGemmaForCausalLM">FlaxGemmaForCausalLM</a> (Gemma model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.FlaxGPT2LMHeadModel">FlaxGPT2LMHeadModel</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.FlaxGPT2LMHeadModel">FlaxGPT2LMHeadModel</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neo#transformers.FlaxGPTNeoForCausalLM">FlaxGPTNeoForCausalLM</a> (GPT Neo model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/main/en/model_doc/gptj#transformers.FlaxGPTJForCausalLM">FlaxGPTJForCausalLM</a> (GPT-J model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.FlaxLlamaForCausalLM">FlaxLlamaForCausalLM</a> (LLaMA model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/main/en/model_doc/mistral#transformers.FlaxMistralForCausalLM">FlaxMistralForCausalLM</a> (Mistral model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/main/en/model_doc/opt#transformers.FlaxOPTForCausalLM">FlaxOPTForCausalLM</a> (OPT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.FlaxRobertaForCausalLM">FlaxRobertaForCausalLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForCausalLM">FlaxRobertaPreLayerNormForCausalLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/main/en/model_doc/xglm#transformers.FlaxXGLMForCausalLM">FlaxXGLMForCausalLM</a> (XGLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForCausalLM">FlaxXLMRobertaForCausalLM</a> (XLM-RoBERTa model)</li>',B1,ei,F2,Vm,T2,ve,Jm,A1,a_,NJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked language modeling head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,j1,s_,qJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Z1,qn,Em,R1,i_,XJ="Instantiates one of the model classes of the library (with a masked language modeling head) from a configuration.",S1,l_,DJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,G1,oi,W1,W,Im,P1,d_,QJ="Instantiate one of the model classes of the library (with a masked language modeling head) from a pretrained model.",V1,m_,HJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,J1,c_,YJ='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertForMaskedLM">AlbertForMaskedLM</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertForMaskedLM">BertForMaskedLM</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdForMaskedLM">BigBirdForMaskedLM</a> (BigBird model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertForMaskedLM">CamembertForMaskedLM</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/en/model_doc/convbert#transformers.ConvBertForMaskedLM">ConvBertForMaskedLM</a> (ConvBERT model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecTextForMaskedLM">Data2VecTextForMaskedLM</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/en/model_doc/deberta#transformers.DebertaForMaskedLM">DebertaForMaskedLM</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.DebertaV2ForMaskedLM">DebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertForMaskedLM">DistilBertForMaskedLM</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraForMaskedLM">ElectraForMaskedLM</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/main/en/model_doc/ernie#transformers.ErnieForMaskedLM">ErnieForMaskedLM</a> (ERNIE model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/main/en/model_doc/esm#transformers.EsmForMaskedLM">EsmForMaskedLM</a> (ESM model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.FlaubertWithLMHeadModel">FlaubertWithLMHeadModel</a> (FlauBERT model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/main/en/model_doc/fnet#transformers.FNetForMaskedLM">FNetForMaskedLM</a> (FNet model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelForMaskedLM">FunnelForMaskedLM</a> (Funnel Transformer model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/main/en/model_doc/ibert#transformers.IBertForMaskedLM">IBertForMaskedLM</a> (I-BERT model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.LayoutLMForMaskedLM">LayoutLMForMaskedLM</a> (LayoutLM model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/main/en/model_doc/longformer#transformers.LongformerForMaskedLM">LongformerForMaskedLM</a> (Longformer model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/main/en/model_doc/luke#transformers.LukeForMaskedLM">LukeForMaskedLM</a> (LUKE model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBartForConditionalGeneration">MBartForConditionalGeneration</a> (mBART model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/main/en/model_doc/mega#transformers.MegaForMaskedLM">MegaForMaskedLM</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/main/en/model_doc/megatron-bert#transformers.MegatronBertForMaskedLM">MegatronBertForMaskedLM</a> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertForMaskedLM">MobileBertForMaskedLM</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.MPNetForMaskedLM">MPNetForMaskedLM</a> (MPNet model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/main/en/model_doc/mra#transformers.MraForMaskedLM">MraForMaskedLM</a> (MRA model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/main/en/model_doc/mvp#transformers.MvpForConditionalGeneration">MvpForConditionalGeneration</a> (MVP model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/main/en/model_doc/nezha#transformers.NezhaForMaskedLM">NezhaForMaskedLM</a> (Nezha model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/main/en/model_doc/nystromformer#transformers.NystromformerForMaskedLM">NystromformerForMaskedLM</a> (Nyströmformer model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForMaskedLM">PerceiverForMaskedLM</a> (Perceiver model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/main/en/model_doc/qdqbert#transformers.QDQBertForMaskedLM">QDQBertForMaskedLM</a> (QDQBert model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerForMaskedLM">ReformerForMaskedLM</a> (Reformer model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/main/en/model_doc/rembert#transformers.RemBertForMaskedLM">RemBertForMaskedLM</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaForMaskedLM">RobertaForMaskedLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForMaskedLM">RobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/main/en/model_doc/roc_bert#transformers.RoCBertForMaskedLM">RoCBertForMaskedLM</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerForMaskedLM">RoFormerForMaskedLM</a> (RoFormer model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/main/en/model_doc/squeezebert#transformers.SqueezeBertForMaskedLM">SqueezeBertForMaskedLM</a> (SqueezeBERT model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasForMaskedLM">TapasForMaskedLM</a> (TAPAS model)</li> <li><strong>wav2vec2</strong> — <code>Wav2Vec2ForMaskedLM</code> (Wav2Vec2 model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMWithLMHeadModel">XLMWithLMHeadModel</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaForMaskedLM">XLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForMaskedLM">XLMRobertaXLForMaskedLM</a> (XLM-RoBERTa-XL model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/main/en/model_doc/xmod#transformers.XmodForMaskedLM">XmodForMaskedLM</a> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/main/en/model_doc/yoso#transformers.YosoForMaskedLM">YosoForMaskedLM</a> (YOSO model)</li>',E1,f_,zJ=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,I1,ri,C2,Um,y2,we,Nm,U1,g_,OJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked language modeling head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,N1,h_,KJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",q1,Xn,qm,X1,p_,eE="Instantiates one of the model classes of the library (with a masked language modeling head) from a configuration.",D1,u_,oE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Q1,ni,H1,Ho,Xm,Y1,__,rE="Instantiate one of the model classes of the library (with a masked language modeling head) from a pretrained model.",z1,b_,nE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,O1,M_,tE='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.TFAlbertForMaskedLM">TFAlbertForMaskedLM</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.TFBertForMaskedLM">TFBertForMaskedLM</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/en/model_doc/camembert#transformers.TFCamembertForMaskedLM">TFCamembertForMaskedLM</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/en/model_doc/convbert#transformers.TFConvBertForMaskedLM">TFConvBertForMaskedLM</a> (ConvBERT model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/en/model_doc/deberta#transformers.TFDebertaForMaskedLM">TFDebertaForMaskedLM</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.TFDebertaV2ForMaskedLM">TFDebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.TFDistilBertForMaskedLM">TFDistilBertForMaskedLM</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.TFElectraForMaskedLM">TFElectraForMaskedLM</a> (ELECTRA model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/main/en/model_doc/esm#transformers.TFEsmForMaskedLM">TFEsmForMaskedLM</a> (ESM model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.TFFlaubertWithLMHeadModel">TFFlaubertWithLMHeadModel</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/main/en/model_doc/funnel#transformers.TFFunnelForMaskedLM">TFFunnelForMaskedLM</a> (Funnel Transformer model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.TFLayoutLMForMaskedLM">TFLayoutLMForMaskedLM</a> (LayoutLM model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/main/en/model_doc/longformer#transformers.TFLongformerForMaskedLM">TFLongformerForMaskedLM</a> (Longformer model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.TFMobileBertForMaskedLM">TFMobileBertForMaskedLM</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.TFMPNetForMaskedLM">TFMPNetForMaskedLM</a> (MPNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/main/en/model_doc/rembert#transformers.TFRemBertForMaskedLM">TFRemBertForMaskedLM</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.TFRobertaForMaskedLM">TFRobertaForMaskedLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForMaskedLM">TFRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.TFRoFormerForMaskedLM">TFRoFormerForMaskedLM</a> (RoFormer model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TFTapasForMaskedLM">TFTapasForMaskedLM</a> (TAPAS model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/main/en/model_doc/xlm#transformers.TFXLMWithLMHeadModel">TFXLMWithLMHeadModel</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForMaskedLM">TFXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>',K1,ti,v2,Dm,w2,xe,Qm,e$,F_,aE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked language modeling head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,o$,T_,sE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",r$,Dn,Hm,n$,C_,iE="Instantiates one of the model classes of the library (with a masked language modeling head) from a configuration.",t$,y_,lE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,a$,ai,s$,Yo,Ym,i$,v_,dE="Instantiate one of the model classes of the library (with a masked language modeling head) from a pretrained model.",l$,w_,mE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,d$,x_,cE='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.FlaxAlbertForMaskedLM">FlaxAlbertForMaskedLM</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.FlaxBartForConditionalGeneration">FlaxBartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.FlaxBertForMaskedLM">FlaxBertForMaskedLM</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.FlaxBigBirdForMaskedLM">FlaxBigBirdForMaskedLM</a> (BigBird model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.FlaxDistilBertForMaskedLM">FlaxDistilBertForMaskedLM</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.FlaxElectraForMaskedLM">FlaxElectraForMaskedLM</a> (ELECTRA model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/main/en/model_doc/mbart#transformers.FlaxMBartForConditionalGeneration">FlaxMBartForConditionalGeneration</a> (mBART model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.FlaxRobertaForMaskedLM">FlaxRobertaForMaskedLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForMaskedLM">FlaxRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.FlaxRoFormerForMaskedLM">FlaxRoFormerForMaskedLM</a> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForMaskedLM">FlaxXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>',m$,si,x2,zm,L2,Om,Km,k2,ec,$2,oc,rc,B2,nc,A2,Le,tc,c$,L_,fE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence language modeling head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,f$,k_,gE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",g$,Qn,ac,h$,$_,hE="Instantiates one of the model classes of the library (with a sequence-to-sequence language modeling head) from a configuration.",p$,B_,pE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,u$,ii,_$,P,sc,b$,A_,uE="Instantiate one of the model classes of the library (with a sequence-to-sequence language modeling head) from a pretrained model.",M$,j_,_E=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,F$,Z_,bE='<li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/main/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForConditionalGeneration">BigBirdPegasusForConditionalGeneration</a> (BigBird-Pegasus model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/main/en/model_doc/blenderbot#transformers.BlenderbotForConditionalGeneration">BlenderbotForConditionalGeneration</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/main/en/model_doc/blenderbot-small#transformers.BlenderbotSmallForConditionalGeneration">BlenderbotSmallForConditionalGeneration</a> (BlenderbotSmall model)</li> <li><strong>encoder-decoder</strong> — <a href="/docs/transformers/main/en/model_doc/encoder-decoder#transformers.EncoderDecoderModel">EncoderDecoderModel</a> (Encoder decoder model)</li> <li><strong>fsmt</strong> — <a href="/docs/transformers/main/en/model_doc/fsmt#transformers.FSMTForConditionalGeneration">FSMTForConditionalGeneration</a> (FairSeq Machine-Translation model)</li> <li><strong>gptsan-japanese</strong> — <a href="/docs/transformers/main/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseForConditionalGeneration">GPTSanJapaneseForConditionalGeneration</a> (GPTSAN-japanese model)</li> <li><strong>led</strong> — <a href="/docs/transformers/main/en/model_doc/led#transformers.LEDForConditionalGeneration">LEDForConditionalGeneration</a> (LED model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/main/en/model_doc/longt5#transformers.LongT5ForConditionalGeneration">LongT5ForConditionalGeneration</a> (LongT5 model)</li> <li><strong>m2m_100</strong> — <a href="/docs/transformers/main/en/model_doc/m2m_100#transformers.M2M100ForConditionalGeneration">M2M100ForConditionalGeneration</a> (M2M100 model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/main/en/model_doc/marian#transformers.MarianMTModel">MarianMTModel</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBartForConditionalGeneration">MBartForConditionalGeneration</a> (mBART model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5ForConditionalGeneration">MT5ForConditionalGeneration</a> (MT5 model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/main/en/model_doc/mvp#transformers.MvpForConditionalGeneration">MvpForConditionalGeneration</a> (MVP model)</li> <li><strong>nllb-moe</strong> — <a href="/docs/transformers/main/en/model_doc/nllb-moe#transformers.NllbMoeForConditionalGeneration">NllbMoeForConditionalGeneration</a> (NLLB-MOE model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/main/en/model_doc/pegasus#transformers.PegasusForConditionalGeneration">PegasusForConditionalGeneration</a> (Pegasus model)</li> <li><strong>pegasus_x</strong> — <a href="/docs/transformers/main/en/model_doc/pegasus_x#transformers.PegasusXForConditionalGeneration">PegasusXForConditionalGeneration</a> (PEGASUS-X model)</li> <li><strong>plbart</strong> — <a href="/docs/transformers/main/en/model_doc/plbart#transformers.PLBartForConditionalGeneration">PLBartForConditionalGeneration</a> (PLBart model)</li> <li><strong>prophetnet</strong> — <a href="/docs/transformers/main/en/model_doc/prophetnet#transformers.ProphetNetForConditionalGeneration">ProphetNetForConditionalGeneration</a> (ProphetNet model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TForTextToText">SeamlessM4TForTextToText</a> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForTextToText">SeamlessM4Tv2ForTextToText</a> (SeamlessM4Tv2 model)</li> <li><strong>switch_transformers</strong> — <a href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersForConditionalGeneration">SwitchTransformersForConditionalGeneration</a> (SwitchTransformers model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5ForConditionalGeneration">T5ForConditionalGeneration</a> (T5 model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/main/en/model_doc/umt5#transformers.UMT5ForConditionalGeneration">UMT5ForConditionalGeneration</a> (UMT5 model)</li> <li><strong>xlm-prophetnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetForConditionalGeneration">XLMProphetNetForConditionalGeneration</a> (XLM-ProphetNet model)</li>',T$,R_,ME=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,C$,li,j2,ic,Z2,ke,lc,y$,S_,FE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence language modeling head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,v$,G_,TE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",w$,Hn,dc,x$,W_,CE="Instantiates one of the model classes of the library (with a sequence-to-sequence language modeling head) from a configuration.",L$,P_,yE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,k$,di,$$,zo,mc,B$,V_,vE="Instantiate one of the model classes of the library (with a sequence-to-sequence language modeling head) from a pretrained model.",A$,J_,wE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,j$,E_,xE='<li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.TFBartForConditionalGeneration">TFBartForConditionalGeneration</a> (BART model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/main/en/model_doc/blenderbot#transformers.TFBlenderbotForConditionalGeneration">TFBlenderbotForConditionalGeneration</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/main/en/model_doc/blenderbot-small#transformers.TFBlenderbotSmallForConditionalGeneration">TFBlenderbotSmallForConditionalGeneration</a> (BlenderbotSmall model)</li> <li><strong>encoder-decoder</strong> — <a href="/docs/transformers/main/en/model_doc/encoder-decoder#transformers.TFEncoderDecoderModel">TFEncoderDecoderModel</a> (Encoder decoder model)</li> <li><strong>led</strong> — <a href="/docs/transformers/main/en/model_doc/led#transformers.TFLEDForConditionalGeneration">TFLEDForConditionalGeneration</a> (LED model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/main/en/model_doc/marian#transformers.TFMarianMTModel">TFMarianMTModel</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/main/en/model_doc/mbart#transformers.TFMBartForConditionalGeneration">TFMBartForConditionalGeneration</a> (mBART model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.TFMT5ForConditionalGeneration">TFMT5ForConditionalGeneration</a> (MT5 model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/main/en/model_doc/pegasus#transformers.TFPegasusForConditionalGeneration">TFPegasusForConditionalGeneration</a> (Pegasus model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/main/en/model_doc/t5#transformers.TFT5ForConditionalGeneration">TFT5ForConditionalGeneration</a> (T5 model)</li>',Z$,mi,R2,cc,S2,$e,fc,R$,I_,LE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence language modeling head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,S$,U_,kE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",G$,Yn,gc,W$,N_,$E="Instantiates one of the model classes of the library (with a sequence-to-sequence language modeling head) from a configuration.",P$,q_,BE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,V$,ci,J$,Oo,hc,E$,X_,AE="Instantiate one of the model classes of the library (with a sequence-to-sequence language modeling head) from a pretrained model.",I$,D_,jE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,U$,Q_,ZE='<li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.FlaxBartForConditionalGeneration">FlaxBartForConditionalGeneration</a> (BART model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/main/en/model_doc/blenderbot#transformers.FlaxBlenderbotForConditionalGeneration">FlaxBlenderbotForConditionalGeneration</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/main/en/model_doc/blenderbot-small#transformers.FlaxBlenderbotSmallForConditionalGeneration">FlaxBlenderbotSmallForConditionalGeneration</a> (BlenderbotSmall model)</li> <li><strong>encoder-decoder</strong> — <a href="/docs/transformers/main/en/model_doc/encoder-decoder#transformers.FlaxEncoderDecoderModel">FlaxEncoderDecoderModel</a> (Encoder decoder model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/main/en/model_doc/longt5#transformers.FlaxLongT5ForConditionalGeneration">FlaxLongT5ForConditionalGeneration</a> (LongT5 model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/main/en/model_doc/marian#transformers.FlaxMarianMTModel">FlaxMarianMTModel</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/main/en/model_doc/mbart#transformers.FlaxMBartForConditionalGeneration">FlaxMBartForConditionalGeneration</a> (mBART model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.FlaxMT5ForConditionalGeneration">FlaxMT5ForConditionalGeneration</a> (MT5 model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/main/en/model_doc/pegasus#transformers.FlaxPegasusForConditionalGeneration">FlaxPegasusForConditionalGeneration</a> (Pegasus model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/main/en/model_doc/t5#transformers.FlaxT5ForConditionalGeneration">FlaxT5ForConditionalGeneration</a> (T5 model)</li>',N$,fi,G2,pc,W2,Be,uc,q$,H_,RE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence classification head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,X$,Y_,SE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",D$,zn,_c,Q$,z_,GE="Instantiates one of the model classes of the library (with a sequence classification head) from a configuration.",H$,O_,WE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Y$,gi,z$,V,bc,O$,K_,PE="Instantiate one of the model classes of the library (with a sequence classification head) from a pretrained model.",K$,eb,VE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,eB,ob,JE='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertForSequenceClassification">AlbertForSequenceClassification</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.BartForSequenceClassification">BartForSequenceClassification</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertForSequenceClassification">BertForSequenceClassification</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdForSequenceClassification">BigBirdForSequenceClassification</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/main/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForSequenceClassification">BigBirdPegasusForSequenceClassification</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptForSequenceClassification">BioGptForSequenceClassification</a> (BioGpt model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/en/model_doc/bloom#transformers.BloomForSequenceClassification">BloomForSequenceClassification</a> (BLOOM model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertForSequenceClassification">CamembertForSequenceClassification</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineForSequenceClassification">CanineForSequenceClassification</a> (CANINE model)</li> <li><strong>code_llama</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaForSequenceClassification">LlamaForSequenceClassification</a> (CodeLlama model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/en/model_doc/convbert#transformers.ConvBertForSequenceClassification">ConvBertForSequenceClassification</a> (ConvBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/en/model_doc/ctrl#transformers.CTRLForSequenceClassification">CTRLForSequenceClassification</a> (CTRL model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecTextForSequenceClassification">Data2VecTextForSequenceClassification</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/en/model_doc/deberta#transformers.DebertaForSequenceClassification">DebertaForSequenceClassification</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.DebertaV2ForSequenceClassification">DebertaV2ForSequenceClassification</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertForSequenceClassification">DistilBertForSequenceClassification</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraForSequenceClassification">ElectraForSequenceClassification</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/main/en/model_doc/ernie#transformers.ErnieForSequenceClassification">ErnieForSequenceClassification</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMForSequenceClassification">ErnieMForSequenceClassification</a> (ErnieM model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/main/en/model_doc/esm#transformers.EsmForSequenceClassification">EsmForSequenceClassification</a> (ESM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/main/en/model_doc/falcon#transformers.FalconForSequenceClassification">FalconForSequenceClassification</a> (Falcon model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.FlaubertForSequenceClassification">FlaubertForSequenceClassification</a> (FlauBERT model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/main/en/model_doc/fnet#transformers.FNetForSequenceClassification">FNetForSequenceClassification</a> (FNet model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelForSequenceClassification">FunnelForSequenceClassification</a> (Funnel Transformer model)</li> <li><strong>gemma</strong> — <a href="/docs/transformers/main/en/model_doc/gemma#transformers.GemmaForSequenceClassification">GemmaForSequenceClassification</a> (Gemma model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2ForSequenceClassification">GPT2ForSequenceClassification</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2ForSequenceClassification">GPT2ForSequenceClassification</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForSequenceClassification">GPTBigCodeForSequenceClassification</a> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neo#transformers.GPTNeoForSequenceClassification">GPTNeoForSequenceClassification</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neox#transformers.GPTNeoXForSequenceClassification">GPTNeoXForSequenceClassification</a> (GPT NeoX model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/main/en/model_doc/gptj#transformers.GPTJForSequenceClassification">GPTJForSequenceClassification</a> (GPT-J model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/main/en/model_doc/ibert#transformers.IBertForSequenceClassification">IBertForSequenceClassification</a> (I-BERT model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.LayoutLMForSequenceClassification">LayoutLMForSequenceClassification</a> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv2#transformers.LayoutLMv2ForSequenceClassification">LayoutLMv2ForSequenceClassification</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.LayoutLMv3ForSequenceClassification">LayoutLMv3ForSequenceClassification</a> (LayoutLMv3 model)</li> <li><strong>led</strong> — <a href="/docs/transformers/main/en/model_doc/led#transformers.LEDForSequenceClassification">LEDForSequenceClassification</a> (LED model)</li> <li><strong>lilt</strong> — <a href="/docs/transformers/main/en/model_doc/lilt#transformers.LiltForSequenceClassification">LiltForSequenceClassification</a> (LiLT model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaForSequenceClassification">LlamaForSequenceClassification</a> (LLaMA model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/main/en/model_doc/longformer#transformers.LongformerForSequenceClassification">LongformerForSequenceClassification</a> (Longformer model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/main/en/model_doc/luke#transformers.LukeForSequenceClassification">LukeForSequenceClassification</a> (LUKE model)</li> <li><strong>markuplm</strong> — <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMForSequenceClassification">MarkupLMForSequenceClassification</a> (MarkupLM model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBartForSequenceClassification">MBartForSequenceClassification</a> (mBART model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/main/en/model_doc/mega#transformers.MegaForSequenceClassification">MegaForSequenceClassification</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/main/en/model_doc/megatron-bert#transformers.MegatronBertForSequenceClassification">MegatronBertForSequenceClassification</a> (Megatron-BERT model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/main/en/model_doc/mistral#transformers.MistralForSequenceClassification">MistralForSequenceClassification</a> (Mistral model)</li> <li><strong>mixtral</strong> — <a href="/docs/transformers/main/en/model_doc/mixtral#transformers.MixtralForSequenceClassification">MixtralForSequenceClassification</a> (Mixtral model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertForSequenceClassification">MobileBertForSequenceClassification</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.MPNetForSequenceClassification">MPNetForSequenceClassification</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptForSequenceClassification">MptForSequenceClassification</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/main/en/model_doc/mra#transformers.MraForSequenceClassification">MraForSequenceClassification</a> (MRA model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5ForSequenceClassification">MT5ForSequenceClassification</a> (MT5 model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/main/en/model_doc/mvp#transformers.MvpForSequenceClassification">MvpForSequenceClassification</a> (MVP model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/main/en/model_doc/nezha#transformers.NezhaForSequenceClassification">NezhaForSequenceClassification</a> (Nezha model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/main/en/model_doc/nystromformer#transformers.NystromformerForSequenceClassification">NystromformerForSequenceClassification</a> (Nyströmformer model)</li> <li><strong>open-llama</strong> — <a href="/docs/transformers/main/en/model_doc/open-llama#transformers.OpenLlamaForSequenceClassification">OpenLlamaForSequenceClassification</a> (OpenLlama model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTForSequenceClassification">OpenAIGPTForSequenceClassification</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTForSequenceClassification">OPTForSequenceClassification</a> (OPT model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForSequenceClassification">PerceiverForSequenceClassification</a> (Perceiver model)</li> <li><strong>persimmon</strong> — <a href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonForSequenceClassification">PersimmonForSequenceClassification</a> (Persimmon model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiForSequenceClassification">PhiForSequenceClassification</a> (Phi model)</li> <li><strong>plbart</strong> — <a href="/docs/transformers/main/en/model_doc/plbart#transformers.PLBartForSequenceClassification">PLBartForSequenceClassification</a> (PLBart model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/main/en/model_doc/qdqbert#transformers.QDQBertForSequenceClassification">QDQBertForSequenceClassification</a> (QDQBert model)</li> <li><strong>qwen2</strong> — <a href="/docs/transformers/main/en/model_doc/qwen2#transformers.Qwen2ForSequenceClassification">Qwen2ForSequenceClassification</a> (Qwen2 model)</li> <li><strong>qwen2_moe</strong> — <a href="/docs/transformers/main/en/model_doc/qwen2_moe#transformers.Qwen2MoeForSequenceClassification">Qwen2MoeForSequenceClassification</a> (Qwen2MoE model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerForSequenceClassification">ReformerForSequenceClassification</a> (Reformer model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/main/en/model_doc/rembert#transformers.RemBertForSequenceClassification">RemBertForSequenceClassification</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaForSequenceClassification">RobertaForSequenceClassification</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForSequenceClassification">RobertaPreLayerNormForSequenceClassification</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/main/en/model_doc/roc_bert#transformers.RoCBertForSequenceClassification">RoCBertForSequenceClassification</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerForSequenceClassification">RoFormerForSequenceClassification</a> (RoFormer model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/main/en/model_doc/squeezebert#transformers.SqueezeBertForSequenceClassification">SqueezeBertForSequenceClassification</a> (SqueezeBERT model)</li> <li><strong>stablelm</strong> — <a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmForSequenceClassification">StableLmForSequenceClassification</a> (StableLm model)</li> <li><strong>starcoder2</strong> — <a href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2ForSequenceClassification">Starcoder2ForSequenceClassification</a> (Starcoder2 model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5ForSequenceClassification">T5ForSequenceClassification</a> (T5 model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasForSequenceClassification">TapasForSequenceClassification</a> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TransfoXLForSequenceClassification">TransfoXLForSequenceClassification</a> (Transformer-XL model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/main/en/model_doc/umt5#transformers.UMT5ForSequenceClassification">UMT5ForSequenceClassification</a> (UMT5 model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMForSequenceClassification">XLMForSequenceClassification</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaForSequenceClassification">XLMRobertaForSequenceClassification</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForSequenceClassification">XLMRobertaXLForSequenceClassification</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetForSequenceClassification">XLNetForSequenceClassification</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/main/en/model_doc/xmod#transformers.XmodForSequenceClassification">XmodForSequenceClassification</a> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/main/en/model_doc/yoso#transformers.YosoForSequenceClassification">YosoForSequenceClassification</a> (YOSO model)</li>',oB,rb,EE=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,rB,hi,P2,Mc,V2,Ae,Fc,nB,nb,IE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence classification head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,tB,tb,UE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",aB,On,Tc,sB,ab,NE="Instantiates one of the model classes of the library (with a sequence classification head) from a configuration.",iB,sb,qE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,lB,pi,dB,Ko,Cc,mB,ib,XE="Instantiate one of the model classes of the library (with a sequence classification head) from a pretrained model.",cB,lb,DE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,fB,db,QE='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.TFAlbertForSequenceClassification">TFAlbertForSequenceClassification</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.TFBartForSequenceClassification">TFBartForSequenceClassification</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.TFBertForSequenceClassification">TFBertForSequenceClassification</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/en/model_doc/camembert#transformers.TFCamembertForSequenceClassification">TFCamembertForSequenceClassification</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/en/model_doc/convbert#transformers.TFConvBertForSequenceClassification">TFConvBertForSequenceClassification</a> (ConvBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/en/model_doc/ctrl#transformers.TFCTRLForSequenceClassification">TFCTRLForSequenceClassification</a> (CTRL model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/en/model_doc/deberta#transformers.TFDebertaForSequenceClassification">TFDebertaForSequenceClassification</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.TFDebertaV2ForSequenceClassification">TFDebertaV2ForSequenceClassification</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.TFDistilBertForSequenceClassification">TFDistilBertForSequenceClassification</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.TFElectraForSequenceClassification">TFElectraForSequenceClassification</a> (ELECTRA model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/main/en/model_doc/esm#transformers.TFEsmForSequenceClassification">TFEsmForSequenceClassification</a> (ESM model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.TFFlaubertForSequenceClassification">TFFlaubertForSequenceClassification</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/main/en/model_doc/funnel#transformers.TFFunnelForSequenceClassification">TFFunnelForSequenceClassification</a> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.TFGPT2ForSequenceClassification">TFGPT2ForSequenceClassification</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.TFGPT2ForSequenceClassification">TFGPT2ForSequenceClassification</a> (OpenAI GPT-2 model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/main/en/model_doc/gptj#transformers.TFGPTJForSequenceClassification">TFGPTJForSequenceClassification</a> (GPT-J model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.TFLayoutLMForSequenceClassification">TFLayoutLMForSequenceClassification</a> (LayoutLM model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.TFLayoutLMv3ForSequenceClassification">TFLayoutLMv3ForSequenceClassification</a> (LayoutLMv3 model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/main/en/model_doc/longformer#transformers.TFLongformerForSequenceClassification">TFLongformerForSequenceClassification</a> (Longformer model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.TFMobileBertForSequenceClassification">TFMobileBertForSequenceClassification</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.TFMPNetForSequenceClassification">TFMPNetForSequenceClassification</a> (MPNet model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.TFOpenAIGPTForSequenceClassification">TFOpenAIGPTForSequenceClassification</a> (OpenAI GPT model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/main/en/model_doc/rembert#transformers.TFRemBertForSequenceClassification">TFRemBertForSequenceClassification</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.TFRobertaForSequenceClassification">TFRobertaForSequenceClassification</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForSequenceClassification">TFRobertaPreLayerNormForSequenceClassification</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.TFRoFormerForSequenceClassification">TFRoFormerForSequenceClassification</a> (RoFormer model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TFTapasForSequenceClassification">TFTapasForSequenceClassification</a> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TFTransfoXLForSequenceClassification">TFTransfoXLForSequenceClassification</a> (Transformer-XL model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/main/en/model_doc/xlm#transformers.TFXLMForSequenceClassification">TFXLMForSequenceClassification</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForSequenceClassification">TFXLMRobertaForSequenceClassification</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.TFXLNetForSequenceClassification">TFXLNetForSequenceClassification</a> (XLNet model)</li>',gB,ui,J2,yc,E2,je,vc,hB,mb,HE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence classification head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,pB,cb,YE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",uB,Kn,wc,_B,fb,zE="Instantiates one of the model classes of the library (with a sequence classification head) from a configuration.",bB,gb,OE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,MB,_i,FB,er,xc,TB,hb,KE="Instantiate one of the model classes of the library (with a sequence classification head) from a pretrained model.",CB,pb,eI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,yB,ub,oI='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.FlaxAlbertForSequenceClassification">FlaxAlbertForSequenceClassification</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.FlaxBartForSequenceClassification">FlaxBartForSequenceClassification</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.FlaxBertForSequenceClassification">FlaxBertForSequenceClassification</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.FlaxBigBirdForSequenceClassification">FlaxBigBirdForSequenceClassification</a> (BigBird model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.FlaxDistilBertForSequenceClassification">FlaxDistilBertForSequenceClassification</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.FlaxElectraForSequenceClassification">FlaxElectraForSequenceClassification</a> (ELECTRA model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/main/en/model_doc/mbart#transformers.FlaxMBartForSequenceClassification">FlaxMBartForSequenceClassification</a> (mBART model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.FlaxRobertaForSequenceClassification">FlaxRobertaForSequenceClassification</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForSequenceClassification">FlaxRobertaPreLayerNormForSequenceClassification</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.FlaxRoFormerForSequenceClassification">FlaxRoFormerForSequenceClassification</a> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForSequenceClassification">FlaxXLMRobertaForSequenceClassification</a> (XLM-RoBERTa model)</li>',vB,bi,I2,Lc,U2,Ze,kc,wB,_b,rI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a multiple choice head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,xB,bb,nI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",LB,et,$c,kB,Mb,tI="Instantiates one of the model classes of the library (with a multiple choice head) from a configuration.",$B,Fb,aI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,BB,Mi,AB,J,Bc,jB,Tb,sI="Instantiate one of the model classes of the library (with a multiple choice head) from a pretrained model.",ZB,Cb,iI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,RB,yb,lI='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertForMultipleChoice">AlbertForMultipleChoice</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertForMultipleChoice">BertForMultipleChoice</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdForMultipleChoice">BigBirdForMultipleChoice</a> (BigBird model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertForMultipleChoice">CamembertForMultipleChoice</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineForMultipleChoice">CanineForMultipleChoice</a> (CANINE model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/en/model_doc/convbert#transformers.ConvBertForMultipleChoice">ConvBertForMultipleChoice</a> (ConvBERT model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecTextForMultipleChoice">Data2VecTextForMultipleChoice</a> (Data2VecText model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.DebertaV2ForMultipleChoice">DebertaV2ForMultipleChoice</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertForMultipleChoice">DistilBertForMultipleChoice</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraForMultipleChoice">ElectraForMultipleChoice</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/main/en/model_doc/ernie#transformers.ErnieForMultipleChoice">ErnieForMultipleChoice</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMForMultipleChoice">ErnieMForMultipleChoice</a> (ErnieM model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.FlaubertForMultipleChoice">FlaubertForMultipleChoice</a> (FlauBERT model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/main/en/model_doc/fnet#transformers.FNetForMultipleChoice">FNetForMultipleChoice</a> (FNet model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelForMultipleChoice">FunnelForMultipleChoice</a> (Funnel Transformer model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/main/en/model_doc/ibert#transformers.IBertForMultipleChoice">IBertForMultipleChoice</a> (I-BERT model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/main/en/model_doc/longformer#transformers.LongformerForMultipleChoice">LongformerForMultipleChoice</a> (Longformer model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/main/en/model_doc/luke#transformers.LukeForMultipleChoice">LukeForMultipleChoice</a> (LUKE model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/main/en/model_doc/mega#transformers.MegaForMultipleChoice">MegaForMultipleChoice</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/main/en/model_doc/megatron-bert#transformers.MegatronBertForMultipleChoice">MegatronBertForMultipleChoice</a> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertForMultipleChoice">MobileBertForMultipleChoice</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.MPNetForMultipleChoice">MPNetForMultipleChoice</a> (MPNet model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/main/en/model_doc/mra#transformers.MraForMultipleChoice">MraForMultipleChoice</a> (MRA model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/main/en/model_doc/nezha#transformers.NezhaForMultipleChoice">NezhaForMultipleChoice</a> (Nezha model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/main/en/model_doc/nystromformer#transformers.NystromformerForMultipleChoice">NystromformerForMultipleChoice</a> (Nyströmformer model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/main/en/model_doc/qdqbert#transformers.QDQBertForMultipleChoice">QDQBertForMultipleChoice</a> (QDQBert model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/main/en/model_doc/rembert#transformers.RemBertForMultipleChoice">RemBertForMultipleChoice</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaForMultipleChoice">RobertaForMultipleChoice</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForMultipleChoice">RobertaPreLayerNormForMultipleChoice</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/main/en/model_doc/roc_bert#transformers.RoCBertForMultipleChoice">RoCBertForMultipleChoice</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerForMultipleChoice">RoFormerForMultipleChoice</a> (RoFormer model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/main/en/model_doc/squeezebert#transformers.SqueezeBertForMultipleChoice">SqueezeBertForMultipleChoice</a> (SqueezeBERT model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMForMultipleChoice">XLMForMultipleChoice</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaForMultipleChoice">XLMRobertaForMultipleChoice</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForMultipleChoice">XLMRobertaXLForMultipleChoice</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetForMultipleChoice">XLNetForMultipleChoice</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/main/en/model_doc/xmod#transformers.XmodForMultipleChoice">XmodForMultipleChoice</a> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/main/en/model_doc/yoso#transformers.YosoForMultipleChoice">YosoForMultipleChoice</a> (YOSO model)</li>',SB,vb,dI=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,GB,Fi,N2,Ac,q2,Re,jc,WB,wb,mI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a multiple choice head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,PB,xb,cI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",VB,ot,Zc,JB,Lb,fI="Instantiates one of the model classes of the library (with a multiple choice head) from a configuration.",EB,kb,gI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,IB,Ti,UB,or,Rc,NB,$b,hI="Instantiate one of the model classes of the library (with a multiple choice head) from a pretrained model.",qB,Bb,pI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,XB,Ab,uI='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.TFAlbertForMultipleChoice">TFAlbertForMultipleChoice</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.TFBertForMultipleChoice">TFBertForMultipleChoice</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/en/model_doc/camembert#transformers.TFCamembertForMultipleChoice">TFCamembertForMultipleChoice</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/en/model_doc/convbert#transformers.TFConvBertForMultipleChoice">TFConvBertForMultipleChoice</a> (ConvBERT model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.TFDebertaV2ForMultipleChoice">TFDebertaV2ForMultipleChoice</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.TFDistilBertForMultipleChoice">TFDistilBertForMultipleChoice</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.TFElectraForMultipleChoice">TFElectraForMultipleChoice</a> (ELECTRA model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.TFFlaubertForMultipleChoice">TFFlaubertForMultipleChoice</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/main/en/model_doc/funnel#transformers.TFFunnelForMultipleChoice">TFFunnelForMultipleChoice</a> (Funnel Transformer model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/main/en/model_doc/longformer#transformers.TFLongformerForMultipleChoice">TFLongformerForMultipleChoice</a> (Longformer model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.TFMobileBertForMultipleChoice">TFMobileBertForMultipleChoice</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.TFMPNetForMultipleChoice">TFMPNetForMultipleChoice</a> (MPNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/main/en/model_doc/rembert#transformers.TFRemBertForMultipleChoice">TFRemBertForMultipleChoice</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.TFRobertaForMultipleChoice">TFRobertaForMultipleChoice</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForMultipleChoice">TFRobertaPreLayerNormForMultipleChoice</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.TFRoFormerForMultipleChoice">TFRoFormerForMultipleChoice</a> (RoFormer model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/main/en/model_doc/xlm#transformers.TFXLMForMultipleChoice">TFXLMForMultipleChoice</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForMultipleChoice">TFXLMRobertaForMultipleChoice</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.TFXLNetForMultipleChoice">TFXLNetForMultipleChoice</a> (XLNet model)</li>',DB,Ci,X2,Sc,D2,Se,Gc,QB,jb,_I=`This is a generic model class that will be instantiated as one of the model classes of the library (with a multiple choice head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,HB,Zb,bI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",YB,rt,Wc,zB,Rb,MI="Instantiates one of the model classes of the library (with a multiple choice head) from a configuration.",OB,Sb,FI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,KB,yi,eA,rr,Pc,oA,Gb,TI="Instantiate one of the model classes of the library (with a multiple choice head) from a pretrained model.",rA,Wb,CI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,nA,Pb,yI='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.FlaxAlbertForMultipleChoice">FlaxAlbertForMultipleChoice</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.FlaxBertForMultipleChoice">FlaxBertForMultipleChoice</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.FlaxBigBirdForMultipleChoice">FlaxBigBirdForMultipleChoice</a> (BigBird model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.FlaxDistilBertForMultipleChoice">FlaxDistilBertForMultipleChoice</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.FlaxElectraForMultipleChoice">FlaxElectraForMultipleChoice</a> (ELECTRA model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.FlaxRobertaForMultipleChoice">FlaxRobertaForMultipleChoice</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForMultipleChoice">FlaxRobertaPreLayerNormForMultipleChoice</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.FlaxRoFormerForMultipleChoice">FlaxRoFormerForMultipleChoice</a> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForMultipleChoice">FlaxXLMRobertaForMultipleChoice</a> (XLM-RoBERTa model)</li>',tA,vi,Q2,Vc,H2,Ge,Jc,aA,Vb,vI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a next sentence prediction head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,sA,Jb,wI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",iA,nt,Ec,lA,Eb,xI="Instantiates one of the model classes of the library (with a next sentence prediction head) from a configuration.",dA,Ib,LI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,mA,wi,cA,E,Ic,fA,Ub,kI="Instantiate one of the model classes of the library (with a next sentence prediction head) from a pretrained model.",gA,Nb,$I=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,hA,qb,BI='<li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertForNextSentencePrediction">BertForNextSentencePrediction</a> (BERT model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/main/en/model_doc/ernie#transformers.ErnieForNextSentencePrediction">ErnieForNextSentencePrediction</a> (ERNIE model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/main/en/model_doc/fnet#transformers.FNetForNextSentencePrediction">FNetForNextSentencePrediction</a> (FNet model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/main/en/model_doc/megatron-bert#transformers.MegatronBertForNextSentencePrediction">MegatronBertForNextSentencePrediction</a> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertForNextSentencePrediction">MobileBertForNextSentencePrediction</a> (MobileBERT model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/main/en/model_doc/nezha#transformers.NezhaForNextSentencePrediction">NezhaForNextSentencePrediction</a> (Nezha model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/main/en/model_doc/qdqbert#transformers.QDQBertForNextSentencePrediction">QDQBertForNextSentencePrediction</a> (QDQBert model)</li>',pA,Xb,AI=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,uA,xi,Y2,Uc,z2,We,Nc,_A,Db,jI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a next sentence prediction head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,bA,Qb,ZI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",MA,tt,qc,FA,Hb,RI="Instantiates one of the model classes of the library (with a next sentence prediction head) from a configuration.",TA,Yb,SI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,CA,Li,yA,nr,Xc,vA,zb,GI="Instantiate one of the model classes of the library (with a next sentence prediction head) from a pretrained model.",wA,Ob,WI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,xA,Kb,PI='<li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.TFBertForNextSentencePrediction">TFBertForNextSentencePrediction</a> (BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.TFMobileBertForNextSentencePrediction">TFMobileBertForNextSentencePrediction</a> (MobileBERT model)</li>',LA,ki,O2,Dc,K2,Pe,Qc,kA,eM,VI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a next sentence prediction head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,$A,oM,JI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",BA,at,Hc,AA,rM,EI="Instantiates one of the model classes of the library (with a next sentence prediction head) from a configuration.",jA,nM,II=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,ZA,$i,RA,tr,Yc,SA,tM,UI="Instantiate one of the model classes of the library (with a next sentence prediction head) from a pretrained model.",GA,aM,NI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,WA,sM,qI='<li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.FlaxBertForNextSentencePrediction">FlaxBertForNextSentencePrediction</a> (BERT model)</li>',PA,Bi,ew,zc,ow,Ve,Oc,VA,iM,XI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a token classification head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,JA,lM,DI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",EA,st,Kc,IA,dM,QI="Instantiates one of the model classes of the library (with a token classification head) from a configuration.",UA,mM,HI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,NA,Ai,qA,I,ef,XA,cM,YI="Instantiate one of the model classes of the library (with a token classification head) from a pretrained model.",DA,fM,zI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,QA,gM,OI='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertForTokenClassification">AlbertForTokenClassification</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertForTokenClassification">BertForTokenClassification</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdForTokenClassification">BigBirdForTokenClassification</a> (BigBird model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptForTokenClassification">BioGptForTokenClassification</a> (BioGpt model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/en/model_doc/bloom#transformers.BloomForTokenClassification">BloomForTokenClassification</a> (BLOOM model)</li> <li><strong>bros</strong> — <a href="/docs/transformers/main/en/model_doc/bros#transformers.BrosForTokenClassification">BrosForTokenClassification</a> (BROS model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertForTokenClassification">CamembertForTokenClassification</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineForTokenClassification">CanineForTokenClassification</a> (CANINE model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/en/model_doc/convbert#transformers.ConvBertForTokenClassification">ConvBertForTokenClassification</a> (ConvBERT model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecTextForTokenClassification">Data2VecTextForTokenClassification</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/en/model_doc/deberta#transformers.DebertaForTokenClassification">DebertaForTokenClassification</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.DebertaV2ForTokenClassification">DebertaV2ForTokenClassification</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertForTokenClassification">DistilBertForTokenClassification</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraForTokenClassification">ElectraForTokenClassification</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/main/en/model_doc/ernie#transformers.ErnieForTokenClassification">ErnieForTokenClassification</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMForTokenClassification">ErnieMForTokenClassification</a> (ErnieM model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/main/en/model_doc/esm#transformers.EsmForTokenClassification">EsmForTokenClassification</a> (ESM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/main/en/model_doc/falcon#transformers.FalconForTokenClassification">FalconForTokenClassification</a> (Falcon model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.FlaubertForTokenClassification">FlaubertForTokenClassification</a> (FlauBERT model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/main/en/model_doc/fnet#transformers.FNetForTokenClassification">FNetForTokenClassification</a> (FNet model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelForTokenClassification">FunnelForTokenClassification</a> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2ForTokenClassification">GPT2ForTokenClassification</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2ForTokenClassification">GPT2ForTokenClassification</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForTokenClassification">GPTBigCodeForTokenClassification</a> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neo#transformers.GPTNeoForTokenClassification">GPTNeoForTokenClassification</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neox#transformers.GPTNeoXForTokenClassification">GPTNeoXForTokenClassification</a> (GPT NeoX model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/main/en/model_doc/ibert#transformers.IBertForTokenClassification">IBertForTokenClassification</a> (I-BERT model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.LayoutLMForTokenClassification">LayoutLMForTokenClassification</a> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv2#transformers.LayoutLMv2ForTokenClassification">LayoutLMv2ForTokenClassification</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.LayoutLMv3ForTokenClassification">LayoutLMv3ForTokenClassification</a> (LayoutLMv3 model)</li> <li><strong>lilt</strong> — <a href="/docs/transformers/main/en/model_doc/lilt#transformers.LiltForTokenClassification">LiltForTokenClassification</a> (LiLT model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/main/en/model_doc/longformer#transformers.LongformerForTokenClassification">LongformerForTokenClassification</a> (Longformer model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/main/en/model_doc/luke#transformers.LukeForTokenClassification">LukeForTokenClassification</a> (LUKE model)</li> <li><strong>markuplm</strong> — <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMForTokenClassification">MarkupLMForTokenClassification</a> (MarkupLM model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/main/en/model_doc/mega#transformers.MegaForTokenClassification">MegaForTokenClassification</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/main/en/model_doc/megatron-bert#transformers.MegatronBertForTokenClassification">MegatronBertForTokenClassification</a> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertForTokenClassification">MobileBertForTokenClassification</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.MPNetForTokenClassification">MPNetForTokenClassification</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptForTokenClassification">MptForTokenClassification</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/main/en/model_doc/mra#transformers.MraForTokenClassification">MraForTokenClassification</a> (MRA model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5ForTokenClassification">MT5ForTokenClassification</a> (MT5 model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/main/en/model_doc/nezha#transformers.NezhaForTokenClassification">NezhaForTokenClassification</a> (Nezha model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/main/en/model_doc/nystromformer#transformers.NystromformerForTokenClassification">NystromformerForTokenClassification</a> (Nyströmformer model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiForTokenClassification">PhiForTokenClassification</a> (Phi model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/main/en/model_doc/qdqbert#transformers.QDQBertForTokenClassification">QDQBertForTokenClassification</a> (QDQBert model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/main/en/model_doc/rembert#transformers.RemBertForTokenClassification">RemBertForTokenClassification</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaForTokenClassification">RobertaForTokenClassification</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForTokenClassification">RobertaPreLayerNormForTokenClassification</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/main/en/model_doc/roc_bert#transformers.RoCBertForTokenClassification">RoCBertForTokenClassification</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerForTokenClassification">RoFormerForTokenClassification</a> (RoFormer model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/main/en/model_doc/squeezebert#transformers.SqueezeBertForTokenClassification">SqueezeBertForTokenClassification</a> (SqueezeBERT model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5ForTokenClassification">T5ForTokenClassification</a> (T5 model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/main/en/model_doc/umt5#transformers.UMT5ForTokenClassification">UMT5ForTokenClassification</a> (UMT5 model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMForTokenClassification">XLMForTokenClassification</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaForTokenClassification">XLMRobertaForTokenClassification</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForTokenClassification">XLMRobertaXLForTokenClassification</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetForTokenClassification">XLNetForTokenClassification</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/main/en/model_doc/xmod#transformers.XmodForTokenClassification">XmodForTokenClassification</a> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/main/en/model_doc/yoso#transformers.YosoForTokenClassification">YosoForTokenClassification</a> (YOSO model)</li>',HA,hM,KI=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,YA,ji,rw,of,nw,Je,rf,zA,pM,eU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a token classification head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,OA,uM,oU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",KA,it,nf,ej,_M,rU="Instantiates one of the model classes of the library (with a token classification head) from a configuration.",oj,bM,nU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,rj,Zi,nj,ar,tf,tj,MM,tU="Instantiate one of the model classes of the library (with a token classification head) from a pretrained model.",aj,FM,aU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,sj,TM,sU='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.TFAlbertForTokenClassification">TFAlbertForTokenClassification</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.TFBertForTokenClassification">TFBertForTokenClassification</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/en/model_doc/camembert#transformers.TFCamembertForTokenClassification">TFCamembertForTokenClassification</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/en/model_doc/convbert#transformers.TFConvBertForTokenClassification">TFConvBertForTokenClassification</a> (ConvBERT model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/en/model_doc/deberta#transformers.TFDebertaForTokenClassification">TFDebertaForTokenClassification</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.TFDebertaV2ForTokenClassification">TFDebertaV2ForTokenClassification</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.TFDistilBertForTokenClassification">TFDistilBertForTokenClassification</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.TFElectraForTokenClassification">TFElectraForTokenClassification</a> (ELECTRA model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/main/en/model_doc/esm#transformers.TFEsmForTokenClassification">TFEsmForTokenClassification</a> (ESM model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.TFFlaubertForTokenClassification">TFFlaubertForTokenClassification</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/main/en/model_doc/funnel#transformers.TFFunnelForTokenClassification">TFFunnelForTokenClassification</a> (Funnel Transformer model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.TFLayoutLMForTokenClassification">TFLayoutLMForTokenClassification</a> (LayoutLM model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.TFLayoutLMv3ForTokenClassification">TFLayoutLMv3ForTokenClassification</a> (LayoutLMv3 model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/main/en/model_doc/longformer#transformers.TFLongformerForTokenClassification">TFLongformerForTokenClassification</a> (Longformer model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.TFMobileBertForTokenClassification">TFMobileBertForTokenClassification</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.TFMPNetForTokenClassification">TFMPNetForTokenClassification</a> (MPNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/main/en/model_doc/rembert#transformers.TFRemBertForTokenClassification">TFRemBertForTokenClassification</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.TFRobertaForTokenClassification">TFRobertaForTokenClassification</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForTokenClassification">TFRobertaPreLayerNormForTokenClassification</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.TFRoFormerForTokenClassification">TFRoFormerForTokenClassification</a> (RoFormer model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/main/en/model_doc/xlm#transformers.TFXLMForTokenClassification">TFXLMForTokenClassification</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForTokenClassification">TFXLMRobertaForTokenClassification</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.TFXLNetForTokenClassification">TFXLNetForTokenClassification</a> (XLNet model)</li>',ij,Ri,tw,af,aw,Ee,sf,lj,CM,iU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a token classification head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,dj,yM,lU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",mj,lt,lf,cj,vM,dU="Instantiates one of the model classes of the library (with a token classification head) from a configuration.",fj,wM,mU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,gj,Si,hj,sr,df,pj,xM,cU="Instantiate one of the model classes of the library (with a token classification head) from a pretrained model.",uj,LM,fU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,_j,kM,gU='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.FlaxAlbertForTokenClassification">FlaxAlbertForTokenClassification</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.FlaxBertForTokenClassification">FlaxBertForTokenClassification</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.FlaxBigBirdForTokenClassification">FlaxBigBirdForTokenClassification</a> (BigBird model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.FlaxDistilBertForTokenClassification">FlaxDistilBertForTokenClassification</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.FlaxElectraForTokenClassification">FlaxElectraForTokenClassification</a> (ELECTRA model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.FlaxRobertaForTokenClassification">FlaxRobertaForTokenClassification</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForTokenClassification">FlaxRobertaPreLayerNormForTokenClassification</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.FlaxRoFormerForTokenClassification">FlaxRoFormerForTokenClassification</a> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForTokenClassification">FlaxXLMRobertaForTokenClassification</a> (XLM-RoBERTa model)</li>',bj,Gi,sw,mf,iw,Ie,cf,Mj,$M,hU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a question answering head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Fj,BM,pU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Tj,dt,ff,Cj,AM,uU="Instantiates one of the model classes of the library (with a question answering head) from a configuration.",yj,jM,_U=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,vj,Wi,wj,U,gf,xj,ZM,bU="Instantiate one of the model classes of the library (with a question answering head) from a pretrained model.",Lj,RM,MU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,kj,SM,FU='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertForQuestionAnswering">AlbertForQuestionAnswering</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.BartForQuestionAnswering">BartForQuestionAnswering</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertForQuestionAnswering">BertForQuestionAnswering</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdForQuestionAnswering">BigBirdForQuestionAnswering</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/main/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForQuestionAnswering">BigBirdPegasusForQuestionAnswering</a> (BigBird-Pegasus model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/en/model_doc/bloom#transformers.BloomForQuestionAnswering">BloomForQuestionAnswering</a> (BLOOM model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertForQuestionAnswering">CamembertForQuestionAnswering</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineForQuestionAnswering">CanineForQuestionAnswering</a> (CANINE model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/en/model_doc/convbert#transformers.ConvBertForQuestionAnswering">ConvBertForQuestionAnswering</a> (ConvBERT model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecTextForQuestionAnswering">Data2VecTextForQuestionAnswering</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/en/model_doc/deberta#transformers.DebertaForQuestionAnswering">DebertaForQuestionAnswering</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.DebertaV2ForQuestionAnswering">DebertaV2ForQuestionAnswering</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertForQuestionAnswering">DistilBertForQuestionAnswering</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraForQuestionAnswering">ElectraForQuestionAnswering</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/main/en/model_doc/ernie#transformers.ErnieForQuestionAnswering">ErnieForQuestionAnswering</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMForQuestionAnswering">ErnieMForQuestionAnswering</a> (ErnieM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/main/en/model_doc/falcon#transformers.FalconForQuestionAnswering">FalconForQuestionAnswering</a> (Falcon model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.FlaubertForQuestionAnsweringSimple">FlaubertForQuestionAnsweringSimple</a> (FlauBERT model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/main/en/model_doc/fnet#transformers.FNetForQuestionAnswering">FNetForQuestionAnswering</a> (FNet model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelForQuestionAnswering">FunnelForQuestionAnswering</a> (Funnel Transformer model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2ForQuestionAnswering">GPT2ForQuestionAnswering</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neo#transformers.GPTNeoForQuestionAnswering">GPTNeoForQuestionAnswering</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/main/en/model_doc/gpt_neox#transformers.GPTNeoXForQuestionAnswering">GPTNeoXForQuestionAnswering</a> (GPT NeoX model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/main/en/model_doc/gptj#transformers.GPTJForQuestionAnswering">GPTJForQuestionAnswering</a> (GPT-J model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/main/en/model_doc/ibert#transformers.IBertForQuestionAnswering">IBertForQuestionAnswering</a> (I-BERT model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv2#transformers.LayoutLMv2ForQuestionAnswering">LayoutLMv2ForQuestionAnswering</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.LayoutLMv3ForQuestionAnswering">LayoutLMv3ForQuestionAnswering</a> (LayoutLMv3 model)</li> <li><strong>led</strong> — <a href="/docs/transformers/main/en/model_doc/led#transformers.LEDForQuestionAnswering">LEDForQuestionAnswering</a> (LED model)</li> <li><strong>lilt</strong> — <a href="/docs/transformers/main/en/model_doc/lilt#transformers.LiltForQuestionAnswering">LiltForQuestionAnswering</a> (LiLT model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaForQuestionAnswering">LlamaForQuestionAnswering</a> (LLaMA model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/main/en/model_doc/longformer#transformers.LongformerForQuestionAnswering">LongformerForQuestionAnswering</a> (Longformer model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/main/en/model_doc/luke#transformers.LukeForQuestionAnswering">LukeForQuestionAnswering</a> (LUKE model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/main/en/model_doc/lxmert#transformers.LxmertForQuestionAnswering">LxmertForQuestionAnswering</a> (LXMERT model)</li> <li><strong>markuplm</strong> — <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMForQuestionAnswering">MarkupLMForQuestionAnswering</a> (MarkupLM model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBartForQuestionAnswering">MBartForQuestionAnswering</a> (mBART model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/main/en/model_doc/mega#transformers.MegaForQuestionAnswering">MegaForQuestionAnswering</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/main/en/model_doc/megatron-bert#transformers.MegatronBertForQuestionAnswering">MegatronBertForQuestionAnswering</a> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertForQuestionAnswering">MobileBertForQuestionAnswering</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.MPNetForQuestionAnswering">MPNetForQuestionAnswering</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptForQuestionAnswering">MptForQuestionAnswering</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/main/en/model_doc/mra#transformers.MraForQuestionAnswering">MraForQuestionAnswering</a> (MRA model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5ForQuestionAnswering">MT5ForQuestionAnswering</a> (MT5 model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/main/en/model_doc/mvp#transformers.MvpForQuestionAnswering">MvpForQuestionAnswering</a> (MVP model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/main/en/model_doc/nezha#transformers.NezhaForQuestionAnswering">NezhaForQuestionAnswering</a> (Nezha model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/main/en/model_doc/nystromformer#transformers.NystromformerForQuestionAnswering">NystromformerForQuestionAnswering</a> (Nyströmformer model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTForQuestionAnswering">OPTForQuestionAnswering</a> (OPT model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/main/en/model_doc/qdqbert#transformers.QDQBertForQuestionAnswering">QDQBertForQuestionAnswering</a> (QDQBert model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerForQuestionAnswering">ReformerForQuestionAnswering</a> (Reformer model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/main/en/model_doc/rembert#transformers.RemBertForQuestionAnswering">RemBertForQuestionAnswering</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaForQuestionAnswering">RobertaForQuestionAnswering</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForQuestionAnswering">RobertaPreLayerNormForQuestionAnswering</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/main/en/model_doc/roc_bert#transformers.RoCBertForQuestionAnswering">RoCBertForQuestionAnswering</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerForQuestionAnswering">RoFormerForQuestionAnswering</a> (RoFormer model)</li> <li><strong>splinter</strong> — <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterForQuestionAnswering">SplinterForQuestionAnswering</a> (Splinter model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/main/en/model_doc/squeezebert#transformers.SqueezeBertForQuestionAnswering">SqueezeBertForQuestionAnswering</a> (SqueezeBERT model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5ForQuestionAnswering">T5ForQuestionAnswering</a> (T5 model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/main/en/model_doc/umt5#transformers.UMT5ForQuestionAnswering">UMT5ForQuestionAnswering</a> (UMT5 model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMForQuestionAnsweringSimple">XLMForQuestionAnsweringSimple</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaForQuestionAnswering">XLMRobertaForQuestionAnswering</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForQuestionAnswering">XLMRobertaXLForQuestionAnswering</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetForQuestionAnsweringSimple">XLNetForQuestionAnsweringSimple</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/main/en/model_doc/xmod#transformers.XmodForQuestionAnswering">XmodForQuestionAnswering</a> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/main/en/model_doc/yoso#transformers.YosoForQuestionAnswering">YosoForQuestionAnswering</a> (YOSO model)</li>',$j,GM,TU=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,Bj,Pi,lw,hf,dw,Ue,pf,Aj,WM,CU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a question answering head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,jj,PM,yU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Zj,mt,uf,Rj,VM,vU="Instantiates one of the model classes of the library (with a question answering head) from a configuration.",Sj,JM,wU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Gj,Vi,Wj,ir,_f,Pj,EM,xU="Instantiate one of the model classes of the library (with a question answering head) from a pretrained model.",Vj,IM,LU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Jj,UM,kU='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.TFAlbertForQuestionAnswering">TFAlbertForQuestionAnswering</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.TFBertForQuestionAnswering">TFBertForQuestionAnswering</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/en/model_doc/camembert#transformers.TFCamembertForQuestionAnswering">TFCamembertForQuestionAnswering</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/en/model_doc/convbert#transformers.TFConvBertForQuestionAnswering">TFConvBertForQuestionAnswering</a> (ConvBERT model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/en/model_doc/deberta#transformers.TFDebertaForQuestionAnswering">TFDebertaForQuestionAnswering</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.TFDebertaV2ForQuestionAnswering">TFDebertaV2ForQuestionAnswering</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.TFDistilBertForQuestionAnswering">TFDistilBertForQuestionAnswering</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.TFElectraForQuestionAnswering">TFElectraForQuestionAnswering</a> (ELECTRA model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.TFFlaubertForQuestionAnsweringSimple">TFFlaubertForQuestionAnsweringSimple</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/main/en/model_doc/funnel#transformers.TFFunnelForQuestionAnswering">TFFunnelForQuestionAnswering</a> (Funnel Transformer model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/main/en/model_doc/gptj#transformers.TFGPTJForQuestionAnswering">TFGPTJForQuestionAnswering</a> (GPT-J model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.TFLayoutLMv3ForQuestionAnswering">TFLayoutLMv3ForQuestionAnswering</a> (LayoutLMv3 model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/main/en/model_doc/longformer#transformers.TFLongformerForQuestionAnswering">TFLongformerForQuestionAnswering</a> (Longformer model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.TFMobileBertForQuestionAnswering">TFMobileBertForQuestionAnswering</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.TFMPNetForQuestionAnswering">TFMPNetForQuestionAnswering</a> (MPNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/main/en/model_doc/rembert#transformers.TFRemBertForQuestionAnswering">TFRemBertForQuestionAnswering</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.TFRobertaForQuestionAnswering">TFRobertaForQuestionAnswering</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForQuestionAnswering">TFRobertaPreLayerNormForQuestionAnswering</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.TFRoFormerForQuestionAnswering">TFRoFormerForQuestionAnswering</a> (RoFormer model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/main/en/model_doc/xlm#transformers.TFXLMForQuestionAnsweringSimple">TFXLMForQuestionAnsweringSimple</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForQuestionAnswering">TFXLMRobertaForQuestionAnswering</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.TFXLNetForQuestionAnsweringSimple">TFXLNetForQuestionAnsweringSimple</a> (XLNet model)</li>',Ej,Ji,mw,bf,cw,Ne,Mf,Ij,NM,$U=`This is a generic model class that will be instantiated as one of the model classes of the library (with a question answering head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Uj,qM,BU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Nj,ct,Ff,qj,XM,AU="Instantiates one of the model classes of the library (with a question answering head) from a configuration.",Xj,DM,jU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Dj,Ei,Qj,lr,Tf,Hj,QM,ZU="Instantiate one of the model classes of the library (with a question answering head) from a pretrained model.",Yj,HM,RU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,zj,YM,SU='<li><strong>albert</strong> — <a href="/docs/transformers/main/en/model_doc/albert#transformers.FlaxAlbertForQuestionAnswering">FlaxAlbertForQuestionAnswering</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/en/model_doc/bart#transformers.FlaxBartForQuestionAnswering">FlaxBartForQuestionAnswering</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/en/model_doc/bert#transformers.FlaxBertForQuestionAnswering">FlaxBertForQuestionAnswering</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.FlaxBigBirdForQuestionAnswering">FlaxBigBirdForQuestionAnswering</a> (BigBird model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.FlaxDistilBertForQuestionAnswering">FlaxDistilBertForQuestionAnswering</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/main/en/model_doc/electra#transformers.FlaxElectraForQuestionAnswering">FlaxElectraForQuestionAnswering</a> (ELECTRA model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/main/en/model_doc/mbart#transformers.FlaxMBartForQuestionAnswering">FlaxMBartForQuestionAnswering</a> (mBART model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/main/en/model_doc/roberta#transformers.FlaxRobertaForQuestionAnswering">FlaxRobertaForQuestionAnswering</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForQuestionAnswering">FlaxRobertaPreLayerNormForQuestionAnswering</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/main/en/model_doc/roformer#transformers.FlaxRoFormerForQuestionAnswering">FlaxRoFormerForQuestionAnswering</a> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForQuestionAnswering">FlaxXLMRobertaForQuestionAnswering</a> (XLM-RoBERTa model)</li>',Oj,Ii,fw,Cf,gw,yf,vf,hw,wf,pw,xf,Lf,uw,kf,_w,$f,GU="The following auto classes are available for the following computer vision tasks.",bw,Bf,Mw,qe,Af,Kj,zM,WU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a depth estimation head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,eZ,OM,PU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",oZ,ft,jf,rZ,KM,VU="Instantiates one of the model classes of the library (with a depth estimation head) from a configuration.",nZ,eF,JU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,tZ,Ui,aZ,N,Zf,sZ,oF,EU="Instantiate one of the model classes of the library (with a depth estimation head) from a pretrained model.",iZ,rF,IU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,lZ,nF,UU='<li><strong>depth_anything</strong> — <a href="/docs/transformers/main/en/model_doc/depth_anything#transformers.DepthAnythingForDepthEstimation">DepthAnythingForDepthEstimation</a> (Depth Anything model)</li> <li><strong>dpt</strong> — <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTForDepthEstimation">DPTForDepthEstimation</a> (DPT model)</li> <li><strong>glpn</strong> — <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNForDepthEstimation">GLPNForDepthEstimation</a> (GLPN model)</li>',dZ,tF,NU=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,mZ,Ni,Fw,Rf,Tw,Xe,Sf,cZ,aF,qU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a image classification head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,fZ,sF,XU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",gZ,gt,Gf,hZ,iF,DU="Instantiates one of the model classes of the library (with a image classification head) from a configuration.",pZ,lF,QU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,uZ,qi,_Z,q,Wf,bZ,dF,HU="Instantiate one of the model classes of the library (with a image classification head) from a pretrained model.",MZ,mF,YU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,FZ,cF,zU='<li><strong>beit</strong> — <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForImageClassification">BeitForImageClassification</a> (BEiT model)</li> <li><strong>bit</strong> — <a href="/docs/transformers/main/en/model_doc/bit#transformers.BitForImageClassification">BitForImageClassification</a> (BiT model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPForImageClassification">CLIPForImageClassification</a> (CLIP model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/main/en/model_doc/convnext#transformers.ConvNextForImageClassification">ConvNextForImageClassification</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/main/en/model_doc/convnextv2#transformers.ConvNextV2ForImageClassification">ConvNextV2ForImageClassification</a> (ConvNeXTV2 model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/main/en/model_doc/cvt#transformers.CvtForImageClassification">CvtForImageClassification</a> (CvT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecVisionForImageClassification">Data2VecVisionForImageClassification</a> (Data2VecVision model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTForImageClassification">DeiTForImageClassification</a> or <a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTForImageClassificationWithTeacher">DeiTForImageClassificationWithTeacher</a> (DeiT model)</li> <li><strong>dinat</strong> — <a href="/docs/transformers/main/en/model_doc/dinat#transformers.DinatForImageClassification">DinatForImageClassification</a> (DiNAT model)</li> <li><strong>dinov2</strong> — <a href="/docs/transformers/main/en/model_doc/dinov2#transformers.Dinov2ForImageClassification">Dinov2ForImageClassification</a> (DINOv2 model)</li> <li><strong>efficientformer</strong> — <a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerForImageClassification">EfficientFormerForImageClassification</a> or <a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerForImageClassificationWithTeacher">EfficientFormerForImageClassificationWithTeacher</a> (EfficientFormer model)</li> <li><strong>efficientnet</strong> — <a href="/docs/transformers/main/en/model_doc/efficientnet#transformers.EfficientNetForImageClassification">EfficientNetForImageClassification</a> (EfficientNet model)</li> <li><strong>focalnet</strong> — <a href="/docs/transformers/main/en/model_doc/focalnet#transformers.FocalNetForImageClassification">FocalNetForImageClassification</a> (FocalNet model)</li> <li><strong>imagegpt</strong> — <a href="/docs/transformers/main/en/model_doc/imagegpt#transformers.ImageGPTForImageClassification">ImageGPTForImageClassification</a> (ImageGPT model)</li> <li><strong>levit</strong> — <a href="/docs/transformers/main/en/model_doc/levit#transformers.LevitForImageClassification">LevitForImageClassification</a> or <a href="/docs/transformers/main/en/model_doc/levit#transformers.LevitForImageClassificationWithTeacher">LevitForImageClassificationWithTeacher</a> (LeViT model)</li> <li><strong>mobilenet_v1</strong> — <a href="/docs/transformers/main/en/model_doc/mobilenet_v1#transformers.MobileNetV1ForImageClassification">MobileNetV1ForImageClassification</a> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <a href="/docs/transformers/main/en/model_doc/mobilenet_v2#transformers.MobileNetV2ForImageClassification">MobileNetV2ForImageClassification</a> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/main/en/model_doc/mobilevit#transformers.MobileViTForImageClassification">MobileViTForImageClassification</a> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <a href="/docs/transformers/main/en/model_doc/mobilevitv2#transformers.MobileViTV2ForImageClassification">MobileViTV2ForImageClassification</a> (MobileViTV2 model)</li> <li><strong>nat</strong> — <a href="/docs/transformers/main/en/model_doc/nat#transformers.NatForImageClassification">NatForImageClassification</a> (NAT model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a> or <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationFourier">PerceiverForImageClassificationFourier</a> or <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationConvProcessing">PerceiverForImageClassificationConvProcessing</a> (Perceiver model)</li> <li><strong>poolformer</strong> — <a href="/docs/transformers/main/en/model_doc/poolformer#transformers.PoolFormerForImageClassification">PoolFormerForImageClassification</a> (PoolFormer model)</li> <li><strong>pvt</strong> — <a href="/docs/transformers/main/en/model_doc/pvt#transformers.PvtForImageClassification">PvtForImageClassification</a> (PVT model)</li> <li><strong>pvt_v2</strong> — <a href="/docs/transformers/main/en/model_doc/pvt_v2#transformers.PvtV2ForImageClassification">PvtV2ForImageClassification</a> (PVTv2 model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetForImageClassification">RegNetForImageClassification</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/main/en/model_doc/resnet#transformers.ResNetForImageClassification">ResNetForImageClassification</a> (ResNet model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/main/en/model_doc/segformer#transformers.SegformerForImageClassification">SegformerForImageClassification</a> (SegFormer model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipForImageClassification">SiglipForImageClassification</a> (SigLIP model)</li> <li><strong>swiftformer</strong> — <a href="/docs/transformers/main/en/model_doc/swiftformer#transformers.SwiftFormerForImageClassification">SwiftFormerForImageClassification</a> (SwiftFormer model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/main/en/model_doc/swin#transformers.SwinForImageClassification">SwinForImageClassification</a> (Swin Transformer model)</li> <li><strong>swinv2</strong> — <a href="/docs/transformers/main/en/model_doc/swinv2#transformers.Swinv2ForImageClassification">Swinv2ForImageClassification</a> (Swin Transformer V2 model)</li> <li><strong>van</strong> — <a href="/docs/transformers/main/en/model_doc/van#transformers.VanForImageClassification">VanForImageClassification</a> (VAN model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTForImageClassification">ViTForImageClassification</a> (ViT model)</li> <li><strong>vit_hybrid</strong> — <a href="/docs/transformers/main/en/model_doc/vit_hybrid#transformers.ViTHybridForImageClassification">ViTHybridForImageClassification</a> (ViT Hybrid model)</li> <li><strong>vit_msn</strong> — <a href="/docs/transformers/main/en/model_doc/vit_msn#transformers.ViTMSNForImageClassification">ViTMSNForImageClassification</a> (ViTMSN model)</li>',TZ,fF,OU=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,CZ,Xi,Cw,Pf,yw,De,Vf,yZ,gF,KU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a image classification head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,vZ,hF,e9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",wZ,ht,Jf,xZ,pF,o9="Instantiates one of the model classes of the library (with a image classification head) from a configuration.",LZ,uF,r9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,kZ,Di,$Z,dr,Ef,BZ,_F,n9="Instantiate one of the model classes of the library (with a image classification head) from a pretrained model.",AZ,bF,t9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,jZ,MF,a9='<li><strong>convnext</strong> — <a href="/docs/transformers/main/en/model_doc/convnext#transformers.TFConvNextForImageClassification">TFConvNextForImageClassification</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/main/en/model_doc/convnextv2#transformers.TFConvNextV2ForImageClassification">TFConvNextV2ForImageClassification</a> (ConvNeXTV2 model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/main/en/model_doc/cvt#transformers.TFCvtForImageClassification">TFCvtForImageClassification</a> (CvT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.TFData2VecVisionForImageClassification">TFData2VecVisionForImageClassification</a> (Data2VecVision model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/main/en/model_doc/deit#transformers.TFDeiTForImageClassification">TFDeiTForImageClassification</a> or <a href="/docs/transformers/main/en/model_doc/deit#transformers.TFDeiTForImageClassificationWithTeacher">TFDeiTForImageClassificationWithTeacher</a> (DeiT model)</li> <li><strong>efficientformer</strong> — <a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.TFEfficientFormerForImageClassification">TFEfficientFormerForImageClassification</a> or <a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.TFEfficientFormerForImageClassificationWithTeacher">TFEfficientFormerForImageClassificationWithTeacher</a> (EfficientFormer model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/main/en/model_doc/mobilevit#transformers.TFMobileViTForImageClassification">TFMobileViTForImageClassification</a> (MobileViT model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/main/en/model_doc/regnet#transformers.TFRegNetForImageClassification">TFRegNetForImageClassification</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/main/en/model_doc/resnet#transformers.TFResNetForImageClassification">TFResNetForImageClassification</a> (ResNet model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/main/en/model_doc/segformer#transformers.TFSegformerForImageClassification">TFSegformerForImageClassification</a> (SegFormer model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/main/en/model_doc/swin#transformers.TFSwinForImageClassification">TFSwinForImageClassification</a> (Swin Transformer model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.TFViTForImageClassification">TFViTForImageClassification</a> (ViT model)</li>',ZZ,Qi,vw,If,ww,Qe,Uf,RZ,FF,s9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a image classification head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,SZ,TF,i9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",GZ,pt,Nf,WZ,CF,l9="Instantiates one of the model classes of the library (with a image classification head) from a configuration.",PZ,yF,d9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,VZ,Hi,JZ,mr,qf,EZ,vF,m9="Instantiate one of the model classes of the library (with a image classification head) from a pretrained model.",IZ,wF,c9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,UZ,xF,f9='<li><strong>beit</strong> — <a href="/docs/transformers/main/en/model_doc/beit#transformers.FlaxBeitForImageClassification">FlaxBeitForImageClassification</a> (BEiT model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/main/en/model_doc/regnet#transformers.FlaxRegNetForImageClassification">FlaxRegNetForImageClassification</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/main/en/model_doc/resnet#transformers.FlaxResNetForImageClassification">FlaxResNetForImageClassification</a> (ResNet model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.FlaxViTForImageClassification">FlaxViTForImageClassification</a> (ViT model)</li>',NZ,Yi,xw,Xf,Lw,He,Df,qZ,LF,g9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a video classification head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,XZ,kF,h9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",DZ,ut,Qf,QZ,$F,p9="Instantiates one of the model classes of the library (with a video classification head) from a configuration.",HZ,BF,u9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,YZ,zi,zZ,X,Hf,OZ,AF,_9="Instantiate one of the model classes of the library (with a video classification head) from a pretrained model.",KZ,jF,b9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,eR,ZF,M9='<li><strong>timesformer</strong> — <a href="/docs/transformers/main/en/model_doc/timesformer#transformers.TimesformerForVideoClassification">TimesformerForVideoClassification</a> (TimeSformer model)</li> <li><strong>videomae</strong> — <a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEForVideoClassification">VideoMAEForVideoClassification</a> (VideoMAE model)</li> <li><strong>vivit</strong> — <a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitForVideoClassification">VivitForVideoClassification</a> (ViViT model)</li>',oR,RF,F9=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,rR,Oi,kw,Yf,$w,zf,Of,Bw,Kf,Aw,Ye,eg,nR,SF,T9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked image modeling head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,tR,GF,C9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",aR,_t,og,sR,WF,y9="Instantiates one of the model classes of the library (with a masked image modeling head) from a configuration.",iR,PF,v9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,lR,Ki,dR,D,rg,mR,VF,w9="Instantiate one of the model classes of the library (with a masked image modeling head) from a pretrained model.",cR,JF,x9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,fR,EF,L9='<li><strong>deit</strong> — <a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTForMaskedImageModeling">DeiTForMaskedImageModeling</a> (DeiT model)</li> <li><strong>focalnet</strong> — <a href="/docs/transformers/main/en/model_doc/focalnet#transformers.FocalNetForMaskedImageModeling">FocalNetForMaskedImageModeling</a> (FocalNet model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/main/en/model_doc/swin#transformers.SwinForMaskedImageModeling">SwinForMaskedImageModeling</a> (Swin Transformer model)</li> <li><strong>swinv2</strong> — <a href="/docs/transformers/main/en/model_doc/swinv2#transformers.Swinv2ForMaskedImageModeling">Swinv2ForMaskedImageModeling</a> (Swin Transformer V2 model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTForMaskedImageModeling">ViTForMaskedImageModeling</a> (ViT model)</li>',gR,IF,k9=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,hR,el,jw,ng,Zw,ze,tg,pR,UF,$9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked image modeling head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,uR,NF,B9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",_R,bt,ag,bR,qF,A9="Instantiates one of the model classes of the library (with a masked image modeling head) from a configuration.",MR,XF,j9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,FR,ol,TR,cr,sg,CR,DF,Z9="Instantiate one of the model classes of the library (with a masked image modeling head) from a pretrained model.",yR,QF,R9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,vR,HF,S9='<li><strong>deit</strong> — <a href="/docs/transformers/main/en/model_doc/deit#transformers.TFDeiTForMaskedImageModeling">TFDeiTForMaskedImageModeling</a> (DeiT model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/main/en/model_doc/swin#transformers.TFSwinForMaskedImageModeling">TFSwinForMaskedImageModeling</a> (Swin Transformer model)</li>',wR,rl,Rw,ig,Sw,Oe,lg,xR,YF,G9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a object detection head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,LR,zF,W9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",kR,Mt,dg,$R,OF,P9="Instantiates one of the model classes of the library (with a object detection head) from a configuration.",BR,KF,V9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,AR,nl,jR,Q,mg,ZR,eT,J9="Instantiate one of the model classes of the library (with a object detection head) from a pretrained model.",RR,oT,E9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,SR,rT,I9='<li><strong>conditional_detr</strong> — <a href="/docs/transformers/main/en/model_doc/conditional_detr#transformers.ConditionalDetrForObjectDetection">ConditionalDetrForObjectDetection</a> (Conditional DETR model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/main/en/model_doc/deformable_detr#transformers.DeformableDetrForObjectDetection">DeformableDetrForObjectDetection</a> (Deformable DETR model)</li> <li><strong>deta</strong> — <a href="/docs/transformers/main/en/model_doc/deta#transformers.DetaForObjectDetection">DetaForObjectDetection</a> (DETA model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> (DETR model)</li> <li><strong>table-transformer</strong> — <a href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerForObjectDetection">TableTransformerForObjectDetection</a> (Table Transformer model)</li> <li><strong>yolos</strong> — <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> (YOLOS model)</li>',GR,nT,U9=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,WR,tl,Gw,cg,Ww,Ke,fg,PR,tT,N9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a image segmentation head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,VR,aT,q9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",JR,Ft,gg,ER,sT,X9="Instantiates one of the model classes of the library (with a image segmentation head) from a configuration.",IR,iT,D9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,UR,al,NR,H,hg,qR,lT,Q9="Instantiate one of the model classes of the library (with a image segmentation head) from a pretrained model.",XR,dT,H9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,DR,mT,Y9='<li><strong>detr</strong> — <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> (DETR model)</li>',QR,cT,z9=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,HR,sl,Pw,pg,Vw,ug,_g,Jw,bg,Ew,eo,Mg,YR,fT,O9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a semantic segmentation head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,zR,gT,K9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",OR,Tt,Fg,KR,hT,eN="Instantiates one of the model classes of the library (with a semantic segmentation head) from a configuration.",eS,pT,oN=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,oS,il,rS,Y,Tg,nS,uT,rN="Instantiate one of the model classes of the library (with a semantic segmentation head) from a pretrained model.",tS,_T,nN=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,aS,bT,tN='<li><strong>beit</strong> — <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a> (BEiT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecVisionForSemanticSegmentation">Data2VecVisionForSemanticSegmentation</a> (Data2VecVision model)</li> <li><strong>dpt</strong> — <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a> (DPT model)</li> <li><strong>mobilenet_v2</strong> — <a href="/docs/transformers/main/en/model_doc/mobilenet_v2#transformers.MobileNetV2ForSemanticSegmentation">MobileNetV2ForSemanticSegmentation</a> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/main/en/model_doc/mobilevit#transformers.MobileViTForSemanticSegmentation">MobileViTForSemanticSegmentation</a> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <a href="/docs/transformers/main/en/model_doc/mobilevitv2#transformers.MobileViTV2ForSemanticSegmentation">MobileViTV2ForSemanticSegmentation</a> (MobileViTV2 model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/main/en/model_doc/segformer#transformers.SegformerForSemanticSegmentation">SegformerForSemanticSegmentation</a> (SegFormer model)</li> <li><strong>upernet</strong> — <a href="/docs/transformers/main/en/model_doc/upernet#transformers.UperNetForSemanticSegmentation">UperNetForSemanticSegmentation</a> (UPerNet model)</li>',sS,MT,aN=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,iS,ll,Iw,Cg,Uw,oo,yg,lS,FT,sN=`This is a generic model class that will be instantiated as one of the model classes of the library (with a semantic segmentation head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,dS,TT,iN="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",mS,Ct,vg,cS,CT,lN="Instantiates one of the model classes of the library (with a semantic segmentation head) from a configuration.",fS,yT,dN=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,gS,dl,hS,fr,wg,pS,vT,mN="Instantiate one of the model classes of the library (with a semantic segmentation head) from a pretrained model.",uS,wT,cN=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,_S,xT,fN='<li><strong>data2vec-vision</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.TFData2VecVisionForSemanticSegmentation">TFData2VecVisionForSemanticSegmentation</a> (Data2VecVision model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/main/en/model_doc/mobilevit#transformers.TFMobileViTForSemanticSegmentation">TFMobileViTForSemanticSegmentation</a> (MobileViT model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/main/en/model_doc/segformer#transformers.TFSegformerForSemanticSegmentation">TFSegformerForSemanticSegmentation</a> (SegFormer model)</li>',bS,ml,Nw,xg,qw,ro,Lg,MS,LT,gN=`This is a generic model class that will be instantiated as one of the model classes of the library (with a instance segmentation head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,FS,kT,hN="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",TS,yt,kg,CS,$T,pN="Instantiates one of the model classes of the library (with a instance segmentation head) from a configuration.",yS,BT,uN=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,vS,cl,wS,z,$g,xS,AT,_N="Instantiate one of the model classes of the library (with a instance segmentation head) from a pretrained model.",LS,jT,bN=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,kS,ZT,MN='<li><strong>maskformer</strong> — <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> (MaskFormer model)</li>',$S,RT,FN=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,BS,fl,Xw,Bg,Dw,no,Ag,AS,ST,TN=`This is a generic model class that will be instantiated as one of the model classes of the library (with a universal image segmentation head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,jS,GT,CN="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",ZS,vt,jg,RS,WT,yN="Instantiates one of the model classes of the library (with a universal image segmentation head) from a configuration.",SS,PT,vN=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,GS,gl,WS,O,Zg,PS,VT,wN="Instantiate one of the model classes of the library (with a universal image segmentation head) from a pretrained model.",VS,JT,xN=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,JS,ET,LN='<li><strong>detr</strong> — <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> (DETR model)</li> <li><strong>mask2former</strong> — <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a> (Mask2Former model)</li> <li><strong>maskformer</strong> — <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> (MaskFormer model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerForUniversalSegmentation">OneFormerForUniversalSegmentation</a> (OneFormer model)</li>',ES,IT,kN=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,IS,hl,Qw,Rg,Hw,to,Sg,US,UT,$N=`This is a generic model class that will be instantiated as one of the model classes of the library (with a zero-shot image classification head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,NS,NT,BN="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",qS,wt,Gg,XS,qT,AN="Instantiates one of the model classes of the library (with a zero-shot image classification head) from a configuration.",DS,XT,jN=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,QS,pl,HS,K,Wg,YS,DT,ZN="Instantiate one of the model classes of the library (with a zero-shot image classification head) from a pretrained model.",zS,QT,RN=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,OS,HT,SN='<li><strong>align</strong> — <a href="/docs/transformers/main/en/model_doc/align#transformers.AlignModel">AlignModel</a> (ALIGN model)</li> <li><strong>altclip</strong> — <a href="/docs/transformers/main/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a> (AltCLIP model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/main/en/model_doc/blip#transformers.BlipModel">BlipModel</a> (BLIP model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/main/en/model_doc/chinese_clip#transformers.ChineseCLIPModel">ChineseCLIPModel</a> (Chinese-CLIP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPModel">CLIPModel</a> (CLIP model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a> (CLIPSeg model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipModel">SiglipModel</a> (SigLIP model)</li>',KS,YT,GN=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,eG,ul,Yw,Pg,zw,ao,Vg,oG,zT,WN=`This is a generic model class that will be instantiated as one of the model classes of the library (with a zero-shot image classification head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,rG,OT,PN="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",nG,xt,Jg,tG,KT,VN="Instantiates one of the model classes of the library (with a zero-shot image classification head) from a configuration.",aG,eC,JN=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,sG,_l,iG,gr,Eg,lG,oC,EN="Instantiate one of the model classes of the library (with a zero-shot image classification head) from a pretrained model.",dG,rC,IN=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,mG,nC,UN='<li><strong>blip</strong> — <a href="/docs/transformers/main/en/model_doc/blip#transformers.TFBlipModel">TFBlipModel</a> (BLIP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/en/model_doc/clip#transformers.TFCLIPModel">TFCLIPModel</a> (CLIP model)</li>',cG,bl,Ow,Ig,Kw,so,Ug,fG,tC,NN=`This is a generic model class that will be instantiated as one of the model classes of the library (with a zero-shot object detection head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,gG,aC,qN="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",hG,Lt,Ng,pG,sC,XN="Instantiates one of the model classes of the library (with a zero-shot object detection head) from a configuration.",uG,iC,DN=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,_G,Ml,bG,ee,qg,MG,lC,QN="Instantiate one of the model classes of the library (with a zero-shot object detection head) from a pretrained model.",FG,dC,HN=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,TG,mC,YN='<li><strong>owlv2</strong> — <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection">Owlv2ForObjectDetection</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/main/en/model_doc/owlvit#transformers.OwlViTForObjectDetection">OwlViTForObjectDetection</a> (OWL-ViT model)</li>',CG,cC,zN=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,yG,Fl,ex,Xg,ox,Dg,ON="The following auto classes are available for the following audio tasks.",rx,Qg,nx,io,Hg,vG,fC,KN=`This is a generic model class that will be instantiated as one of the model classes of the library (with a audio classification head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,wG,gC,e5="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",xG,kt,Yg,LG,hC,o5="Instantiates one of the model classes of the library (with a audio classification head) from a configuration.",kG,pC,r5=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,$G,Tl,BG,oe,zg,AG,uC,n5="Instantiate one of the model classes of the library (with a audio classification head) from a pretrained model.",jG,_C,t5=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,ZG,bC,a5='<li><strong>audio-spectrogram-transformer</strong> — <a href="/docs/transformers/main/en/model_doc/audio-spectrogram-transformer#transformers.ASTForAudioClassification">ASTForAudioClassification</a> (Audio Spectrogram Transformer model)</li> <li><strong>data2vec-audio</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecAudioForSequenceClassification">Data2VecAudioForSequenceClassification</a> (Data2VecAudio model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertForSequenceClassification">HubertForSequenceClassification</a> (Hubert model)</li> <li><strong>sew</strong> — <a href="/docs/transformers/main/en/model_doc/sew#transformers.SEWForSequenceClassification">SEWForSequenceClassification</a> (SEW model)</li> <li><strong>sew-d</strong> — <a href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDForSequenceClassification">SEWDForSequenceClassification</a> (SEW-D model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/main/en/model_doc/unispeech#transformers.UniSpeechForSequenceClassification">UniSpeechForSequenceClassification</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/main/en/model_doc/unispeech-sat#transformers.UniSpeechSatForSequenceClassification">UniSpeechSatForSequenceClassification</a> (UniSpeechSat model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForSequenceClassification">Wav2Vec2ForSequenceClassification</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertForSequenceClassification">Wav2Vec2BertForSequenceClassification</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerForSequenceClassification">Wav2Vec2ConformerForSequenceClassification</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/main/en/model_doc/wavlm#transformers.WavLMForSequenceClassification">WavLMForSequenceClassification</a> (WavLM model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/main/en/model_doc/whisper#transformers.WhisperForAudioClassification">WhisperForAudioClassification</a> (Whisper model)</li>',RG,MC,s5=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,SG,Cl,tx,Og,ax,lo,Kg,GG,FC,i5=`This is a generic model class that will be instantiated as one of the model classes of the library (with a audio classification head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,WG,TC,l5="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",PG,$t,eh,VG,CC,d5="Instantiates one of the model classes of the library (with a audio classification head) from a configuration.",JG,yC,m5=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,EG,yl,IG,hr,oh,UG,vC,c5="Instantiate one of the model classes of the library (with a audio classification head) from a pretrained model.",NG,wC,f5=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,qG,xC,g5='<li><strong>wav2vec2</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.TFWav2Vec2ForSequenceClassification">TFWav2Vec2ForSequenceClassification</a> (Wav2Vec2 model)</li>',XG,vl,sx,rh,ix,mo,nh,DG,LC,h5=`This is a generic model class that will be instantiated as one of the model classes of the library (with a audio frame (token) classification head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,QG,kC,p5="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",HG,Bt,th,YG,$C,u5="Instantiates one of the model classes of the library (with a audio frame (token) classification head) from a configuration.",zG,BC,_5=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,OG,wl,KG,re,ah,eW,AC,b5="Instantiate one of the model classes of the library (with a audio frame (token) classification head) from a pretrained model.",oW,jC,M5=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,rW,ZC,F5='<li><strong>data2vec-audio</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecAudioForAudioFrameClassification">Data2VecAudioForAudioFrameClassification</a> (Data2VecAudio model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/main/en/model_doc/unispeech-sat#transformers.UniSpeechSatForAudioFrameClassification">UniSpeechSatForAudioFrameClassification</a> (UniSpeechSat model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForAudioFrameClassification">Wav2Vec2ForAudioFrameClassification</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertForAudioFrameClassification">Wav2Vec2BertForAudioFrameClassification</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerForAudioFrameClassification">Wav2Vec2ConformerForAudioFrameClassification</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/main/en/model_doc/wavlm#transformers.WavLMForAudioFrameClassification">WavLMForAudioFrameClassification</a> (WavLM model)</li>',nW,RC,T5=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,tW,xl,lx,sh,dx,co,ih,aW,SC,C5=`This is a generic model class that will be instantiated as one of the model classes of the library (with a connectionist temporal classification head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,sW,GC,y5="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",iW,At,lh,lW,WC,v5="Instantiates one of the model classes of the library (with a connectionist temporal classification head) from a configuration.",dW,PC,w5=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,mW,Ll,cW,ne,dh,fW,VC,x5="Instantiate one of the model classes of the library (with a connectionist temporal classification head) from a pretrained model.",gW,JC,L5=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,hW,EC,k5='<li><strong>data2vec-audio</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecAudioForCTC">Data2VecAudioForCTC</a> (Data2VecAudio model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertForCTC">HubertForCTC</a> (Hubert model)</li> <li><strong>mctct</strong> — <a href="/docs/transformers/main/en/model_doc/mctct#transformers.MCTCTForCTC">MCTCTForCTC</a> (M-CTC-T model)</li> <li><strong>sew</strong> — <a href="/docs/transformers/main/en/model_doc/sew#transformers.SEWForCTC">SEWForCTC</a> (SEW model)</li> <li><strong>sew-d</strong> — <a href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDForCTC">SEWDForCTC</a> (SEW-D model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/main/en/model_doc/unispeech#transformers.UniSpeechForCTC">UniSpeechForCTC</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/main/en/model_doc/unispeech-sat#transformers.UniSpeechSatForCTC">UniSpeechSatForCTC</a> (UniSpeechSat model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertForCTC">Wav2Vec2BertForCTC</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerForCTC">Wav2Vec2ConformerForCTC</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/main/en/model_doc/wavlm#transformers.WavLMForCTC">WavLMForCTC</a> (WavLM model)</li>',pW,IC,$5=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,uW,kl,mx,mh,cx,fo,ch,_W,UC,B5=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,bW,NC,A5="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",MW,jt,fh,FW,qC,j5="Instantiates one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a configuration.",TW,XC,Z5=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,CW,$l,yW,te,gh,vW,DC,R5="Instantiate one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a pretrained model.",wW,QC,S5=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,xW,HC,G5='<li><strong>pop2piano</strong> — <a href="/docs/transformers/main/en/model_doc/pop2piano#transformers.Pop2PianoForConditionalGeneration">Pop2PianoForConditionalGeneration</a> (Pop2Piano model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TForSpeechToText">SeamlessM4TForSpeechToText</a> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForSpeechToText">SeamlessM4Tv2ForSpeechToText</a> (SeamlessM4Tv2 model)</li> <li><strong>speech-encoder-decoder</strong> — <a href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderModel">SpeechEncoderDecoderModel</a> (Speech Encoder decoder model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/main/en/model_doc/speech_to_text#transformers.Speech2TextForConditionalGeneration">Speech2TextForConditionalGeneration</a> (Speech2Text model)</li> <li><strong>speecht5</strong> — <a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5ForSpeechToText">SpeechT5ForSpeechToText</a> (SpeechT5 model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/main/en/model_doc/whisper#transformers.WhisperForConditionalGeneration">WhisperForConditionalGeneration</a> (Whisper model)</li>',LW,YC,W5=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,kW,Bl,fx,hh,gx,go,ph,$W,zC,P5=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,BW,OC,V5="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",AW,Zt,uh,jW,KC,J5="Instantiates one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a configuration.",ZW,ey,E5=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,RW,Al,SW,pr,_h,GW,oy,I5="Instantiate one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a pretrained model.",WW,ry,U5=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,PW,ny,N5='<li><strong>speech_to_text</strong> — <a href="/docs/transformers/main/en/model_doc/speech_to_text#transformers.TFSpeech2TextForConditionalGeneration">TFSpeech2TextForConditionalGeneration</a> (Speech2Text model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/main/en/model_doc/whisper#transformers.TFWhisperForConditionalGeneration">TFWhisperForConditionalGeneration</a> (Whisper model)</li>',VW,jl,hx,bh,px,ho,Mh,JW,ty,q5=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,EW,ay,X5="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",IW,Rt,Fh,UW,sy,D5="Instantiates one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a configuration.",NW,iy,Q5=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,qW,Zl,XW,ur,Th,DW,ly,H5="Instantiate one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a pretrained model.",QW,dy,Y5=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,HW,my,z5='<li><strong>speech-encoder-decoder</strong> — <a href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.FlaxSpeechEncoderDecoderModel">FlaxSpeechEncoderDecoderModel</a> (Speech Encoder decoder model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/main/en/model_doc/whisper#transformers.FlaxWhisperForConditionalGeneration">FlaxWhisperForConditionalGeneration</a> (Whisper model)</li>',YW,Rl,ux,Ch,_x,po,yh,zW,cy,O5=`This is a generic model class that will be instantiated as one of the model classes of the library (with a audio retrieval via x-vector head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,OW,fy,K5="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",KW,St,vh,eP,gy,eq="Instantiates one of the model classes of the library (with a audio retrieval via x-vector head) from a configuration.",oP,hy,oq=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,rP,Sl,nP,ae,wh,tP,py,rq="Instantiate one of the model classes of the library (with a audio retrieval via x-vector head) from a pretrained model.",aP,uy,nq=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,sP,_y,tq='<li><strong>data2vec-audio</strong> — <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecAudioForXVector">Data2VecAudioForXVector</a> (Data2VecAudio model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/main/en/model_doc/unispeech-sat#transformers.UniSpeechSatForXVector">UniSpeechSatForXVector</a> (UniSpeechSat model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForXVector">Wav2Vec2ForXVector</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertForXVector">Wav2Vec2BertForXVector</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/main/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerForXVector">Wav2Vec2ConformerForXVector</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/main/en/model_doc/wavlm#transformers.WavLMForXVector">WavLMForXVector</a> (WavLM model)</li>',iP,by,aq=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,lP,Gl,bx,xh,Mx,Lh,kh,Fx,$h,Tx,Bh,Ah,Cx,jh,yx,Zh,sq="The following auto classes are available for the following multimodal tasks.",vx,Rh,wx,uo,Sh,dP,My,iq=`This is a generic model class that will be instantiated as one of the model classes of the library (with a table question answering head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,mP,Fy,lq="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",cP,Gt,Gh,fP,Ty,dq="Instantiates one of the model classes of the library (with a table question answering head) from a configuration.",gP,Cy,mq=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,hP,Wl,pP,se,Wh,uP,yy,cq="Instantiate one of the model classes of the library (with a table question answering head) from a pretrained model.",_P,vy,fq=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,bP,wy,gq='<li><strong>tapas</strong> — <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> (TAPAS model)</li>',MP,xy,hq=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,FP,Pl,xx,Ph,Lx,_o,Vh,TP,Ly,pq=`This is a generic model class that will be instantiated as one of the model classes of the library (with a table question answering head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,CP,ky,uq="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",yP,Wt,Jh,vP,$y,_q="Instantiates one of the model classes of the library (with a table question answering head) from a configuration.",wP,By,bq=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,xP,Vl,LP,_r,Eh,kP,Ay,Mq="Instantiate one of the model classes of the library (with a table question answering head) from a pretrained model.",$P,jy,Fq=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,BP,Zy,Tq='<li><strong>tapas</strong> — <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> (TAPAS model)</li>',AP,Jl,kx,Ih,$x,bo,Uh,jP,Ry,Cq=`This is a generic model class that will be instantiated as one of the model classes of the library (with a document question answering head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,ZP,Sy,yq="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",RP,Pt,Nh,SP,Gy,vq="Instantiates one of the model classes of the library (with a document question answering head) from a configuration.",GP,Wy,wq=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,WP,El,PP,ie,qh,VP,Py,xq="Instantiate one of the model classes of the library (with a document question answering head) from a pretrained model.",JP,Vy,Lq=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,EP,Jy,kq='<li><strong>layoutlm</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.LayoutLMForQuestionAnswering">LayoutLMForQuestionAnswering</a> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv2#transformers.LayoutLMv2ForQuestionAnswering">LayoutLMv2ForQuestionAnswering</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.LayoutLMv3ForQuestionAnswering">LayoutLMv3ForQuestionAnswering</a> (LayoutLMv3 model)</li>',IP,Ey,$q=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,UP,Il,Bx,Xh,Ax,Mo,Dh,NP,Iy,Bq=`This is a generic model class that will be instantiated as one of the model classes of the library (with a document question answering head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,qP,Uy,Aq="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",XP,Vt,Qh,DP,Ny,jq="Instantiates one of the model classes of the library (with a document question answering head) from a configuration.",QP,qy,Zq=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,HP,Ul,YP,br,Hh,zP,Xy,Rq="Instantiate one of the model classes of the library (with a document question answering head) from a pretrained model.",OP,Dy,Sq=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,KP,Qy,Gq='<li><strong>layoutlm</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.TFLayoutLMForQuestionAnswering">TFLayoutLMForQuestionAnswering</a> (LayoutLM model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.TFLayoutLMv3ForQuestionAnswering">TFLayoutLMv3ForQuestionAnswering</a> (LayoutLMv3 model)</li>',eV,Nl,jx,Yh,Zx,Fo,zh,oV,Hy,Wq=`This is a generic model class that will be instantiated as one of the model classes of the library (with a visual question answering head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,rV,Yy,Pq="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",nV,Jt,Oh,tV,zy,Vq="Instantiates one of the model classes of the library (with a visual question answering head) from a configuration.",aV,Oy,Jq=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,sV,ql,iV,le,Kh,lV,Ky,Eq="Instantiate one of the model classes of the library (with a visual question answering head) from a pretrained model.",dV,ev,Iq=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,mV,ov,Uq='<li><strong>blip</strong> — <a href="/docs/transformers/main/en/model_doc/blip#transformers.BlipForQuestionAnswering">BlipForQuestionAnswering</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/main/en/model_doc/blip-2#transformers.Blip2ForConditionalGeneration">Blip2ForConditionalGeneration</a> (BLIP-2 model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltForQuestionAnswering">ViltForQuestionAnswering</a> (ViLT model)</li>',cV,rv,Nq=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,fV,Xl,Rx,ep,Sx,To,op,gV,nv,qq=`This is a generic model class that will be instantiated as one of the model classes of the library (with a vision-to-text modeling head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,hV,tv,Xq="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",pV,Et,rp,uV,av,Dq="Instantiates one of the model classes of the library (with a vision-to-text modeling head) from a configuration.",_V,sv,Qq=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,bV,Dl,MV,de,np,FV,iv,Hq="Instantiate one of the model classes of the library (with a vision-to-text modeling head) from a pretrained model.",TV,lv,Yq=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,CV,dv,zq='<li><strong>blip</strong> — <a href="/docs/transformers/main/en/model_doc/blip#transformers.BlipForConditionalGeneration">BlipForConditionalGeneration</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/main/en/model_doc/blip-2#transformers.Blip2ForConditionalGeneration">Blip2ForConditionalGeneration</a> (BLIP-2 model)</li> <li><strong>git</strong> — <a href="/docs/transformers/main/en/model_doc/git#transformers.GitForCausalLM">GitForCausalLM</a> (GIT model)</li> <li><strong>instructblip</strong> — <a href="/docs/transformers/main/en/model_doc/instructblip#transformers.InstructBlipForConditionalGeneration">InstructBlipForConditionalGeneration</a> (InstructBLIP model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/main/en/model_doc/kosmos-2#transformers.Kosmos2ForConditionalGeneration">Kosmos2ForConditionalGeneration</a> (KOSMOS-2 model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaForConditionalGeneration">LlavaForConditionalGeneration</a> (LLaVa model)</li> <li><strong>llava_next</strong> — <a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextForConditionalGeneration">LlavaNextForConditionalGeneration</a> (LLaVA-NeXT model)</li> <li><strong>pix2struct</strong> — <a href="/docs/transformers/main/en/model_doc/pix2struct#transformers.Pix2StructForConditionalGeneration">Pix2StructForConditionalGeneration</a> (Pix2Struct model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/main/en/model_doc/vipllava#transformers.VipLlavaForConditionalGeneration">VipLlavaForConditionalGeneration</a> (VipLlava model)</li> <li><strong>vision-encoder-decoder</strong> — <a href="/docs/transformers/main/en/model_doc/vision-encoder-decoder#transformers.VisionEncoderDecoderModel">VisionEncoderDecoderModel</a> (Vision Encoder decoder model)</li>',yV,mv,Oq=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,vV,Ql,Gx,tp,Wx,Co,ap,wV,cv,Kq=`This is a generic model class that will be instantiated as one of the model classes of the library (with a vision-to-text modeling head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,xV,fv,e4="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",LV,It,sp,kV,gv,o4="Instantiates one of the model classes of the library (with a vision-to-text modeling head) from a configuration.",$V,hv,r4=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,BV,Hl,AV,Mr,ip,jV,pv,n4="Instantiate one of the model classes of the library (with a vision-to-text modeling head) from a pretrained model.",ZV,uv,t4=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,RV,_v,a4='<li><strong>blip</strong> — <a href="/docs/transformers/main/en/model_doc/blip#transformers.TFBlipForConditionalGeneration">TFBlipForConditionalGeneration</a> (BLIP model)</li> <li><strong>vision-encoder-decoder</strong> — <a href="/docs/transformers/main/en/model_doc/vision-encoder-decoder#transformers.TFVisionEncoderDecoderModel">TFVisionEncoderDecoderModel</a> (Vision Encoder decoder model)</li>',SV,Yl,Px,lp,Vx,yo,dp,GV,bv,s4=`This is a generic model class that will be instantiated as one of the model classes of the library (with a vision-to-text modeling head) when created
with the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,WV,Mv,i4="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",PV,Ut,mp,VV,Fv,l4="Instantiates one of the model classes of the library (with a vision-to-text modeling head) from a configuration.",JV,Tv,d4=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,EV,zl,IV,Fr,cp,UV,Cv,m4="Instantiate one of the model classes of the library (with a vision-to-text modeling head) from a pretrained model.",NV,yv,c4=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,qV,vv,f4='<li><strong>vision-encoder-decoder</strong> — <a href="/docs/transformers/main/en/model_doc/vision-encoder-decoder#transformers.FlaxVisionEncoderDecoderModel">FlaxVisionEncoderDecoderModel</a> (Vision Encoder decoder model)</li>',XV,Ol,Jx,wv,Ex;return c=new B({props:{title:"Auto Classes",local:"auto-classes",headingTag:"h1"}}),vd=new k({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKQ==",highlighted:'model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)',wrap:!1}}),Ld=new B({props:{title:"Extending the Auto Classes",local:"extending-the-auto-classes",headingTag:"h2"}}),$d=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMEElMEFBdXRvQ29uZmlnLnJlZ2lzdGVyKCUyMm5ldy1tb2RlbCUyMiUyQyUyME5ld01vZGVsQ29uZmlnKSUwQUF1dG9Nb2RlbC5yZWdpc3RlcihOZXdNb2RlbENvbmZpZyUyQyUyME5ld01vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel

AutoConfig.register(<span class="hljs-string">&quot;new-model&quot;</span>, NewModelConfig)
AutoModel.register(NewModelConfig, NewModel)`,wrap:!1}}),ys=new Ix({props:{warning:!0,$$slots:{default:[T4]},$$scope:{ctx:y}}}),Ad=new B({props:{title:"AutoConfig",local:"transformers.AutoConfig",headingTag:"h2"}}),jd=new x({props:{name:"class transformers.AutoConfig",anchor:"transformers.AutoConfig",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/configuration_auto.py#L791"}}),Zd=new x({props:{name:"from_pretrained",anchor:"transformers.AutoConfig.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoConfig.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co.</li>
<li>A path to a <em>directory</em> containing a configuration file saved using the
<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.save_pretrained">save_pretrained()</a> method, or the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> method,
e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a saved configuration JSON <em>file</em>, e.g.,
<code>./my_model_directory/configuration.json</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoConfig.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoConfig.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download the model weights and configuration files and override the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoConfig.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoConfig.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoConfig.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoConfig.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final configuration object.</p>
<p>If <code>True</code>, then this functions returns a <code>Tuple(config, unused_kwargs)</code> where <em>unused_kwargs</em> is a
dictionary consisting of the key/value pairs whose keys are not configuration attributes: i.e., the
part of <code>kwargs</code> which has not been used to update <code>config</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.AutoConfig.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoConfig.from_pretrained.kwargs(additional",description:`<strong>kwargs(additional</strong> keyword arguments, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are configuration attributes will be used to override the loaded
values. Behavior concerning key/value pairs whose keys are <em>not</em> configuration attributes is controlled
by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs(additional"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/configuration_auto.py#L814"}}),vs=new $({props:{anchor:"transformers.AutoConfig.from_pretrained.example",$$slots:{default:[C4]},$$scope:{ctx:y}}}),Rd=new x({props:{name:"register",anchor:"transformers.AutoConfig.register",parameters:[{name:"model_type",val:""},{name:"config",val:""},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoConfig.register.model_type",description:"<strong>model_type</strong> (<code>str</code>) &#x2014; The model type like &#x201C;bert&#x201D; or &#x201C;gpt&#x201D;.",name:"model_type"},{anchor:"transformers.AutoConfig.register.config",description:'<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014; The config to register.',name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/configuration_auto.py#L953"}}),Sd=new B({props:{title:"AutoTokenizer",local:"transformers.AutoTokenizer",headingTag:"h2"}}),Gd=new x({props:{name:"class transformers.AutoTokenizer",anchor:"transformers.AutoTokenizer",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/tokenization_auto.py#L646"}}),Wd=new x({props:{name:"from_pretrained",anchor:"transformers.AutoTokenizer.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoTokenizer.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a predefined tokenizer hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing vocabulary files required by the tokenizer, for instance saved
using the <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a single saved vocabulary file if and only if the tokenizer only requires a
single vocabulary file (like Bert or XLNet), e.g.: <code>./my_model_directory/vocab.txt</code>. (Not
applicable to all derived classes)</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoTokenizer.from_pretrained.inputs",description:`<strong>inputs</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the Tokenizer <code>__init__()</code> method.`,name:"inputs"},{anchor:"transformers.AutoTokenizer.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
The configuration object used to determine the tokenizer class to instantiate.`,name:"config"},{anchor:"transformers.AutoTokenizer.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoTokenizer.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download the model weights and configuration files and override the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoTokenizer.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoTokenizer.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoTokenizer.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoTokenizer.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co (e.g. for
facebook/rag-token-base), specify it here.`,name:"subfolder"},{anchor:"transformers.AutoTokenizer.from_pretrained.use_fast",description:`<strong>use_fast</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Use a <a href="https://huggingface.co/docs/tokenizers/index" rel="nofollow">fast Rust-based tokenizer</a> if it is supported for
a given model. If a fast tokenizer is not available for a given model, a normal Python-based tokenizer
is returned instead.`,name:"use_fast"},{anchor:"transformers.AutoTokenizer.from_pretrained.tokenizer_type",description:`<strong>tokenizer_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Tokenizer type to be loaded.`,name:"tokenizer_type"},{anchor:"transformers.AutoTokenizer.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoTokenizer.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Will be passed to the Tokenizer <code>__init__()</code> method. Can be used to set special tokens like
<code>bos_token</code>, <code>eos_token</code>, <code>unk_token</code>, <code>sep_token</code>, <code>pad_token</code>, <code>cls_token</code>, <code>mask_token</code>,
<code>additional_special_tokens</code>. See parameters in the <code>__init__()</code> for more details.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/tokenization_auto.py#L660"}}),xs=new $({props:{anchor:"transformers.AutoTokenizer.from_pretrained.example",$$slots:{default:[y4]},$$scope:{ctx:y}}}),Pd=new x({props:{name:"register",anchor:"transformers.AutoTokenizer.register",parameters:[{name:"config_class",val:""},{name:"slow_tokenizer_class",val:" = None"},{name:"fast_tokenizer_class",val:" = None"},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoTokenizer.register.config_class",description:`<strong>config_class</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The configuration corresponding to the model to register.`,name:"config_class"},{anchor:"transformers.AutoTokenizer.register.slow_tokenizer_class",description:`<strong>slow_tokenizer_class</strong> (<code>PretrainedTokenizer</code>, <em>optional</em>) &#x2014;
The slow tokenizer to register.`,name:"slow_tokenizer_class"},{anchor:"transformers.AutoTokenizer.register.fast_tokenizer_class",description:`<strong>fast_tokenizer_class</strong> (<code>PretrainedTokenizerFast</code>, <em>optional</em>) &#x2014;
The fast tokenizer to register.`,name:"fast_tokenizer_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/tokenization_auto.py#L877"}}),Vd=new B({props:{title:"AutoFeatureExtractor",local:"transformers.AutoFeatureExtractor",headingTag:"h2"}}),Jd=new x({props:{name:"class transformers.AutoFeatureExtractor",anchor:"transformers.AutoFeatureExtractor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/feature_extraction_auto.py#L238"}}),Ed=new x({props:{name:"from_pretrained",anchor:"transformers.AutoFeatureExtractor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoFeatureExtractor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g.,
<code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model feature extractor should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the feature extractor files and override the cached versions
if they exist.`,name:"force_download"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final feature extractor object. If <code>True</code>, then this
functions returns a <code>Tuple(feature_extractor, unused_kwargs)</code> where <em>unused_kwargs</em> is a dictionary
consisting of the key/value pairs whose keys are not feature extractor attributes: i.e., the part of
<code>kwargs</code> which has not been used to update <code>feature_extractor</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are feature extractor attributes will be used to override the
loaded values. Behavior concerning key/value pairs whose keys are <em>not</em> feature extractor attributes is
controlled by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/feature_extraction_auto.py#L252"}}),ks=new Ix({props:{$$slots:{default:[v4]},$$scope:{ctx:y}}}),$s=new $({props:{anchor:"transformers.AutoFeatureExtractor.from_pretrained.example",$$slots:{default:[w4]},$$scope:{ctx:y}}}),Id=new x({props:{name:"register",anchor:"transformers.AutoFeatureExtractor.register",parameters:[{name:"config_class",val:""},{name:"feature_extractor_class",val:""},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoFeatureExtractor.register.config_class",description:`<strong>config_class</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The configuration corresponding to the model to register.`,name:"config_class"},{anchor:"transformers.AutoFeatureExtractor.register.feature_extractor_class",description:"<strong>feature_extractor_class</strong> (<code>FeatureExtractorMixin</code>) &#x2014; The feature extractor to register.",name:"feature_extractor_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/feature_extraction_auto.py#L386"}}),Ud=new B({props:{title:"AutoImageProcessor",local:"transformers.AutoImageProcessor",headingTag:"h2"}}),Nd=new x({props:{name:"class transformers.AutoImageProcessor",anchor:"transformers.AutoImageProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/image_processing_auto.py#L255"}}),qd=new x({props:{name:"from_pretrained",anchor:"transformers.AutoImageProcessor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoImageProcessor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained image_processor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a image processor file saved using the
<a href="/docs/transformers/main/en/main_classes/image_processor#transformers.ImageProcessingMixin.save_pretrained">save_pretrained()</a> method, e.g.,
<code>./my_model_directory/</code>.</li>
<li>a path or url to a saved image processor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoImageProcessor.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model image processor should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoImageProcessor.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the image processor files and override the cached versions if
they exist.`,name:"force_download"},{anchor:"transformers.AutoImageProcessor.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.AutoImageProcessor.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoImageProcessor.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.AutoImageProcessor.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoImageProcessor.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final image processor object. If <code>True</code>, then this
functions returns a <code>Tuple(image_processor, unused_kwargs)</code> where <em>unused_kwargs</em> is a dictionary
consisting of the key/value pairs whose keys are not image processor attributes: i.e., the part of
<code>kwargs</code> which has not been used to update <code>image_processor</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.AutoImageProcessor.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoImageProcessor.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are image processor attributes will be used to override the
loaded values. Behavior concerning key/value pairs whose keys are <em>not</em> image processor attributes is
controlled by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/image_processing_auto.py#L269"}}),As=new Ix({props:{$$slots:{default:[x4]},$$scope:{ctx:y}}}),js=new $({props:{anchor:"transformers.AutoImageProcessor.from_pretrained.example",$$slots:{default:[L4]},$$scope:{ctx:y}}}),Xd=new x({props:{name:"register",anchor:"transformers.AutoImageProcessor.register",parameters:[{name:"config_class",val:""},{name:"image_processor_class",val:""},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoImageProcessor.register.config_class",description:`<strong>config_class</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The configuration corresponding to the model to register.`,name:"config_class"},{anchor:"transformers.AutoImageProcessor.register.image_processor_class",description:'<strong>image_processor_class</strong> (<a href="/docs/transformers/main/en/main_classes/image_processor#transformers.ImageProcessingMixin">ImageProcessingMixin</a>) &#x2014; The image processor to register.',name:"image_processor_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/image_processing_auto.py#L425"}}),Dd=new B({props:{title:"AutoProcessor",local:"transformers.AutoProcessor",headingTag:"h2"}}),Qd=new x({props:{name:"class transformers.AutoProcessor",anchor:"transformers.AutoProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/processing_auto.py#L130"}}),Hd=new x({props:{name:"from_pretrained",anchor:"transformers.AutoProcessor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoProcessor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a processor files saved using the <code>save_pretrained()</code> method,
e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoProcessor.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model feature extractor should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoProcessor.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the feature extractor files and override the cached versions
if they exist.`,name:"force_download"},{anchor:"transformers.AutoProcessor.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.AutoProcessor.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoProcessor.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.AutoProcessor.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoProcessor.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final feature extractor object. If <code>True</code>, then this
functions returns a <code>Tuple(feature_extractor, unused_kwargs)</code> where <em>unused_kwargs</em> is a dictionary
consisting of the key/value pairs whose keys are not feature extractor attributes: i.e., the part of
<code>kwargs</code> which has not been used to update <code>feature_extractor</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.AutoProcessor.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoProcessor.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are feature extractor attributes will be used to override the
loaded values. Behavior concerning key/value pairs whose keys are <em>not</em> feature extractor attributes is
controlled by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/processing_auto.py#L144"}}),Rs=new Ix({props:{$$slots:{default:[k4]},$$scope:{ctx:y}}}),Ss=new $({props:{anchor:"transformers.AutoProcessor.from_pretrained.example",$$slots:{default:[$4]},$$scope:{ctx:y}}}),Yd=new x({props:{name:"register",anchor:"transformers.AutoProcessor.register",parameters:[{name:"config_class",val:""},{name:"processor_class",val:""},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoProcessor.register.config_class",description:`<strong>config_class</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The configuration corresponding to the model to register.`,name:"config_class"},{anchor:"transformers.AutoProcessor.register.processor_class",description:"<strong>processor_class</strong> (<code>FeatureExtractorMixin</code>) &#x2014; The processor to register.",name:"processor_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/processing_auto.py#L347"}}),zd=new B({props:{title:"Generic model classes",local:"generic-model-classes",headingTag:"h2"}}),Kd=new B({props:{title:"AutoModel",local:"transformers.AutoModel",headingTag:"h3"}}),em=new x({props:{name:"class transformers.AutoModel",anchor:"transformers.AutoModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_auto.py#L1408"}}),om=new x({props:{name:"from_config",anchor:"transformers.AutoModel.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModel.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/en/model_doc/audio-spectrogram-transformer#transformers.ASTConfig">ASTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/audio-spectrogram-transformer#transformers.ASTModel">ASTModel</a> (Audio Spectrogram Transformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertModel">AlbertModel</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/align#transformers.AlignConfig">AlignConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/align#transformers.AlignModel">AlignModel</a> (ALIGN model)</li>
<li><a href="/docs/transformers/main/en/model_doc/altclip#transformers.AltCLIPConfig">AltCLIPConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a> (AltCLIP model)</li>
<li><a href="/docs/transformers/main/en/model_doc/autoformer#transformers.AutoformerConfig">AutoformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/autoformer#transformers.AutoformerModel">AutoformerModel</a> (Autoformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bark#transformers.BarkConfig">BarkConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bark#transformers.BarkModel">BarkModel</a> (Bark model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bart#transformers.BartModel">BartModel</a> (BART model)</li>
<li><a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitModel">BeitModel</a> (BEiT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertModel">BertModel</a> (BERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bert-generation#transformers.BertGenerationConfig">BertGenerationConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bert-generation#transformers.BertGenerationEncoder">BertGenerationEncoder</a> (Bert Generation model)</li>
<li><a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdModel">BigBirdModel</a> (BigBird model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusConfig">BigBirdPegasusConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusModel">BigBirdPegasusModel</a> (BigBird-Pegasus model)</li>
<li><a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig">BioGptConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptModel">BioGptModel</a> (BioGpt model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bit#transformers.BitConfig">BitConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bit#transformers.BitModel">BitModel</a> (BiT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/blenderbot#transformers.BlenderbotModel">BlenderbotModel</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/main/en/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/blenderbot-small#transformers.BlenderbotSmallModel">BlenderbotSmallModel</a> (BlenderbotSmall model)</li>
<li><a href="/docs/transformers/main/en/model_doc/blip-2#transformers.Blip2Config">Blip2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/blip-2#transformers.Blip2Model">Blip2Model</a> (BLIP-2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/blip#transformers.BlipConfig">BlipConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/blip#transformers.BlipModel">BlipModel</a> (BLIP model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bloom#transformers.BloomModel">BloomModel</a> (BLOOM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bridgetower#transformers.BridgeTowerConfig">BridgeTowerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bridgetower#transformers.BridgeTowerModel">BridgeTowerModel</a> (BridgeTower model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bros#transformers.BrosConfig">BrosConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bros#transformers.BrosModel">BrosModel</a> (BROS model)</li>
<li><a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPConfig">CLIPConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPModel">CLIPModel</a> (CLIP model)</li>
<li><a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegConfig">CLIPSegConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a> (CLIPSeg model)</li>
<li><a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionConfig">CLIPVisionConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionModel">CLIPVisionModel</a> (CLIPVisionModel model)</li>
<li><a href="/docs/transformers/main/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/ctrl#transformers.CTRLModel">CTRLModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertModel">CamembertModel</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineConfig">CanineConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineModel">CanineModel</a> (CANINE model)</li>
<li><a href="/docs/transformers/main/en/model_doc/chinese_clip#transformers.ChineseCLIPConfig">ChineseCLIPConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/chinese_clip#transformers.ChineseCLIPModel">ChineseCLIPModel</a> (Chinese-CLIP model)</li>
<li><a href="/docs/transformers/main/en/model_doc/chinese_clip#transformers.ChineseCLIPVisionConfig">ChineseCLIPVisionConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/chinese_clip#transformers.ChineseCLIPVisionModel">ChineseCLIPVisionModel</a> (ChineseCLIPVisionModel model)</li>
<li><a href="/docs/transformers/main/en/model_doc/clap#transformers.ClapConfig">ClapConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/clap#transformers.ClapModel">ClapModel</a> (CLAP model)</li>
<li><a href="/docs/transformers/main/en/model_doc/clvp#transformers.ClvpConfig">ClvpConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/clvp#transformers.ClvpModelForConditionalGeneration">ClvpModelForConditionalGeneration</a> (CLVP model)</li>
<li><a href="/docs/transformers/main/en/model_doc/codegen#transformers.CodeGenConfig">CodeGenConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/codegen#transformers.CodeGenModel">CodeGenModel</a> (CodeGen model)</li>
<li><a href="/docs/transformers/main/en/model_doc/cohere#transformers.CohereConfig">CohereConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/cohere#transformers.CohereModel">CohereModel</a> (Cohere model)</li>
<li><a href="/docs/transformers/main/en/model_doc/conditional_detr#transformers.ConditionalDetrConfig">ConditionalDetrConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/conditional_detr#transformers.ConditionalDetrModel">ConditionalDetrModel</a> (Conditional DETR model)</li>
<li><a href="/docs/transformers/main/en/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/convbert#transformers.ConvBertModel">ConvBertModel</a> (ConvBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/convnext#transformers.ConvNextConfig">ConvNextConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/convnext#transformers.ConvNextModel">ConvNextModel</a> (ConvNeXT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/convnextv2#transformers.ConvNextV2Config">ConvNextV2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/convnextv2#transformers.ConvNextV2Model">ConvNextV2Model</a> (ConvNeXTV2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/cpmant#transformers.CpmAntConfig">CpmAntConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/cpmant#transformers.CpmAntModel">CpmAntModel</a> (CPM-Ant model)</li>
<li><a href="/docs/transformers/main/en/model_doc/cvt#transformers.CvtConfig">CvtConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/cvt#transformers.CvtModel">CvtModel</a> (CvT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/dpr#transformers.DPRConfig">DPRConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/dpr#transformers.DPRQuestionEncoder">DPRQuestionEncoder</a> (DPR model)</li>
<li><a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTConfig">DPTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTModel">DPTModel</a> (DPT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecAudioConfig">Data2VecAudioConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecAudioModel">Data2VecAudioModel</a> (Data2VecAudio model)</li>
<li><a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecTextModel">Data2VecTextModel</a> (Data2VecText model)</li>
<li><a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecVisionConfig">Data2VecVisionConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecVisionModel">Data2VecVisionModel</a> (Data2VecVision model)</li>
<li><a href="/docs/transformers/main/en/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/deberta#transformers.DebertaModel">DebertaModel</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.DebertaV2Model">DebertaV2Model</a> (DeBERTa-v2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/decision_transformer#transformers.DecisionTransformerConfig">DecisionTransformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/decision_transformer#transformers.DecisionTransformerModel">DecisionTransformerModel</a> (Decision Transformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/deformable_detr#transformers.DeformableDetrConfig">DeformableDetrConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/deformable_detr#transformers.DeformableDetrModel">DeformableDetrModel</a> (Deformable DETR model)</li>
<li><a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTModel">DeiTModel</a> (DeiT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/deta#transformers.DetaConfig">DetaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/deta#transformers.DetaModel">DetaModel</a> (DETA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrModel">DetrModel</a> (DETR model)</li>
<li><a href="/docs/transformers/main/en/model_doc/dinat#transformers.DinatConfig">DinatConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/dinat#transformers.DinatModel">DinatModel</a> (DiNAT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/dinov2#transformers.Dinov2Config">Dinov2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/dinov2#transformers.Dinov2Model">Dinov2Model</a> (DINOv2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertModel">DistilBertModel</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/donut#transformers.DonutSwinConfig">DonutSwinConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/donut#transformers.DonutSwinModel">DonutSwinModel</a> (DonutSwin model)</li>
<li><a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerModel">EfficientFormerModel</a> (EfficientFormer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/efficientnet#transformers.EfficientNetConfig">EfficientNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/efficientnet#transformers.EfficientNetModel">EfficientNetModel</a> (EfficientNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraModel">ElectraModel</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecConfig">EncodecConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a> (EnCodec model)</li>
<li><a href="/docs/transformers/main/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/ernie#transformers.ErnieModel">ErnieModel</a> (ERNIE model)</li>
<li><a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMModel">ErnieMModel</a> (ErnieM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/esm#transformers.EsmConfig">EsmConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/esm#transformers.EsmModel">EsmModel</a> (ESM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/fnet#transformers.FNetConfig">FNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/fnet#transformers.FNetModel">FNetModel</a> (FNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/fsmt#transformers.FSMTConfig">FSMTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/fsmt#transformers.FSMTModel">FSMTModel</a> (FairSeq Machine-Translation model)</li>
<li><a href="/docs/transformers/main/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/falcon#transformers.FalconModel">FalconModel</a> (Falcon model)</li>
<li><a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerConfig">FastSpeech2ConformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerModel">FastSpeech2ConformerModel</a> (FastSpeech2Conformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.FlaubertModel">FlaubertModel</a> (FlauBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/flava#transformers.FlavaConfig">FlavaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/flava#transformers.FlavaModel">FlavaModel</a> (FLAVA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/focalnet#transformers.FocalNetConfig">FocalNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/focalnet#transformers.FocalNetModel">FocalNetModel</a> (FocalNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelModel">FunnelModel</a> or <a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelBaseModel">FunnelBaseModel</a> (Funnel Transformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNConfig">GLPNConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNModel">GLPNModel</a> (GLPN model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Model">GPT2Model</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeConfig">GPTBigCodeConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeModel">GPTBigCodeModel</a> (GPTBigCode model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gptj#transformers.GPTJModel">GPTJModel</a> (GPT-J model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt_neo#transformers.GPTNeoConfig">GPTNeoConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt_neo#transformers.GPTNeoModel">GPTNeoModel</a> (GPT Neo model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt_neox#transformers.GPTNeoXConfig">GPTNeoXConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt_neox#transformers.GPTNeoXModel">GPTNeoXModel</a> (GPT NeoX model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseConfig">GPTNeoXJapaneseConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseModel">GPTNeoXJapaneseModel</a> (GPT NeoX Japanese model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseConfig">GPTSanJapaneseConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseForConditionalGeneration">GPTSanJapaneseForConditionalGeneration</a> (GPTSAN-japanese model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gemma#transformers.GemmaConfig">GemmaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gemma#transformers.GemmaModel">GemmaModel</a> (Gemma model)</li>
<li><a href="/docs/transformers/main/en/model_doc/git#transformers.GitConfig">GitConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/git#transformers.GitModel">GitModel</a> (GIT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/graphormer#transformers.GraphormerConfig">GraphormerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/graphormer#transformers.GraphormerModel">GraphormerModel</a> (Graphormer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/groupvit#transformers.GroupViTConfig">GroupViTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/groupvit#transformers.GroupViTModel">GroupViTModel</a> (GroupViT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertConfig">HubertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertModel">HubertModel</a> (Hubert model)</li>
<li><a href="/docs/transformers/main/en/model_doc/ibert#transformers.IBertConfig">IBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/ibert#transformers.IBertModel">IBertModel</a> (I-BERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsConfig">IdeficsConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsModel">IdeficsModel</a> (IDEFICS model)</li>
<li><a href="/docs/transformers/main/en/model_doc/imagegpt#transformers.ImageGPTConfig">ImageGPTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/imagegpt#transformers.ImageGPTModel">ImageGPTModel</a> (ImageGPT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/informer#transformers.InformerConfig">InformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/informer#transformers.InformerModel">InformerModel</a> (Informer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/jukebox#transformers.JukeboxConfig">JukeboxConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/jukebox#transformers.JukeboxModel">JukeboxModel</a> (Jukebox model)</li>
<li><a href="/docs/transformers/main/en/model_doc/kosmos-2#transformers.Kosmos2Config">Kosmos2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/kosmos-2#transformers.Kosmos2Model">Kosmos2Model</a> (KOSMOS-2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/led#transformers.LEDConfig">LEDConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/led#transformers.LEDModel">LEDModel</a> (LED model)</li>
<li><a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.LayoutLMModel">LayoutLMModel</a> (LayoutLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/layoutlmv2#transformers.LayoutLMv2Config">LayoutLMv2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/layoutlmv2#transformers.LayoutLMv2Model">LayoutLMv2Model</a> (LayoutLMv2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.LayoutLMv3Config">LayoutLMv3Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.LayoutLMv3Model">LayoutLMv3Model</a> (LayoutLMv3 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/levit#transformers.LevitConfig">LevitConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/levit#transformers.LevitModel">LevitModel</a> (LeViT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/lilt#transformers.LiltConfig">LiltConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/lilt#transformers.LiltModel">LiltModel</a> (LiLT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaConfig">LlamaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaModel">LlamaModel</a> (LLaMA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/longt5#transformers.LongT5Config">LongT5Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/longt5#transformers.LongT5Model">LongT5Model</a> (LongT5 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/longformer#transformers.LongformerConfig">LongformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/longformer#transformers.LongformerModel">LongformerModel</a> (Longformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/luke#transformers.LukeConfig">LukeConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/luke#transformers.LukeModel">LukeModel</a> (LUKE model)</li>
<li><a href="/docs/transformers/main/en/model_doc/lxmert#transformers.LxmertConfig">LxmertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/lxmert#transformers.LxmertModel">LxmertModel</a> (LXMERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/m2m_100#transformers.M2M100Config">M2M100Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/m2m_100#transformers.M2M100Model">M2M100Model</a> (M2M100 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBartModel">MBartModel</a> (mBART model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mctct#transformers.MCTCTConfig">MCTCTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mctct#transformers.MCTCTModel">MCTCTModel</a> (M-CTC-T model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.MPNetModel">MPNetModel</a> (MPNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Config">MT5Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Model">MT5Model</a> (MT5 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mamba#transformers.MambaConfig">MambaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mamba#transformers.MambaModel">MambaModel</a> (Mamba model)</li>
<li><a href="/docs/transformers/main/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/marian#transformers.MarianModel">MarianModel</a> (Marian model)</li>
<li><a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMConfig">MarkupLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/markuplm#transformers.MarkupLMModel">MarkupLMModel</a> (MarkupLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a> (Mask2Former model)</li>
<li><a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerConfig">MaskFormerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerModel">MaskFormerModel</a> (MaskFormer model)</li>
<li><code>MaskFormerSwinConfig</code> configuration class: <code>MaskFormerSwinModel</code> (MaskFormerSwin model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mega#transformers.MegaModel">MegaModel</a> (MEGA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/megatron-bert#transformers.MegatronBertConfig">MegatronBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/megatron-bert#transformers.MegatronBertModel">MegatronBertModel</a> (Megatron-BERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mgp-str#transformers.MgpstrConfig">MgpstrConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mgp-str#transformers.MgpstrForSceneTextRecognition">MgpstrForSceneTextRecognition</a> (MGP-STR model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mistral#transformers.MistralConfig">MistralConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mistral#transformers.MistralModel">MistralModel</a> (Mistral model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mixtral#transformers.MixtralConfig">MixtralConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mixtral#transformers.MixtralModel">MixtralModel</a> (Mixtral model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertModel">MobileBertModel</a> (MobileBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mobilenet_v1#transformers.MobileNetV1Config">MobileNetV1Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mobilenet_v1#transformers.MobileNetV1Model">MobileNetV1Model</a> (MobileNetV1 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mobilenet_v2#transformers.MobileNetV2Config">MobileNetV2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mobilenet_v2#transformers.MobileNetV2Model">MobileNetV2Model</a> (MobileNetV2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mobilevit#transformers.MobileViTConfig">MobileViTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mobilevit#transformers.MobileViTModel">MobileViTModel</a> (MobileViT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mobilevitv2#transformers.MobileViTV2Config">MobileViTV2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mobilevitv2#transformers.MobileViTV2Model">MobileViTV2Model</a> (MobileViTV2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig">MptConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptModel">MptModel</a> (MPT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mra#transformers.MraConfig">MraConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mra#transformers.MraModel">MraModel</a> (MRA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mvp#transformers.MvpConfig">MvpConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mvp#transformers.MvpModel">MvpModel</a> (MVP model)</li>
<li><a href="/docs/transformers/main/en/model_doc/nat#transformers.NatConfig">NatConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/nat#transformers.NatModel">NatModel</a> (NAT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/nezha#transformers.NezhaConfig">NezhaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/nezha#transformers.NezhaModel">NezhaModel</a> (Nezha model)</li>
<li><a href="/docs/transformers/main/en/model_doc/nllb-moe#transformers.NllbMoeConfig">NllbMoeConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/nllb-moe#transformers.NllbMoeModel">NllbMoeModel</a> (NLLB-MOE model)</li>
<li><a href="/docs/transformers/main/en/model_doc/nystromformer#transformers.NystromformerConfig">NystromformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/nystromformer#transformers.NystromformerModel">NystromformerModel</a> (Nystr&#xF6;mformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTModel">OPTModel</a> (OPT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerConfig">OneFormerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a> (OneFormer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTModel">OpenAIGPTModel</a> (OpenAI GPT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/open-llama#transformers.OpenLlamaConfig">OpenLlamaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/open-llama#transformers.OpenLlamaModel">OpenLlamaModel</a> (OpenLlama model)</li>
<li><a href="/docs/transformers/main/en/model_doc/owlvit#transformers.OwlViTConfig">OwlViTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/owlvit#transformers.OwlViTModel">OwlViTModel</a> (OWL-ViT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Config">Owlv2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a> (OWLv2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/plbart#transformers.PLBartConfig">PLBartConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/plbart#transformers.PLBartModel">PLBartModel</a> (PLBart model)</li>
<li><a href="/docs/transformers/main/en/model_doc/patchtsmixer#transformers.PatchTSMixerConfig">PatchTSMixerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/patchtsmixer#transformers.PatchTSMixerModel">PatchTSMixerModel</a> (PatchTSMixer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/patchtst#transformers.PatchTSTModel">PatchTSTModel</a> (PatchTST model)</li>
<li><a href="/docs/transformers/main/en/model_doc/pegasus#transformers.PegasusConfig">PegasusConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/pegasus#transformers.PegasusModel">PegasusModel</a> (Pegasus model)</li>
<li><a href="/docs/transformers/main/en/model_doc/pegasus_x#transformers.PegasusXConfig">PegasusXConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/pegasus_x#transformers.PegasusXModel">PegasusXModel</a> (PEGASUS-X model)</li>
<li><a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> (Perceiver model)</li>
<li><a href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonConfig">PersimmonConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonModel">PersimmonModel</a> (Persimmon model)</li>
<li><a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiConfig">PhiConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiModel">PhiModel</a> (Phi model)</li>
<li><a href="/docs/transformers/main/en/model_doc/poolformer#transformers.PoolFormerConfig">PoolFormerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/poolformer#transformers.PoolFormerModel">PoolFormerModel</a> (PoolFormer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/prophetnet#transformers.ProphetNetConfig">ProphetNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/prophetnet#transformers.ProphetNetModel">ProphetNetModel</a> (ProphetNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/pvt#transformers.PvtConfig">PvtConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/pvt#transformers.PvtModel">PvtModel</a> (PVT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/pvt_v2#transformers.PvtV2Config">PvtV2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/pvt_v2#transformers.PvtV2Model">PvtV2Model</a> (PVTv2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/qdqbert#transformers.QDQBertConfig">QDQBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/qdqbert#transformers.QDQBertModel">QDQBertModel</a> (QDQBert model)</li>
<li><a href="/docs/transformers/main/en/model_doc/qwen2#transformers.Qwen2Config">Qwen2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/qwen2#transformers.Qwen2Model">Qwen2Model</a> (Qwen2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/qwen2_moe#transformers.Qwen2MoeConfig">Qwen2MoeConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/qwen2_moe#transformers.Qwen2MoeModel">Qwen2MoeModel</a> (Qwen2MoE model)</li>
<li><a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerModel">ReformerModel</a> (Reformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetModel">RegNetModel</a> (RegNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/rembert#transformers.RemBertModel">RemBertModel</a> (RemBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/resnet#transformers.ResNetConfig">ResNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/resnet#transformers.ResNetModel">ResNetModel</a> (ResNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/retribert#transformers.RetriBertConfig">RetriBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/retribert#transformers.RetriBertModel">RetriBertModel</a> (RetriBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roc_bert#transformers.RoCBertConfig">RoCBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roc_bert#transformers.RoCBertModel">RoCBertModel</a> (RoCBert model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerModel">RoFormerModel</a> (RoFormer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaModel">RobertaModel</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormModel">RobertaPreLayerNormModel</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/main/en/model_doc/rwkv#transformers.RwkvConfig">RwkvConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/rwkv#transformers.RwkvModel">RwkvModel</a> (RWKV model)</li>
<li><a href="/docs/transformers/main/en/model_doc/sew#transformers.SEWConfig">SEWConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/sew#transformers.SEWModel">SEWModel</a> (SEW model)</li>
<li><a href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDConfig">SEWDConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDModel">SEWDModel</a> (SEW-D model)</li>
<li><a href="/docs/transformers/main/en/model_doc/sam#transformers.SamConfig">SamConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/sam#transformers.SamModel">SamModel</a> (SAM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TConfig">SeamlessM4TConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TModel">SeamlessM4TModel</a> (SeamlessM4T model)</li>
<li><a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Config">SeamlessM4Tv2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Model">SeamlessM4Tv2Model</a> (SeamlessM4Tv2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/seggpt#transformers.SegGptConfig">SegGptConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/seggpt#transformers.SegGptModel">SegGptModel</a> (SegGPT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/segformer#transformers.SegformerConfig">SegformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/segformer#transformers.SegformerModel">SegformerModel</a> (SegFormer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipConfig">SiglipConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipModel">SiglipModel</a> (SigLIP model)</li>
<li><a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipVisionConfig">SiglipVisionConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipVisionModel">SiglipVisionModel</a> (SiglipVisionModel model)</li>
<li><a href="/docs/transformers/main/en/model_doc/speech_to_text#transformers.Speech2TextConfig">Speech2TextConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/speech_to_text#transformers.Speech2TextModel">Speech2TextModel</a> (Speech2Text model)</li>
<li><a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5Config">SpeechT5Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5Model">SpeechT5Model</a> (SpeechT5 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterConfig">SplinterConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a> (Splinter model)</li>
<li><a href="/docs/transformers/main/en/model_doc/squeezebert#transformers.SqueezeBertConfig">SqueezeBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/squeezebert#transformers.SqueezeBertModel">SqueezeBertModel</a> (SqueezeBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmConfig">StableLmConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmModel">StableLmModel</a> (StableLm model)</li>
<li><a href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2Config">Starcoder2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2Model">Starcoder2Model</a> (Starcoder2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/swiftformer#transformers.SwiftFormerConfig">SwiftFormerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/swiftformer#transformers.SwiftFormerModel">SwiftFormerModel</a> (SwiftFormer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/swin2sr#transformers.Swin2SRConfig">Swin2SRConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/swin2sr#transformers.Swin2SRModel">Swin2SRModel</a> (Swin2SR model)</li>
<li><a href="/docs/transformers/main/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/swin#transformers.SwinModel">SwinModel</a> (Swin Transformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/swinv2#transformers.Swinv2Config">Swinv2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/swinv2#transformers.Swinv2Model">Swinv2Model</a> (Swin Transformer V2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig">SwitchTransformersConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersModel">SwitchTransformersModel</a> (SwitchTransformers model)</li>
<li><a href="/docs/transformers/main/en/model_doc/t5#transformers.T5Config">T5Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5Model">T5Model</a> (T5 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerConfig">TableTransformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerModel">TableTransformerModel</a> (Table Transformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasModel">TapasModel</a> (TAPAS model)</li>
<li><a href="/docs/transformers/main/en/model_doc/time_series_transformer#transformers.TimeSeriesTransformerConfig">TimeSeriesTransformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/time_series_transformer#transformers.TimeSeriesTransformerModel">TimeSeriesTransformerModel</a> (Time Series Transformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/timesformer#transformers.TimesformerConfig">TimesformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/timesformer#transformers.TimesformerModel">TimesformerModel</a> (TimeSformer model)</li>
<li><a href="/docs/transformers/main/en/main_classes/backbones#transformers.TimmBackboneConfig">TimmBackboneConfig</a> configuration class: <a href="/docs/transformers/main/en/main_classes/backbones#transformers.TimmBackbone">TimmBackbone</a> (TimmBackbone model)</li>
<li><a href="/docs/transformers/main/en/model_doc/trajectory_transformer#transformers.TrajectoryTransformerConfig">TrajectoryTransformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/trajectory_transformer#transformers.TrajectoryTransformerModel">TrajectoryTransformerModel</a> (Trajectory Transformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TransfoXLModel">TransfoXLModel</a> (Transformer-XL model)</li>
<li><a href="/docs/transformers/main/en/model_doc/tvlt#transformers.TvltConfig">TvltConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/tvlt#transformers.TvltModel">TvltModel</a> (TVLT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpConfig">TvpConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/tvp#transformers.TvpModel">TvpModel</a> (TVP model)</li>
<li><a href="/docs/transformers/main/en/model_doc/umt5#transformers.UMT5Config">UMT5Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/umt5#transformers.UMT5Model">UMT5Model</a> (UMT5 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/udop#transformers.UdopConfig">UdopConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/udop#transformers.UdopModel">UdopModel</a> (UDOP model)</li>
<li><a href="/docs/transformers/main/en/model_doc/unispeech#transformers.UniSpeechConfig">UniSpeechConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/unispeech#transformers.UniSpeechModel">UniSpeechModel</a> (UniSpeech model)</li>
<li><a href="/docs/transformers/main/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig">UniSpeechSatConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/unispeech-sat#transformers.UniSpeechSatModel">UniSpeechSatModel</a> (UniSpeechSat model)</li>
<li><a href="/docs/transformers/main/en/model_doc/univnet#transformers.UnivNetConfig">UnivNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/univnet#transformers.UnivNetModel">UnivNetModel</a> (UnivNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/van#transformers.VanConfig">VanConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/van#transformers.VanModel">VanModel</a> (VAN model)</li>
<li><a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTModel">ViTModel</a> (ViT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/vit_hybrid#transformers.ViTHybridConfig">ViTHybridConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/vit_hybrid#transformers.ViTHybridModel">ViTHybridModel</a> (ViT Hybrid model)</li>
<li><a href="/docs/transformers/main/en/model_doc/vit_mae#transformers.ViTMAEConfig">ViTMAEConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/vit_mae#transformers.ViTMAEModel">ViTMAEModel</a> (ViTMAE model)</li>
<li><a href="/docs/transformers/main/en/model_doc/vit_msn#transformers.ViTMSNConfig">ViTMSNConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/vit_msn#transformers.ViTMSNModel">ViTMSNModel</a> (ViTMSN model)</li>
<li><a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEConfig">VideoMAEConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEModel">VideoMAEModel</a> (VideoMAE model)</li>
<li><a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltConfig">ViltConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltModel">ViltModel</a> (ViLT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderModel">VisionTextDualEncoderModel</a> (VisionTextDualEncoder model)</li>
<li><a href="/docs/transformers/main/en/model_doc/visual_bert#transformers.VisualBertConfig">VisualBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/visual_bert#transformers.VisualBertModel">VisualBertModel</a> (VisualBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/vitdet#transformers.VitDetConfig">VitDetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/vitdet#transformers.VitDetModel">VitDetModel</a> (VitDet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/vits#transformers.VitsConfig">VitsConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/vits#transformers.VitsModel">VitsModel</a> (VITS model)</li>
<li><a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitConfig">VivitConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitModel">VivitModel</a> (ViViT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertConfig">Wav2Vec2BertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertModel">Wav2Vec2BertModel</a> (Wav2Vec2-BERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Model">Wav2Vec2Model</a> (Wav2Vec2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerConfig">Wav2Vec2ConformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerModel">Wav2Vec2ConformerModel</a> (Wav2Vec2-Conformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/wavlm#transformers.WavLMConfig">WavLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/wavlm#transformers.WavLMModel">WavLMModel</a> (WavLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/whisper#transformers.WhisperConfig">WhisperConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/whisper#transformers.WhisperModel">WhisperModel</a> (Whisper model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xclip#transformers.XCLIPConfig">XCLIPConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xclip#transformers.XCLIPModel">XCLIPModel</a> (X-CLIP model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xglm#transformers.XGLMModel">XGLMModel</a> (XGLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMModel">XLMModel</a> (XLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetConfig">XLMProphetNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetModel">XLMProphetNetModel</a> (XLM-ProphetNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaModel">XLMRobertaModel</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLConfig">XLMRobertaXLConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLModel">XLMRobertaXLModel</a> (XLM-RoBERTa-XL model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetModel">XLNetModel</a> (XLNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xmod#transformers.XmodConfig">XmodConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xmod#transformers.XmodModel">XmodModel</a> (X-MOD model)</li>
<li><a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosConfig">YolosConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosModel">YolosModel</a> (YOLOS model)</li>
<li><a href="/docs/transformers/main/en/model_doc/yoso#transformers.YosoConfig">YosoConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/yoso#transformers.YosoModel">YosoModel</a> (YOSO model)</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModel.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),Ws=new $({props:{anchor:"transformers.AutoModel.from_config.example",$$slots:{default:[B4]},$$scope:{ctx:y}}}),rm=new x({props:{name:"from_pretrained",anchor:"transformers.AutoModel.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModel.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModel.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModel.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModel.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModel.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModel.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModel.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModel.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModel.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModel.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModel.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),Ps=new $({props:{anchor:"transformers.AutoModel.from_pretrained.example",$$slots:{default:[A4]},$$scope:{ctx:y}}}),nm=new B({props:{title:"TFAutoModel",local:"transformers.TFAutoModel",headingTag:"h3"}}),tm=new x({props:{name:"class transformers.TFAutoModel",anchor:"transformers.TFAutoModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_tf_auto.py#L531"}}),am=new x({props:{name:"from_config",anchor:"transformers.TFAutoModel.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModel.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/albert#transformers.TFAlbertModel">TFAlbertModel</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bart#transformers.TFBartModel">TFBartModel</a> (BART model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bert#transformers.TFBertModel">TFBertModel</a> (BERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/blenderbot#transformers.TFBlenderbotModel">TFBlenderbotModel</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/main/en/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/blenderbot-small#transformers.TFBlenderbotSmallModel">TFBlenderbotSmallModel</a> (BlenderbotSmall model)</li>
<li><a href="/docs/transformers/main/en/model_doc/blip#transformers.BlipConfig">BlipConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/blip#transformers.TFBlipModel">TFBlipModel</a> (BLIP model)</li>
<li><a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPConfig">CLIPConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/clip#transformers.TFCLIPModel">TFCLIPModel</a> (CLIP model)</li>
<li><a href="/docs/transformers/main/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/ctrl#transformers.TFCTRLModel">TFCTRLModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/camembert#transformers.TFCamembertModel">TFCamembertModel</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/convbert#transformers.TFConvBertModel">TFConvBertModel</a> (ConvBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/convnext#transformers.ConvNextConfig">ConvNextConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/convnext#transformers.TFConvNextModel">TFConvNextModel</a> (ConvNeXT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/convnextv2#transformers.ConvNextV2Config">ConvNextV2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/convnextv2#transformers.TFConvNextV2Model">TFConvNextV2Model</a> (ConvNeXTV2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/cvt#transformers.CvtConfig">CvtConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/cvt#transformers.TFCvtModel">TFCvtModel</a> (CvT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/dpr#transformers.DPRConfig">DPRConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/dpr#transformers.TFDPRQuestionEncoder">TFDPRQuestionEncoder</a> (DPR model)</li>
<li><a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecVisionConfig">Data2VecVisionConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.TFData2VecVisionModel">TFData2VecVisionModel</a> (Data2VecVision model)</li>
<li><a href="/docs/transformers/main/en/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/deberta#transformers.TFDebertaModel">TFDebertaModel</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.TFDebertaV2Model">TFDebertaV2Model</a> (DeBERTa-v2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/deit#transformers.TFDeiTModel">TFDeiTModel</a> (DeiT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.TFDistilBertModel">TFDistilBertModel</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/efficientformer#transformers.TFEfficientFormerModel">TFEfficientFormerModel</a> (EfficientFormer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/electra#transformers.TFElectraModel">TFElectraModel</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/esm#transformers.EsmConfig">EsmConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/esm#transformers.TFEsmModel">TFEsmModel</a> (ESM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.TFFlaubertModel">TFFlaubertModel</a> (FlauBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/funnel#transformers.TFFunnelModel">TFFunnelModel</a> or <a href="/docs/transformers/main/en/model_doc/funnel#transformers.TFFunnelBaseModel">TFFunnelBaseModel</a> (Funnel Transformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.TFGPT2Model">TFGPT2Model</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gptj#transformers.TFGPTJModel">TFGPTJModel</a> (GPT-J model)</li>
<li><a href="/docs/transformers/main/en/model_doc/groupvit#transformers.GroupViTConfig">GroupViTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/groupvit#transformers.TFGroupViTModel">TFGroupViTModel</a> (GroupViT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertConfig">HubertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/hubert#transformers.TFHubertModel">TFHubertModel</a> (Hubert model)</li>
<li><a href="/docs/transformers/main/en/model_doc/led#transformers.LEDConfig">LEDConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/led#transformers.TFLEDModel">TFLEDModel</a> (LED model)</li>
<li><a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.TFLayoutLMModel">TFLayoutLMModel</a> (LayoutLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.LayoutLMv3Config">LayoutLMv3Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/layoutlmv3#transformers.TFLayoutLMv3Model">TFLayoutLMv3Model</a> (LayoutLMv3 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/longformer#transformers.LongformerConfig">LongformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/longformer#transformers.TFLongformerModel">TFLongformerModel</a> (Longformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/lxmert#transformers.LxmertConfig">LxmertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/lxmert#transformers.TFLxmertModel">TFLxmertModel</a> (LXMERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mbart#transformers.TFMBartModel">TFMBartModel</a> (mBART model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.TFMPNetModel">TFMPNetModel</a> (MPNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Config">MT5Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mt5#transformers.TFMT5Model">TFMT5Model</a> (MT5 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/marian#transformers.TFMarianModel">TFMarianModel</a> (Marian model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.TFMobileBertModel">TFMobileBertModel</a> (MobileBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mobilevit#transformers.MobileViTConfig">MobileViTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mobilevit#transformers.TFMobileViTModel">TFMobileViTModel</a> (MobileViT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/opt#transformers.TFOPTModel">TFOPTModel</a> (OPT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.TFOpenAIGPTModel">TFOpenAIGPTModel</a> (OpenAI GPT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/pegasus#transformers.PegasusConfig">PegasusConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/pegasus#transformers.TFPegasusModel">TFPegasusModel</a> (Pegasus model)</li>
<li><a href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/regnet#transformers.TFRegNetModel">TFRegNetModel</a> (RegNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/rembert#transformers.TFRemBertModel">TFRemBertModel</a> (RemBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/resnet#transformers.ResNetConfig">ResNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/resnet#transformers.TFResNetModel">TFResNetModel</a> (ResNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roformer#transformers.TFRoFormerModel">TFRoFormerModel</a> (RoFormer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta#transformers.TFRobertaModel">TFRobertaModel</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormModel">TFRobertaPreLayerNormModel</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/main/en/model_doc/sam#transformers.SamConfig">SamConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/sam#transformers.TFSamModel">TFSamModel</a> (SAM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/segformer#transformers.SegformerConfig">SegformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/segformer#transformers.TFSegformerModel">TFSegformerModel</a> (SegFormer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/speech_to_text#transformers.Speech2TextConfig">Speech2TextConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/speech_to_text#transformers.TFSpeech2TextModel">TFSpeech2TextModel</a> (Speech2Text model)</li>
<li><a href="/docs/transformers/main/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/swin#transformers.TFSwinModel">TFSwinModel</a> (Swin Transformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/t5#transformers.T5Config">T5Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/t5#transformers.TFT5Model">TFT5Model</a> (T5 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TFTapasModel">TFTapasModel</a> (TAPAS model)</li>
<li><a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TFTransfoXLModel">TFTransfoXLModel</a> (Transformer-XL model)</li>
<li><a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/vit#transformers.TFViTModel">TFViTModel</a> (ViT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/vit_mae#transformers.ViTMAEConfig">ViTMAEConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/vit_mae#transformers.TFViTMAEModel">TFViTMAEModel</a> (ViTMAE model)</li>
<li><a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.TFVisionTextDualEncoderModel">TFVisionTextDualEncoderModel</a> (VisionTextDualEncoder model)</li>
<li><a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.TFWav2Vec2Model">TFWav2Vec2Model</a> (Wav2Vec2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/whisper#transformers.WhisperConfig">WhisperConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/whisper#transformers.TFWhisperModel">TFWhisperModel</a> (Whisper model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xglm#transformers.TFXGLMModel">TFXGLMModel</a> (XGLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm#transformers.TFXLMModel">TFXLMModel</a> (XLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.TFXLMRobertaModel">TFXLMRobertaModel</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.TFXLNetModel">TFXLNetModel</a> (XLNet model)</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModel.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),Vs=new $({props:{anchor:"transformers.TFAutoModel.from_config.example",$$slots:{default:[j4]},$$scope:{ctx:y}}}),sm=new x({props:{name:"from_pretrained",anchor:"transformers.TFAutoModel.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModel.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.TFAutoModel.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.TFAutoModel.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.TFAutoModel.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.TFAutoModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.TFAutoModel.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.TFAutoModel.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.TFAutoModel.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.TFAutoModel.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.TFAutoModel.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.TFAutoModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.TFAutoModel.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.TFAutoModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),Js=new $({props:{anchor:"transformers.TFAutoModel.from_pretrained.example",$$slots:{default:[Z4]},$$scope:{ctx:y}}}),im=new B({props:{title:"FlaxAutoModel",local:"transformers.FlaxAutoModel",headingTag:"h3"}}),lm=new x({props:{name:"class transformers.FlaxAutoModel",anchor:"transformers.FlaxAutoModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_flax_auto.py#L280"}}),dm=new x({props:{name:"from_config",anchor:"transformers.FlaxAutoModel.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModel.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/albert#transformers.FlaxAlbertModel">FlaxAlbertModel</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bart#transformers.FlaxBartModel">FlaxBartModel</a> (BART model)</li>
<li><a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/beit#transformers.FlaxBeitModel">FlaxBeitModel</a> (BEiT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bert#transformers.FlaxBertModel">FlaxBertModel</a> (BERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.FlaxBigBirdModel">FlaxBigBirdModel</a> (BigBird model)</li>
<li><a href="/docs/transformers/main/en/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/blenderbot#transformers.FlaxBlenderbotModel">FlaxBlenderbotModel</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/main/en/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/blenderbot-small#transformers.FlaxBlenderbotSmallModel">FlaxBlenderbotSmallModel</a> (BlenderbotSmall model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bloom#transformers.FlaxBloomModel">FlaxBloomModel</a> (BLOOM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPConfig">CLIPConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/clip#transformers.FlaxCLIPModel">FlaxCLIPModel</a> (CLIP model)</li>
<li><a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.FlaxDistilBertModel">FlaxDistilBertModel</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/electra#transformers.FlaxElectraModel">FlaxElectraModel</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.FlaxGPT2Model">FlaxGPT2Model</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gptj#transformers.FlaxGPTJModel">FlaxGPTJModel</a> (GPT-J model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt_neo#transformers.GPTNeoConfig">GPTNeoConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt_neo#transformers.FlaxGPTNeoModel">FlaxGPTNeoModel</a> (GPT Neo model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gemma#transformers.GemmaConfig">GemmaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gemma#transformers.FlaxGemmaModel">FlaxGemmaModel</a> (Gemma model)</li>
<li><a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaConfig">LlamaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/llama#transformers.FlaxLlamaModel">FlaxLlamaModel</a> (LLaMA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/longt5#transformers.LongT5Config">LongT5Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/longt5#transformers.FlaxLongT5Model">FlaxLongT5Model</a> (LongT5 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mbart#transformers.FlaxMBartModel">FlaxMBartModel</a> (mBART model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Config">MT5Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mt5#transformers.FlaxMT5Model">FlaxMT5Model</a> (MT5 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/marian#transformers.FlaxMarianModel">FlaxMarianModel</a> (Marian model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mistral#transformers.MistralConfig">MistralConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mistral#transformers.FlaxMistralModel">FlaxMistralModel</a> (Mistral model)</li>
<li><a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/opt#transformers.FlaxOPTModel">FlaxOPTModel</a> (OPT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/pegasus#transformers.PegasusConfig">PegasusConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/pegasus#transformers.FlaxPegasusModel">FlaxPegasusModel</a> (Pegasus model)</li>
<li><a href="/docs/transformers/main/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/regnet#transformers.FlaxRegNetModel">FlaxRegNetModel</a> (RegNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/resnet#transformers.ResNetConfig">ResNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/resnet#transformers.FlaxResNetModel">FlaxResNetModel</a> (ResNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roformer#transformers.FlaxRoFormerModel">FlaxRoFormerModel</a> (RoFormer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta#transformers.FlaxRobertaModel">FlaxRobertaModel</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormModel">FlaxRobertaPreLayerNormModel</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/main/en/model_doc/t5#transformers.T5Config">T5Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/t5#transformers.FlaxT5Model">FlaxT5Model</a> (T5 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/vit#transformers.FlaxViTModel">FlaxViTModel</a> (ViT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.FlaxVisionTextDualEncoderModel">FlaxVisionTextDualEncoderModel</a> (VisionTextDualEncoder model)</li>
<li><a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.FlaxWav2Vec2Model">FlaxWav2Vec2Model</a> (Wav2Vec2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/whisper#transformers.WhisperConfig">WhisperConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/whisper#transformers.FlaxWhisperModel">FlaxWhisperModel</a> (Whisper model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xglm#transformers.FlaxXGLMModel">FlaxXGLMModel</a> (XGLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaModel">FlaxXLMRobertaModel</a> (XLM-RoBERTa model)</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModel.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),Es=new $({props:{anchor:"transformers.FlaxAutoModel.from_config.example",$$slots:{default:[R4]},$$scope:{ctx:y}}}),mm=new x({props:{name:"from_pretrained",anchor:"transformers.FlaxAutoModel.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModel.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.FlaxAutoModel.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.FlaxAutoModel.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.FlaxAutoModel.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.FlaxAutoModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.FlaxAutoModel.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.FlaxAutoModel.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.FlaxAutoModel.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.FlaxAutoModel.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.FlaxAutoModel.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.FlaxAutoModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.FlaxAutoModel.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.FlaxAutoModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),Is=new $({props:{anchor:"transformers.FlaxAutoModel.from_pretrained.example",$$slots:{default:[S4]},$$scope:{ctx:y}}}),cm=new B({props:{title:"Generic pretraining classes",local:"generic-pretraining-classes",headingTag:"h2"}}),gm=new B({props:{title:"AutoModelForPreTraining",local:"transformers.AutoModelForPreTraining",headingTag:"h3"}}),hm=new x({props:{name:"class transformers.AutoModelForPreTraining",anchor:"transformers.AutoModelForPreTraining",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_auto.py#L1415"}}),pm=new x({props:{name:"from_config",anchor:"transformers.AutoModelForPreTraining.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForPreTraining.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertForPreTraining">AlbertForPreTraining</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertForPreTraining">BertForPreTraining</a> (BERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdForPreTraining">BigBirdForPreTraining</a> (BigBird model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bloom#transformers.BloomForCausalLM">BloomForCausalLM</a> (BLOOM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/ctrl#transformers.CTRLLMHeadModel">CTRLLMHeadModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertForMaskedLM">CamembertForMaskedLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecTextForMaskedLM">Data2VecTextForMaskedLM</a> (Data2VecText model)</li>
<li><a href="/docs/transformers/main/en/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/deberta#transformers.DebertaForMaskedLM">DebertaForMaskedLM</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.DebertaV2ForMaskedLM">DebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertForMaskedLM">DistilBertForMaskedLM</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraForPreTraining">ElectraForPreTraining</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/ernie#transformers.ErnieForPreTraining">ErnieForPreTraining</a> (ERNIE model)</li>
<li><a href="/docs/transformers/main/en/model_doc/fnet#transformers.FNetConfig">FNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/fnet#transformers.FNetForPreTraining">FNetForPreTraining</a> (FNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/fsmt#transformers.FSMTConfig">FSMTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/fsmt#transformers.FSMTForConditionalGeneration">FSMTForConditionalGeneration</a> (FairSeq Machine-Translation model)</li>
<li><a href="/docs/transformers/main/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.FlaubertWithLMHeadModel">FlaubertWithLMHeadModel</a> (FlauBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/flava#transformers.FlavaConfig">FlavaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/flava#transformers.FlavaForPreTraining">FlavaForPreTraining</a> (FLAVA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelForPreTraining">FunnelForPreTraining</a> (Funnel Transformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2LMHeadModel">GPT2LMHeadModel</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeConfig">GPTBigCodeConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForCausalLM">GPTBigCodeForCausalLM</a> (GPTBigCode model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseConfig">GPTSanJapaneseConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseForConditionalGeneration">GPTSanJapaneseForConditionalGeneration</a> (GPTSAN-japanese model)</li>
<li><a href="/docs/transformers/main/en/model_doc/ibert#transformers.IBertConfig">IBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/ibert#transformers.IBertForMaskedLM">IBertForMaskedLM</a> (I-BERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsConfig">IdeficsConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsForVisionText2Text">IdeficsForVisionText2Text</a> (IDEFICS model)</li>
<li><a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.LayoutLMForMaskedLM">LayoutLMForMaskedLM</a> (LayoutLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaConfig">LlavaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaForConditionalGeneration">LlavaForConditionalGeneration</a> (LLaVa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextConfig">LlavaNextConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextForConditionalGeneration">LlavaNextForConditionalGeneration</a> (LLaVA-NeXT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/longformer#transformers.LongformerConfig">LongformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/longformer#transformers.LongformerForMaskedLM">LongformerForMaskedLM</a> (Longformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/luke#transformers.LukeConfig">LukeConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/luke#transformers.LukeForMaskedLM">LukeForMaskedLM</a> (LUKE model)</li>
<li><a href="/docs/transformers/main/en/model_doc/lxmert#transformers.LxmertConfig">LxmertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/lxmert#transformers.LxmertForPreTraining">LxmertForPreTraining</a> (LXMERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.MPNetForMaskedLM">MPNetForMaskedLM</a> (MPNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mamba#transformers.MambaConfig">MambaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mamba#transformers.MambaForCausalLM">MambaForCausalLM</a> (Mamba model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mega#transformers.MegaForMaskedLM">MegaForMaskedLM</a> (MEGA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/megatron-bert#transformers.MegatronBertConfig">MegatronBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/megatron-bert#transformers.MegatronBertForPreTraining">MegatronBertForPreTraining</a> (Megatron-BERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertForPreTraining">MobileBertForPreTraining</a> (MobileBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig">MptConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptForCausalLM">MptForCausalLM</a> (MPT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mra#transformers.MraConfig">MraConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mra#transformers.MraForMaskedLM">MraForMaskedLM</a> (MRA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mvp#transformers.MvpConfig">MvpConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mvp#transformers.MvpForConditionalGeneration">MvpForConditionalGeneration</a> (MVP model)</li>
<li><a href="/docs/transformers/main/en/model_doc/nezha#transformers.NezhaConfig">NezhaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/nezha#transformers.NezhaForPreTraining">NezhaForPreTraining</a> (Nezha model)</li>
<li><a href="/docs/transformers/main/en/model_doc/nllb-moe#transformers.NllbMoeConfig">NllbMoeConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/nllb-moe#transformers.NllbMoeForConditionalGeneration">NllbMoeForConditionalGeneration</a> (NLLB-MOE model)</li>
<li><a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTLMHeadModel">OpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/retribert#transformers.RetriBertConfig">RetriBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/retribert#transformers.RetriBertModel">RetriBertModel</a> (RetriBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roc_bert#transformers.RoCBertConfig">RoCBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roc_bert#transformers.RoCBertForPreTraining">RoCBertForPreTraining</a> (RoCBert model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaForMaskedLM">RobertaForMaskedLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForMaskedLM">RobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/main/en/model_doc/rwkv#transformers.RwkvConfig">RwkvConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/rwkv#transformers.RwkvForCausalLM">RwkvForCausalLM</a> (RWKV model)</li>
<li><a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterConfig">SplinterConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterForPreTraining">SplinterForPreTraining</a> (Splinter model)</li>
<li><a href="/docs/transformers/main/en/model_doc/squeezebert#transformers.SqueezeBertConfig">SqueezeBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/squeezebert#transformers.SqueezeBertForMaskedLM">SqueezeBertForMaskedLM</a> (SqueezeBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig">SwitchTransformersConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersForConditionalGeneration">SwitchTransformersForConditionalGeneration</a> (SwitchTransformers model)</li>
<li><a href="/docs/transformers/main/en/model_doc/t5#transformers.T5Config">T5Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5ForConditionalGeneration">T5ForConditionalGeneration</a> (T5 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasForMaskedLM">TapasForMaskedLM</a> (TAPAS model)</li>
<li><a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TransfoXLLMHeadModel">TransfoXLLMHeadModel</a> (Transformer-XL model)</li>
<li><a href="/docs/transformers/main/en/model_doc/tvlt#transformers.TvltConfig">TvltConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/tvlt#transformers.TvltForPreTraining">TvltForPreTraining</a> (TVLT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/unispeech#transformers.UniSpeechConfig">UniSpeechConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/unispeech#transformers.UniSpeechForPreTraining">UniSpeechForPreTraining</a> (UniSpeech model)</li>
<li><a href="/docs/transformers/main/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig">UniSpeechSatConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/unispeech-sat#transformers.UniSpeechSatForPreTraining">UniSpeechSatForPreTraining</a> (UniSpeechSat model)</li>
<li><a href="/docs/transformers/main/en/model_doc/vit_mae#transformers.ViTMAEConfig">ViTMAEConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/vit_mae#transformers.ViTMAEForPreTraining">ViTMAEForPreTraining</a> (ViTMAE model)</li>
<li><a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEConfig">VideoMAEConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEForPreTraining">VideoMAEForPreTraining</a> (VideoMAE model)</li>
<li><a href="/docs/transformers/main/en/model_doc/vipllava#transformers.VipLlavaConfig">VipLlavaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/vipllava#transformers.VipLlavaForConditionalGeneration">VipLlavaForConditionalGeneration</a> (VipLlava model)</li>
<li><a href="/docs/transformers/main/en/model_doc/visual_bert#transformers.VisualBertConfig">VisualBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/visual_bert#transformers.VisualBertForPreTraining">VisualBertForPreTraining</a> (VisualBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForPreTraining">Wav2Vec2ForPreTraining</a> (Wav2Vec2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerConfig">Wav2Vec2ConformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerForPreTraining">Wav2Vec2ConformerForPreTraining</a> (Wav2Vec2-Conformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMWithLMHeadModel">XLMWithLMHeadModel</a> (XLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaForMaskedLM">XLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLConfig">XLMRobertaXLConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForMaskedLM">XLMRobertaXLForMaskedLM</a> (XLM-RoBERTa-XL model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetLMHeadModel">XLNetLMHeadModel</a> (XLNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xmod#transformers.XmodConfig">XmodConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xmod#transformers.XmodForMaskedLM">XmodForMaskedLM</a> (X-MOD model)</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForPreTraining.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),Us=new $({props:{anchor:"transformers.AutoModelForPreTraining.from_config.example",$$slots:{default:[G4]},$$scope:{ctx:y}}}),um=new x({props:{name:"from_pretrained",anchor:"transformers.AutoModelForPreTraining.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForPreTraining.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),Ns=new $({props:{anchor:"transformers.AutoModelForPreTraining.from_pretrained.example",$$slots:{default:[W4]},$$scope:{ctx:y}}}),_m=new B({props:{title:"TFAutoModelForPreTraining",local:"transformers.TFAutoModelForPreTraining",headingTag:"h3"}}),bm=new x({props:{name:"class transformers.TFAutoModelForPreTraining",anchor:"transformers.TFAutoModelForPreTraining",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_tf_auto.py#L547"}}),Mm=new x({props:{name:"from_config",anchor:"transformers.TFAutoModelForPreTraining.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForPreTraining.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/albert#transformers.TFAlbertForPreTraining">TFAlbertForPreTraining</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bart#transformers.TFBartForConditionalGeneration">TFBartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bert#transformers.TFBertForPreTraining">TFBertForPreTraining</a> (BERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/ctrl#transformers.TFCTRLLMHeadModel">TFCTRLLMHeadModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/camembert#transformers.TFCamembertForMaskedLM">TFCamembertForMaskedLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.TFDistilBertForMaskedLM">TFDistilBertForMaskedLM</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/electra#transformers.TFElectraForPreTraining">TFElectraForPreTraining</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.TFFlaubertWithLMHeadModel">TFFlaubertWithLMHeadModel</a> (FlauBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/funnel#transformers.TFFunnelForPreTraining">TFFunnelForPreTraining</a> (Funnel Transformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.TFGPT2LMHeadModel">TFGPT2LMHeadModel</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.TFLayoutLMForMaskedLM">TFLayoutLMForMaskedLM</a> (LayoutLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/lxmert#transformers.LxmertConfig">LxmertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/lxmert#transformers.TFLxmertForPreTraining">TFLxmertForPreTraining</a> (LXMERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.TFMPNetForMaskedLM">TFMPNetForMaskedLM</a> (MPNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.TFMobileBertForPreTraining">TFMobileBertForPreTraining</a> (MobileBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.TFOpenAIGPTLMHeadModel">TFOpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta#transformers.TFRobertaForMaskedLM">TFRobertaForMaskedLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForMaskedLM">TFRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/main/en/model_doc/t5#transformers.T5Config">T5Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/t5#transformers.TFT5ForConditionalGeneration">TFT5ForConditionalGeneration</a> (T5 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TFTapasForMaskedLM">TFTapasForMaskedLM</a> (TAPAS model)</li>
<li><a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TFTransfoXLLMHeadModel">TFTransfoXLLMHeadModel</a> (Transformer-XL model)</li>
<li><a href="/docs/transformers/main/en/model_doc/vit_mae#transformers.ViTMAEConfig">ViTMAEConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/vit_mae#transformers.TFViTMAEForPreTraining">TFViTMAEForPreTraining</a> (ViTMAE model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm#transformers.TFXLMWithLMHeadModel">TFXLMWithLMHeadModel</a> (XLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForMaskedLM">TFXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.TFXLNetLMHeadModel">TFXLNetLMHeadModel</a> (XLNet model)</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForPreTraining.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),qs=new $({props:{anchor:"transformers.TFAutoModelForPreTraining.from_config.example",$$slots:{default:[P4]},$$scope:{ctx:y}}}),Fm=new x({props:{name:"from_pretrained",anchor:"transformers.TFAutoModelForPreTraining.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),Xs=new $({props:{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.example",$$slots:{default:[V4]},$$scope:{ctx:y}}}),Tm=new B({props:{title:"FlaxAutoModelForPreTraining",local:"transformers.FlaxAutoModelForPreTraining",headingTag:"h3"}}),Cm=new x({props:{name:"class transformers.FlaxAutoModelForPreTraining",anchor:"transformers.FlaxAutoModelForPreTraining",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_flax_auto.py#L287"}}),ym=new x({props:{name:"from_config",anchor:"transformers.FlaxAutoModelForPreTraining.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForPreTraining.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/albert#transformers.FlaxAlbertForPreTraining">FlaxAlbertForPreTraining</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bart#transformers.FlaxBartForConditionalGeneration">FlaxBartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bert#transformers.FlaxBertForPreTraining">FlaxBertForPreTraining</a> (BERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.FlaxBigBirdForPreTraining">FlaxBigBirdForPreTraining</a> (BigBird model)</li>
<li><a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/electra#transformers.FlaxElectraForPreTraining">FlaxElectraForPreTraining</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/longt5#transformers.LongT5Config">LongT5Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/longt5#transformers.FlaxLongT5ForConditionalGeneration">FlaxLongT5ForConditionalGeneration</a> (LongT5 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mbart#transformers.FlaxMBartForConditionalGeneration">FlaxMBartForConditionalGeneration</a> (mBART model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Config">MT5Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mt5#transformers.FlaxMT5ForConditionalGeneration">FlaxMT5ForConditionalGeneration</a> (MT5 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roformer#transformers.FlaxRoFormerForMaskedLM">FlaxRoFormerForMaskedLM</a> (RoFormer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta#transformers.FlaxRobertaForMaskedLM">FlaxRobertaForMaskedLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForMaskedLM">FlaxRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/main/en/model_doc/t5#transformers.T5Config">T5Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/t5#transformers.FlaxT5ForConditionalGeneration">FlaxT5ForConditionalGeneration</a> (T5 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.FlaxWav2Vec2ForPreTraining">FlaxWav2Vec2ForPreTraining</a> (Wav2Vec2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/whisper#transformers.WhisperConfig">WhisperConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/whisper#transformers.FlaxWhisperForConditionalGeneration">FlaxWhisperForConditionalGeneration</a> (Whisper model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForMaskedLM">FlaxXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),Ds=new $({props:{anchor:"transformers.FlaxAutoModelForPreTraining.from_config.example",$$slots:{default:[J4]},$$scope:{ctx:y}}}),vm=new x({props:{name:"from_pretrained",anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),Qs=new $({props:{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.example",$$slots:{default:[E4]},$$scope:{ctx:y}}}),wm=new B({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),Lm=new B({props:{title:"AutoModelForCausalLM",local:"transformers.AutoModelForCausalLM",headingTag:"h3"}}),km=new x({props:{name:"class transformers.AutoModelForCausalLM",anchor:"transformers.AutoModelForCausalLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_auto.py#L1430"}}),$m=new x({props:{name:"from_config",anchor:"transformers.AutoModelForCausalLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForCausalLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bart#transformers.BartForCausalLM">BartForCausalLM</a> (BART model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertLMHeadModel">BertLMHeadModel</a> (BERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bert-generation#transformers.BertGenerationConfig">BertGenerationConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bert-generation#transformers.BertGenerationDecoder">BertGenerationDecoder</a> (Bert Generation model)</li>
<li><a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdForCausalLM">BigBirdForCausalLM</a> (BigBird model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusConfig">BigBirdPegasusConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForCausalLM">BigBirdPegasusForCausalLM</a> (BigBird-Pegasus model)</li>
<li><a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig">BioGptConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptForCausalLM">BioGptForCausalLM</a> (BioGpt model)</li>
<li><a href="/docs/transformers/main/en/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/blenderbot#transformers.BlenderbotForCausalLM">BlenderbotForCausalLM</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/main/en/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/blenderbot-small#transformers.BlenderbotSmallForCausalLM">BlenderbotSmallForCausalLM</a> (BlenderbotSmall model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bloom#transformers.BloomForCausalLM">BloomForCausalLM</a> (BLOOM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/ctrl#transformers.CTRLLMHeadModel">CTRLLMHeadModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertForCausalLM">CamembertForCausalLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/codegen#transformers.CodeGenConfig">CodeGenConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/codegen#transformers.CodeGenForCausalLM">CodeGenForCausalLM</a> (CodeGen model)</li>
<li><a href="/docs/transformers/main/en/model_doc/cohere#transformers.CohereConfig">CohereConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/cohere#transformers.CohereForCausalLM">CohereForCausalLM</a> (Cohere model)</li>
<li><a href="/docs/transformers/main/en/model_doc/cpmant#transformers.CpmAntConfig">CpmAntConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/cpmant#transformers.CpmAntForCausalLM">CpmAntForCausalLM</a> (CPM-Ant model)</li>
<li><a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecTextForCausalLM">Data2VecTextForCausalLM</a> (Data2VecText model)</li>
<li><a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraForCausalLM">ElectraForCausalLM</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/ernie#transformers.ErnieForCausalLM">ErnieForCausalLM</a> (ERNIE model)</li>
<li><a href="/docs/transformers/main/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/falcon#transformers.FalconForCausalLM">FalconForCausalLM</a> (Falcon model)</li>
<li><a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuConfig">FuyuConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuForCausalLM">FuyuForCausalLM</a> (Fuyu model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2LMHeadModel">GPT2LMHeadModel</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeConfig">GPTBigCodeConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForCausalLM">GPTBigCodeForCausalLM</a> (GPTBigCode model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gptj#transformers.GPTJForCausalLM">GPTJForCausalLM</a> (GPT-J model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt_neo#transformers.GPTNeoConfig">GPTNeoConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt_neo#transformers.GPTNeoForCausalLM">GPTNeoForCausalLM</a> (GPT Neo model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt_neox#transformers.GPTNeoXConfig">GPTNeoXConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt_neox#transformers.GPTNeoXForCausalLM">GPTNeoXForCausalLM</a> (GPT NeoX model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseConfig">GPTNeoXJapaneseConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseForCausalLM">GPTNeoXJapaneseForCausalLM</a> (GPT NeoX Japanese model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gemma#transformers.GemmaConfig">GemmaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gemma#transformers.GemmaForCausalLM">GemmaForCausalLM</a> (Gemma model)</li>
<li><a href="/docs/transformers/main/en/model_doc/git#transformers.GitConfig">GitConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/git#transformers.GitForCausalLM">GitForCausalLM</a> (GIT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaConfig">LlamaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaForCausalLM">LlamaForCausalLM</a> (LLaMA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBartForCausalLM">MBartForCausalLM</a> (mBART model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mamba#transformers.MambaConfig">MambaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mamba#transformers.MambaForCausalLM">MambaForCausalLM</a> (Mamba model)</li>
<li><a href="/docs/transformers/main/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/marian#transformers.MarianForCausalLM">MarianForCausalLM</a> (Marian model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mega#transformers.MegaForCausalLM">MegaForCausalLM</a> (MEGA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/megatron-bert#transformers.MegatronBertConfig">MegatronBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/megatron-bert#transformers.MegatronBertForCausalLM">MegatronBertForCausalLM</a> (Megatron-BERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mistral#transformers.MistralConfig">MistralConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mistral#transformers.MistralForCausalLM">MistralForCausalLM</a> (Mistral model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mixtral#transformers.MixtralConfig">MixtralConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mixtral#transformers.MixtralForCausalLM">MixtralForCausalLM</a> (Mixtral model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig">MptConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptForCausalLM">MptForCausalLM</a> (MPT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenForCausalLM">MusicgenForCausalLM</a> (MusicGen model)</li>
<li><a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig">MusicgenMelodyConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForCausalLM">MusicgenMelodyForCausalLM</a> (MusicGen Melody model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mvp#transformers.MvpConfig">MvpConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mvp#transformers.MvpForCausalLM">MvpForCausalLM</a> (MVP model)</li>
<li><a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTForCausalLM">OPTForCausalLM</a> (OPT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTLMHeadModel">OpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/open-llama#transformers.OpenLlamaConfig">OpenLlamaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/open-llama#transformers.OpenLlamaForCausalLM">OpenLlamaForCausalLM</a> (OpenLlama model)</li>
<li><a href="/docs/transformers/main/en/model_doc/plbart#transformers.PLBartConfig">PLBartConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/plbart#transformers.PLBartForCausalLM">PLBartForCausalLM</a> (PLBart model)</li>
<li><a href="/docs/transformers/main/en/model_doc/pegasus#transformers.PegasusConfig">PegasusConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/pegasus#transformers.PegasusForCausalLM">PegasusForCausalLM</a> (Pegasus model)</li>
<li><a href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonConfig">PersimmonConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonForCausalLM">PersimmonForCausalLM</a> (Persimmon model)</li>
<li><a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiConfig">PhiConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiForCausalLM">PhiForCausalLM</a> (Phi model)</li>
<li><a href="/docs/transformers/main/en/model_doc/prophetnet#transformers.ProphetNetConfig">ProphetNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/prophetnet#transformers.ProphetNetForCausalLM">ProphetNetForCausalLM</a> (ProphetNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/qdqbert#transformers.QDQBertConfig">QDQBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/qdqbert#transformers.QDQBertLMHeadModel">QDQBertLMHeadModel</a> (QDQBert model)</li>
<li><a href="/docs/transformers/main/en/model_doc/qwen2#transformers.Qwen2Config">Qwen2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/qwen2#transformers.Qwen2ForCausalLM">Qwen2ForCausalLM</a> (Qwen2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/qwen2_moe#transformers.Qwen2MoeConfig">Qwen2MoeConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/qwen2_moe#transformers.Qwen2MoeForCausalLM">Qwen2MoeForCausalLM</a> (Qwen2MoE model)</li>
<li><a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerModelWithLMHead">ReformerModelWithLMHead</a> (Reformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/rembert#transformers.RemBertForCausalLM">RemBertForCausalLM</a> (RemBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roc_bert#transformers.RoCBertConfig">RoCBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roc_bert#transformers.RoCBertForCausalLM">RoCBertForCausalLM</a> (RoCBert model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerForCausalLM">RoFormerForCausalLM</a> (RoFormer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaForCausalLM">RobertaForCausalLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForCausalLM">RobertaPreLayerNormForCausalLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/main/en/model_doc/rwkv#transformers.RwkvConfig">RwkvConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/rwkv#transformers.RwkvForCausalLM">RwkvForCausalLM</a> (RWKV model)</li>
<li><a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2Config">Speech2Text2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2ForCausalLM">Speech2Text2ForCausalLM</a> (Speech2Text2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmConfig">StableLmConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmForCausalLM">StableLmForCausalLM</a> (StableLm model)</li>
<li><a href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2Config">Starcoder2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2ForCausalLM">Starcoder2ForCausalLM</a> (Starcoder2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/trocr#transformers.TrOCRConfig">TrOCRConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/trocr#transformers.TrOCRForCausalLM">TrOCRForCausalLM</a> (TrOCR model)</li>
<li><a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TransfoXLLMHeadModel">TransfoXLLMHeadModel</a> (Transformer-XL model)</li>
<li><a href="/docs/transformers/main/en/model_doc/whisper#transformers.WhisperConfig">WhisperConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/whisper#transformers.WhisperForCausalLM">WhisperForCausalLM</a> (Whisper model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xglm#transformers.XGLMForCausalLM">XGLMForCausalLM</a> (XGLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMWithLMHeadModel">XLMWithLMHeadModel</a> (XLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetConfig">XLMProphetNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetForCausalLM">XLMProphetNetForCausalLM</a> (XLM-ProphetNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaForCausalLM">XLMRobertaForCausalLM</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLConfig">XLMRobertaXLConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForCausalLM">XLMRobertaXLForCausalLM</a> (XLM-RoBERTa-XL model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetLMHeadModel">XLNetLMHeadModel</a> (XLNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xmod#transformers.XmodConfig">XmodConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xmod#transformers.XmodForCausalLM">XmodForCausalLM</a> (X-MOD model)</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForCausalLM.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),Hs=new $({props:{anchor:"transformers.AutoModelForCausalLM.from_config.example",$$slots:{default:[I4]},$$scope:{ctx:y}}}),Bm=new x({props:{name:"from_pretrained",anchor:"transformers.AutoModelForCausalLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForCausalLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),Ys=new $({props:{anchor:"transformers.AutoModelForCausalLM.from_pretrained.example",$$slots:{default:[U4]},$$scope:{ctx:y}}}),Am=new B({props:{title:"TFAutoModelForCausalLM",local:"transformers.TFAutoModelForCausalLM",headingTag:"h3"}}),jm=new x({props:{name:"class transformers.TFAutoModelForCausalLM",anchor:"transformers.TFAutoModelForCausalLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_tf_auto.py#L562"}}),Zm=new x({props:{name:"from_config",anchor:"transformers.TFAutoModelForCausalLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForCausalLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bert#transformers.TFBertLMHeadModel">TFBertLMHeadModel</a> (BERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/ctrl#transformers.TFCTRLLMHeadModel">TFCTRLLMHeadModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/camembert#transformers.TFCamembertForCausalLM">TFCamembertForCausalLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.TFGPT2LMHeadModel">TFGPT2LMHeadModel</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gptj#transformers.TFGPTJForCausalLM">TFGPTJForCausalLM</a> (GPT-J model)</li>
<li><a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/opt#transformers.TFOPTForCausalLM">TFOPTForCausalLM</a> (OPT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.TFOpenAIGPTLMHeadModel">TFOpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/rembert#transformers.TFRemBertForCausalLM">TFRemBertForCausalLM</a> (RemBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roformer#transformers.TFRoFormerForCausalLM">TFRoFormerForCausalLM</a> (RoFormer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta#transformers.TFRobertaForCausalLM">TFRobertaForCausalLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForCausalLM">TFRobertaPreLayerNormForCausalLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/transfo-xl#transformers.TFTransfoXLLMHeadModel">TFTransfoXLLMHeadModel</a> (Transformer-XL model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xglm#transformers.TFXGLMForCausalLM">TFXGLMForCausalLM</a> (XGLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm#transformers.TFXLMWithLMHeadModel">TFXLMWithLMHeadModel</a> (XLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForCausalLM">TFXLMRobertaForCausalLM</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.TFXLNetLMHeadModel">TFXLNetLMHeadModel</a> (XLNet model)</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForCausalLM.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),zs=new $({props:{anchor:"transformers.TFAutoModelForCausalLM.from_config.example",$$slots:{default:[N4]},$$scope:{ctx:y}}}),Rm=new x({props:{name:"from_pretrained",anchor:"transformers.TFAutoModelForCausalLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),Os=new $({props:{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.example",$$slots:{default:[q4]},$$scope:{ctx:y}}}),Sm=new B({props:{title:"FlaxAutoModelForCausalLM",local:"transformers.FlaxAutoModelForCausalLM",headingTag:"h3"}}),Gm=new x({props:{name:"class transformers.FlaxAutoModelForCausalLM",anchor:"transformers.FlaxAutoModelForCausalLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_flax_auto.py#L294"}}),Wm=new x({props:{name:"from_config",anchor:"transformers.FlaxAutoModelForCausalLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForCausalLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bart#transformers.FlaxBartForCausalLM">FlaxBartForCausalLM</a> (BART model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bert#transformers.FlaxBertForCausalLM">FlaxBertForCausalLM</a> (BERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.FlaxBigBirdForCausalLM">FlaxBigBirdForCausalLM</a> (BigBird model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bloom#transformers.FlaxBloomForCausalLM">FlaxBloomForCausalLM</a> (BLOOM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/electra#transformers.FlaxElectraForCausalLM">FlaxElectraForCausalLM</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.FlaxGPT2LMHeadModel">FlaxGPT2LMHeadModel</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gptj#transformers.FlaxGPTJForCausalLM">FlaxGPTJForCausalLM</a> (GPT-J model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gpt_neo#transformers.GPTNeoConfig">GPTNeoConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gpt_neo#transformers.FlaxGPTNeoForCausalLM">FlaxGPTNeoForCausalLM</a> (GPT Neo model)</li>
<li><a href="/docs/transformers/main/en/model_doc/gemma#transformers.GemmaConfig">GemmaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/gemma#transformers.FlaxGemmaForCausalLM">FlaxGemmaForCausalLM</a> (Gemma model)</li>
<li><a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaConfig">LlamaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/llama#transformers.FlaxLlamaForCausalLM">FlaxLlamaForCausalLM</a> (LLaMA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mistral#transformers.MistralConfig">MistralConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mistral#transformers.FlaxMistralForCausalLM">FlaxMistralForCausalLM</a> (Mistral model)</li>
<li><a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/opt#transformers.FlaxOPTForCausalLM">FlaxOPTForCausalLM</a> (OPT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta#transformers.FlaxRobertaForCausalLM">FlaxRobertaForCausalLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForCausalLM">FlaxRobertaPreLayerNormForCausalLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xglm#transformers.FlaxXGLMForCausalLM">FlaxXGLMForCausalLM</a> (XGLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForCausalLM">FlaxXLMRobertaForCausalLM</a> (XLM-RoBERTa model)</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),Ks=new $({props:{anchor:"transformers.FlaxAutoModelForCausalLM.from_config.example",$$slots:{default:[X4]},$$scope:{ctx:y}}}),Pm=new x({props:{name:"from_pretrained",anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),ei=new $({props:{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.example",$$slots:{default:[D4]},$$scope:{ctx:y}}}),Vm=new B({props:{title:"AutoModelForMaskedLM",local:"transformers.AutoModelForMaskedLM",headingTag:"h3"}}),Jm=new x({props:{name:"class transformers.AutoModelForMaskedLM",anchor:"transformers.AutoModelForMaskedLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_auto.py#L1437"}}),Em=new x({props:{name:"from_config",anchor:"transformers.AutoModelForMaskedLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForMaskedLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/albert#transformers.AlbertForMaskedLM">AlbertForMaskedLM</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/main/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertForMaskedLM">BertForMaskedLM</a> (BERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/big_bird#transformers.BigBirdForMaskedLM">BigBirdForMaskedLM</a> (BigBird model)</li>
<li><a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/camembert#transformers.CamembertForMaskedLM">CamembertForMaskedLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/convbert#transformers.ConvBertForMaskedLM">ConvBertForMaskedLM</a> (ConvBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/data2vec#transformers.Data2VecTextForMaskedLM">Data2VecTextForMaskedLM</a> (Data2VecText model)</li>
<li><a href="/docs/transformers/main/en/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/deberta#transformers.DebertaForMaskedLM">DebertaForMaskedLM</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/main/en/model_doc/deberta-v2#transformers.DebertaV2ForMaskedLM">DebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/distilbert#transformers.DistilBertForMaskedLM">DistilBertForMaskedLM</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/electra#transformers.ElectraForMaskedLM">ElectraForMaskedLM</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/ernie#transformers.ErnieForMaskedLM">ErnieForMaskedLM</a> (ERNIE model)</li>
<li><a href="/docs/transformers/main/en/model_doc/esm#transformers.EsmConfig">EsmConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/esm#transformers.EsmForMaskedLM">EsmForMaskedLM</a> (ESM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/fnet#transformers.FNetConfig">FNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/fnet#transformers.FNetForMaskedLM">FNetForMaskedLM</a> (FNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/flaubert#transformers.FlaubertWithLMHeadModel">FlaubertWithLMHeadModel</a> (FlauBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/funnel#transformers.FunnelForMaskedLM">FunnelForMaskedLM</a> (Funnel Transformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/ibert#transformers.IBertConfig">IBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/ibert#transformers.IBertForMaskedLM">IBertForMaskedLM</a> (I-BERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/layoutlm#transformers.LayoutLMForMaskedLM">LayoutLMForMaskedLM</a> (LayoutLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/longformer#transformers.LongformerConfig">LongformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/longformer#transformers.LongformerForMaskedLM">LongformerForMaskedLM</a> (Longformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/luke#transformers.LukeConfig">LukeConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/luke#transformers.LukeForMaskedLM">LukeForMaskedLM</a> (LUKE model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mbart#transformers.MBartForConditionalGeneration">MBartForConditionalGeneration</a> (mBART model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mpnet#transformers.MPNetForMaskedLM">MPNetForMaskedLM</a> (MPNet model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mega#transformers.MegaForMaskedLM">MegaForMaskedLM</a> (MEGA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/megatron-bert#transformers.MegatronBertConfig">MegatronBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/megatron-bert#transformers.MegatronBertForMaskedLM">MegatronBertForMaskedLM</a> (Megatron-BERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mobilebert#transformers.MobileBertForMaskedLM">MobileBertForMaskedLM</a> (MobileBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mra#transformers.MraConfig">MraConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mra#transformers.MraForMaskedLM">MraForMaskedLM</a> (MRA model)</li>
<li><a href="/docs/transformers/main/en/model_doc/mvp#transformers.MvpConfig">MvpConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/mvp#transformers.MvpForConditionalGeneration">MvpForConditionalGeneration</a> (MVP model)</li>
<li><a href="/docs/transformers/main/en/model_doc/nezha#transformers.NezhaConfig">NezhaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/nezha#transformers.NezhaForMaskedLM">NezhaForMaskedLM</a> (Nezha model)</li>
<li><a href="/docs/transformers/main/en/model_doc/nystromformer#transformers.NystromformerConfig">NystromformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/nystromformer#transformers.NystromformerForMaskedLM">NystromformerForMaskedLM</a> (Nystr&#xF6;mformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForMaskedLM">PerceiverForMaskedLM</a> (Perceiver model)</li>
<li><a href="/docs/transformers/main/en/model_doc/qdqbert#transformers.QDQBertConfig">QDQBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/qdqbert#transformers.QDQBertForMaskedLM">QDQBertForMaskedLM</a> (QDQBert model)</li>
<li><a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/reformer#transformers.ReformerForMaskedLM">ReformerForMaskedLM</a> (Reformer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/rembert#transformers.RemBertForMaskedLM">RemBertForMaskedLM</a> (RemBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roc_bert#transformers.RoCBertConfig">RoCBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roc_bert#transformers.RoCBertForMaskedLM">RoCBertForMaskedLM</a> (RoCBert model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roformer#transformers.RoFormerForMaskedLM">RoFormerForMaskedLM</a> (RoFormer model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaForMaskedLM">RobertaForMaskedLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForMaskedLM">RobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/main/en/model_doc/squeezebert#transformers.SqueezeBertConfig">SqueezeBertConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/squeezebert#transformers.SqueezeBertForMaskedLM">SqueezeBertForMaskedLM</a> (SqueezeBERT model)</li>
<li><a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/tapas#transformers.TapasForMaskedLM">TapasForMaskedLM</a> (TAPAS model)</li>
<li><a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> configuration class: <code>Wav2Vec2ForMaskedLM</code> (Wav2Vec2 model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm#transformers.XLMWithLMHeadModel">XLMWithLMHeadModel</a> (XLM model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm-roberta#transformers.XLMRobertaForMaskedLM">XLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLConfig">XLMRobertaXLConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForMaskedLM">XLMRobertaXLForMaskedLM</a> (XLM-RoBERTa-XL model)</li>
<li><a href="/docs/transformers/main/en/model_doc/xmod#transformers.XmodConfig">XmodConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/xmod#transformers.XmodForMaskedLM">XmodForMaskedLM</a> (X-MOD model)</li>
<li><a href="/docs/transformers/main/en/model_doc/yoso#transformers.YosoConfig">YosoConfig</a> configuration class: <a href="/docs/transformers/main/en/model_doc/yoso#transformers.YosoForMaskedLM">YosoForMaskedLM</a> (YOSO model)</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForMaskedLM.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),oi=new $({props:{anc