import{s as jn,o as mn,n as rn}from"../chunks/scheduler.9bc65507.js";import{S as on,i as hn,g as p,s as e,r as j,A as yn,h as c,f as l,c as t,j as Mn,u as m,x as M,k as hl,y as Jn,a as n,v as i,d as r,t as o,w as h,m as un,n as Un}from"../chunks/index.707bf1b6.js";import{T as bn}from"../chunks/Tip.c2ecdbf4.js";import{C as y}from"../chunks/CodeBlock.54a9f38d.js";import{D as Tn}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{H as Ys}from"../chunks/Heading.342b1fa6.js";function wn(Fs){let J,u,T='<a href="../model_doc/conditional_detr">Conditional DETR</a>, <a href="../model_doc/deformable_detr">Deformable DETR</a>, <a href="../model_doc/deta">DETA</a>, <a href="../model_doc/detr">DETR</a>, <a href="../model_doc/table-transformer">Table Transformer</a>, <a href="../model_doc/yolos">YOLOS</a>';return{c(){J=un(`このチュートリアルで説明するタスクは、次のモデル アーキテクチャでサポートされています。

`),u=p("p"),u.innerHTML=T},l(U){J=Un(U,`このチュートリアルで説明するタスクは、次のモデル アーキテクチャでサポートされています。

`),u=c(U,"P",{"data-svelte-h":!0}),M(u)!=="svelte-1cb65l9"&&(u.innerHTML=T)},m(U,b){n(U,J,b),n(U,u,b)},p:rn,d(U){U&&(l(J),l(u))}}}function dn(Fs){let J,u,T,U,b,Hs,I,$s,C,yl=`オブジェクト検出は、画像内のインスタンス (人間、建物、車など) を検出するコンピューター ビジョン タスクです。物体検出モデルは画像を入力および出力として受け取ります
検出されたオブジェクトの境界ボックスと関連するラベルの座標。画像には複数のオブジェクトを含めることができます。
それぞれに独自の境界ボックスとラベルがあり (例: 車と建物を持つことができます)、各オブジェクトは
画像のさまざまな部分に存在する必要があります (たとえば、画像には複数の車が含まれている可能性があります)。
このタスクは、歩行者、道路標識、信号機などを検出するために自動運転で一般的に使用されます。
他のアプリケーションには、画像内のオブジェクトのカウント、画像検索などが含まれます。`,zs,f,Jl="このガイドでは、次の方法を学習します。",Ss,Z,ul=`<li>Finetune <a href="https://huggingface.co/docs/transformers/model_doc/detr" rel="nofollow">DETR</a>、畳み込みアルゴリズムを組み合わせたモデル
<a href="https://huggingface.co/datasets/cppe-5" rel="nofollow">CPPE-5</a> 上のエンコーダー/デコーダー トランスフォーマーを備えたバックボーン
データセット。</li> <li>微調整したモデルを推論に使用します。</li>`,Ds,w,Ls,_,Ul="始める前に、必要なライブラリがすべてインストールされていることを確認してください。",Ps,A,Ks,B,bl=`🤗 データセットを使用して Hugging Face Hub からデータセットをロードし、🤗 トランスフォーマーを使用してモデルをトレーニングします。
データを増強するための<code>albumentations</code>。 <code>timm</code> は現在、DETR モデルの畳み込みバックボーンをロードするために必要です。`,Os,G,Tl=`モデルをコミュニティと共有することをお勧めします。 Hugging Face アカウントにログインして、ハブにアップロードします。
プロンプトが表示されたら、トークンを入力してログインします。`,sa,W,aa,R,la,v,wl=`<a href="https://huggingface.co/datasets/cppe-5" rel="nofollow">CPPE-5 データセット</a> には、次の画像が含まれています。
新型コロナウイルス感染症のパンデミックにおける医療用個人保護具 (PPE) を識別する注釈。`,na,Q,dl="データセットをロードすることから始めます。",ea,x,ta,k,gl="このデータセットには、1000 枚の画像を含むトレーニング セットと 29 枚の画像を含むテスト セットがすでに付属していることがわかります。",pa,V,Il="データに慣れるために、例がどのようなものかを調べてください。",ca,E,Ma,X,Cl="データセット内の例には次のフィールドがあります。",ja,N,fl='<li><code>image_id</code>: サンプルの画像ID</li> <li><code>image</code>: 画像を含む <code>PIL.Image.Image</code> オブジェクト</li> <li><code>width</code>: 画像の幅</li> <li><code>height</code>: 画像の高さ</li> <li><code>objects</code>: 画像内のオブジェクトの境界ボックスのメタデータを含む辞書:<ul><li><code>id</code>: アノテーションID</li> <li><code>area</code>: 境界ボックスの領域</li> <li><code>bbox</code>: オブジェクトの境界ボックス (<a href="https://albumentations.ai/docs/getting_started/bounding_boxes_augmentation/#coco" rel="nofollow">COCO 形式</a> )</li> <li><code>category</code>: オブジェクトのカテゴリー。可能な値には、<code>Coverall (0)</code>、<code>Face_Shield (1)</code>、<code>Gloves (2)</code>、<code>Goggles (3)</code>、および <code>Mask (4)</code> が含まれます。</li></ul></li>',ma,Y,Zl=`<code>bbox</code>フィールドが COCO 形式に従っていることに気づくかもしれません。これは DETR モデルが予期する形式です。
ただし、「オブジェクト」内のフィールドのグループ化は、DETR が必要とする注釈形式とは異なります。あなたはするであろう
このデータをトレーニングに使用する前に、いくつかの前処理変換を適用する必要があります。`,ia,q,_l="データをさらに深く理解するには、データセット内の例を視覚化します。",ra,F,oa,d,Al='<img src="https://i.imgur.com/TdaqPJO.png" alt="CPPE-5 Image Example"/>',ha,H,Bl=`関連付けられたラベルを使用して境界ボックスを視覚化するには、データセットのメタデータからラベルを取得します。
<code>category</code>フィールド。
また、ラベル ID をラベル クラスにマッピングする辞書 (<code>id2label</code>) やその逆 (<code>label2id</code>) を作成することもできます。
これらは、後でモデルをセットアップするときに使用できます。これらのマップを含めると、共有した場合に他の人がモデルを再利用できるようになります。
ハグフェイスハブに取り付けます。`,ya,$,Gl=`データに慣れるための最後のステップとして、潜在的な問題がないかデータを調査します。データセットに関する一般的な問題の 1 つは、
オブジェクト検出は、画像の端を越えて「伸びる」境界ボックスです。このような「暴走」境界ボックスは、
トレーニング中にエラーが発生するため、この段階で対処する必要があります。このデータセットには、この問題に関する例がいくつかあります。
このガイドでは内容をわかりやすくするために、これらの画像をデータから削除します。`,Ja,z,ua,S,Ua,D,Wl=`モデルを微調整するには、事前トレーニングされたモデルに使用されるアプローチと正確に一致するように、使用する予定のデータを前処理する必要があります。
<a href="/docs/transformers/main/ja/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> は、画像データを処理して <code>pixel_values</code>、<code>pixel_mask</code>、および
DETR モデルをトレーニングできる「ラベル」。画像プロセッサには、心配する必要のないいくつかの属性があります。`,ba,L,Rl="<li><code>image_mean = [0.485, 0.456, 0.406 ]</code></li> <li><code>image_std = [0.229, 0.224, 0.225]</code></li>",Ta,P,vl=`これらは、モデルの事前トレーニング中に画像を正規化するために使用される平均と標準偏差です。これらの価値観は非常に重要です
事前にトレーニングされた画像モデルを推論または微調整するときに複製します。`,wa,K,Ql="微調整するモデルと同じチェックポイントからイメージ プロセッサをインスタンス化します。",da,O,ga,ss,xl="画像を<code>image_processor</code>に渡す前に、2 つの前処理変換をデータセットに適用します。",Ia,as,kl="<li>画像の拡張</li> <li>DETR の期待に応えるための注釈の再フォーマット</li>",Ca,ls,Vl=`まず、モデルがトレーニング データにオーバーフィットしないようにするために、任意のデータ拡張ライブラリを使用して画像拡張を適用できます。ここでは<a href="https://albumentations.ai/docs/" rel="nofollow">Albumentations</a>を使用します…
このライブラリは、変換が画像に影響を与え、それに応じて境界ボックスを更新することを保証します。
🤗 データセット ライブラリのドキュメントには、詳細な <a href="https://huggingface.co/docs/datasets/object_detection" rel="nofollow">物体検出用に画像を拡張する方法に関するガイド</a> が記載されています。
例としてまったく同じデータセットを使用しています。ここでも同じアプローチを適用し、各画像のサイズを (480, 480) に変更します。
水平に反転して明るくします。`,fa,ns,Za,es,El=`<code>image_processor</code> は、注釈が次の形式であることを期待します: <code>{&#39;image_id&#39;: int, &#39;annotations&#39;: List[Dict]}</code>,
ここで、各辞書は COCO オブジェクトの注釈です。 1 つの例として、注釈を再フォーマットする関数を追加してみましょう。`,_a,ts,Aa,ps,Xl="これで、画像と注釈の変換を組み合わせてサンプルのバッチで使用できるようになりました。",Ba,cs,Ga,Ms,Nl=`🤗 Datasets <code>with_transform</code> メソッドを使用して、この前処理関数をデータセット全体に適用します。この方法が適用されるのは、
データセットの要素を読み込むときに、その場で変換します。`,Wa,js,Yl=`この時点で、データセットの例が変換後にどのようになるかを確認できます。テンソルが表示されるはずです
<code>pixel_values</code>、テンソルと <code>pixel_mask</code>、および <code>labels</code> を使用します。`,Ra,ms,va,is,ql=`個々の画像を正常に拡張し、それらの注釈を準備しました。ただし、前処理はそうではありません。
まだ完成しています。最後のステップでは、画像をバッチ処理するためのカスタム <code>collat​​e_fn</code> を作成します。
画像 (現在は <code>pixel_values</code>) をバッチ内の最大の画像にパディングし、対応する <code>pixel_mask</code> を作成します
どのピクセルが実数 (1) で、どのピクセルがパディング (0) であるかを示します。`,Qa,rs,xa,os,ka,hs,Fl=`前のセクションで重労働のほとんどを完了したので、モデルをトレーニングする準備が整いました。
このデータセット内の画像は、サイズを変更した後でも依然として非常に大きいです。これは、このモデルを微調整すると、
少なくとも 1 つの GPU が必要です。`,Va,ys,Hl="トレーニングには次の手順が含まれます。",Ea,Js,$l='<li>前処理と同じチェックポイントを使用して、<a href="/docs/transformers/main/ja/model_doc/auto#transformers.AutoModelForObjectDetection">AutoModelForObjectDetection</a> でモデルを読み込みます。</li> <li><a href="/docs/transformers/main/ja/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> でトレーニング ハイパーパラメータを定義します。</li> <li>トレーニング引数をモデル、データセット、画像プロセッサ、データ照合器とともに <a href="/docs/transformers/main/ja/main_classes/trainer#transformers.Trainer">Trainer</a> に渡します。</li> <li><a href="/docs/transformers/main/ja/main_classes/trainer#transformers.Trainer.train">train()</a> を呼び出してモデルを微調整します。</li>',Xa,us,zl=`前処理に使用したのと同じチェックポイントからモデルをロードするときは、必ず<code>label2id</code>を渡してください。
および <code>id2label</code> マップは、以前にデータセットのメタデータから作成したものです。さらに、<code>ignore_mismatched_sizes=True</code>を指定して、既存の分類頭部を新しい分類頭部に置き換えます。`,Na,Us,Ya,bs,Sl=`<a href="/docs/transformers/main/ja/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> で、<code>output_dir</code> を使用してモデルの保存場所を指定し、必要に応じてハイパーパラメーターを構成します。
画像列が削除されるため、未使用の列を削除しないことが重要です。画像列がないと、
<code>pixel_values</code> を作成できません。このため、<code>remove_unused_columns</code>を<code>False</code>に設定します。
ハブにプッシュしてモデルを共有したい場合は、<code>push_to_hub</code> を <code>True</code> に設定します (Hugging にサインインする必要があります)
顔に向かってモデルをアップロードします）。`,qa,Ts,Fa,ws,Dl='最後に、すべてをまとめて、<a href="/docs/transformers/main/ja/main_classes/trainer#transformers.Trainer.train">train()</a> を呼び出します。',Ha,ds,$a,gs,Ll=`<code>training_args</code>で<code>push_to_hub</code>を<code>True</code>に設定した場合、トレーニング チェックポイントは
ハグフェイスハブ。トレーニングが完了したら、<a href="/docs/transformers/main/ja/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> メソッドを呼び出して、最終モデルもハブにプッシュします。`,za,Is,Sa,Cs,Da,fs,Pl=`物体検出モデルは通常、一連の <a href="https://cocodataset.org/#detection-eval">COCO スタイルの指標</a>を使用して評価されます。
既存のメトリクス実装のいずれかを使用できますが、ここでは<code>torchvision</code>のメトリクス実装を使用して最終的なメトリクスを評価します。
ハブにプッシュしたモデル。`,La,Zs,Kl=`<code>torchvision</code>エバリュエーターを使用するには、グラウンド トゥルース COCO データセットを準備する必要があります。 COCO データセットを構築するための API
データを特定の形式で保存する必要があるため、最初に画像と注釈をディスクに保存する必要があります。と同じように
トレーニング用にデータを準備するとき、<code>cppe5[&quot;test&quot;]</code> からの注釈をフォーマットする必要があります。ただし、画像
そのままでいるべきです。`,Pa,_s,Ol=`評価ステップには少し作業が必要ですが、大きく 3 つのステップに分けることができます。
まず、<code>cppe5[&quot;test&quot;]</code> セットを準備します。注釈をフォーマットし、データをディスクに保存します。`,Ka,As,Oa,Bs,sn="次に、<code>cocoevaluator</code>で利用できる<code>CocoDetection</code>クラスのインスタンスを用意します。",sl,Gs,al,Ws,an="最後に、メトリクスをロードして評価を実行します。",ll,Rs,nl,vs,ln='これらの結果は、<a href="/docs/transformers/main/ja/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> のハイパーパラメータを調整することでさらに改善できます。試してごらん！',el,Qs,tl,xs,nn=`DETR モデルを微調整して評価し、Hugging Face Hub にアップロードしたので、それを推論に使用できます。
推論用に微調整されたモデルを試す最も簡単な方法は、それを <a href="/docs/transformers/main/ja/main_classes/pipelines#transformers.pipeline">pipeline()</a> で使用することです。パイプラインをインスタンス化する
モデルを使用してオブジェクトを検出し、それに画像を渡します。`,pl,ks,cl,Vs,en="必要に応じて、パイプラインの結果を手動で複製することもできます。",Ml,Es,jl,Xs,tn="結果をプロットしてみましょう:",ml,Ns,il,g,pn='<img src="https://i.imgur.com/4QZnf9A.png" alt="Object detection result on a new image"/>',rl,qs,ol;return b=new Ys({props:{title:"Object detection",local:"object-detection",headingTag:"h1"}}),I=new Tn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/object_detection.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/object_detection.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/object_detection.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/object_detection.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/object_detection.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/object_detection.ipynb"}]}}),w=new bn({props:{$$slots:{default:[wn]},$$scope:{ctx:Fs}}}),A=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwZGF0YXNldHMlMjB0cmFuc2Zvcm1lcnMlMjBldmFsdWF0ZSUyMHRpbW0lMjBhbGJ1bWVudGF0aW9ucw==",highlighted:"pip install -q datasets transformers evaluate timm albumentations",wrap:!1}}),W=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),R=new Ys({props:{title:"Load the CPPE-5 dataset",local:"load-the-cppe-5-dataset",headingTag:"h2"}}),x=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBY3BwZTUlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyY3BwZS01JTIyKSUwQWNwcGU1",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5 = load_dataset(<span class="hljs-string">&quot;cppe-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5
DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;width&#x27;</span>, <span class="hljs-string">&#x27;height&#x27;</span>, <span class="hljs-string">&#x27;objects&#x27;</span>],
        num_rows: <span class="hljs-number">1000</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;width&#x27;</span>, <span class="hljs-string">&#x27;height&#x27;</span>, <span class="hljs-string">&#x27;objects&#x27;</span>],
        num_rows: <span class="hljs-number">29</span>
    })
})`,wrap:!1}}),E=new y({props:{code:"Y3BwZTUlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;image_id&#x27;</span>: <span class="hljs-number">15</span>,
 <span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=943x663 at <span class="hljs-number">0x7F9EC9E77C10</span>&gt;,
 <span class="hljs-string">&#x27;width&#x27;</span>: <span class="hljs-number">943</span>,
 <span class="hljs-string">&#x27;height&#x27;</span>: <span class="hljs-number">663</span>,
 <span class="hljs-string">&#x27;objects&#x27;</span>: {<span class="hljs-string">&#x27;id&#x27;</span>: [<span class="hljs-number">114</span>, <span class="hljs-number">115</span>, <span class="hljs-number">116</span>, <span class="hljs-number">117</span>],
  <span class="hljs-string">&#x27;area&#x27;</span>: [<span class="hljs-number">3796</span>, <span class="hljs-number">1596</span>, <span class="hljs-number">152768</span>, <span class="hljs-number">81002</span>],
  <span class="hljs-string">&#x27;bbox&#x27;</span>: [[<span class="hljs-number">302.0</span>, <span class="hljs-number">109.0</span>, <span class="hljs-number">73.0</span>, <span class="hljs-number">52.0</span>],
   [<span class="hljs-number">810.0</span>, <span class="hljs-number">100.0</span>, <span class="hljs-number">57.0</span>, <span class="hljs-number">28.0</span>],
   [<span class="hljs-number">160.0</span>, <span class="hljs-number">31.0</span>, <span class="hljs-number">248.0</span>, <span class="hljs-number">616.0</span>],
   [<span class="hljs-number">741.0</span>, <span class="hljs-number">68.0</span>, <span class="hljs-number">202.0</span>, <span class="hljs-number">401.0</span>]],
  <span class="hljs-string">&#x27;category&#x27;</span>: [<span class="hljs-number">4</span>, <span class="hljs-number">4</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]}}`,wrap:!1}}),F=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwb3MlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMkMlMjBJbWFnZURyYXclMEElMEFpbWFnZSUyMCUzRCUyMGNwcGU1JTVCJTIydHJhaW4lMjIlNUQlNUIwJTVEJTVCJTIyaW1hZ2UlMjIlNUQlMEFhbm5vdGF0aW9ucyUyMCUzRCUyMGNwcGU1JTVCJTIydHJhaW4lMjIlNUQlNUIwJTVEJTVCJTIyb2JqZWN0cyUyMiU1RCUwQWRyYXclMjAlM0QlMjBJbWFnZURyYXcuRHJhdyhpbWFnZSklMEElMEFjYXRlZ29yaWVzJTIwJTNEJTIwY3BwZTUlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMm9iamVjdHMlMjIlNUQuZmVhdHVyZSU1QiUyMmNhdGVnb3J5JTIyJTVELm5hbWVzJTBBJTBBaWQybGFiZWwlMjAlM0QlMjAlN0JpbmRleCUzQSUyMHglMjBmb3IlMjBpbmRleCUyQyUyMHglMjBpbiUyMGVudW1lcmF0ZShjYXRlZ29yaWVzJTJDJTIwc3RhcnQlM0QwKSU3RCUwQWxhYmVsMmlkJTIwJTNEJTIwJTdCdiUzQSUyMGslMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaWQybGFiZWwuaXRlbXMoKSU3RCUwQSUwQWZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihhbm5vdGF0aW9ucyU1QiUyMmlkJTIyJTVEKSklM0ElMEElMjAlMjAlMjAlMjBib3glMjAlM0QlMjBhbm5vdGF0aW9ucyU1QiUyMmJib3glMjIlNUQlNUJpJTVEJTBBJTIwJTIwJTIwJTIwY2xhc3NfaWR4JTIwJTNEJTIwYW5ub3RhdGlvbnMlNUIlMjJjYXRlZ29yeSUyMiU1RCU1QmklNUQlMEElMjAlMjAlMjAlMjB4JTJDJTIweSUyQyUyMHclMkMlMjBoJTIwJTNEJTIwdHVwbGUoYm94KSUwQSUyMCUyMCUyMCUyMGRyYXcucmVjdGFuZ2xlKCh4JTJDJTIweSUyQyUyMHglMjAlMkIlMjB3JTJDJTIweSUyMCUyQiUyMGgpJTJDJTIwb3V0bGluZSUzRCUyMnJlZCUyMiUyQyUyMHdpZHRoJTNEMSklMEElMjAlMjAlMjAlMjBkcmF3LnRleHQoKHglMkMlMjB5KSUyQyUyMGlkMmxhYmVsJTVCY2xhc3NfaWR4JTVEJTJDJTIwZmlsbCUzRCUyMndoaXRlJTIyKSUwQSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image, ImageDraw

<span class="hljs-meta">&gt;&gt;&gt; </span>image = cppe5[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>annotations = cppe5[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;objects&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image)

<span class="hljs-meta">&gt;&gt;&gt; </span>categories = cppe5[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;objects&quot;</span>].feature[<span class="hljs-string">&quot;category&quot;</span>].names

<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = {index: x <span class="hljs-keyword">for</span> index, x <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(categories, start=<span class="hljs-number">0</span>)}
<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {v: k <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> id2label.items()}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(annotations[<span class="hljs-string">&quot;id&quot;</span>])):
<span class="hljs-meta">... </span>    box = annotations[<span class="hljs-string">&quot;bbox&quot;</span>][i]
<span class="hljs-meta">... </span>    class_idx = annotations[<span class="hljs-string">&quot;category&quot;</span>][i]
<span class="hljs-meta">... </span>    x, y, w, h = <span class="hljs-built_in">tuple</span>(box)
<span class="hljs-meta">... </span>    draw.rectangle((x, y, x + w, y + h), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((x, y), id2label[class_idx], fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),z=new y({props:{code:"cmVtb3ZlX2lkeCUyMCUzRCUyMCU1QjU5MCUyQyUyMDgyMSUyQyUyMDgyMiUyQyUyMDg3NSUyQyUyMDg3NiUyQyUyMDg3OCUyQyUyMDg3OSU1RCUwQWtlZXAlMjAlM0QlMjAlNUJpJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobGVuKGNwcGU1JTVCJTIydHJhaW4lMjIlNUQpKSUyMGlmJTIwaSUyMG5vdCUyMGluJTIwcmVtb3ZlX2lkeCU1RCUwQWNwcGU1JTVCJTIydHJhaW4lMjIlNUQlMjAlM0QlMjBjcHBlNSU1QiUyMnRyYWluJTIyJTVELnNlbGVjdChrZWVwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>remove_idx = [<span class="hljs-number">590</span>, <span class="hljs-number">821</span>, <span class="hljs-number">822</span>, <span class="hljs-number">875</span>, <span class="hljs-number">876</span>, <span class="hljs-number">878</span>, <span class="hljs-number">879</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>keep = [i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(cppe5[<span class="hljs-string">&quot;train&quot;</span>])) <span class="hljs-keyword">if</span> i <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> remove_idx]
<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5[<span class="hljs-string">&quot;train&quot;</span>] = cppe5[<span class="hljs-string">&quot;train&quot;</span>].select(keep)`,wrap:!1}}),S=new Ys({props:{title:"Preprocess the data",local:"preprocess-the-data",headingTag:"h2"}}),O=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwJTIyJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(checkpoint)`,wrap:!1}}),ns=new y({props:{code:"aW1wb3J0JTIwYWxidW1lbnRhdGlvbnMlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRyYW5zZm9ybSUyMCUzRCUyMGFsYnVtZW50YXRpb25zLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWxidW1lbnRhdGlvbnMuUmVzaXplKDQ4MCUyQyUyMDQ4MCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbGJ1bWVudGF0aW9ucy5Ib3Jpem9udGFsRmxpcChwJTNEMS4wKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFsYnVtZW50YXRpb25zLlJhbmRvbUJyaWdodG5lc3NDb250cmFzdChwJTNEMS4wKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMGJib3hfcGFyYW1zJTNEYWxidW1lbnRhdGlvbnMuQmJveFBhcmFtcyhmb3JtYXQlM0QlMjJjb2NvJTIyJTJDJTIwbGFiZWxfZmllbGRzJTNEJTVCJTIyY2F0ZWdvcnklMjIlNUQpJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> albumentations
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>transform = albumentations.Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        albumentations.Resize(<span class="hljs-number">480</span>, <span class="hljs-number">480</span>),
<span class="hljs-meta">... </span>        albumentations.HorizontalFlip(p=<span class="hljs-number">1.0</span>),
<span class="hljs-meta">... </span>        albumentations.RandomBrightnessContrast(p=<span class="hljs-number">1.0</span>),
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    bbox_params=albumentations.BboxParams(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;coco&quot;</span>, label_fields=[<span class="hljs-string">&quot;category&quot;</span>]),
<span class="hljs-meta">... </span>)`,wrap:!1}}),ts=new y({props:{code:"ZGVmJTIwZm9ybWF0dGVkX2FubnMoaW1hZ2VfaWQlMkMlMjBjYXRlZ29yeSUyQyUyMGFyZWElMkMlMjBiYm94KSUzQSUwQSUyMCUyMCUyMCUyMGFubm90YXRpb25zJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihjYXRlZ29yeSkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmV3X2FubiUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmltYWdlX2lkJTIyJTNBJTIwaW1hZ2VfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYXRlZ29yeV9pZCUyMiUzQSUyMGNhdGVnb3J5JTVCaSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlzQ3Jvd2QlMjIlM0ElMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJlYSUyMiUzQSUyMGFyZWElNUJpJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYmJveCUyMiUzQSUyMGxpc3QoYmJveCU1QmklNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYW5ub3RhdGlvbnMuYXBwZW5kKG5ld19hbm4pJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYW5ub3RhdGlvbnM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">formatted_anns</span>(<span class="hljs-params">image_id, category, area, bbox</span>):
<span class="hljs-meta">... </span>    annotations = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(category)):
<span class="hljs-meta">... </span>        new_ann = {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;image_id&quot;</span>: image_id,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;category_id&quot;</span>: category[i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;isCrowd&quot;</span>: <span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;area&quot;</span>: area[i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;bbox&quot;</span>: <span class="hljs-built_in">list</span>(bbox[i]),
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>        annotations.append(new_ann)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> annotations`,wrap:!1}}),cs=new y({props:{code:"JTIzJTIwdHJhbnNmb3JtaW5nJTIwYSUyMGJhdGNoJTBBZGVmJTIwdHJhbnNmb3JtX2F1Z19hbm4oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VfaWRzJTIwJTNEJTIwZXhhbXBsZXMlNUIlMjJpbWFnZV9pZCUyMiU1RCUwQSUyMCUyMCUyMCUyMGltYWdlcyUyQyUyMGJib3hlcyUyQyUyMGFyZWElMkMlMjBjYXRlZ29yaWVzJTIwJTNEJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaW1hZ2UlMkMlMjBvYmplY3RzJTIwaW4lMjB6aXAoZXhhbXBsZXMlNUIlMjJpbWFnZSUyMiU1RCUyQyUyMGV4YW1wbGVzJTVCJTIyb2JqZWN0cyUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMG5wLmFycmF5KGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklNUIlM0ElMkMlMjAlM0ElMkMlMjAlM0ElM0EtMSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMHRyYW5zZm9ybShpbWFnZSUzRGltYWdlJTJDJTIwYmJveGVzJTNEb2JqZWN0cyU1QiUyMmJib3glMjIlNUQlMkMlMjBjYXRlZ29yeSUzRG9iamVjdHMlNUIlMjJjYXRlZ29yeSUyMiU1RCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmVhLmFwcGVuZChvYmplY3RzJTVCJTIyYXJlYSUyMiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZXMuYXBwZW5kKG91dCU1QiUyMmltYWdlJTIyJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJib3hlcy5hcHBlbmQob3V0JTVCJTIyYmJveGVzJTIyJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhdGVnb3JpZXMuYXBwZW5kKG91dCU1QiUyMmNhdGVnb3J5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJpbWFnZV9pZCUyMiUzQSUyMGlkXyUyQyUyMCUyMmFubm90YXRpb25zJTIyJTNBJTIwZm9ybWF0dGVkX2FubnMoaWRfJTJDJTIwY2F0XyUyQyUyMGFyXyUyQyUyMGJveF8pJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwaWRfJTJDJTIwY2F0XyUyQyUyMGFyXyUyQyUyMGJveF8lMjBpbiUyMHppcChpbWFnZV9pZHMlMkMlMjBjYXRlZ29yaWVzJTJDJTIwYXJlYSUyQyUyMGJib3hlcyklMEElMjAlMjAlMjAlMjAlNUQlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2VzJTJDJTIwYW5ub3RhdGlvbnMlM0R0YXJnZXRzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># transforming a batch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_aug_ann</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    image_ids = examples[<span class="hljs-string">&quot;image_id&quot;</span>]
<span class="hljs-meta">... </span>    images, bboxes, area, categories = [], [], [], []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> image, objects <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&quot;image&quot;</span>], examples[<span class="hljs-string">&quot;objects&quot;</span>]):
<span class="hljs-meta">... </span>        image = np.array(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>))[:, :, ::-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>        out = transform(image=image, bboxes=objects[<span class="hljs-string">&quot;bbox&quot;</span>], category=objects[<span class="hljs-string">&quot;category&quot;</span>])

<span class="hljs-meta">... </span>        area.append(objects[<span class="hljs-string">&quot;area&quot;</span>])
<span class="hljs-meta">... </span>        images.append(out[<span class="hljs-string">&quot;image&quot;</span>])
<span class="hljs-meta">... </span>        bboxes.append(out[<span class="hljs-string">&quot;bboxes&quot;</span>])
<span class="hljs-meta">... </span>        categories.append(out[<span class="hljs-string">&quot;category&quot;</span>])

<span class="hljs-meta">... </span>    targets = [
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;image_id&quot;</span>: id_, <span class="hljs-string">&quot;annotations&quot;</span>: formatted_anns(id_, cat_, ar_, box_)}
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> id_, cat_, ar_, box_ <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(image_ids, categories, area, bboxes)
<span class="hljs-meta">... </span>    ]

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image_processor(images=images, annotations=targets, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),ms=new y({props:{code:"Y3BwZTUlNUIlMjJ0cmFpbiUyMiU1RCUyMCUzRCUyMGNwcGU1JTVCJTIydHJhaW4lMjIlNUQud2l0aF90cmFuc2Zvcm0odHJhbnNmb3JtX2F1Z19hbm4pJTBBY3BwZTUlNUIlMjJ0cmFpbiUyMiU1RCU1QjE1JTVEJTBBJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5[<span class="hljs-string">&quot;train&quot;</span>] = cppe5[<span class="hljs-string">&quot;train&quot;</span>].with_transform(transform_aug_ann)
<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">15</span>]
{<span class="hljs-string">&#x27;pixel_values&#x27;</span>: tensor([[[ <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  ..., -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>],
          [ <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  ..., -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>],
          [ <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  ..., -<span class="hljs-number">1.9638</span>, -<span class="hljs-number">1.9638</span>, -<span class="hljs-number">1.9638</span>],
          ...,
          [-<span class="hljs-number">1.5699</span>, -<span class="hljs-number">1.5699</span>, -<span class="hljs-number">1.5699</span>,  ..., -<span class="hljs-number">1.9980</span>, -<span class="hljs-number">1.9980</span>, -<span class="hljs-number">1.9980</span>],
          [-<span class="hljs-number">1.5528</span>, -<span class="hljs-number">1.5528</span>, -<span class="hljs-number">1.5528</span>,  ..., -<span class="hljs-number">1.9980</span>, -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>],
          [-<span class="hljs-number">1.5528</span>, -<span class="hljs-number">1.5528</span>, -<span class="hljs-number">1.5528</span>,  ..., -<span class="hljs-number">1.9980</span>, -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>]],

         [[ <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  ..., -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>],
          [ <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  ..., -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>],
          [ <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  ..., -<span class="hljs-number">1.8256</span>, -<span class="hljs-number">1.8256</span>, -<span class="hljs-number">1.8256</span>],
          ...,
          [-<span class="hljs-number">1.3179</span>, -<span class="hljs-number">1.3179</span>, -<span class="hljs-number">1.3179</span>,  ..., -<span class="hljs-number">1.8606</span>, -<span class="hljs-number">1.8606</span>, -<span class="hljs-number">1.8606</span>],
          [-<span class="hljs-number">1.3004</span>, -<span class="hljs-number">1.3004</span>, -<span class="hljs-number">1.3004</span>,  ..., -<span class="hljs-number">1.8606</span>, -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>],
          [-<span class="hljs-number">1.3004</span>, -<span class="hljs-number">1.3004</span>, -<span class="hljs-number">1.3004</span>,  ..., -<span class="hljs-number">1.8606</span>, -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>]],

         [[ <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  ..., -<span class="hljs-number">1.6476</span>, -<span class="hljs-number">1.6476</span>, -<span class="hljs-number">1.6476</span>],
          [ <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  ..., -<span class="hljs-number">1.6476</span>, -<span class="hljs-number">1.6476</span>, -<span class="hljs-number">1.6476</span>],
          [ <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  ..., -<span class="hljs-number">1.6302</span>, -<span class="hljs-number">1.6302</span>, -<span class="hljs-number">1.6302</span>],
          ...,
          [-<span class="hljs-number">1.0201</span>, -<span class="hljs-number">1.0201</span>, -<span class="hljs-number">1.0201</span>,  ..., -<span class="hljs-number">1.5604</span>, -<span class="hljs-number">1.5604</span>, -<span class="hljs-number">1.5604</span>],
          [-<span class="hljs-number">1.0027</span>, -<span class="hljs-number">1.0027</span>, -<span class="hljs-number">1.0027</span>,  ..., -<span class="hljs-number">1.5604</span>, -<span class="hljs-number">1.5430</span>, -<span class="hljs-number">1.5430</span>],
          [-<span class="hljs-number">1.0027</span>, -<span class="hljs-number">1.0027</span>, -<span class="hljs-number">1.0027</span>,  ..., -<span class="hljs-number">1.5604</span>, -<span class="hljs-number">1.5430</span>, -<span class="hljs-number">1.5430</span>]]]),
 <span class="hljs-string">&#x27;pixel_mask&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         ...,
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: {<span class="hljs-string">&#x27;size&#x27;</span>: tensor([<span class="hljs-number">800</span>, <span class="hljs-number">800</span>]), <span class="hljs-string">&#x27;image_id&#x27;</span>: tensor([<span class="hljs-number">756</span>]), <span class="hljs-string">&#x27;class_labels&#x27;</span>: tensor([<span class="hljs-number">4</span>]), <span class="hljs-string">&#x27;boxes&#x27;</span>: tensor([[<span class="hljs-number">0.7340</span>, <span class="hljs-number">0.6986</span>, <span class="hljs-number">0.3414</span>, <span class="hljs-number">0.5944</span>]]), <span class="hljs-string">&#x27;area&#x27;</span>: tensor([<span class="hljs-number">519544.4375</span>]), <span class="hljs-string">&#x27;iscrowd&#x27;</span>: tensor([<span class="hljs-number">0</span>]), <span class="hljs-string">&#x27;orig_size&#x27;</span>: tensor([<span class="hljs-number">480</span>, <span class="hljs-number">480</span>])}}`,wrap:!1}}),rs=new y({props:{code:"ZGVmJTIwY29sbGF0ZV9mbihiYXRjaCklM0ElMEElMjAlMjAlMjAlMjBwaXhlbF92YWx1ZXMlMjAlM0QlMjAlNUJpdGVtJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwYmF0Y2glNUQlMEElMjAlMjAlMjAlMjBlbmNvZGluZyUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wYWQocGl4ZWxfdmFsdWVzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjAlNUJpdGVtJTVCJTIybGFiZWxzJTIyJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwYmF0Y2glNUQlMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwJTNEJTIwZW5jb2RpbmclNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnBpeGVsX21hc2slMjIlNUQlMjAlM0QlMjBlbmNvZGluZyU1QiUyMnBpeGVsX21hc2slMjIlNUQlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGxhYmVscyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGJhdGNo",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    pixel_values = [item[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> batch]
<span class="hljs-meta">... </span>    encoding = image_processor.pad(pixel_values, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">... </span>    labels = [item[<span class="hljs-string">&quot;labels&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> batch]
<span class="hljs-meta">... </span>    batch = {}
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = encoding[<span class="hljs-string">&quot;pixel_values&quot;</span>]
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;pixel_mask&quot;</span>] = encoding[<span class="hljs-string">&quot;pixel_mask&quot;</span>]
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),os=new Ys({props:{title:"Training the DETR model",local:"training-the-detr-model",headingTag:"h2"}}),Us=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBjaGVja3BvaW50JTJDJTBBJTIwJTIwJTIwJTIwaWQybGFiZWwlM0RpZDJsYWJlbCUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsMmlkJTNEbGFiZWwyaWQlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(
<span class="hljs-meta">... </span>    checkpoint,
<span class="hljs-meta">... </span>    id2label=id2label,
<span class="hljs-meta">... </span>    label2id=label2id,
<span class="hljs-meta">... </span>    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ts=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJkZXRyLXJlc25ldC01MF9maW5ldHVuZWRfY3BwZTUlMjIlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2Vwb2NocyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwZnAxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMjAwJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRfZGVjYXklM0QxZS00JTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV90b3RhbF9saW1pdCUzRDIlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfdW51c2VkX2NvbHVtbnMlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;detr-resnet-50_finetuned_cppe5&quot;</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    fp16=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">1e-5</span>,
<span class="hljs-meta">... </span>    weight_decay=<span class="hljs-number">1e-4</span>,
<span class="hljs-meta">... </span>    save_total_limit=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ds=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEY29sbGF0ZV9mbiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RjcHBlNSU1QiUyMnRyYWluJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2VfcHJvY2Vzc29yJTNEaW1hZ2VfcHJvY2Vzc29yJTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    data_collator=collate_fn,
<span class="hljs-meta">... </span>    train_dataset=cppe5[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    image_processor=image_processor,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()`,wrap:!1}}),Is=new y({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),Cs=new Ys({props:{title:"Evaluate",local:"evaluate",headingTag:"h2"}}),As=new y({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># format annotations the same as for training, no need for data augmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">val_formatted_anns</span>(<span class="hljs-params">image_id, objects</span>):
<span class="hljs-meta">... </span>    annotations = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(objects[<span class="hljs-string">&quot;id&quot;</span>])):
<span class="hljs-meta">... </span>        new_ann = {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;id&quot;</span>: objects[<span class="hljs-string">&quot;id&quot;</span>][i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;category_id&quot;</span>: objects[<span class="hljs-string">&quot;category&quot;</span>][i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;iscrowd&quot;</span>: <span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;image_id&quot;</span>: image_id,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;area&quot;</span>: objects[<span class="hljs-string">&quot;area&quot;</span>][i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;bbox&quot;</span>: objects[<span class="hljs-string">&quot;bbox&quot;</span>][i],
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>        annotations.append(new_ann)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> annotations


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save images and annotations into the files torchvision.datasets.CocoDetection expects</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">save_cppe5_annotation_file_images</span>(<span class="hljs-params">cppe5</span>):
<span class="hljs-meta">... </span>    output_json = {}
<span class="hljs-meta">... </span>    path_output_cppe5 = <span class="hljs-string">f&quot;<span class="hljs-subst">{os.getcwd()}</span>/cppe5/&quot;</span>

<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> os.path.exists(path_output_cppe5):
<span class="hljs-meta">... </span>        os.makedirs(path_output_cppe5)

<span class="hljs-meta">... </span>    path_anno = os.path.join(path_output_cppe5, <span class="hljs-string">&quot;cppe5_ann.json&quot;</span>)
<span class="hljs-meta">... </span>    categories_json = [{<span class="hljs-string">&quot;supercategory&quot;</span>: <span class="hljs-string">&quot;none&quot;</span>, <span class="hljs-string">&quot;id&quot;</span>: <span class="hljs-built_in">id</span>, <span class="hljs-string">&quot;name&quot;</span>: id2label[<span class="hljs-built_in">id</span>]} <span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span> <span class="hljs-keyword">in</span> id2label]
<span class="hljs-meta">... </span>    output_json[<span class="hljs-string">&quot;images&quot;</span>] = []
<span class="hljs-meta">... </span>    output_json[<span class="hljs-string">&quot;annotations&quot;</span>] = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> cppe5:
<span class="hljs-meta">... </span>        ann = val_formatted_anns(example[<span class="hljs-string">&quot;image_id&quot;</span>], example[<span class="hljs-string">&quot;objects&quot;</span>])
<span class="hljs-meta">... </span>        output_json[<span class="hljs-string">&quot;images&quot;</span>].append(
<span class="hljs-meta">... </span>            {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;id&quot;</span>: example[<span class="hljs-string">&quot;image_id&quot;</span>],
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;width&quot;</span>: example[<span class="hljs-string">&quot;image&quot;</span>].width,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;height&quot;</span>: example[<span class="hljs-string">&quot;image&quot;</span>].height,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;file_name&quot;</span>: <span class="hljs-string">f&quot;<span class="hljs-subst">{example[<span class="hljs-string">&#x27;image_id&#x27;</span>]}</span>.png&quot;</span>,
<span class="hljs-meta">... </span>            }
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        output_json[<span class="hljs-string">&quot;annotations&quot;</span>].extend(ann)
<span class="hljs-meta">... </span>    output_json[<span class="hljs-string">&quot;categories&quot;</span>] = categories_json

<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(path_anno, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>        json.dump(output_json, file, ensure_ascii=<span class="hljs-literal">False</span>, indent=<span class="hljs-number">4</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> im, img_id <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(cppe5[<span class="hljs-string">&quot;image&quot;</span>], cppe5[<span class="hljs-string">&quot;image_id&quot;</span>]):
<span class="hljs-meta">... </span>        path_img = os.path.join(path_output_cppe5, <span class="hljs-string">f&quot;<span class="hljs-subst">{img_id}</span>.png&quot;</span>)
<span class="hljs-meta">... </span>        im.save(path_img)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> path_output_cppe5, path_anno`,wrap:!1}}),Gs=new y({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torchvision


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">CocoDetection</span>(torchvision.datasets.CocoDetection):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, img_folder, image_processor, ann_file</span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__(img_folder, ann_file)
<span class="hljs-meta">... </span>        self.image_processor = image_processor

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__getitem__</span>(<span class="hljs-params">self, idx</span>):
<span class="hljs-meta">... </span>        <span class="hljs-comment"># read in PIL image and target in COCO format</span>
<span class="hljs-meta">... </span>        img, target = <span class="hljs-built_in">super</span>(CocoDetection, self).__getitem__(idx)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># preprocess image and target: converting target to DETR format,</span>
<span class="hljs-meta">... </span>        <span class="hljs-comment"># resizing + normalization of both image and target)</span>
<span class="hljs-meta">... </span>        image_id = self.ids[idx]
<span class="hljs-meta">... </span>        target = {<span class="hljs-string">&quot;image_id&quot;</span>: image_id, <span class="hljs-string">&quot;annotations&quot;</span>: target}
<span class="hljs-meta">... </span>        encoding = self.image_processor(images=img, annotations=target, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">... </span>        pixel_values = encoding[<span class="hljs-string">&quot;pixel_values&quot;</span>].squeeze()  <span class="hljs-comment"># remove batch dimension</span>
<span class="hljs-meta">... </span>        target = encoding[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]  <span class="hljs-comment"># remove batch dimension</span>

<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: target}


<span class="hljs-meta">&gt;&gt;&gt; </span>im_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>path_output_cppe5, path_anno = save_cppe5_annotation_file_images(cppe5[<span class="hljs-string">&quot;test&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>test_ds_coco_format = CocoDetection(path_output_cppe5, im_processor, path_anno)`,wrap:!1}}),Rs=new y({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> evaluate
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>module = evaluate.load(<span class="hljs-string">&quot;ybelkada/cocoevaluate&quot;</span>, coco=test_ds_coco_format.coco)
<span class="hljs-meta">&gt;&gt;&gt; </span>val_dataloader = torch.utils.data.DataLoader(
<span class="hljs-meta">... </span>    test_ds_coco_format, batch_size=<span class="hljs-number">8</span>, shuffle=<span class="hljs-literal">False</span>, num_workers=<span class="hljs-number">4</span>, collate_fn=collate_fn
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> idx, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(val_dataloader)):
<span class="hljs-meta">... </span>        pixel_values = batch[<span class="hljs-string">&quot;pixel_values&quot;</span>]
<span class="hljs-meta">... </span>        pixel_mask = batch[<span class="hljs-string">&quot;pixel_mask&quot;</span>]

<span class="hljs-meta">... </span>        labels = [
<span class="hljs-meta">... </span>            {k: v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> t.items()} <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> batch[<span class="hljs-string">&quot;labels&quot;</span>]
<span class="hljs-meta">... </span>        ]  <span class="hljs-comment"># these are in DETR format, resized + normalized</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">... </span>        outputs = model(pixel_values=pixel_values, pixel_mask=pixel_mask)

<span class="hljs-meta">... </span>        orig_target_sizes = torch.stack([target[<span class="hljs-string">&quot;orig_size&quot;</span>] <span class="hljs-keyword">for</span> target <span class="hljs-keyword">in</span> labels], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>        results = im_processor.post_process(outputs, orig_target_sizes)  <span class="hljs-comment"># convert outputs of model to Pascal VOC format (xmin, ymin, xmax, ymax)</span>

<span class="hljs-meta">... </span>        module.add(prediction=results, reference=labels)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">del</span> batch

<span class="hljs-meta">&gt;&gt;&gt; </span>results = module.compute()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(results)
Accumulating evaluation results...
DONE (t=<span class="hljs-number">0.08</span>s).
IoU metric: bbox
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=   <span class="hljs-built_in">all</span> | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.352</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>      | area=   <span class="hljs-built_in">all</span> | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.681</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.75</span>      | area=   <span class="hljs-built_in">all</span> | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.292</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area= small | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.168</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=medium | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.208</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area= large | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.429</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=   <span class="hljs-built_in">all</span> | maxDets=  <span class="hljs-number">1</span> ] = <span class="hljs-number">0.274</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=   <span class="hljs-built_in">all</span> | maxDets= <span class="hljs-number">10</span> ] = <span class="hljs-number">0.484</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=   <span class="hljs-built_in">all</span> | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.501</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area= small | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.191</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=medium | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.323</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area= large | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.590</span>`,wrap:!1}}),Qs=new Ys({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ks=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmkuaW1ndXIuY29tJTJGMmxuV29seS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFvYmpfZGV0ZWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJvYmplY3QtZGV0ZWN0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJkZXZvbmhvJTJGZGV0ci1yZXNuZXQtNTBfZmluZXR1bmVkX2NwcGU1JTIyKSUwQW9ial9kZXRlY3RvcihpbWFnZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://i.imgur.com/2lnWoly.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>obj_detector = pipeline(<span class="hljs-string">&quot;object-detection&quot;</span>, model=<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>obj_detector(image)`,wrap:!1}}),Es=new y({props:{code:"aW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJkZXZvbmhvJTJGZGV0ci1yZXNuZXQtNTBfZmluZXR1bmVkX2NwcGU1JTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJkZXZvbmhvJTJGZGV0ci1yZXNuZXQtNTBfZmluZXR1bmVkX2NwcGU1JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjAlMjAlMjAlMjB0YXJnZXRfc2l6ZXMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEKSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX29iamVjdF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMHRocmVzaG9sZCUzRDAuNSUyQyUyMHRhcmdldF9zaXplcyUzRHRhcmdldF9zaXplcyklNUIwJTVEJTBBJTBBZm9yJTIwc2NvcmUlMkMlMjBsYWJlbCUyQyUyMGJveCUyMGluJTIwemlwKHJlc3VsdHMlNUIlMjJzY29yZXMlMjIlNUQlMkMlMjByZXN1bHRzJTVCJTIybGFiZWxzJTIyJTVEJTJDJTIwcmVzdWx0cyU1QiUyMmJveGVzJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMGJveCUyMCUzRCUyMCU1QnJvdW5kKGklMkMlMjAyKSUyMGZvciUyMGklMjBpbiUyMGJveC50b2xpc3QoKSU1RCUwQSUyMCUyMCUyMCUyMHByaW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJEZXRlY3RlZCUyMCU3Qm1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QmxhYmVsLml0ZW0oKSU1RCU3RCUyMHdpdGglMjBjb25maWRlbmNlJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMiU3QnJvdW5kKHNjb3JlLml0ZW0oKSUyQyUyMDMpJTdEJTIwYXQlMjBsb2NhdGlvbiUyMCU3QmJveCU3RCUyMiUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>    results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.5</span>, target_sizes=target_sizes)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected Coverall <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.566</span> at location [<span class="hljs-number">1215.32</span>, <span class="hljs-number">147.38</span>, <span class="hljs-number">4401.81</span>, <span class="hljs-number">3227.08</span>]
Detected Mask <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.584</span> at location [<span class="hljs-number">2449.06</span>, <span class="hljs-number">823.19</span>, <span class="hljs-number">3256.43</span>, <span class="hljs-number">1413.9</span>]`,wrap:!1}}),Ns=new y({props:{code:"ZHJhdyUyMCUzRCUyMEltYWdlRHJhdy5EcmF3KGltYWdlKSUwQSUwQWZvciUyMHNjb3JlJTJDJTIwbGFiZWwlMkMlMjBib3glMjBpbiUyMHppcChyZXN1bHRzJTVCJTIyc2NvcmVzJTIyJTVEJTJDJTIwcmVzdWx0cyU1QiUyMmxhYmVscyUyMiU1RCUyQyUyMHJlc3VsdHMlNUIlMjJib3hlcyUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjBib3glMjAlM0QlMjAlNUJyb3VuZChpJTJDJTIwMiklMjBmb3IlMjBpJTIwaW4lMjBib3gudG9saXN0KCklNUQlMEElMjAlMjAlMjAlMjB4JTJDJTIweSUyQyUyMHgyJTJDJTIweTIlMjAlM0QlMjB0dXBsZShib3gpJTBBJTIwJTIwJTIwJTIwZHJhdy5yZWN0YW5nbGUoKHglMkMlMjB5JTJDJTIweDIlMkMlMjB5MiklMkMlMjBvdXRsaW5lJTNEJTIycmVkJTIyJTJDJTIwd2lkdGglM0QxKSUwQSUyMCUyMCUyMCUyMGRyYXcudGV4dCgoeCUyQyUyMHkpJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCbGFiZWwuaXRlbSgpJTVEJTJDJTIwZmlsbCUzRCUyMndoaXRlJTIyKSUwQSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    x, y, x2, y2 = <span class="hljs-built_in">tuple</span>(box)
<span class="hljs-meta">... </span>    draw.rectangle((x, y, x2, y2), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((x, y), model.config.id2label[label.item()], fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),{c(){J=p("meta"),u=e(),T=p("p"),U=e(),j(b.$$.fragment),Hs=e(),j(I.$$.fragment),$s=e(),C=p("p"),C.textContent=yl,zs=e(),f=p("p"),f.textContent=Jl,Ss=e(),Z=p("ol"),Z.innerHTML=ul,Ds=e(),j(w.$$.fragment),Ls=e(),_=p("p"),_.textContent=Ul,Ps=e(),j(A.$$.fragment),Ks=e(),B=p("p"),B.innerHTML=bl,Os=e(),G=p("p"),G.textContent=Tl,sa=e(),j(W.$$.fragment),aa=e(),j(R.$$.fragment),la=e(),v=p("p"),v.innerHTML=wl,na=e(),Q=p("p"),Q.textContent=dl,ea=e(),j(x.$$.fragment),ta=e(),k=p("p"),k.textContent=gl,pa=e(),V=p("p"),V.textContent=Il,ca=e(),j(E.$$.fragment),Ma=e(),X=p("p"),X.textContent=Cl,ja=e(),N=p("ul"),N.innerHTML=fl,ma=e(),Y=p("p"),Y.innerHTML=Zl,ia=e(),q=p("p"),q.textContent=_l,ra=e(),j(F.$$.fragment),oa=e(),d=p("div"),d.innerHTML=Al,ha=e(),H=p("p"),H.innerHTML=Bl,ya=e(),$=p("p"),$.textContent=Gl,Ja=e(),j(z.$$.fragment),ua=e(),j(S.$$.fragment),Ua=e(),D=p("p"),D.innerHTML=Wl,ba=e(),L=p("ul"),L.innerHTML=Rl,Ta=e(),P=p("p"),P.textContent=vl,wa=e(),K=p("p"),K.textContent=Ql,da=e(),j(O.$$.fragment),ga=e(),ss=p("p"),ss.innerHTML=xl,Ia=e(),as=p("ul"),as.innerHTML=kl,Ca=e(),ls=p("p"),ls.innerHTML=Vl,fa=e(),j(ns.$$.fragment),Za=e(),es=p("p"),es.innerHTML=El,_a=e(),j(ts.$$.fragment),Aa=e(),ps=p("p"),ps.textContent=Xl,Ba=e(),j(cs.$$.fragment),Ga=e(),Ms=p("p"),Ms.innerHTML=Nl,Wa=e(),js=p("p"),js.innerHTML=Yl,Ra=e(),j(ms.$$.fragment),va=e(),is=p("p"),is.innerHTML=ql,Qa=e(),j(rs.$$.fragment),xa=e(),j(os.$$.fragment),ka=e(),hs=p("p"),hs.textContent=Fl,Va=e(),ys=p("p"),ys.textContent=Hl,Ea=e(),Js=p("ol"),Js.innerHTML=$l,Xa=e(),us=p("p"),us.innerHTML=zl,Na=e(),j(Us.$$.fragment),Ya=e(),bs=p("p"),bs.innerHTML=Sl,qa=e(),j(Ts.$$.fragment),Fa=e(),ws=p("p"),ws.innerHTML=Dl,Ha=e(),j(ds.$$.fragment),$a=e(),gs=p("p"),gs.innerHTML=Ll,za=e(),j(Is.$$.fragment),Sa=e(),j(Cs.$$.fragment),Da=e(),fs=p("p"),fs.innerHTML=Pl,La=e(),Zs=p("p"),Zs.innerHTML=Kl,Pa=e(),_s=p("p"),_s.innerHTML=Ol,Ka=e(),j(As.$$.fragment),Oa=e(),Bs=p("p"),Bs.innerHTML=sn,sl=e(),j(Gs.$$.fragment),al=e(),Ws=p("p"),Ws.textContent=an,ll=e(),j(Rs.$$.fragment),nl=e(),vs=p("p"),vs.innerHTML=ln,el=e(),j(Qs.$$.fragment),tl=e(),xs=p("p"),xs.innerHTML=nn,pl=e(),j(ks.$$.fragment),cl=e(),Vs=p("p"),Vs.textContent=en,Ml=e(),j(Es.$$.fragment),jl=e(),Xs=p("p"),Xs.textContent=tn,ml=e(),j(Ns.$$.fragment),il=e(),g=p("div"),g.innerHTML=pn,rl=e(),qs=p("p"),this.h()},l(s){const a=yn("svelte-u9bgzb",document.head);J=c(a,"META",{name:!0,content:!0}),a.forEach(l),u=t(s),T=c(s,"P",{}),Mn(T).forEach(l),U=t(s),m(b.$$.fragment,s),Hs=t(s),m(I.$$.fragment,s),$s=t(s),C=c(s,"P",{"data-svelte-h":!0}),M(C)!=="svelte-5r6akf"&&(C.textContent=yl),zs=t(s),f=c(s,"P",{"data-svelte-h":!0}),M(f)!=="svelte-sw406c"&&(f.textContent=Jl),Ss=t(s),Z=c(s,"OL",{"data-svelte-h":!0}),M(Z)!=="svelte-gfibwd"&&(Z.innerHTML=ul),Ds=t(s),m(w.$$.fragment,s),Ls=t(s),_=c(s,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1lya3k8"&&(_.textContent=Ul),Ps=t(s),m(A.$$.fragment,s),Ks=t(s),B=c(s,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1heb5sb"&&(B.innerHTML=bl),Os=t(s),G=c(s,"P",{"data-svelte-h":!0}),M(G)!=="svelte-km1v2k"&&(G.textContent=Tl),sa=t(s),m(W.$$.fragment,s),aa=t(s),m(R.$$.fragment,s),la=t(s),v=c(s,"P",{"data-svelte-h":!0}),M(v)!=="svelte-omjhw2"&&(v.innerHTML=wl),na=t(s),Q=c(s,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1kjcyvo"&&(Q.textContent=dl),ea=t(s),m(x.$$.fragment,s),ta=t(s),k=c(s,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1edqlqi"&&(k.textContent=gl),pa=t(s),V=c(s,"P",{"data-svelte-h":!0}),M(V)!=="svelte-h4ffk6"&&(V.textContent=Il),ca=t(s),m(E.$$.fragment,s),Ma=t(s),X=c(s,"P",{"data-svelte-h":!0}),M(X)!=="svelte-13hht2o"&&(X.textContent=Cl),ja=t(s),N=c(s,"UL",{"data-svelte-h":!0}),M(N)!=="svelte-fjri37"&&(N.innerHTML=fl),ma=t(s),Y=c(s,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-y6a2g5"&&(Y.innerHTML=Zl),ia=t(s),q=c(s,"P",{"data-svelte-h":!0}),M(q)!=="svelte-1q29g0x"&&(q.textContent=_l),ra=t(s),m(F.$$.fragment,s),oa=t(s),d=c(s,"DIV",{class:!0,"data-svelte-h":!0}),M(d)!=="svelte-1mkaz8h"&&(d.innerHTML=Al),ha=t(s),H=c(s,"P",{"data-svelte-h":!0}),M(H)!=="svelte-19dg06i"&&(H.innerHTML=Bl),ya=t(s),$=c(s,"P",{"data-svelte-h":!0}),M($)!=="svelte-1xdk7br"&&($.textContent=Gl),Ja=t(s),m(z.$$.fragment,s),ua=t(s),m(S.$$.fragment,s),Ua=t(s),D=c(s,"P",{"data-svelte-h":!0}),M(D)!=="svelte-76sjmi"&&(D.innerHTML=Wl),ba=t(s),L=c(s,"UL",{"data-svelte-h":!0}),M(L)!=="svelte-9xz2l6"&&(L.innerHTML=Rl),Ta=t(s),P=c(s,"P",{"data-svelte-h":!0}),M(P)!=="svelte-w4h0v0"&&(P.textContent=vl),wa=t(s),K=c(s,"P",{"data-svelte-h":!0}),M(K)!=="svelte-16cx11i"&&(K.textContent=Ql),da=t(s),m(O.$$.fragment,s),ga=t(s),ss=c(s,"P",{"data-svelte-h":!0}),M(ss)!=="svelte-1i23rsc"&&(ss.innerHTML=xl),Ia=t(s),as=c(s,"UL",{"data-svelte-h":!0}),M(as)!=="svelte-17t0a11"&&(as.innerHTML=kl),Ca=t(s),ls=c(s,"P",{"data-svelte-h":!0}),M(ls)!=="svelte-18jci73"&&(ls.innerHTML=Vl),fa=t(s),m(ns.$$.fragment,s),Za=t(s),es=c(s,"P",{"data-svelte-h":!0}),M(es)!=="svelte-3sh3zj"&&(es.innerHTML=El),_a=t(s),m(ts.$$.fragment,s),Aa=t(s),ps=c(s,"P",{"data-svelte-h":!0}),M(ps)!=="svelte-cpkzfa"&&(ps.textContent=Xl),Ba=t(s),m(cs.$$.fragment,s),Ga=t(s),Ms=c(s,"P",{"data-svelte-h":!0}),M(Ms)!=="svelte-fnbbog"&&(Ms.innerHTML=Nl),Wa=t(s),js=c(s,"P",{"data-svelte-h":!0}),M(js)!=="svelte-1ddlogf"&&(js.innerHTML=Yl),Ra=t(s),m(ms.$$.fragment,s),va=t(s),is=c(s,"P",{"data-svelte-h":!0}),M(is)!=="svelte-lzm515"&&(is.innerHTML=ql),Qa=t(s),m(rs.$$.fragment,s),xa=t(s),m(os.$$.fragment,s),ka=t(s),hs=c(s,"P",{"data-svelte-h":!0}),M(hs)!=="svelte-1144ckg"&&(hs.textContent=Fl),Va=t(s),ys=c(s,"P",{"data-svelte-h":!0}),M(ys)!=="svelte-cqdmyi"&&(ys.textContent=Hl),Ea=t(s),Js=c(s,"OL",{"data-svelte-h":!0}),M(Js)!=="svelte-1da4rlp"&&(Js.innerHTML=$l),Xa=t(s),us=c(s,"P",{"data-svelte-h":!0}),M(us)!=="svelte-1j2te6e"&&(us.innerHTML=zl),Na=t(s),m(Us.$$.fragment,s),Ya=t(s),bs=c(s,"P",{"data-svelte-h":!0}),M(bs)!=="svelte-f1ek5p"&&(bs.innerHTML=Sl),qa=t(s),m(Ts.$$.fragment,s),Fa=t(s),ws=c(s,"P",{"data-svelte-h":!0}),M(ws)!=="svelte-432r7p"&&(ws.innerHTML=Dl),Ha=t(s),m(ds.$$.fragment,s),$a=t(s),gs=c(s,"P",{"data-svelte-h":!0}),M(gs)!=="svelte-1ki34dy"&&(gs.innerHTML=Ll),za=t(s),m(Is.$$.fragment,s),Sa=t(s),m(Cs.$$.fragment,s),Da=t(s),fs=c(s,"P",{"data-svelte-h":!0}),M(fs)!=="svelte-1f6htse"&&(fs.innerHTML=Pl),La=t(s),Zs=c(s,"P",{"data-svelte-h":!0}),M(Zs)!=="svelte-1urhuq1"&&(Zs.innerHTML=Kl),Pa=t(s),_s=c(s,"P",{"data-svelte-h":!0}),M(_s)!=="svelte-4fq9ze"&&(_s.innerHTML=Ol),Ka=t(s),m(As.$$.fragment,s),Oa=t(s),Bs=c(s,"P",{"data-svelte-h":!0}),M(Bs)!=="svelte-1pucslt"&&(Bs.innerHTML=sn),sl=t(s),m(Gs.$$.fragment,s),al=t(s),Ws=c(s,"P",{"data-svelte-h":!0}),M(Ws)!=="svelte-b0b8dt"&&(Ws.textContent=an),ll=t(s),m(Rs.$$.fragment,s),nl=t(s),vs=c(s,"P",{"data-svelte-h":!0}),M(vs)!=="svelte-4n33ma"&&(vs.innerHTML=ln),el=t(s),m(Qs.$$.fragment,s),tl=t(s),xs=c(s,"P",{"data-svelte-h":!0}),M(xs)!=="svelte-1l6wk9y"&&(xs.innerHTML=nn),pl=t(s),m(ks.$$.fragment,s),cl=t(s),Vs=c(s,"P",{"data-svelte-h":!0}),M(Vs)!=="svelte-19p6rx9"&&(Vs.textContent=en),Ml=t(s),m(Es.$$.fragment,s),jl=t(s),Xs=c(s,"P",{"data-svelte-h":!0}),M(Xs)!=="svelte-12ncpbb"&&(Xs.textContent=tn),ml=t(s),m(Ns.$$.fragment,s),il=t(s),g=c(s,"DIV",{class:!0,"data-svelte-h":!0}),M(g)!=="svelte-16oi5q2"&&(g.innerHTML=pn),rl=t(s),qs=c(s,"P",{}),Mn(qs).forEach(l),this.h()},h(){hl(J,"name","hf:doc:metadata"),hl(J,"content",gn),hl(d,"class","flex justify-center"),hl(g,"class","flex justify-center")},m(s,a){Jn(document.head,J),n(s,u,a),n(s,T,a),n(s,U,a),i(b,s,a),n(s,Hs,a),i(I,s,a),n(s,$s,a),n(s,C,a),n(s,zs,a),n(s,f,a),n(s,Ss,a),n(s,Z,a),n(s,Ds,a),i(w,s,a),n(s,Ls,a),n(s,_,a),n(s,Ps,a),i(A,s,a),n(s,Ks,a),n(s,B,a),n(s,Os,a),n(s,G,a),n(s,sa,a),i(W,s,a),n(s,aa,a),i(R,s,a),n(s,la,a),n(s,v,a),n(s,na,a),n(s,Q,a),n(s,ea,a),i(x,s,a),n(s,ta,a),n(s,k,a),n(s,pa,a),n(s,V,a),n(s,ca,a),i(E,s,a),n(s,Ma,a),n(s,X,a),n(s,ja,a),n(s,N,a),n(s,ma,a),n(s,Y,a),n(s,ia,a),n(s,q,a),n(s,ra,a),i(F,s,a),n(s,oa,a),n(s,d,a),n(s,ha,a),n(s,H,a),n(s,ya,a),n(s,$,a),n(s,Ja,a),i(z,s,a),n(s,ua,a),i(S,s,a),n(s,Ua,a),n(s,D,a),n(s,ba,a),n(s,L,a),n(s,Ta,a),n(s,P,a),n(s,wa,a),n(s,K,a),n(s,da,a),i(O,s,a),n(s,ga,a),n(s,ss,a),n(s,Ia,a),n(s,as,a),n(s,Ca,a),n(s,ls,a),n(s,fa,a),i(ns,s,a),n(s,Za,a),n(s,es,a),n(s,_a,a),i(ts,s,a),n(s,Aa,a),n(s,ps,a),n(s,Ba,a),i(cs,s,a),n(s,Ga,a),n(s,Ms,a),n(s,Wa,a),n(s,js,a),n(s,Ra,a),i(ms,s,a),n(s,va,a),n(s,is,a),n(s,Qa,a),i(rs,s,a),n(s,xa,a),i(os,s,a),n(s,ka,a),n(s,hs,a),n(s,Va,a),n(s,ys,a),n(s,Ea,a),n(s,Js,a),n(s,Xa,a),n(s,us,a),n(s,Na,a),i(Us,s,a),n(s,Ya,a),n(s,bs,a),n(s,qa,a),i(Ts,s,a),n(s,Fa,a),n(s,ws,a),n(s,Ha,a),i(ds,s,a),n(s,$a,a),n(s,gs,a),n(s,za,a),i(Is,s,a),n(s,Sa,a),i(Cs,s,a),n(s,Da,a),n(s,fs,a),n(s,La,a),n(s,Zs,a),n(s,Pa,a),n(s,_s,a),n(s,Ka,a),i(As,s,a),n(s,Oa,a),n(s,Bs,a),n(s,sl,a),i(Gs,s,a),n(s,al,a),n(s,Ws,a),n(s,ll,a),i(Rs,s,a),n(s,nl,a),n(s,vs,a),n(s,el,a),i(Qs,s,a),n(s,tl,a),n(s,xs,a),n(s,pl,a),i(ks,s,a),n(s,cl,a),n(s,Vs,a),n(s,Ml,a),i(Es,s,a),n(s,jl,a),n(s,Xs,a),n(s,ml,a),i(Ns,s,a),n(s,il,a),n(s,g,a),n(s,rl,a),n(s,qs,a),ol=!0},p(s,[a]){const cn={};a&2&&(cn.$$scope={dirty:a,ctx:s}),w.$set(cn)},i(s){ol||(r(b.$$.fragment,s),r(I.$$.fragment,s),r(w.$$.fragment,s),r(A.$$.fragment,s),r(W.$$.fragment,s),r(R.$$.fragment,s),r(x.$$.fragment,s),r(E.$$.fragment,s),r(F.$$.fragment,s),r(z.$$.fragment,s),r(S.$$.fragment,s),r(O.$$.fragment,s),r(ns.$$.fragment,s),r(ts.$$.fragment,s),r(cs.$$.fragment,s),r(ms.$$.fragment,s),r(rs.$$.fragment,s),r(os.$$.fragment,s),r(Us.$$.fragment,s),r(Ts.$$.fragment,s),r(ds.$$.fragment,s),r(Is.$$.fragment,s),r(Cs.$$.fragment,s),r(As.$$.fragment,s),r(Gs.$$.fragment,s),r(Rs.$$.fragment,s),r(Qs.$$.fragment,s),r(ks.$$.fragment,s),r(Es.$$.fragment,s),r(Ns.$$.fragment,s),ol=!0)},o(s){o(b.$$.fragment,s),o(I.$$.fragment,s),o(w.$$.fragment,s),o(A.$$.fragment,s),o(W.$$.fragment,s),o(R.$$.fragment,s),o(x.$$.fragment,s),o(E.$$.fragment,s),o(F.$$.fragment,s),o(z.$$.fragment,s),o(S.$$.fragment,s),o(O.$$.fragment,s),o(ns.$$.fragment,s),o(ts.$$.fragment,s),o(cs.$$.fragment,s),o(ms.$$.fragment,s),o(rs.$$.fragment,s),o(os.$$.fragment,s),o(Us.$$.fragment,s),o(Ts.$$.fragment,s),o(ds.$$.fragment,s),o(Is.$$.fragment,s),o(Cs.$$.fragment,s),o(As.$$.fragment,s),o(Gs.$$.fragment,s),o(Rs.$$.fragment,s),o(Qs.$$.fragment,s),o(ks.$$.fragment,s),o(Es.$$.fragment,s),o(Ns.$$.fragment,s),ol=!1},d(s){s&&(l(u),l(T),l(U),l(Hs),l($s),l(C),l(zs),l(f),l(Ss),l(Z),l(Ds),l(Ls),l(_),l(Ps),l(Ks),l(B),l(Os),l(G),l(sa),l(aa),l(la),l(v),l(na),l(Q),l(ea),l(ta),l(k),l(pa),l(V),l(ca),l(Ma),l(X),l(ja),l(N),l(ma),l(Y),l(ia),l(q),l(ra),l(oa),l(d),l(ha),l(H),l(ya),l($),l(Ja),l(ua),l(Ua),l(D),l(ba),l(L),l(Ta),l(P),l(wa),l(K),l(da),l(ga),l(ss),l(Ia),l(as),l(Ca),l(ls),l(fa),l(Za),l(es),l(_a),l(Aa),l(ps),l(Ba),l(Ga),l(Ms),l(Wa),l(js),l(Ra),l(va),l(is),l(Qa),l(xa),l(ka),l(hs),l(Va),l(ys),l(Ea),l(Js),l(Xa),l(us),l(Na),l(Ya),l(bs),l(qa),l(Fa),l(ws),l(Ha),l($a),l(gs),l(za),l(Sa),l(Da),l(fs),l(La),l(Zs),l(Pa),l(_s),l(Ka),l(Oa),l(Bs),l(sl),l(al),l(Ws),l(ll),l(nl),l(vs),l(el),l(tl),l(xs),l(pl),l(cl),l(Vs),l(Ml),l(jl),l(Xs),l(ml),l(il),l(g),l(rl),l(qs)),l(J),h(b,s),h(I,s),h(w,s),h(A,s),h(W,s),h(R,s),h(x,s),h(E,s),h(F,s),h(z,s),h(S,s),h(O,s),h(ns,s),h(ts,s),h(cs,s),h(ms,s),h(rs,s),h(os,s),h(Us,s),h(Ts,s),h(ds,s),h(Is,s),h(Cs,s),h(As,s),h(Gs,s),h(Rs,s),h(Qs,s),h(ks,s),h(Es,s),h(Ns,s)}}}const gn='{"title":"Object detection","local":"object-detection","sections":[{"title":"Load the CPPE-5 dataset","local":"load-the-cppe-5-dataset","sections":[],"depth":2},{"title":"Preprocess the data","local":"preprocess-the-data","sections":[],"depth":2},{"title":"Training the DETR model","local":"training-the-detr-model","sections":[],"depth":2},{"title":"Evaluate","local":"evaluate","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function In(Fs){return mn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gn extends on{constructor(J){super(),hn(this,J,In,dn,jn,{})}}export{Gn as component};
