import{s as Tt,n as bt,o as jt}from"../chunks/scheduler.defa9a21.js";import{S as Ut,i as Jt,g as i,s,r as c,A as $t,h as r,f as a,c as n,j as yt,u as o,x as p,k as wt,y as vt,a as l,v as m,d as h,t as d,w as u}from"../chunks/index.fe795e71.js";import{C as te}from"../chunks/CodeBlock.42404125.js";import{H as ae,E as _t}from"../chunks/EditOnGithub.0f575778.js";function Ct(Ne){let f,ne,le,ie,M,re,g,We='🤗 Accelerate provides integrations to train on lower precision methods using specified supported hardware through the <code>TransformersEngine</code> and <code>MS-AMP</code> packages. This documentation will help guide you through what hardware is supported, how to configure your <a href="/docs/accelerate/v0.34.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> to leverage the low precision methods, and what you can expect when training.',pe,y,ce,w,Ve='To explore more of the nitty-gritty in training in FP8 with PyTorch and 🤗 Accelerate, check out the <a href="../concept_guides/low_precision_training">concept_guide</a> on why this can be difficult. But essentially rather than training in BF16, some (or all) aspects of training a model can be performed using 8 bits instead of 16. The challenge is doing so without degrading final performance.',oe,T,qe="This is only enabled on specific NVIDIA hardware, namely:",me,b,Ke="<li>Anything after the 3000 series consumer graphics cards (such as the 4090)</li> <li>Hopper-based GPU architectures (such as the <code>H100</code> and <code>H200</code>)</li>",he,j,Oe="What this will result in is some gain in the memory used (as we’ve cut the needed memory in half for some parts of training) and an increase in throughput <em>should</em> be seen as well for larger models that can replace certain layers with FP8-enabled ones.",de,U,ue,J,De="Currently two different backends for FP8 are supported (<code>TransformersEngine</code> and <code>MS-AMP</code>), each with different capabilities and configurations.",fe,$,et='To use either, the same core API is used. Just pass <code>mixed_precision=&quot;fp8&quot;</code> to either the <a href="/docs/accelerate/v0.34.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>, during <code>accelerate config</code> when prompted about mixed precision, or as part of your <code>config.yaml</code> file in the <code>mixed_precision</code> key:',Me,v,ge,_,tt='By default, if <code>MS-AMP</code> is available in your environment, 🤗 Accelerate will automatically utilize it as a backend. To specify it yourself (and customize other parts of the FP8 mixed precision setup), you can utilize the <a href="/docs/accelerate/v0.34.0/en/package_reference/fp8#accelerate.utils.FP8RecipeKwargs">utils.FP8RecipeKwargs</a> or clarify it in your config <code>yaml</code>/during <code>accelerate launch</code>:',ye,C,we,B,Te,Z,be,x,at="Of the two, <code>MS-AMP</code> is traditionally the easier one to configure as there is only a single argument: the optimization level.",je,A,lt="Currently two levels of optimization are supported in the 🤗 Accelerate integration, <code>&quot;O1&quot;</code> and <code>&quot;O2&quot;</code> (using the letter ‘o’, not zero).",Ue,P,st="<li><code>&quot;O1&quot;</code> will cast the weight gradients and <code>all_reduce</code> communications to happen in 8-bit, while the rest are done in 16 bit. This reduces the general GPU memory usage and speeds up communication bandwidths.</li> <li><code>&quot;O2&quot;</code> will also cast first-order optimizer states into 8 bit, while the second order states are in FP16. (Currently just the <code>Adam</code> optimizer is supported). This tries its best to minimize final accuracy degradation and will save the highest potential memory.</li>",Je,G,nt="To specify an optimization level, pass it to the <code>FP8KwargsHandler</code> by setting the <code>optimization_level</code> argument:",$e,X,ve,F,it="Or during <code>accelerate launch</code> via <code>--fp8_backend=msamp --fp8_opt_level=O2</code>",_e,H,rt="Similarly this can be set in your <code>config.yaml</code>:",Ce,z,Be,k,Ze,E,pt='TransformersEngine has much more available for customizing how and what FP8 calculations are performed. A full list of supported arguments and what they mean are available in <a href="https://docs.nvidia.com/deeplearning/transformer-engine/user-guide/api/common.html" rel="nofollow">NVIDIA’s documentation</a>, however they are restated as part of <code>FP8KwargsHandler</code>’s docstring for your convenience.',xe,I,ct="🤗 Accelerate tries to set sensible defaults, but exploring and tweaking the various parameters yourself can lead to better performance potentially.",Ae,R,ot="To use it, specify <code>backend=&quot;te&quot;</code> and modify any of the arguments you want as part of your kwarg handler:",Pe,S,Ge,Y,mt="Or during <code>accelerate launch</code> via <code>--fp8_backend=te ...</code>. Use <code>accelerate launch --fp8_backend=te -h</code> to see relevent arguments.",Xe,Q,ht="Similarly this can be set in your <code>config.yaml</code>:",Fe,L,He,N,ze,W,dt=`We have examples showcasing training with FP8 both with accelerate and its underlying implementation available in the accelerate repo.
Currently we support scripts showcasing:`,ke,V,ut="<li>Single GPU</li> <li>Distributed Data Parallelism (Multi-GPU)</li> <li>Fully Sharded Data Parallelism</li> <li>DeepSpeed ZeRO 1 through 3</li>",Ee,q,ft='Find out more <a href="https://github.com/huggingface/accelerate/tree/main/benchmarks/fp8" rel="nofollow">here</a>',Ie,K,Re,O,Mt="To learn more about training in FP8 please check out the following resources:",Se,D,gt='<li><a href="../concept_guides/low_precision_training">Our concept guide</a> detailing into more about both TransformersEngine and MS-AMP</li> <li><a href="https://docs.nvidia.com/deeplearning/transformer-engine/user-guide/api/common.html" rel="nofollow">The <code>transformers-engine</code> documentation</a></li> <li><a href="https://azure.github.io/MS-AMP/docs/" rel="nofollow">The <code>MS-AMP</code> documentation</a></li>',Ye,ee,Qe,se,Le;return M=new ae({props:{title:"Low Precision Training Methods",local:"low-precision-training-methods",headingTag:"h1"}}),y=new ae({props:{title:"What training on FP8 means",local:"what-training-on-fp8-means",headingTag:"h2"}}),U=new ae({props:{title:"Configuring the Accelerator",local:"configuring-the-accelerator",headingTag:"h2"}}),v=new te({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnA4JTIyKQ==",highlighted:`from accelerate import Accelerator
<span class="hljs-attribute">accelerator</span> <span class="hljs-operator">=</span> Accelerator(mixed_precision<span class="hljs-operator">=</span><span class="hljs-string">&quot;fp8&quot;</span>)`,wrap:!1}}),C=new te({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwRlA4UmVjaXBlS3dhcmdzJTBBa3dhcmdzJTIwJTNEJTIwJTVCRlA4UmVjaXBlS3dhcmdzKGJhY2tlbmQlM0QlMjJtc2FtcCUyMiklNUQlMEElMjMlMjBPciUyMHRvJTIwc3BlY2lmeSUyMHRoZSUyMGJhY2tlbmQlMjBhcyUyMCU2MFRyYW5zZm9ybWVyc0VuZ2luZSU2MCUyMGV2ZW4lMjBpZiUyME1TLUFNUCUyMGlzJTIwaW5zdGFsbGVkJTBBJTIzJTIwa3dhcmdzJTIwJTNEJTIwJTVCRlA4UmVjaXBlS3dhcmdzKGJhY2tlbmQlM0QlMjJ0ZSUyMiklNUQlMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKG1peGVkX3ByZWNpc2lvbiUzRCUyMmZwOCUyMiUyQyUyMGt3YXJnX2hhbmRsZXJzJTNEa3dhcmdzKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import FP8RecipeKwargs
kwargs = [FP8RecipeKwargs(<span class="hljs-attribute">backend</span>=<span class="hljs-string">&quot;msamp&quot;</span>)]
<span class="hljs-comment"># Or to specify the backend as \`TransformersEngine\` even if MS-AMP is installed</span>
<span class="hljs-comment"># kwargs = [FP8RecipeKwargs(backend=&quot;te&quot;)]</span>
accelerator = Accelerator(<span class="hljs-attribute">mixed_precision</span>=<span class="hljs-string">&quot;fp8&quot;</span>, <span class="hljs-attribute">kwarg_handlers</span>=kwargs)`,wrap:!1}}),B=new te({props:{code:"bWl4ZWRfcHJlY2lzaW9uJTNBJTIwZnA4JTBBZnA4X2NvbmZpZyUzQSUwQSUyMCUyMGFtYXhfY29tcHV0ZV9hbGdvcml0aG0lM0ElMjBtYXglMEElMjAlMjBhbWF4X2hpc3RvcnlfbGVuZ3RoJTNBJTIwMTAyNCUwQSUyMCUyMGJhY2tlbmQlM0ElMjBURSUwQSUyMCUyMGZwOF9mb3JtYXQlM0ElMjBIWUJSSUQlMEElMjAlMjBpbnRlcnZhbCUzQSUyMDElMEElMjAlMjBtYXJnaW4lM0ElMjAwJTBBJTIwJTIwb3ZlcnJpZGVfbGluZWFyX3ByZWNpc2lvbiUzQSUyMGZhbHNlJTBBJTIwJTIwdXNlX2F1dG9jYXN0X2R1cmluZ19ldmFsJTNBJTIwZmFsc2U=",highlighted:`<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">fp8</span>
<span class="hljs-attr">fp8_config:</span>
  <span class="hljs-attr">amax_compute_algorithm:</span> <span class="hljs-string">max</span>
  <span class="hljs-attr">amax_history_length:</span> <span class="hljs-number">1024</span>
  <span class="hljs-attr">backend:</span> <span class="hljs-string">TE</span>
  <span class="hljs-attr">fp8_format:</span> <span class="hljs-string">HYBRID</span>
  <span class="hljs-attr">interval:</span> <span class="hljs-number">1</span>
  <span class="hljs-attr">margin:</span> <span class="hljs-number">0</span>
  <span class="hljs-attr">override_linear_precision:</span> <span class="hljs-literal">false</span>
  <span class="hljs-attr">use_autocast_during_eval:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),Z=new ae({props:{title:"Configuring MS-AMP",local:"configuring-ms-amp",headingTag:"h2"}}),X=new te({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwRlA4UmVjaXBlS3dhcmdzJTBBa3dhcmdzJTIwJTNEJTIwJTVCRlA4UmVjaXBlS3dhcmdzKGJhY2tlbmQlM0QlMjJtc2FtcCUyMiUyQyUyMG9wdGltaXphdGlvbl9sZXZlbCUzRCUyMk8yJTIyKSU1RCUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnA4JTIyJTJDJTIwa3dhcmdfaGFuZGxlcnMlM0Rrd2FyZ3Mp",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import FP8RecipeKwargs
kwargs = [FP8RecipeKwargs(<span class="hljs-attribute">backend</span>=<span class="hljs-string">&quot;msamp&quot;</span>, <span class="hljs-attribute">optimization_level</span>=<span class="hljs-string">&quot;O2&quot;</span>)]
accelerator = Accelerator(<span class="hljs-attribute">mixed_precision</span>=<span class="hljs-string">&quot;fp8&quot;</span>, <span class="hljs-attribute">kwarg_handlers</span>=kwargs)`,wrap:!1}}),z=new te({props:{code:"bWl4ZWRfcHJlY2lzaW9uJTNBJTIwZnA4JTBBZnA4X2NvbmZpZyUzQSUwQSUyMCUyMCUyMCUyMGJhY2tlbmQlM0ElMjBNU0FNUCUwQSUyMCUyMCUyMCUyMG9wdF9sZXZlbCUzQSUyME8y",highlighted:`<span class="hljs-symbol">mixed_precision:</span> fp8
<span class="hljs-symbol">fp8_config:</span>
<span class="hljs-symbol">    backend:</span> MSAMP
<span class="hljs-symbol">    opt_level:</span> O2`,wrap:!1}}),k=new ae({props:{title:"Configuring TransformersEngine",local:"configuring-transformersengine",headingTag:"h2"}}),S=new te({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwRlA4UmVjaXBlS3dhcmdzJTBBa3dhcmdzJTIwJTNEJTIwJTVCRlA4UmVjaXBlS3dhcmdzKGJhY2tlbmQlM0QlMjJ0ZSUyMiUyQyUyMC4uLiklNUQlMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKG1peGVkX3ByZWNpc2lvbiUzRCUyMmZwOCUyMiUyQyUyMGt3YXJnX2hhbmRsZXJzJTNEa3dhcmdzKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import FP8RecipeKwargs
kwargs = [FP8RecipeKwargs(<span class="hljs-attribute">backend</span>=<span class="hljs-string">&quot;te&quot;</span>, <span class="hljs-built_in">..</span>.)]
accelerator = Accelerator(<span class="hljs-attribute">mixed_precision</span>=<span class="hljs-string">&quot;fp8&quot;</span>, <span class="hljs-attribute">kwarg_handlers</span>=kwargs)`,wrap:!1}}),L=new te({props:{code:"bWl4ZWRfcHJlY2lzaW9uJTNBJTIwZnA4JTBBZnA4X2NvbmZpZyUzQSUwQSUyMCUyMCUyMCUyMGFtYXhfY29tcHV0ZV9hbGdvcml0aG0lM0ElMjBtYXglMEElMjAlMjAlMjAlMjBhbWF4X2hpc3RvcnlfbGVuZ3RoJTNBJTIwMTAyNCUwQSUyMCUyMCUyMCUyMGJhY2tlbmQlM0ElMjBURSUwQSUyMCUyMCUyMCUyMGZwOF9mb3JtYXQlM0ElMjBIWUJSSUQlMEElMjAlMjAlMjAlMjBpbnRlcnZhbCUzQSUyMDElMEElMjAlMjAlMjAlMjBtYXJnaW4lM0ElMjAwJTBBJTIwJTIwJTIwJTIwb3ZlcnJpZGVfbGluZWFyX3ByZWNpc2lvbiUzQSUyMGZhbHNlJTBBJTIwJTIwJTIwJTIwdXNlX2F1dG9jYXN0X2R1cmluZ19ldmFsJTNBJTIwZmFsc2U=",highlighted:`<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">fp8</span>
<span class="hljs-attr">fp8_config:</span>
    <span class="hljs-attr">amax_compute_algorithm:</span> <span class="hljs-string">max</span>
    <span class="hljs-attr">amax_history_length:</span> <span class="hljs-number">1024</span>
    <span class="hljs-attr">backend:</span> <span class="hljs-string">TE</span>
    <span class="hljs-attr">fp8_format:</span> <span class="hljs-string">HYBRID</span>
    <span class="hljs-attr">interval:</span> <span class="hljs-number">1</span>
    <span class="hljs-attr">margin:</span> <span class="hljs-number">0</span>
    <span class="hljs-attr">override_linear_precision:</span> <span class="hljs-literal">false</span>
    <span class="hljs-attr">use_autocast_during_eval:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),N=new ae({props:{title:"Example Zoo",local:"example-zoo",headingTag:"h2"}}),K=new ae({props:{title:"Further Reading",local:"further-reading",headingTag:"h2"}}),ee=new _t({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/usage_guides/low_precision_training.md"}}),{c(){f=i("meta"),ne=s(),le=i("p"),ie=s(),c(M.$$.fragment),re=s(),g=i("p"),g.innerHTML=We,pe=s(),c(y.$$.fragment),ce=s(),w=i("p"),w.innerHTML=Ve,oe=s(),T=i("p"),T.textContent=qe,me=s(),b=i("ul"),b.innerHTML=Ke,he=s(),j=i("p"),j.innerHTML=Oe,de=s(),c(U.$$.fragment),ue=s(),J=i("p"),J.innerHTML=De,fe=s(),$=i("p"),$.innerHTML=et,Me=s(),c(v.$$.fragment),ge=s(),_=i("p"),_.innerHTML=tt,ye=s(),c(C.$$.fragment),we=s(),c(B.$$.fragment),Te=s(),c(Z.$$.fragment),be=s(),x=i("p"),x.innerHTML=at,je=s(),A=i("p"),A.innerHTML=lt,Ue=s(),P=i("ul"),P.innerHTML=st,Je=s(),G=i("p"),G.innerHTML=nt,$e=s(),c(X.$$.fragment),ve=s(),F=i("p"),F.innerHTML=it,_e=s(),H=i("p"),H.innerHTML=rt,Ce=s(),c(z.$$.fragment),Be=s(),c(k.$$.fragment),Ze=s(),E=i("p"),E.innerHTML=pt,xe=s(),I=i("p"),I.textContent=ct,Ae=s(),R=i("p"),R.innerHTML=ot,Pe=s(),c(S.$$.fragment),Ge=s(),Y=i("p"),Y.innerHTML=mt,Xe=s(),Q=i("p"),Q.innerHTML=ht,Fe=s(),c(L.$$.fragment),He=s(),c(N.$$.fragment),ze=s(),W=i("p"),W.textContent=dt,ke=s(),V=i("ul"),V.innerHTML=ut,Ee=s(),q=i("p"),q.innerHTML=ft,Ie=s(),c(K.$$.fragment),Re=s(),O=i("p"),O.textContent=Mt,Se=s(),D=i("ul"),D.innerHTML=gt,Ye=s(),c(ee.$$.fragment),Qe=s(),se=i("p"),this.h()},l(e){const t=$t("svelte-u9bgzb",document.head);f=r(t,"META",{name:!0,content:!0}),t.forEach(a),ne=n(e),le=r(e,"P",{}),yt(le).forEach(a),ie=n(e),o(M.$$.fragment,e),re=n(e),g=r(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-15725la"&&(g.innerHTML=We),pe=n(e),o(y.$$.fragment,e),ce=n(e),w=r(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-of2aev"&&(w.innerHTML=Ve),oe=n(e),T=r(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-10cwb11"&&(T.textContent=qe),me=n(e),b=r(e,"UL",{"data-svelte-h":!0}),p(b)!=="svelte-5d1df8"&&(b.innerHTML=Ke),he=n(e),j=r(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1j45xey"&&(j.innerHTML=Oe),de=n(e),o(U.$$.fragment,e),ue=n(e),J=r(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-ewzxpg"&&(J.innerHTML=De),fe=n(e),$=r(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-iuaa3o"&&($.innerHTML=et),Me=n(e),o(v.$$.fragment,e),ge=n(e),_=r(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1a4n8yf"&&(_.innerHTML=tt),ye=n(e),o(C.$$.fragment,e),we=n(e),o(B.$$.fragment,e),Te=n(e),o(Z.$$.fragment,e),be=n(e),x=r(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-13jlsqr"&&(x.innerHTML=at),je=n(e),A=r(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-11lh24s"&&(A.innerHTML=lt),Ue=n(e),P=r(e,"UL",{"data-svelte-h":!0}),p(P)!=="svelte-ha185h"&&(P.innerHTML=st),Je=n(e),G=r(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-wx6vs8"&&(G.innerHTML=nt),$e=n(e),o(X.$$.fragment,e),ve=n(e),F=r(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-vo4vij"&&(F.innerHTML=it),_e=n(e),H=r(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1n0fir7"&&(H.innerHTML=rt),Ce=n(e),o(z.$$.fragment,e),Be=n(e),o(k.$$.fragment,e),Ze=n(e),E=r(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-ngle0n"&&(E.innerHTML=pt),xe=n(e),I=r(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-18df25g"&&(I.textContent=ct),Ae=n(e),R=r(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-8khoko"&&(R.innerHTML=ot),Pe=n(e),o(S.$$.fragment,e),Ge=n(e),Y=r(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-99qxte"&&(Y.innerHTML=mt),Xe=n(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1n0fir7"&&(Q.innerHTML=ht),Fe=n(e),o(L.$$.fragment,e),He=n(e),o(N.$$.fragment,e),ze=n(e),W=r(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1ay0trc"&&(W.textContent=dt),ke=n(e),V=r(e,"UL",{"data-svelte-h":!0}),p(V)!=="svelte-1affbo7"&&(V.innerHTML=ut),Ee=n(e),q=r(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-sau342"&&(q.innerHTML=ft),Ie=n(e),o(K.$$.fragment,e),Re=n(e),O=r(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-t5s4ol"&&(O.textContent=Mt),Se=n(e),D=r(e,"UL",{"data-svelte-h":!0}),p(D)!=="svelte-1ipwzpl"&&(D.innerHTML=gt),Ye=n(e),o(ee.$$.fragment,e),Qe=n(e),se=r(e,"P",{}),yt(se).forEach(a),this.h()},h(){wt(f,"name","hf:doc:metadata"),wt(f,"content",Bt)},m(e,t){vt(document.head,f),l(e,ne,t),l(e,le,t),l(e,ie,t),m(M,e,t),l(e,re,t),l(e,g,t),l(e,pe,t),m(y,e,t),l(e,ce,t),l(e,w,t),l(e,oe,t),l(e,T,t),l(e,me,t),l(e,b,t),l(e,he,t),l(e,j,t),l(e,de,t),m(U,e,t),l(e,ue,t),l(e,J,t),l(e,fe,t),l(e,$,t),l(e,Me,t),m(v,e,t),l(e,ge,t),l(e,_,t),l(e,ye,t),m(C,e,t),l(e,we,t),m(B,e,t),l(e,Te,t),m(Z,e,t),l(e,be,t),l(e,x,t),l(e,je,t),l(e,A,t),l(e,Ue,t),l(e,P,t),l(e,Je,t),l(e,G,t),l(e,$e,t),m(X,e,t),l(e,ve,t),l(e,F,t),l(e,_e,t),l(e,H,t),l(e,Ce,t),m(z,e,t),l(e,Be,t),m(k,e,t),l(e,Ze,t),l(e,E,t),l(e,xe,t),l(e,I,t),l(e,Ae,t),l(e,R,t),l(e,Pe,t),m(S,e,t),l(e,Ge,t),l(e,Y,t),l(e,Xe,t),l(e,Q,t),l(e,Fe,t),m(L,e,t),l(e,He,t),m(N,e,t),l(e,ze,t),l(e,W,t),l(e,ke,t),l(e,V,t),l(e,Ee,t),l(e,q,t),l(e,Ie,t),m(K,e,t),l(e,Re,t),l(e,O,t),l(e,Se,t),l(e,D,t),l(e,Ye,t),m(ee,e,t),l(e,Qe,t),l(e,se,t),Le=!0},p:bt,i(e){Le||(h(M.$$.fragment,e),h(y.$$.fragment,e),h(U.$$.fragment,e),h(v.$$.fragment,e),h(C.$$.fragment,e),h(B.$$.fragment,e),h(Z.$$.fragment,e),h(X.$$.fragment,e),h(z.$$.fragment,e),h(k.$$.fragment,e),h(S.$$.fragment,e),h(L.$$.fragment,e),h(N.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),Le=!0)},o(e){d(M.$$.fragment,e),d(y.$$.fragment,e),d(U.$$.fragment,e),d(v.$$.fragment,e),d(C.$$.fragment,e),d(B.$$.fragment,e),d(Z.$$.fragment,e),d(X.$$.fragment,e),d(z.$$.fragment,e),d(k.$$.fragment,e),d(S.$$.fragment,e),d(L.$$.fragment,e),d(N.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),Le=!1},d(e){e&&(a(ne),a(le),a(ie),a(re),a(g),a(pe),a(ce),a(w),a(oe),a(T),a(me),a(b),a(he),a(j),a(de),a(ue),a(J),a(fe),a($),a(Me),a(ge),a(_),a(ye),a(we),a(Te),a(be),a(x),a(je),a(A),a(Ue),a(P),a(Je),a(G),a($e),a(ve),a(F),a(_e),a(H),a(Ce),a(Be),a(Ze),a(E),a(xe),a(I),a(Ae),a(R),a(Pe),a(Ge),a(Y),a(Xe),a(Q),a(Fe),a(He),a(ze),a(W),a(ke),a(V),a(Ee),a(q),a(Ie),a(Re),a(O),a(Se),a(D),a(Ye),a(Qe),a(se)),a(f),u(M,e),u(y,e),u(U,e),u(v,e),u(C,e),u(B,e),u(Z,e),u(X,e),u(z,e),u(k,e),u(S,e),u(L,e),u(N,e),u(K,e),u(ee,e)}}}const Bt='{"title":"Low Precision Training Methods","local":"low-precision-training-methods","sections":[{"title":"What training on FP8 means","local":"what-training-on-fp8-means","sections":[],"depth":2},{"title":"Configuring the Accelerator","local":"configuring-the-accelerator","sections":[],"depth":2},{"title":"Configuring MS-AMP","local":"configuring-ms-amp","sections":[],"depth":2},{"title":"Configuring TransformersEngine","local":"configuring-transformersengine","sections":[],"depth":2},{"title":"Example Zoo","local":"example-zoo","sections":[],"depth":2},{"title":"Further Reading","local":"further-reading","sections":[],"depth":2}],"depth":1}';function Zt(Ne){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xt extends Ut{constructor(f){super(),Jt(this,f,Zt,Ct,Tt,{})}}export{Xt as component};
