import{s as Bl,o as El,n as Qt}from"../chunks/scheduler.c57aa7ef.js";import{S as Vl,i as Xl,g as o,s as n,r,A as Fl,h as i,f as l,c as a,j as Il,u as c,x as m,k as Rl,y as Al,a as s,v as d,d as u,t as y,w as M}from"../chunks/index.394f8801.js";import{T as St}from"../chunks/Tip.23dfb1a9.js";import{C as f}from"../chunks/CodeBlock.5228ed01.js";import{H as _e,E as Nl}from"../chunks/EditOnGithub.157fddbf.js";function Yl(J){let p,b=`For this toy example, we choose an exceedingly large number of hidden units to highlight the efficiency gains
from PEFT, but those gains are in line with more realistic examples.`;return{c(){p=o("p"),p.textContent=b},l(h){p=i(h,"P",{"data-svelte-h":!0}),m(p)!=="svelte-7te1s3"&&(p.textContent=b)},m(h,w){s(h,p,w)},p:Qt,d(h){h&&l(p)}}}function Hl(J){let p,b="This feature is experimental and subject to change, depending on its reception by the community. We will introduce a public and stable API if there is significant demand for it.";return{c(){p=o("p"),p.textContent=b},l(h){p=i(h,"P",{"data-svelte-h":!0}),m(p)!=="svelte-1u15dlh"&&(p.textContent=b)},m(h,w){s(h,p,w)},p:Qt,d(h){h&&l(p)}}}function Sl(J){let p,b='When you call <a href="/docs/peft/v0.15.0/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a>, you will see a warning because PEFT does not recognize the targeted module type. In this case, you can ignore this warning.';return{c(){p=o("p"),p.innerHTML=b},l(h){p=i(h,"P",{"data-svelte-h":!0}),m(p)!=="svelte-1wuejnc"&&(p.innerHTML=b)},m(h,w){s(h,p,w)},p:Qt,d(h){h&&l(p)}}}function Ql(J){let p,b,h,w,k,We,x,zt=`Some fine-tuning techniques, such as prompt tuning, are specific to language models. That means in 🤗 PEFT, it is
assumed a 🤗 Transformers model is being used. However, other fine-tuning techniques - like
<a href="../conceptual_guides/lora">LoRA</a> - are not restricted to specific model types.`,Ie,U,Pt='In this guide, we will see how LoRA can be applied to a multilayer perceptron, a computer vision model from the <a href="https://huggingface.co/docs/timm/index" rel="nofollow">timm</a> library, or a new 🤗 Transformers architecture.',Re,Z,Be,C,qt="Let’s assume that we want to fine-tune a multilayer perceptron with LoRA. Here is the definition:",Ee,v,Ve,L,Dt="This is a straightforward multilayer perceptron with an input layer, a hidden layer, and an output layer.",Xe,T,Fe,$,Kt=`There are a few linear layers in this model that could be tuned with LoRA. When working with common 🤗 Transformers
models, PEFT will know which layers to apply LoRA to, but in this case, it is up to us as a user to choose the layers.
To determine the names of the layers to tune:`,Ae,_,Ne,G,Ot="This should print:",Ye,W,He,I,el=`Let’s say we want to apply LoRA to the input layer and to the hidden layer, those are <code>&#39;seq.0&#39;</code> and <code>&#39;seq.2&#39;</code>. Moreover,
let’s assume we want to update the output layer without LoRA, that would be <code>&#39;seq.4&#39;</code>. The corresponding config would
be:`,Se,R,Qe,B,tl="With that, we can create our PEFT model and check the fraction of parameters trained:",ze,E,Pe,V,ll="Finally, we can use any training framework we like, or write our own fit loop, to train the <code>peft_model</code>.",qe,X,sl='For a complete example, check out <a href="https://github.com/huggingface/peft/blob/main/examples/multilayer_perceptron/multilayer_perceptron_lora.ipynb" rel="nofollow">this notebook</a>.',De,F,Ke,A,nl=`The <a href="https://huggingface.co/docs/timm/index" rel="nofollow">timm</a> library contains a large number of pretrained computer vision models.
Those can also be fine-tuned with PEFT. Let’s check out how this works in practice.`,Oe,N,al="To start, ensure that timm is installed in the Python environment:",et,Y,tt,H,ol="Next we load a timm model for an image classification task:",lt,S,st,Q,il=`Again, we need to make a decision about what layers to apply LoRA to. Since LoRA supports 2D conv layers, and since
those are a major building block of this model, we should apply LoRA to the 2D conv layers. To identify the names of
those layers, let’s look at all the layer names:`,nt,z,at,P,ml="This will print a very long list, we’ll only show the first few:",ot,q,it,D,pl=`Upon closer inspection, we see that the 2D conv layers have names such as <code>&quot;stages.0.blocks.0.mlp.fc1&quot;</code> and
<code>&quot;stages.0.blocks.0.mlp.fc2&quot;</code>. How can we match those layer names specifically? You can write a <a href="https://docs.python.org/3/library/re.html" rel="nofollow">regular
expressions</a> to match the layer names. For our case, the regex
<code>r&quot;.*\\.mlp\\.fc\\d&quot;</code> should do the job.`,mt,K,rl=`Furthermore, as in the first example, we should ensure that the output layer, in this case the classification head, is
also updated. Looking at the end of the list printed above, we can see that it’s named <code>&#39;head.fc&#39;</code>. With that in mind,
here is our LoRA config:`,pt,O,rt,ee,cl="Then we only need to create the PEFT model by passing our base model and the config to <code>get_peft_model</code>:",ct,te,dt,le,dl="This shows us that we only need to train less than 2% of all parameters, which is a huge efficiency gain.",ut,se,ul='For a complete example, check out <a href="https://github.com/huggingface/peft/blob/main/examples/image_classification/image_classification_timm_peft_lora.ipynb" rel="nofollow">this notebook</a>.',yt,ne,Mt,ae,yl="When new popular transformers architectures are released, we do our best to quickly add them to PEFT. If you come across a transformers model that is not supported out of the box, don’t worry, it will most likely still work if the config is set correctly. Specifically, you have to identify the layers that should be adapted and set them correctly when initializing the corresponding config class, e.g. <code>LoraConfig</code>. Here are some tips to help with this.",ht,oe,Ml='As a first step, it is a good idea is to check the existing models for inspiration. You can find them inside of <a href="https://github.com/huggingface/peft/blob/main/src/peft/utils/constants.py" rel="nofollow">constants.py</a> in the PEFT repository. Often, you’ll find a similar architecture that uses the same names. For example, if the new model architecture is a variation of the “mistral” model and you want to apply LoRA, you can see that the entry for “mistral” in <code>TRANSFORMERS_MODELS_TO_LORA_TARGET_MODULES_MAPPING</code> contains <code>[&quot;q_proj&quot;, &quot;v_proj&quot;]</code>. This tells you that for “mistral” models, the <code>target_modules</code> for LoRA should be <code>[&quot;q_proj&quot;, &quot;v_proj&quot;]</code>:',ft,ie,bt,me,hl="If that doesn’t help, check the existing modules in your model architecture with the <code>named_modules</code> method and try to identify the attention layers, especially the key, query, and value layers. Those will often have names such as <code>c_attn</code>, <code>query</code>, <code>q_proj</code>, etc. The key layer is not always adapted, and ideally, you should check whether including it results in better performance.",wt,pe,fl='Additionally, linear layers are common targets to be adapted (e.g. in <a href="https://arxiv.org/abs/2305.14314" rel="nofollow">QLoRA paper</a>, authors suggest to adapt them as well). Their names will often contain the strings <code>fc</code> or <code>dense</code>.',Jt,re,bl='If you want to add a new model to PEFT, please create an entry in <a href="https://github.com/huggingface/peft/blob/main/src/peft/utils/constants.py" rel="nofollow">constants.py</a> and open a pull request on the <a href="https://github.com/huggingface/peft/pulls" rel="nofollow">repository</a>. Don’t forget to update the <a href="https://github.com/huggingface/peft#models-support-matrix" rel="nofollow">README</a> as well.',Tt,ce,jt,de,wl="You can verify whether you’ve correctly applied a PEFT method to your model in a few ways.",gt,ue,Jl='<li>Check the fraction of parameters that are trainable with the <a href="/docs/peft/v0.15.0/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a> method. If this number is lower or higher than expected, check the model <code>repr</code> by printing the model. This shows the names of all the layer types in the model. Ensure that only the intended target layers are replaced by the adapter layers. For example, if LoRA is applied to <code>nn.Linear</code> layers, then you should only see <code>lora.Linear</code> layers being used.</li>',kt,ye,xt,Me,Tl="<li>Another way you can view the adapted layers is to use the <code>targeted_module_names</code> attribute to list the name of each module that was adapted.</li>",Ut,he,Zt,fe,Ct,be,jl="Methods like LoRA only work if the target modules are supported by PEFT. For example, it’s possible to apply LoRA to <code>nn.Linear</code> and <code>nn.Conv2d</code> layers, but not, for instance, to <code>nn.LSTM</code>. If you find a layer class you want to apply PEFT to is not supported, you can:",vt,we,gl='<li>define a custom mapping to dynamically dispatch custom modules in LoRA</li> <li>open an <a href="https://github.com/huggingface/peft/issues" rel="nofollow">issue</a> and request the feature where maintainers will implement it or guide you on how to implement it yourself if demand for this module type is sufficiently high</li>',Lt,Je,$t,j,_t,Te,kl="PEFT supports an experimental API for custom module types for LoRA. Let’s assume you have a LoRA implementation for LSTMs. Normally, you would not be able to tell PEFT to use it, even if it would theoretically work with PEFT. However, this is possible with dynamic dispatch of custom layers.",Gt,je,xl="The experimental API currently looks like this:",Wt,ge,It,g,Rt,ke,Ul="By supplying a custom mapping, PEFT first checks the base model’s layers against the custom mapping and dispatches to the custom LoRA layer type if there is a match. If there is no match, PEFT checks the built-in LoRA layer types for a match.",Bt,xe,Zl="Therefore, this feature can also be used to override existing dispatch logic, e.g. if you want to use your own LoRA layer for <code>nn.Linear</code> instead of using the one provided by PEFT.",Et,Ue,Cl='When creating your custom LoRA module, please follow the same rules as the <a href="https://github.com/huggingface/peft/blob/main/src/peft/tuners/lora/layer.py" rel="nofollow">existing LoRA modules</a>. Some important constraints to consider:',Vt,Ze,vl="<li>The custom module should inherit from <code>nn.Module</code> and <code>peft.tuners.lora.layer.LoraLayer</code>.</li> <li>The <code>__init__</code> method of the custom module should have the positional arguments <code>base_layer</code> and <code>adapter_name</code>. After this, there are additional <code>**kwargs</code> that you are free to use or ignore.</li> <li>The learnable parameters should be stored in an <code>nn.ModuleDict</code> or <code>nn.ParameterDict</code>, where the key corresponds to the name of the specific adapter (remember that a model can have more than one adapter at a time).</li> <li>The name of these learnable parameter attributes should start with <code>&quot;lora_&quot;</code>, e.g. <code>self.lora_new_param = ...</code>.</li> <li>Some methods are optional, e.g. you only need to implement <code>merge</code> and <code>unmerge</code> if you want to support weight merging.</li>",Xt,Ce,Ll="Currently, the information about the custom module does not persist when you save the model. When loading the model, you have to register the custom modules again.",Ft,ve,At,Le,$l="If you use this feature and find it useful, or if you encounter problems, let us know by creating an issue or a discussion on GitHub. This allows us to estimate the demand for this feature and add a public API if it is sufficiently high.",Nt,$e,Yt,Ge,Ht;return k=new _e({props:{title:"Custom models",local:"custom-models",headingTag:"h1"}}),Z=new _e({props:{title:"Multilayer perceptron",local:"multilayer-perceptron",headingTag:"h2"}}),v=new f({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEElMEElMEFjbGFzcyUyME1MUChubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMG51bV91bml0c19oaWRkZW4lM0QyMDAwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuc2VxJTIwJTNEJTIwbm4uU2VxdWVudGlhbCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5MaW5lYXIoMjAlMkMlMjBudW1fdW5pdHNfaGlkZGVuKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLlJlTFUoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLkxpbmVhcihudW1fdW5pdHNfaGlkZGVuJTJDJTIwbnVtX3VuaXRzX2hpZGRlbiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5SZUxVKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5MaW5lYXIobnVtX3VuaXRzX2hpZGRlbiUyQyUyMDIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uTG9nU29mdG1heChkaW0lM0QtMSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwWCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLnNlcShYKQ==",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MLP</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_units_hidden=<span class="hljs-number">2000</span></span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.seq = nn.Sequential(
            nn.Linear(<span class="hljs-number">20</span>, num_units_hidden),
            nn.ReLU(),
            nn.Linear(num_units_hidden, num_units_hidden),
            nn.ReLU(),
            nn.Linear(num_units_hidden, <span class="hljs-number">2</span>),
            nn.LogSoftmax(dim=-<span class="hljs-number">1</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, X</span>):
        <span class="hljs-keyword">return</span> self.seq(X)`,wrap:!1}}),T=new St({props:{$$slots:{default:[Yl]},$$scope:{ctx:J}}}),_=new f({props:{code:"cHJpbnQoJTVCKG4lMkMlMjB0eXBlKG0pKSUyMGZvciUyMG4lMkMlMjBtJTIwaW4lMjBNTFAoKS5uYW1lZF9tb2R1bGVzKCklNUQp",highlighted:'<span class="hljs-built_in">print</span>([(n, <span class="hljs-built_in">type</span>(m)) <span class="hljs-keyword">for</span> n, m <span class="hljs-keyword">in</span> MLP().named_modules()])',wrap:!1}}),W=new f({props:{code:"JTVCKCcnJTJDJTIwX19tYWluX18uTUxQKSUyQyUwQSUyMCgnc2VxJyUyQyUyMHRvcmNoLm5uLm1vZHVsZXMuY29udGFpbmVyLlNlcXVlbnRpYWwpJTJDJTBBJTIwKCdzZXEuMCclMkMlMjB0b3JjaC5ubi5tb2R1bGVzLmxpbmVhci5MaW5lYXIpJTJDJTBBJTIwKCdzZXEuMSclMkMlMjB0b3JjaC5ubi5tb2R1bGVzLmFjdGl2YXRpb24uUmVMVSklMkMlMEElMjAoJ3NlcS4yJyUyQyUyMHRvcmNoLm5uLm1vZHVsZXMubGluZWFyLkxpbmVhciklMkMlMEElMjAoJ3NlcS4zJyUyQyUyMHRvcmNoLm5uLm1vZHVsZXMuYWN0aXZhdGlvbi5SZUxVKSUyQyUwQSUyMCgnc2VxLjQnJTJDJTIwdG9yY2gubm4ubW9kdWxlcy5saW5lYXIuTGluZWFyKSUyQyUwQSUyMCgnc2VxLjUnJTJDJTIwdG9yY2gubm4ubW9kdWxlcy5hY3RpdmF0aW9uLkxvZ1NvZnRtYXgpJTVE",highlighted:`[(&#x27;&#x27;, __main__.MLP),
 (<span class="hljs-symbol">&#x27;seq</span>&#x27;, torch.nn.modules.container.Sequential),
 (<span class="hljs-symbol">&#x27;seq.0</span>&#x27;, torch.nn.modules.linear.Linear),
 (<span class="hljs-symbol">&#x27;seq.1</span>&#x27;, torch.nn.modules.activation.ReLU),
 (<span class="hljs-symbol">&#x27;seq.2</span>&#x27;, torch.nn.modules.linear.Linear),
 (<span class="hljs-symbol">&#x27;seq.3</span>&#x27;, torch.nn.modules.activation.ReLU),
 (<span class="hljs-symbol">&#x27;seq.4</span>&#x27;, torch.nn.modules.linear.Linear),
 (<span class="hljs-symbol">&#x27;seq.5</span>&#x27;, torch.nn.modules.activation.LogSoftmax)]`,wrap:!1}}),R=new f({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnNlcS4wJTIyJTJDJTIwJTIyc2VxLjIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVzX3RvX3NhdmUlM0QlNUIlMjJzZXEuNCUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;seq.0&quot;</span>, <span class="hljs-string">&quot;seq.2&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;seq.4&quot;</span>],
)`,wrap:!1}}),E=new f({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwTUxQKCklMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcpJTBBcGVmdF9tb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIzJTIwcHJpbnRzJTIwdHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwNTYlMkMxNjQlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA0JTJDMTAwJTJDMTY0JTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMS4zNjk3OTg4NjY1ODE5MjI=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = MLP()
peft_model = get_peft_model(model, config)
peft_model.print_trainable_parameters()
<span class="hljs-comment"># prints trainable params: 56,164 || all params: 4,100,164 || trainable%: 1.369798866581922</span>`,wrap:!1}}),F=new _e({props:{title:"timm models",local:"timm-models",headingTag:"h2"}}),Y=new f({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjB0aW1t",highlighted:"python -m pip install -U timm",wrap:!1}}),S=new f({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQW51bV9jbGFzc2VzJTIwJTNEJTIwLi4uJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJ0aW1tJTJGcG9vbGZvcm1lcl9tMzYuc2FpbF9pbjFrJTIyJTBBbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbChtb2RlbF9pZCUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fY2xhc3Nlcyk=",highlighted:`<span class="hljs-keyword">import</span> timm

num_classes = ...
model_id = <span class="hljs-string">&quot;timm/poolformer_m36.sail_in1k&quot;</span>
model = timm.create_model(model_id, pretrained=<span class="hljs-literal">True</span>, num_classes=num_classes)`,wrap:!1}}),z=new f({props:{code:"cHJpbnQoJTVCKG4lMkMlMjB0eXBlKG0pKSUyMGZvciUyMG4lMkMlMjBtJTIwaW4lMjBtb2RlbC5uYW1lZF9tb2R1bGVzKCklNUQp",highlighted:'<span class="hljs-built_in">print</span>([(n, <span class="hljs-built_in">type</span>(m)) <span class="hljs-keyword">for</span> n, m <span class="hljs-keyword">in</span> model.named_modules()])',wrap:!1}}),q=new f({props:{code:"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",highlighted:`[(<span class="hljs-string">&#x27;&#x27;</span>, timm.models.metaformer.MetaFormer),
 (<span class="hljs-string">&#x27;stem&#x27;</span>, timm.models.metaformer.Stem),
 (<span class="hljs-string">&#x27;stem.conv&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.conv.Conv2d),
 (<span class="hljs-string">&#x27;stem.norm&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.container.Sequential),
 (<span class="hljs-string">&#x27;stages.0&#x27;</span>, timm.models.metaformer.MetaFormerStage),
 (<span class="hljs-string">&#x27;stages.0.downsample&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.container.Sequential),
 (<span class="hljs-string">&#x27;stages.0.blocks.0&#x27;</span>, timm.models.metaformer.MetaFormerBlock),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.norm1&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.GroupNorm1),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.token_mixer&#x27;</span>, timm.models.metaformer.Pooling),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.token_mixer.pool&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.pooling.AvgPool2d),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.drop_path1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.layer_scale1&#x27;</span>, timm.models.metaformer.Scale),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.res_scale1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.norm2&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.GroupNorm1),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp&#x27;</span>, timm.layers.mlp.Mlp),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.fc1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.conv.Conv2d),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.act&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.activation.GELU),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.drop1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.dropout.Dropout),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.norm&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.fc2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.conv.Conv2d),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.drop2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.dropout.Dropout),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.drop_path2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.layer_scale2&#x27;</span>, timm.models.metaformer.Scale),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.res_scale2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.1&#x27;</span>, timm.models.metaformer.MetaFormerBlock),
 (<span class="hljs-string">&#x27;stages.0.blocks.1.norm1&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.GroupNorm1),
 (<span class="hljs-string">&#x27;stages.0.blocks.1.token_mixer&#x27;</span>, timm.models.metaformer.Pooling),
 (<span class="hljs-string">&#x27;stages.0.blocks.1.token_mixer.pool&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.pooling.AvgPool2d),
 ...
 (<span class="hljs-string">&#x27;head.global_pool.flatten&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;head.norm&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.LayerNorm2d),
 (<span class="hljs-string">&#x27;head.flatten&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.flatten.Flatten),
 (<span class="hljs-string">&#x27;head.drop&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;head.fc&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Linear)]
 ]`,wrap:!1}}),O=new f({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRHIlMjIuKiU1Qy5tbHAlNUMuZmMlNUNkJTIyJTJDJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyaGVhZC5mYyUyMiU1RCk=",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">r&quot;.*\\.mlp\\.fc\\d&quot;</span>, modules_to_save=[<span class="hljs-string">&quot;head.fc&quot;</span>])',wrap:!1}}),te=new f({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwY29uZmlnKSUwQXBlZnRfbW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKSUwQSUyMyUyMHByaW50cyUyMHRyYWluYWJsZSUyMHBhcmFtcyUzQSUyMDElMkMwNjQlMkM0NTQlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA1NiUyQzQ2NyUyQzk3NCUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDEuODg1MDU3ODkxMzk4NzY=",highlighted:`peft_model = get_peft_model(model, config)
peft_model.print_trainable_parameters()
<span class="hljs-comment"># prints trainable params: 1,064,454 || all params: 56,467,974 || trainable%: 1.88505789139876</span>`,wrap:!1}}),ne=new _e({props:{title:"New transformers architectures",local:"new-transformers-architectures",headingTag:"h2"}}),ie=new f({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFteV9taXN0cmFsX21vZGVsJTIwJTNEJTIwLi4uJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnFfcHJvaiUyMiUyQyUyMCUyMnZfcHJvaiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMC4uLiUyQyUyMCUyMCUyMyUyMG90aGVyJTIwTG9SQSUyMGFyZ3VtZW50cyUwQSklMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobXlfbWlzdHJhbF9tb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

my_mistral_model = ...
config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>],
    ...,  <span class="hljs-comment"># other LoRA arguments</span>
)
peft_model = get_peft_model(my_mistral_model, config)`,wrap:!1}}),ce=new _e({props:{title:"Verify parameters and layers",local:"verify-parameters-and-layers",headingTag:"h2"}}),ye=new f({props:{code:"cGVmdF9tb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygp",highlighted:"peft_model.print_trainable_parameters()",wrap:!1}}),he=new f({props:{code:"cHJpbnQocGVmdF9tb2RlbC50YXJnZXRlZF9tb2R1bGVfbmFtZXMp",highlighted:'<span class="hljs-built_in">print</span>(peft_model.targeted_module_names)',wrap:!1}}),fe=new _e({props:{title:"Unsupported module types",local:"unsupported-module-types",headingTag:"h2"}}),Je=new _e({props:{title:"Experimental support for dynamic dispatch of custom modules in LoRA",local:"experimental-support-for-dynamic-dispatch-of-custom-modules-in-lora",headingTag:"h3"}}),j=new St({props:{warning:!0,$$slots:{default:[Hl]},$$scope:{ctx:J}}}),ge=new f({props:{code:"Y2xhc3MlMjBNeUxvcmFMU1RNTGF5ZXIlM0ElMEElMjAlMjAlMjAlMjAuLi4lMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwLi4uJTIwJTIwJTIzJTIwbG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUyMHRoYXQlMjB1c2VzJTIwTFNUTXMlMEElMEElMjMlMjBhZGQlMjB0aGUlMjBMU1RNJTIwbGF5ZXIlMjBuYW1lcyUyMHRvJTIwdGFyZ2V0X21vZHVsZXMlMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiUyQyUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIybHN0bSUyMiU1RCklMEElMjMlMjBkZWZpbmUlMjBhJTIwbWFwcGluZyUyMGZyb20lMjBiYXNlJTIwbGF5ZXIlMjB0eXBlJTIwdG8lMjBMb1JBJTIwbGF5ZXIlMjB0eXBlJTBBY3VzdG9tX21vZHVsZV9tYXBwaW5nJTIwJTNEJTIwJTdCbm4uTFNUTSUzQSUyME15TG9yYUxTVE1MYXllciU3RCUwQSUyMyUyMHJlZ2lzdGVyJTIwdGhlJTIwbmV3JTIwbWFwcGluZyUwQWNvbmZpZy5fcmVnaXN0ZXJfY3VzdG9tX21vZHVsZShjdXN0b21fbW9kdWxlX21hcHBpbmcpJTBBJTIzJTIwYWZ0ZXIlMjByZWdpc3RyYXRpb24lMkMlMjBjcmVhdGUlMjB0aGUlMjBQRUZUJTIwbW9kZWwlMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwoYmFzZV9tb2RlbCUyQyUyMGNvbmZpZyklMEElMjMlMjBkbyUyMHRyYWluaW5n",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyLoraLSTMLayer</span>:
    ...

base_model = ...  <span class="hljs-comment"># load the base model that uses LSTMs</span>

<span class="hljs-comment"># add the LSTM layer names to target_modules</span>
config = LoraConfig(..., target_modules=[<span class="hljs-string">&quot;lstm&quot;</span>])
<span class="hljs-comment"># define a mapping from base layer type to LoRA layer type</span>
custom_module_mapping = {nn.LSTM: MyLoraLSTMLayer}
<span class="hljs-comment"># register the new mapping</span>
config._register_custom_module(custom_module_mapping)
<span class="hljs-comment"># after registration, create the PEFT model</span>
peft_model = get_peft_model(base_model, config)
<span class="hljs-comment"># do training</span>`,wrap:!1}}),g=new St({props:{$$slots:{default:[Sl]},$$scope:{ctx:J}}}),ve=new f({props:{code:"JTIzJTIwc2F2aW5nJTIwd29ya3MlMjBhcyUyMGFsd2F5cyUyMGFuZCUyMGluY2x1ZGVzJTIwdGhlJTIwcGFyYW1ldGVycyUyMG9mJTIwdGhlJTIwY3VzdG9tJTIwbW9kdWxlcyUwQXBlZnRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUzQ21vZGVsLXBhdGglM0UpJTBBJTBBJTIzJTIwbG9hZGluZyUyMHRoZSUyMG1vZGVsJTIwbGF0ZXIlM0ElMEFiYXNlX21vZGVsJTIwJTNEJTIwLi4uJTBBJTIzJTIwbG9hZCUyMHRoZSUyMExvUkElMjBjb25maWclMjB0aGF0JTIweW91JTIwc2F2ZWQlMjBlYXJsaWVyJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTNDbW9kZWwtcGF0aCUzRSklMEElMjMlMjByZWdpc3RlciUyMHRoZSUyMGN1c3RvbSUyMG1vZHVsZSUyMGFnYWluJTJDJTIwdGhlJTIwc2FtZSUyMHdheSUyMGFzJTIwdGhlJTIwZmlyc3QlMjB0aW1lJTBBY3VzdG9tX21vZHVsZV9tYXBwaW5nJTIwJTNEJTIwJTdCbm4uTFNUTSUzQSUyME15TG9yYUxTVE1MYXllciU3RCUwQWNvbmZpZy5fcmVnaXN0ZXJfY3VzdG9tX21vZHVsZShjdXN0b21fbW9kdWxlX21hcHBpbmcpJTBBJTIzJTIwcGFzcyUyMHRoZSUyMGNvbmZpZyUyMGluc3RhbmNlJTIwdG8lMjBmcm9tX3ByZXRyYWluZWQlM0ElMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMHRtcF9wYXRoJTIwJTJGJTIwJTIybG9yYS1jdXN0b20tbW9kdWxlJTIyJTJDJTIwY29uZmlnJTNEY29uZmlnKQ==",highlighted:`<span class="hljs-comment"># saving works as always and includes the parameters of the custom modules</span>
peft_model.save_pretrained(&lt;model-path&gt;)

<span class="hljs-comment"># loading the model later:</span>
base_model = ...
<span class="hljs-comment"># load the LoRA config that you saved earlier</span>
config = LoraConfig.from_pretrained(&lt;model-path&gt;)
<span class="hljs-comment"># register the custom module again, the same way as the first time</span>
custom_module_mapping = {nn.LSTM: MyLoraLSTMLayer}
config._register_custom_module(custom_module_mapping)
<span class="hljs-comment"># pass the config instance to from_pretrained:</span>
peft_model = PeftModel.from_pretrained(model, tmp_path / <span class="hljs-string">&quot;lora-custom-module&quot;</span>, config=config)`,wrap:!1}}),$e=new Nl({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/custom_models.md"}}),{c(){p=o("meta"),b=n(),h=o("p"),w=n(),r(k.$$.fragment),We=n(),x=o("p"),x.innerHTML=zt,Ie=n(),U=o("p"),U.innerHTML=Pt,Re=n(),r(Z.$$.fragment),Be=n(),C=o("p"),C.textContent=qt,Ee=n(),r(v.$$.fragment),Ve=n(),L=o("p"),L.textContent=Dt,Xe=n(),r(T.$$.fragment),Fe=n(),$=o("p"),$.textContent=Kt,Ae=n(),r(_.$$.fragment),Ne=n(),G=o("p"),G.textContent=Ot,Ye=n(),r(W.$$.fragment),He=n(),I=o("p"),I.innerHTML=el,Se=n(),r(R.$$.fragment),Qe=n(),B=o("p"),B.textContent=tl,ze=n(),r(E.$$.fragment),Pe=n(),V=o("p"),V.innerHTML=ll,qe=n(),X=o("p"),X.innerHTML=sl,De=n(),r(F.$$.fragment),Ke=n(),A=o("p"),A.innerHTML=nl,Oe=n(),N=o("p"),N.textContent=al,et=n(),r(Y.$$.fragment),tt=n(),H=o("p"),H.textContent=ol,lt=n(),r(S.$$.fragment),st=n(),Q=o("p"),Q.textContent=il,nt=n(),r(z.$$.fragment),at=n(),P=o("p"),P.textContent=ml,ot=n(),r(q.$$.fragment),it=n(),D=o("p"),D.innerHTML=pl,mt=n(),K=o("p"),K.innerHTML=rl,pt=n(),r(O.$$.fragment),rt=n(),ee=o("p"),ee.innerHTML=cl,ct=n(),r(te.$$.fragment),dt=n(),le=o("p"),le.textContent=dl,ut=n(),se=o("p"),se.innerHTML=ul,yt=n(),r(ne.$$.fragment),Mt=n(),ae=o("p"),ae.innerHTML=yl,ht=n(),oe=o("p"),oe.innerHTML=Ml,ft=n(),r(ie.$$.fragment),bt=n(),me=o("p"),me.innerHTML=hl,wt=n(),pe=o("p"),pe.innerHTML=fl,Jt=n(),re=o("p"),re.innerHTML=bl,Tt=n(),r(ce.$$.fragment),jt=n(),de=o("p"),de.textContent=wl,gt=n(),ue=o("ul"),ue.innerHTML=Jl,kt=n(),r(ye.$$.fragment),xt=n(),Me=o("ul"),Me.innerHTML=Tl,Ut=n(),r(he.$$.fragment),Zt=n(),r(fe.$$.fragment),Ct=n(),be=o("p"),be.innerHTML=jl,vt=n(),we=o("ul"),we.innerHTML=gl,Lt=n(),r(Je.$$.fragment),$t=n(),r(j.$$.fragment),_t=n(),Te=o("p"),Te.textContent=kl,Gt=n(),je=o("p"),je.textContent=xl,Wt=n(),r(ge.$$.fragment),It=n(),r(g.$$.fragment),Rt=n(),ke=o("p"),ke.textContent=Ul,Bt=n(),xe=o("p"),xe.innerHTML=Zl,Et=n(),Ue=o("p"),Ue.innerHTML=Cl,Vt=n(),Ze=o("ul"),Ze.innerHTML=vl,Xt=n(),Ce=o("p"),Ce.textContent=Ll,Ft=n(),r(ve.$$.fragment),At=n(),Le=o("p"),Le.textContent=$l,Nt=n(),r($e.$$.fragment),Yt=n(),Ge=o("p"),this.h()},l(e){const t=Fl("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(l),b=a(e),h=i(e,"P",{}),Il(h).forEach(l),w=a(e),c(k.$$.fragment,e),We=a(e),x=i(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1twj2ga"&&(x.innerHTML=zt),Ie=a(e),U=i(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-14u0q1"&&(U.innerHTML=Pt),Re=a(e),c(Z.$$.fragment,e),Be=a(e),C=i(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1vzm18b"&&(C.textContent=qt),Ee=a(e),c(v.$$.fragment,e),Ve=a(e),L=i(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-ifflo"&&(L.textContent=Dt),Xe=a(e),c(T.$$.fragment,e),Fe=a(e),$=i(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-19hnh19"&&($.textContent=Kt),Ae=a(e),c(_.$$.fragment,e),Ne=a(e),G=i(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-47m0b6"&&(G.textContent=Ot),Ye=a(e),c(W.$$.fragment,e),He=a(e),I=i(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-hvbljg"&&(I.innerHTML=el),Se=a(e),c(R.$$.fragment,e),Qe=a(e),B=i(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-12m4713"&&(B.textContent=tl),ze=a(e),c(E.$$.fragment,e),Pe=a(e),V=i(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-3iyeuu"&&(V.innerHTML=ll),qe=a(e),X=i(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-12a8po"&&(X.innerHTML=sl),De=a(e),c(F.$$.fragment,e),Ke=a(e),A=i(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1el2qhw"&&(A.innerHTML=nl),Oe=a(e),N=i(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-132k8n8"&&(N.textContent=al),et=a(e),c(Y.$$.fragment,e),tt=a(e),H=i(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1i7knza"&&(H.textContent=ol),lt=a(e),c(S.$$.fragment,e),st=a(e),Q=i(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-66d7qt"&&(Q.textContent=il),nt=a(e),c(z.$$.fragment,e),at=a(e),P=i(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-132x2pj"&&(P.textContent=ml),ot=a(e),c(q.$$.fragment,e),it=a(e),D=i(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-odd6w6"&&(D.innerHTML=pl),mt=a(e),K=i(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-vtvaop"&&(K.innerHTML=rl),pt=a(e),c(O.$$.fragment,e),rt=a(e),ee=i(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-1ym7j5n"&&(ee.innerHTML=cl),ct=a(e),c(te.$$.fragment,e),dt=a(e),le=i(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-1a6hk12"&&(le.textContent=dl),ut=a(e),se=i(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-13ceymq"&&(se.innerHTML=ul),yt=a(e),c(ne.$$.fragment,e),Mt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-zh7y7t"&&(ae.innerHTML=yl),ht=a(e),oe=i(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-foxae4"&&(oe.innerHTML=Ml),ft=a(e),c(ie.$$.fragment,e),bt=a(e),me=i(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-tkcysf"&&(me.innerHTML=hl),wt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-8q7t0u"&&(pe.innerHTML=fl),Jt=a(e),re=i(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-485c9z"&&(re.innerHTML=bl),Tt=a(e),c(ce.$$.fragment,e),jt=a(e),de=i(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-g4uxja"&&(de.textContent=wl),gt=a(e),ue=i(e,"UL",{"data-svelte-h":!0}),m(ue)!=="svelte-16oxlhu"&&(ue.innerHTML=Jl),kt=a(e),c(ye.$$.fragment,e),xt=a(e),Me=i(e,"UL",{"data-svelte-h":!0}),m(Me)!=="svelte-1lks9wd"&&(Me.innerHTML=Tl),Ut=a(e),c(he.$$.fragment,e),Zt=a(e),c(fe.$$.fragment,e),Ct=a(e),be=i(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1nivrxo"&&(be.innerHTML=jl),vt=a(e),we=i(e,"UL",{"data-svelte-h":!0}),m(we)!=="svelte-1pyzk0w"&&(we.innerHTML=gl),Lt=a(e),c(Je.$$.fragment,e),$t=a(e),c(j.$$.fragment,e),_t=a(e),Te=i(e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-1ve93t1"&&(Te.textContent=kl),Gt=a(e),je=i(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-hzxzie"&&(je.textContent=xl),Wt=a(e),c(ge.$$.fragment,e),It=a(e),c(g.$$.fragment,e),Rt=a(e),ke=i(e,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-1rh0r2d"&&(ke.textContent=Ul),Bt=a(e),xe=i(e,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-1p8m775"&&(xe.innerHTML=Zl),Et=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-qp8f4l"&&(Ue.innerHTML=Cl),Vt=a(e),Ze=i(e,"UL",{"data-svelte-h":!0}),m(Ze)!=="svelte-c8ydbv"&&(Ze.innerHTML=vl),Xt=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-1bmvvdg"&&(Ce.textContent=Ll),Ft=a(e),c(ve.$$.fragment,e),At=a(e),Le=i(e,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-n2s6f5"&&(Le.textContent=$l),Nt=a(e),c($e.$$.fragment,e),Yt=a(e),Ge=i(e,"P",{}),Il(Ge).forEach(l),this.h()},h(){Rl(p,"name","hf:doc:metadata"),Rl(p,"content",zl)},m(e,t){Al(document.head,p),s(e,b,t),s(e,h,t),s(e,w,t),d(k,e,t),s(e,We,t),s(e,x,t),s(e,Ie,t),s(e,U,t),s(e,Re,t),d(Z,e,t),s(e,Be,t),s(e,C,t),s(e,Ee,t),d(v,e,t),s(e,Ve,t),s(e,L,t),s(e,Xe,t),d(T,e,t),s(e,Fe,t),s(e,$,t),s(e,Ae,t),d(_,e,t),s(e,Ne,t),s(e,G,t),s(e,Ye,t),d(W,e,t),s(e,He,t),s(e,I,t),s(e,Se,t),d(R,e,t),s(e,Qe,t),s(e,B,t),s(e,ze,t),d(E,e,t),s(e,Pe,t),s(e,V,t),s(e,qe,t),s(e,X,t),s(e,De,t),d(F,e,t),s(e,Ke,t),s(e,A,t),s(e,Oe,t),s(e,N,t),s(e,et,t),d(Y,e,t),s(e,tt,t),s(e,H,t),s(e,lt,t),d(S,e,t),s(e,st,t),s(e,Q,t),s(e,nt,t),d(z,e,t),s(e,at,t),s(e,P,t),s(e,ot,t),d(q,e,t),s(e,it,t),s(e,D,t),s(e,mt,t),s(e,K,t),s(e,pt,t),d(O,e,t),s(e,rt,t),s(e,ee,t),s(e,ct,t),d(te,e,t),s(e,dt,t),s(e,le,t),s(e,ut,t),s(e,se,t),s(e,yt,t),d(ne,e,t),s(e,Mt,t),s(e,ae,t),s(e,ht,t),s(e,oe,t),s(e,ft,t),d(ie,e,t),s(e,bt,t),s(e,me,t),s(e,wt,t),s(e,pe,t),s(e,Jt,t),s(e,re,t),s(e,Tt,t),d(ce,e,t),s(e,jt,t),s(e,de,t),s(e,gt,t),s(e,ue,t),s(e,kt,t),d(ye,e,t),s(e,xt,t),s(e,Me,t),s(e,Ut,t),d(he,e,t),s(e,Zt,t),d(fe,e,t),s(e,Ct,t),s(e,be,t),s(e,vt,t),s(e,we,t),s(e,Lt,t),d(Je,e,t),s(e,$t,t),d(j,e,t),s(e,_t,t),s(e,Te,t),s(e,Gt,t),s(e,je,t),s(e,Wt,t),d(ge,e,t),s(e,It,t),d(g,e,t),s(e,Rt,t),s(e,ke,t),s(e,Bt,t),s(e,xe,t),s(e,Et,t),s(e,Ue,t),s(e,Vt,t),s(e,Ze,t),s(e,Xt,t),s(e,Ce,t),s(e,Ft,t),d(ve,e,t),s(e,At,t),s(e,Le,t),s(e,Nt,t),d($e,e,t),s(e,Yt,t),s(e,Ge,t),Ht=!0},p(e,[t]){const _l={};t&2&&(_l.$$scope={dirty:t,ctx:e}),T.$set(_l);const Gl={};t&2&&(Gl.$$scope={dirty:t,ctx:e}),j.$set(Gl);const Wl={};t&2&&(Wl.$$scope={dirty:t,ctx:e}),g.$set(Wl)},i(e){Ht||(u(k.$$.fragment,e),u(Z.$$.fragment,e),u(v.$$.fragment,e),u(T.$$.fragment,e),u(_.$$.fragment,e),u(W.$$.fragment,e),u(R.$$.fragment,e),u(E.$$.fragment,e),u(F.$$.fragment,e),u(Y.$$.fragment,e),u(S.$$.fragment,e),u(z.$$.fragment,e),u(q.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(ce.$$.fragment,e),u(ye.$$.fragment,e),u(he.$$.fragment,e),u(fe.$$.fragment,e),u(Je.$$.fragment,e),u(j.$$.fragment,e),u(ge.$$.fragment,e),u(g.$$.fragment,e),u(ve.$$.fragment,e),u($e.$$.fragment,e),Ht=!0)},o(e){y(k.$$.fragment,e),y(Z.$$.fragment,e),y(v.$$.fragment,e),y(T.$$.fragment,e),y(_.$$.fragment,e),y(W.$$.fragment,e),y(R.$$.fragment,e),y(E.$$.fragment,e),y(F.$$.fragment,e),y(Y.$$.fragment,e),y(S.$$.fragment,e),y(z.$$.fragment,e),y(q.$$.fragment,e),y(O.$$.fragment,e),y(te.$$.fragment,e),y(ne.$$.fragment,e),y(ie.$$.fragment,e),y(ce.$$.fragment,e),y(ye.$$.fragment,e),y(he.$$.fragment,e),y(fe.$$.fragment,e),y(Je.$$.fragment,e),y(j.$$.fragment,e),y(ge.$$.fragment,e),y(g.$$.fragment,e),y(ve.$$.fragment,e),y($e.$$.fragment,e),Ht=!1},d(e){e&&(l(b),l(h),l(w),l(We),l(x),l(Ie),l(U),l(Re),l(Be),l(C),l(Ee),l(Ve),l(L),l(Xe),l(Fe),l($),l(Ae),l(Ne),l(G),l(Ye),l(He),l(I),l(Se),l(Qe),l(B),l(ze),l(Pe),l(V),l(qe),l(X),l(De),l(Ke),l(A),l(Oe),l(N),l(et),l(tt),l(H),l(lt),l(st),l(Q),l(nt),l(at),l(P),l(ot),l(it),l(D),l(mt),l(K),l(pt),l(rt),l(ee),l(ct),l(dt),l(le),l(ut),l(se),l(yt),l(Mt),l(ae),l(ht),l(oe),l(ft),l(bt),l(me),l(wt),l(pe),l(Jt),l(re),l(Tt),l(jt),l(de),l(gt),l(ue),l(kt),l(xt),l(Me),l(Ut),l(Zt),l(Ct),l(be),l(vt),l(we),l(Lt),l($t),l(_t),l(Te),l(Gt),l(je),l(Wt),l(It),l(Rt),l(ke),l(Bt),l(xe),l(Et),l(Ue),l(Vt),l(Ze),l(Xt),l(Ce),l(Ft),l(At),l(Le),l(Nt),l(Yt),l(Ge)),l(p),M(k,e),M(Z,e),M(v,e),M(T,e),M(_,e),M(W,e),M(R,e),M(E,e),M(F,e),M(Y,e),M(S,e),M(z,e),M(q,e),M(O,e),M(te,e),M(ne,e),M(ie,e),M(ce,e),M(ye,e),M(he,e),M(fe,e),M(Je,e),M(j,e),M(ge,e),M(g,e),M(ve,e),M($e,e)}}}const zl='{"title":"Custom models","local":"custom-models","sections":[{"title":"Multilayer perceptron","local":"multilayer-perceptron","sections":[],"depth":2},{"title":"timm models","local":"timm-models","sections":[],"depth":2},{"title":"New transformers architectures","local":"new-transformers-architectures","sections":[],"depth":2},{"title":"Verify parameters and layers","local":"verify-parameters-and-layers","sections":[],"depth":2},{"title":"Unsupported module types","local":"unsupported-module-types","sections":[{"title":"Experimental support for dynamic dispatch of custom modules in LoRA","local":"experimental-support-for-dynamic-dispatch-of-custom-modules-in-lora","sections":[],"depth":3}],"depth":2}],"depth":1}';function Pl(J){return El(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ts extends Vl{constructor(p){super(),Xl(this,p,Pl,Ql,Bl,{})}}export{ts as component};
