import{s as St,o as Zt,n as Rt}from"../chunks/scheduler.7b8d42e8.js";import{S as zt,i as Vt,g as s,s as r,r as u,A as Xt,h as i,f as o,c as n,j as $,u as f,x as g,k as M,y as t,a as m,v as h,d as _,t as x,w as b}from"../chunks/index.8a4d5423.js";import{T as Bt}from"../chunks/Tip.8a16d533.js";import{D as C}from"../chunks/Docstring.3fe27d1a.js";import{C as Jt}from"../chunks/CodeBlock.3d203e50.js";import{E as Wt}from"../chunks/ExampleCodeBlock.b66b31a1.js";import{H as we}from"../chunks/getInferenceSnippets.484b0f4e.js";function Gt(le){let p,F="It is possible to know which tasks are supported for a model for a given backend, by doing:",y,k,T;return k=new Jt({props:{code:"ZnJvbSUyMG9wdGltdW0uZXhwb3J0ZXJzLnRhc2tzJTIwaW1wb3J0JTIwVGFza3NNYW5hZ2VyJTBBJTBBbW9kZWxfdHlwZSUyMCUzRCUyMCUyMmRpc3RpbGJlcnQlMjIlMEElMjMlMjBGb3IlMjBpbnN0YW5jZSUyQyUyMGZvciUyMHRoZSUyME9OTlglMjBleHBvcnQuJTBBYmFja2VuZCUyMCUzRCUyMCUyMm9ubnglMjIlMEFkaXN0aWxiZXJ0X3Rhc2tzJTIwJTNEJTIwbGlzdChUYXNrc01hbmFnZXIuZ2V0X3N1cHBvcnRlZF90YXNrc19mb3JfbW9kZWxfdHlwZShtb2RlbF90eXBlJTJDJTIwYmFja2VuZCkua2V5cygpKSUwQSUwQXByaW50KGRpc3RpbGJlcnRfdGFza3Mp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters.tasks <span class="hljs-keyword">import</span> TasksManager

<span class="hljs-meta">&gt;&gt;&gt; </span>model_type = <span class="hljs-string">&quot;distilbert&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For instance, for the ONNX export.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>backend = <span class="hljs-string">&quot;onnx&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>distilbert_tasks = <span class="hljs-built_in">list</span>(TasksManager.get_supported_tasks_for_model_type(model_type, backend).keys())

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(distilbert_tasks)
[<span class="hljs-string">&#x27;default&#x27;</span>, <span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;text-classification&#x27;</span>, <span class="hljs-string">&#x27;multiple-choice&#x27;</span>, <span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;question-answering&#x27;</span>]`,wrap:!1}}),{c(){p=s("p"),p.textContent=F,y=r(),u(k.$$.fragment)},l(d){p=i(d,"P",{"data-svelte-h":!0}),g(p)!=="svelte-af61zr"&&(p.textContent=F),y=n(d),f(k.$$.fragment,d)},m(d,v){m(d,p,v),m(d,y,v),h(k,d,v),T=!0},p:Rt,i(d){T||(_(k.$$.fragment,d),T=!0)},o(d){x(k.$$.fragment,d),T=!1},d(d){d&&(o(p),o(y)),b(k,d)}}}function Yt(le){let p,F="Example:",y,k,T;return k=new Jt({props:{code:"cmVnaXN0ZXJfZm9yX25ld19iYWNrZW5kJTIwJTNEJTIwY3JlYXRlX3JlZ2lzdGVyKCUyMm5ldy1iYWNrZW5kJTIyKSUwQSUwQSU0MHJlZ2lzdGVyX2Zvcl9uZXdfYmFja2VuZCglMjJiZXJ0JTIyJTJDJTIwJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMCUyMnRva2VuLWNsYXNzaWZpY2F0aW9uJTIyKSUwQWNsYXNzJTIwQmVydE5ld0JhY2tlbmRDb25maWcoTmV3QmFja2VuZENvbmZpZyklM0ElMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>register_for_new_backend = create_register(<span class="hljs-string">&quot;new-backend&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>@register_for_new_backend(<span class="hljs-string">&quot;bert&quot;</span>, <span class="hljs-string">&quot;text-classification&quot;</span>, <span class="hljs-string">&quot;token-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">BertNewBackendConfig</span>(<span class="hljs-title class_ inherited__">NewBackendConfig</span>):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">pass</span>`,wrap:!1}}),{c(){p=s("p"),p.textContent=F,y=r(),u(k.$$.fragment)},l(d){p=i(d,"P",{"data-svelte-h":!0}),g(p)!=="svelte-11lpom8"&&(p.textContent=F),y=n(d),f(k.$$.fragment,d)},m(d,v){m(d,p,v),m(d,y,v),h(k,d,v),T=!0},p:Rt,i(d){T||(_(k.$$.fragment,d),T=!0)},o(d){x(k.$$.fragment,d),T=!1},d(d){d&&(o(p),o(y)),b(k,d)}}}function Qt(le){let p,F,y,k,T,d,v,Tt="Exporting a model from one framework to some format (also called backend here) involves specifying inputs and outputs information that the export function needs. The way <code>optimum.exporters</code> is structured for each backend is as follows:",Ce,S,yt="<li>Configuration classes containing the information for each model to perform the export.</li> <li>Exporting functions using the proper configuration for the model to export.</li>",Fe,Z,vt='The role of the <a href="/docs/optimum/main/en/exporters/task_manager#optimum.exporters.TasksManager">TasksManager</a> is to be the main entry-point to load a model given a name and a task, and to get the proper configuration for a given (architecture, backend) couple. That way, there is a centralized place to register the <code>task -&gt; model class</code> and <code>(architecture, backend) -&gt; configuration</code> mappings. This allows the export functions to use this, and to rely on the various checks it provides.',Ne,z,De,V,$t="The tasks supported might depend on the backend, but here are the mappings between a task name and the auto class for both PyTorch and TensorFlow.",Pe,P,He,X,je,B,Mt="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-generation</code>, <code>text-generation-with-past</code></td> <td><code>AutoModelForCausalLM</code></td></tr> <tr><td><code>feature-extraction</code>, <code>feature-extraction-with-past</code></td> <td><code>AutoModel</code></td></tr> <tr><td><code>fill-mask</code></td> <td><code>AutoModelForMaskedLM</code></td></tr> <tr><td><code>question-answering</code></td> <td><code>AutoModelForQuestionAnswering</code></td></tr> <tr><td><code>text2text-generation</code>, <code>text2text-generation-with-past</code></td> <td><code>AutoModelForSeq2SeqLM</code></td></tr> <tr><td><code>text-classification</code></td> <td><code>AutoModelForSequenceClassification</code></td></tr> <tr><td><code>token-classification</code></td> <td><code>AutoModelForTokenClassification</code></td></tr> <tr><td><code>multiple-choice</code></td> <td><code>AutoModelForMultipleChoice</code></td></tr> <tr><td><code>image-classification</code></td> <td><code>AutoModelForImageClassification</code></td></tr> <tr><td><code>object-detection</code></td> <td><code>AutoModelForObjectDetection</code></td></tr> <tr><td><code>image-segmentation</code></td> <td><code>AutoModelForImageSegmentation</code></td></tr> <tr><td><code>masked-im</code></td> <td><code>AutoModelForMaskedImageModeling</code></td></tr> <tr><td><code>semantic-segmentation</code></td> <td><code>AutoModelForSemanticSegmentation</code></td></tr> <tr><td><code>automatic-speech-recognition</code></td> <td><code>AutoModelForSpeechSeq2Seq</code></td></tr></tbody>",Oe,W,Ie,G,wt="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-generation</code>, <code>text-generation-with-past</code></td> <td><code>TFAutoModelForCausalLM</code></td></tr> <tr><td><code>default</code>, <code>default-with-past</code></td> <td><code>TFAutoModel</code></td></tr> <tr><td><code>fill-mask</code></td> <td><code>TFAutoModelForMaskedLM</code></td></tr> <tr><td><code>question-answering</code></td> <td><code>TFAutoModelForQuestionAnswering</code></td></tr> <tr><td><code>text2text-generation</code>, <code>text2text-generation-with-past</code></td> <td><code>TFAutoModelForSeq2SeqLM</code></td></tr> <tr><td><code>text-classification</code></td> <td><code>TFAutoModelForSequenceClassification</code></td></tr> <tr><td><code>token-classification</code></td> <td><code>TFAutoModelForTokenClassification</code></td></tr> <tr><td><code>multiple-choice</code></td> <td><code>TFAutoModelForMultipleChoice</code></td></tr> <tr><td><code>semantic-segmentation</code></td> <td><code>TFAutoModelForSemanticSegmentation</code></td></tr></tbody>",Ue,Y,Ae,c,Q,We,me,Ct="Handles the <code>task name -&gt; model class</code> and <code>architecture -&gt; configuration</code> mappings.",Ge,N,K,Ye,pe,Ft="Creates a register function for the specified backend.",Qe,H,Ke,w,ee,et,ge,Nt="Determines the framework to use for the export.",tt,ue,Dt="The priority is in the following order:",ot,fe,Pt="<li>User input via <code>framework</code>.</li> <li>If local checkpoint is provided, use the same framework as the checkpoint.</li> <li>If model repo, try to infer the framework from the cache if available, else from the Hub.</li> <li>If could not infer, use available framework in environment, with priority given to PyTorch.</li>",rt,j,te,nt,he,Ht="Retrieves all the possible tasks.",at,O,oe,st,_e,jt="Gets the <code>ExportConfigConstructor</code> for a model (or alternatively for a model type) and task combination.",it,I,re,dt,xe,Ot="Attempts to retrieve an AutoModel class from a task name.",ct,U,ne,lt,be,It="Retrieves a model from its name and the task to be enabled.",mt,A,ae,pt,ke,Ut="Returns the list of supported architectures by the exporter for a given task. Transformers-specific.",gt,q,se,ut,Te,At="Retrieves the <code>task -&gt; exporter backend config constructors</code> map from the model type.",ft,L,ie,ht,ye,qt="Infers the library from the model repo, model instance, or model class.",_t,E,de,xt,ve,Lt="Infers the task from the model repo, model instance, or model class.",bt,R,ce,kt,$e,Et=`Updates the model for export. This function is suitable to make required changes to the models from different
libraries to follow transformers style.`,qe,Me,Le;return T=new we({props:{title:"The Tasks Manager",local:"the-tasks-manager",headingTag:"h1"}}),z=new we({props:{title:"Task names",local:"task-names",headingTag:"h2"}}),P=new Bt({props:{$$slots:{default:[Gt]},$$scope:{ctx:le}}}),X=new we({props:{title:"PyTorch",local:"pytorch",headingTag:"h3"}}),W=new we({props:{title:"TensorFlow",local:"tensorflow",headingTag:"h3"}}),Y=new we({props:{title:"Reference",local:"optimum.exporters.TasksManager",headingTag:"h2"}}),Q=new C({props:{name:"class optimum.exporters.TasksManager",anchor:"optimum.exporters.TasksManager",parameters:[],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L120"}}),K=new C({props:{name:"create_register",anchor:"optimum.exporters.TasksManager.create_register",parameters:[{name:"backend",val:": str"},{name:"overwrite_existing",val:": bool = False"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.create_register.backend",description:`<strong>backend</strong> (<code>str</code>) &#x2014;
The name of the backend that the register function will handle.`,name:"backend"},{anchor:"optimum.exporters.TasksManager.create_register.overwrite_existing",description:`<strong>overwrite_existing</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not the register function is allowed to overwrite an already existing config.`,name:"overwrite_existing"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L327",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A decorator taking the model type and a the
supported tasks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Callable[[str, Tuple[str, ...]], Callable[[Type], Type]]</code></p>
`}}),H=new Wt({props:{anchor:"optimum.exporters.TasksManager.create_register.example",$$slots:{default:[Yt]},$$scope:{ctx:le}}}),ee=new C({props:{name:"determine_framework",anchor:"optimum.exporters.TasksManager.determine_framework",parameters:[{name:"model_name_or_path",val:": typing.Union[str, pathlib.Path]"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": str = '/home/runner/.cache/huggingface/hub'"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.determine_framework.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either the model id of a model repo on the Hugging Face Hub, or a path to a local directory
containing a model.`,name:"model_name_or_path"},{anchor:"optimum.exporters.TasksManager.determine_framework.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.TasksManager.determine_framework.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>,  defaults to <code>None</code>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"},{anchor:"optimum.exporters.TasksManager.determine_framework.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model weights have been cached if the standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.exporters.TasksManager.determine_framework.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L632",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The framework to use for the export.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),te=new C({props:{name:"get_all_tasks",anchor:"optimum.exporters.TasksManager.get_all_tasks",parameters:[],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1119",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>all the possible tasks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`}}),oe=new C({props:{name:"get_exporter_config_constructor",anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor",parameters:[{name:"exporter",val:": str"},{name:"model",val:": typing.Union[ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel'), NoneType] = None"},{name:"task",val:": str = 'feature-extraction'"},{name:"model_type",val:": typing.Optional[str] = None"},{name:"model_name",val:": typing.Optional[str] = None"},{name:"exporter_config_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"library_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.exporter",description:`<strong>exporter</strong> (<code>str</code>) &#x2014;
The exporter to use.`,name:"exporter"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.model",description:`<strong>model</strong> (<code>Optional[Union[PreTrainedModel, TFPreTrainedModel]]</code>, defaults to <code>None</code>) &#x2014;
The instance of the model.`,name:"model"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;feature-extraction&quot;</code>) &#x2014;
The task to retrieve the config for.`,name:"task"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.model_type",description:`<strong>model_type</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The model type to retrieve the config for.`,name:"model_type"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.model_name",description:`<strong>model_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The name attribute of the model object, only used for the exception message.`,name:"model_name"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.exporter_config_kwargs",description:`<strong>exporter_config_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
Arguments that will be passed to the exporter config class when building the config constructor.`,name:"exporter_config_kwargs"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;.`,name:"library_name"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1308",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>ExporterConfig</code> constructor for the requested backend.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ExportConfigConstructor</code></p>
`}}),re=new C({props:{name:"get_model_class_for_task",anchor:"optimum.exporters.TasksManager.get_model_class_for_task",parameters:[{name:"task",val:": str"},{name:"framework",val:": str = 'pt'"},{name:"model_type",val:": typing.Optional[str] = None"},{name:"model_class_name",val:": typing.Optional[str] = None"},{name:"library",val:": str = 'transformers'"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The task required.`,name:"task"},{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.framework",description:`<strong>framework</strong> (<code>str</code>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
The framework to use for the export.`,name:"framework"},{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.model_type",description:`<strong>model_type</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The model type to retrieve the model class for. Some architectures need a custom class to be loaded,
and can not be loaded from auto class.`,name:"model_type"},{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.model_class_name",description:`<strong>model_class_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
A model class name, allowing to override the default class that would be detected for the task. This
parameter is useful for example for &#x201C;automatic-speech-recognition&#x201D;, that may map to
AutoModelForSpeechSeq2Seq or to AutoModelForCTC.`,name:"model_class_name"},{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.library",description:`<strong>library</strong> (<code>str</code>, defaults to <code>transformers</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;.`,name:"library"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L487",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The AutoModel class corresponding to the task.</p>
`}}),ne=new C({props:{name:"get_model_from_task",anchor:"optimum.exporters.TasksManager.get_model_from_task",parameters:[{name:"task",val:": str"},{name:"model_name_or_path",val:": typing.Union[str, pathlib.Path]"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": str = '/home/runner/.cache/huggingface/hub'"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"framework",val:": typing.Optional[str] = None"},{name:"torch_dtype",val:": typing.Optional[ForwardRef('torch.dtype')] = None"},{name:"device",val:": typing.Union[ForwardRef('torch.device'), str, NoneType] = None"},{name:"library_name",val:": typing.Optional[str] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.get_model_from_task.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The task required.`,name:"task"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either the model id of a model repo on the Hugging Face Hub, or a path to a local directory
containing a model.`,name:"model_name_or_path"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model weights have been cached if the standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.framework",description:`<strong>framework</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
The framework to use for the export. See <code>TasksManager.determine_framework</code> for the priority should
none be provided.`,name:"framework"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.torch_dtype",description:`<strong>torch_dtype</strong> (<code>Optional[torch.dtype]</code>, defaults to <code>None</code>) &#x2014;
Data type to load the model on. PyTorch-only argument.`,name:"torch_dtype"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
Device to initialize the model on. PyTorch-only argument. For PyTorch, defaults to &#x201C;cpu&#x201D;.`,name:"device"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;. See <code>TasksManager.infer_library_from_model</code> for the priority should
none be provided.`,name:"library_name"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.model_kwargs",description:`<strong>model_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Keyword arguments to pass to the model <code>.from_pretrained()</code> method.`,name:"model_kwargs"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;. See <code>TasksManager.infer_library_from_model</code> for the priority should
none be provided.`,name:"library_name"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1147",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The instance of the model.</p>
`}}),ae=new C({props:{name:"get_supported_model_type_for_task",anchor:"optimum.exporters.TasksManager.get_supported_model_type_for_task",parameters:[{name:"task",val:": str"},{name:"exporter",val:": str"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L443"}}),se=new C({props:{name:"get_supported_tasks_for_model_type",anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type",parameters:[{name:"model_type",val:": str"},{name:"exporter",val:": str"},{name:"model_name",val:": typing.Optional[str] = None"},{name:"library_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type.model_type",description:`<strong>model_type</strong> (<code>str</code>) &#x2014;
The model type to retrieve the supported tasks for.`,name:"model_type"},{anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type.exporter",description:`<strong>exporter</strong> (<code>str</code>) &#x2014;
The name of the exporter.`,name:"exporter"},{anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type.model_name",description:`<strong>model_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The name attribute of the model object, only used for the exception message.`,name:"model_name"},{anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;.`,name:"library_name"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L382",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary mapping each task to a corresponding <code>ExporterConfig</code>
constructor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>TaskNameToExportConfigDict</code></p>
`}}),ie=new C({props:{name:"infer_library_from_model",anchor:"optimum.exporters.TasksManager.infer_library_from_model",parameters:[{name:"model",val:": typing.Union[str, ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel'), ForwardRef('DiffusionPipeline'), typing.Type]"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": str = '/home/runner/.cache/huggingface/hub'"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.infer_library_from_model.model",description:`<strong>model</strong> (<code>Union[str, PreTrainedModel, TFPreTrainedModel, DiffusionPipeline, Type]</code>) &#x2014;
The model to infer the task from. This can either be the name of a repo on the HuggingFace Hub, an
instance of a model, or a model class.`,name:"model"},{anchor:"optimum.exporters.TasksManager.infer_library_from_model.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.TasksManager.infer_library_from_model.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"},{anchor:"optimum.exporters.TasksManager.infer_library_from_model.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model weights have been cached if the standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.exporters.TasksManager.infer_library_from_model.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1022",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The library name automatically detected from the model repo, model instance, or model class.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),de=new C({props:{name:"infer_task_from_model",anchor:"optimum.exporters.TasksManager.infer_task_from_model",parameters:[{name:"model",val:": typing.Union[str, ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel'), ForwardRef('DiffusionPipeline'), typing.Type]"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": str = '/home/runner/.cache/huggingface/hub'"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"library_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.infer_task_from_model.model",description:`<strong>model</strong> (<code>Union[str, PreTrainedModel, TFPreTrainedModel, DiffusionPipeline, Type]</code>) &#x2014;
The model to infer the task from. This can either be the name of a repo on the HuggingFace Hub, an
instance of a model, or a model class.`,name:"model"},{anchor:"optimum.exporters.TasksManager.infer_task_from_model.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.TasksManager.infer_task_from_model.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>,  defaults to <code>None</code>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"},{anchor:"optimum.exporters.TasksManager.infer_task_from_model.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model weights have been cached if the standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.exporters.TasksManager.infer_task_from_model.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"},{anchor:"optimum.exporters.TasksManager.infer_task_from_model.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;. See <code>TasksManager.infer_library_from_model</code> for the priority should
none be provided.`,name:"library_name"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L863",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The task name automatically detected from the HF hub repo, model instance, or model class.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),ce=new C({props:{name:"standardize_model_attributes",anchor:"optimum.exporters.TasksManager.standardize_model_attributes",parameters:[{name:"model",val:": typing.Union[ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel'), ForwardRef('DiffusionPipeline')]"},{name:"library_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.standardize_model_attributes.model",description:`<strong>model</strong> (<code>Union[PreTrainedModel, TFPreTrainedModel, DiffusionPipeline]</code>) &#x2014;
The instance of the model.`,name:"model"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1068"}}),{c(){p=s("meta"),F=r(),y=s("p"),k=r(),u(T.$$.fragment),d=r(),v=s("p"),v.innerHTML=Tt,Ce=r(),S=s("ul"),S.innerHTML=yt,Fe=r(),Z=s("p"),Z.innerHTML=vt,Ne=r(),u(z.$$.fragment),De=r(),V=s("p"),V.textContent=$t,Pe=r(),u(P.$$.fragment),He=r(),u(X.$$.fragment),je=r(),B=s("table"),B.innerHTML=Mt,Oe=r(),u(W.$$.fragment),Ie=r(),G=s("table"),G.innerHTML=wt,Ue=r(),u(Y.$$.fragment),Ae=r(),c=s("div"),u(Q.$$.fragment),We=r(),me=s("p"),me.innerHTML=Ct,Ge=r(),N=s("div"),u(K.$$.fragment),Ye=r(),pe=s("p"),pe.textContent=Ft,Qe=r(),u(H.$$.fragment),Ke=r(),w=s("div"),u(ee.$$.fragment),et=r(),ge=s("p"),ge.textContent=Nt,tt=r(),ue=s("p"),ue.textContent=Dt,ot=r(),fe=s("ol"),fe.innerHTML=Pt,rt=r(),j=s("div"),u(te.$$.fragment),nt=r(),he=s("p"),he.textContent=Ht,at=r(),O=s("div"),u(oe.$$.fragment),st=r(),_e=s("p"),_e.innerHTML=jt,it=r(),I=s("div"),u(re.$$.fragment),dt=r(),xe=s("p"),xe.textContent=Ot,ct=r(),U=s("div"),u(ne.$$.fragment),lt=r(),be=s("p"),be.textContent=It,mt=r(),A=s("div"),u(ae.$$.fragment),pt=r(),ke=s("p"),ke.textContent=Ut,gt=r(),q=s("div"),u(se.$$.fragment),ut=r(),Te=s("p"),Te.innerHTML=At,ft=r(),L=s("div"),u(ie.$$.fragment),ht=r(),ye=s("p"),ye.textContent=qt,_t=r(),E=s("div"),u(de.$$.fragment),xt=r(),ve=s("p"),ve.textContent=Lt,bt=r(),R=s("div"),u(ce.$$.fragment),kt=r(),$e=s("p"),$e.textContent=Et,qe=r(),Me=s("p"),this.h()},l(e){const a=Xt("svelte-u9bgzb",document.head);p=i(a,"META",{name:!0,content:!0}),a.forEach(o),F=n(e),y=i(e,"P",{}),$(y).forEach(o),k=n(e),f(T.$$.fragment,e),d=n(e),v=i(e,"P",{"data-svelte-h":!0}),g(v)!=="svelte-ab4qq0"&&(v.innerHTML=Tt),Ce=n(e),S=i(e,"UL",{"data-svelte-h":!0}),g(S)!=="svelte-g9sbqh"&&(S.innerHTML=yt),Fe=n(e),Z=i(e,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-slwz7e"&&(Z.innerHTML=vt),Ne=n(e),f(z.$$.fragment,e),De=n(e),V=i(e,"P",{"data-svelte-h":!0}),g(V)!=="svelte-1bgg04"&&(V.textContent=$t),Pe=n(e),f(P.$$.fragment,e),He=n(e),f(X.$$.fragment,e),je=n(e),B=i(e,"TABLE",{"data-svelte-h":!0}),g(B)!=="svelte-52hvyl"&&(B.innerHTML=Mt),Oe=n(e),f(W.$$.fragment,e),Ie=n(e),G=i(e,"TABLE",{"data-svelte-h":!0}),g(G)!=="svelte-1b4ycm7"&&(G.innerHTML=wt),Ue=n(e),f(Y.$$.fragment,e),Ae=n(e),c=i(e,"DIV",{class:!0});var l=$(c);f(Q.$$.fragment,l),We=n(l),me=i(l,"P",{"data-svelte-h":!0}),g(me)!=="svelte-11ax9pk"&&(me.innerHTML=Ct),Ge=n(l),N=i(l,"DIV",{class:!0});var D=$(N);f(K.$$.fragment,D),Ye=n(D),pe=i(D,"P",{"data-svelte-h":!0}),g(pe)!=="svelte-1hg58vd"&&(pe.textContent=Ft),Qe=n(D),f(H.$$.fragment,D),D.forEach(o),Ke=n(l),w=i(l,"DIV",{class:!0});var J=$(w);f(ee.$$.fragment,J),et=n(J),ge=i(J,"P",{"data-svelte-h":!0}),g(ge)!=="svelte-rshgf5"&&(ge.textContent=Nt),tt=n(J),ue=i(J,"P",{"data-svelte-h":!0}),g(ue)!=="svelte-1wbth9c"&&(ue.textContent=Dt),ot=n(J),fe=i(J,"OL",{"data-svelte-h":!0}),g(fe)!=="svelte-17imzut"&&(fe.innerHTML=Pt),J.forEach(o),rt=n(l),j=i(l,"DIV",{class:!0});var Ee=$(j);f(te.$$.fragment,Ee),nt=n(Ee),he=i(Ee,"P",{"data-svelte-h":!0}),g(he)!=="svelte-1u59gs0"&&(he.textContent=Ht),Ee.forEach(o),at=n(l),O=i(l,"DIV",{class:!0});var Re=$(O);f(oe.$$.fragment,Re),st=n(Re),_e=i(Re,"P",{"data-svelte-h":!0}),g(_e)!=="svelte-77ppuy"&&(_e.innerHTML=jt),Re.forEach(o),it=n(l),I=i(l,"DIV",{class:!0});var Je=$(I);f(re.$$.fragment,Je),dt=n(Je),xe=i(Je,"P",{"data-svelte-h":!0}),g(xe)!=="svelte-dfgadj"&&(xe.textContent=Ot),Je.forEach(o),ct=n(l),U=i(l,"DIV",{class:!0});var Se=$(U);f(ne.$$.fragment,Se),lt=n(Se),be=i(Se,"P",{"data-svelte-h":!0}),g(be)!=="svelte-xnksbg"&&(be.textContent=It),Se.forEach(o),mt=n(l),A=i(l,"DIV",{class:!0});var Ze=$(A);f(ae.$$.fragment,Ze),pt=n(Ze),ke=i(Ze,"P",{"data-svelte-h":!0}),g(ke)!=="svelte-1tobybd"&&(ke.textContent=Ut),Ze.forEach(o),gt=n(l),q=i(l,"DIV",{class:!0});var ze=$(q);f(se.$$.fragment,ze),ut=n(ze),Te=i(ze,"P",{"data-svelte-h":!0}),g(Te)!=="svelte-h2w0ej"&&(Te.innerHTML=At),ze.forEach(o),ft=n(l),L=i(l,"DIV",{class:!0});var Ve=$(L);f(ie.$$.fragment,Ve),ht=n(Ve),ye=i(Ve,"P",{"data-svelte-h":!0}),g(ye)!=="svelte-k1qkuj"&&(ye.textContent=qt),Ve.forEach(o),_t=n(l),E=i(l,"DIV",{class:!0});var Xe=$(E);f(de.$$.fragment,Xe),xt=n(Xe),ve=i(Xe,"P",{"data-svelte-h":!0}),g(ve)!=="svelte-rnhyr"&&(ve.textContent=Lt),Xe.forEach(o),bt=n(l),R=i(l,"DIV",{class:!0});var Be=$(R);f(ce.$$.fragment,Be),kt=n(Be),$e=i(Be,"P",{"data-svelte-h":!0}),g($e)!=="svelte-3l6tv0"&&($e.textContent=Et),Be.forEach(o),l.forEach(o),qe=n(e),Me=i(e,"P",{}),$(Me).forEach(o),this.h()},h(){M(p,"name","hf:doc:metadata"),M(p,"content",Kt),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){t(document.head,p),m(e,F,a),m(e,y,a),m(e,k,a),h(T,e,a),m(e,d,a),m(e,v,a),m(e,Ce,a),m(e,S,a),m(e,Fe,a),m(e,Z,a),m(e,Ne,a),h(z,e,a),m(e,De,a),m(e,V,a),m(e,Pe,a),h(P,e,a),m(e,He,a),h(X,e,a),m(e,je,a),m(e,B,a),m(e,Oe,a),h(W,e,a),m(e,Ie,a),m(e,G,a),m(e,Ue,a),h(Y,e,a),m(e,Ae,a),m(e,c,a),h(Q,c,null),t(c,We),t(c,me),t(c,Ge),t(c,N),h(K,N,null),t(N,Ye),t(N,pe),t(N,Qe),h(H,N,null),t(c,Ke),t(c,w),h(ee,w,null),t(w,et),t(w,ge),t(w,tt),t(w,ue),t(w,ot),t(w,fe),t(c,rt),t(c,j),h(te,j,null),t(j,nt),t(j,he),t(c,at),t(c,O),h(oe,O,null),t(O,st),t(O,_e),t(c,it),t(c,I),h(re,I,null),t(I,dt),t(I,xe),t(c,ct),t(c,U),h(ne,U,null),t(U,lt),t(U,be),t(c,mt),t(c,A),h(ae,A,null),t(A,pt),t(A,ke),t(c,gt),t(c,q),h(se,q,null),t(q,ut),t(q,Te),t(c,ft),t(c,L),h(ie,L,null),t(L,ht),t(L,ye),t(c,_t),t(c,E),h(de,E,null),t(E,xt),t(E,ve),t(c,bt),t(c,R),h(ce,R,null),t(R,kt),t(R,$e),m(e,qe,a),m(e,Me,a),Le=!0},p(e,[a]){const l={};a&2&&(l.$$scope={dirty:a,ctx:e}),P.$set(l);const D={};a&2&&(D.$$scope={dirty:a,ctx:e}),H.$set(D)},i(e){Le||(_(T.$$.fragment,e),_(z.$$.fragment,e),_(P.$$.fragment,e),_(X.$$.fragment,e),_(W.$$.fragment,e),_(Y.$$.fragment,e),_(Q.$$.fragment,e),_(K.$$.fragment,e),_(H.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(re.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_(se.$$.fragment,e),_(ie.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),Le=!0)},o(e){x(T.$$.fragment,e),x(z.$$.fragment,e),x(P.$$.fragment,e),x(X.$$.fragment,e),x(W.$$.fragment,e),x(Y.$$.fragment,e),x(Q.$$.fragment,e),x(K.$$.fragment,e),x(H.$$.fragment,e),x(ee.$$.fragment,e),x(te.$$.fragment,e),x(oe.$$.fragment,e),x(re.$$.fragment,e),x(ne.$$.fragment,e),x(ae.$$.fragment,e),x(se.$$.fragment,e),x(ie.$$.fragment,e),x(de.$$.fragment,e),x(ce.$$.fragment,e),Le=!1},d(e){e&&(o(F),o(y),o(k),o(d),o(v),o(Ce),o(S),o(Fe),o(Z),o(Ne),o(De),o(V),o(Pe),o(He),o(je),o(B),o(Oe),o(Ie),o(G),o(Ue),o(Ae),o(c),o(qe),o(Me)),o(p),b(T,e),b(z,e),b(P,e),b(X,e),b(W,e),b(Y,e),b(Q),b(K),b(H),b(ee),b(te),b(oe),b(re),b(ne),b(ae),b(se),b(ie),b(de),b(ce)}}}const Kt='{"title":"The Tasks Manager","local":"the-tasks-manager","sections":[{"title":"Task names","local":"task-names","sections":[{"title":"PyTorch","local":"pytorch","sections":[],"depth":3},{"title":"TensorFlow","local":"tensorflow","sections":[],"depth":3}],"depth":2},{"title":"Reference","local":"optimum.exporters.TasksManager","sections":[],"depth":2}],"depth":1}';function eo(le){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class co extends zt{constructor(p){super(),Vt(this,p,eo,Qt,St,{})}}export{co as component};
