import{s as nt,n as st,o as at}from"../chunks/scheduler.f6319a2a.js";import{S as ot,i as it,g as o,s,r as d,A as rt,h as i,f as l,c as a,j as lt,u as m,x as r,k as He,y as dt,a as n,v as p,d as g,t as u,w as c}from"../chunks/index.85aa684c.js";import{C as Ie}from"../chunks/CodeBlock.3400fc53.js";import{D as mt}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as M,E as pt}from"../chunks/getInferenceSnippets.55a93fbe.js";function gt(Le){let f,K,q,O,w,ee,b,Re='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/license_to_call.png" style="max-width:700px"/>',te,y,le,T,Ge="<code>smolagents</code> is an open-source Python library designed to make it extremely easy to build and run agents using just a few lines of code.",ne,x,Qe="Key features of <code>smolagents</code> include:",se,$,Ee="✨ <strong>Simplicity</strong>: The logic for agents fits in ~thousand lines of code. We kept abstractions to their minimal shape above raw code!",ae,v,Ve='🧑‍💻 <strong>First-class support for Code Agents</strong>: <a href="reference/agents#smolagents.CodeAgent"><code>CodeAgent</code></a> writes its actions in code (as opposed to “agents being used to write code”) to invoke tools or perform computations, enabling natural composability (function nesting, loops, conditionals). To make it secure, we support <a href="tutorials/secure_code_execution">executing in sandboxed environment</a> via <a href="https://e2b.dev/" rel="nofollow">E2B</a> or via Docker.',oe,C,Se='📡 <strong>Common Tool-Calling Agent Support</strong>: In addition to CodeAgents, <a href="reference/agents#smolagents.ToolCallingAgent"><code>ToolCallingAgent</code></a> supports usual JSON/text-based tool-calling for scenarios where that paradigm is preferred.',ie,j,Ae="🤗 <strong>Hub integrations</strong>: Seamlessly share and load agents and tools to/from the Hub as Gradio Spaces.",re,J,Ne='🌐 <strong>Model-agnostic</strong>: Easily integrate any large language model (LLM), whether it’s hosted on the Hub via <a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">Inference providers</a>, accessed via APIs such as OpenAI, Anthropic, or many others via LiteLLM integration, or run locally using Transformers or Ollama. Powering an agent with your preferred LLM is straightforward and flexible.',de,U,Fe='👁️ <strong>Modality-agnostic</strong>: Beyond text, agents can handle vision, video, and audio inputs, broadening the range of possible applications. Check out <a href="examples/web_browser">this tutorial</a> for vision.',me,W,Pe='🛠️ <strong>Tool-agnostic</strong>: You can use tools from any <a href="reference/tools#smolagents.ToolCollection.from_mcp">MCP server</a>, from <a href="reference/tools#smolagents.Tool.from_langchain">LangChain</a>, you can even use a <a href="reference/tools#smolagents.Tool.from_space">Hub Space</a> as a tool.',pe,k,Ye="💻 <strong>CLI Tools</strong>: Comes with command-line utilities (smolagent, webagent) for quickly running agents without writing boilerplate code.",ge,B,ue,_,ce,Z,ze="Get started with smolagents in just a few minutes! This guide will show you how to create and run your first agent.",fe,H,be,I,Xe="Install smolagents with pip:",he,L,Me,R,we,G,qe="Here’s a minimal example to create and run an agent:",ye,Q,Te,E,De="That’s it! Your agent will use Python code to solve the task and return the result.",xe,V,$e,S,Ke="Let’s make our agent more capable by adding some tools:",ve,A,Ce,N,je,F,Oe="You can use various models with your agent:",Je,P,Ue,Y,We,z,et='<li>Learn how to set up smolagents with various models and tools in the <a href="installation">Installation Guide</a></li> <li>Check out the <a href="guided_tour">Guided Tour</a> for more advanced features</li> <li>Learn about <a href="tutorials/tools">building custom tools</a></li> <li>Explore <a href="tutorials/secure_code_execution">secure code execution</a></li> <li>See how to create <a href="tutorials/building_good_agents">multi-agent systems</a></li>',ke,h,tt='<div class="w-full flex flex-col space-y-4 md:space-y-0 md:grid md:grid-cols-2 md:gap-y-4 md:gap-x-5"><a class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg" href="./guided_tour"><div class="w-full text-center bg-gradient-to-br from-blue-400 to-blue-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">Guided tour</div> <p class="text-gray-700">Learn the basics and become familiar with using Agents. Start here if you are using Agents for the first time!</p></a> <a class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg" href="./examples/text_to_sql"><div class="w-full text-center bg-gradient-to-br from-indigo-400 to-indigo-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">How-to guides</div> <p class="text-gray-700">Practical guides to help you achieve a specific goal: create an agent to generate and test SQL queries!</p></a> <a class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg" href="./conceptual_guides/intro_agents"><div class="w-full text-center bg-gradient-to-br from-pink-400 to-pink-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">Conceptual guides</div> <p class="text-gray-700">High-level explanations for building a better understanding of important topics.</p></a> <a class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg" href="./tutorials/building_good_agents"><div class="w-full text-center bg-gradient-to-br from-purple-400 to-purple-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">Tutorials</div> <p class="text-gray-700">Horizontal tutorials that cover important aspects of building agents.</p></a></div>',Be,X,_e,D,Ze;return w=new M({props:{title:"smolagents",local:"smolagents",headingTag:"h1"}}),y=new M({props:{title:"What is smolagents?",local:"what-is-smolagents",headingTag:"h2"}}),B=new M({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),_=new mt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/index.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/index.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/index.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/index.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/index.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/index.ipynb"}]}}),H=new M({props:{title:"Installation",local:"installation",headingTag:"h3"}}),L=new Ie({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCdG9vbGtpdCU1RCclMjAlMjAlMjMlMjBJbmNsdWRlcyUyMGRlZmF1bHQlMjB0b29scyUyMGxpa2UlMjB3ZWIlMjBzZWFyY2g=",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[toolkit]&#x27;</span>  <span class="hljs-comment"># Includes default tools like web search</span>',wrap:!1}}),R=new M({props:{title:"Create Your First Agent",local:"create-your-first-agent",headingTag:"h3"}}),Q=new Ie({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjBhJTIwbW9kZWwlMjAodXNpbmclMjBIdWdnaW5nJTIwRmFjZSUyMEluZmVyZW5jZSUyMEFQSSklMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCklMjAlMjAlMjMlMjBVc2VzJTIwYSUyMGRlZmF1bHQlMjBtb2RlbCUwQSUwQSUyMyUyMENyZWF0ZSUyMGFuJTIwYWdlbnQlMjB3aXRoJTIwbm8lMjB0b29scyUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCklMEElMEElMjMlMjBSdW4lMjB0aGUlMjBhZ2VudCUyMHdpdGglMjBhJTIwdGFzayUwQXJlc3VsdCUyMCUzRCUyMGFnZW50LnJ1biglMjJDYWxjdWxhdGUlMjB0aGUlMjBzdW0lMjBvZiUyMG51bWJlcnMlMjBmcm9tJTIwMSUyMHRvJTIwMTAlMjIpJTBBcHJpbnQocmVzdWx0KQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

<span class="hljs-comment"># Initialize a model (using Hugging Face Inference API)</span>
model = InferenceClientModel()  <span class="hljs-comment"># Uses a default model</span>

<span class="hljs-comment"># Create an agent with no tools</span>
agent = CodeAgent(tools=[], model=model)

<span class="hljs-comment"># Run the agent with a task</span>
result = agent.run(<span class="hljs-string">&quot;Calculate the sum of numbers from 1 to 10&quot;</span>)
<span class="hljs-built_in">print</span>(result)`,wrap:!1}}),V=new M({props:{title:"Adding Tools",local:"adding-tools",headingTag:"h3"}}),A=new Ie({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMER1Y2tEdWNrR29TZWFyY2hUb29sJTBBJTBBbW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSklMEElMEElMjMlMjBOb3clMjB0aGUlMjBhZ2VudCUyMGNhbiUyMHNlYXJjaCUyMHRoZSUyMHdlYiElMEFyZXN1bHQlMjAlM0QlMjBhZ2VudC5ydW4oJTIyV2hhdCUyMGlzJTIwdGhlJTIwY3VycmVudCUyMHdlYXRoZXIlMjBpbiUyMFBhcmlzJTNGJTIyKSUwQXByaW50KHJlc3VsdCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, DuckDuckGoSearchTool

model = InferenceClientModel()
agent = CodeAgent(
    tools=[DuckDuckGoSearchTool()],
    model=model,
)

<span class="hljs-comment"># Now the agent can search the web!</span>
result = agent.run(<span class="hljs-string">&quot;What is the current weather in Paris?&quot;</span>)
<span class="hljs-built_in">print</span>(result)`,wrap:!1}}),N=new M({props:{title:"Using Different Models",local:"using-different-models",headingTag:"h3"}}),P=new Ie({props:{code:"JTIzJTIwVXNpbmclMjBhJTIwc3BlY2lmaWMlMjBtb2RlbCUyMGZyb20lMjBIdWdnaW5nJTIwRmFjZSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03MGItY2hhdC1oZiUyMiklMEElMEElMjMlMjBVc2luZyUyME9wZW5BSSUyRkFudGhyb3BpYyUyMChyZXF1aXJlcyUyMCdzbW9sYWdlbnRzJTVCbGl0ZWxsbSU1RCcpJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBMaXRlTExNTW9kZWwlMEFtb2RlbCUyMCUzRCUyMExpdGVMTE1Nb2RlbChtb2RlbF9pZCUzRCUyMmdwdC00JTIyKSUwQSUwQSUyMyUyMFVzaW5nJTIwbG9jYWwlMjBtb2RlbHMlMjAocmVxdWlyZXMlMjAnc21vbGFnZW50cyU1QnRyYW5zZm9ybWVycyU1RCcpJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUcmFuc2Zvcm1lcnNNb2RlbCUwQW1vZGVsJTIwJTNEJTIwVHJhbnNmb3JtZXJzTW9kZWwobW9kZWxfaWQlM0QlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyKQ==",highlighted:`<span class="hljs-comment"># Using a specific model from Hugging Face</span>
model = InferenceClientModel(model_id=<span class="hljs-string">&quot;meta-llama/Llama-2-70b-chat-hf&quot;</span>)

<span class="hljs-comment"># Using OpenAI/Anthropic (requires &#x27;smolagents[litellm]&#x27;)</span>
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> LiteLLMModel
model = LiteLLMModel(model_id=<span class="hljs-string">&quot;gpt-4&quot;</span>)

<span class="hljs-comment"># Using local models (requires &#x27;smolagents[transformers]&#x27;)</span>
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> TransformersModel
model = TransformersModel(model_id=<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)`,wrap:!1}}),Y=new M({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),X=new pt({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/index.md"}}),{c(){f=o("meta"),K=s(),q=o("p"),O=s(),d(w.$$.fragment),ee=s(),b=o("div"),b.innerHTML=Re,te=s(),d(y.$$.fragment),le=s(),T=o("p"),T.innerHTML=Ge,ne=s(),x=o("p"),x.innerHTML=Qe,se=s(),$=o("p"),$.innerHTML=Ee,ae=s(),v=o("p"),v.innerHTML=Ve,oe=s(),C=o("p"),C.innerHTML=Se,ie=s(),j=o("p"),j.innerHTML=Ae,re=s(),J=o("p"),J.innerHTML=Ne,de=s(),U=o("p"),U.innerHTML=Fe,me=s(),W=o("p"),W.innerHTML=Pe,pe=s(),k=o("p"),k.innerHTML=Ye,ge=s(),d(B.$$.fragment),ue=s(),d(_.$$.fragment),ce=s(),Z=o("p"),Z.textContent=ze,fe=s(),d(H.$$.fragment),be=s(),I=o("p"),I.textContent=Xe,he=s(),d(L.$$.fragment),Me=s(),d(R.$$.fragment),we=s(),G=o("p"),G.textContent=qe,ye=s(),d(Q.$$.fragment),Te=s(),E=o("p"),E.textContent=De,xe=s(),d(V.$$.fragment),$e=s(),S=o("p"),S.textContent=Ke,ve=s(),d(A.$$.fragment),Ce=s(),d(N.$$.fragment),je=s(),F=o("p"),F.textContent=Oe,Je=s(),d(P.$$.fragment),Ue=s(),d(Y.$$.fragment),We=s(),z=o("ul"),z.innerHTML=et,ke=s(),h=o("div"),h.innerHTML=tt,Be=s(),d(X.$$.fragment),_e=s(),D=o("p"),this.h()},l(e){const t=rt("svelte-u9bgzb",document.head);f=i(t,"META",{name:!0,content:!0}),t.forEach(l),K=a(e),q=i(e,"P",{}),lt(q).forEach(l),O=a(e),m(w.$$.fragment,e),ee=a(e),b=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-179djvt"&&(b.innerHTML=Re),te=a(e),m(y.$$.fragment,e),le=a(e),T=i(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-jhl2ln"&&(T.innerHTML=Ge),ne=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1pqihaz"&&(x.innerHTML=Qe),se=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1mb244l"&&($.innerHTML=Ee),ae=a(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-j73xkp"&&(v.innerHTML=Ve),oe=a(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-yoh19t"&&(C.innerHTML=Se),ie=a(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1lg6pu7"&&(j.innerHTML=Ae),re=a(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1qzseh1"&&(J.innerHTML=Ne),de=a(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1rmitxe"&&(U.innerHTML=Fe),me=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-a167ry"&&(W.innerHTML=Pe),pe=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-s12dt5"&&(k.innerHTML=Ye),ge=a(e),m(B.$$.fragment,e),ue=a(e),m(_.$$.fragment,e),ce=a(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1e03v1f"&&(Z.textContent=ze),fe=a(e),m(H.$$.fragment,e),be=a(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-edafpj"&&(I.textContent=Xe),he=a(e),m(L.$$.fragment,e),Me=a(e),m(R.$$.fragment,e),we=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-d4prih"&&(G.textContent=qe),ye=a(e),m(Q.$$.fragment,e),Te=a(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1ys1s7w"&&(E.textContent=De),xe=a(e),m(V.$$.fragment,e),$e=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-10xh9zq"&&(S.textContent=Ke),ve=a(e),m(A.$$.fragment,e),Ce=a(e),m(N.$$.fragment,e),je=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-198akbh"&&(F.textContent=Oe),Je=a(e),m(P.$$.fragment,e),Ue=a(e),m(Y.$$.fragment,e),We=a(e),z=i(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-1hwc194"&&(z.innerHTML=et),ke=a(e),h=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-ywybpx"&&(h.innerHTML=tt),Be=a(e),m(X.$$.fragment,e),_e=a(e),D=i(e,"P",{}),lt(D).forEach(l),this.h()},h(){He(f,"name","hf:doc:metadata"),He(f,"content",ut),He(b,"class","flex justify-center"),He(h,"class","mt-10")},m(e,t){dt(document.head,f),n(e,K,t),n(e,q,t),n(e,O,t),p(w,e,t),n(e,ee,t),n(e,b,t),n(e,te,t),p(y,e,t),n(e,le,t),n(e,T,t),n(e,ne,t),n(e,x,t),n(e,se,t),n(e,$,t),n(e,ae,t),n(e,v,t),n(e,oe,t),n(e,C,t),n(e,ie,t),n(e,j,t),n(e,re,t),n(e,J,t),n(e,de,t),n(e,U,t),n(e,me,t),n(e,W,t),n(e,pe,t),n(e,k,t),n(e,ge,t),p(B,e,t),n(e,ue,t),p(_,e,t),n(e,ce,t),n(e,Z,t),n(e,fe,t),p(H,e,t),n(e,be,t),n(e,I,t),n(e,he,t),p(L,e,t),n(e,Me,t),p(R,e,t),n(e,we,t),n(e,G,t),n(e,ye,t),p(Q,e,t),n(e,Te,t),n(e,E,t),n(e,xe,t),p(V,e,t),n(e,$e,t),n(e,S,t),n(e,ve,t),p(A,e,t),n(e,Ce,t),p(N,e,t),n(e,je,t),n(e,F,t),n(e,Je,t),p(P,e,t),n(e,Ue,t),p(Y,e,t),n(e,We,t),n(e,z,t),n(e,ke,t),n(e,h,t),n(e,Be,t),p(X,e,t),n(e,_e,t),n(e,D,t),Ze=!0},p:st,i(e){Ze||(g(w.$$.fragment,e),g(y.$$.fragment,e),g(B.$$.fragment,e),g(_.$$.fragment,e),g(H.$$.fragment,e),g(L.$$.fragment,e),g(R.$$.fragment,e),g(Q.$$.fragment,e),g(V.$$.fragment,e),g(A.$$.fragment,e),g(N.$$.fragment,e),g(P.$$.fragment,e),g(Y.$$.fragment,e),g(X.$$.fragment,e),Ze=!0)},o(e){u(w.$$.fragment,e),u(y.$$.fragment,e),u(B.$$.fragment,e),u(_.$$.fragment,e),u(H.$$.fragment,e),u(L.$$.fragment,e),u(R.$$.fragment,e),u(Q.$$.fragment,e),u(V.$$.fragment,e),u(A.$$.fragment,e),u(N.$$.fragment,e),u(P.$$.fragment,e),u(Y.$$.fragment,e),u(X.$$.fragment,e),Ze=!1},d(e){e&&(l(K),l(q),l(O),l(ee),l(b),l(te),l(le),l(T),l(ne),l(x),l(se),l($),l(ae),l(v),l(oe),l(C),l(ie),l(j),l(re),l(J),l(de),l(U),l(me),l(W),l(pe),l(k),l(ge),l(ue),l(ce),l(Z),l(fe),l(be),l(I),l(he),l(Me),l(we),l(G),l(ye),l(Te),l(E),l(xe),l($e),l(S),l(ve),l(Ce),l(je),l(F),l(Je),l(Ue),l(We),l(z),l(ke),l(h),l(Be),l(_e),l(D)),l(f),c(w,e),c(y,e),c(B,e),c(_,e),c(H,e),c(L,e),c(R,e),c(Q,e),c(V,e),c(A,e),c(N,e),c(P,e),c(Y,e),c(X,e)}}}const ut='{"title":"smolagents","local":"smolagents","sections":[{"title":"What is smolagents?","local":"what-is-smolagents","sections":[],"depth":2},{"title":"Quickstart","local":"quickstart","sections":[{"title":"Installation","local":"installation","sections":[],"depth":3},{"title":"Create Your First Agent","local":"create-your-first-agent","sections":[],"depth":3},{"title":"Adding Tools","local":"adding-tools","sections":[],"depth":3},{"title":"Using Different Models","local":"using-different-models","sections":[],"depth":3}],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function ct(Le){return at(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yt extends ot{constructor(f){super(),it(this,f,ct,gt,nt,{})}}export{yt as component};
