import{s as is,f as ss,o as os,n as dt}from"../chunks/scheduler.f6319a2a.js";import{S as ps,i as Ms,g as i,s,r,A as rs,h as o,f as l,c as a,j as as,u,x as p,k as ct,y as us,a as n,v as c,d as y,t as d,w as J}from"../chunks/index.85aa684c.js";import{T as yt}from"../chunks/Tip.3d397a88.js";import{C as j}from"../chunks/CodeBlock.3400fc53.js";import{D as cs}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as m,E as ys}from"../chunks/getInferenceSnippets.55a93fbe.js";function ds(I){let M,b='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){M=i("p"),M.innerHTML=b},l(w){M=o(w,"P",{"data-svelte-h":!0}),p(M)!=="svelte-1p1d9vw"&&(M.innerHTML=b)},m(w,h){n(w,M,h)},p:dt,d(w){w&&l(M)}}}function Js(I){let M,b="It’s important to understand that no local python sandbox can ever be completely secure. While our interpreter provides significant safety improvements over the standard Python interpreter, it is still possible for a determined attacker or a fine-tuned malicious LLM to find vulnerabilities and potentially harm your environment.",w,h,g="For example, if you’ve allowed packages like <code>Pillow</code> to process images, the LLM could generate code that creates thousands of large image files to fill your hard drive. Other advanced escape techniques might exploit deeper vulnerabilities in authorized packages.",C,U,Z="Running LLM-generated code in your local environment always carries some inherent risk. The only way to run LLM-generated code with truly robust security isolation is to use remote execution options like E2B or Docker, as detailed below.";return{c(){M=i("p"),M.textContent=b,w=s(),h=i("p"),h.innerHTML=g,C=s(),U=i("p"),U.textContent=Z},l(T){M=o(T,"P",{"data-svelte-h":!0}),p(M)!=="svelte-13ohzr"&&(M.textContent=b),w=a(T),h=o(T,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1wfid17"&&(h.innerHTML=g),C=a(T),U=o(T,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1zo76k"&&(U.textContent=Z)},m(T,f){n(T,M,f),n(T,w,f),n(T,h,f),n(T,C,f),n(T,U,f)},p:dt,d(T){T&&(l(M),l(w),l(h),l(C),l(U))}}}function ws(I){let M,b=`Using the agent as a context manager (with the <code>with</code> statement) ensures that the E2B sandbox is cleaned up immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.`;return{c(){M=i("p"),M.innerHTML=b},l(w){M=o(w,"P",{"data-svelte-h":!0}),p(M)!=="svelte-h2lp0n"&&(M.innerHTML=b)},m(w,h){n(w,M,h)},p:dt,d(w){w&&l(M)}}}function ms(I){let M,b=`Using the agent as a context manager (with the <code>with</code> statement) ensures that the Modal sandbox is cleaned immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.`;return{c(){M=i("p"),M.innerHTML=b},l(w){M=o(w,"P",{"data-svelte-h":!0}),p(M)!=="svelte-13o6fhw"&&(M.innerHTML=b)},m(w,h){n(w,M,h)},p:dt,d(w){w&&l(M)}}}function Ts(I){let M,b=`Using the agent as a context manager (with the <code>with</code> statement) ensures that the Docker container is cleaned immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.`;return{c(){M=i("p"),M.innerHTML=b},l(w){M=o(w,"P",{"data-svelte-h":!0}),p(M)!=="svelte-hvigp3"&&(M.innerHTML=b)},m(w,h){n(w,M,h)},p:dt,d(w){w&&l(M)}}}function hs(I){let M,b,w,h,g,C,U,Z,T,f,W,Jt,G,Ol='<a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Multiple</a> <a href="https://huggingface.co/papers/2411.01747" rel="nofollow">research</a> <a href="https://huggingface.co/papers/2401.00812" rel="nofollow">papers</a> have shown that having the LLM write its actions (the tool calls) in code is much better than the current standard format for tool calling, which is across the industry different shades of “writing actions as a JSON of tools names and arguments to use”.',wt,A,en="Why is code better? Well, because we crafted our code languages specifically to be great at expressing actions performed by a computer. If JSON snippets were a better way, this package would have been written in JSON snippets and the devil would be laughing at us.",mt,V,tn="Code is just a better way to express actions on a computer. It has better:",Tt,E,ln="<li><strong>Composability:</strong> could you nest JSON actions within each other, or define a set of JSON actions to re-use later, the same way you could just define a python function?</li> <li><strong>Object management:</strong> how do you store the output of an action like <code>generate_image</code> in JSON?</li> <li><strong>Generality:</strong> code is built to express simply anything you can have a computer do.</li> <li><strong>Representation in LLM training corpus:</strong> why not leverage this benediction of the sky that plenty of quality actions have already been included in LLM training corpus?</li>",ht,R,nn='This is illustrated on the figure below, taken from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>.',bt,Mt,sn,Ut,N,an="This is why we put emphasis on proposing code agents, in this case python agents, which meant putting higher effort on building secure python interpreters.",It,_,jt,S,on="By default, the <code>CodeAgent</code> runs LLM-generated code in your environment.",gt,Q,pn="This is inherently risky, LLM-generated code could be harmful to your environment.",ft,H,Mn="Malicious code execution can occur in several ways:",Ct,Y,rn=`<li><strong>Plain LLM error:</strong> LLMs are still far from perfect and may unintentionally generate harmful commands while attempting to be helpful. While this risk is low, instances have been observed where an LLM attempted to execute potentially dangerous code.</li> <li><strong>Supply chain attack:</strong> Running an untrusted or compromised LLM could expose a system to harmful code generation. While this risk is extremely low when using well-known models on secure inference infrastructure, it remains a theoretical possibility.</li> <li><strong>Prompt injection:</strong> an agent browsing the web could arrive on a malicious website that contains harmful instructions, thus injecting an attack into the agent’s memory</li> <li><strong>Exploitation of publicly accessible agents:</strong> Agents exposed to the public can be misused by malicious actors to execute harmful code. Attackers may craft adversarial inputs to exploit the agent’s execution capabilities, leading to unintended consequences.
Once malicious code is executed, whether accidentally or intentionally, it can damage the file system, exploit local or cloud-based resources, abuse API services, and even compromise network security.</li>`,xt,X,un='One could argue that on the <a href="../conceptual_guides/intro_agents">spectrum of agency</a>, code agents give much higher agency to the LLM on your system than other less agentic setups: this goes hand-in-hand with higher risk.',Bt,q,cn="So you need to be very mindful of security.",vt,z,yn="To improve safety, we propose a range of measures that propose elevated levels of security, at a higher setup cost.",$t,F,dn="We advise you to keep in mind that no solution will be 100% safe.",kt,rt,Jn,Zt,L,Wt,D,wn=`To add a first layer of security, code execution in <code>smolagents</code> is not performed by the vanilla Python interpreter.
We have re-built a more secure <code>LocalPythonExecutor</code> from the ground up.`,Gt,P,mn="To be precise, this interpreter works by loading the Abstract Syntax Tree (AST) from your Code and executes it operation by operation, making sure to always follow certain rules:",At,K,Tn="<li>By default, imports are disallowed unless they have been explicitly added to an authorization list by the user.</li> <li>Furthermore, access to submodules is disabled by default, and each must be explicitly authorized in the import list as well, or you can pass for instance <code>numpy.*</code> to allow both <code>numpy</code> and all its subpackags, like <code>numpy.random</code> or <code>numpy.a.b</code>.<ul><li>Note that some seemingly innocuous packages like <code>random</code> can give access to potentially harmful submodules, as in <code>random._os</code>.</li></ul></li> <li>The total count of elementary operations processed is capped to prevent infinite loops and resource bloating.</li> <li>Any operation that has not been explicitly defined in our custom interpreter will raise an error.</li>",Vt,O,hn="You could try these safeguards as follows:",Et,ee,Rt,te,bn=`These safeguards make out interpreter is safer.
We have used it on a diversity of use cases, without ever observing any damage to the environment.`,Nt,x,_t,le,Un=`The risk of a malicious attack is low when using well-known LLMs from trusted inference providers, but it is not zero.
For high-security applications or when using less trusted models, you should consider using a remote execution sandbox.`,St,ne,Qt,se,In="When working with AI agents that execute code, security is paramount. There are two main approaches to sandboxing code execution in smolagents, each with different security properties and capabilities:",Ht,ae,jn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/sandboxed_execution.png" alt="Sandbox approaches comparison"/>',Yt,ie,gn=`<li><p><strong>Running individual code snippets in a sandbox</strong>: This approach (left side of diagram) only executes the agent-generated Python code snippets in a sandbox while keeping the rest of the agentic system in your local environment. It’s simpler to set up using <code>executor_type=&quot;e2b&quot;</code>, <code>executor_type=&quot;modal&quot;</code>, or
<code>executor_type=&quot;docker&quot;</code>, but it doesn’t support multi-agents and still requires passing state data between your environment and the sandbox.</p></li> <li><p><strong>Running the entire agentic system in a sandbox</strong>: This approach (right side of diagram) runs the entire agentic system, including the agent, model, and tools, within a sandbox environment. This provides better isolation but requires more manual setup and may require passing sensitive credentials (like API keys) to the sandbox environment.</p></li>`,Xt,oe,fn="This guide describes how to set up and use both types of sandbox approaches for your agent applications.",qt,pe,zt,Me,Ft,re,Cn='<li>Create an E2B account at <a href="https://e2b.dev" rel="nofollow">e2b.dev</a></li> <li>Install the required packages:</li>',Lt,ue,Dt,ce,Pt,ye,xn="We provide a simple way to use an E2B Sandbox: simply add <code>executor_type=&quot;e2b&quot;</code> to the agent initialization, as follows:",Kt,de,Ot,B,el,Je,Bn=`This solution send the agent state to the server at the start of each <code>agent.run()</code>.
Then the models are called from the local environment, but the generated code will be sent to the sandbox for execution, and only the output will be returned.`,tl,we,vn="This is illustrated in the figure below.",ll,v,$n='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/sandboxed_execution.png" alt="sandboxed code execution" width="60%" max-width="500px"/>',nl,me,kn=`However, since any call to a <a href="../examples/multiagents">managed agent</a> would require model calls, since we do not transfer secrets to the remote sandbox, the model call would lack credentials.
Hence this solution does not work (yet) with more complicated multi-agent setups.`,sl,Te,al,he,Zn="To use multi-agents in an E2B sandbox, you need to run your agents completely from within E2B.",il,be,Wn="Here is how to do it:",ol,Ue,pl,Ie,Ml,je,rl,ge,Gn='<li>Create a Modal account at <a href="https://modal.com/signup" rel="nofollow">modal.com</a></li> <li>Install the required packages:</li>',ul,fe,cl,Ce,yl,xe,An="We provide a simple way to use a Modal Sandbox: simply add <code>executor_type=&quot;modal&quot;</code> to the agent initialization, as follows:",dl,Be,Jl,$,wl,ve,Vn="The agent state and generated code from the <code>InferenceClientModel</code> are sent to a Modal sandbox, which can securely execute code inside them.",ml,$e,Tl,ke,hl,Ze,En='<li><a href="https://docs.docker.com/get-started/get-docker/" rel="nofollow">Install Docker on your system</a></li> <li>Install the required packages:</li>',bl,We,Ul,Ge,Il,Ae,Rn="Similar to the E2B Sandbox above, to quickly get started with Docker, simply add <code>executor_type=&quot;docker&quot;</code> to the agent initialization, like:",jl,Ve,gl,k,fl,Ee,Cl,Re,Nn="If you want to run multi-agent systems in Docker, you’ll need to setup a custom interpreter in a sandbox.",xl,Ne,_n="Here is how to setup the a Dockerfile:",Bl,_e,vl,Se,Sn="Create a sandbox manager to run code:",$l,Qe,kl,He,Zl,Ye,Qn=`WebAssembly (Wasm) is a binary instruction format that allows code to be run in a safe, sandboxed environment.
It is designed to be fast, efficient, and secure, making it an excellent choice for executing potentially untrusted code.`,Wl,Xe,Hn='The <code>WasmExecutor</code> uses <a href="https://pyodide.org/" rel="nofollow">Pyodide</a> and <a href="https://docs.deno.com/" rel="nofollow">Deno</a>.',Gl,qe,Al,ze,Yn='<li><a href="https://docs.deno.com/runtime/getting_started/installation/" rel="nofollow">Install Deno on your system</a></li>',Vl,Fe,El,Le,Xn="Simply pass <code>executor_type=&quot;wasm&quot;</code> to the agent initialization, like:",Rl,De,Nl,Pe,_l,Ke,qn="These key practices apply to both E2B and Docker sandboxes:",Sl,Oe,zn="<li><p>Resource management</p> <ul><li>Set memory and CPU limits</li> <li>Implement execution timeouts</li> <li>Monitor resource usage</li></ul></li> <li><p>Security</p> <ul><li>Run with minimal privileges</li> <li>Disable unnecessary network access</li> <li>Use environment variables for secrets</li></ul></li> <li><p>Environment</p> <ul><li>Keep dependencies minimal</li> <li>Use fixed package versions</li> <li>If you use base images, update them regularly</li></ul></li> <li><p>Cleanup</p> <ul><li>Always ensure proper cleanup of resources, especially for Docker containers, to avoid having dangling containers eating up resources.</li></ul></li>",Ql,et,Fn="✨ By following these practices and implementing proper cleanup procedures, you can ensure your agent runs safely and efficiently in a sandboxed environment.",Hl,tt,Yl,lt,Ln="As illustrated in the diagram earlier, both sandboxing approaches have different security implications:",Xl,nt,ql,st,Dn="<li><strong>Pros</strong>: <ul><li>Easier to set up with a simple parameter (<code>executor_type=&quot;e2b&quot;</code> or <code>executor_type=&quot;docker&quot;</code>)</li> <li>No need to transfer API keys to the sandbox</li> <li>Better protection for your local environment</li></ul></li> <li><strong>Cons</strong>:<ul><li>Doesn’t support multi-agents (managed agents)</li> <li>Still requires transferring state between your environment and the sandbox</li> <li>Limited to specific code execution</li></ul></li>",zl,at,Fl,it,Pn="<li><strong>Pros</strong>:<ul><li>Supports multi-agents</li> <li>Complete isolation of the entire agent system</li> <li>More flexible for complex agent architectures</li></ul></li> <li><strong>Cons</strong>:<ul><li>Requires more manual setup</li> <li>May require transferring sensitive API keys to the sandbox</li> <li>Potentially higher latency due to more complex operations</li></ul></li>",Ll,ot,Kn="Choose the approach that best balances your security needs with your application’s requirements. For most applications with simpler agent architectures, Approach 1 provides a good balance of security and ease of use. For more complex multi-agent systems where you need full isolation, Approach 2, while more involved to set up, offers better security guarantees.",Dl,pt,Pl,ut,Kl;return g=new m({props:{title:"Secure code execution",local:"secure-code-execution",headingTag:"h1"}}),U=new cs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"}]}}),T=new yt({props:{warning:!1,$$slots:{default:[ds]},$$scope:{ctx:I}}}),W=new m({props:{title:"Code agents",local:"code-agents",headingTag:"h3"}}),_=new m({props:{title:"Local code execution??",local:"local-code-execution",headingTag:"h3"}}),L=new m({props:{title:"Our local Python executor",local:"our-local-python-executor",headingTag:"h3"}}),ee=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents.local_python_executor <span class="hljs-keyword">import</span> LocalPythonExecutor

<span class="hljs-comment"># Set up custom executor, authorize package &quot;numpy&quot;</span>
custom_executor = LocalPythonExecutor([<span class="hljs-string">&quot;numpy&quot;</span>])

<span class="hljs-comment"># Utilisty for pretty printing errors</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_capture_exception</span>(<span class="hljs-params">command: <span class="hljs-built_in">str</span></span>):
    <span class="hljs-keyword">try</span>:
        custom_executor(harmful_command)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;ERROR:\\n&quot;</span>, e)

<span class="hljs-comment"># Undefined command just do not work</span>
harmful_command=<span class="hljs-string">&quot;!echo Bad command&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: invalid syntax (&lt;unknown&gt;, line 1)</span>


<span class="hljs-comment"># Imports like os will not be performed unless explicitly added to \`additional_authorized_imports\`</span>
harmful_command=<span class="hljs-string">&quot;import os; exit_code = os.system(&#x27;echo Bad command&#x27;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;import os&#x27; due to: InterpreterError: Import of os is not allowed. Authorized imports are: [&#x27;statistics&#x27;, &#x27;numpy&#x27;, &#x27;itertools&#x27;, &#x27;time&#x27;, &#x27;queue&#x27;, &#x27;collections&#x27;, &#x27;math&#x27;, &#x27;random&#x27;, &#x27;re&#x27;, &#x27;datetime&#x27;, &#x27;stat&#x27;, &#x27;unicodedata&#x27;]</span>

<span class="hljs-comment"># Even in authorized imports, potentially harmful packages will not be imported</span>
harmful_command=<span class="hljs-string">&quot;import random; random._os.system(&#x27;echo Bad command&#x27;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;random._os.system(&#x27;echo Bad command&#x27;)&#x27; due to: InterpreterError: Forbidden access to module: os</span>

<span class="hljs-comment"># Infinite loop are interrupted after N operations</span>
harmful_command=<span class="hljs-string">&quot;&quot;&quot;
while True:
    pass
&quot;&quot;&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;while True: pass&#x27; due to: InterpreterError: Maximum number of 1000000 iterations in While loop exceeded</span>`,wrap:!1}}),x=new yt({props:{warning:!0,$$slots:{default:[Js]},$$scope:{ctx:I}}}),ne=new m({props:{title:"Sandbox approaches for secure code execution",local:"sandbox-approaches-for-secure-code-execution",headingTag:"h2"}}),pe=new m({props:{title:"E2B setup",local:"e2b-setup",headingTag:"h3"}}),Me=new m({props:{title:"Installation",local:"installation",headingTag:"h4"}}),ue=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZTJiJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[e2b]&#x27;</span>',wrap:!1}}),ce=new m({props:{title:"Running your agent in E2B: quick start",local:"running-your-agent-in-e2b-quick-start",headingTag:"h4"}}),de=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBDb2RlQWdlbnQobW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdG9vbHMlM0QlNUIlNUQlMkMlMjBleGVjdXRvcl90eXBlJTNEJTIyZTJiJTIyKSUyMGFzJTIwYWdlbnQlM0ElMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-keyword">with</span> CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;e2b&quot;</span>) <span class="hljs-keyword">as</span> agent:
    agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),B=new yt({props:{warning:!1,$$slots:{default:[ws]},$$scope:{ctx:I}}}),Te=new m({props:{title:"Running your agent in E2B: multi-agents",local:"running-your-agent-in-e2b-multi-agents",headingTag:"h4"}}),Ue=new j({props:{code:"ZnJvbSUyMGUyYl9jb2RlX2ludGVycHJldGVyJTIwaW1wb3J0JTIwU2FuZGJveCUwQWltcG9ydCUyMG9zJTBBJTBBJTIzJTIwQ3JlYXRlJTIwdGhlJTIwc2FuZGJveCUwQXNhbmRib3glMjAlM0QlMjBTYW5kYm94KCklMEElMEElMjMlMjBJbnN0YWxsJTIwcmVxdWlyZWQlMjBwYWNrYWdlcyUwQXNhbmRib3guY29tbWFuZHMucnVuKCUyMnBpcCUyMGluc3RhbGwlMjBzbW9sYWdlbnRzJTIyKSUwQSUwQWRlZiUyMHJ1bl9jb2RlX3JhaXNlX2Vycm9ycyhzYW5kYm94JTJDJTIwY29kZSUzQSUyMHN0ciUyQyUyMHZlcmJvc2UlM0ElMjBib29sJTIwJTNEJTIwRmFsc2UpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMGV4ZWN1dGlvbiUyMCUzRCUyMHNhbmRib3gucnVuX2NvZGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29kZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudnMlM0QlN0InSEZfVE9LRU4nJTNBJTIwb3MuZ2V0ZW52KCdIRl9UT0tFTicpJTdEJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGlmJTIwZXhlY3V0aW9uLmVycm9yJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhlY3V0aW9uX2xvZ3MlMjAlM0QlMjAlMjIlNUNuJTIyLmpvaW4oJTVCc3RyKGxvZyklMjBmb3IlMjBsb2clMjBpbiUyMGV4ZWN1dGlvbi5sb2dzLnN0ZG91dCU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2dzJTIwJTNEJTIwZXhlY3V0aW9uX2xvZ3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2dzJTIwJTJCJTNEJTIwZXhlY3V0aW9uLmVycm9yLnRyYWNlYmFjayUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwVmFsdWVFcnJvcihsb2dzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCUyMiU1Q24lMjIuam9pbiglNUJzdHIobG9nKSUyMGZvciUyMGxvZyUyMGluJTIwZXhlY3V0aW9uLmxvZ3Muc3Rkb3V0JTVEKSUwQSUwQSUyMyUyMERlZmluZSUyMHlvdXIlMjBhZ2VudCUyMGFwcGxpY2F0aW9uJTBBYWdlbnRfY29kZSUyMCUzRCUyMCUyMiUyMiUyMiUwQWltcG9ydCUyMG9zJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjBhZ2VudHMlMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKHRva2VuJTNEb3MuZ2V0ZW52KCUyMkhGX1RPS0VOJTIyKSUyQyUyMHByb3ZpZGVyJTNEJTIydG9nZXRoZXIlMjIpJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUIlNUQlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyY29kZXJfYWdlbnQlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlRoaXMlMjBhZ2VudCUyMHRha2VzJTIwY2FyZSUyMG9mJTIweW91ciUyMGRpZmZpY3VsdCUyMGFsZ29yaXRobWljJTIwcHJvYmxlbXMlMjB1c2luZyUyMGNvZGUuJTIyJTBBKSUwQSUwQW1hbmFnZXJfYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCh0b2tlbiUzRG9zLmdldGVudiglMjJIRl9UT0tFTiUyMiklMkMlMjBwcm92aWRlciUzRCUyMnRvZ2V0aGVyJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbWFuYWdlZF9hZ2VudHMlM0QlNUJhZ2VudCU1RCUyQyUwQSklMEElMEElMjMlMjBSdW4lMjB0aGUlMjBhZ2VudCUwQXJlc3BvbnNlJTIwJTNEJTIwbWFuYWdlcl9hZ2VudC5ydW4oJTIyV2hhdCdzJTIwdGhlJTIwMjB0aCUyMEZpYm9uYWNjaSUyMG51bWJlciUzRiUyMiklMEFwcmludChyZXNwb25zZSklMEElMjIlMjIlMjIlMEElMEElMjMlMjBSdW4lMjB0aGUlMjBhZ2VudCUyMGNvZGUlMjBpbiUyMHRoZSUyMHNhbmRib3glMEFleGVjdXRpb25fbG9ncyUyMCUzRCUyMHJ1bl9jb2RlX3JhaXNlX2Vycm9ycyhzYW5kYm94JTJDJTIwYWdlbnRfY29kZSklMEFwcmludChleGVjdXRpb25fbG9ncyk=",highlighted:`<span class="hljs-keyword">from</span> e2b_code_interpreter <span class="hljs-keyword">import</span> Sandbox
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Create the sandbox</span>
sandbox = Sandbox()

<span class="hljs-comment"># Install required packages</span>
sandbox.commands.run(<span class="hljs-string">&quot;pip install smolagents&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code_raise_errors</span>(<span class="hljs-params">sandbox, code: <span class="hljs-built_in">str</span>, verbose: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    execution = sandbox.run_code(
        code,
        envs={<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>: os.getenv(<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>)}
    )
    <span class="hljs-keyword">if</span> execution.error:
        execution_logs = <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])
        logs = execution_logs
        logs += execution.error.traceback
        <span class="hljs-keyword">raise</span> ValueError(logs)
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])

<span class="hljs-comment"># Define your agent application</span>
agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, InferenceClientModel

# Initialize the agents
agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    name=&quot;coder_agent&quot;,
    description=&quot;This agent takes care of your difficult algorithmic problems using code.&quot;
)

manager_agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    managed_agents=[agent],
)

# Run the agent
response = manager_agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

<span class="hljs-comment"># Run the agent code in the sandbox</span>
execution_logs = run_code_raise_errors(sandbox, agent_code)
<span class="hljs-built_in">print</span>(execution_logs)`,wrap:!1}}),Ie=new m({props:{title:"Modal setup",local:"modal-setup",headingTag:"h3"}}),je=new m({props:{title:"Installation",local:"installation",headingTag:"h4"}}),fe=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCbW9kYWwlNUQn",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[modal]&#x27;</span>',wrap:!1}}),Ce=new m({props:{title:"Running your agent in Modal: quick start",local:"running-your-agent-in-modal-quick-start",headingTag:"h4"}}),Be=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBDb2RlQWdlbnQobW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdG9vbHMlM0QlNUIlNUQlMkMlMjBleGVjdXRvcl90eXBlJTNEJTIybW9kYWwlMjIpJTIwYXMlMjBhZ2VudCUzQSUwQSUyMCUyMCUyMCUyMGFnZW50LnJ1biglMjJXaGF0JTIwaXMlMjB0aGUlMjA0MnRoJTIwRmlib25hY2NpJTIwbnVtYmVyJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-keyword">with</span> CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;modal&quot;</span>) <span class="hljs-keyword">as</span> agent:
    agent.run(<span class="hljs-string">&quot;What is the 42th Fibonacci number?&quot;</span>)`,wrap:!1}}),$=new yt({props:{warning:!1,$$slots:{default:[ms]},$$scope:{ctx:I}}}),$e=new m({props:{title:"Docker setup",local:"docker-setup",headingTag:"h3"}}),ke=new m({props:{title:"Installation",local:"installation",headingTag:"h4"}}),We=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZG9ja2VyJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[docker]&#x27;</span>',wrap:!1}}),Ge=new m({props:{title:"Running your agent in Docker: quick start",local:"running-your-agent-in-docker-quick-start",headingTag:"h4"}}),Ve=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBDb2RlQWdlbnQobW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdG9vbHMlM0QlNUIlNUQlMkMlMjBleGVjdXRvcl90eXBlJTNEJTIyZG9ja2VyJTIyKSUyMGFzJTIwYWdlbnQlM0ElMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-keyword">with</span> CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;docker&quot;</span>) <span class="hljs-keyword">as</span> agent:
    agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),k=new yt({props:{warning:!1,$$slots:{default:[Ts]},$$scope:{ctx:I}}}),Ee=new m({props:{title:"Advanced docker usage",local:"advanced-docker-usage",headingTag:"h4"}}),_e=new j({props:{code:"RlJPTSUyMHB5dGhvbiUzQTMuMTAtYnVsbHNleWUlMEElMEElMjMlMjBJbnN0YWxsJTIwYnVpbGQlMjBkZXBlbmRlbmNpZXMlMEFSVU4lMjBhcHQtZ2V0JTIwdXBkYXRlJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGluc3RhbGwlMjAteSUyMC0tbm8taW5zdGFsbC1yZWNvbW1lbmRzJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnVpbGQtZXNzZW50aWFsJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0aG9uMy1kZXYlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjBwaXAlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjBzbW9sYWdlbnRzJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGNsZWFuJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwcm0lMjAtcmYlMjAlMkZ2YXIlMkZsaWIlMkZhcHQlMkZsaXN0cyUyRiolMEElMEElMjMlMjBTZXQlMjB3b3JraW5nJTIwZGlyZWN0b3J5JTBBV09SS0RJUiUyMCUyRmFwcCUwQSUwQSUyMyUyMFJ1biUyMHdpdGglMjBsaW1pdGVkJTIwcHJpdmlsZWdlcyUwQVVTRVIlMjBub2JvZHklMEElMEElMjMlMjBEZWZhdWx0JTIwY29tbWFuZCUwQUNNRCUyMCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTJDJTIwJTIycHJpbnQoJ0NvbnRhaW5lciUyMHJlYWR5JyklMjIlNUQ=",highlighted:`<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.10</span>-bullseye

<span class="hljs-comment"># Install build dependencies</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> apt-get update &amp;&amp; \\
    apt-get install -y --no-install-recommends \\
        build-essential \\
        python3-dev &amp;&amp; \\
    pip install --no-cache-dir --upgrade pip &amp;&amp; \\
    pip install --no-cache-dir smolagents &amp;&amp; \\
    apt-get clean &amp;&amp; \\
    <span class="hljs-built_in">rm</span> -rf /var/lib/apt/lists/*</span>

<span class="hljs-comment"># Set working directory</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /app</span>

<span class="hljs-comment"># Run with limited privileges</span>
<span class="hljs-keyword">USER</span> nobody

<span class="hljs-comment"># Default command</span>
<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Container ready&#x27;)&quot;</span>]</span>`,wrap:!1}}),Qe=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> docker
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DockerSandbox</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        self.client = docker.from_env()
        self.container = <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">create_container</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">try</span>:
            image, build_logs = self.client.images.build(
                path=<span class="hljs-string">&quot;.&quot;</span>,
                tag=<span class="hljs-string">&quot;agent-sandbox&quot;</span>,
                rm=<span class="hljs-literal">True</span>,
                forcerm=<span class="hljs-literal">True</span>,
                buildargs={},
                <span class="hljs-comment"># decode=True</span>
            )
        <span class="hljs-keyword">except</span> docker.errors.BuildError <span class="hljs-keyword">as</span> e:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Build error logs:&quot;</span>)
            <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> e.build_log:
                <span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;stream&#x27;</span> <span class="hljs-keyword">in</span> log:
                    <span class="hljs-built_in">print</span>(log[<span class="hljs-string">&#x27;stream&#x27;</span>].strip())
            <span class="hljs-keyword">raise</span>

        <span class="hljs-comment"># Create container with security constraints and proper logging</span>
        self.container = self.client.containers.run(
            <span class="hljs-string">&quot;agent-sandbox&quot;</span>,
            command=<span class="hljs-string">&quot;tail -f /dev/null&quot;</span>,  <span class="hljs-comment"># Keep container running</span>
            detach=<span class="hljs-literal">True</span>,
            tty=<span class="hljs-literal">True</span>,
            mem_limit=<span class="hljs-string">&quot;512m&quot;</span>,
            cpu_quota=<span class="hljs-number">50000</span>,
            pids_limit=<span class="hljs-number">100</span>,
            security_opt=[<span class="hljs-string">&quot;no-new-privileges&quot;</span>],
            cap_drop=[<span class="hljs-string">&quot;ALL&quot;</span>],
            environment={
                <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
            },
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code</span>(<span class="hljs-params">self, code: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.container:
            self.create_container()

        <span class="hljs-comment"># Execute code in container</span>
        exec_result = self.container.exec_run(
            cmd=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, code],
            user=<span class="hljs-string">&quot;nobody&quot;</span>
        )

        <span class="hljs-comment"># Collect all output</span>
        <span class="hljs-keyword">return</span> exec_result.output.decode() <span class="hljs-keyword">if</span> exec_result.output <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>


    <span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> self.container:
            <span class="hljs-keyword">try</span>:
                self.container.stop()
            <span class="hljs-keyword">except</span> docker.errors.NotFound:
                <span class="hljs-comment"># Container already removed, this is expected</span>
                <span class="hljs-keyword">pass</span>
            <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Error during cleanup: <span class="hljs-subst">{e}</span>&quot;</span>)
            <span class="hljs-keyword">finally</span>:
                self.container = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Clear the reference</span>

<span class="hljs-comment"># Example usage:</span>
sandbox = DockerSandbox()

<span class="hljs-keyword">try</span>:
    <span class="hljs-comment"># Define your agent code</span>
    agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, InferenceClientModel

# Initialize the agent
agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[]
)

# Run the agent
response = agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Run the code in the sandbox</span>
    output = sandbox.run_code(agent_code)
    <span class="hljs-built_in">print</span>(output)

<span class="hljs-keyword">finally</span>:
    sandbox.cleanup()`,wrap:!1}}),He=new m({props:{title:"WebAssembly setup",local:"webassembly-setup",headingTag:"h3"}}),qe=new m({props:{title:"Installation",local:"installation",headingTag:"h4"}}),Fe=new m({props:{title:"Running your agent in WebAssembly: quick start",local:"running-your-agent-in-webassembly-quick-start",headingTag:"h4"}}),De=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMHRvb2xzJTNEJTVCJTVEJTJDJTIwZXhlY3V0b3JfdHlwZSUzRCUyMndhc20lMjIpJTBBJTBBYWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMDEwMHRoJTIwRmlib25hY2NpJTIwbnVtYmVyJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;wasm&quot;</span>)

agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),Pe=new m({props:{title:"Best practices for sandboxes",local:"best-practices-for-sandboxes",headingTag:"h3"}}),tt=new m({props:{title:"Comparing security approaches",local:"comparing-security-approaches",headingTag:"h2"}}),nt=new m({props:{title:"Approach 1: Running just the code snippets in a sandbox",local:"approach-1-running-just-the-code-snippets-in-a-sandbox",headingTag:"h3"}}),at=new m({props:{title:"Approach 2: Running the entire agentic system in a sandbox",local:"approach-2-running-the-entire-agentic-system-in-a-sandbox",headingTag:"h3"}}),pt=new ys({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/secure_code_execution.md"}}),{c(){M=i("meta"),b=s(),w=i("p"),h=s(),r(g.$$.fragment),C=s(),r(U.$$.fragment),Z=s(),r(T.$$.fragment),f=s(),r(W.$$.fragment),Jt=s(),G=i("p"),G.innerHTML=Ol,wt=s(),A=i("p"),A.textContent=en,mt=s(),V=i("p"),V.textContent=tn,Tt=s(),E=i("ul"),E.innerHTML=ln,ht=s(),R=i("p"),R.innerHTML=nn,bt=s(),Mt=i("img"),Ut=s(),N=i("p"),N.textContent=an,It=s(),r(_.$$.fragment),jt=s(),S=i("p"),S.innerHTML=on,gt=s(),Q=i("p"),Q.textContent=pn,ft=s(),H=i("p"),H.textContent=Mn,Ct=s(),Y=i("ul"),Y.innerHTML=rn,xt=s(),X=i("p"),X.innerHTML=un,Bt=s(),q=i("p"),q.textContent=cn,vt=s(),z=i("p"),z.textContent=yn,$t=s(),F=i("p"),F.textContent=dn,kt=s(),rt=i("img"),Zt=s(),r(L.$$.fragment),Wt=s(),D=i("p"),D.innerHTML=wn,Gt=s(),P=i("p"),P.textContent=mn,At=s(),K=i("ul"),K.innerHTML=Tn,Vt=s(),O=i("p"),O.textContent=hn,Et=s(),r(ee.$$.fragment),Rt=s(),te=i("p"),te.textContent=bn,Nt=s(),r(x.$$.fragment),_t=s(),le=i("p"),le.textContent=Un,St=s(),r(ne.$$.fragment),Qt=s(),se=i("p"),se.textContent=In,Ht=s(),ae=i("p"),ae.innerHTML=jn,Yt=s(),ie=i("ol"),ie.innerHTML=gn,Xt=s(),oe=i("p"),oe.textContent=fn,qt=s(),r(pe.$$.fragment),zt=s(),r(Me.$$.fragment),Ft=s(),re=i("ol"),re.innerHTML=Cn,Lt=s(),r(ue.$$.fragment),Dt=s(),r(ce.$$.fragment),Pt=s(),ye=i("p"),ye.innerHTML=xn,Kt=s(),r(de.$$.fragment),Ot=s(),r(B.$$.fragment),el=s(),Je=i("p"),Je.innerHTML=Bn,tl=s(),we=i("p"),we.textContent=vn,ll=s(),v=i("p"),v.innerHTML=$n,nl=s(),me=i("p"),me.innerHTML=kn,sl=s(),r(Te.$$.fragment),al=s(),he=i("p"),he.textContent=Zn,il=s(),be=i("p"),be.textContent=Wn,ol=s(),r(Ue.$$.fragment),pl=s(),r(Ie.$$.fragment),Ml=s(),r(je.$$.fragment),rl=s(),ge=i("ol"),ge.innerHTML=Gn,ul=s(),r(fe.$$.fragment),cl=s(),r(Ce.$$.fragment),yl=s(),xe=i("p"),xe.innerHTML=An,dl=s(),r(Be.$$.fragment),Jl=s(),r($.$$.fragment),wl=s(),ve=i("p"),ve.innerHTML=Vn,ml=s(),r($e.$$.fragment),Tl=s(),r(ke.$$.fragment),hl=s(),Ze=i("ol"),Ze.innerHTML=En,bl=s(),r(We.$$.fragment),Ul=s(),r(Ge.$$.fragment),Il=s(),Ae=i("p"),Ae.innerHTML=Rn,jl=s(),r(Ve.$$.fragment),gl=s(),r(k.$$.fragment),fl=s(),r(Ee.$$.fragment),Cl=s(),Re=i("p"),Re.textContent=Nn,xl=s(),Ne=i("p"),Ne.textContent=_n,Bl=s(),r(_e.$$.fragment),vl=s(),Se=i("p"),Se.textContent=Sn,$l=s(),r(Qe.$$.fragment),kl=s(),r(He.$$.fragment),Zl=s(),Ye=i("p"),Ye.textContent=Qn,Wl=s(),Xe=i("p"),Xe.innerHTML=Hn,Gl=s(),r(qe.$$.fragment),Al=s(),ze=i("ol"),ze.innerHTML=Yn,Vl=s(),r(Fe.$$.fragment),El=s(),Le=i("p"),Le.innerHTML=Xn,Rl=s(),r(De.$$.fragment),Nl=s(),r(Pe.$$.fragment),_l=s(),Ke=i("p"),Ke.textContent=qn,Sl=s(),Oe=i("ul"),Oe.innerHTML=zn,Ql=s(),et=i("p"),et.textContent=Fn,Hl=s(),r(tt.$$.fragment),Yl=s(),lt=i("p"),lt.textContent=Ln,Xl=s(),r(nt.$$.fragment),ql=s(),st=i("ul"),st.innerHTML=Dn,zl=s(),r(at.$$.fragment),Fl=s(),it=i("ul"),it.innerHTML=Pn,Ll=s(),ot=i("p"),ot.textContent=Kn,Dl=s(),r(pt.$$.fragment),Pl=s(),ut=i("p"),this.h()},l(e){const t=rs("svelte-u9bgzb",document.head);M=o(t,"META",{name:!0,content:!0}),t.forEach(l),b=a(e),w=o(e,"P",{}),as(w).forEach(l),h=a(e),u(g.$$.fragment,e),C=a(e),u(U.$$.fragment,e),Z=a(e),u(T.$$.fragment,e),f=a(e),u(W.$$.fragment,e),Jt=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1nor5c0"&&(G.innerHTML=Ol),wt=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1b2f48c"&&(A.textContent=en),mt=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1jp5kiv"&&(V.textContent=tn),Tt=a(e),E=o(e,"UL",{"data-svelte-h":!0}),p(E)!=="svelte-a7ou7n"&&(E.innerHTML=ln),ht=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1ugtxvn"&&(R.innerHTML=nn),bt=a(e),Mt=o(e,"IMG",{src:!0}),Ut=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1lbgv3o"&&(N.textContent=an),It=a(e),u(_.$$.fragment,e),jt=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-19p3p3d"&&(S.innerHTML=on),gt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-y55i8i"&&(Q.textContent=pn),ft=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-y4kupg"&&(H.textContent=Mn),Ct=a(e),Y=o(e,"UL",{"data-svelte-h":!0}),p(Y)!=="svelte-1b6z7ic"&&(Y.innerHTML=rn),xt=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-uopq3c"&&(X.innerHTML=un),Bt=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-gfolx1"&&(q.textContent=cn),vt=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1j1i1cv"&&(z.textContent=yn),$t=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1ghwkh9"&&(F.textContent=dn),kt=a(e),rt=o(e,"IMG",{src:!0}),Zt=a(e),u(L.$$.fragment,e),Wt=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-845rka"&&(D.innerHTML=wn),Gt=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-180snho"&&(P.textContent=mn),At=a(e),K=o(e,"UL",{"data-svelte-h":!0}),p(K)!=="svelte-19qb8ke"&&(K.innerHTML=Tn),Vt=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1wz8jbt"&&(O.textContent=hn),Et=a(e),u(ee.$$.fragment,e),Rt=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1gk7uki"&&(te.textContent=bn),Nt=a(e),u(x.$$.fragment,e),_t=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-whkli4"&&(le.textContent=Un),St=a(e),u(ne.$$.fragment,e),Qt=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-grnb59"&&(se.textContent=In),Ht=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1r04sc2"&&(ae.innerHTML=jn),Yt=a(e),ie=o(e,"OL",{"data-svelte-h":!0}),p(ie)!=="svelte-15n47tm"&&(ie.innerHTML=gn),Xt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1h3g1zs"&&(oe.textContent=fn),qt=a(e),u(pe.$$.fragment,e),zt=a(e),u(Me.$$.fragment,e),Ft=a(e),re=o(e,"OL",{"data-svelte-h":!0}),p(re)!=="svelte-uvtwg2"&&(re.innerHTML=Cn),Lt=a(e),u(ue.$$.fragment,e),Dt=a(e),u(ce.$$.fragment,e),Pt=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-r3242t"&&(ye.innerHTML=xn),Kt=a(e),u(de.$$.fragment,e),Ot=a(e),u(B.$$.fragment,e),el=a(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-jrgx8f"&&(Je.innerHTML=Bn),tl=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-8sir7q"&&(we.textContent=vn),ll=a(e),v=o(e,"P",{align:!0,"data-svelte-h":!0}),p(v)!=="svelte-11rtdvt"&&(v.innerHTML=$n),nl=a(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-ofpo9r"&&(me.innerHTML=kn),sl=a(e),u(Te.$$.fragment,e),al=a(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-geglm0"&&(he.textContent=Zn),il=a(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1iycphr"&&(be.textContent=Wn),ol=a(e),u(Ue.$$.fragment,e),pl=a(e),u(Ie.$$.fragment,e),Ml=a(e),u(je.$$.fragment,e),rl=a(e),ge=o(e,"OL",{"data-svelte-h":!0}),p(ge)!=="svelte-18yk2df"&&(ge.innerHTML=Gn),ul=a(e),u(fe.$$.fragment,e),cl=a(e),u(Ce.$$.fragment,e),yl=a(e),xe=o(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-fv88x1"&&(xe.innerHTML=An),dl=a(e),u(Be.$$.fragment,e),Jl=a(e),u($.$$.fragment,e),wl=a(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-1tt8eoy"&&(ve.innerHTML=Vn),ml=a(e),u($e.$$.fragment,e),Tl=a(e),u(ke.$$.fragment,e),hl=a(e),Ze=o(e,"OL",{"data-svelte-h":!0}),p(Ze)!=="svelte-19h0avy"&&(Ze.innerHTML=En),bl=a(e),u(We.$$.fragment,e),Ul=a(e),u(Ge.$$.fragment,e),Il=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-1j9zoi1"&&(Ae.innerHTML=Rn),jl=a(e),u(Ve.$$.fragment,e),gl=a(e),u(k.$$.fragment,e),fl=a(e),u(Ee.$$.fragment,e),Cl=a(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-t1it0d"&&(Re.textContent=Nn),xl=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1lygj8"&&(Ne.textContent=_n),Bl=a(e),u(_e.$$.fragment,e),vl=a(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-8mtm8c"&&(Se.textContent=Sn),$l=a(e),u(Qe.$$.fragment,e),kl=a(e),u(He.$$.fragment,e),Zl=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-ozg6k5"&&(Ye.textContent=Qn),Wl=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-1f0518g"&&(Xe.innerHTML=Hn),Gl=a(e),u(qe.$$.fragment,e),Al=a(e),ze=o(e,"OL",{"data-svelte-h":!0}),p(ze)!=="svelte-18eum27"&&(ze.innerHTML=Yn),Vl=a(e),u(Fe.$$.fragment,e),El=a(e),Le=o(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-zmyq9d"&&(Le.innerHTML=Xn),Rl=a(e),u(De.$$.fragment,e),Nl=a(e),u(Pe.$$.fragment,e),_l=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-5fyo5r"&&(Ke.textContent=qn),Sl=a(e),Oe=o(e,"UL",{"data-svelte-h":!0}),p(Oe)!=="svelte-162p62u"&&(Oe.innerHTML=zn),Ql=a(e),et=o(e,"P",{"data-svelte-h":!0}),p(et)!=="svelte-1hbg2e4"&&(et.textContent=Fn),Hl=a(e),u(tt.$$.fragment,e),Yl=a(e),lt=o(e,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-i4top7"&&(lt.textContent=Ln),Xl=a(e),u(nt.$$.fragment,e),ql=a(e),st=o(e,"UL",{"data-svelte-h":!0}),p(st)!=="svelte-8oe7h4"&&(st.innerHTML=Dn),zl=a(e),u(at.$$.fragment,e),Fl=a(e),it=o(e,"UL",{"data-svelte-h":!0}),p(it)!=="svelte-1nt0hab"&&(it.innerHTML=Pn),Ll=a(e),ot=o(e,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-l1ns7z"&&(ot.textContent=Kn),Dl=a(e),u(pt.$$.fragment,e),Pl=a(e),ut=o(e,"P",{}),as(ut).forEach(l),this.h()},h(){ct(M,"name","hf:doc:metadata"),ct(M,"content",bs),ss(Mt.src,sn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png")||ct(Mt,"src",sn),ss(rt.src,Jn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/code_execution_safety_diagram.png")||ct(rt,"src",Jn),ct(v,"align","center")},m(e,t){us(document.head,M),n(e,b,t),n(e,w,t),n(e,h,t),c(g,e,t),n(e,C,t),c(U,e,t),n(e,Z,t),c(T,e,t),n(e,f,t),c(W,e,t),n(e,Jt,t),n(e,G,t),n(e,wt,t),n(e,A,t),n(e,mt,t),n(e,V,t),n(e,Tt,t),n(e,E,t),n(e,ht,t),n(e,R,t),n(e,bt,t),n(e,Mt,t),n(e,Ut,t),n(e,N,t),n(e,It,t),c(_,e,t),n(e,jt,t),n(e,S,t),n(e,gt,t),n(e,Q,t),n(e,ft,t),n(e,H,t),n(e,Ct,t),n(e,Y,t),n(e,xt,t),n(e,X,t),n(e,Bt,t),n(e,q,t),n(e,vt,t),n(e,z,t),n(e,$t,t),n(e,F,t),n(e,kt,t),n(e,rt,t),n(e,Zt,t),c(L,e,t),n(e,Wt,t),n(e,D,t),n(e,Gt,t),n(e,P,t),n(e,At,t),n(e,K,t),n(e,Vt,t),n(e,O,t),n(e,Et,t),c(ee,e,t),n(e,Rt,t),n(e,te,t),n(e,Nt,t),c(x,e,t),n(e,_t,t),n(e,le,t),n(e,St,t),c(ne,e,t),n(e,Qt,t),n(e,se,t),n(e,Ht,t),n(e,ae,t),n(e,Yt,t),n(e,ie,t),n(e,Xt,t),n(e,oe,t),n(e,qt,t),c(pe,e,t),n(e,zt,t),c(Me,e,t),n(e,Ft,t),n(e,re,t),n(e,Lt,t),c(ue,e,t),n(e,Dt,t),c(ce,e,t),n(e,Pt,t),n(e,ye,t),n(e,Kt,t),c(de,e,t),n(e,Ot,t),c(B,e,t),n(e,el,t),n(e,Je,t),n(e,tl,t),n(e,we,t),n(e,ll,t),n(e,v,t),n(e,nl,t),n(e,me,t),n(e,sl,t),c(Te,e,t),n(e,al,t),n(e,he,t),n(e,il,t),n(e,be,t),n(e,ol,t),c(Ue,e,t),n(e,pl,t),c(Ie,e,t),n(e,Ml,t),c(je,e,t),n(e,rl,t),n(e,ge,t),n(e,ul,t),c(fe,e,t),n(e,cl,t),c(Ce,e,t),n(e,yl,t),n(e,xe,t),n(e,dl,t),c(Be,e,t),n(e,Jl,t),c($,e,t),n(e,wl,t),n(e,ve,t),n(e,ml,t),c($e,e,t),n(e,Tl,t),c(ke,e,t),n(e,hl,t),n(e,Ze,t),n(e,bl,t),c(We,e,t),n(e,Ul,t),c(Ge,e,t),n(e,Il,t),n(e,Ae,t),n(e,jl,t),c(Ve,e,t),n(e,gl,t),c(k,e,t),n(e,fl,t),c(Ee,e,t),n(e,Cl,t),n(e,Re,t),n(e,xl,t),n(e,Ne,t),n(e,Bl,t),c(_e,e,t),n(e,vl,t),n(e,Se,t),n(e,$l,t),c(Qe,e,t),n(e,kl,t),c(He,e,t),n(e,Zl,t),n(e,Ye,t),n(e,Wl,t),n(e,Xe,t),n(e,Gl,t),c(qe,e,t),n(e,Al,t),n(e,ze,t),n(e,Vl,t),c(Fe,e,t),n(e,El,t),n(e,Le,t),n(e,Rl,t),c(De,e,t),n(e,Nl,t),c(Pe,e,t),n(e,_l,t),n(e,Ke,t),n(e,Sl,t),n(e,Oe,t),n(e,Ql,t),n(e,et,t),n(e,Hl,t),c(tt,e,t),n(e,Yl,t),n(e,lt,t),n(e,Xl,t),c(nt,e,t),n(e,ql,t),n(e,st,t),n(e,zl,t),c(at,e,t),n(e,Fl,t),n(e,it,t),n(e,Ll,t),n(e,ot,t),n(e,Dl,t),c(pt,e,t),n(e,Pl,t),n(e,ut,t),Kl=!0},p(e,[t]){const On={};t&2&&(On.$$scope={dirty:t,ctx:e}),T.$set(On);const es={};t&2&&(es.$$scope={dirty:t,ctx:e}),x.$set(es);const ts={};t&2&&(ts.$$scope={dirty:t,ctx:e}),B.$set(ts);const ls={};t&2&&(ls.$$scope={dirty:t,ctx:e}),$.$set(ls);const ns={};t&2&&(ns.$$scope={dirty:t,ctx:e}),k.$set(ns)},i(e){Kl||(y(g.$$.fragment,e),y(U.$$.fragment,e),y(T.$$.fragment,e),y(W.$$.fragment,e),y(_.$$.fragment,e),y(L.$$.fragment,e),y(ee.$$.fragment,e),y(x.$$.fragment,e),y(ne.$$.fragment,e),y(pe.$$.fragment,e),y(Me.$$.fragment,e),y(ue.$$.fragment,e),y(ce.$$.fragment,e),y(de.$$.fragment,e),y(B.$$.fragment,e),y(Te.$$.fragment,e),y(Ue.$$.fragment,e),y(Ie.$$.fragment,e),y(je.$$.fragment,e),y(fe.$$.fragment,e),y(Ce.$$.fragment,e),y(Be.$$.fragment,e),y($.$$.fragment,e),y($e.$$.fragment,e),y(ke.$$.fragment,e),y(We.$$.fragment,e),y(Ge.$$.fragment,e),y(Ve.$$.fragment,e),y(k.$$.fragment,e),y(Ee.$$.fragment,e),y(_e.$$.fragment,e),y(Qe.$$.fragment,e),y(He.$$.fragment,e),y(qe.$$.fragment,e),y(Fe.$$.fragment,e),y(De.$$.fragment,e),y(Pe.$$.fragment,e),y(tt.$$.fragment,e),y(nt.$$.fragment,e),y(at.$$.fragment,e),y(pt.$$.fragment,e),Kl=!0)},o(e){d(g.$$.fragment,e),d(U.$$.fragment,e),d(T.$$.fragment,e),d(W.$$.fragment,e),d(_.$$.fragment,e),d(L.$$.fragment,e),d(ee.$$.fragment,e),d(x.$$.fragment,e),d(ne.$$.fragment,e),d(pe.$$.fragment,e),d(Me.$$.fragment,e),d(ue.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(B.$$.fragment,e),d(Te.$$.fragment,e),d(Ue.$$.fragment,e),d(Ie.$$.fragment,e),d(je.$$.fragment,e),d(fe.$$.fragment,e),d(Ce.$$.fragment,e),d(Be.$$.fragment,e),d($.$$.fragment,e),d($e.$$.fragment,e),d(ke.$$.fragment,e),d(We.$$.fragment,e),d(Ge.$$.fragment,e),d(Ve.$$.fragment,e),d(k.$$.fragment,e),d(Ee.$$.fragment,e),d(_e.$$.fragment,e),d(Qe.$$.fragment,e),d(He.$$.fragment,e),d(qe.$$.fragment,e),d(Fe.$$.fragment,e),d(De.$$.fragment,e),d(Pe.$$.fragment,e),d(tt.$$.fragment,e),d(nt.$$.fragment,e),d(at.$$.fragment,e),d(pt.$$.fragment,e),Kl=!1},d(e){e&&(l(b),l(w),l(h),l(C),l(Z),l(f),l(Jt),l(G),l(wt),l(A),l(mt),l(V),l(Tt),l(E),l(ht),l(R),l(bt),l(Mt),l(Ut),l(N),l(It),l(jt),l(S),l(gt),l(Q),l(ft),l(H),l(Ct),l(Y),l(xt),l(X),l(Bt),l(q),l(vt),l(z),l($t),l(F),l(kt),l(rt),l(Zt),l(Wt),l(D),l(Gt),l(P),l(At),l(K),l(Vt),l(O),l(Et),l(Rt),l(te),l(Nt),l(_t),l(le),l(St),l(Qt),l(se),l(Ht),l(ae),l(Yt),l(ie),l(Xt),l(oe),l(qt),l(zt),l(Ft),l(re),l(Lt),l(Dt),l(Pt),l(ye),l(Kt),l(Ot),l(el),l(Je),l(tl),l(we),l(ll),l(v),l(nl),l(me),l(sl),l(al),l(he),l(il),l(be),l(ol),l(pl),l(Ml),l(rl),l(ge),l(ul),l(cl),l(yl),l(xe),l(dl),l(Jl),l(wl),l(ve),l(ml),l(Tl),l(hl),l(Ze),l(bl),l(Ul),l(Il),l(Ae),l(jl),l(gl),l(fl),l(Cl),l(Re),l(xl),l(Ne),l(Bl),l(vl),l(Se),l($l),l(kl),l(Zl),l(Ye),l(Wl),l(Xe),l(Gl),l(Al),l(ze),l(Vl),l(El),l(Le),l(Rl),l(Nl),l(_l),l(Ke),l(Sl),l(Oe),l(Ql),l(et),l(Hl),l(Yl),l(lt),l(Xl),l(ql),l(st),l(zl),l(Fl),l(it),l(Ll),l(ot),l(Dl),l(Pl),l(ut)),l(M),J(g,e),J(U,e),J(T,e),J(W,e),J(_,e),J(L,e),J(ee,e),J(x,e),J(ne,e),J(pe,e),J(Me,e),J(ue,e),J(ce,e),J(de,e),J(B,e),J(Te,e),J(Ue,e),J(Ie,e),J(je,e),J(fe,e),J(Ce,e),J(Be,e),J($,e),J($e,e),J(ke,e),J(We,e),J(Ge,e),J(Ve,e),J(k,e),J(Ee,e),J(_e,e),J(Qe,e),J(He,e),J(qe,e),J(Fe,e),J(De,e),J(Pe,e),J(tt,e),J(nt,e),J(at,e),J(pt,e)}}}const bs='{"title":"Secure code execution","local":"secure-code-execution","sections":[{"title":"Code agents","local":"code-agents","sections":[],"depth":3},{"title":"Local code execution??","local":"local-code-execution","sections":[],"depth":3},{"title":"Our local Python executor","local":"our-local-python-executor","sections":[],"depth":3},{"title":"Sandbox approaches for secure code execution","local":"sandbox-approaches-for-secure-code-execution","sections":[{"title":"E2B setup","local":"e2b-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in E2B: quick start","local":"running-your-agent-in-e2b-quick-start","sections":[],"depth":4},{"title":"Running your agent in E2B: multi-agents","local":"running-your-agent-in-e2b-multi-agents","sections":[],"depth":4}],"depth":3},{"title":"Modal setup","local":"modal-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in Modal: quick start","local":"running-your-agent-in-modal-quick-start","sections":[],"depth":4}],"depth":3},{"title":"Docker setup","local":"docker-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in Docker: quick start","local":"running-your-agent-in-docker-quick-start","sections":[],"depth":4},{"title":"Advanced docker usage","local":"advanced-docker-usage","sections":[],"depth":4}],"depth":3},{"title":"WebAssembly setup","local":"webassembly-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in WebAssembly: quick start","local":"running-your-agent-in-webassembly-quick-start","sections":[],"depth":4}],"depth":3},{"title":"Best practices for sandboxes","local":"best-practices-for-sandboxes","sections":[],"depth":3}],"depth":2},{"title":"Comparing security approaches","local":"comparing-security-approaches","sections":[{"title":"Approach 1: Running just the code snippets in a sandbox","local":"approach-1-running-just-the-code-snippets-in-a-sandbox","sections":[],"depth":3},{"title":"Approach 2: Running the entire agentic system in a sandbox","local":"approach-2-running-the-entire-agentic-system-in-a-sandbox","sections":[],"depth":3}],"depth":2}],"depth":1}';function Us(I){return os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bs extends ps{constructor(M){super(),Ms(this,M,Us,hs,is,{})}}export{Bs as component};
