import{s as Ys,f as Fs,o as zs,n as Xl}from"../chunks/scheduler.f6319a2a.js";import{S as Ps,i as Ls,g as a,s as n,r as M,A as Ds,h as i,f as l,c as o,j as qs,u,x as r,k as Nl,y as Ks,a as s,v as c,d,t as m,w as y}from"../chunks/index.85aa684c.js";import{T as El}from"../chunks/Tip.3d397a88.js";import{C as T}from"../chunks/CodeBlock.3400fc53.js";import{D as Os}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as f,E as en}from"../chunks/getInferenceSnippets.55a93fbe.js";function tn(g){let p,J='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){p=a("p"),p.innerHTML=J},l(h){p=i(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1p1d9vw"&&(p.innerHTML=J)},m(h,b){s(h,p,b)},p:Xl,d(h){h&&l(p)}}}function ln(g){let p,J=`<strong>Security Warning:</strong> Always verify the source and integrity of any MCP server before connecting to it, especially for production environments.
Using MCP servers comes with security risks:`,h,b,U="<li><strong>Trust is essential:</strong> Only use MCP servers from trusted sources. Malicious servers can execute harmful code on your machine.</li> <li><strong>Stdio-based MCP servers</strong> will always execute code on your machine (that’s their intended functionality).</li> <li><strong>Streamable HTTP-based MCP servers:</strong> While remote MCP servers will not execute code on your machine, still proceed with caution.</li>";return{c(){p=a("p"),p.innerHTML=J,h=n(),b=a("ul"),b.innerHTML=U},l(w){p=i(w,"P",{"data-svelte-h":!0}),r(p)!=="svelte-t3a0vm"&&(p.innerHTML=J),h=o(w),b=i(w,"UL",{"data-svelte-h":!0}),r(b)!=="svelte-gohv2x"&&(b.innerHTML=U)},m(w,j){s(w,p,j),s(w,h,j),s(w,b,j)},p:Xl,d(w){w&&(l(p),l(h),l(b))}}}function sn(g){let p,J="Beware of not adding too many tools to an agent: this can overwhelm weaker LLM engines.";return{c(){p=a("p"),p.textContent=J},l(h){p=i(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-h9mzfm"&&(p.textContent=J)},m(h,b){s(h,p,b)},p:Xl,d(h){h&&l(p)}}}function nn(g){let p,J=`<strong>Security Warning:</strong> Always verify the source and integrity of any MCP server before connecting to it, especially for production environments.
Using MCP servers comes with security risks:`,h,b,U="<li><strong>Trust is essential:</strong> Only use MCP servers from trusted sources. Malicious servers can execute harmful code on your machine.</li> <li><strong>Stdio-based MCP servers</strong> will always execute code on your machine (that’s their intended functionality).</li> <li><strong>Streamable HTTP-based MCP servers:</strong> While remote MCP servers will not execute code on your machine, still proceed with caution.</li>";return{c(){p=a("p"),p.innerHTML=J,h=n(),b=a("ul"),b.innerHTML=U},l(w){p=i(w,"P",{"data-svelte-h":!0}),r(p)!=="svelte-t3a0vm"&&(p.innerHTML=J),h=o(w),b=i(w,"UL",{"data-svelte-h":!0}),r(b)!=="svelte-gohv2x"&&(b.innerHTML=U)},m(w,j){s(w,p,j),s(w,h,j),s(w,b,j)},p:Xl,d(w){w&&(l(p),l(h),l(b))}}}function on(g){let p,J,h,b,U,w,j,ot,B,Sl="Here, we’re going to see advanced tool usage.",at,C,it,W,rt,G,Al="A tool is mostly a function that an LLM can use in an agentic system.",pt,$,Fl="But to use it, the LLM will need to be given an API: name, tool description, input types and descriptions, output type.",Mt,k,ql="So it cannot be only a function. It should be a class.",ut,Q,Yl="So at core, the tool is a class that wraps a function with metadata that helps the LLM understand how to use it.",ct,H,zl="Here’s how it looks:",dt,_,mt,R,Pl='The custom tool subclasses <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool">Tool</a> to inherit useful methods. The child class also defines:',yt,V,Ll='<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type. The types for both <code>inputs</code> and <code>output_type</code> should be <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>, they can be either of these: <code>~AUTHORIZED_TYPES()</code>.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>',ht,x,Dl="And that’s all it needs to be used in an agent!",bt,N,Kl='There’s another way to build a tool. In the <a href="../guided_tour">guided_tour</a>, we implemented a tool using the <code>@tool</code> decorator. The <a href="/docs/smolagents/main/en/reference/tools#smolagents.tool">tool()</a> decorator is the recommended way to define simple tools, but sometimes you need more than this: using several methods in a class for more clarity, or using additional class attributes.',wt,E,Ol='In this case, you can build your tool by subclassing <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool">Tool</a> as described above.',Tt,X,Jt,S,es='You can share your custom tool to the Hub as a Space repository by calling <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',jt,A,Ut,F,ts="For the push to Hub to work, your tool will need to respect some rules:",ft,q,ls='<li>All methods are self-contained, e.g. use variables that come either from their args.</li> <li>As per the above point, <strong>all imports should be defined directly within the tool’s functions</strong>, else you will get an error when trying to call <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.save">save()</a> or <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> with your custom tool.</li> <li>If you subclass the <code>__init__</code> method, you can give it no other argument than <code>self</code>. This is because arguments set during a specific tool instance’s initialization are hard to track, which prevents from sharing them properly to the hub. And anyway, the idea of making a specific class is that you can already set class attributes for anything you need to hard-code (just set <code>your_variable=(...)</code> directly under the <code>class YourTool(Tool):</code> line). And of course you can still create a class attribute anywhere in your code by assigning stuff to <code>self.your_variable</code>.</li>',gt,Y,ss='Once your tool is pushed to Hub, you can visualize it. <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">Here</a> is the <code>model_downloads_tool</code> that I’ve pushed. It has a nice gradio interface.',Ct,z,ns='When diving into the tool files, you can find that all the tool’s logic is under <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a>. That is where you can inspect a tool shared by someone else.',vt,P,os=`Then you can load the tool with <a href="/docs/smolagents/main/en/reference/tools#smolagents.load_tool">load_tool()</a> or create it with <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.from_hub">from_hub()</a> and pass it to the <code>tools</code> parameter in your agent.
Since running tools means running custom code, you need to make sure you trust the repository, thus we require to pass <code>trust_remote_code=True</code> to load a tool from the Hub.`,It,L,Zt,D,Bt,K,as="Our <code>MCPClient</code> allows you to load tools from an MCP server, and gives you full control over the connection and tool management:",Wt,O,is="For stdio-based MCP servers:",Gt,ee,$t,te,rs="For Streamable HTTP-based MCP servers:",kt,le,Qt,se,ps="You can also manually manage the connection lifecycle with the try…finally pattern:",Ht,ne,_t,oe,Ms="You can also connect to multiple MCP servers at once by passing a list of server parameters:",Rt,ae,Vt,v,xt,ie,Nt,re,us='The latest <a href="https://modelcontextprotocol.io/specification/2025-06-18/server/tools#structured-content" rel="nofollow">MCP specifications (2025-06-18+)</a> include support for <code>outputSchema</code>, which enables tools to return structured data with defined schemas. <code>smolagents</code> takes advantage of these structured output capabilities, allowing agents to work with tools that return complex data structures, JSON objects, and other structured formats. With this feature, the agent’s LLMs can “see” the structure of the tool output before calling a tool, enabling more intelligent and context-aware interactions.',Et,pe,cs="To enable structured output support, pass <code>structured_output=True</code> when initializing the <code>MCPClient</code>:",Xt,Me,St,ue,ds="When <code>structured_output=True</code>, the following features are enabled:",At,ce,ms="<li><strong>Output Schema Support</strong>: Tools can define JSON schemas for their outputs</li> <li><strong>Structured Content Handling</strong>: Support for <code>structuredContent</code> in MCP responses</li> <li><strong>JSON Parsing</strong>: Automatic parsing of structured data from tool responses</li>",Ft,de,ys="Here’s an example using a weather MCP server with structured output:",qt,me,Yt,ye,hs="Agent using output schema and structured output:",zt,he,Pt,be,bs="When structured output is enabled, the <code>CodeAgent</code> system prompt is enhanced to include JSON schema information for tools, helping the agent understand the expected structure of tool outputs and access the data appropriately.",Lt,we,ws="<strong>Backwards Compatibility</strong>: The <code>structured_output</code> parameter currently defaults to <code>False</code> to maintain backwards compatibility. Existing code will continue to work without changes, receiving simple text outputs as before.",Dt,Te,Ts="<strong>Future Change</strong>: In a future release, the default value of <code>structured_output</code> will change from <code>False</code> to <code>True</code>. It is recommended to explicitly set <code>structured_output=True</code> to opt into the enhanced functionality, which provides better tool output handling and improved agent performance. Use <code>structured_output=False</code> only if you specifically need to maintain the current text-only behavior.",Kt,Je,Ot,je,Js='You can directly import a Gradio Space from the Hub as a tool using the <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> method!',el,Ue,js='You only need to provide the id of the Space on the Hub, its name, and a description that will help your agent understand what the tool does. Under the hood, this will use <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> library to call the Space.',tl,fe,Us='For instance, let’s import the <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space from the Hub and use it to generate an image.',ll,ge,sl,Ce,fs="And voilà, here’s your image! 🏖️",nl,lt,gs,ol,ve,Cs="Then you can use this tool just like any other tool.  For example, let’s improve the prompt <code>a rabbit wearing a space suit</code> and generate an image of it. This example also shows how you can pass additional arguments to the agent.",al,Ie,il,Ze,rl,st,vs,pl,Be,Is="How cool is this? 🤩",Ml,We,ul,Ge,Zs=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,cl,$e,Bs=`Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.
This tool will need <code>pip install langchain google-search-results -q</code> to work properly.`,dl,ke,ml,Qe,yl,He,Ws="You can manage an agent’s toolbox by adding or replacing a tool in attribute <code>agent.tools</code>, since it is a standard dictionary.",hl,_e,Gs="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",bl,Re,wl,Ve,$s="Now we can leverage the new tool:",Tl,xe,Jl,I,jl,Ne,Ul,Ee,ks='You can leverage tool collections by using <a href="/docs/smolagents/main/en/reference/tools#smolagents.ToolCollection">ToolCollection</a>. It supports loading either a collection from the Hub or an MCP server tools.',fl,Xe,gl,Se,Qs='Leverage tools from the hundreds of MCP servers available on <a href="https://glama.ai/mcp/servers" rel="nofollow">glama.ai</a> or <a href="https://smithery.ai/" rel="nofollow">smithery.ai</a>.',Cl,Ae,Hs='The MCP servers tools can be loaded with <a href="/docs/smolagents/main/en/reference/tools#smolagents.ToolCollection.from_mcp">ToolCollection.from_mcp()</a>.',vl,Z,Il,Fe,_s="For stdio-based MCP servers, pass the server parameters as an instance of <code>mcp.StdioServerParameters</code>:",Zl,qe,Bl,Ye,Rs="To enable structured output support with ToolCollection, add the <code>structured_output=True</code> parameter:",Wl,ze,Gl,Pe,Vs="For Streamable HTTP-based MCP servers, simply pass a dict with parameters to <code>mcp.client.streamable_http.streamablehttp_client</code> and add the key <code>transport</code> with the value <code>&quot;streamable-http&quot;</code>:",$l,Le,kl,De,Ql,Ke,xs=`You can leverage it with the slug of the collection you want to use.
Then pass them as a list to initialize your agent, and start using them!`,Hl,Oe,_l,et,Ns="To speed up the start, tools are loaded only if called by the agent.",Rl,tt,Vl,nt,xl;return U=new f({props:{title:"Tools",local:"tools",headingTag:"h1"}}),j=new Os({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"}]}}),C=new El({props:{warning:!1,$$slots:{default:[tn]},$$scope:{ctx:g}}}),W=new f({props:{title:"What is a tool, and how to build one?",local:"what-is-a-tool-and-how-to-build-one",headingTag:"h3"}}),_=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),X=new f({props:{title:"Share your tool to the Hub",local:"share-your-tool-to-the-hub",headingTag:"h3"}}),A=new T({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),L=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),D=new f({props:{title:"Use tools from an MCP server",local:"use-tools-from-an-mcp-server",headingTag:"h3"}}),ee=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTIwJTIwJTIzJTIwVXNpbmclMjB1dnglMjBlbnN1cmVzJTIwZGVwZW5kZW5jaWVzJTIwYXJlJTIwYXZhaWxhYmxlJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyME1DUENsaWVudChzZXJ2ZXJfcGFyYW1ldGVycyklMjBhcyUyMHRvb2xzJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0R0b29scyUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGZpbmQlMjB0aGUlMjBsYXRlc3QlMjByZXNlYXJjaCUyMG9uJTIwQ09WSUQtMTklMjB0cmVhdG1lbnQuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,  <span class="hljs-comment"># Using uvx ensures dependencies are available</span>
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> MCPClient(server_parameters) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find the latest research on COVID-19 treatment.&quot;</span>)`,wrap:!1}}),le=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEElMEF3aXRoJTIwTUNQQ2xpZW50KCU3QiUyMnVybCUyMiUzQSUyMCUyMmh0dHAlM0ElMkYlMkYxMjcuMC4wLjElM0E4MDAwJTJGbWNwJTIyJTJDJTIwJTIydHJhbnNwb3J0JTIyJTNBJTIwJTIyc3RyZWFtYWJsZS1odHRwJTIyJTdEKSUyMGFzJTIwdG9vbHMlM0ElMEElMjAlMjAlMjAlMjBhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRHRvb2xzJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent

<span class="hljs-keyword">with</span> MCPClient({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/mcp&quot;</span>, <span class="hljs-string">&quot;transport&quot;</span>: <span class="hljs-string">&quot;streamable-http&quot;</span>}) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),ne=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEElMjMlMjBJbml0aWFsaXplJTIwc2VydmVyJTIwcGFyYW1ldGVycyUwQXNlcnZlcl9wYXJhbWV0ZXJzJTIwJTNEJTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzKCUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlMjJ1dnglMjIlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEJTVCJTIyLS1xdWlldCUyMiUyQyUyMCUyMnB1Ym1lZG1jcCU0MDAuMS4zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZW52JTNEJTdCJTIyVVZfUFlUSE9OJTIyJTNBJTIwJTIyMy4xMiUyMiUyQyUyMCoqb3MuZW52aXJvbiU3RCUyQyUwQSklMEElMEElMjMlMjBNYW51YWxseSUyMG1hbmFnZSUyMHRoZSUyMGNvbm5lY3Rpb24lMEF0cnklM0ElMEElMjAlMjAlMjAlMjBtY3BfY2xpZW50JTIwJTNEJTIwTUNQQ2xpZW50KHNlcnZlcl9wYXJhbWV0ZXJzKSUwQSUyMCUyMCUyMCUyMHRvb2xzJTIwJTNEJTIwbWNwX2NsaWVudC5nZXRfdG9vbHMoKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHRoZSUyMHRvb2xzJTIwd2l0aCUyMHlvdXIlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEdG9vbHMlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMGFnZW50LnJ1biglMjJXaGF0JTIwYXJlJTIwdGhlJTIwcmVjZW50JTIwdGhlcmFwZXV0aWMlMjBhcHByb2FjaGVzJTIwZm9yJTIwQWx6aGVpbWVyJ3MlMjBkaXNlYXNlJTNGJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjB0aGUlMjByZXN1bHQlMjBhcyUyMG5lZWRlZCUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJBZ2VudCUyMHJlc3BvbnNlJTNBJTIwJTdCcmVzdWx0JTdEJTIyKSUwQWZpbmFsbHklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBbHdheXMlMjBlbnN1cmUlMjB0aGUlMjBjb25uZWN0aW9uJTIwaXMlMjBwcm9wZXJseSUyMGNsb3NlZCUwQSUyMCUyMCUyMCUyMG1jcF9jbGllbnQuZGlzY29ubmVjdCgp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Initialize server parameters</span>
server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-comment"># Manually manage the connection</span>
<span class="hljs-keyword">try</span>:
    mcp_client = MCPClient(server_parameters)
    tools = mcp_client.get_tools()

    <span class="hljs-comment"># Use the tools with your agent</span>
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    result = agent.run(<span class="hljs-string">&quot;What are the recent therapeutic approaches for Alzheimer&#x27;s disease?&quot;</span>)

    <span class="hljs-comment"># Process the result as needed</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Agent response: <span class="hljs-subst">{result}</span>&quot;</span>)
<span class="hljs-keyword">finally</span>:
    <span class="hljs-comment"># Always ensure the connection is properly closed</span>
    mcp_client.disconnect()`,wrap:!1}}),ae=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEFzZXJ2ZXJfcGFyYW1zMSUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBc2VydmVyX3BhcmFtczIlMjAlM0QlMjAlN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNzZSUyMiU3RCUwQSUwQXdpdGglMjBNQ1BDbGllbnQoJTVCc2VydmVyX3BhcmFtczElMkMlMjBzZXJ2ZXJfcGFyYW1zMiU1RCklMjBhcyUyMHRvb2xzJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0R0b29scyUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGFuYWx5emUlMjB0aGUlMjBsYXRlc3QlMjByZXNlYXJjaCUyMGFuZCUyMHN1Z2dlc3QlMjByZW1lZGllcyUyMGZvciUyMGhlYWRhY2hlcy4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

server_params1 = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

server_params2 = {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/sse&quot;</span>}

<span class="hljs-keyword">with</span> MCPClient([server_params1, server_params2]) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please analyze the latest research and suggest remedies for headaches.&quot;</span>)`,wrap:!1}}),v=new El({props:{warning:!0,$$slots:{default:[ln]},$$scope:{ctx:g}}}),ie=new f({props:{title:"Structured Output and Output Schema Support",local:"structured-output-and-output-schema-support",headingTag:"h4"}}),Me=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEElMEElMjMlMjBFbmFibGUlMjBzdHJ1Y3R1cmVkJTIwb3V0cHV0JTIwc3VwcG9ydCUwQXdpdGglMjBNQ1BDbGllbnQoc2VydmVyX3BhcmFtZXRlcnMlMkMlMjBzdHJ1Y3R1cmVkX291dHB1dCUzRFRydWUpJTIwYXMlMjB0b29scyUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEdG9vbHMlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMGFnZW50LnJ1biglMjJHZXQlMjB3ZWF0aGVyJTIwaW5mb3JtYXRpb24lMjBmb3IlMjBQYXJpcyUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent

<span class="hljs-comment"># Enable structured output support</span>
<span class="hljs-keyword">with</span> MCPClient(server_parameters, structured_output=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Get weather information for Paris&quot;</span>)`,wrap:!1}}),me=new T({props:{code:"JTIzJTIwZGVtbyUyRndlYXRoZXIucHklMjAtJTIwRXhhbXBsZSUyME1DUCUyMHNlcnZlciUyMHdpdGglMjBzdHJ1Y3R1cmVkJTIwb3V0cHV0JTBBZnJvbSUyMHB5ZGFudGljJTIwaW1wb3J0JTIwQmFzZU1vZGVsJTJDJTIwRmllbGQlMEFmcm9tJTIwbWNwLnNlcnZlci5mYXN0bWNwJTIwaW1wb3J0JTIwRmFzdE1DUCUwQSUwQW1jcCUyMCUzRCUyMEZhc3RNQ1AoJTIyV2VhdGhlciUyMFNlcnZpY2UlMjIpJTBBJTBBY2xhc3MlMjBXZWF0aGVySW5mbyhCYXNlTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0ElMjBzdHIlMjAlM0QlMjBGaWVsZChkZXNjcmlwdGlvbiUzRCUyMlRoZSUyMGxvY2F0aW9uJTIwbmFtZSUyMiklMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzQSUyMGZsb2F0JTIwJTNEJTIwRmllbGQoZGVzY3JpcHRpb24lM0QlMjJUZW1wZXJhdHVyZSUyMGluJTIwQ2Vsc2l1cyUyMiklMEElMjAlMjAlMjAlMjBjb25kaXRpb25zJTNBJTIwc3RyJTIwJTNEJTIwRmllbGQoZGVzY3JpcHRpb24lM0QlMjJXZWF0aGVyJTIwY29uZGl0aW9ucyUyMiklMEElMjAlMjAlMjAlMjBodW1pZGl0eSUzQSUyMGludCUyMCUzRCUyMEZpZWxkKGRlc2NyaXB0aW9uJTNEJTIySHVtaWRpdHklMjBwZXJjZW50YWdlJTIyJTJDJTIwZ2UlM0QwJTJDJTIwbGUlM0QxMDApJTBBJTBBJTQwbWNwLnRvb2woJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMmdldF93ZWF0aGVyX2luZm8lMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMkdldCUyMHdlYXRoZXIlMjBpbmZvcm1hdGlvbiUyMGZvciUyMGElMjBsb2NhdGlvbiUyMGFzJTIwc3RydWN0dXJlZCUyMGRhdGEuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwc3RydWN0dXJlZF9vdXRwdXQlM0RUcnVlJTIwaXMlMjBlbmFibGVkJTIwYnklMjBkZWZhdWx0JTIwaW4lMjBGYXN0TUNQJTBBKSUwQWRlZiUyMGdldF93ZWF0aGVyX2luZm8oY2l0eSUzQSUyMHN0ciklMjAtJTNFJTIwV2VhdGhlckluZm8lM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJHZXQlMjB3ZWF0aGVyJTIwaW5mb3JtYXRpb24lMjBmb3IlMjBhJTIwY2l0eS4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBXZWF0aGVySW5mbyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2NhdGlvbiUzRGNpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDIyLjUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25kaXRpb25zJTNEJTIycGFydGx5JTIwY2xvdWR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaHVtaWRpdHklM0Q2NSUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-comment"># demo/weather.py - Example MCP server with structured output</span>
<span class="hljs-keyword">from</span> pydantic <span class="hljs-keyword">import</span> BaseModel, Field
<span class="hljs-keyword">from</span> mcp.server.fastmcp <span class="hljs-keyword">import</span> FastMCP

mcp = FastMCP(<span class="hljs-string">&quot;Weather Service&quot;</span>)

<span class="hljs-keyword">class</span> <span class="hljs-title class_">WeatherInfo</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
    location: <span class="hljs-built_in">str</span> = Field(description=<span class="hljs-string">&quot;The location name&quot;</span>)
    temperature: <span class="hljs-built_in">float</span> = Field(description=<span class="hljs-string">&quot;Temperature in Celsius&quot;</span>)
    conditions: <span class="hljs-built_in">str</span> = Field(description=<span class="hljs-string">&quot;Weather conditions&quot;</span>)
    humidity: <span class="hljs-built_in">int</span> = Field(description=<span class="hljs-string">&quot;Humidity percentage&quot;</span>, ge=<span class="hljs-number">0</span>, le=<span class="hljs-number">100</span>)

<span class="hljs-meta">@mcp.tool(<span class="hljs-params">
    name=<span class="hljs-string">&quot;get_weather_info&quot;</span>,
    description=<span class="hljs-string">&quot;Get weather information for a location as structured data.&quot;</span>,
    <span class="hljs-comment"># structured_output=True is enabled by default in FastMCP</span>
</span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_info</span>(<span class="hljs-params">city: <span class="hljs-built_in">str</span></span>) -&gt; WeatherInfo:
    <span class="hljs-string">&quot;&quot;&quot;Get weather information for a city.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> WeatherInfo(
        location=city,
        temperature=<span class="hljs-number">22.5</span>,
        conditions=<span class="hljs-string">&quot;partly cloudy&quot;</span>,
        humidity=<span class="hljs-number">65</span>
    )`,wrap:!1}}),he=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEElMEElMjMlMjBVc2luZyUyMHRoZSUyMHdlYXRoZXIlMjBzZXJ2ZXIlMjB3aXRoJTIwc3RydWN0dXJlZCUyMG91dHB1dCUwQWZyb20lMjBtY3AlMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIycHl0aG9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMmRlbW8lMkZ3ZWF0aGVyLnB5JTIyJTVEJTBBKSUwQSUwQXdpdGglMjBNQ1BDbGllbnQoc2VydmVyX3BhcmFtZXRlcnMlMkMlMjBzdHJ1Y3R1cmVkX291dHB1dCUzRFRydWUpJTIwYXMlMjB0b29scyUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEdG9vbHMlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMGFnZW50LnJ1biglMjJXaGF0JTIwaXMlMjB0aGUlMjB0ZW1wZXJhdHVyZSUyMGluJTIwVG9reW8lMjBpbiUyMEZhaHJlbmhlaXQlM0YlMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQocmVzdWx0KQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent

<span class="hljs-comment"># Using the weather server with structured output</span>
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;python&quot;</span>,
    args=[<span class="hljs-string">&quot;demo/weather.py&quot;</span>]
)

<span class="hljs-keyword">with</span> MCPClient(server_parameters, structured_output=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model)
    result = agent.run(<span class="hljs-string">&quot;What is the temperature in Tokyo in Fahrenheit?&quot;</span>)
    <span class="hljs-built_in">print</span>(result)`,wrap:!1}}),Je=new f({props:{title:"Import a Space as a tool",local:"import-a-space-as-a-tool",headingTag:"h3"}}),ge=new T({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),Ie=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJJbXByb3ZlJTIwdGhpcyUyMHByb21wdCUyQyUyMHRoZW4lMjBnZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBvZiUyMGl0LiUyMiUyQyUyMGFkZGl0aW9uYWxfYXJncyUzRCU3Qid1c2VyX3Byb21wdCclM0ElMjAnQSUyMHJhYmJpdCUyMHdlYXJpbmclMjBhJTIwc3BhY2UlMjBzdWl0JyU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>}
)`,wrap:!1}}),Ze=new T({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),We=new f({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),ke=new T({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),Qe=new f({props:{title:"Manage your agent’s toolbox",local:"manage-your-agents-toolbox",headingTag:"h3"}}),Re=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQWFnZW50LnRvb2xzJTVCbW9kZWxfZG93bmxvYWRfdG9vbC5uYW1lJTVEJTIwJTNEJTIwbW9kZWxfZG93bmxvYWRfdG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.tools[model_download_tool.name] = model_download_tool`,wrap:!1}}),xe=new T({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),I=new El({props:{warning:!1,$$slots:{default:[sn]},$$scope:{ctx:g}}}),Ne=new f({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),Xe=new f({props:{title:"Tool Collection from any MCP server",local:"tool-collection-from-any-mcp-server",headingTag:"h4"}}),Z=new El({props:{warning:!0,$$slots:{default:[nn]},$$scope:{ctx:g}}}),qe=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBtY3AlMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),ze=new T({props:{code:"d2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlJTJDJTIwc3RydWN0dXJlZF9vdXRwdXQlM0RUcnVlKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>, structured_output=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),Le=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBUb29sQ29sbGVjdGlvbi5mcm9tX21jcCglN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRm1jcCUyMiUyQyUyMCUyMnRyYW5zcG9ydCUyMiUzQSUyMCUyMnN0cmVhbWFibGUtaHR0cCUyMiU3RCUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMjBhcyUyMHRvb2xfY29sbGVjdGlvbiUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCKnRvb2xfY29sbGVjdGlvbi50b29scyU1RCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

<span class="hljs-keyword">with</span> ToolCollection.from_mcp({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/mcp&quot;</span>, <span class="hljs-string">&quot;transport&quot;</span>: <span class="hljs-string">&quot;streamable-http&quot;</span>}, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),De=new f({props:{title:"Tool Collection from a collection in the Hub",local:"tool-collection-from-a-collection-in-the-hub",headingTag:"h4"}}),Oe=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uLmZyb21faHViKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection.from_hub(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),tt=new en({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/tools.md"}}),{c(){p=a("meta"),J=n(),h=a("p"),b=n(),M(U.$$.fragment),w=n(),M(j.$$.fragment),ot=n(),B=a("p"),B.textContent=Sl,at=n(),M(C.$$.fragment),it=n(),M(W.$$.fragment),rt=n(),G=a("p"),G.textContent=Al,pt=n(),$=a("p"),$.textContent=Fl,Mt=n(),k=a("p"),k.textContent=ql,ut=n(),Q=a("p"),Q.textContent=Yl,ct=n(),H=a("p"),H.textContent=zl,dt=n(),M(_.$$.fragment),mt=n(),R=a("p"),R.innerHTML=Pl,yt=n(),V=a("ul"),V.innerHTML=Ll,ht=n(),x=a("p"),x.textContent=Dl,bt=n(),N=a("p"),N.innerHTML=Kl,wt=n(),E=a("p"),E.innerHTML=Ol,Tt=n(),M(X.$$.fragment),Jt=n(),S=a("p"),S.innerHTML=es,jt=n(),M(A.$$.fragment),Ut=n(),F=a("p"),F.textContent=ts,ft=n(),q=a("ul"),q.innerHTML=ls,gt=n(),Y=a("p"),Y.innerHTML=ss,Ct=n(),z=a("p"),z.innerHTML=ns,vt=n(),P=a("p"),P.innerHTML=os,It=n(),M(L.$$.fragment),Zt=n(),M(D.$$.fragment),Bt=n(),K=a("p"),K.innerHTML=as,Wt=n(),O=a("p"),O.textContent=is,Gt=n(),M(ee.$$.fragment),$t=n(),te=a("p"),te.textContent=rs,kt=n(),M(le.$$.fragment),Qt=n(),se=a("p"),se.textContent=ps,Ht=n(),M(ne.$$.fragment),_t=n(),oe=a("p"),oe.textContent=Ms,Rt=n(),M(ae.$$.fragment),Vt=n(),M(v.$$.fragment),xt=n(),M(ie.$$.fragment),Nt=n(),re=a("p"),re.innerHTML=us,Et=n(),pe=a("p"),pe.innerHTML=cs,Xt=n(),M(Me.$$.fragment),St=n(),ue=a("p"),ue.innerHTML=ds,At=n(),ce=a("ul"),ce.innerHTML=ms,Ft=n(),de=a("p"),de.textContent=ys,qt=n(),M(me.$$.fragment),Yt=n(),ye=a("p"),ye.textContent=hs,zt=n(),M(he.$$.fragment),Pt=n(),be=a("p"),be.innerHTML=bs,Lt=n(),we=a("p"),we.innerHTML=ws,Dt=n(),Te=a("p"),Te.innerHTML=Ts,Kt=n(),M(Je.$$.fragment),Ot=n(),je=a("p"),je.innerHTML=Js,el=n(),Ue=a("p"),Ue.innerHTML=js,tl=n(),fe=a("p"),fe.innerHTML=Us,ll=n(),M(ge.$$.fragment),sl=n(),Ce=a("p"),Ce.textContent=fs,nl=n(),lt=a("img"),ol=n(),ve=a("p"),ve.innerHTML=Cs,al=n(),M(Ie.$$.fragment),il=n(),M(Ze.$$.fragment),rl=n(),st=a("img"),pl=n(),Be=a("p"),Be.textContent=Is,Ml=n(),M(We.$$.fragment),ul=n(),Ge=a("p"),Ge.innerHTML=Zs,cl=n(),$e=a("p"),$e.innerHTML=Bs,dl=n(),M(ke.$$.fragment),ml=n(),M(Qe.$$.fragment),yl=n(),He=a("p"),He.innerHTML=Ws,hl=n(),_e=a("p"),_e.innerHTML=Gs,bl=n(),M(Re.$$.fragment),wl=n(),Ve=a("p"),Ve.textContent=$s,Tl=n(),M(xe.$$.fragment),Jl=n(),M(I.$$.fragment),jl=n(),M(Ne.$$.fragment),Ul=n(),Ee=a("p"),Ee.innerHTML=ks,fl=n(),M(Xe.$$.fragment),gl=n(),Se=a("p"),Se.innerHTML=Qs,Cl=n(),Ae=a("p"),Ae.innerHTML=Hs,vl=n(),M(Z.$$.fragment),Il=n(),Fe=a("p"),Fe.innerHTML=_s,Zl=n(),M(qe.$$.fragment),Bl=n(),Ye=a("p"),Ye.innerHTML=Rs,Wl=n(),M(ze.$$.fragment),Gl=n(),Pe=a("p"),Pe.innerHTML=Vs,$l=n(),M(Le.$$.fragment),kl=n(),M(De.$$.fragment),Ql=n(),Ke=a("p"),Ke.textContent=xs,Hl=n(),M(Oe.$$.fragment),_l=n(),et=a("p"),et.textContent=Ns,Rl=n(),M(tt.$$.fragment),Vl=n(),nt=a("p"),this.h()},l(e){const t=Ds("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(l),J=o(e),h=i(e,"P",{}),qs(h).forEach(l),b=o(e),u(U.$$.fragment,e),w=o(e),u(j.$$.fragment,e),ot=o(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-8951oz"&&(B.textContent=Sl),at=o(e),u(C.$$.fragment,e),it=o(e),u(W.$$.fragment,e),rt=o(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-50z9h0"&&(G.textContent=Al),pt=o(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1llqfcr"&&($.textContent=Fl),Mt=o(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-eilpgu"&&(k.textContent=ql),ut=o(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-suz7fy"&&(Q.textContent=Yl),ct=o(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-x18ywb"&&(H.textContent=zl),dt=o(e),u(_.$$.fragment,e),mt=o(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-prn7f3"&&(R.innerHTML=Pl),yt=o(e),V=i(e,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-xqgwuf"&&(V.innerHTML=Ll),ht=o(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-220ayw"&&(x.textContent=Dl),bt=o(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-13idprj"&&(N.innerHTML=Kl),wt=o(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1lot62h"&&(E.innerHTML=Ol),Tt=o(e),u(X.$$.fragment,e),Jt=o(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-4kwync"&&(S.innerHTML=es),jt=o(e),u(A.$$.fragment,e),Ut=o(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-hoocvd"&&(F.textContent=ts),ft=o(e),q=i(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-cqj6gr"&&(q.innerHTML=ls),gt=o(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-4n5s3c"&&(Y.innerHTML=ss),Ct=o(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1knl8v8"&&(z.innerHTML=ns),vt=o(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1skw0cc"&&(P.innerHTML=os),It=o(e),u(L.$$.fragment,e),Zt=o(e),u(D.$$.fragment,e),Bt=o(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-eofyyc"&&(K.innerHTML=as),Wt=o(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1en3ihe"&&(O.textContent=is),Gt=o(e),u(ee.$$.fragment,e),$t=o(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1ro6hjz"&&(te.textContent=rs),kt=o(e),u(le.$$.fragment,e),Qt=o(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1and4a8"&&(se.textContent=ps),Ht=o(e),u(ne.$$.fragment,e),_t=o(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-7q6kbi"&&(oe.textContent=Ms),Rt=o(e),u(ae.$$.fragment,e),Vt=o(e),u(v.$$.fragment,e),xt=o(e),u(ie.$$.fragment,e),Nt=o(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1ku5522"&&(re.innerHTML=us),Et=o(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-10wjig9"&&(pe.innerHTML=cs),Xt=o(e),u(Me.$$.fragment,e),St=o(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-rntkgd"&&(ue.innerHTML=ds),At=o(e),ce=i(e,"UL",{"data-svelte-h":!0}),r(ce)!=="svelte-745dbc"&&(ce.innerHTML=ms),Ft=o(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1e0rvyj"&&(de.textContent=ys),qt=o(e),u(me.$$.fragment,e),Yt=o(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-xhsky2"&&(ye.textContent=hs),zt=o(e),u(he.$$.fragment,e),Pt=o(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1dbhry6"&&(be.innerHTML=bs),Lt=o(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-shyg20"&&(we.innerHTML=ws),Dt=o(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-g6qlg5"&&(Te.innerHTML=Ts),Kt=o(e),u(Je.$$.fragment,e),Ot=o(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1p3gfeb"&&(je.innerHTML=Js),el=o(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-17wa58l"&&(Ue.innerHTML=js),tl=o(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1gucs20"&&(fe.innerHTML=Us),ll=o(e),u(ge.$$.fragment,e),sl=o(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-sgspwr"&&(Ce.textContent=fs),nl=o(e),lt=i(e,"IMG",{src:!0}),ol=o(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1y8rl57"&&(ve.innerHTML=Cs),al=o(e),u(Ie.$$.fragment,e),il=o(e),u(Ze.$$.fragment,e),rl=o(e),st=i(e,"IMG",{src:!0}),pl=o(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-i5dtbz"&&(Be.textContent=Is),Ml=o(e),u(We.$$.fragment,e),ul=o(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1rq40pf"&&(Ge.innerHTML=Zs),cl=o(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1g7jkvd"&&($e.innerHTML=Bs),dl=o(e),u(ke.$$.fragment,e),ml=o(e),u(Qe.$$.fragment,e),yl=o(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-69p3x"&&(He.innerHTML=Ws),hl=o(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-ocb8u2"&&(_e.innerHTML=Gs),bl=o(e),u(Re.$$.fragment,e),wl=o(e),Ve=i(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-o3ledg"&&(Ve.textContent=$s),Tl=o(e),u(xe.$$.fragment,e),Jl=o(e),u(I.$$.fragment,e),jl=o(e),u(Ne.$$.fragment,e),Ul=o(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-w4ihv0"&&(Ee.innerHTML=ks),fl=o(e),u(Xe.$$.fragment,e),gl=o(e),Se=i(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1q39vf"&&(Se.innerHTML=Qs),Cl=o(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-v7rocy"&&(Ae.innerHTML=Hs),vl=o(e),u(Z.$$.fragment,e),Il=o(e),Fe=i(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-s0gh2b"&&(Fe.innerHTML=_s),Zl=o(e),u(qe.$$.fragment,e),Bl=o(e),Ye=i(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-17z5hjh"&&(Ye.innerHTML=Rs),Wl=o(e),u(ze.$$.fragment,e),Gl=o(e),Pe=i(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-j0i0xh"&&(Pe.innerHTML=Vs),$l=o(e),u(Le.$$.fragment,e),kl=o(e),u(De.$$.fragment,e),Ql=o(e),Ke=i(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-qubpc6"&&(Ke.textContent=xs),Hl=o(e),u(Oe.$$.fragment,e),_l=o(e),et=i(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-6r1jgt"&&(et.textContent=Ns),Rl=o(e),u(tt.$$.fragment,e),Vl=o(e),nt=i(e,"P",{}),qs(nt).forEach(l),this.h()},h(){Nl(p,"name","hf:doc:metadata"),Nl(p,"content",an),Fs(lt.src,gs="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||Nl(lt,"src",gs),Fs(st.src,vs="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||Nl(st,"src",vs)},m(e,t){Ks(document.head,p),s(e,J,t),s(e,h,t),s(e,b,t),c(U,e,t),s(e,w,t),c(j,e,t),s(e,ot,t),s(e,B,t),s(e,at,t),c(C,e,t),s(e,it,t),c(W,e,t),s(e,rt,t),s(e,G,t),s(e,pt,t),s(e,$,t),s(e,Mt,t),s(e,k,t),s(e,ut,t),s(e,Q,t),s(e,ct,t),s(e,H,t),s(e,dt,t),c(_,e,t),s(e,mt,t),s(e,R,t),s(e,yt,t),s(e,V,t),s(e,ht,t),s(e,x,t),s(e,bt,t),s(e,N,t),s(e,wt,t),s(e,E,t),s(e,Tt,t),c(X,e,t),s(e,Jt,t),s(e,S,t),s(e,jt,t),c(A,e,t),s(e,Ut,t),s(e,F,t),s(e,ft,t),s(e,q,t),s(e,gt,t),s(e,Y,t),s(e,Ct,t),s(e,z,t),s(e,vt,t),s(e,P,t),s(e,It,t),c(L,e,t),s(e,Zt,t),c(D,e,t),s(e,Bt,t),s(e,K,t),s(e,Wt,t),s(e,O,t),s(e,Gt,t),c(ee,e,t),s(e,$t,t),s(e,te,t),s(e,kt,t),c(le,e,t),s(e,Qt,t),s(e,se,t),s(e,Ht,t),c(ne,e,t),s(e,_t,t),s(e,oe,t),s(e,Rt,t),c(ae,e,t),s(e,Vt,t),c(v,e,t),s(e,xt,t),c(ie,e,t),s(e,Nt,t),s(e,re,t),s(e,Et,t),s(e,pe,t),s(e,Xt,t),c(Me,e,t),s(e,St,t),s(e,ue,t),s(e,At,t),s(e,ce,t),s(e,Ft,t),s(e,de,t),s(e,qt,t),c(me,e,t),s(e,Yt,t),s(e,ye,t),s(e,zt,t),c(he,e,t),s(e,Pt,t),s(e,be,t),s(e,Lt,t),s(e,we,t),s(e,Dt,t),s(e,Te,t),s(e,Kt,t),c(Je,e,t),s(e,Ot,t),s(e,je,t),s(e,el,t),s(e,Ue,t),s(e,tl,t),s(e,fe,t),s(e,ll,t),c(ge,e,t),s(e,sl,t),s(e,Ce,t),s(e,nl,t),s(e,lt,t),s(e,ol,t),s(e,ve,t),s(e,al,t),c(Ie,e,t),s(e,il,t),c(Ze,e,t),s(e,rl,t),s(e,st,t),s(e,pl,t),s(e,Be,t),s(e,Ml,t),c(We,e,t),s(e,ul,t),s(e,Ge,t),s(e,cl,t),s(e,$e,t),s(e,dl,t),c(ke,e,t),s(e,ml,t),c(Qe,e,t),s(e,yl,t),s(e,He,t),s(e,hl,t),s(e,_e,t),s(e,bl,t),c(Re,e,t),s(e,wl,t),s(e,Ve,t),s(e,Tl,t),c(xe,e,t),s(e,Jl,t),c(I,e,t),s(e,jl,t),c(Ne,e,t),s(e,Ul,t),s(e,Ee,t),s(e,fl,t),c(Xe,e,t),s(e,gl,t),s(e,Se,t),s(e,Cl,t),s(e,Ae,t),s(e,vl,t),c(Z,e,t),s(e,Il,t),s(e,Fe,t),s(e,Zl,t),c(qe,e,t),s(e,Bl,t),s(e,Ye,t),s(e,Wl,t),c(ze,e,t),s(e,Gl,t),s(e,Pe,t),s(e,$l,t),c(Le,e,t),s(e,kl,t),c(De,e,t),s(e,Ql,t),s(e,Ke,t),s(e,Hl,t),c(Oe,e,t),s(e,_l,t),s(e,et,t),s(e,Rl,t),c(tt,e,t),s(e,Vl,t),s(e,nt,t),xl=!0},p(e,[t]){const Es={};t&2&&(Es.$$scope={dirty:t,ctx:e}),C.$set(Es);const Xs={};t&2&&(Xs.$$scope={dirty:t,ctx:e}),v.$set(Xs);const Ss={};t&2&&(Ss.$$scope={dirty:t,ctx:e}),I.$set(Ss);const As={};t&2&&(As.$$scope={dirty:t,ctx:e}),Z.$set(As)},i(e){xl||(d(U.$$.fragment,e),d(j.$$.fragment,e),d(C.$$.fragment,e),d(W.$$.fragment,e),d(_.$$.fragment,e),d(X.$$.fragment,e),d(A.$$.fragment,e),d(L.$$.fragment,e),d(D.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(ae.$$.fragment,e),d(v.$$.fragment,e),d(ie.$$.fragment,e),d(Me.$$.fragment,e),d(me.$$.fragment,e),d(he.$$.fragment,e),d(Je.$$.fragment,e),d(ge.$$.fragment,e),d(Ie.$$.fragment,e),d(Ze.$$.fragment,e),d(We.$$.fragment,e),d(ke.$$.fragment,e),d(Qe.$$.fragment,e),d(Re.$$.fragment,e),d(xe.$$.fragment,e),d(I.$$.fragment,e),d(Ne.$$.fragment,e),d(Xe.$$.fragment,e),d(Z.$$.fragment,e),d(qe.$$.fragment,e),d(ze.$$.fragment,e),d(Le.$$.fragment,e),d(De.$$.fragment,e),d(Oe.$$.fragment,e),d(tt.$$.fragment,e),xl=!0)},o(e){m(U.$$.fragment,e),m(j.$$.fragment,e),m(C.$$.fragment,e),m(W.$$.fragment,e),m(_.$$.fragment,e),m(X.$$.fragment,e),m(A.$$.fragment,e),m(L.$$.fragment,e),m(D.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(ae.$$.fragment,e),m(v.$$.fragment,e),m(ie.$$.fragment,e),m(Me.$$.fragment,e),m(me.$$.fragment,e),m(he.$$.fragment,e),m(Je.$$.fragment,e),m(ge.$$.fragment,e),m(Ie.$$.fragment,e),m(Ze.$$.fragment,e),m(We.$$.fragment,e),m(ke.$$.fragment,e),m(Qe.$$.fragment,e),m(Re.$$.fragment,e),m(xe.$$.fragment,e),m(I.$$.fragment,e),m(Ne.$$.fragment,e),m(Xe.$$.fragment,e),m(Z.$$.fragment,e),m(qe.$$.fragment,e),m(ze.$$.fragment,e),m(Le.$$.fragment,e),m(De.$$.fragment,e),m(Oe.$$.fragment,e),m(tt.$$.fragment,e),xl=!1},d(e){e&&(l(J),l(h),l(b),l(w),l(ot),l(B),l(at),l(it),l(rt),l(G),l(pt),l($),l(Mt),l(k),l(ut),l(Q),l(ct),l(H),l(dt),l(mt),l(R),l(yt),l(V),l(ht),l(x),l(bt),l(N),l(wt),l(E),l(Tt),l(Jt),l(S),l(jt),l(Ut),l(F),l(ft),l(q),l(gt),l(Y),l(Ct),l(z),l(vt),l(P),l(It),l(Zt),l(Bt),l(K),l(Wt),l(O),l(Gt),l($t),l(te),l(kt),l(Qt),l(se),l(Ht),l(_t),l(oe),l(Rt),l(Vt),l(xt),l(Nt),l(re),l(Et),l(pe),l(Xt),l(St),l(ue),l(At),l(ce),l(Ft),l(de),l(qt),l(Yt),l(ye),l(zt),l(Pt),l(be),l(Lt),l(we),l(Dt),l(Te),l(Kt),l(Ot),l(je),l(el),l(Ue),l(tl),l(fe),l(ll),l(sl),l(Ce),l(nl),l(lt),l(ol),l(ve),l(al),l(il),l(rl),l(st),l(pl),l(Be),l(Ml),l(ul),l(Ge),l(cl),l($e),l(dl),l(ml),l(yl),l(He),l(hl),l(_e),l(bl),l(wl),l(Ve),l(Tl),l(Jl),l(jl),l(Ul),l(Ee),l(fl),l(gl),l(Se),l(Cl),l(Ae),l(vl),l(Il),l(Fe),l(Zl),l(Bl),l(Ye),l(Wl),l(Gl),l(Pe),l($l),l(kl),l(Ql),l(Ke),l(Hl),l(_l),l(et),l(Rl),l(Vl),l(nt)),l(p),y(U,e),y(j,e),y(C,e),y(W,e),y(_,e),y(X,e),y(A,e),y(L,e),y(D,e),y(ee,e),y(le,e),y(ne,e),y(ae,e),y(v,e),y(ie,e),y(Me,e),y(me,e),y(he,e),y(Je,e),y(ge,e),y(Ie,e),y(Ze,e),y(We,e),y(ke,e),y(Qe,e),y(Re,e),y(xe,e),y(I,e),y(Ne,e),y(Xe,e),y(Z,e),y(qe,e),y(ze,e),y(Le,e),y(De,e),y(Oe,e),y(tt,e)}}}const an='{"title":"Tools","local":"tools","sections":[{"title":"What is a tool, and how to build one?","local":"what-is-a-tool-and-how-to-build-one","sections":[],"depth":3},{"title":"Share your tool to the Hub","local":"share-your-tool-to-the-hub","sections":[],"depth":3},{"title":"Use tools from an MCP server","local":"use-tools-from-an-mcp-server","sections":[{"title":"Structured Output and Output Schema Support","local":"structured-output-and-output-schema-support","sections":[],"depth":4}],"depth":3},{"title":"Import a Space as a tool","local":"import-a-space-as-a-tool","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3},{"title":"Manage your agent’s toolbox","local":"manage-your-agents-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[{"title":"Tool Collection from any MCP server","local":"tool-collection-from-any-mcp-server","sections":[],"depth":4},{"title":"Tool Collection from a collection in the Hub","local":"tool-collection-from-a-collection-in-the-hub","sections":[],"depth":4}],"depth":3}],"depth":1}';function rn(g){return zs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yn extends Ps{constructor(p){super(),Ls(this,p,rn,on,Ys,{})}}export{yn as component};
