import{s as tt,n as lt,o as st}from"../chunks/scheduler.f6319a2a.js";import{S as nt,i as ot,g as i,s as n,r as p,A as it,h as a,f as l,c as o,j as Ke,u as r,x as m,k as et,y as at,a as s,v as d,d as M,t as f,w as g}from"../chunks/index.85aa684c.js";import{C as u}from"../chunks/CodeBlock.3400fc53.js";import{D as mt}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as D,E as pt}from"../chunks/getInferenceSnippets.55a93fbe.js";function rt(Ee){let T,K,Y,ee,c,te,w,le,b,Ce=`<code>smolagents</code> provides a flexible framework that allows you to use various language models from different providers.
This guide will show you how to use different model types with your agents.`,se,J,ne,y,xe="<code>smolagents</code> supports several model types out of the box:",oe,U,je='<li><a href="/docs/smolagents/main/en/reference/models#smolagents.InferenceClientModel">InferenceClientModel</a>: Uses Hugging Face’s Inference API to access models</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.TransformersModel">TransformersModel</a>: Runs models locally using the Transformers library</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.VLLMModel">VLLMModel</a>: Uses vLLM for fast inference with optimized serving</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.MLXModel">MLXModel</a>: Optimized for Apple Silicon devices using MLX</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.LiteLLMModel">LiteLLMModel</a>: Provides access to hundreds of LLMs through LiteLLM</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.LiteLLMRouterModel">LiteLLMRouterModel</a>: Distributes requests among multiple models</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.OpenAIServerModel">OpenAIServerModel</a>: Provides access to any provider that implements an OpenAI-compatible API</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.AzureOpenAIServerModel">AzureOpenAIServerModel</a>: Uses Azure’s OpenAI service</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.AmazonBedrockServerModel">AmazonBedrockServerModel</a>: Connects to AWS Bedrock’s API</li>',ie,h,Ge=`All model classes support passing additional keyword arguments (like <code>temperature</code>, <code>max_tokens</code>, <code>top_p</code>, etc.) directly at instantiation time.
These parameters are automatically forwarded to the underlying model’s completion calls, allowing you to configure model behavior such as creativity, response length, and sampling strategies.`,ae,I,me,$,Pe=`As explained in the Google Gemini API documentation (<a href="https://ai.google.dev/gemini-api/docs/openai" rel="nofollow">https://ai.google.dev/gemini-api/docs/openai</a>),
Google provides an OpenAI-compatible API for Gemini models, allowing you to use the <a href="/docs/smolagents/main/en/reference/models#smolagents.OpenAIServerModel">OpenAIServerModel</a>
with Gemini models by setting the appropriate base URL.`,pe,v,Fe="First, install the required dependencies:",re,R,de,k,We='Then, <a href="https://ai.google.dev/gemini-api/docs/api-key" rel="nofollow">get a Gemini API key</a> and set it in your code:',Me,L,fe,A,He=`Now, you can initialize the Gemini model using the <code>OpenAIServerModel</code> class
and setting the <code>api_base</code> parameter to the Gemini API base URL:`,ge,B,Te,_,ue,V,Oe=`OpenRouter provides access to a wide variety of language models through a unified OpenAI-compatible API.
You can use the <a href="/docs/smolagents/main/en/reference/models#smolagents.OpenAIServerModel">OpenAIServerModel</a> to connect to OpenRouter by setting the appropriate base URL.`,ce,S,Ze="First, install the required dependencies:",we,E,be,C,Qe='Then, <a href="https://openrouter.ai/keys" rel="nofollow">get an OpenRouter API key</a> and set it in your code:',Je,x,ye,j,ze="Now, you can initialize any model available on OpenRouter using the <code>OpenAIServerModel</code> class:",Ue,G,he,P,Ie,F,Xe='xAI’s Grok models can be accessed through <a href="/docs/smolagents/main/en/reference/models#smolagents.LiteLLMModel">LiteLLMModel</a>.',$e,W,Ne=`Some models (such as “grok-4” and “grok-3-mini”) don’t support the <code>stop</code> parameter, so you’ll need to use
<code>REMOVE_PARAMETER</code> to exclude it from API calls.`,ve,H,Ye="First, install the required dependencies:",Re,O,ke,Z,qe='Then, <a href="https://console.x.ai/" rel="nofollow">get an xAI API key</a> and set it in your code:',Le,Q,Ae,z,De="Now, you can initialize Grok models using the <code>LiteLLMModel</code> class and remove the <code>stop</code> parameter if applicable:",Be,X,_e,N,Ve,q,Se;return c=new D({props:{title:"Using different models",local:"using-different-models",headingTag:"h1"}}),w=new mt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/using_different_models.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/using_different_models.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/using_different_models.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/using_different_models.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/using_different_models.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/using_different_models.ipynb"}]}}),J=new D({props:{title:"Available model types",local:"available-model-types",headingTag:"h2"}}),I=new D({props:{title:"Using Google Gemini Models",local:"using-google-gemini-models",headingTag:"h2"}}),R=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCb3BlbmFpJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[openai]&#x27;</span>',wrap:!1}}),L=new u({props:{code:"R0VNSU5JX0FQSV9LRVklMjAlM0QlMjAlM0NZT1VSLUdFTUlOSS1BUEktS0VZJTNF",highlighted:"GEMINI_API_KEY = &lt;YOUR-GEMINI-API-KEY&gt;",wrap:!1}}),B=new u({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBPcGVuQUlTZXJ2ZXJNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJU2VydmVyTW9kZWwoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlM0QlMjJnZW1pbmktMi4wLWZsYXNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwR29vZ2xlJTIwR2VtaW5pJTIwT3BlbkFJLWNvbXBhdGlibGUlMjBBUEklMjBiYXNlJTIwVVJMJTBBJTIwJTIwJTIwJTIwYXBpX2Jhc2UlM0QlMjJodHRwcyUzQSUyRiUyRmdlbmVyYXRpdmVsYW5ndWFnZS5nb29nbGVhcGlzLmNvbSUyRnYxYmV0YSUyRm9wZW5haSUyRiUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0RHRU1JTklfQVBJX0tFWSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> OpenAIServerModel

model = OpenAIServerModel(
    model_id=<span class="hljs-string">&quot;gemini-2.0-flash&quot;</span>,
    <span class="hljs-comment"># Google Gemini OpenAI-compatible API base URL</span>
    api_base=<span class="hljs-string">&quot;https://generativelanguage.googleapis.com/v1beta/openai/&quot;</span>,
    api_key=GEMINI_API_KEY,
)`,wrap:!1}}),_=new D({props:{title:"Using OpenRouter Models",local:"using-openrouter-models",headingTag:"h2"}}),E=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCb3BlbmFpJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[openai]&#x27;</span>',wrap:!1}}),x=new u({props:{code:"T1BFTlJPVVRFUl9BUElfS0VZJTIwJTNEJTIwJTNDWU9VUi1PUEVOUk9VVEVSLUFQSS1LRVklM0U=",highlighted:"OPENROUTER_API_KEY = &lt;YOUR-OPENROUTER-API-KEY&gt;",wrap:!1}}),G=new u({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBPcGVuQUlTZXJ2ZXJNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJU2VydmVyTW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIzJTIwWW91JTIwY2FuJTIwdXNlJTIwYW55JTIwbW9kZWwlMjBJRCUyMGF2YWlsYWJsZSUyMG9uJTIwT3BlblJvdXRlciUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTNEJTIyb3BlbmFpJTJGZ3B0LTRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwT3BlblJvdXRlciUyMEFQSSUyMGJhc2UlMjBVUkwlMEElMjAlMjAlMjAlMjBhcGlfYmFzZSUzRCUyMmh0dHBzJTNBJTJGJTJGb3BlbnJvdXRlci5haSUyRmFwaSUyRnYxJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRE9QRU5ST1VURVJfQVBJX0tFWSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> OpenAIServerModel

model = OpenAIServerModel(
    <span class="hljs-comment"># You can use any model ID available on OpenRouter</span>
    model_id=<span class="hljs-string">&quot;openai/gpt-4o&quot;</span>,
    <span class="hljs-comment"># OpenRouter API base URL</span>
    api_base=<span class="hljs-string">&quot;https://openrouter.ai/api/v1&quot;</span>,
    api_key=OPENROUTER_API_KEY,
)`,wrap:!1}}),P=new D({props:{title:"Using xAI’s Grok Models",local:"using-xais-grok-models",headingTag:"h2"}}),O=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlNUJsaXRlbGxtJTVE",highlighted:"pip install smolagents[litellm]",wrap:!1}}),Q=new u({props:{code:"WEFJX0FQSV9LRVklMjAlM0QlMjAlM0NZT1VSLVhBSS1BUEktS0VZJTNF",highlighted:"XAI_API_KEY = &lt;YOUR-XAI-API-KEY&gt;",wrap:!1}}),X=new u({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBMaXRlTExNTW9kZWwlMkMlMjBSRU1PVkVfUEFSQU1FVEVSJTBBJTBBJTIzJTIwVXNpbmclMjBHcm9rLTQlMEFtb2RlbCUyMCUzRCUyMExpdGVMTE1Nb2RlbCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMnhhaSUyRmdyb2stNCUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0RYQUlfQVBJX0tFWSUyQyUwQSUyMCUyMCUyMCUyMHN0b3AlM0RSRU1PVkVfUEFSQU1FVEVSJTJDJTIwJTIwJTIzJTIwUmVtb3ZlJTIwc3RvcCUyMHBhcmFtZXRlciUyMGFzJTIwZ3Jvay00JTIwbW9kZWwlMjBkb2Vzbid0JTIwc3VwcG9ydCUyMGl0JTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjclMEEpJTBBJTBBJTIzJTIwT3IlMjB1c2luZyUyMEdyb2stMy1taW5pJTBBbW9kZWxfbWluaSUyMCUzRCUyMExpdGVMTE1Nb2RlbCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMnhhaSUyRmdyb2stMy1taW5pJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRFhBSV9BUElfS0VZJTJDJTBBJTIwJTIwJTIwJTIwc3RvcCUzRFJFTU9WRV9QQVJBTUVURVIlMkMlMjAlMjAlMjMlMjBSZW1vdmUlMjBzdG9wJTIwcGFyYW1ldGVyJTIwYXMlMjBncm9rLTMtbWluaSUyMG1vZGVsJTIwZG9lc24ndCUyMHN1cHBvcnQlMjBpdCUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDAwJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> LiteLLMModel, REMOVE_PARAMETER

<span class="hljs-comment"># Using Grok-4</span>
model = LiteLLMModel(
    model_id=<span class="hljs-string">&quot;xai/grok-4&quot;</span>,
    api_key=XAI_API_KEY,
    stop=REMOVE_PARAMETER,  <span class="hljs-comment"># Remove stop parameter as grok-4 model doesn&#x27;t support it</span>
    temperature=<span class="hljs-number">0.7</span>
)

<span class="hljs-comment"># Or using Grok-3-mini</span>
model_mini = LiteLLMModel(
    model_id=<span class="hljs-string">&quot;xai/grok-3-mini&quot;</span>,
    api_key=XAI_API_KEY,
    stop=REMOVE_PARAMETER,  <span class="hljs-comment"># Remove stop parameter as grok-3-mini model doesn&#x27;t support it</span>
    max_tokens=<span class="hljs-number">1000</span>
)`,wrap:!1}}),N=new pt({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/using_different_models.md"}}),{c(){T=i("meta"),K=n(),Y=i("p"),ee=n(),p(c.$$.fragment),te=n(),p(w.$$.fragment),le=n(),b=i("p"),b.innerHTML=Ce,se=n(),p(J.$$.fragment),ne=n(),y=i("p"),y.innerHTML=xe,oe=n(),U=i("ol"),U.innerHTML=je,ie=n(),h=i("p"),h.innerHTML=Ge,ae=n(),p(I.$$.fragment),me=n(),$=i("p"),$.innerHTML=Pe,pe=n(),v=i("p"),v.textContent=Fe,re=n(),p(R.$$.fragment),de=n(),k=i("p"),k.innerHTML=We,Me=n(),p(L.$$.fragment),fe=n(),A=i("p"),A.innerHTML=He,ge=n(),p(B.$$.fragment),Te=n(),p(_.$$.fragment),ue=n(),V=i("p"),V.innerHTML=Oe,ce=n(),S=i("p"),S.textContent=Ze,we=n(),p(E.$$.fragment),be=n(),C=i("p"),C.innerHTML=Qe,Je=n(),p(x.$$.fragment),ye=n(),j=i("p"),j.innerHTML=ze,Ue=n(),p(G.$$.fragment),he=n(),p(P.$$.fragment),Ie=n(),F=i("p"),F.innerHTML=Xe,$e=n(),W=i("p"),W.innerHTML=Ne,ve=n(),H=i("p"),H.textContent=Ye,Re=n(),p(O.$$.fragment),ke=n(),Z=i("p"),Z.innerHTML=qe,Le=n(),p(Q.$$.fragment),Ae=n(),z=i("p"),z.innerHTML=De,Be=n(),p(X.$$.fragment),_e=n(),p(N.$$.fragment),Ve=n(),q=i("p"),this.h()},l(e){const t=it("svelte-u9bgzb",document.head);T=a(t,"META",{name:!0,content:!0}),t.forEach(l),K=o(e),Y=a(e,"P",{}),Ke(Y).forEach(l),ee=o(e),r(c.$$.fragment,e),te=o(e),r(w.$$.fragment,e),le=o(e),b=a(e,"P",{"data-svelte-h":!0}),m(b)!=="svelte-nqa3ku"&&(b.innerHTML=Ce),se=o(e),r(J.$$.fragment,e),ne=o(e),y=a(e,"P",{"data-svelte-h":!0}),m(y)!=="svelte-z7j4in"&&(y.innerHTML=xe),oe=o(e),U=a(e,"OL",{"data-svelte-h":!0}),m(U)!=="svelte-1gtg7ax"&&(U.innerHTML=je),ie=o(e),h=a(e,"P",{"data-svelte-h":!0}),m(h)!=="svelte-zqae9j"&&(h.innerHTML=Ge),ae=o(e),r(I.$$.fragment,e),me=o(e),$=a(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-ybt1yc"&&($.innerHTML=Pe),pe=o(e),v=a(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1f3oki6"&&(v.textContent=Fe),re=o(e),r(R.$$.fragment,e),de=o(e),k=a(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1scf5a3"&&(k.innerHTML=We),Me=o(e),r(L.$$.fragment,e),fe=o(e),A=a(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1a5n7np"&&(A.innerHTML=He),ge=o(e),r(B.$$.fragment,e),Te=o(e),r(_.$$.fragment,e),ue=o(e),V=a(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1wgz0x9"&&(V.innerHTML=Oe),ce=o(e),S=a(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1f3oki6"&&(S.textContent=Ze),we=o(e),r(E.$$.fragment,e),be=o(e),C=a(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-co5fkh"&&(C.innerHTML=Qe),Je=o(e),r(x.$$.fragment,e),ye=o(e),j=a(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1ibsz4t"&&(j.innerHTML=ze),Ue=o(e),r(G.$$.fragment,e),he=o(e),r(P.$$.fragment,e),Ie=o(e),F=a(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1qlxq5o"&&(F.innerHTML=Xe),$e=o(e),W=a(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1iunuuy"&&(W.innerHTML=Ne),ve=o(e),H=a(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1f3oki6"&&(H.textContent=Ye),Re=o(e),r(O.$$.fragment,e),ke=o(e),Z=a(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-180jkec"&&(Z.innerHTML=qe),Le=o(e),r(Q.$$.fragment,e),Ae=o(e),z=a(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1ffid4g"&&(z.innerHTML=De),Be=o(e),r(X.$$.fragment,e),_e=o(e),r(N.$$.fragment,e),Ve=o(e),q=a(e,"P",{}),Ke(q).forEach(l),this.h()},h(){et(T,"name","hf:doc:metadata"),et(T,"content",dt)},m(e,t){at(document.head,T),s(e,K,t),s(e,Y,t),s(e,ee,t),d(c,e,t),s(e,te,t),d(w,e,t),s(e,le,t),s(e,b,t),s(e,se,t),d(J,e,t),s(e,ne,t),s(e,y,t),s(e,oe,t),s(e,U,t),s(e,ie,t),s(e,h,t),s(e,ae,t),d(I,e,t),s(e,me,t),s(e,$,t),s(e,pe,t),s(e,v,t),s(e,re,t),d(R,e,t),s(e,de,t),s(e,k,t),s(e,Me,t),d(L,e,t),s(e,fe,t),s(e,A,t),s(e,ge,t),d(B,e,t),s(e,Te,t),d(_,e,t),s(e,ue,t),s(e,V,t),s(e,ce,t),s(e,S,t),s(e,we,t),d(E,e,t),s(e,be,t),s(e,C,t),s(e,Je,t),d(x,e,t),s(e,ye,t),s(e,j,t),s(e,Ue,t),d(G,e,t),s(e,he,t),d(P,e,t),s(e,Ie,t),s(e,F,t),s(e,$e,t),s(e,W,t),s(e,ve,t),s(e,H,t),s(e,Re,t),d(O,e,t),s(e,ke,t),s(e,Z,t),s(e,Le,t),d(Q,e,t),s(e,Ae,t),s(e,z,t),s(e,Be,t),d(X,e,t),s(e,_e,t),d(N,e,t),s(e,Ve,t),s(e,q,t),Se=!0},p:lt,i(e){Se||(M(c.$$.fragment,e),M(w.$$.fragment,e),M(J.$$.fragment,e),M(I.$$.fragment,e),M(R.$$.fragment,e),M(L.$$.fragment,e),M(B.$$.fragment,e),M(_.$$.fragment,e),M(E.$$.fragment,e),M(x.$$.fragment,e),M(G.$$.fragment,e),M(P.$$.fragment,e),M(O.$$.fragment,e),M(Q.$$.fragment,e),M(X.$$.fragment,e),M(N.$$.fragment,e),Se=!0)},o(e){f(c.$$.fragment,e),f(w.$$.fragment,e),f(J.$$.fragment,e),f(I.$$.fragment,e),f(R.$$.fragment,e),f(L.$$.fragment,e),f(B.$$.fragment,e),f(_.$$.fragment,e),f(E.$$.fragment,e),f(x.$$.fragment,e),f(G.$$.fragment,e),f(P.$$.fragment,e),f(O.$$.fragment,e),f(Q.$$.fragment,e),f(X.$$.fragment,e),f(N.$$.fragment,e),Se=!1},d(e){e&&(l(K),l(Y),l(ee),l(te),l(le),l(b),l(se),l(ne),l(y),l(oe),l(U),l(ie),l(h),l(ae),l(me),l($),l(pe),l(v),l(re),l(de),l(k),l(Me),l(fe),l(A),l(ge),l(Te),l(ue),l(V),l(ce),l(S),l(we),l(be),l(C),l(Je),l(ye),l(j),l(Ue),l(he),l(Ie),l(F),l($e),l(W),l(ve),l(H),l(Re),l(ke),l(Z),l(Le),l(Ae),l(z),l(Be),l(_e),l(Ve),l(q)),l(T),g(c,e),g(w,e),g(J,e),g(I,e),g(R,e),g(L,e),g(B,e),g(_,e),g(E,e),g(x,e),g(G,e),g(P,e),g(O,e),g(Q,e),g(X,e),g(N,e)}}}const dt='{"title":"Using different models","local":"using-different-models","sections":[{"title":"Available model types","local":"available-model-types","sections":[],"depth":2},{"title":"Using Google Gemini Models","local":"using-google-gemini-models","sections":[],"depth":2},{"title":"Using OpenRouter Models","local":"using-openrouter-models","sections":[],"depth":2},{"title":"Using xAI’s Grok Models","local":"using-xais-grok-models","sections":[],"depth":2}],"depth":1}';function Mt(Ee){return st(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wt extends nt{constructor(T){super(),ot(this,T,Mt,rt,tt,{})}}export{wt as component};
