import{s as YT,o as vT,n as XT}from"../chunks/scheduler.f6319a2a.js";import{S as ST,i as ET,g as e,s as M,r as i,m as AT,A as fT,h as y,f as T,c as t,j as rl,u as a,x as C,n as WT,k as DT,y as p,a as J,v as w,d as n,t as s,w as o}from"../chunks/index.85aa684c.js";import{T as zT}from"../chunks/Tip.3d397a88.js";import{C as V}from"../chunks/CodeBlock.3400fc53.js";import{D as HT}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as F,E as xT}from"../chunks/getInferenceSnippets.55a93fbe.js";function _T(Al){let N,h='如果你是 agent 构建的新手，请确保首先阅读 <a href="../conceptual_guides/intro_agents">agent 介绍</a> 和 <a href="../guided_tour">smolagents 导览</a>。';return{c(){N=e("p"),N.innerHTML=h},l(I){N=y(I,"P",{"data-svelte-h":!0}),C(N)!=="svelte-171btbu"&&(N.innerHTML=h)},m(I,Bl){J(I,N,Bl)},p:XT,d(I){I&&T(N)}}}function $T(Al){let N,h,I,Bl,R,Wl,c,Dl,j,qU=`能良好工作的 agent 和不能工作的 agent 之间，有天壤之别。
我们怎么样才能构建出属于前者的 agent 呢？
在本指南中，我们将看到构建 agent 的最佳实践。`,Yl,k,vl,b,Xl,u,LU="在你的工作流中赋予 LLM 一些自主权，会引入一些错误风险。",Sl,O,PU="经过良好编程的 agent 系统，通常具有良好的错误日志记录和重试机制，因此 LLM 引擎有机会自我纠错。但为了最大限度地降低 LLM 错误的风险，你应该简化你的工作流！",El,B,KU=`让我们回顾一下 <a href="../conceptual_guides/intro_agents">agent 介绍</a> 中的例子：一个为冲浪旅行公司回答用户咨询的机器人。
与其让 agent 每次被问及新的冲浪地点时，都分别调用 “旅行距离 API” 和 “天气 API”，你可以只创建一个统一的工具 “return_spot_information”，一个同时调用这两个 API，并返回它们连接输出的函数。`,fl,m,lT="这可以降低成本、延迟和错误风险！",zl,Q,UT="主要的指导原则是：尽可能减少 LLM 调用的次数。",Hl,G,TT="这可以带来一些启发：",xl,Z,JT="<li>尽可能把两个工具合并为一个，就像我们两个 API 的例子。</li> <li>尽可能基于确定性函数，而不是 agent 决策，来实现逻辑。</li>",_l,r,$l,A,MT="记住，你的 LLM 引擎就像一个 ~智能~ 机器人，被关在一个房间里，与外界唯一的交流方式是通过门缝传递的纸条。",ql,W,tT="如果你没有明确地将信息放入其提示中，它将不知道发生的任何事情。",Ll,D,eT=`所以首先要让你的任务非常清晰！
由于 agent 由 LLM 驱动，任务表述的微小变化可能会产生完全不同的结果。`,Pl,Y,yT="然后，改善工具使用中流向 agent 的信息流。",Kl,v,CT="需要遵循的具体指南：",lU,X,iT="<li>每个工具都应该记录（只需在工具的 <code>forward</code> 方法中使用 <code>print</code> 语句）对 LLM 引擎可能有用的所有信息。<ul><li>特别是，记录工具执行错误的详细信息会很有帮助！</li></ul></li>",UU,S,aT="例如，这里有一个根据位置和日期时间检索天气数据的工具：",TU,E,wT="首先，这是一个糟糕的版本：",JU,f,MU,z,nT="为什么它不好？",tU,H,sT="<li>没有说明 <code>date_time</code> 应该使用的格式</li> <li>没有说明位置应该如何指定</li> <li>没有记录机制来处理明确的报错情况，如位置格式不正确或 date_time 格式不正确</li> <li>输出格式难以理解</li>",eU,x,oT="如果工具调用失败，内存中记录的错误跟踪，可以帮助 LLM 逆向工程工具来修复错误。但为什么要让它做这么多繁重的工作呢？",yU,_,NT="构建这个工具的更好方式如下：",CU,$,iU,q,IT="一般来说，为了减轻 LLM 的负担，要问自己的好问题是：“如果我是一个第一次使用这个工具的傻瓜，使用这个工具编程并纠正自己的错误有多容易？“。",aU,L,wU,P,dT="除了简单的任务描述字符串外，你还可以使用 <code>additional_args</code> 参数传递任何类型的对象：",nU,K,sU,ll,VT="例如，你可以使用这个 <code>additional_args</code> 参数传递你希望 agent 利用的图像或字符串。",oU,Ul,NU,Tl,IU,Jl,gT=`在 agent 工作流中，有些错误是实际错误，有些则是你的 LLM 引擎没有正确推理的结果。
例如，参考这个我要求创建一个汽车图片的 <code>CodeAgent</code> 的运行记录：`,dU,Ml,VU,tl,FT=`用户看到的是返回了一个路径，而不是图像。
这看起来像是系统的错误，但实际上 agent 系统并没有导致错误：只是 LLM 大脑犯了一个错误，没有把图像输出，保存到变量中。
因此，它无法再次访问图像，只能利用保存图像时记录的路径，所以它返回的是路径，而不是图像。`,gU,el,kT="调试 agent 的第一步是”使用更强大的 LLM”。像 <code>Qwen2.5-72B-Instruct</code> 这样的替代方案不会犯这种错误。",FU,yl,kU,Cl,pT="你也可以使用不太强大的模型，只要你更有效地指导它们。",pU,il,hT="站在模型的角度思考：如果你是模型在解决任务，你会因为系统提示+任务表述+工具描述中提供的信息而挣扎吗？",hU,al,RT="你需要一些额外的说明吗？",RU,wl,cT=`为了提供额外信息，我们不建议立即更改系统提示：默认系统提示有许多调整，除非你非常了解提示，否则你很容易翻车。
更好的指导 LLM 引擎的方法是：`,cU,nl,jT="<li>如果是关于要解决的任务：把所有细节添加到任务中。任务可以有几百页长。</li> <li>如果是关于如何使用工具：你的工具的 description 属性。</li>",jU,sl,bU,ol,bT="如果上述说明不够，你可以更改系统提示。",uU,Nl,uT='让我们看看它是如何工作的。例如，让我们检查 <a href="/docs/smolagents/main/zh/reference/agents#smolagents.CodeAgent">CodeAgent</a> 的默认系统提示（下面的版本通过跳过零样本示例进行了缩短）。',OU,Il,BU,dl,OT="你会得到：",mU,Vl,QU,gl,BT="如你所见，有一些占位符，如 <code>&quot;{{ tool.description }}&quot;</code>：这些将在 agent 初始化时用于插入某些自动生成的工具或管理 agent 的描述。",GU,Fl,mT="因此，虽然你可以通过将自定义提示作为参数传递给 <code>system_prompt</code> 参数来覆盖此系统提示模板，但你的新系统提示必须包含以下占位符：",ZU,d,ml,fU,kl,zU,Ql,HU,pl,xU,Gl,QT="仅限 <code>CodeAgent</code>：<code>&quot;{{authorized_imports}}&quot;</code> 用于插入授权导入列表。",rU,hl,GT="然后你可以根据如下，更改系统提示：",AU,Rl,WU,cl,ZT='这也适用于 <a href="/docs/smolagents/main/zh/reference/agents#smolagents.ToolCallingAgent">ToolCallingAgent</a>。',DU,jl,YU,bl,rT="我们提供了一个用于补充规划步骤的模型，agent 可以在正常操作步骤之间定期运行。在此步骤中，没有工具调用，LLM 只是被要求更新它知道的事实列表，并根据这些事实反推它应该采取的下一步。",vU,ul,XU,Ol,SU,Zl,EU;return R=new F({props:{title:"构建好用的 agent",local:"构建好用的-agent",headingTag:"h1"}}),c=new HT({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/building_good_agents.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/pytorch/building_good_agents.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tensorflow/building_good_agents.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/building_good_agents.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/pytorch/building_good_agents.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tensorflow/building_good_agents.ipynb"}]}}),k=new zT({props:{warning:!1,$$slots:{default:[_T]},$$scope:{ctx:Al}}}),b=new F({props:{title:"最好的 agent 系统是最简单的：尽可能简化工作流",local:"最好的-agent-系统是最简单的尽可能简化工作流",headingTag:"h3"}}),r=new F({props:{title:"改善流向 LLM 引擎的信息流",local:"改善流向-llm-引擎的信息流",headingTag:"h3"}}),f=new V({props:{code:"aW1wb3J0JTIwZGF0ZXRpbWUlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMHRvb2wlMEElMEFkZWYlMjBnZXRfd2VhdGhlcl9yZXBvcnRfYXRfY29vcmRpbmF0ZXMoY29vcmRpbmF0ZXMlMkMlMjBkYXRlX3RpbWUpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwJUU4JTk5JTlBJUU2JThCJTlGJUU1JTg3JUJEJUU2JTk1JUIwJUVGJUJDJThDJUU4JUJGJTk0JUU1JTlCJTlFJTIwJTVCJUU2JUI4JUE5JUU1JUJBJUE2JUVGJUJDJTg4JUMyJUIwQyVFRiVCQyU4OSVFRiVCQyU4QyVFOSU5OSU4RCVFOSU5QiVBOCVFOSVBMyU4RSVFOSU5OSVBOSVFRiVCQyU4ODAtMSVFRiVCQyU4OSVFRiVCQyU4QyVFNiVCNSVBQSVFOSVBQiU5OCVFRiVCQyU4OG0lRUYlQkMlODklNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUIyOC4wJTJDJTIwMC4zNSUyQyUyMDAuODUlNUQlMEElMEFkZWYlMjBnZXRfY29vcmRpbmF0ZXNfZnJvbV9sb2NhdGlvbihsb2NhdGlvbiklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjAlRTglQkYlOTQlRTUlOUIlOUUlRTglOTklOUElRTYlOEIlOUYlRTUlOUQlOTAlRTYlQTAlODclMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUIzLjMlMkMlMjAtNDIuMCU1RCUwQSUwQSU0MHRvb2wlMEFkZWYlMjBnZXRfd2VhdGhlcl9hcGkobG9jYXRpb24lM0ElMjBzdHIlMkMlMjBkYXRlX3RpbWUlM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMFJldHVybnMlMjB0aGUlMjB3ZWF0aGVyJTIwcmVwb3J0LiUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2NhdGlvbiUzQSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMHBsYWNlJTIwdGhhdCUyMHlvdSUyMHdhbnQlMjB0aGUlMjB3ZWF0aGVyJTIwZm9yLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGVfdGltZSUzQSUyMHRoZSUyMGRhdGUlMjBhbmQlMjB0aW1lJTIwZm9yJTIwd2hpY2glMjB5b3UlMjB3YW50JTIwdGhlJTIwcmVwb3J0LiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGxvbiUyQyUyMGxhdCUyMCUzRCUyMGNvbnZlcnRfbG9jYXRpb25fdG9fY29vcmRpbmF0ZXMobG9jYXRpb24pJTBBJTIwJTIwJTIwJTIwZGF0ZV90aW1lJTIwJTNEJTIwZGF0ZXRpbWUuc3RycHRpbWUoZGF0ZV90aW1lKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHN0cihnZXRfd2VhdGhlcl9yZXBvcnRfYXRfY29vcmRpbmF0ZXMoKGxvbiUyQyUyMGxhdCklMkMlMjBkYXRlX3RpbWUpKQ==",highlighted:`<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_report_at_coordinates</span>(<span class="hljs-params">coordinates, date_time</span>):
    <span class="hljs-comment"># 虚拟函数，返回 [温度（°C），降雨风险（0-1），浪高（m）]</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">28.0</span>, <span class="hljs-number">0.35</span>, <span class="hljs-number">0.85</span>]

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_coordinates_from_location</span>(<span class="hljs-params">location</span>):
    <span class="hljs-comment"># 返回虚拟坐标</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">3.3</span>, -<span class="hljs-number">42.0</span>]

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_api</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, date_time: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Returns the weather report.

    Args:
        location: the name of the place that you want the weather for.
        date_time: the date and time for which you want the report.
    &quot;&quot;&quot;</span>
    lon, lat = convert_location_to_coordinates(location)
    date_time = datetime.strptime(date_time)
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(get_weather_report_at_coordinates((lon, lat), date_time))`,wrap:!1}}),$=new V({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_api</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, date_time: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Returns the weather report.

    Args:
        location: the name of the place that you want the weather for. Should be a place name, followed by possibly a city name, then a country, like &quot;Anchor Point, Taghazout, Morocco&quot;.
        date_time: the date and time for which you want the report, formatted as &#x27;%m/%d/%y %H:%M:%S&#x27;.
    &quot;&quot;&quot;</span>
    lon, lat = convert_location_to_coordinates(location)
    <span class="hljs-keyword">try</span>:
        date_time = datetime.strptime(date_time)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;Conversion of \`date_time\` to datetime format failed, make sure to provide a string in format &#x27;%m/%d/%y %H:%M:%S&#x27;. Full trace:&quot;</span> + <span class="hljs-built_in">str</span>(e))
    temperature_celsius, risk_of_rain, wave_height = get_weather_report_at_coordinates((lon, lat), date_time)
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Weather report for <span class="hljs-subst">{location}</span>, <span class="hljs-subst">{date_time}</span>: Temperature will be <span class="hljs-subst">{temperature_celsius}</span>°C, risk of rain is <span class="hljs-subst">{risk_of_rain*<span class="hljs-number">100</span>:<span class="hljs-number">.0</span>f}</span>%, wave height is <span class="hljs-subst">{wave_height}</span>m.&quot;</span>`,wrap:!1}}),L=new F({props:{title:"给 agent 更多参数",local:"给-agent-更多参数",headingTag:"h3"}}),K=new V({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMy03MEItSW5zdHJ1Y3QlMjIlMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0Rtb2RlbF9pZCklMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMldoeSUyMGRvZXMlMjBNaWtlJTIwbm90JTIwa25vdyUyMG1hbnklMjBwZW9wbGUlMjBpbiUyME5ldyUyMFlvcmslM0YlMjIlMkMlMEElMjAlMjAlMjAlMjBhZGRpdGlvbmFsX2FyZ3MlM0QlN0IlMjJtcDNfc291bmRfZmlsZV91cmwlMjIlM0EnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGdHJhbnNmb3JtZXJzJTJGcmVjb3JkaW5nLm1wMyclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.3-70B-Instruct&quot;</span>

agent = CodeAgent(tools=[], model=InferenceClientModel(model_id=model_id), add_base_tools=<span class="hljs-literal">True</span>)

agent.run(
    <span class="hljs-string">&quot;Why does Mike not know many people in New York?&quot;</span>,
    additional_args={<span class="hljs-string">&quot;mp3_sound_file_url&quot;</span>:<span class="hljs-string">&#x27;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/recording.mp3&#x27;</span>}
)`,wrap:!1}}),Ul=new F({props:{title:"如何调试你的 agent",local:"如何调试你的-agent",headingTag:"h2"}}),Tl=new F({props:{title:"1. 使用更强大的 LLM",local:"1-使用更强大的-llm",headingTag:"h3"}}),Ml=new V({props:{code:"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",highlighted:`==================================================================================================== New task ====================================================================================================
Make me a cool car picture
──────────────────────────────────────────────────────────────────────────────────────────────────── New step ─────────────────────────────────────────────────────────────────────────────────────────────────────
Agent is executing the code below: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
image_generator(prompt=&quot;A cool, futuristic sports car with LED headlights, aerodynamic design, and vibrant color, high-res, photorealistic&quot;)
──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────

Last output from code snippet: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
/var/folders/6m/9b1tts6d5w960j80wbw9tx3m0000gn/T/tmpx09qfsdd/652f0007-3ee9-44e2-94ac-90dae6bb89a4.png
Step 1:

- Time taken: 16.35 seconds
- Input tokens: 1,383
- Output tokens: 77
──────────────────────────────────────────────────────────────────────────────────────────────────── New step ─────────────────────────────────────────────────────────────────────────────────────────────────────
Agent is executing the code below: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
final_answer(&quot;/var/folders/6m/9b1tts6d5w960j80wbw9tx3m0000gn/T/tmpx09qfsdd/652f0007-3ee9-44e2-94ac-90dae6bb89a4.png&quot;)
──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
Print outputs:

Last output from code snippet: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
/var/folders/6m/9b1tts6d5w960j80wbw9tx3m0000gn/T/tmpx09qfsdd/652f0007-3ee9-44e2-94ac-90dae6bb89a4.png
Final answer:
/var/folders/6m/9b1tts6d5w960j80wbw9tx3m0000gn/T/tmpx09qfsdd/652f0007-3ee9-44e2-94ac-90dae6bb89a4.png`,wrap:!1}}),yl=new F({props:{title:"2. 提供更多指导/更多信息",local:"2-提供更多指导更多信息",headingTag:"h3"}}),sl=new F({props:{title:"3. 更改系统提示（通常不建议）",local:"3-更改系统提示通常不建议",headingTag:"h3"}}),Il=new V({props:{code:"cHJpbnQoYWdlbnQucHJvbXB0X3RlbXBsYXRlcyU1QiUyMnN5c3RlbV9wcm9tcHQlMjIlNUQp",highlighted:'<span class="hljs-built_in">print</span>(agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>])',wrap:!1}}),Vl=new V({props:{code:"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",highlighted:`You are an expert assistant who can solve any task using code blobs. You will be given a task to solve as best you can.
To do so, you have been given access to a list of tools: these tools are basically Python functions which you can call with code.
To solve the task, you must plan forward to proceed in a series of steps, in a cycle of &#x27;Thought:&#x27;, &#x27;Code:&#x27;, and &#x27;Observation:&#x27; sequences.

At each step, in the &#x27;Thought:&#x27; sequence, you should first explain your reasoning towards solving the task and the tools that you want to use.
Then in the &#x27;Code:&#x27; sequence, you should write the code in simple Python. The code sequence must end with &#x27;&lt;end_code&gt;&#x27; sequence.
During each intermediate step, you can use &#x27;print()&#x27; to save whatever important information you will then need.
These print outputs will then appear in the &#x27;Observation:&#x27; field, which will be available as input for the next step.
In the end you have to return a final answer using the \`final_answer\` tool.

Here are a few examples using notional tools:
---
Task: &quot;Generate an image of the oldest person in this document.&quot;

Thought: I will proceed step by step and use the following tools: \`document_qa\` to find the oldest person in the document, then \`image_generator\` to generate an image according to the answer.
Code:
\`\`\`py
answer = document_qa(document=document, question=&quot;Who is the oldest person mentioned?&quot;)
print(answer)
\`\`\`&lt;end_code&gt;
Observation: &quot;The oldest person in the document is John Doe, a 55 year old lumberjack living in Newfoundland.&quot;

Thought: I will now generate an image showcasing the oldest person.
Code:
\`\`\`py
image = image_generator(&quot;A portrait of John Doe, a 55-year-old man living in Canada.&quot;)
final_answer(image)
\`\`\`&lt;end_code&gt;

---
Task: &quot;What is the result of the following operation: 5 + 3 + 1294.678?&quot;

Thought: I will use python code to compute the result of the operation and then return the final answer using the \`final_answer\` tool
Code:
\`\`\`py
result = 5 + 3 + 1294.678
final_answer(result)
\`\`\`&lt;end_code&gt;

---
Task:
&quot;Answer the question in the variable \`question\` about the image stored in the variable \`image\`. The question is in French.
You have been provided with these additional arguments, that you can access using the keys as variables in your python code:
{&#x27;question&#x27;: &#x27;Quel est l&#x27;animal sur l&#x27;image?&#x27;, &#x27;image&#x27;: &#x27;path/to/image.jpg&#x27;}&quot;

Thought: I will use the following tools: \`translator\` to translate the question into English and then \`image_qa\` to answer the question on the input image.
Code:
\`\`\`py
translated_question = translator(question=question, src_lang=&quot;French&quot;, tgt_lang=&quot;English&quot;)
print(f&quot;The translated question is {translated_question}.&quot;)
answer = image_qa(image=image, question=translated_question)
final_answer(f&quot;The answer is {answer}&quot;)
\`\`\`&lt;end_code&gt;

---
Task:
In a 1979 interview, Stanislaus Ulam discusses with Martin Sherwin about other great physicists of his time, including Oppenheimer.
What does he say was the consequence of Einstein learning too much math on his creativity, in one word?

Thought: I need to find and read the 1979 interview of Stanislaus Ulam with Martin Sherwin.
Code:
\`\`\`py
pages = search(query=&quot;1979 interview Stanislaus Ulam Martin Sherwin physicists Einstein&quot;)
print(pages)
\`\`\`&lt;end_code&gt;
Observation:
No result found for query &quot;1979 interview Stanislaus Ulam Martin Sherwin physicists Einstein&quot;.

Thought: The query was maybe too restrictive and did not find any results. Let&#x27;s try again with a broader query.
Code:
\`\`\`py
pages = search(query=&quot;1979 interview Stanislaus Ulam&quot;)
print(pages)
\`\`\`&lt;end_code&gt;
Observation:
Found 6 pages:
[Stanislaus Ulam 1979 interview](https://ahf.nuclearmuseum.org/voices/oral-histories/stanislaus-ulams-interview-1979/)

[Ulam discusses Manhattan Project](https://ahf.nuclearmuseum.org/manhattan-project/ulam-manhattan-project/)

(truncated)

Thought: I will read the first 2 pages to know more.
Code:
\`\`\`py
for url in [&quot;https://ahf.nuclearmuseum.org/voices/oral-histories/stanislaus-ulams-interview-1979/&quot;, &quot;https://ahf.nuclearmuseum.org/manhattan-project/ulam-manhattan-project/&quot;]:
    whole_page = visit_webpage(url)
    print(whole_page)
    print(&quot;\\n&quot; + &quot;=&quot;*80 + &quot;\\n&quot;)  # Print separator between pages
\`\`\`&lt;end_code&gt;
Observation:
Manhattan Project Locations:
Los Alamos, NM
Stanislaus Ulam was a Polish-American mathematician. He worked on the Manhattan Project at Los Alamos and later helped design the hydrogen bomb. In this interview, he discusses his work at
(truncated)

Thought: I now have the final answer: from the webpages visited, Stanislaus Ulam says of Einstein: &quot;He learned too much mathematics and sort of diminished, it seems to me personally, it seems to me his purely physics creativity.&quot; Let&#x27;s answer in one word.
Code:
\`\`\`py
final_answer(&quot;diminished&quot;)
\`\`\`&lt;end_code&gt;

---
Task: &quot;Which city has the highest population: Guangzhou or Shanghai?&quot;

Thought: I need to get the populations for both cities and compare them: I will use the tool \`search\` to get the population of both cities.
Code:
\`\`\`py
for city in [&quot;Guangzhou&quot;, &quot;Shanghai&quot;]:
    print(f&quot;Population {city}:&quot;, search(f&quot;{city} population&quot;)
\`\`\`&lt;end_code&gt;
Observation:
Population Guangzhou: [&#x27;Guangzhou has a population of 15 million inhabitants as of 2021.&#x27;]
Population Shanghai: &#x27;26 million (2019)&#x27;

Thought: Now I know that Shanghai has the highest population.
Code:
\`\`\`py
final_answer(&quot;Shanghai&quot;)
\`\`\`&lt;end_code&gt;

---
Task: &quot;What is the current age of the pope, raised to the power 0.36?&quot;

Thought: I will use the tool \`wiki\` to get the age of the pope, and confirm that with a web search.
Code:
\`\`\`py
pope_age_wiki = wiki(query=&quot;current pope age&quot;)
print(&quot;Pope age as per wikipedia:&quot;, pope_age_wiki)
pope_age_search = web_search(query=&quot;current pope age&quot;)
print(&quot;Pope age as per google search:&quot;, pope_age_search)
\`\`\`&lt;end_code&gt;
Observation:
Pope age: &quot;The pope Francis is currently 88 years old.&quot;

Thought: I know that the pope is 88 years old. Let&#x27;s compute the result using python code.
Code:
\`\`\`py
pope_current_age = 88 ** 0.36
final_answer(pope_current_age)
\`\`\`&lt;end_code&gt;

Above example were using notional tools that might not exist for you. On top of performing computations in the Python code snippets that you create, you only have access to these tools:
{%- for tool in tools.values() %}
- {{ tool.to_tool_calling_prompt() }}
{%- endfor %}

{%- if managed_agents and managed_agents.values() | list %}
You can also give tasks to team members.
Calling a team member works similarly to calling a tool: provide the task description as the &#x27;task&#x27; argument. Since this team member is a real human, be as detailed and verbose as necessary in your task description.
You can also include any relevant variables or context using the &#x27;additional_args&#x27; argument.
Here is a list of the team members that you can call:
{%- for agent in managed_agents.values() %}
- {{ agent.name }}: {{ agent.description }}
{%- endfor %}
{%- endif %}

Here are the rules you should always follow to solve your task:
1. Always provide a &#x27;Thought:&#x27; sequence, and a &#x27;Code:\\n\`\`\`py&#x27; sequence ending with &#x27;\`\`\`&lt;end_code&gt;&#x27; sequence, else you will fail.
2. Use only variables that you have defined!
3. Always use the right arguments for the tools. DO NOT pass the arguments as a dict as in &#x27;answer = wiki({&#x27;query&#x27;: &quot;What is the place where James Bond lives?&quot;})&#x27;, but use the arguments directly as in &#x27;answer = wiki(query=&quot;What is the place where James Bond lives?&quot;)&#x27;.
4. Take care to not chain too many sequential tool calls in the same code block, especially when the output format is unpredictable. For instance, a call to search has an unpredictable return format, so do not have another tool call that depends on its output in the same block: rather output results with print() to use them in the next block.
5. Call a tool only when needed, and never re-do a tool call that you previously did with the exact same parameters.
6. Don&#x27;t name any new variable with the same name as a tool: for instance don&#x27;t name a variable &#x27;final_answer&#x27;.
7. Never create any notional variables in our code, as having these in your logs will derail you from the true variables.
8. You can use imports in your code, but only from the following list of modules: {{authorized_imports}}
9. The state persists between code executions: so if in one step you&#x27;ve created variables or imported modules, these will all persist.
10. Don&#x27;t give up! You&#x27;re in charge of solving the task, not providing directions to solve it.

Now Begin! If you solve the task correctly, you will receive a reward of $1,000,000.`,wrap:!1}}),kl=new V({props:{code:"JTdCJTI1LSUyMGZvciUyMHRvb2wlMjBpbiUyMHRvb2xzLnZhbHVlcygpJTIwJTI1JTdEJTBBLSUyMCU3QiU3QiUyMHRvb2wudG9fdG9vbF9jYWxsaW5nX3Byb21wdCgpJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">for</span></span> tool <span class="hljs-keyword">in</span> tools.values() %}</span><span class="language-xml">
- </span><span class="hljs-template-variable">{{ tool.to_tool_calling_prompt() }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span>`,wrap:!1}}),pl=new V({props:{code:"JTdCJTI1LSUyMGlmJTIwbWFuYWdlZF9hZ2VudHMlMjBhbmQlMjBtYW5hZ2VkX2FnZW50cy52YWx1ZXMoKSUyMCU3QyUyMGxpc3QlMjAlMjUlN0QlMEFZb3UlMjBjYW4lMjBhbHNvJTIwZ2l2ZSUyMHRhc2tzJTIwdG8lMjB0ZWFtJTIwbWVtYmVycy4lMEFDYWxsaW5nJTIwYSUyMHRlYW0lMjBtZW1iZXIlMjB3b3JrcyUyMHNpbWlsYXJseSUyMHRvJTIwY2FsbGluZyUyMGElMjB0b29sJTNBJTIwcHJvdmlkZSUyMHRoZSUyMHRhc2slMjBkZXNjcmlwdGlvbiUyMGFzJTIwdGhlJTIwJ3Rhc2snJTIwYXJndW1lbnQuJTIwU2luY2UlMjB0aGlzJTIwdGVhbSUyMG1lbWJlciUyMGlzJTIwYSUyMHJlYWwlMjBodW1hbiUyQyUyMGJlJTIwYXMlMjBkZXRhaWxlZCUyMGFuZCUyMHZlcmJvc2UlMjBhcyUyMG5lY2Vzc2FyeSUyMGluJTIweW91ciUyMHRhc2slMjBkZXNjcmlwdGlvbi4lMEFZb3UlMjBjYW4lMjBhbHNvJTIwaW5jbHVkZSUyMGFueSUyMHJlbGV2YW50JTIwdmFyaWFibGVzJTIwb3IlMjBjb250ZXh0JTIwdXNpbmclMjB0aGUlMjAnYWRkaXRpb25hbF9hcmdzJyUyMGFyZ3VtZW50LiUwQUhlcmUlMjBpcyUyMGElMjBsaXN0JTIwb2YlMjB0aGUlMjB0ZWFtJTIwbWVtYmVycyUyMHRoYXQlMjB5b3UlMjBjYW4lMjBjYWxsJTNBJTBBJTdCJTI1LSUyMGZvciUyMGFnZW50JTIwaW4lMjBtYW5hZ2VkX2FnZW50cy52YWx1ZXMoKSUyMCUyNSU3RCUwQS0lMjAlN0IlN0IlMjBhZ2VudC5uYW1lJTIwJTdEJTdEJTNBJTIwJTdCJTdCJTIwYWdlbnQuZGVzY3JpcHRpb24lMjAlN0QlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdEJTBBJTdCJTI1LSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">if</span> managed_agents <span class="hljs-built_in">and</span> managed_agents.<span class="hljs-built_in">values</span>() | <span class="hljs-keyword">list</span> %}
You can also give tasks <span class="hljs-keyword">to</span> team members.
Calling <span class="hljs-keyword">a</span> team member works similarly <span class="hljs-keyword">to</span> calling <span class="hljs-keyword">a</span> tool: provide the task description <span class="hljs-keyword">as</span> the <span class="hljs-string">&#x27;task&#x27;</span> <span class="hljs-keyword">argument</span>. Since this team member <span class="hljs-keyword">is</span> <span class="hljs-keyword">a</span> real human, <span class="hljs-keyword">be</span> <span class="hljs-keyword">as</span> detailed <span class="hljs-built_in">and</span> <span class="hljs-keyword">verbose</span> <span class="hljs-keyword">as</span> necessary in your task description.
You can also include any relevant variables <span class="hljs-built_in">or</span> context using the <span class="hljs-string">&#x27;additional_args&#x27;</span> <span class="hljs-keyword">argument</span>.
Here <span class="hljs-keyword">is</span> <span class="hljs-keyword">a</span> <span class="hljs-keyword">list</span> of the team members that you can <span class="hljs-keyword">call</span>:
{%- <span class="hljs-keyword">for</span> agent in managed_agents.<span class="hljs-built_in">values</span>() %}
- {{ agent.name }}: {{ agent.description }}
{%- <span class="hljs-keyword">endfor</span> %}
{%- <span class="hljs-keyword">endif</span> %}`,wrap:!1}}),Rl=new V({props:{code:"YWdlbnQucHJvbXB0X3RlbXBsYXRlcyU1QiUyMnN5c3RlbV9wcm9tcHQlMjIlNUQlMjAlM0QlMjBhZ2VudC5wcm9tcHRfdGVtcGxhdGVzJTVCJTIyc3lzdGVtX3Byb21wdCUyMiU1RCUyMCUyQiUyMCUyMiU1Q25IZXJlJTIweW91JTIwZ28hJTIy",highlighted:'agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>] = agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>] + <span class="hljs-string">&quot;\\nHere you go!&quot;</span>',wrap:!1}}),jl=new F({props:{title:"4. 额外规划",local:"4-额外规划",headingTag:"h3"}}),ul=new V({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFdlYlNlYXJjaFRvb2wlMEFmcm9tJTIwZG90ZW52JTIwaW1wb3J0JTIwbG9hZF9kb3RlbnYlMEElMEFsb2FkX2RvdGVudigpJTBBJTBBJTIzJTIwJUU0JUJCJThFJTIwSHViJTIwJUU1JUFGJUJDJUU1JTg1JUE1JUU1JUI3JUE1JUU1JTg1JUI3JTBBaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwbG9hZF90b29sKCUyMm0tcmljJTJGdGV4dC10by1pbWFnZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMFdlYlNlYXJjaFRvb2woKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEJTIyUXdlbiUyRlF3ZW4yLjUtNzJCLUluc3RydWN0JTIyKSUyQyUwQSUyMCUyMCUyMCUyMHBsYW5uaW5nX2ludGVydmFsJTNEMyUyMCUyMyUyMCVFOCVCRiU5OSVFNiU5OCVBRiVFNCVCRCVBMCVFNiVCRiU4MCVFNiVCNCVCQiVFOCVBNyU4NCVFNSU4OCU5MiVFNyU5QSU4NCVFNSU5QyVCMCVFNiU5NiVCOSVFRiVCQyU4MSUwQSklMEElMEElMjMlMjAlRTglQkYlOTAlRTglQTElOEMlRTUlQUUlODMlRUYlQkMlODElMEFyZXN1bHQlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySG93JTIwbG9uZyUyMHdvdWxkJTIwYSUyMGNoZWV0YWglMjBhdCUyMGZ1bGwlMjBzcGVlZCUyMHRha2UlMjB0byUyMHJ1biUyMHRoZSUyMGxlbmd0aCUyMG9mJTIwUG9udCUyMEFsZXhhbmRyZSUyMElJSSUzRiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, InferenceClientModel, WebSearchTool
<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv

load_dotenv()

<span class="hljs-comment"># 从 Hub 导入工具</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

search_tool = WebSearchTool()

agent = CodeAgent(
    tools=[search_tool],
    model=InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>),
    planning_interval=<span class="hljs-number">3</span> <span class="hljs-comment"># 这是你激活规划的地方！</span>
)

<span class="hljs-comment"># 运行它！</span>
result = agent.run(
    <span class="hljs-string">&quot;How long would a cheetah at full speed take to run the length of Pont Alexandre III?&quot;</span>,
)`,wrap:!1}}),Ol=new xT({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/zh/tutorials/building_good_agents.md"}}),{c(){N=e("meta"),h=M(),I=e("p"),Bl=M(),i(R.$$.fragment),Wl=M(),i(c.$$.fragment),Dl=M(),j=e("p"),j.textContent=qU,Yl=M(),i(k.$$.fragment),vl=M(),i(b.$$.fragment),Xl=M(),u=e("p"),u.textContent=LU,Sl=M(),O=e("p"),O.textContent=PU,El=M(),B=e("p"),B.innerHTML=KU,fl=M(),m=e("p"),m.textContent=lT,zl=M(),Q=e("p"),Q.textContent=UT,Hl=M(),G=e("p"),G.textContent=TT,xl=M(),Z=e("ul"),Z.innerHTML=JT,_l=M(),i(r.$$.fragment),$l=M(),A=e("p"),A.textContent=MT,ql=M(),W=e("p"),W.textContent=tT,Ll=M(),D=e("p"),D.textContent=eT,Pl=M(),Y=e("p"),Y.textContent=yT,Kl=M(),v=e("p"),v.textContent=CT,lU=M(),X=e("ul"),X.innerHTML=iT,UU=M(),S=e("p"),S.textContent=aT,TU=M(),E=e("p"),E.textContent=wT,JU=M(),i(f.$$.fragment),MU=M(),z=e("p"),z.textContent=nT,tU=M(),H=e("ul"),H.innerHTML=sT,eU=M(),x=e("p"),x.textContent=oT,yU=M(),_=e("p"),_.textContent=NT,CU=M(),i($.$$.fragment),iU=M(),q=e("p"),q.textContent=IT,aU=M(),i(L.$$.fragment),wU=M(),P=e("p"),P.innerHTML=dT,nU=M(),i(K.$$.fragment),sU=M(),ll=e("p"),ll.innerHTML=VT,oU=M(),i(Ul.$$.fragment),NU=M(),i(Tl.$$.fragment),IU=M(),Jl=e("p"),Jl.innerHTML=gT,dU=M(),i(Ml.$$.fragment),VU=M(),tl=e("p"),tl.textContent=FT,gU=M(),el=e("p"),el.innerHTML=kT,FU=M(),i(yl.$$.fragment),kU=M(),Cl=e("p"),Cl.textContent=pT,pU=M(),il=e("p"),il.textContent=hT,hU=M(),al=e("p"),al.textContent=RT,RU=M(),wl=e("p"),wl.textContent=cT,cU=M(),nl=e("ul"),nl.innerHTML=jT,jU=M(),i(sl.$$.fragment),bU=M(),ol=e("p"),ol.textContent=bT,uU=M(),Nl=e("p"),Nl.innerHTML=uT,OU=M(),i(Il.$$.fragment),BU=M(),dl=e("p"),dl.textContent=OT,mU=M(),i(Vl.$$.fragment),QU=M(),gl=e("p"),gl.innerHTML=BT,GU=M(),Fl=e("p"),Fl.innerHTML=mT,ZU=M(),d=e("ul"),ml=e("li"),fU=AT(`用于插入工具描述。
	`),i(kl.$$.fragment),zU=M(),Ql=e("li"),HU=AT(`用于插入 managed agent 的描述（如果有）。
	`),i(pl.$$.fragment),xU=M(),Gl=e("li"),Gl.innerHTML=QT,rU=M(),hl=e("p"),hl.textContent=GT,AU=M(),i(Rl.$$.fragment),WU=M(),cl=e("p"),cl.innerHTML=ZT,DU=M(),i(jl.$$.fragment),YU=M(),bl=e("p"),bl.textContent=rT,vU=M(),i(ul.$$.fragment),XU=M(),i(Ol.$$.fragment),SU=M(),Zl=e("p"),this.h()},l(l){const U=fT("svelte-u9bgzb",document.head);N=y(U,"META",{name:!0,content:!0}),U.forEach(T),h=t(l),I=y(l,"P",{}),rl(I).forEach(T),Bl=t(l),a(R.$$.fragment,l),Wl=t(l),a(c.$$.fragment,l),Dl=t(l),j=y(l,"P",{"data-svelte-h":!0}),C(j)!=="svelte-1met110"&&(j.textContent=qU),Yl=t(l),a(k.$$.fragment,l),vl=t(l),a(b.$$.fragment,l),Xl=t(l),u=y(l,"P",{"data-svelte-h":!0}),C(u)!=="svelte-a4fgyy"&&(u.textContent=LU),Sl=t(l),O=y(l,"P",{"data-svelte-h":!0}),C(O)!=="svelte-1345c1y"&&(O.textContent=PU),El=t(l),B=y(l,"P",{"data-svelte-h":!0}),C(B)!=="svelte-1jhg7yy"&&(B.innerHTML=KU),fl=t(l),m=y(l,"P",{"data-svelte-h":!0}),C(m)!=="svelte-13yxmi4"&&(m.textContent=lT),zl=t(l),Q=y(l,"P",{"data-svelte-h":!0}),C(Q)!=="svelte-1taokco"&&(Q.textContent=UT),Hl=t(l),G=y(l,"P",{"data-svelte-h":!0}),C(G)!=="svelte-1vu0lf5"&&(G.textContent=TT),xl=t(l),Z=y(l,"UL",{"data-svelte-h":!0}),C(Z)!=="svelte-xxxtf1"&&(Z.innerHTML=JT),_l=t(l),a(r.$$.fragment,l),$l=t(l),A=y(l,"P",{"data-svelte-h":!0}),C(A)!=="svelte-fw1m5"&&(A.textContent=MT),ql=t(l),W=y(l,"P",{"data-svelte-h":!0}),C(W)!=="svelte-vu0a8i"&&(W.textContent=tT),Ll=t(l),D=y(l,"P",{"data-svelte-h":!0}),C(D)!=="svelte-8wvvox"&&(D.textContent=eT),Pl=t(l),Y=y(l,"P",{"data-svelte-h":!0}),C(Y)!=="svelte-xkapbj"&&(Y.textContent=yT),Kl=t(l),v=y(l,"P",{"data-svelte-h":!0}),C(v)!=="svelte-1w674xq"&&(v.textContent=CT),lU=t(l),X=y(l,"UL",{"data-svelte-h":!0}),C(X)!=="svelte-1sman8v"&&(X.innerHTML=iT),UU=t(l),S=y(l,"P",{"data-svelte-h":!0}),C(S)!=="svelte-n1rwv0"&&(S.textContent=aT),TU=t(l),E=y(l,"P",{"data-svelte-h":!0}),C(E)!=="svelte-1e4q4z2"&&(E.textContent=wT),JU=t(l),a(f.$$.fragment,l),MU=t(l),z=y(l,"P",{"data-svelte-h":!0}),C(z)!=="svelte-lt66sa"&&(z.textContent=nT),tU=t(l),H=y(l,"UL",{"data-svelte-h":!0}),C(H)!=="svelte-7zap47"&&(H.innerHTML=sT),eU=t(l),x=y(l,"P",{"data-svelte-h":!0}),C(x)!=="svelte-1tegct6"&&(x.textContent=oT),yU=t(l),_=y(l,"P",{"data-svelte-h":!0}),C(_)!=="svelte-1toua79"&&(_.textContent=NT),CU=t(l),a($.$$.fragment,l),iU=t(l),q=y(l,"P",{"data-svelte-h":!0}),C(q)!=="svelte-16qojp7"&&(q.textContent=IT),aU=t(l),a(L.$$.fragment,l),wU=t(l),P=y(l,"P",{"data-svelte-h":!0}),C(P)!=="svelte-1por9sc"&&(P.innerHTML=dT),nU=t(l),a(K.$$.fragment,l),sU=t(l),ll=y(l,"P",{"data-svelte-h":!0}),C(ll)!=="svelte-19ozoig"&&(ll.innerHTML=VT),oU=t(l),a(Ul.$$.fragment,l),NU=t(l),a(Tl.$$.fragment,l),IU=t(l),Jl=y(l,"P",{"data-svelte-h":!0}),C(Jl)!=="svelte-1xnhysw"&&(Jl.innerHTML=gT),dU=t(l),a(Ml.$$.fragment,l),VU=t(l),tl=y(l,"P",{"data-svelte-h":!0}),C(tl)!=="svelte-16w5zxi"&&(tl.textContent=FT),gU=t(l),el=y(l,"P",{"data-svelte-h":!0}),C(el)!=="svelte-1a1chw0"&&(el.innerHTML=kT),FU=t(l),a(yl.$$.fragment,l),kU=t(l),Cl=y(l,"P",{"data-svelte-h":!0}),C(Cl)!=="svelte-edw9z0"&&(Cl.textContent=pT),pU=t(l),il=y(l,"P",{"data-svelte-h":!0}),C(il)!=="svelte-hr4pfg"&&(il.textContent=hT),hU=t(l),al=y(l,"P",{"data-svelte-h":!0}),C(al)!=="svelte-1y94ft5"&&(al.textContent=RT),RU=t(l),wl=y(l,"P",{"data-svelte-h":!0}),C(wl)!=="svelte-1eencvf"&&(wl.textContent=cT),cU=t(l),nl=y(l,"UL",{"data-svelte-h":!0}),C(nl)!=="svelte-1mggoae"&&(nl.innerHTML=jT),jU=t(l),a(sl.$$.fragment,l),bU=t(l),ol=y(l,"P",{"data-svelte-h":!0}),C(ol)!=="svelte-1py4z0l"&&(ol.textContent=bT),uU=t(l),Nl=y(l,"P",{"data-svelte-h":!0}),C(Nl)!=="svelte-1f0dyjn"&&(Nl.innerHTML=uT),OU=t(l),a(Il.$$.fragment,l),BU=t(l),dl=y(l,"P",{"data-svelte-h":!0}),C(dl)!=="svelte-vw2mzx"&&(dl.textContent=OT),mU=t(l),a(Vl.$$.fragment,l),QU=t(l),gl=y(l,"P",{"data-svelte-h":!0}),C(gl)!=="svelte-1gfvhx6"&&(gl.innerHTML=BT),GU=t(l),Fl=y(l,"P",{"data-svelte-h":!0}),C(Fl)!=="svelte-1ob421r"&&(Fl.innerHTML=mT),ZU=t(l),d=y(l,"UL",{});var g=rl(d);ml=y(g,"LI",{});var _U=rl(ml);fU=WT(_U,`用于插入工具描述。
	`),a(kl.$$.fragment,_U),_U.forEach(T),zU=t(g),Ql=y(g,"LI",{});var $U=rl(Ql);HU=WT($U,`用于插入 managed agent 的描述（如果有）。
	`),a(pl.$$.fragment,$U),$U.forEach(T),xU=t(g),Gl=y(g,"LI",{"data-svelte-h":!0}),C(Gl)!=="svelte-uubaw1"&&(Gl.innerHTML=QT),g.forEach(T),rU=t(l),hl=y(l,"P",{"data-svelte-h":!0}),C(hl)!=="svelte-13uu5v7"&&(hl.textContent=GT),AU=t(l),a(Rl.$$.fragment,l),WU=t(l),cl=y(l,"P",{"data-svelte-h":!0}),C(cl)!=="svelte-h2zgd9"&&(cl.innerHTML=ZT),DU=t(l),a(jl.$$.fragment,l),YU=t(l),bl=y(l,"P",{"data-svelte-h":!0}),C(bl)!=="svelte-7v6ub7"&&(bl.textContent=rT),vU=t(l),a(ul.$$.fragment,l),XU=t(l),a(Ol.$$.fragment,l),SU=t(l),Zl=y(l,"P",{}),rl(Zl).forEach(T),this.h()},h(){DT(N,"name","hf:doc:metadata"),DT(N,"content",qT)},m(l,U){p(document.head,N),J(l,h,U),J(l,I,U),J(l,Bl,U),w(R,l,U),J(l,Wl,U),w(c,l,U),J(l,Dl,U),J(l,j,U),J(l,Yl,U),w(k,l,U),J(l,vl,U),w(b,l,U),J(l,Xl,U),J(l,u,U),J(l,Sl,U),J(l,O,U),J(l,El,U),J(l,B,U),J(l,fl,U),J(l,m,U),J(l,zl,U),J(l,Q,U),J(l,Hl,U),J(l,G,U),J(l,xl,U),J(l,Z,U),J(l,_l,U),w(r,l,U),J(l,$l,U),J(l,A,U),J(l,ql,U),J(l,W,U),J(l,Ll,U),J(l,D,U),J(l,Pl,U),J(l,Y,U),J(l,Kl,U),J(l,v,U),J(l,lU,U),J(l,X,U),J(l,UU,U),J(l,S,U),J(l,TU,U),J(l,E,U),J(l,JU,U),w(f,l,U),J(l,MU,U),J(l,z,U),J(l,tU,U),J(l,H,U),J(l,eU,U),J(l,x,U),J(l,yU,U),J(l,_,U),J(l,CU,U),w($,l,U),J(l,iU,U),J(l,q,U),J(l,aU,U),w(L,l,U),J(l,wU,U),J(l,P,U),J(l,nU,U),w(K,l,U),J(l,sU,U),J(l,ll,U),J(l,oU,U),w(Ul,l,U),J(l,NU,U),w(Tl,l,U),J(l,IU,U),J(l,Jl,U),J(l,dU,U),w(Ml,l,U),J(l,VU,U),J(l,tl,U),J(l,gU,U),J(l,el,U),J(l,FU,U),w(yl,l,U),J(l,kU,U),J(l,Cl,U),J(l,pU,U),J(l,il,U),J(l,hU,U),J(l,al,U),J(l,RU,U),J(l,wl,U),J(l,cU,U),J(l,nl,U),J(l,jU,U),w(sl,l,U),J(l,bU,U),J(l,ol,U),J(l,uU,U),J(l,Nl,U),J(l,OU,U),w(Il,l,U),J(l,BU,U),J(l,dl,U),J(l,mU,U),w(Vl,l,U),J(l,QU,U),J(l,gl,U),J(l,GU,U),J(l,Fl,U),J(l,ZU,U),J(l,d,U),p(d,ml),p(ml,fU),w(kl,ml,null),p(d,zU),p(d,Ql),p(Ql,HU),w(pl,Ql,null),p(d,xU),p(d,Gl),J(l,rU,U),J(l,hl,U),J(l,AU,U),w(Rl,l,U),J(l,WU,U),J(l,cl,U),J(l,DU,U),w(jl,l,U),J(l,YU,U),J(l,bl,U),J(l,vU,U),w(ul,l,U),J(l,XU,U),w(Ol,l,U),J(l,SU,U),J(l,Zl,U),EU=!0},p(l,[U]){const g={};U&2&&(g.$$scope={dirty:U,ctx:l}),k.$set(g)},i(l){EU||(n(R.$$.fragment,l),n(c.$$.fragment,l),n(k.$$.fragment,l),n(b.$$.fragment,l),n(r.$$.fragment,l),n(f.$$.fragment,l),n($.$$.fragment,l),n(L.$$.fragment,l),n(K.$$.fragment,l),n(Ul.$$.fragment,l),n(Tl.$$.fragment,l),n(Ml.$$.fragment,l),n(yl.$$.fragment,l),n(sl.$$.fragment,l),n(Il.$$.fragment,l),n(Vl.$$.fragment,l),n(kl.$$.fragment,l),n(pl.$$.fragment,l),n(Rl.$$.fragment,l),n(jl.$$.fragment,l),n(ul.$$.fragment,l),n(Ol.$$.fragment,l),EU=!0)},o(l){s(R.$$.fragment,l),s(c.$$.fragment,l),s(k.$$.fragment,l),s(b.$$.fragment,l),s(r.$$.fragment,l),s(f.$$.fragment,l),s($.$$.fragment,l),s(L.$$.fragment,l),s(K.$$.fragment,l),s(Ul.$$.fragment,l),s(Tl.$$.fragment,l),s(Ml.$$.fragment,l),s(yl.$$.fragment,l),s(sl.$$.fragment,l),s(Il.$$.fragment,l),s(Vl.$$.fragment,l),s(kl.$$.fragment,l),s(pl.$$.fragment,l),s(Rl.$$.fragment,l),s(jl.$$.fragment,l),s(ul.$$.fragment,l),s(Ol.$$.fragment,l),EU=!1},d(l){l&&(T(h),T(I),T(Bl),T(Wl),T(Dl),T(j),T(Yl),T(vl),T(Xl),T(u),T(Sl),T(O),T(El),T(B),T(fl),T(m),T(zl),T(Q),T(Hl),T(G),T(xl),T(Z),T(_l),T($l),T(A),T(ql),T(W),T(Ll),T(D),T(Pl),T(Y),T(Kl),T(v),T(lU),T(X),T(UU),T(S),T(TU),T(E),T(JU),T(MU),T(z),T(tU),T(H),T(eU),T(x),T(yU),T(_),T(CU),T(iU),T(q),T(aU),T(wU),T(P),T(nU),T(sU),T(ll),T(oU),T(NU),T(IU),T(Jl),T(dU),T(VU),T(tl),T(gU),T(el),T(FU),T(kU),T(Cl),T(pU),T(il),T(hU),T(al),T(RU),T(wl),T(cU),T(nl),T(jU),T(bU),T(ol),T(uU),T(Nl),T(OU),T(BU),T(dl),T(mU),T(QU),T(gl),T(GU),T(Fl),T(ZU),T(d),T(rU),T(hl),T(AU),T(WU),T(cl),T(DU),T(YU),T(bl),T(vU),T(XU),T(SU),T(Zl)),T(N),o(R,l),o(c,l),o(k,l),o(b,l),o(r,l),o(f,l),o($,l),o(L,l),o(K,l),o(Ul,l),o(Tl,l),o(Ml,l),o(yl,l),o(sl,l),o(Il,l),o(Vl,l),o(kl),o(pl),o(Rl,l),o(jl,l),o(ul,l),o(Ol,l)}}}const qT='{"title":"构建好用的 agent","local":"构建好用的-agent","sections":[{"title":"最好的 agent 系统是最简单的：尽可能简化工作流","local":"最好的-agent-系统是最简单的尽可能简化工作流","sections":[],"depth":3},{"title":"改善流向 LLM 引擎的信息流","local":"改善流向-llm-引擎的信息流","sections":[],"depth":3},{"title":"给 agent 更多参数","local":"给-agent-更多参数","sections":[],"depth":3},{"title":"如何调试你的 agent","local":"如何调试你的-agent","sections":[{"title":"1. 使用更强大的 LLM","local":"1-使用更强大的-llm","sections":[],"depth":3},{"title":"2. 提供更多指导/更多信息","local":"2-提供更多指导更多信息","sections":[],"depth":3},{"title":"3. 更改系统提示（通常不建议）","local":"3-更改系统提示通常不建议","sections":[],"depth":3},{"title":"4. 额外规划","local":"4-额外规划","sections":[],"depth":3}],"depth":2}],"depth":1}';function LT(Al){return vT(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class MJ extends ST{constructor(N){super(),ET(this,N,LT,$T,YT,{})}}export{MJ as component};
