import{s as He,o as Ye}from"../chunks/scheduler.37c15a92.js";import{S as Qe,i as Fe,g as M,s as n,r as p,A as _e,h as c,f as l,c as a,j as Ce,u as i,x as h,k as Ne,y as Ae,a as s,v as o,d as r,t as m,w as u}from"../chunks/index.7cb9c9b8.js";import{C as y}from"../chunks/CodeBlock.abae2786.js";import{C as De}from"../chunks/CourseFloatingBanner.df82c153.js";import{F as Pe}from"../chunks/FrameworkSwitchCourse.97630871.js";import{H as $e,E as Le}from"../chunks/getInferenceSnippets.b56d4d4c.js";function Ke(Ze){let d,_,w,A,b,P,J,L,j,K,T,ke="In the last few sections, we’ve been trying our best to do most of the work by hand. We’ve explored how tokenizers work and looked at tokenization, conversion to input IDs, padding, truncation, and attention masks.",O,f,Ve="However, as we saw in section 2, the 🤗 Transformers API can handle all of this for us with a high-level function that we’ll dive into here. When you call your <code>tokenizer</code> directly on the sentence, you get back inputs that are ready to pass through your model:",ee,I,te,U,We="Here, the <code>model_inputs</code> variable contains everything that’s necessary for a model to operate well. For DistilBERT, that includes the input IDs as well as the attention mask. Other models that accept additional inputs will also have those output by the <code>tokenizer</code> object.",le,g,Be="As we’ll see in some examples below, this method is very powerful. First, it can tokenize a single sequence:",se,Z,ne,$,xe="It also handles multiple sequences at a time, with no change in the API:",ae,k,pe,V,ve="It can pad according to several objectives:",ie,W,oe,B,Xe="It can also truncate sequences:",re,x,me,v,ze="The <code>tokenizer</code> object can handle the conversion to specific framework tensors, which can then be directly sent to the model. For example, in the following code sample we are prompting the tokenizer to return tensors from the different frameworks — <code>&quot;pt&quot;</code> returns PyTorch tensors and <code>&quot;np&quot;</code> returns NumPy arrays:",ue,X,Me,z,ce,S,Se="If we take a look at the input IDs returned by the tokenizer, we will see they are a tiny bit different from what we had earlier:",he,G,ye,E,de,q,Ge="One token ID was added at the beginning, and one at the end. Let’s decode the two sequences of IDs above to see what this is about:",we,R,be,C,Je,N,Ee="The tokenizer added the special word <code>[CLS]</code> at the beginning and the special word <code>[SEP]</code> at the end. This is because the model was pretrained with those, so to get the same results for inference we need to add them as well. Note that some models don’t add special words, or add different ones; models may also add these special words only at the beginning, or only at the end. In any case, the tokenizer knows which ones are expected and will deal with this for you.",je,H,Te,Y,qe="Now that we’ve seen all the individual steps the <code>tokenizer</code> object uses when applied on texts, let’s see one final time how it can handle multiple sequences (padding!), very long sequences (truncation!), and multiple types of tensors with its main API:",fe,Q,Ie,F,Ue,D,ge;return b=new Pe({props:{fw:Ze[0]}}),J=new $e({props:{title:"Putting it all together",local:"putting-it-all-together",headingTag:"h1"}}),j=new De({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter2/section6_pt.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter2/section6_pt.ipynb"}]}}),I=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQXNlcXVlbmNlJTIwJTNEJTIwJTIySSd2ZSUyMGJlZW4lMjB3YWl0aW5nJTIwZm9yJTIwYSUyMEh1Z2dpbmdGYWNlJTIwY291cnNlJTIwbXklMjB3aG9sZSUyMGxpZmUuJTIyJTBBJTBBbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHNlcXVlbmNlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)

sequence = <span class="hljs-string">&quot;I&#x27;ve been waiting for a HuggingFace course my whole life.&quot;</span>

model_inputs = tokenizer(sequence)`,wrap:!1}}),Z=new y({props:{code:"c2VxdWVuY2UlMjAlM0QlMjAlMjJJJ3ZlJTIwYmVlbiUyMHdhaXRpbmclMjBmb3IlMjBhJTIwSHVnZ2luZ0ZhY2UlMjBjb3Vyc2UlMjBteSUyMHdob2xlJTIwbGlmZS4lMjIlMEElMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoc2VxdWVuY2Up",highlighted:`sequence = <span class="hljs-string">&quot;I&#x27;ve been waiting for a HuggingFace course my whole life.&quot;</span>

model_inputs = tokenizer(sequence)`,wrap:!1}}),k=new y({props:{code:"c2VxdWVuY2VzJTIwJTNEJTIwJTVCJTIySSd2ZSUyMGJlZW4lMjB3YWl0aW5nJTIwZm9yJTIwYSUyMEh1Z2dpbmdGYWNlJTIwY291cnNlJTIwbXklMjB3aG9sZSUyMGxpZmUuJTIyJTJDJTIwJTIyU28lMjBoYXZlJTIwSSElMjIlNUQlMEElMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoc2VxdWVuY2VzKQ==",highlighted:`sequences = [<span class="hljs-string">&quot;I&#x27;ve been waiting for a HuggingFace course my whole life.&quot;</span>, <span class="hljs-string">&quot;So have I!&quot;</span>]

model_inputs = tokenizer(sequences)`,wrap:!1}}),W=new y({props:{code:"JTIzJTIwV2lsbCUyMHBhZCUyMHRoZSUyMHNlcXVlbmNlcyUyMHVwJTIwdG8lMjB0aGUlMjBtYXhpbXVtJTIwc2VxdWVuY2UlMjBsZW5ndGglMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoc2VxdWVuY2VzJTJDJTIwcGFkZGluZyUzRCUyMmxvbmdlc3QlMjIpJTBBJTBBJTIzJTIwV2lsbCUyMHBhZCUyMHRoZSUyMHNlcXVlbmNlcyUyMHVwJTIwdG8lMjB0aGUlMjBtb2RlbCUyMG1heCUyMGxlbmd0aCUwQSUyMyUyMCg1MTIlMjBmb3IlMjBCRVJUJTIwb3IlMjBEaXN0aWxCRVJUKSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplcihzZXF1ZW5jZXMlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiklMEElMEElMjMlMjBXaWxsJTIwcGFkJTIwdGhlJTIwc2VxdWVuY2VzJTIwdXAlMjB0byUyMHRoZSUyMHNwZWNpZmllZCUyMG1heCUyMGxlbmd0aCUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplcihzZXF1ZW5jZXMlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMG1heF9sZW5ndGglM0Q4KQ==",highlighted:`<span class="hljs-comment"># Will pad the sequences up to the maximum sequence length</span>
model_inputs = tokenizer(sequences, padding=<span class="hljs-string">&quot;longest&quot;</span>)

<span class="hljs-comment"># Will pad the sequences up to the model max length</span>
<span class="hljs-comment"># (512 for BERT or DistilBERT)</span>
model_inputs = tokenizer(sequences, padding=<span class="hljs-string">&quot;max_length&quot;</span>)

<span class="hljs-comment"># Will pad the sequences up to the specified max length</span>
model_inputs = tokenizer(sequences, padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=<span class="hljs-number">8</span>)`,wrap:!1}}),x=new y({props:{code:"c2VxdWVuY2VzJTIwJTNEJTIwJTVCJTIySSd2ZSUyMGJlZW4lMjB3YWl0aW5nJTIwZm9yJTIwYSUyMEh1Z2dpbmdGYWNlJTIwY291cnNlJTIwbXklMjB3aG9sZSUyMGxpZmUuJTIyJTJDJTIwJTIyU28lMjBoYXZlJTIwSSElMjIlNUQlMEElMEElMjMlMjBXaWxsJTIwdHJ1bmNhdGUlMjB0aGUlMjBzZXF1ZW5jZXMlMjB0aGF0JTIwYXJlJTIwbG9uZ2VyJTIwdGhhbiUyMHRoZSUyMG1vZGVsJTIwbWF4JTIwbGVuZ3RoJTBBJTIzJTIwKDUxMiUyMGZvciUyMEJFUlQlMjBvciUyMERpc3RpbEJFUlQpJTBBbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHNlcXVlbmNlcyUyQyUyMHRydW5jYXRpb24lM0RUcnVlKSUwQSUwQSUyMyUyMFdpbGwlMjB0cnVuY2F0ZSUyMHRoZSUyMHNlcXVlbmNlcyUyMHRoYXQlMjBhcmUlMjBsb25nZXIlMjB0aGFuJTIwdGhlJTIwc3BlY2lmaWVkJTIwbWF4JTIwbGVuZ3RoJTBBbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHNlcXVlbmNlcyUyQyUyMG1heF9sZW5ndGglM0Q4JTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUp",highlighted:`sequences = [<span class="hljs-string">&quot;I&#x27;ve been waiting for a HuggingFace course my whole life.&quot;</span>, <span class="hljs-string">&quot;So have I!&quot;</span>]

<span class="hljs-comment"># Will truncate the sequences that are longer than the model max length</span>
<span class="hljs-comment"># (512 for BERT or DistilBERT)</span>
model_inputs = tokenizer(sequences, truncation=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Will truncate the sequences that are longer than the specified max length</span>
model_inputs = tokenizer(sequences, max_length=<span class="hljs-number">8</span>, truncation=<span class="hljs-literal">True</span>)`,wrap:!1}}),X=new y({props:{code:"c2VxdWVuY2VzJTIwJTNEJTIwJTVCJTIySSd2ZSUyMGJlZW4lMjB3YWl0aW5nJTIwZm9yJTIwYSUyMEh1Z2dpbmdGYWNlJTIwY291cnNlJTIwbXklMjB3aG9sZSUyMGxpZmUuJTIyJTJDJTIwJTIyU28lMjBoYXZlJTIwSSElMjIlNUQlMEElMEElMjMlMjBSZXR1cm5zJTIwUHlUb3JjaCUyMHRlbnNvcnMlMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoc2VxdWVuY2VzJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFJldHVybnMlMjBOdW1QeSUyMGFycmF5cyUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplcihzZXF1ZW5jZXMlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIp",highlighted:`sequences = [<span class="hljs-string">&quot;I&#x27;ve been waiting for a HuggingFace course my whole life.&quot;</span>, <span class="hljs-string">&quot;So have I!&quot;</span>]

<span class="hljs-comment"># Returns PyTorch tensors</span>
model_inputs = tokenizer(sequences, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-comment"># Returns NumPy arrays</span>
model_inputs = tokenizer(sequences, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)`,wrap:!1}}),z=new $e({props:{title:"Special tokens",local:"special-tokens",headingTag:"h2"}}),G=new y({props:{code:"c2VxdWVuY2UlMjAlM0QlMjAlMjJJJ3ZlJTIwYmVlbiUyMHdhaXRpbmclMjBmb3IlMjBhJTIwSHVnZ2luZ0ZhY2UlMjBjb3Vyc2UlMjBteSUyMHdob2xlJTIwbGlmZS4lMjIlMEElMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoc2VxdWVuY2UpJTBBcHJpbnQobW9kZWxfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQSUwQXRva2VucyUyMCUzRCUyMHRva2VuaXplci50b2tlbml6ZShzZXF1ZW5jZSklMEFpZHMlMjAlM0QlMjB0b2tlbml6ZXIuY29udmVydF90b2tlbnNfdG9faWRzKHRva2VucyklMEFwcmludChpZHMp",highlighted:`sequence = <span class="hljs-string">&quot;I&#x27;ve been waiting for a HuggingFace course my whole life.&quot;</span>

model_inputs = tokenizer(sequence)
<span class="hljs-built_in">print</span>(model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])

tokens = tokenizer.tokenize(sequence)
ids = tokenizer.convert_tokens_to_ids(tokens)
<span class="hljs-built_in">print</span>(ids)`,wrap:!1}}),E=new y({props:{code:"JTVCMTAxJTJDJTIwMTA0NSUyQyUyMDEwMDUlMkMlMjAyMzEwJTJDJTIwMjA0MiUyQyUyMDM0MDMlMkMlMjAyMDA1JTJDJTIwMTAzNyUyQyUyMDE3NjYyJTJDJTIwMTIxNzIlMkMlMjAyNjA3JTJDJTIwMjAyNiUyQyUyMDI4NzglMkMlMjAyMTY2JTJDJTIwMTAxMiUyQyUyMDEwMiU1RCUwQSU1QjEwNDUlMkMlMjAxMDA1JTJDJTIwMjMxMCUyQyUyMDIwNDIlMkMlMjAzNDAzJTJDJTIwMjAwNSUyQyUyMDEwMzclMkMlMjAxNzY2MiUyQyUyMDEyMTcyJTJDJTIwMjYwNyUyQyUyMDIwMjYlMkMlMjAyODc4JTJDJTIwMjE2NiUyQyUyMDEwMTIlNUQ=",highlighted:`[<span class="hljs-number">101</span>, <span class="hljs-number">1045</span>, <span class="hljs-number">1005</span>, <span class="hljs-number">2310</span>, <span class="hljs-number">2042</span>, <span class="hljs-number">3403</span>, <span class="hljs-number">2005</span>, <span class="hljs-number">1037</span>, <span class="hljs-number">17662</span>, <span class="hljs-number">12172</span>, <span class="hljs-number">2607</span>, <span class="hljs-number">2026</span>, <span class="hljs-number">2878</span>, <span class="hljs-number">2166</span>, <span class="hljs-number">1012</span>, <span class="hljs-number">102</span>]
[<span class="hljs-number">1045</span>, <span class="hljs-number">1005</span>, <span class="hljs-number">2310</span>, <span class="hljs-number">2042</span>, <span class="hljs-number">3403</span>, <span class="hljs-number">2005</span>, <span class="hljs-number">1037</span>, <span class="hljs-number">17662</span>, <span class="hljs-number">12172</span>, <span class="hljs-number">2607</span>, <span class="hljs-number">2026</span>, <span class="hljs-number">2878</span>, <span class="hljs-number">2166</span>, <span class="hljs-number">1012</span>]`,wrap:!1}}),R=new y({props:{code:"cHJpbnQodG9rZW5pemVyLmRlY29kZShtb2RlbF9pbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUoaWRzKSk=",highlighted:`<span class="hljs-built_in">print</span>(tokenizer.decode(model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>]))
<span class="hljs-built_in">print</span>(tokenizer.decode(ids))`,wrap:!1}}),C=new y({props:{code:"JTIyJTVCQ0xTJTVEJTIwaSd2ZSUyMGJlZW4lMjB3YWl0aW5nJTIwZm9yJTIwYSUyMGh1Z2dpbmdmYWNlJTIwY291cnNlJTIwbXklMjB3aG9sZSUyMGxpZmUuJTIwJTVCU0VQJTVEJTIyJTBBJTIyaSd2ZSUyMGJlZW4lMjB3YWl0aW5nJTIwZm9yJTIwYSUyMGh1Z2dpbmdmYWNlJTIwY291cnNlJTIwbXklMjB3aG9sZSUyMGxpZmUuJTIy",highlighted:`<span class="hljs-string">&quot;[CLS] i&#x27;ve been waiting for a huggingface course my whole life. [SEP]&quot;</span>
<span class="hljs-string">&quot;i&#x27;ve been waiting for a huggingface course my whole life.&quot;</span>`,wrap:!1}}),H=new $e({props:{title:"Wrapping up: From tokenizer to model",local:"wrapping-up-from-tokenizer-to-model",headingTag:"h2"}}),Q=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFzZXF1ZW5jZXMlMjAlM0QlMjAlNUIlMjJJJ3ZlJTIwYmVlbiUyMHdhaXRpbmclMjBmb3IlMjBhJTIwSHVnZ2luZ0ZhY2UlMjBjb3Vyc2UlMjBteSUyMHdob2xlJTIwbGlmZS4lMjIlMkMlMjAlMjJTbyUyMGhhdmUlMjBJISUyMiU1RCUwQSUwQXRva2VucyUyMCUzRCUyMHRva2VuaXplcihzZXF1ZW5jZXMlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXQlMjAlM0QlMjBtb2RlbCgqKnRva2Vucyk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSequenceClassification

checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint)
sequences = [<span class="hljs-string">&quot;I&#x27;ve been waiting for a HuggingFace course my whole life.&quot;</span>, <span class="hljs-string">&quot;So have I!&quot;</span>]

tokens = tokenizer(sequences, padding=<span class="hljs-literal">True</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
output = model(**tokens)`,wrap:!1}}),F=new Le({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter2/6.mdx"}}),{c(){d=M("meta"),_=n(),w=M("p"),A=n(),p(b.$$.fragment),P=n(),p(J.$$.fragment),L=n(),p(j.$$.fragment),K=n(),T=M("p"),T.textContent=ke,O=n(),f=M("p"),f.innerHTML=Ve,ee=n(),p(I.$$.fragment),te=n(),U=M("p"),U.innerHTML=We,le=n(),g=M("p"),g.textContent=Be,se=n(),p(Z.$$.fragment),ne=n(),$=M("p"),$.textContent=xe,ae=n(),p(k.$$.fragment),pe=n(),V=M("p"),V.textContent=ve,ie=n(),p(W.$$.fragment),oe=n(),B=M("p"),B.textContent=Xe,re=n(),p(x.$$.fragment),me=n(),v=M("p"),v.innerHTML=ze,ue=n(),p(X.$$.fragment),Me=n(),p(z.$$.fragment),ce=n(),S=M("p"),S.textContent=Se,he=n(),p(G.$$.fragment),ye=n(),p(E.$$.fragment),de=n(),q=M("p"),q.textContent=Ge,we=n(),p(R.$$.fragment),be=n(),p(C.$$.fragment),Je=n(),N=M("p"),N.innerHTML=Ee,je=n(),p(H.$$.fragment),Te=n(),Y=M("p"),Y.innerHTML=qe,fe=n(),p(Q.$$.fragment),Ie=n(),p(F.$$.fragment),Ue=n(),D=M("p"),this.h()},l(e){const t=_e("svelte-u9bgzb",document.head);d=c(t,"META",{name:!0,content:!0}),t.forEach(l),_=a(e),w=c(e,"P",{}),Ce(w).forEach(l),A=a(e),i(b.$$.fragment,e),P=a(e),i(J.$$.fragment,e),L=a(e),i(j.$$.fragment,e),K=a(e),T=c(e,"P",{"data-svelte-h":!0}),h(T)!=="svelte-8x3t43"&&(T.textContent=ke),O=a(e),f=c(e,"P",{"data-svelte-h":!0}),h(f)!=="svelte-1m0etnl"&&(f.innerHTML=Ve),ee=a(e),i(I.$$.fragment,e),te=a(e),U=c(e,"P",{"data-svelte-h":!0}),h(U)!=="svelte-1ppe5qh"&&(U.innerHTML=We),le=a(e),g=c(e,"P",{"data-svelte-h":!0}),h(g)!=="svelte-y34ype"&&(g.textContent=Be),se=a(e),i(Z.$$.fragment,e),ne=a(e),$=c(e,"P",{"data-svelte-h":!0}),h($)!=="svelte-164017d"&&($.textContent=xe),ae=a(e),i(k.$$.fragment,e),pe=a(e),V=c(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-lvhia5"&&(V.textContent=ve),ie=a(e),i(W.$$.fragment,e),oe=a(e),B=c(e,"P",{"data-svelte-h":!0}),h(B)!=="svelte-rx5s8"&&(B.textContent=Xe),re=a(e),i(x.$$.fragment,e),me=a(e),v=c(e,"P",{"data-svelte-h":!0}),h(v)!=="svelte-17mlhci"&&(v.innerHTML=ze),ue=a(e),i(X.$$.fragment,e),Me=a(e),i(z.$$.fragment,e),ce=a(e),S=c(e,"P",{"data-svelte-h":!0}),h(S)!=="svelte-1tipyqt"&&(S.textContent=Se),he=a(e),i(G.$$.fragment,e),ye=a(e),i(E.$$.fragment,e),de=a(e),q=c(e,"P",{"data-svelte-h":!0}),h(q)!=="svelte-s6ie2x"&&(q.textContent=Ge),we=a(e),i(R.$$.fragment,e),be=a(e),i(C.$$.fragment,e),Je=a(e),N=c(e,"P",{"data-svelte-h":!0}),h(N)!=="svelte-yfjwtr"&&(N.innerHTML=Ee),je=a(e),i(H.$$.fragment,e),Te=a(e),Y=c(e,"P",{"data-svelte-h":!0}),h(Y)!=="svelte-mudtzg"&&(Y.innerHTML=qe),fe=a(e),i(Q.$$.fragment,e),Ie=a(e),i(F.$$.fragment,e),Ue=a(e),D=c(e,"P",{}),Ce(D).forEach(l),this.h()},h(){Ne(d,"name","hf:doc:metadata"),Ne(d,"content",Oe)},m(e,t){Ae(document.head,d),s(e,_,t),s(e,w,t),s(e,A,t),o(b,e,t),s(e,P,t),o(J,e,t),s(e,L,t),o(j,e,t),s(e,K,t),s(e,T,t),s(e,O,t),s(e,f,t),s(e,ee,t),o(I,e,t),s(e,te,t),s(e,U,t),s(e,le,t),s(e,g,t),s(e,se,t),o(Z,e,t),s(e,ne,t),s(e,$,t),s(e,ae,t),o(k,e,t),s(e,pe,t),s(e,V,t),s(e,ie,t),o(W,e,t),s(e,oe,t),s(e,B,t),s(e,re,t),o(x,e,t),s(e,me,t),s(e,v,t),s(e,ue,t),o(X,e,t),s(e,Me,t),o(z,e,t),s(e,ce,t),s(e,S,t),s(e,he,t),o(G,e,t),s(e,ye,t),o(E,e,t),s(e,de,t),s(e,q,t),s(e,we,t),o(R,e,t),s(e,be,t),o(C,e,t),s(e,Je,t),s(e,N,t),s(e,je,t),o(H,e,t),s(e,Te,t),s(e,Y,t),s(e,fe,t),o(Q,e,t),s(e,Ie,t),o(F,e,t),s(e,Ue,t),s(e,D,t),ge=!0},p(e,[t]){const Re={};t&1&&(Re.fw=e[0]),b.$set(Re)},i(e){ge||(r(b.$$.fragment,e),r(J.$$.fragment,e),r(j.$$.fragment,e),r(I.$$.fragment,e),r(Z.$$.fragment,e),r(k.$$.fragment,e),r(W.$$.fragment,e),r(x.$$.fragment,e),r(X.$$.fragment,e),r(z.$$.fragment,e),r(G.$$.fragment,e),r(E.$$.fragment,e),r(R.$$.fragment,e),r(C.$$.fragment,e),r(H.$$.fragment,e),r(Q.$$.fragment,e),r(F.$$.fragment,e),ge=!0)},o(e){m(b.$$.fragment,e),m(J.$$.fragment,e),m(j.$$.fragment,e),m(I.$$.fragment,e),m(Z.$$.fragment,e),m(k.$$.fragment,e),m(W.$$.fragment,e),m(x.$$.fragment,e),m(X.$$.fragment,e),m(z.$$.fragment,e),m(G.$$.fragment,e),m(E.$$.fragment,e),m(R.$$.fragment,e),m(C.$$.fragment,e),m(H.$$.fragment,e),m(Q.$$.fragment,e),m(F.$$.fragment,e),ge=!1},d(e){e&&(l(_),l(w),l(A),l(P),l(L),l(K),l(T),l(O),l(f),l(ee),l(te),l(U),l(le),l(g),l(se),l(ne),l($),l(ae),l(pe),l(V),l(ie),l(oe),l(B),l(re),l(me),l(v),l(ue),l(Me),l(ce),l(S),l(he),l(ye),l(de),l(q),l(we),l(be),l(Je),l(N),l(je),l(Te),l(Y),l(fe),l(Ie),l(Ue),l(D)),l(d),u(b,e),u(J,e),u(j,e),u(I,e),u(Z,e),u(k,e),u(W,e),u(x,e),u(X,e),u(z,e),u(G,e),u(E,e),u(R,e),u(C,e),u(H,e),u(Q,e),u(F,e)}}}const Oe='{"title":"Putting it all together","local":"putting-it-all-together","sections":[{"title":"Special tokens","local":"special-tokens","sections":[],"depth":2},{"title":"Wrapping up: From tokenizer to model","local":"wrapping-up-from-tokenizer-to-model","sections":[],"depth":2}],"depth":1}';function et(Ze,d,_){let w="pt";return Ye(()=>{const A=new URLSearchParams(window.location.search);_(0,w=A.get("fw")||"pt")}),[w]}class it extends Qe{constructor(d){super(),Fe(this,d,et,Ke,He,{})}}export{it as component};
