import{s as El,f as tl,n as Hl,o as Wl}from"../chunks/scheduler.37c15a92.js";import{S as Rl,i as Ll,g as i,s as a,r as y,A as Ql,h as p,f as t,c as n,j as re,u as m,x as o,k as r,y as Nl,a as s,v as d,d as w,t as T,w as j}from"../chunks/index.2bf4358c.js";import{C as sl}from"../chunks/CodeBlock.4e987730.js";import{D as Sl}from"../chunks/DocNotebookDropdown.efc1fb7c.js";import{H as ie,E as Vl}from"../chunks/getInferenceSnippets.97e75ee2.js";function Xl(al){let J,Me,pe,ce,f,ue,U,ye,h,nl="在这一节中，我们将更详细地了解 <code>Interface</code> 类，并理解创建 Interface 时使用的主要参数的含义和设置方法。",me,b,de,I,il="你会注意到 <code>Interface</code> 类有 3 个必需参数： <code>Interface(fn, inputs, outputs, ...)</code>",we,C,pl="这些参数的含义是：",Te,v,ol="<li><code>fn</code> ：由 Gradio 接口包装的预测函数。该函数可以接受一个或多个参数并返回一个或多个值</li> <li><code>inputs</code> ：输入组件类型。Gradio 提供了许多预构建的组件，例如 <code>image</code> 或 <code>mic</code> 。</li> <li><code>outputs</code> ：输出组件类型。同样，Gradio 提供了许多预构建的组件，例如 <code>image</code> 或 <code>label</code> 。</li>",je,k,rl='可以使用组件的完整列表请参阅 <a href="https://gradio.app/docs" rel="nofollow">Gradio 文档</a> 。每个预构建的组件都可以通过实例化该组件对应的类来定制。',Je,g,Ml='例如，正如我们在 <a href="/course/chapter9/2">前一小节</a> 中看到的，你可以将一个 <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> 组件传递给 <code>inputs</code> 参数，而不是将 <code>&quot;textbox&quot;</code> 以字符串形式传递进去，这样就可以创建一个 7 行并包含一个标签的文本框。',fe,A,cl="让我们看另一个例子，这个例子使用了 <code>Audio</code> 组件。",Ue,$,he,x,ul="如前所述，Gradio 提供了许多不同的输入和输出组件。因此，让我们构建一个适用于音频的 <code>Interface</code> 。",be,G,yl="在这个例子中，我们将构建一个输入和输出都是音频的函数，它可以接收一个音频文件后将其反转并返回。",Ie,B,ml="我们将使用 <code>Audio</code> 组件作为输入。使用 <code>Audio</code> 组件时，你可以通过 <code>source</code> 指定输入音频的方式是上传的音频文件还是通过麦克风实时录制的声音。在这个例子中，让我们将其设置为“麦克风”。为了让交互更加友好，我们会在我们的 <code>Audio</code> 上添加一个标签，上面写着“Speak here.”。",Ce,Z,dl="此外，我们希望函数接收的音频是 <code>numpy</code> 数组格式，这样我们可以轻松地“反转”它。因此我们将 <code>&quot;type&quot;</code> 设置为 <code>&quot;numpy&quot;</code> ，它会将传递输入 data 转换为 <code>(sample_rate,data)</code> 的元组输入到我们的函数。",ve,_,wl="我们还将使用 <code>Audio</code> 作为输出组件，它可以自动将根据采样率和音频数据将 numpy 数组渲染为可播放的音频文件。因此，在这个例子中不需要对输出组件进行修改，只需要传递一个 <code>&quot;audio&quot;</code> 字符串。",ke,q,ge,E,Tl='上面的代码将生成一个如下所示的界面（如果你的浏览器没有要求你授权麦克风权限，请在 <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">新标签页中打开演示</a>。）',Ae,M,jl,$e,H,Jl="现在你可以录制你的声音并听到倒放的音频了 - 太神奇了 👻！",xe,W,Ge,R,fl="假设我们有一个更复杂的预测函数，有多个输入和输出。在下面的示例中，我我们有一个函数，它接收一个下拉框索引、一个滑块值和一个数字，并返回一个特定音调的音频样本。",Be,L,Ul="让我们看看该如何传递输入和输出组件列表，看看你能不能理解他们。",Ze,Q,hl="关键要传递：",_e,N,bl="<li>输入组件列表，每个组件依次对应一个参数。</li> <li>输出组件列表，每个组件对应一个返回值。</li>",qe,S,Il="下面的代码片段显示了三个输入组件如何与 <code>generate_tone()</code> 函数的三个参数一一对齐：",Ee,V,He,c,Cl,We,X,Re,Y,vl="到目前为止，我们已经使用了 <code>launch()</code> 方法来启动界面，但是我们还没有真正讨论过它的作用。",Le,P,kl="默认情况下， <code>launch()</code> 方法将在本地运行一个 Web 服务器来启动演示。如果你在 Jupyter 或 Colab Notebook 中运行代码，那么 Gradio 会将演示 GUI 嵌入到 Notebook 中，以便你可以轻松使用它。",Qe,z,gl="你可以通过不同的参数自定义 <code>launch()</code> 的行为：",Ne,F,Al="<li><code>inline</code> ——  是否在 Python Notebook 中内联显示接口。</li> <li><code>inbrowser</code> —— 是否在默认浏览器的新标签页中自动打开演示页面。</li> <li><code>share</code> ——  是否在你的计算机上创建一个公开可共享的链接。有点像 Google Drive 的链接！</li>",Se,D,$l="我们将在下一节中更详细地介绍 <code>share</code> 参数！",Ve,K,Xe,O,xl="让我们构建一个演示语音识别模型的演示。为了让它变得有趣，我们将同时支持从麦克风实时录制或上传的文件。",Ye,ee,Gl="像往常一样，我们将使用 🤗 Transformers 中的 <code>pipeline()</code> 函数加载我们的语音识别模型。如果你需要快速复习回顾，你可以返回第一章。接下来，我们将实现一个 <code>transcribe_audio()</code> 函数来处理音频并返回转录后的文本。最后，我们将把这个函数包装在一个 <code>Interface</code> 中，将输入的类型设置为 <code>Audio</code> 组件，将输出的类型设置为文本。汇总起来，这个演示的代码如下：",Pe,le,ze,te,Bl='如果你的浏览器没有要求你授权麦克风权限，请在<a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">新标签页中打开演示</a>。',Fe,u,Zl,De,se,_l="就是这样！现在你可以使用这个界面来转录音频了。请注意，在这个例子中我们将 <code>optional</code> 参数设置为了 <code>True</code> ，这样用户可以提供麦克风的实时录音或音频文件中任意一种作为输入（或两者都不提供，但这将返回错误消息）。",Ke,ae,ql="接下来，我们将学习如何与他人分享你的演示！",Oe,ne,el,oe,ll;return f=new ie({props:{title:"了解 Interface 类",local:"了解 Interface 类",headingTag:"h1"}}),U=new Sl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter9/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter9/section3.ipynb"}]}}),b=new ie({props:{title:"如何创建 Interface",local:"如何创建 Interface",headingTag:"h2"}}),$=new ie({props:{title:"一个音频组件的简单示例",local:"一个音频组件的简单示例",headingTag:"h2"}}),q=new sl({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMm1pY3JvcGhvbmUlMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIlMkMlMjBsYWJlbCUzRCUyMlNwZWFrJTIwaGVyZS4uLiUyMiklMEFnci5JbnRlcmZhY2UocmV2ZXJzZV9hdWRpbyUyQyUyMG1pYyUyQyUyMCUyMmF1ZGlvJTIyKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Speak here...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),W=new ie({props:{title:"处理多个输入和输出",local:"处理多个输入和输出",headingTag:"h2"}}),V=new sl({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3godHlwZSUzRCUyMm51bWJlciUyMiUyQyUyMHZhbHVlJTNEMSUyQyUyMGxhYmVsJTNEJTIyRHVyYXRpb24lMjBpbiUyMHNlY29uZHMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8lMjIlMkMlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Textbox(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;number&quot;</span>, value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Duration in seconds&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),X=new ie({props:{title:"launch() 方法",local:"launch-方法",headingTag:"h3"}}),K=new ie({props:{title:"✏️ 让我们实践一下！",local:"-让我们实践一下",headingTag:"h2"}}),le=new sl({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKG1pYyUzRE5vbmUlMkMlMjBmaWxlJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG1pYyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbWljJTBBJTIwJTIwJTIwJTIwZWxpZiUyMGZpbGUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpbyUyMCUzRCUyMGZpbGUlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyWW91JTIwbXVzdCUyMGVpdGhlciUyMHByb3ZpZGUlMjBhJTIwbWljJTIwcmVjb3JkaW5nJTIwb3IlMjBhJTIwZmlsZSUyMiUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5BdWRpbyhzb3VyY2UlM0QlMjJtaWNyb3Bob25lJTIyJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyJTJDJTIwb3B0aW9uYWwlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiUyQyUyMG9wdGlvbmFsJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTIydGV4dCUyMiUyQyUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">mic=<span class="hljs-literal">None</span>, file=<span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">if</span> mic <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = mic
    <span class="hljs-keyword">elif</span> file <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = file
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;You must either provide a mic recording or a file&quot;</span>
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=[
        gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
        gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
    ],
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),ne=new Vl({props:{source:"https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter9/3.mdx"}}),{c(){J=i("meta"),Me=a(),pe=i("p"),ce=a(),y(f.$$.fragment),ue=a(),y(U.$$.fragment),ye=a(),h=i("p"),h.innerHTML=nl,me=a(),y(b.$$.fragment),de=a(),I=i("p"),I.innerHTML=il,we=a(),C=i("p"),C.textContent=pl,Te=a(),v=i("ul"),v.innerHTML=ol,je=a(),k=i("p"),k.innerHTML=rl,Je=a(),g=i("p"),g.innerHTML=Ml,fe=a(),A=i("p"),A.innerHTML=cl,Ue=a(),y($.$$.fragment),he=a(),x=i("p"),x.innerHTML=ul,be=a(),G=i("p"),G.textContent=yl,Ie=a(),B=i("p"),B.innerHTML=ml,Ce=a(),Z=i("p"),Z.innerHTML=dl,ve=a(),_=i("p"),_.innerHTML=wl,ke=a(),y(q.$$.fragment),ge=a(),E=i("p"),E.innerHTML=Tl,Ae=a(),M=i("iframe"),$e=a(),H=i("p"),H.textContent=Jl,xe=a(),y(W.$$.fragment),Ge=a(),R=i("p"),R.textContent=fl,Be=a(),L=i("p"),L.textContent=Ul,Ze=a(),Q=i("p"),Q.textContent=hl,_e=a(),N=i("ul"),N.innerHTML=bl,qe=a(),S=i("p"),S.innerHTML=Il,Ee=a(),y(V.$$.fragment),He=a(),c=i("iframe"),We=a(),y(X.$$.fragment),Re=a(),Y=i("p"),Y.innerHTML=vl,Le=a(),P=i("p"),P.innerHTML=kl,Qe=a(),z=i("p"),z.innerHTML=gl,Ne=a(),F=i("ul"),F.innerHTML=Al,Se=a(),D=i("p"),D.innerHTML=$l,Ve=a(),y(K.$$.fragment),Xe=a(),O=i("p"),O.textContent=xl,Ye=a(),ee=i("p"),ee.innerHTML=Gl,Pe=a(),y(le.$$.fragment),ze=a(),te=i("p"),te.innerHTML=Bl,Fe=a(),u=i("iframe"),De=a(),se=i("p"),se.innerHTML=_l,Ke=a(),ae=i("p"),ae.textContent=ql,Oe=a(),y(ne.$$.fragment),el=a(),oe=i("p"),this.h()},l(e){const l=Ql("svelte-u9bgzb",document.head);J=p(l,"META",{name:!0,content:!0}),l.forEach(t),Me=n(e),pe=p(e,"P",{}),re(pe).forEach(t),ce=n(e),m(f.$$.fragment,e),ue=n(e),m(U.$$.fragment,e),ye=n(e),h=p(e,"P",{"data-svelte-h":!0}),o(h)!=="svelte-laf13r"&&(h.innerHTML=nl),me=n(e),m(b.$$.fragment,e),de=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-o1yr13"&&(I.innerHTML=il),we=n(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-gqxxez"&&(C.textContent=pl),Te=n(e),v=p(e,"UL",{"data-svelte-h":!0}),o(v)!=="svelte-1k2if01"&&(v.innerHTML=ol),je=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-cf195f"&&(k.innerHTML=rl),Je=n(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-17o6fl6"&&(g.innerHTML=Ml),fe=n(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1i07wje"&&(A.innerHTML=cl),Ue=n(e),m($.$$.fragment,e),he=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-14ytwgm"&&(x.innerHTML=ul),be=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-joy6oa"&&(G.textContent=yl),Ie=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-6lotiv"&&(B.innerHTML=ml),Ce=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1fbke88"&&(Z.innerHTML=dl),ve=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-19r0yoy"&&(_.innerHTML=wl),ke=n(e),m(q.$$.fragment,e),ge=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-2urhun"&&(E.innerHTML=Tl),Ae=n(e),M=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),re(M).forEach(t),$e=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1fo3iq1"&&(H.textContent=Jl),xe=n(e),m(W.$$.fragment,e),Ge=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1kkn6le"&&(R.textContent=fl),Be=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-rayjrw"&&(L.textContent=Ul),Ze=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-fs669w"&&(Q.textContent=hl),_e=n(e),N=p(e,"UL",{"data-svelte-h":!0}),o(N)!=="svelte-1spg63n"&&(N.innerHTML=bl),qe=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1osi2ri"&&(S.innerHTML=Il),Ee=n(e),m(V.$$.fragment,e),He=n(e),c=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),re(c).forEach(t),We=n(e),m(X.$$.fragment,e),Re=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-i5i6pl"&&(Y.innerHTML=vl),Le=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1n427fw"&&(P.innerHTML=kl),Qe=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-c1su3i"&&(z.innerHTML=gl),Ne=n(e),F=p(e,"UL",{"data-svelte-h":!0}),o(F)!=="svelte-8gq6"&&(F.innerHTML=Al),Se=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-bqa4yo"&&(D.innerHTML=$l),Ve=n(e),m(K.$$.fragment,e),Xe=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-sd6hz4"&&(O.textContent=xl),Ye=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-lw56ip"&&(ee.innerHTML=Gl),Pe=n(e),m(le.$$.fragment,e),ze=n(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-6jj0k"&&(te.innerHTML=Bl),Fe=n(e),u=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),re(u).forEach(t),De=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-lvhf8i"&&(se.innerHTML=_l),Ke=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1qe7s93"&&(ae.textContent=ql),Oe=n(e),m(ne.$$.fragment,e),el=n(e),oe=p(e,"P",{}),re(oe).forEach(t),this.h()},h(){r(J,"name","hf:doc:metadata"),r(J,"content",Yl),tl(M.src,jl="https://course-demos-audio-reverse.hf.space")||r(M,"src",jl),r(M,"frameborder","0"),r(M,"height","250"),r(M,"title","Gradio app"),r(M,"class","container p-0 flex-grow space-iframe"),r(M,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(M,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),tl(c.src,Cl="https://course-demos-generate-tone.hf.space")||r(c,"src",Cl),r(c,"frameborder","0"),r(c,"height","450"),r(c,"title","Gradio app"),r(c,"class","container p-0 flex-grow space-iframe"),r(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),tl(u.src,Zl="https://course-demos-asr.hf.space")||r(u,"src",Zl),r(u,"frameborder","0"),r(u,"height","550"),r(u,"title","Gradio app"),r(u,"class","container p-0 flex-grow space-iframe"),r(u,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(u,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,l){Nl(document.head,J),s(e,Me,l),s(e,pe,l),s(e,ce,l),d(f,e,l),s(e,ue,l),d(U,e,l),s(e,ye,l),s(e,h,l),s(e,me,l),d(b,e,l),s(e,de,l),s(e,I,l),s(e,we,l),s(e,C,l),s(e,Te,l),s(e,v,l),s(e,je,l),s(e,k,l),s(e,Je,l),s(e,g,l),s(e,fe,l),s(e,A,l),s(e,Ue,l),d($,e,l),s(e,he,l),s(e,x,l),s(e,be,l),s(e,G,l),s(e,Ie,l),s(e,B,l),s(e,Ce,l),s(e,Z,l),s(e,ve,l),s(e,_,l),s(e,ke,l),d(q,e,l),s(e,ge,l),s(e,E,l),s(e,Ae,l),s(e,M,l),s(e,$e,l),s(e,H,l),s(e,xe,l),d(W,e,l),s(e,Ge,l),s(e,R,l),s(e,Be,l),s(e,L,l),s(e,Ze,l),s(e,Q,l),s(e,_e,l),s(e,N,l),s(e,qe,l),s(e,S,l),s(e,Ee,l),d(V,e,l),s(e,He,l),s(e,c,l),s(e,We,l),d(X,e,l),s(e,Re,l),s(e,Y,l),s(e,Le,l),s(e,P,l),s(e,Qe,l),s(e,z,l),s(e,Ne,l),s(e,F,l),s(e,Se,l),s(e,D,l),s(e,Ve,l),d(K,e,l),s(e,Xe,l),s(e,O,l),s(e,Ye,l),s(e,ee,l),s(e,Pe,l),d(le,e,l),s(e,ze,l),s(e,te,l),s(e,Fe,l),s(e,u,l),s(e,De,l),s(e,se,l),s(e,Ke,l),s(e,ae,l),s(e,Oe,l),d(ne,e,l),s(e,el,l),s(e,oe,l),ll=!0},p:Hl,i(e){ll||(w(f.$$.fragment,e),w(U.$$.fragment,e),w(b.$$.fragment,e),w($.$$.fragment,e),w(q.$$.fragment,e),w(W.$$.fragment,e),w(V.$$.fragment,e),w(X.$$.fragment,e),w(K.$$.fragment,e),w(le.$$.fragment,e),w(ne.$$.fragment,e),ll=!0)},o(e){T(f.$$.fragment,e),T(U.$$.fragment,e),T(b.$$.fragment,e),T($.$$.fragment,e),T(q.$$.fragment,e),T(W.$$.fragment,e),T(V.$$.fragment,e),T(X.$$.fragment,e),T(K.$$.fragment,e),T(le.$$.fragment,e),T(ne.$$.fragment,e),ll=!1},d(e){e&&(t(Me),t(pe),t(ce),t(ue),t(ye),t(h),t(me),t(de),t(I),t(we),t(C),t(Te),t(v),t(je),t(k),t(Je),t(g),t(fe),t(A),t(Ue),t(he),t(x),t(be),t(G),t(Ie),t(B),t(Ce),t(Z),t(ve),t(_),t(ke),t(ge),t(E),t(Ae),t(M),t($e),t(H),t(xe),t(Ge),t(R),t(Be),t(L),t(Ze),t(Q),t(_e),t(N),t(qe),t(S),t(Ee),t(He),t(c),t(We),t(Re),t(Y),t(Le),t(P),t(Qe),t(z),t(Ne),t(F),t(Se),t(D),t(Ve),t(Xe),t(O),t(Ye),t(ee),t(Pe),t(ze),t(te),t(Fe),t(u),t(De),t(se),t(Ke),t(ae),t(Oe),t(el),t(oe)),t(J),j(f,e),j(U,e),j(b,e),j($,e),j(q,e),j(W,e),j(V,e),j(X,e),j(K,e),j(le,e),j(ne,e)}}}const Yl='{"title":"了解 Interface 类","local":"了解 Interface 类","sections":[{"title":"如何创建 Interface","local":"如何创建 Interface","sections":[],"depth":2},{"title":"一个音频组件的简单示例","local":"一个音频组件的简单示例","sections":[],"depth":2},{"title":"处理多个输入和输出","local":"处理多个输入和输出","sections":[{"title":"launch() 方法","local":"launch-方法","sections":[],"depth":3}],"depth":2},{"title":"✏️ 让我们实践一下！","local":"-让我们实践一下","sections":[],"depth":2}],"depth":1}';function Pl(al){return Wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class et extends Rl{constructor(J){super(),Ll(this,J,Pl,Xl,El,{})}}export{et as component};
