import{s as hs,o as cs,n as Q}from"../chunks/scheduler.9bc65507.js";import{S as gs,i as bs,g as p,s,r as u,A as Ms,h as m,f as l,c as i,j as fs,u as f,x as d,k as Xe,y as ys,a,v as h,d as c,t as g,w as b}from"../chunks/index.707bf1b6.js";import{T as B}from"../chunks/Tip.c2ecdbf4.js";import{C as v}from"../chunks/CodeBlock.54a9f38d.js";import{H as I}from"../chunks/Heading.342b1fa6.js";import{H as Sa,a as Re}from"../chunks/HfOption.6d864328.js";function Ts(_){let n,y='Interested in adding a new quantization method to Transformers? Read the <a href="./hf_quantizer">HfQuantizer</a> guide to learn how!';return{c(){n=p("p"),n.innerHTML=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-px0yfi"&&(n.innerHTML=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function ws(_){let n,y='Try AWQ quantization with this <a href="https://colab.research.google.com/drive/1HzZH89yAXJaZgwJDhQj9LqSBux932BvY" rel="nofollow">notebook</a>!';return{c(){n=p("p"),n.innerHTML=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1yzcfmc"&&(n.innerHTML=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function $s(_){let n,y="Fused modules cannot be combined with other optimization techniques such as FlashAttention-2.";return{c(){n=p("p"),n.textContent=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-hwgpn3"&&(n.textContent=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function Js(_){let n,y='To enable fused modules for supported architectures, create an <a href="/docs/transformers/main/en/main_classes/quantization#transformers.AwqConfig">AwqConfig</a> and set the parameters <code>fuse_max_seq_len</code> and <code>do_fuse=True</code>. The <code>fuse_max_seq_len</code> parameter is the total sequence length and it should include the context length and the expected generation length. You can set it to a larger value to be safe.',o,M,r='For example, to fuse the AWQ modules of the <a href="https://huggingface.co/TheBloke/Mistral-7B-OpenOrca-AWQ" rel="nofollow">TheBloke/Mistral-7B-OpenOrca-AWQ</a> model.',T,U,C;return U=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXdxQ29uZmlnJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMlRoZUJsb2tlJTJGTWlzdHJhbC03Qi1PcGVuT3JjYS1BV1ElMjIlMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQXdxQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGJpdHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZnVzZV9tYXhfc2VxX2xlbiUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMGRvX2Z1c2UlM0RUcnVlJTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWcpLnRvKDAp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AwqConfig, AutoModelForCausalLM

model_id = <span class="hljs-string">&quot;TheBloke/Mistral-7B-OpenOrca-AWQ&quot;</span>

quantization_config = AwqConfig(
    bits=<span class="hljs-number">4</span>,
    fuse_max_seq_len=<span class="hljs-number">512</span>,
    do_fuse=<span class="hljs-literal">True</span>,
)

model = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=quantization_config).to(<span class="hljs-number">0</span>)`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=s(),M=p("p"),M.innerHTML=r,T=s(),u(U.$$.fragment)},l(w){n=m(w,"P",{"data-svelte-h":!0}),d(n)!=="svelte-cvz4de"&&(n.innerHTML=y),o=i(w),M=m(w,"P",{"data-svelte-h":!0}),d(M)!=="svelte-1zxz2i"&&(M.innerHTML=r),T=i(w),f(U.$$.fragment,w)},m(w,q){a(w,n,q),a(w,o,q),a(w,M,q),a(w,T,q),h(U,w,q),C=!0},p:Q,i(w){C||(c(U.$$.fragment,w),C=!0)},o(w){g(U.$$.fragment,w),C=!1},d(w){w&&(l(n),l(o),l(M),l(T)),b(U,w)}}}function _s(_){let n,y='For architectures that don’t support fused modules yet, you need to create a custom fusing mapping to define which modules need to be fused with the <code>modules_to_fuse</code> parameter. For example, to fuse the AWQ modules of the <a href="https://huggingface.co/TheBloke/Yi-34B-AWQ" rel="nofollow">TheBloke/Yi-34B-AWQ</a> model.',o,M,r,T,U="The parameter <code>modules_to_fuse</code> should include:",C,w,q="<li><code>&quot;attention&quot;</code>: The names of the attention layers to fuse in the following order: query, key, value and output projection layer. If you don’t want to fuse these layers, pass an empty list.</li> <li><code>&quot;layernorm&quot;</code>: The names of all the LayerNorm layers you want to replace with a custom fused LayerNorm. If you don’t want to fuse these layers, pass an empty list.</li> <li><code>&quot;mlp&quot;</code>: The names of the MLP layers you want to fuse into a single MLP layer in the order: (gate (dense, layer, post-attention) / up / down layers).</li> <li><code>&quot;use_alibi&quot;</code>: If your model uses ALiBi positional embedding.</li> <li><code>&quot;num_attention_heads&quot;</code>: The number of attention heads.</li> <li><code>&quot;num_key_value_heads&quot;</code>: The number of key value heads that should be used to implement Grouped Query Attention (GQA). If <code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if <code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA), otherwise GQA is used.</li> <li><code>&quot;hidden_size&quot;</code>: The dimension of the hidden representations.</li>",Z;return M=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXdxQ29uZmlnJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMlRoZUJsb2tlJTJGWWktMzRCLUFXUSUyMiUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBBd3FDb25maWcoJTBBJTIwJTIwJTIwJTIwYml0cyUzRDQlMkMlMEElMjAlMjAlMjAlMjBmdXNlX21heF9zZXFfbGVuJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19mdXNlJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXR0ZW50aW9uJTIyJTNBJTIwJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGF5ZXJub3JtJTIyJTNBJTIwJTVCJTIybG4xJTIyJTJDJTIwJTIybG4yJTIyJTJDJTIwJTIybm9ybSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1scCUyMiUzQSUyMCU1QiUyMmdhdGVfcHJvaiUyMiUyQyUyMCUyMnVwX3Byb2olMjIlMkMlMjAlMjJkb3duX3Byb2olMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ1c2VfYWxpYmklMjIlM0ElMjBGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm51bV9hdHRlbnRpb25faGVhZHMlMjIlM0ElMjA1NiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm51bV9rZXlfdmFsdWVfaGVhZHMlMjIlM0ElMjA4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaGlkZGVuX3NpemUlMjIlM0ElMjA3MTY4JTBBJTIwJTIwJTIwJTIwJTdEJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWcpLnRvKDAp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AwqConfig, AutoModelForCausalLM

model_id = <span class="hljs-string">&quot;TheBloke/Yi-34B-AWQ&quot;</span>

quantization_config = AwqConfig(
    bits=<span class="hljs-number">4</span>,
    fuse_max_seq_len=<span class="hljs-number">512</span>,
    modules_to_fuse={
        <span class="hljs-string">&quot;attention&quot;</span>: [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
        <span class="hljs-string">&quot;layernorm&quot;</span>: [<span class="hljs-string">&quot;ln1&quot;</span>, <span class="hljs-string">&quot;ln2&quot;</span>, <span class="hljs-string">&quot;norm&quot;</span>],
        <span class="hljs-string">&quot;mlp&quot;</span>: [<span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>],
        <span class="hljs-string">&quot;use_alibi&quot;</span>: <span class="hljs-literal">False</span>,
        <span class="hljs-string">&quot;num_attention_heads&quot;</span>: <span class="hljs-number">56</span>,
        <span class="hljs-string">&quot;num_key_value_heads&quot;</span>: <span class="hljs-number">8</span>,
        <span class="hljs-string">&quot;hidden_size&quot;</span>: <span class="hljs-number">7168</span>
    }
)

model = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=quantization_config).to(<span class="hljs-number">0</span>)`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=s(),u(M.$$.fragment),r=s(),T=p("p"),T.innerHTML=U,C=s(),w=p("ul"),w.innerHTML=q},l(j){n=m(j,"P",{"data-svelte-h":!0}),d(n)!=="svelte-ecilwg"&&(n.innerHTML=y),o=i(j),f(M.$$.fragment,j),r=i(j),T=m(j,"P",{"data-svelte-h":!0}),d(T)!=="svelte-1divolh"&&(T.innerHTML=U),C=i(j),w=m(j,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-ln3msn"&&(w.innerHTML=q)},m(j,k){a(j,n,k),a(j,o,k),h(M,j,k),a(j,r,k),a(j,T,k),a(j,C,k),a(j,w,k),Z=!0},p:Q,i(j){Z||(c(M.$$.fragment,j),Z=!0)},o(j){g(M.$$.fragment,j),Z=!1},d(j){j&&(l(n),l(o),l(r),l(T),l(C),l(w)),b(M,j)}}}function vs(_){let n,y,o,M;return n=new Re({props:{id:"fuse",option:"supported architectures",$$slots:{default:[Js]},$$scope:{ctx:_}}}),o=new Re({props:{id:"fuse",option:"unsupported architectures",$$slots:{default:[_s]},$$scope:{ctx:_}}}),{c(){u(n.$$.fragment),y=s(),u(o.$$.fragment)},l(r){f(n.$$.fragment,r),y=i(r),f(o.$$.fragment,r)},m(r,T){h(n,r,T),a(r,y,T),h(o,r,T),M=!0},p(r,T){const U={};T&2&&(U.$$scope={dirty:T,ctx:r}),n.$set(U);const C={};T&2&&(C.$$scope={dirty:T,ctx:r}),o.$set(C)},i(r){M||(c(n.$$.fragment,r),c(o.$$.fragment,r),M=!0)},o(r){g(n.$$.fragment,r),g(o.$$.fragment,r),M=!1},d(r){r&&l(y),b(n,r),b(o,r)}}}function Us(_){let n,y='Try GPTQ quantization with PEFT in this <a href="https://colab.research.google.com/drive/1_TIrmuKOFhuRRiTWN94iLKUFu6ZX4ceb?usp=sharing" rel="nofollow">notebook</a> and learn more about it’s details in this <a href="https://huggingface.co/blog/gptq-integration" rel="nofollow">blog post</a>!';return{c(){n=p("p"),n.innerHTML=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1tfpiad"&&(n.innerHTML=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function js(_){let n,y='Depending on your hardware, it can take some time to quantize a model from scratch. It can take ~5 minutes to quantize the <a href="https://huggingface.co/facebook/opt-350m" rel="nofollow">facebook/opt-350m</a> model on a free-tier Google Colab GPU, but it’ll take ~4 hours to quantize a 175B parameter model on a NVIDIA A100. Before you quantize a model, it is a good idea to check the Hub if a GPTQ-quantized version of the model already exists.';return{c(){n=p("p"),n.innerHTML=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-jdzahk"&&(n.innerHTML=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function Cs(_){let n,y="Only 4-bit models are supported, and we recommend deactivating the ExLlama kernels if you’re finetuning a quantized model with PEFT.";return{c(){n=p("p"),n.textContent=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-14ppi1y"&&(n.textContent=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function qs(_){let n,y;return n=new v({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlM0UwLjM3LjA=",highlighted:"pip install transformers accelerate bitsandbytes&gt;0.37.0",wrap:!1}}),{c(){u(n.$$.fragment)},l(o){f(n.$$.fragment,o)},m(o,M){h(n,o,M),y=!0},p:Q,i(o){y||(c(n.$$.fragment,o),y=!0)},o(o){g(n.$$.fragment,o),y=!1},d(o){b(n,o)}}}function ks(_){let n,y;return n=new v({props:{code:"cGlwJTIwaW5zdGFsbCUyMGJpdHNhbmRieXRlcyUzRSUzRDAuMzkuMCUwQXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjBhY2NlbGVyYXRlJTBBcGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHRyYW5zZm9ybWVycw==",highlighted:`pip install bitsandbytes&gt;=0.39.0
pip install --upgrade accelerate
pip install --upgrade transformers`,wrap:!1}}),{c(){u(n.$$.fragment)},l(o){f(n.$$.fragment,o)},m(o,M){h(n,o,M),y=!0},p:Q,i(o){y||(c(n.$$.fragment,o),y=!0)},o(o){g(n.$$.fragment,o),y=!1},d(o){b(n,o)}}}function Zs(_){let n,y,o,M;return n=new Re({props:{id:"bnb",option:"8-bit",$$slots:{default:[qs]},$$scope:{ctx:_}}}),o=new Re({props:{id:"bnb",option:"4-bit",$$slots:{default:[ks]},$$scope:{ctx:_}}}),{c(){u(n.$$.fragment),y=s(),u(o.$$.fragment)},l(r){f(n.$$.fragment,r),y=i(r),f(o.$$.fragment,r)},m(r,T){h(n,r,T),a(r,y,T),h(o,r,T),M=!0},p(r,T){const U={};T&2&&(U.$$scope={dirty:T,ctx:r}),n.$set(U);const C={};T&2&&(C.$$scope={dirty:T,ctx:r}),o.$set(C)},i(r){M||(c(n.$$.fragment,r),c(o.$$.fragment,r),M=!0)},o(r){g(n.$$.fragment,r),g(o.$$.fragment,r),M=!1},d(r){r&&l(y),b(n,r),b(o,r)}}}function Gs(_){let n,y="Quantizing a model in 8-bit halves the memory-usage, and for large models, set <code>device_map=&quot;auto&quot;</code> to efficiently use the GPUs available:",o,M,r,T,U="By default, all the other modules such as <code>torch.nn.LayerNorm</code> are converted to <code>torch.float16</code>. You can change the data type of these modules with the <code>torch_dtype</code> parameter if you want:",C,w,q,Z,j='Once a model is quantized to 8-bit, you can’t push the quantized weights to the Hub unless you’re using the latest version of Transformers and bitsandbytes. If you have the latest versions, then you can push the 8-bit model to the Hub with the <a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method. The quantization config.json file is pushed first, followed by the quantized model weights.',k,$,G;return M=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWxfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb20tMWI3JTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model_8bit = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)`,wrap:!1}}),w=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbF84Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDMyKSUwQW1vZGVsXzhiaXQubW9kZWwuZGVjb2Rlci5sYXllcnMlNUItMSU1RC5maW5hbF9sYXllcl9ub3JtLndlaWdodC5kdHlwZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model_8bit = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>, torch_dtype=torch.float32)
model_8bit.model.decoder.layers[-<span class="hljs-number">1</span>].final_layer_norm.weight.dtype`,wrap:!1}}),$=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbS01NjBtJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbS01NjBtJTIyKSUwQSUwQW1vZGVsLnB1c2hfdG9faHViKCUyMmJsb29tLTU2MG0tOGJpdCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom-560m&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom-560m&quot;</span>)

model.push_to_hub(<span class="hljs-string">&quot;bloom-560m-8bit&quot;</span>)`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=s(),u(M.$$.fragment),r=s(),T=p("p"),T.innerHTML=U,C=s(),u(w.$$.fragment),q=s(),Z=p("p"),Z.innerHTML=j,k=s(),u($.$$.fragment)},l(J){n=m(J,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1dz8xeq"&&(n.innerHTML=y),o=i(J),f(M.$$.fragment,J),r=i(J),T=m(J,"P",{"data-svelte-h":!0}),d(T)!=="svelte-kfzkum"&&(T.innerHTML=U),C=i(J),f(w.$$.fragment,J),q=i(J),Z=m(J,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-951rn"&&(Z.innerHTML=j),k=i(J),f($.$$.fragment,J)},m(J,z){a(J,n,z),a(J,o,z),h(M,J,z),a(J,r,z),a(J,T,z),a(J,C,z),h(w,J,z),a(J,q,z),a(J,Z,z),a(J,k,z),h($,J,z),G=!0},p:Q,i(J){G||(c(M.$$.fragment,J),c(w.$$.fragment,J),c($.$$.fragment,J),G=!0)},o(J){g(M.$$.fragment,J),g(w.$$.fragment,J),g($.$$.fragment,J),G=!1},d(J){J&&(l(n),l(o),l(r),l(T),l(C),l(q),l(Z),l(k)),b(M,J),b(w,J),b($,J)}}}function Is(_){let n,y="Quantizing a model in 4-bit reduces your memory-usage by 4x, and for large models, set <code>device_map=&quot;auto&quot;</code> to efficiently use the GPUs available:",o,M,r,T,U="By default, all the other modules such as <code>torch.nn.LayerNorm</code> are converted to <code>torch.float16</code>. You can change the data type of these modules with the <code>torch_dtype</code> parameter if you want:",C,w,q,Z,j="If you have <code>bitsandbytes&gt;=0.41.3</code>, you can serialize 4-bit models and push them on Hugging Face Hub. Simply call <code>model.push_to_hub()</code> after loading it in 4-bit precision. You can also save the serialized 4-bit models locally with <code>model.save_pretrained()</code> command.",k;return M=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWxfNGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb20tMWI3JTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model_4bit = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>)`,wrap:!1}}),w=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbF80Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDMyKSUwQW1vZGVsXzRiaXQubW9kZWwuZGVjb2Rlci5sYXllcnMlNUItMSU1RC5maW5hbF9sYXllcl9ub3JtLndlaWdodC5kdHlwZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model_4bit = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>, torch_dtype=torch.float32)
model_4bit.model.decoder.layers[-<span class="hljs-number">1</span>].final_layer_norm.weight.dtype`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=s(),u(M.$$.fragment),r=s(),T=p("p"),T.innerHTML=U,C=s(),u(w.$$.fragment),q=s(),Z=p("p"),Z.innerHTML=j},l($){n=m($,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1b6jp1p"&&(n.innerHTML=y),o=i($),f(M.$$.fragment,$),r=i($),T=m($,"P",{"data-svelte-h":!0}),d(T)!=="svelte-kfzkum"&&(T.innerHTML=U),C=i($),f(w.$$.fragment,$),q=i($),Z=m($,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1pmx2wb"&&(Z.innerHTML=j)},m($,G){a($,n,G),a($,o,G),h(M,$,G),a($,r,G),a($,T,G),a($,C,G),h(w,$,G),a($,q,G),a($,Z,G),k=!0},p:Q,i($){k||(c(M.$$.fragment,$),c(w.$$.fragment,$),k=!0)},o($){g(M.$$.fragment,$),g(w.$$.fragment,$),k=!1},d($){$&&(l(n),l(o),l(r),l(T),l(C),l(q),l(Z)),b(M,$),b(w,$)}}}function zs(_){let n,y,o,M;return n=new Re({props:{id:"bnb",option:"8-bit",$$slots:{default:[Gs]},$$scope:{ctx:_}}}),o=new Re({props:{id:"bnb",option:"4-bit",$$slots:{default:[Is]},$$scope:{ctx:_}}}),{c(){u(n.$$.fragment),y=s(),u(o.$$.fragment)},l(r){f(n.$$.fragment,r),y=i(r),f(o.$$.fragment,r)},m(r,T){h(n,r,T),a(r,y,T),h(o,r,T),M=!0},p(r,T){const U={};T&2&&(U.$$scope={dirty:T,ctx:r}),n.$set(U);const C={};T&2&&(C.$$scope={dirty:T,ctx:r}),o.$set(C)},i(r){M||(c(n.$$.fragment,r),c(o.$$.fragment,r),M=!0)},o(r){g(n.$$.fragment,r),g(o.$$.fragment,r),M=!1},d(r){r&&l(y),b(n,r),b(o,r)}}}function Qs(_){let n,y="Training with 8-bit and 4-bit weights are only supported for training <em>extra</em> parameters.";return{c(){n=p("p"),n.innerHTML=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-of9sym"&&(n.innerHTML=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function Bs(_){let n,y='Learn more about the details of 8-bit quantization in this <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">blog post</a>!';return{c(){n=p("p"),n.innerHTML=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-1bb05fp"&&(n.innerHTML=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function Ws(_){let n,y='Try 4-bit quantization in this <a href="https://colab.research.google.com/drive/1ge2F1QSK8Q7h0hn3YKuBCOAS0bK8E0wf" rel="nofollow">notebook</a> and learn more about it’s details in this <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">blog post</a>.';return{c(){n=p("p"),n.innerHTML=y},l(o){n=m(o,"P",{"data-svelte-h":!0}),d(n)!=="svelte-rme94c"&&(n.innerHTML=y)},m(o,M){a(o,n,M)},p:Q,d(o){o&&l(n)}}}function Fs(_){let n,y,o,M,r,T,U,C="Quantization techniques focus on representing data with less information while also trying to not lose too much accuracy. This often means converting a data type to represent the same information with fewer bits. For example, if your model weights are stored as 32-bit floating points and they’re quantized to 16-bit floating points, this halves the model size which makes it easier to store and reduces memory-usage. Lower precision can also speedup inference because it takes less time to perform calculations with fewer bits.",w,q,Z="Transformers supports several quantization schemes to help you run inference with large language models (LLMs) and finetune adapters on quantized models. This guide will show you how to use Activation-aware Weight Quantization (AWQ), AutoGPTQ, and bitsandbytes.",j,k,$,G,J,z,Da='Try AQLM on <a href="https://colab.research.google.com/drive/1-xZmBRXT5Fm3Ghn4Mwa2KRypORXb855X?usp=sharing" rel="nofollow">Google Colab</a>!',Ae,O,Ka='Additive Quantization of Language Models (<a href="https://arxiv.org/abs/2401.06118" rel="nofollow">AQLM</a>) is a Large Language Models compression method. It quantizes multiple weights together and take advantage of interdependencies between them. AQLM represents groups of 8-16 weights as a sum of multiple vector codes.',Ne,tt,Oa="Inference support for AQLM is realised in the <code>aqlm</code> library. Make sure to install it to run the models (note aqlm works only with python&gt;=3.10):",He,et,Ee,lt,tn="The library provides efficient kernels for both GPU and CPU inference and training.",Ye,at,en='The instructions on how to quantize models yourself, as well as all the relevant code can be found in the corresponding GitHub <a href="https://github.com/Vahe1994/AQLM" rel="nofollow">repository</a>.',Pe,nt,Se,st,ln='Starting with version <code>aqlm 1.0.2</code>, AQLM supports Parameter-Efficient Fine-Tuning in a form of <a href="https://huggingface.co/docs/peft/package_reference/lora" rel="nofollow">LoRA</a> integrated into the <a href="https://huggingface.co/blog/peft" rel="nofollow">PEFT</a> library.',De,it,Ke,ot,an="AQLM quantization setpus vary mainly on the number of codebooks used as well as codebook sizes in bits. The most popular setups, as well as inference kernels they support are:",Oe,rt,nn="<thead><tr><th>Kernel</th> <th>Number of codebooks</th> <th>Codebook size, bits</th> <th>Notation</th> <th>Accuracy</th> <th>Speedup</th> <th>Fast GPU inference</th> <th>Fast CPU inference</th></tr></thead> <tbody><tr><td>Triton</td> <td>K</td> <td>N</td> <td>KxN</td> <td>-</td> <td>Up to ~0.7x</td> <td>✅</td> <td>❌</td></tr> <tr><td>CUDA</td> <td>1</td> <td>16</td> <td>1x16</td> <td>Best</td> <td>Up to ~1.3x</td> <td>✅</td> <td>❌</td></tr> <tr><td>CUDA</td> <td>2</td> <td>8</td> <td>2x8</td> <td>OK</td> <td>Up to ~3.0x</td> <td>✅</td> <td>❌</td></tr> <tr><td>Numba</td> <td>K</td> <td>8</td> <td>Kx8</td> <td>Good</td> <td>Up to ~4.0x</td> <td>❌</td> <td>✅</td></tr></tbody>",tl,pt,el,W,ll,mt,sn='<a href="https://hf.co/papers/2306.00978" rel="nofollow">Activation-aware Weight Quantization (AWQ)</a> doesn’t quantize all the weights in a model, and instead, it preserves a small percentage of weights that are important for LLM performance. This significantly reduces quantization loss such that you can run models in 4-bit precision without experiencing any performance degradation.',al,dt,on='There are several libraries for quantizing models with the AWQ algorithm, such as <a href="https://github.com/mit-han-lab/llm-awq" rel="nofollow">llm-awq</a>, <a href="https://github.com/casper-hansen/AutoAWQ" rel="nofollow">autoawq</a> or <a href="https://huggingface.co/docs/optimum/main/en/intel/optimization_inc" rel="nofollow">optimum-intel</a>. Transformers supports loading models quantized with the llm-awq and autoawq libraries. This guide will show you how to load models quantized with autoawq, but the process is similar for llm-awq quantized models.',nl,ut,rn="Make sure you have autoawq installed:",sl,ft,il,ht,pn='AWQ-quantized models can be identified by checking the <code>quantization_config</code> attribute in the model’s <a href="https://huggingface.co/TheBloke/zephyr-7B-alpha-AWQ/blob/main/config.json" rel="nofollow">config.json</a> file:',ol,ct,rl,gt,mn='A quantized model is loaded with the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method. If you loaded your model on the CPU, make sure to move it to a GPU device first. Use the <code>device_map</code> parameter to specify where to place the model:',pl,bt,ml,Mt,dn="Loading an AWQ-quantized model automatically sets other weights to fp16 by default for performance reasons. If you want to load these other weights in a different format, use the <code>torch_dtype</code> parameter:",dl,yt,ul,Tt,un='AWQ quantization can also be combined with <a href="perf_infer_gpu_one#flashattention-2">FlashAttention-2</a> to further accelerate inference:',fl,wt,hl,$t,cl,Jt,fn='Fused modules offers improved accuracy and performance and it is supported out-of-the-box for AWQ modules for <a href="https://huggingface.co/meta-llama" rel="nofollow">Llama</a> and <a href="https://huggingface.co/mistralai/Mistral-7B-v0.1" rel="nofollow">Mistral</a> architectures, but you can also fuse AWQ modules for unsupported architectures.',gl,F,bl,V,Ml,_t,yl,x,Tl,vt,hn='The <a href="https://github.com/PanQiWei/AutoGPTQ" rel="nofollow">AutoGPTQ</a> library implements the GPTQ algorithm, a post-training quantization technique where each row of the weight matrix is quantized independently to find a version of the weights that minimizes the error. These weights are quantized to int4, but they’re restored to fp16 on the fly during inference. This can save your memory-usage by 4x because the int4 weights are dequantized in a fused kernel rather than a GPU’s global memory, and you can also expect a speedup in inference because using a lower bitwidth takes less time to communicate.',wl,Ut,cn="Before you begin, make sure the following libraries are installed:",$l,jt,Jl,Ct,gn='To quantize a model (currently only supported for text models), you need to create a <a href="/docs/transformers/main/en/main_classes/quantization#transformers.GPTQConfig">GPTQConfig</a> class and set the number of bits to quantize to, a dataset to calibrate the weights for quantization, and a tokenizer to prepare the dataset.',_l,qt,vl,kt,bn="You could also pass your own dataset as a list of strings, but it is highly recommended to use the same dataset from the GPTQ paper.",Ul,Zt,jl,Gt,Mn='Load a model to quantize and pass the <code>gptq_config</code> to the <a href="/docs/transformers/main/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> method. Set <code>device_map=&quot;auto&quot;</code> to automatically offload the model to a CPU to help fit the model in memory, and allow the model modules to be moved between the CPU and GPU for quantization.',Cl,It,ql,zt,yn="If you’re running out of memory because a dataset is too large, disk offloading is not supported. If this is the case, try passing the <code>max_memory</code> parameter to allocate the amount of memory to use on your device (GPU and CPU):",kl,Qt,Zl,X,Gl,Bt,Tn='Once your model is quantized, you can push the model and tokenizer to the Hub where it can be easily shared and accessed. Use the <a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method to save the <a href="/docs/transformers/main/en/main_classes/quantization#transformers.GPTQConfig">GPTQConfig</a>:',Il,Wt,zl,Ft,wn='You could also save your quantized model locally with the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> method. If the model was quantized with the <code>device_map</code> parameter, make sure to move the entire model to a GPU or CPU before saving it. For example, to save the model on a CPU:',Ql,Vt,Bl,xt,$n='Reload a quantized model with the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method, and set <code>device_map=&quot;auto&quot;</code> to automatically distribute the model on all available GPUs to load the model faster without using more memory than needed.',Wl,Xt,Fl,Rt,Vl,Lt,Jn='<a href="https://github.com/turboderp/exllama" rel="nofollow">ExLlama</a> is a Python/C++/CUDA implementation of the <a href="model_doc/llama">Llama</a> model that is designed for faster inference with 4-bit GPTQ weights (check out these <a href="https://github.com/huggingface/optimum/tree/main/tests/benchmark#gptq-benchmark" rel="nofollow">benchmarks</a>). The ExLlama kernel is activated by default when you create a <a href="/docs/transformers/main/en/main_classes/quantization#transformers.GPTQConfig">GPTQConfig</a> object. To boost inference speed even further, use the <a href="https://github.com/turboderp/exllamav2" rel="nofollow">ExLlamaV2</a> kernels by configuring the <code>exllama_config</code> parameter:',xl,At,Xl,R,Rl,Nt,_n="The ExLlama kernels are only supported when the entire model is on the GPU. If you’re doing inference on a CPU with AutoGPTQ (version > 0.4.2), then you’ll need to disable the ExLlama kernel. This overwrites the attributes related to the ExLlama kernels in the quantization config of the config.json file.",Ll,Ht,Al,Et,Nl,Yt,vn='<a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> is the easiest option for quantizing a model to 8 and 4-bit. 8-bit quantization multiplies outliers in fp16 with non-outliers in int8, converts the non-outlier values back to fp16, and then adds them together to return the weights in fp16. This reduces the degradative effect outlier values have on a model’s performance. 4-bit quantization compresses a model even further, and it is commonly used with <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> to finetune quantized LLMs.',Hl,Pt,Un="To use bitsandbytes, make sure you have the following libraries installed:",El,L,Yl,St,jn='Now you can quantize a model with the <code>load_in_8bit</code> or <code>load_in_4bit</code> parameters in the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method. This works for any model in any modality, as long as it supports loading with Accelerate and contains <code>torch.nn.Linear</code> layers.',Pl,A,Sl,N,Dl,Dt,Cn="You can check your memory footprint with the <code>get_memory_footprint</code> method:",Kl,Kt,Ol,Ot,qn='Quantized models can be loaded from the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method without needing to specify the <code>load_in_8bit</code> or <code>load_in_4bit</code> parameters:',ta,te,ea,ee,la,H,aa,le,kn="This section explores some of the specific features of 8-bit models, such as offloading, outlier thresholds, skipping module conversion, and finetuning.",na,ae,sa,ne,Zn='8-bit models can offload weights between the CPU and GPU to support fitting very large models into memory. The weights dispatched to the CPU are actually stored in <strong>float32</strong>, and aren’t converted to 8-bit. For example, to enable offloading for the <a href="https://huggingface.co/bigscience/bloom-1b7" rel="nofollow">bigscience/bloom-1b7</a> model, start by creating a <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',ia,se,oa,ie,Gn="Design a custom device map to fit everything on your GPU except for the <code>lm_head</code>, which you’ll dispatch to the CPU:",ra,oe,pa,re,In="Now load your model with the custom <code>device_map</code> and <code>quantization_config</code>:",ma,pe,da,me,ua,de,zn="An “outlier” is a hidden state value greater than a certain threshold, and these values are computed in fp16. While the values are usually normally distributed ([-3.5, 3.5]), this distribution can be very different for large models ([-60, 6] or [6, 60]). 8-bit quantization works well for values ~5, but beyond that, there is a significant performance penalty. A good default threshold value is 6, but a lower threshold may be needed for more unstable models (small models or finetuning).",fa,ue,Qn='To find the best threshold for your model, we recommend experimenting with the <code>llm_int8_threshold</code> parameter in <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',ha,fe,ca,he,ga,ce,Bn='For some models, like <a href="model_doc/jukebox">Jukebox</a>, you don’t need to quantize every module to 8-bit which can actually cause instability. With Jukebox, there are several <code>lm_head</code> modules that should be skipped using the <code>llm_int8_skip_modules</code> parameter in <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',ba,ge,Ma,be,ya,Me,Wn='With the <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT</a> library, you can finetune large models like <a href="https://huggingface.co/google/flan-t5-large" rel="nofollow">flan-t5-large</a> and <a href="https://huggingface.co/facebook/opt-6.7b" rel="nofollow">facebook/opt-6.7b</a> with 8-bit quantization. You don’t need to pass the <code>device_map</code> parameter for training because it’ll automatically load your model on a GPU. However, you can still customize the device map with the <code>device_map</code> parameter if you want to (<code>device_map=&quot;auto&quot;</code> should only be used for inference).',Ta,ye,wa,E,$a,Te,Fn="This section explores some of the specific features of 4-bit models, such as changing the compute data type, using the Normal Float 4 (NF4) data type, and using nested quantization.",Ja,we,_a,$e,Vn='To speedup computation, you can change the data type from float32 (the default value) to bf16 using the <code>bnb_4bit_compute_dtype</code> parameter in <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',va,Je,Ua,_e,ja,ve,xn='NF4 is a 4-bit data type from the <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> paper, adapted for weights initialized from a normal distribution. You should use NF4 for training 4-bit base models. This can be configured with the <code>bnb_4bit_quant_type</code> parameter in the <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Ca,Ue,qa,je,Xn="For inference, the <code>bnb_4bit_quant_type</code> does not have a huge impact on performance. However, to remain consistent with the model weights, you should use the <code>bnb_4bit_compute_dtype</code> and <code>torch_dtype</code> values.",ka,Ce,Za,qe,Rn='Nested quantization is a technique that can save additional memory at no additional performance cost. This feature performs a second quantization of the already quantized weights to save an addition 0.4 bits/parameter. For example, with nested quantization, you can finetune a <a href="https://huggingface.co/meta-llama/Llama-2-13b" rel="nofollow">Llama-13b</a> model on a 16GB NVIDIA T4 GPU with a sequence length of 1024, a batch size of 1, and enabling gradient accumulation with 4 steps.',Ga,ke,Ia,Ze,za,Ge,Ln='The <a href="https://huggingface.co/docs/optimum/index" rel="nofollow">Optimum</a> library supports quantization for Intel, Furiosa, ONNX Runtime, GPTQ, and lower-level PyTorch quantization functions. Consider using Optimum for quantization if you’re using specific and optimized hardware like Intel CPUs, Furiosa NPUs or a model accelerator like ONNX Runtime.',Qa,Ie,Ba,ze,An='To compare the speed, throughput, and latency of each quantization scheme, check the following benchmarks obtained from the <a href="https://github.com/huggingface/optimum-benchmark" rel="nofollow">optimum-benchmark</a> library. The benchmark was run on a NVIDIA A1000 for the <a href="https://huggingface.co/TheBloke/Mistral-7B-v0.1-AWQ" rel="nofollow">TheBloke/Mistral-7B-v0.1-AWQ</a> and <a href="https://huggingface.co/TheBloke/Mistral-7B-v0.1-GPTQ" rel="nofollow">TheBloke/Mistral-7B-v0.1-GPTQ</a> models. These were also tested against the bitsandbytes quantization methods as well as a native fp16 model.',Wa,Y,Nn='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/quantization/forward_memory_plot.png" alt="forward peak memory per batch size"/> <figcaption class="mt-2 text-center text-sm text-gray-500">forward peak memory/batch size</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/quantization/generate_memory_plot.png" alt="generate peak memory per batch size"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generate peak memory/batch size</figcaption></div>',Fa,P,Hn='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/quantization/generate_throughput_plot.png" alt="generate throughput per batch size"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generate throughput/batch size</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/quantization/forward_latency_plot.png" alt="forward latency per batch size"/> <figcaption class="mt-2 text-center text-sm text-gray-500">forward latency/batch size</figcaption></div>',Va,Qe,En='The benchmarks indicate AWQ quantization is the fastest for inference, text generation, and has the lowest peak memory for text generation. However, AWQ has the largest forward latency per batch size. For a more detailed discussion about the pros and cons of each quantization method, read the <a href="https://huggingface.co/blog/overview-quantization-transformers" rel="nofollow">Overview of natively supported quantization schemes in 🤗 Transformers</a> blog post.',xa,Be,Xa,We,Yn='The <a href="https://huggingface.co/TheBloke/Mistral-7B-OpenOrca-AWQ" rel="nofollow">TheBloke/Mistral-7B-OpenOrca-AWQ</a> model was benchmarked with <code>batch_size=1</code> with and without fused modules.',Ra,S,Pn="Unfused module",La,Fe,Sn='<thead><tr><th align="right">Batch Size</th> <th align="right">Prefill Length</th> <th align="right">Decode Length</th> <th align="right">Prefill tokens/s</th> <th align="right">Decode tokens/s</th> <th align="left">Memory (VRAM)</th></tr></thead> <tbody><tr><td align="right">1</td> <td align="right">32</td> <td align="right">32</td> <td align="right">60.0984</td> <td align="right">38.4537</td> <td align="left">4.50 GB (5.68%)</td></tr> <tr><td align="right">1</td> <td align="right">64</td> <td align="right">64</td> <td align="right">1333.67</td> <td align="right">31.6604</td> <td align="left">4.50 GB (5.68%)</td></tr> <tr><td align="right">1</td> <td align="right">128</td> <td align="right">128</td> <td align="right">2434.06</td> <td align="right">31.6272</td> <td align="left">4.50 GB (5.68%)</td></tr> <tr><td align="right">1</td> <td align="right">256</td> <td align="right">256</td> <td align="right">3072.26</td> <td align="right">38.1731</td> <td align="left">4.50 GB (5.68%)</td></tr> <tr><td align="right">1</td> <td align="right">512</td> <td align="right">512</td> <td align="right">3184.74</td> <td align="right">31.6819</td> <td align="left">4.59 GB (5.80%)</td></tr> <tr><td align="right">1</td> <td align="right">1024</td> <td align="right">1024</td> <td align="right">3148.18</td> <td align="right">36.8031</td> <td align="left">4.81 GB (6.07%)</td></tr> <tr><td align="right">1</td> <td align="right">2048</td> <td align="right">2048</td> <td align="right">2927.33</td> <td align="right">35.2676</td> <td align="left">5.73 GB (7.23%)</td></tr></tbody>',Aa,D,Dn="Fused module",Na,Ve,Kn='<thead><tr><th align="right">Batch Size</th> <th align="right">Prefill Length</th> <th align="right">Decode Length</th> <th align="right">Prefill tokens/s</th> <th align="right">Decode tokens/s</th> <th align="left">Memory (VRAM)</th></tr></thead> <tbody><tr><td align="right">1</td> <td align="right">32</td> <td align="right">32</td> <td align="right">81.4899</td> <td align="right">80.2569</td> <td align="left">4.00 GB (5.05%)</td></tr> <tr><td align="right">1</td> <td align="right">64</td> <td align="right">64</td> <td align="right">1756.1</td> <td align="right">106.26</td> <td align="left">4.00 GB (5.05%)</td></tr> <tr><td align="right">1</td> <td align="right">128</td> <td align="right">128</td> <td align="right">2479.32</td> <td align="right">105.631</td> <td align="left">4.00 GB (5.06%)</td></tr> <tr><td align="right">1</td> <td align="right">256</td> <td align="right">256</td> <td align="right">1813.6</td> <td align="right">85.7485</td> <td align="left">4.01 GB (5.06%)</td></tr> <tr><td align="right">1</td> <td align="right">512</td> <td align="right">512</td> <td align="right">2848.9</td> <td align="right">97.701</td> <td align="left">4.11 GB (5.19%)</td></tr> <tr><td align="right">1</td> <td align="right">1024</td> <td align="right">1024</td> <td align="right">3044.35</td> <td align="right">87.7323</td> <td align="left">4.41 GB (5.57%)</td></tr> <tr><td align="right">1</td> <td align="right">2048</td> <td align="right">2048</td> <td align="right">2715.11</td> <td align="right">89.4709</td> <td align="left">5.57 GB (7.04%)</td></tr></tbody>',Ha,xe,On='The speed and throughput of fused and unfused modules were also tested with the <a href="https://github.com/huggingface/optimum-benchmark" rel="nofollow">optimum-benchmark</a> library.',Ea,K,ts='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/quantization/fused_forward_memory_plot.png" alt="generate throughput per batch size"/> <figcaption class="mt-2 text-center text-sm text-gray-500">forward peak memory/batch size</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/quantization/fused_generate_throughput_plot.png" alt="forward latency per batch size"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generate throughput/batch size</figcaption></div>',Ya,Le,Pa;return r=new I({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),k=new B({props:{$$slots:{default:[Ts]},$$scope:{ctx:_}}}),G=new I({props:{title:"AQLM",local:"aqlm",headingTag:"h2"}}),et=new v({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFxbG0lNUJncHUlMkNjcHUlNUQ=",highlighted:"pip install aqlm[gpu,cpu]",wrap:!1}}),nt=new I({props:{title:"PEFT",local:"peft",headingTag:"h3"}}),it=new I({props:{title:"AQLM configurations",local:"aqlm-configurations",headingTag:"h3"}}),pt=new I({props:{title:"AWQ",local:"awq",headingTag:"h2"}}),W=new B({props:{$$slots:{default:[ws]},$$scope:{ctx:_}}}),ft=new v({props:{code:"cGlwJTIwaW5zdGFsbCUyMGF1dG9hd3E=",highlighted:"pip install autoawq",wrap:!1}}),ct=new v({props:{code:"JTdCJTBBJTIwJTIwJTIyX25hbWVfb3JfcGF0aCUyMiUzQSUyMCUyMiUyRndvcmtzcGFjZSUyRnByb2Nlc3MlMkZodWdnaW5nZmFjZWg0X3plcGh5ci03Yi1hbHBoYSUyRnNvdXJjZSUyMiUyQyUwQSUyMCUyMCUyMmFyY2hpdGVjdHVyZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJNaXN0cmFsRm9yQ2F1c2FsTE0lMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAuLi4lMEElMjAlMjAuLi4lMEElMjAlMjAuLi4lMEElMjAlMjAlMjJxdWFudGl6YXRpb25fY29uZmlnJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycXVhbnRfbWV0aG9kJTIyJTNBJTIwJTIyYXdxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyemVyb19wb2ludCUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjJncm91cF9zaXplJTIyJTNBJTIwMTI4JTJDJTBBJTIwJTIwJTIwJTIwJTIyYml0cyUyMiUzQSUyMDQlMkMlMEElMjAlMjAlMjAlMjAlMjJ2ZXJzaW9uJTIyJTNBJTIwJTIyZ2VtbSUyMiUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;_name_or_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/workspace/process/huggingfaceh4_zephyr-7b-alpha/source&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;architectures&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;MistralForCausalLM&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  ...
  ...
  ...
  <span class="hljs-attr">&quot;quantization_config&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;quant_method&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;awq&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;zero_point&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;group_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;bits&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">4</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gemm&quot;</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),bt=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyVGhlQmxva2UlMkZ6ZXBoeXItN0ItYWxwaGEtQVdRJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUzQTAlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model_id = <span class="hljs-string">&quot;TheBloke/zephyr-7B-alpha-AWQ&quot;</span>
model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;cuda:0&quot;</span>)`,wrap:!1}}),yt=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyVGhlQmxva2UlMkZ6ZXBoeXItN0ItYWxwaGEtQVdRJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MzIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model_id = <span class="hljs-string">&quot;TheBloke/zephyr-7B-alpha-AWQ&quot;</span>
model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.float32)`,wrap:!1}}),wt=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlRoZUJsb2tlJTJGemVwaHlyLTdCLWFscGhhLUFXUSUyMiUyQyUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTNBMCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;TheBloke/zephyr-7B-alpha-AWQ&quot;</span>, attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>, device_map=<span class="hljs-string">&quot;cuda:0&quot;</span>)`,wrap:!1}}),$t=new I({props:{title:"Fused modules",local:"fused-modules",headingTag:"h3"}}),F=new B({props:{warning:!0,$$slots:{default:[$s]},$$scope:{ctx:_}}}),V=new Sa({props:{id:"fuse",options:["supported architectures","unsupported architectures"],$$slots:{default:[vs]},$$scope:{ctx:_}}}),_t=new I({props:{title:"AutoGPTQ",local:"autogptq",headingTag:"h2"}}),x=new B({props:{$$slots:{default:[Us]},$$scope:{ctx:_}}}),jt=new v({props:{code:"cGlwJTIwaW5zdGFsbCUyMGF1dG8tZ3B0cSUwQXBpcCUyMGluc3RhbGwlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRm9wdGltdW0uZ2l0JTBBcGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzLmdpdCUwQXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjBhY2NlbGVyYXRl",highlighted:`pip install auto-gptq
pip install git+https://github.com/huggingface/optimum.git
pip install git+https://github.com/huggingface/transformers.git
pip install --upgrade accelerate`,wrap:!1}}),qt=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEdQVFFDb25maWclMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmZhY2Vib29rJTJGb3B0LTEyNW0lMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFncHRxX2NvbmZpZyUyMCUzRCUyMEdQVFFDb25maWcoYml0cyUzRDQlMkMlMjBkYXRhc2V0JTNEJTIyYzQlMjIlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, GPTQConfig

model_id = <span class="hljs-string">&quot;facebook/opt-125m&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
gptq_config = GPTQConfig(bits=<span class="hljs-number">4</span>, dataset=<span class="hljs-string">&quot;c4&quot;</span>, tokenizer=tokenizer)`,wrap:!1}}),Zt=new v({props:{code:"ZGF0YXNldCUyMCUzRCUyMCU1QiUyMmF1dG8tZ3B0cSUyMGlzJTIwYW4lMjBlYXN5LXRvLXVzZSUyMG1vZGVsJTIwcXVhbnRpemF0aW9uJTIwbGlicmFyeSUyMHdpdGglMjB1c2VyLWZyaWVuZGx5JTIwYXBpcyUyQyUyMGJhc2VkJTIwb24lMjBHUFRRJTIwYWxnb3JpdGhtLiUyMiU1RCUwQWdwdHFfY29uZmlnJTIwJTNEJTIwR1BUUUNvbmZpZyhiaXRzJTNENCUyQyUyMGRhdGFzZXQlM0RkYXRhc2V0JTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKQ==",highlighted:`dataset = [<span class="hljs-string">&quot;auto-gptq is an easy-to-use model quantization library with user-friendly apis, based on GPTQ algorithm.&quot;</span>]
gptq_config = GPTQConfig(bits=<span class="hljs-number">4</span>, dataset=dataset, tokenizer=tokenizer)`,wrap:!1}}),It=new v({props:{code:"cXVhbnRpemVkX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEZ3B0cV9jb25maWcp",highlighted:'quantized_model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=gptq_config)',wrap:!1}}),Qt=new v({props:{code:"cXVhbnRpemVkX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBtYXhfbWVtb3J5JTNEJTdCMCUzQSUyMCUyMjMwR2lCJTIyJTJDJTIwMSUzQSUyMCUyMjQ2R2lCJTIyJTJDJTIwJTIyY3B1JTIyJTNBJTIwJTIyMzBHaUIlMjIlN0QlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEZ3B0cV9jb25maWcp",highlighted:'quantized_model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, max_memory={<span class="hljs-number">0</span>: <span class="hljs-string">&quot;30GiB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;46GiB&quot;</span>, <span class="hljs-string">&quot;cpu&quot;</span>: <span class="hljs-string">&quot;30GiB&quot;</span>}, quantization_config=gptq_config)',wrap:!1}}),X=new B({props:{warning:!0,$$slots:{default:[js]},$$scope:{ctx:_}}}),Wt=new v({props:{code:"cXVhbnRpemVkX21vZGVsLnB1c2hfdG9faHViKCUyMm9wdC0xMjVtLWdwdHElMjIpJTBBdG9rZW5pemVyLnB1c2hfdG9faHViKCUyMm9wdC0xMjVtLWdwdHElMjIp",highlighted:`quantized_model.push_to_hub(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)
tokenizer.push_to_hub(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)`,wrap:!1}}),Vt=new v({props:{code:"cXVhbnRpemVkX21vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJvcHQtMTI1bS1ncHRxJTIyKSUwQXRva2VuaXplci5zYXZlX3ByZXRyYWluZWQoJTIyb3B0LTEyNW0tZ3B0cSUyMiklMEElMEElMjMlMjBpZiUyMHF1YW50aXplZCUyMHdpdGglMjBkZXZpY2VfbWFwJTIwc2V0JTBBcXVhbnRpemVkX21vZGVsLnRvKCUyMmNwdSUyMiklMEFxdWFudGl6ZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMm9wdC0xMjVtLWdwdHElMjIp",highlighted:`quantized_model.save_pretrained(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)

<span class="hljs-comment"># if quantized with device_map set</span>
quantized_model.to(<span class="hljs-string">&quot;cpu&quot;</span>)
quantized_model.save_pretrained(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)`,wrap:!1}}),Xt=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRm9wdC0xMjVtLWdwdHElMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;{your_username}/opt-125m-gptq&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),Rt=new I({props:{title:"ExLlama",local:"exllama",headingTag:"h3"}}),At=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBHUFRRQ29uZmlnJTBBJTBBZ3B0cV9jb25maWclMjAlM0QlMjBHUFRRQ29uZmlnKGJpdHMlM0Q0JTJDJTIwZXhsbGFtYV9jb25maWclM0QlN0IlMjJ2ZXJzaW9uJTIyJTNBMiU3RCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjIlN0J5b3VyX3VzZXJuYW1lJTdEJTJGb3B0LTEyNW0tZ3B0cSUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGdwdHFfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, GPTQConfig

gptq_config = GPTQConfig(bits=<span class="hljs-number">4</span>, exllama_config={<span class="hljs-string">&quot;version&quot;</span>:<span class="hljs-number">2</span>})
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;{your_username}/opt-125m-gptq&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=gptq_config)`,wrap:!1}}),R=new B({props:{warning:!0,$$slots:{default:[Cs]},$$scope:{ctx:_}}}),Ht=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBHUFRRQ29uZmlnJTBBZ3B0cV9jb25maWclMjAlM0QlMjBHUFRRQ29uZmlnKGJpdHMlM0Q0JTJDJTIwdXNlX2V4bGxhbWElM0RGYWxzZSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjIlN0J5b3VyX3VzZXJuYW1lJTdEJTJGb3B0LTEyNW0tZ3B0cSUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJjcHUlMjIlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEZ3B0cV9jb25maWcp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, GPTQConfig
gptq_config = GPTQConfig(bits=<span class="hljs-number">4</span>, use_exllama=<span class="hljs-literal">False</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;{your_username}/opt-125m-gptq&quot;</span>, device_map=<span class="hljs-string">&quot;cpu&quot;</span>, quantization_config=gptq_config)`,wrap:!1}}),Et=new I({props:{title:"bitsandbytes",local:"bitsandbytes",headingTag:"h2"}}),L=new Sa({props:{id:"bnb",options:["8-bit","4-bit"],$$slots:{default:[Zs]},$$scope:{ctx:_}}}),A=new Sa({props:{id:"bnb",options:["8-bit","4-bit"],$$slots:{default:[zs]},$$scope:{ctx:_}}}),N=new B({props:{warning:!0,$$slots:{default:[Qs]},$$scope:{ctx:_}}}),Kt=new v({props:{code:"cHJpbnQobW9kZWwuZ2V0X21lbW9yeV9mb290cHJpbnQoKSk=",highlighted:'<span class="hljs-built_in">print</span>(model.get_memory_footprint())',wrap:!1}}),te=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZibG9vbS01NjBtLThiaXQlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;{your_username}/bloom-560m-8bit&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),ee=new I({props:{title:"8-bit",local:"8-bit",headingTag:"h3"}}),H=new B({props:{$$slots:{default:[Bs]},$$scope:{ctx:_}}}),ae=new I({props:{title:"Offloading",local:"offloading",headingTag:"h4"}}),se=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsbG1faW50OF9lbmFibGVfZnAzMl9jcHVfb2ZmbG9hZCUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(llm_int8_enable_fp32_cpu_offload=<span class="hljs-literal">True</span>)`,wrap:!1}}),oe=new v({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLndvcmRfZW1iZWRkaW5ncyUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci53b3JkX2VtYmVkZGluZ3NfbGF5ZXJub3JtJTIyJTNBJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxtX2hlYWQlMjIlM0ElMjAlMjJjcHUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci5oJTIyJTNBJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLmxuX2YlMjIlM0ElMjAwJTJDJTBBJTdE",highlighted:`device_map = {
    <span class="hljs-string">&quot;transformer.word_embeddings&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.word_embeddings_layernorm&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;lm_head&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
    <span class="hljs-string">&quot;transformer.h&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.ln_f&quot;</span>: <span class="hljs-number">0</span>,
}`,wrap:!1}}),pe=new v({props:{code:"bW9kZWxfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJiaWdzY2llbmNlJTJGYmxvb20tMWI3JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRGRldmljZV9tYXAlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSk=",highlighted:`model_8bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>,
    device_map=device_map,
    quantization_config=quantization_config,
)`,wrap:!1}}),me=new I({props:{title:"Outlier threshold",local:"outlier-threshold",headingTag:"h4"}}),fe=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJiaWdzY2llbmNlJTJGYmxvb20tMWI3JTIyJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsbG1faW50OF90aHJlc2hvbGQlM0QxMCUyQyUwQSklMEElMEFtb2RlbF84Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRGRldmljZV9tYXAlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

model_id = <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>

quantization_config = BitsAndBytesConfig(
    llm_int8_threshold=<span class="hljs-number">10</span>,
)

model_8bit = AutoModelForCausalLM.from_pretrained(
    model_id,
    device_map=device_map,
    quantization_config=quantization_config,
)`,wrap:!1}}),he=new I({props:{title:"Skip module conversion",local:"skip-module-conversion",headingTag:"h4"}}),ge=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYmlnc2NpZW5jZSUyRmJsb29tLTFiNyUyMiUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbGxtX2ludDhfc2tpcF9tb2R1bGVzJTNEJTVCJTIybG1faGVhZCUyMiU1RCUyQyUwQSklMEElMEFtb2RlbF84Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig

model_id = <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>

quantization_config = BitsAndBytesConfig(
    llm_int8_skip_modules=[<span class="hljs-string">&quot;lm_head&quot;</span>],
)

model_8bit = AutoModelForCausalLM.from_pretrained(
    model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    quantization_config=quantization_config,
)`,wrap:!1}}),be=new I({props:{title:"Finetuning",local:"finetuning",headingTag:"h4"}}),ye=new I({props:{title:"4-bit",local:"4-bit",headingTag:"h3"}}),E=new B({props:{$$slots:{default:[Ws]},$$scope:{ctx:_}}}),we=new I({props:{title:"Compute data type",local:"compute-data-type",headingTag:"h4"}}),Je=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16)`,wrap:!1}}),_e=new I({props:{title:"Normal Float 4 (NF4)",local:"normal-float-4-nf4",headingTag:"h4"}}),Ue=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQW5mNF9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEEpJTBBJTBBbW9kZWxfbmY0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRG5mNF9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

nf4_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

model_nf4 = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=nf4_config)`,wrap:!1}}),Ce=new I({props:{title:"Nested quantization",local:"nested-quantization",headingTag:"h4"}}),ke=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQWRvdWJsZV9xdWFudF9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBKSUwQSUwQW1vZGVsX2RvdWJsZV9xdWFudCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi0xM2IlMjIlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEZG91YmxlX3F1YW50X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

double_quant_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

model_double_quant = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-13b&quot;</span>, quantization_config=double_quant_config)`,wrap:!1}}),Ze=new I({props:{title:"Optimum",local:"optimum",headingTag:"h2"}}),Ie=new I({props:{title:"Benchmarks",local:"benchmarks",headingTag:"h2"}}),Be=new I({props:{title:"Fused AWQ modules",local:"fused-awq-modules",headingTag:"h3"}}),{c(){n=p("meta"),y=s(),o=p("p"),M=s(),u(r.$$.fragment),T=s(),U=p("p"),U.textContent=C,w=s(),q=p("p"),q.textContent=Z,j=s(),u(k.$$.fragment),$=s(),u(G.$$.fragment),J=s(),z=p("p"),z.innerHTML=Da,Ae=s(),O=p("p"),O.innerHTML=Ka,Ne=s(),tt=p("p"),tt.innerHTML=Oa,He=s(),u(et.$$.fragment),Ee=s(),lt=p("p"),lt.textContent=tn,Ye=s(),at=p("p"),at.innerHTML=en,Pe=s(),u(nt.$$.fragment),Se=s(),st=p("p"),st.innerHTML=ln,De=s(),u(it.$$.fragment),Ke=s(),ot=p("p"),ot.textContent=an,Oe=s(),rt=p("table"),rt.innerHTML=nn,tl=s(),u(pt.$$.fragment),el=s(),u(W.$$.fragment),ll=s(),mt=p("p"),mt.innerHTML=sn,al=s(),dt=p("p"),dt.innerHTML=on,nl=s(),ut=p("p"),ut.textContent=rn,sl=s(),u(ft.$$.fragment),il=s(),ht=p("p"),ht.innerHTML=pn,ol=s(),u(ct.$$.fragment),rl=s(),gt=p("p"),gt.innerHTML=mn,pl=s(),u(bt.$$.fragment),ml=s(),Mt=p("p"),Mt.innerHTML=dn,dl=s(),u(yt.$$.fragment),ul=s(),Tt=p("p"),Tt.innerHTML=un,fl=s(),u(wt.$$.fragment),hl=s(),u($t.$$.fragment),cl=s(),Jt=p("p"),Jt.innerHTML=fn,gl=s(),u(F.$$.fragment),bl=s(),u(V.$$.fragment),Ml=s(),u(_t.$$.fragment),yl=s(),u(x.$$.fragment),Tl=s(),vt=p("p"),vt.innerHTML=hn,wl=s(),Ut=p("p"),Ut.textContent=cn,$l=s(),u(jt.$$.fragment),Jl=s(),Ct=p("p"),Ct.innerHTML=gn,_l=s(),u(qt.$$.fragment),vl=s(),kt=p("p"),kt.textContent=bn,Ul=s(),u(Zt.$$.fragment),jl=s(),Gt=p("p"),Gt.innerHTML=Mn,Cl=s(),u(It.$$.fragment),ql=s(),zt=p("p"),zt.innerHTML=yn,kl=s(),u(Qt.$$.fragment),Zl=s(),u(X.$$.fragment),Gl=s(),Bt=p("p"),Bt.innerHTML=Tn,Il=s(),u(Wt.$$.fragment),zl=s(),Ft=p("p"),Ft.innerHTML=wn,Ql=s(),u(Vt.$$.fragment),Bl=s(),xt=p("p"),xt.innerHTML=$n,Wl=s(),u(Xt.$$.fragment),Fl=s(),u(Rt.$$.fragment),Vl=s(),Lt=p("p"),Lt.innerHTML=Jn,xl=s(),u(At.$$.fragment),Xl=s(),u(R.$$.fragment),Rl=s(),Nt=p("p"),Nt.textContent=_n,Ll=s(),u(Ht.$$.fragment),Al=s(),u(Et.$$.fragment),Nl=s(),Yt=p("p"),Yt.innerHTML=vn,Hl=s(),Pt=p("p"),Pt.textContent=Un,El=s(),u(L.$$.fragment),Yl=s(),St=p("p"),St.innerHTML=jn,Pl=s(),u(A.$$.fragment),Sl=s(),u(N.$$.fragment),Dl=s(),Dt=p("p"),Dt.innerHTML=Cn,Kl=s(),u(Kt.$$.fragment),Ol=s(),Ot=p("p"),Ot.innerHTML=qn,ta=s(),u(te.$$.fragment),ea=s(),u(ee.$$.fragment),la=s(),u(H.$$.fragment),aa=s(),le=p("p"),le.textContent=kn,na=s(),u(ae.$$.fragment),sa=s(),ne=p("p"),ne.innerHTML=Zn,ia=s(),u(se.$$.fragment),oa=s(),ie=p("p"),ie.innerHTML=Gn,ra=s(),u(oe.$$.fragment),pa=s(),re=p("p"),re.innerHTML=In,ma=s(),u(pe.$$.fragment),da=s(),u(me.$$.fragment),ua=s(),de=p("p"),de.textContent=zn,fa=s(),ue=p("p"),ue.innerHTML=Qn,ha=s(),u(fe.$$.fragment),ca=s(),u(he.$$.fragment),ga=s(),ce=p("p"),ce.innerHTML=Bn,ba=s(),u(ge.$$.fragment),Ma=s(),u(be.$$.fragment),ya=s(),Me=p("p"),Me.innerHTML=Wn,Ta=s(),u(ye.$$.fragment),wa=s(),u(E.$$.fragment),$a=s(),Te=p("p"),Te.textContent=Fn,Ja=s(),u(we.$$.fragment),_a=s(),$e=p("p"),$e.innerHTML=Vn,va=s(),u(Je.$$.fragment),Ua=s(),u(_e.$$.fragment),ja=s(),ve=p("p"),ve.innerHTML=xn,Ca=s(),u(Ue.$$.fragment),qa=s(),je=p("p"),je.innerHTML=Xn,ka=s(),u(Ce.$$.fragment),Za=s(),qe=p("p"),qe.innerHTML=Rn,Ga=s(),u(ke.$$.fragment),Ia=s(),u(Ze.$$.fragment),za=s(),Ge=p("p"),Ge.innerHTML=Ln,Qa=s(),u(Ie.$$.fragment),Ba=s(),ze=p("p"),ze.innerHTML=An,Wa=s(),Y=p("div"),Y.innerHTML=Nn,Fa=s(),P=p("div"),P.innerHTML=Hn,Va=s(),Qe=p("p"),Qe.innerHTML=En,xa=s(),u(Be.$$.fragment),Xa=s(),We=p("p"),We.innerHTML=Yn,Ra=s(),S=p("figcaption"),S.textContent=Pn,La=s(),Fe=p("table"),Fe.innerHTML=Sn,Aa=s(),D=p("figcaption"),D.textContent=Dn,Na=s(),Ve=p("table"),Ve.innerHTML=Kn,Ha=s(),xe=p("p"),xe.innerHTML=On,Ea=s(),K=p("div"),K.innerHTML=ts,Ya=s(),Le=p("p"),this.h()},l(t){const e=Ms("svelte-u9bgzb",document.head);n=m(e,"META",{name:!0,content:!0}),e.forEach(l),y=i(t),o=m(t,"P",{}),fs(o).forEach(l),M=i(t),f(r.$$.fragment,t),T=i(t),U=m(t,"P",{"data-svelte-h":!0}),d(U)!=="svelte-1euzkei"&&(U.textContent=C),w=i(t),q=m(t,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1f5pv07"&&(q.textContent=Z),j=i(t),f(k.$$.fragment,t),$=i(t),f(G.$$.fragment,t),J=i(t),z=m(t,"P",{"data-svelte-h":!0}),d(z)!=="svelte-vu1jh7"&&(z.innerHTML=Da),Ae=i(t),O=m(t,"P",{"data-svelte-h":!0}),d(O)!=="svelte-11fbd25"&&(O.innerHTML=Ka),Ne=i(t),tt=m(t,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-1rdkef8"&&(tt.innerHTML=Oa),He=i(t),f(et.$$.fragment,t),Ee=i(t),lt=m(t,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-6sf1ac"&&(lt.textContent=tn),Ye=i(t),at=m(t,"P",{"data-svelte-h":!0}),d(at)!=="svelte-mrigan"&&(at.innerHTML=en),Pe=i(t),f(nt.$$.fragment,t),Se=i(t),st=m(t,"P",{"data-svelte-h":!0}),d(st)!=="svelte-1uurbap"&&(st.innerHTML=ln),De=i(t),f(it.$$.fragment,t),Ke=i(t),ot=m(t,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-14j9yls"&&(ot.textContent=an),Oe=i(t),rt=m(t,"TABLE",{"data-svelte-h":!0}),d(rt)!=="svelte-mgp7ro"&&(rt.innerHTML=nn),tl=i(t),f(pt.$$.fragment,t),el=i(t),f(W.$$.fragment,t),ll=i(t),mt=m(t,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-1c5vyni"&&(mt.innerHTML=sn),al=i(t),dt=m(t,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-vomabp"&&(dt.innerHTML=on),nl=i(t),ut=m(t,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-1ozln1k"&&(ut.textContent=rn),sl=i(t),f(ft.$$.fragment,t),il=i(t),ht=m(t,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1lxz9t"&&(ht.innerHTML=pn),ol=i(t),f(ct.$$.fragment,t),rl=i(t),gt=m(t,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-108eg93"&&(gt.innerHTML=mn),pl=i(t),f(bt.$$.fragment,t),ml=i(t),Mt=m(t,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-19un5li"&&(Mt.innerHTML=dn),dl=i(t),f(yt.$$.fragment,t),ul=i(t),Tt=m(t,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-ptrt24"&&(Tt.innerHTML=un),fl=i(t),f(wt.$$.fragment,t),hl=i(t),f($t.$$.fragment,t),cl=i(t),Jt=m(t,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-jywid1"&&(Jt.innerHTML=fn),gl=i(t),f(F.$$.fragment,t),bl=i(t),f(V.$$.fragment,t),Ml=i(t),f(_t.$$.fragment,t),yl=i(t),f(x.$$.fragment,t),Tl=i(t),vt=m(t,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-sq0x7n"&&(vt.innerHTML=hn),wl=i(t),Ut=m(t,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-13c61n1"&&(Ut.textContent=cn),$l=i(t),f(jt.$$.fragment,t),Jl=i(t),Ct=m(t,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-ur342m"&&(Ct.innerHTML=gn),_l=i(t),f(qt.$$.fragment,t),vl=i(t),kt=m(t,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-1cjo88z"&&(kt.textContent=bn),Ul=i(t),f(Zt.$$.fragment,t),jl=i(t),Gt=m(t,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-13cn5o4"&&(Gt.innerHTML=Mn),Cl=i(t),f(It.$$.fragment,t),ql=i(t),zt=m(t,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-1tle3a0"&&(zt.innerHTML=yn),kl=i(t),f(Qt.$$.fragment,t),Zl=i(t),f(X.$$.fragment,t),Gl=i(t),Bt=m(t,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-jjj96e"&&(Bt.innerHTML=Tn),Il=i(t),f(Wt.$$.fragment,t),zl=i(t),Ft=m(t,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-l9o6va"&&(Ft.innerHTML=wn),Ql=i(t),f(Vt.$$.fragment,t),Bl=i(t),xt=m(t,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-42jvja"&&(xt.innerHTML=$n),Wl=i(t),f(Xt.$$.fragment,t),Fl=i(t),f(Rt.$$.fragment,t),Vl=i(t),Lt=m(t,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1y1pnbl"&&(Lt.innerHTML=Jn),xl=i(t),f(At.$$.fragment,t),Xl=i(t),f(R.$$.fragment,t),Rl=i(t),Nt=m(t,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-m9nw5y"&&(Nt.textContent=_n),Ll=i(t),f(Ht.$$.fragment,t),Al=i(t),f(Et.$$.fragment,t),Nl=i(t),Yt=m(t,"P",{"data-svelte-h":!0}),d(Yt)!=="svelte-5a92xi"&&(Yt.innerHTML=vn),Hl=i(t),Pt=m(t,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-gf36q7"&&(Pt.textContent=Un),El=i(t),f(L.$$.fragment,t),Yl=i(t),St=m(t,"P",{"data-svelte-h":!0}),d(St)!=="svelte-1tamrid"&&(St.innerHTML=jn),Pl=i(t),f(A.$$.fragment,t),Sl=i(t),f(N.$$.fragment,t),Dl=i(t),Dt=m(t,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-1bxp667"&&(Dt.innerHTML=Cn),Kl=i(t),f(Kt.$$.fragment,t),Ol=i(t),Ot=m(t,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-17ps4nd"&&(Ot.innerHTML=qn),ta=i(t),f(te.$$.fragment,t),ea=i(t),f(ee.$$.fragment,t),la=i(t),f(H.$$.fragment,t),aa=i(t),le=m(t,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1yx1x2g"&&(le.textContent=kn),na=i(t),f(ae.$$.fragment,t),sa=i(t),ne=m(t,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1v0jh01"&&(ne.innerHTML=Zn),ia=i(t),f(se.$$.fragment,t),oa=i(t),ie=m(t,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-15oy7am"&&(ie.innerHTML=Gn),ra=i(t),f(oe.$$.fragment,t),pa=i(t),re=m(t,"P",{"data-svelte-h":!0}),d(re)!=="svelte-k1g8c2"&&(re.innerHTML=In),ma=i(t),f(pe.$$.fragment,t),da=i(t),f(me.$$.fragment,t),ua=i(t),de=m(t,"P",{"data-svelte-h":!0}),d(de)!=="svelte-ur5rgd"&&(de.textContent=zn),fa=i(t),ue=m(t,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-v5sezx"&&(ue.innerHTML=Qn),ha=i(t),f(fe.$$.fragment,t),ca=i(t),f(he.$$.fragment,t),ga=i(t),ce=m(t,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1ba1s3u"&&(ce.innerHTML=Bn),ba=i(t),f(ge.$$.fragment,t),Ma=i(t),f(be.$$.fragment,t),ya=i(t),Me=m(t,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-4nvx4q"&&(Me.innerHTML=Wn),Ta=i(t),f(ye.$$.fragment,t),wa=i(t),f(E.$$.fragment,t),$a=i(t),Te=m(t,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-7ob7j"&&(Te.textContent=Fn),Ja=i(t),f(we.$$.fragment,t),_a=i(t),$e=m(t,"P",{"data-svelte-h":!0}),d($e)!=="svelte-15j4whk"&&($e.innerHTML=Vn),va=i(t),f(Je.$$.fragment,t),Ua=i(t),f(_e.$$.fragment,t),ja=i(t),ve=m(t,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-7qr54g"&&(ve.innerHTML=xn),Ca=i(t),f(Ue.$$.fragment,t),qa=i(t),je=m(t,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1qoc2ct"&&(je.innerHTML=Xn),ka=i(t),f(Ce.$$.fragment,t),Za=i(t),qe=m(t,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-l0u9eq"&&(qe.innerHTML=Rn),Ga=i(t),f(ke.$$.fragment,t),Ia=i(t),f(Ze.$$.fragment,t),za=i(t),Ge=m(t,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-opujmz"&&(Ge.innerHTML=Ln),Qa=i(t),f(Ie.$$.fragment,t),Ba=i(t),ze=m(t,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-10oh9lm"&&(ze.innerHTML=An),Wa=i(t),Y=m(t,"DIV",{class:!0,"data-svelte-h":!0}),d(Y)!=="svelte-10jjm5l"&&(Y.innerHTML=Nn),Fa=i(t),P=m(t,"DIV",{class:!0,"data-svelte-h":!0}),d(P)!=="svelte-48at03"&&(P.innerHTML=Hn),Va=i(t),Qe=m(t,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-1sm7gom"&&(Qe.innerHTML=En),xa=i(t),f(Be.$$.fragment,t),Xa=i(t),We=m(t,"P",{"data-svelte-h":!0}),d(We)!=="svelte-81zmsw"&&(We.innerHTML=Yn),Ra=i(t),S=m(t,"FIGCAPTION",{class:!0,"data-svelte-h":!0}),d(S)!=="svelte-grefv0"&&(S.textContent=Pn),La=i(t),Fe=m(t,"TABLE",{"data-svelte-h":!0}),d(Fe)!=="svelte-19aactm"&&(Fe.innerHTML=Sn),Aa=i(t),D=m(t,"FIGCAPTION",{class:!0,"data-svelte-h":!0}),d(D)!=="svelte-1r15bg7"&&(D.textContent=Dn),Na=i(t),Ve=m(t,"TABLE",{"data-svelte-h":!0}),d(Ve)!=="svelte-19fczbk"&&(Ve.innerHTML=Kn),Ha=i(t),xe=m(t,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-gu8e8k"&&(xe.innerHTML=On),Ea=i(t),K=m(t,"DIV",{class:!0,"data-svelte-h":!0}),d(K)!=="svelte-1ke50ja"&&(K.innerHTML=ts),Ya=i(t),Le=m(t,"P",{}),fs(Le).forEach(l),this.h()},h(){Xe(n,"name","hf:doc:metadata"),Xe(n,"content",Vs),Xe(Y,"class","flex gap-4"),Xe(P,"class","flex gap-4"),Xe(S,"class","text-center text-gray-500 text-lg"),Xe(D,"class","text-center text-gray-500 text-lg"),Xe(K,"class","flex gap-4")},m(t,e){ys(document.head,n),a(t,y,e),a(t,o,e),a(t,M,e),h(r,t,e),a(t,T,e),a(t,U,e),a(t,w,e),a(t,q,e),a(t,j,e),h(k,t,e),a(t,$,e),h(G,t,e),a(t,J,e),a(t,z,e),a(t,Ae,e),a(t,O,e),a(t,Ne,e),a(t,tt,e),a(t,He,e),h(et,t,e),a(t,Ee,e),a(t,lt,e),a(t,Ye,e),a(t,at,e),a(t,Pe,e),h(nt,t,e),a(t,Se,e),a(t,st,e),a(t,De,e),h(it,t,e),a(t,Ke,e),a(t,ot,e),a(t,Oe,e),a(t,rt,e),a(t,tl,e),h(pt,t,e),a(t,el,e),h(W,t,e),a(t,ll,e),a(t,mt,e),a(t,al,e),a(t,dt,e),a(t,nl,e),a(t,ut,e),a(t,sl,e),h(ft,t,e),a(t,il,e),a(t,ht,e),a(t,ol,e),h(ct,t,e),a(t,rl,e),a(t,gt,e),a(t,pl,e),h(bt,t,e),a(t,ml,e),a(t,Mt,e),a(t,dl,e),h(yt,t,e),a(t,ul,e),a(t,Tt,e),a(t,fl,e),h(wt,t,e),a(t,hl,e),h($t,t,e),a(t,cl,e),a(t,Jt,e),a(t,gl,e),h(F,t,e),a(t,bl,e),h(V,t,e),a(t,Ml,e),h(_t,t,e),a(t,yl,e),h(x,t,e),a(t,Tl,e),a(t,vt,e),a(t,wl,e),a(t,Ut,e),a(t,$l,e),h(jt,t,e),a(t,Jl,e),a(t,Ct,e),a(t,_l,e),h(qt,t,e),a(t,vl,e),a(t,kt,e),a(t,Ul,e),h(Zt,t,e),a(t,jl,e),a(t,Gt,e),a(t,Cl,e),h(It,t,e),a(t,ql,e),a(t,zt,e),a(t,kl,e),h(Qt,t,e),a(t,Zl,e),h(X,t,e),a(t,Gl,e),a(t,Bt,e),a(t,Il,e),h(Wt,t,e),a(t,zl,e),a(t,Ft,e),a(t,Ql,e),h(Vt,t,e),a(t,Bl,e),a(t,xt,e),a(t,Wl,e),h(Xt,t,e),a(t,Fl,e),h(Rt,t,e),a(t,Vl,e),a(t,Lt,e),a(t,xl,e),h(At,t,e),a(t,Xl,e),h(R,t,e),a(t,Rl,e),a(t,Nt,e),a(t,Ll,e),h(Ht,t,e),a(t,Al,e),h(Et,t,e),a(t,Nl,e),a(t,Yt,e),a(t,Hl,e),a(t,Pt,e),a(t,El,e),h(L,t,e),a(t,Yl,e),a(t,St,e),a(t,Pl,e),h(A,t,e),a(t,Sl,e),h(N,t,e),a(t,Dl,e),a(t,Dt,e),a(t,Kl,e),h(Kt,t,e),a(t,Ol,e),a(t,Ot,e),a(t,ta,e),h(te,t,e),a(t,ea,e),h(ee,t,e),a(t,la,e),h(H,t,e),a(t,aa,e),a(t,le,e),a(t,na,e),h(ae,t,e),a(t,sa,e),a(t,ne,e),a(t,ia,e),h(se,t,e),a(t,oa,e),a(t,ie,e),a(t,ra,e),h(oe,t,e),a(t,pa,e),a(t,re,e),a(t,ma,e),h(pe,t,e),a(t,da,e),h(me,t,e),a(t,ua,e),a(t,de,e),a(t,fa,e),a(t,ue,e),a(t,ha,e),h(fe,t,e),a(t,ca,e),h(he,t,e),a(t,ga,e),a(t,ce,e),a(t,ba,e),h(ge,t,e),a(t,Ma,e),h(be,t,e),a(t,ya,e),a(t,Me,e),a(t,Ta,e),h(ye,t,e),a(t,wa,e),h(E,t,e),a(t,$a,e),a(t,Te,e),a(t,Ja,e),h(we,t,e),a(t,_a,e),a(t,$e,e),a(t,va,e),h(Je,t,e),a(t,Ua,e),h(_e,t,e),a(t,ja,e),a(t,ve,e),a(t,Ca,e),h(Ue,t,e),a(t,qa,e),a(t,je,e),a(t,ka,e),h(Ce,t,e),a(t,Za,e),a(t,qe,e),a(t,Ga,e),h(ke,t,e),a(t,Ia,e),h(Ze,t,e),a(t,za,e),a(t,Ge,e),a(t,Qa,e),h(Ie,t,e),a(t,Ba,e),a(t,ze,e),a(t,Wa,e),a(t,Y,e),a(t,Fa,e),a(t,P,e),a(t,Va,e),a(t,Qe,e),a(t,xa,e),h(Be,t,e),a(t,Xa,e),a(t,We,e),a(t,Ra,e),a(t,S,e),a(t,La,e),a(t,Fe,e),a(t,Aa,e),a(t,D,e),a(t,Na,e),a(t,Ve,e),a(t,Ha,e),a(t,xe,e),a(t,Ea,e),a(t,K,e),a(t,Ya,e),a(t,Le,e),Pa=!0},p(t,[e]){const es={};e&2&&(es.$$scope={dirty:e,ctx:t}),k.$set(es);const ls={};e&2&&(ls.$$scope={dirty:e,ctx:t}),W.$set(ls);const as={};e&2&&(as.$$scope={dirty:e,ctx:t}),F.$set(as);const ns={};e&2&&(ns.$$scope={dirty:e,ctx:t}),V.$set(ns);const ss={};e&2&&(ss.$$scope={dirty:e,ctx:t}),x.$set(ss);const is={};e&2&&(is.$$scope={dirty:e,ctx:t}),X.$set(is);const os={};e&2&&(os.$$scope={dirty:e,ctx:t}),R.$set(os);const rs={};e&2&&(rs.$$scope={dirty:e,ctx:t}),L.$set(rs);const ps={};e&2&&(ps.$$scope={dirty:e,ctx:t}),A.$set(ps);const ms={};e&2&&(ms.$$scope={dirty:e,ctx:t}),N.$set(ms);const ds={};e&2&&(ds.$$scope={dirty:e,ctx:t}),H.$set(ds);const us={};e&2&&(us.$$scope={dirty:e,ctx:t}),E.$set(us)},i(t){Pa||(c(r.$$.fragment,t),c(k.$$.fragment,t),c(G.$$.fragment,t),c(et.$$.fragment,t),c(nt.$$.fragment,t),c(it.$$.fragment,t),c(pt.$$.fragment,t),c(W.$$.fragment,t),c(ft.$$.fragment,t),c(ct.$$.fragment,t),c(bt.$$.fragment,t),c(yt.$$.fragment,t),c(wt.$$.fragment,t),c($t.$$.fragment,t),c(F.$$.fragment,t),c(V.$$.fragment,t),c(_t.$$.fragment,t),c(x.$$.fragment,t),c(jt.$$.fragment,t),c(qt.$$.fragment,t),c(Zt.$$.fragment,t),c(It.$$.fragment,t),c(Qt.$$.fragment,t),c(X.$$.fragment,t),c(Wt.$$.fragment,t),c(Vt.$$.fragment,t),c(Xt.$$.fragment,t),c(Rt.$$.fragment,t),c(At.$$.fragment,t),c(R.$$.fragment,t),c(Ht.$$.fragment,t),c(Et.$$.fragment,t),c(L.$$.fragment,t),c(A.$$.fragment,t),c(N.$$.fragment,t),c(Kt.$$.fragment,t),c(te.$$.fragment,t),c(ee.$$.fragment,t),c(H.$$.fragment,t),c(ae.$$.fragment,t),c(se.$$.fragment,t),c(oe.$$.fragment,t),c(pe.$$.fragment,t),c(me.$$.fragment,t),c(fe.$$.fragment,t),c(he.$$.fragment,t),c(ge.$$.fragment,t),c(be.$$.fragment,t),c(ye.$$.fragment,t),c(E.$$.fragment,t),c(we.$$.fragment,t),c(Je.$$.fragment,t),c(_e.$$.fragment,t),c(Ue.$$.fragment,t),c(Ce.$$.fragment,t),c(ke.$$.fragment,t),c(Ze.$$.fragment,t),c(Ie.$$.fragment,t),c(Be.$$.fragment,t),Pa=!0)},o(t){g(r.$$.fragment,t),g(k.$$.fragment,t),g(G.$$.fragment,t),g(et.$$.fragment,t),g(nt.$$.fragment,t),g(it.$$.fragment,t),g(pt.$$.fragment,t),g(W.$$.fragment,t),g(ft.$$.fragment,t),g(ct.$$.fragment,t),g(bt.$$.fragment,t),g(yt.$$.fragment,t),g(wt.$$.fragment,t),g($t.$$.fragment,t),g(F.$$.fragment,t),g(V.$$.fragment,t),g(_t.$$.fragment,t),g(x.$$.fragment,t),g(jt.$$.fragment,t),g(qt.$$.fragment,t),g(Zt.$$.fragment,t),g(It.$$.fragment,t),g(Qt.$$.fragment,t),g(X.$$.fragment,t),g(Wt.$$.fragment,t),g(Vt.$$.fragment,t),g(Xt.$$.fragment,t),g(Rt.$$.fragment,t),g(At.$$.fragment,t),g(R.$$.fragment,t),g(Ht.$$.fragment,t),g(Et.$$.fragment,t),g(L.$$.fragment,t),g(A.$$.fragment,t),g(N.$$.fragment,t),g(Kt.$$.fragment,t),g(te.$$.fragment,t),g(ee.$$.fragment,t),g(H.$$.fragment,t),g(ae.$$.fragment,t),g(se.$$.fragment,t),g(oe.$$.fragment,t),g(pe.$$.fragment,t),g(me.$$.fragment,t),g(fe.$$.fragment,t),g(he.$$.fragment,t),g(ge.$$.fragment,t),g(be.$$.fragment,t),g(ye.$$.fragment,t),g(E.$$.fragment,t),g(we.$$.fragment,t),g(Je.$$.fragment,t),g(_e.$$.fragment,t),g(Ue.$$.fragment,t),g(Ce.$$.fragment,t),g(ke.$$.fragment,t),g(Ze.$$.fragment,t),g(Ie.$$.fragment,t),g(Be.$$.fragment,t),Pa=!1},d(t){t&&(l(y),l(o),l(M),l(T),l(U),l(w),l(q),l(j),l($),l(J),l(z),l(Ae),l(O),l(Ne),l(tt),l(He),l(Ee),l(lt),l(Ye),l(at),l(Pe),l(Se),l(st),l(De),l(Ke),l(ot),l(Oe),l(rt),l(tl),l(el),l(ll),l(mt),l(al),l(dt),l(nl),l(ut),l(sl),l(il),l(ht),l(ol),l(rl),l(gt),l(pl),l(ml),l(Mt),l(dl),l(ul),l(Tt),l(fl),l(hl),l(cl),l(Jt),l(gl),l(bl),l(Ml),l(yl),l(Tl),l(vt),l(wl),l(Ut),l($l),l(Jl),l(Ct),l(_l),l(vl),l(kt),l(Ul),l(jl),l(Gt),l(Cl),l(ql),l(zt),l(kl),l(Zl),l(Gl),l(Bt),l(Il),l(zl),l(Ft),l(Ql),l(Bl),l(xt),l(Wl),l(Fl),l(Vl),l(Lt),l(xl),l(Xl),l(Rl),l(Nt),l(Ll),l(Al),l(Nl),l(Yt),l(Hl),l(Pt),l(El),l(Yl),l(St),l(Pl),l(Sl),l(Dl),l(Dt),l(Kl),l(Ol),l(Ot),l(ta),l(ea),l(la),l(aa),l(le),l(na),l(sa),l(ne),l(ia),l(oa),l(ie),l(ra),l(pa),l(re),l(ma),l(da),l(ua),l(de),l(fa),l(ue),l(ha),l(ca),l(ga),l(ce),l(ba),l(Ma),l(ya),l(Me),l(Ta),l(wa),l($a),l(Te),l(Ja),l(_a),l($e),l(va),l(Ua),l(ja),l(ve),l(Ca),l(qa),l(je),l(ka),l(Za),l(qe),l(Ga),l(Ia),l(za),l(Ge),l(Qa),l(Ba),l(ze),l(Wa),l(Y),l(Fa),l(P),l(Va),l(Qe),l(xa),l(Xa),l(We),l(Ra),l(S),l(La),l(Fe),l(Aa),l(D),l(Na),l(Ve),l(Ha),l(xe),l(Ea),l(K),l(Ya),l(Le)),l(n),b(r,t),b(k,t),b(G,t),b(et,t),b(nt,t),b(it,t),b(pt,t),b(W,t),b(ft,t),b(ct,t),b(bt,t),b(yt,t),b(wt,t),b($t,t),b(F,t),b(V,t),b(_t,t),b(x,t),b(jt,t),b(qt,t),b(Zt,t),b(It,t),b(Qt,t),b(X,t),b(Wt,t),b(Vt,t),b(Xt,t),b(Rt,t),b(At,t),b(R,t),b(Ht,t),b(Et,t),b(L,t),b(A,t),b(N,t),b(Kt,t),b(te,t),b(ee,t),b(H,t),b(ae,t),b(se,t),b(oe,t),b(pe,t),b(me,t),b(fe,t),b(he,t),b(ge,t),b(be,t),b(ye,t),b(E,t),b(we,t),b(Je,t),b(_e,t),b(Ue,t),b(Ce,t),b(ke,t),b(Ze,t),b(Ie,t),b(Be,t)}}}const Vs='{"title":"Quantization","local":"quantization","sections":[{"title":"AQLM","local":"aqlm","sections":[{"title":"PEFT","local":"peft","sections":[],"depth":3},{"title":"AQLM configurations","local":"aqlm-configurations","sections":[],"depth":3}],"depth":2},{"title":"AWQ","local":"awq","sections":[{"title":"Fused modules","local":"fused-modules","sections":[],"depth":3}],"depth":2},{"title":"AutoGPTQ","local":"autogptq","sections":[{"title":"ExLlama","local":"exllama","sections":[],"depth":3}],"depth":2},{"title":"bitsandbytes","local":"bitsandbytes","sections":[{"title":"8-bit","local":"8-bit","sections":[{"title":"Offloading","local":"offloading","sections":[],"depth":4},{"title":"Outlier threshold","local":"outlier-threshold","sections":[],"depth":4},{"title":"Skip module conversion","local":"skip-module-conversion","sections":[],"depth":4},{"title":"Finetuning","local":"finetuning","sections":[],"depth":4}],"depth":3},{"title":"4-bit","local":"4-bit","sections":[{"title":"Compute data type","local":"compute-data-type","sections":[],"depth":4},{"title":"Normal Float 4 (NF4)","local":"normal-float-4-nf4","sections":[],"depth":4},{"title":"Nested quantization","local":"nested-quantization","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Optimum","local":"optimum","sections":[],"depth":2},{"title":"Benchmarks","local":"benchmarks","sections":[{"title":"Fused AWQ modules","local":"fused-awq-modules","sections":[],"depth":3}],"depth":2}],"depth":1}';function xs(_){return cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Es extends gs{constructor(n){super(),bs(this,n,xs,Fs,hs,{})}}export{Es as component};
