import{s as Ot,o as te,n as ee}from"../chunks/scheduler.9bc65507.js";import{S as se,i as le,g as i,s as a,r,A as ae,h as p,f as s,c as n,j as Kt,u as h,x as o,k as K,y as ne,a as l,v as c,d,t as u,w as g,m as ie,n as pe}from"../chunks/index.707bf1b6.js";import{T as oe}from"../chunks/Tip.c2ecdbf4.js";import{C as w}from"../chunks/CodeBlock.54a9f38d.js";import{H as _t}from"../chunks/Heading.342b1fa6.js";function me(O){let m,f,b='<a href="../model_doc/depth_anything">Depth Anything</a>, <a href="../model_doc/dpt">DPT</a>, <a href="../model_doc/glpn">GLPN</a>';return{c(){m=ie(`The task illustrated in this tutorial is supported by the following model architectures:

`),f=i("p"),f.innerHTML=b},l(y){m=pe(y,`The task illustrated in this tutorial is supported by the following model architectures:

`),f=p(y,"P",{"data-svelte-h":!0}),o(f)!=="svelte-7k3qdm"&&(f.innerHTML=b)},m(y,M){l(y,m,M),l(y,f,M)},p:ee,d(y){y&&(s(m),s(f))}}}function re(O){let m,f,b,y,M,tt,J,Rt=`Monocular depth estimation is a computer vision task that involves predicting the depth information of a scene from a
single image. In other words, it is the process of estimating the distance of objects in a scene from
a single camera viewpoint.`,et,U,Gt=`Monocular depth estimation has various applications, including 3D reconstruction, augmented reality, autonomous driving,
and robotics. It is a challenging task as it requires the model to understand the complex relationships between objects
in the scene and the corresponding depth information, which can be affected by factors such as lighting conditions,
occlusion, and texture.`,st,$,lt,C,Bt="In this guide you’ll learn how to:",at,k,Ht="<li>create a depth estimation pipeline</li> <li>run depth estimation inference by hand</li>",nt,x,It="Before you begin, make sure you have all the necessary libraries installed:",it,Z,pt,W,ot,_,zt=`The simplest way to try out inference with a model supporting depth estimation is to use the corresponding <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>.
Instantiate a pipeline from a <a href="https://huggingface.co/models?pipeline_tag=depth-estimation&amp;sort=downloads" rel="nofollow">checkpoint on the Hugging Face Hub</a>:`,mt,R,rt,G,Vt="Next, choose an image to analyze:",ht,B,ct,j,Et='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/depth-estimation-example.jpg" alt="Photo of a busy street"/>',dt,H,Nt="Pass the image to the pipeline.",ut,I,gt,z,Xt=`The pipeline returns a dictionary with two entries. The first one, called <code>predicted_depth</code>, is a tensor with the values
being the depth expressed in meters for each pixel.
The second one, <code>depth</code>, is a PIL image that visualizes the depth estimation result.`,ft,V,Qt="Let’s take a look at the visualized result:",yt,E,Mt,v,Ft='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/depth-visualization.png" alt="Depth estimation visualization"/>',wt,N,bt,X,Yt="Now that you’ve seen how to use the depth estimation pipeline, let’s see how we can replicate the same result by hand.",$t,Q,Pt=`Start by loading the model and associated processor from a <a href="https://huggingface.co/models?pipeline_tag=depth-estimation&amp;sort=downloads" rel="nofollow">checkpoint on the Hugging Face Hub</a>.
Here we’ll use the same checkpoint as before:`,jt,F,vt,Y,St=`Prepare the image input for the model using the <code>image_processor</code> that will take care of the necessary image transformations
such as resizing and normalization:`,Tt,P,Jt,S,Lt="Pass the prepared inputs through the model:",Ut,L,Ct,q,qt="Visualize the results:",kt,A,xt,T,At='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/depth-visualization.png" alt="Depth estimation visualization"/>',Zt,D,Wt;return M=new _t({props:{title:"Monocular depth estimation",local:"monocular-depth-estimation",headingTag:"h1"}}),$=new oe({props:{$$slots:{default:[me]},$$scope:{ctx:O}}}),Z=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers",wrap:!1}}),W=new _t({props:{title:"Depth estimation pipeline",local:"depth-estimation-pipeline",headingTag:"h2"}}),R=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMnZpbnZpbm8wMiUyRmdscG4tbnl1JTIyJTBBZGVwdGhfZXN0aW1hdG9yJTIwJTNEJTIwcGlwZWxpbmUoJTIyZGVwdGgtZXN0aW1hdGlvbiUyMiUyQyUyMG1vZGVsJTNEY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;vinvino02/glpn-nyu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth_estimator = pipeline(<span class="hljs-string">&quot;depth-estimation&quot;</span>, model=checkpoint)`,wrap:!1}}),B=new w({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRkh3QkFzU2JQQkRVJTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4elpXRnlZMmg4TXpSOGZHTmhjaVV5TUdsdUpUSXdkR2hsSlRJd2MzUnlaV1YwZkdWdWZEQjhNSHg4ZkRFMk56ZzVNREV3T0RnJTI2Zm9yY2UlM0R0cnVlJTI2dyUzRDY0MCUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/HwBAsSbPBDU/download?ixid=MnwxMjA3fDB8MXxzZWFyY2h8MzR8fGNhciUyMGluJTIwdGhlJTIwc3RyZWV0fGVufDB8MHx8fDE2Nzg5MDEwODg&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),I=new w({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBkZXB0aF9lc3RpbWF0b3IoaW1hZ2Up",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>predictions = depth_estimator(image)',wrap:!1}}),E=new w({props:{code:"cHJlZGljdGlvbnMlNUIlMjJkZXB0aCUyMiU1RA==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>predictions[<span class="hljs-string">&quot;depth&quot;</span>]',wrap:!1}}),N=new _t({props:{title:"Depth estimation inference by hand",local:"depth-estimation-inference-by-hand",headingTag:"h2"}}),F=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbiUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJ2aW52aW5vMDIlMkZnbHBuLW55dSUyMiUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;vinvino02/glpn-nyu&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(checkpoint)`,wrap:!1}}),P=new w({props:{code:"cGl4ZWxfdmFsdWVzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikucGl4ZWxfdmFsdWVz",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values',wrap:!1}}),L=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBpeGVsX3ZhbHVlcyklMEElMjAlMjAlMjAlMjBwcmVkaWN0ZWRfZGVwdGglMjAlM0QlMjBvdXRwdXRzLnByZWRpY3RlZF9kZXB0aA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(pixel_values)
<span class="hljs-meta">... </span>    predicted_depth = outputs.predicted_depth`,wrap:!1}}),A=new w({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTIzJTIwaW50ZXJwb2xhdGUlMjB0byUyMG9yaWdpbmFsJTIwc2l6ZSUwQXByZWRpY3Rpb24lMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLmludGVycG9sYXRlKCUwQSUyMCUyMCUyMCUyMHByZWRpY3RlZF9kZXB0aC51bnNxdWVlemUoMSklMkMlMEElMjAlMjAlMjAlMjBzaXplJTNEaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZSUzRCUyMmJpY3ViaWMlMjIlMkMlMEElMjAlMjAlMjAlMjBhbGlnbl9jb3JuZXJzJTNERmFsc2UlMkMlMEEpLnNxdWVlemUoKSUwQW91dHB1dCUyMCUzRCUyMHByZWRpY3Rpb24ubnVtcHkoKSUwQSUwQWZvcm1hdHRlZCUyMCUzRCUyMChvdXRwdXQlMjAqJTIwMjU1JTIwJTJGJTIwbnAubWF4KG91dHB1dCkpLmFzdHlwZSglMjJ1aW50OCUyMiklMEFkZXB0aCUyMCUzRCUyMEltYWdlLmZyb21hcnJheShmb3JtYXR0ZWQpJTBBZGVwdGg=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction = torch.nn.functional.interpolate(
<span class="hljs-meta">... </span>    predicted_depth.unsqueeze(<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    size=image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>    mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
<span class="hljs-meta">... </span>    align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>).squeeze()
<span class="hljs-meta">&gt;&gt;&gt; </span>output = prediction.numpy()

<span class="hljs-meta">&gt;&gt;&gt; </span>formatted = (output * <span class="hljs-number">255</span> / np.<span class="hljs-built_in">max</span>(output)).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(formatted)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth`,wrap:!1}}),{c(){m=i("meta"),f=a(),b=i("p"),y=a(),r(M.$$.fragment),tt=a(),J=i("p"),J.textContent=Rt,et=a(),U=i("p"),U.textContent=Gt,st=a(),r($.$$.fragment),lt=a(),C=i("p"),C.textContent=Bt,at=a(),k=i("ul"),k.innerHTML=Ht,nt=a(),x=i("p"),x.textContent=It,it=a(),r(Z.$$.fragment),pt=a(),r(W.$$.fragment),ot=a(),_=i("p"),_.innerHTML=zt,mt=a(),r(R.$$.fragment),rt=a(),G=i("p"),G.textContent=Vt,ht=a(),r(B.$$.fragment),ct=a(),j=i("div"),j.innerHTML=Et,dt=a(),H=i("p"),H.textContent=Nt,ut=a(),r(I.$$.fragment),gt=a(),z=i("p"),z.innerHTML=Xt,ft=a(),V=i("p"),V.textContent=Qt,yt=a(),r(E.$$.fragment),Mt=a(),v=i("div"),v.innerHTML=Ft,wt=a(),r(N.$$.fragment),bt=a(),X=i("p"),X.textContent=Yt,$t=a(),Q=i("p"),Q.innerHTML=Pt,jt=a(),r(F.$$.fragment),vt=a(),Y=i("p"),Y.innerHTML=St,Tt=a(),r(P.$$.fragment),Jt=a(),S=i("p"),S.textContent=Lt,Ut=a(),r(L.$$.fragment),Ct=a(),q=i("p"),q.textContent=qt,kt=a(),r(A.$$.fragment),xt=a(),T=i("div"),T.innerHTML=At,Zt=a(),D=i("p"),this.h()},l(t){const e=ae("svelte-u9bgzb",document.head);m=p(e,"META",{name:!0,content:!0}),e.forEach(s),f=n(t),b=p(t,"P",{}),Kt(b).forEach(s),y=n(t),h(M.$$.fragment,t),tt=n(t),J=p(t,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1elgt0a"&&(J.textContent=Rt),et=n(t),U=p(t,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1bkqs5v"&&(U.textContent=Gt),st=n(t),h($.$$.fragment,t),lt=n(t),C=p(t,"P",{"data-svelte-h":!0}),o(C)!=="svelte-jr2b5g"&&(C.textContent=Bt),at=n(t),k=p(t,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-tj6led"&&(k.innerHTML=Ht),nt=n(t),x=p(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1c9nexd"&&(x.textContent=It),it=n(t),h(Z.$$.fragment,t),pt=n(t),h(W.$$.fragment,t),ot=n(t),_=p(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-dz0z6"&&(_.innerHTML=zt),mt=n(t),h(R.$$.fragment,t),rt=n(t),G=p(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-wuz5lr"&&(G.textContent=Vt),ht=n(t),h(B.$$.fragment,t),ct=n(t),j=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-10bakl"&&(j.innerHTML=Et),dt=n(t),H=p(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-mcr1tn"&&(H.textContent=Nt),ut=n(t),h(I.$$.fragment,t),gt=n(t),z=p(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1jckqfu"&&(z.innerHTML=Xt),ft=n(t),V=p(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1dzpyfr"&&(V.textContent=Qt),yt=n(t),h(E.$$.fragment,t),Mt=n(t),v=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(v)!=="svelte-43wxxb"&&(v.innerHTML=Ft),wt=n(t),h(N.$$.fragment,t),bt=n(t),X=p(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1u79cc9"&&(X.textContent=Yt),$t=n(t),Q=p(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1r8mctn"&&(Q.innerHTML=Pt),jt=n(t),h(F.$$.fragment,t),vt=n(t),Y=p(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-hhrw3"&&(Y.innerHTML=St),Tt=n(t),h(P.$$.fragment,t),Jt=n(t),S=p(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1yk8q0z"&&(S.textContent=Lt),Ut=n(t),h(L.$$.fragment,t),Ct=n(t),q=p(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-6ebm65"&&(q.textContent=qt),kt=n(t),h(A.$$.fragment,t),xt=n(t),T=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-43wxxb"&&(T.innerHTML=At),Zt=n(t),D=p(t,"P",{}),Kt(D).forEach(s),this.h()},h(){K(m,"name","hf:doc:metadata"),K(m,"content",he),K(j,"class","flex justify-center"),K(v,"class","flex justify-center"),K(T,"class","flex justify-center")},m(t,e){ne(document.head,m),l(t,f,e),l(t,b,e),l(t,y,e),c(M,t,e),l(t,tt,e),l(t,J,e),l(t,et,e),l(t,U,e),l(t,st,e),c($,t,e),l(t,lt,e),l(t,C,e),l(t,at,e),l(t,k,e),l(t,nt,e),l(t,x,e),l(t,it,e),c(Z,t,e),l(t,pt,e),c(W,t,e),l(t,ot,e),l(t,_,e),l(t,mt,e),c(R,t,e),l(t,rt,e),l(t,G,e),l(t,ht,e),c(B,t,e),l(t,ct,e),l(t,j,e),l(t,dt,e),l(t,H,e),l(t,ut,e),c(I,t,e),l(t,gt,e),l(t,z,e),l(t,ft,e),l(t,V,e),l(t,yt,e),c(E,t,e),l(t,Mt,e),l(t,v,e),l(t,wt,e),c(N,t,e),l(t,bt,e),l(t,X,e),l(t,$t,e),l(t,Q,e),l(t,jt,e),c(F,t,e),l(t,vt,e),l(t,Y,e),l(t,Tt,e),c(P,t,e),l(t,Jt,e),l(t,S,e),l(t,Ut,e),c(L,t,e),l(t,Ct,e),l(t,q,e),l(t,kt,e),c(A,t,e),l(t,xt,e),l(t,T,e),l(t,Zt,e),l(t,D,e),Wt=!0},p(t,[e]){const Dt={};e&2&&(Dt.$$scope={dirty:e,ctx:t}),$.$set(Dt)},i(t){Wt||(d(M.$$.fragment,t),d($.$$.fragment,t),d(Z.$$.fragment,t),d(W.$$.fragment,t),d(R.$$.fragment,t),d(B.$$.fragment,t),d(I.$$.fragment,t),d(E.$$.fragment,t),d(N.$$.fragment,t),d(F.$$.fragment,t),d(P.$$.fragment,t),d(L.$$.fragment,t),d(A.$$.fragment,t),Wt=!0)},o(t){u(M.$$.fragment,t),u($.$$.fragment,t),u(Z.$$.fragment,t),u(W.$$.fragment,t),u(R.$$.fragment,t),u(B.$$.fragment,t),u(I.$$.fragment,t),u(E.$$.fragment,t),u(N.$$.fragment,t),u(F.$$.fragment,t),u(P.$$.fragment,t),u(L.$$.fragment,t),u(A.$$.fragment,t),Wt=!1},d(t){t&&(s(f),s(b),s(y),s(tt),s(J),s(et),s(U),s(st),s(lt),s(C),s(at),s(k),s(nt),s(x),s(it),s(pt),s(ot),s(_),s(mt),s(rt),s(G),s(ht),s(ct),s(j),s(dt),s(H),s(ut),s(gt),s(z),s(ft),s(V),s(yt),s(Mt),s(v),s(wt),s(bt),s(X),s($t),s(Q),s(jt),s(vt),s(Y),s(Tt),s(Jt),s(S),s(Ut),s(Ct),s(q),s(kt),s(xt),s(T),s(Zt),s(D)),s(m),g(M,t),g($,t),g(Z,t),g(W,t),g(R,t),g(B,t),g(I,t),g(E,t),g(N,t),g(F,t),g(P,t),g(L,t),g(A,t)}}}const he='{"title":"Monocular depth estimation","local":"monocular-depth-estimation","sections":[{"title":"Depth estimation pipeline","local":"depth-estimation-pipeline","sections":[],"depth":2},{"title":"Depth estimation inference by hand","local":"depth-estimation-inference-by-hand","sections":[],"depth":2}],"depth":1}';function ce(O){return te(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Me extends se{constructor(m){super(),le(this,m,ce,re,Ot,{})}}export{Me as component};
