import{s as ue,n as ye,o as be}from"../chunks/scheduler.56730f09.js";import{S as we,i as Je,g as p,s as a,r as c,A as fe,h as i,f as l,c as n,j as de,u as r,x as m,k as As,y as Te,a as e,v as o,d as g,t as h,w as M}from"../chunks/index.1f144517.js";import{H as zs,g as xe}from"../chunks/Heading.5c5b0b2d.js";import{C as j}from"../chunks/CodeBlock.738eeccb.js";import{D as Ue}from"../chunks/DocNotebookDropdown.b2e82107.js";function $e(fl){let d,qs,Ys,Ls,w,Ss,J,Ps,f,Tl="시각적 질의응답(VQA)은 이미지를 기반으로 개방형 질문에 대응하는 작업입니다. 이 작업을 지원하는 모델의 입력은 대부분 이미지와 질문의 조합이며, 출력은 자연어로 된 답변입니다.",Ds,T,xl="VQA의 주요 사용 사례는 다음과 같습니다:",Ks,x,Ul="<li>시각 장애인을 위한 접근성 애플리케이션을 구축할 수 있습니다.</li> <li>교육: 강의나 교과서에 나온 시각 자료에 대한 질문에 답할 수 있습니다. 또한 체험형 전시와 유적 등에서도 VQA를 활용할 수 있습니다.</li> <li>고객 서비스 및 전자상거래: VQA는 사용자가 제품에 대해 질문할 수 있게 함으로써 사용자 경험을 향상시킬 수 있습니다.</li> <li>이미지 검색: VQA 모델을 사용하여 원하는 특성을 가진 이미지를 검색할 수 있습니다. 예를 들어 사용자는 “강아지가 있어?”라고 물어봐서 주어진 이미지 묶음에서 강아지가 있는 모든 이미지를 받아볼 수 있습니다.</li>",Os,U,$l="이 가이드에서 학습할 내용은 다음과 같습니다:",st,$,Cl='<li>VQA 모델 중 하나인 <a href="../../en/model_doc/vilt">ViLT</a>를 <a href="https://huggingface.co/datasets/Graphcore/vqa" rel="nofollow"><code>Graphcore/vqa</code> 데이터셋</a> 에서 미세조정하는 방법</li> <li>미세조정된 ViLT 모델로 추론하는 방법</li> <li>BLIP-2 같은 생성 모델로 제로샷 VQA 추론을 실행하는 방법</li>',tt,C,lt,Z,Zl=`ViLT는 Vision Transformer (ViT) 내에 텍스트 임베딩을 포함하여 비전/자연어 사전훈련(VLP; Vision-and-Language Pretraining)을 위한 기본 디자인을 제공합니다.
ViLT 모델은 비전 트랜스포머(ViT)에 텍스트 임베딩을 넣어 비전/언어 사전훈련(VLP; Vision-and-Language Pre-training)을 위한 기본적인 디자인을 갖췄습니다. 이 모델은 여러 다운스트림 작업에 사용할 수 있습니다. VQA 태스크에서는 (<code>[CLS]</code> 토큰의 최종 은닉 상태 위에 선형 레이어인) 분류 헤더가 있으며 무작위로 초기화됩니다.
따라서 여기에서 시각적 질의응답은 <strong>분류 문제</strong>로 취급됩니다.`,et,v,vl="최근의 BLIP, BLIP-2, InstructBLIP와 같은 모델들은 VQA를 생성형 작업으로 간주합니다. 가이드의 후반부에서는 이런 모델들을 사용하여 제로샷 VQA 추론을 하는 방법에 대해 설명하겠습니다.",at,_,_l="시작하기 전 필요한 모든 라이브러리를 설치했는지 확인하세요.",nt,V,pt,G,Vl=`커뮤니티에 모델을 공유하는 것을 권장 드립니다. Hugging Face 계정에 로그인하여 🤗 Hub에 업로드할 수 있습니다.
메시지가 나타나면 로그인할 토큰을 입력하세요:`,it,W,mt,k,Gl="모델 체크포인트를 전역 변수로 선언하세요.",ct,I,rt,B,ot,X,Wl='이 가이드에서는 <code>Graphcore/vqa</code> 데이터세트의 작은 샘플을 사용합니다. 전체 데이터세트는 <a href="https://huggingface.co/datasets/Graphcore/vqa" rel="nofollow">🤗 Hub</a> 에서 확인할 수 있습니다.',gt,Q,kl=`<a href="https://huggingface.co/datasets/Graphcore/vqa" rel="nofollow"><code>Graphcore/vqa</code> 데이터세트</a> 의 대안으로 공식 <a href="https://visualqa.org/download.html" rel="nofollow">VQA 데이터세트 페이지</a> 에서 동일한 데이터를 수동으로 다운로드할 수 있습니다. 직접 공수한 데이터로 튜토리얼을 따르고 싶다면 <a href="https://huggingface.co/docs/datasets/image_dataset#loading-script" rel="nofollow">이미지 데이터세트 만들기</a> 라는
🤗 Datasets 문서를 참조하세요.`,ht,R,Il="검증 데이터의 첫 200개 항목을 불러와 데이터세트의 특성을 확인해 보겠습니다:",Mt,H,jt,F,Bl="예제를 하나 뽑아 데이터세트의 특성을 이해해 보겠습니다.",dt,N,ut,z,Xl="데이터세트에는 다음과 같은 특성이 포함되어 있습니다:",yt,Y,Ql="<li><code>question</code>: 이미지에 대한 질문</li> <li><code>image_id</code>: 질문과 관련된 이미지의 경로</li> <li><code>label</code>: 데이터의 레이블 (annotations)</li>",bt,E,Rl="나머지 특성들은 필요하지 않기 때문에 삭제해도 됩니다:",wt,A,Jt,q,Hl="보시다시피 <code>label</code> 특성은 같은 질문마다 답변이 여러 개 있을 수 있습니다. 모두 다른 데이터 라벨러들로부터 수집되었기 때문인데요. 질문의 답변은 주관적일 수 있습니다. 이 경우 질문은 “그는 어디를 보고 있나요?” 였지만, 어떤 사람들은 “아래”로 레이블을 달았고, 다른 사람들은 “테이블” 또는 “스케이트보드” 등으로 주석을 달았습니다.",ft,L,Fl="아래의 이미지를 보고 어떤 답변을 선택할 것인지 생각해 보세요:",Tt,S,xt,u,Nl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/vqa-example.png" alt="VQA Image Example"/>',Ut,P,zl="질문과 답변의 모호성으로 인해 이러한 데이터세트는 여러 개의 답변이 가능하므로 다중 레이블 분류 문제로 처리됩니다. 게다가, 원핫(one-hot) 인코딩 벡터를 생성하기보다는 레이블에서 특정 답변이 나타나는 횟수를 기반으로 소프트 인코딩을 생성합니다.",$t,D,Yl="위의 예시에서 “아래”라는 답변이 다른 답변보다 훨씬 더 자주 선택되었기 때문에 데이터세트에서 <code>weight</code>라고 불리는 점수로 1.0을 가지며, 나머지 답변들은 1.0 미만의 점수를 가집니다.",Ct,K,El="적절한 분류 헤더로 모델을 나중에 인스턴스화하기 위해 레이블을 정수로 매핑한 딕셔너리 하나, 반대로 정수를 레이블로 매핑한 딕셔너리 하나 총 2개의 딕셔너리를 생성하세요:",Zt,O,vt,ss,Al="이제 매핑이 완료되었으므로 문자열 답변을 해당 id로 교체하고, 데이터세트의 더 편리한 후처리를 위해 편평화 할 수 있습니다.",_t,ts,Vt,ls,Gt,es,ql=`다음 단계는 모델을 위해 이미지와 텍스트 데이터를 준비하기 위해 ViLT 프로세서를 가져오는 것입니다.
<code>ViltProcessor</code>는 BERT 토크나이저와 ViLT 이미지 프로세서를 편리하게 하나의 프로세서로 묶습니다:`,Wt,as,kt,ns,Ll=`데이터를 전처리하려면 이미지와 질문을 <code>ViltProcessor</code>로 인코딩해야 합니다. 프로세서는 <code>BertTokenizerFast</code>로 텍스트를 토크나이즈하고 텍스트 데이터를 위해 <code>input_ids</code>, <code>attention_mask</code> 및 <code>token_type_ids</code>를 생성합니다.
이미지는 <code>ViltImageProcessor</code>로 이미지를 크기 조정하고 정규화하며, <code>pixel_values</code>와 <code>pixel_mask</code>를 생성합니다.`,It,ps,Sl="이런 전처리 단계는 모두 내부에서 이루어지므로, <code>processor</code>를 호출하기만 하면 됩니다. 하지만 아직 타겟 레이블이 완성되지 않았습니다. 타겟의 표현에서 각 요소는 가능한 답변(레이블)에 해당합니다. 정확한 답변의 요소는 해당 점수(weight)를 유지시키고 나머지 요소는 0으로 설정해야 합니다.",Bt,is,Pl="아래 함수가 위에서 설명한대로 이미지와 질문에 <code>processor</code>를 적용하고 레이블을 형식에 맞춥니다:",Xt,ms,Qt,cs,Dl="전체 데이터세트에 전처리 함수를 적용하려면 🤗 Datasets의 <code>map</code> 함수를 사용하십시오. <code>batched=True</code>를 설정하여 데이터세트의 여러 요소를 한 번에 처리함으로써 <code>map</code>을 더 빠르게 할 수 있습니다. 이 시점에서 필요하지 않은 열은 제거하세요.",Rt,rs,Ht,os,Kl="마지막 단계로, <code>DefaultDataCollator</code>를 사용하여 예제로 쓸 배치를 생성하세요:",Ft,gs,Nt,hs,zt,Ms,Ol="이제 모델을 훈련하기 위해 준비되었습니다! <code>ViltForQuestionAnswering</code>으로 ViLT를 가져올 차례입니다. 레이블의 수와 레이블 매핑을 지정하세요:",Yt,js,Et,ds,se="이 시점에서는 다음 세 단계만 남았습니다:",At,us,te="<li><code>TrainingArguments</code>에서 훈련 하이퍼파라미터를 정의하세요:</li>",qt,ys,Lt,y,le="<li>모델, 데이터세트, 프로세서, 데이터 콜레이터와 함께 훈련 인수를 <code>Trainer</code>에 전달하세요:</li>",St,bs,Pt,b,ee="<li><code>train()</code>을 호출하여 모델을 미세 조정하세요:</li>",Dt,ws,Kt,Js,ae="훈련이 완료되면, <code>push_to_hub()</code> 메소드를 사용하여 🤗 Hub에 모델을 공유하세요:",Ot,fs,sl,Ts,tl,xs,ne="ViLT 모델을 미세 조정하고 🤗 Hub에 업로드했다면 추론에 사용할 수 있습니다. 미세 조정된 모델을 추론에 사용해보는 가장 간단한 방법은 <code>Pipeline</code>에서 사용하는 것입니다.",ll,Us,el,$s,pe="이 가이드의 모델은 200개의 예제에서만 훈련되었으므로 그다지 많은 것을 기대할 수는 없습니다. 데이터세트의 첫 번째 예제를 사용하여 추론 결과를 설명해보겠습니다:",al,Cs,nl,Zs,ie="비록 확신은 별로 없지만, 모델은 실제로 무언가를 배웠습니다. 더 많은 예제와 더 긴 훈련 기간이 주어진다면 분명 더 나은 결과를 얻을 수 있을 것입니다!",pl,vs,me="원한다면 파이프라인의 결과를 수동으로 복제할 수도 있습니다:",il,_s,ce="<li>이미지와 질문을 가져와서 프로세서를 사용하여 모델에 준비합니다.</li> <li>전처리된 결과를 모델에 전달합니다.</li> <li>로짓에서 가장 가능성 있는 답변의 id를 가져와서 <code>id2label</code>에서 실제 답변을 찾습니다.</li>",ml,Vs,cl,Gs,rl,Ws,re=`이전 모델은 VQA를 분류 문제로 처리했습니다. BLIP, BLIP-2 및 InstructBLIP와 같은 최근의 모델은 VQA를 생성 작업으로 접근합니다. <a href="../../en/model_doc/blip-2">BLIP-2</a>를 예로 들어 보겠습니다. 이 모델은 사전훈련된 비전 인코더와 LLM의 모든 조합을 사용할 수 있는 새로운 비전-자연어 사전 학습 패러다임을 도입했습니다. (<a href="https://huggingface.co/blog/blip-2" rel="nofollow">BLIP-2 블로그 포스트</a>를 통해 더 자세히 알아볼 수 있어요)
이를 통해 시각적 질의응답을 포함한 여러 비전-자연어 작업에서 SOTA를 달성할 수 있었습니다.`,ol,ks,oe="이 모델을 어떻게 VQA에 사용할 수 있는지 설명해 보겠습니다. 먼저 모델을 가져와 보겠습니다. 여기서 GPU가 사용 가능한 경우 모델을 명시적으로 GPU로 전송할 것입니다. 이전에는 훈련할 때 쓰지 않은 이유는 <code>Trainer</code>가 이 부분을 자동으로 처리하기 때문입니다:",gl,Is,hl,Bs,ge="모델은 이미지와 텍스트를 입력으로 받으므로, VQA 데이터세트의 첫 번째 예제에서와 동일한 이미지/질문 쌍을 사용해 보겠습니다:",Ml,Xs,jl,Qs,he="BLIP-2를 시각적 질의응답 작업에 사용하려면 텍스트 프롬프트가 <code>Question: {} Answer:</code> 형식을 따라야 합니다.",dl,Rs,ul,Hs,Me="이제 모델의 프로세서로 이미지/프롬프트를 전처리하고, 처리된 입력을 모델을 통해 전달하고, 출력을 디코드해야 합니다:",yl,Fs,bl,Ns,je="보시다시피 모델은 군중을 인식하고, 얼굴의 방향(아래쪽을 보고 있음)을 인식했지만, 군중이 스케이터 뒤에 있다는 사실을 놓쳤습니다. 그러나 사람이 직접 라벨링한 데이터셋을 얻을 수 없는 경우에, 이 접근법은 빠르게 유용한 결과를 생성할 수 있습니다.",wl,Es,Jl;return w=new zs({props:{title:"시각적 질의응답 (Visual Question Answering)",local:"시각적-질의응답-visual-question-answering",headingTag:"h1"}}),J=new Ue({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/visual_question_answering.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/visual_question_answering.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/visual_question_answering.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/visual_question_answering.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/visual_question_answering.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/visual_question_answering.ipynb"}]}}),C=new zs({props:{title:"ViLT 미세 조정",local:"finetuning-vilt",headingTag:"h2"}}),V=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJzJTIwZGF0YXNldHM=",highlighted:"pip install -q transformers datasets",wrap:!1}}),W=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),I=new j({props:{code:"bW9kZWxfY2hlY2twb2ludCUyMCUzRCUyMCUyMmRhbmRlbGluJTJGdmlsdC1iMzItbWxtJTIy",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model_checkpoint = <span class="hljs-string">&quot;dandelin/vilt-b32-mlm&quot;</span>',wrap:!1}}),B=new zs({props:{title:"데이터 가져오기",local:"load-the-data",headingTag:"h2"}}),H=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJHcmFwaGNvcmUlMkZ2cWElMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lNUIlM0EyMDAlNUQlMjIpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;Graphcore/vqa&quot;</span>, split=<span class="hljs-string">&quot;validation[:200]&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;question&#x27;</span>, <span class="hljs-string">&#x27;question_type&#x27;</span>, <span class="hljs-string">&#x27;question_id&#x27;</span>, <span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;answer_type&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">200</span>
})`,wrap:!1}}),N=new j({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;question&#x27;</span>: <span class="hljs-string">&#x27;Where is he looking?&#x27;</span>,
 <span class="hljs-string">&#x27;question_type&#x27;</span>: <span class="hljs-string">&#x27;none of the above&#x27;</span>,
 <span class="hljs-string">&#x27;question_id&#x27;</span>: <span class="hljs-number">262148000</span>,
 <span class="hljs-string">&#x27;image_id&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/ca733e0e000fb2d7a09fbcc94dbfe7b5a30750681d0e965f8e0a23b1c2f98c75/val2014/COCO_val2014_000000262148.jpg&#x27;</span>,
 <span class="hljs-string">&#x27;answer_type&#x27;</span>: <span class="hljs-string">&#x27;other&#x27;</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: {<span class="hljs-string">&#x27;ids&#x27;</span>: [<span class="hljs-string">&#x27;at table&#x27;</span>, <span class="hljs-string">&#x27;down&#x27;</span>, <span class="hljs-string">&#x27;skateboard&#x27;</span>, <span class="hljs-string">&#x27;table&#x27;</span>],
  <span class="hljs-string">&#x27;weights&#x27;</span>: [<span class="hljs-number">0.30000001192092896</span>,
   <span class="hljs-number">1.0</span>,
   <span class="hljs-number">0.30000001192092896</span>,
   <span class="hljs-number">0.30000001192092896</span>]}}`,wrap:!1}}),A=new j({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQucmVtb3ZlX2NvbHVtbnMoJTVCJ3F1ZXN0aW9uX3R5cGUnJTJDJTIwJ3F1ZXN0aW9uX2lkJyUyQyUyMCdhbnN3ZXJfdHlwZSclNUQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.remove_columns([<span class="hljs-string">&#x27;question_type&#x27;</span>, <span class="hljs-string">&#x27;question_id&#x27;</span>, <span class="hljs-string">&#x27;answer_type&#x27;</span>])',wrap:!1}}),S=new j({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGRhdGFzZXQlNUIwJTVEJTVCJ2ltYWdlX2lkJyU1RCklMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),O=new j({props:{code:"aW1wb3J0JTIwaXRlcnRvb2xzJTBBJTBBbGFiZWxzJTIwJTNEJTIwJTVCaXRlbSU1QidpZHMnJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwZGF0YXNldCU1QidsYWJlbCclNUQlNUQlMEFmbGF0dGVuZWRfbGFiZWxzJTIwJTNEJTIwbGlzdChpdGVydG9vbHMuY2hhaW4oKmxhYmVscykpJTBBdW5pcXVlX2xhYmVscyUyMCUzRCUyMGxpc3Qoc2V0KGZsYXR0ZW5lZF9sYWJlbHMpKSUwQSUwQWxhYmVsMmlkJTIwJTNEJTIwJTdCbGFiZWwlM0ElMjBpZHglMjBmb3IlMjBpZHglMkMlMjBsYWJlbCUyMGluJTIwZW51bWVyYXRlKHVuaXF1ZV9sYWJlbHMpJTdEJTBBaWQybGFiZWwlMjAlM0QlMjAlN0JpZHglM0ElMjBsYWJlbCUyMGZvciUyMGxhYmVsJTJDJTIwaWR4JTIwaW4lMjBsYWJlbDJpZC5pdGVtcygpJTdEJTIw",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> itertools

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [item[<span class="hljs-string">&#x27;ids&#x27;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&#x27;label&#x27;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>flattened_labels = <span class="hljs-built_in">list</span>(itertools.chain(*labels))
<span class="hljs-meta">&gt;&gt;&gt; </span>unique_labels = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(flattened_labels))

<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {label: idx <span class="hljs-keyword">for</span> idx, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(unique_labels)}
<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = {idx: label <span class="hljs-keyword">for</span> label, idx <span class="hljs-keyword">in</span> label2id.items()} `,wrap:!1}}),ts=new j({props:{code:"ZGVmJTIwcmVwbGFjZV9pZHMoaW5wdXRzKSUzQSUwQSUyMCUyMGlucHV0cyU1QiUyMmxhYmVsJTIyJTVEJTVCJTIyaWRzJTIyJTVEJTIwJTNEJTIwJTVCbGFiZWwyaWQlNUJ4JTVEJTIwZm9yJTIweCUyMGluJTIwaW5wdXRzJTVCJTIybGFiZWwlMjIlNUQlNUIlMjJpZHMlMjIlNUQlNUQlMEElMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAocmVwbGFjZV9pZHMpJTBBZmxhdF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5mbGF0dGVuKCklMEFmbGF0X2RhdGFzZXQuZmVhdHVyZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">replace_ids</span>(<span class="hljs-params">inputs</span>):
<span class="hljs-meta">... </span>  inputs[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-string">&quot;ids&quot;</span>] = [label2id[x] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> inputs[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-string">&quot;ids&quot;</span>]]
<span class="hljs-meta">... </span>  <span class="hljs-keyword">return</span> inputs


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(replace_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_dataset = dataset.flatten()
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_dataset.features
{<span class="hljs-string">&#x27;question&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;image_id&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;label.ids&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;label.weights&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;float64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),ls=new zs({props:{title:"데이터 전처리",local:"preprocessing-data",headingTag:"h2"}}),as=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpbHRQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBWaWx0UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViltProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = ViltProcessor.from_pretrained(model_checkpoint)`,wrap:!1}}),ms=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBwcmVwcm9jZXNzX2RhdGEoZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VfcGF0aHMlMjAlM0QlMjBleGFtcGxlcyU1QidpbWFnZV9pZCclNUQlMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJJbWFnZS5vcGVuKGltYWdlX3BhdGgpJTIwZm9yJTIwaW1hZ2VfcGF0aCUyMGluJTIwaW1hZ2VfcGF0aHMlNUQlMEElMjAlMjAlMjAlMjB0ZXh0cyUyMCUzRCUyMGV4YW1wbGVzJTVCJ3F1ZXN0aW9uJyU1RCUyMCUyMCUyMCUyMCUwQSUwQSUyMCUyMCUyMCUyMGVuY29kaW5nJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUyQyUyMHRleHRzJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIwJTIwJTIwJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGVuY29kaW5nLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbmNvZGluZyU1QmslNUQlMjAlM0QlMjB2LnNxdWVlemUoKSUwQSUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjAlNUIlNUQlMEElMEElMjAlMjAlMjAlMjBmb3IlMjBsYWJlbHMlMkMlMjBzY29yZXMlMjBpbiUyMHppcChleGFtcGxlcyU1QidsYWJlbC5pZHMnJTVEJTJDJTIwZXhhbXBsZXMlNUInbGFiZWwud2VpZ2h0cyclNUQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFyZ2V0JTIwJTNEJTIwdG9yY2guemVyb3MobGVuKGlkMmxhYmVsKSklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBsYWJlbCUyQyUyMHNjb3JlJTIwaW4lMjB6aXAobGFiZWxzJTJDJTIwc2NvcmVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhcmdldCU1QmxhYmVsJTVEJTIwJTNEJTIwc2NvcmUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXJnZXRzLmFwcGVuZCh0YXJnZXQpJTBBJTBBJTIwJTIwJTIwJTIwZW5jb2RpbmclNUIlMjJsYWJlbHMlMjIlNUQlMjAlM0QlMjB0YXJnZXRzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZW5jb2Rpbmc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_data</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    image_paths = examples[<span class="hljs-string">&#x27;image_id&#x27;</span>]
<span class="hljs-meta">... </span>    images = [Image.<span class="hljs-built_in">open</span>(image_path) <span class="hljs-keyword">for</span> image_path <span class="hljs-keyword">in</span> image_paths]
<span class="hljs-meta">... </span>    texts = examples[<span class="hljs-string">&#x27;question&#x27;</span>]    

<span class="hljs-meta">... </span>    encoding = processor(images, texts, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> encoding.items():
<span class="hljs-meta">... </span>          encoding[k] = v.squeeze()
    
<span class="hljs-meta">... </span>    targets = []

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> labels, scores <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&#x27;label.ids&#x27;</span>], examples[<span class="hljs-string">&#x27;label.weights&#x27;</span>]):
<span class="hljs-meta">... </span>        target = torch.zeros(<span class="hljs-built_in">len</span>(id2label))

<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> label, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(labels, scores):
<span class="hljs-meta">... </span>            target[label] = score
      
<span class="hljs-meta">... </span>        targets.append(target)

<span class="hljs-meta">... </span>    encoding[<span class="hljs-string">&quot;labels&quot;</span>] = targets
    
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> encoding`,wrap:!1}}),rs=new j({props:{code:"cHJvY2Vzc2VkX2RhdGFzZXQlMjAlM0QlMjBmbGF0X2RhdGFzZXQubWFwKHByZXByb2Nlc3NfZGF0YSUyQyUyMGJhdGNoZWQlM0RUcnVlJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0QlNUIncXVlc3Rpb24nJTJDJ3F1ZXN0aW9uX3R5cGUnJTJDJTIwJTIwJ3F1ZXN0aW9uX2lkJyUyQyUyMCdpbWFnZV9pZCclMkMlMjAnYW5zd2VyX3R5cGUnJTJDJTIwJ2xhYmVsLmlkcyclMkMlMjAnbGFiZWwud2VpZ2h0cyclNUQpJTBBcHJvY2Vzc2VkX2RhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processed_dataset = flat_dataset.<span class="hljs-built_in">map</span>(preprocess_data, batched=<span class="hljs-literal">True</span>, remove_columns=[<span class="hljs-string">&#x27;question&#x27;</span>,<span class="hljs-string">&#x27;question_type&#x27;</span>,  <span class="hljs-string">&#x27;question_id&#x27;</span>, <span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;answer_type&#x27;</span>, <span class="hljs-string">&#x27;label.ids&#x27;</span>, <span class="hljs-string">&#x27;label.weights&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_dataset
Dataset({
    features: [<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;pixel_values&#x27;</span>, <span class="hljs-string">&#x27;pixel_mask&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>],
    num_rows: <span class="hljs-number">200</span>
})`,wrap:!1}}),gs=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DefaultDataCollator()`,wrap:!1}}),hs=new zs({props:{title:"모델 훈련",local:"train-the-model",headingTag:"h2"}}),js=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpbHRGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQW1vZGVsJTIwJTNEJTIwVmlsdEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRGxlbihpZDJsYWJlbCklMkMlMjBpZDJsYWJlbCUzRGlkMmxhYmVsJTJDJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViltForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ViltForQuestionAnswering.from_pretrained(model_checkpoint, num_labels=<span class="hljs-built_in">len</span>(id2label), id2label=id2label, label2id=label2id)`,wrap:!1}}),ys=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMk1hcmlhSyUyRnZpbHRfZmluZXR1bmVkXzIwMCUyMiUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMjAwJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDVlLTUlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3RvdGFsX2xpbWl0JTNEMiUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=repo_id,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">5e-5</span>,
<span class="hljs-meta">... </span>    save_total_limit=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),bs=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEZGF0YV9jb2xsYXRvciUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0Rwcm9jZXNzZWRfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHByb2Nlc3NvciUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>    train_dataset=processed_dataset,
<span class="hljs-meta">... </span>    tokenizer=processor,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ws=new j({props:{code:"dHJhaW5lci50cmFpbigpJTIw",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train() ',wrap:!1}}),fs=new j({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),Ts=new zs({props:{title:"추론",local:"inference",headingTag:"h2"}}),Us=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnZpc3VhbC1xdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMjBtb2RlbCUzRCUyMk1hcmlhSyUyRnZpbHRfZmluZXR1bmVkXzIwMCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;visual-question-answering&quot;</span>, model=<span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>)`,wrap:!1}}),Cs=new j({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIwJTVEJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGV4YW1wbGUlNUInaW1hZ2VfaWQnJTVEKSUwQXF1ZXN0aW9uJTIwJTNEJTIwZXhhbXBsZSU1QidxdWVzdGlvbiclNUQlMEFwcmludChxdWVzdGlvbiklMEFwaXBlKGltYWdlJTJDJTIwcXVlc3Rpb24lMkMlMjB0b3BfayUzRDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(example[<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&#x27;question&#x27;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(question)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(image, question, top_k=<span class="hljs-number">1</span>)
<span class="hljs-string">&quot;Where is he looking?&quot;</span>
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.5498199462890625</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;down&#x27;</span>}]`,wrap:!1}}),Vs=new j({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwVmlsdFByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyTWFyaWFLJTJGdmlsdF9maW5ldHVuZWRfMjAwJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihleGFtcGxlJTVCJ2ltYWdlX2lkJyU1RCklMEFxdWVzdGlvbiUyMCUzRCUyMGV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGlucHV0cyUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZSUyQyUyMHF1ZXN0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMFZpbHRGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyTWFyaWFLJTJGdmlsdF9maW5ldHVuZWRfMjAwJTIyKSUwQSUwQSUyMyUyMGZvcndhcmQlMjBwYXNzJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWlkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGFuc3dlciUzQSUyMiUyQyUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QmlkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processor = ViltProcessor.from_pretrained(<span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(example[<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&#x27;question&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ViltForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer:&quot;</span>, model.config.id2label[idx])
Predicted answer: down`,wrap:!1}}),Gs=new zs({props:{title:"제로샷 VQA",local:"zeroshot-vqa",headingTag:"h2"}}),Is=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBCbGlwMkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmJsaXAyLW9wdC0yLjdiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQmxpcDJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMlNhbGVzZm9yY2UlMkZibGlwMi1vcHQtMi43YiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQW1vZGVsLnRvKGRldmljZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Blip2ForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip2-opt-2.7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Blip2ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip2-opt-2.7b&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)`,wrap:!1}}),Xs=new j({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIwJTVEJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGV4YW1wbGUlNUInaW1hZ2VfaWQnJTVEKSUwQXF1ZXN0aW9uJTIwJTNEJTIwZXhhbXBsZSU1QidxdWVzdGlvbiclNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(example[<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&#x27;question&#x27;</span>]`,wrap:!1}}),Rs=new j({props:{code:"cHJvbXB0JTIwJTNEJTIwZiUyMlF1ZXN0aW9uJTNBJTIwJTdCcXVlc3Rpb24lN0QlMjBBbnN3ZXIlM0ElMjIlMjA=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span> Answer:&quot;</span> ',wrap:!1}}),Fs=new j({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwdGV4dCUzRHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSUyQyUyMHRvcmNoLmZsb2F0MTYpJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFnZW5lcmF0ZWRfdGV4dCUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQuc3RyaXAoKSUwQXByaW50KGdlbmVyYXRlZF90ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device, torch.float16)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>].strip()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text)
<span class="hljs-string">&quot;He is looking at the crowd&quot;</span> `,wrap:!1}}),{c(){d=p("meta"),qs=a(),Ys=p("p"),Ls=a(),c(w.$$.fragment),Ss=a(),c(J.$$.fragment),Ps=a(),f=p("p"),f.textContent=Tl,Ds=a(),T=p("p"),T.textContent=xl,Ks=a(),x=p("ul"),x.innerHTML=Ul,Os=a(),U=p("p"),U.textContent=$l,st=a(),$=p("ul"),$.innerHTML=Cl,tt=a(),c(C.$$.fragment),lt=a(),Z=p("p"),Z.innerHTML=Zl,et=a(),v=p("p"),v.textContent=vl,at=a(),_=p("p"),_.textContent=_l,nt=a(),c(V.$$.fragment),pt=a(),G=p("p"),G.textContent=Vl,it=a(),c(W.$$.fragment),mt=a(),k=p("p"),k.textContent=Gl,ct=a(),c(I.$$.fragment),rt=a(),c(B.$$.fragment),ot=a(),X=p("p"),X.innerHTML=Wl,gt=a(),Q=p("p"),Q.innerHTML=kl,ht=a(),R=p("p"),R.textContent=Il,Mt=a(),c(H.$$.fragment),jt=a(),F=p("p"),F.textContent=Bl,dt=a(),c(N.$$.fragment),ut=a(),z=p("p"),z.textContent=Xl,yt=a(),Y=p("ul"),Y.innerHTML=Ql,bt=a(),E=p("p"),E.textContent=Rl,wt=a(),c(A.$$.fragment),Jt=a(),q=p("p"),q.innerHTML=Hl,ft=a(),L=p("p"),L.textContent=Fl,Tt=a(),c(S.$$.fragment),xt=a(),u=p("div"),u.innerHTML=Nl,Ut=a(),P=p("p"),P.textContent=zl,$t=a(),D=p("p"),D.innerHTML=Yl,Ct=a(),K=p("p"),K.textContent=El,Zt=a(),c(O.$$.fragment),vt=a(),ss=p("p"),ss.textContent=Al,_t=a(),c(ts.$$.fragment),Vt=a(),c(ls.$$.fragment),Gt=a(),es=p("p"),es.innerHTML=ql,Wt=a(),c(as.$$.fragment),kt=a(),ns=p("p"),ns.innerHTML=Ll,It=a(),ps=p("p"),ps.innerHTML=Sl,Bt=a(),is=p("p"),is.innerHTML=Pl,Xt=a(),c(ms.$$.fragment),Qt=a(),cs=p("p"),cs.innerHTML=Dl,Rt=a(),c(rs.$$.fragment),Ht=a(),os=p("p"),os.innerHTML=Kl,Ft=a(),c(gs.$$.fragment),Nt=a(),c(hs.$$.fragment),zt=a(),Ms=p("p"),Ms.innerHTML=Ol,Yt=a(),c(js.$$.fragment),Et=a(),ds=p("p"),ds.textContent=se,At=a(),us=p("ol"),us.innerHTML=te,qt=a(),c(ys.$$.fragment),Lt=a(),y=p("ol"),y.innerHTML=le,St=a(),c(bs.$$.fragment),Pt=a(),b=p("ol"),b.innerHTML=ee,Dt=a(),c(ws.$$.fragment),Kt=a(),Js=p("p"),Js.innerHTML=ae,Ot=a(),c(fs.$$.fragment),sl=a(),c(Ts.$$.fragment),tl=a(),xs=p("p"),xs.innerHTML=ne,ll=a(),c(Us.$$.fragment),el=a(),$s=p("p"),$s.textContent=pe,al=a(),c(Cs.$$.fragment),nl=a(),Zs=p("p"),Zs.textContent=ie,pl=a(),vs=p("p"),vs.textContent=me,il=a(),_s=p("ol"),_s.innerHTML=ce,ml=a(),c(Vs.$$.fragment),cl=a(),c(Gs.$$.fragment),rl=a(),Ws=p("p"),Ws.innerHTML=re,ol=a(),ks=p("p"),ks.innerHTML=oe,gl=a(),c(Is.$$.fragment),hl=a(),Bs=p("p"),Bs.textContent=ge,Ml=a(),c(Xs.$$.fragment),jl=a(),Qs=p("p"),Qs.innerHTML=he,dl=a(),c(Rs.$$.fragment),ul=a(),Hs=p("p"),Hs.textContent=Me,yl=a(),c(Fs.$$.fragment),bl=a(),Ns=p("p"),Ns.textContent=je,wl=a(),Es=p("p"),this.h()},l(s){const t=fe("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(l),qs=n(s),Ys=i(s,"P",{}),de(Ys).forEach(l),Ls=n(s),r(w.$$.fragment,s),Ss=n(s),r(J.$$.fragment,s),Ps=n(s),f=i(s,"P",{"data-svelte-h":!0}),m(f)!=="svelte-lsf3d3"&&(f.textContent=Tl),Ds=n(s),T=i(s,"P",{"data-svelte-h":!0}),m(T)!=="svelte-1m5x0xt"&&(T.textContent=xl),Ks=n(s),x=i(s,"UL",{"data-svelte-h":!0}),m(x)!=="svelte-19c3jz6"&&(x.innerHTML=Ul),Os=n(s),U=i(s,"P",{"data-svelte-h":!0}),m(U)!=="svelte-27ww4z"&&(U.textContent=$l),st=n(s),$=i(s,"UL",{"data-svelte-h":!0}),m($)!=="svelte-4zovkh"&&($.innerHTML=Cl),tt=n(s),r(C.$$.fragment,s),lt=n(s),Z=i(s,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-l5s5vs"&&(Z.innerHTML=Zl),et=n(s),v=i(s,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1gnol8d"&&(v.textContent=vl),at=n(s),_=i(s,"P",{"data-svelte-h":!0}),m(_)!=="svelte-16n8ks6"&&(_.textContent=_l),nt=n(s),r(V.$$.fragment,s),pt=n(s),G=i(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1tfz9ll"&&(G.textContent=Vl),it=n(s),r(W.$$.fragment,s),mt=n(s),k=i(s,"P",{"data-svelte-h":!0}),m(k)!=="svelte-8hbytf"&&(k.textContent=Gl),ct=n(s),r(I.$$.fragment,s),rt=n(s),r(B.$$.fragment,s),ot=n(s),X=i(s,"P",{"data-svelte-h":!0}),m(X)!=="svelte-ogma3f"&&(X.innerHTML=Wl),gt=n(s),Q=i(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1yqcape"&&(Q.innerHTML=kl),ht=n(s),R=i(s,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1e6q69w"&&(R.textContent=Il),Mt=n(s),r(H.$$.fragment,s),jt=n(s),F=i(s,"P",{"data-svelte-h":!0}),m(F)!=="svelte-k3mzt8"&&(F.textContent=Bl),dt=n(s),r(N.$$.fragment,s),ut=n(s),z=i(s,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1vwvj02"&&(z.textContent=Xl),yt=n(s),Y=i(s,"UL",{"data-svelte-h":!0}),m(Y)!=="svelte-1bz53k7"&&(Y.innerHTML=Ql),bt=n(s),E=i(s,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1hynqfk"&&(E.textContent=Rl),wt=n(s),r(A.$$.fragment,s),Jt=n(s),q=i(s,"P",{"data-svelte-h":!0}),m(q)!=="svelte-6vh6f7"&&(q.innerHTML=Hl),ft=n(s),L=i(s,"P",{"data-svelte-h":!0}),m(L)!=="svelte-1o0kwl9"&&(L.textContent=Fl),Tt=n(s),r(S.$$.fragment,s),xt=n(s),u=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(u)!=="svelte-1tjg4st"&&(u.innerHTML=Nl),Ut=n(s),P=i(s,"P",{"data-svelte-h":!0}),m(P)!=="svelte-bmlc3i"&&(P.textContent=zl),$t=n(s),D=i(s,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1isdfaj"&&(D.innerHTML=Yl),Ct=n(s),K=i(s,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1hwga8k"&&(K.textContent=El),Zt=n(s),r(O.$$.fragment,s),vt=n(s),ss=i(s,"P",{"data-svelte-h":!0}),m(ss)!=="svelte-1f1gsw8"&&(ss.textContent=Al),_t=n(s),r(ts.$$.fragment,s),Vt=n(s),r(ls.$$.fragment,s),Gt=n(s),es=i(s,"P",{"data-svelte-h":!0}),m(es)!=="svelte-u0lfur"&&(es.innerHTML=ql),Wt=n(s),r(as.$$.fragment,s),kt=n(s),ns=i(s,"P",{"data-svelte-h":!0}),m(ns)!=="svelte-1ihxpp7"&&(ns.innerHTML=Ll),It=n(s),ps=i(s,"P",{"data-svelte-h":!0}),m(ps)!=="svelte-8a14gg"&&(ps.innerHTML=Sl),Bt=n(s),is=i(s,"P",{"data-svelte-h":!0}),m(is)!=="svelte-x4dc7"&&(is.innerHTML=Pl),Xt=n(s),r(ms.$$.fragment,s),Qt=n(s),cs=i(s,"P",{"data-svelte-h":!0}),m(cs)!=="svelte-y8sr6z"&&(cs.innerHTML=Dl),Rt=n(s),r(rs.$$.fragment,s),Ht=n(s),os=i(s,"P",{"data-svelte-h":!0}),m(os)!=="svelte-12etfja"&&(os.innerHTML=Kl),Ft=n(s),r(gs.$$.fragment,s),Nt=n(s),r(hs.$$.fragment,s),zt=n(s),Ms=i(s,"P",{"data-svelte-h":!0}),m(Ms)!=="svelte-117iw8t"&&(Ms.innerHTML=Ol),Yt=n(s),r(js.$$.fragment,s),Et=n(s),ds=i(s,"P",{"data-svelte-h":!0}),m(ds)!=="svelte-ahfk2n"&&(ds.textContent=se),At=n(s),us=i(s,"OL",{"data-svelte-h":!0}),m(us)!=="svelte-9y82ex"&&(us.innerHTML=te),qt=n(s),r(ys.$$.fragment,s),Lt=n(s),y=i(s,"OL",{start:!0,"data-svelte-h":!0}),m(y)!=="svelte-18s4qm6"&&(y.innerHTML=le),St=n(s),r(bs.$$.fragment,s),Pt=n(s),b=i(s,"OL",{start:!0,"data-svelte-h":!0}),m(b)!=="svelte-1jabqg6"&&(b.innerHTML=ee),Dt=n(s),r(ws.$$.fragment,s),Kt=n(s),Js=i(s,"P",{"data-svelte-h":!0}),m(Js)!=="svelte-njd4j0"&&(Js.innerHTML=ae),Ot=n(s),r(fs.$$.fragment,s),sl=n(s),r(Ts.$$.fragment,s),tl=n(s),xs=i(s,"P",{"data-svelte-h":!0}),m(xs)!=="svelte-1uxaimc"&&(xs.innerHTML=ne),ll=n(s),r(Us.$$.fragment,s),el=n(s),$s=i(s,"P",{"data-svelte-h":!0}),m($s)!=="svelte-2v1cek"&&($s.textContent=pe),al=n(s),r(Cs.$$.fragment,s),nl=n(s),Zs=i(s,"P",{"data-svelte-h":!0}),m(Zs)!=="svelte-tjyuxs"&&(Zs.textContent=ie),pl=n(s),vs=i(s,"P",{"data-svelte-h":!0}),m(vs)!=="svelte-4epvs7"&&(vs.textContent=me),il=n(s),_s=i(s,"OL",{"data-svelte-h":!0}),m(_s)!=="svelte-gtxums"&&(_s.innerHTML=ce),ml=n(s),r(Vs.$$.fragment,s),cl=n(s),r(Gs.$$.fragment,s),rl=n(s),Ws=i(s,"P",{"data-svelte-h":!0}),m(Ws)!=="svelte-y6okgx"&&(Ws.innerHTML=re),ol=n(s),ks=i(s,"P",{"data-svelte-h":!0}),m(ks)!=="svelte-17wlrgr"&&(ks.innerHTML=oe),gl=n(s),r(Is.$$.fragment,s),hl=n(s),Bs=i(s,"P",{"data-svelte-h":!0}),m(Bs)!=="svelte-bl55fy"&&(Bs.textContent=ge),Ml=n(s),r(Xs.$$.fragment,s),jl=n(s),Qs=i(s,"P",{"data-svelte-h":!0}),m(Qs)!=="svelte-179kzpa"&&(Qs.innerHTML=he),dl=n(s),r(Rs.$$.fragment,s),ul=n(s),Hs=i(s,"P",{"data-svelte-h":!0}),m(Hs)!=="svelte-les5jw"&&(Hs.textContent=Me),yl=n(s),r(Fs.$$.fragment,s),bl=n(s),Ns=i(s,"P",{"data-svelte-h":!0}),m(Ns)!=="svelte-1wddc64"&&(Ns.textContent=je),wl=n(s),Es=i(s,"P",{}),de(Es).forEach(l),this.h()},h(){As(d,"name","hf:doc:metadata"),As(d,"content",Ce),As(u,"class","flex justify-center"),As(y,"start","2"),As(b,"start","3")},m(s,t){Te(document.head,d),e(s,qs,t),e(s,Ys,t),e(s,Ls,t),o(w,s,t),e(s,Ss,t),o(J,s,t),e(s,Ps,t),e(s,f,t),e(s,Ds,t),e(s,T,t),e(s,Ks,t),e(s,x,t),e(s,Os,t),e(s,U,t),e(s,st,t),e(s,$,t),e(s,tt,t),o(C,s,t),e(s,lt,t),e(s,Z,t),e(s,et,t),e(s,v,t),e(s,at,t),e(s,_,t),e(s,nt,t),o(V,s,t),e(s,pt,t),e(s,G,t),e(s,it,t),o(W,s,t),e(s,mt,t),e(s,k,t),e(s,ct,t),o(I,s,t),e(s,rt,t),o(B,s,t),e(s,ot,t),e(s,X,t),e(s,gt,t),e(s,Q,t),e(s,ht,t),e(s,R,t),e(s,Mt,t),o(H,s,t),e(s,jt,t),e(s,F,t),e(s,dt,t),o(N,s,t),e(s,ut,t),e(s,z,t),e(s,yt,t),e(s,Y,t),e(s,bt,t),e(s,E,t),e(s,wt,t),o(A,s,t),e(s,Jt,t),e(s,q,t),e(s,ft,t),e(s,L,t),e(s,Tt,t),o(S,s,t),e(s,xt,t),e(s,u,t),e(s,Ut,t),e(s,P,t),e(s,$t,t),e(s,D,t),e(s,Ct,t),e(s,K,t),e(s,Zt,t),o(O,s,t),e(s,vt,t),e(s,ss,t),e(s,_t,t),o(ts,s,t),e(s,Vt,t),o(ls,s,t),e(s,Gt,t),e(s,es,t),e(s,Wt,t),o(as,s,t),e(s,kt,t),e(s,ns,t),e(s,It,t),e(s,ps,t),e(s,Bt,t),e(s,is,t),e(s,Xt,t),o(ms,s,t),e(s,Qt,t),e(s,cs,t),e(s,Rt,t),o(rs,s,t),e(s,Ht,t),e(s,os,t),e(s,Ft,t),o(gs,s,t),e(s,Nt,t),o(hs,s,t),e(s,zt,t),e(s,Ms,t),e(s,Yt,t),o(js,s,t),e(s,Et,t),e(s,ds,t),e(s,At,t),e(s,us,t),e(s,qt,t),o(ys,s,t),e(s,Lt,t),e(s,y,t),e(s,St,t),o(bs,s,t),e(s,Pt,t),e(s,b,t),e(s,Dt,t),o(ws,s,t),e(s,Kt,t),e(s,Js,t),e(s,Ot,t),o(fs,s,t),e(s,sl,t),o(Ts,s,t),e(s,tl,t),e(s,xs,t),e(s,ll,t),o(Us,s,t),e(s,el,t),e(s,$s,t),e(s,al,t),o(Cs,s,t),e(s,nl,t),e(s,Zs,t),e(s,pl,t),e(s,vs,t),e(s,il,t),e(s,_s,t),e(s,ml,t),o(Vs,s,t),e(s,cl,t),o(Gs,s,t),e(s,rl,t),e(s,Ws,t),e(s,ol,t),e(s,ks,t),e(s,gl,t),o(Is,s,t),e(s,hl,t),e(s,Bs,t),e(s,Ml,t),o(Xs,s,t),e(s,jl,t),e(s,Qs,t),e(s,dl,t),o(Rs,s,t),e(s,ul,t),e(s,Hs,t),e(s,yl,t),o(Fs,s,t),e(s,bl,t),e(s,Ns,t),e(s,wl,t),e(s,Es,t),Jl=!0},p:ye,i(s){Jl||(g(w.$$.fragment,s),g(J.$$.fragment,s),g(C.$$.fragment,s),g(V.$$.fragment,s),g(W.$$.fragment,s),g(I.$$.fragment,s),g(B.$$.fragment,s),g(H.$$.fragment,s),g(N.$$.fragment,s),g(A.$$.fragment,s),g(S.$$.fragment,s),g(O.$$.fragment,s),g(ts.$$.fragment,s),g(ls.$$.fragment,s),g(as.$$.fragment,s),g(ms.$$.fragment,s),g(rs.$$.fragment,s),g(gs.$$.fragment,s),g(hs.$$.fragment,s),g(js.$$.fragment,s),g(ys.$$.fragment,s),g(bs.$$.fragment,s),g(ws.$$.fragment,s),g(fs.$$.fragment,s),g(Ts.$$.fragment,s),g(Us.$$.fragment,s),g(Cs.$$.fragment,s),g(Vs.$$.fragment,s),g(Gs.$$.fragment,s),g(Is.$$.fragment,s),g(Xs.$$.fragment,s),g(Rs.$$.fragment,s),g(Fs.$$.fragment,s),Jl=!0)},o(s){h(w.$$.fragment,s),h(J.$$.fragment,s),h(C.$$.fragment,s),h(V.$$.fragment,s),h(W.$$.fragment,s),h(I.$$.fragment,s),h(B.$$.fragment,s),h(H.$$.fragment,s),h(N.$$.fragment,s),h(A.$$.fragment,s),h(S.$$.fragment,s),h(O.$$.fragment,s),h(ts.$$.fragment,s),h(ls.$$.fragment,s),h(as.$$.fragment,s),h(ms.$$.fragment,s),h(rs.$$.fragment,s),h(gs.$$.fragment,s),h(hs.$$.fragment,s),h(js.$$.fragment,s),h(ys.$$.fragment,s),h(bs.$$.fragment,s),h(ws.$$.fragment,s),h(fs.$$.fragment,s),h(Ts.$$.fragment,s),h(Us.$$.fragment,s),h(Cs.$$.fragment,s),h(Vs.$$.fragment,s),h(Gs.$$.fragment,s),h(Is.$$.fragment,s),h(Xs.$$.fragment,s),h(Rs.$$.fragment,s),h(Fs.$$.fragment,s),Jl=!1},d(s){s&&(l(qs),l(Ys),l(Ls),l(Ss),l(Ps),l(f),l(Ds),l(T),l(Ks),l(x),l(Os),l(U),l(st),l($),l(tt),l(lt),l(Z),l(et),l(v),l(at),l(_),l(nt),l(pt),l(G),l(it),l(mt),l(k),l(ct),l(rt),l(ot),l(X),l(gt),l(Q),l(ht),l(R),l(Mt),l(jt),l(F),l(dt),l(ut),l(z),l(yt),l(Y),l(bt),l(E),l(wt),l(Jt),l(q),l(ft),l(L),l(Tt),l(xt),l(u),l(Ut),l(P),l($t),l(D),l(Ct),l(K),l(Zt),l(vt),l(ss),l(_t),l(Vt),l(Gt),l(es),l(Wt),l(kt),l(ns),l(It),l(ps),l(Bt),l(is),l(Xt),l(Qt),l(cs),l(Rt),l(Ht),l(os),l(Ft),l(Nt),l(zt),l(Ms),l(Yt),l(Et),l(ds),l(At),l(us),l(qt),l(Lt),l(y),l(St),l(Pt),l(b),l(Dt),l(Kt),l(Js),l(Ot),l(sl),l(tl),l(xs),l(ll),l(el),l($s),l(al),l(nl),l(Zs),l(pl),l(vs),l(il),l(_s),l(ml),l(cl),l(rl),l(Ws),l(ol),l(ks),l(gl),l(hl),l(Bs),l(Ml),l(jl),l(Qs),l(dl),l(ul),l(Hs),l(yl),l(bl),l(Ns),l(wl),l(Es)),l(d),M(w,s),M(J,s),M(C,s),M(V,s),M(W,s),M(I,s),M(B,s),M(H,s),M(N,s),M(A,s),M(S,s),M(O,s),M(ts,s),M(ls,s),M(as,s),M(ms,s),M(rs,s),M(gs,s),M(hs,s),M(js,s),M(ys,s),M(bs,s),M(ws,s),M(fs,s),M(Ts,s),M(Us,s),M(Cs,s),M(Vs,s),M(Gs,s),M(Is,s),M(Xs,s),M(Rs,s),M(Fs,s)}}}const Ce='{"title":"시각적 질의응답 (Visual Question Answering)","local":"시각적-질의응답-visual-question-answering","sections":[{"title":"ViLT 미세 조정","local":"finetuning-vilt","sections":[],"depth":2},{"title":"데이터 가져오기","local":"load-the-data","sections":[],"depth":2},{"title":"데이터 전처리","local":"preprocessing-data","sections":[],"depth":2},{"title":"모델 훈련","local":"train-the-model","sections":[],"depth":2},{"title":"추론","local":"inference","sections":[],"depth":2},{"title":"제로샷 VQA","local":"zeroshot-vqa","sections":[],"depth":2}],"depth":1}';function Ze(fl){return be(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=xe}),[]}class ke extends we{constructor(d){super(),Je(this,d,Ze,$e,ue,{})}}export{ke as component};
