import{s as ha,n as Ca,o as Ba}from"../chunks/scheduler.65852ee5.js";import{S as ga,i as Za,g as e,s as a,r as i,A as fa,h as p,f as n,c as M,j as Ia,u as y,x as T,k as ba,y as Ga,a as t,v as o,d as J,t as j,w as U}from"../chunks/index.65a1b999.js";import{D as Aa,C as w}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as c,E as Ra}from"../chunks/getInferenceSnippets.56942ade.js";function Wa(bt){let m,ms,cs,rs,r,us,u,ds,d,ht='<em>Authored by: <a href="https://github.com/behroozazarkhalili" rel="nofollow">Behrooz Azarkhalili</a></em>',Is,I,Ct="This notebook demonstrates how to fine-tune language models for function calling capabilities using the <strong>xLAM dataset</strong> from Salesforce and <strong>QLoRA</strong> (Quantized Low-Rank Adaptation) technique. We’ll work with popular models like Llama 3, Qwen2, Mistral, and others.",bs,b,Bt=`<strong>What is Function Calling?</strong>
Function calling enables language models to interact with external tools and APIs by generating structured function invocations. Instead of just generating text, the model learns to call specific functions with the right parameters based on user requests.`,hs,h,gt="<strong>What You’ll Learn:</strong>",Cs,C,Zt="<li><strong>Data Processing</strong>: How to format the xLAM dataset for function calling training</li> <li><strong>Model Fine-tuning</strong>: Using QLoRA for memory-efficient training on consumer GPUs</li> <li><strong>Evaluation</strong>: Testing the fine-tuned models with example prompts</li> <li><strong>Multi-model Support</strong>: Working with different model architectures</li>",Bs,B,ft="<strong>Key Benefits:</strong>",gs,g,Gt="<li><strong>Memory Efficient</strong>: QLoRA enables training on 16-24GB GPUs</li> <li><strong>Production Ready</strong>: Modular code with proper error handling</li> <li><strong>Flexible Architecture</strong>: Easy to adapt for different models and datasets</li> <li><strong>Universal Support</strong>: Works with Llama, Qwen, Mistral, Gemma, Phi, and more</li>",Zs,Z,At="<strong>Hardware Requirements:</strong>",fs,f,Rt="<li><strong>GPU</strong>: 16GB+ VRAM (24GB recommended for larger models)</li> <li><strong>RAM</strong>: 32GB+ system memory</li> <li><strong>Storage</strong>: 50GB+ free space for models and datasets</li>",Gs,G,Wt=`<strong>Software Dependencies:</strong>
The notebook will install required packages automatically, including:`,As,A,Et="<li><code>transformers</code>, <code>peft</code>, <code>bitsandbytes</code>, <code>trl</code>, <code>datasets</code>, <code>accelerate</code></li>",Rs,R,Xt='<em>For detailed methodology and results, see: <a href="https://newsletter.kaitchup.com/p/function-calling-fine-tuning-llama" rel="nofollow">Function Calling: Fine-tuning Llama 3 and Qwen2 on xLAM</a></em>',Ws,W,Es,E,Xs,X,Vt="Let’s start with the essential imports and basic setup for our notebook.",Vs,V,Qs,Q,Qt=`PyTorch version: 2.8.0+cu128
CUDA available: True
GPU: NVIDIA H100 NVL
VRAM: 100.0 GB
`,_s,_,ks,k,_t="Next, we’ll set up authentication with HuggingFace Hub. This allows us to download models and datasets, and optionally upload our fine-tuned models.",Ns,N,Ss,S,kt=`✅ Successfully authenticated with HuggingFace!
`,Fs,F,vs,v,Nt="We’ll create two configuration classes to organize our settings:",Ys,Y,St="<li><strong>ModelConfig</strong>: Stores model-specific settings like tokenizer configuration</li> <li><strong>TrainingConfig</strong>: Stores training parameters like learning rate and batch size</li>",zs,z,Hs,H,qs,q,Ft="This function automatically detects the model’s tokenizer settings and creates a proper configuration. It handles different model architectures (Llama, Qwen, Mistral, etc.) and their specific token requirements.",xs,x,$s,$,Ls,L,vt=`✅ Configuration system ready!
💡 Supports Llama, Qwen, Mistral, Gemma, Phi, and more
`,Ds,D,Ks,K,Yt="Let’s detect our hardware capabilities and configure optimal settings. We’ll check for bfloat16 support and set up the best attention mechanism for our GPU.",Os,O,Ps,P,ln,ll,zt="Now let’s create a function to set up our tokenizer with the right configuration from our model settings.",sn,sl,nn,nl,Ht=`📊 Hardware Configuration Complete:
   • Compute dtype: torch.bfloat16
   • Attention implementation: flash_attention_2
   • Device: NVIDIA H100 NVL
`,tn,tl,an,al,qt="Now we’ll work with the xLAM dataset from Salesforce. This dataset contains about 60,000 examples of function calling conversations that we’ll use to train our model.",Mn,Ml,xt="<strong>Key Functions:</strong>",en,el,$t="<li><strong><code>process_xlam_sample()</code></strong>: Converts a single dataset example into the training format with special tags (<code>&lt;user&gt;</code>, <code>&lt;tools&gt;</code>, <code>&lt;calls&gt;</code>) and EOS token</li> <li><strong><code>load_and_process_xlam_dataset()</code></strong>: Loads the complete xLAM dataset (60K samples) from Hugging Face and processes all samples using multiprocessing for efficiency</li> <li><strong><code>preview_dataset_sample()</code></strong>: Displays a formatted preview of a processed dataset sample for inspection with statistics</li>",pn,pl,yn,il,on,yl,Jn,ol,jn,Jl,Lt="Now let’s add functions to load the xLAM dataset and process it into the format our model needs for training.",Un,jl,Tn,Ul,cn,Tl,Dt="QLoRA (Quantized Low-Rank Adaptation) allows us to fine-tune large language models efficiently. It uses 4-bit quantization to reduce memory usage while maintaining training quality.",wn,cl,mn,wl,rn,ml,Kt="LoRA (Low-Rank Adaptation) is the key technique that makes efficient fine-tuning possible. Instead of updating all model parameters, LoRA adds small trainable matrices to specific layers while keeping the base model frozen.",un,rl,dn,ul,Ot="Now we’ll create the main training function that puts everything together. This function configures the training arguments and executes the fine-tuning process using TRL’s SFTTrainer.",In,dl,bn,Il,hn,bl,Pt="<strong>Choose any model for fine-tuning!</strong> This notebook supports a wide range of popular models. Simply uncomment the model you want to use or specify your own.",Cn,hl,Bn,Cl,la="Uncomment one of these popular models or specify your own:",gn,Bl,sa="<strong>Why Llama 3-8B-Instruct as default?</strong>",Zn,gl,na="<li><strong>Proven Performance</strong>: Excellent function calling capabilities and instruction following</li> <li><strong>Optimal Size</strong>: 8B parameters provide great balance between performance and resource usage</li>",fn,Zl,Gn,fl,ta=`🎯 Selected Model: meta-llama/Meta-Llama-3-8B-Instruct

🔧 Auto-configuring everything for meta-llama/Meta-Llama-3-8B-Instruct...
🔍 Loading model configuration: meta-llama/Meta-Llama-3-8B-Instruct
📊 Model: llama, vocab_size: 128,256
✅ Configured - pad: '<|eot_id|>' (ID: 128009), eos: '<|eot_id|>' (ID: 128009)

🎉 Ready to fine-tune! Everything configured automatically:
   ✅ Model type: llama
   ✅ Vocabulary: 128,256 tokens
   ✅ Pad token: '<|eot_id|>' (ID: 128009)
   ✅ Output dir: ./Meta_Llama_3_8B_Instruct_xLAM

🚀 Configuration complete for meta-llama/Meta-Llama-3-8B-Instruct!
`,An,Gl,Rn,Al,Wn,Rl,aa="After training is complete, we need to load the trained model for inference. This function loads the base model with quantization and applies the trained LoRA adapters.",En,Wl,Xn,El,Vn,Xl,Ma="Now let’s create the function that generates responses from our fine-tuned model. This handles tokenization, generation parameters, and decoding.",Qn,Vl,_n,Ql,kn,_l,ea="This function provides a comprehensive test suite to evaluate our fine-tuned model with different types of function calling scenarios.",Nn,kl,Sn,Nl,Fn,Sl,vn,Fl,pa=`🧪 Testing function calling capabilities...

============================================================
Test Case 1: Mathematical Function
============================================================
🎯 Generating response for prompt...
📝 Input: <user>Check if the numbers 8 and 1233 are powers of two.</user>

<tools>
✅ Generation completed!
📊 Generated 90 new tokens

🔍 Complete Response:
----------------------------------------
<user>Check if the numbers 8 and 1233 are powers of two.</user>

<tools>&amp;#123;&#39;name&#39;: &#39;is_power_of_two&#39;, &#39;description&#39;: &#39;Checks if a number is a power of two.&#39;, &#39;parameters&#39;: &amp;#123;&#39;num&#39;: &amp;#123;&#39;description&#39;: &#39;The number to check.&#39;, &#39;type&#39;: &#39;int&#39;}}}</tools>

<calls>&amp;#123;&#39;name&#39;: &#39;is_power_of_two&#39;, &#39;arguments&#39;: &amp;#123;&#39;num&#39;: 8}}
&amp;#123;&#39;name&#39;: &#39;is_power_of_two&#39;, &#39;arguments&#39;: &amp;#123;&#39;num&#39;: 1233}}</calls>
----------------------------------------

============================================================
Test Case 2: Weather Query
============================================================
🎯 Generating response for prompt...
📝 Input: <user>What&#39;s the weather like in New York today?</user>

<tools>
✅ Generation completed!
📊 Generated 105 new tokens

🔍 Complete Response:
----------------------------------------
<user>What&#39;s the weather like in New York today?</user>

<tools>&amp;#123;&#39;name&#39;:&#39;realtime_weather_api&#39;, &#39;description&#39;: &#39;Fetches current weather information based on the provided query parameter.&#39;, &#39;parameters&#39;: &amp;#123;&#39;q&#39;: &amp;#123;&#39;description&#39;: &#39;Query parameter used to specify the location for which weather data is required. It can be in various formats such as:&#39;, &#39;type&#39;:&#39;str&#39;, &#39;default&#39;: &#39;53.1,-0.13&#39;}}}</tools>

<calls>&amp;#123;&#39;name&#39;:&#39;realtime_weather_api&#39;, &#39;arguments&#39;: &amp;#123;&#39;q&#39;: &#39;New York&#39;}}</calls>
----------------------------------------

============================================================
Test Case 3: Data Processing
============================================================
🎯 Generating response for prompt...
📝 Input: <user>Calculate the average of these numbers: 10, 20, 30, 40, 50</user>

<tools>
✅ Generation completed!
📊 Generated 81 new tokens

🔍 Complete Response:
----------------------------------------
<user>Calculate the average of these numbers: 10, 20, 30, 40, 50</user>

<tools>&amp;#123;&#39;name&#39;: &#39;average&#39;, &#39;description&#39;: &#39;Calculates the arithmetic mean of a list of numbers.&#39;, &#39;parameters&#39;: &amp;#123;&#39;numbers&#39;: &amp;#123;&#39;description&#39;: &#39;The list of numbers.&#39;, &#39;type&#39;: &#39;List[float]&#39;}}}</tools>

<calls>&amp;#123;&#39;name&#39;: &#39;average&#39;, &#39;arguments&#39;: &amp;#123;&#39;numbers&#39;: [10, 20, 30, 40, 50]}}</calls>
----------------------------------------

✅ All test cases completed!
</tools></tools></tools>`,Yn,vl,zn,Hn,qn,Yl,xn,zl,ia="This notebook demonstrated a <strong>complete, production-ready, universal pipeline</strong> for fine-tuning language models for function calling capabilities using:",$n,Hl,ya="<li><strong>🎯 Universal Model Support</strong>: Works with any model - just change the <code>MODEL_NAME</code> variable</li> <li><strong>🔧 Intelligent Configuration</strong>: Automatic token detection using <code>auto_configure_model()</code></li> <li><strong>⚡ QLoRA Efficiency</strong>: Memory-efficient training on consumer GPUs (16-24GB)</li> <li><strong>📋 Comprehensive Testing</strong>: Automated evaluation and interactive testing capabilities</li>",Ln,ql,Dn,xl,Kn,$l,oa="<li>✅ <strong>Multi-Model Support</strong>: Works with Llama, Qwen, Mistral, Gemma, Phi, DeepSeek, Yi, and more</li> <li>✅ <strong>Smart Token Detection</strong>: Automatically finds pad/EOS tokens from any model’s tokenizer</li> <li>✅ <strong>Error Prevention</strong>: Validates configurations and provides helpful error messages</li> <li>✅ <strong>Flexible Architecture</strong>: Easy to add new models without code changes</li>",On,Ll,Pn,Dl,Ja="<li>✅ <strong>Type Hints</strong>: Full type annotations for better IDE support and error catching</li> <li>✅ <strong>Docstrings</strong>: Comprehensive documentation for all functions</li> <li>✅ <strong>Error Handling</strong>: Robust error handling with informative messages</li> <li>✅ <strong>Modular Design</strong>: Clean separation of concerns and reusable components</li>",lt,Kl,st,Ol,ja="<li>✅ <strong>One-Line Model Selection</strong>: Simply change <code>MODEL_NAME</code> variable</li> <li>✅ <strong>Automatic Configuration</strong>: Everything extracted from transformers automatically</li> <li>✅ <strong>Clear Progress Indicators</strong>: Emojis and detailed logging throughout</li> <li>✅ <strong>Production Ready</strong>: Code suitable for research and deployment</li>",nt,Pl,tt,ls,at,ss,Ua="<li><strong>Try Different Models</strong>: Simply change the <code>MODEL_NAME</code> variable and re-run</li> <li><strong>Hyperparameter Tuning</strong>: Experiment with different LoRA ranks, learning rates</li> <li><strong>Extended Training</strong>: Try multi-epoch training for better convergence</li>",Mt,ns,et,ts,Ta="<li><strong>Quantitative Metrics</strong>: Add BLEU, ROUGE, or custom function calling accuracy</li> <li><strong>Benchmark Datasets</strong>: Test on additional function calling benchmarks</li> <li><strong>Multi-Model Comparison</strong>: Compare performance across different model families</li>",pt,as,it,Ms,ca="<li><strong>Model Serving</strong>: Deploy with FastAPI, TensorRT, or vLLM</li> <li><strong>Integration</strong>: Connect with real APIs and function execution environments</li> <li><strong>Optimization</strong>: Implement model quantization and pruning for production</li>",yt,es,ot,ps,wa="<li><strong>Multi-turn Conversations</strong>: Extend to handle conversation context</li> <li><strong>Tool Selection</strong>: Improve tool selection and reasoning capabilities</li> <li><strong>Error Recovery</strong>: Add error handling and recovery mechanisms</li>",Jt,is,jt,ys,ma='<li><strong>xLAM Dataset</strong>: <a href="https://huggingface.co/datasets/Salesforce/xlam-function-calling-60k" rel="nofollow">Salesforce/xlam-function-calling-60k</a></li> <li><strong>QLoRA Paper</strong>: <a href="https://arxiv.org/abs/2305.14314" rel="nofollow">Efficient Finetuning of Quantized LLMs</a></li> <li><strong>Function Calling Guide</strong>: <a href="https://newsletter.kaitchup.com/p/function-calling-fine-tuning-llama" rel="nofollow">Complete methodology article</a></li> <li><strong>PEFT Library</strong>: <a href="https://huggingface.co/docs/peft" rel="nofollow">Hugging Face PEFT Documentation</a></li>',Ut,os,Tt,Js,ra="<strong>🏆 Universal Function Calling Fine-tuning Master!</strong>",ct,js,ua="You now have a production-ready system that can fine-tune virtually any open-source language model for function calling with just a single line change!",wt,mt,rt,Us,da="<strong>Happy Fine-tuning! 🚀</strong> Try different models, share your results, and contribute back to the community!",ut,Ts,dt,ws,It;return r=new Aa({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/function_calling_fine_tuning_llms_on_xlam.ipynb"}]}}),u=new c({props:{title:"Fine-tuning LLMs for Function Calling with xLAM Dataset",local:"fine-tuning-llms-for-function-calling-with-xlam-dataset",headingTag:"h1"}}),W=new w({props:{code:"JTIzJTIwSW5zdGFsbCUyMHJlcXVpcmVkJTIwcGFja2FnZXMlMjBmb3IlMjBmdW5jdGlvbiUyMGNhbGxpbmclMjBmaW5lLXR1bmluZyUwQSUyMyUyMCF1diUyMHBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjBiaXRzYW5kYnl0ZXMlMjBwZWZ0JTIwdHJsJTIwcHl0aG9uLWRvdGVudg==",highlighted:`<span class="hljs-comment"># Install required packages for function calling fine-tuning</span>
<span class="hljs-comment"># !uv pip install --upgrade bitsandbytes peft trl python-dotenv</span>`,wrap:!1}}),E=new c({props:{title:"Basic Setup and Imports",local:"basic-setup-and-imports",headingTag:"h2"}}),V=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBvcyUwQWltcG9ydCUyMHdhcm5pbmdzJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMERpY3QlMkMlMjBBbnklMkMlMjBPcHRpb25hbCUyQyUyMFR1cGxlJTBBJTBBJTIzJTIwU2V0JTIwdXAlMjBHUFUlMjBhbmQlMjBzdXBwcmVzcyUyMHdhcm5pbmdzJTIwZm9yJTIwY2xlYW5lciUyMG91dHB1dCUwQW9zLmVudmlyb24lNUIlMjJDVURBX1ZJU0lCTEVfREVWSUNFUyUyMiU1RCUyMCUzRCUyMCUyMjAlMjIlMEF3YXJuaW5ncy5maWx0ZXJ3YXJuaW5ncyglMjJpZ25vcmUlMjIpJTBBJTBBcHJpbnQoZiUyMlB5VG9yY2glMjB2ZXJzaW9uJTNBJTIwJTdCdG9yY2guX192ZXJzaW9uX18lN0QlMjIpJTBBcHJpbnQoZiUyMkNVREElMjBhdmFpbGFibGUlM0ElMjAlN0J0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTdEJTIyKSUwQWlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJHUFUlM0ElMjAlN0J0b3JjaC5jdWRhLmdldF9kZXZpY2VfbmFtZSgwKSU3RCUyMiklMEElMjAlMjAlMjAlMjBwcmludChmJTIyVlJBTSUzQSUyMCU3QnRvcmNoLmN1ZGEuZ2V0X2RldmljZV9wcm9wZXJ0aWVzKDApLnRvdGFsX21lbW9yeSUyMCUyRiUyMDFlOSUzQS4xZiU3RCUyMEdCJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> warnings
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>, <span class="hljs-type">Optional</span>, <span class="hljs-type">Tuple</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set up GPU and suppress warnings for cleaner output</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>os.environ[<span class="hljs-string">&quot;CUDA_VISIBLE_DEVICES&quot;</span>] = <span class="hljs-string">&quot;0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>warnings.filterwarnings(<span class="hljs-string">&quot;ignore&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;PyTorch version: <span class="hljs-subst">{torch.__version__}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CUDA available: <span class="hljs-subst">{torch.cuda.is_available()}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> torch.cuda.is_available():
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;GPU: <span class="hljs-subst">{torch.cuda.get_device_name(<span class="hljs-number">0</span>)}</span>&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;VRAM: <span class="hljs-subst">{torch.cuda.get_device_properties(<span class="hljs-number">0</span>).total_memory / <span class="hljs-number">1e9</span>:<span class="hljs-number">.1</span>f}</span> GB&quot;</span>)`,wrap:!1}}),_=new c({props:{title:"Hugging Face Authentication Setup",local:"hugging-face-authentication-setup",headingTag:"h2"}}),N=new w({props:{code:"JTIzJTIwU2V0JTIwdXAlMjBIdWdnaW5nRmFjZSUyMGF1dGhlbnRpY2F0aW9uJTBBZnJvbSUyMGRvdGVudiUyMGltcG9ydCUyMGxvYWRfZG90ZW52JTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTBBJTIzJTIwTG9hZCUyMGVudmlyb25tZW50JTIwdmFyaWFibGVzJTIwZnJvbSUyMC5lbnYlMjBmaWxlJTIwKG9wdGlvbmFsKSUwQWxvYWRfZG90ZW52KCklMEElMEElMjMlMjBBdXRoZW50aWNhdGUlMjB3aXRoJTIwSHVnZ2luZ0ZhY2UlMjB1c2luZyUyMHRva2VuJTIwZnJvbSUyMC5lbnYlMjBmaWxlJTBBaGZfdG9rZW4lMjAlM0QlMjBvcy5nZXRlbnYoJTIyaGZfYXBpX2tleSUyMiklMEFpZiUyMGhmX3Rva2VuJTNBJTBBJTIwJTIwJTIwJTIwbG9naW4odG9rZW4lM0RoZl90b2tlbiklMEElMjAlMjAlMjAlMjBwcmludCglMjIlRTIlOUMlODUlMjBTdWNjZXNzZnVsbHklMjBhdXRoZW50aWNhdGVkJTIwd2l0aCUyMEh1Z2dpbmdGYWNlISUyMiklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyJUUyJTlBJUEwJUVGJUI4JThGJTIwJTIwV2FybmluZyUzQSUyMEhGX0FQSV9LRVklMjBub3QlMjBmb3VuZCUyMGluJTIwLmVudiUyMGZpbGUlMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyJTIwJTIwJTIwWW91JTIwY2FuJTIwc3RpbGwlMjBydW4lMjB0aGUlMjBub3RlYm9vayUyQyUyMGJ1dCUyMHdvbid0JTIwYmUlMjBhYmxlJTIwdG8lMjB1cGxvYWQlMjBtb2RlbHMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set up HuggingFace authentication</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load environment variables from .env file (optional)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>load_dotenv()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Authenticate with HuggingFace using token from .env file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_token = os.getenv(<span class="hljs-string">&quot;hf_api_key&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> hf_token:
<span class="hljs-meta">... </span>    login(token=hf_token)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Successfully authenticated with HuggingFace!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;⚠️  Warning: HF_API_KEY not found in .env file&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;   You can still run the notebook, but won&#x27;t be able to upload models&quot;</span>)`,wrap:!1}}),F=new c({props:{title:"Model Configuration Classes",local:"model-configuration-classes",headingTag:"h2"}}),z=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">ModelConfig</span>:
    <span class="hljs-string">&quot;&quot;&quot;Configuration for model-specific settings.&quot;&quot;&quot;</span>

    model_name: <span class="hljs-built_in">str</span>  <span class="hljs-comment"># HuggingFace model identifier</span>
    pad_token: <span class="hljs-built_in">str</span>  <span class="hljs-comment"># Padding token for the tokenizer</span>
    pad_token_id: <span class="hljs-built_in">int</span>  <span class="hljs-comment"># Numerical ID for the padding token</span>
    padding_side: <span class="hljs-built_in">str</span>  <span class="hljs-comment"># Side to add padding (&#x27;left&#x27; or &#x27;right&#x27;)</span>
    eos_token: <span class="hljs-built_in">str</span>  <span class="hljs-comment"># End of sequence token</span>
    eos_token_id: <span class="hljs-built_in">int</span>  <span class="hljs-comment"># End of sequence token ID</span>
    vocab_size: <span class="hljs-built_in">int</span>  <span class="hljs-comment"># Vocabulary size</span>
    model_type: <span class="hljs-built_in">str</span>  <span class="hljs-comment"># Model architecture type</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TrainingConfig</span>:
    <span class="hljs-string">&quot;&quot;&quot;Configuration for training hyperparameters.&quot;&quot;&quot;</span>

    output_dir: <span class="hljs-built_in">str</span>  <span class="hljs-comment"># Directory to save model checkpoints</span>
    batch_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">16</span>  <span class="hljs-comment"># Training batch size per device</span>
    gradient_accumulation_steps: <span class="hljs-built_in">int</span> = <span class="hljs-number">8</span>  <span class="hljs-comment"># Steps to accumulate gradients</span>
    learning_rate: <span class="hljs-built_in">float</span> = <span class="hljs-number">1e-4</span>  <span class="hljs-comment"># Learning rate for optimization</span>
    max_steps: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>  <span class="hljs-comment"># Maximum training steps</span>
    max_seq_length: <span class="hljs-built_in">int</span> = <span class="hljs-number">2048</span>  <span class="hljs-comment"># Maximum sequence length</span>
    lora_r: <span class="hljs-built_in">int</span> = <span class="hljs-number">16</span>  <span class="hljs-comment"># LoRA rank parameter</span>
    lora_alpha: <span class="hljs-built_in">int</span> = <span class="hljs-number">16</span>  <span class="hljs-comment"># LoRA alpha scaling parameter</span>
    lora_dropout: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.05</span>  <span class="hljs-comment"># LoRA dropout rate</span>
    save_steps: <span class="hljs-built_in">int</span> = <span class="hljs-number">250</span>  <span class="hljs-comment"># Steps between checkpoint saves</span>
    logging_steps: <span class="hljs-built_in">int</span> = <span class="hljs-number">10</span>  <span class="hljs-comment"># Steps between log outputs</span>
    warmup_ratio: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.1</span>  <span class="hljs-comment"># Warmup ratio for learning rate</span>`,wrap:!1}}),H=new c({props:{title:"Automatic Model Configuration",local:"automatic-model-configuration",headingTag:"h2"}}),x=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoConfig


<span class="hljs-keyword">def</span> <span class="hljs-title function_">auto_configure_model</span>(<span class="hljs-params">model_name: <span class="hljs-built_in">str</span>, custom_pad_token: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span></span>) -&gt; ModelConfig:
    <span class="hljs-string">&quot;&quot;&quot;
    Automatically configure any model by extracting information from its tokenizer.

    Args:
        model_name: HuggingFace model identifier
        custom_pad_token: Custom pad token if model doesn&#x27;t have one

    Returns:
        ModelConfig: Complete model configuration
    &quot;&quot;&quot;</span>

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔍 Loading model configuration: <span class="hljs-subst">{model_name}</span>&quot;</span>)

    <span class="hljs-comment"># Load tokenizer and model config</span>
    tokenizer = AutoTokenizer.from_pretrained(model_name, use_fast=<span class="hljs-literal">True</span>)
    model_config = AutoConfig.from_pretrained(model_name)

    <span class="hljs-comment"># Extract basic model info</span>
    model_type = <span class="hljs-built_in">getattr</span>(model_config, <span class="hljs-string">&quot;model_type&quot;</span>, <span class="hljs-string">&quot;unknown&quot;</span>)
    vocab_size = <span class="hljs-built_in">getattr</span>(model_config, <span class="hljs-string">&quot;vocab_size&quot;</span>, <span class="hljs-built_in">len</span>(tokenizer.get_vocab()))

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 Model: <span class="hljs-subst">{model_type}</span>, vocab_size: <span class="hljs-subst">{vocab_size:,}</span>&quot;</span>)

    <span class="hljs-comment"># Get EOS token (required)</span>
    eos_token = tokenizer.eos_token
    eos_token_id = tokenizer.eos_token_id

    <span class="hljs-keyword">if</span> eos_token <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;Model &#x27;<span class="hljs-subst">{model_name}</span>&#x27; missing EOS token&quot;</span>)

    <span class="hljs-comment"># Get or set pad token</span>
    pad_token = tokenizer.pad_token
    pad_token_id = tokenizer.pad_token_id

    <span class="hljs-keyword">if</span> pad_token <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">if</span> custom_pad_token <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;Model needs custom_pad_token. Use &#x27;&lt;|eot_id|&gt;&#x27; for Llama, &#x27;&lt;|im_end|&gt;&#x27; for Qwen&quot;</span>)

        pad_token = custom_pad_token
        <span class="hljs-keyword">if</span> pad_token <span class="hljs-keyword">in</span> tokenizer.get_vocab():
            pad_token_id = tokenizer.get_vocab()[pad_token]
        <span class="hljs-keyword">else</span>:
            tokenizer.add_special_tokens({<span class="hljs-string">&quot;pad_token&quot;</span>: pad_token})
            pad_token_id = tokenizer.pad_token_id

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ Configured - pad: &#x27;<span class="hljs-subst">{pad_token}</span>&#x27; (ID: <span class="hljs-subst">{pad_token_id}</span>), eos: &#x27;<span class="hljs-subst">{eos_token}</span>&#x27; (ID: <span class="hljs-subst">{eos_token_id}</span>)&quot;</span>)

    <span class="hljs-keyword">return</span> ModelConfig(
        model_name=model_name,
        pad_token=pad_token,
        pad_token_id=pad_token_id,
        padding_side=<span class="hljs-string">&quot;left&quot;</span>,  <span class="hljs-comment"># Standard for causal LMs</span>
        eos_token=eos_token,
        eos_token_id=eos_token_id,
        vocab_size=vocab_size,
        model_type=model_type,
    )`,wrap:!1}}),$=new w({props:{code:"ZGVmJTIwY3JlYXRlX3RyYWluaW5nX2NvbmZpZyhtb2RlbF9uYW1lJTNBJTIwc3RyJTJDJTIwKiprd2FyZ3MpJTIwLSUzRSUyMFRyYWluaW5nQ29uZmlnJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQ3JlYXRlJTIwdHJhaW5pbmclMjBjb25maWd1cmF0aW9uJTIwd2l0aCUyMGF1dG9tYXRpYyUyMG91dHB1dCUyMGRpcmVjdG9yeS4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjMlMjBDcmVhdGUlMjBjbGVhbiUyMGRpcmVjdG9yeSUyMG5hbWUlMjBmcm9tJTIwbW9kZWwlMjBuYW1lJTBBJTIwJTIwJTIwJTIwbW9kZWxfY2xlYW4lMjAlM0QlMjBtb2RlbF9uYW1lLnNwbGl0KCUyMiUyRiUyMiklNUItMSU1RC5yZXBsYWNlKCUyMi0lMjIlMkMlMjAlMjJfJTIyKS5yZXBsYWNlKCUyMi4lMjIlMkMlMjAlMjJfJTIyKSUwQSUyMCUyMCUyMCUyMGRlZmF1bHRfb3V0cHV0X2RpciUyMCUzRCUyMGYlMjIuJTJGJTdCbW9kZWxfY2xlYW4lN0RfeExBTSUyMiUwQSUwQSUyMCUyMCUyMCUyMGNvbmZpZ19kaWN0JTIwJTNEJTIwJTdCJTIyb3V0cHV0X2RpciUyMiUzQSUyMGRlZmF1bHRfb3V0cHV0X2RpciUyQyUyMCoqa3dhcmdzJTdEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwVHJhaW5pbmdDb25maWcoKipjb25maWdfZGljdCklMEElMEElMEFwcmludCglMjIlRTIlOUMlODUlMjBDb25maWd1cmF0aW9uJTIwc3lzdGVtJTIwcmVhZHkhJTIyKSUwQXByaW50KCUyMiVGMCU5RiU5MiVBMSUyMFN1cHBvcnRzJTIwTGxhbWElMkMlMjBRd2VuJTJDJTIwTWlzdHJhbCUyQyUyMEdlbW1hJTJDJTIwUGhpJTJDJTIwYW5kJTIwbW9yZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">create_training_config</span>(<span class="hljs-params">model_name: <span class="hljs-built_in">str</span>, **kwargs</span>) -&gt; TrainingConfig:
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Create training configuration with automatic output directory.&quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Create clean directory name from model name</span>
<span class="hljs-meta">... </span>    model_clean = model_name.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>].replace(<span class="hljs-string">&quot;-&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>).replace(<span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>)
<span class="hljs-meta">... </span>    default_output_dir = <span class="hljs-string">f&quot;./<span class="hljs-subst">{model_clean}</span>_xLAM&quot;</span>

<span class="hljs-meta">... </span>    config_dict = {<span class="hljs-string">&quot;output_dir&quot;</span>: default_output_dir, **kwargs}
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> TrainingConfig(**config_dict)


<span class="hljs-meta">... </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Configuration system ready!&quot;</span>)
<span class="hljs-meta">... </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;💡 Supports Llama, Qwen, Mistral, Gemma, Phi, and more&quot;</span>)`,wrap:!1}}),D=new c({props:{title:"Hardware Detection and Setup",local:"hardware-detection-and-setup",headingTag:"h2"}}),O=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">setup_hardware_config</span>() -&gt; <span class="hljs-type">Tuple</span>[torch.dtype, <span class="hljs-built_in">str</span>]:
    <span class="hljs-string">&quot;&quot;&quot;
    Automatically detect and configure hardware-specific settings.

    Returns:
        Tuple[torch.dtype, str]: compute_dtype and attention_implementation
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🔍 Detecting hardware capabilities...&quot;</span>)

    <span class="hljs-keyword">if</span> torch.cuda.is_bf16_supported():
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ bfloat16 supported - using optimal precision&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;📦 Installing FlashAttention for better performance...&quot;</span>)

        <span class="hljs-comment"># Install FlashAttention for supported hardware</span>
        os.system(<span class="hljs-string">&quot;pip install flash_attn --no-build-isolation&quot;</span>)

        compute_dtype = torch.bfloat16
        attn_implementation = <span class="hljs-string">&quot;flash_attention_2&quot;</span>

        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🚀 Configuration: bfloat16 + FlashAttention 2&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;⚠️  bfloat16 not supported - using float16 fallback&quot;</span>)
        compute_dtype = torch.float16
        attn_implementation = <span class="hljs-string">&quot;sdpa&quot;</span>  <span class="hljs-comment"># Scaled Dot Product Attention</span>

        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🔄 Configuration: float16 + SDPA&quot;</span>)

    <span class="hljs-keyword">return</span> compute_dtype, attn_implementation


<span class="hljs-comment"># Configure hardware settings</span>
compute_dtype, attn_implementation = setup_hardware_config()`,wrap:!1}}),P=new c({props:{title:"Tokenizer Setup Function",local:"tokenizer-setup-function",headingTag:"h2"}}),sl=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">setup_tokenizer</span>(<span class="hljs-params">model_config: ModelConfig</span>) -&gt; AutoTokenizer:
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>    Initialize and configure the tokenizer using model configuration.

<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        model_config: Model configuration with all token information

<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        AutoTokenizer: Configured tokenizer with proper pad token settings
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔤 Loading tokenizer for <span class="hljs-subst">{model_config.model_name}</span>&quot;</span>)

<span class="hljs-meta">... </span>    tokenizer = AutoTokenizer.from_pretrained(model_config.model_name, use_fast=<span class="hljs-literal">True</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Configure padding token using values from model_config</span>
<span class="hljs-meta">... </span>    tokenizer.pad_token = model_config.pad_token
<span class="hljs-meta">... </span>    tokenizer.pad_token_id = model_config.pad_token_id
<span class="hljs-meta">... </span>    tokenizer.padding_side = model_config.padding_side

<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ Tokenizer configured - pad: &#x27;<span class="hljs-subst">{model_config.pad_token}</span>&#x27; (ID: <span class="hljs-subst">{model_config.pad_token_id}</span>)&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 Hardware Configuration Complete:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Compute dtype: <span class="hljs-subst">{compute_dtype}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Attention implementation: <span class="hljs-subst">{attn_implementation}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Device: <span class="hljs-subst">{torch.cuda.get_device_name(<span class="hljs-number">0</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;CPU&#x27;</span>}</span>&quot;</span>)`,wrap:!1}}),tl=new c({props:{title:"Dataset Processing",local:"dataset-processing",headingTag:"h2"}}),pl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> multiprocessing
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Dataset


<span class="hljs-keyword">def</span> <span class="hljs-title function_">process_xlam_sample</span>(<span class="hljs-params">row: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>], tokenizer</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">str</span>]:
    <span class="hljs-string">&quot;&quot;&quot;
    Process a single xLAM dataset sample into training format.

    The format we create is:
    &lt;user&gt;[user query]&lt;/user&gt;

    &lt;tools&gt;
    [tool definitions]
    &lt;/tools&gt;

    &lt;calls&gt;
    [expected function calls]
    &lt;/calls&gt;[EOS_TOKEN]
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Format user query</span>
    formatted_query = <span class="hljs-string">f&quot;&lt;user&gt;<span class="hljs-subst">{row[<span class="hljs-string">&#x27;query&#x27;</span>]}</span>&lt;/user&gt;\\n\\n&quot;</span>

    <span class="hljs-comment"># Parse and format available tools</span>
    <span class="hljs-keyword">try</span>:
        parsed_tools = json.loads(row[<span class="hljs-string">&quot;tools&quot;</span>])
        tools_text = <span class="hljs-string">&quot;\\n&quot;</span>.join(<span class="hljs-built_in">str</span>(tool) <span class="hljs-keyword">for</span> tool <span class="hljs-keyword">in</span> parsed_tools)
    <span class="hljs-keyword">except</span> json.JSONDecodeError:
        tools_text = <span class="hljs-built_in">str</span>(row[<span class="hljs-string">&quot;tools&quot;</span>])  <span class="hljs-comment"># Fallback to raw string</span>

    formatted_tools = <span class="hljs-string">f&quot;&lt;tools&gt;<span class="hljs-subst">{tools_text}</span>&lt;/tools&gt;\\n\\n&quot;</span>

    <span class="hljs-comment"># Parse and format expected function calls</span>
    <span class="hljs-keyword">try</span>:
        parsed_answers = json.loads(row[<span class="hljs-string">&quot;answers&quot;</span>])
        answers_text = <span class="hljs-string">&quot;\\n&quot;</span>.join(<span class="hljs-built_in">str</span>(answer) <span class="hljs-keyword">for</span> answer <span class="hljs-keyword">in</span> parsed_answers)
    <span class="hljs-keyword">except</span> json.JSONDecodeError:
        answers_text = <span class="hljs-built_in">str</span>(row[<span class="hljs-string">&quot;answers&quot;</span>])  <span class="hljs-comment"># Fallback to raw string</span>

    formatted_answers = <span class="hljs-string">f&quot;&lt;calls&gt;<span class="hljs-subst">{answers_text}</span>&lt;/calls&gt;&quot;</span>

    <span class="hljs-comment"># Combine all parts with EOS token</span>
    complete_text = formatted_query + formatted_tools + formatted_answers + tokenizer.eos_token

    <span class="hljs-comment"># Update row with processed data</span>
    row[<span class="hljs-string">&quot;query&quot;</span>] = formatted_query
    row[<span class="hljs-string">&quot;tools&quot;</span>] = formatted_tools
    row[<span class="hljs-string">&quot;answers&quot;</span>] = formatted_answers
    row[<span class="hljs-string">&quot;text&quot;</span>] = complete_text

    <span class="hljs-keyword">return</span> row`,wrap:!1}}),il=new w({props:{code:"ZGVmJTIwbG9hZF9hbmRfcHJvY2Vzc194bGFtX2RhdGFzZXQodG9rZW5pemVyJTNBJTIwQXV0b1Rva2VuaXplciUyQyUyMHNhbXBsZV9zaXplJTNBJTIwT3B0aW9uYWwlNUJpbnQlNUQlMjAlM0QlMjBOb25lKSUyMC0lM0UlMjBEYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwTG9hZCUyMGFuZCUyMHByb2Nlc3MlMjB0aGUlMjBjb21wbGV0ZSUyMHhMQU0lMjBkYXRhc2V0JTIwZm9yJTIwZnVuY3Rpb24lMjBjYWxsaW5nJTIwdHJhaW5pbmcuJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRva2VuaXplciUzQSUyMENvbmZpZ3VyZWQlMjB0b2tlbml6ZXIlMjBmb3IlMjB0aGUlMjBtb2RlbCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsZV9zaXplJTNBJTIwT3B0aW9uYWwlMjBudW1iZXIlMjBvZiUyMHNhbXBsZXMlMjB0byUyMHVzZSUyMChOb25lJTIwZm9yJTIwZnVsbCUyMGRhdGFzZXQpJTBBJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMERhdGFzZXQlM0ElMjBQcm9jZXNzZWQlMjBkYXRhc2V0JTIwcmVhZHklMjBmb3IlMjB0cmFpbmluZyUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHByaW50KCUyMiVGMCU5RiU5MyU4QSUyMExvYWRpbmclMjB4TEFNJTIwZnVuY3Rpb24lMjBjYWxsaW5nJTIwZGF0YXNldC4uLiUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBMb2FkJTIwdGhlJTIwU2FsZXNmb3JjZSUyMHhMQU0lMjBkYXRhc2V0JTIwZnJvbSUyMEh1Z2dpbmclMjBGYWNlJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJTYWxlc2ZvcmNlJTJGeGxhbS1mdW5jdGlvbi1jYWxsaW5nLTYwayUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVGMCU5RiU5MyU4QiUyME9yaWdpbmFsJTIwZGF0YXNldCUyMHNpemUlM0ElMjAlN0JsZW4oZGF0YXNldCklM0ElMkMlN0QlMjBzYW1wbGVzJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFNhbXBsZSUyMGRhdGFzZXQlMjBpZiUyMHJlcXVlc3RlZCUyMCh1c2VmdWwlMjBmb3IlMjB0ZXN0aW5nKSUwQSUyMCUyMCUyMCUyMGlmJTIwc2FtcGxlX3NpemUlMjBpcyUyMG5vdCUyME5vbmUlMjBhbmQlMjBzYW1wbGVfc2l6ZSUyMCUzQyUyMGxlbihkYXRhc2V0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNlbGVjdChyYW5nZShzYW1wbGVfc2l6ZSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVGMCU5RiU5NCVBQyUyMFVzaW5nJTIwc2FtcGxlJTIwc2l6ZSUzQSUyMCU3QnNhbXBsZV9zaXplJTNBJTJDJTdEJTIwc2FtcGxlcyUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBQcm9jZXNzJTIwYWxsJTIwc2FtcGxlcyUyMHVzaW5nJTIwbXVsdGlwcm9jZXNzaW5nJTIwZm9yJTIwZWZmaWNpZW5jeSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMiVFMiU5QSU5OSVFRiVCOCU4RiUyMFByb2Nlc3NpbmclMjBkYXRhc2V0JTIwc2FtcGxlcyUyMGludG8lMjB0cmFpbmluZyUyMGZvcm1hdC4uLiUyMiklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBwcm9jZXNzX2JhdGNoKGJhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiUyMiUyMlByb2Nlc3MlMjBhJTIwYmF0Y2glMjBvZiUyMHNhbXBsZXMlMjB3aXRoJTIwdGhlJTIwdG9rZW5pemVyLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2Nlc3NlZF9iYXRjaCUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihiYXRjaCU1QiUyMnF1ZXJ5JTIyJTVEKSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByb3clMjAlM0QlMjAlN0IlMjJxdWVyeSUyMiUzQSUyMGJhdGNoJTVCJTIycXVlcnklMjIlNUQlNUJpJTVEJTJDJTIwJTIydG9vbHMlMjIlM0ElMjBiYXRjaCU1QiUyMnRvb2xzJTIyJTVEJTVCaSU1RCUyQyUyMCUyMmFuc3dlcnMlMjIlM0ElMjBiYXRjaCU1QiUyMmFuc3dlcnMlMjIlNUQlNUJpJTVEJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvY2Vzc2VkX3JvdyUyMCUzRCUyMHByb2Nlc3NfeGxhbV9zYW1wbGUocm93JTJDJTIwdG9rZW5pemVyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2Nlc3NlZF9iYXRjaC5hcHBlbmQocHJvY2Vzc2VkX3JvdyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBDb252ZXJ0JTIwdG8lMjBiYXRjaCUyMGZvcm1hdCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjAlNUJpdGVtJTVCJTIydGV4dCUyMiU1RCUyMGZvciUyMGl0ZW0lMjBpbiUyMHByb2Nlc3NlZF9iYXRjaCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnF1ZXJ5JTIyJTNBJTIwJTVCaXRlbSU1QiUyMnF1ZXJ5JTIyJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwcHJvY2Vzc2VkX2JhdGNoJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydG9vbHMlMjIlM0ElMjAlNUJpdGVtJTVCJTIydG9vbHMlMjIlNUQlMjBmb3IlMjBpdGVtJTIwaW4lMjBwcm9jZXNzZWRfYmF0Y2glNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhbnN3ZXJzJTIyJTNBJTIwJTVCaXRlbSU1QiUyMmFuc3dlcnMlMjIlNUQlMjBmb3IlMjBpdGVtJTIwaW4lMjBwcm9jZXNzZWRfYmF0Y2glNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBQcm9jZXNzJTIwdGhlJTIwZGF0YXNldCUwQSUyMCUyMCUyMCUyMHByb2Nlc3NlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvY2Vzc19iYXRjaCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoZWQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDEwMDAlMkMlMjAlMjAlMjMlMjBQcm9jZXNzJTIwaW4lMjBiYXRjaGVzJTIwZm9yJTIwZWZmaWNpZW5jeSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9wcm9jJTNEbWluKDQlMkMlMjBtdWx0aXByb2Nlc3NpbmcuY3B1X2NvdW50KCkpJTJDJTIwJTIwJTIzJTIwVXNlJTIwbXVsdGlwbGUlMjBjb3JlcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlc2MlM0QlMjJQcm9jZXNzaW5nJTIweExBTSUyMHNhbXBsZXMlMjIlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyJUUyJTlDJTg1JTIwRGF0YXNldCUyMHByb2Nlc3NpbmclMjBjb21wbGV0ZSElMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVGMCU5RiU5MyU4QSUyMEZpbmFsJTIwZGF0YXNldCUyMHNpemUlM0ElMjAlN0JsZW4ocHJvY2Vzc2VkX2RhdGFzZXQpJTNBJTJDJTdEJTIwc2FtcGxlcyUyMiklMEElMjAlMjAlMjAlMjBwcmludCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyJUYwJTlGJTk0JUE0JTIwQXZlcmFnZSUyMHRleHQlMjBsZW5ndGglM0ElMjAlN0JzdW0obGVuKHRleHQpJTIwZm9yJTIwdGV4dCUyMGluJTIwcHJvY2Vzc2VkX2RhdGFzZXQlNUIndGV4dCclNUQpJTIwJTJGJTIwbGVuKHByb2Nlc3NlZF9kYXRhc2V0KSUzQSUyQy4wZiU3RCUyMGNoYXJhY3RlcnMlMjIlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcHJvY2Vzc2VkX2RhdGFzZXQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">load_and_process_xlam_dataset</span>(<span class="hljs-params">tokenizer: AutoTokenizer, sample_size: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">int</span>] = <span class="hljs-literal">None</span></span>) -&gt; Dataset:
    <span class="hljs-string">&quot;&quot;&quot;
    Load and process the complete xLAM dataset for function calling training.

    Args:
        tokenizer: Configured tokenizer for the model
        sample_size: Optional number of samples to use (None for full dataset)

    Returns:
        Dataset: Processed dataset ready for training
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;📊 Loading xLAM function calling dataset...&quot;</span>)

    <span class="hljs-comment"># Load the Salesforce xLAM dataset from Hugging Face</span>
    dataset = load_dataset(<span class="hljs-string">&quot;Salesforce/xlam-function-calling-60k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📋 Original dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset):,}</span> samples&quot;</span>)

    <span class="hljs-comment"># Sample dataset if requested (useful for testing)</span>
    <span class="hljs-keyword">if</span> sample_size <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sample_size &lt; <span class="hljs-built_in">len</span>(dataset):
        dataset = dataset.select(<span class="hljs-built_in">range</span>(sample_size))
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔬 Using sample size: <span class="hljs-subst">{sample_size:,}</span> samples&quot;</span>)

    <span class="hljs-comment"># Process all samples using multiprocessing for efficiency</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;⚙️ Processing dataset samples into training format...&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">process_batch</span>(<span class="hljs-params">batch</span>):
        <span class="hljs-string">&quot;&quot;&quot;Process a batch of samples with the tokenizer.&quot;&quot;&quot;</span>
        processed_batch = []
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(batch[<span class="hljs-string">&quot;query&quot;</span>])):
            row = {<span class="hljs-string">&quot;query&quot;</span>: batch[<span class="hljs-string">&quot;query&quot;</span>][i], <span class="hljs-string">&quot;tools&quot;</span>: batch[<span class="hljs-string">&quot;tools&quot;</span>][i], <span class="hljs-string">&quot;answers&quot;</span>: batch[<span class="hljs-string">&quot;answers&quot;</span>][i]}
            processed_row = process_xlam_sample(row, tokenizer)
            processed_batch.append(processed_row)

        <span class="hljs-comment"># Convert to batch format</span>
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;text&quot;</span>: [item[<span class="hljs-string">&quot;text&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> processed_batch],
            <span class="hljs-string">&quot;query&quot;</span>: [item[<span class="hljs-string">&quot;query&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> processed_batch],
            <span class="hljs-string">&quot;tools&quot;</span>: [item[<span class="hljs-string">&quot;tools&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> processed_batch],
            <span class="hljs-string">&quot;answers&quot;</span>: [item[<span class="hljs-string">&quot;answers&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> processed_batch],
        }

    <span class="hljs-comment"># Process the dataset</span>
    processed_dataset = dataset.<span class="hljs-built_in">map</span>(
        process_batch,
        batched=<span class="hljs-literal">True</span>,
        batch_size=<span class="hljs-number">1000</span>,  <span class="hljs-comment"># Process in batches for efficiency</span>
        num_proc=<span class="hljs-built_in">min</span>(<span class="hljs-number">4</span>, multiprocessing.cpu_count()),  <span class="hljs-comment"># Use multiple cores</span>
        desc=<span class="hljs-string">&quot;Processing xLAM samples&quot;</span>,
    )

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Dataset processing complete!&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 Final dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(processed_dataset):,}</span> samples&quot;</span>)
    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">f&quot;🔤 Average text length: <span class="hljs-subst">{<span class="hljs-built_in">sum</span>(<span class="hljs-built_in">len</span>(text) <span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> processed_dataset[<span class="hljs-string">&#x27;text&#x27;</span>]) / <span class="hljs-built_in">len</span>(processed_dataset):,<span class="hljs-number">.0</span>f}</span> characters&quot;</span>
    )

    <span class="hljs-keyword">return</span> processed_dataset`,wrap:!1}}),yl=new w({props:{code:"ZGVmJTIwcHJldmlld19kYXRhc2V0X3NhbXBsZShkYXRhc2V0JTNBJTIwRGF0YXNldCUyQyUyMGluZGV4JTNBJTIwaW50JTIwJTNEJTIwMCklMjAtJTNFJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMERpc3BsYXklMjBhJTIwZm9ybWF0dGVkJTIwcHJldmlldyUyMG9mJTIwYSUyMGRhdGFzZXQlMjBzYW1wbGUlMjBmb3IlMjBpbnNwZWN0aW9uLiUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0JTNBJTIwVGhlJTIwcHJvY2Vzc2VkJTIwZGF0YXNldCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluZGV4JTNBJTIwSW5kZXglMjBvZiUyMHRoZSUyMHNhbXBsZSUyMHRvJTIwcHJldmlldyUyMChkZWZhdWx0JTNBJTIwMCklMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpZiUyMGluZGV4JTIwJTNFJTNEJTIwbGVuKGRhdGFzZXQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVFMiU5RCU4QyUyMEluZGV4JTIwJTdCaW5kZXglN0QlMjBpcyUyMG91dCUyMG9mJTIwcmFuZ2UuJTIwRGF0YXNldCUyMGhhcyUyMCU3QmxlbihkYXRhc2V0KSU3RCUyMHNhbXBsZXMuJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUwQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUJpbmRleCU1RCUwQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlRjAlOUYlOTMlOEIlMjBEYXRhc2V0JTIwU2FtcGxlJTIwUHJldmlldyUyMChJbmRleCUzQSUyMCU3QmluZGV4JTdEKSUyMiklMEElMjAlMjAlMjAlMjBwcmludCglMjIlM0QlMjIlMjAqJTIwODApJTBBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiU1Q24lRjAlOUYlOTQlOEQlMjBSYXclMjBDb21wb25lbnRzJTNBJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJRdWVyeSUzQSUyMCU3QnNhbXBsZSU1QidxdWVyeSclNUQlNUIlM0EyMDAlNUQlN0QlN0InLi4uJyUyMGlmJTIwbGVuKHNhbXBsZSU1QidxdWVyeSclNUQpJTIwJTNFJTIwMjAwJTIwZWxzZSUyMCcnJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJUb29scyUzQSUyMCU3QnNhbXBsZSU1Qid0b29scyclNUQlNUIlM0EyMDAlNUQlN0QlN0InLi4uJyUyMGlmJTIwbGVuKHNhbXBsZSU1Qid0b29scyclNUQpJTIwJTNFJTIwMjAwJTIwZWxzZSUyMCcnJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJBbnN3ZXJzJTNBJTIwJTdCc2FtcGxlJTVCJ2Fuc3dlcnMnJTVEJTVCJTNBMjAwJTVEJTdEJTdCJy4uLiclMjBpZiUyMGxlbihzYW1wbGUlNUInYW5zd2VycyclNUQpJTIwJTNFJTIwMjAwJTIwZWxzZSUyMCcnJTdEJTIyKSUwQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlNUNuJUYwJTlGJTkzJTlEJTIwQ29tcGxldGUlMjBUcmFpbmluZyUyMFRleHQlM0ElMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyLSUyMiUyMColMjA0MCklMEElMjAlMjAlMjAlMjBwcmludChzYW1wbGUlNUIlMjJ0ZXh0JTIyJTVEKSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0lMjIlMjAqJTIwNDApJTBBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiU1Q24lRjAlOUYlOTMlOEElMjBTYW1wbGUlMjBTdGF0aXN0aWNzJTNBJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlMjAlMjAlMjAlRTIlODAlQTIlMjBUZXh0JTIwbGVuZ3RoJTNBJTIwJTdCbGVuKHNhbXBsZSU1Qid0ZXh0JyU1RCklM0ElMkMlN0QlMjBjaGFyYWN0ZXJzJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlMjAlMjAlMjAlRTIlODAlQTIlMjBFc3RpbWF0ZWQlMjB0b2tlbnMlM0ElMjB+JTdCbGVuKHNhbXBsZSU1Qid0ZXh0JyU1RCklMjAlMkYlMkYlMjA0JTNBJTJDJTdEJTIwdG9rZW5zJTIyKSUwQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMiU1Q24lRTIlOUMlODUlMjBQcmV2aWV3JTIwY29tcGxldGUhJTIyKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">preview_dataset_sample</span>(<span class="hljs-params">dataset: Dataset, index: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span></span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Display a formatted preview of a dataset sample for inspection.

    Args:
        dataset: The processed dataset
        index: Index of the sample to preview (default: 0)
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> index &gt;= <span class="hljs-built_in">len</span>(dataset):
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ Index <span class="hljs-subst">{index}</span> is out of range. Dataset has <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset)}</span> samples.&quot;</span>)
        <span class="hljs-keyword">return</span>

    sample = dataset[index]

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📋 Dataset Sample Preview (Index: <span class="hljs-subst">{index}</span>)&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&quot;</span> * <span class="hljs-number">80</span>)

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n🔍 Raw Components:&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Query: <span class="hljs-subst">{sample[<span class="hljs-string">&#x27;query&#x27;</span>][:<span class="hljs-number">200</span>]}</span><span class="hljs-subst">{<span class="hljs-string">&#x27;...&#x27;</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&#x27;query&#x27;</span>]) &gt; <span class="hljs-number">200</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;&#x27;</span>}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Tools: <span class="hljs-subst">{sample[<span class="hljs-string">&#x27;tools&#x27;</span>][:<span class="hljs-number">200</span>]}</span><span class="hljs-subst">{<span class="hljs-string">&#x27;...&#x27;</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&#x27;tools&#x27;</span>]) &gt; <span class="hljs-number">200</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;&#x27;</span>}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answers: <span class="hljs-subst">{sample[<span class="hljs-string">&#x27;answers&#x27;</span>][:<span class="hljs-number">200</span>]}</span><span class="hljs-subst">{<span class="hljs-string">&#x27;...&#x27;</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&#x27;answers&#x27;</span>]) &gt; <span class="hljs-number">200</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;&#x27;</span>}</span>&quot;</span>)

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n📝 Complete Training Text:&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;-&quot;</span> * <span class="hljs-number">40</span>)
    <span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;-&quot;</span> * <span class="hljs-number">40</span>)

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n📊 Sample Statistics:&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Text length: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&#x27;text&#x27;</span>]):,}</span> characters&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Estimated tokens: ~<span class="hljs-subst">{<span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&#x27;text&#x27;</span>]) // <span class="hljs-number">4</span>:,}</span> tokens&quot;</span>)

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n✅ Preview complete!&quot;</span>)`,wrap:!1}}),ol=new c({props:{title:"Loading and Processing the Dataset",local:"loading-and-processing-the-dataset",headingTag:"h2"}}),jl=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Import QLoRA training components when we need them</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, prepare_model_for_kbit_training
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, SFTConfig


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_qlora_model</span>(<span class="hljs-params">
    model_config: ModelConfig, tokenizer: AutoTokenizer, compute_dtype: torch.dtype, attn_implementation: <span class="hljs-built_in">str</span>
</span>) -&gt; AutoModelForCausalLM:
    <span class="hljs-string">&quot;&quot;&quot;
    Create and configure a QLoRA-enabled model for efficient fine-tuning.

    QLoRA uses 4-bit quantization and low-rank adapters to enable
    fine-tuning large models on consumer GPUs.
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🏗️  Creating QLoRA model: <span class="hljs-subst">{model_config.model_name}</span>&quot;</span>)

    <span class="hljs-comment"># Configure 4-bit quantization for memory efficiency</span>
    bnb_config = BitsAndBytesConfig(
        load_in_4bit=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Enable 4-bit quantization</span>
        bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,  <span class="hljs-comment"># Use NF4 quantization</span>
        bnb_4bit_compute_dtype=compute_dtype,  <span class="hljs-comment"># Computation data type</span>
        bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Double quantization for more memory savings</span>
    )

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;📦 Loading quantized model...&quot;</span>)

    <span class="hljs-comment"># Load model with quantization</span>
    model = AutoModelForCausalLM.from_pretrained(
        model_config.model_name,
        quantization_config=bnb_config,
        device_map={<span class="hljs-string">&quot;&quot;</span>: <span class="hljs-number">0</span>},  <span class="hljs-comment"># Load on first GPU</span>
        attn_implementation=attn_implementation,
        torch_dtype=compute_dtype,
        trust_remote_code=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Required for some models</span>
    )

    <span class="hljs-comment"># Prepare model for k-bit training (required for QLoRA)</span>
    model = prepare_model_for_kbit_training(model, gradient_checkpointing_kwargs={<span class="hljs-string">&quot;use_reentrant&quot;</span>: <span class="hljs-literal">True</span>})

    <span class="hljs-comment"># Configure tokenizer settings in model</span>
    model.config.pad_token_id = tokenizer.pad_token_id
    model.config.use_cache = <span class="hljs-literal">False</span>  <span class="hljs-comment"># Disable cache for training</span>

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ QLoRA model prepared successfully!&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;💾 Model memory footprint: ~<span class="hljs-subst">{model.get_memory_footprint() / <span class="hljs-number">1e9</span>:<span class="hljs-number">.1</span>f}</span> GB&quot;</span>)

    <span class="hljs-keyword">return</span> model`,wrap:!1}}),Ul=new c({props:{title:"QLoRA Training Setup",local:"qlora-training-setup",headingTag:"h2"}}),cl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_lora_config</span>(<span class="hljs-params">training_config: TrainingConfig</span>) -&gt; LoraConfig:
    <span class="hljs-string">&quot;&quot;&quot;
    Create LoRA configuration for parameter-efficient fine-tuning.

    LoRA (Low-Rank Adaptation) adds small trainable matrices to specific
    model layers while keeping the base model frozen.

    Args:
        training_config (TrainingConfig): Training configuration with LoRA parameters

    Returns:
        LoraConfig: Configured LoRA adapter settings

    LoRA Parameters:
        - r (rank): Dimensionality of adaptation matrices (higher = more capacity)
        - alpha: Scaling factor for LoRA weights
        - dropout: Regularization to prevent overfitting
        - target_modules: Which model layers to adapt
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;⚙️ Configuring LoRA adapters...&quot;</span>)

    <span class="hljs-comment"># Target modules for both Llama and Qwen architectures</span>
    target_modules = [
        <span class="hljs-string">&quot;k_proj&quot;</span>,
        <span class="hljs-string">&quot;q_proj&quot;</span>,
        <span class="hljs-string">&quot;v_proj&quot;</span>,
        <span class="hljs-string">&quot;o_proj&quot;</span>,  <span class="hljs-comment"># Attention projections</span>
        <span class="hljs-string">&quot;gate_proj&quot;</span>,
        <span class="hljs-string">&quot;down_proj&quot;</span>,
        <span class="hljs-string">&quot;up_proj&quot;</span>,  <span class="hljs-comment"># Feed-forward projections</span>
    ]

    lora_config = LoraConfig(
        lora_alpha=training_config.lora_alpha,
        lora_dropout=training_config.lora_dropout,
        r=training_config.lora_r,
        bias=<span class="hljs-string">&quot;none&quot;</span>,  <span class="hljs-comment"># Don&#x27;t adapt bias terms</span>
        task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,  <span class="hljs-comment"># Causal language modeling</span>
        target_modules=target_modules,
    )

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🎯 LoRA targeting modules: <span class="hljs-subst">{target_modules}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 LoRA parameters: r=<span class="hljs-subst">{training_config.lora_r}</span>, alpha=<span class="hljs-subst">{training_config.lora_alpha}</span>&quot;</span>)

    <span class="hljs-keyword">return</span> lora_config`,wrap:!1}}),wl=new c({props:{title:"LoRA Configuration",local:"lora-configuration",headingTag:"h2"}}),rl=new c({props:{title:"Training Execution",local:"training-execution",headingTag:"h2"}}),dl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">train_qlora_model</span>(<span class="hljs-params">
    dataset: Dataset, model: AutoModelForCausalLM, training_config: TrainingConfig, compute_dtype: torch.dtype
</span>) -&gt; SFTTrainer:
    <span class="hljs-string">&quot;&quot;&quot;
    Execute QLoRA fine-tuning with comprehensive configuration and monitoring.

    Args:
        dataset (Dataset): Processed training dataset
        model (AutoModelForCausalLM): QLoRA-configured model
        training_config (TrainingConfig): Training hyperparameters
        compute_dtype (torch.dtype): Computation data type

    Returns:
        SFTTrainer: Trained model trainer

    Training Features:
        - Supervised fine-tuning with SFTTrainer
        - Memory-optimized settings for consumer GPUs
        - Comprehensive logging and checkpointing
        - Automatic mixed precision training
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🚀 Starting QLoRA fine-tuning...&quot;</span>)

    <span class="hljs-comment"># Create LoRA configuration</span>
    peft_config = create_lora_config(training_config)

    <span class="hljs-comment"># Configure training arguments</span>
    training_arguments = SFTConfig(
        output_dir=training_config.output_dir,
        optim=<span class="hljs-string">&quot;adamw_8bit&quot;</span>,  <span class="hljs-comment"># 8-bit optimizer for memory efficiency</span>
        per_device_train_batch_size=training_config.batch_size,
        gradient_accumulation_steps=training_config.gradient_accumulation_steps,
        log_level=<span class="hljs-string">&quot;info&quot;</span>,  <span class="hljs-comment"># Detailed logging</span>
        save_steps=training_config.save_steps,
        logging_steps=training_config.logging_steps,
        learning_rate=training_config.learning_rate,
        fp16=compute_dtype == torch.float16,  <span class="hljs-comment"># Use FP16 if not using bfloat16</span>
        bf16=compute_dtype == torch.bfloat16,  <span class="hljs-comment"># Use bfloat16 if supported</span>
        max_steps=training_config.max_steps,
        warmup_ratio=training_config.warmup_ratio,
        lr_scheduler_type=<span class="hljs-string">&quot;linear&quot;</span>,
        dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,  <span class="hljs-comment"># Field containing training text</span>
        max_length=training_config.max_seq_length,
        remove_unused_columns=<span class="hljs-literal">False</span>,  <span class="hljs-comment"># Keep all dataset columns</span>
        <span class="hljs-comment"># Additional stability and performance settings</span>
        dataloader_drop_last=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Drop incomplete batches</span>
        gradient_checkpointing=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Enable gradient checkpointing</span>
        save_total_limit=<span class="hljs-number">3</span>,  <span class="hljs-comment"># Keep only 3 most recent checkpoints</span>
        load_best_model_at_end=<span class="hljs-literal">False</span>,  <span class="hljs-comment"># Don&#x27;t load best model (saves memory)</span>
    )

    <span class="hljs-comment"># Create trainer</span>
    trainer = SFTTrainer(
        model=model,
        train_dataset=dataset,
        peft_config=peft_config,
        args=training_arguments,
    )

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 Training configuration:&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset):,}</span> samples&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Batch size: <span class="hljs-subst">{training_config.batch_size}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Gradient accumulation: <span class="hljs-subst">{training_config.gradient_accumulation_steps}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Effective batch size: <span class="hljs-subst">{training_config.batch_size * training_config.gradient_accumulation_steps}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Max steps: <span class="hljs-subst">{training_config.max_steps:,}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Learning rate: <span class="hljs-subst">{training_config.learning_rate}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Output directory: <span class="hljs-subst">{training_config.output_dir}</span>&quot;</span>)

    <span class="hljs-comment"># Start training</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n🏁 Beginning training...&quot;</span>)
    trainer.train()

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Training completed successfully!&quot;</span>)

    <span class="hljs-keyword">return</span> trainer`,wrap:!1}}),Il=new c({props:{title:"🎯 Universal Model Selection",local:"-universal-model-selection",headingTag:"h2"}}),hl=new c({props:{title:"📋 Quick Model Selection",local:"-quick-model-selection",headingTag:"h3"}}),Zl=new w({props:{code:"JTIzJTIwJUYwJTlGJThFJUFGJTIwT05FLUxJTkUlMjBNT0RFTCUyMENPTkZJR1VSQVRJT04lMjAlRjAlOUYlOEUlQUYlMEElMjMlMjBKdXN0JTIwc3BlY2lmeSUyMGFueSUyMEh1Z2dpbmclMjBGYWNlJTIwbW9kZWwlMjBhbmQlMjBpdHMlMjBjdXN0b20lMjBwYWQlMjB0b2tlbiUyMC0lMjBldmVyeXRoaW5nJTIwZWxzZSUyMGlzJTIwYXV0b21hdGljISUwQSUwQSUyMyUyMCUzRCUzRCUzRCUyMFNpbXBseSUyMGNoYW5nZSUyMHRoaXMlMjBsaW5lJTIwdG8lMjB1c2UlMjBBTlklMjBtb2RlbCUyMCUzRCUzRCUzRCUwQU1PREVMX05BTUUlMjAlM0QlMjAlMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCLUluc3RydWN0JTIyJTBBY3VzdG9tX3BhZF90b2tlbiUyMCUzRCUyMCUyMiUzQyU3Q2VvdF9pZCU3QyUzRSUyMiUwQSUyMyUyMFVzZSUyMCclM0MlN0Nlb3RfaWQlN0MlM0UnJTIwZm9yJTIwTGxhbWEzJTJCJTIwbW9kZWxzJTJDJTIwJyUzQyU3Q2ltX2VuZCU3QyUzRSclMjBmb3IlMjBRd2VuMiUyQiUyMG1vZGVscyUyQyUyMCclM0MlMkZzJTNFJyUyMGZvciUyME1pc3RyYWwlMjBtb2RlbHMlMkMlMjAnJTNDJTdDZW5kJTdDJTNFJyUyMGZvciUyMFBoaTMlMkIlMjBtb2RlbHMlMEElMEElMjMlMjAlM0QlM0QlM0QlMjBQb3B1bGFyJTIwYWx0ZXJuYXRpdmVzJTIwKHVuY29tbWVudCUyMHRvJTIwdXNlKSUyMCUzRCUzRCUzRCUwQSUyMyUyME1PREVMX05BTUUlMjAlM0QlMjAlMjJRd2VuJTJGUXdlbjItN0ItSW5zdHJ1Y3QlMjIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBRd2VuMiUwQSUyMyUyME1PREVMX05BTUUlMjAlM0QlMjAlMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjIlMjIlMjAlMjAlMjAlMjAlMjMlMjBNaXN0cmFsJTBBJTIzJTIwTU9ERUxfTkFNRSUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRlBoaS0zLW1pbmktNGstaW5zdHJ1Y3QlMjIlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBQaGktMyUyME1pbmklMEElMjMlMjBNT0RFTF9OQU1FJTIwJTNEJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtMS4xLTdiLWl0JTIyJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwR2VtbWElMEElMjMlMjBNT0RFTF9OQU1FJTIwJTNEJTIwJTIyeW91ci1jdXN0b20tbW9kZWwlMkZtb2RlbC1uYW1lJTIyJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQW55JTIwY3VzdG9tJTIwbW9kZWwlMEElMEFwcmludChmJTIyJUYwJTlGJThFJUFGJTIwU2VsZWN0ZWQlMjBNb2RlbCUzQSUyMCU3Qk1PREVMX05BTUUlN0QlMjIpJTBBJTBBJTIzJTIwJUYwJTlGJTlBJTgwJTIwQVVUT01BVElDJTIwQ09ORklHVVJBVElPTiUyMC0lMjBObyUyMG1hbnVhbCUyMHNldHVwJTIwbmVlZGVkISUwQXByaW50KGYlMjIlNUNuJUYwJTlGJTk0JUE3JTIwQXV0by1jb25maWd1cmluZyUyMGV2ZXJ5dGhpbmclMjBmb3IlMjAlN0JNT0RFTF9OQU1FJTdELi4uJTIyKSUwQSUwQSUyMyUyMEV4dHJhY3QlMjBBTEwlMjBpbmZvcm1hdGlvbiUyMGF1dG9tYXRpY2FsbHklMjB1c2luZyUyMHRyYW5zZm9ybWVycyUwQW1vZGVsX2NvbmZpZyUyMCUzRCUyMGF1dG9fY29uZmlndXJlX21vZGVsKE1PREVMX05BTUUlMkMlMjBjdXN0b21fcGFkX3Rva2VuJTNEY3VzdG9tX3BhZF90b2tlbiklMEF0cmFpbmluZ19jb25maWclMjAlM0QlMjBjcmVhdGVfdHJhaW5pbmdfY29uZmlnKE1PREVMX05BTUUpJTBBJTBBcHJpbnQoZiUyMiU1Q24lRjAlOUYlOEUlODklMjBSZWFkeSUyMHRvJTIwZmluZS10dW5lISUyMEV2ZXJ5dGhpbmclMjBjb25maWd1cmVkJTIwYXV0b21hdGljYWxseSUzQSUyMiklMEFwcmludChmJTIyJTIwJTIwJTIwJUUyJTlDJTg1JTIwTW9kZWwlMjB0eXBlJTNBJTIwJTdCbW9kZWxfY29uZmlnLm1vZGVsX3R5cGUlN0QlMjIpJTBBcHJpbnQoZiUyMiUyMCUyMCUyMCVFMiU5QyU4NSUyMFZvY2FidWxhcnklM0ElMjAlN0Jtb2RlbF9jb25maWcudm9jYWJfc2l6ZSUzQSUyQyU3RCUyMHRva2VucyUyMiklMEFwcmludChmJTIyJTIwJTIwJTIwJUUyJTlDJTg1JTIwUGFkJTIwdG9rZW4lM0ElMjAnJTdCbW9kZWxfY29uZmlnLnBhZF90b2tlbiU3RCclMjAoSUQlM0ElMjAlN0Jtb2RlbF9jb25maWcucGFkX3Rva2VuX2lkJTdEKSUyMiklMEFwcmludChmJTIyJTIwJTIwJTIwJUUyJTlDJTg1JTIwT3V0cHV0JTIwZGlyJTNBJTIwJTdCdHJhaW5pbmdfY29uZmlnLm91dHB1dF9kaXIlN0QlMjIpJTBBJTBBcHJpbnQoZiUyMiU1Q24lRjAlOUYlOUElODAlMjBDb25maWd1cmF0aW9uJTIwY29tcGxldGUlMjBmb3IlMjAlN0JNT0RFTF9OQU1FJTdEISUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 🎯 ONE-LINE MODEL CONFIGURATION 🎯</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Just specify any Hugging Face model and its custom pad token - everything else is automatic!</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># === Simply change this line to use ANY model ===</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>MODEL_NAME = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>custom_pad_token = <span class="hljs-string">&quot;&lt;|eot_id|&gt;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use &#x27;&lt;|eot_id|&gt;&#x27; for Llama3+ models, &#x27;&lt;|im_end|&gt;&#x27; for Qwen2+ models, &#x27;&lt;/s&gt;&#x27; for Mistral models, &#x27;&lt;|end|&gt;&#x27; for Phi3+ models</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># === Popular alternatives (uncomment to use) ===</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># MODEL_NAME = &quot;Qwen/Qwen2-7B-Instruct&quot;                # Qwen2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># MODEL_NAME = &quot;mistralai/Mistral-7B-Instruct-v0.2&quot;    # Mistral</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># MODEL_NAME = &quot;microsoft/Phi-3-mini-4k-instruct&quot;      # Phi-3 Mini</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># MODEL_NAME = &quot;google/gemma-1.1-7b-it&quot;                # Gemma</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># MODEL_NAME = &quot;your-custom-model/model-name&quot;          # Any custom model</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🎯 Selected Model: <span class="hljs-subst">{MODEL_NAME}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 🚀 AUTOMATIC CONFIGURATION - No manual setup needed!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n🔧 Auto-configuring everything for <span class="hljs-subst">{MODEL_NAME}</span>...&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Extract ALL information automatically using transformers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_config = auto_configure_model(MODEL_NAME, custom_pad_token=custom_pad_token)
<span class="hljs-meta">&gt;&gt;&gt; </span>training_config = create_training_config(MODEL_NAME)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n🎉 Ready to fine-tune! Everything configured automatically:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   ✅ Model type: <span class="hljs-subst">{model_config.model_type}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   ✅ Vocabulary: <span class="hljs-subst">{model_config.vocab_size:,}</span> tokens&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   ✅ Pad token: &#x27;<span class="hljs-subst">{model_config.pad_token}</span>&#x27; (ID: <span class="hljs-subst">{model_config.pad_token_id}</span>)&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   ✅ Output dir: <span class="hljs-subst">{training_config.output_dir}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n🚀 Configuration complete for <span class="hljs-subst">{MODEL_NAME}</span>!&quot;</span>)`,wrap:!1}}),Gl=new w({props:{code:"JTIzJTIwVW5pdmVyc2FsJTIwZmluZS10dW5pbmclMjBwaXBlbGluZSUyMC0lMjB3b3JrcyUyMHdpdGglMjBhbnklMjBtb2RlbCElMEFwcmludChmJTIyJUYwJTlGJTlBJTgwJTIwU3RhcnRpbmclMjBmaW5lLXR1bmluZyUyMHBpcGVsaW5lJTIwZm9yJTIwJTdCbW9kZWxfY29uZmlnLm1vZGVsX25hbWUlN0QlMjIpJTBBJTBBJTIzJTIwU3RlcCUyMDElM0ElMjBTZXR1cCUyMHRva2VuaXplciUwQXByaW50KGYlMjIlNUNuJUYwJTlGJTkzJTlEJTIwU2V0dGluZyUyMHVwJTIwdG9rZW5pemVyLi4uJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMHNldHVwX3Rva2VuaXplcihtb2RlbF9jb25maWcpJTBBJTBBJTIzJTIwU3RlcCUyMDIlM0ElMjBMb2FkJTIwYW5kJTIwcHJvY2VzcyUyMGRhdGFzZXQlMEFwcmludChmJTIyJTVDbiVGMCU5RiU5MyU4QSUyMExvYWRpbmclMjBhbmQlMjBwcm9jZXNzaW5nJTIweExBTSUyMGRhdGFzZXQuLi4lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfYW5kX3Byb2Nlc3NfeGxhbV9kYXRhc2V0KHRva2VuaXplciUyQyUyMHNhbXBsZV9zaXplJTNETm9uZSklMjAlMjAlMjMlMjBTZXQlMjBzYW1wbGVfc2l6ZSUyMGZvciUyMHRlc3RpbmclMEElMEElMjMlMjBTdGVwJTIwMyUzQSUyMFByZXZpZXclMjBkYXRhc2V0JTIwc2FtcGxlJTBBcHJpbnQoZiUyMiU1Q24lRjAlOUYlOTElODAlMjBEYXRhc2V0JTIwc2FtcGxlJTIwcHJldmlldyUzQSUyMiklMEFwcmV2aWV3X2RhdGFzZXRfc2FtcGxlKGRhdGFzZXQlMkMlMjBpbmRleCUzRDApJTBBJTBBJTIzJTIwU3RlcCUyMDQlM0ElMjBDcmVhdGUlMjBRTG9SQSUyMG1vZGVsJTBBcHJpbnQoZiUyMiU1Q24lRjAlOUYlOEYlOTclRUYlQjglOEYlMjAlMjBDcmVhdGluZyUyMFFMb1JBJTIwbW9kZWwuLi4lMjIpJTBBbW9kZWwlMjAlM0QlMjBjcmVhdGVfcWxvcmFfbW9kZWwobW9kZWxfY29uZmlnJTJDJTIwdG9rZW5pemVyJTJDJTIwY29tcHV0ZV9kdHlwZSUyQyUyMGF0dG5faW1wbGVtZW50YXRpb24pJTBBJTBBJTIzJTIwU3RlcCUyMDUlM0ElMjBFeGVjdXRlJTIwdHJhaW5pbmclMEFwcmludChmJTIyJTVDbiVGMCU5RiU4RSVBRiUyMFN0YXJ0aW5nJTIwdHJhaW5pbmcuLi4lMjIpJTBBdHJhaW5lciUyMCUzRCUyMHRyYWluX3Fsb3JhX21vZGVsKGRhdGFzZXQlM0RkYXRhc2V0JTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRyYWluaW5nX2NvbmZpZyUzRHRyYWluaW5nX2NvbmZpZyUyQyUyMGNvbXB1dGVfZHR5cGUlM0Rjb21wdXRlX2R0eXBlKSUwQSUwQXByaW50KGYlMjIlNUNuJUYwJTlGJThFJTg5JTIwRmluZS10dW5pbmclMjBjb21wbGV0ZWQlMjBmb3IlMjAlN0Jtb2RlbF9jb25maWcubW9kZWxfbmFtZS5zcGxpdCgnJTJGJyklNUItMSU1RCU3RCElMjIpJTBBcHJpbnQoZiUyMiVGMCU5RiU5MyU4MSUyME1vZGVsJTIwc2F2ZWQlMjB0byUzQSUyMCU3QnRyYWluaW5nX2NvbmZpZy5vdXRwdXRfZGlyJTdEJTIyKSUwQXByaW50KGYlMjIlRjAlOUYlOTQlOEQlMjBUbyUyMHRlc3QlMjB0aGUlMjBtb2RlbCUyQyUyMHJ1biUyMHRoZSUyMGluZmVyZW5jZSUyMGNlbGxzJTIwYmVsb3clMjIp",highlighted:`<span class="hljs-comment"># Universal fine-tuning pipeline - works with any model!</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🚀 Starting fine-tuning pipeline for <span class="hljs-subst">{model_config.model_name}</span>&quot;</span>)

<span class="hljs-comment"># Step 1: Setup tokenizer</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n📝 Setting up tokenizer...&quot;</span>)
tokenizer = setup_tokenizer(model_config)

<span class="hljs-comment"># Step 2: Load and process dataset</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n📊 Loading and processing xLAM dataset...&quot;</span>)
dataset = load_and_process_xlam_dataset(tokenizer, sample_size=<span class="hljs-literal">None</span>)  <span class="hljs-comment"># Set sample_size for testing</span>

<span class="hljs-comment"># Step 3: Preview dataset sample</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n👀 Dataset sample preview:&quot;</span>)
preview_dataset_sample(dataset, index=<span class="hljs-number">0</span>)

<span class="hljs-comment"># Step 4: Create QLoRA model</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n🏗️  Creating QLoRA model...&quot;</span>)
model = create_qlora_model(model_config, tokenizer, compute_dtype, attn_implementation)

<span class="hljs-comment"># Step 5: Execute training</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n🎯 Starting training...&quot;</span>)
trainer = train_qlora_model(dataset=dataset, model=model, training_config=training_config, compute_dtype=compute_dtype)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n🎉 Fine-tuning completed for <span class="hljs-subst">{model_config.model_name.split(<span class="hljs-string">&#x27;/&#x27;</span>)[-<span class="hljs-number">1</span>]}</span>!&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📁 Model saved to: <span class="hljs-subst">{training_config.output_dir}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔍 To test the model, run the inference cells below&quot;</span>)`,wrap:!1}}),Al=new c({props:{title:"Model Loading for Inference",local:"model-loading-for-inference",headingTag:"h2"}}),Wl=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Import required components for inference</span>
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel


<span class="hljs-keyword">def</span> <span class="hljs-title function_">load_trained_model</span>(<span class="hljs-params">
    model_config: ModelConfig, adapter_path: <span class="hljs-built_in">str</span>, compute_dtype: torch.dtype, attn_implementation: <span class="hljs-built_in">str</span>
</span>) -&gt; <span class="hljs-type">Tuple</span>[AutoModelForCausalLM, AutoTokenizer]:
    <span class="hljs-string">&quot;&quot;&quot;
    Load a trained model with LoRA adapters for inference.

    This function loads the base model with quantization and applies the trained
    LoRA adapters for efficient inference. It&#x27;s designed to work after training
    completion or for loading previously saved models.

    Args:
        model_config (ModelConfig): Configuration for the base model
        adapter_path (str): Path to the saved LoRA adapter
        compute_dtype (torch.dtype): Computation data type
        attn_implementation (str): Attention implementation

    Returns:
        Tuple[AutoModelForCausalLM, AutoTokenizer]: Loaded model and tokenizer

    Note:
        You may need to restart the notebook to free GPU memory before loading
        the model for inference, especially after training.
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔄 Loading trained model from <span class="hljs-subst">{adapter_path}</span>&quot;</span>)

    <span class="hljs-comment"># Configure quantization for inference</span>
    quantization_config = BitsAndBytesConfig(
        load_in_4bit=<span class="hljs-literal">True</span>,
        bnb_4bit_compute_dtype=compute_dtype,
        bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
        bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    )

    <span class="hljs-comment"># Load tokenizer with proper configuration</span>
    tokenizer = setup_tokenizer(model_config)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔤 Tokenizer loaded for <span class="hljs-subst">{model_config.model_name}</span>&quot;</span>)

    <span class="hljs-comment"># Load base model</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📦 Loading base model <span class="hljs-subst">{model_config.model_name}</span>...&quot;</span>)
    base_model = AutoModelForCausalLM.from_pretrained(
        model_config.model_name,
        quantization_config=quantization_config,
        torch_dtype=compute_dtype,
        device_map={<span class="hljs-string">&quot;&quot;</span>: <span class="hljs-number">0</span>},
        attn_implementation=attn_implementation,
        trust_remote_code=<span class="hljs-literal">True</span>,
    )

    <span class="hljs-comment"># Load LoRA adapters</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔗 Loading LoRA adapters from <span class="hljs-subst">{adapter_path}</span>...&quot;</span>)
    model = PeftModel.from_pretrained(base_model, adapter_path)

    <span class="hljs-comment"># Enable evaluation mode</span>
    model.<span class="hljs-built_in">eval</span>()

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Model loaded successfully and ready for inference!&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;💾 Total memory usage: ~<span class="hljs-subst">{model.get_memory_footprint() / <span class="hljs-number">1e9</span>:<span class="hljs-number">.1</span>f}</span> GB&quot;</span>)

    <span class="hljs-keyword">return</span> model, tokenizer`,wrap:!1}}),El=new c({props:{title:"Text Generation for Function Calls",local:"text-generation-for-function-calls",headingTag:"h2"}}),Vl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_function_call</span>(<span class="hljs-params">
    model: AutoModelForCausalLM,
    tokenizer: AutoTokenizer,
    prompt: <span class="hljs-built_in">str</span>,
    max_new_tokens: <span class="hljs-built_in">int</span> = <span class="hljs-number">512</span>,
    temperature: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.7</span>,
    do_sample: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">True</span>,
</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Generate a function call response using the fine-tuned model.

    Args:
        model (AutoModelForCausalLM): Fine-tuned model with LoRA adapters
        tokenizer (AutoTokenizer): Model tokenizer
        prompt (str): Input prompt for function calling
        max_new_tokens (int): Maximum tokens to generate
        temperature (float): Sampling temperature (only used when do_sample=True)
        do_sample (bool): Whether to use sampling

    Returns:
        str: Generated response with function calls

    Example Prompt Format:
        &quot;&lt;user&gt;Check if the numbers 8 and 1233 are powers of two.&lt;/user&gt;\\n\\n&lt;tools&gt;&quot;
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🎯 Generating response for prompt...&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📝 Input: <span class="hljs-subst">{prompt}</span>&quot;</span>)

    <span class="hljs-comment"># Tokenize input</span>
    inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

    <span class="hljs-comment"># Generate response with proper parameter handling</span>
    generation_kwargs = {
        <span class="hljs-string">&quot;max_new_tokens&quot;</span>: max_new_tokens,
        <span class="hljs-string">&quot;pad_token_id&quot;</span>: tokenizer.pad_token_id,
        <span class="hljs-string">&quot;eos_token_id&quot;</span>: tokenizer.eos_token_id,
        <span class="hljs-string">&quot;do_sample&quot;</span>: do_sample,
    }

    <span class="hljs-comment"># Only add sampling parameters if do_sample=True</span>
    <span class="hljs-keyword">if</span> do_sample:
        generation_kwargs[<span class="hljs-string">&quot;temperature&quot;</span>] = temperature

    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model.generate(**inputs, **generation_kwargs)

    <span class="hljs-comment"># Decode result</span>
    result = tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Generation completed!&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 Generated <span class="hljs-subst">{<span class="hljs-built_in">len</span>(outputs[<span class="hljs-number">0</span>]) - <span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&#x27;input_ids&#x27;</span>][<span class="hljs-number">0</span>])}</span> new tokens&quot;</span>)

    <span class="hljs-keyword">return</span> result`,wrap:!1}}),Ql=new c({props:{title:"Testing Function Calling Capabilities",local:"testing-function-calling-capabilities",headingTag:"h2"}}),kl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_function_calling_examples</span>(<span class="hljs-params">model: AutoModelForCausalLM, tokenizer: AutoTokenizer</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Test the model with various function calling examples.

    Args:
        model (AutoModelForCausalLM): Fine-tuned model
        tokenizer (AutoTokenizer): Model tokenizer
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🧪 Testing function calling capabilities...&quot;</span>)

    test_cases = [
        {
            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;Mathematical Function&quot;</span>,
            <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;&lt;user&gt;Check if the numbers 8 and 1233 are powers of two.&lt;/user&gt;\\n\\n&lt;tools&gt;&quot;</span>,
        },
        {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;Weather Query&quot;</span>, <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;&lt;user&gt;What&#x27;s the weather like in New York today?&lt;/user&gt;\\n\\n&lt;tools&gt;&quot;</span>},
        {
            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;Data Processing&quot;</span>,
            <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;&lt;user&gt;Calculate the average of these numbers: 10, 20, 30, 40, 50&lt;/user&gt;\\n\\n&lt;tools&gt;&quot;</span>,
        },
    ]

    <span class="hljs-keyword">for</span> i, test_case <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(test_cases, <span class="hljs-number">1</span>):
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n<span class="hljs-subst">{<span class="hljs-string">&#x27;=&#x27;</span>*<span class="hljs-number">60</span>}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Test Case <span class="hljs-subst">{i}</span>: <span class="hljs-subst">{test_case[<span class="hljs-string">&#x27;name&#x27;</span>]}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-string">&#x27;=&#x27;</span>*<span class="hljs-number">60</span>}</span>&quot;</span>)

        result = generate_function_call(
            model=model,
            tokenizer=tokenizer,
            prompt=test_case[<span class="hljs-string">&quot;prompt&quot;</span>],
            max_new_tokens=<span class="hljs-number">512</span>,  <span class="hljs-comment"># Adjust as needed</span>
            temperature=<span class="hljs-number">0.7</span>,
            do_sample=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Fixed: Use sampling with temperature</span>
        )

        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n🔍 Complete Response:&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;-&quot;</span> * <span class="hljs-number">40</span>)
        <span class="hljs-built_in">print</span>(result)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;-&quot;</span> * <span class="hljs-number">40</span>)

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n✅ All test cases completed!&quot;</span>)`,wrap:!1}}),Nl=new w({props:{code:"JTIzJTIwTG9hZCUyMGFuZCUyMHRlc3QlMjB0aGUlMjB0cmFpbmVkJTIwbW9kZWwlMEElMjMlMjBOb3RlJTNBJTIwWW91JTIwbWF5JTIwbmVlZCUyMHRvJTIwcmVzdGFydCUyMHRoZSUyMG5vdGVib29rJTIwdG8lMjBmcmVlJTIwbWVtb3J5JTIwYmVmb3JlJTIwcnVubmluZyUyMHRoaXMlMEElMEFwcmludCglMjIlRjAlOUYlOTQlODQlMjBMb2FkaW5nJTIwdHJhaW5lZCUyMG1vZGVsJTIwZm9yJTIwdGVzdGluZy4uLiUyMiklMEFwcmludCglMjIlRTIlOUElQTAlRUYlQjglOEYlMjAlMjBJZiUyMHlvdSUyMGVuY291bnRlciUyMG1lbW9yeSUyMGlzc3VlcyUyQyUyMHJlc3RhcnQlMjB0aGUlMjBub3RlYm9vayUyMGFuZCUyMHJ1biUyMG9ubHklMjB0aGlzJTIwY2VsbCUyMiklMEElMEElMjMlMjBEZXRlcm1pbmUlMjB0aGUlMjBhZGFwdGVyJTIwcGF0aCUyMGJhc2VkJTIwb24lMjB0aGUlMjB0cmFpbmluZyUyMGNvbmZpZ3VyYXRpb24lMEFhZGFwdGVyX3BhdGglMjAlM0QlMjBmJTIyJTdCdHJhaW5pbmdfY29uZmlnLm91dHB1dF9kaXIlN0QlMkZjaGVja3BvaW50LSU3QnRyYWluaW5nX2NvbmZpZy5tYXhfc3RlcHMlN0QlMjIlMEElMEFwcmludChmJTIyJUYwJTlGJTkzJTgxJTIwTG9va2luZyUyMGZvciUyMGFkYXB0ZXIlMjBhdCUzQSUyMCU3QmFkYXB0ZXJfcGF0aCU3RCUyMiklMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwdHJhaW5lZCUyMG1vZGVsJTBBdHJhaW5lZF9tb2RlbCUyQyUyMHRyYWluZWRfdG9rZW5pemVyJTIwJTNEJTIwbG9hZF90cmFpbmVkX21vZGVsKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2NvbmZpZyUzRG1vZGVsX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGFkYXB0ZXJfcGF0aCUzRGFkYXB0ZXJfcGF0aCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfZHR5cGUlM0Rjb21wdXRlX2R0eXBlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRGF0dG5faW1wbGVtZW50YXRpb24lMkMlMEEpJTBBJTBBJTIzJTIwVGVzdCUyMHdpdGglMjBhJTIwc2luZ2xlJTIwZXhhbXBsZSUwQXRlc3RfcHJvbXB0JTIwJTNEJTIwJTIyJTNDdXNlciUzRUNoZWNrJTIwaWYlMjB0aGUlMjBudW1iZXJzJTIwOCUyMGFuZCUyMDEyMzMlMjBhcmUlMjBwb3dlcnMlMjBvZiUyMHR3by4lM0MlMkZ1c2VyJTNFJTVDbiU1Q24lM0N0b29scyUzRSUyMiUwQXJlc3VsdCUyMCUzRCUyMGdlbmVyYXRlX2Z1bmN0aW9uX2NhbGwodHJhaW5lZF9tb2RlbCUyQyUyMHRyYWluZWRfdG9rZW5pemVyJTJDJTIwdGVzdF9wcm9tcHQpJTBBJTBBcHJpbnQoZiUyMiU1Q24lRjAlOUYlOEUlQUYlMjBUZXN0JTIwUmVzdWx0JTIwZm9yJTIwJTdCbW9kZWxfY29uZmlnLm1vZGVsX25hbWUuc3BsaXQoJyUyRicpJTVCLTElNUQlN0QlM0ElMjIpJTBBcHJpbnQoJTIyJTNEJTIyJTIwKiUyMDgwKSUwQXByaW50KHJlc3VsdCklMEFwcmludCglMjIlM0QlMjIlMjAqJTIwODAp",highlighted:`<span class="hljs-comment"># Load and test the trained model</span>
<span class="hljs-comment"># Note: You may need to restart the notebook to free memory before running this</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🔄 Loading trained model for testing...&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;⚠️  If you encounter memory issues, restart the notebook and run only this cell&quot;</span>)

<span class="hljs-comment"># Determine the adapter path based on the training configuration</span>
adapter_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{training_config.output_dir}</span>/checkpoint-<span class="hljs-subst">{training_config.max_steps}</span>&quot;</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📁 Looking for adapter at: <span class="hljs-subst">{adapter_path}</span>&quot;</span>)

<span class="hljs-comment"># Load the trained model</span>
trained_model, trained_tokenizer = load_trained_model(
    model_config=model_config,
    adapter_path=adapter_path,
    compute_dtype=compute_dtype,
    attn_implementation=attn_implementation,
)

<span class="hljs-comment"># Test with a single example</span>
test_prompt = <span class="hljs-string">&quot;&lt;user&gt;Check if the numbers 8 and 1233 are powers of two.&lt;/user&gt;\\n\\n&lt;tools&gt;&quot;</span>
result = generate_function_call(trained_model, trained_tokenizer, test_prompt)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n🎯 Test Result for <span class="hljs-subst">{model_config.model_name.split(<span class="hljs-string">&#x27;/&#x27;</span>)[-<span class="hljs-number">1</span>]}</span>:&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&quot;</span> * <span class="hljs-number">80</span>)
<span class="hljs-built_in">print</span>(result)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&quot;</span> * <span class="hljs-number">80</span>)`,wrap:!1}}),Sl=new w({props:{code:"JTIzJTIwUnVuJTIwY29tcHJlaGVuc2l2ZSUyMHRlc3RpbmclMjBzdWl0ZSUyMGZvciUyMHlvdXIlMjB0cmFpbmVkJTIwbW9kZWwlMEF0ZXN0X2Z1bmN0aW9uX2NhbGxpbmdfZXhhbXBsZXModHJhaW5lZF9tb2RlbCUyQyUyMHRyYWluZWRfdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run comprehensive testing suite for your trained model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>test_function_calling_examples(trained_model, trained_tokenizer)`,wrap:!1}}),vl=new c({props:{title:"🎉 Conclusion and Next Steps",local:"-conclusion-and-next-steps",headingTag:"h2"}}),Yl=new c({props:{title:"📊 Summary",local:"-summary",headingTag:"h3"}}),ql=new c({props:{title:"🚀 Key Improvements Made",local:"-key-improvements-made",headingTag:"h3"}}),xl=new c({props:{title:"Universal Compatibility",local:"universal-compatibility",headingTag:"h4"}}),Ll=new c({props:{title:"Code Quality",local:"code-quality",headingTag:"h4"}}),Kl=new c({props:{title:"User Experience",local:"user-experience",headingTag:"h4"}}),Pl=new c({props:{title:"🔄 Next Steps and Extensions",local:"-next-steps-and-extensions",headingTag:"h3"}}),ls=new c({props:{title:"Model Improvements",local:"model-improvements",headingTag:"h4"}}),ns=new c({props:{title:"Evaluation Enhancements",local:"evaluation-enhancements",headingTag:"h4"}}),as=new c({props:{title:"Deployment Options",local:"deployment-options",headingTag:"h4"}}),es=new c({props:{title:"Additional Features",local:"additional-features",headingTag:"h4"}}),is=new c({props:{title:"📚 Resources and References",local:"-resources-and-references",headingTag:"h3"}}),os=new c({props:{title:"🎖️ Achievement Unlocked",local:"-achievement-unlocked",headingTag:"h3"}}),Ts=new Ra({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/function_calling_fine_tuning_llms_on_xlam.md"}}),{c(){m=e("meta"),ms=a(),cs=e("p"),rs=a(),i(r.$$.fragment),us=a(),i(u.$$.fragment),ds=a(),d=e("p"),d.innerHTML=ht,Is=a(),I=e("p"),I.innerHTML=Ct,bs=a(),b=e("p"),b.innerHTML=Bt,hs=a(),h=e("p"),h.innerHTML=gt,Cs=a(),C=e("ul"),C.innerHTML=Zt,Bs=a(),B=e("p"),B.innerHTML=ft,gs=a(),g=e("ul"),g.innerHTML=Gt,Zs=a(),Z=e("p"),Z.innerHTML=At,fs=a(),f=e("ul"),f.innerHTML=Rt,Gs=a(),G=e("p"),G.innerHTML=Wt,As=a(),A=e("ul"),A.innerHTML=Et,Rs=a(),R=e("p"),R.innerHTML=Xt,Ws=a(),i(W.$$.fragment),Es=a(),i(E.$$.fragment),Xs=a(),X=e("p"),X.textContent=Vt,Vs=a(),i(V.$$.fragment),Qs=a(),Q=e("pre"),Q.textContent=Qt,_s=a(),i(_.$$.fragment),ks=a(),k=e("p"),k.textContent=_t,Ns=a(),i(N.$$.fragment),Ss=a(),S=e("pre"),S.textContent=kt,Fs=a(),i(F.$$.fragment),vs=a(),v=e("p"),v.textContent=Nt,Ys=a(),Y=e("ol"),Y.innerHTML=St,zs=a(),i(z.$$.fragment),Hs=a(),i(H.$$.fragment),qs=a(),q=e("p"),q.textContent=Ft,xs=a(),i(x.$$.fragment),$s=a(),i($.$$.fragment),Ls=a(),L=e("pre"),L.textContent=vt,Ds=a(),i(D.$$.fragment),Ks=a(),K=e("p"),K.textContent=Yt,Os=a(),i(O.$$.fragment),Ps=a(),i(P.$$.fragment),ln=a(),ll=e("p"),ll.textContent=zt,sn=a(),i(sl.$$.fragment),nn=a(),nl=e("pre"),nl.textContent=Ht,tn=a(),i(tl.$$.fragment),an=a(),al=e("p"),al.textContent=qt,Mn=a(),Ml=e("p"),Ml.innerHTML=xt,en=a(),el=e("ul"),el.innerHTML=$t,pn=a(),i(pl.$$.fragment),yn=a(),i(il.$$.fragment),on=a(),i(yl.$$.fragment),Jn=a(),i(ol.$$.fragment),jn=a(),Jl=e("p"),Jl.textContent=Lt,Un=a(),i(jl.$$.fragment),Tn=a(),i(Ul.$$.fragment),cn=a(),Tl=e("p"),Tl.textContent=Dt,wn=a(),i(cl.$$.fragment),mn=a(),i(wl.$$.fragment),rn=a(),ml=e("p"),ml.textContent=Kt,un=a(),i(rl.$$.fragment),dn=a(),ul=e("p"),ul.textContent=Ot,In=a(),i(dl.$$.fragment),bn=a(),i(Il.$$.fragment),hn=a(),bl=e("p"),bl.innerHTML=Pt,Cn=a(),i(hl.$$.fragment),Bn=a(),Cl=e("p"),Cl.textContent=la,gn=a(),Bl=e("p"),Bl.innerHTML=sa,Zn=a(),gl=e("ul"),gl.innerHTML=na,fn=a(),i(Zl.$$.fragment),Gn=a(),fl=e("pre"),fl.textContent=ta,An=a(),i(Gl.$$.fragment),Rn=a(),i(Al.$$.fragment),Wn=a(),Rl=e("p"),Rl.textContent=aa,En=a(),i(Wl.$$.fragment),Xn=a(),i(El.$$.fragment),Vn=a(),Xl=e("p"),Xl.textContent=Ma,Qn=a(),i(Vl.$$.fragment),_n=a(),i(Ql.$$.fragment),kn=a(),_l=e("p"),_l.textContent=ea,Nn=a(),i(kl.$$.fragment),Sn=a(),i(Nl.$$.fragment),Fn=a(),i(Sl.$$.fragment),vn=a(),Fl=e("pre"),Fl.innerHTML=pa,Yn=a(),i(vl.$$.fragment),zn=a(),Hn=e("hr"),qn=a(),i(Yl.$$.fragment),xn=a(),zl=e("p"),zl.innerHTML=ia,$n=a(),Hl=e("ul"),Hl.innerHTML=ya,Ln=a(),i(ql.$$.fragment),Dn=a(),i(xl.$$.fragment),Kn=a(),$l=e("ul"),$l.innerHTML=oa,On=a(),i(Ll.$$.fragment),Pn=a(),Dl=e("ul"),Dl.innerHTML=Ja,lt=a(),i(Kl.$$.fragment),st=a(),Ol=e("ul"),Ol.innerHTML=ja,nt=a(),i(Pl.$$.fragment),tt=a(),i(ls.$$.fragment),at=a(),ss=e("ol"),ss.innerHTML=Ua,Mt=a(),i(ns.$$.fragment),et=a(),ts=e("ol"),ts.innerHTML=Ta,pt=a(),i(as.$$.fragment),it=a(),Ms=e("ol"),Ms.innerHTML=ca,yt=a(),i(es.$$.fragment),ot=a(),ps=e("ol"),ps.innerHTML=wa,Jt=a(),i(is.$$.fragment),jt=a(),ys=e("ul"),ys.innerHTML=ma,Ut=a(),i(os.$$.fragment),Tt=a(),Js=e("p"),Js.innerHTML=ra,ct=a(),js=e("p"),js.textContent=ua,wt=a(),mt=e("hr"),rt=a(),Us=e("p"),Us.innerHTML=da,ut=a(),i(Ts.$$.fragment),dt=a(),ws=e("p"),this.h()},l(l){const s=fa("svelte-u9bgzb",document.head);m=p(s,"META",{name:!0,content:!0}),s.forEach(n),ms=M(l),cs=p(l,"P",{}),Ia(cs).forEach(n),rs=M(l),y(r.$$.fragment,l),us=M(l),y(u.$$.fragment,l),ds=M(l),d=p(l,"P",{"data-svelte-h":!0}),T(d)!=="svelte-1wcfxf7"&&(d.innerHTML=ht),Is=M(l),I=p(l,"P",{"data-svelte-h":!0}),T(I)!=="svelte-nk8pjg"&&(I.innerHTML=Ct),bs=M(l),b=p(l,"P",{"data-svelte-h":!0}),T(b)!=="svelte-p86hf7"&&(b.innerHTML=Bt),hs=M(l),h=p(l,"P",{"data-svelte-h":!0}),T(h)!=="svelte-144uh4x"&&(h.innerHTML=gt),Cs=M(l),C=p(l,"UL",{"data-svelte-h":!0}),T(C)!=="svelte-1lvcm95"&&(C.innerHTML=Zt),Bs=M(l),B=p(l,"P",{"data-svelte-h":!0}),T(B)!=="svelte-1c3q00"&&(B.innerHTML=ft),gs=M(l),g=p(l,"UL",{"data-svelte-h":!0}),T(g)!=="svelte-1ygkxbz"&&(g.innerHTML=Gt),Zs=M(l),Z=p(l,"P",{"data-svelte-h":!0}),T(Z)!=="svelte-1l0t8mb"&&(Z.innerHTML=At),fs=M(l),f=p(l,"UL",{"data-svelte-h":!0}),T(f)!=="svelte-19sjw7i"&&(f.innerHTML=Rt),Gs=M(l),G=p(l,"P",{"data-svelte-h":!0}),T(G)!=="svelte-ygvktk"&&(G.innerHTML=Wt),As=M(l),A=p(l,"UL",{"data-svelte-h":!0}),T(A)!=="svelte-tnnr46"&&(A.innerHTML=Et),Rs=M(l),R=p(l,"P",{"data-svelte-h":!0}),T(R)!=="svelte-cucop9"&&(R.innerHTML=Xt),Ws=M(l),y(W.$$.fragment,l),Es=M(l),y(E.$$.fragment,l),Xs=M(l),X=p(l,"P",{"data-svelte-h":!0}),T(X)!=="svelte-4pzxfo"&&(X.textContent=Vt),Vs=M(l),y(V.$$.fragment,l),Qs=M(l),Q=p(l,"PRE",{"data-svelte-h":!0}),T(Q)!=="svelte-1nn5gbv"&&(Q.textContent=Qt),_s=M(l),y(_.$$.fragment,l),ks=M(l),k=p(l,"P",{"data-svelte-h":!0}),T(k)!=="svelte-h19jbj"&&(k.textContent=_t),Ns=M(l),y(N.$$.fragment,l),Ss=M(l),S=p(l,"PRE",{"data-svelte-h":!0}),T(S)!=="svelte-1yaudwa"&&(S.textContent=kt),Fs=M(l),y(F.$$.fragment,l),vs=M(l),v=p(l,"P",{"data-svelte-h":!0}),T(v)!=="svelte-1rfz7gc"&&(v.textContent=Nt),Ys=M(l),Y=p(l,"OL",{"data-svelte-h":!0}),T(Y)!=="svelte-ewbwt7"&&(Y.innerHTML=St),zs=M(l),y(z.$$.fragment,l),Hs=M(l),y(H.$$.fragment,l),qs=M(l),q=p(l,"P",{"data-svelte-h":!0}),T(q)!=="svelte-1v4wkkr"&&(q.textContent=Ft),xs=M(l),y(x.$$.fragment,l),$s=M(l),y($.$$.fragment,l),Ls=M(l),L=p(l,"PRE",{"data-svelte-h":!0}),T(L)!=="svelte-euglyw"&&(L.textContent=vt),Ds=M(l),y(D.$$.fragment,l),Ks=M(l),K=p(l,"P",{"data-svelte-h":!0}),T(K)!=="svelte-1apgrdp"&&(K.textContent=Yt),Os=M(l),y(O.$$.fragment,l),Ps=M(l),y(P.$$.fragment,l),ln=M(l),ll=p(l,"P",{"data-svelte-h":!0}),T(ll)!=="svelte-16i4o06"&&(ll.textContent=zt),sn=M(l),y(sl.$$.fragment,l),nn=M(l),nl=p(l,"PRE",{"data-svelte-h":!0}),T(nl)!=="svelte-fqnc52"&&(nl.textContent=Ht),tn=M(l),y(tl.$$.fragment,l),an=M(l),al=p(l,"P",{"data-svelte-h":!0}),T(al)!=="svelte-1c113tt"&&(al.textContent=qt),Mn=M(l),Ml=p(l,"P",{"data-svelte-h":!0}),T(Ml)!=="svelte-1da1j5l"&&(Ml.innerHTML=xt),en=M(l),el=p(l,"UL",{"data-svelte-h":!0}),T(el)!=="svelte-1bzadrj"&&(el.innerHTML=$t),pn=M(l),y(pl.$$.fragment,l),yn=M(l),y(il.$$.fragment,l),on=M(l),y(yl.$$.fragment,l),Jn=M(l),y(ol.$$.fragment,l),jn=M(l),Jl=p(l,"P",{"data-svelte-h":!0}),T(Jl)!=="svelte-y099h"&&(Jl.textContent=Lt),Un=M(l),y(jl.$$.fragment,l),Tn=M(l),y(Ul.$$.fragment,l),cn=M(l),Tl=p(l,"P",{"data-svelte-h":!0}),T(Tl)!=="svelte-10lfqbi"&&(Tl.textContent=Dt),wn=M(l),y(cl.$$.fragment,l),mn=M(l),y(wl.$$.fragment,l),rn=M(l),ml=p(l,"P",{"data-svelte-h":!0}),T(ml)!=="svelte-q6lhkl"&&(ml.textContent=Kt),un=M(l),y(rl.$$.fragment,l),dn=M(l),ul=p(l,"P",{"data-svelte-h":!0}),T(ul)!=="svelte-8nn6e4"&&(ul.textContent=Ot),In=M(l),y(dl.$$.fragment,l),bn=M(l),y(Il.$$.fragment,l),hn=M(l),bl=p(l,"P",{"data-svelte-h":!0}),T(bl)!=="svelte-m8etyh"&&(bl.innerHTML=Pt),Cn=M(l),y(hl.$$.fragment,l),Bn=M(l),Cl=p(l,"P",{"data-svelte-h":!0}),T(Cl)!=="svelte-1o215q8"&&(Cl.textContent=la),gn=M(l),Bl=p(l,"P",{"data-svelte-h":!0}),T(Bl)!=="svelte-1ds7t4j"&&(Bl.innerHTML=sa),Zn=M(l),gl=p(l,"UL",{"data-svelte-h":!0}),T(gl)!=="svelte-4ybqyv"&&(gl.innerHTML=na),fn=M(l),y(Zl.$$.fragment,l),Gn=M(l),fl=p(l,"PRE",{"data-svelte-h":!0}),T(fl)!=="svelte-c4t8wc"&&(fl.textContent=ta),An=M(l),y(Gl.$$.fragment,l),Rn=M(l),y(Al.$$.fragment,l),Wn=M(l),Rl=p(l,"P",{"data-svelte-h":!0}),T(Rl)!=="svelte-exsagt"&&(Rl.textContent=aa),En=M(l),y(Wl.$$.fragment,l),Xn=M(l),y(El.$$.fragment,l),Vn=M(l),Xl=p(l,"P",{"data-svelte-h":!0}),T(Xl)!=="svelte-1b6dez5"&&(Xl.textContent=Ma),Qn=M(l),y(Vl.$$.fragment,l),_n=M(l),y(Ql.$$.fragment,l),kn=M(l),_l=p(l,"P",{"data-svelte-h":!0}),T(_l)!=="svelte-10wzkmt"&&(_l.textContent=ea),Nn=M(l),y(kl.$$.fragment,l),Sn=M(l),y(Nl.$$.fragment,l),Fn=M(l),y(Sl.$$.fragment,l),vn=M(l),Fl=p(l,"PRE",{"data-svelte-h":!0}),T(Fl)!=="svelte-yrs79z"&&(Fl.innerHTML=pa),Yn=M(l),y(vl.$$.fragment,l),zn=M(l),Hn=p(l,"HR",{}),qn=M(l),y(Yl.$$.fragment,l),xn=M(l),zl=p(l,"P",{"data-svelte-h":!0}),T(zl)!=="svelte-1okcj8g"&&(zl.innerHTML=ia),$n=M(l),Hl=p(l,"UL",{"data-svelte-h":!0}),T(Hl)!=="svelte-1b0hkxy"&&(Hl.innerHTML=ya),Ln=M(l),y(ql.$$.fragment,l),Dn=M(l),y(xl.$$.fragment,l),Kn=M(l),$l=p(l,"UL",{"data-svelte-h":!0}),T($l)!=="svelte-1he7ow6"&&($l.innerHTML=oa),On=M(l),y(Ll.$$.fragment,l),Pn=M(l),Dl=p(l,"UL",{"data-svelte-h":!0}),T(Dl)!=="svelte-x5pxte"&&(Dl.innerHTML=Ja),lt=M(l),y(Kl.$$.fragment,l),st=M(l),Ol=p(l,"UL",{"data-svelte-h":!0}),T(Ol)!=="svelte-1co223r"&&(Ol.innerHTML=ja),nt=M(l),y(Pl.$$.fragment,l),tt=M(l),y(ls.$$.fragment,l),at=M(l),ss=p(l,"OL",{"data-svelte-h":!0}),T(ss)!=="svelte-1xupp26"&&(ss.innerHTML=Ua),Mt=M(l),y(ns.$$.fragment,l),et=M(l),ts=p(l,"OL",{"data-svelte-h":!0}),T(ts)!=="svelte-1xcwpje"&&(ts.innerHTML=Ta),pt=M(l),y(as.$$.fragment,l),it=M(l),Ms=p(l,"OL",{"data-svelte-h":!0}),T(Ms)!=="svelte-1hftmkl"&&(Ms.innerHTML=ca),yt=M(l),y(es.$$.fragment,l),ot=M(l),ps=p(l,"OL",{"data-svelte-h":!0}),T(ps)!=="svelte-1vc2fxa"&&(ps.innerHTML=wa),Jt=M(l),y(is.$$.fragment,l),jt=M(l),ys=p(l,"UL",{"data-svelte-h":!0}),T(ys)!=="svelte-7yazkv"&&(ys.innerHTML=ma),Ut=M(l),y(os.$$.fragment,l),Tt=M(l),Js=p(l,"P",{"data-svelte-h":!0}),T(Js)!=="svelte-1m5ldvz"&&(Js.innerHTML=ra),ct=M(l),js=p(l,"P",{"data-svelte-h":!0}),T(js)!=="svelte-1oyjwag"&&(js.textContent=ua),wt=M(l),mt=p(l,"HR",{}),rt=M(l),Us=p(l,"P",{"data-svelte-h":!0}),T(Us)!=="svelte-186p5gg"&&(Us.innerHTML=da),ut=M(l),y(Ts.$$.fragment,l),dt=M(l),ws=p(l,"P",{}),Ia(ws).forEach(n),this.h()},h(){ba(m,"name","hf:doc:metadata"),ba(m,"content",Ea)},m(l,s){Ga(document.head,m),t(l,ms,s),t(l,cs,s),t(l,rs,s),o(r,l,s),t(l,us,s),o(u,l,s),t(l,ds,s),t(l,d,s),t(l,Is,s),t(l,I,s),t(l,bs,s),t(l,b,s),t(l,hs,s),t(l,h,s),t(l,Cs,s),t(l,C,s),t(l,Bs,s),t(l,B,s),t(l,gs,s),t(l,g,s),t(l,Zs,s),t(l,Z,s),t(l,fs,s),t(l,f,s),t(l,Gs,s),t(l,G,s),t(l,As,s),t(l,A,s),t(l,Rs,s),t(l,R,s),t(l,Ws,s),o(W,l,s),t(l,Es,s),o(E,l,s),t(l,Xs,s),t(l,X,s),t(l,Vs,s),o(V,l,s),t(l,Qs,s),t(l,Q,s),t(l,_s,s),o(_,l,s),t(l,ks,s),t(l,k,s),t(l,Ns,s),o(N,l,s),t(l,Ss,s),t(l,S,s),t(l,Fs,s),o(F,l,s),t(l,vs,s),t(l,v,s),t(l,Ys,s),t(l,Y,s),t(l,zs,s),o(z,l,s),t(l,Hs,s),o(H,l,s),t(l,qs,s),t(l,q,s),t(l,xs,s),o(x,l,s),t(l,$s,s),o($,l,s),t(l,Ls,s),t(l,L,s),t(l,Ds,s),o(D,l,s),t(l,Ks,s),t(l,K,s),t(l,Os,s),o(O,l,s),t(l,Ps,s),o(P,l,s),t(l,ln,s),t(l,ll,s),t(l,sn,s),o(sl,l,s),t(l,nn,s),t(l,nl,s),t(l,tn,s),o(tl,l,s),t(l,an,s),t(l,al,s),t(l,Mn,s),t(l,Ml,s),t(l,en,s),t(l,el,s),t(l,pn,s),o(pl,l,s),t(l,yn,s),o(il,l,s),t(l,on,s),o(yl,l,s),t(l,Jn,s),o(ol,l,s),t(l,jn,s),t(l,Jl,s),t(l,Un,s),o(jl,l,s),t(l,Tn,s),o(Ul,l,s),t(l,cn,s),t(l,Tl,s),t(l,wn,s),o(cl,l,s),t(l,mn,s),o(wl,l,s),t(l,rn,s),t(l,ml,s),t(l,un,s),o(rl,l,s),t(l,dn,s),t(l,ul,s),t(l,In,s),o(dl,l,s),t(l,bn,s),o(Il,l,s),t(l,hn,s),t(l,bl,s),t(l,Cn,s),o(hl,l,s),t(l,Bn,s),t(l,Cl,s),t(l,gn,s),t(l,Bl,s),t(l,Zn,s),t(l,gl,s),t(l,fn,s),o(Zl,l,s),t(l,Gn,s),t(l,fl,s),t(l,An,s),o(Gl,l,s),t(l,Rn,s),o(Al,l,s),t(l,Wn,s),t(l,Rl,s),t(l,En,s),o(Wl,l,s),t(l,Xn,s),o(El,l,s),t(l,Vn,s),t(l,Xl,s),t(l,Qn,s),o(Vl,l,s),t(l,_n,s),o(Ql,l,s),t(l,kn,s),t(l,_l,s),t(l,Nn,s),o(kl,l,s),t(l,Sn,s),o(Nl,l,s),t(l,Fn,s),o(Sl,l,s),t(l,vn,s),t(l,Fl,s),t(l,Yn,s),o(vl,l,s),t(l,zn,s),t(l,Hn,s),t(l,qn,s),o(Yl,l,s),t(l,xn,s),t(l,zl,s),t(l,$n,s),t(l,Hl,s),t(l,Ln,s),o(ql,l,s),t(l,Dn,s),o(xl,l,s),t(l,Kn,s),t(l,$l,s),t(l,On,s),o(Ll,l,s),t(l,Pn,s),t(l,Dl,s),t(l,lt,s),o(Kl,l,s),t(l,st,s),t(l,Ol,s),t(l,nt,s),o(Pl,l,s),t(l,tt,s),o(ls,l,s),t(l,at,s),t(l,ss,s),t(l,Mt,s),o(ns,l,s),t(l,et,s),t(l,ts,s),t(l,pt,s),o(as,l,s),t(l,it,s),t(l,Ms,s),t(l,yt,s),o(es,l,s),t(l,ot,s),t(l,ps,s),t(l,Jt,s),o(is,l,s),t(l,jt,s),t(l,ys,s),t(l,Ut,s),o(os,l,s),t(l,Tt,s),t(l,Js,s),t(l,ct,s),t(l,js,s),t(l,wt,s),t(l,mt,s),t(l,rt,s),t(l,Us,s),t(l,ut,s),o(Ts,l,s),t(l,dt,s),t(l,ws,s),It=!0},p:Ca,i(l){It||(J(r.$$.fragment,l),J(u.$$.fragment,l),J(W.$$.fragment,l),J(E.$$.fragment,l),J(V.$$.fragment,l),J(_.$$.fragment,l),J(N.$$.fragment,l),J(F.$$.fragment,l),J(z.$$.fragment,l),J(H.$$.fragment,l),J(x.$$.fragment,l),J($.$$.fragment,l),J(D.$$.fragment,l),J(O.$$.fragment,l),J(P.$$.fragment,l),J(sl.$$.fragment,l),J(tl.$$.fragment,l),J(pl.$$.fragment,l),J(il.$$.fragment,l),J(yl.$$.fragment,l),J(ol.$$.fragment,l),J(jl.$$.fragment,l),J(Ul.$$.fragment,l),J(cl.$$.fragment,l),J(wl.$$.fragment,l),J(rl.$$.fragment,l),J(dl.$$.fragment,l),J(Il.$$.fragment,l),J(hl.$$.fragment,l),J(Zl.$$.fragment,l),J(Gl.$$.fragment,l),J(Al.$$.fragment,l),J(Wl.$$.fragment,l),J(El.$$.fragment,l),J(Vl.$$.fragment,l),J(Ql.$$.fragment,l),J(kl.$$.fragment,l),J(Nl.$$.fragment,l),J(Sl.$$.fragment,l),J(vl.$$.fragment,l),J(Yl.$$.fragment,l),J(ql.$$.fragment,l),J(xl.$$.fragment,l),J(Ll.$$.fragment,l),J(Kl.$$.fragment,l),J(Pl.$$.fragment,l),J(ls.$$.fragment,l),J(ns.$$.fragment,l),J(as.$$.fragment,l),J(es.$$.fragment,l),J(is.$$.fragment,l),J(os.$$.fragment,l),J(Ts.$$.fragment,l),It=!0)},o(l){j(r.$$.fragment,l),j(u.$$.fragment,l),j(W.$$.fragment,l),j(E.$$.fragment,l),j(V.$$.fragment,l),j(_.$$.fragment,l),j(N.$$.fragment,l),j(F.$$.fragment,l),j(z.$$.fragment,l),j(H.$$.fragment,l),j(x.$$.fragment,l),j($.$$.fragment,l),j(D.$$.fragment,l),j(O.$$.fragment,l),j(P.$$.fragment,l),j(sl.$$.fragment,l),j(tl.$$.fragment,l),j(pl.$$.fragment,l),j(il.$$.fragment,l),j(yl.$$.fragment,l),j(ol.$$.fragment,l),j(jl.$$.fragment,l),j(Ul.$$.fragment,l),j(cl.$$.fragment,l),j(wl.$$.fragment,l),j(rl.$$.fragment,l),j(dl.$$.fragment,l),j(Il.$$.fragment,l),j(hl.$$.fragment,l),j(Zl.$$.fragment,l),j(Gl.$$.fragment,l),j(Al.$$.fragment,l),j(Wl.$$.fragment,l),j(El.$$.fragment,l),j(Vl.$$.fragment,l),j(Ql.$$.fragment,l),j(kl.$$.fragment,l),j(Nl.$$.fragment,l),j(Sl.$$.fragment,l),j(vl.$$.fragment,l),j(Yl.$$.fragment,l),j(ql.$$.fragment,l),j(xl.$$.fragment,l),j(Ll.$$.fragment,l),j(Kl.$$.fragment,l),j(Pl.$$.fragment,l),j(ls.$$.fragment,l),j(ns.$$.fragment,l),j(as.$$.fragment,l),j(es.$$.fragment,l),j(is.$$.fragment,l),j(os.$$.fragment,l),j(Ts.$$.fragment,l),It=!1},d(l){l&&(n(ms),n(cs),n(rs),n(us),n(ds),n(d),n(Is),n(I),n(bs),n(b),n(hs),n(h),n(Cs),n(C),n(Bs),n(B),n(gs),n(g),n(Zs),n(Z),n(fs),n(f),n(Gs),n(G),n(As),n(A),n(Rs),n(R),n(Ws),n(Es),n(Xs),n(X),n(Vs),n(Qs),n(Q),n(_s),n(ks),n(k),n(Ns),n(Ss),n(S),n(Fs),n(vs),n(v),n(Ys),n(Y),n(zs),n(Hs),n(qs),n(q),n(xs),n($s),n(Ls),n(L),n(Ds),n(Ks),n(K),n(Os),n(Ps),n(ln),n(ll),n(sn),n(nn),n(nl),n(tn),n(an),n(al),n(Mn),n(Ml),n(en),n(el),n(pn),n(yn),n(on),n(Jn),n(jn),n(Jl),n(Un),n(Tn),n(cn),n(Tl),n(wn),n(mn),n(rn),n(ml),n(un),n(dn),n(ul),n(In),n(bn),n(hn),n(bl),n(Cn),n(Bn),n(Cl),n(gn),n(Bl),n(Zn),n(gl),n(fn),n(Gn),n(fl),n(An),n(Rn),n(Wn),n(Rl),n(En),n(Xn),n(Vn),n(Xl),n(Qn),n(_n),n(kn),n(_l),n(Nn),n(Sn),n(Fn),n(vn),n(Fl),n(Yn),n(zn),n(Hn),n(qn),n(xn),n(zl),n($n),n(Hl),n(Ln),n(Dn),n(Kn),n($l),n(On),n(Pn),n(Dl),n(lt),n(st),n(Ol),n(nt),n(tt),n(at),n(ss),n(Mt),n(et),n(ts),n(pt),n(it),n(Ms),n(yt),n(ot),n(ps),n(Jt),n(jt),n(ys),n(Ut),n(Tt),n(Js),n(ct),n(js),n(wt),n(mt),n(rt),n(Us),n(ut),n(dt),n(ws)),n(m),U(r,l),U(u,l),U(W,l),U(E,l),U(V,l),U(_,l),U(N,l),U(F,l),U(z,l),U(H,l),U(x,l),U($,l),U(D,l),U(O,l),U(P,l),U(sl,l),U(tl,l),U(pl,l),U(il,l),U(yl,l),U(ol,l),U(jl,l),U(Ul,l),U(cl,l),U(wl,l),U(rl,l),U(dl,l),U(Il,l),U(hl,l),U(Zl,l),U(Gl,l),U(Al,l),U(Wl,l),U(El,l),U(Vl,l),U(Ql,l),U(kl,l),U(Nl,l),U(Sl,l),U(vl,l),U(Yl,l),U(ql,l),U(xl,l),U(Ll,l),U(Kl,l),U(Pl,l),U(ls,l),U(ns,l),U(as,l),U(es,l),U(is,l),U(os,l),U(Ts,l)}}}const Ea='{"title":"Fine-tuning LLMs for Function Calling with xLAM Dataset","local":"fine-tuning-llms-for-function-calling-with-xlam-dataset","sections":[{"title":"Basic Setup and Imports","local":"basic-setup-and-imports","sections":[],"depth":2},{"title":"Hugging Face Authentication Setup","local":"hugging-face-authentication-setup","sections":[],"depth":2},{"title":"Model Configuration Classes","local":"model-configuration-classes","sections":[],"depth":2},{"title":"Automatic Model Configuration","local":"automatic-model-configuration","sections":[],"depth":2},{"title":"Hardware Detection and Setup","local":"hardware-detection-and-setup","sections":[],"depth":2},{"title":"Tokenizer Setup Function","local":"tokenizer-setup-function","sections":[],"depth":2},{"title":"Dataset Processing","local":"dataset-processing","sections":[],"depth":2},{"title":"Loading and Processing the Dataset","local":"loading-and-processing-the-dataset","sections":[],"depth":2},{"title":"QLoRA Training Setup","local":"qlora-training-setup","sections":[],"depth":2},{"title":"LoRA Configuration","local":"lora-configuration","sections":[],"depth":2},{"title":"Training Execution","local":"training-execution","sections":[],"depth":2},{"title":"🎯 Universal Model Selection","local":"-universal-model-selection","sections":[{"title":"📋 Quick Model Selection","local":"-quick-model-selection","sections":[],"depth":3}],"depth":2},{"title":"Model Loading for Inference","local":"model-loading-for-inference","sections":[],"depth":2},{"title":"Text Generation for Function Calls","local":"text-generation-for-function-calls","sections":[],"depth":2},{"title":"Testing Function Calling Capabilities","local":"testing-function-calling-capabilities","sections":[],"depth":2},{"title":"🎉 Conclusion and Next Steps","local":"-conclusion-and-next-steps","sections":[{"title":"📊 Summary","local":"-summary","sections":[],"depth":3},{"title":"🚀 Key Improvements Made","local":"-key-improvements-made","sections":[{"title":"Universal Compatibility","local":"universal-compatibility","sections":[],"depth":4},{"title":"Code Quality","local":"code-quality","sections":[],"depth":4},{"title":"User Experience","local":"user-experience","sections":[],"depth":4}],"depth":3},{"title":"🔄 Next Steps and Extensions","local":"-next-steps-and-extensions","sections":[{"title":"Model Improvements","local":"model-improvements","sections":[],"depth":4},{"title":"Evaluation Enhancements","local":"evaluation-enhancements","sections":[],"depth":4},{"title":"Deployment Options","local":"deployment-options","sections":[],"depth":4},{"title":"Additional Features","local":"additional-features","sections":[],"depth":4}],"depth":3},{"title":"📚 Resources and References","local":"-resources-and-references","sections":[],"depth":3},{"title":"🎖️ Achievement Unlocked","local":"-achievement-unlocked","sections":[],"depth":3}],"depth":2}],"depth":1}';function Xa(bt){return Ba(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Na extends ga{constructor(m){super(),Za(this,m,Xa,Wa,ha,{})}}export{Na as component};
