import{s as Ul,f as ml,n as jl,o as wl}from"../chunks/scheduler.65852ee5.js";import{S as Tl,i as Jl,g as i,s,r,A as fl,h as o,f as l,c as n,j as St,u as c,x as M,k as w,y as Cl,a,v as p,d as u,t as y,w as d}from"../chunks/index.65a1b999.js";import{D as gl,C as h}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as m,E as Il}from"../chunks/getInferenceSnippets.56942ade.js";function bl(_t){let T,Ae,Ie,Ge,J,ke,f,Be,C,qt='<em>Authored by: <a href="https://huggingface.co/davidberenstein1957" rel="nofollow">David Berenstein</a> and <a href="https://huggingface.co/sdiazlor" rel="nofollow">Sara Han Díaz</a></em>',$e,g,xt='<li><strong>Libraries</strong>: <a href="https://github.com/argilla-io/argilla" rel="nofollow">argilla</a>, <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">hf-inference-endpoints</a></li> <li><strong>Components</strong>: <a href="https://distilabel.argilla.io/latest/components-gallery/steps/loaddatafromhub/" rel="nofollow">LoadDataFromHub</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/tasks/textgeneration/" rel="nofollow">TextGeneration</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/tasks/ultrafeedback/" rel="nofollow">UltraFeedback</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/steps/groupcolumns/" rel="nofollow">GroupColumns</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/steps/formattextgenerationdpo/" rel="nofollow">FormatTextGenerationDPO</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/steps/textgenerationtoargilla/" rel="nofollow">PreferenceToArgilla</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/llms/inferenceendpointsllm/" rel="nofollow">InferenceEndpointsLLM</a></li>',We,I,Rt='In this tutorial, we will use distilabel to generate a synthetic preference dataset for DPO, ORPO or RLHF. <a href="https://github.com/argilla-io/distilabel" rel="nofollow">distilabel</a> is a synthetic data and AI feedback framework for engineers who need fast, reliable and scalable pipelines based on verified research papers. Check the documentation <a href="https://distilabel.argilla.io/latest/" rel="nofollow">here</a>.',ve,b,Vt='To generate the responses and evaluate them, we will use the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">serverless HF Inference API</a> integrated with distilabel. This is free but rate-limited, allowing you to test and evaluate over 150,000 public models, or your own private models, via simple HTTP requests, with fast inference hosted on Hugging Face shared infrastructure. If you need more compute power, you can deploy your own inference endpoint with <a href="https://huggingface.co/docs/inference-endpoints/guides/create_endpoint" rel="nofollow">Hugging Face Inference Endpoints</a>.',Ze,A,Qt='Finally, to further curate the data, we will use <a href="https://github.com/argilla-io/argilla" rel="nofollow">Argilla</a>, which allows us to provide human feedback on the data quality. Argilla is a collaboration tool for AI engineers and domain experts who need to build high-quality datasets for their projects. Check the documentation <a href="https://docs.argilla.io/latest/" rel="nofollow">here</a>.',Ee,G,Se,k,_e,B,Lt="To complete this tutorial, you need to install the distilabel SDK and a few third-party libraries via pip. We will be using <strong>the free but rate-limited Hugging Face serverless Inference API</strong> for this tutorial, so we need to install this as an extra distilabel dependency. You can install them by running the following command:",qe,$,xe,W,Re,v,Ft="Let’s make the required imports:",Ve,Z,Qe,E,Xt="You’ll need an <code>HF_TOKEN</code> to use the HF Inference Endpoints. Log in to use it directly within this notebook.",Le,S,Fe,_,Xe,q,Nt='You can skip this step or replace it with any other data evaluation tool, but the quality of your model will suffer from a lack of data quality, so we do recommend looking at your data. If you already deployed Argilla, you can skip this step. Otherwise, you can quickly deploy Argilla following <a href="https://docs.argilla.io/latest/getting_started/quickstart/" rel="nofollow">this guide</a>.',Ne,x,Ht="Along with that, you will need to install Argilla as a distilabel extra.",He,R,Ye,V,ze,Q,Yt="To generate our preference dataset, we will need to define a <code>Pipeline</code> with all the necessary steps. Below, we will go over each step in detail.",Pe,L,De,F,zt='We will use as source data the <a href="https://huggingface.co/datasets/argilla/10Kprompts-mini" rel="nofollow"><code>argilla/10Kprompts-mini</code></a> dataset from the Hugging Face Hub.',Ke,U,Pt,Oe,X,Dt="<li>Component: <code>LoadDataFromHub</code></li> <li>Input columns: <code>instruction</code> and <code>topic</code>, the same as in the loaded dataset</li> <li>Output columns: <code>instruction</code> and <code>topic</code></li>",et,N,tt,H,lt,Y,Kt='We need to generate the responses for the given instructions. We will use two different models available on the Hugging Face Hub through the Serverless Inference API: <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B-Instruct" rel="nofollow"><code>meta-llama/Meta-Llama-3-8B-Instruct</code></a> and <a href="https://huggingface.co/mistralai/Mixtral-8x7B-Instruct-v0.1" rel="nofollow"><code>mistralai/Mixtral-8x7B-Instruct-v0.1</code></a>. We will also indicate the generation parameters for each model.',at,z,Ot="<li>Component: <code>TextGeneration</code> task with LLMs using <code>InferenceEndpointsLLM</code></li> <li>Input columns: <code>instruction</code></li> <li>Output columns: <code>generation</code>, <code>distilabel_metadata</code>, <code>model_name</code> for each model</li>",st,P,el='For your use case and to improve the results, you can use any <a href="https://distilabel.argilla.io/latest/components-gallery/llms/" rel="nofollow">other LLM of your choice</a>.',nt,D,it,K,tl=`[&#123;'instruction': 'Which are the top cities in Spain?', 'generation': 'Spain is a country with a rich culture, history, and architecture, and it has many great cities to visit. Here are some of the top cities in Spain:\\n\\n1. **Madrid**: The capital city of Spain, known for its vibrant nightlife, museums, and historic landmarks like the Royal Palace and Prado Museum.\\n2. **Barcelona**: The second-largest city in Spain, famous for its modernist architecture, beaches, and iconic landmarks like La Sagrada Família and Park Güell, designed by Antoni Gaudí.\\n3. **Valencia**: Located on the Mediterranean coast, Valencia is known for its beautiful beaches, City of Arts and Sciences, and delicious local cuisine, such as paella.\\n4. **Seville**: The capital of Andalusia, Seville is famous for its stunning cathedral, Royal Alcázar Palace, and lively flamenco music scene.\\n5. **Málaga**: A coastal city in southern Spain, Málaga is known for its rich history, beautiful beaches, and being the birthplace of Pablo Picasso.\\n6. **Zaragoza**: Located in the northeastern region of Aragon, Zaragoza is a city with a rich history, known for its Roman ruins, Gothic cathedral, and beautiful parks.\\n7. **Granada**: A city in the Andalusian region, Granada is famous for its stunning Alhambra palace and generalife gardens, a UNESCO World Heritage Site.\\n8. **Bilbao**: A city in the Basque Country, Bilbao is known for its modern architecture, including the Guggenheim Museum, and its rich cultural heritage.\\n9. **Alicante**: A coastal city in the Valencia region, Alicante is famous for its beautiful beaches, historic castle, and lively nightlife.\\n10. **San Sebastián**: A city in the Basque Country, San Sebastián is known for its stunning beaches, gastronomic scene, and cultural events like the San Sebastián International Film Festival.\\n\\nThese are just a few of the many great cities in Spain, each with its own unique character and attractions.', 'distilabel_metadata': &#123;'raw_output_text_generation_0': 'Spain is a country with a rich culture, history, and architecture, and it has many great cities to visit. Here are some of the top cities in Spain:\\n\\n1. **Madrid**: The capital city of Spain, known for its vibrant nightlife, museums, and historic landmarks like the Royal Palace and Prado Museum.\\n2. **Barcelona**: The second-largest city in Spain, famous for its modernist architecture, beaches, and iconic landmarks like La Sagrada Família and Park Güell, designed by Antoni Gaudí.\\n3. **Valencia**: Located on the Mediterranean coast, Valencia is known for its beautiful beaches, City of Arts and Sciences, and delicious local cuisine, such as paella.\\n4. **Seville**: The capital of Andalusia, Seville is famous for its stunning cathedral, Royal Alcázar Palace, and lively flamenco music scene.\\n5. **Málaga**: A coastal city in southern Spain, Málaga is known for its rich history, beautiful beaches, and being the birthplace of Pablo Picasso.\\n6. **Zaragoza**: Located in the northeastern region of Aragon, Zaragoza is a city with a rich history, known for its Roman ruins, Gothic cathedral, and beautiful parks.\\n7. **Granada**: A city in the Andalusian region, Granada is famous for its stunning Alhambra palace and generalife gardens, a UNESCO World Heritage Site.\\n8. **Bilbao**: A city in the Basque Country, Bilbao is known for its modern architecture, including the Guggenheim Museum, and its rich cultural heritage.\\n9. **Alicante**: A coastal city in the Valencia region, Alicante is famous for its beautiful beaches, historic castle, and lively nightlife.\\n10. **San Sebastián**: A city in the Basque Country, San Sebastián is known for its stunning beaches, gastronomic scene, and cultural events like the San Sebastián International Film Festival.\\n\\nThese are just a few of the many great cities in Spain, each with its own unique character and attractions.'}, 'model_name': 'meta-llama/Meta-Llama-3-8B-Instruct'}]
[&#123;'instruction': 'Which are the top cities in Spain?', 'generation': ' Here are some of the top cities in Spain based on various factors such as tourism, culture, history, and quality of life:\\n\\n1. Madrid: The capital and largest city in Spain, Madrid is known for its vibrant nightlife, world-class museums (such as the Prado Museum and Reina Sofia Museum), stunning parks (such as the Retiro Park), and delicious food.\\n\\n2. Barcelona: Famous for its unique architecture, Barcelona is home to several UNESCO World Heritage sites designed by Antoni Gaudí, including the Sagrada Familia and Park Güell. The city also boasts beautiful beaches, a lively arts scene, and delicious Catalan cuisine.\\n\\n3. Valencia: A coastal city located in the east of Spain, Valencia is known for its City of Arts and Sciences, a modern architectural complex that includes a planetarium, opera house, and museum of interactive science. The city is also famous for its paella, a traditional Spanish dish made with rice, vegetables, and seafood.\\n\\n4. Seville: The capital of Andalusia, Seville is famous for its flamenco dancing, stunning cathedral (the largest Gothic cathedral in the world), and the Alcázar, a beautiful palace made up of a series of rooms and courtyards.\\n\\n5. Granada: Located in the foothills of the Sierra Nevada mountains, Granada is known for its stunning Alhambra palace, a Moorish fortress that dates back to the 9th century. The city is also famous for its tapas, a traditional Spanish dish that is often served for free with drinks.\\n\\n6. Bilbao: A city in the Basque Country, Bilbao is famous for its modern architecture, including the Guggenheim Museum, a contemporary art museum designed by Frank Gehry. The city is also known for its pintxos, a type of Basque tapas that are served in bars and restaurants.\\n\\n7. Málaga: A coastal city in Andalusia, Málaga is known for its beautiful beaches, historic sites (including the Alcazaba and Gibralfaro castles), and the Picasso Museum, which is dedicated to the famous Spanish artist who was born in the city.\\n\\nThese are just a few of the many wonderful cities in Spain.', 'distilabel_metadata': &#123;'raw_output_text_generation_0': ' Here are some of the top cities in Spain based on various factors such as tourism, culture, history, and quality of life:\\n\\n1. Madrid: The capital and largest city in Spain, Madrid is known for its vibrant nightlife, world-class museums (such as the Prado Museum and Reina Sofia Museum), stunning parks (such as the Retiro Park), and delicious food.\\n\\n2. Barcelona: Famous for its unique architecture, Barcelona is home to several UNESCO World Heritage sites designed by Antoni Gaudí, including the Sagrada Familia and Park Güell. The city also boasts beautiful beaches, a lively arts scene, and delicious Catalan cuisine.\\n\\n3. Valencia: A coastal city located in the east of Spain, Valencia is known for its City of Arts and Sciences, a modern architectural complex that includes a planetarium, opera house, and museum of interactive science. The city is also famous for its paella, a traditional Spanish dish made with rice, vegetables, and seafood.\\n\\n4. Seville: The capital of Andalusia, Seville is famous for its flamenco dancing, stunning cathedral (the largest Gothic cathedral in the world), and the Alcázar, a beautiful palace made up of a series of rooms and courtyards.\\n\\n5. Granada: Located in the foothills of the Sierra Nevada mountains, Granada is known for its stunning Alhambra palace, a Moorish fortress that dates back to the 9th century. The city is also famous for its tapas, a traditional Spanish dish that is often served for free with drinks.\\n\\n6. Bilbao: A city in the Basque Country, Bilbao is famous for its modern architecture, including the Guggenheim Museum, a contemporary art museum designed by Frank Gehry. The city is also known for its pintxos, a type of Basque tapas that are served in bars and restaurants.\\n\\n7. Málaga: A coastal city in Andalusia, Málaga is known for its beautiful beaches, historic sites (including the Alcazaba and Gibralfaro castles), and the Picasso Museum, which is dedicated to the famous Spanish artist who was born in the city.\\n\\nThese are just a few of the many wonderful cities in Spain.'}, 'model_name': 'mistralai/Mixtral-8x7B-Instruct-v0.1'}]
`,ot,O,Mt,ee,ll="The task to evaluate the responses needs as input a list of generations. However, each model response was saved in the generation column of the subsets <code>text_generation_0</code> and <code>text_generation_1</code>. We will combine these two columns into a single column and the <code>default</code> subset.",rt,te,al="<li>Component: <code>GroupColumns</code></li> <li>Input columns: <code>generation</code> and <code>model_name</code>from <code>text_generation_0</code> and <code>text_generation_1</code></li> <li>Output columns: <code>generations</code> and <code>model_names</code></li>",ct,le,pt,ae,ut,se,sl='To build our preference dataset, we need to evaluate the responses generated by the models. We will use <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow"><code>meta-llama/Meta-Llama-3-70B-Instruct</code></a> for this, applying the <code>UltraFeedback</code> task that judges the responses according to different dimensions (helpfulness, honesty, instruction-following, truthfulness).',yt,ne,nl="<li>Component: <code>UltraFeedback</code> task with LLMs using <code>InferenceEndpointsLLM</code></li> <li>Input columns: <code>instruction</code>, <code>generations</code></li> <li>Output columns: <code>ratings</code>, <code>rationales</code>, <code>distilabel_metadata</code>, <code>model_name</code></li>",dt,ie,il='For your use case and to improve the results, you can use any <a href="https://distilabel.argilla.io/latest/components-gallery/llms/" rel="nofollow">other LLM of your choice</a>.',ht,oe,mt,Me,Ut,re,ol="<li>You can automatically convert it to a preference dataset with the <code>chosen</code> and <code>rejected</code> columns.<ul><li>Component: <code>FormatTextGenerationDPO</code> step</li> <li>Input columns: <code>instruction</code>, <code>generations</code>, <code>generation_models</code>, <code>ratings</code></li> <li>Output columns: <code>prompt</code>, <code>prompt_id</code>, <code>chosen</code>, <code>chosen_model</code>, <code>chosen_rating</code>, <code>rejected</code>, <code>rejected_model</code>, <code>rejected_rating</code></li></ul></li>",jt,ce,wt,pe,Ml="<li>Or you can use Argilla to manually label the data and convert it to a preference dataset.<ul><li>Component: <code>PreferenceToArgilla</code> step</li> <li>Input columns: <code>instruction</code>, <code>generations</code>, <code>generation_models</code>, <code>ratings</code></li> <li>Output columns: <code>instruction</code>, <code>generations</code>, <code>generation_models</code>, <code>ratings</code></li></ul></li>",Tt,ue,Jt,ye,ft,de,rl="Below, you can see the full pipeline definition:",Ct,he,gt,me,cl="Let’s now run the pipeline and generate the preference dataset.",It,Ue,bt,je,pl='Let’s check the preference dataset! If you have loaded the data to Argilla, you can <a href="https://docs.argilla.io/latest/how_to_guides/annotate/" rel="nofollow">start annotating in the Argilla UI</a>.',At,we,ul='You can push the dataset to the Hub for sharing with the community and <a href="https://huggingface.co/docs/hub/datasets-viewer-embed" rel="nofollow">embed it to explore the data</a>.',Gt,Te,kt,j,yl,Bt,Je,$t,fe,dl="In this tutorial, we showcased the detailed steps to build a pipeline for generating a preference dataset using distilabel. You can customize this pipeline for your own use cases and share your datasets with the community through the Hugging Face Hub, or use them to train a model for DPO or ORPO.",Wt,Ce,hl="We used a dataset containing prompts to generate responses using two different models through the serverless Hugging Face Inference API. Next, we evaluated the responses using a third model, following the UltraFeedback standards. Finally, we converted the data to a preference dataset and used Argilla for further curation.",vt,ge,Zt,be,Et;return J=new gl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/generate_preference_dataset_distilabel.ipynb"}]}}),f=new m({props:{title:"Generate a Preference Dataset with distilabel",local:"generate-a-preference-dataset-with-distilabel",headingTag:"h1"}}),G=new m({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),k=new m({props:{title:"Install the dependencies",local:"install-the-dependencies",headingTag:"h3"}}),$=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJkaXN0aWxhYmVsJTVCaGYtaW5mZXJlbmNlLWVuZHBvaW50cyU1RCUyMg==",highlighted:'!pip install <span class="hljs-string">&quot;distilabel[hf-inference-endpoints]&quot;</span>',wrap:!1}}),W=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJ0cmFuc2Zvcm1lcnN+JTNENC4wJTIyJTIwJTIydG9yY2h+JTNEMi4wJTIy",highlighted:'!pip install <span class="hljs-string">&quot;transformers~=4.0&quot;</span> <span class="hljs-string">&quot;torch~=2.0&quot;</span>',wrap:!1}}),Z=new h({props:{code:"ZnJvbSUyMGRpc3RpbGFiZWwubGxtcyUyMGltcG9ydCUyMEluZmVyZW5jZUVuZHBvaW50c0xMTSUwQWZyb20lMjBkaXN0aWxhYmVsLnBpcGVsaW5lJTIwaW1wb3J0JTIwUGlwZWxpbmUlMEFmcm9tJTIwZGlzdGlsYWJlbC5zdGVwcyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBMb2FkRGF0YUZyb21IdWIlMkMlMEElMjAlMjAlMjAlMjBHcm91cENvbHVtbnMlMkMlMEElMjAlMjAlMjAlMjBGb3JtYXRUZXh0R2VuZXJhdGlvbkRQTyUyQyUwQSUyMCUyMCUyMCUyMFByZWZlcmVuY2VUb0FyZ2lsbGElMkMlMEEpJTBBZnJvbSUyMGRpc3RpbGFiZWwuc3RlcHMudGFza3MlMjBpbXBvcnQlMjBUZXh0R2VuZXJhdGlvbiUyQyUyMFVsdHJhRmVlZGJhY2s=",highlighted:`<span class="hljs-keyword">from</span> distilabel.llms <span class="hljs-keyword">import</span> InferenceEndpointsLLM
<span class="hljs-keyword">from</span> distilabel.pipeline <span class="hljs-keyword">import</span> Pipeline
<span class="hljs-keyword">from</span> distilabel.steps <span class="hljs-keyword">import</span> (
    LoadDataFromHub,
    GroupColumns,
    FormatTextGenerationDPO,
    PreferenceToArgilla,
)
<span class="hljs-keyword">from</span> distilabel.steps.tasks <span class="hljs-keyword">import</span> TextGeneration, UltraFeedback`,wrap:!1}}),S=new h({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbG9naW4lMEElMEFsb2dpbih0b2tlbiUzRG9zLmdldGVudiglMjJIRl9UT0tFTiUyMiklMkMlMjBhZGRfdG9fZ2l0X2NyZWRlbnRpYWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

login(token=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>), add_to_git_credential=<span class="hljs-literal">True</span>)`,wrap:!1}}),_=new m({props:{title:"(optional) Deploy Argilla",local:"optional-deploy-argilla",headingTag:"h3"}}),R=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJkaXN0aWxhYmVsJTVCYXJnaWxsYSUyQyUyMGhmLWluZmVyZW5jZS1lbmRwb2ludHMlNUQlMjI=",highlighted:'!pip install <span class="hljs-string">&quot;distilabel[argilla, hf-inference-endpoints]&quot;</span>',wrap:!1}}),V=new m({props:{title:"Define the pipeline",local:"define-the-pipeline",headingTag:"h2"}}),L=new m({props:{title:"Load the dataset",local:"load-the-dataset",headingTag:"h3"}}),N=new h({props:{code:"bG9hZF9kYXRhc2V0JTIwJTNEJTIwTG9hZERhdGFGcm9tSHViKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJhcmdpbGxhJTJGMTBLcHJvbXB0cy1taW5pJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2V4YW1wbGVzJTNEMSUyQyUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lJTNEUGlwZWxpbmUobmFtZSUzRCUyMnNob3djYXNlLXBpcGVsaW5lJTIyKSUyQyUwQSklMEFsb2FkX2RhdGFzZXQubG9hZCgpJTBBbmV4dChsb2FkX2RhdGFzZXQucHJvY2VzcygpKQ==",highlighted:`load_dataset = LoadDataFromHub(
    repo_id=<span class="hljs-string">&quot;argilla/10Kprompts-mini&quot;</span>,
    num_examples=<span class="hljs-number">1</span>,
    pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
)
load_dataset.load()
<span class="hljs-built_in">next</span>(load_dataset.process())`,wrap:!1}}),H=new m({props:{title:"Generate responses",local:"generate-responses",headingTag:"h3"}}),D=new h({props:{code:"Z2VuZXJhdGVfcmVzcG9uc2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwVGV4dEdlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGxtJTNESW5mZXJlbmNlRW5kcG9pbnRzTExNKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX2lkJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRva2VuaXplcl9pZCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnZW5lcmF0aW9uX2t3YXJncyUzRCU3QiUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwNTEyJTJDJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZWxpbmUlM0RQaXBlbGluZShuYW1lJTNEJTIyc2hvd2Nhc2UtcGlwZWxpbmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMFRleHRHZW5lcmF0aW9uKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxsbSUzREluZmVyZW5jZUVuZHBvaW50c0xMTSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMm1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW5pemVyX2lkJTNEJTIybWlzdHJhbGFpJTJGTWl4dHJhbC04eDdCLUluc3RydWN0LXYwLjElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnZW5lcmF0aW9uX2t3YXJncyUzRCU3QiUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwNTEyJTJDJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZWxpbmUlM0RQaXBlbGluZShuYW1lJTNEJTIyc2hvd2Nhc2UtcGlwZWxpbmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSU1RCUwQWZvciUyMHRhc2slMjBpbiUyMGdlbmVyYXRlX3Jlc3BvbnNlcyUzQSUwQSUyMCUyMCUyMCUyMHRhc2subG9hZCgpJTBBJTIwJTIwJTIwJTIwcHJpbnQobmV4dCh0YXNrLnByb2Nlc3MoJTVCJTdCJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJXaGljaCUyMGFyZSUyMHRoZSUyMHRvcCUyMGNpdGllcyUyMGluJTIwU3BhaW4lM0YlMjIlN0QlNUQpKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generate_responses = [
<span class="hljs-meta">... </span>    TextGeneration(
<span class="hljs-meta">... </span>        llm=InferenceEndpointsLLM(
<span class="hljs-meta">... </span>            model_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>            tokenizer_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>            generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
<span class="hljs-meta">... </span>        ),
<span class="hljs-meta">... </span>        pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>    TextGeneration(
<span class="hljs-meta">... </span>        llm=InferenceEndpointsLLM(
<span class="hljs-meta">... </span>            model_id=<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>,
<span class="hljs-meta">... </span>            tokenizer_id=<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>,
<span class="hljs-meta">... </span>            generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
<span class="hljs-meta">... </span>        ),
<span class="hljs-meta">... </span>        pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> task <span class="hljs-keyword">in</span> generate_responses:
<span class="hljs-meta">... </span>    task.load()
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">next</span>(task.process([{<span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;Which are the top cities in Spain?&quot;</span>}])))`,wrap:!1}}),O=new m({props:{title:"Group the responses",local:"group-the-responses",headingTag:"h3"}}),le=new h({props:{code:"Z3JvdXBfcmVzcG9uc2VzJTIwJTNEJTIwR3JvdXBDb2x1bW5zKCUwQSUyMCUyMCUyMCUyMGNvbHVtbnMlM0QlNUIlMjJnZW5lcmF0aW9uJTIyJTJDJTIwJTIybW9kZWxfbmFtZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dF9jb2x1bW5zJTNEJTVCJTIyZ2VuZXJhdGlvbnMlMjIlMkMlMjAlMjJtb2RlbF9uYW1lcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lJTNEUGlwZWxpbmUobmFtZSUzRCUyMnNob3djYXNlLXBpcGVsaW5lJTIyKSUyQyUwQSklMEFuZXh0KCUwQSUyMCUyMCUyMCUyMGdyb3VwX3Jlc3BvbnNlcy5wcm9jZXNzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmdlbmVyYXRpb24lMjIlM0ElMjAlMjJNYWRyaWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtb2RlbF9uYW1lJTIyJTNBJTIwJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmdlbmVyYXRpb24lMjIlM0ElMjAlMjJCYXJjZWxvbmElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtb2RlbF9uYW1lJTIyJTNBJTIwJTIybWlzdHJhbGFpJTJGTWl4dHJhbC04eDdCLUluc3RydWN0LXYwLjElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjApJTBBKQ==",highlighted:`group_responses = GroupColumns(
    columns=[<span class="hljs-string">&quot;generation&quot;</span>, <span class="hljs-string">&quot;model_name&quot;</span>],
    output_columns=[<span class="hljs-string">&quot;generations&quot;</span>, <span class="hljs-string">&quot;model_names&quot;</span>],
    pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
)
<span class="hljs-built_in">next</span>(
    group_responses.process(
        [
            {
                <span class="hljs-string">&quot;generation&quot;</span>: <span class="hljs-string">&quot;Madrid&quot;</span>,
                <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
            },
        ],
        [
            {
                <span class="hljs-string">&quot;generation&quot;</span>: <span class="hljs-string">&quot;Barcelona&quot;</span>,
                <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>,
            }
        ],
    )
)`,wrap:!1}}),ae=new m({props:{title:"Evaluate the responses",local:"evaluate-the-responses",headingTag:"h3"}}),oe=new h({props:{code:"ZXZhbHVhdGVfcmVzcG9uc2VzJTIwJTNEJTIwVWx0cmFGZWVkYmFjayglMEElMjAlMjAlMjAlMjBhc3BlY3QlM0QlMjJvdmVyYWxsLXJhdGluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMGxsbSUzREluZmVyZW5jZUVuZHBvaW50c0xMTSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtNzBCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW5pemVyX2lkJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnZW5lcmF0aW9uX2t3YXJncyUzRCU3QiUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwNTEyJTJDJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjclN0QlMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmUlM0RQaXBlbGluZShuYW1lJTNEJTIyc2hvd2Nhc2UtcGlwZWxpbmUlMjIpJTJDJTBBKSUwQWV2YWx1YXRlX3Jlc3BvbnNlcy5sb2FkKCklMEFuZXh0KCUwQSUyMCUyMCUyMCUyMGV2YWx1YXRlX3Jlc3BvbnNlcy5wcm9jZXNzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmluc3RydWN0aW9uJTIyJTNBJTIwJTIyV2hhdCdzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwU3BhaW4lM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJnZW5lcmF0aW9ucyUyMiUzQSUyMCU1QiUyMk1hZHJpZCUyMiUyQyUyMCUyMkJhcmNlbG9uYSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCklMEEp",highlighted:`evaluate_responses = UltraFeedback(
    aspect=<span class="hljs-string">&quot;overall-rating&quot;</span>,
    llm=InferenceEndpointsLLM(
        model_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
        tokenizer_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
        generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
    ),
    pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
)
evaluate_responses.load()
<span class="hljs-built_in">next</span>(
    evaluate_responses.process(
        [
            {
                <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the capital of Spain?&quot;</span>,
                <span class="hljs-string">&quot;generations&quot;</span>: [<span class="hljs-string">&quot;Madrid&quot;</span>, <span class="hljs-string">&quot;Barcelona&quot;</span>],
            }
        ]
    )
)`,wrap:!1}}),Me=new m({props:{title:"Convert to a preference dataset",local:"convert-to-a-preference-dataset",headingTag:"h3"}}),ce=new h({props:{code:"Zm9ybWF0X2RwbyUyMCUzRCUyMEZvcm1hdFRleHRHZW5lcmF0aW9uRFBPKHBpcGVsaW5lJTNEUGlwZWxpbmUobmFtZSUzRCUyMnNob3djYXNlLXBpcGVsaW5lJTIyKSklMEFmb3JtYXRfZHBvLmxvYWQoKSUwQW5leHQoJTBBJTIwJTIwJTIwJTIwZm9ybWF0X2Rwby5wcm9jZXNzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmluc3RydWN0aW9uJTIyJTNBJTIwJTIyV2hhdCdzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwU3BhaW4lM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJnZW5lcmF0aW9ucyUyMiUzQSUyMCU1QiUyMk1hZHJpZCUyMiUyQyUyMCUyMkJhcmNlbG9uYSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmdlbmVyYXRpb25fbW9kZWxzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTWV0YS1MbGFtYS0zLThCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTWl4dHJhbC04eDdCLUluc3RydWN0LXYwLjElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyYXRpbmdzJTIyJTNBJTIwJTVCNSUyQyUyMDElNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjApJTBBKQ==",highlighted:`format_dpo = FormatTextGenerationDPO(pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>))
format_dpo.load()
<span class="hljs-built_in">next</span>(
    format_dpo.process(
        [
            {
                <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the capital of Spain?&quot;</span>,
                <span class="hljs-string">&quot;generations&quot;</span>: [<span class="hljs-string">&quot;Madrid&quot;</span>, <span class="hljs-string">&quot;Barcelona&quot;</span>],
                <span class="hljs-string">&quot;generation_models&quot;</span>: [
                    <span class="hljs-string">&quot;Meta-Llama-3-8B-Instruct&quot;</span>,
                    <span class="hljs-string">&quot;Mixtral-8x7B-Instruct-v0.1&quot;</span>,
                ],
                <span class="hljs-string">&quot;ratings&quot;</span>: [<span class="hljs-number">5</span>, <span class="hljs-number">1</span>],
            }
        ]
    )
)`,wrap:!1}}),ue=new h({props:{code:"dG9fYXJnaWxsYSUyMCUzRCUyMFByZWZlcmVuY2VUb0FyZ2lsbGEoJTBBJTIwJTIwJTIwJTIwZGF0YXNldF9uYW1lJTNEJTIycHJlZmVyZW5jZS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF93b3Jrc3BhY2UlM0QlMjJhcmdpbGxhJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGJTVCeW91ci1vd25lci1uYW1lJTVELSU1QnlvdXItc3BhY2UtbmFtZSU1RC5oZi5zcGFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjIlNUJ5b3VyLWFwaS1rZXklNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fZ2VuZXJhdGlvbnMlM0QyJTJDJTBBKQ==",highlighted:`to_argilla = PreferenceToArgilla(
    dataset_name=<span class="hljs-string">&quot;preference-dataset&quot;</span>,
    dataset_workspace=<span class="hljs-string">&quot;argilla&quot;</span>,
    api_url=<span class="hljs-string">&quot;https://[your-owner-name]-[your-space-name].hf.space&quot;</span>,
    api_key=<span class="hljs-string">&quot;[your-api-key]&quot;</span>,
    num_generations=<span class="hljs-number">2</span>,
)`,wrap:!1}}),ye=new m({props:{title:"Run the pipeline",local:"run-the-pipeline",headingTag:"h2"}}),he=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">with</span> Pipeline(name=<span class="hljs-string">&quot;generate-dataset&quot;</span>) <span class="hljs-keyword">as</span> pipeline:

    load_dataset = LoadDataFromHub(repo_id=<span class="hljs-string">&quot;argilla/10Kprompts-mini&quot;</span>)

    generate_responses = [
        TextGeneration(
            llm=InferenceEndpointsLLM(
                model_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
                tokenizer_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
                generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
            )
        ),
        TextGeneration(
            llm=InferenceEndpointsLLM(
                model_id=<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>,
                tokenizer_id=<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>,
                generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
            )
        ),
    ]

    group_responses = GroupColumns(
        columns=[<span class="hljs-string">&quot;generation&quot;</span>, <span class="hljs-string">&quot;model_name&quot;</span>],
        output_columns=[<span class="hljs-string">&quot;generations&quot;</span>, <span class="hljs-string">&quot;model_names&quot;</span>],
    )

    evaluate_responses = UltraFeedback(
        aspect=<span class="hljs-string">&quot;overall-rating&quot;</span>,
        llm=InferenceEndpointsLLM(
            model_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
            tokenizer_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
            generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
        ),
    )

    format_dpo = FormatTextGenerationDPO()

    to_argilla = PreferenceToArgilla(
        dataset_name=<span class="hljs-string">&quot;preference-dataset&quot;</span>,
        dataset_workspace=<span class="hljs-string">&quot;argilla&quot;</span>,
        api_url=<span class="hljs-string">&quot;https://[your-owner-name]-[your-space-name].hf.space&quot;</span>,
        api_key=<span class="hljs-string">&quot;[your-api-key]&quot;</span>,
        num_generations=<span class="hljs-number">2</span>,
    )

    <span class="hljs-keyword">for</span> task <span class="hljs-keyword">in</span> generate_responses:
        load_dataset.connect(task)
        task.connect(group_responses)
    group_responses.connect(evaluate_responses)
    evaluate_responses.connect(format_dpo, to_argilla)`,wrap:!1}}),Ue=new h({props:{code:"ZGlzdGlzZXQlMjAlM0QlMjBwaXBlbGluZS5ydW4oKQ==",highlighted:"distiset = pipeline.run()",wrap:!1}}),Te=new h({props:{code:"ZGlzdGlzZXQucHVzaF90b19odWIoJTIyJTVCeW91ci1vd25lci1uYW1lJTVEJTJGZXhhbXBsZS1wcmVmZXJlbmNlLWRhdGFzZXQlMjIp",highlighted:'distiset.push_to_hub(<span class="hljs-string">&quot;[your-owner-name]/example-preference-dataset&quot;</span>)',wrap:!1}}),Je=new m({props:{title:"Conclusions",local:"conclusions",headingTag:"h2"}}),ge=new Il({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/generate_preference_dataset_distilabel.md"}}),{c(){T=i("meta"),Ae=s(),Ie=i("p"),Ge=s(),r(J.$$.fragment),ke=s(),r(f.$$.fragment),Be=s(),C=i("p"),C.innerHTML=qt,$e=s(),g=i("ul"),g.innerHTML=xt,We=s(),I=i("p"),I.innerHTML=Rt,ve=s(),b=i("p"),b.innerHTML=Vt,Ze=s(),A=i("p"),A.innerHTML=Qt,Ee=s(),r(G.$$.fragment),Se=s(),r(k.$$.fragment),_e=s(),B=i("p"),B.innerHTML=Lt,qe=s(),r($.$$.fragment),xe=s(),r(W.$$.fragment),Re=s(),v=i("p"),v.textContent=Ft,Ve=s(),r(Z.$$.fragment),Qe=s(),E=i("p"),E.innerHTML=Xt,Le=s(),r(S.$$.fragment),Fe=s(),r(_.$$.fragment),Xe=s(),q=i("p"),q.innerHTML=Nt,Ne=s(),x=i("p"),x.textContent=Ht,He=s(),r(R.$$.fragment),Ye=s(),r(V.$$.fragment),ze=s(),Q=i("p"),Q.innerHTML=Yt,Pe=s(),r(L.$$.fragment),De=s(),F=i("p"),F.innerHTML=zt,Ke=s(),U=i("iframe"),Oe=s(),X=i("ul"),X.innerHTML=Dt,et=s(),r(N.$$.fragment),tt=s(),r(H.$$.fragment),lt=s(),Y=i("p"),Y.innerHTML=Kt,at=s(),z=i("ul"),z.innerHTML=Ot,st=s(),P=i("p"),P.innerHTML=el,nt=s(),r(D.$$.fragment),it=s(),K=i("pre"),K.textContent=tl,ot=s(),r(O.$$.fragment),Mt=s(),ee=i("p"),ee.innerHTML=ll,rt=s(),te=i("ul"),te.innerHTML=al,ct=s(),r(le.$$.fragment),pt=s(),r(ae.$$.fragment),ut=s(),se=i("p"),se.innerHTML=sl,yt=s(),ne=i("ul"),ne.innerHTML=nl,dt=s(),ie=i("p"),ie.innerHTML=il,ht=s(),r(oe.$$.fragment),mt=s(),r(Me.$$.fragment),Ut=s(),re=i("ul"),re.innerHTML=ol,jt=s(),r(ce.$$.fragment),wt=s(),pe=i("ul"),pe.innerHTML=Ml,Tt=s(),r(ue.$$.fragment),Jt=s(),r(ye.$$.fragment),ft=s(),de=i("p"),de.textContent=rl,Ct=s(),r(he.$$.fragment),gt=s(),me=i("p"),me.textContent=cl,It=s(),r(Ue.$$.fragment),bt=s(),je=i("p"),je.innerHTML=pl,At=s(),we=i("p"),we.innerHTML=ul,Gt=s(),r(Te.$$.fragment),kt=s(),j=i("iframe"),Bt=s(),r(Je.$$.fragment),$t=s(),fe=i("p"),fe.textContent=dl,Wt=s(),Ce=i("p"),Ce.textContent=hl,vt=s(),r(ge.$$.fragment),Zt=s(),be=i("p"),this.h()},l(e){const t=fl("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(l),Ae=n(e),Ie=o(e,"P",{}),St(Ie).forEach(l),Ge=n(e),c(J.$$.fragment,e),ke=n(e),c(f.$$.fragment,e),Be=n(e),C=o(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-gisfdz"&&(C.innerHTML=qt),$e=n(e),g=o(e,"UL",{"data-svelte-h":!0}),M(g)!=="svelte-1125nkr"&&(g.innerHTML=xt),We=n(e),I=o(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-14ghd0x"&&(I.innerHTML=Rt),ve=n(e),b=o(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1l44s89"&&(b.innerHTML=Vt),Ze=n(e),A=o(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1tx7tfk"&&(A.innerHTML=Qt),Ee=n(e),c(G.$$.fragment,e),Se=n(e),c(k.$$.fragment,e),_e=n(e),B=o(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-48yyh0"&&(B.innerHTML=Lt),qe=n(e),c($.$$.fragment,e),xe=n(e),c(W.$$.fragment,e),Re=n(e),v=o(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1efpmun"&&(v.textContent=Ft),Ve=n(e),c(Z.$$.fragment,e),Qe=n(e),E=o(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-cc667m"&&(E.innerHTML=Xt),Le=n(e),c(S.$$.fragment,e),Fe=n(e),c(_.$$.fragment,e),Xe=n(e),q=o(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-104zazh"&&(q.innerHTML=Nt),Ne=n(e),x=o(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-nd7qbb"&&(x.textContent=Ht),He=n(e),c(R.$$.fragment,e),Ye=n(e),c(V.$$.fragment,e),ze=n(e),Q=o(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-phdqc7"&&(Q.innerHTML=Yt),Pe=n(e),c(L.$$.fragment,e),De=n(e),F=o(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-mi4gjp"&&(F.innerHTML=zt),Ke=n(e),U=o(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),St(U).forEach(l),Oe=n(e),X=o(e,"UL",{"data-svelte-h":!0}),M(X)!=="svelte-1orqye3"&&(X.innerHTML=Dt),et=n(e),c(N.$$.fragment,e),tt=n(e),c(H.$$.fragment,e),lt=n(e),Y=o(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1s34ial"&&(Y.innerHTML=Kt),at=n(e),z=o(e,"UL",{"data-svelte-h":!0}),M(z)!=="svelte-1u4djwu"&&(z.innerHTML=Ot),st=n(e),P=o(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-wb9t0n"&&(P.innerHTML=el),nt=n(e),c(D.$$.fragment,e),it=n(e),K=o(e,"PRE",{"data-svelte-h":!0}),M(K)!=="svelte-1yyf24g"&&(K.textContent=tl),ot=n(e),c(O.$$.fragment,e),Mt=n(e),ee=o(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-u7i2or"&&(ee.innerHTML=ll),rt=n(e),te=o(e,"UL",{"data-svelte-h":!0}),M(te)!=="svelte-1l4lk1a"&&(te.innerHTML=al),ct=n(e),c(le.$$.fragment,e),pt=n(e),c(ae.$$.fragment,e),ut=n(e),se=o(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-1l4awig"&&(se.innerHTML=sl),yt=n(e),ne=o(e,"UL",{"data-svelte-h":!0}),M(ne)!=="svelte-1lich0g"&&(ne.innerHTML=nl),dt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-wb9t0n"&&(ie.innerHTML=il),ht=n(e),c(oe.$$.fragment,e),mt=n(e),c(Me.$$.fragment,e),Ut=n(e),re=o(e,"UL",{"data-svelte-h":!0}),M(re)!=="svelte-1ni35zr"&&(re.innerHTML=ol),jt=n(e),c(ce.$$.fragment,e),wt=n(e),pe=o(e,"UL",{"data-svelte-h":!0}),M(pe)!=="svelte-x0h38s"&&(pe.innerHTML=Ml),Tt=n(e),c(ue.$$.fragment,e),Jt=n(e),c(ye.$$.fragment,e),ft=n(e),de=o(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-z5tzhe"&&(de.textContent=rl),Ct=n(e),c(he.$$.fragment,e),gt=n(e),me=o(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-13atkrj"&&(me.textContent=cl),It=n(e),c(Ue.$$.fragment,e),bt=n(e),je=o(e,"P",{"data-svelte-h":!0}),M(je)!=="svelte-17uzlyb"&&(je.innerHTML=pl),At=n(e),we=o(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-1cen2j5"&&(we.innerHTML=ul),Gt=n(e),c(Te.$$.fragment,e),kt=n(e),j=o(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),St(j).forEach(l),Bt=n(e),c(Je.$$.fragment,e),$t=n(e),fe=o(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-1pikznd"&&(fe.textContent=dl),Wt=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-spvgbj"&&(Ce.textContent=hl),vt=n(e),c(ge.$$.fragment,e),Zt=n(e),be=o(e,"P",{}),St(be).forEach(l),this.h()},h(){w(T,"name","hf:doc:metadata"),w(T,"content",Al),ml(U.src,Pt="https://huggingface.co/datasets/argilla/10Kprompts-mini/embed/viewer/default/train")||w(U,"src",Pt),w(U,"frameborder","0"),w(U,"width","100%"),w(U,"height","560px"),ml(j.src,yl="https://huggingface.co/datasets/distilabel-internal-testing/example-generate-preference-dataset/embed/viewer/format_text_generation_d_p_o_0/train")||w(j,"src",yl),w(j,"frameborder","0"),w(j,"width","100%"),w(j,"height","560px")},m(e,t){Cl(document.head,T),a(e,Ae,t),a(e,Ie,t),a(e,Ge,t),p(J,e,t),a(e,ke,t),p(f,e,t),a(e,Be,t),a(e,C,t),a(e,$e,t),a(e,g,t),a(e,We,t),a(e,I,t),a(e,ve,t),a(e,b,t),a(e,Ze,t),a(e,A,t),a(e,Ee,t),p(G,e,t),a(e,Se,t),p(k,e,t),a(e,_e,t),a(e,B,t),a(e,qe,t),p($,e,t),a(e,xe,t),p(W,e,t),a(e,Re,t),a(e,v,t),a(e,Ve,t),p(Z,e,t),a(e,Qe,t),a(e,E,t),a(e,Le,t),p(S,e,t),a(e,Fe,t),p(_,e,t),a(e,Xe,t),a(e,q,t),a(e,Ne,t),a(e,x,t),a(e,He,t),p(R,e,t),a(e,Ye,t),p(V,e,t),a(e,ze,t),a(e,Q,t),a(e,Pe,t),p(L,e,t),a(e,De,t),a(e,F,t),a(e,Ke,t),a(e,U,t),a(e,Oe,t),a(e,X,t),a(e,et,t),p(N,e,t),a(e,tt,t),p(H,e,t),a(e,lt,t),a(e,Y,t),a(e,at,t),a(e,z,t),a(e,st,t),a(e,P,t),a(e,nt,t),p(D,e,t),a(e,it,t),a(e,K,t),a(e,ot,t),p(O,e,t),a(e,Mt,t),a(e,ee,t),a(e,rt,t),a(e,te,t),a(e,ct,t),p(le,e,t),a(e,pt,t),p(ae,e,t),a(e,ut,t),a(e,se,t),a(e,yt,t),a(e,ne,t),a(e,dt,t),a(e,ie,t),a(e,ht,t),p(oe,e,t),a(e,mt,t),p(Me,e,t),a(e,Ut,t),a(e,re,t),a(e,jt,t),p(ce,e,t),a(e,wt,t),a(e,pe,t),a(e,Tt,t),p(ue,e,t),a(e,Jt,t),p(ye,e,t),a(e,ft,t),a(e,de,t),a(e,Ct,t),p(he,e,t),a(e,gt,t),a(e,me,t),a(e,It,t),p(Ue,e,t),a(e,bt,t),a(e,je,t),a(e,At,t),a(e,we,t),a(e,Gt,t),p(Te,e,t),a(e,kt,t),a(e,j,t),a(e,Bt,t),p(Je,e,t),a(e,$t,t),a(e,fe,t),a(e,Wt,t),a(e,Ce,t),a(e,vt,t),p(ge,e,t),a(e,Zt,t),a(e,be,t),Et=!0},p:jl,i(e){Et||(u(J.$$.fragment,e),u(f.$$.fragment,e),u(G.$$.fragment,e),u(k.$$.fragment,e),u($.$$.fragment,e),u(W.$$.fragment,e),u(Z.$$.fragment,e),u(S.$$.fragment,e),u(_.$$.fragment,e),u(R.$$.fragment,e),u(V.$$.fragment,e),u(L.$$.fragment,e),u(N.$$.fragment,e),u(H.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(Me.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(ye.$$.fragment,e),u(he.$$.fragment,e),u(Ue.$$.fragment,e),u(Te.$$.fragment,e),u(Je.$$.fragment,e),u(ge.$$.fragment,e),Et=!0)},o(e){y(J.$$.fragment,e),y(f.$$.fragment,e),y(G.$$.fragment,e),y(k.$$.fragment,e),y($.$$.fragment,e),y(W.$$.fragment,e),y(Z.$$.fragment,e),y(S.$$.fragment,e),y(_.$$.fragment,e),y(R.$$.fragment,e),y(V.$$.fragment,e),y(L.$$.fragment,e),y(N.$$.fragment,e),y(H.$$.fragment,e),y(D.$$.fragment,e),y(O.$$.fragment,e),y(le.$$.fragment,e),y(ae.$$.fragment,e),y(oe.$$.fragment,e),y(Me.$$.fragment,e),y(ce.$$.fragment,e),y(ue.$$.fragment,e),y(ye.$$.fragment,e),y(he.$$.fragment,e),y(Ue.$$.fragment,e),y(Te.$$.fragment,e),y(Je.$$.fragment,e),y(ge.$$.fragment,e),Et=!1},d(e){e&&(l(Ae),l(Ie),l(Ge),l(ke),l(Be),l(C),l($e),l(g),l(We),l(I),l(ve),l(b),l(Ze),l(A),l(Ee),l(Se),l(_e),l(B),l(qe),l(xe),l(Re),l(v),l(Ve),l(Qe),l(E),l(Le),l(Fe),l(Xe),l(q),l(Ne),l(x),l(He),l(Ye),l(ze),l(Q),l(Pe),l(De),l(F),l(Ke),l(U),l(Oe),l(X),l(et),l(tt),l(lt),l(Y),l(at),l(z),l(st),l(P),l(nt),l(it),l(K),l(ot),l(Mt),l(ee),l(rt),l(te),l(ct),l(pt),l(ut),l(se),l(yt),l(ne),l(dt),l(ie),l(ht),l(mt),l(Ut),l(re),l(jt),l(wt),l(pe),l(Tt),l(Jt),l(ft),l(de),l(Ct),l(gt),l(me),l(It),l(bt),l(je),l(At),l(we),l(Gt),l(kt),l(j),l(Bt),l($t),l(fe),l(Wt),l(Ce),l(vt),l(Zt),l(be)),l(T),d(J,e),d(f,e),d(G,e),d(k,e),d($,e),d(W,e),d(Z,e),d(S,e),d(_,e),d(R,e),d(V,e),d(L,e),d(N,e),d(H,e),d(D,e),d(O,e),d(le,e),d(ae,e),d(oe,e),d(Me,e),d(ce,e),d(ue,e),d(ye,e),d(he,e),d(Ue,e),d(Te,e),d(Je,e),d(ge,e)}}}const Al='{"title":"Generate a Preference Dataset with distilabel","local":"generate-a-preference-dataset-with-distilabel","sections":[{"title":"Getting started","local":"getting-started","sections":[{"title":"Install the dependencies","local":"install-the-dependencies","sections":[],"depth":3},{"title":"(optional) Deploy Argilla","local":"optional-deploy-argilla","sections":[],"depth":3}],"depth":2},{"title":"Define the pipeline","local":"define-the-pipeline","sections":[{"title":"Load the dataset","local":"load-the-dataset","sections":[],"depth":3},{"title":"Generate responses","local":"generate-responses","sections":[],"depth":3},{"title":"Group the responses","local":"group-the-responses","sections":[],"depth":3},{"title":"Evaluate the responses","local":"evaluate-the-responses","sections":[],"depth":3},{"title":"Convert to a preference dataset","local":"convert-to-a-preference-dataset","sections":[],"depth":3}],"depth":2},{"title":"Run the pipeline","local":"run-the-pipeline","sections":[],"depth":2},{"title":"Conclusions","local":"conclusions","sections":[],"depth":2}],"depth":1}';function Gl(_t){return wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vl extends Tl{constructor(T){super(),Jl(this,T,Gl,bl,Ul,{})}}export{vl as component};
