import{s as Fe,n as Se,o as Qe}from"../chunks/scheduler.65852ee5.js";import{S as He,i as ze,g as c,s as a,r as i,A as Le,h as m,f as s,c as n,j as qe,u as M,x as T,k as ve,y as De,a as t,v as d,d as J,t as o,w as p}from"../chunks/index.65a1b999.js";import{D as Ke,C as b}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as u,E as Pe}from"../chunks/getInferenceSnippets.56942ade.js";function Oe(Be){let w,D,z,K,r,P,j,O,h,_e='Datasets on the Hugging Face Hub rely on parquet files. We can <a href="https://huggingface.co/docs/hub/en/datasets-duckdb" rel="nofollow">interact with these files using DuckDB</a> as a fast in-memory database system. One of DuckDB’s features is <a href="https://duckdb.org/docs/extensions/vss.html" rel="nofollow">vector similarity search</a> which can be used with or without an index.',ee,y,le,I,se,f,te,U,ke="First, we need to create embeddings for the dataset to search over. We will use the <code>sentence-transformers</code> library to create embeddings for the dataset.",ae,g,ne,Z,Ce='Now, let’s load the <a href="https://huggingface.co/datasets/ai-blueprint/fineweb-bbc-news" rel="nofollow">ai-blueprint/fineweb-bbc-news</a> dataset from the Hub.',ie,W,Me,A,$e="We can now create embeddings for the dataset. Normally, we might want to chunk our data into smaller batches to avoid losing precision, but for this example, we will just create embeddings for the full text of the dataset.",de,B,Je,_,Ee="We can now upload our dataset with embeddings back to the Hub.",oe,k,pe,C,ce,$,Ve="We can now perform vector search on the dataset using <code>duckdb</code>. When doing so, we can either use an index or not. Searching <strong>without</strong> an index is slower but more precise, whereas searching <strong>with</strong> an index is faster but less precise.",me,E,Te,V,Ge="To search without an index, we can use the <code>duckdb</code> library to connect to the dataset and perform a vector search. This is a slow operation, but normally works quick enough for small datasets up to let’s say 100k rows. Meaning querying our dataset will be somewhat slower.",we,G,be,R,ue,N,Re="This approach creates a local copy of the dataset and uses this to create an index. This has some minor overhead but it will significantly speed up the search once you’ve created it.",re,Y,je,X,Ne="Now we can perform a vector search with the index, which return the results instantly.",he,x,ye,q,Ye="The query reduces from 30 seconds to sub-second response times and does not require you to deploy a heavy-weight vector search engine, while storage is handled by the Hub.",Ie,v,fe,F,Xe="We have seen how to perform vector search on the Hub using <code>duckdb</code>. For small datasets &lt;100k rows, we can perform vector search without an index using the Hub as a vector search backend, but for larger datasets, we should create an index with the <code>vss</code> extension while doing local search and using the Hub as a storage backend.",Ue,S,ge,Q,xe='<li><a href="https://huggingface.co/docs/hub/en/datasets-duckdb" rel="nofollow">Vector Search on Hugging Face</a></li> <li><a href="https://duckdb.org/docs/extensions/vss.html" rel="nofollow">Vector Search Indexing with DuckDB</a></li>',Ze,H,We,L,Ae;return r=new Ke({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/vector_search_with_hub_as_backend.ipynb"}]}}),j=new u({props:{title:"Vector Search on Hugging Face with the Hub as Backend",local:"vector-search-on-hugging-face-with-the-hub-as-backend",headingTag:"h1"}}),y=new u({props:{title:"Install dependencies",local:"install-dependencies",headingTag:"h2"}}),I=new b({props:{code:"IXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyUyMGR1Y2tkYiUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMG1vZGVsMnZlYyUyMC1x",highlighted:"!pip install datasets duckdb sentence-transformers model2vec -q",wrap:!1}}),f=new u({props:{title:"Create embeddings for the dataset",local:"create-embeddings-for-the-dataset",headingTag:"h2"}}),g=new b({props:{code:"ZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEFmcm9tJTIwc2VudGVuY2VfdHJhbnNmb3JtZXJzLm1vZGVscyUyMGltcG9ydCUyMFN0YXRpY0VtYmVkZGluZyUwQSUwQXN0YXRpY19lbWJlZGRpbmclMjAlM0QlMjBTdGF0aWNFbWJlZGRpbmcuZnJvbV9tb2RlbDJ2ZWMoJTIybWluaXNobGFiJTJGcG90aW9uLWJhc2UtOE0lMjIpJTBBbW9kZWwlMjAlM0QlMjBTZW50ZW5jZVRyYW5zZm9ybWVyKG1vZHVsZXMlM0QlNUJzdGF0aWNfZW1iZWRkaW5nJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer
<span class="hljs-keyword">from</span> sentence_transformers.models <span class="hljs-keyword">import</span> StaticEmbedding

static_embedding = StaticEmbedding.from_model2vec(<span class="hljs-string">&quot;minishlab/potion-base-8M&quot;</span>)
model = SentenceTransformer(modules=[static_embedding])`,wrap:!1}}),W=new b({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyYWktYmx1ZXByaW50JTJGZmluZXdlYi1iYmMtbmV3cyUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;ai-blueprint/fineweb-bbc-news&quot;</span>)`,wrap:!1}}),B=new b({props:{code:"ZGVmJTIwY3JlYXRlX2VtYmVkZGluZ3MoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwZW1iZWRkaW5ncyUyMCUzRCUyMG1vZGVsLmVuY29kZShiYXRjaCU1QiUyMnRleHQlMjIlNUQlMkMlMjBjb252ZXJ0X3RvX251bXB5JTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmVtYmVkZGluZ3MlMjIlNUQlMjAlM0QlMjBlbWJlZGRpbmdzLnRvbGlzdCgpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2glMEElMEElMEFkcyUyMCUzRCUyMGRzLm1hcChjcmVhdGVfZW1iZWRkaW5ncyUyQyUyMGJhdGNoZWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_embeddings</span>(<span class="hljs-params">batch</span>):
    embeddings = model.encode(batch[<span class="hljs-string">&quot;text&quot;</span>], convert_to_numpy=<span class="hljs-literal">True</span>)
    batch[<span class="hljs-string">&quot;embeddings&quot;</span>] = embeddings.tolist()
    <span class="hljs-keyword">return</span> batch


ds = ds.<span class="hljs-built_in">map</span>(create_embeddings, batched=<span class="hljs-literal">True</span>)`,wrap:!1}}),k=new b({props:{code:"ZHMucHVzaF90b19odWIoJTIyYWktYmx1ZXByaW50JTJGZmluZXdlYi1iYmMtbmV3cy1lbWJlZGRpbmdzJTIyKQ==",highlighted:'ds.push_to_hub(<span class="hljs-string">&quot;ai-blueprint/fineweb-bbc-news-embeddings&quot;</span>)',wrap:!1}}),C=new u({props:{title:"Vector Search the Hugging Face Hub",local:"vector-search-the-hugging-face-hub",headingTag:"h2"}}),E=new u({props:{title:"Without an index",local:"without-an-index",headingTag:"h3"}}),G=new b({props:{code:"aW1wb3J0JTIwZHVja2RiJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpc3QlMEElMEElMEFkZWYlMjBzaW1pbGFyaXR5X3NlYXJjaF93aXRob3V0X2R1Y2tkYl9pbmRleCglMEElMjAlMjAlMjAlMjBxdWVyeSUzQSUyMHN0ciUyQyUwQSUyMCUyMCUyMCUyMGslM0ElMjBpbnQlMjAlM0QlMjA1JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF9uYW1lJTNBJTIwc3RyJTIwJTNEJTIwJTIyYWktYmx1ZXByaW50JTJGZmluZXdlYi1iYmMtbmV3cy1lbWJlZGRpbmdzJTIyJTJDJTBBJTIwJTIwJTIwJTIwZW1iZWRkaW5nX2NvbHVtbiUzQSUyMHN0ciUyMCUzRCUyMCUyMmVtYmVkZGluZ3MlMjIlMkMlMEEpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXNlJTIwc2FtZSUyMG1vZGVsJTIwYXMlMjB1c2VkJTIwZm9yJTIwaW5kZXhpbmclMEElMjAlMjAlMjAlMjBxdWVyeV92ZWN0b3IlMjAlM0QlMjBtb2RlbC5lbmNvZGUocXVlcnkpJTBBJTIwJTIwJTIwJTIwZW1iZWRkaW5nX2RpbSUyMCUzRCUyMG1vZGVsLmdldF9zZW50ZW5jZV9lbWJlZGRpbmdfZGltZW5zaW9uKCklMEElMEElMjAlMjAlMjAlMjBzcWwlMjAlM0QlMjBmJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwU0VMRUNUJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFycmF5X2Nvc2luZV9kaXN0YW5jZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0JlbWJlZGRpbmdfY29sdW1uJTdEJTNBJTNBZmxvYXQlNUIlN0JlbWJlZGRpbmdfZGltJTdEJTVEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCcXVlcnlfdmVjdG9yLnRvbGlzdCgpJTdEJTNBJTNBZmxvYXQlNUIlN0JlbWJlZGRpbmdfZGltJTdEJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyMGFzJTIwZGlzdGFuY2UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBGUk9NJTIwJ2hmJTNBJTJGJTJGZGF0YXNldHMlMkYlN0JkYXRhc2V0X25hbWUlN0QlMkYqKiUyRioucGFycXVldCclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBPUkRFUiUyMEJZJTIwZGlzdGFuY2UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBMSU1JVCUyMCU3QmslN0QlMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBkdWNrZGIuc3FsKHNxbCkudG9fZGYoKSUwQSUwQSUwQXNpbWlsYXJpdHlfc2VhcmNoX3dpdGhvdXRfZHVja2RiX2luZGV4KCUyMldoYXQlMjBpcyUyMHRoZSUyMGZ1dHVyZSUyMG9mJTIwQUklM0YlMjIp",highlighted:`<span class="hljs-keyword">import</span> duckdb
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">similarity_search_without_duckdb_index</span>(<span class="hljs-params">
    query: <span class="hljs-built_in">str</span>,
    k: <span class="hljs-built_in">int</span> = <span class="hljs-number">5</span>,
    dataset_name: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;ai-blueprint/fineweb-bbc-news-embeddings&quot;</span>,
    embedding_column: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;embeddings&quot;</span>,
</span>):
    <span class="hljs-comment"># Use same model as used for indexing</span>
    query_vector = model.encode(query)
    embedding_dim = model.get_sentence_embedding_dimension()

    sql = <span class="hljs-string">f&quot;&quot;&quot;
        SELECT 
            *,
            array_cosine_distance(
                <span class="hljs-subst">{embedding_column}</span>::float[<span class="hljs-subst">{embedding_dim}</span>], 
                <span class="hljs-subst">{query_vector.tolist()}</span>::float[<span class="hljs-subst">{embedding_dim}</span>]
            ) as distance
        FROM &#x27;hf://datasets/<span class="hljs-subst">{dataset_name}</span>/**/*.parquet&#x27;
        ORDER BY distance
        LIMIT <span class="hljs-subst">{k}</span>
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> duckdb.sql(sql).to_df()


similarity_search_without_duckdb_index(<span class="hljs-string">&quot;What is the future of AI?&quot;</span>)`,wrap:!1}}),R=new u({props:{title:"With an index",local:"with-an-index",headingTag:"h3"}}),Y=new b({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> duckdb


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_setup_vss</span>():
    duckdb.sql(
        query=<span class="hljs-string">&quot;&quot;&quot;
        INSTALL vss;
        LOAD vss;
        &quot;&quot;&quot;</span>
    )


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_drop_table</span>(<span class="hljs-params">table_name</span>):
    duckdb.sql(
        query=<span class="hljs-string">f&quot;&quot;&quot;
        DROP TABLE IF EXISTS <span class="hljs-subst">{table_name}</span>;
        &quot;&quot;&quot;</span>
    )


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_create_table</span>(<span class="hljs-params">dataset_name, table_name, embedding_column</span>):
    duckdb.sql(
        query=<span class="hljs-string">f&quot;&quot;&quot;
        CREATE TABLE <span class="hljs-subst">{table_name}</span> AS 
        SELECT *, <span class="hljs-subst">{embedding_column}</span>::float[<span class="hljs-subst">{model.get_sentence_embedding_dimension()}</span>] as <span class="hljs-subst">{embedding_column}</span>_float 
        FROM &#x27;hf://datasets/<span class="hljs-subst">{dataset_name}</span>/**/*.parquet&#x27;;
        &quot;&quot;&quot;</span>
    )


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_create_index</span>(<span class="hljs-params">table_name, embedding_column</span>):
    duckdb.sql(
        query=<span class="hljs-string">f&quot;&quot;&quot;
        CREATE INDEX my_hnsw_index ON <span class="hljs-subst">{table_name}</span> USING HNSW (<span class="hljs-subst">{embedding_column}</span>_float) WITH (metric = &#x27;cosine&#x27;);
        &quot;&quot;&quot;</span>
    )


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_index</span>(<span class="hljs-params">dataset_name, table_name, embedding_column</span>):
    _setup_vss()
    _drop_table(table_name)
    _create_table(dataset_name, table_name, embedding_column)
    _create_index(table_name, embedding_column)


create_index(
    dataset_name=<span class="hljs-string">&quot;ai-blueprint/fineweb-bbc-news-embeddings&quot;</span>,
    table_name=<span class="hljs-string">&quot;fineweb_bbc_news_embeddings&quot;</span>,
    embedding_column=<span class="hljs-string">&quot;embeddings&quot;</span>,
)`,wrap:!1}}),x=new b({props:{code:"ZGVmJTIwc2ltaWxhcml0eV9zZWFyY2hfd2l0aF9kdWNrZGJfaW5kZXgoJTBBJTIwJTIwJTIwJTIwcXVlcnklM0ElMjBzdHIlMkMlMjBrJTNBJTIwaW50JTIwJTNEJTIwNSUyQyUyMHRhYmxlX25hbWUlM0ElMjBzdHIlMjAlM0QlMjAlMjJmaW5ld2ViX2JiY19uZXdzX2VtYmVkZGluZ3MlMjIlMkMlMjBlbWJlZGRpbmdfY29sdW1uJTNBJTIwc3RyJTIwJTNEJTIwJTIyZW1iZWRkaW5ncyUyMiUwQSklM0ElMEElMjAlMjAlMjAlMjBlbWJlZGRpbmclMjAlM0QlMjBtb2RlbC5lbmNvZGUocXVlcnkpLnRvbGlzdCgpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZHVja2RiLnNxbCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWVyeSUzRGYlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTRUxFQ1QlMjAqJTJDJTIwYXJyYXlfY29zaW5lX2Rpc3RhbmNlKCU3QmVtYmVkZGluZ19jb2x1bW4lN0RfZmxvYXQlMkMlMjAlN0JlbWJlZGRpbmclN0QlM0ElM0FGTE9BVCU1QiU3Qm1vZGVsLmdldF9zZW50ZW5jZV9lbWJlZGRpbmdfZGltZW5zaW9uKCklN0QlNUQpJTIwYXMlMjBkaXN0YW5jZSUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZST00lMjAlN0J0YWJsZV9uYW1lJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwT1JERVIlMjBCWSUyMGRpc3RhbmNlJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwTElNSVQlMjAlN0JrJTdEJTNCJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwKS50b19kZigpJTBBJTBBJTBBc2ltaWxhcml0eV9zZWFyY2hfd2l0aF9kdWNrZGJfaW5kZXgoJTIyV2hhdCUyMGlzJTIwdGhlJTIwZnV0dXJlJTIwb2YlMjBBSSUzRiUyMik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">similarity_search_with_duckdb_index</span>(<span class="hljs-params">
    query: <span class="hljs-built_in">str</span>, k: <span class="hljs-built_in">int</span> = <span class="hljs-number">5</span>, table_name: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;fineweb_bbc_news_embeddings&quot;</span>, embedding_column: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;embeddings&quot;</span>
</span>):
    embedding = model.encode(query).tolist()
    <span class="hljs-keyword">return</span> duckdb.sql(
        query=<span class="hljs-string">f&quot;&quot;&quot;
        SELECT *, array_cosine_distance(<span class="hljs-subst">{embedding_column}</span>_float, <span class="hljs-subst">{embedding}</span>::FLOAT[<span class="hljs-subst">{model.get_sentence_embedding_dimension()}</span>]) as distance 
        FROM <span class="hljs-subst">{table_name}</span>
        ORDER BY distance 
        LIMIT <span class="hljs-subst">{k}</span>;
    &quot;&quot;&quot;</span>
    ).to_df()


similarity_search_with_duckdb_index(<span class="hljs-string">&quot;What is the future of AI?&quot;</span>)`,wrap:!1}}),v=new u({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),S=new u({props:{title:"Learn more",local:"learn-more",headingTag:"h2"}}),H=new Pe({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/vector_search_with_hub_as_backend.md"}}),{c(){w=c("meta"),D=a(),z=c("p"),K=a(),i(r.$$.fragment),P=a(),i(j.$$.fragment),O=a(),h=c("p"),h.innerHTML=_e,ee=a(),i(y.$$.fragment),le=a(),i(I.$$.fragment),se=a(),i(f.$$.fragment),te=a(),U=c("p"),U.innerHTML=ke,ae=a(),i(g.$$.fragment),ne=a(),Z=c("p"),Z.innerHTML=Ce,ie=a(),i(W.$$.fragment),Me=a(),A=c("p"),A.textContent=$e,de=a(),i(B.$$.fragment),Je=a(),_=c("p"),_.textContent=Ee,oe=a(),i(k.$$.fragment),pe=a(),i(C.$$.fragment),ce=a(),$=c("p"),$.innerHTML=Ve,me=a(),i(E.$$.fragment),Te=a(),V=c("p"),V.innerHTML=Ge,we=a(),i(G.$$.fragment),be=a(),i(R.$$.fragment),ue=a(),N=c("p"),N.textContent=Re,re=a(),i(Y.$$.fragment),je=a(),X=c("p"),X.textContent=Ne,he=a(),i(x.$$.fragment),ye=a(),q=c("p"),q.textContent=Ye,Ie=a(),i(v.$$.fragment),fe=a(),F=c("p"),F.innerHTML=Xe,Ue=a(),i(S.$$.fragment),ge=a(),Q=c("ul"),Q.innerHTML=xe,Ze=a(),i(H.$$.fragment),We=a(),L=c("p"),this.h()},l(e){const l=Le("svelte-u9bgzb",document.head);w=m(l,"META",{name:!0,content:!0}),l.forEach(s),D=n(e),z=m(e,"P",{}),qe(z).forEach(s),K=n(e),M(r.$$.fragment,e),P=n(e),M(j.$$.fragment,e),O=n(e),h=m(e,"P",{"data-svelte-h":!0}),T(h)!=="svelte-1t5w2hp"&&(h.innerHTML=_e),ee=n(e),M(y.$$.fragment,e),le=n(e),M(I.$$.fragment,e),se=n(e),M(f.$$.fragment,e),te=n(e),U=m(e,"P",{"data-svelte-h":!0}),T(U)!=="svelte-slwj9z"&&(U.innerHTML=ke),ae=n(e),M(g.$$.fragment,e),ne=n(e),Z=m(e,"P",{"data-svelte-h":!0}),T(Z)!=="svelte-qzt0uj"&&(Z.innerHTML=Ce),ie=n(e),M(W.$$.fragment,e),Me=n(e),A=m(e,"P",{"data-svelte-h":!0}),T(A)!=="svelte-1633f25"&&(A.textContent=$e),de=n(e),M(B.$$.fragment,e),Je=n(e),_=m(e,"P",{"data-svelte-h":!0}),T(_)!=="svelte-gc9dd9"&&(_.textContent=Ee),oe=n(e),M(k.$$.fragment,e),pe=n(e),M(C.$$.fragment,e),ce=n(e),$=m(e,"P",{"data-svelte-h":!0}),T($)!=="svelte-pmvn8c"&&($.innerHTML=Ve),me=n(e),M(E.$$.fragment,e),Te=n(e),V=m(e,"P",{"data-svelte-h":!0}),T(V)!=="svelte-10x7dzt"&&(V.innerHTML=Ge),we=n(e),M(G.$$.fragment,e),be=n(e),M(R.$$.fragment,e),ue=n(e),N=m(e,"P",{"data-svelte-h":!0}),T(N)!=="svelte-e2ywn4"&&(N.textContent=Re),re=n(e),M(Y.$$.fragment,e),je=n(e),X=m(e,"P",{"data-svelte-h":!0}),T(X)!=="svelte-nopqs8"&&(X.textContent=Ne),he=n(e),M(x.$$.fragment,e),ye=n(e),q=m(e,"P",{"data-svelte-h":!0}),T(q)!=="svelte-x1ox1z"&&(q.textContent=Ye),Ie=n(e),M(v.$$.fragment,e),fe=n(e),F=m(e,"P",{"data-svelte-h":!0}),T(F)!=="svelte-1y1h50d"&&(F.innerHTML=Xe),Ue=n(e),M(S.$$.fragment,e),ge=n(e),Q=m(e,"UL",{"data-svelte-h":!0}),T(Q)!=="svelte-1aqcu0g"&&(Q.innerHTML=xe),Ze=n(e),M(H.$$.fragment,e),We=n(e),L=m(e,"P",{}),qe(L).forEach(s),this.h()},h(){ve(w,"name","hf:doc:metadata"),ve(w,"content",el)},m(e,l){De(document.head,w),t(e,D,l),t(e,z,l),t(e,K,l),d(r,e,l),t(e,P,l),d(j,e,l),t(e,O,l),t(e,h,l),t(e,ee,l),d(y,e,l),t(e,le,l),d(I,e,l),t(e,se,l),d(f,e,l),t(e,te,l),t(e,U,l),t(e,ae,l),d(g,e,l),t(e,ne,l),t(e,Z,l),t(e,ie,l),d(W,e,l),t(e,Me,l),t(e,A,l),t(e,de,l),d(B,e,l),t(e,Je,l),t(e,_,l),t(e,oe,l),d(k,e,l),t(e,pe,l),d(C,e,l),t(e,ce,l),t(e,$,l),t(e,me,l),d(E,e,l),t(e,Te,l),t(e,V,l),t(e,we,l),d(G,e,l),t(e,be,l),d(R,e,l),t(e,ue,l),t(e,N,l),t(e,re,l),d(Y,e,l),t(e,je,l),t(e,X,l),t(e,he,l),d(x,e,l),t(e,ye,l),t(e,q,l),t(e,Ie,l),d(v,e,l),t(e,fe,l),t(e,F,l),t(e,Ue,l),d(S,e,l),t(e,ge,l),t(e,Q,l),t(e,Ze,l),d(H,e,l),t(e,We,l),t(e,L,l),Ae=!0},p:Se,i(e){Ae||(J(r.$$.fragment,e),J(j.$$.fragment,e),J(y.$$.fragment,e),J(I.$$.fragment,e),J(f.$$.fragment,e),J(g.$$.fragment,e),J(W.$$.fragment,e),J(B.$$.fragment,e),J(k.$$.fragment,e),J(C.$$.fragment,e),J(E.$$.fragment,e),J(G.$$.fragment,e),J(R.$$.fragment,e),J(Y.$$.fragment,e),J(x.$$.fragment,e),J(v.$$.fragment,e),J(S.$$.fragment,e),J(H.$$.fragment,e),Ae=!0)},o(e){o(r.$$.fragment,e),o(j.$$.fragment,e),o(y.$$.fragment,e),o(I.$$.fragment,e),o(f.$$.fragment,e),o(g.$$.fragment,e),o(W.$$.fragment,e),o(B.$$.fragment,e),o(k.$$.fragment,e),o(C.$$.fragment,e),o(E.$$.fragment,e),o(G.$$.fragment,e),o(R.$$.fragment,e),o(Y.$$.fragment,e),o(x.$$.fragment,e),o(v.$$.fragment,e),o(S.$$.fragment,e),o(H.$$.fragment,e),Ae=!1},d(e){e&&(s(D),s(z),s(K),s(P),s(O),s(h),s(ee),s(le),s(se),s(te),s(U),s(ae),s(ne),s(Z),s(ie),s(Me),s(A),s(de),s(Je),s(_),s(oe),s(pe),s(ce),s($),s(me),s(Te),s(V),s(we),s(be),s(ue),s(N),s(re),s(je),s(X),s(he),s(ye),s(q),s(Ie),s(fe),s(F),s(Ue),s(ge),s(Q),s(Ze),s(We),s(L)),s(w),p(r,e),p(j,e),p(y,e),p(I,e),p(f,e),p(g,e),p(W,e),p(B,e),p(k,e),p(C,e),p(E,e),p(G,e),p(R,e),p(Y,e),p(x,e),p(v,e),p(S,e),p(H,e)}}}const el='{"title":"Vector Search on Hugging Face with the Hub as Backend","local":"vector-search-on-hugging-face-with-the-hub-as-backend","sections":[{"title":"Install dependencies","local":"install-dependencies","sections":[],"depth":2},{"title":"Create embeddings for the dataset","local":"create-embeddings-for-the-dataset","sections":[],"depth":2},{"title":"Vector Search the Hugging Face Hub","local":"vector-search-the-hugging-face-hub","sections":[{"title":"Without an index","local":"without-an-index","sections":[],"depth":3},{"title":"With an index","local":"with-an-index","sections":[],"depth":3}],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2},{"title":"Learn more","local":"learn-more","sections":[],"depth":2}],"depth":1}';function ll(Be){return Qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class il extends He{constructor(w){super(),ze(this,w,ll,Oe,Fe,{})}}export{il as component};
